# mypy-boto3-machinelearning

[![PyPI - mypy-boto3-machinelearning](https://img.shields.io/pypi/v/mypy-boto3-machinelearning.svg?color=blue)](https://pypi.org/project/mypy-boto3-machinelearning)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-machinelearning.svg?color=blue)](https://pypi.org/project/mypy-boto3-machinelearning)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

- [mypy-boto3-machinelearning](#mypy-boto3-machinelearning)
  - [How to use](#how-to-use)
  - [Automated type discovery](#automated-type-discovery)


Type annotations for
[boto3.MachineLearning 1.13.26](https://boto3.amazonaws.com/v1/documentation/api/1.13.26/reference/services/machinelearning.html#MachineLearning) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.0.3](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-machinelearning](#mypy-boto3-machinelearning)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `MachineLearning` service.

```bash
python -m pip install boto3-stubs[machinelearning]

# update installed packages index for automated type discovery
python -m mypy_boto3
```

Use `boto3` with `mypy_boto3_machinelearning` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3_machinelearning import MachineLearningClient

# Now mypy can check if your code is valid.
client: MachineLearningClient = boto3.client("machinelearning")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: MachineLearningClient = session.client("machinelearning")



# Waiters are also supported

import mypy_boto3_machinelearning.waiter as machinelearning_waiters

batch_prediction_available_waiter: machinelearning_waiters.BatchPredictionAvailableWaiter = client.get_waiter("batch_prediction_available")
data_source_available_waiter: machinelearning_waiters.DataSourceAvailableWaiter = client.get_waiter("data_source_available")
evaluation_available_waiter: machinelearning_waiters.EvaluationAvailableWaiter = client.get_waiter("evaluation_available")
ml_model_available_waiter: machinelearning_waiters.MLModelAvailableWaiter = client.get_waiter("ml_model_available")


# Annotated paginators are included as well

import mypy_boto3_machinelearning.paginator as machinelearning_paginators

describe_batch_predictions_paginator: machinelearning_paginators.DescribeBatchPredictionsPaginator = client.get_paginator("describe_batch_predictions")
describe_data_sources_paginator: machinelearning_paginators.DescribeDataSourcesPaginator = client.get_paginator("describe_data_sources")
describe_evaluations_paginator: machinelearning_paginators.DescribeEvaluationsPaginator = client.get_paginator("describe_evaluations")
describe_ml_models_paginator: machinelearning_paginators.DescribeMLModelsPaginator = client.get_paginator("describe_ml_models")
```

## Automated type discovery

`mypy_boto3` package can generate index for `mypy_boto3_machinelearning` and other installed services.

```bash
# Run this command when you add or remove service packages
python -m mypy_boto3
```

Generated index provides overloads for `boto3.client` and `boto3.service`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully
- `VSCode` does not currently support function overloads

Also, generated index allows you to import types from `mypy_boto3`:

```python
# you can replace imports
import mypy_boto3_machinelearning as machinelearning
from mypy_boto3_machinelearning import MachineLearningClient

# with these
from mypy_boto3 import machinelearning
from mypy_boto3.machinelearning import MachineLearningClient
```