# Generated by Django 4.0.2 on 2022-03-02 22:40

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="OidcSession",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("modified", models.DateTimeField(auto_now=True)),
                ("user_uid", models.CharField(max_length=120)),
                ("client_id", models.URLField(blank=True, null=True)),
                ("nonce", models.CharField(max_length=2048)),
                ("authz_request", models.JSONField(max_length=2048)),
                ("sub", models.CharField(blank=True, max_length=254, null=True)),
                ("user_claims", models.JSONField(blank=True, default=dict)),
                ("revoked", models.BooleanField(default=False)),
                ("auth_code", models.CharField(max_length=2048)),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "User Session",
                "verbose_name_plural": "User Sessions",
                "unique_together": {("client_id", "nonce")},
            },
        ),
        migrations.CreateModel(
            name="IssuedToken",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("modified", models.DateTimeField(auto_now=True)),
                ("access_token", models.TextField(blank=True, null=True)),
                ("id_token", models.TextField(blank=True, null=True)),
                ("refresh_token", models.TextField(blank=True, null=True)),
                (
                    "session",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="spid_cie_oidc_provider.oidcsession",
                    ),
                ),
            ],
            options={
                "verbose_name": "Issued Token",
                "verbose_name_plural": "Issued Tokens",
            },
        ),
    ]
