# coding: utf-8

from __future__ import annotations

import re  # noqa: F401
from datetime import datetime  # noqa: F401
from typing import List, Optional  # noqa: F401

from fastapi_camelcase import CamelModel
from pydantic import AnyUrl, Field  # noqa: F401

from telus_bulk.models.tmf_645.check_service_qualification_item import (
    CheckServiceQualificationItem,
)
from telus_bulk.models.tmf_645.related_party import RelatedParty


class CheckServiceQualificationCreate(CamelModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    CheckServiceQualificationCreate - a model defined in OpenAPI

        description: The description of this CheckServiceQualificationCreate [Optional].
        expected_qualification_date: The expected_qualification_date of this CheckServiceQualificationCreate [Optional].
        external_id: The external_id of this CheckServiceQualificationCreate [Optional].
        instant_sync_qualification: The instant_sync_qualification of this CheckServiceQualificationCreate [Optional].
        provide_alternative: The provide_alternative of this CheckServiceQualificationCreate [Optional].
        provide_unavailability_reason: The provide_unavailability_reason of this CheckServiceQualificationCreate [Optional].
        related_party: The related_party of this CheckServiceQualificationCreate [Optional].
        service_qualification_item: The service_qualification_item of this CheckServiceQualificationCreate.
        base_type: The base_type of this CheckServiceQualificationCreate [Optional].
        schema_location: The schema_location of this CheckServiceQualificationCreate [Optional].
        type: The type of this CheckServiceQualificationCreate [Optional].
    """

    description: Optional[str] = None
    expected_qualification_date: Optional[datetime] = None
    external_id: Optional[str] = None
    instant_sync_qualification: Optional[bool] = None
    provide_alternative: Optional[bool] = None
    provide_unavailability_reason: Optional[bool] = None
    related_party: Optional[List[RelatedParty]] = [
        RelatedParty(
            id="SFDC",
            name="SFDC",
            role="Requestor",
            type="RelatedParty",
            referred_type="Organization",
        )
    ]
    service_qualification_item: List[CheckServiceQualificationItem]
    base_type: Optional[str] = None
    schema_location: Optional[AnyUrl] = None
    type: Optional[str] = Field(default=None, alias="@type")


CheckServiceQualificationCreate.update_forward_refs()
