# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['retrocookie',
 'retrocookie.pr',
 'retrocookie.pr.adapters',
 'retrocookie.pr.base',
 'retrocookie.pr.compat',
 'retrocookie.pr.protocols']

package_data = \
{'': ['*']}

install_requires = \
['click>=7.0,<8.0', 'git-filter-repo>=2.26.0,<3.0.0', 'pygit2>=1.2.1,<2.0.0']

extras_require = \
{'pr': ['typing-extensions>=3.7.4,<4.0.0',
        'github3.py>=1.3.0,<2.0.0',
        'tenacity>=6.3.1,<7.0.0',
        'appdirs>=1.4.4,<2.0.0',
        'rich>=9.5.1,<10.0.0']}

entry_points = \
{'console_scripts': ['retrocookie = retrocookie.__main__:main',
                     'retrocookie-pr = retrocookie.pr.__main__:main']}

setup_kwargs = {
    'name': 'retrocookie',
    'version': '0.4.0',
    'description': 'Update Cookiecutter templates with changes from their instances',
    'long_description': 'Retrocookie\n===========\n\n|PyPI| |Python Version| |License|\n\n|Read the Docs| |Tests| |Codecov|\n\n|pre-commit| |Black|\n\n.. |PyPI| image:: https://img.shields.io/pypi/v/retrocookie.svg\n   :target: https://pypi.org/project/retrocookie/\n   :alt: PyPI\n.. |Python Version| image:: https://img.shields.io/pypi/pyversions/retrocookie\n   :target: https://pypi.org/project/retrocookie\n   :alt: Python Version\n.. |License| image:: https://img.shields.io/pypi/l/retrocookie\n   :target: https://opensource.org/licenses/MIT\n   :alt: License\n.. |Read the Docs| image:: https://img.shields.io/readthedocs/retrocookie/latest.svg?label=Read%20the%20Docs\n   :target: https://retrocookie.readthedocs.io/\n   :alt: Read the documentation at https://retrocookie.readthedocs.io/\n.. |Tests| image:: https://github.com/cjolowicz/retrocookie/workflows/Tests/badge.svg\n   :target: https://github.com/cjolowicz/retrocookie/actions?workflow=Tests\n   :alt: Tests\n.. |Codecov| image:: https://codecov.io/gh/cjolowicz/retrocookie/branch/master/graph/badge.svg\n   :target: https://codecov.io/gh/cjolowicz/retrocookie\n   :alt: Codecov\n.. |pre-commit| image:: https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white\n   :target: https://github.com/pre-commit/pre-commit\n   :alt: pre-commit\n.. |Black| image:: https://img.shields.io/badge/code%20style-black-000000.svg\n   :target: https://github.com/psf/black\n   :alt: Black\n\n\nRetrocookie updates Cookiecutter_ templates with changes from generated projects.\n\nWhen developing Cookiecutter templates,\nyou often need to work in a generated project rather than the template itself.\nReasons for this include the following:\n\n- You need to run the Continuous Integration suite for the generated project\n- Your development tools choke when running on the templated project\n\nAny changes you make in the generated project\nneed to be backported into the template,\ncarefully replacing expanded variables from ``cookiecutter.json`` by templating tags,\nand escaping any use of ``{{`` and ``}}``\nor other tokens with special meaning in Jinja.\n\nRetrocookie helps you in this situation.\n\nIt is designed to fetch commits from the repository of a generated project,\nand import them into your Cookiecutter repository,\nrewriting them on the fly to insert templating tags,\nescape Jinja-special constructs,\nand place files in the template directory.\n\nUnder the hood,\nRetrocookie rewrites the selected commits using git-filter-repo_,\nsaving them to a temporary repository.\nIt then fetches and cherry-picks the rewritten commits\nfrom the temporary repository into the Cookiecutter template,\nusing pygit2_.\n\nMaybe you\'re thinking,\nhow can this possibly work?\nOne cannot reconstruct a Jinja template from its rendered output.\nHowever, simple replacements of template variables work well in practice\nwhen you\'re only importing a handful of commits at a time.\n\n**Important:**\n\nRetrocookie relies on a ``.cookiecutter.json`` file in the generated project\nto work out how to rewrite commits.\nThis file is similar to the ``cookiecutter.json`` file in the template,\nbut contains the specific values chosen during project generation.\nYou can generate this file by putting it into the template directory in the Cookiecutter,\nwith the following contents:\n\n.. code:: jinja\n\n   {{ cookiecutter | jsonify }}\n\n\nRequirements\n------------\n\n* Python 3.7+\n* git >= 2.22.0\n\n\nInstallation\n------------\n\nYou can install *Retrocookie* via pip_ from PyPI_:\n\n.. code:: console\n\n   $ pip install retrocookie\n\nOptionally, install the ``pr`` extra for the retrocookie-pr_ command:\n\n.. code:: console\n\n   $ pip install retrocookie[pr]\n\n\nExample\n-------\n\nHere\'s an example to demonstrate the general workflow.\n\nTo start with, we clone the repository of your Cookiecutter template.\nFor this example, I\'ll use my own `Hypermodern Python Cookiecutter`_.\n\n.. code:: console\n\n   $ git clone https://github.com/cjolowicz/cookiecutter-hypermodern-python\n\nNext, we\'ll create a project from the template,\nand set up a git repository for it:\n\n.. code:: console\n\n   $ cookiecutter --no-input cookiecutter-hypermodern-python\n   $ cd hypermodern-python\n   $ git init\n   $ git add .\n   $ git commit --message="Initial commit"\n\nLet\'s open a feature branch in the project repository,\nand make a fictitious change involving the default project name *hypermodern-python*:\n\n.. code:: console\n\n   $ git switch --create add-example\n   $ echo \'# hypermodern-python\' > EXAMPLE.md\n   $ git add EXAMPLE.md\n   $ git commit --message="Add example"\n\nBack in the Cookiecutter repository,\nwe can now invoke retrocookie to import the changes from the feature branch:\n\n.. code:: console\n\n   $ cd ../cookiecutter-hypermodern-python\n   $ retrocookie --branch add-example --create ../hypermodern-python\n\nA ``git show`` in the Cookiecutter shows the file under the template directory,\non a branch named as in the original repository,\nwith the project name replaced by a Jinja tag:\n\n.. code:: diff\n\n   commit abb4f823b9f1760e3a678c927ec9797c0a40a9b6 (HEAD -> add-example)\n   Author: Your Name <your.name@example.com>\n   Date:   Fri Dec 4 23:40:41 2020 +0100\n\n       Add example\n\n   diff --git a/{{cookiecutter.project_name}}/EXAMPLE.md b/{{cookiecutter.project_name}}/EXAMPLE.md\n   new file mode 100644\n   index 0000000..a158618\n   --- /dev/null\n   +++ b/{{cookiecutter.project_name}}/EXAMPLE.md\n   @@ -0,0 +1 @@\n   +# {{cookiecutter.project_name}}\n\n\nUsage\n-----\n\nThe basic form:\n\n.. code::\n\n   $ retrocookie <repository> [<commits>...]\n   $ retrocookie <repository> -b <branch> [--create]\n\nThe ``<repository>`` is a filesystem path to the source repository.\nFor ``<commits>``, see `gitrevisions(7)`__.\n\n__ https://git-scm.com/docs/gitrevisions\n\nImport ``HEAD`` from ``<repository>``:\n\n.. code::\n\n   $ retrocookie <repository>\n\nImport the last two commits:\n\n.. code::\n\n   $ retrocookie <repository> HEAD~2..\n\nImport by commit hash:\n\n.. code::\n\n   $ retrocookie <repository> 53268f7 6a3368a c0b4c6c\n\nImport commits from branch ``topic``:\n\n.. code::\n\n   $ retrocookie <repository> --branch=topic\n\nEquivalently:\n\n.. code::\n\n   $ retrocookie <repository> master..topic\n\nImport commits from ``topic`` into a branch with the same name:\n\n.. code::\n\n   $ retrocookie <repository> --branch=topic --create\n\nEquivalently, using short options:\n\n.. code::\n\n   $ retrocookie <repository> -cb topic\n\nImport commits from branch ``topic``, which was branched off ``1.0``:\n\n.. code::\n\n   $ retrocookie <repository> --branch=topic --upstream=1.0\n\nEquivalently:\n\n.. code::\n\n   $ retrocookie <repository> 1.0..topic\n\nImport ``HEAD`` into a new branch ``topic``:\n\n.. code::\n\n   $ retrocookie <repository> --create-branch=topic\n\nPlease see the `Command-line Reference <Usage_>`_ for further details.\n\n\n.. _retrocookie-pr:\n\nImporting pull requests from generated projects with retrocookie-pr\n-------------------------------------------------------------------\n\nYou can import pull requests from a generated project to the project template,\nassuming their repositories are on GitHub_.\nThis requires activating the ``pr`` extra when installing with pip_:\n\n.. code::\n\n  $ pip install retrocookie[pr]\n\nThe command ``retrocookie-pr`` has the basic form:\n\n.. code::\n\n   $ retrocookie-pr [-R <repository>] [<pr>...]\n   $ retrocookie-pr [-R <repository>] --user=<user>\n   $ retrocookie-pr [-R <repository>] --all\n\nCommand-line arguments specify pull requests to import, by number or by branch.\nPull requests from forks are currently not supported.\n\nUse the ``-R <repository>`` option to specify the GitHub repository of the generated project\nfrom which the pull requests should be imported.\nProvide the full name of the repository on GitHub in the form ``owner/name``.\nThe owner can be omitted if the repository is owned by the authenticated user.\nThis option can be omitted when the command is invoked from a local clone.\n\nYou can also select pull requests by specifying the user that opened them, via the ``--user`` option.\nThis is handy for importing automated pull requests, such as dependency updates from Dependabot_.\n\nUse the ``--all`` option to import all open pull requests in the generated project.\n\nYou can update previously imported pull requests by specifying ``--force``.\nBy default, ``retrocookie-pr`` refuses to overwrite existing pull requests.\n\nThe command needs a `personal access token`_ to access the GitHub API.\n(This token is also used to push to the GitHub repository of the project template.)\nYou will be prompted for the token when you invoke the command for the first time.\nOn subsequent invocations, the token is read from the application cache.\nAlternatively, you can specify the token using the ``--token`` option or the ``GITHUB_TOKEN`` environment variable;\nboth of these methods bypass the cache.\n\nUse the ``--open`` option to open each imported pull request in a web browser.\n\nPlease see the `Command-line Reference <Usage_>`_ for further details.\n\n\nContributing\n------------\n\nContributions are very welcome.\nTo learn more, see the `Contributor Guide`_.\n\n\nLicense\n-------\n\nDistributed under the terms of the MIT_ license,\n*Retrocookie* is free and open source software.\n\n\nIssues\n------\n\nIf you encounter any problems,\nplease `file an issue`_ along with a detailed description.\n\n\nCredits\n-------\n\nThis project was generated from `@cjolowicz`_\'s `Hypermodern Python Cookiecutter`_ template.\n\n\n.. _@cjolowicz: https://github.com/cjolowicz\n.. _Cookiecutter: https://github.com/audreyr/cookiecutter\n.. _Dependabot: https://dependabot.com/\n.. _GitHub: https://github.com/\n.. _Hypermodern Python Cookiecutter: https://github.com/cjolowicz/cookiecutter-hypermodern-python\n.. _MIT: http://opensource.org/licenses/MIT\n.. _PyPI: https://pypi.org/\n.. _file an issue: https://github.com/cjolowicz/retrocookie/issues\n.. _git-filter-repo: https://github.com/newren/git-filter-repo\n.. _git rebase: https://git-scm.com/docs/git-rebase\n.. _pip: https://pip.pypa.io/\n.. _personal access token: https://docs.github.com/en/free-pro-team@latest/github/authenticating-to-github/creating-a-personal-access-token\n.. _pygit2: https://github.com/libgit2/pygit2\n.. github-only\n.. _Contributor Guide: CONTRIBUTING.rst\n.. _Usage: https://retrocookie.readthedocs.io/en/latest/usage.html\n',
    'author': 'Claudio Jolowicz',
    'author_email': 'mail@claudiojolowicz.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/cjolowicz/retrocookie',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
