"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const enums_1 = require("./enums");
/**
 * An EC2 instance that is the target for load balancing
 *
 * If you register a target of this type, you are responsible for making
 * sure the load balancer's security group can connect to the instance.
 *
 * @deprecated Use IpTarget from the @aws-cdk/aws-elasticloadbalancingv2-targets package instead.
 */
class InstanceTarget {
    /**
     * Create a new Instance target
     *
     * @param instanceId Instance ID of the instance to register to
     * @param port Override the default port for the target group
     */
    constructor(instanceId, port) {
        this.instanceId = instanceId;
        this.port = port;
    }
    /**
     * Register this instance target with a load balancer
     *
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     */
    attachToApplicationTargetGroup(targetGroup) {
        return this.attach(targetGroup);
    }
    /**
     * Register this instance target with a load balancer
     *
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     */
    attachToNetworkTargetGroup(targetGroup) {
        return this.attach(targetGroup);
    }
    attach(_targetGroup) {
        return {
            targetType: enums_1.TargetType.INSTANCE,
            targetJson: { id: this.instanceId, port: this.port }
        };
    }
}
exports.InstanceTarget = InstanceTarget;
/**
 * An IP address that is a target for load balancing.
 *
 * Specify IP addresses from the subnets of the virtual private cloud (VPC) for
 * the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and
 * 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify
 * publicly routable IP addresses.
 *
 * If you register a target of this type, you are responsible for making
 * sure the load balancer's security group can send packets to the IP address.
 *
 * @deprecated Use IpTarget from the @aws-cdk/aws-elasticloadbalancingv2-targets package instead.
 */
class IpTarget {
    /**
     * Create a new IPAddress target
     *
     * The availabilityZone parameter determines whether the target receives
     * traffic from the load balancer nodes in the specified Availability Zone
     * or from all enabled Availability Zones for the load balancer.
     *
     * This parameter is not supported if the target type of the target group
     * is instance. If the IP address is in a subnet of the VPC for the target
     * group, the Availability Zone is automatically detected and this
     * parameter is optional. If the IP address is outside the VPC, this
     * parameter is required.
     *
     * With an Application Load Balancer, if the IP address is outside the VPC
     * for the target group, the only supported value is all.
     *
     * Default is automatic.
     *
     * @param ipAddress The IP Address to load balance to
     * @param port Override the group's default port
     * @param availabilityZone Availability zone to send traffic from
     */
    constructor(ipAddress, port, availabilityZone) {
        this.ipAddress = ipAddress;
        this.port = port;
        this.availabilityZone = availabilityZone;
    }
    /**
     * Register this instance target with a load balancer
     *
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     */
    attachToApplicationTargetGroup(targetGroup) {
        return this.attach(targetGroup);
    }
    /**
     * Register this instance target with a load balancer
     *
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     */
    attachToNetworkTargetGroup(targetGroup) {
        return this.attach(targetGroup);
    }
    attach(_targetGroup) {
        return {
            targetType: enums_1.TargetType.IP,
            targetJson: { id: this.ipAddress, port: this.port, availabilityZone: this.availabilityZone }
        };
    }
}
exports.IpTarget = IpTarget;
//# sourceMappingURL=data:application/json;base64,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