#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("@aws-cdk/aws-ec2");
const cdk = require("@aws-cdk/core");
const elbv2 = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-elbv2-integ');
const vpc = new ec2.Vpc(stack, 'VPC', {
    maxAzs: 2
});
const lb = new elbv2.ApplicationLoadBalancer(stack, 'LB', {
    vpc,
    internetFacing: true
});
const listener = lb.addListener('Listener', {
    port: 80,
});
const group1 = listener.addTargets('Target', {
    port: 80,
    targets: [new elbv2.IpTarget('10.0.128.4')]
});
const group2 = listener.addTargets('ConditionalTarget', {
    priority: 10,
    hostHeader: 'example.com',
    port: 80,
    targets: [new elbv2.IpTarget('10.0.128.5')]
});
group1.metricTargetResponseTime().createAlarm(stack, 'ResponseTimeHigh1', {
    threshold: 5,
    evaluationPeriods: 2,
});
group2.metricTargetResponseTime().createAlarm(stack, 'ResponseTimeHigh2', {
    threshold: 5,
    evaluationPeriods: 2,
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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