#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("@aws-cdk/aws-ec2");
const cdk = require("@aws-cdk/core");
const elbv2 = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-elbv2-integ');
const vpc = new ec2.Vpc(stack, 'VPC', {
    maxAzs: 2
});
const lb = new elbv2.NetworkLoadBalancer(stack, 'LB', {
    vpc,
    internetFacing: true
});
const listener = lb.addListener('Listener', {
    port: 443,
});
const group = listener.addTargets('Target', {
    port: 443,
    targets: [new elbv2.IpTarget('10.0.1.1')]
});
group.node.addDependency(vpc.internetConnectivityEstablished);
// The target's security group must allow being routed by the LB and the clients.
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcubmxiLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcubmxiLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUNBLHdDQUF3QztBQUN4QyxxQ0FBcUM7QUFDckMsZ0NBQWdDO0FBRWhDLE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLEdBQUcsRUFBRSxDQUFDO0FBQzFCLE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUscUJBQXFCLENBQUMsQ0FBQztBQUV4RCxNQUFNLEdBQUcsR0FBRyxJQUFJLEdBQUcsQ0FBQyxHQUFHLENBQUMsS0FBSyxFQUFFLEtBQUssRUFBRTtJQUNwQyxNQUFNLEVBQUUsQ0FBQztDQUNWLENBQUMsQ0FBQztBQUVILE1BQU0sRUFBRSxHQUFHLElBQUksS0FBSyxDQUFDLG1CQUFtQixDQUFDLEtBQUssRUFBRSxJQUFJLEVBQUU7SUFDcEQsR0FBRztJQUNILGNBQWMsRUFBRSxJQUFJO0NBQ3JCLENBQUMsQ0FBQztBQUVILE1BQU0sUUFBUSxHQUFHLEVBQUUsQ0FBQyxXQUFXLENBQUMsVUFBVSxFQUFFO0lBQzFDLElBQUksRUFBRSxHQUFHO0NBQ1YsQ0FBQyxDQUFDO0FBRUgsTUFBTSxLQUFLLEdBQUcsUUFBUSxDQUFDLFVBQVUsQ0FBQyxRQUFRLEVBQUU7SUFDMUMsSUFBSSxFQUFFLEdBQUc7SUFDVCxPQUFPLEVBQUUsQ0FBQyxJQUFJLEtBQUssQ0FBQyxRQUFRLENBQUMsVUFBVSxDQUFDLENBQUM7Q0FDMUMsQ0FBQyxDQUFDO0FBRUgsS0FBSyxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLCtCQUErQixDQUFDLENBQUM7QUFFOUQsaUZBQWlGO0FBRWpGLEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIiMhL3Vzci9iaW4vZW52IG5vZGVcbmltcG9ydCAqIGFzIGVjMiBmcm9tICdAYXdzLWNkay9hd3MtZWMyJztcbmltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCAqIGFzIGVsYnYyIGZyb20gJy4uL2xpYic7XG5cbmNvbnN0IGFwcCA9IG5ldyBjZGsuQXBwKCk7XG5jb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soYXBwLCAnYXdzLWNkay1lbGJ2Mi1pbnRlZycpO1xuXG5jb25zdCB2cGMgPSBuZXcgZWMyLlZwYyhzdGFjaywgJ1ZQQycsIHtcbiAgbWF4QXpzOiAyXG59KTtcblxuY29uc3QgbGIgPSBuZXcgZWxidjIuTmV0d29ya0xvYWRCYWxhbmNlcihzdGFjaywgJ0xCJywge1xuICB2cGMsXG4gIGludGVybmV0RmFjaW5nOiB0cnVlXG59KTtcblxuY29uc3QgbGlzdGVuZXIgPSBsYi5hZGRMaXN0ZW5lcignTGlzdGVuZXInLCB7XG4gIHBvcnQ6IDQ0Myxcbn0pO1xuXG5jb25zdCBncm91cCA9IGxpc3RlbmVyLmFkZFRhcmdldHMoJ1RhcmdldCcsIHtcbiAgcG9ydDogNDQzLFxuICB0YXJnZXRzOiBbbmV3IGVsYnYyLklwVGFyZ2V0KCcxMC4wLjEuMScpXVxufSk7XG5cbmdyb3VwLm5vZGUuYWRkRGVwZW5kZW5jeSh2cGMuaW50ZXJuZXRDb25uZWN0aXZpdHlFc3RhYmxpc2hlZCk7XG5cbi8vIFRoZSB0YXJnZXQncyBzZWN1cml0eSBncm91cCBtdXN0IGFsbG93IGJlaW5nIHJvdXRlZCBieSB0aGUgTEIgYW5kIHRoZSBjbGllbnRzLlxuXG5hcHAuc3ludGgoKTtcbiJdfQ==