"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DynamicTagGroup = exports.DynamicTagGroupProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cms_generated_1 = require("./cms.generated");
Object.defineProperty(exports, "DynamicTagGroupProperty", { enumerable: true, get: function () { return cms_generated_1.RosDynamicTagGroup; } });
/**
 * A ROS resource type:  `ALIYUN::CMS::DynamicTagGroup`
 */
class DynamicTagGroup extends ros.Resource {
    /**
     * Create a new `ALIYUN::CMS::DynamicTagGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDynamicTagGroup = new cms_generated_1.RosDynamicTagGroup(this, id, {
            contactGroupList: props.contactGroupList,
            matchExpressFilterRelation: props.matchExpressFilterRelation,
            enableSubscribeEvent: props.enableSubscribeEvent,
            templateIdList: props.templateIdList,
            tagKey: props.tagKey,
            enableInstallAgent: props.enableInstallAgent,
            matchExpress: props.matchExpress,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDynamicTagGroup;
        this.attrDynamicTagRuleId = rosDynamicTagGroup.attrDynamicTagRuleId;
        this.attrTagKey = rosDynamicTagGroup.attrTagKey;
    }
}
exports.DynamicTagGroup = DynamicTagGroup;
//# sourceMappingURL=data:application/json;base64,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