"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventRuleTargets = exports.EventRuleTargetsProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cms_generated_1 = require("./cms.generated");
Object.defineProperty(exports, "EventRuleTargetsProperty", { enumerable: true, get: function () { return cms_generated_1.RosEventRuleTargets; } });
/**
 * A ROS resource type:  `ALIYUN::CMS::EventRuleTargets`
 */
class EventRuleTargets extends ros.Resource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the properties of this ROS resource, which will be assigned to ROS resource.
     */
    /**
     * Create a new `ALIYUN::CMS::EventRuleTargets`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosEventRuleTargets = new cms_generated_1.RosEventRuleTargets(this, id, {
            contactParameters: props.contactParameters,
            slsParameters: props.slsParameters,
            webhookParameters: props.webhookParameters,
            fcParameters: props.fcParameters,
            ruleName: props.ruleName,
            mnsParameters: props.mnsParameters,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosEventRuleTargets;
    }
}
exports.EventRuleTargets = EventRuleTargets;
//# sourceMappingURL=data:application/json;base64,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