"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetricRuleTargets = exports.MetricRuleTargetsProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cms_generated_1 = require("./cms.generated");
Object.defineProperty(exports, "MetricRuleTargetsProperty", { enumerable: true, get: function () { return cms_generated_1.RosMetricRuleTargets; } });
/**
 * A ROS resource type:  `ALIYUN::CMS::MetricRuleTargets`
 */
class MetricRuleTargets extends ros.Resource {
    /**
     * Create a new `ALIYUN::CMS::MetricRuleTargets`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosMetricRuleTargets = new cms_generated_1.RosMetricRuleTargets(this, id, {
            ruleId: props.ruleId,
            targets: props.targets,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosMetricRuleTargets;
        this.attrArns = rosMetricRuleTargets.attrArns;
        this.attrIds = rosMetricRuleTargets.attrIds;
    }
}
exports.MetricRuleTargets = MetricRuleTargets;
//# sourceMappingURL=data:application/json;base64,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