"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetricRuleTemplate = exports.MetricRuleTemplateProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cms_generated_1 = require("./cms.generated");
Object.defineProperty(exports, "MetricRuleTemplateProperty", { enumerable: true, get: function () { return cms_generated_1.RosMetricRuleTemplate; } });
/**
 * A ROS resource type:  `ALIYUN::CMS::MetricRuleTemplate`
 */
class MetricRuleTemplate extends ros.Resource {
    /**
     * Create a new `ALIYUN::CMS::MetricRuleTemplate`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosMetricRuleTemplate = new cms_generated_1.RosMetricRuleTemplate(this, id, {
            alertTemplates: props.alertTemplates,
            description: props.description,
            restVersion: props.restVersion,
            templateId: props.templateId,
            name: props.name,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosMetricRuleTemplate;
        this.attrId = rosMetricRuleTemplate.attrId;
    }
}
exports.MetricRuleTemplate = MetricRuleTemplate;
//# sourceMappingURL=data:application/json;base64,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