"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MonitorGroupInstances = exports.MonitorGroupInstancesProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cms_generated_1 = require("./cms.generated");
Object.defineProperty(exports, "MonitorGroupInstancesProperty", { enumerable: true, get: function () { return cms_generated_1.RosMonitorGroupInstances; } });
/**
 * A ROS resource type:  `ALIYUN::CMS::MonitorGroupInstances`
 */
class MonitorGroupInstances extends ros.Resource {
    /**
     * Create a new `ALIYUN::CMS::MonitorGroupInstances`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosMonitorGroupInstances = new cms_generated_1.RosMonitorGroupInstances(this, id, {
            instances: props.instances,
            groupId: props.groupId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosMonitorGroupInstances;
        this.attrGroupId = rosMonitorGroupInstances.attrGroupId;
    }
}
exports.MonitorGroupInstances = MonitorGroupInstances;
//# sourceMappingURL=data:application/json;base64,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