import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface FolderOrganizationPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the Constraint the Policy is configuring, for example, serviceuser.services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#constraint FolderOrganizationPolicy#constraint}
     *
     * @stability stable
     */
    readonly constraint: string;
    /**
     * The resource name of the folder to set the policy for. Its format is folders/{folder_id}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#folder FolderOrganizationPolicy#folder}
     *
     * @stability stable
     */
    readonly folder: string;
    /**
     * Version of the Policy. Default version is 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#version FolderOrganizationPolicy#version}
     *
     * @stability stable
     */
    readonly version?: number;
    /**
     * boolean_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#boolean_policy FolderOrganizationPolicy#boolean_policy}
     *
     * @stability stable
     */
    readonly booleanPolicy?: FolderOrganizationPolicyBooleanPolicy;
    /**
     * list_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#list_policy FolderOrganizationPolicy#list_policy}
     *
     * @stability stable
     */
    readonly listPolicy?: FolderOrganizationPolicyListPolicy;
    /**
     * restore_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#restore_policy FolderOrganizationPolicy#restore_policy}
     *
     * @stability stable
     */
    readonly restorePolicy?: FolderOrganizationPolicyRestorePolicy;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#timeouts FolderOrganizationPolicy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: FolderOrganizationPolicyTimeouts;
}
/**
 * @stability stable
 */
export interface FolderOrganizationPolicyBooleanPolicy {
    /**
     * If true, then the Policy is enforced. If false, then any configuration is acceptable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#enforced FolderOrganizationPolicy#enforced}
     *
     * @stability stable
     */
    readonly enforced: boolean | cdktf.IResolvable;
}
export declare function folderOrganizationPolicyBooleanPolicyToTerraform(struct?: FolderOrganizationPolicyBooleanPolicyOutputReference | FolderOrganizationPolicyBooleanPolicy): any;
/**
 * @stability stable
 */
export declare class FolderOrganizationPolicyBooleanPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FolderOrganizationPolicyBooleanPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FolderOrganizationPolicyBooleanPolicy | undefined);
    private _enforced?;
    /**
     * @stability stable
     */
    get enforced(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enforced(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enforcedInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface FolderOrganizationPolicyListPolicyAllow {
    /**
     * The policy allows or denies all values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#all FolderOrganizationPolicy#all}
     *
     * @stability stable
     */
    readonly all?: boolean | cdktf.IResolvable;
    /**
     * The policy can define specific values that are allowed or denied.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#values FolderOrganizationPolicy#values}
     *
     * @stability stable
     */
    readonly values?: string[];
}
export declare function folderOrganizationPolicyListPolicyAllowToTerraform(struct?: FolderOrganizationPolicyListPolicyAllowOutputReference | FolderOrganizationPolicyListPolicyAllow): any;
/**
 * @stability stable
 */
export declare class FolderOrganizationPolicyListPolicyAllowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FolderOrganizationPolicyListPolicyAllow | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FolderOrganizationPolicyListPolicyAllow | undefined);
    private _all?;
    /**
     * @stability stable
     */
    get all(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set all(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAll(): void;
    /**
     * @stability stable
     */
    get allInput(): boolean | cdktf.IResolvable | undefined;
    private _values?;
    /**
     * @stability stable
     */
    get values(): string[];
    /**
     * @stability stable
     */
    set values(value: string[]);
    /**
     * @stability stable
     */
    resetValues(): void;
    /**
     * @stability stable
     */
    get valuesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface FolderOrganizationPolicyListPolicyDeny {
    /**
     * The policy allows or denies all values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#all FolderOrganizationPolicy#all}
     *
     * @stability stable
     */
    readonly all?: boolean | cdktf.IResolvable;
    /**
     * The policy can define specific values that are allowed or denied.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#values FolderOrganizationPolicy#values}
     *
     * @stability stable
     */
    readonly values?: string[];
}
export declare function folderOrganizationPolicyListPolicyDenyToTerraform(struct?: FolderOrganizationPolicyListPolicyDenyOutputReference | FolderOrganizationPolicyListPolicyDeny): any;
/**
 * @stability stable
 */
export declare class FolderOrganizationPolicyListPolicyDenyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FolderOrganizationPolicyListPolicyDeny | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FolderOrganizationPolicyListPolicyDeny | undefined);
    private _all?;
    /**
     * @stability stable
     */
    get all(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set all(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAll(): void;
    /**
     * @stability stable
     */
    get allInput(): boolean | cdktf.IResolvable | undefined;
    private _values?;
    /**
     * @stability stable
     */
    get values(): string[];
    /**
     * @stability stable
     */
    set values(value: string[]);
    /**
     * @stability stable
     */
    resetValues(): void;
    /**
     * @stability stable
     */
    get valuesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface FolderOrganizationPolicyListPolicy {
    /**
     * If set to true, the values from the effective Policy of the parent resource are inherited, meaning the values set in this Policy are added to the values inherited up the hierarchy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#inherit_from_parent FolderOrganizationPolicy#inherit_from_parent}
     *
     * @stability stable
     */
    readonly inheritFromParent?: boolean | cdktf.IResolvable;
    /**
     * The Google Cloud Console will try to default to a configuration that matches the value specified in this field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#suggested_value FolderOrganizationPolicy#suggested_value}
     *
     * @stability stable
     */
    readonly suggestedValue?: string;
    /**
     * allow block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#allow FolderOrganizationPolicy#allow}
     *
     * @stability stable
     */
    readonly allow?: FolderOrganizationPolicyListPolicyAllow;
    /**
     * deny block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#deny FolderOrganizationPolicy#deny}
     *
     * @stability stable
     */
    readonly deny?: FolderOrganizationPolicyListPolicyDeny;
}
export declare function folderOrganizationPolicyListPolicyToTerraform(struct?: FolderOrganizationPolicyListPolicyOutputReference | FolderOrganizationPolicyListPolicy): any;
/**
 * @stability stable
 */
export declare class FolderOrganizationPolicyListPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FolderOrganizationPolicyListPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FolderOrganizationPolicyListPolicy | undefined);
    private _inheritFromParent?;
    /**
     * @stability stable
     */
    get inheritFromParent(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set inheritFromParent(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetInheritFromParent(): void;
    /**
     * @stability stable
     */
    get inheritFromParentInput(): boolean | cdktf.IResolvable | undefined;
    private _suggestedValue?;
    /**
     * @stability stable
     */
    get suggestedValue(): string;
    /**
     * @stability stable
     */
    set suggestedValue(value: string);
    /**
     * @stability stable
     */
    resetSuggestedValue(): void;
    /**
     * @stability stable
     */
    get suggestedValueInput(): string | undefined;
    private _allow;
    /**
     * @stability stable
     */
    get allow(): FolderOrganizationPolicyListPolicyAllowOutputReference;
    /**
     * @stability stable
     */
    putAllow(value: FolderOrganizationPolicyListPolicyAllow): void;
    /**
     * @stability stable
     */
    resetAllow(): void;
    /**
     * @stability stable
     */
    get allowInput(): FolderOrganizationPolicyListPolicyAllow | undefined;
    private _deny;
    /**
     * @stability stable
     */
    get deny(): FolderOrganizationPolicyListPolicyDenyOutputReference;
    /**
     * @stability stable
     */
    putDeny(value: FolderOrganizationPolicyListPolicyDeny): void;
    /**
     * @stability stable
     */
    resetDeny(): void;
    /**
     * @stability stable
     */
    get denyInput(): FolderOrganizationPolicyListPolicyDeny | undefined;
}
/**
 * @stability stable
 */
export interface FolderOrganizationPolicyRestorePolicy {
    /**
     * May only be set to true. If set, then the default Policy is restored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#default FolderOrganizationPolicy#default}
     *
     * @stability stable
     */
    readonly default: boolean | cdktf.IResolvable;
}
export declare function folderOrganizationPolicyRestorePolicyToTerraform(struct?: FolderOrganizationPolicyRestorePolicyOutputReference | FolderOrganizationPolicyRestorePolicy): any;
/**
 * @stability stable
 */
export declare class FolderOrganizationPolicyRestorePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FolderOrganizationPolicyRestorePolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FolderOrganizationPolicyRestorePolicy | undefined);
    private _default?;
    /**
     * @stability stable
     */
    get default(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set default(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get defaultInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface FolderOrganizationPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#create FolderOrganizationPolicy#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#delete FolderOrganizationPolicy#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#read FolderOrganizationPolicy#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#update FolderOrganizationPolicy#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function folderOrganizationPolicyTimeoutsToTerraform(struct?: FolderOrganizationPolicyTimeoutsOutputReference | FolderOrganizationPolicyTimeouts): any;
/**
 * @stability stable
 */
export declare class FolderOrganizationPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FolderOrganizationPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FolderOrganizationPolicyTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html google_folder_organization_policy}.
 *
 * @stability stable
 */
export declare class FolderOrganizationPolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html google_folder_organization_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: FolderOrganizationPolicyConfig);
    private _constraint?;
    /**
     * @stability stable
     */
    get constraint(): string;
    /**
     * @stability stable
     */
    set constraint(value: string);
    /**
     * @stability stable
     */
    get constraintInput(): string | undefined;
    /**
     * @stability stable
     */
    get etag(): string;
    private _folder?;
    /**
     * @stability stable
     */
    get folder(): string;
    /**
     * @stability stable
     */
    set folder(value: string);
    /**
     * @stability stable
     */
    get folderInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get updateTime(): string;
    private _version?;
    /**
     * @stability stable
     */
    get version(): number;
    /**
     * @stability stable
     */
    set version(value: number);
    /**
     * @stability stable
     */
    resetVersion(): void;
    /**
     * @stability stable
     */
    get versionInput(): number | undefined;
    private _booleanPolicy;
    /**
     * @stability stable
     */
    get booleanPolicy(): FolderOrganizationPolicyBooleanPolicyOutputReference;
    /**
     * @stability stable
     */
    putBooleanPolicy(value: FolderOrganizationPolicyBooleanPolicy): void;
    /**
     * @stability stable
     */
    resetBooleanPolicy(): void;
    /**
     * @stability stable
     */
    get booleanPolicyInput(): FolderOrganizationPolicyBooleanPolicy | undefined;
    private _listPolicy;
    /**
     * @stability stable
     */
    get listPolicy(): FolderOrganizationPolicyListPolicyOutputReference;
    /**
     * @stability stable
     */
    putListPolicy(value: FolderOrganizationPolicyListPolicy): void;
    /**
     * @stability stable
     */
    resetListPolicy(): void;
    /**
     * @stability stable
     */
    get listPolicyInput(): FolderOrganizationPolicyListPolicy | undefined;
    private _restorePolicy;
    /**
     * @stability stable
     */
    get restorePolicy(): FolderOrganizationPolicyRestorePolicyOutputReference;
    /**
     * @stability stable
     */
    putRestorePolicy(value: FolderOrganizationPolicyRestorePolicy): void;
    /**
     * @stability stable
     */
    resetRestorePolicy(): void;
    /**
     * @stability stable
     */
    get restorePolicyInput(): FolderOrganizationPolicyRestorePolicy | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): FolderOrganizationPolicyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: FolderOrganizationPolicyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): FolderOrganizationPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
