# mypy-boto3-kms<a id="mypy-boto3-kms"></a>

[![PyPI - mypy-boto3-kms](https://img.shields.io/pypi/v/mypy-boto3-kms.svg?color=blue)](https://pypi.org/project/mypy-boto3-kms)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-kms.svg?color=blue)](https://pypi.org/project/mypy-boto3-kms)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-kms?color=blue)](https://pypistats.org/packages/mypy-boto3-kms)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.KMS 1.17.72](https://boto3.amazonaws.com/v1/documentation/api/1.17.72/reference/services/kms.html#KMS)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.13.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-kms docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_kms/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-kms](#mypy-boto3-kms)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

## How to install<a id="how-to-install"></a>

Install `boto3-stubs` for `KMS` service.

```bash
python -m pip install boto3-stubs[kms]
```

## Usage<a id="usage"></a>

### VSCode<a id="vscode"></a>

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[kms]` in your environment:
  `python -m pip install 'boto3-stubs[kms]'`

Both type checking and auto-complete should work for `KMS` service. No explicit
type annotations required, write your `boto3` code as usual.

### PyCharm<a id="pycharm"></a>

- Install `boto-stubs[kms]` in your environment:
  `python -m pip install 'boto3-stubs[kms]'`

Both type checking and auto-complete should work for `KMS` service. No explicit
type annotations required, write your `boto3` code as usual. Auto-complete can
be slow on big projects or if you have a lot of installed `boto3-stubs`
submodules.

### Other IDEs<a id="other-ides"></a>

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

### mypy<a id="mypy"></a>

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[kms]` in your environment:
  `python -m pip install 'boto3-stubs[kms]'`
- Run `mypy` as usual

Type checking should work for `KMS` service. No explicit type annotations
required, write your `boto3` code as usual.

### pyright<a id="pyright"></a>

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[kms]` in your environment:
  `python -m pip install 'boto3-stubs[kms]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `KMS` service. No explicit type annotations
required, write your `boto3` code as usual.

## Explicit type annotations<a id="explicit-type-annotations"></a>

### Client annotations<a id="client-annotations"></a>

`KMSClient` provides annotations for `boto3.client("kms")`.

```python
import boto3

from mypy_boto3_kms import KMSClient

client: KMSClient = boto3.client("kms")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: KMSClient = session.client("kms")
```

### Paginators annotations<a id="paginators-annotations"></a>

`mypy_boto3_kms.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_kms import KMSClient
from mypy_boto3_kms.paginator import (
    ListAliasesPaginator,
    ListGrantsPaginator,
    ListKeyPoliciesPaginator,
    ListKeysPaginator,
)

client: KMSClient = boto3.client("kms")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_aliases_paginator: ListAliasesPaginator = client.get_paginator("list_aliases")
list_grants_paginator: ListGrantsPaginator = client.get_paginator("list_grants")
list_key_policies_paginator: ListKeyPoliciesPaginator = client.get_paginator("list_key_policies")
list_keys_paginator: ListKeysPaginator = client.get_paginator("list_keys")
```

### Literals<a id="literals"></a>

`mypy_boto3_kms.literals` module contains literals extracted from shapes that
can be used in user code for type checking.

```python
from mypy_boto3_kms.literals import (
    AlgorithmSpecType,
    ConnectionErrorCodeTypeType,
    ConnectionStateTypeType,
    CustomerMasterKeySpecType,
    DataKeyPairSpecType,
    DataKeySpecType,
    EncryptionAlgorithmSpecType,
    ExpirationModelTypeType,
    GrantOperationType,
    KeyManagerTypeType,
    KeyStateType,
    KeyUsageTypeType,
    ListAliasesPaginatorName,
    ListGrantsPaginatorName,
    ListKeyPoliciesPaginatorName,
    ListKeysPaginatorName,
    MessageTypeType,
    OriginTypeType,
    SigningAlgorithmSpecType,
    WrappingKeySpecType,
)

def check_value(value: AlgorithmSpecType) -> bool:
    ...
```

### Typed dictionaries<a id="typed-dictionaries"></a>

`mypy_boto3_kms.type_defs` module contains structures and shapes assembled to
typed dictionaries for additional type checking.

```python
from mypy_boto3_kms.type_defs import (
    AliasListEntryTypeDef,
    CancelKeyDeletionResponseTypeDef,
    CreateCustomKeyStoreResponseTypeDef,
    CreateGrantResponseTypeDef,
    CreateKeyResponseTypeDef,
    CustomKeyStoresListEntryTypeDef,
    DecryptResponseTypeDef,
    DescribeCustomKeyStoresResponseTypeDef,
    DescribeKeyResponseTypeDef,
    EncryptResponseTypeDef,
    GenerateDataKeyPairResponseTypeDef,
    GenerateDataKeyPairWithoutPlaintextResponseTypeDef,
    GenerateDataKeyResponseTypeDef,
    GenerateDataKeyWithoutPlaintextResponseTypeDef,
    GenerateRandomResponseTypeDef,
    GetKeyPolicyResponseTypeDef,
    GetKeyRotationStatusResponseTypeDef,
    GetParametersForImportResponseTypeDef,
    GetPublicKeyResponseTypeDef,
    GrantConstraintsTypeDef,
    GrantListEntryTypeDef,
    KeyListEntryTypeDef,
    KeyMetadataTypeDef,
    ListAliasesResponseTypeDef,
    ListGrantsResponseTypeDef,
    ListKeyPoliciesResponseTypeDef,
    ListKeysResponseTypeDef,
    ListResourceTagsResponseTypeDef,
    PaginatorConfigTypeDef,
    ReEncryptResponseTypeDef,
    ScheduleKeyDeletionResponseTypeDef,
    SignResponseTypeDef,
    TagTypeDef,
    VerifyResponseTypeDef,
)

def get_structure() -> AliasListEntryTypeDef:
    return {
      ...
    }
```

## Versioning<a id="versioning"></a>

`mypy-boto3-kms` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

## Documentation<a id="documentation"></a>

All type annotations can be found in
[mypy-boto3-kms docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_kms/)

## Support and contributing<a id="support-and-contributing"></a>

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
