[![portray - Your Project with Great Documentation.](https://raw.github.com/timothycrosley/portray/main/art/logo.png)](https://timothycrosley.github.io/portray/)
_________________

[![PyPI version](https://badge.fury.io/py/portray.svg)](http://badge.fury.io/py/portray)
[![Test Status](https://github.com/timothycrosley/portray/workflows/Test/badge.svg?branch=main)](https://github.com/timothycrosley/portray/actions?query=workflow%3ATest)
[![Lint Status](https://github.com/timothycrosley/portray/workflows/Lint/badge.svg?branch=main)](https://github.com/timothycrosley/portray/actions?query=workflow%3ALint)
[![codecov](https://codecov.io/gh/timothycrosley/portray/branch/main/graph/badge.svg)](https://codecov.io/gh/timothycrosley/portray)
[![Join the chat at https://gitter.im/timothycrosley/portray](https://badges.gitter.im/timothycrosley/portray.svg)](https://gitter.im/timothycrosley/portray?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)
[![License](https://img.shields.io/github/license/mashape/apistatus.svg)](https://pypi.python.org/pypi/portray/)
[![Downloads](https://pepy.tech/badge/portray)](https://pepy.tech/project/portray)
_________________

[Read Latest Documentation](https://timothycrosley.github.io/portray/) - [Browse GitHub Code Repository](https://github.com/timothycrosley/portray/)
_________________

> The only thing worse than documentation never written, is documentation written but never discovered.

**portray** is a Python3 command line tool and library that helps you create great documentation websites for your Python projects with as little effort as possible.

[![Example Usage Gif](https://raw.githubusercontent.com/timothycrosley/portray/main/art/example.gif)](https://raw.githubusercontent.com/timothycrosley/portray/main/art/example.gif)

Key Features:

* **Zero-Config**: No configuration is necessary to use `portray`. Just run `portray` in the root of your Python project and it will find your documentation.
* **Statically Generated**: `portray` websites are easy to host on GitHub pages and other similar services as they are outputted as standard static HTML websites.
* **Markdown Aware**: `portray` will automatically include your projects `.md` files and render them into HTML. It will also find and render Markdown within `__doc__` strings.
* **Fully Configurable**: While `portray` doesn't have to be configured, you still can fully configure it within the standard `pyproject.toml` file.
* **Easily Programmable**: `portray` exposes a clean and simple [Python API](https://timothycrosley.github.io/portray/reference/portray/api/).
* **Searchable**: Out of the box `portray` makes all of your documentation, even autogenerated code references, free-text searchable.
* **Themeable**: `portray` is compatible with all existing [MkDocs Themes](https://github.com/mkdocs/mkdocs/wiki/MkDocs-Themes).

Under the hood, portray combines the [Markdown](https://commonmark.org/help/) documentation rendering capabilities provided by [MkDocs](https://www.mkdocs.org/)
with the automatic reference documentation generated by [pdocs](https://timothycrosley.github.io/pdocs/).

## Quick Start

The following guides should get you up and running with a documentation website in no time.

1. [Installation](https://timothycrosley.github.io/portray/docs/quick_start/1.-installation/) - TL;DR: Run `pip3 install portray` within your projects virtual environment.
2. [Command Line Usage](https://timothycrosley.github.io/portray/docs/quick_start/2.-cli/) - TL;DR: Run `portray in_browser` to test and `portray on_github_pages` to deploy.
3. [API Usage](https://timothycrosley.github.io/portray/docs/quick_start/3.-api/) - TL;DR: Everything available via the CLI is also easily available programmatically from within Python.
4. [Configuration](https://timothycrosley.github.io/portray/docs/quick_start/4.-configuration/) - TL;DR: Put all configuration within a `[tool.portray]` section of your `pyproject.toml` file.

## Why Create Portray?

I create a lot of Python projects and I've always wanted a quick way to build documentation sites for them that included both manually written guides and autogenerated reference documentation.
Tools have improved over the years, but still nothing has given me this experience out of the box. Portray isn't a competitor for the 2 newer Python documentation projects (pdocs and MkDocs), rather it is melding of them
together to give me the quick to create and comprehensive documentation website generation I've always wanted.

Thanks and I hope you too find `portray` useful!

~Timothy Crosley
