# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['portray']

package_data = \
{'': ['*'], 'portray': ['mkdocs_templates/partials/*']}

install_requires = \
['GitPython>=3.0,<4.0',
 'hug>=2.6,<3.0',
 'livereload>=2.6.3,<3.0.0',
 'mkdocs-material>=7.0,<8.0',
 'mkdocs>=1.2,<1.3',
 'pdocs>=1.1.1,<2.0.0',
 'pymdown-extensions>=7.0,<8.0',
 'toml>=0.10.0,<0.11.0',
 'yaspin>=0.15.0,<0.16.0']

entry_points = \
{'console_scripts': ['portray = portray.cli:__hug__.cli']}

setup_kwargs = {
    'name': 'portray',
    'version': '1.7.0',
    'description': 'Your Project with Great Documentation',
    'long_description': "[![portray - Your Project with Great Documentation.](https://raw.github.com/timothycrosley/portray/main/art/logo.png)](https://timothycrosley.github.io/portray/)\n_________________\n\n[![PyPI version](https://badge.fury.io/py/portray.svg)](http://badge.fury.io/py/portray)\n[![Test Status](https://github.com/timothycrosley/portray/workflows/Test/badge.svg?branch=main)](https://github.com/timothycrosley/portray/actions?query=workflow%3ATest)\n[![Lint Status](https://github.com/timothycrosley/portray/workflows/Lint/badge.svg?branch=main)](https://github.com/timothycrosley/portray/actions?query=workflow%3ALint)\n[![codecov](https://codecov.io/gh/timothycrosley/portray/branch/main/graph/badge.svg)](https://codecov.io/gh/timothycrosley/portray)\n[![Join the chat at https://gitter.im/timothycrosley/portray](https://badges.gitter.im/timothycrosley/portray.svg)](https://gitter.im/timothycrosley/portray?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)\n[![License](https://img.shields.io/github/license/mashape/apistatus.svg)](https://pypi.python.org/pypi/portray/)\n[![Downloads](https://pepy.tech/badge/portray)](https://pepy.tech/project/portray)\n_________________\n\n[Read Latest Documentation](https://timothycrosley.github.io/portray/) - [Browse GitHub Code Repository](https://github.com/timothycrosley/portray/)\n_________________\n\n> The only thing worse than documentation never written, is documentation written but never discovered.\n\n**portray** is a Python3 command line tool and library that helps you create great documentation websites for your Python projects with as little effort as possible.\n\n[![Example Usage Gif](https://raw.githubusercontent.com/timothycrosley/portray/main/art/example.gif)](https://raw.githubusercontent.com/timothycrosley/portray/main/art/example.gif)\n\nKey Features:\n\n* **Zero-Config**: No configuration is necessary to use `portray`. Just run `portray` in the root of your Python project and it will find your documentation.\n* **Statically Generated**: `portray` websites are easy to host on GitHub pages and other similar services as they are outputted as standard static HTML websites.\n* **Markdown Aware**: `portray` will automatically include your projects `.md` files and render them into HTML. It will also find and render Markdown within `__doc__` strings.\n* **Fully Configurable**: While `portray` doesn't have to be configured, you still can fully configure it within the standard `pyproject.toml` file.\n* **Easily Programmable**: `portray` exposes a clean and simple [Python API](https://timothycrosley.github.io/portray/reference/portray/api/).\n* **Searchable**: Out of the box `portray` makes all of your documentation, even autogenerated code references, free-text searchable.\n* **Themeable**: `portray` is compatible with all existing [MkDocs Themes](https://github.com/mkdocs/mkdocs/wiki/MkDocs-Themes).\n\nUnder the hood, portray combines the [Markdown](https://commonmark.org/help/) documentation rendering capabilities provided by [MkDocs](https://www.mkdocs.org/)\nwith the automatic reference documentation generated by [pdocs](https://timothycrosley.github.io/pdocs/).\n\n## Quick Start\n\nThe following guides should get you up and running with a documentation website in no time.\n\n1. [Installation](https://timothycrosley.github.io/portray/docs/quick_start/1.-installation/) - TL;DR: Run `pip3 install portray` within your projects virtual environment.\n2. [Command Line Usage](https://timothycrosley.github.io/portray/docs/quick_start/2.-cli/) - TL;DR: Run `portray in_browser` to test and `portray on_github_pages` to deploy.\n3. [API Usage](https://timothycrosley.github.io/portray/docs/quick_start/3.-api/) - TL;DR: Everything available via the CLI is also easily available programmatically from within Python.\n4. [Configuration](https://timothycrosley.github.io/portray/docs/quick_start/4.-configuration/) - TL;DR: Put all configuration within a `[tool.portray]` section of your `pyproject.toml` file.\n\n## Why Create Portray?\n\nI create a lot of Python projects and I've always wanted a quick way to build documentation sites for them that included both manually written guides and autogenerated reference documentation.\nTools have improved over the years, but still nothing has given me this experience out of the box. Portray isn't a competitor for the 2 newer Python documentation projects (pdocs and MkDocs), rather it is melding of them\ntogether to give me the quick to create and comprehensive documentation website generation I've always wanted.\n\nThanks and I hope you too find `portray` useful!\n\n~Timothy Crosley\n",
    'author': 'Timothy Crosley',
    'author_email': 'timothy.crosley@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
