# coding: utf-8

"""
    Yagna Activity API

     The Activity API can be perceived as controls which a Requestor-side application has to steer the execution of an Activity as specified in an Agreement which has been negotiated via the Market API/Protocol. This defines possible interactions between the Requestor application (via Activity API) and the generic components running on the Provider node, which host the Provider-side application code. The possible interactions imply a logical “execution environment” component, which is the host/container for the “payload” code. The “execution environment” is specified as an ExeUnit, with a generic interface via which a Provider node’s Activity Controller can operate the hosted code. It conforms with capability level 1 of the [Activity API specification] (https://docs.google.com/document/d/1BXaN32ediXdBHljEApmznSfbuudTU8TmvOmHKl0gmQM).   # noqa: E501

    The version of the OpenAPI document: 1.6.1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

from ya_activity.configuration import Configuration


class SgxCredentials(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'enclave_pub_key': 'str',
        'requestor_pub_key': 'str',
        'payload_hash': 'str',
        'ias_report': 'str',
        'ias_sig': 'str'
    }

    attribute_map = {
        'enclave_pub_key': 'enclavePubKey',
        'requestor_pub_key': 'requestorPubKey',
        'payload_hash': 'payloadHash',
        'ias_report': 'iasReport',
        'ias_sig': 'iasSig'
    }

    def __init__(self, enclave_pub_key=None, requestor_pub_key=None, payload_hash=None, ias_report=None, ias_sig=None, local_vars_configuration=None):  # noqa: E501
        """SgxCredentials - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._enclave_pub_key = None
        self._requestor_pub_key = None
        self._payload_hash = None
        self._ias_report = None
        self._ias_sig = None
        self.discriminator = None

        self.enclave_pub_key = enclave_pub_key
        self.requestor_pub_key = requestor_pub_key
        self.payload_hash = payload_hash
        self.ias_report = ias_report
        self.ias_sig = ias_sig

    @property
    def enclave_pub_key(self):
        """Gets the enclave_pub_key of this SgxCredentials.  # noqa: E501


        :return: The enclave_pub_key of this SgxCredentials.  # noqa: E501
        :rtype: str
        """
        return self._enclave_pub_key

    @enclave_pub_key.setter
    def enclave_pub_key(self, enclave_pub_key):
        """Sets the enclave_pub_key of this SgxCredentials.


        :param enclave_pub_key: The enclave_pub_key of this SgxCredentials.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and enclave_pub_key is None:  # noqa: E501
            raise ValueError("Invalid value for `enclave_pub_key`, must not be `None`")  # noqa: E501

        self._enclave_pub_key = enclave_pub_key

    @property
    def requestor_pub_key(self):
        """Gets the requestor_pub_key of this SgxCredentials.  # noqa: E501


        :return: The requestor_pub_key of this SgxCredentials.  # noqa: E501
        :rtype: str
        """
        return self._requestor_pub_key

    @requestor_pub_key.setter
    def requestor_pub_key(self, requestor_pub_key):
        """Sets the requestor_pub_key of this SgxCredentials.


        :param requestor_pub_key: The requestor_pub_key of this SgxCredentials.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and requestor_pub_key is None:  # noqa: E501
            raise ValueError("Invalid value for `requestor_pub_key`, must not be `None`")  # noqa: E501

        self._requestor_pub_key = requestor_pub_key

    @property
    def payload_hash(self):
        """Gets the payload_hash of this SgxCredentials.  # noqa: E501


        :return: The payload_hash of this SgxCredentials.  # noqa: E501
        :rtype: str
        """
        return self._payload_hash

    @payload_hash.setter
    def payload_hash(self, payload_hash):
        """Sets the payload_hash of this SgxCredentials.


        :param payload_hash: The payload_hash of this SgxCredentials.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and payload_hash is None:  # noqa: E501
            raise ValueError("Invalid value for `payload_hash`, must not be `None`")  # noqa: E501

        self._payload_hash = payload_hash

    @property
    def ias_report(self):
        """Gets the ias_report of this SgxCredentials.  # noqa: E501


        :return: The ias_report of this SgxCredentials.  # noqa: E501
        :rtype: str
        """
        return self._ias_report

    @ias_report.setter
    def ias_report(self, ias_report):
        """Sets the ias_report of this SgxCredentials.


        :param ias_report: The ias_report of this SgxCredentials.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and ias_report is None:  # noqa: E501
            raise ValueError("Invalid value for `ias_report`, must not be `None`")  # noqa: E501

        self._ias_report = ias_report

    @property
    def ias_sig(self):
        """Gets the ias_sig of this SgxCredentials.  # noqa: E501


        :return: The ias_sig of this SgxCredentials.  # noqa: E501
        :rtype: str
        """
        return self._ias_sig

    @ias_sig.setter
    def ias_sig(self, ias_sig):
        """Sets the ias_sig of this SgxCredentials.


        :param ias_sig: The ias_sig of this SgxCredentials.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and ias_sig is None:  # noqa: E501
            raise ValueError("Invalid value for `ias_sig`, must not be `None`")  # noqa: E501

        self._ias_sig = ias_sig

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr in self.openapi_types:
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SgxCredentials):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SgxCredentials):
            return True

        return self.to_dict() != other.to_dict()
