# coding: utf-8

"""
    Yagna Payment API

     Invoicing and Payments is a fundamental area of Yagna Ecosystem functionality. It includes aspects of communication between Requestor, Provider and a selected Payment Platform, which becomes crucial when Activities are executed in the context of negotiated Agreements. Yagna applications must be able to exercise various payment models, and the Invoicing/Payment-related communication is happening in parallel to Activity control communication. To define functional patterns of Requestor/Provider interaction in this area, Payment API is specified.  An important principle of the Yagna Payment API is that the actual payment transactions are hidden behind the Invoice flow. In other words, a Yagna Application on Requestor side isn’t expected to trigger actual payment transactions. Instead it is expected to receive and accept Invoices raised by the Provider - based on Application’s Invoice Accept notifications, the Payment API implementation orchestrates the payment via a configured Payment platform.  **NOTE: This specification is work-in-progress.**   # noqa: E501

    The version of the OpenAPI document: 1.6.2
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401


from ya_payment.configuration import Configuration


class DebitNote(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "debit_note_id": "str",
        "issuer_id": "str",
        "recipient_id": "str",
        "payee_addr": "str",
        "payer_addr": "str",
        "payment_platform": "str",
        "previous_debit_note_id": "str",
        "timestamp": "datetime",
        "agreement_id": "str",
        "activity_id": "str",
        "total_amount_due": "str",
        "usage_counter_vector": "object",
        "payment_due_date": "datetime",
        "status": "InvoiceStatus",
    }

    attribute_map = {
        "debit_note_id": "debitNoteId",
        "issuer_id": "issuerId",
        "recipient_id": "recipientId",
        "payee_addr": "payeeAddr",
        "payer_addr": "payerAddr",
        "payment_platform": "paymentPlatform",
        "previous_debit_note_id": "previousDebitNoteId",
        "timestamp": "timestamp",
        "agreement_id": "agreementId",
        "activity_id": "activityId",
        "total_amount_due": "totalAmountDue",
        "usage_counter_vector": "usageCounterVector",
        "payment_due_date": "paymentDueDate",
        "status": "status",
    }

    def __init__(
        self,
        debit_note_id=None,
        issuer_id=None,
        recipient_id=None,
        payee_addr=None,
        payer_addr=None,
        payment_platform=None,
        previous_debit_note_id=None,
        timestamp=None,
        agreement_id=None,
        activity_id=None,
        total_amount_due=None,
        usage_counter_vector=None,
        payment_due_date=None,
        status=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """DebitNote - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._debit_note_id = None
        self._issuer_id = None
        self._recipient_id = None
        self._payee_addr = None
        self._payer_addr = None
        self._payment_platform = None
        self._previous_debit_note_id = None
        self._timestamp = None
        self._agreement_id = None
        self._activity_id = None
        self._total_amount_due = None
        self._usage_counter_vector = None
        self._payment_due_date = None
        self._status = None
        self.discriminator = None

        self.debit_note_id = debit_note_id
        self.issuer_id = issuer_id
        self.recipient_id = recipient_id
        if payee_addr is not None:
            self.payee_addr = payee_addr
        if payer_addr is not None:
            self.payer_addr = payer_addr
        if payment_platform is not None:
            self.payment_platform = payment_platform
        if previous_debit_note_id is not None:
            self.previous_debit_note_id = previous_debit_note_id
        self.timestamp = timestamp
        self.agreement_id = agreement_id
        self.activity_id = activity_id
        self.total_amount_due = total_amount_due
        if usage_counter_vector is not None:
            self.usage_counter_vector = usage_counter_vector
        if payment_due_date is not None:
            self.payment_due_date = payment_due_date
        self.status = status

    @property
    def debit_note_id(self):
        """Gets the debit_note_id of this DebitNote.  # noqa: E501


        :return: The debit_note_id of this DebitNote.  # noqa: E501
        :rtype: str
        """
        return self._debit_note_id

    @debit_note_id.setter
    def debit_note_id(self, debit_note_id):
        """Sets the debit_note_id of this DebitNote.


        :param debit_note_id: The debit_note_id of this DebitNote.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation
            and debit_note_id is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `debit_note_id`, must not be `None`"
            )  # noqa: E501

        self._debit_note_id = debit_note_id

    @property
    def issuer_id(self):
        """Gets the issuer_id of this DebitNote.  # noqa: E501


        :return: The issuer_id of this DebitNote.  # noqa: E501
        :rtype: str
        """
        return self._issuer_id

    @issuer_id.setter
    def issuer_id(self, issuer_id):
        """Sets the issuer_id of this DebitNote.


        :param issuer_id: The issuer_id of this DebitNote.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and issuer_id is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `issuer_id`, must not be `None`"
            )  # noqa: E501

        self._issuer_id = issuer_id

    @property
    def recipient_id(self):
        """Gets the recipient_id of this DebitNote.  # noqa: E501


        :return: The recipient_id of this DebitNote.  # noqa: E501
        :rtype: str
        """
        return self._recipient_id

    @recipient_id.setter
    def recipient_id(self, recipient_id):
        """Sets the recipient_id of this DebitNote.


        :param recipient_id: The recipient_id of this DebitNote.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation
            and recipient_id is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `recipient_id`, must not be `None`"
            )  # noqa: E501

        self._recipient_id = recipient_id

    @property
    def payee_addr(self):
        """Gets the payee_addr of this DebitNote.  # noqa: E501


        :return: The payee_addr of this DebitNote.  # noqa: E501
        :rtype: str
        """
        return self._payee_addr

    @payee_addr.setter
    def payee_addr(self, payee_addr):
        """Sets the payee_addr of this DebitNote.


        :param payee_addr: The payee_addr of this DebitNote.  # noqa: E501
        :type: str
        """

        self._payee_addr = payee_addr

    @property
    def payer_addr(self):
        """Gets the payer_addr of this DebitNote.  # noqa: E501


        :return: The payer_addr of this DebitNote.  # noqa: E501
        :rtype: str
        """
        return self._payer_addr

    @payer_addr.setter
    def payer_addr(self, payer_addr):
        """Sets the payer_addr of this DebitNote.


        :param payer_addr: The payer_addr of this DebitNote.  # noqa: E501
        :type: str
        """

        self._payer_addr = payer_addr

    @property
    def payment_platform(self):
        """Gets the payment_platform of this DebitNote.  # noqa: E501


        :return: The payment_platform of this DebitNote.  # noqa: E501
        :rtype: str
        """
        return self._payment_platform

    @payment_platform.setter
    def payment_platform(self, payment_platform):
        """Sets the payment_platform of this DebitNote.


        :param payment_platform: The payment_platform of this DebitNote.  # noqa: E501
        :type: str
        """

        self._payment_platform = payment_platform

    @property
    def previous_debit_note_id(self):
        """Gets the previous_debit_note_id of this DebitNote.  # noqa: E501


        :return: The previous_debit_note_id of this DebitNote.  # noqa: E501
        :rtype: str
        """
        return self._previous_debit_note_id

    @previous_debit_note_id.setter
    def previous_debit_note_id(self, previous_debit_note_id):
        """Sets the previous_debit_note_id of this DebitNote.


        :param previous_debit_note_id: The previous_debit_note_id of this DebitNote.  # noqa: E501
        :type: str
        """

        self._previous_debit_note_id = previous_debit_note_id

    @property
    def timestamp(self):
        """Gets the timestamp of this DebitNote.  # noqa: E501


        :return: The timestamp of this DebitNote.  # noqa: E501
        :rtype: datetime
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """Sets the timestamp of this DebitNote.


        :param timestamp: The timestamp of this DebitNote.  # noqa: E501
        :type: datetime
        """
        if (
            self.local_vars_configuration.client_side_validation and timestamp is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `timestamp`, must not be `None`"
            )  # noqa: E501

        self._timestamp = timestamp

    @property
    def agreement_id(self):
        """Gets the agreement_id of this DebitNote.  # noqa: E501


        :return: The agreement_id of this DebitNote.  # noqa: E501
        :rtype: str
        """
        return self._agreement_id

    @agreement_id.setter
    def agreement_id(self, agreement_id):
        """Sets the agreement_id of this DebitNote.


        :param agreement_id: The agreement_id of this DebitNote.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation
            and agreement_id is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `agreement_id`, must not be `None`"
            )  # noqa: E501

        self._agreement_id = agreement_id

    @property
    def activity_id(self):
        """Gets the activity_id of this DebitNote.  # noqa: E501


        :return: The activity_id of this DebitNote.  # noqa: E501
        :rtype: str
        """
        return self._activity_id

    @activity_id.setter
    def activity_id(self, activity_id):
        """Sets the activity_id of this DebitNote.


        :param activity_id: The activity_id of this DebitNote.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and activity_id is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `activity_id`, must not be `None`"
            )  # noqa: E501

        self._activity_id = activity_id

    @property
    def total_amount_due(self):
        """Gets the total_amount_due of this DebitNote.  # noqa: E501


        :return: The total_amount_due of this DebitNote.  # noqa: E501
        :rtype: str
        """
        return self._total_amount_due

    @total_amount_due.setter
    def total_amount_due(self, total_amount_due):
        """Sets the total_amount_due of this DebitNote.


        :param total_amount_due: The total_amount_due of this DebitNote.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation
            and total_amount_due is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `total_amount_due`, must not be `None`"
            )  # noqa: E501

        self._total_amount_due = total_amount_due

    @property
    def usage_counter_vector(self):
        """Gets the usage_counter_vector of this DebitNote.  # noqa: E501


        :return: The usage_counter_vector of this DebitNote.  # noqa: E501
        :rtype: object
        """
        return self._usage_counter_vector

    @usage_counter_vector.setter
    def usage_counter_vector(self, usage_counter_vector):
        """Sets the usage_counter_vector of this DebitNote.


        :param usage_counter_vector: The usage_counter_vector of this DebitNote.  # noqa: E501
        :type: object
        """

        self._usage_counter_vector = usage_counter_vector

    @property
    def payment_due_date(self):
        """Gets the payment_due_date of this DebitNote.  # noqa: E501


        :return: The payment_due_date of this DebitNote.  # noqa: E501
        :rtype: datetime
        """
        return self._payment_due_date

    @payment_due_date.setter
    def payment_due_date(self, payment_due_date):
        """Sets the payment_due_date of this DebitNote.


        :param payment_due_date: The payment_due_date of this DebitNote.  # noqa: E501
        :type: datetime
        """

        self._payment_due_date = payment_due_date

    @property
    def status(self):
        """Gets the status of this DebitNote.  # noqa: E501


        :return: The status of this DebitNote.  # noqa: E501
        :rtype: InvoiceStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this DebitNote.


        :param status: The status of this DebitNote.  # noqa: E501
        :type: InvoiceStatus
        """
        if (
            self.local_vars_configuration.client_side_validation and status is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `status`, must not be `None`"
            )  # noqa: E501

        self._status = status

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in self.openapi_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DebitNote):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DebitNote):
            return True

        return self.to_dict() != other.to_dict()
