"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ListenerCertificate = void 0;
/**
 * A certificate source for an ELBv2 listener.
 */
class ListenerCertificate {
    /**
     *
     */
    constructor(certificateArn) {
        this.certificateArn = certificateArn;
    }
    /**
     * Use an ACM certificate as a listener certificate.
     */
    static fromCertificateManager(acmCertificate) {
        return new ListenerCertificate(acmCertificate.certificateArn);
    }
    /**
     * Use any certificate, identified by its ARN, as a listener certificate.
     */
    static fromArn(certificateArn) {
        return new ListenerCertificate(certificateArn);
    }
}
exports.ListenerCertificate = ListenerCertificate;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGlzdGVuZXItY2VydGlmaWNhdGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJsaXN0ZW5lci1jZXJ0aWZpY2F0ZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFlQSxNQUFhLG1CQUFtQjs7OztJQW9COUIsWUFBc0IsY0FBc0I7UUFDMUMsSUFBSSxDQUFDLGNBQWMsR0FBRyxjQUFjLENBQUM7SUFDdkMsQ0FBQzs7OztJQWxCTSxNQUFNLENBQUMsc0JBQXNCLENBQUMsY0FBZ0M7UUFDbkUsT0FBTyxJQUFJLG1CQUFtQixDQUFDLGNBQWMsQ0FBQyxjQUFjLENBQUMsQ0FBQztJQUNoRSxDQUFDOzs7O0lBS00sTUFBTSxDQUFDLE9BQU8sQ0FBQyxjQUFzQjtRQUMxQyxPQUFPLElBQUksbUJBQW1CLENBQUMsY0FBYyxDQUFDLENBQUM7SUFDakQsQ0FBQztDQVVGO0FBdkJELGtEQXVCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGFjbSBmcm9tICdAYXdzLWNkay9hd3MtY2VydGlmaWNhdGVtYW5hZ2VyJztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgSUxpc3RlbmVyQ2VydGlmaWNhdGUge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgY2VydGlmaWNhdGVBcm46IHN0cmluZztcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBMaXN0ZW5lckNlcnRpZmljYXRlIGltcGxlbWVudHMgSUxpc3RlbmVyQ2VydGlmaWNhdGUge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBmcm9tQ2VydGlmaWNhdGVNYW5hZ2VyKGFjbUNlcnRpZmljYXRlOiBhY20uSUNlcnRpZmljYXRlKSB7XG4gICAgcmV0dXJuIG5ldyBMaXN0ZW5lckNlcnRpZmljYXRlKGFjbUNlcnRpZmljYXRlLmNlcnRpZmljYXRlQXJuKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIGZyb21Bcm4oY2VydGlmaWNhdGVBcm46IHN0cmluZykge1xuICAgIHJldHVybiBuZXcgTGlzdGVuZXJDZXJ0aWZpY2F0ZShjZXJ0aWZpY2F0ZUFybik7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IGNlcnRpZmljYXRlQXJuOiBzdHJpbmc7XG5cbiAgcHJvdGVjdGVkIGNvbnN0cnVjdG9yKGNlcnRpZmljYXRlQXJuOiBzdHJpbmcpIHtcbiAgICB0aGlzLmNlcnRpZmljYXRlQXJuID0gY2VydGlmaWNhdGVBcm47XG4gIH1cbn1cbiJdfQ==