# CookieBD database documentation

This document has the documentation for version `1.1.0` of **CookieDB**,
check the file [CHANGELOG.md](https://github.com/jaedsonpys/cookiedb/blob/master/CHANGELOG.md)
to see all changes to the project.

> **WARNING**: _This version_ of `CookieDB` is _just a package_ for python, it still
> doesn't work as a command line program.

## Using CookieDB

See here a tutorial on how to use **CookieDB** in an easy and objective way.

### Manipulation

To manipulate the database, you must instantiate the `CookieDB` class
passing (or not) some arguments, such as:

1. `key`: a 32-character _base64_ encoded key. If not specified,
a default key will be used (unsafe if your database is exposed);
2. `database_local`: directory where the database will be or is, if nothing is
past, the current directory will be used;
3. `autocommit`: automatic commit, if active, all changes will be pushed
automatically.

```python
from cookiedb import CookieDB

cookiedb = CookieDB()
```

After that, you can perform any operation.

### Creating a database

To create a database, use the `CookieDB.create_database` method, passing
(or not) some arguments:

1. `database_name`: name of the database;
2. `if_not_exists`: optional parameter, if the database does not exist, no error
It will be released.

```python
from cookiedb import CookieDB

cookiedb = CookieDB()
cookiedb.create_database('MyDatabase')
```

### Opening a database

It is only possible to open a database if it exists, otherwise a
exception will be thrown. There is no secret to open, just use the `CookieDB.open` method:

```python
from cookiedb import CookieDB

cookiedb = CookieDB()
cookiedb.open('MyDatabase')
```

All **CookieDB** database files (**from version `1.0.0`**) have a `.cookiedb` extension, when opening a database,
CookieDB will look for the database name along with the `.cookiedb`
extension (e.g. `MyDatabase.cookiedb`).

> If _no database is open_, and **write** or **read** operations, `NoOpenDatabaseError` exception will be thrown.

### Creating item

An "item" is an object in the database, which can be a dictionary, list, string,
integer or float. The path can be just a string or an integer.

To create an item, we use the `CookieDB.create_item` method, which has the following parameters:

1. `path`: path of the item (where its value will be stored);
2. `value`: item value.

```python
from cookiedb import CookieDB

cookiedb = CookieDB(autocommit=True)
cookiedb.open('MyDatabase')

cookiedb.create_item('languages', {
    'python': {
        'extension': '.py',
        'creator': 'Guido van Rossum'
    },
    'cpp': {
        'extension': '.cpp',
        'creator': 'Bjarne Stroustrup'
    }
})
```

Each path, separated by "/" (slash), is a **key** in the `JSON` file,
creating an organized structure, see the example:

```python
path = 'languages/python'

# equivalent to:

json = {
    'languages': {
        'python': {}
    }
}
```

### Commit changes

If `autocommit` has not been enabled, you need to push your changes
manually using the `CookieDB.commit` method:

```python
from cookiedb import CookieDB

cookiedb = CookieDB()  # autocommit disabled
cookiedb.open('MyDatabase')

cookiedb.create_item('languages', {
    'python': {
        'extension': '.py',
        'creator': 'Guido van Rossum'
    },
    'cpp': {
        'extension': '.cpp',
        'creator': 'Bjarne Stroustrup'
    }
})

cookiedb.commit()
```

> The `CookieDB.get_item` method (which will be seen next), does not work if
> changes are not pushed before! Consider pushing all your
> changes before performing these operations. Write operations on database
> items are temporarily (assuming `autocommit` is disabled) saved, if the database is closed and these changes are not committed, they are lost.

### Getting an item

To get an item, use the `CookieDB.get_item` method passing the argument
`path` with the **path** of the item:

```python
from cookiedb import CookieDB

cookiedb = CookieDB(autocommit=True)
cookiedb.open('MyDatabase')

languages = cookiedb.get_item('languages')
print(languages)

# or, get an item inside that item

python_info = cookiedb.get_item('languages/python')
print(python_info)
```

That is, you can get data through the **path** as long as the content is
a dictionary (key and value).