# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['bunnet',
 'bunnet.odm',
 'bunnet.odm.interfaces',
 'bunnet.odm.operators',
 'bunnet.odm.operators.find',
 'bunnet.odm.operators.update',
 'bunnet.odm.queries',
 'bunnet.odm.settings',
 'bunnet.odm.utils']

package_data = \
{'': ['*']}

install_requires = \
['pydantic>=1.9.0', 'pymongo', 'yarl>=1.6']

setup_kwargs = {
    'name': 'bunnet',
    'version': '0.1.0',
    'description': 'Synchronous Python ODM for MongoDB',
    'long_description': '[![shields badge](https://shields.io/badge/-docs-blue)](https://roman-right.github.io/bunnet/)\n[![pypi](https://img.shields.io/pypi/v/bunnet.svg)](https://pypi.python.org/pypi/bunnet)\n\n[![Bunnet](https://github.com/roman-right/bunnet/raw/main/docs/assets/1.png)](https://github.com/roman-right/bunnet)\n\n*The logo is generated by [WOMBO Dream](https://www.wombo.art)*\n\n## Overview\n\n[Bunnet](https://github.com/roman-right/bunnet) - is a Python object-document mapper (ODM) for MongoDB. It is a synchronous fork of [Beanie ODM](https://github.com/roman-right/beanie).\n\nWhen using Bunnet each database collection has a corresponding `Document` that\nis used to interact with that collection. In addition to retrieving data,\nBunnet allows you to add, update, or delete documents from the collection as\nwell.\n\nBunnet saves you time by removing boilerplate code, and it helps you focus on\nthe parts of your app that actually matter.\n\n## Installation\n\n### PIP\n\n```shell\npip install bunnet\n```\n\n### Poetry\n\n```shell\npoetry add bunnet\n```\n## Example\n\n```python\nfrom typing import Optional\n\nfrom pymongo import MongoClient\nfrom pydantic import BaseModel\n\nfrom bunnet import Document, Indexed, init_bunnet\n\n\nclass Category(BaseModel):\n    name: str\n    description: str\n\n\nclass Product(Document):\n    name: str                          # You can use normal types just like in pydantic\n    description: Optional[str] = None\n    price: Indexed(float)              # You can also specify that a field should correspond to an index\n    category: Category                 # You can include pydantic models as well\n\n\n\n# Beanie uses Pymongo client under the hood \nclient = MongoClient("mongodb://user:pass@host:27017")\n\n# Initialize bunnet with the Product document class\ninit_bunnet(database=client.db_name, document_models=[Product])\n\nchocolate = Category(name="Chocolate", description="A preparation of roasted and ground cacao seeds.")\n# Beanie documents work just like pydantic models\ntonybar = Product(name="Tony\'s", price=5.95, category=chocolate)\n# And can be inserted into the database\ntonybar.insert() \n\n# You can find documents with pythonic syntax\nproduct = Product.find_one(Product.price < 10).run()\n\n# And update them\nproduct.set({Product.name:"Gold bar"})\n\n```\n\n## Links\n\n### Documentation\n\n- **[Doc](https://roman-right.github.io/bunnet/)** - Tutorial, API documentation, and development guidelines.\n\n### Resources\n\n- **[GitHub](https://github.com/roman-right/bunnet)** - GitHub page of the\n  project\n- **[Changelog](https://roman-right.github.io/bunnet/changelog)** - list of all\n  the valuable changes\n- **[Discord](https://discord.gg/ZTTnM7rMaz)** - ask your questions, share\n  ideas or just say `Hello!!`\n\n----\nSupported by [JetBrains](https://jb.gg/OpenSource)\n\n[![JetBrains](https://raw.githubusercontent.com/roman-right/beanie/main/assets/logo/jetbrains.svg)](https://jb.gg/OpenSource)\n',
    'author': 'Roman',
    'author_email': 'roman-right@protonmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/roman-right/bunnet',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
