# ===================================================================================================
#                           _  __     _ _
#                          | |/ /__ _| | |_ _  _ _ _ __ _
#                          | ' </ _` | |  _| || | '_/ _` |
#                          |_|\_\__,_|_|\__|\_,_|_| \__,_|
#
# This file is part of the Kaltura Collaborative Media Suite which allows users
# to do with audio, video, and animation what Wiki platforms allow them to do with
# text.
#
# Copyright (C) 2006-2022  Kaltura Inc.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http:#www.gnu.org/licenses/>.
#
# @ignore
# ===================================================================================================
# @package Kaltura
# @subpackage Client
from __future__ import absolute_import

from ..Base import (
    getXmlNodeBool,
    getXmlNodeFloat,
    getXmlNodeInt,
    getXmlNodeText,
    KalturaClientPlugin,
    KalturaEnumsFactory,
    KalturaObjectBase,
    KalturaObjectFactory,
    KalturaParams,
    KalturaServiceBase,
)

API_VERSION = '18.4.0'

########## enums ##########
# @package Kaltura
# @subpackage Client
class KalturaAppTokenStatus(object):
    DISABLED = 1
    ACTIVE = 2
    DELETED = 3

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaAppearInListType(object):
    PARTNER_ONLY = 1
    CATEGORY_MEMBERS_ONLY = 3

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaAssetParamsDeletePolicy(object):
    KEEP = 0
    DELETE = 1

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaAssetParamsOrigin(object):
    CONVERT = 0
    INGEST = 1
    CONVERT_WHEN_MISSING = 2

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaBatchJobErrorTypes(object):
    APP = 0
    RUNTIME = 1
    HTTP = 2
    CURL = 3
    KALTURA_API = 4
    KALTURA_CLIENT = 5

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaBatchJobStatus(object):
    PENDING = 0
    QUEUED = 1
    PROCESSING = 2
    PROCESSED = 3
    MOVEFILE = 4
    FINISHED = 5
    FAILED = 6
    ABORTED = 7
    ALMOST_DONE = 8
    RETRY = 9
    FATAL = 10
    DONT_PROCESS = 11
    FINISHED_PARTIALLY = 12
    SUSPEND = 13
    SUSPEND_ALMOST_DONE = 14

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaBitRateMode(object):
    CBR = 1
    VBR = 2

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaCategoryEntryStatus(object):
    PENDING = 1
    ACTIVE = 2
    DELETED = 3
    REJECTED = 4

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaCategoryStatus(object):
    UPDATING = 1
    ACTIVE = 2
    DELETED = 3
    PURGED = 4

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaCategoryUserPermissionLevel(object):
    MANAGER = 0
    MODERATOR = 1
    CONTRIBUTOR = 2
    MEMBER = 3
    NONE = 4

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaCategoryUserStatus(object):
    ACTIVE = 1
    PENDING = 2
    NOT_ACTIVE = 3
    DELETED = 4

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaChinaCacheAlgorithmType(object):
    SHA1 = 1
    SHA256 = 2

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaCommercialUseType(object):
    NON_COMMERCIAL_USE = 0
    COMMERCIAL_USE = 1

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaContributionPolicyType(object):
    ALL = 1
    MEMBERS_WITH_CONTRIBUTION_PERMISSION = 2

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaControlPanelCommandStatus(object):
    PENDING = 1
    HANDLED = 2
    DONE = 3
    FAILED = 4

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaControlPanelCommandTargetType(object):
    DATA_CENTER = 1
    SCHEDULER = 2
    JOB_TYPE = 3
    JOB = 4
    BATCH = 5

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaControlPanelCommandType(object):
    KILL = 4

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaCountryRestrictionType(object):
    RESTRICT_COUNTRY_LIST = 0
    ALLOW_COUNTRY_LIST = 1

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaDVRStatus(object):
    DISABLED = 0
    ENABLED = 1

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaDeliveryStatus(object):
    ACTIVE = 0
    DELETED = 1
    STAGING_IN = 2
    STAGING_OUT = 3

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaDirectoryRestrictionType(object):
    DONT_DISPLAY = 0
    DISPLAY_WITH_LINK = 1

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaEditorType(object):
    SIMPLE = 1
    ADVANCED = 2

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaEffectType(object):
    VIDEO_FADE_IN = 1
    VIDEO_FADE_OUT = 2

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaEmailIngestionProfileStatus(object):
    INACTIVE = 0
    ACTIVE = 1

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaEntryDisplayInSearchType(object):
    SYSTEM = -1
    NONE = 0
    PARTNER_ONLY = 1
    KALTURA_NETWORK = 2

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaEntryModerationStatus(object):
    PENDING_MODERATION = 1
    APPROVED = 2
    REJECTED = 3
    DELETED = 4
    FLAGGED_FOR_REVIEW = 5
    AUTO_APPROVED = 6

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaEntryServerNodeRecordingStatus(object):
    STOPPED = 0
    ON_GOING = 1
    DONE = 2
    DISMISSED = 3

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaEntryServerNodeStatus(object):
    ERROR = -1
    STOPPED = 0
    PLAYABLE = 1
    BROADCASTING = 2
    AUTHENTICATED = 3
    MARKED_FOR_DELETION = 4
    TASK_PENDING = 5
    TASK_QUEUED = 6
    TASK_PROCESSING = 7
    TASK_UPLOADING = 8
    TASK_FINISHED = 9

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaFeatureStatusType(object):
    LOCK_CATEGORY = 1
    CATEGORY = 2
    CATEGORY_ENTRY = 3
    ENTRY = 4
    CATEGORY_USER = 5
    USER = 6

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaFlavorAssetStatus(object):
    ERROR = -1
    QUEUED = 0
    CONVERTING = 1
    READY = 2
    DELETED = 3
    NOT_APPLICABLE = 4
    TEMP = 5
    WAIT_FOR_CONVERT = 6
    IMPORTING = 7
    VALIDATING = 8
    EXPORTING = 9

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaFlavorReadyBehaviorType(object):
    NO_IMPACT = 0
    INHERIT_FLAVOR_PARAMS = 0
    REQUIRED = 1
    OPTIONAL = 2

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaGender(object):
    UNKNOWN = 0
    MALE = 1
    FEMALE = 2

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaGroupUserCreationMode(object):
    MANUAL = 1
    AUTOMATIC = 2

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaGroupUserRole(object):
    MEMBER = 1
    MANAGER = 2

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaGroupUserStatus(object):
    ACTIVE = 0
    DELETED = 1

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaInheritanceType(object):
    INHERIT = 1
    MANUAL = 2

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaIpAddressRestrictionType(object):
    RESTRICT_LIST = 0
    ALLOW_LIST = 1

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaLicenseType(object):
    UNKNOWN = -1
    NONE = 0
    COPYRIGHTED = 1
    PUBLIC_DOMAIN = 2
    CREATIVECOMMONS_ATTRIBUTION = 3
    CREATIVECOMMONS_ATTRIBUTION_SHARE_ALIKE = 4
    CREATIVECOMMONS_ATTRIBUTION_NO_DERIVATIVES = 5
    CREATIVECOMMONS_ATTRIBUTION_NON_COMMERCIAL = 6
    CREATIVECOMMONS_ATTRIBUTION_NON_COMMERCIAL_SHARE_ALIKE = 7
    CREATIVECOMMONS_ATTRIBUTION_NON_COMMERCIAL_NO_DERIVATIVES = 8
    GFDL = 9
    GPL = 10
    AFFERO_GPL = 11
    LGPL = 12
    BSD = 13
    APACHE = 14
    MOZILLA = 15

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaLimitFlavorsRestrictionType(object):
    RESTRICT_LIST = 0
    ALLOW_LIST = 1

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaLivePublishStatus(object):
    DISABLED = 0
    ENABLED = 1

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaLiveReportExportType(object):
    PARTNER_TOTAL_ALL = 1
    PARTNER_TOTAL_LIVE = 2
    ENTRY_TIME_LINE_ALL = 11
    ENTRY_TIME_LINE_LIVE = 12
    LOCATION_ALL = 21
    LOCATION_LIVE = 22
    SYNDICATION_ALL = 31
    SYNDICATION_LIVE = 32

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaLiveStatsEventType(object):
    LIVE = 1
    DVR = 2

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaLiveStreamBroadcastStatus(object):
    OFFLINE = 1
    PREVIEW = 2
    LIVE = 3

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaMailJobStatus(object):
    PENDING = 1
    SENT = 2
    ERROR = 3
    QUEUED = 4

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaMediaType(object):
    VIDEO = 1
    IMAGE = 2
    AUDIO = 5
    LIVE_STREAM_FLASH = 201
    LIVE_STREAM_WINDOWS_MEDIA = 202
    LIVE_STREAM_REAL_MEDIA = 203
    LIVE_STREAM_QUICKTIME = 204

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaModerationFlagType(object):
    SEXUAL_CONTENT = 1
    VIOLENT_REPULSIVE = 2
    HARMFUL_DANGEROUS = 3
    SPAM_COMMERCIALS = 4
    COPYRIGHT = 5
    TERMS_OF_USE_VIOLATION = 6

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaMrssExtensionMode(object):
    APPEND = 1
    REPLACE = 2

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaNotificationObjectType(object):
    ENTRY = 1
    KSHOW = 2
    USER = 3
    BATCH_JOB = 4

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaNotificationStatus(object):
    PENDING = 1
    SENT = 2
    ERROR = 3
    SHOULD_RESEND = 4
    ERROR_RESENDING = 5
    SENT_SYNCH = 6
    QUEUED = 7

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaNotificationType(object):
    ENTRY_ADD = 1
    ENTR_UPDATE_PERMISSIONS = 2
    ENTRY_DELETE = 3
    ENTRY_BLOCK = 4
    ENTRY_UPDATE = 5
    ENTRY_UPDATE_THUMBNAIL = 6
    ENTRY_UPDATE_MODERATION = 7
    USER_ADD = 21
    USER_BANNED = 26

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaNullableBoolean(object):
    NULL_VALUE = -1
    FALSE_VALUE = 0
    TRUE_VALUE = 1

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaPartnerAuthenticationType(object):
    PASSWORD_ONLY = 0
    TWO_FACTOR_AUTH = 1
    SSO = 2

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaPartnerGroupType(object):
    PUBLISHER = 1
    VAR_GROUP = 2
    GROUP = 3
    TEMPLATE = 4

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaPartnerStatus(object):
    DELETED = 0
    ACTIVE = 1
    BLOCKED = 2
    FULL_BLOCK = 3
    READ_ONLY = 4

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaPartnerType(object):
    KMC = 1
    WIKI = 100
    WORDPRESS = 101
    DRUPAL = 102
    DEKIWIKI = 103
    MOODLE = 104
    COMMUNITY_EDITION = 105
    JOOMLA = 106
    BLACKBOARD = 107
    SAKAI = 108
    ADMIN_CONSOLE = 109

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaPermissionStatus(object):
    ACTIVE = 1
    BLOCKED = 2
    DELETED = 3

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaPermissionType(object):
    NORMAL = 1
    SPECIAL_FEATURE = 2
    PLUGIN = 3
    PARTNER_GROUP = 4

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaPlaylistType(object):
    STATIC_LIST = 3
    DYNAMIC = 10
    EXTERNAL = 101
    PATH = 102

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaPrivacyType(object):
    ALL = 1
    AUTHENTICATED_USERS = 2
    MEMBERS_ONLY = 3

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaRecordStatus(object):
    DISABLED = 0
    APPENDED = 1
    PER_SESSION = 2

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaRecordingStatus(object):
    STOPPED = 0
    PAUSED = 1
    ACTIVE = 2
    DISABLED = 3

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaReportExportItemType(object):
    TABLE = 1
    TOTAL = 2
    GRAPH = 3

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaResponseProfileStatus(object):
    DISABLED = 1
    ENABLED = 2
    DELETED = 3

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaResponseProfileType(object):
    INCLUDE_FIELDS = 1
    EXCLUDE_FIELDS = 2

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaResponseType(object):
    RESPONSE_TYPE_JSON = 1
    RESPONSE_TYPE_XML = 2
    RESPONSE_TYPE_PHP = 3
    RESPONSE_TYPE_PHP_ARRAY = 4
    RESPONSE_TYPE_HTML = 7
    RESPONSE_TYPE_MRSS = 8
    RESPONSE_TYPE_JSONP = 9

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaSchedulerStatusType(object):
    RUNNING_BATCHES_COUNT = 1
    RUNNING_BATCHES_CPU = 2
    RUNNING_BATCHES_MEMORY = 3
    RUNNING_BATCHES_NETWORK = 4
    RUNNING_BATCHES_DISC_IO = 5
    RUNNING_BATCHES_DISC_SPACE = 6
    RUNNING_BATCHES_IS_RUNNING = 7
    RUNNING_BATCHES_LAST_EXECUTION_TIME = 8

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaSearchOperatorType(object):
    SEARCH_AND = 1
    SEARCH_OR = 2

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaSearchProviderType(object):
    FLICKR = 3
    YOUTUBE = 4
    MYSPACE = 7
    PHOTOBUCKET = 8
    JAMENDO = 9
    CCMIXTER = 10
    NYPL = 11
    CURRENT = 12
    MEDIA_COMMONS = 13
    KALTURA = 20
    KALTURA_USER_CLIPS = 21
    ARCHIVE_ORG = 22
    KALTURA_PARTNER = 23
    METACAFE = 24
    SEARCH_PROXY = 28
    PARTNER_SPECIFIC = 100

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaServerNodeStatus(object):
    ACTIVE = 1
    DISABLED = 2
    DELETED = 3
    NOT_REGISTERED = 4
    NOT_OPERATIONAL = 5

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaSessionType(object):
    USER = 0
    ADMIN = 2

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaSiteRestrictionType(object):
    RESTRICT_SITE_LIST = 0
    ALLOW_SITE_LIST = 1

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaStatsEventType(object):
    WIDGET_LOADED = 1
    MEDIA_LOADED = 2
    PLAY = 3
    PLAY_REACHED_25 = 4
    PLAY_REACHED_50 = 5
    PLAY_REACHED_75 = 6
    PLAY_REACHED_100 = 7
    OPEN_EDIT = 8
    OPEN_VIRAL = 9
    OPEN_DOWNLOAD = 10
    OPEN_REPORT = 11
    BUFFER_START = 12
    BUFFER_END = 13
    OPEN_FULL_SCREEN = 14
    CLOSE_FULL_SCREEN = 15
    REPLAY = 16
    SEEK = 17
    OPEN_UPLOAD = 18
    SAVE_PUBLISH = 19
    CLOSE_EDITOR = 20
    PRE_BUMPER_PLAYED = 21
    POST_BUMPER_PLAYED = 22
    BUMPER_CLICKED = 23
    PREROLL_STARTED = 24
    MIDROLL_STARTED = 25
    POSTROLL_STARTED = 26
    OVERLAY_STARTED = 27
    PREROLL_CLICKED = 28
    MIDROLL_CLICKED = 29
    POSTROLL_CLICKED = 30
    OVERLAY_CLICKED = 31
    PREROLL_25 = 32
    PREROLL_50 = 33
    PREROLL_75 = 34
    MIDROLL_25 = 35
    MIDROLL_50 = 36
    MIDROLL_75 = 37
    POSTROLL_25 = 38
    POSTROLL_50 = 39
    POSTROLL_75 = 40

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaStatsFeatureType(object):
    NONE = 0
    RELATED = 1

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaStatsKmcEventType(object):
    CONTENT_PAGE_VIEW = 1001
    CONTENT_ADD_PLAYLIST = 1010
    CONTENT_EDIT_PLAYLIST = 1011
    CONTENT_DELETE_PLAYLIST = 1012
    CONTENT_EDIT_ENTRY = 1013
    CONTENT_CHANGE_THUMBNAIL = 1014
    CONTENT_ADD_TAGS = 1015
    CONTENT_REMOVE_TAGS = 1016
    CONTENT_ADD_ADMIN_TAGS = 1017
    CONTENT_REMOVE_ADMIN_TAGS = 1018
    CONTENT_DOWNLOAD = 1019
    CONTENT_APPROVE_MODERATION = 1020
    CONTENT_REJECT_MODERATION = 1021
    CONTENT_BULK_UPLOAD = 1022
    CONTENT_ADMIN_KCW_UPLOAD = 1023
    ACCOUNT_CHANGE_PARTNER_INFO = 1030
    ACCOUNT_CHANGE_LOGIN_INFO = 1031
    ACCOUNT_CONTACT_US_USAGE = 1032
    ACCOUNT_UPDATE_SERVER_SETTINGS = 1033
    ACCOUNT_ACCOUNT_OVERVIEW = 1034
    ACCOUNT_ACCESS_CONTROL = 1035
    ACCOUNT_TRANSCODING_SETTINGS = 1036
    ACCOUNT_ACCOUNT_UPGRADE = 1037
    ACCOUNT_SAVE_SERVER_SETTINGS = 1038
    ACCOUNT_ACCESS_CONTROL_DELETE = 1039
    ACCOUNT_SAVE_TRANSCODING_SETTINGS = 1040
    LOGIN = 1041
    DASHBOARD_IMPORT_CONTENT = 1042
    DASHBOARD_UPDATE_CONTENT = 1043
    DASHBOARD_ACCOUNT_CONTACT_US = 1044
    DASHBOARD_VIEW_REPORTS = 1045
    DASHBOARD_EMBED_PLAYER = 1046
    DASHBOARD_EMBED_PLAYLIST = 1047
    DASHBOARD_CUSTOMIZE_PLAYERS = 1048
    APP_STUDIO_NEW_PLAYER_SINGLE_VIDEO = 1050
    APP_STUDIO_NEW_PLAYER_PLAYLIST = 1051
    APP_STUDIO_NEW_PLAYER_MULTI_TAB_PLAYLIST = 1052
    APP_STUDIO_EDIT_PLAYER_SINGLE_VIDEO = 1053
    APP_STUDIO_EDIT_PLAYER_PLAYLIST = 1054
    APP_STUDIO_EDIT_PLAYER_MULTI_TAB_PLAYLIST = 1055
    APP_STUDIO_DUPLICATE_PLAYER = 1056
    CONTENT_CONTENT_GO_TO_PAGE = 1057
    CONTENT_DELETE_ITEM = 1058
    CONTENT_DELETE_MIX = 1059
    REPORTS_AND_ANALYTICS_BANDWIDTH_USAGE_TAB = 1070
    REPORTS_AND_ANALYTICS_CONTENT_REPORTS_TAB = 1071
    REPORTS_AND_ANALYTICS_USERS_AND_COMMUNITY_REPORTS_TAB = 1072
    REPORTS_AND_ANALYTICS_TOP_CONTRIBUTORS = 1073
    REPORTS_AND_ANALYTICS_MAP_OVERLAYS = 1074
    REPORTS_AND_ANALYTICS_TOP_SYNDICATIONS = 1075
    REPORTS_AND_ANALYTICS_TOP_CONTENT = 1076
    REPORTS_AND_ANALYTICS_CONTENT_DROPOFF = 1077
    REPORTS_AND_ANALYTICS_CONTENT_INTERACTIONS = 1078
    REPORTS_AND_ANALYTICS_CONTENT_CONTRIBUTIONS = 1079
    REPORTS_AND_ANALYTICS_VIDEO_DRILL_DOWN = 1080
    REPORTS_AND_ANALYTICS_CONTENT_DRILL_DOWN_INTERACTION = 1081
    REPORTS_AND_ANALYTICS_CONTENT_CONTRIBUTIONS_DRILLDOWN = 1082
    REPORTS_AND_ANALYTICS_VIDEO_DRILL_DOWN_DROPOFF = 1083
    REPORTS_AND_ANALYTICS_MAP_OVERLAYS_DRILLDOWN = 1084
    REPORTS_AND_ANALYTICS_TOP_SYNDICATIONS_DRILL_DOWN = 1085
    REPORTS_AND_ANALYTICS_BANDWIDTH_USAGE_VIEW_MONTHLY = 1086
    REPORTS_AND_ANALYTICS_BANDWIDTH_USAGE_VIEW_YEARLY = 1087
    CONTENT_ENTRY_DRILLDOWN = 1088
    CONTENT_OPEN_PREVIEW_AND_EMBED = 1089

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaStorageProfileDeliveryStatus(object):
    ACTIVE = 1
    BLOCKED = 2

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaStorageProfileReadyBehavior(object):
    NO_IMPACT = 0
    REQUIRED = 1

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaStorageProfileStatus(object):
    DISABLED = 1
    AUTOMATIC = 2
    MANUAL = 3

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaSyndicationFeedStatus(object):
    DELETED = -1
    ACTIVE = 1

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaSyndicationFeedType(object):
    GOOGLE_VIDEO = 1
    YAHOO = 2
    ITUNES = 3
    TUBE_MOGUL = 4
    KALTURA = 5
    KALTURA_XSLT = 6
    ROKU_DIRECT_PUBLISHER = 7
    OPERA_TV_SNAP = 8

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaThumbAssetStatus(object):
    ERROR = -1
    QUEUED = 0
    CAPTURING = 1
    READY = 2
    DELETED = 3
    IMPORTING = 7
    EXPORTING = 9

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaThumbCropType(object):
    RESIZE = 1
    RESIZE_WITH_PADDING = 2
    CROP = 3
    CROP_FROM_TOP = 4
    RESIZE_WITH_FORCE = 5

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaTwoFactorAuthenticationMode(object):
    ALL = 0
    ADMIN_USERS_ONLY = 1
    NON_ADMIN_USERS_ONLY = 2

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaUiConfCreationMode(object):
    WIZARD = 2
    ADVANCED = 3

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaUiConfObjType(object):
    PLAYER = 1
    CONTRIBUTION_WIZARD = 2
    SIMPLE_EDITOR = 3
    ADVANCED_EDITOR = 4
    PLAYLIST = 5
    APP_STUDIO = 6
    KRECORD = 7
    PLAYER_V3 = 8
    KMC_ACCOUNT = 9
    KMC_ANALYTICS = 10
    KMC_CONTENT = 11
    KMC_DASHBOARD = 12
    KMC_LOGIN = 13
    PLAYER_SL = 14
    CLIENTSIDE_ENCODER = 15
    KMC_GENERAL = 16
    KMC_ROLES_AND_PERMISSIONS = 17
    CLIPPER = 18
    KSR = 19
    KUPLOAD = 20
    WEBCASTING = 21

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaUpdateMethodType(object):
    MANUAL = 0
    AUTOMATIC = 1

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaUploadErrorCode(object):
    NO_ERROR = 0
    GENERAL_ERROR = 1
    PARTIAL_UPLOAD = 2

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaUploadTokenStatus(object):
    PENDING = 0
    PARTIAL_UPLOAD = 1
    FULL_UPLOAD = 2
    CLOSED = 3
    TIMED_OUT = 4
    DELETED = 5

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaUserAgentRestrictionType(object):
    RESTRICT_LIST = 0
    ALLOW_LIST = 1

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaUserJoinPolicyType(object):
    AUTO_JOIN = 1
    REQUEST_TO_JOIN = 2
    NOT_ALLOWED = 3

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaUserMode(object):
    NONE = 0
    PROTECTED_USER = 1

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaUserRoleStatus(object):
    ACTIVE = 1
    BLOCKED = 2
    DELETED = 3

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaUserStatus(object):
    BLOCKED = 0
    ACTIVE = 1
    DELETED = 2

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaUserType(object):
    USER = 0
    GROUP = 1

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaViewMode(object):
    PREVIEW = 0
    ALLOW_ALL = 1

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaWidgetSecurityType(object):
    NONE = 1
    TIMEHASH = 2

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaAccessControlOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    CREATED_AT_DESC = "-createdAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaAccessControlProfileOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaAdminUserOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    ID_ASC = "+id"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    ID_DESC = "-id"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaAkamaiUniversalStreamType(object):
    HD_IPHONE_IPAD_LIVE = "HD iPhone/iPad Live"
    UNIVERSAL_STREAMING_LIVE = "Universal Streaming Live"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaAmazonS3StorageProfileFilesPermissionLevel(object):
    ACL_AUTHENTICATED_READ = "authenticated-read"
    ACL_PRIVATE = "private"
    ACL_PUBLIC_READ = "public-read"
    ACL_PUBLIC_READ_WRITE = "public-read-write"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaAmazonS3StorageProfileOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaApiActionPermissionItemOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    ID_ASC = "+id"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    ID_DESC = "-id"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaApiParameterPermissionItemAction(object):
    USAGE = "all"
    INSERT = "insert"
    READ = "read"
    UPDATE = "update"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaApiParameterPermissionItemOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    ID_ASC = "+id"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    ID_DESC = "-id"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaAppTokenHashType(object):
    MD5 = "MD5"
    SHA1 = "SHA1"
    SHA256 = "SHA256"
    SHA512 = "SHA512"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaAppTokenOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaAssetOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    DELETED_AT_ASC = "+deletedAt"
    SIZE_ASC = "+size"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    DELETED_AT_DESC = "-deletedAt"
    SIZE_DESC = "-size"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaAssetParamsOrderBy(object):

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaAssetParamsOutputOrderBy(object):

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaAssetType(object):
    ATTACHMENT = "attachment.Attachment"
    CAPTION = "caption.Caption"
    DOCUMENT = "document.Document"
    IMAGE = "document.Image"
    PDF = "document.PDF"
    SWF = "document.SWF"
    TIMED_THUMB_ASSET = "thumbCuePoint.timedThumb"
    TRANSCRIPT = "transcript.Transcript"
    WIDEVINE_FLAVOR = "widevine.WidevineFlavor"
    FLAVOR = "1"
    THUMBNAIL = "2"
    LIVE = "3"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaAudioCodec(object):
    NONE = ""
    AAC = "aac"
    AACHE = "aache"
    AC3 = "ac3"
    AMRNB = "amrnb"
    COPY = "copy"
    EAC3 = "eac3"
    MP3 = "mp3"
    MPEG2 = "mpeg2"
    PCM = "pcm"
    VORBIS = "vorbis"
    WMA = "wma"
    WMAPRO = "wmapro"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaBaseEntryCloneOptions(object):
    AD_CUE_POINTS = "adCuePoint.AD_CUE_POINTS"
    ANNOTATION_CUE_POINTS = "annotation.ANNOTATION_CUE_POINTS"
    CODE_CUE_POINTS = "codeCuePoint.CODE_CUE_POINTS"
    THUMB_CUE_POINTS = "thumbCuePoint.THUMB_CUE_POINTS"
    USERS = "1"
    CATEGORIES = "2"
    CHILD_ENTRIES = "3"
    ACCESS_CONTROL = "4"
    METADATA = "5"
    FLAVORS = "6"
    CAPTIONS = "7"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaBaseEntryCompareAttribute(object):
    ACCESS_CONTROL_ID = "accessControlId"
    CREATED_AT = "createdAt"
    END_DATE = "endDate"
    MODERATION_COUNT = "moderationCount"
    MODERATION_STATUS = "moderationStatus"
    PARTNER_ID = "partnerId"
    PARTNER_SORT_VALUE = "partnerSortValue"
    RANK = "rank"
    REPLACEMENT_STATUS = "replacementStatus"
    START_DATE = "startDate"
    STATUS = "status"
    TOTAL_RANK = "totalRank"
    TYPE = "type"
    UPDATED_AT = "updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaBaseEntryMatchAttribute(object):
    ADMIN_TAGS = "adminTags"
    CATEGORIES_IDS = "categoriesIds"
    CREATOR_ID = "creatorId"
    DESCRIPTION = "description"
    GROUP_ID = "groupId"
    ID = "id"
    NAME = "name"
    REFERENCE_ID = "referenceId"
    REPLACED_ENTRY_ID = "replacedEntryId"
    REPLACING_ENTRY_ID = "replacingEntryId"
    SEARCH_TEXT = "searchText"
    TAGS = "tags"
    USER_ID = "userId"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaBaseEntryOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    END_DATE_ASC = "+endDate"
    MODERATION_COUNT_ASC = "+moderationCount"
    NAME_ASC = "+name"
    PARTNER_SORT_VALUE_ASC = "+partnerSortValue"
    RANK_ASC = "+rank"
    RECENT_ASC = "+recent"
    START_DATE_ASC = "+startDate"
    TOTAL_RANK_ASC = "+totalRank"
    UPDATED_AT_ASC = "+updatedAt"
    WEIGHT_ASC = "+weight"
    CREATED_AT_DESC = "-createdAt"
    END_DATE_DESC = "-endDate"
    MODERATION_COUNT_DESC = "-moderationCount"
    NAME_DESC = "-name"
    PARTNER_SORT_VALUE_DESC = "-partnerSortValue"
    RANK_DESC = "-rank"
    RECENT_DESC = "-recent"
    START_DATE_DESC = "-startDate"
    TOTAL_RANK_DESC = "-totalRank"
    UPDATED_AT_DESC = "-updatedAt"
    WEIGHT_DESC = "-weight"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaBaseSyndicationFeedOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    NAME_ASC = "+name"
    PLAYLIST_ID_ASC = "+playlistId"
    TYPE_ASC = "+type"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    NAME_DESC = "-name"
    PLAYLIST_ID_DESC = "-playlistId"
    TYPE_DESC = "-type"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaBaseUserOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    ID_ASC = "+id"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    ID_DESC = "-id"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaBatchJobObjectType(object):
    ENTRY_DISTRIBUTION = "contentDistribution.EntryDistribution"
    DROP_FOLDER_FILE = "dropFolderXmlBulkUpload.DropFolderFile"
    METADATA = "metadata.Metadata"
    METADATA_PROFILE = "metadata.MetadataProfile"
    SCHEDULED_TASK_PROFILE = "scheduledTask.ScheduledTaskProfile"
    ENTRY = "1"
    CATEGORY = "2"
    FILE_SYNC = "3"
    ASSET = "4"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaBatchJobOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    ESTIMATED_EFFORT_ASC = "+estimatedEffort"
    EXECUTION_ATTEMPTS_ASC = "+executionAttempts"
    FINISH_TIME_ASC = "+finishTime"
    LOCK_VERSION_ASC = "+lockVersion"
    PRIORITY_ASC = "+priority"
    QUEUE_TIME_ASC = "+queueTime"
    STATUS_ASC = "+status"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    ESTIMATED_EFFORT_DESC = "-estimatedEffort"
    EXECUTION_ATTEMPTS_DESC = "-executionAttempts"
    FINISH_TIME_DESC = "-finishTime"
    LOCK_VERSION_DESC = "-lockVersion"
    PRIORITY_DESC = "-priority"
    QUEUE_TIME_DESC = "-queueTime"
    STATUS_DESC = "-status"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaBatchJobType(object):
    CONVERT = "0"
    CONVERT_CAPTION_ASSET = "caption.convertcaptionasset"
    PARSE_MULTI_LANGUAGE_CAPTION_ASSET = "caption.parsemultilanguagecaptionasset"
    PARSE_CAPTION_ASSET = "captionSearch.parseCaptionAsset"
    DISTRIBUTION_DELETE = "contentDistribution.DistributionDelete"
    DISTRIBUTION_DISABLE = "contentDistribution.DistributionDisable"
    DISTRIBUTION_ENABLE = "contentDistribution.DistributionEnable"
    DISTRIBUTION_FETCH_REPORT = "contentDistribution.DistributionFetchReport"
    DISTRIBUTION_SUBMIT = "contentDistribution.DistributionSubmit"
    DISTRIBUTION_SYNC = "contentDistribution.DistributionSync"
    DISTRIBUTION_UPDATE = "contentDistribution.DistributionUpdate"
    DROP_FOLDER_CONTENT_PROCESSOR = "dropFolder.DropFolderContentProcessor"
    DROP_FOLDER_WATCHER = "dropFolder.DropFolderWatcher"
    EVENT_NOTIFICATION_HANDLER = "eventNotification.EventNotificationHandler"
    INTEGRATION = "integration.Integration"
    ENTRY_VENDOR_TASK_CSV = "reach.EntryVendorTasksCsv"
    SYNC_REACH_CREDIT_TASK = "reach.SyncReachCreditTask"
    SCHEDULED_TASK = "scheduledTask.ScheduledTask"
    INDEX_TAGS = "tagSearch.IndexTagsByPrivacyContext"
    TAG_RESOLVE = "tagSearch.TagResolve"
    VIRUS_SCAN = "virusScan.VirusScan"
    WIDEVINE_REPOSITORY_SYNC = "widevine.WidevineRepositorySync"
    IMPORT = "1"
    DELETE = "2"
    FLATTEN = "3"
    BULKUPLOAD = "4"
    DVDCREATOR = "5"
    DOWNLOAD = "6"
    OOCONVERT = "7"
    CONVERT_PROFILE = "10"
    POSTCONVERT = "11"
    EXTRACT_MEDIA = "14"
    MAIL = "15"
    NOTIFICATION = "16"
    CLEANUP = "17"
    SCHEDULER_HELPER = "18"
    BULKDOWNLOAD = "19"
    DB_CLEANUP = "20"
    PROVISION_PROVIDE = "21"
    CONVERT_COLLECTION = "22"
    STORAGE_EXPORT = "23"
    PROVISION_DELETE = "24"
    STORAGE_DELETE = "25"
    EMAIL_INGESTION = "26"
    METADATA_IMPORT = "27"
    METADATA_TRANSFORM = "28"
    FILESYNC_IMPORT = "29"
    CAPTURE_THUMB = "30"
    DELETE_FILE = "31"
    INDEX = "32"
    MOVE_CATEGORY_ENTRIES = "33"
    COPY = "34"
    CONCAT = "35"
    CONVERT_LIVE_SEGMENT = "36"
    COPY_PARTNER = "37"
    VALIDATE_LIVE_MEDIA_SERVERS = "38"
    SYNC_CATEGORY_PRIVACY_CONTEXT = "39"
    LIVE_REPORT_EXPORT = "40"
    RECALCULATE_CACHE = "41"
    LIVE_TO_VOD = "42"
    COPY_CAPTIONS = "43"
    CHUNKED_ENCODE_JOB_SCHEDULER = "44"
    SERVER_NODE_MONITOR = "45"
    USERS_CSV = "46"
    CLIP_CONCAT = "47"
    COPY_CUE_POINTS = "48"
    EXPORT_CSV = "49"
    REPORT_EXPORT = "50"
    LIVE_ENTRY_ARCHIVE = "51"
    STORAGE_UPDATE = "52"
    STORAGE_PERIODIC_EXPORT = "53"
    STORAGE_PERIODIC_PURGE = "54"
    STORAGE_PERIODIC_DELETE_LOCAL = "55"
    REACH_JOB_CLEANER = "56"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaBulkUploadAction(object):
    CANCEL = "scheduleBulkUpload.CANCEL"
    ADD = "1"
    UPDATE = "2"
    DELETE = "3"
    REPLACE = "4"
    TRANSFORM_XSLT = "5"
    ADD_OR_UPDATE = "6"
    ACTIVATE = "7"
    REJECT = "8"
    UPDATE_STATUS = "9"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaBulkUploadObjectType(object):
    JOB = "bulkUploadFilter.JOB"
    SCHEDULE_EVENT = "scheduleBulkUpload.SCHEDULE_EVENT"
    SCHEDULE_RESOURCE = "scheduleBulkUpload.SCHEDULE_RESOURCE"
    ENTRY = "1"
    CATEGORY = "2"
    USER = "3"
    CATEGORY_USER = "4"
    CATEGORY_ENTRY = "5"
    USER_ENTRY = "6"
    VENDOR_CATALOG_ITEM = "7"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaBulkUploadOrderBy(object):

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaBulkUploadResultStatus(object):
    ERROR = "1"
    OK = "2"
    IN_PROGRESS = "3"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaBulkUploadType(object):
    CSV = "bulkUploadCsv.CSV"
    FILTER = "bulkUploadFilter.FILTER"
    XML = "bulkUploadXml.XML"
    DROP_FOLDER_XML = "dropFolderXmlBulkUpload.DROP_FOLDER_XML"
    ICAL = "scheduleBulkUpload.ICAL"
    DROP_FOLDER_ICAL = "scheduleDropFolder.DROP_FOLDER_ICAL"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaCategoryEntryAdvancedOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    CREATED_AT_DESC = "-createdAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaCategoryEntryOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    CREATED_AT_DESC = "-createdAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaCategoryIdentifierField(object):
    FULL_NAME = "fullName"
    ID = "id"
    REFERENCE_ID = "referenceId"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaCategoryOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    DEPTH_ASC = "+depth"
    DIRECT_ENTRIES_COUNT_ASC = "+directEntriesCount"
    DIRECT_SUB_CATEGORIES_COUNT_ASC = "+directSubCategoriesCount"
    ENTRIES_COUNT_ASC = "+entriesCount"
    FULL_NAME_ASC = "+fullName"
    MEMBERS_COUNT_ASC = "+membersCount"
    NAME_ASC = "+name"
    PARTNER_SORT_VALUE_ASC = "+partnerSortValue"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    DEPTH_DESC = "-depth"
    DIRECT_ENTRIES_COUNT_DESC = "-directEntriesCount"
    DIRECT_SUB_CATEGORIES_COUNT_DESC = "-directSubCategoriesCount"
    ENTRIES_COUNT_DESC = "-entriesCount"
    FULL_NAME_DESC = "-fullName"
    MEMBERS_COUNT_DESC = "-membersCount"
    NAME_DESC = "-name"
    PARTNER_SORT_VALUE_DESC = "-partnerSortValue"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaCategoryUserOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaCloneComponentSelectorType(object):
    INCLUDE_COMPONENT = "0"
    EXCLUDE_COMPONENT = "1"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaConditionType(object):
    EVENT_NOTIFICATION_FIELD = "eventNotification.BooleanField"
    EVENT_NOTIFICATION_OBJECT_CHANGED = "eventNotification.ObjectChanged"
    METADATA_FIELD_CHANGED = "metadata.FieldChanged"
    METADATA_FIELD_COMPARE = "metadata.FieldCompare"
    METADATA_FIELD_MATCH = "metadata.FieldMatch"
    EVENT_CATEGORY_ENTRY = "reach.CategoryEntry"
    AUTHENTICATED = "1"
    COUNTRY = "2"
    IP_ADDRESS = "3"
    SITE = "4"
    USER_AGENT = "5"
    FIELD_MATCH = "6"
    FIELD_COMPARE = "7"
    ASSET_PROPERTIES_COMPARE = "8"
    USER_ROLE = "9"
    GEO_DISTANCE = "10"
    OR_OPERATOR = "11"
    HASH = "12"
    DELIVERY_PROFILE = "13"
    ACTIVE_EDGE_VALIDATE = "14"
    ANONYMOUS_IP = "15"
    ASSET_TYPE = "16"
    BOOLEAN = "17"
    HTTP_HEADER = "18"
    ENTRY_SCHEDULED = "19"
    ACTION_NAME = "20"
    URL_AUTH_PARAMS = "21"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaConfMapsSourceLocation(object):
    FS = "FileSystem"
    DB = "database"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaContainerFormat(object):
    _3GP = "3gp"
    APPLEHTTP = "applehttp"
    AVI = "avi"
    BIF = "bif"
    BMP = "bmp"
    COPY = "copy"
    FLV = "flv"
    HLS = "hls"
    ISMA = "isma"
    ISMV = "ismv"
    JPG = "jpg"
    M2TS = "m2ts"
    M4V = "m4v"
    MKV = "mkv"
    MOV = "mov"
    MP3 = "mp3"
    MP4 = "mp4"
    MPEG = "mpeg"
    MPEGTS = "mpegts"
    MXF = "mxf"
    OGG = "ogg"
    OGV = "ogv"
    PDF = "pdf"
    PNG = "png"
    SWF = "swf"
    WAV = "wav"
    WEBM = "webm"
    WMA = "wma"
    WMV = "wmv"
    WVM = "wvm"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaContextType(object):
    PLAY = "1"
    DOWNLOAD = "2"
    THUMBNAIL = "3"
    METADATA = "4"
    EXPORT = "5"
    SERVE = "6"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaControlPanelCommandOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaConversionProfileAssetParamsOrderBy(object):

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaConversionProfileOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    CREATED_AT_DESC = "-createdAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaConversionProfileStatus(object):
    DISABLED = "1"
    ENABLED = "2"
    DELETED = "3"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaConversionProfileType(object):
    MEDIA = "1"
    LIVE_STREAM = "2"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaDataEntryCompareAttribute(object):
    ACCESS_CONTROL_ID = "accessControlId"
    CREATED_AT = "createdAt"
    END_DATE = "endDate"
    MODERATION_COUNT = "moderationCount"
    MODERATION_STATUS = "moderationStatus"
    PARTNER_ID = "partnerId"
    PARTNER_SORT_VALUE = "partnerSortValue"
    RANK = "rank"
    REPLACEMENT_STATUS = "replacementStatus"
    START_DATE = "startDate"
    STATUS = "status"
    TOTAL_RANK = "totalRank"
    TYPE = "type"
    UPDATED_AT = "updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaDataEntryMatchAttribute(object):
    ADMIN_TAGS = "adminTags"
    CATEGORIES_IDS = "categoriesIds"
    CREATOR_ID = "creatorId"
    DESCRIPTION = "description"
    GROUP_ID = "groupId"
    ID = "id"
    NAME = "name"
    REFERENCE_ID = "referenceId"
    REPLACED_ENTRY_ID = "replacedEntryId"
    REPLACING_ENTRY_ID = "replacingEntryId"
    SEARCH_TEXT = "searchText"
    TAGS = "tags"
    USER_ID = "userId"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaDataEntryOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    END_DATE_ASC = "+endDate"
    MODERATION_COUNT_ASC = "+moderationCount"
    NAME_ASC = "+name"
    PARTNER_SORT_VALUE_ASC = "+partnerSortValue"
    RANK_ASC = "+rank"
    RECENT_ASC = "+recent"
    START_DATE_ASC = "+startDate"
    TOTAL_RANK_ASC = "+totalRank"
    UPDATED_AT_ASC = "+updatedAt"
    WEIGHT_ASC = "+weight"
    CREATED_AT_DESC = "-createdAt"
    END_DATE_DESC = "-endDate"
    MODERATION_COUNT_DESC = "-moderationCount"
    NAME_DESC = "-name"
    PARTNER_SORT_VALUE_DESC = "-partnerSortValue"
    RANK_DESC = "-rank"
    RECENT_DESC = "-recent"
    START_DATE_DESC = "-startDate"
    TOTAL_RANK_DESC = "-totalRank"
    UPDATED_AT_DESC = "-updatedAt"
    WEIGHT_DESC = "-weight"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaDeliveryProfileAkamaiAppleHttpManifestOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaDeliveryProfileAkamaiHdsOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaDeliveryProfileAkamaiHttpOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaDeliveryProfileGenericAppleHttpOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaDeliveryProfileGenericHdsOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaDeliveryProfileGenericHttpOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaDeliveryProfileGenericRtmpOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaDeliveryProfileGenericSilverLightOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaDeliveryProfileLiveAppleHttpOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaDeliveryProfileOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaDeliveryProfileRtmpOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaDeliveryProfileType(object):
    EDGE_CAST_HTTP = "edgeCast.EDGE_CAST_HTTP"
    EDGE_CAST_RTMP = "edgeCast.EDGE_CAST_RTMP"
    KONTIKI_HTTP = "kontiki.KONTIKI_HTTP"
    VELOCIX_HDS = "velocix.VELOCIX_HDS"
    VELOCIX_HLS = "velocix.VELOCIX_HLS"
    APPLE_HTTP = "1"
    HDS = "3"
    HTTP = "4"
    RTMP = "5"
    RTSP = "6"
    SILVER_LIGHT = "7"
    AKAMAI_HLS_DIRECT = "10"
    AKAMAI_HLS_MANIFEST = "11"
    AKAMAI_HD = "12"
    AKAMAI_HDS = "13"
    AKAMAI_HTTP = "14"
    AKAMAI_RTMP = "15"
    AKAMAI_RTSP = "16"
    AKAMAI_SS = "17"
    GENERIC_HLS = "21"
    GENERIC_HDS = "23"
    GENERIC_HTTP = "24"
    GENERIC_HLS_MANIFEST = "25"
    GENERIC_HDS_MANIFEST = "26"
    GENERIC_SS = "27"
    GENERIC_RTMP = "28"
    LEVEL3_HLS = "31"
    LEVEL3_HTTP = "34"
    LEVEL3_RTMP = "35"
    LIMELIGHT_HTTP = "44"
    LIMELIGHT_RTMP = "45"
    LOCAL_PATH_APPLE_HTTP = "51"
    LOCAL_PATH_HDS = "53"
    LOCAL_PATH_HTTP = "54"
    LOCAL_PATH_RTMP = "55"
    VOD_PACKAGER_HLS = "61"
    VOD_PACKAGER_HDS = "63"
    VOD_PACKAGER_MSS = "67"
    VOD_PACKAGER_DASH = "68"
    VOD_PACKAGER_HLS_MANIFEST = "69"
    LIVE_HLS = "1001"
    LIVE_HDS = "1002"
    LIVE_DASH = "1003"
    LIVE_RTMP = "1005"
    LIVE_HLS_TO_MULTICAST = "1006"
    LIVE_PACKAGER_HLS = "1007"
    LIVE_PACKAGER_HDS = "1008"
    LIVE_PACKAGER_DASH = "1009"
    LIVE_PACKAGER_MSS = "1010"
    LIVE_AKAMAI_HDS = "1013"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaDeliveryServerNodeOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    HEARTBEAT_TIME_ASC = "+heartbeatTime"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    HEARTBEAT_TIME_DESC = "-heartbeatTime"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaDocumentEntryCompareAttribute(object):
    ACCESS_CONTROL_ID = "accessControlId"
    CREATED_AT = "createdAt"
    END_DATE = "endDate"
    MODERATION_COUNT = "moderationCount"
    MODERATION_STATUS = "moderationStatus"
    PARTNER_ID = "partnerId"
    PARTNER_SORT_VALUE = "partnerSortValue"
    RANK = "rank"
    REPLACEMENT_STATUS = "replacementStatus"
    START_DATE = "startDate"
    STATUS = "status"
    TOTAL_RANK = "totalRank"
    TYPE = "type"
    UPDATED_AT = "updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaDocumentEntryMatchAttribute(object):
    ADMIN_TAGS = "adminTags"
    CATEGORIES_IDS = "categoriesIds"
    CREATOR_ID = "creatorId"
    DESCRIPTION = "description"
    GROUP_ID = "groupId"
    ID = "id"
    NAME = "name"
    REFERENCE_ID = "referenceId"
    REPLACED_ENTRY_ID = "replacedEntryId"
    REPLACING_ENTRY_ID = "replacingEntryId"
    SEARCH_TEXT = "searchText"
    TAGS = "tags"
    USER_ID = "userId"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaDrmSchemeName(object):
    PLAYREADY_CENC = "drm.PLAYREADY_CENC"
    WIDEVINE_CENC = "drm.WIDEVINE_CENC"
    FAIRPLAY = "fairplay.FAIRPLAY"
    PLAYREADY = "playReady.PLAYREADY"
    WIDEVINE = "widevine.WIDEVINE"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaDurationType(object):
    LONG = "long"
    MEDIUM = "medium"
    NOT_AVAILABLE = "notavailable"
    SHORT = "short"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaESearchLanguage(object):
    ARABIC = "Arabic"
    BASQUE = "Basque"
    BRAZILIAN = "Brazilian"
    BULGARIAN = "Bulgarian"
    CATALAN = "Catalan"
    CHINESE = "Chinese"
    CZECH = "Czech"
    DANISH = "Danish"
    DUTCH = "Dutch"
    ENGLISH = "English"
    FINNISH = "Finnish"
    FRENCH = "French"
    GALICIAN = "Galician"
    GERMAN = "German"
    GREEK = "Greek"
    HINDI = "Hindi"
    HUNGRIAN = "Hungarian"
    INDONESIAN = "Indonesian"
    ITALIAN = "Italian"
    JAPANESE = "Japanese"
    KOREAN = "Korean"
    LATVIAN = "Latvian"
    LITHUANIAN = "Lithuanian"
    NORWEGIAN = "Norwegian"
    PERSIAN = "Persian"
    PORTUGUESE = "Prtuguese"
    ROMANIAN = "Romanian"
    RUSSIAN = "Russian"
    SORANI = "Sorani"
    SPANISH = "Spanish"
    SWEDISH = "Swedish"
    THAI = "Thai"
    TURKISH = "Turkish"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaEdgeServerNodeOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    HEARTBEAT_TIME_ASC = "+heartbeatTime"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    HEARTBEAT_TIME_DESC = "-heartbeatTime"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaEntryApplication(object):
    KMC = "0"
    KMS = "1"
    KAF = "2"
    PITCH = "3"
    KMS_GO = "4"
    WEBCAST_APP = "5"
    PERSONAL_CAPTURE = "6"
    KALTURA_MEETING = "7"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaEntryIdentifierField(object):
    ID = "id"
    REFERENCE_ID = "referenceId"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaEntryReplacementStatus(object):
    NONE = "0"
    APPROVED_BUT_NOT_READY = "1"
    READY_BUT_NOT_APPROVED = "2"
    NOT_READY_AND_NOT_APPROVED = "3"
    FAILED = "4"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaEntryServerNodeOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaEntryServerNodeType(object):
    LIVE_PRIMARY = "0"
    LIVE_BACKUP = "1"
    LIVE_CLIPPING_TASK = "2"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaEntryStatus(object):
    ERROR_IMPORTING = "-2"
    ERROR_CONVERTING = "-1"
    IMPORT = "0"
    INFECTED = "virusScan.Infected"
    SCAN_FAILURE = "virusScan.ScanFailure"
    PRECONVERT = "1"
    READY = "2"
    DELETED = "3"
    PENDING = "4"
    MODERATE = "5"
    BLOCKED = "6"
    NO_CONTENT = "7"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaEntryType(object):
    AUTOMATIC = "-1"
    CONFERENCE_ENTRY_SERVER = "conference.CONFERENCE_ENTRY_SERVER"
    EXTERNAL_MEDIA = "externalMedia.externalMedia"
    SIP_ENTRY_SERVER = "sip.SIP_ENTRY_SERVER"
    MEDIA_CLIP = "1"
    MIX = "2"
    PLAYLIST = "5"
    DATA = "6"
    LIVE_STREAM = "7"
    LIVE_CHANNEL = "8"
    DOCUMENT = "10"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaExternalMediaEntryCompareAttribute(object):
    ACCESS_CONTROL_ID = "accessControlId"
    CREATED_AT = "createdAt"
    END_DATE = "endDate"
    LAST_PLAYED_AT = "lastPlayedAt"
    MEDIA_DATE = "mediaDate"
    MEDIA_TYPE = "mediaType"
    MODERATION_COUNT = "moderationCount"
    MODERATION_STATUS = "moderationStatus"
    MS_DURATION = "msDuration"
    PARTNER_ID = "partnerId"
    PARTNER_SORT_VALUE = "partnerSortValue"
    PLAYS = "plays"
    RANK = "rank"
    REPLACEMENT_STATUS = "replacementStatus"
    START_DATE = "startDate"
    STATUS = "status"
    TOTAL_RANK = "totalRank"
    TYPE = "type"
    UPDATED_AT = "updatedAt"
    VIEWS = "views"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaExternalMediaEntryMatchAttribute(object):
    ADMIN_TAGS = "adminTags"
    CATEGORIES_IDS = "categoriesIds"
    CREATOR_ID = "creatorId"
    DESCRIPTION = "description"
    DURATION_TYPE = "durationType"
    FLAVOR_PARAMS_IDS = "flavorParamsIds"
    GROUP_ID = "groupId"
    ID = "id"
    NAME = "name"
    REFERENCE_ID = "referenceId"
    REPLACED_ENTRY_ID = "replacedEntryId"
    REPLACING_ENTRY_ID = "replacingEntryId"
    SEARCH_TEXT = "searchText"
    TAGS = "tags"
    USER_ID = "userId"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaFileAssetObjectType(object):
    UI_CONF = "2"
    ENTRY = "3"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaFileAssetOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaFileAssetStatus(object):
    PENDING = "0"
    UPLOADING = "1"
    READY = "2"
    DELETED = "3"
    ERROR = "4"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaFileSyncObjectType(object):
    DISTRIBUTION_PROFILE = "contentDistribution.DistributionProfile"
    ENTRY_DISTRIBUTION = "contentDistribution.EntryDistribution"
    GENERIC_DISTRIBUTION_ACTION = "contentDistribution.GenericDistributionAction"
    EMAIL_NOTIFICATION_TEMPLATE = "emailNotification.EmailNotificationTemplate"
    HTTP_NOTIFICATION_TEMPLATE = "httpNotification.HttpNotificationTemplate"
    ENTRY = "1"
    UICONF = "2"
    BATCHJOB = "3"
    ASSET = "4"
    FLAVOR_ASSET = "4"
    METADATA = "5"
    METADATA_PROFILE = "6"
    SYNDICATION_FEED = "7"
    CONVERSION_PROFILE = "8"
    FILE_ASSET = "9"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaFlavorAssetOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    DELETED_AT_ASC = "+deletedAt"
    SIZE_ASC = "+size"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    DELETED_AT_DESC = "-deletedAt"
    SIZE_DESC = "-size"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaFlavorParamsOrderBy(object):

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaFlavorParamsOutputOrderBy(object):

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaGenericSyndicationFeedOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    NAME_ASC = "+name"
    PLAYLIST_ID_ASC = "+playlistId"
    TYPE_ASC = "+type"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    NAME_DESC = "-name"
    PLAYLIST_ID_DESC = "-playlistId"
    TYPE_DESC = "-type"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaGenericXsltSyndicationFeedOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    NAME_ASC = "+name"
    PLAYLIST_ID_ASC = "+playlistId"
    TYPE_ASC = "+type"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    NAME_DESC = "-name"
    PLAYLIST_ID_DESC = "-playlistId"
    TYPE_DESC = "-type"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaGeoCoderType(object):
    KALTURA = "1"
    MAX_MIND = "2"
    DIGITAL_ELEMENT = "3"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaGoogleSyndicationFeedAdultValues(object):
    NO = "No"
    YES = "Yes"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaGoogleVideoSyndicationFeedOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    NAME_ASC = "+name"
    PLAYLIST_ID_ASC = "+playlistId"
    TYPE_ASC = "+type"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    NAME_DESC = "-name"
    PLAYLIST_ID_DESC = "-playlistId"
    TYPE_DESC = "-type"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaGroupUserOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaITunesSyndicationFeedAdultValues(object):
    CLEAN = "clean"
    NO = "no"
    YES = "yes"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaITunesSyndicationFeedCategories(object):
    ARTS = "Arts"
    ARTS_DESIGN = "Arts/Design"
    ARTS_FASHION_BEAUTY = "Arts/Fashion &amp; Beauty"
    ARTS_FOOD = "Arts/Food"
    ARTS_LITERATURE = "Arts/Literature"
    ARTS_PERFORMING_ARTS = "Arts/Performing Arts"
    ARTS_VISUAL_ARTS = "Arts/Visual Arts"
    BUSINESS = "Business"
    BUSINESS_BUSINESS_NEWS = "Business/Business News"
    BUSINESS_CAREERS = "Business/Careers"
    BUSINESS_INVESTING = "Business/Investing"
    BUSINESS_MANAGEMENT_MARKETING = "Business/Management &amp; Marketing"
    BUSINESS_SHOPPING = "Business/Shopping"
    COMEDY = "Comedy"
    EDUCATION = "Education"
    EDUCATION_TECHNOLOGY = "Education/Education Technology"
    EDUCATION_HIGHER_EDUCATION = "Education/Higher Education"
    EDUCATION_K_12 = "Education/K-12"
    EDUCATION_LANGUAGE_COURSES = "Education/Language Courses"
    EDUCATION_TRAINING = "Education/Training"
    GAMES_HOBBIES = "Games &amp; Hobbies"
    GAMES_HOBBIES_AUTOMOTIVE = "Games &amp; Hobbies/Automotive"
    GAMES_HOBBIES_AVIATION = "Games &amp; Hobbies/Aviation"
    GAMES_HOBBIES_HOBBIES = "Games &amp; Hobbies/Hobbies"
    GAMES_HOBBIES_OTHER_GAMES = "Games &amp; Hobbies/Other Games"
    GAMES_HOBBIES_VIDEO_GAMES = "Games &amp; Hobbies/Video Games"
    GOVERNMENT_ORGANIZATIONS = "Government &amp; Organizations"
    GOVERNMENT_ORGANIZATIONS_LOCAL = "Government &amp; Organizations/Local"
    GOVERNMENT_ORGANIZATIONS_NATIONAL = "Government &amp; Organizations/National"
    GOVERNMENT_ORGANIZATIONS_NON_PROFIT = "Government &amp; Organizations/Non-Profit"
    GOVERNMENT_ORGANIZATIONS_REGIONAL = "Government &amp; Organizations/Regional"
    HEALTH = "Health"
    HEALTH_ALTERNATIVE_HEALTH = "Health/Alternative Health"
    HEALTH_FITNESS_NUTRITION = "Health/Fitness &amp; Nutrition"
    HEALTH_SELF_HELP = "Health/Self-Help"
    HEALTH_SEXUALITY = "Health/Sexuality"
    KIDS_FAMILY = "Kids &amp; Family"
    MUSIC = "Music"
    NEWS_POLITICS = "News &amp; Politics"
    RELIGION_SPIRITUALITY = "Religion &amp; Spirituality"
    RELIGION_SPIRITUALITY_BUDDHISM = "Religion &amp; Spirituality/Buddhism"
    RELIGION_SPIRITUALITY_CHRISTIANITY = "Religion &amp; Spirituality/Christianity"
    RELIGION_SPIRITUALITY_HINDUISM = "Religion &amp; Spirituality/Hinduism"
    RELIGION_SPIRITUALITY_ISLAM = "Religion &amp; Spirituality/Islam"
    RELIGION_SPIRITUALITY_JUDAISM = "Religion &amp; Spirituality/Judaism"
    RELIGION_SPIRITUALITY_OTHER = "Religion &amp; Spirituality/Other"
    RELIGION_SPIRITUALITY_SPIRITUALITY = "Religion &amp; Spirituality/Spirituality"
    SCIENCE_MEDICINE = "Science &amp; Medicine"
    SCIENCE_MEDICINE_MEDICINE = "Science &amp; Medicine/Medicine"
    SCIENCE_MEDICINE_NATURAL_SCIENCES = "Science &amp; Medicine/Natural Sciences"
    SCIENCE_MEDICINE_SOCIAL_SCIENCES = "Science &amp; Medicine/Social Sciences"
    SOCIETY_CULTURE = "Society &amp; Culture"
    SOCIETY_CULTURE_HISTORY = "Society &amp; Culture/History"
    SOCIETY_CULTURE_PERSONAL_JOURNALS = "Society &amp; Culture/Personal Journals"
    SOCIETY_CULTURE_PHILOSOPHY = "Society &amp; Culture/Philosophy"
    SOCIETY_CULTURE_PLACES_TRAVEL = "Society &amp; Culture/Places &amp; Travel"
    SPORTS_RECREATION = "Sports &amp; Recreation"
    SPORTS_RECREATION_AMATEUR = "Sports &amp; Recreation/Amateur"
    SPORTS_RECREATION_COLLEGE_HIGH_SCHOOL = "Sports &amp; Recreation/College &amp; High School"
    SPORTS_RECREATION_OUTDOOR = "Sports &amp; Recreation/Outdoor"
    SPORTS_RECREATION_PROFESSIONAL = "Sports &amp; Recreation/Professional"
    TV_FILM = "TV &amp; Film"
    TECHNOLOGY = "Technology"
    TECHNOLOGY_GADGETS = "Technology/Gadgets"
    TECHNOLOGY_PODCASTING = "Technology/Podcasting"
    TECHNOLOGY_SOFTWARE_HOW_TO = "Technology/Software How-To"
    TECHNOLOGY_TECH_NEWS = "Technology/Tech News"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaITunesSyndicationFeedOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    NAME_ASC = "+name"
    PLAYLIST_ID_ASC = "+playlistId"
    TYPE_ASC = "+type"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    NAME_DESC = "-name"
    PLAYLIST_ID_DESC = "-playlistId"
    TYPE_DESC = "-type"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaLanguage(object):
    ABQ = "Abaza"
    AB = "Abkhazian"
    ABE = "Abnaki Western"
    ABU = "Abure"
    ACN = "Achang"
    ACE = "Achinese"
    ACT = "Achterhooks"
    ACV = "Achumawi"
    ADJ = "Adioukrou"
    ADY = "Adyghe; Adygei"
    ADT = "Adynyamathanha"
    AAL = "Afade"
    AA = "Afar"
    AF = "Afrikaans"
    AGQ = "Aghem"
    AGX = "Aghul"
    AGU = "Aguacateco"
    AGR = "Aguaruna"
    AIN = "Ainu (Japan)"
    AKK = "Akkadian"
    AKL = "Aklanon"
    AKU = "Akum"
    AKZ = "Alabama"
    SQ = "Albanian"
    ALN = "Albanian (Gheg)"
    ALS = "Albanian (Tosk)"
    ALE = "Aleut"
    ALG = "Algonquian languages"
    ALQ = "Algonquin"
    ALT = "Altai (Southern)"
    AM = "Amharic"
    RME = "Angloromani"
    APJ = "Apache (Jicarilla)"
    APW = "Apache (Western)"
    AR = "Arabic"
    ARB = "Arabic (standard)"
    B_T = "Arabic Tunisian Spoken"
    ARC = "Aramaic"
    SAM = "Aramaic Samaritan"
    ARP = "Arapaho"
    ARN = "Araucanian"
    ARI = "Arikara"
    HY = "Armenian"
    RUP = "Aromanian"
    AS_ = "Assamese"
    ASB = "Assiniboine"
    AII = "Assyrian Neo-Aramaic"
    AST = "Asturian"
    ATH = "Athapascan languages"
    ATJ = "Atikamekw"
    AWA = "Awadhi"
    AY = "Aymara"
    AZ = "Azerbaijani"
    BCR = "Babine"
    BFQ = "Badaga"
    BDJ = "Bai"
    BAN = "Balinese"
    BCC = "Balochi Southern"
    BFT = "Balti"
    BAL = "Baluchi"
    BAS = "Basa (Cameroon)"
    BA = "Bashkir"
    EU = "Basque"
    BAR = "Bavarian"
    BEA = "Beaver"
    BEJ = "Beja"
    BEM = "Bemba (Zambia)"
    BN = "Bengali (Bangla)"
    BEW = "Betawi"
    KAP = "Bezhta"
    BHB = "Bhili"
    BHO = "Bhojpuri"
    DZ = "Bhutani"
    BH = "Bihari"
    BIK = "Bikol"
    BIN = "Bini"
    BPY = "Bishnupriya Manipuri"
    BI = "Bislama"
    BR = "Breton"
    BUG = "Buginese"
    BG = "Bulgarian"
    BUA = "Buriat"
    MY = "Burmese"
    BE = "Byelorussian (Belarusian)"
    CAD = "Caddo"
    KM = "Cambodian"
    YUE = "Cantonese"
    CRX = "Carrier"
    CAF = "Carrier Southern"
    CA = "Catalan"
    CHC = "Catawba"
    CAY = "Cayuga"
    CEB = "Cebuano"
    CHG = "Chagatai"
    CLD = "Chaldean Neo-Aramaic"
    CHR = "Cherokee"
    CHY = "Cheyenne"
    CIC = "Chickasaw"
    CLC = "Chilcotin"
    ZH = "Chinese"
    CHN = "Chinook jargon"
    CHP = "Chipewyan"
    CIW = "Chippewa"
    CHO = "Choctaw"
    CAA = "Chor"
    CKT = "Chukot"
    CIM = "Cimbrian"
    CLM = "Clallam Klallam"
    COJ = "Cochimi"
    COC = "Cocopa"
    KSH = "Colognian"
    COM = "Comanche"
    SWB = "Comorian"
    COO = "Comox"
    COP = "Coptic"
    CO = "Corsican"
    CR = "Cree"
    MUS = "Creek"
    CRH = "Crimean Tatar"
    HR = "Croatian"
    CUP = "Cupeo"
    CS = "Czech"
    DAK = "Dakota"
    DA = "Danish"
    DAR = "Dargwa"
    PRD = "Dari (Persian)"
    GBZ = "Dari Zoroastrian"
    DHV = "Dehu"
    DEL = "Delaware"
    DIN = "Dinka"
    DOI = "Dogri (generic)"
    DGR = "Dogrib"
    DLG = "Dolgan"
    DOH = "Dong"
    DUA = "Duala"
    DNG = "Dungan"
    NL = "Dutch"
    DYU = "Dyula"
    EEE = "E"
    EGL = "Emilian"
    EN = "English"
    EN_US = "English (American)"
    EN_GB = "English (British)"
    ENM = "English Middle (1100-1500)"
    MYV = "Erzya"
    EO = "Esperanto"
    ET = "Estonian"
    EVE = "Even"
    EVN = "Evenki"
    FO = "Faeroese"
    FAX = "Fala"
    FAN = "Fang (Equatorial Guinea)"
    FA = "Farsi"
    FJ = "Fiji"
    FIL = "Filipino"
    FI = "Finnish"
    FIT = "Finnish (Tornedalen)"
    FON = "Fon"
    FRP = "Franco-Prove"
    FRK = "Frankish"
    FR = "French"
    FR_CA = "French (Canada)"
    FY = "Frisian"
    FRR = "Frisian Northern"
    FUR = "Friulian"
    FVR = "Fur"
    GAA = "Ga"
    GV = "Gaelic (Manx)"
    GD = "Gaelic (Scottish)"
    GAG = "Gagauz"
    GL = "Galician"
    GAN = "Gan"
    GEZ = "Geez"
    KA = "Georgian"
    DE = "German"
    GEH = "German Hutterite"
    PDC = "German Pennsylvania"
    GIL = "Gilbertese"
    NIV = "Gilyak Nivkh"
    GIT = "Gitxsan"
    EL = "Greek"
    GRC = "Greek Ancient (to 1453)"
    KL = "Greenlandic"
    GN = "Guarani"
    GU = "Gujarati"
    GWI = "Gwichin"
    HAI = "Haida"
    HNN = "Hainanese"
    HAS = "Haisla"
    HAK = "Hakka"
    HUR = "Halkomelem"
    HAA = "Han"
    HNI = "Hani"
    HA = "Hausa"
    HAW = "Hawaiian"
    IW = "Hebrew"
    HE = "Hebrew"
    HEI = "Heiltsuk"
    HID = "Hidatsa"
    HIL = "Hiligaynon"
    HI = "Hindi"
    HMN = "Hmong"
    HKK = "Hokkien"
    HOP = "Hopi"
    CZH = "Huizhou Chinese"
    HU = "Hungarian"
    IS = "Icelandic"
    KPO = "Ikposo"
    ILO = "Iloko"
    SMN = "Inari Sami"
    IN = "Indonesian"
    ID = "Indonesian"
    IZH = "Ingrian"
    INH = "Ingush"
    IA = "Interlingua"
    IE = "Interlingue"
    IKT = "Inuinnaqtun"
    IU = "Inuktitut"
    IK = "Inupiak"
    GA = "Irish"
    IRO = "Iroquoian languages"
    IT = "Italian"
    ITL = "Itelmen"
    JA = "Japanese"
    JV = "Javanese"
    CJY = "Jinyu Chinese"
    KAJ = "Jju"
    JCT = "Judeo-Crimean Tatar"
    JGE = "Judeo-Georgian"
    JUT = "Jutish"
    KBD = "Kabardian"
    KEA = "Kabuverdianu"
    KAB = "Kabyle"
    KFR = "Kachchi"
    KJV = "Kaikavian literary language (Kajkavian)"
    XAL = "Kalmyk Oirat"
    KN = "Kannada"
    KSK = "Kansa"
    KRC = "Karachay-Balkar"
    KIM = "Karagas"
    KDR = "Karaim"
    KAA = "Karakalpak"
    KRL = "Karelian"
    KS = "Kashmiri"
    CSB = "Kashubian"
    KKZ = "Kaska"
    KAW = "Kawi"
    KK = "Kazakh"
    KJH = "Khakas"
    KLJ = "Khalaj Turkic"
    KCA = "Khanty"
    KHA = "Khasi"
    KXM = "Khmer Northern"
    KIC = "Kickapoo"
    RW = "Kinyarwanda (Ruanda)"
    KIO = "Kiowa"
    KY = "Kirghiz"
    RN = "Kirundi (Rundi)"
    TLH = "Klingon tlhIngan-Hol"
    KFA = "Kodava"
    KOI = "Komi-Permyak"
    KOK = "Konkani (generic)"
    KNN = "Konkani (specific)"
    GOM = "Konkani Goan"
    KO = "Korean"
    KPY = "Koryak"
    KOS = "Kosraean"
    AVK = "Kotava"
    KPE = "Kpelle"
    DIH = "Kumiai"
    KUM = "Kumyk"
    KU = "Kurdish"
    KUT = "Kutenai"
    KWK = "Kwakiutl"
    GDM = "Laal"
    LLD = "Ladin"
    LAD = "Ladino"
    LAH = "Lahnda"
    LHU = "Lahu"
    LBE = "Lak"
    LKI = "Laki"
    LKT = "Lakota"
    LO = "Laothian"
    LA = "Latin"
    LV = "Latvian (Lettish)"
    LZZ = "Laz"
    LEZ = "Lezghian"
    LIJ = "Ligurian"
    LIL = "Lillooet"
    LIF = "Limbu"
    LI = "Limburgish ( Limburger)"
    LN = "Lingala"
    LT = "Lithuanian"
    JBO = "Lojban"
    LOM = "Loma (Liberia)"
    LMO = "Lombard"
    NDS = "Low German Low Saxon"
    LOZ = "Lozi"
    LUA = "Luba-Lulua"
    LUQ = "Lucumi"
    LUD = "Ludian"
    SMJ = "Lule Sami"
    LUN = "Lunda"
    LUO = "Luo (Kenya and Tanzania)"
    LUT = "Lushootseed"
    LB = "Luxembourgish (Letzeburgesch)"
    MK = "Macedonian"
    MAD = "Madurese"
    MAG = "Magahi"
    MAI = "Maithili"
    MG = "Malagasy"
    MS = "Malay"
    ML = "Malayalam"
    PQM = "Malecite-Passamaquoddy"
    MT = "Maltese"
    MNC = "Manchu"
    MID = "Mandaic"
    MHQ = "Mandan"
    CMN = "Mandarin Chinese"
    MNS = "Mansi"
    MI = "Maori"
    MRW = "Maranao"
    MR = "Marathi"
    CHM = "Mari (Russia)"
    MWR = "Marwari"
    MAS = "Masai"
    MFY = "Mayo"
    MNI = "Meitei"
    MEN = "Mende (Sierra Leone)"
    MEZ = "Menominee"
    CRG = "Michif"
    MIC = "Micmac"
    MNP = "Min Bei Chinese"
    CDO = "Min Dong Chinese"
    MIN = "Minangkabau"
    XMF = "Mingrelian"
    MWL = "Mirandese"
    MOH = "Mohawk"
    MDF = "Moksha"
    MO = "Moldavian"
    MNW = "Mon"
    MN = "Mongolian"
    MOE = "Montagnais"
    MFE = "Morisyen"
    MOS = "Mossi"
    MXI = "Mozarabic"
    MU = "Multilingual"
    MTQ = "Muong"
    NAQ = "Nama (Namibia)"
    GLD = "Nanai"
    NSK = "Naskapi"
    NA = "Nauru"
    NAP = "Neapolitan"
    NE = "Nepali"
    NEW_ = "Newari Nepal Bhasa"
    NIO = "Nganasan"
    NCG = "Nisgaa"
    NIU = "Niuean"
    ZXX = "No linguistic content"
    NOG = "Nogai"
    NON = "Norse Old"
    NSO = "Northern Sotho Pedi Sepedi"
    NO = "Norwegian"
    NOV = "Novial"
    NYM = "Nyamwezi"
    NYO = "Nyoro"
    NYS = "Nyungah"
    OC = "Occitan"
    OJC = "Ojibwa Central"
    OJG = "Ojibwa Eastern"
    OJB = "Ojibwa Northwestern"
    OJS = "Ojibwa Severn"
    OJW = "Ojibwa Western"
    OJ = "Ojibwe, Ojibwa"
    OKA = "Okanagan"
    RYU = "Okinawan Central"
    ANG = "Old English"
    ONE = "Oneida"
    ONO = "Onondaga"
    OR_ = "Oriya"
    OM = "Oromo (Afan, Galla)"
    OTW = "Ottawa"
    PPI = "Paipai"
    PAU = "Palauan"
    PAM = "Pampanga"
    PAG = "Pangasinan"
    PAP = "Papiamento"
    PS = "Pashto (Pushto)"
    PRP = "Persian"
    PRS = "Persian (Dari)"
    PFL = "Pfaelzisch"
    PCD = "Picard"
    PMS = "Piedmontese"
    MYP = "Pirah"
    PIH = "Pitcairn-Norfolk"
    PDT = "Plautdietsch"
    PL = "Polish"
    PNT = "Pontic"
    PT = "Portuguese"
    PT_BR = "Portuguese (Brazil)"
    POT = "Potawatomi"
    PRG = "Prussian"
    FUC = "Pulaar"
    PA = "Punjabi"
    QXQ = "Qashqai"
    ALC = "Qawasqar"
    QU = "Quechua"
    QUC = "Quich Central"
    RAP = "Rapanui"
    RAR = "Rarotongan"
    QTZ = "Reserved for local use."
    RM = "Rhaeto-Romance"
    RGN = "Romagnol"
    RMF = "Romani Kalo Finnish"
    RMO = "Romani Sinte"
    RO = "Romanian"
    RUO = "Romanian Istro"
    RUQ = "Romanian Megleno"
    ROM = "Romany"
    RCF = "Runion Creole French"
    RU = "Russian"
    RUE = "Rusyn"
    ACF = "Saint Lucian Creole French"
    SAH = "Sakha"
    SLR = "Salar"
    STR = "Salish Straits"
    SAL = "Salishan languages"
    SJD = "Sami Kildin"
    SMI = "Sami languages"
    SM = "Samoan"
    SG = "Sangro"
    SA = "Sanskrit"
    SAT = "Santali"
    SRM = "Saramaccan"
    SDC = "Sardinian Sassarese"
    STQ = "Saterland Frisian"
    SXU = "Saxon Upper"
    SCO = "Scots"
    SEC = "Sechelt"
    TRV = "Seediq"
    SEK = "Sekani"
    SEL = "Selkup"
    SEE = "Seneca"
    SR = "Serbian"
    SH = "Serbo-Croatian"
    SEI = "Seri"
    ST = "Sesotho"
    TN = "Setswana"
    SJW = "Shawnee"
    SN = "Shona"
    CJS = "Shor"
    SHH = "Shoshoni"
    SHS = "Shuswap"
    SCN = "Sicilian"
    SID = "Sidamo"
    BLA = "Siksika"
    SZL = "Silesian"
    SD = "Sindhi"
    SI = "Sinhalese"
    SS = "Siswati"
    SMS = "Skolt Sami"
    SCS = "Slavey North"
    XSL = "Slavey South"
    SK = "Slovak"
    SL = "Slovenian"
    SO = "Somali"
    SNK = "Soninke"
    DSB = "Sorbian Lower"
    HSB = "Sorbian Upper"
    SMA = "Southern Sami"
    TCE = "Southern Tutchone"
    ES = "Spanish"
    ES_XL = "Spanish (Latin America)"
    SRN = "Sranan"
    STO = "Stoney"
    XSV = "Sudovian"
    SUX = "Sumerian"
    SU = "Sundanese"
    SVA = "Svan"
    SWG = "Swabian"
    SW = "Swahili (Kiswahili)"
    SV = "Swedish"
    SWL = "Swedish Sign Language"
    GSW = "Swiss German Alemannic Alsatian"
    SYR = "Syriac"
    TAB = "Tabassaran"
    SHY = "Tachawit"
    SHI = "Tachelhit"
    TL = "Tagalog"
    TBW = "Tagbanwa"
    TGX = "Tagish"
    THT = "Tahltan"
    TDD = "Tai Na"
    ZH_TW = "Taiwanese Mandarin"
    TG = "Tajik"
    TLY = "Talysh"
    TTQ = "Tamajaq Tawallammat"
    TAQ = "Tamasheq"
    TZM = "Tamazight Central Atlas"
    TA = "Tamil"
    TAR = "Tarahumara Central"
    TTT = "Tat Muslim"
    TT = "Tatar"
    TE = "Telugu"
    TEO = "Teo Chew"
    TET = "Tetum"
    TH = "Thai"
    NOD = "Thai (Northern)"
    TTS = "Thai Northeastern"
    THP = "Thompson"
    BO = "Tibetan"
    TIG = "Tigre"
    TI = "Tigrinya"
    TLI = "Tlingit"
    TCX = "Toda"
    OOD = "Tohono Oodham"
    TPI = "Tok Pisin"
    TO = "Tonga"
    TOG = "Tonga (Nyasa)"
    DDO = "Tsez"
    TSI = "Tsimshian"
    TS = "Tsonga"
    TCY = "Tulu"
    TUM = "Tumbuka"
    MZB = "Tumzabt"
    TPN = "Tupinamb"
    TUV = "Turkana"
    TR = "Turkish"
    OTA = "Turkish Ottoman"
    TK = "Turkmen"
    TUS = "Tuscarora"
    TVL = "Tuvalu"
    TYV = "Tuvinian"
    TW = "Twi"
    UBY = "Ubykh"
    UDI = "Udi"
    UDM = "Udmurt"
    UG = "Uighur"
    UK = "Ukrainian"
    UN = "Undefined"
    UR = "Urdu"
    UUM = "Urum"
    UZ = "Uzbek"
    VEC = "Venetian"
    VEP = "Veps"
    VI = "Vietnamese"
    VO = "Volapuk"
    VOR = "Voro"
    VOT = "Votic"
    VRO = "Vro"
    AUC = "Waorani"
    WAR = "Waray (Philippines)"
    CY = "Welsh"
    PES = "Western Farsi"
    AMW = "Western Neo-Aramaic"
    WIY = "Wiyot"
    WO = "Wolof"
    WUU = "Wu Chinese"
    WYM = "Wymysorys"
    XH = "Xhosa"
    AME = "Yanesha"
    JI = "Yiddish"
    YI = "Yiddish"
    YO = "Yoruba"
    ZAI = "Zapotec Isthmus"
    DJE = "Zarma"
    ZU = "Zulu"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaLanguageCode(object):
    AA = "aa"
    AB = "ab"
    AF = "af"
    ALG = "alg"
    AM = "am"
    AR = "ar"
    AS_ = "as"
    ATH = "ath"
    AY = "ay"
    AZ = "az"
    BA = "ba"
    BE = "be"
    BG = "bg"
    BH = "bh"
    BI = "bi"
    BLA = "bla"
    BN = "bn"
    BO = "bo"
    BR = "br"
    CA = "ca"
    CO = "co"
    CR = "cr"
    CRG = "crg"
    CS = "cs"
    CY = "cy"
    DA = "da"
    DE = "de"
    DZ = "dz"
    EL = "el"
    EN = "en"
    EN_GB = "en_gb"
    EN_US = "en_us"
    EO = "eo"
    ES = "es"
    ES_XL = "es_xl"
    ET = "et"
    EU = "eu"
    FA = "fa"
    FI = "fi"
    FJ = "fj"
    FO = "fo"
    FR = "fr"
    FR_CA = "fr_ca"
    FY = "fy"
    GA = "ga"
    GD = "gd"
    GL = "gl"
    GN = "gn"
    GU = "gu"
    GV = "gv"
    HA = "ha"
    HE = "he"
    HI = "hi"
    HR = "hr"
    HU = "hu"
    HY = "hy"
    IA = "ia"
    ID = "id"
    IE = "ie"
    IK = "ik"
    IKT = "ikt"
    IN = "in"
    IRO = "iro"
    IS = "is"
    IT = "it"
    IU = "iu"
    IW = "iw"
    JA = "ja"
    JI = "ji"
    JV = "jv"
    KA = "ka"
    KK = "kk"
    KL = "kl"
    KM = "km"
    KN = "kn"
    KO = "ko"
    KS = "ks"
    KU = "ku"
    KY = "ky"
    LA = "la"
    LB = "lb"
    LI = "li"
    LN = "ln"
    LO = "lo"
    LT = "lt"
    LV = "lv"
    MG = "mg"
    MI = "mi"
    MIC = "mic"
    MK = "mk"
    ML = "ml"
    MN = "mn"
    MO = "mo"
    MOE = "moe"
    MR = "mr"
    MS = "ms"
    MT = "mt"
    MU = "mu"
    MY = "my"
    NA = "na"
    NE = "ne"
    NL = "nl"
    NO = "no"
    OC = "oc"
    OJ = "oj"
    OJS = "ojs"
    OJW = "ojw"
    OKA = "oka"
    OM = "om"
    OR_ = "or"
    PA = "pa"
    PL = "pl"
    PS = "ps"
    PT = "pt"
    PT_BR = "pt_br"
    QU = "qu"
    RM = "rm"
    RN = "rn"
    RO = "ro"
    RU = "ru"
    RW = "rw"
    SA = "sa"
    SAL = "sal"
    SD = "sd"
    SG = "sg"
    SH = "sh"
    SI = "si"
    SK = "sk"
    SL = "sl"
    SM = "sm"
    SMI = "smi"
    SN = "sn"
    SO = "so"
    SQ = "sq"
    SR = "sr"
    SS = "ss"
    ST = "st"
    SU = "su"
    SV = "sv"
    SW = "sw"
    TA = "ta"
    TCE = "tce"
    TE = "te"
    TG = "tg"
    TH = "th"
    TI = "ti"
    TK = "tk"
    TL = "tl"
    TN = "tn"
    TO = "to"
    TR = "tr"
    TS = "ts"
    TT = "tt"
    TW = "tw"
    UG = "ug"
    UK = "uk"
    UN = "un"
    UR = "ur"
    UZ = "uz"
    VI = "vi"
    VO = "vo"
    WO = "wo"
    XH = "xh"
    YI = "yi"
    YO = "yo"
    ZH = "zh"
    ZH_TW = "zh_tw"
    ZU = "zu"
    ZXX = "zxx"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaLiveAssetOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    DELETED_AT_ASC = "+deletedAt"
    SIZE_ASC = "+size"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    DELETED_AT_DESC = "-deletedAt"
    SIZE_DESC = "-size"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaLiveChannelCompareAttribute(object):
    ACCESS_CONTROL_ID = "accessControlId"
    CREATED_AT = "createdAt"
    END_DATE = "endDate"
    LAST_PLAYED_AT = "lastPlayedAt"
    MEDIA_DATE = "mediaDate"
    MEDIA_TYPE = "mediaType"
    MODERATION_COUNT = "moderationCount"
    MODERATION_STATUS = "moderationStatus"
    MS_DURATION = "msDuration"
    PARTNER_ID = "partnerId"
    PARTNER_SORT_VALUE = "partnerSortValue"
    PLAYS = "plays"
    RANK = "rank"
    REPLACEMENT_STATUS = "replacementStatus"
    START_DATE = "startDate"
    STATUS = "status"
    TOTAL_RANK = "totalRank"
    TYPE = "type"
    UPDATED_AT = "updatedAt"
    VIEWS = "views"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaLiveChannelMatchAttribute(object):
    ADMIN_TAGS = "adminTags"
    CATEGORIES_IDS = "categoriesIds"
    CREATOR_ID = "creatorId"
    DESCRIPTION = "description"
    DURATION_TYPE = "durationType"
    FLAVOR_PARAMS_IDS = "flavorParamsIds"
    GROUP_ID = "groupId"
    ID = "id"
    NAME = "name"
    REFERENCE_ID = "referenceId"
    REPLACED_ENTRY_ID = "replacedEntryId"
    REPLACING_ENTRY_ID = "replacingEntryId"
    SEARCH_TEXT = "searchText"
    TAGS = "tags"
    USER_ID = "userId"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaLiveChannelOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    DURATION_ASC = "+duration"
    END_DATE_ASC = "+endDate"
    FIRST_BROADCAST_ASC = "+firstBroadcast"
    LAST_BROADCAST_ASC = "+lastBroadcast"
    LAST_PLAYED_AT_ASC = "+lastPlayedAt"
    MEDIA_TYPE_ASC = "+mediaType"
    MODERATION_COUNT_ASC = "+moderationCount"
    NAME_ASC = "+name"
    PARTNER_SORT_VALUE_ASC = "+partnerSortValue"
    PLAYS_ASC = "+plays"
    RANK_ASC = "+rank"
    RECENT_ASC = "+recent"
    START_DATE_ASC = "+startDate"
    TOTAL_RANK_ASC = "+totalRank"
    UPDATED_AT_ASC = "+updatedAt"
    VIEWS_ASC = "+views"
    WEIGHT_ASC = "+weight"
    CREATED_AT_DESC = "-createdAt"
    DURATION_DESC = "-duration"
    END_DATE_DESC = "-endDate"
    FIRST_BROADCAST_DESC = "-firstBroadcast"
    LAST_BROADCAST_DESC = "-lastBroadcast"
    LAST_PLAYED_AT_DESC = "-lastPlayedAt"
    MEDIA_TYPE_DESC = "-mediaType"
    MODERATION_COUNT_DESC = "-moderationCount"
    NAME_DESC = "-name"
    PARTNER_SORT_VALUE_DESC = "-partnerSortValue"
    PLAYS_DESC = "-plays"
    RANK_DESC = "-rank"
    RECENT_DESC = "-recent"
    START_DATE_DESC = "-startDate"
    TOTAL_RANK_DESC = "-totalRank"
    UPDATED_AT_DESC = "-updatedAt"
    VIEWS_DESC = "-views"
    WEIGHT_DESC = "-weight"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaLiveChannelSegmentOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    START_TIME_ASC = "+startTime"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    START_TIME_DESC = "-startTime"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaLiveChannelSegmentStatus(object):
    ACTIVE = "2"
    DELETED = "3"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaLiveChannelSegmentTriggerType(object):
    CHANNEL_RELATIVE = "1"
    ABSOLUTE_TIME = "2"
    SEGMENT_START_RELATIVE = "3"
    SEGMENT_END_RELATIVE = "4"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaLiveChannelSegmentType(object):
    VIDEO_AND_AUDIO = "1"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaLiveEntryCompareAttribute(object):
    ACCESS_CONTROL_ID = "accessControlId"
    CREATED_AT = "createdAt"
    END_DATE = "endDate"
    LAST_PLAYED_AT = "lastPlayedAt"
    MEDIA_DATE = "mediaDate"
    MEDIA_TYPE = "mediaType"
    MODERATION_COUNT = "moderationCount"
    MODERATION_STATUS = "moderationStatus"
    MS_DURATION = "msDuration"
    PARTNER_ID = "partnerId"
    PARTNER_SORT_VALUE = "partnerSortValue"
    PLAYS = "plays"
    RANK = "rank"
    REPLACEMENT_STATUS = "replacementStatus"
    START_DATE = "startDate"
    STATUS = "status"
    TOTAL_RANK = "totalRank"
    TYPE = "type"
    UPDATED_AT = "updatedAt"
    VIEWS = "views"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaLiveEntryMatchAttribute(object):
    ADMIN_TAGS = "adminTags"
    CATEGORIES_IDS = "categoriesIds"
    CREATOR_ID = "creatorId"
    DESCRIPTION = "description"
    DURATION_TYPE = "durationType"
    FLAVOR_PARAMS_IDS = "flavorParamsIds"
    GROUP_ID = "groupId"
    ID = "id"
    NAME = "name"
    REFERENCE_ID = "referenceId"
    REPLACED_ENTRY_ID = "replacedEntryId"
    REPLACING_ENTRY_ID = "replacingEntryId"
    SEARCH_TEXT = "searchText"
    TAGS = "tags"
    USER_ID = "userId"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaLiveEntryOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    DURATION_ASC = "+duration"
    END_DATE_ASC = "+endDate"
    FIRST_BROADCAST_ASC = "+firstBroadcast"
    LAST_BROADCAST_ASC = "+lastBroadcast"
    LAST_PLAYED_AT_ASC = "+lastPlayedAt"
    MEDIA_TYPE_ASC = "+mediaType"
    MODERATION_COUNT_ASC = "+moderationCount"
    NAME_ASC = "+name"
    PARTNER_SORT_VALUE_ASC = "+partnerSortValue"
    PLAYS_ASC = "+plays"
    RANK_ASC = "+rank"
    RECENT_ASC = "+recent"
    START_DATE_ASC = "+startDate"
    TOTAL_RANK_ASC = "+totalRank"
    UPDATED_AT_ASC = "+updatedAt"
    VIEWS_ASC = "+views"
    WEIGHT_ASC = "+weight"
    CREATED_AT_DESC = "-createdAt"
    DURATION_DESC = "-duration"
    END_DATE_DESC = "-endDate"
    FIRST_BROADCAST_DESC = "-firstBroadcast"
    LAST_BROADCAST_DESC = "-lastBroadcast"
    LAST_PLAYED_AT_DESC = "-lastPlayedAt"
    MEDIA_TYPE_DESC = "-mediaType"
    MODERATION_COUNT_DESC = "-moderationCount"
    NAME_DESC = "-name"
    PARTNER_SORT_VALUE_DESC = "-partnerSortValue"
    PLAYS_DESC = "-plays"
    RANK_DESC = "-rank"
    RECENT_DESC = "-recent"
    START_DATE_DESC = "-startDate"
    TOTAL_RANK_DESC = "-totalRank"
    UPDATED_AT_DESC = "-updatedAt"
    VIEWS_DESC = "-views"
    WEIGHT_DESC = "-weight"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaLiveParamsOrderBy(object):

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaLiveReportOrderBy(object):
    NAME_ASC = "+name"
    AUDIENCE_DESC = "-audience"
    EVENT_TIME_DESC = "-eventTime"
    PLAYS_DESC = "-plays"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaLiveReportType(object):
    ENTRY_GEO_TIME_LINE = "ENTRY_GEO_TIME_LINE"
    ENTRY_SYNDICATION_TOTAL = "ENTRY_SYNDICATION_TOTAL"
    ENTRY_TIME_LINE = "ENTRY_TIME_LINE"
    ENTRY_TOTAL = "ENTRY_TOTAL"
    PARTNER_TOTAL = "PARTNER_TOTAL"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaLiveStreamAdminEntryCompareAttribute(object):
    ACCESS_CONTROL_ID = "accessControlId"
    CREATED_AT = "createdAt"
    END_DATE = "endDate"
    LAST_PLAYED_AT = "lastPlayedAt"
    MEDIA_DATE = "mediaDate"
    MEDIA_TYPE = "mediaType"
    MODERATION_COUNT = "moderationCount"
    MODERATION_STATUS = "moderationStatus"
    MS_DURATION = "msDuration"
    PARTNER_ID = "partnerId"
    PARTNER_SORT_VALUE = "partnerSortValue"
    PLAYS = "plays"
    RANK = "rank"
    REPLACEMENT_STATUS = "replacementStatus"
    START_DATE = "startDate"
    STATUS = "status"
    TOTAL_RANK = "totalRank"
    TYPE = "type"
    UPDATED_AT = "updatedAt"
    VIEWS = "views"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaLiveStreamAdminEntryMatchAttribute(object):
    ADMIN_TAGS = "adminTags"
    CATEGORIES_IDS = "categoriesIds"
    CREATOR_ID = "creatorId"
    DESCRIPTION = "description"
    DURATION_TYPE = "durationType"
    FLAVOR_PARAMS_IDS = "flavorParamsIds"
    GROUP_ID = "groupId"
    ID = "id"
    NAME = "name"
    REFERENCE_ID = "referenceId"
    REPLACED_ENTRY_ID = "replacedEntryId"
    REPLACING_ENTRY_ID = "replacingEntryId"
    SEARCH_TEXT = "searchText"
    TAGS = "tags"
    USER_ID = "userId"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaLiveStreamAdminEntryOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    DURATION_ASC = "+duration"
    END_DATE_ASC = "+endDate"
    FIRST_BROADCAST_ASC = "+firstBroadcast"
    LAST_BROADCAST_ASC = "+lastBroadcast"
    LAST_PLAYED_AT_ASC = "+lastPlayedAt"
    MEDIA_TYPE_ASC = "+mediaType"
    MODERATION_COUNT_ASC = "+moderationCount"
    NAME_ASC = "+name"
    PARTNER_SORT_VALUE_ASC = "+partnerSortValue"
    PLAYS_ASC = "+plays"
    RANK_ASC = "+rank"
    RECENT_ASC = "+recent"
    START_DATE_ASC = "+startDate"
    TOTAL_RANK_ASC = "+totalRank"
    UPDATED_AT_ASC = "+updatedAt"
    VIEWS_ASC = "+views"
    WEIGHT_ASC = "+weight"
    CREATED_AT_DESC = "-createdAt"
    DURATION_DESC = "-duration"
    END_DATE_DESC = "-endDate"
    FIRST_BROADCAST_DESC = "-firstBroadcast"
    LAST_BROADCAST_DESC = "-lastBroadcast"
    LAST_PLAYED_AT_DESC = "-lastPlayedAt"
    MEDIA_TYPE_DESC = "-mediaType"
    MODERATION_COUNT_DESC = "-moderationCount"
    NAME_DESC = "-name"
    PARTNER_SORT_VALUE_DESC = "-partnerSortValue"
    PLAYS_DESC = "-plays"
    RANK_DESC = "-rank"
    RECENT_DESC = "-recent"
    START_DATE_DESC = "-startDate"
    TOTAL_RANK_DESC = "-totalRank"
    UPDATED_AT_DESC = "-updatedAt"
    VIEWS_DESC = "-views"
    WEIGHT_DESC = "-weight"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaLiveStreamEntryCompareAttribute(object):
    ACCESS_CONTROL_ID = "accessControlId"
    CREATED_AT = "createdAt"
    END_DATE = "endDate"
    LAST_PLAYED_AT = "lastPlayedAt"
    MEDIA_DATE = "mediaDate"
    MEDIA_TYPE = "mediaType"
    MODERATION_COUNT = "moderationCount"
    MODERATION_STATUS = "moderationStatus"
    MS_DURATION = "msDuration"
    PARTNER_ID = "partnerId"
    PARTNER_SORT_VALUE = "partnerSortValue"
    PLAYS = "plays"
    RANK = "rank"
    REPLACEMENT_STATUS = "replacementStatus"
    START_DATE = "startDate"
    STATUS = "status"
    TOTAL_RANK = "totalRank"
    TYPE = "type"
    UPDATED_AT = "updatedAt"
    VIEWS = "views"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaLiveStreamEntryMatchAttribute(object):
    ADMIN_TAGS = "adminTags"
    CATEGORIES_IDS = "categoriesIds"
    CREATOR_ID = "creatorId"
    DESCRIPTION = "description"
    DURATION_TYPE = "durationType"
    FLAVOR_PARAMS_IDS = "flavorParamsIds"
    GROUP_ID = "groupId"
    ID = "id"
    NAME = "name"
    REFERENCE_ID = "referenceId"
    REPLACED_ENTRY_ID = "replacedEntryId"
    REPLACING_ENTRY_ID = "replacingEntryId"
    SEARCH_TEXT = "searchText"
    TAGS = "tags"
    USER_ID = "userId"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaLiveStreamEntryOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    DURATION_ASC = "+duration"
    END_DATE_ASC = "+endDate"
    FIRST_BROADCAST_ASC = "+firstBroadcast"
    LAST_BROADCAST_ASC = "+lastBroadcast"
    LAST_PLAYED_AT_ASC = "+lastPlayedAt"
    MEDIA_TYPE_ASC = "+mediaType"
    MODERATION_COUNT_ASC = "+moderationCount"
    NAME_ASC = "+name"
    PARTNER_SORT_VALUE_ASC = "+partnerSortValue"
    PLAYS_ASC = "+plays"
    RANK_ASC = "+rank"
    RECENT_ASC = "+recent"
    START_DATE_ASC = "+startDate"
    TOTAL_RANK_ASC = "+totalRank"
    UPDATED_AT_ASC = "+updatedAt"
    VIEWS_ASC = "+views"
    WEIGHT_ASC = "+weight"
    CREATED_AT_DESC = "-createdAt"
    DURATION_DESC = "-duration"
    END_DATE_DESC = "-endDate"
    FIRST_BROADCAST_DESC = "-firstBroadcast"
    LAST_BROADCAST_DESC = "-lastBroadcast"
    LAST_PLAYED_AT_DESC = "-lastPlayedAt"
    MEDIA_TYPE_DESC = "-mediaType"
    MODERATION_COUNT_DESC = "-moderationCount"
    NAME_DESC = "-name"
    PARTNER_SORT_VALUE_DESC = "-partnerSortValue"
    PLAYS_DESC = "-plays"
    RANK_DESC = "-rank"
    RECENT_DESC = "-recent"
    START_DATE_DESC = "-startDate"
    TOTAL_RANK_DESC = "-totalRank"
    UPDATED_AT_DESC = "-updatedAt"
    VIEWS_DESC = "-views"
    WEIGHT_DESC = "-weight"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaMailType(object):
    MAIL_TYPE_KALTURA_NEWSLETTER = "10"
    MAIL_TYPE_ADDED_TO_FAVORITES = "11"
    MAIL_TYPE_ADDED_TO_CLIP_FAVORITES = "12"
    MAIL_TYPE_NEW_COMMENT_IN_PROFILE = "13"
    MAIL_TYPE_CLIP_ADDED_YOUR_KALTURA = "20"
    MAIL_TYPE_VIDEO_ADDED = "21"
    MAIL_TYPE_ROUGHCUT_CREATED = "22"
    MAIL_TYPE_ADDED_KALTURA_TO_YOUR_FAVORITES = "23"
    MAIL_TYPE_NEW_COMMENT_IN_KALTURA = "24"
    MAIL_TYPE_CLIP_ADDED = "30"
    MAIL_TYPE_VIDEO_CREATED = "31"
    MAIL_TYPE_ADDED_KALTURA_TO_HIS_FAVORITES = "32"
    MAIL_TYPE_NEW_COMMENT_IN_KALTURA_YOU_CONTRIBUTED = "33"
    MAIL_TYPE_CLIP_CONTRIBUTED = "40"
    MAIL_TYPE_ROUGHCUT_CREATED_SUBSCRIBED = "41"
    MAIL_TYPE_ADDED_KALTURA_TO_HIS_FAVORITES_SUBSCRIBED = "42"
    MAIL_TYPE_NEW_COMMENT_IN_KALTURA_YOU_SUBSCRIBED = "43"
    MAIL_TYPE_REGISTER_CONFIRM = "50"
    MAIL_TYPE_PASSWORD_RESET = "51"
    MAIL_TYPE_LOGIN_MAIL_RESET = "52"
    MAIL_TYPE_REGISTER_CONFIRM_VIDEO_SERVICE = "54"
    MAIL_TYPE_VIDEO_READY = "60"
    MAIL_TYPE_VIDEO_IS_READY = "62"
    MAIL_TYPE_BULK_DOWNLOAD_READY = "63"
    MAIL_TYPE_BULKUPLOAD_FINISHED = "64"
    MAIL_TYPE_BULKUPLOAD_FAILED = "65"
    MAIL_TYPE_BULKUPLOAD_ABORTED = "66"
    MAIL_TYPE_NOTIFY_ERR = "70"
    MAIL_TYPE_ACCOUNT_UPGRADE_CONFIRM = "80"
    MAIL_TYPE_VIDEO_SERVICE_NOTICE = "81"
    MAIL_TYPE_VIDEO_SERVICE_NOTICE_LIMIT_REACHED = "82"
    MAIL_TYPE_VIDEO_SERVICE_NOTICE_ACCOUNT_LOCKED = "83"
    MAIL_TYPE_VIDEO_SERVICE_NOTICE_ACCOUNT_DELETED = "84"
    MAIL_TYPE_VIDEO_SERVICE_NOTICE_UPGRADE_OFFER = "85"
    MAIL_TYPE_ACCOUNT_REACTIVE_CONFIRM = "86"
    MAIL_TYPE_EXTENDED_FREE_TRIAL_ENDS_WARNING = "87"
    MAIL_TYPE_SYSTEM_USER_RESET_PASSWORD = "110"
    MAIL_TYPE_SYSTEM_USER_RESET_PASSWORD_SUCCESS = "111"
    MAIL_TYPE_SYSTEM_USER_NEW_PASSWORD = "112"
    MAIL_TYPE_SYSTEM_USER_CREDENTIALS_SAVED = "113"
    MAIL_TYPE_LIVE_REPORT_EXPORT_SUCCESS = "130"
    MAIL_TYPE_LIVE_REPORT_EXPORT_FAILURE = "131"
    MAIL_TYPE_LIVE_REPORT_EXPORT_ABORT = "132"
    MAIL_TYPE_USERS_CSV = "133"
    MAIL_TYPE_OBJECTS_CSV = "135"
    MAIL_TYPE_REPORT_EXPORT_SUCCESS = "136"
    MAIL_TYPE_REPORT_EXPORT_FAILURE = "137"
    MAIL_TYPE_REPORT_EXPORT_ABORT = "138"
    MAIL_TYPE_SIP_FAILURE = "139"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaMatchConditionType(object):
    MATCH_ANY = "1"
    MATCH_ALL = "2"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaMediaEntryCompareAttribute(object):
    ACCESS_CONTROL_ID = "accessControlId"
    CREATED_AT = "createdAt"
    END_DATE = "endDate"
    LAST_PLAYED_AT = "lastPlayedAt"
    MEDIA_DATE = "mediaDate"
    MEDIA_TYPE = "mediaType"
    MODERATION_COUNT = "moderationCount"
    MODERATION_STATUS = "moderationStatus"
    MS_DURATION = "msDuration"
    PARTNER_ID = "partnerId"
    PARTNER_SORT_VALUE = "partnerSortValue"
    PLAYS = "plays"
    RANK = "rank"
    REPLACEMENT_STATUS = "replacementStatus"
    START_DATE = "startDate"
    STATUS = "status"
    TOTAL_RANK = "totalRank"
    TYPE = "type"
    UPDATED_AT = "updatedAt"
    VIEWS = "views"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaMediaEntryMatchAttribute(object):
    ADMIN_TAGS = "adminTags"
    CATEGORIES_IDS = "categoriesIds"
    CREATOR_ID = "creatorId"
    DESCRIPTION = "description"
    DURATION_TYPE = "durationType"
    FLAVOR_PARAMS_IDS = "flavorParamsIds"
    GROUP_ID = "groupId"
    ID = "id"
    NAME = "name"
    REFERENCE_ID = "referenceId"
    REPLACED_ENTRY_ID = "replacedEntryId"
    REPLACING_ENTRY_ID = "replacingEntryId"
    SEARCH_TEXT = "searchText"
    TAGS = "tags"
    USER_ID = "userId"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaMediaEntryOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    DURATION_ASC = "+duration"
    END_DATE_ASC = "+endDate"
    LAST_PLAYED_AT_ASC = "+lastPlayedAt"
    MEDIA_TYPE_ASC = "+mediaType"
    MODERATION_COUNT_ASC = "+moderationCount"
    NAME_ASC = "+name"
    PARTNER_SORT_VALUE_ASC = "+partnerSortValue"
    PLAYS_ASC = "+plays"
    RANK_ASC = "+rank"
    RECENT_ASC = "+recent"
    START_DATE_ASC = "+startDate"
    TOTAL_RANK_ASC = "+totalRank"
    UPDATED_AT_ASC = "+updatedAt"
    VIEWS_ASC = "+views"
    WEIGHT_ASC = "+weight"
    CREATED_AT_DESC = "-createdAt"
    DURATION_DESC = "-duration"
    END_DATE_DESC = "-endDate"
    LAST_PLAYED_AT_DESC = "-lastPlayedAt"
    MEDIA_TYPE_DESC = "-mediaType"
    MODERATION_COUNT_DESC = "-moderationCount"
    NAME_DESC = "-name"
    PARTNER_SORT_VALUE_DESC = "-partnerSortValue"
    PLAYS_DESC = "-plays"
    RANK_DESC = "-rank"
    RECENT_DESC = "-recent"
    START_DATE_DESC = "-startDate"
    TOTAL_RANK_DESC = "-totalRank"
    UPDATED_AT_DESC = "-updatedAt"
    VIEWS_DESC = "-views"
    WEIGHT_DESC = "-weight"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaMediaFlavorParamsOrderBy(object):

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaMediaFlavorParamsOutputOrderBy(object):

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaMediaInfoOrderBy(object):

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaMediaParserType(object):
    MEDIAINFO = "0"
    FFMPEG = "1"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaMediaServerNodeOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    HEARTBEAT_TIME_ASC = "+heartbeatTime"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    HEARTBEAT_TIME_DESC = "-heartbeatTime"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaMixEntryCompareAttribute(object):
    ACCESS_CONTROL_ID = "accessControlId"
    CREATED_AT = "createdAt"
    END_DATE = "endDate"
    LAST_PLAYED_AT = "lastPlayedAt"
    MODERATION_COUNT = "moderationCount"
    MODERATION_STATUS = "moderationStatus"
    MS_DURATION = "msDuration"
    PARTNER_ID = "partnerId"
    PARTNER_SORT_VALUE = "partnerSortValue"
    PLAYS = "plays"
    RANK = "rank"
    REPLACEMENT_STATUS = "replacementStatus"
    START_DATE = "startDate"
    STATUS = "status"
    TOTAL_RANK = "totalRank"
    TYPE = "type"
    UPDATED_AT = "updatedAt"
    VIEWS = "views"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaMixEntryMatchAttribute(object):
    ADMIN_TAGS = "adminTags"
    CATEGORIES_IDS = "categoriesIds"
    CREATOR_ID = "creatorId"
    DESCRIPTION = "description"
    DURATION_TYPE = "durationType"
    GROUP_ID = "groupId"
    ID = "id"
    NAME = "name"
    REFERENCE_ID = "referenceId"
    REPLACED_ENTRY_ID = "replacedEntryId"
    REPLACING_ENTRY_ID = "replacingEntryId"
    SEARCH_TEXT = "searchText"
    TAGS = "tags"
    USER_ID = "userId"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaMixEntryOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    DURATION_ASC = "+duration"
    END_DATE_ASC = "+endDate"
    LAST_PLAYED_AT_ASC = "+lastPlayedAt"
    MODERATION_COUNT_ASC = "+moderationCount"
    NAME_ASC = "+name"
    PARTNER_SORT_VALUE_ASC = "+partnerSortValue"
    PLAYS_ASC = "+plays"
    RANK_ASC = "+rank"
    RECENT_ASC = "+recent"
    START_DATE_ASC = "+startDate"
    TOTAL_RANK_ASC = "+totalRank"
    UPDATED_AT_ASC = "+updatedAt"
    VIEWS_ASC = "+views"
    WEIGHT_ASC = "+weight"
    CREATED_AT_DESC = "-createdAt"
    DURATION_DESC = "-duration"
    END_DATE_DESC = "-endDate"
    LAST_PLAYED_AT_DESC = "-lastPlayedAt"
    MODERATION_COUNT_DESC = "-moderationCount"
    NAME_DESC = "-name"
    PARTNER_SORT_VALUE_DESC = "-partnerSortValue"
    PLAYS_DESC = "-plays"
    RANK_DESC = "-rank"
    RECENT_DESC = "-recent"
    START_DATE_DESC = "-startDate"
    TOTAL_RANK_DESC = "-totalRank"
    UPDATED_AT_DESC = "-updatedAt"
    VIEWS_DESC = "-views"
    WEIGHT_DESC = "-weight"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaModerationFlagStatus(object):
    PENDING = "1"
    MODERATED = "2"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaModerationObjectType(object):
    ENTRY = "2"
    USER = "3"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaPartnerOrderBy(object):
    ADMIN_EMAIL_ASC = "+adminEmail"
    ADMIN_NAME_ASC = "+adminName"
    CREATED_AT_ASC = "+createdAt"
    ID_ASC = "+id"
    NAME_ASC = "+name"
    STATUS_ASC = "+status"
    WEBSITE_ASC = "+website"
    ADMIN_EMAIL_DESC = "-adminEmail"
    ADMIN_NAME_DESC = "-adminName"
    CREATED_AT_DESC = "-createdAt"
    ID_DESC = "-id"
    NAME_DESC = "-name"
    STATUS_DESC = "-status"
    WEBSITE_DESC = "-website"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaPermissionItemOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    ID_ASC = "+id"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    ID_DESC = "-id"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaPermissionItemType(object):
    API_ACTION_ITEM = "kApiActionPermissionItem"
    API_PARAMETER_ITEM = "kApiParameterPermissionItem"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaPermissionOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    ID_ASC = "+id"
    NAME_ASC = "+name"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    ID_DESC = "-id"
    NAME_DESC = "-name"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaPlayableEntryCompareAttribute(object):
    ACCESS_CONTROL_ID = "accessControlId"
    CREATED_AT = "createdAt"
    END_DATE = "endDate"
    LAST_PLAYED_AT = "lastPlayedAt"
    MODERATION_COUNT = "moderationCount"
    MODERATION_STATUS = "moderationStatus"
    MS_DURATION = "msDuration"
    PARTNER_ID = "partnerId"
    PARTNER_SORT_VALUE = "partnerSortValue"
    PLAYS = "plays"
    RANK = "rank"
    REPLACEMENT_STATUS = "replacementStatus"
    START_DATE = "startDate"
    STATUS = "status"
    TOTAL_RANK = "totalRank"
    TYPE = "type"
    UPDATED_AT = "updatedAt"
    VIEWS = "views"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaPlayableEntryMatchAttribute(object):
    ADMIN_TAGS = "adminTags"
    CATEGORIES_IDS = "categoriesIds"
    CREATOR_ID = "creatorId"
    DESCRIPTION = "description"
    DURATION_TYPE = "durationType"
    GROUP_ID = "groupId"
    ID = "id"
    NAME = "name"
    REFERENCE_ID = "referenceId"
    REPLACED_ENTRY_ID = "replacedEntryId"
    REPLACING_ENTRY_ID = "replacingEntryId"
    SEARCH_TEXT = "searchText"
    TAGS = "tags"
    USER_ID = "userId"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaPlayableEntryOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    DURATION_ASC = "+duration"
    END_DATE_ASC = "+endDate"
    LAST_PLAYED_AT_ASC = "+lastPlayedAt"
    MODERATION_COUNT_ASC = "+moderationCount"
    NAME_ASC = "+name"
    PARTNER_SORT_VALUE_ASC = "+partnerSortValue"
    PLAYS_ASC = "+plays"
    RANK_ASC = "+rank"
    RECENT_ASC = "+recent"
    START_DATE_ASC = "+startDate"
    TOTAL_RANK_ASC = "+totalRank"
    UPDATED_AT_ASC = "+updatedAt"
    VIEWS_ASC = "+views"
    WEIGHT_ASC = "+weight"
    CREATED_AT_DESC = "-createdAt"
    DURATION_DESC = "-duration"
    END_DATE_DESC = "-endDate"
    LAST_PLAYED_AT_DESC = "-lastPlayedAt"
    MODERATION_COUNT_DESC = "-moderationCount"
    NAME_DESC = "-name"
    PARTNER_SORT_VALUE_DESC = "-partnerSortValue"
    PLAYS_DESC = "-plays"
    RANK_DESC = "-rank"
    RECENT_DESC = "-recent"
    START_DATE_DESC = "-startDate"
    TOTAL_RANK_DESC = "-totalRank"
    UPDATED_AT_DESC = "-updatedAt"
    VIEWS_DESC = "-views"
    WEIGHT_DESC = "-weight"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaPlaybackProtocol(object):
    APPLE_HTTP = "applehttp"
    APPLE_HTTP_TO_MC = "applehttp_to_mc"
    AUTO = "auto"
    DOWNLOAD = "download"
    AKAMAI_HD = "hdnetwork"
    AKAMAI_HDS = "hdnetworkmanifest"
    HDS = "hds"
    HLS = "hls"
    HTTP = "http"
    MPEG_DASH = "mpegdash"
    MULTICAST_SL = "multicast_silverlight"
    RTMP = "rtmp"
    RTSP = "rtsp"
    SILVER_LIGHT = "sl"
    URL = "url"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaPlaylistCompareAttribute(object):
    ACCESS_CONTROL_ID = "accessControlId"
    CREATED_AT = "createdAt"
    END_DATE = "endDate"
    MODERATION_COUNT = "moderationCount"
    MODERATION_STATUS = "moderationStatus"
    PARTNER_ID = "partnerId"
    PARTNER_SORT_VALUE = "partnerSortValue"
    RANK = "rank"
    REPLACEMENT_STATUS = "replacementStatus"
    START_DATE = "startDate"
    STATUS = "status"
    TOTAL_RANK = "totalRank"
    TYPE = "type"
    UPDATED_AT = "updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaPlaylistMatchAttribute(object):
    ADMIN_TAGS = "adminTags"
    CATEGORIES_IDS = "categoriesIds"
    CREATOR_ID = "creatorId"
    DESCRIPTION = "description"
    GROUP_ID = "groupId"
    ID = "id"
    NAME = "name"
    REFERENCE_ID = "referenceId"
    REPLACED_ENTRY_ID = "replacedEntryId"
    REPLACING_ENTRY_ID = "replacingEntryId"
    SEARCH_TEXT = "searchText"
    TAGS = "tags"
    USER_ID = "userId"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaPlaylistOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    END_DATE_ASC = "+endDate"
    MODERATION_COUNT_ASC = "+moderationCount"
    NAME_ASC = "+name"
    PARTNER_SORT_VALUE_ASC = "+partnerSortValue"
    RANK_ASC = "+rank"
    RECENT_ASC = "+recent"
    START_DATE_ASC = "+startDate"
    TOTAL_RANK_ASC = "+totalRank"
    UPDATED_AT_ASC = "+updatedAt"
    WEIGHT_ASC = "+weight"
    CREATED_AT_DESC = "-createdAt"
    END_DATE_DESC = "-endDate"
    MODERATION_COUNT_DESC = "-moderationCount"
    NAME_DESC = "-name"
    PARTNER_SORT_VALUE_DESC = "-partnerSortValue"
    RANK_DESC = "-rank"
    RECENT_DESC = "-recent"
    START_DATE_DESC = "-startDate"
    TOTAL_RANK_DESC = "-totalRank"
    UPDATED_AT_DESC = "-updatedAt"
    WEIGHT_DESC = "-weight"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaQuizUserEntryOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaReportInterval(object):
    DAYS = "days"
    HOURS = "hours"
    MINUTES = "minutes"
    MONTHS = "months"
    TEN_MINUTES = "ten_minutes"
    TEN_SECONDS = "ten_seconds"
    YEARS = "years"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaReportOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    CREATED_AT_DESC = "-createdAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaReportType(object):
    QUIZ = "quiz.QUIZ"
    QUIZ_AGGREGATE_BY_QUESTION = "quiz.QUIZ_AGGREGATE_BY_QUESTION"
    QUIZ_USER_AGGREGATE_BY_QUESTION = "quiz.QUIZ_USER_AGGREGATE_BY_QUESTION"
    QUIZ_USER_PERCENTAGE = "quiz.QUIZ_USER_PERCENTAGE"
    TOP_CONTENT = "1"
    CONTENT_DROPOFF = "2"
    CONTENT_INTERACTIONS = "3"
    MAP_OVERLAY = "4"
    TOP_CONTRIBUTORS = "5"
    TOP_SYNDICATION = "6"
    CONTENT_CONTRIBUTIONS = "7"
    USER_ENGAGEMENT = "11"
    SPECIFIC_USER_ENGAGEMENT = "12"
    USER_TOP_CONTENT = "13"
    USER_CONTENT_DROPOFF = "14"
    USER_CONTENT_INTERACTIONS = "15"
    APPLICATIONS = "16"
    USER_USAGE = "17"
    SPECIFIC_USER_USAGE = "18"
    VAR_USAGE = "19"
    TOP_CREATORS = "20"
    PLATFORMS = "21"
    OPERATING_SYSTEM = "22"
    BROWSERS = "23"
    LIVE = "24"
    TOP_PLAYBACK_CONTEXT = "25"
    VPAAS_USAGE = "26"
    ENTRY_USAGE = "27"
    REACH_USAGE = "28"
    TOP_CUSTOM_VAR1 = "29"
    MAP_OVERLAY_CITY = "30"
    OPERATING_SYSTEM_FAMILIES = "32"
    BROWSERS_FAMILIES = "33"
    USER_ENGAGEMENT_TIMELINE = "34"
    UNIQUE_USERS_PLAY = "35"
    MAP_OVERLAY_COUNTRY = "36"
    MAP_OVERLAY_REGION = "37"
    TOP_CONTENT_CREATOR = "38"
    TOP_CONTENT_CONTRIBUTORS = "39"
    APP_DOMAIN_UNIQUE_ACTIVE_USERS = "40"
    TOP_SOURCES = "41"
    VPAAS_USAGE_MULTI = "42"
    PERCENTILES = "43"
    CONTENT_REPORT_REASONS = "44"
    PLAYER_RELATED_INTERACTIONS = "45"
    PLAYBACK_RATE = "46"
    TOP_USER_CONTENT = "47"
    USER_HIGHLIGHTS = "48"
    USER_INTERACTIVE_VIDEO = "49"
    INTERACTIVE_VIDEO_TOP_NODES = "50"
    LATEST_PLAYED_ENTRIES = "51"
    CATEGORY_HIGHLIGHTS = "52"
    SUB_CATEGORIES = "53"
    INTERACTIVE_VIDEO_NODE_TOP_HOTSPOTS = "54"
    INTERCATIVE_VIDEO_NODE_SWITCH_TOP_HOTSPOTS = "55"
    INTERACTIVE_VIDEO_HOTSPOT_CLICKED_PERCENTILES = "56"
    INTERACTIVE_VIDEO_NODE_SWITCH_HOTSPOT_CLICKED_PERCENTILES = "57"
    TOP_CUSTOM_VAR2 = "58"
    TOP_CUSTOM_VAR3 = "59"
    SELF_SERVE_USAGE = "60"
    FLAVOR_PARAMS_TRANSCODING_USAGE = "61"
    PARTNER_USAGE = "201"
    MAP_OVERLAY_COUNTRY_REALTIME = "10001"
    MAP_OVERLAY_REGION_REALTIME = "10002"
    MAP_OVERLAY_CITY_REALTIME = "10003"
    PLATFORMS_REALTIME = "10004"
    USERS_OVERVIEW_REALTIME = "10005"
    QOS_OVERVIEW_REALTIME = "10006"
    DISCOVERY_REALTIME = "10007"
    ENTRY_LEVEL_USERS_DISCOVERY_REALTIME = "10008"
    ENTRY_LEVEL_USERS_STATUS_REALTIME = "10009"
    PLATFORMS_DISCOVERY_REALTIME = "10010"
    PLAYBACK_TYPE_REALTIME = "10011"
    CONTENT_REALTIME = "10012"
    DISCOVERY_VIEW_REALTIME = "10013"
    TOP_ENDED_BROADCAST_ENTRIES = "10014"
    TOP_LIVE_NOW_ENTRIES = "10015"
    CONTENT_DROPOFF_VPAAS = "20001"
    TOP_SYNDICATION_VPAAS = "20002"
    USER_TOP_CONTENT_VPAAS = "20003"
    USER_USAGE_VPAAS = "20004"
    PLATFORMS_VPAAS = "20005"
    OPERATING_SYSTEM_VPAAS = "20006"
    BROWSERS_VPAAS = "20007"
    OPERATING_SYSTEM_FAMILIES_VPAAS = "20008"
    BROWSERS_FAMILIES_VPAAS = "20009"
    USER_ENGAGEMENT_TIMELINE_VPAAS = "20010"
    UNIQUE_USERS_PLAY_VPAAS = "20011"
    MAP_OVERLAY_COUNTRY_VPAAS = "20012"
    MAP_OVERLAY_REGION_VPAAS = "20013"
    MAP_OVERLAY_CITY_VPAAS = "20014"
    TOP_CONTENT_CREATOR_VPAAS = "20015"
    TOP_CONTENT_CONTRIBUTORS_VPAAS = "20016"
    TOP_SOURCES_VPAAS = "20017"
    CONTENT_REPORT_REASONS_VPAAS = "20018"
    PLAYER_RELATED_INTERACTIONS_VPAAS = "20019"
    PLAYBACK_RATE_VPAAS = "20020"
    PARTNER_USAGE_VPAAS = "20021"
    TOP_PLAYBACK_CONTEXT_VPAAS = "20022"
    SELF_SERVE_USAGE_VPAAS = "20023"
    QOE_OVERVIEW = "30001"
    QOE_EXPERIENCE = "30002"
    QOE_EXPERIENCE_PLATFORMS = "30003"
    QOE_EXPERIENCE_COUNTRY = "30004"
    QOE_EXPERIENCE_REGION = "30005"
    QOE_EXPERIENCE_CITY = "30006"
    QOE_EXPERIENCE_BROWSERS_FAMILIES = "30007"
    QOE_EXPERIENCE_BROWSERS = "30008"
    QOE_EXPERIENCE_OPERATING_SYSTEM_FAMILIES = "30009"
    QOE_EXPERIENCE_OPERATING_SYSTEM = "30010"
    QOE_EXPERIENCE_PLAYER_VERSION = "30011"
    QOE_EXPERIENCE_ENTRY = "30012"
    QOE_EXPERIENCE_ISP = "30013"
    QOE_ENGAGEMENT = "30014"
    QOE_ENGAGEMENT_PLATFORMS = "30015"
    QOE_ENGAGEMENT_COUNTRY = "30016"
    QOE_ENGAGEMENT_REGION = "30017"
    QOE_ENGAGEMENT_CITY = "30018"
    QOE_ENGAGEMENT_BROWSERS_FAMILIES = "30019"
    QOE_ENGAGEMENT_BROWSERS = "30020"
    QOE_ENGAGEMENT_OPERATING_SYSTEM_FAMILIES = "30021"
    QOE_ENGAGEMENT_OPERATING_SYSTEM = "30022"
    QOE_ENGAGEMENT_PLAYER_VERSION = "30023"
    QOE_ENGAGEMENT_ENTRY = "30024"
    QOE_ENGAGEMENT_ISP = "30025"
    QOE_STREAM_QUALITY = "30026"
    QOE_STREAM_QUALITY_PLATFORMS = "30027"
    QOE_STREAM_QUALITY_COUNTRY = "30028"
    QOE_STREAM_QUALITY_REGION = "30029"
    QOE_STREAM_QUALITY_CITY = "30030"
    QOE_STREAM_QUALITY_BROWSERS_FAMILIES = "30031"
    QOE_STREAM_QUALITY_BROWSERS = "30032"
    QOE_STREAM_QUALITY_OPERATING_SYSTEM_FAMILIES = "30033"
    QOE_STREAM_QUALITY_OPERATING_SYSTEM = "30034"
    QOE_STREAM_QUALITY_PLAYER_VERSION = "30035"
    QOE_STREAM_QUALITY_ENTRY = "30036"
    QOE_STREAM_QUALITY_ISP = "30037"
    QOE_ERROR_TRACKING = "30038"
    QOE_ERROR_TRACKING_CODES = "30039"
    QOE_ERROR_TRACKING_PLATFORMS = "30040"
    QOE_ERROR_TRACKING_BROWSERS_FAMILIES = "30041"
    QOE_ERROR_TRACKING_BROWSERS = "30042"
    QOE_ERROR_TRACKING_OPERATING_SYSTEM_FAMILIES = "30043"
    QOE_ERROR_TRACKING_OPERATING_SYSTEM = "30044"
    QOE_ERROR_TRACKING_PLAYER_VERSION = "30045"
    QOE_ERROR_TRACKING_ENTRY = "30046"
    QOE_VOD_SESSION_FLOW = "30047"
    QOE_LIVE_SESSION_FLOW = "30048"
    QOE_EXPERIENCE_CUSTOM_VAR1 = "30049"
    QOE_EXPERIENCE_CUSTOM_VAR2 = "30050"
    QOE_EXPERIENCE_CUSTOM_VAR3 = "30051"
    QOE_ENGAGEMENT_CUSTOM_VAR1 = "30052"
    QOE_ENGAGEMENT_CUSTOM_VAR2 = "30053"
    QOE_ENGAGEMENT_CUSTOM_VAR3 = "30054"
    QOE_STREAM_QUALITY_CUSTOM_VAR1 = "30055"
    QOE_STREAM_QUALITY_CUSTOM_VAR2 = "30056"
    QOE_STREAM_QUALITY_CUSTOM_VAR3 = "30057"
    QOE_ERROR_TRACKING_CUSTOM_VAR1 = "30058"
    QOE_ERROR_TRACKING_CUSTOM_VAR2 = "30059"
    QOE_ERROR_TRACKING_CUSTOM_VAR3 = "30060"
    QOE_EXPERIENCE_APPLICATION_VERSION = "30061"
    QOE_ENGAGEMENT_APPLICATION_VERSION = "30062"
    QOE_STREAM_QUALITY_APPLICATION_VERSION = "30063"
    QOE_ERROR_TRACKING_APPLICATION_VERSION = "30064"
    HIGHLIGHTS_WEBCAST = "40001"
    ENGAGEMENT_WEBCAST = "40002"
    QUALITY_WEBCAST = "40003"
    MAP_OVERLAY_COUNTRY_WEBCAST = "40004"
    MAP_OVERLAY_REGION_WEBCAST = "40005"
    MAP_OVERLAY_CITY_WEBCAST = "40006"
    PLATFORMS_WEBCAST = "40007"
    TOP_DOMAINS_WEBCAST = "40008"
    TOP_USERS_WEBCAST = "40009"
    ENGAGEMENT_BREAKDOWN_WEBCAST = "40010"
    ENGAGMENT_TIMELINE_WEBCAST = "40011"
    ENGAGEMENT_TOOLS_WEBCAST = "40012"
    REACTIONS_BREAKDOWN_WEBCAST = "40013"
    VE_HIGHLIGHTS = "50000"
    VE_REGISTERED_PLATFORMS = "50001"
    VE_REGISTERED_INDUSTRY = "50002"
    VE_REGISTERED_ROLES = "50003"
    VE_REGISTERED_COUNTRIES = "50004"
    VE_REGISTERED_WORLD_REGIONS = "50005"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaResetPassLinkType(object):
    KMC = "1"
    KMS = "2"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaResponseProfileOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaRuleActionType(object):
    DRM_POLICY = "drm.DRM_POLICY"
    ADD_ENTRY_VENDOR_TASK = "reach.ADD_ENTRY_VENDOR_TASK"
    BLOCK = "1"
    PREVIEW = "2"
    LIMIT_FLAVORS = "3"
    ADD_TO_STORAGE = "4"
    LIMIT_DELIVERY_PROFILES = "5"
    SERVE_FROM_REMOTE_SERVER = "6"
    REQUEST_HOST_REGEX = "7"
    LIMIT_THUMBNAIL_CAPTURE = "8"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaSchemaType(object):
    BULK_UPLOAD_RESULT_XML = "bulkUploadXml.bulkUploadResultXML"
    BULK_UPLOAD_XML = "bulkUploadXml.bulkUploadXML"
    INGEST_API = "cuePoint.ingestAPI"
    SERVE_API = "cuePoint.serveAPI"
    DROP_FOLDER_XML = "dropFolderXmlBulkUpload.dropFolderXml"
    SYNDICATION = "syndication"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaSearchConditionComparison(object):
    EQUAL = "1"
    GREATER_THAN = "2"
    GREATER_THAN_OR_EQUAL = "3"
    LESS_THAN = "4"
    LESS_THAN_OR_EQUAL = "5"
    NOT_EQUAL = "6"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaServerNodeOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    HEARTBEAT_TIME_ASC = "+heartbeatTime"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    HEARTBEAT_TIME_DESC = "-heartbeatTime"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaServerNodeType(object):
    CONFERENCE_SERVER = "conference.CONFERENCE_SERVER"
    LIVE_CLUSTER_MEDIA_SERVER = "liveCluster.LIVE_CLUSTER_MEDIA_SERVER"
    SIP_SERVER = "sip.SIP_SERVER"
    WOWZA_MEDIA_SERVER = "wowza.WOWZA_MEDIA_SERVER"
    EDGE = "1"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaSourceType(object):
    LIMELIGHT_LIVE = "limeLight.LIVE_STREAM"
    VELOCIX_LIVE = "velocix.VELOCIX_LIVE"
    FILE = "1"
    WEBCAM = "2"
    URL = "5"
    SEARCH_PROVIDER = "6"
    AKAMAI_LIVE = "29"
    MANUAL_LIVE_STREAM = "30"
    AKAMAI_UNIVERSAL_LIVE = "31"
    LIVE_STREAM = "32"
    LIVE_CHANNEL = "33"
    RECORDED_LIVE = "34"
    CLIP = "35"
    KALTURA_RECORDED_LIVE = "36"
    LECTURE_CAPTURE = "37"
    LIVE_STREAM_ONTEXTDATA_CAPTIONS = "42"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaStorageProfileOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaStorageProfileProtocol(object):
    KONTIKI = "kontiki.KONTIKI"
    KALTURA_DC = "0"
    FTP = "1"
    SCP = "2"
    SFTP = "3"
    S3 = "6"
    LOCAL = "7"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaSyndicationFeedEntriesOrderBy(object):
    CREATED_AT_DESC = "-createdAt"
    RECENT = "recent"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaTaggedObjectType(object):
    ENTRY = "1"
    CATEGORY = "2"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaThumbAssetOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    DELETED_AT_ASC = "+deletedAt"
    SIZE_ASC = "+size"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    DELETED_AT_DESC = "-deletedAt"
    SIZE_DESC = "-size"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaThumbParamsOrderBy(object):

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaThumbParamsOutputOrderBy(object):

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaTubeMogulSyndicationFeedCategories(object):
    ANIMALS_AND_PETS = "Animals &amp; Pets"
    ARTS_AND_ANIMATION = "Arts &amp; Animation"
    AUTOS = "Autos"
    COMEDY = "Comedy"
    COMMERCIALS_PROMOTIONAL = "Commercials/Promotional"
    ENTERTAINMENT = "Entertainment"
    FAMILY_AND_KIDS = "Family &amp; Kids"
    HOW_TO_INSTRUCTIONAL_DIY = "How To/Instructional/DIY"
    MUSIC = "Music"
    NEWS_AND_BLOGS = "News &amp; Blogs"
    SCIENCE_AND_TECHNOLOGY = "Science &amp; Technology"
    SPORTS = "Sports"
    TRAVEL_AND_PLACES = "Travel &amp; Places"
    VIDEO_GAMES = "Video Games"
    VLOGS_PEOPLE = "Vlogs &amp; People"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaTubeMogulSyndicationFeedOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    NAME_ASC = "+name"
    PLAYLIST_ID_ASC = "+playlistId"
    TYPE_ASC = "+type"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    NAME_DESC = "-name"
    PLAYLIST_ID_DESC = "-playlistId"
    TYPE_DESC = "-type"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaUiConfOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaUploadTokenOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    CREATED_AT_DESC = "-createdAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaUserEntryExtendedStatus(object):
    PLAYBACK_COMPLETE = "viewHistory.PLAYBACK_COMPLETE"
    PLAYBACK_STARTED = "viewHistory.PLAYBACK_STARTED"
    VIEWED = "viewHistory.VIEWED"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaUserEntryOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaUserEntryStatus(object):
    QUIZ_SUBMITTED = "quiz.3"
    ACTIVE = "1"
    DELETED = "2"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaUserEntryType(object):
    QUIZ = "quiz.QUIZ"
    REGISTRATION = "registration.REGISTRATION"
    VIEW_HISTORY = "viewHistory.VIEW_HISTORY"
    WATCH_LATER = "watchLater.WATCH_LATER"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaUserLoginDataOrderBy(object):

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaUserOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    ID_ASC = "+id"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    ID_DESC = "-id"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaUserRoleOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    ID_ASC = "+id"
    NAME_ASC = "+name"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    ID_DESC = "-id"
    NAME_DESC = "-name"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaVideoCodec(object):
    NONE = ""
    APCH = "apch"
    APCN = "apcn"
    APCO = "apco"
    APCS = "apcs"
    AV1 = "av1"
    COPY = "copy"
    DNXHD = "dnxhd"
    DV = "dv"
    FLV = "flv"
    H263 = "h263"
    H264 = "h264"
    H264B = "h264b"
    H264H = "h264h"
    H264M = "h264m"
    H265 = "h265"
    MPEG2 = "mpeg2"
    MPEG4 = "mpeg4"
    THEORA = "theora"
    VP6 = "vp6"
    VP8 = "vp8"
    VP9 = "vp9"
    WMV2 = "wmv2"
    WMV3 = "wmv3"
    WVC1A = "wvc1a"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaWidgetOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    CREATED_AT_DESC = "-createdAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaYahooSyndicationFeedAdultValues(object):
    ADULT = "adult"
    NON_ADULT = "nonadult"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaYahooSyndicationFeedCategories(object):
    ACTION = "Action"
    ANIMALS = "Animals"
    ART_AND_ANIMATION = "Art &amp; Animation"
    COMMERCIALS = "Commercials"
    ENTERTAINMENT_AND_TV = "Entertainment &amp; TV"
    FAMILY = "Family"
    FOOD = "Food"
    FUNNY_VIDEOS = "Funny Videos"
    GAMES = "Games"
    HEALTH_AND_BEAUTY = "Health &amp; Beauty"
    HOW_TO = "How-To"
    MOVIES_AND_SHORTS = "Movies &amp; Shorts"
    MUSIC = "Music"
    NEWS_AND_POLITICS = "News &amp; Politics"
    PEOPLE_AND_VLOGS = "People &amp; Vlogs"
    PRODUCTS_AND_TECH = "Products &amp; Tech."
    SCIENCE_AND_ENVIRONMENT = "Science &amp; Environment"
    SPORTS = "Sports"
    TRANSPORTATION = "Transportation"
    TRAVEL = "Travel"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

# @package Kaltura
# @subpackage Client
class KalturaYahooSyndicationFeedOrderBy(object):
    CREATED_AT_ASC = "+createdAt"
    NAME_ASC = "+name"
    PLAYLIST_ID_ASC = "+playlistId"
    TYPE_ASC = "+type"
    UPDATED_AT_ASC = "+updatedAt"
    CREATED_AT_DESC = "-createdAt"
    NAME_DESC = "-name"
    PLAYLIST_ID_DESC = "-playlistId"
    TYPE_DESC = "-type"
    UPDATED_AT_DESC = "-updatedAt"

    def __init__(self, value):
        self.value = value

    def getValue(self):
        return self.value

########## classes ##########
# @package Kaltura
# @subpackage Client
class KalturaListResponse(KalturaObjectBase):
    def __init__(self,
            totalCount=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var int
        # @readonly
        self.totalCount = totalCount


    PROPERTY_LOADERS = {
        'totalCount': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaListResponse.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaListResponse")
        return kparams

    def getTotalCount(self):
        return self.totalCount


# @package Kaltura
# @subpackage Client
class KalturaBaseRestriction(KalturaObjectBase):
    def __init__(self):
        KalturaObjectBase.__init__(self)


    PROPERTY_LOADERS = {
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaBaseRestriction.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaBaseRestriction")
        return kparams


# @package Kaltura
# @subpackage Client
class KalturaAccessControl(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            partnerId=NotImplemented,
            name=NotImplemented,
            systemName=NotImplemented,
            description=NotImplemented,
            createdAt=NotImplemented,
            isDefault=NotImplemented,
            restrictions=NotImplemented,
            containsUnsuportedRestrictions=NotImplemented):
        KalturaObjectBase.__init__(self)

        # The id of the Access Control Profile
        # @var int
        # @readonly
        self.id = id

        # @var int
        # @readonly
        self.partnerId = partnerId

        # The name of the Access Control Profile
        # @var string
        self.name = name

        # System name of the Access Control Profile
        # @var string
        self.systemName = systemName

        # The description of the Access Control Profile
        # @var string
        self.description = description

        # Creation date as Unix timestamp (In seconds)
        # @var int
        # @readonly
        self.createdAt = createdAt

        # True if this Conversion Profile is the default
        # @var KalturaNullableBoolean
        self.isDefault = isDefault

        # Array of Access Control Restrictions
        # @var array of KalturaBaseRestriction
        self.restrictions = restrictions

        # Indicates that the access control profile is new and should be handled using KalturaAccessControlProfile object and accessControlProfile service
        # @var bool
        # @readonly
        self.containsUnsuportedRestrictions = containsUnsuportedRestrictions


    PROPERTY_LOADERS = {
        'id': getXmlNodeInt, 
        'partnerId': getXmlNodeInt, 
        'name': getXmlNodeText, 
        'systemName': getXmlNodeText, 
        'description': getXmlNodeText, 
        'createdAt': getXmlNodeInt, 
        'isDefault': (KalturaEnumsFactory.createInt, "KalturaNullableBoolean"), 
        'restrictions': (KalturaObjectFactory.createArray, 'KalturaBaseRestriction'), 
        'containsUnsuportedRestrictions': getXmlNodeBool, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaAccessControl.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaAccessControl")
        kparams.addStringIfDefined("name", self.name)
        kparams.addStringIfDefined("systemName", self.systemName)
        kparams.addStringIfDefined("description", self.description)
        kparams.addIntEnumIfDefined("isDefault", self.isDefault)
        kparams.addArrayIfDefined("restrictions", self.restrictions)
        return kparams

    def getId(self):
        return self.id

    def getPartnerId(self):
        return self.partnerId

    def getName(self):
        return self.name

    def setName(self, newName):
        self.name = newName

    def getSystemName(self):
        return self.systemName

    def setSystemName(self, newSystemName):
        self.systemName = newSystemName

    def getDescription(self):
        return self.description

    def setDescription(self, newDescription):
        self.description = newDescription

    def getCreatedAt(self):
        return self.createdAt

    def getIsDefault(self):
        return self.isDefault

    def setIsDefault(self, newIsDefault):
        self.isDefault = newIsDefault

    def getRestrictions(self):
        return self.restrictions

    def setRestrictions(self, newRestrictions):
        self.restrictions = newRestrictions

    def getContainsUnsuportedRestrictions(self):
        return self.containsUnsuportedRestrictions


# @package Kaltura
# @subpackage Client
class KalturaContextTypeHolder(KalturaObjectBase):
    def __init__(self,
            type=NotImplemented):
        KalturaObjectBase.__init__(self)

        # The type of the condition context
        # @var KalturaContextType
        self.type = type


    PROPERTY_LOADERS = {
        'type': (KalturaEnumsFactory.createString, "KalturaContextType"), 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaContextTypeHolder.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaContextTypeHolder")
        kparams.addStringEnumIfDefined("type", self.type)
        return kparams

    def getType(self):
        return self.type

    def setType(self, newType):
        self.type = newType


# @package Kaltura
# @subpackage Client
class KalturaAccessControlContextTypeHolder(KalturaContextTypeHolder):
    def __init__(self,
            type=NotImplemented):
        KalturaContextTypeHolder.__init__(self,
            type)


    PROPERTY_LOADERS = {
    }

    def fromXml(self, node):
        KalturaContextTypeHolder.fromXml(self, node)
        self.fromXmlImpl(node, KalturaAccessControlContextTypeHolder.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaContextTypeHolder.toParams(self)
        kparams.put("objectType", "KalturaAccessControlContextTypeHolder")
        return kparams


# @package Kaltura
# @subpackage Client
class KalturaAccessControlMessage(KalturaObjectBase):
    def __init__(self,
            message=NotImplemented,
            code=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.message = message

        # @var string
        self.code = code


    PROPERTY_LOADERS = {
        'message': getXmlNodeText, 
        'code': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaAccessControlMessage.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaAccessControlMessage")
        kparams.addStringIfDefined("message", self.message)
        kparams.addStringIfDefined("code", self.code)
        return kparams

    def getMessage(self):
        return self.message

    def setMessage(self, newMessage):
        self.message = newMessage

    def getCode(self):
        return self.code

    def setCode(self, newCode):
        self.code = newCode


# @package Kaltura
# @subpackage Client
class KalturaRuleAction(KalturaObjectBase):
    def __init__(self,
            type=NotImplemented):
        KalturaObjectBase.__init__(self)

        # The type of the action
        # @var KalturaRuleActionType
        # @readonly
        self.type = type


    PROPERTY_LOADERS = {
        'type': (KalturaEnumsFactory.createString, "KalturaRuleActionType"), 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaRuleAction.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaRuleAction")
        return kparams

    def getType(self):
        return self.type


# @package Kaltura
# @subpackage Client
class KalturaCondition(KalturaObjectBase):
    def __init__(self,
            type=NotImplemented,
            description=NotImplemented,
            not_=NotImplemented):
        KalturaObjectBase.__init__(self)

        # The type of the access control condition
        # @var KalturaConditionType
        # @readonly
        self.type = type

        # @var string
        self.description = description

        # @var bool
        self.not_ = not_


    PROPERTY_LOADERS = {
        'type': (KalturaEnumsFactory.createString, "KalturaConditionType"), 
        'description': getXmlNodeText, 
        'not_': getXmlNodeBool, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaCondition.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaCondition")
        kparams.addStringIfDefined("description", self.description)
        kparams.addBoolIfDefined("not", self.not_)
        return kparams

    def getType(self):
        return self.type

    def getDescription(self):
        return self.description

    def setDescription(self, newDescription):
        self.description = newDescription

    def getNot_(self):
        return self.not_

    def setNot_(self, newNot_):
        self.not_ = newNot_


# @package Kaltura
# @subpackage Client
class KalturaRule(KalturaObjectBase):
    def __init__(self,
            description=NotImplemented,
            ruleData=NotImplemented,
            message=NotImplemented,
            code=NotImplemented,
            actions=NotImplemented,
            conditions=NotImplemented,
            contexts=NotImplemented,
            stopProcessing=NotImplemented,
            forceAdminValidation=NotImplemented):
        KalturaObjectBase.__init__(self)

        # Short Rule Description
        # @var string
        self.description = description

        # Rule Custom Data to allow saving rule specific information
        # @var string
        self.ruleData = ruleData

        # Message to be thrown to the player in case the rule is fulfilled
        # @var string
        self.message = message

        # Code to be thrown to the player in case the rule is fulfilled
        # @var string
        self.code = code

        # Actions to be performed by the player in case the rule is fulfilled
        # @var array of KalturaRuleAction
        self.actions = actions

        # Conditions to validate the rule
        # @var array of KalturaCondition
        self.conditions = conditions

        # Indicates what contexts should be tested by this rule
        # @var array of KalturaContextTypeHolder
        self.contexts = contexts

        # Indicates that this rule is enough and no need to continue checking the rest of the rules
        # @var bool
        self.stopProcessing = stopProcessing

        # Indicates if we should force ks validation for admin ks users as well
        # @var KalturaNullableBoolean
        self.forceAdminValidation = forceAdminValidation


    PROPERTY_LOADERS = {
        'description': getXmlNodeText, 
        'ruleData': getXmlNodeText, 
        'message': getXmlNodeText, 
        'code': getXmlNodeText, 
        'actions': (KalturaObjectFactory.createArray, 'KalturaRuleAction'), 
        'conditions': (KalturaObjectFactory.createArray, 'KalturaCondition'), 
        'contexts': (KalturaObjectFactory.createArray, 'KalturaContextTypeHolder'), 
        'stopProcessing': getXmlNodeBool, 
        'forceAdminValidation': (KalturaEnumsFactory.createInt, "KalturaNullableBoolean"), 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaRule.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaRule")
        kparams.addStringIfDefined("description", self.description)
        kparams.addStringIfDefined("ruleData", self.ruleData)
        kparams.addStringIfDefined("message", self.message)
        kparams.addStringIfDefined("code", self.code)
        kparams.addArrayIfDefined("actions", self.actions)
        kparams.addArrayIfDefined("conditions", self.conditions)
        kparams.addArrayIfDefined("contexts", self.contexts)
        kparams.addBoolIfDefined("stopProcessing", self.stopProcessing)
        kparams.addIntEnumIfDefined("forceAdminValidation", self.forceAdminValidation)
        return kparams

    def getDescription(self):
        return self.description

    def setDescription(self, newDescription):
        self.description = newDescription

    def getRuleData(self):
        return self.ruleData

    def setRuleData(self, newRuleData):
        self.ruleData = newRuleData

    def getMessage(self):
        return self.message

    def setMessage(self, newMessage):
        self.message = newMessage

    def getCode(self):
        return self.code

    def setCode(self, newCode):
        self.code = newCode

    def getActions(self):
        return self.actions

    def setActions(self, newActions):
        self.actions = newActions

    def getConditions(self):
        return self.conditions

    def setConditions(self, newConditions):
        self.conditions = newConditions

    def getContexts(self):
        return self.contexts

    def setContexts(self, newContexts):
        self.contexts = newContexts

    def getStopProcessing(self):
        return self.stopProcessing

    def setStopProcessing(self, newStopProcessing):
        self.stopProcessing = newStopProcessing

    def getForceAdminValidation(self):
        return self.forceAdminValidation

    def setForceAdminValidation(self, newForceAdminValidation):
        self.forceAdminValidation = newForceAdminValidation


# @package Kaltura
# @subpackage Client
class KalturaAccessControlProfile(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            partnerId=NotImplemented,
            name=NotImplemented,
            systemName=NotImplemented,
            description=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented,
            isDefault=NotImplemented,
            rules=NotImplemented):
        KalturaObjectBase.__init__(self)

        # The id of the Access Control Profile
        # @var int
        # @readonly
        self.id = id

        # @var int
        # @readonly
        self.partnerId = partnerId

        # The name of the Access Control Profile
        # @var string
        self.name = name

        # System name of the Access Control Profile
        # @var string
        self.systemName = systemName

        # The description of the Access Control Profile
        # @var string
        self.description = description

        # Creation time as Unix timestamp (In seconds)
        # @var int
        # @readonly
        self.createdAt = createdAt

        # Update time as Unix timestamp (In seconds)
        # @var int
        # @readonly
        self.updatedAt = updatedAt

        # True if this access control profile is the partner default
        # @var KalturaNullableBoolean
        self.isDefault = isDefault

        # Array of access control rules
        # @var array of KalturaRule
        self.rules = rules


    PROPERTY_LOADERS = {
        'id': getXmlNodeInt, 
        'partnerId': getXmlNodeInt, 
        'name': getXmlNodeText, 
        'systemName': getXmlNodeText, 
        'description': getXmlNodeText, 
        'createdAt': getXmlNodeInt, 
        'updatedAt': getXmlNodeInt, 
        'isDefault': (KalturaEnumsFactory.createInt, "KalturaNullableBoolean"), 
        'rules': (KalturaObjectFactory.createArray, 'KalturaRule'), 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaAccessControlProfile.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaAccessControlProfile")
        kparams.addStringIfDefined("name", self.name)
        kparams.addStringIfDefined("systemName", self.systemName)
        kparams.addStringIfDefined("description", self.description)
        kparams.addIntEnumIfDefined("isDefault", self.isDefault)
        kparams.addArrayIfDefined("rules", self.rules)
        return kparams

    def getId(self):
        return self.id

    def getPartnerId(self):
        return self.partnerId

    def getName(self):
        return self.name

    def setName(self, newName):
        self.name = newName

    def getSystemName(self):
        return self.systemName

    def setSystemName(self, newSystemName):
        self.systemName = newSystemName

    def getDescription(self):
        return self.description

    def setDescription(self, newDescription):
        self.description = newDescription

    def getCreatedAt(self):
        return self.createdAt

    def getUpdatedAt(self):
        return self.updatedAt

    def getIsDefault(self):
        return self.isDefault

    def setIsDefault(self, newIsDefault):
        self.isDefault = newIsDefault

    def getRules(self):
        return self.rules

    def setRules(self, newRules):
        self.rules = newRules


# @package Kaltura
# @subpackage Client
class KalturaKeyValue(KalturaObjectBase):
    """A key value pair representation to return an array of key-value pairs (associative array)"""

    def __init__(self,
            key=NotImplemented,
            value=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.key = key

        # @var string
        self.value = value


    PROPERTY_LOADERS = {
        'key': getXmlNodeText, 
        'value': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaKeyValue.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaKeyValue")
        kparams.addStringIfDefined("key", self.key)
        kparams.addStringIfDefined("value", self.value)
        return kparams

    def getKey(self):
        return self.key

    def setKey(self, newKey):
        self.key = newKey

    def getValue(self):
        return self.value

    def setValue(self, newValue):
        self.value = newValue


# @package Kaltura
# @subpackage Client
class KalturaAccessControlScope(KalturaObjectBase):
    def __init__(self,
            referrer=NotImplemented,
            ip=NotImplemented,
            ks=NotImplemented,
            userAgent=NotImplemented,
            time=NotImplemented,
            contexts=NotImplemented,
            hashes=NotImplemented):
        KalturaObjectBase.__init__(self)

        # URL to be used to test domain conditions.
        # @var string
        self.referrer = referrer

        # IP to be used to test geographic location conditions.
        # @var string
        self.ip = ip

        # Kaltura session to be used to test session and user conditions.
        # @var string
        self.ks = ks

        # Browser or client application to be used to test agent conditions.
        # @var string
        self.userAgent = userAgent

        # Unix timestamp (In seconds) to be used to test entry scheduling, keep null to use now.
        # @var int
        self.time = time

        # Indicates what contexts should be tested. No contexts means any context.
        # @var array of KalturaAccessControlContextTypeHolder
        self.contexts = contexts

        # Array of hashes to pass to the access control profile scope
        # @var array of KalturaKeyValue
        self.hashes = hashes


    PROPERTY_LOADERS = {
        'referrer': getXmlNodeText, 
        'ip': getXmlNodeText, 
        'ks': getXmlNodeText, 
        'userAgent': getXmlNodeText, 
        'time': getXmlNodeInt, 
        'contexts': (KalturaObjectFactory.createArray, 'KalturaAccessControlContextTypeHolder'), 
        'hashes': (KalturaObjectFactory.createArray, 'KalturaKeyValue'), 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaAccessControlScope.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaAccessControlScope")
        kparams.addStringIfDefined("referrer", self.referrer)
        kparams.addStringIfDefined("ip", self.ip)
        kparams.addStringIfDefined("ks", self.ks)
        kparams.addStringIfDefined("userAgent", self.userAgent)
        kparams.addIntIfDefined("time", self.time)
        kparams.addArrayIfDefined("contexts", self.contexts)
        kparams.addArrayIfDefined("hashes", self.hashes)
        return kparams

    def getReferrer(self):
        return self.referrer

    def setReferrer(self, newReferrer):
        self.referrer = newReferrer

    def getIp(self):
        return self.ip

    def setIp(self, newIp):
        self.ip = newIp

    def getKs(self):
        return self.ks

    def setKs(self, newKs):
        self.ks = newKs

    def getUserAgent(self):
        return self.userAgent

    def setUserAgent(self, newUserAgent):
        self.userAgent = newUserAgent

    def getTime(self):
        return self.time

    def setTime(self, newTime):
        self.time = newTime

    def getContexts(self):
        return self.contexts

    def setContexts(self, newContexts):
        self.contexts = newContexts

    def getHashes(self):
        return self.hashes

    def setHashes(self, newHashes):
        self.hashes = newHashes


# @package Kaltura
# @subpackage Client
class KalturaReportFilter(KalturaObjectBase):
    def __init__(self,
            dimension=NotImplemented,
            values=NotImplemented):
        KalturaObjectBase.__init__(self)

        # The dimension whose values should be filtered
        # @var string
        self.dimension = dimension

        # The (comma separated) values to include in the filter
        # @var string
        self.values = values


    PROPERTY_LOADERS = {
        'dimension': getXmlNodeText, 
        'values': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaReportFilter.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaReportFilter")
        kparams.addStringIfDefined("dimension", self.dimension)
        kparams.addStringIfDefined("values", self.values)
        return kparams

    def getDimension(self):
        return self.dimension

    def setDimension(self, newDimension):
        self.dimension = newDimension

    def getValues(self):
        return self.values

    def setValues(self, newValues):
        self.values = newValues


# @package Kaltura
# @subpackage Client
class KalturaAnalyticsFilter(KalturaObjectBase):
    def __init__(self,
            from_time=NotImplemented,
            to_time=NotImplemented,
            metrics=NotImplemented,
            utcOffset=NotImplemented,
            dimensions=NotImplemented,
            filters=NotImplemented,
            orderBy=NotImplemented):
        KalturaObjectBase.__init__(self)

        # Query start time (in local time) MM/dd/yyyy HH:mi
        # @var string
        self.from_time = from_time

        # Query end time (in local time) MM/dd/yyyy HH:mi
        # @var string
        self.to_time = to_time

        # Comma separated metrics list
        # @var string
        self.metrics = metrics

        # Timezone offset from UTC (in minutes)
        # @var float
        self.utcOffset = utcOffset

        # Comma separated dimensions list
        # @var string
        self.dimensions = dimensions

        # Array of filters
        # @var array of KalturaReportFilter
        self.filters = filters

        # Query order by metric/dimension
        # @var string
        self.orderBy = orderBy


    PROPERTY_LOADERS = {
        'from_time': getXmlNodeText, 
        'to_time': getXmlNodeText, 
        'metrics': getXmlNodeText, 
        'utcOffset': getXmlNodeFloat, 
        'dimensions': getXmlNodeText, 
        'filters': (KalturaObjectFactory.createArray, 'KalturaReportFilter'), 
        'orderBy': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaAnalyticsFilter.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaAnalyticsFilter")
        kparams.addStringIfDefined("from_time", self.from_time)
        kparams.addStringIfDefined("to_time", self.to_time)
        kparams.addStringIfDefined("metrics", self.metrics)
        kparams.addFloatIfDefined("utcOffset", self.utcOffset)
        kparams.addStringIfDefined("dimensions", self.dimensions)
        kparams.addArrayIfDefined("filters", self.filters)
        kparams.addStringIfDefined("orderBy", self.orderBy)
        return kparams

    def getFrom_time(self):
        return self.from_time

    def setFrom_time(self, newFrom_time):
        self.from_time = newFrom_time

    def getTo_time(self):
        return self.to_time

    def setTo_time(self, newTo_time):
        self.to_time = newTo_time

    def getMetrics(self):
        return self.metrics

    def setMetrics(self, newMetrics):
        self.metrics = newMetrics

    def getUtcOffset(self):
        return self.utcOffset

    def setUtcOffset(self, newUtcOffset):
        self.utcOffset = newUtcOffset

    def getDimensions(self):
        return self.dimensions

    def setDimensions(self, newDimensions):
        self.dimensions = newDimensions

    def getFilters(self):
        return self.filters

    def setFilters(self, newFilters):
        self.filters = newFilters

    def getOrderBy(self):
        return self.orderBy

    def setOrderBy(self, newOrderBy):
        self.orderBy = newOrderBy


# @package Kaltura
# @subpackage Client
class KalturaApiExceptionArg(KalturaObjectBase):
    def __init__(self,
            name=NotImplemented,
            value=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.name = name

        # @var string
        self.value = value


    PROPERTY_LOADERS = {
        'name': getXmlNodeText, 
        'value': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaApiExceptionArg.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaApiExceptionArg")
        kparams.addStringIfDefined("name", self.name)
        kparams.addStringIfDefined("value", self.value)
        return kparams

    def getName(self):
        return self.name

    def setName(self, newName):
        self.name = newName

    def getValue(self):
        return self.value

    def setValue(self, newValue):
        self.value = newValue


# @package Kaltura
# @subpackage Client
class KalturaAppToken(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            token=NotImplemented,
            partnerId=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented,
            status=NotImplemented,
            expiry=NotImplemented,
            sessionType=NotImplemented,
            sessionUserId=NotImplemented,
            sessionDuration=NotImplemented,
            sessionPrivileges=NotImplemented,
            hashType=NotImplemented,
            description=NotImplemented):
        KalturaObjectBase.__init__(self)

        # The id of the application token
        # @var string
        # @readonly
        self.id = id

        # The application token
        # @var string
        # @readonly
        self.token = token

        # @var int
        # @readonly
        self.partnerId = partnerId

        # Creation time as Unix timestamp (In seconds)
        # @var int
        # @readonly
        self.createdAt = createdAt

        # Update time as Unix timestamp (In seconds)
        # @var int
        # @readonly
        self.updatedAt = updatedAt

        # Application token status
        # @var KalturaAppTokenStatus
        # @readonly
        self.status = status

        # Expiry time of current token (unix timestamp in seconds)
        # @var int
        self.expiry = expiry

        # Type of KS (Kaltura Session) that created using the current token
        # @var KalturaSessionType
        self.sessionType = sessionType

        # User id of KS (Kaltura Session) that created using the current token
        # @var string
        self.sessionUserId = sessionUserId

        # Expiry duration of KS (Kaltura Session) that created using the current token (in seconds)
        # @var int
        self.sessionDuration = sessionDuration

        # Comma separated privileges to be applied on KS (Kaltura Session) that created using the current token
        # @var string
        self.sessionPrivileges = sessionPrivileges

        # @var KalturaAppTokenHashType
        self.hashType = hashType

        # @var string
        self.description = description


    PROPERTY_LOADERS = {
        'id': getXmlNodeText, 
        'token': getXmlNodeText, 
        'partnerId': getXmlNodeInt, 
        'createdAt': getXmlNodeInt, 
        'updatedAt': getXmlNodeInt, 
        'status': (KalturaEnumsFactory.createInt, "KalturaAppTokenStatus"), 
        'expiry': getXmlNodeInt, 
        'sessionType': (KalturaEnumsFactory.createInt, "KalturaSessionType"), 
        'sessionUserId': getXmlNodeText, 
        'sessionDuration': getXmlNodeInt, 
        'sessionPrivileges': getXmlNodeText, 
        'hashType': (KalturaEnumsFactory.createString, "KalturaAppTokenHashType"), 
        'description': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaAppToken.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaAppToken")
        kparams.addIntIfDefined("expiry", self.expiry)
        kparams.addIntEnumIfDefined("sessionType", self.sessionType)
        kparams.addStringIfDefined("sessionUserId", self.sessionUserId)
        kparams.addIntIfDefined("sessionDuration", self.sessionDuration)
        kparams.addStringIfDefined("sessionPrivileges", self.sessionPrivileges)
        kparams.addStringEnumIfDefined("hashType", self.hashType)
        kparams.addStringIfDefined("description", self.description)
        return kparams

    def getId(self):
        return self.id

    def getToken(self):
        return self.token

    def getPartnerId(self):
        return self.partnerId

    def getCreatedAt(self):
        return self.createdAt

    def getUpdatedAt(self):
        return self.updatedAt

    def getStatus(self):
        return self.status

    def getExpiry(self):
        return self.expiry

    def setExpiry(self, newExpiry):
        self.expiry = newExpiry

    def getSessionType(self):
        return self.sessionType

    def setSessionType(self, newSessionType):
        self.sessionType = newSessionType

    def getSessionUserId(self):
        return self.sessionUserId

    def setSessionUserId(self, newSessionUserId):
        self.sessionUserId = newSessionUserId

    def getSessionDuration(self):
        return self.sessionDuration

    def setSessionDuration(self, newSessionDuration):
        self.sessionDuration = newSessionDuration

    def getSessionPrivileges(self):
        return self.sessionPrivileges

    def setSessionPrivileges(self, newSessionPrivileges):
        self.sessionPrivileges = newSessionPrivileges

    def getHashType(self):
        return self.hashType

    def setHashType(self, newHashType):
        self.hashType = newHashType

    def getDescription(self):
        return self.description

    def setDescription(self, newDescription):
        self.description = newDescription


# @package Kaltura
# @subpackage Client
class KalturaAsset(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            entryId=NotImplemented,
            partnerId=NotImplemented,
            version=NotImplemented,
            size=NotImplemented,
            tags=NotImplemented,
            fileExt=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented,
            deletedAt=NotImplemented,
            description=NotImplemented,
            partnerData=NotImplemented,
            partnerDescription=NotImplemented,
            actualSourceAssetParamsIds=NotImplemented,
            sizeInBytes=NotImplemented):
        KalturaObjectBase.__init__(self)

        # The ID of the Flavor Asset
        # @var string
        # @readonly
        self.id = id

        # The entry ID of the Flavor Asset
        # @var string
        # @readonly
        self.entryId = entryId

        # @var int
        # @readonly
        self.partnerId = partnerId

        # The version of the Flavor Asset
        # @var int
        # @readonly
        self.version = version

        # The size (in KBytes) of the Flavor Asset
        # @var int
        # @readonly
        self.size = size

        # Tags used to identify the Flavor Asset in various scenarios
        # @var string
        self.tags = tags

        # The file extension
        # @var string
        # @insertonly
        self.fileExt = fileExt

        # @var int
        # @readonly
        self.createdAt = createdAt

        # @var int
        # @readonly
        self.updatedAt = updatedAt

        # @var int
        # @readonly
        self.deletedAt = deletedAt

        # System description, error message, warnings and failure cause.
        # @var string
        # @readonly
        self.description = description

        # Partner private data
        # @var string
        self.partnerData = partnerData

        # Partner friendly description
        # @var string
        self.partnerDescription = partnerDescription

        # Comma separated list of source flavor params ids
        # @var string
        self.actualSourceAssetParamsIds = actualSourceAssetParamsIds

        # The size (in Bytes) of the asset
        # @var int
        # @readonly
        self.sizeInBytes = sizeInBytes


    PROPERTY_LOADERS = {
        'id': getXmlNodeText, 
        'entryId': getXmlNodeText, 
        'partnerId': getXmlNodeInt, 
        'version': getXmlNodeInt, 
        'size': getXmlNodeInt, 
        'tags': getXmlNodeText, 
        'fileExt': getXmlNodeText, 
        'createdAt': getXmlNodeInt, 
        'updatedAt': getXmlNodeInt, 
        'deletedAt': getXmlNodeInt, 
        'description': getXmlNodeText, 
        'partnerData': getXmlNodeText, 
        'partnerDescription': getXmlNodeText, 
        'actualSourceAssetParamsIds': getXmlNodeText, 
        'sizeInBytes': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaAsset.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaAsset")
        kparams.addStringIfDefined("tags", self.tags)
        kparams.addStringIfDefined("fileExt", self.fileExt)
        kparams.addStringIfDefined("partnerData", self.partnerData)
        kparams.addStringIfDefined("partnerDescription", self.partnerDescription)
        kparams.addStringIfDefined("actualSourceAssetParamsIds", self.actualSourceAssetParamsIds)
        return kparams

    def getId(self):
        return self.id

    def getEntryId(self):
        return self.entryId

    def getPartnerId(self):
        return self.partnerId

    def getVersion(self):
        return self.version

    def getSize(self):
        return self.size

    def getTags(self):
        return self.tags

    def setTags(self, newTags):
        self.tags = newTags

    def getFileExt(self):
        return self.fileExt

    def setFileExt(self, newFileExt):
        self.fileExt = newFileExt

    def getCreatedAt(self):
        return self.createdAt

    def getUpdatedAt(self):
        return self.updatedAt

    def getDeletedAt(self):
        return self.deletedAt

    def getDescription(self):
        return self.description

    def getPartnerData(self):
        return self.partnerData

    def setPartnerData(self, newPartnerData):
        self.partnerData = newPartnerData

    def getPartnerDescription(self):
        return self.partnerDescription

    def setPartnerDescription(self, newPartnerDescription):
        self.partnerDescription = newPartnerDescription

    def getActualSourceAssetParamsIds(self):
        return self.actualSourceAssetParamsIds

    def setActualSourceAssetParamsIds(self, newActualSourceAssetParamsIds):
        self.actualSourceAssetParamsIds = newActualSourceAssetParamsIds

    def getSizeInBytes(self):
        return self.sizeInBytes


# @package Kaltura
# @subpackage Client
class KalturaString(KalturaObjectBase):
    """A string representation to return an array of strings"""

    def __init__(self,
            value=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.value = value


    PROPERTY_LOADERS = {
        'value': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaString.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaString")
        kparams.addStringIfDefined("value", self.value)
        return kparams

    def getValue(self):
        return self.value

    def setValue(self, newValue):
        self.value = newValue


# @package Kaltura
# @subpackage Client
class KalturaAssetParams(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            partnerId=NotImplemented,
            name=NotImplemented,
            systemName=NotImplemented,
            description=NotImplemented,
            createdAt=NotImplemented,
            isSystemDefault=NotImplemented,
            tags=NotImplemented,
            requiredPermissions=NotImplemented,
            sourceRemoteStorageProfileId=NotImplemented,
            remoteStorageProfileIds=NotImplemented,
            mediaParserType=NotImplemented,
            sourceAssetParamsIds=NotImplemented):
        KalturaObjectBase.__init__(self)

        # The id of the Flavor Params
        # @var int
        # @readonly
        self.id = id

        # @var int
        self.partnerId = partnerId

        # The name of the Flavor Params
        # @var string
        self.name = name

        # System name of the Flavor Params
        # @var string
        self.systemName = systemName

        # The description of the Flavor Params
        # @var string
        self.description = description

        # Creation date as Unix timestamp (In seconds)
        # @var int
        # @readonly
        self.createdAt = createdAt

        # True if those Flavor Params are part of system defaults
        # @var KalturaNullableBoolean
        # @readonly
        self.isSystemDefault = isSystemDefault

        # The Flavor Params tags are used to identify the flavor for different usage (e.g. web, hd, mobile)
        # @var string
        self.tags = tags

        # Array of partner permisison names that required for using this asset params
        # @var array of KalturaString
        self.requiredPermissions = requiredPermissions

        # Id of remote storage profile that used to get the source, zero indicates Kaltura data center
        # @var int
        self.sourceRemoteStorageProfileId = sourceRemoteStorageProfileId

        # Comma seperated ids of remote storage profiles that the flavor distributed to, the distribution done by the conversion engine
        # @var int
        self.remoteStorageProfileIds = remoteStorageProfileIds

        # Media parser type to be used for post-conversion validation
        # @var KalturaMediaParserType
        self.mediaParserType = mediaParserType

        # Comma seperated ids of source flavor params this flavor is created from
        # @var string
        self.sourceAssetParamsIds = sourceAssetParamsIds


    PROPERTY_LOADERS = {
        'id': getXmlNodeInt, 
        'partnerId': getXmlNodeInt, 
        'name': getXmlNodeText, 
        'systemName': getXmlNodeText, 
        'description': getXmlNodeText, 
        'createdAt': getXmlNodeInt, 
        'isSystemDefault': (KalturaEnumsFactory.createInt, "KalturaNullableBoolean"), 
        'tags': getXmlNodeText, 
        'requiredPermissions': (KalturaObjectFactory.createArray, 'KalturaString'), 
        'sourceRemoteStorageProfileId': getXmlNodeInt, 
        'remoteStorageProfileIds': getXmlNodeInt, 
        'mediaParserType': (KalturaEnumsFactory.createString, "KalturaMediaParserType"), 
        'sourceAssetParamsIds': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaAssetParams.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaAssetParams")
        kparams.addIntIfDefined("partnerId", self.partnerId)
        kparams.addStringIfDefined("name", self.name)
        kparams.addStringIfDefined("systemName", self.systemName)
        kparams.addStringIfDefined("description", self.description)
        kparams.addStringIfDefined("tags", self.tags)
        kparams.addArrayIfDefined("requiredPermissions", self.requiredPermissions)
        kparams.addIntIfDefined("sourceRemoteStorageProfileId", self.sourceRemoteStorageProfileId)
        kparams.addIntIfDefined("remoteStorageProfileIds", self.remoteStorageProfileIds)
        kparams.addStringEnumIfDefined("mediaParserType", self.mediaParserType)
        kparams.addStringIfDefined("sourceAssetParamsIds", self.sourceAssetParamsIds)
        return kparams

    def getId(self):
        return self.id

    def getPartnerId(self):
        return self.partnerId

    def setPartnerId(self, newPartnerId):
        self.partnerId = newPartnerId

    def getName(self):
        return self.name

    def setName(self, newName):
        self.name = newName

    def getSystemName(self):
        return self.systemName

    def setSystemName(self, newSystemName):
        self.systemName = newSystemName

    def getDescription(self):
        return self.description

    def setDescription(self, newDescription):
        self.description = newDescription

    def getCreatedAt(self):
        return self.createdAt

    def getIsSystemDefault(self):
        return self.isSystemDefault

    def getTags(self):
        return self.tags

    def setTags(self, newTags):
        self.tags = newTags

    def getRequiredPermissions(self):
        return self.requiredPermissions

    def setRequiredPermissions(self, newRequiredPermissions):
        self.requiredPermissions = newRequiredPermissions

    def getSourceRemoteStorageProfileId(self):
        return self.sourceRemoteStorageProfileId

    def setSourceRemoteStorageProfileId(self, newSourceRemoteStorageProfileId):
        self.sourceRemoteStorageProfileId = newSourceRemoteStorageProfileId

    def getRemoteStorageProfileIds(self):
        return self.remoteStorageProfileIds

    def setRemoteStorageProfileIds(self, newRemoteStorageProfileIds):
        self.remoteStorageProfileIds = newRemoteStorageProfileIds

    def getMediaParserType(self):
        return self.mediaParserType

    def setMediaParserType(self, newMediaParserType):
        self.mediaParserType = newMediaParserType

    def getSourceAssetParamsIds(self):
        return self.sourceAssetParamsIds

    def setSourceAssetParamsIds(self, newSourceAssetParamsIds):
        self.sourceAssetParamsIds = newSourceAssetParamsIds


# @package Kaltura
# @subpackage Client
class KalturaResource(KalturaObjectBase):
    """Used to ingest entry object, as single resource or list of resources accompanied by asset params ids."""

    def __init__(self):
        KalturaObjectBase.__init__(self)


    PROPERTY_LOADERS = {
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaResource.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaResource")
        return kparams


# @package Kaltura
# @subpackage Client
class KalturaContentResource(KalturaResource):
    """Is a unified way to add content to Kaltura whether it's an uploaded file, webcam recording, imported URL or existing file sync."""

    def __init__(self):
        KalturaResource.__init__(self)


    PROPERTY_LOADERS = {
    }

    def fromXml(self, node):
        KalturaResource.fromXml(self, node)
        self.fromXmlImpl(node, KalturaContentResource.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaResource.toParams(self)
        kparams.put("objectType", "KalturaContentResource")
        return kparams


# @package Kaltura
# @subpackage Client
class KalturaAssetParamsResourceContainer(KalturaResource):
    def __init__(self,
            resource=NotImplemented,
            assetParamsId=NotImplemented):
        KalturaResource.__init__(self)

        # The content resource to associate with asset params
        # @var KalturaContentResource
        self.resource = resource

        # The asset params to associate with the reaource
        # @var int
        self.assetParamsId = assetParamsId


    PROPERTY_LOADERS = {
        'resource': (KalturaObjectFactory.create, 'KalturaContentResource'), 
        'assetParamsId': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaResource.fromXml(self, node)
        self.fromXmlImpl(node, KalturaAssetParamsResourceContainer.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaResource.toParams(self)
        kparams.put("objectType", "KalturaAssetParamsResourceContainer")
        kparams.addObjectIfDefined("resource", self.resource)
        kparams.addIntIfDefined("assetParamsId", self.assetParamsId)
        return kparams

    def getResource(self):
        return self.resource

    def setResource(self, newResource):
        self.resource = newResource

    def getAssetParamsId(self):
        return self.assetParamsId

    def setAssetParamsId(self, newAssetParamsId):
        self.assetParamsId = newAssetParamsId


# @package Kaltura
# @subpackage Client
class KalturaAssetServeOptions(KalturaObjectBase):
    def __init__(self,
            download=NotImplemented,
            referrer=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var bool
        self.download = download

        # @var string
        self.referrer = referrer


    PROPERTY_LOADERS = {
        'download': getXmlNodeBool, 
        'referrer': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaAssetServeOptions.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaAssetServeOptions")
        kparams.addBoolIfDefined("download", self.download)
        kparams.addStringIfDefined("referrer", self.referrer)
        return kparams

    def getDownload(self):
        return self.download

    def setDownload(self, newDownload):
        self.download = newDownload

    def getReferrer(self):
        return self.referrer

    def setReferrer(self, newReferrer):
        self.referrer = newReferrer


# @package Kaltura
# @subpackage Client
class KalturaAuthentication(KalturaObjectBase):
    def __init__(self,
            qrCode=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.qrCode = qrCode


    PROPERTY_LOADERS = {
        'qrCode': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaAuthentication.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaAuthentication")
        kparams.addStringIfDefined("qrCode", self.qrCode)
        return kparams

    def getQrCode(self):
        return self.qrCode

    def setQrCode(self, newQrCode):
        self.qrCode = newQrCode


# @package Kaltura
# @subpackage Client
class KalturaOperationAttributes(KalturaObjectBase):
    """Base class to all operation attributes types"""

    def __init__(self):
        KalturaObjectBase.__init__(self)


    PROPERTY_LOADERS = {
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaOperationAttributes.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaOperationAttributes")
        return kparams


# @package Kaltura
# @subpackage Client
class KalturaBaseEntry(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            name=NotImplemented,
            description=NotImplemented,
            partnerId=NotImplemented,
            userId=NotImplemented,
            creatorId=NotImplemented,
            tags=NotImplemented,
            adminTags=NotImplemented,
            categories=NotImplemented,
            categoriesIds=NotImplemented,
            status=NotImplemented,
            moderationStatus=NotImplemented,
            moderationCount=NotImplemented,
            type=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented,
            rank=NotImplemented,
            totalRank=NotImplemented,
            votes=NotImplemented,
            groupId=NotImplemented,
            partnerData=NotImplemented,
            downloadUrl=NotImplemented,
            searchText=NotImplemented,
            licenseType=NotImplemented,
            version=NotImplemented,
            thumbnailUrl=NotImplemented,
            accessControlId=NotImplemented,
            startDate=NotImplemented,
            endDate=NotImplemented,
            referenceId=NotImplemented,
            replacingEntryId=NotImplemented,
            replacedEntryId=NotImplemented,
            replacementStatus=NotImplemented,
            partnerSortValue=NotImplemented,
            conversionProfileId=NotImplemented,
            redirectEntryId=NotImplemented,
            rootEntryId=NotImplemented,
            parentEntryId=NotImplemented,
            operationAttributes=NotImplemented,
            entitledUsersEdit=NotImplemented,
            entitledUsersPublish=NotImplemented,
            entitledUsersView=NotImplemented,
            capabilities=NotImplemented,
            templateEntryId=NotImplemented,
            displayInSearch=NotImplemented,
            application=NotImplemented,
            applicationVersion=NotImplemented,
            blockAutoTranscript=NotImplemented):
        KalturaObjectBase.__init__(self)

        # Auto generated 10 characters alphanumeric string
        # @var string
        # @readonly
        self.id = id

        # Entry name (Min 1 chars)
        # @var string
        self.name = name

        # Entry description
        # @var string
        self.description = description

        # @var int
        # @readonly
        self.partnerId = partnerId

        # The ID of the user who is the owner of this entry
        # @var string
        self.userId = userId

        # The ID of the user who created this entry
        # @var string
        # @insertonly
        self.creatorId = creatorId

        # Entry tags
        # @var string
        self.tags = tags

        # Entry admin tags can be updated only by administrators
        # @var string
        self.adminTags = adminTags

        # Comma separated list of full names of categories to which this entry belongs. Only categories that don't have entitlement (privacy context) are listed, to retrieve the full list of categories, use the categoryEntry.list action.
        # @var string
        self.categories = categories

        # Comma separated list of ids of categories to which this entry belongs. Only categories that don't have entitlement (privacy context) are listed, to retrieve the full list of categories, use the categoryEntry.list action.
        # @var string
        self.categoriesIds = categoriesIds

        # @var KalturaEntryStatus
        # @readonly
        self.status = status

        # Entry moderation status
        # @var KalturaEntryModerationStatus
        # @readonly
        self.moderationStatus = moderationStatus

        # Number of moderation requests waiting for this entry
        # @var int
        # @readonly
        self.moderationCount = moderationCount

        # The type of the entry, this is auto filled by the derived entry object
        # @var KalturaEntryType
        self.type = type

        # Entry creation date as Unix timestamp (In seconds)
        # @var int
        # @readonly
        self.createdAt = createdAt

        # Entry update date as Unix timestamp (In seconds)
        # @var int
        # @readonly
        self.updatedAt = updatedAt

        # The calculated average rank. rank = totalRank / votes
        # @var float
        # @readonly
        self.rank = rank

        # The sum of all rank values submitted to the baseEntry.anonymousRank action
        # @var int
        # @readonly
        self.totalRank = totalRank

        # A count of all requests made to the baseEntry.anonymousRank action
        # @var int
        # @readonly
        self.votes = votes

        # @var int
        self.groupId = groupId

        # Can be used to store various partner related data as a string
        # @var string
        self.partnerData = partnerData

        # Download URL for the entry
        # @var string
        # @readonly
        self.downloadUrl = downloadUrl

        # Indexed search text for full text search
        # @var string
        # @readonly
        self.searchText = searchText

        # License type used for this entry
        # @var KalturaLicenseType
        self.licenseType = licenseType

        # Version of the entry data
        # @var int
        # @readonly
        self.version = version

        # Thumbnail URL
        # @var string
        # @readonly
        self.thumbnailUrl = thumbnailUrl

        # The Access Control ID assigned to this entry (null when not set, send -1 to remove)
        # @var int
        self.accessControlId = accessControlId

        # Entry scheduling start date (null when not set, send -1 to remove)
        # @var int
        self.startDate = startDate

        # Entry scheduling end date (null when not set, send -1 to remove)
        # @var int
        self.endDate = endDate

        # Entry external reference id
        # @var string
        self.referenceId = referenceId

        # ID of temporary entry that will replace this entry when it's approved and ready for replacement
        # @var string
        # @readonly
        self.replacingEntryId = replacingEntryId

        # ID of the entry that will be replaced when the replacement approved and this entry is ready
        # @var string
        # @readonly
        self.replacedEntryId = replacedEntryId

        # Status of the replacement readiness and approval
        # @var KalturaEntryReplacementStatus
        # @readonly
        self.replacementStatus = replacementStatus

        # Can be used to store various partner related data as a numeric value
        # @var int
        self.partnerSortValue = partnerSortValue

        # Override the default ingestion profile
        # @var int
        self.conversionProfileId = conversionProfileId

        # IF not empty, points to an entry ID the should replace this current entry's id.
        # @var string
        self.redirectEntryId = redirectEntryId

        # ID of source root entry, used for clipped, skipped and cropped entries that created from another entry
        # @var string
        # @readonly
        self.rootEntryId = rootEntryId

        # ID of source root entry, used for defining entires association
        # @var string
        self.parentEntryId = parentEntryId

        # clipping, skipping and cropping attributes that used to create this entry
        # @var array of KalturaOperationAttributes
        self.operationAttributes = operationAttributes

        # list of user ids that are entitled to edit the entry (no server enforcement) The difference between entitledUsersEdit, entitledUsersPublish and entitledUsersView is applicative only
        # @var string
        self.entitledUsersEdit = entitledUsersEdit

        # list of user ids that are entitled to publish the entry (no server enforcement) The difference between entitledUsersEdit, entitledUsersPublish and entitledUsersView is applicative only
        # @var string
        self.entitledUsersPublish = entitledUsersPublish

        # list of user ids that are entitled to view the entry (no server enforcement) The difference between entitledUsersEdit, entitledUsersPublish and entitledUsersView is applicative only
        # @var string
        self.entitledUsersView = entitledUsersView

        # Comma seperated string of the capabilities of the entry. Any capability needed can be added to this list.
        # @var string
        # @readonly
        self.capabilities = capabilities

        # Template entry id
        # @var string
        # @insertonly
        self.templateEntryId = templateEntryId

        # should we display this entry in search
        # @var KalturaEntryDisplayInSearchType
        self.displayInSearch = displayInSearch

        # Entry application
        # @var KalturaEntryApplication
        # @insertonly
        self.application = application

        # Entry application version
        # @var string
        # @insertonly
        self.applicationVersion = applicationVersion

        # Block auto transcript on Entry
        # @var bool
        self.blockAutoTranscript = blockAutoTranscript


    PROPERTY_LOADERS = {
        'id': getXmlNodeText, 
        'name': getXmlNodeText, 
        'description': getXmlNodeText, 
        'partnerId': getXmlNodeInt, 
        'userId': getXmlNodeText, 
        'creatorId': getXmlNodeText, 
        'tags': getXmlNodeText, 
        'adminTags': getXmlNodeText, 
        'categories': getXmlNodeText, 
        'categoriesIds': getXmlNodeText, 
        'status': (KalturaEnumsFactory.createString, "KalturaEntryStatus"), 
        'moderationStatus': (KalturaEnumsFactory.createInt, "KalturaEntryModerationStatus"), 
        'moderationCount': getXmlNodeInt, 
        'type': (KalturaEnumsFactory.createString, "KalturaEntryType"), 
        'createdAt': getXmlNodeInt, 
        'updatedAt': getXmlNodeInt, 
        'rank': getXmlNodeFloat, 
        'totalRank': getXmlNodeInt, 
        'votes': getXmlNodeInt, 
        'groupId': getXmlNodeInt, 
        'partnerData': getXmlNodeText, 
        'downloadUrl': getXmlNodeText, 
        'searchText': getXmlNodeText, 
        'licenseType': (KalturaEnumsFactory.createInt, "KalturaLicenseType"), 
        'version': getXmlNodeInt, 
        'thumbnailUrl': getXmlNodeText, 
        'accessControlId': getXmlNodeInt, 
        'startDate': getXmlNodeInt, 
        'endDate': getXmlNodeInt, 
        'referenceId': getXmlNodeText, 
        'replacingEntryId': getXmlNodeText, 
        'replacedEntryId': getXmlNodeText, 
        'replacementStatus': (KalturaEnumsFactory.createString, "KalturaEntryReplacementStatus"), 
        'partnerSortValue': getXmlNodeInt, 
        'conversionProfileId': getXmlNodeInt, 
        'redirectEntryId': getXmlNodeText, 
        'rootEntryId': getXmlNodeText, 
        'parentEntryId': getXmlNodeText, 
        'operationAttributes': (KalturaObjectFactory.createArray, 'KalturaOperationAttributes'), 
        'entitledUsersEdit': getXmlNodeText, 
        'entitledUsersPublish': getXmlNodeText, 
        'entitledUsersView': getXmlNodeText, 
        'capabilities': getXmlNodeText, 
        'templateEntryId': getXmlNodeText, 
        'displayInSearch': (KalturaEnumsFactory.createInt, "KalturaEntryDisplayInSearchType"), 
        'application': (KalturaEnumsFactory.createString, "KalturaEntryApplication"), 
        'applicationVersion': getXmlNodeText, 
        'blockAutoTranscript': getXmlNodeBool, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaBaseEntry.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaBaseEntry")
        kparams.addStringIfDefined("name", self.name)
        kparams.addStringIfDefined("description", self.description)
        kparams.addStringIfDefined("userId", self.userId)
        kparams.addStringIfDefined("creatorId", self.creatorId)
        kparams.addStringIfDefined("tags", self.tags)
        kparams.addStringIfDefined("adminTags", self.adminTags)
        kparams.addStringIfDefined("categories", self.categories)
        kparams.addStringIfDefined("categoriesIds", self.categoriesIds)
        kparams.addStringEnumIfDefined("type", self.type)
        kparams.addIntIfDefined("groupId", self.groupId)
        kparams.addStringIfDefined("partnerData", self.partnerData)
        kparams.addIntEnumIfDefined("licenseType", self.licenseType)
        kparams.addIntIfDefined("accessControlId", self.accessControlId)
        kparams.addIntIfDefined("startDate", self.startDate)
        kparams.addIntIfDefined("endDate", self.endDate)
        kparams.addStringIfDefined("referenceId", self.referenceId)
        kparams.addIntIfDefined("partnerSortValue", self.partnerSortValue)
        kparams.addIntIfDefined("conversionProfileId", self.conversionProfileId)
        kparams.addStringIfDefined("redirectEntryId", self.redirectEntryId)
        kparams.addStringIfDefined("parentEntryId", self.parentEntryId)
        kparams.addArrayIfDefined("operationAttributes", self.operationAttributes)
        kparams.addStringIfDefined("entitledUsersEdit", self.entitledUsersEdit)
        kparams.addStringIfDefined("entitledUsersPublish", self.entitledUsersPublish)
        kparams.addStringIfDefined("entitledUsersView", self.entitledUsersView)
        kparams.addStringIfDefined("templateEntryId", self.templateEntryId)
        kparams.addIntEnumIfDefined("displayInSearch", self.displayInSearch)
        kparams.addStringEnumIfDefined("application", self.application)
        kparams.addStringIfDefined("applicationVersion", self.applicationVersion)
        kparams.addBoolIfDefined("blockAutoTranscript", self.blockAutoTranscript)
        return kparams

    def getId(self):
        return self.id

    def getName(self):
        return self.name

    def setName(self, newName):
        self.name = newName

    def getDescription(self):
        return self.description

    def setDescription(self, newDescription):
        self.description = newDescription

    def getPartnerId(self):
        return self.partnerId

    def getUserId(self):
        return self.userId

    def setUserId(self, newUserId):
        self.userId = newUserId

    def getCreatorId(self):
        return self.creatorId

    def setCreatorId(self, newCreatorId):
        self.creatorId = newCreatorId

    def getTags(self):
        return self.tags

    def setTags(self, newTags):
        self.tags = newTags

    def getAdminTags(self):
        return self.adminTags

    def setAdminTags(self, newAdminTags):
        self.adminTags = newAdminTags

    def getCategories(self):
        return self.categories

    def setCategories(self, newCategories):
        self.categories = newCategories

    def getCategoriesIds(self):
        return self.categoriesIds

    def setCategoriesIds(self, newCategoriesIds):
        self.categoriesIds = newCategoriesIds

    def getStatus(self):
        return self.status

    def getModerationStatus(self):
        return self.moderationStatus

    def getModerationCount(self):
        return self.moderationCount

    def getType(self):
        return self.type

    def setType(self, newType):
        self.type = newType

    def getCreatedAt(self):
        return self.createdAt

    def getUpdatedAt(self):
        return self.updatedAt

    def getRank(self):
        return self.rank

    def getTotalRank(self):
        return self.totalRank

    def getVotes(self):
        return self.votes

    def getGroupId(self):
        return self.groupId

    def setGroupId(self, newGroupId):
        self.groupId = newGroupId

    def getPartnerData(self):
        return self.partnerData

    def setPartnerData(self, newPartnerData):
        self.partnerData = newPartnerData

    def getDownloadUrl(self):
        return self.downloadUrl

    def getSearchText(self):
        return self.searchText

    def getLicenseType(self):
        return self.licenseType

    def setLicenseType(self, newLicenseType):
        self.licenseType = newLicenseType

    def getVersion(self):
        return self.version

    def getThumbnailUrl(self):
        return self.thumbnailUrl

    def getAccessControlId(self):
        return self.accessControlId

    def setAccessControlId(self, newAccessControlId):
        self.accessControlId = newAccessControlId

    def getStartDate(self):
        return self.startDate

    def setStartDate(self, newStartDate):
        self.startDate = newStartDate

    def getEndDate(self):
        return self.endDate

    def setEndDate(self, newEndDate):
        self.endDate = newEndDate

    def getReferenceId(self):
        return self.referenceId

    def setReferenceId(self, newReferenceId):
        self.referenceId = newReferenceId

    def getReplacingEntryId(self):
        return self.replacingEntryId

    def getReplacedEntryId(self):
        return self.replacedEntryId

    def getReplacementStatus(self):
        return self.replacementStatus

    def getPartnerSortValue(self):
        return self.partnerSortValue

    def setPartnerSortValue(self, newPartnerSortValue):
        self.partnerSortValue = newPartnerSortValue

    def getConversionProfileId(self):
        return self.conversionProfileId

    def setConversionProfileId(self, newConversionProfileId):
        self.conversionProfileId = newConversionProfileId

    def getRedirectEntryId(self):
        return self.redirectEntryId

    def setRedirectEntryId(self, newRedirectEntryId):
        self.redirectEntryId = newRedirectEntryId

    def getRootEntryId(self):
        return self.rootEntryId

    def getParentEntryId(self):
        return self.parentEntryId

    def setParentEntryId(self, newParentEntryId):
        self.parentEntryId = newParentEntryId

    def getOperationAttributes(self):
        return self.operationAttributes

    def setOperationAttributes(self, newOperationAttributes):
        self.operationAttributes = newOperationAttributes

    def getEntitledUsersEdit(self):
        return self.entitledUsersEdit

    def setEntitledUsersEdit(self, newEntitledUsersEdit):
        self.entitledUsersEdit = newEntitledUsersEdit

    def getEntitledUsersPublish(self):
        return self.entitledUsersPublish

    def setEntitledUsersPublish(self, newEntitledUsersPublish):
        self.entitledUsersPublish = newEntitledUsersPublish

    def getEntitledUsersView(self):
        return self.entitledUsersView

    def setEntitledUsersView(self, newEntitledUsersView):
        self.entitledUsersView = newEntitledUsersView

    def getCapabilities(self):
        return self.capabilities

    def getTemplateEntryId(self):
        return self.templateEntryId

    def setTemplateEntryId(self, newTemplateEntryId):
        self.templateEntryId = newTemplateEntryId

    def getDisplayInSearch(self):
        return self.displayInSearch

    def setDisplayInSearch(self, newDisplayInSearch):
        self.displayInSearch = newDisplayInSearch

    def getApplication(self):
        return self.application

    def setApplication(self, newApplication):
        self.application = newApplication

    def getApplicationVersion(self):
        return self.applicationVersion

    def setApplicationVersion(self, newApplicationVersion):
        self.applicationVersion = newApplicationVersion

    def getBlockAutoTranscript(self):
        return self.blockAutoTranscript

    def setBlockAutoTranscript(self, newBlockAutoTranscript):
        self.blockAutoTranscript = newBlockAutoTranscript


# @package Kaltura
# @subpackage Client
class KalturaBaseEntryCloneOptionItem(KalturaObjectBase):
    def __init__(self):
        KalturaObjectBase.__init__(self)


    PROPERTY_LOADERS = {
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaBaseEntryCloneOptionItem.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaBaseEntryCloneOptionItem")
        return kparams


# @package Kaltura
# @subpackage Client
class KalturaBaseResponseProfile(KalturaObjectBase):
    def __init__(self):
        KalturaObjectBase.__init__(self)


    PROPERTY_LOADERS = {
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaBaseResponseProfile.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaBaseResponseProfile")
        return kparams


# @package Kaltura
# @subpackage Client
class KalturaBaseSyndicationFeed(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            feedUrl=NotImplemented,
            partnerId=NotImplemented,
            playlistId=NotImplemented,
            name=NotImplemented,
            status=NotImplemented,
            type=NotImplemented,
            landingPage=NotImplemented,
            createdAt=NotImplemented,
            allowEmbed=NotImplemented,
            playerUiconfId=NotImplemented,
            flavorParamId=NotImplemented,
            transcodeExistingContent=NotImplemented,
            addToDefaultConversionProfile=NotImplemented,
            categories=NotImplemented,
            storageId=NotImplemented,
            entriesOrderBy=NotImplemented,
            enforceEntitlement=NotImplemented,
            privacyContext=NotImplemented,
            updatedAt=NotImplemented,
            useCategoryEntries=NotImplemented,
            feedContentTypeHeader=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        # @readonly
        self.id = id

        # @var string
        # @readonly
        self.feedUrl = feedUrl

        # @var int
        # @readonly
        self.partnerId = partnerId

        # link a playlist that will set what content the feed will include
        # 	 if empty, all content will be included in feed
        # @var string
        self.playlistId = playlistId

        # feed name
        # @var string
        self.name = name

        # feed status
        # @var KalturaSyndicationFeedStatus
        # @readonly
        self.status = status

        # feed type
        # @var KalturaSyndicationFeedType
        # @insertonly
        self.type = type

        # Base URL for each video, on the partners site
        # 	 This is required by all syndication types.
        # @var string
        self.landingPage = landingPage

        # Creation date as Unix timestamp (In seconds)
        # @var int
        # @readonly
        self.createdAt = createdAt

        # allow_embed tells google OR yahoo weather to allow embedding the video on google OR yahoo video results
        # 	 or just to provide a link to the landing page.
        # 	 it is applied on the video-player_loc property in the XML (google)
        # 	 and addes media-player tag (yahoo)
        # @var bool
        self.allowEmbed = allowEmbed

        # Select a uiconf ID as player skin to include in the kwidget url
        # @var int
        self.playerUiconfId = playerUiconfId

        # @var int
        self.flavorParamId = flavorParamId

        # @var bool
        self.transcodeExistingContent = transcodeExistingContent

        # @var bool
        self.addToDefaultConversionProfile = addToDefaultConversionProfile

        # @var string
        self.categories = categories

        # @var int
        self.storageId = storageId

        # @var KalturaSyndicationFeedEntriesOrderBy
        self.entriesOrderBy = entriesOrderBy

        # Should enforce entitlement on feed entries
        # @var bool
        self.enforceEntitlement = enforceEntitlement

        # Set privacy context for search entries that assiged to private and public categories within a category privacy context.
        # @var string
        self.privacyContext = privacyContext

        # Update date as Unix timestamp (In seconds)
        # @var int
        # @readonly
        self.updatedAt = updatedAt

        # @var bool
        self.useCategoryEntries = useCategoryEntries

        # Feed content-type header value
        # @var string
        self.feedContentTypeHeader = feedContentTypeHeader


    PROPERTY_LOADERS = {
        'id': getXmlNodeText, 
        'feedUrl': getXmlNodeText, 
        'partnerId': getXmlNodeInt, 
        'playlistId': getXmlNodeText, 
        'name': getXmlNodeText, 
        'status': (KalturaEnumsFactory.createInt, "KalturaSyndicationFeedStatus"), 
        'type': (KalturaEnumsFactory.createInt, "KalturaSyndicationFeedType"), 
        'landingPage': getXmlNodeText, 
        'createdAt': getXmlNodeInt, 
        'allowEmbed': getXmlNodeBool, 
        'playerUiconfId': getXmlNodeInt, 
        'flavorParamId': getXmlNodeInt, 
        'transcodeExistingContent': getXmlNodeBool, 
        'addToDefaultConversionProfile': getXmlNodeBool, 
        'categories': getXmlNodeText, 
        'storageId': getXmlNodeInt, 
        'entriesOrderBy': (KalturaEnumsFactory.createString, "KalturaSyndicationFeedEntriesOrderBy"), 
        'enforceEntitlement': getXmlNodeBool, 
        'privacyContext': getXmlNodeText, 
        'updatedAt': getXmlNodeInt, 
        'useCategoryEntries': getXmlNodeBool, 
        'feedContentTypeHeader': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaBaseSyndicationFeed.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaBaseSyndicationFeed")
        kparams.addStringIfDefined("playlistId", self.playlistId)
        kparams.addStringIfDefined("name", self.name)
        kparams.addIntEnumIfDefined("type", self.type)
        kparams.addStringIfDefined("landingPage", self.landingPage)
        kparams.addBoolIfDefined("allowEmbed", self.allowEmbed)
        kparams.addIntIfDefined("playerUiconfId", self.playerUiconfId)
        kparams.addIntIfDefined("flavorParamId", self.flavorParamId)
        kparams.addBoolIfDefined("transcodeExistingContent", self.transcodeExistingContent)
        kparams.addBoolIfDefined("addToDefaultConversionProfile", self.addToDefaultConversionProfile)
        kparams.addStringIfDefined("categories", self.categories)
        kparams.addIntIfDefined("storageId", self.storageId)
        kparams.addStringEnumIfDefined("entriesOrderBy", self.entriesOrderBy)
        kparams.addBoolIfDefined("enforceEntitlement", self.enforceEntitlement)
        kparams.addStringIfDefined("privacyContext", self.privacyContext)
        kparams.addBoolIfDefined("useCategoryEntries", self.useCategoryEntries)
        kparams.addStringIfDefined("feedContentTypeHeader", self.feedContentTypeHeader)
        return kparams

    def getId(self):
        return self.id

    def getFeedUrl(self):
        return self.feedUrl

    def getPartnerId(self):
        return self.partnerId

    def getPlaylistId(self):
        return self.playlistId

    def setPlaylistId(self, newPlaylistId):
        self.playlistId = newPlaylistId

    def getName(self):
        return self.name

    def setName(self, newName):
        self.name = newName

    def getStatus(self):
        return self.status

    def getType(self):
        return self.type

    def setType(self, newType):
        self.type = newType

    def getLandingPage(self):
        return self.landingPage

    def setLandingPage(self, newLandingPage):
        self.landingPage = newLandingPage

    def getCreatedAt(self):
        return self.createdAt

    def getAllowEmbed(self):
        return self.allowEmbed

    def setAllowEmbed(self, newAllowEmbed):
        self.allowEmbed = newAllowEmbed

    def getPlayerUiconfId(self):
        return self.playerUiconfId

    def setPlayerUiconfId(self, newPlayerUiconfId):
        self.playerUiconfId = newPlayerUiconfId

    def getFlavorParamId(self):
        return self.flavorParamId

    def setFlavorParamId(self, newFlavorParamId):
        self.flavorParamId = newFlavorParamId

    def getTranscodeExistingContent(self):
        return self.transcodeExistingContent

    def setTranscodeExistingContent(self, newTranscodeExistingContent):
        self.transcodeExistingContent = newTranscodeExistingContent

    def getAddToDefaultConversionProfile(self):
        return self.addToDefaultConversionProfile

    def setAddToDefaultConversionProfile(self, newAddToDefaultConversionProfile):
        self.addToDefaultConversionProfile = newAddToDefaultConversionProfile

    def getCategories(self):
        return self.categories

    def setCategories(self, newCategories):
        self.categories = newCategories

    def getStorageId(self):
        return self.storageId

    def setStorageId(self, newStorageId):
        self.storageId = newStorageId

    def getEntriesOrderBy(self):
        return self.entriesOrderBy

    def setEntriesOrderBy(self, newEntriesOrderBy):
        self.entriesOrderBy = newEntriesOrderBy

    def getEnforceEntitlement(self):
        return self.enforceEntitlement

    def setEnforceEntitlement(self, newEnforceEntitlement):
        self.enforceEntitlement = newEnforceEntitlement

    def getPrivacyContext(self):
        return self.privacyContext

    def setPrivacyContext(self, newPrivacyContext):
        self.privacyContext = newPrivacyContext

    def getUpdatedAt(self):
        return self.updatedAt

    def getUseCategoryEntries(self):
        return self.useCategoryEntries

    def setUseCategoryEntries(self, newUseCategoryEntries):
        self.useCategoryEntries = newUseCategoryEntries

    def getFeedContentTypeHeader(self):
        return self.feedContentTypeHeader

    def setFeedContentTypeHeader(self, newFeedContentTypeHeader):
        self.feedContentTypeHeader = newFeedContentTypeHeader


# @package Kaltura
# @subpackage Client
class KalturaBaseUser(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            partnerId=NotImplemented,
            screenName=NotImplemented,
            fullName=NotImplemented,
            email=NotImplemented,
            country=NotImplemented,
            state=NotImplemented,
            city=NotImplemented,
            zip=NotImplemented,
            thumbnailUrl=NotImplemented,
            description=NotImplemented,
            tags=NotImplemented,
            adminTags=NotImplemented,
            status=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented,
            partnerData=NotImplemented,
            indexedPartnerDataInt=NotImplemented,
            indexedPartnerDataString=NotImplemented,
            storageSize=NotImplemented,
            language=NotImplemented,
            lastLoginTime=NotImplemented,
            statusUpdatedAt=NotImplemented,
            deletedAt=NotImplemented,
            allowedPartnerIds=NotImplemented,
            allowedPartnerPackages=NotImplemented,
            userMode=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.id = id

        # @var int
        # @readonly
        self.partnerId = partnerId

        # @var string
        self.screenName = screenName

        # @var string
        self.fullName = fullName

        # @var string
        self.email = email

        # @var string
        self.country = country

        # @var string
        self.state = state

        # @var string
        self.city = city

        # @var string
        self.zip = zip

        # @var string
        self.thumbnailUrl = thumbnailUrl

        # @var string
        self.description = description

        # @var string
        self.tags = tags

        # Admin tags can be updated only by using an admin session
        # @var string
        self.adminTags = adminTags

        # @var KalturaUserStatus
        self.status = status

        # Creation date as Unix timestamp (In seconds)
        # @var int
        # @readonly
        self.createdAt = createdAt

        # Last update date as Unix timestamp (In seconds)
        # @var int
        # @readonly
        self.updatedAt = updatedAt

        # Can be used to store various partner related data as a string
        # @var string
        self.partnerData = partnerData

        # @var int
        self.indexedPartnerDataInt = indexedPartnerDataInt

        # @var string
        self.indexedPartnerDataString = indexedPartnerDataString

        # @var int
        # @readonly
        self.storageSize = storageSize

        # @var KalturaLanguageCode
        self.language = language

        # @var int
        # @readonly
        self.lastLoginTime = lastLoginTime

        # @var int
        # @readonly
        self.statusUpdatedAt = statusUpdatedAt

        # @var int
        # @readonly
        self.deletedAt = deletedAt

        # @var string
        self.allowedPartnerIds = allowedPartnerIds

        # @var string
        self.allowedPartnerPackages = allowedPartnerPackages

        # @var KalturaUserMode
        self.userMode = userMode


    PROPERTY_LOADERS = {
        'id': getXmlNodeText, 
        'partnerId': getXmlNodeInt, 
        'screenName': getXmlNodeText, 
        'fullName': getXmlNodeText, 
        'email': getXmlNodeText, 
        'country': getXmlNodeText, 
        'state': getXmlNodeText, 
        'city': getXmlNodeText, 
        'zip': getXmlNodeText, 
        'thumbnailUrl': getXmlNodeText, 
        'description': getXmlNodeText, 
        'tags': getXmlNodeText, 
        'adminTags': getXmlNodeText, 
        'status': (KalturaEnumsFactory.createInt, "KalturaUserStatus"), 
        'createdAt': getXmlNodeInt, 
        'updatedAt': getXmlNodeInt, 
        'partnerData': getXmlNodeText, 
        'indexedPartnerDataInt': getXmlNodeInt, 
        'indexedPartnerDataString': getXmlNodeText, 
        'storageSize': getXmlNodeInt, 
        'language': (KalturaEnumsFactory.createString, "KalturaLanguageCode"), 
        'lastLoginTime': getXmlNodeInt, 
        'statusUpdatedAt': getXmlNodeInt, 
        'deletedAt': getXmlNodeInt, 
        'allowedPartnerIds': getXmlNodeText, 
        'allowedPartnerPackages': getXmlNodeText, 
        'userMode': (KalturaEnumsFactory.createInt, "KalturaUserMode"), 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaBaseUser.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaBaseUser")
        kparams.addStringIfDefined("id", self.id)
        kparams.addStringIfDefined("screenName", self.screenName)
        kparams.addStringIfDefined("fullName", self.fullName)
        kparams.addStringIfDefined("email", self.email)
        kparams.addStringIfDefined("country", self.country)
        kparams.addStringIfDefined("state", self.state)
        kparams.addStringIfDefined("city", self.city)
        kparams.addStringIfDefined("zip", self.zip)
        kparams.addStringIfDefined("thumbnailUrl", self.thumbnailUrl)
        kparams.addStringIfDefined("description", self.description)
        kparams.addStringIfDefined("tags", self.tags)
        kparams.addStringIfDefined("adminTags", self.adminTags)
        kparams.addIntEnumIfDefined("status", self.status)
        kparams.addStringIfDefined("partnerData", self.partnerData)
        kparams.addIntIfDefined("indexedPartnerDataInt", self.indexedPartnerDataInt)
        kparams.addStringIfDefined("indexedPartnerDataString", self.indexedPartnerDataString)
        kparams.addStringEnumIfDefined("language", self.language)
        kparams.addStringIfDefined("allowedPartnerIds", self.allowedPartnerIds)
        kparams.addStringIfDefined("allowedPartnerPackages", self.allowedPartnerPackages)
        kparams.addIntEnumIfDefined("userMode", self.userMode)
        return kparams

    def getId(self):
        return self.id

    def setId(self, newId):
        self.id = newId

    def getPartnerId(self):
        return self.partnerId

    def getScreenName(self):
        return self.screenName

    def setScreenName(self, newScreenName):
        self.screenName = newScreenName

    def getFullName(self):
        return self.fullName

    def setFullName(self, newFullName):
        self.fullName = newFullName

    def getEmail(self):
        return self.email

    def setEmail(self, newEmail):
        self.email = newEmail

    def getCountry(self):
        return self.country

    def setCountry(self, newCountry):
        self.country = newCountry

    def getState(self):
        return self.state

    def setState(self, newState):
        self.state = newState

    def getCity(self):
        return self.city

    def setCity(self, newCity):
        self.city = newCity

    def getZip(self):
        return self.zip

    def setZip(self, newZip):
        self.zip = newZip

    def getThumbnailUrl(self):
        return self.thumbnailUrl

    def setThumbnailUrl(self, newThumbnailUrl):
        self.thumbnailUrl = newThumbnailUrl

    def getDescription(self):
        return self.description

    def setDescription(self, newDescription):
        self.description = newDescription

    def getTags(self):
        return self.tags

    def setTags(self, newTags):
        self.tags = newTags

    def getAdminTags(self):
        return self.adminTags

    def setAdminTags(self, newAdminTags):
        self.adminTags = newAdminTags

    def getStatus(self):
        return self.status

    def setStatus(self, newStatus):
        self.status = newStatus

    def getCreatedAt(self):
        return self.createdAt

    def getUpdatedAt(self):
        return self.updatedAt

    def getPartnerData(self):
        return self.partnerData

    def setPartnerData(self, newPartnerData):
        self.partnerData = newPartnerData

    def getIndexedPartnerDataInt(self):
        return self.indexedPartnerDataInt

    def setIndexedPartnerDataInt(self, newIndexedPartnerDataInt):
        self.indexedPartnerDataInt = newIndexedPartnerDataInt

    def getIndexedPartnerDataString(self):
        return self.indexedPartnerDataString

    def setIndexedPartnerDataString(self, newIndexedPartnerDataString):
        self.indexedPartnerDataString = newIndexedPartnerDataString

    def getStorageSize(self):
        return self.storageSize

    def getLanguage(self):
        return self.language

    def setLanguage(self, newLanguage):
        self.language = newLanguage

    def getLastLoginTime(self):
        return self.lastLoginTime

    def getStatusUpdatedAt(self):
        return self.statusUpdatedAt

    def getDeletedAt(self):
        return self.deletedAt

    def getAllowedPartnerIds(self):
        return self.allowedPartnerIds

    def setAllowedPartnerIds(self, newAllowedPartnerIds):
        self.allowedPartnerIds = newAllowedPartnerIds

    def getAllowedPartnerPackages(self):
        return self.allowedPartnerPackages

    def setAllowedPartnerPackages(self, newAllowedPartnerPackages):
        self.allowedPartnerPackages = newAllowedPartnerPackages

    def getUserMode(self):
        return self.userMode

    def setUserMode(self, newUserMode):
        self.userMode = newUserMode


# @package Kaltura
# @subpackage Client
class KalturaJobData(KalturaObjectBase):
    def __init__(self):
        KalturaObjectBase.__init__(self)


    PROPERTY_LOADERS = {
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaJobData.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaJobData")
        return kparams


# @package Kaltura
# @subpackage Client
class KalturaBatchHistoryData(KalturaObjectBase):
    def __init__(self,
            schedulerId=NotImplemented,
            workerId=NotImplemented,
            batchIndex=NotImplemented,
            timeStamp=NotImplemented,
            message=NotImplemented,
            errType=NotImplemented,
            errNumber=NotImplemented,
            hostName=NotImplemented,
            sessionId=NotImplemented,
            schedulerName=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var int
        self.schedulerId = schedulerId

        # @var int
        self.workerId = workerId

        # @var int
        self.batchIndex = batchIndex

        # @var int
        self.timeStamp = timeStamp

        # @var string
        self.message = message

        # @var int
        self.errType = errType

        # @var int
        self.errNumber = errNumber

        # @var string
        self.hostName = hostName

        # @var string
        self.sessionId = sessionId

        # @var string
        self.schedulerName = schedulerName


    PROPERTY_LOADERS = {
        'schedulerId': getXmlNodeInt, 
        'workerId': getXmlNodeInt, 
        'batchIndex': getXmlNodeInt, 
        'timeStamp': getXmlNodeInt, 
        'message': getXmlNodeText, 
        'errType': getXmlNodeInt, 
        'errNumber': getXmlNodeInt, 
        'hostName': getXmlNodeText, 
        'sessionId': getXmlNodeText, 
        'schedulerName': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaBatchHistoryData.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaBatchHistoryData")
        kparams.addIntIfDefined("schedulerId", self.schedulerId)
        kparams.addIntIfDefined("workerId", self.workerId)
        kparams.addIntIfDefined("batchIndex", self.batchIndex)
        kparams.addIntIfDefined("timeStamp", self.timeStamp)
        kparams.addStringIfDefined("message", self.message)
        kparams.addIntIfDefined("errType", self.errType)
        kparams.addIntIfDefined("errNumber", self.errNumber)
        kparams.addStringIfDefined("hostName", self.hostName)
        kparams.addStringIfDefined("sessionId", self.sessionId)
        kparams.addStringIfDefined("schedulerName", self.schedulerName)
        return kparams

    def getSchedulerId(self):
        return self.schedulerId

    def setSchedulerId(self, newSchedulerId):
        self.schedulerId = newSchedulerId

    def getWorkerId(self):
        return self.workerId

    def setWorkerId(self, newWorkerId):
        self.workerId = newWorkerId

    def getBatchIndex(self):
        return self.batchIndex

    def setBatchIndex(self, newBatchIndex):
        self.batchIndex = newBatchIndex

    def getTimeStamp(self):
        return self.timeStamp

    def setTimeStamp(self, newTimeStamp):
        self.timeStamp = newTimeStamp

    def getMessage(self):
        return self.message

    def setMessage(self, newMessage):
        self.message = newMessage

    def getErrType(self):
        return self.errType

    def setErrType(self, newErrType):
        self.errType = newErrType

    def getErrNumber(self):
        return self.errNumber

    def setErrNumber(self, newErrNumber):
        self.errNumber = newErrNumber

    def getHostName(self):
        return self.hostName

    def setHostName(self, newHostName):
        self.hostName = newHostName

    def getSessionId(self):
        return self.sessionId

    def setSessionId(self, newSessionId):
        self.sessionId = newSessionId

    def getSchedulerName(self):
        return self.schedulerName

    def setSchedulerName(self, newSchedulerName):
        self.schedulerName = newSchedulerName


# @package Kaltura
# @subpackage Client
class KalturaBatchJob(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            partnerId=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented,
            deletedAt=NotImplemented,
            lockExpiration=NotImplemented,
            executionAttempts=NotImplemented,
            lockVersion=NotImplemented,
            entryId=NotImplemented,
            entryName=NotImplemented,
            jobType=NotImplemented,
            jobSubType=NotImplemented,
            data=NotImplemented,
            status=NotImplemented,
            abort=NotImplemented,
            checkAgainTimeout=NotImplemented,
            message=NotImplemented,
            description=NotImplemented,
            priority=NotImplemented,
            history=NotImplemented,
            bulkJobId=NotImplemented,
            batchVersion=NotImplemented,
            parentJobId=NotImplemented,
            rootJobId=NotImplemented,
            queueTime=NotImplemented,
            finishTime=NotImplemented,
            errType=NotImplemented,
            errNumber=NotImplemented,
            estimatedEffort=NotImplemented,
            urgency=NotImplemented,
            schedulerId=NotImplemented,
            workerId=NotImplemented,
            batchIndex=NotImplemented,
            lastSchedulerId=NotImplemented,
            lastWorkerId=NotImplemented,
            dc=NotImplemented,
            jobObjectId=NotImplemented,
            jobObjectType=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var int
        # @readonly
        self.id = id

        # @var int
        # @readonly
        self.partnerId = partnerId

        # @var int
        # @readonly
        self.createdAt = createdAt

        # @var int
        # @readonly
        self.updatedAt = updatedAt

        # @var int
        # @readonly
        self.deletedAt = deletedAt

        # @var int
        # @readonly
        self.lockExpiration = lockExpiration

        # @var int
        # @readonly
        self.executionAttempts = executionAttempts

        # @var int
        # @readonly
        self.lockVersion = lockVersion

        # @var string
        self.entryId = entryId

        # @var string
        self.entryName = entryName

        # @var KalturaBatchJobType
        # @readonly
        self.jobType = jobType

        # @var int
        self.jobSubType = jobSubType

        # @var KalturaJobData
        self.data = data

        # @var KalturaBatchJobStatus
        self.status = status

        # @var int
        self.abort = abort

        # @var int
        self.checkAgainTimeout = checkAgainTimeout

        # @var string
        self.message = message

        # @var string
        self.description = description

        # @var int
        self.priority = priority

        # @var array of KalturaBatchHistoryData
        self.history = history

        # The id of the bulk upload job that initiated this job
        # @var int
        self.bulkJobId = bulkJobId

        # @var int
        self.batchVersion = batchVersion

        # When one job creates another - the parent should set this parentJobId to be its own id.
        # @var int
        self.parentJobId = parentJobId

        # The id of the root parent job
        # @var int
        self.rootJobId = rootJobId

        # The time that the job was pulled from the queue
        # @var int
        self.queueTime = queueTime

        # The time that the job was finished or closed as failed
        # @var int
        self.finishTime = finishTime

        # @var KalturaBatchJobErrorTypes
        self.errType = errType

        # @var int
        self.errNumber = errNumber

        # @var int
        self.estimatedEffort = estimatedEffort

        # @var int
        self.urgency = urgency

        # @var int
        self.schedulerId = schedulerId

        # @var int
        self.workerId = workerId

        # @var int
        self.batchIndex = batchIndex

        # @var int
        self.lastSchedulerId = lastSchedulerId

        # @var int
        self.lastWorkerId = lastWorkerId

        # @var int
        self.dc = dc

        # @var string
        self.jobObjectId = jobObjectId

        # @var int
        self.jobObjectType = jobObjectType


    PROPERTY_LOADERS = {
        'id': getXmlNodeInt, 
        'partnerId': getXmlNodeInt, 
        'createdAt': getXmlNodeInt, 
        'updatedAt': getXmlNodeInt, 
        'deletedAt': getXmlNodeInt, 
        'lockExpiration': getXmlNodeInt, 
        'executionAttempts': getXmlNodeInt, 
        'lockVersion': getXmlNodeInt, 
        'entryId': getXmlNodeText, 
        'entryName': getXmlNodeText, 
        'jobType': (KalturaEnumsFactory.createString, "KalturaBatchJobType"), 
        'jobSubType': getXmlNodeInt, 
        'data': (KalturaObjectFactory.create, 'KalturaJobData'), 
        'status': (KalturaEnumsFactory.createInt, "KalturaBatchJobStatus"), 
        'abort': getXmlNodeInt, 
        'checkAgainTimeout': getXmlNodeInt, 
        'message': getXmlNodeText, 
        'description': getXmlNodeText, 
        'priority': getXmlNodeInt, 
        'history': (KalturaObjectFactory.createArray, 'KalturaBatchHistoryData'), 
        'bulkJobId': getXmlNodeInt, 
        'batchVersion': getXmlNodeInt, 
        'parentJobId': getXmlNodeInt, 
        'rootJobId': getXmlNodeInt, 
        'queueTime': getXmlNodeInt, 
        'finishTime': getXmlNodeInt, 
        'errType': (KalturaEnumsFactory.createInt, "KalturaBatchJobErrorTypes"), 
        'errNumber': getXmlNodeInt, 
        'estimatedEffort': getXmlNodeInt, 
        'urgency': getXmlNodeInt, 
        'schedulerId': getXmlNodeInt, 
        'workerId': getXmlNodeInt, 
        'batchIndex': getXmlNodeInt, 
        'lastSchedulerId': getXmlNodeInt, 
        'lastWorkerId': getXmlNodeInt, 
        'dc': getXmlNodeInt, 
        'jobObjectId': getXmlNodeText, 
        'jobObjectType': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaBatchJob.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaBatchJob")
        kparams.addStringIfDefined("entryId", self.entryId)
        kparams.addStringIfDefined("entryName", self.entryName)
        kparams.addIntIfDefined("jobSubType", self.jobSubType)
        kparams.addObjectIfDefined("data", self.data)
        kparams.addIntEnumIfDefined("status", self.status)
        kparams.addIntIfDefined("abort", self.abort)
        kparams.addIntIfDefined("checkAgainTimeout", self.checkAgainTimeout)
        kparams.addStringIfDefined("message", self.message)
        kparams.addStringIfDefined("description", self.description)
        kparams.addIntIfDefined("priority", self.priority)
        kparams.addArrayIfDefined("history", self.history)
        kparams.addIntIfDefined("bulkJobId", self.bulkJobId)
        kparams.addIntIfDefined("batchVersion", self.batchVersion)
        kparams.addIntIfDefined("parentJobId", self.parentJobId)
        kparams.addIntIfDefined("rootJobId", self.rootJobId)
        kparams.addIntIfDefined("queueTime", self.queueTime)
        kparams.addIntIfDefined("finishTime", self.finishTime)
        kparams.addIntEnumIfDefined("errType", self.errType)
        kparams.addIntIfDefined("errNumber", self.errNumber)
        kparams.addIntIfDefined("estimatedEffort", self.estimatedEffort)
        kparams.addIntIfDefined("urgency", self.urgency)
        kparams.addIntIfDefined("schedulerId", self.schedulerId)
        kparams.addIntIfDefined("workerId", self.workerId)
        kparams.addIntIfDefined("batchIndex", self.batchIndex)
        kparams.addIntIfDefined("lastSchedulerId", self.lastSchedulerId)
        kparams.addIntIfDefined("lastWorkerId", self.lastWorkerId)
        kparams.addIntIfDefined("dc", self.dc)
        kparams.addStringIfDefined("jobObjectId", self.jobObjectId)
        kparams.addIntIfDefined("jobObjectType", self.jobObjectType)
        return kparams

    def getId(self):
        return self.id

    def getPartnerId(self):
        return self.partnerId

    def getCreatedAt(self):
        return self.createdAt

    def getUpdatedAt(self):
        return self.updatedAt

    def getDeletedAt(self):
        return self.deletedAt

    def getLockExpiration(self):
        return self.lockExpiration

    def getExecutionAttempts(self):
        return self.executionAttempts

    def getLockVersion(self):
        return self.lockVersion

    def getEntryId(self):
        return self.entryId

    def setEntryId(self, newEntryId):
        self.entryId = newEntryId

    def getEntryName(self):
        return self.entryName

    def setEntryName(self, newEntryName):
        self.entryName = newEntryName

    def getJobType(self):
        return self.jobType

    def getJobSubType(self):
        return self.jobSubType

    def setJobSubType(self, newJobSubType):
        self.jobSubType = newJobSubType

    def getData(self):
        return self.data

    def setData(self, newData):
        self.data = newData

    def getStatus(self):
        return self.status

    def setStatus(self, newStatus):
        self.status = newStatus

    def getAbort(self):
        return self.abort

    def setAbort(self, newAbort):
        self.abort = newAbort

    def getCheckAgainTimeout(self):
        return self.checkAgainTimeout

    def setCheckAgainTimeout(self, newCheckAgainTimeout):
        self.checkAgainTimeout = newCheckAgainTimeout

    def getMessage(self):
        return self.message

    def setMessage(self, newMessage):
        self.message = newMessage

    def getDescription(self):
        return self.description

    def setDescription(self, newDescription):
        self.description = newDescription

    def getPriority(self):
        return self.priority

    def setPriority(self, newPriority):
        self.priority = newPriority

    def getHistory(self):
        return self.history

    def setHistory(self, newHistory):
        self.history = newHistory

    def getBulkJobId(self):
        return self.bulkJobId

    def setBulkJobId(self, newBulkJobId):
        self.bulkJobId = newBulkJobId

    def getBatchVersion(self):
        return self.batchVersion

    def setBatchVersion(self, newBatchVersion):
        self.batchVersion = newBatchVersion

    def getParentJobId(self):
        return self.parentJobId

    def setParentJobId(self, newParentJobId):
        self.parentJobId = newParentJobId

    def getRootJobId(self):
        return self.rootJobId

    def setRootJobId(self, newRootJobId):
        self.rootJobId = newRootJobId

    def getQueueTime(self):
        return self.queueTime

    def setQueueTime(self, newQueueTime):
        self.queueTime = newQueueTime

    def getFinishTime(self):
        return self.finishTime

    def setFinishTime(self, newFinishTime):
        self.finishTime = newFinishTime

    def getErrType(self):
        return self.errType

    def setErrType(self, newErrType):
        self.errType = newErrType

    def getErrNumber(self):
        return self.errNumber

    def setErrNumber(self, newErrNumber):
        self.errNumber = newErrNumber

    def getEstimatedEffort(self):
        return self.estimatedEffort

    def setEstimatedEffort(self, newEstimatedEffort):
        self.estimatedEffort = newEstimatedEffort

    def getUrgency(self):
        return self.urgency

    def setUrgency(self, newUrgency):
        self.urgency = newUrgency

    def getSchedulerId(self):
        return self.schedulerId

    def setSchedulerId(self, newSchedulerId):
        self.schedulerId = newSchedulerId

    def getWorkerId(self):
        return self.workerId

    def setWorkerId(self, newWorkerId):
        self.workerId = newWorkerId

    def getBatchIndex(self):
        return self.batchIndex

    def setBatchIndex(self, newBatchIndex):
        self.batchIndex = newBatchIndex

    def getLastSchedulerId(self):
        return self.lastSchedulerId

    def setLastSchedulerId(self, newLastSchedulerId):
        self.lastSchedulerId = newLastSchedulerId

    def getLastWorkerId(self):
        return self.lastWorkerId

    def setLastWorkerId(self, newLastWorkerId):
        self.lastWorkerId = newLastWorkerId

    def getDc(self):
        return self.dc

    def setDc(self, newDc):
        self.dc = newDc

    def getJobObjectId(self):
        return self.jobObjectId

    def setJobObjectId(self, newJobObjectId):
        self.jobObjectId = newJobObjectId

    def getJobObjectType(self):
        return self.jobObjectType

    def setJobObjectType(self, newJobObjectType):
        self.jobObjectType = newJobObjectType


# @package Kaltura
# @subpackage Client
class KalturaPlayerDeliveryType(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            label=NotImplemented,
            flashvars=NotImplemented,
            minVersion=NotImplemented,
            enabledByDefault=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.id = id

        # @var string
        self.label = label

        # @var array of KalturaKeyValue
        self.flashvars = flashvars

        # @var string
        self.minVersion = minVersion

        # @var bool
        self.enabledByDefault = enabledByDefault


    PROPERTY_LOADERS = {
        'id': getXmlNodeText, 
        'label': getXmlNodeText, 
        'flashvars': (KalturaObjectFactory.createArray, 'KalturaKeyValue'), 
        'minVersion': getXmlNodeText, 
        'enabledByDefault': getXmlNodeBool, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaPlayerDeliveryType.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaPlayerDeliveryType")
        kparams.addStringIfDefined("id", self.id)
        kparams.addStringIfDefined("label", self.label)
        kparams.addArrayIfDefined("flashvars", self.flashvars)
        kparams.addStringIfDefined("minVersion", self.minVersion)
        kparams.addBoolIfDefined("enabledByDefault", self.enabledByDefault)
        return kparams

    def getId(self):
        return self.id

    def setId(self, newId):
        self.id = newId

    def getLabel(self):
        return self.label

    def setLabel(self, newLabel):
        self.label = newLabel

    def getFlashvars(self):
        return self.flashvars

    def setFlashvars(self, newFlashvars):
        self.flashvars = newFlashvars

    def getMinVersion(self):
        return self.minVersion

    def setMinVersion(self, newMinVersion):
        self.minVersion = newMinVersion

    def getEnabledByDefault(self):
        return self.enabledByDefault

    def setEnabledByDefault(self, newEnabledByDefault):
        self.enabledByDefault = newEnabledByDefault


# @package Kaltura
# @subpackage Client
class KalturaPlayerEmbedCodeType(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            label=NotImplemented,
            entryOnly=NotImplemented,
            minVersion=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.id = id

        # @var string
        self.label = label

        # @var bool
        self.entryOnly = entryOnly

        # @var string
        self.minVersion = minVersion


    PROPERTY_LOADERS = {
        'id': getXmlNodeText, 
        'label': getXmlNodeText, 
        'entryOnly': getXmlNodeBool, 
        'minVersion': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaPlayerEmbedCodeType.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaPlayerEmbedCodeType")
        kparams.addStringIfDefined("id", self.id)
        kparams.addStringIfDefined("label", self.label)
        kparams.addBoolIfDefined("entryOnly", self.entryOnly)
        kparams.addStringIfDefined("minVersion", self.minVersion)
        return kparams

    def getId(self):
        return self.id

    def setId(self, newId):
        self.id = newId

    def getLabel(self):
        return self.label

    def setLabel(self, newLabel):
        self.label = newLabel

    def getEntryOnly(self):
        return self.entryOnly

    def setEntryOnly(self, newEntryOnly):
        self.entryOnly = newEntryOnly

    def getMinVersion(self):
        return self.minVersion

    def setMinVersion(self, newMinVersion):
        self.minVersion = newMinVersion


# @package Kaltura
# @subpackage Client
class KalturaESearchLanguageItem(KalturaObjectBase):
    def __init__(self,
            eSerachLanguage=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var KalturaESearchLanguage
        self.eSerachLanguage = eSerachLanguage


    PROPERTY_LOADERS = {
        'eSerachLanguage': (KalturaEnumsFactory.createString, "KalturaESearchLanguage"), 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaESearchLanguageItem.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaESearchLanguageItem")
        kparams.addStringEnumIfDefined("eSerachLanguage", self.eSerachLanguage)
        return kparams

    def getESerachLanguage(self):
        return self.eSerachLanguage

    def setESerachLanguage(self, newESerachLanguage):
        self.eSerachLanguage = newESerachLanguage


# @package Kaltura
# @subpackage Client
class KalturaRegexItem(KalturaObjectBase):
    def __init__(self,
            regex=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.regex = regex


    PROPERTY_LOADERS = {
        'regex': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaRegexItem.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaRegexItem")
        kparams.addStringIfDefined("regex", self.regex)
        return kparams

    def getRegex(self):
        return self.regex

    def setRegex(self, newRegex):
        self.regex = newRegex


# @package Kaltura
# @subpackage Client
class KalturaPartner(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            name=NotImplemented,
            website=NotImplemented,
            notificationUrl=NotImplemented,
            appearInSearch=NotImplemented,
            createdAt=NotImplemented,
            adminName=NotImplemented,
            adminEmail=NotImplemented,
            description=NotImplemented,
            commercialUse=NotImplemented,
            landingPage=NotImplemented,
            userLandingPage=NotImplemented,
            contentCategories=NotImplemented,
            type=NotImplemented,
            phone=NotImplemented,
            describeYourself=NotImplemented,
            adultContent=NotImplemented,
            defConversionProfileType=NotImplemented,
            notify=NotImplemented,
            status=NotImplemented,
            allowQuickEdit=NotImplemented,
            mergeEntryLists=NotImplemented,
            notificationsConfig=NotImplemented,
            allowedFromEmailWhiteList=NotImplemented,
            maxUploadSize=NotImplemented,
            partnerPackage=NotImplemented,
            secret=NotImplemented,
            adminSecret=NotImplemented,
            cmsPassword=NotImplemented,
            allowMultiNotification=NotImplemented,
            adminLoginUsersQuota=NotImplemented,
            adminUserId=NotImplemented,
            firstName=NotImplemented,
            lastName=NotImplemented,
            country=NotImplemented,
            state=NotImplemented,
            additionalParams=NotImplemented,
            publishersQuota=NotImplemented,
            partnerGroupType=NotImplemented,
            defaultEntitlementEnforcement=NotImplemented,
            defaultDeliveryType=NotImplemented,
            defaultEmbedCodeType=NotImplemented,
            deliveryTypes=NotImplemented,
            embedCodeTypes=NotImplemented,
            templatePartnerId=NotImplemented,
            ignoreSeoLinks=NotImplemented,
            blockDirectLogin=NotImplemented,
            host=NotImplemented,
            cdnHost=NotImplemented,
            isFirstLogin=NotImplemented,
            logoutUrl=NotImplemented,
            partnerParentId=NotImplemented,
            crmId=NotImplemented,
            referenceId=NotImplemented,
            timeAlignedRenditions=NotImplemented,
            publisherEnvironmentType=NotImplemented,
            ovpEnvironmentUrl=NotImplemented,
            ottEnvironmentUrl=NotImplemented,
            eSearchLanguages=NotImplemented,
            authenticationType=NotImplemented,
            extendedFreeTrailExpiryReason=NotImplemented,
            extendedFreeTrailExpiryDate=NotImplemented,
            extendedFreeTrail=NotImplemented,
            extendedFreeTrailEndsWarning=NotImplemented,
            eightyPercentWarning=NotImplemented,
            usageLimitWarning=NotImplemented,
            lastFreeTrialNotificationDay=NotImplemented,
            monitorUsage=NotImplemented,
            passwordStructureValidations=NotImplemented,
            passwordStructureValidationsDescription=NotImplemented,
            passReplaceFreq=NotImplemented,
            maxLoginAttempts=NotImplemented,
            loginBlockPeriod=NotImplemented,
            numPrevPassToKeep=NotImplemented,
            twoFactorAuthenticationMode=NotImplemented,
            isSelfServe=NotImplemented,
            allowedDomains=NotImplemented,
            excludedAdminRoleName=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var int
        # @readonly
        self.id = id

        # @var string
        self.name = name

        # @var string
        self.website = website

        # @var string
        self.notificationUrl = notificationUrl

        # @var int
        self.appearInSearch = appearInSearch

        # @var int
        # @readonly
        self.createdAt = createdAt

        # deprecated - lastName and firstName replaces this field
        # @var string
        self.adminName = adminName

        # @var string
        self.adminEmail = adminEmail

        # @var string
        self.description = description

        # @var KalturaCommercialUseType
        self.commercialUse = commercialUse

        # @var string
        self.landingPage = landingPage

        # @var string
        self.userLandingPage = userLandingPage

        # @var string
        self.contentCategories = contentCategories

        # @var KalturaPartnerType
        self.type = type

        # @var string
        self.phone = phone

        # @var string
        self.describeYourself = describeYourself

        # @var bool
        self.adultContent = adultContent

        # @var string
        self.defConversionProfileType = defConversionProfileType

        # @var int
        self.notify = notify

        # @var KalturaPartnerStatus
        # @readonly
        self.status = status

        # @var int
        self.allowQuickEdit = allowQuickEdit

        # @var int
        self.mergeEntryLists = mergeEntryLists

        # @var string
        self.notificationsConfig = notificationsConfig

        # @var string
        self.allowedFromEmailWhiteList = allowedFromEmailWhiteList

        # @var int
        self.maxUploadSize = maxUploadSize

        # @var int
        self.partnerPackage = partnerPackage

        # @var string
        # @readonly
        self.secret = secret

        # @var string
        # @readonly
        self.adminSecret = adminSecret

        # @var string
        # @readonly
        self.cmsPassword = cmsPassword

        # @var int
        self.allowMultiNotification = allowMultiNotification

        # @var int
        # @readonly
        self.adminLoginUsersQuota = adminLoginUsersQuota

        # @var string
        self.adminUserId = adminUserId

        # firstName and lastName replace the old (deprecated) adminName
        # @var string
        self.firstName = firstName

        # lastName and firstName replace the old (deprecated) adminName
        # @var string
        self.lastName = lastName

        # country code (2char) - this field is optional
        # @var string
        self.country = country

        # state code (2char) - this field is optional
        # @var string
        self.state = state

        # @var array of KalturaKeyValue
        self.additionalParams = additionalParams

        # @var int
        # @readonly
        self.publishersQuota = publishersQuota

        # @var KalturaPartnerGroupType
        # @readonly
        self.partnerGroupType = partnerGroupType

        # @var bool
        # @readonly
        self.defaultEntitlementEnforcement = defaultEntitlementEnforcement

        # @var string
        # @readonly
        self.defaultDeliveryType = defaultDeliveryType

        # @var string
        # @readonly
        self.defaultEmbedCodeType = defaultEmbedCodeType

        # @var array of KalturaPlayerDeliveryType
        # @readonly
        self.deliveryTypes = deliveryTypes

        # @var array of KalturaPlayerEmbedCodeType
        # @readonly
        self.embedCodeTypes = embedCodeTypes

        # @var int
        # @readonly
        self.templatePartnerId = templatePartnerId

        # @var bool
        # @readonly
        self.ignoreSeoLinks = ignoreSeoLinks

        # @var bool
        # @readonly
        self.blockDirectLogin = blockDirectLogin

        # @var string
        # @readonly
        self.host = host

        # @var string
        # @readonly
        self.cdnHost = cdnHost

        # @var bool
        # @readonly
        self.isFirstLogin = isFirstLogin

        # @var string
        # @readonly
        self.logoutUrl = logoutUrl

        # @var int
        self.partnerParentId = partnerParentId

        # @var string
        # @readonly
        self.crmId = crmId

        # @var string
        self.referenceId = referenceId

        # @var bool
        # @readonly
        self.timeAlignedRenditions = timeAlignedRenditions

        # @var int
        # @readonly
        self.publisherEnvironmentType = publisherEnvironmentType

        # @var string
        # @readonly
        self.ovpEnvironmentUrl = ovpEnvironmentUrl

        # @var string
        # @readonly
        self.ottEnvironmentUrl = ottEnvironmentUrl

        # @var array of KalturaESearchLanguageItem
        self.eSearchLanguages = eSearchLanguages

        # @var KalturaPartnerAuthenticationType
        # @readonly
        self.authenticationType = authenticationType

        # @var string
        # @readonly
        self.extendedFreeTrailExpiryReason = extendedFreeTrailExpiryReason

        # Unix timestamp (In seconds)
        # @var int
        # @readonly
        self.extendedFreeTrailExpiryDate = extendedFreeTrailExpiryDate

        # @var int
        # @readonly
        self.extendedFreeTrail = extendedFreeTrail

        # @var bool
        # @readonly
        self.extendedFreeTrailEndsWarning = extendedFreeTrailEndsWarning

        # @var int
        # @readonly
        self.eightyPercentWarning = eightyPercentWarning

        # @var int
        # @readonly
        self.usageLimitWarning = usageLimitWarning

        # @var int
        # @readonly
        self.lastFreeTrialNotificationDay = lastFreeTrialNotificationDay

        # @var int
        # @readonly
        self.monitorUsage = monitorUsage

        # @var array of KalturaRegexItem
        self.passwordStructureValidations = passwordStructureValidations

        # @var string
        self.passwordStructureValidationsDescription = passwordStructureValidationsDescription

        # @var int
        self.passReplaceFreq = passReplaceFreq

        # @var int
        self.maxLoginAttempts = maxLoginAttempts

        # @var int
        self.loginBlockPeriod = loginBlockPeriod

        # @var int
        self.numPrevPassToKeep = numPrevPassToKeep

        # @var KalturaTwoFactorAuthenticationMode
        # @readonly
        self.twoFactorAuthenticationMode = twoFactorAuthenticationMode

        # @var bool
        self.isSelfServe = isSelfServe

        # @var string
        # @readonly
        self.allowedDomains = allowedDomains

        # @var string
        # @readonly
        self.excludedAdminRoleName = excludedAdminRoleName


    PROPERTY_LOADERS = {
        'id': getXmlNodeInt, 
        'name': getXmlNodeText, 
        'website': getXmlNodeText, 
        'notificationUrl': getXmlNodeText, 
        'appearInSearch': getXmlNodeInt, 
        'createdAt': getXmlNodeInt, 
        'adminName': getXmlNodeText, 
        'adminEmail': getXmlNodeText, 
        'description': getXmlNodeText, 
        'commercialUse': (KalturaEnumsFactory.createInt, "KalturaCommercialUseType"), 
        'landingPage': getXmlNodeText, 
        'userLandingPage': getXmlNodeText, 
        'contentCategories': getXmlNodeText, 
        'type': (KalturaEnumsFactory.createInt, "KalturaPartnerType"), 
        'phone': getXmlNodeText, 
        'describeYourself': getXmlNodeText, 
        'adultContent': getXmlNodeBool, 
        'defConversionProfileType': getXmlNodeText, 
        'notify': getXmlNodeInt, 
        'status': (KalturaEnumsFactory.createInt, "KalturaPartnerStatus"), 
        'allowQuickEdit': getXmlNodeInt, 
        'mergeEntryLists': getXmlNodeInt, 
        'notificationsConfig': getXmlNodeText, 
        'allowedFromEmailWhiteList': getXmlNodeText, 
        'maxUploadSize': getXmlNodeInt, 
        'partnerPackage': getXmlNodeInt, 
        'secret': getXmlNodeText, 
        'adminSecret': getXmlNodeText, 
        'cmsPassword': getXmlNodeText, 
        'allowMultiNotification': getXmlNodeInt, 
        'adminLoginUsersQuota': getXmlNodeInt, 
        'adminUserId': getXmlNodeText, 
        'firstName': getXmlNodeText, 
        'lastName': getXmlNodeText, 
        'country': getXmlNodeText, 
        'state': getXmlNodeText, 
        'additionalParams': (KalturaObjectFactory.createArray, 'KalturaKeyValue'), 
        'publishersQuota': getXmlNodeInt, 
        'partnerGroupType': (KalturaEnumsFactory.createInt, "KalturaPartnerGroupType"), 
        'defaultEntitlementEnforcement': getXmlNodeBool, 
        'defaultDeliveryType': getXmlNodeText, 
        'defaultEmbedCodeType': getXmlNodeText, 
        'deliveryTypes': (KalturaObjectFactory.createArray, 'KalturaPlayerDeliveryType'), 
        'embedCodeTypes': (KalturaObjectFactory.createArray, 'KalturaPlayerEmbedCodeType'), 
        'templatePartnerId': getXmlNodeInt, 
        'ignoreSeoLinks': getXmlNodeBool, 
        'blockDirectLogin': getXmlNodeBool, 
        'host': getXmlNodeText, 
        'cdnHost': getXmlNodeText, 
        'isFirstLogin': getXmlNodeBool, 
        'logoutUrl': getXmlNodeText, 
        'partnerParentId': getXmlNodeInt, 
        'crmId': getXmlNodeText, 
        'referenceId': getXmlNodeText, 
        'timeAlignedRenditions': getXmlNodeBool, 
        'publisherEnvironmentType': getXmlNodeInt, 
        'ovpEnvironmentUrl': getXmlNodeText, 
        'ottEnvironmentUrl': getXmlNodeText, 
        'eSearchLanguages': (KalturaObjectFactory.createArray, 'KalturaESearchLanguageItem'), 
        'authenticationType': (KalturaEnumsFactory.createInt, "KalturaPartnerAuthenticationType"), 
        'extendedFreeTrailExpiryReason': getXmlNodeText, 
        'extendedFreeTrailExpiryDate': getXmlNodeInt, 
        'extendedFreeTrail': getXmlNodeInt, 
        'extendedFreeTrailEndsWarning': getXmlNodeBool, 
        'eightyPercentWarning': getXmlNodeInt, 
        'usageLimitWarning': getXmlNodeInt, 
        'lastFreeTrialNotificationDay': getXmlNodeInt, 
        'monitorUsage': getXmlNodeInt, 
        'passwordStructureValidations': (KalturaObjectFactory.createArray, 'KalturaRegexItem'), 
        'passwordStructureValidationsDescription': getXmlNodeText, 
        'passReplaceFreq': getXmlNodeInt, 
        'maxLoginAttempts': getXmlNodeInt, 
        'loginBlockPeriod': getXmlNodeInt, 
        'numPrevPassToKeep': getXmlNodeInt, 
        'twoFactorAuthenticationMode': (KalturaEnumsFactory.createInt, "KalturaTwoFactorAuthenticationMode"), 
        'isSelfServe': getXmlNodeBool, 
        'allowedDomains': getXmlNodeText, 
        'excludedAdminRoleName': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaPartner.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaPartner")
        kparams.addStringIfDefined("name", self.name)
        kparams.addStringIfDefined("website", self.website)
        kparams.addStringIfDefined("notificationUrl", self.notificationUrl)
        kparams.addIntIfDefined("appearInSearch", self.appearInSearch)
        kparams.addStringIfDefined("adminName", self.adminName)
        kparams.addStringIfDefined("adminEmail", self.adminEmail)
        kparams.addStringIfDefined("description", self.description)
        kparams.addIntEnumIfDefined("commercialUse", self.commercialUse)
        kparams.addStringIfDefined("landingPage", self.landingPage)
        kparams.addStringIfDefined("userLandingPage", self.userLandingPage)
        kparams.addStringIfDefined("contentCategories", self.contentCategories)
        kparams.addIntEnumIfDefined("type", self.type)
        kparams.addStringIfDefined("phone", self.phone)
        kparams.addStringIfDefined("describeYourself", self.describeYourself)
        kparams.addBoolIfDefined("adultContent", self.adultContent)
        kparams.addStringIfDefined("defConversionProfileType", self.defConversionProfileType)
        kparams.addIntIfDefined("notify", self.notify)
        kparams.addIntIfDefined("allowQuickEdit", self.allowQuickEdit)
        kparams.addIntIfDefined("mergeEntryLists", self.mergeEntryLists)
        kparams.addStringIfDefined("notificationsConfig", self.notificationsConfig)
        kparams.addStringIfDefined("allowedFromEmailWhiteList", self.allowedFromEmailWhiteList)
        kparams.addIntIfDefined("maxUploadSize", self.maxUploadSize)
        kparams.addIntIfDefined("partnerPackage", self.partnerPackage)
        kparams.addIntIfDefined("allowMultiNotification", self.allowMultiNotification)
        kparams.addStringIfDefined("adminUserId", self.adminUserId)
        kparams.addStringIfDefined("firstName", self.firstName)
        kparams.addStringIfDefined("lastName", self.lastName)
        kparams.addStringIfDefined("country", self.country)
        kparams.addStringIfDefined("state", self.state)
        kparams.addArrayIfDefined("additionalParams", self.additionalParams)
        kparams.addIntIfDefined("partnerParentId", self.partnerParentId)
        kparams.addStringIfDefined("referenceId", self.referenceId)
        kparams.addArrayIfDefined("eSearchLanguages", self.eSearchLanguages)
        kparams.addArrayIfDefined("passwordStructureValidations", self.passwordStructureValidations)
        kparams.addStringIfDefined("passwordStructureValidationsDescription", self.passwordStructureValidationsDescription)
        kparams.addIntIfDefined("passReplaceFreq", self.passReplaceFreq)
        kparams.addIntIfDefined("maxLoginAttempts", self.maxLoginAttempts)
        kparams.addIntIfDefined("loginBlockPeriod", self.loginBlockPeriod)
        kparams.addIntIfDefined("numPrevPassToKeep", self.numPrevPassToKeep)
        kparams.addBoolIfDefined("isSelfServe", self.isSelfServe)
        return kparams

    def getId(self):
        return self.id

    def getName(self):
        return self.name

    def setName(self, newName):
        self.name = newName

    def getWebsite(self):
        return self.website

    def setWebsite(self, newWebsite):
        self.website = newWebsite

    def getNotificationUrl(self):
        return self.notificationUrl

    def setNotificationUrl(self, newNotificationUrl):
        self.notificationUrl = newNotificationUrl

    def getAppearInSearch(self):
        return self.appearInSearch

    def setAppearInSearch(self, newAppearInSearch):
        self.appearInSearch = newAppearInSearch

    def getCreatedAt(self):
        return self.createdAt

    def getAdminName(self):
        return self.adminName

    def setAdminName(self, newAdminName):
        self.adminName = newAdminName

    def getAdminEmail(self):
        return self.adminEmail

    def setAdminEmail(self, newAdminEmail):
        self.adminEmail = newAdminEmail

    def getDescription(self):
        return self.description

    def setDescription(self, newDescription):
        self.description = newDescription

    def getCommercialUse(self):
        return self.commercialUse

    def setCommercialUse(self, newCommercialUse):
        self.commercialUse = newCommercialUse

    def getLandingPage(self):
        return self.landingPage

    def setLandingPage(self, newLandingPage):
        self.landingPage = newLandingPage

    def getUserLandingPage(self):
        return self.userLandingPage

    def setUserLandingPage(self, newUserLandingPage):
        self.userLandingPage = newUserLandingPage

    def getContentCategories(self):
        return self.contentCategories

    def setContentCategories(self, newContentCategories):
        self.contentCategories = newContentCategories

    def getType(self):
        return self.type

    def setType(self, newType):
        self.type = newType

    def getPhone(self):
        return self.phone

    def setPhone(self, newPhone):
        self.phone = newPhone

    def getDescribeYourself(self):
        return self.describeYourself

    def setDescribeYourself(self, newDescribeYourself):
        self.describeYourself = newDescribeYourself

    def getAdultContent(self):
        return self.adultContent

    def setAdultContent(self, newAdultContent):
        self.adultContent = newAdultContent

    def getDefConversionProfileType(self):
        return self.defConversionProfileType

    def setDefConversionProfileType(self, newDefConversionProfileType):
        self.defConversionProfileType = newDefConversionProfileType

    def getNotify(self):
        return self.notify

    def setNotify(self, newNotify):
        self.notify = newNotify

    def getStatus(self):
        return self.status

    def getAllowQuickEdit(self):
        return self.allowQuickEdit

    def setAllowQuickEdit(self, newAllowQuickEdit):
        self.allowQuickEdit = newAllowQuickEdit

    def getMergeEntryLists(self):
        return self.mergeEntryLists

    def setMergeEntryLists(self, newMergeEntryLists):
        self.mergeEntryLists = newMergeEntryLists

    def getNotificationsConfig(self):
        return self.notificationsConfig

    def setNotificationsConfig(self, newNotificationsConfig):
        self.notificationsConfig = newNotificationsConfig

    def getAllowedFromEmailWhiteList(self):
        return self.allowedFromEmailWhiteList

    def setAllowedFromEmailWhiteList(self, newAllowedFromEmailWhiteList):
        self.allowedFromEmailWhiteList = newAllowedFromEmailWhiteList

    def getMaxUploadSize(self):
        return self.maxUploadSize

    def setMaxUploadSize(self, newMaxUploadSize):
        self.maxUploadSize = newMaxUploadSize

    def getPartnerPackage(self):
        return self.partnerPackage

    def setPartnerPackage(self, newPartnerPackage):
        self.partnerPackage = newPartnerPackage

    def getSecret(self):
        return self.secret

    def getAdminSecret(self):
        return self.adminSecret

    def getCmsPassword(self):
        return self.cmsPassword

    def getAllowMultiNotification(self):
        return self.allowMultiNotification

    def setAllowMultiNotification(self, newAllowMultiNotification):
        self.allowMultiNotification = newAllowMultiNotification

    def getAdminLoginUsersQuota(self):
        return self.adminLoginUsersQuota

    def getAdminUserId(self):
        return self.adminUserId

    def setAdminUserId(self, newAdminUserId):
        self.adminUserId = newAdminUserId

    def getFirstName(self):
        return self.firstName

    def setFirstName(self, newFirstName):
        self.firstName = newFirstName

    def getLastName(self):
        return self.lastName

    def setLastName(self, newLastName):
        self.lastName = newLastName

    def getCountry(self):
        return self.country

    def setCountry(self, newCountry):
        self.country = newCountry

    def getState(self):
        return self.state

    def setState(self, newState):
        self.state = newState

    def getAdditionalParams(self):
        return self.additionalParams

    def setAdditionalParams(self, newAdditionalParams):
        self.additionalParams = newAdditionalParams

    def getPublishersQuota(self):
        return self.publishersQuota

    def getPartnerGroupType(self):
        return self.partnerGroupType

    def getDefaultEntitlementEnforcement(self):
        return self.defaultEntitlementEnforcement

    def getDefaultDeliveryType(self):
        return self.defaultDeliveryType

    def getDefaultEmbedCodeType(self):
        return self.defaultEmbedCodeType

    def getDeliveryTypes(self):
        return self.deliveryTypes

    def getEmbedCodeTypes(self):
        return self.embedCodeTypes

    def getTemplatePartnerId(self):
        return self.templatePartnerId

    def getIgnoreSeoLinks(self):
        return self.ignoreSeoLinks

    def getBlockDirectLogin(self):
        return self.blockDirectLogin

    def getHost(self):
        return self.host

    def getCdnHost(self):
        return self.cdnHost

    def getIsFirstLogin(self):
        return self.isFirstLogin

    def getLogoutUrl(self):
        return self.logoutUrl

    def getPartnerParentId(self):
        return self.partnerParentId

    def setPartnerParentId(self, newPartnerParentId):
        self.partnerParentId = newPartnerParentId

    def getCrmId(self):
        return self.crmId

    def getReferenceId(self):
        return self.referenceId

    def setReferenceId(self, newReferenceId):
        self.referenceId = newReferenceId

    def getTimeAlignedRenditions(self):
        return self.timeAlignedRenditions

    def getPublisherEnvironmentType(self):
        return self.publisherEnvironmentType

    def getOvpEnvironmentUrl(self):
        return self.ovpEnvironmentUrl

    def getOttEnvironmentUrl(self):
        return self.ottEnvironmentUrl

    def getESearchLanguages(self):
        return self.eSearchLanguages

    def setESearchLanguages(self, newESearchLanguages):
        self.eSearchLanguages = newESearchLanguages

    def getAuthenticationType(self):
        return self.authenticationType

    def getExtendedFreeTrailExpiryReason(self):
        return self.extendedFreeTrailExpiryReason

    def getExtendedFreeTrailExpiryDate(self):
        return self.extendedFreeTrailExpiryDate

    def getExtendedFreeTrail(self):
        return self.extendedFreeTrail

    def getExtendedFreeTrailEndsWarning(self):
        return self.extendedFreeTrailEndsWarning

    def getEightyPercentWarning(self):
        return self.eightyPercentWarning

    def getUsageLimitWarning(self):
        return self.usageLimitWarning

    def getLastFreeTrialNotificationDay(self):
        return self.lastFreeTrialNotificationDay

    def getMonitorUsage(self):
        return self.monitorUsage

    def getPasswordStructureValidations(self):
        return self.passwordStructureValidations

    def setPasswordStructureValidations(self, newPasswordStructureValidations):
        self.passwordStructureValidations = newPasswordStructureValidations

    def getPasswordStructureValidationsDescription(self):
        return self.passwordStructureValidationsDescription

    def setPasswordStructureValidationsDescription(self, newPasswordStructureValidationsDescription):
        self.passwordStructureValidationsDescription = newPasswordStructureValidationsDescription

    def getPassReplaceFreq(self):
        return self.passReplaceFreq

    def setPassReplaceFreq(self, newPassReplaceFreq):
        self.passReplaceFreq = newPassReplaceFreq

    def getMaxLoginAttempts(self):
        return self.maxLoginAttempts

    def setMaxLoginAttempts(self, newMaxLoginAttempts):
        self.maxLoginAttempts = newMaxLoginAttempts

    def getLoginBlockPeriod(self):
        return self.loginBlockPeriod

    def setLoginBlockPeriod(self, newLoginBlockPeriod):
        self.loginBlockPeriod = newLoginBlockPeriod

    def getNumPrevPassToKeep(self):
        return self.numPrevPassToKeep

    def setNumPrevPassToKeep(self, newNumPrevPassToKeep):
        self.numPrevPassToKeep = newNumPrevPassToKeep

    def getTwoFactorAuthenticationMode(self):
        return self.twoFactorAuthenticationMode

    def getIsSelfServe(self):
        return self.isSelfServe

    def setIsSelfServe(self, newIsSelfServe):
        self.isSelfServe = newIsSelfServe

    def getAllowedDomains(self):
        return self.allowedDomains

    def getExcludedAdminRoleName(self):
        return self.excludedAdminRoleName


# @package Kaltura
# @subpackage Client
class KalturaValue(KalturaObjectBase):
    """A representation to return an array of values"""

    def __init__(self,
            description=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.description = description


    PROPERTY_LOADERS = {
        'description': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaValue.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaValue")
        kparams.addStringIfDefined("description", self.description)
        return kparams

    def getDescription(self):
        return self.description

    def setDescription(self, newDescription):
        self.description = newDescription


# @package Kaltura
# @subpackage Client
class KalturaBooleanValue(KalturaValue):
    """A boolean representation to return an array of booleans"""

    def __init__(self,
            description=NotImplemented,
            value=NotImplemented):
        KalturaValue.__init__(self,
            description)

        # @var bool
        self.value = value


    PROPERTY_LOADERS = {
        'value': getXmlNodeBool, 
    }

    def fromXml(self, node):
        KalturaValue.fromXml(self, node)
        self.fromXmlImpl(node, KalturaBooleanValue.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaValue.toParams(self)
        kparams.put("objectType", "KalturaBooleanValue")
        kparams.addBoolIfDefined("value", self.value)
        return kparams

    def getValue(self):
        return self.value

    def setValue(self, newValue):
        self.value = newValue


# @package Kaltura
# @subpackage Client
class KalturaBulkUploadPluginData(KalturaObjectBase):
    def __init__(self,
            field=NotImplemented,
            value=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.field = field

        # @var string
        self.value = value


    PROPERTY_LOADERS = {
        'field': getXmlNodeText, 
        'value': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaBulkUploadPluginData.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaBulkUploadPluginData")
        kparams.addStringIfDefined("field", self.field)
        kparams.addStringIfDefined("value", self.value)
        return kparams

    def getField(self):
        return self.field

    def setField(self, newField):
        self.field = newField

    def getValue(self):
        return self.value

    def setValue(self, newValue):
        self.value = newValue


# @package Kaltura
# @subpackage Client
class KalturaBulkUploadResult(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            bulkUploadJobId=NotImplemented,
            lineIndex=NotImplemented,
            partnerId=NotImplemented,
            status=NotImplemented,
            action=NotImplemented,
            objectId=NotImplemented,
            objectStatus=NotImplemented,
            bulkUploadResultObjectType=NotImplemented,
            rowData=NotImplemented,
            partnerData=NotImplemented,
            objectErrorDescription=NotImplemented,
            pluginsData=NotImplemented,
            errorDescription=NotImplemented,
            errorCode=NotImplemented,
            errorType=NotImplemented):
        KalturaObjectBase.__init__(self)

        # The id of the result
        # @var int
        # @readonly
        self.id = id

        # The id of the parent job
        # @var int
        self.bulkUploadJobId = bulkUploadJobId

        # The index of the line in the CSV
        # @var int
        self.lineIndex = lineIndex

        # @var int
        self.partnerId = partnerId

        # @var KalturaBulkUploadResultStatus
        self.status = status

        # @var KalturaBulkUploadAction
        self.action = action

        # @var string
        self.objectId = objectId

        # @var int
        self.objectStatus = objectStatus

        # @var KalturaBulkUploadObjectType
        self.bulkUploadResultObjectType = bulkUploadResultObjectType

        # The data as recieved in the csv
        # @var string
        self.rowData = rowData

        # @var string
        self.partnerData = partnerData

        # @var string
        self.objectErrorDescription = objectErrorDescription

        # @var array of KalturaBulkUploadPluginData
        self.pluginsData = pluginsData

        # @var string
        self.errorDescription = errorDescription

        # @var string
        self.errorCode = errorCode

        # @var int
        self.errorType = errorType


    PROPERTY_LOADERS = {
        'id': getXmlNodeInt, 
        'bulkUploadJobId': getXmlNodeInt, 
        'lineIndex': getXmlNodeInt, 
        'partnerId': getXmlNodeInt, 
        'status': (KalturaEnumsFactory.createString, "KalturaBulkUploadResultStatus"), 
        'action': (KalturaEnumsFactory.createString, "KalturaBulkUploadAction"), 
        'objectId': getXmlNodeText, 
        'objectStatus': getXmlNodeInt, 
        'bulkUploadResultObjectType': (KalturaEnumsFactory.createString, "KalturaBulkUploadObjectType"), 
        'rowData': getXmlNodeText, 
        'partnerData': getXmlNodeText, 
        'objectErrorDescription': getXmlNodeText, 
        'pluginsData': (KalturaObjectFactory.createArray, 'KalturaBulkUploadPluginData'), 
        'errorDescription': getXmlNodeText, 
        'errorCode': getXmlNodeText, 
        'errorType': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaBulkUploadResult.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaBulkUploadResult")
        kparams.addIntIfDefined("bulkUploadJobId", self.bulkUploadJobId)
        kparams.addIntIfDefined("lineIndex", self.lineIndex)
        kparams.addIntIfDefined("partnerId", self.partnerId)
        kparams.addStringEnumIfDefined("status", self.status)
        kparams.addStringEnumIfDefined("action", self.action)
        kparams.addStringIfDefined("objectId", self.objectId)
        kparams.addIntIfDefined("objectStatus", self.objectStatus)
        kparams.addStringEnumIfDefined("bulkUploadResultObjectType", self.bulkUploadResultObjectType)
        kparams.addStringIfDefined("rowData", self.rowData)
        kparams.addStringIfDefined("partnerData", self.partnerData)
        kparams.addStringIfDefined("objectErrorDescription", self.objectErrorDescription)
        kparams.addArrayIfDefined("pluginsData", self.pluginsData)
        kparams.addStringIfDefined("errorDescription", self.errorDescription)
        kparams.addStringIfDefined("errorCode", self.errorCode)
        kparams.addIntIfDefined("errorType", self.errorType)
        return kparams

    def getId(self):
        return self.id

    def getBulkUploadJobId(self):
        return self.bulkUploadJobId

    def setBulkUploadJobId(self, newBulkUploadJobId):
        self.bulkUploadJobId = newBulkUploadJobId

    def getLineIndex(self):
        return self.lineIndex

    def setLineIndex(self, newLineIndex):
        self.lineIndex = newLineIndex

    def getPartnerId(self):
        return self.partnerId

    def setPartnerId(self, newPartnerId):
        self.partnerId = newPartnerId

    def getStatus(self):
        return self.status

    def setStatus(self, newStatus):
        self.status = newStatus

    def getAction(self):
        return self.action

    def setAction(self, newAction):
        self.action = newAction

    def getObjectId(self):
        return self.objectId

    def setObjectId(self, newObjectId):
        self.objectId = newObjectId

    def getObjectStatus(self):
        return self.objectStatus

    def setObjectStatus(self, newObjectStatus):
        self.objectStatus = newObjectStatus

    def getBulkUploadResultObjectType(self):
        return self.bulkUploadResultObjectType

    def setBulkUploadResultObjectType(self, newBulkUploadResultObjectType):
        self.bulkUploadResultObjectType = newBulkUploadResultObjectType

    def getRowData(self):
        return self.rowData

    def setRowData(self, newRowData):
        self.rowData = newRowData

    def getPartnerData(self):
        return self.partnerData

    def setPartnerData(self, newPartnerData):
        self.partnerData = newPartnerData

    def getObjectErrorDescription(self):
        return self.objectErrorDescription

    def setObjectErrorDescription(self, newObjectErrorDescription):
        self.objectErrorDescription = newObjectErrorDescription

    def getPluginsData(self):
        return self.pluginsData

    def setPluginsData(self, newPluginsData):
        self.pluginsData = newPluginsData

    def getErrorDescription(self):
        return self.errorDescription

    def setErrorDescription(self, newErrorDescription):
        self.errorDescription = newErrorDescription

    def getErrorCode(self):
        return self.errorCode

    def setErrorCode(self, newErrorCode):
        self.errorCode = newErrorCode

    def getErrorType(self):
        return self.errorType

    def setErrorType(self, newErrorType):
        self.errorType = newErrorType


# @package Kaltura
# @subpackage Client
class KalturaBulkUpload(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            uploadedBy=NotImplemented,
            uploadedByUserId=NotImplemented,
            uploadedOn=NotImplemented,
            numOfEntries=NotImplemented,
            status=NotImplemented,
            logFileUrl=NotImplemented,
            csvFileUrl=NotImplemented,
            bulkFileUrl=NotImplemented,
            bulkUploadType=NotImplemented,
            results=NotImplemented,
            error=NotImplemented,
            errorType=NotImplemented,
            errorNumber=NotImplemented,
            fileName=NotImplemented,
            description=NotImplemented,
            numOfObjects=NotImplemented,
            bulkUploadObjectType=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var int
        self.id = id

        # @var string
        self.uploadedBy = uploadedBy

        # @var string
        self.uploadedByUserId = uploadedByUserId

        # @var int
        self.uploadedOn = uploadedOn

        # @var int
        self.numOfEntries = numOfEntries

        # @var KalturaBatchJobStatus
        self.status = status

        # @var string
        self.logFileUrl = logFileUrl

        # @var string
        self.csvFileUrl = csvFileUrl

        # @var string
        self.bulkFileUrl = bulkFileUrl

        # @var KalturaBulkUploadType
        self.bulkUploadType = bulkUploadType

        # @var array of KalturaBulkUploadResult
        self.results = results

        # @var string
        self.error = error

        # @var KalturaBatchJobErrorTypes
        self.errorType = errorType

        # @var int
        self.errorNumber = errorNumber

        # @var string
        self.fileName = fileName

        # @var string
        self.description = description

        # @var int
        self.numOfObjects = numOfObjects

        # @var KalturaBulkUploadObjectType
        self.bulkUploadObjectType = bulkUploadObjectType


    PROPERTY_LOADERS = {
        'id': getXmlNodeInt, 
        'uploadedBy': getXmlNodeText, 
        'uploadedByUserId': getXmlNodeText, 
        'uploadedOn': getXmlNodeInt, 
        'numOfEntries': getXmlNodeInt, 
        'status': (KalturaEnumsFactory.createInt, "KalturaBatchJobStatus"), 
        'logFileUrl': getXmlNodeText, 
        'csvFileUrl': getXmlNodeText, 
        'bulkFileUrl': getXmlNodeText, 
        'bulkUploadType': (KalturaEnumsFactory.createString, "KalturaBulkUploadType"), 
        'results': (KalturaObjectFactory.createArray, 'KalturaBulkUploadResult'), 
        'error': getXmlNodeText, 
        'errorType': (KalturaEnumsFactory.createInt, "KalturaBatchJobErrorTypes"), 
        'errorNumber': getXmlNodeInt, 
        'fileName': getXmlNodeText, 
        'description': getXmlNodeText, 
        'numOfObjects': getXmlNodeInt, 
        'bulkUploadObjectType': (KalturaEnumsFactory.createString, "KalturaBulkUploadObjectType"), 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaBulkUpload.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaBulkUpload")
        kparams.addIntIfDefined("id", self.id)
        kparams.addStringIfDefined("uploadedBy", self.uploadedBy)
        kparams.addStringIfDefined("uploadedByUserId", self.uploadedByUserId)
        kparams.addIntIfDefined("uploadedOn", self.uploadedOn)
        kparams.addIntIfDefined("numOfEntries", self.numOfEntries)
        kparams.addIntEnumIfDefined("status", self.status)
        kparams.addStringIfDefined("logFileUrl", self.logFileUrl)
        kparams.addStringIfDefined("csvFileUrl", self.csvFileUrl)
        kparams.addStringIfDefined("bulkFileUrl", self.bulkFileUrl)
        kparams.addStringEnumIfDefined("bulkUploadType", self.bulkUploadType)
        kparams.addArrayIfDefined("results", self.results)
        kparams.addStringIfDefined("error", self.error)
        kparams.addIntEnumIfDefined("errorType", self.errorType)
        kparams.addIntIfDefined("errorNumber", self.errorNumber)
        kparams.addStringIfDefined("fileName", self.fileName)
        kparams.addStringIfDefined("description", self.description)
        kparams.addIntIfDefined("numOfObjects", self.numOfObjects)
        kparams.addStringEnumIfDefined("bulkUploadObjectType", self.bulkUploadObjectType)
        return kparams

    def getId(self):
        return self.id

    def setId(self, newId):
        self.id = newId

    def getUploadedBy(self):
        return self.uploadedBy

    def setUploadedBy(self, newUploadedBy):
        self.uploadedBy = newUploadedBy

    def getUploadedByUserId(self):
        return self.uploadedByUserId

    def setUploadedByUserId(self, newUploadedByUserId):
        self.uploadedByUserId = newUploadedByUserId

    def getUploadedOn(self):
        return self.uploadedOn

    def setUploadedOn(self, newUploadedOn):
        self.uploadedOn = newUploadedOn

    def getNumOfEntries(self):
        return self.numOfEntries

    def setNumOfEntries(self, newNumOfEntries):
        self.numOfEntries = newNumOfEntries

    def getStatus(self):
        return self.status

    def setStatus(self, newStatus):
        self.status = newStatus

    def getLogFileUrl(self):
        return self.logFileUrl

    def setLogFileUrl(self, newLogFileUrl):
        self.logFileUrl = newLogFileUrl

    def getCsvFileUrl(self):
        return self.csvFileUrl

    def setCsvFileUrl(self, newCsvFileUrl):
        self.csvFileUrl = newCsvFileUrl

    def getBulkFileUrl(self):
        return self.bulkFileUrl

    def setBulkFileUrl(self, newBulkFileUrl):
        self.bulkFileUrl = newBulkFileUrl

    def getBulkUploadType(self):
        return self.bulkUploadType

    def setBulkUploadType(self, newBulkUploadType):
        self.bulkUploadType = newBulkUploadType

    def getResults(self):
        return self.results

    def setResults(self, newResults):
        self.results = newResults

    def getError(self):
        return self.error

    def setError(self, newError):
        self.error = newError

    def getErrorType(self):
        return self.errorType

    def setErrorType(self, newErrorType):
        self.errorType = newErrorType

    def getErrorNumber(self):
        return self.errorNumber

    def setErrorNumber(self, newErrorNumber):
        self.errorNumber = newErrorNumber

    def getFileName(self):
        return self.fileName

    def setFileName(self, newFileName):
        self.fileName = newFileName

    def getDescription(self):
        return self.description

    def setDescription(self, newDescription):
        self.description = newDescription

    def getNumOfObjects(self):
        return self.numOfObjects

    def setNumOfObjects(self, newNumOfObjects):
        self.numOfObjects = newNumOfObjects

    def getBulkUploadObjectType(self):
        return self.bulkUploadObjectType

    def setBulkUploadObjectType(self, newBulkUploadObjectType):
        self.bulkUploadObjectType = newBulkUploadObjectType


# @package Kaltura
# @subpackage Client
class KalturaBulkUploadObjectData(KalturaObjectBase):
    """This class represents object-specific data passed to the 
     bulk upload job."""

    def __init__(self):
        KalturaObjectBase.__init__(self)


    PROPERTY_LOADERS = {
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaBulkUploadObjectData.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaBulkUploadObjectData")
        return kparams


# @package Kaltura
# @subpackage Client
class KalturaCEError(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            partnerId=NotImplemented,
            browser=NotImplemented,
            serverIp=NotImplemented,
            serverOs=NotImplemented,
            phpVersion=NotImplemented,
            ceAdminEmail=NotImplemented,
            type=NotImplemented,
            description=NotImplemented,
            data=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        # @readonly
        self.id = id

        # @var int
        self.partnerId = partnerId

        # @var string
        self.browser = browser

        # @var string
        self.serverIp = serverIp

        # @var string
        self.serverOs = serverOs

        # @var string
        self.phpVersion = phpVersion

        # @var string
        self.ceAdminEmail = ceAdminEmail

        # @var string
        self.type = type

        # @var string
        self.description = description

        # @var string
        self.data = data


    PROPERTY_LOADERS = {
        'id': getXmlNodeText, 
        'partnerId': getXmlNodeInt, 
        'browser': getXmlNodeText, 
        'serverIp': getXmlNodeText, 
        'serverOs': getXmlNodeText, 
        'phpVersion': getXmlNodeText, 
        'ceAdminEmail': getXmlNodeText, 
        'type': getXmlNodeText, 
        'description': getXmlNodeText, 
        'data': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaCEError.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaCEError")
        kparams.addIntIfDefined("partnerId", self.partnerId)
        kparams.addStringIfDefined("browser", self.browser)
        kparams.addStringIfDefined("serverIp", self.serverIp)
        kparams.addStringIfDefined("serverOs", self.serverOs)
        kparams.addStringIfDefined("phpVersion", self.phpVersion)
        kparams.addStringIfDefined("ceAdminEmail", self.ceAdminEmail)
        kparams.addStringIfDefined("type", self.type)
        kparams.addStringIfDefined("description", self.description)
        kparams.addStringIfDefined("data", self.data)
        return kparams

    def getId(self):
        return self.id

    def getPartnerId(self):
        return self.partnerId

    def setPartnerId(self, newPartnerId):
        self.partnerId = newPartnerId

    def getBrowser(self):
        return self.browser

    def setBrowser(self, newBrowser):
        self.browser = newBrowser

    def getServerIp(self):
        return self.serverIp

    def setServerIp(self, newServerIp):
        self.serverIp = newServerIp

    def getServerOs(self):
        return self.serverOs

    def setServerOs(self, newServerOs):
        self.serverOs = newServerOs

    def getPhpVersion(self):
        return self.phpVersion

    def setPhpVersion(self, newPhpVersion):
        self.phpVersion = newPhpVersion

    def getCeAdminEmail(self):
        return self.ceAdminEmail

    def setCeAdminEmail(self, newCeAdminEmail):
        self.ceAdminEmail = newCeAdminEmail

    def getType(self):
        return self.type

    def setType(self, newType):
        self.type = newType

    def getDescription(self):
        return self.description

    def setDescription(self, newDescription):
        self.description = newDescription

    def getData(self):
        return self.data

    def setData(self, newData):
        self.data = newData


# @package Kaltura
# @subpackage Client
class KalturaCategory(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            parentId=NotImplemented,
            depth=NotImplemented,
            partnerId=NotImplemented,
            name=NotImplemented,
            fullName=NotImplemented,
            fullIds=NotImplemented,
            entriesCount=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented,
            description=NotImplemented,
            tags=NotImplemented,
            appearInList=NotImplemented,
            privacy=NotImplemented,
            inheritanceType=NotImplemented,
            userJoinPolicy=NotImplemented,
            defaultPermissionLevel=NotImplemented,
            owner=NotImplemented,
            directEntriesCount=NotImplemented,
            referenceId=NotImplemented,
            contributionPolicy=NotImplemented,
            membersCount=NotImplemented,
            pendingMembersCount=NotImplemented,
            privacyContext=NotImplemented,
            privacyContexts=NotImplemented,
            status=NotImplemented,
            inheritedParentId=NotImplemented,
            partnerSortValue=NotImplemented,
            partnerData=NotImplemented,
            defaultOrderBy=NotImplemented,
            directSubCategoriesCount=NotImplemented,
            moderation=NotImplemented,
            pendingEntriesCount=NotImplemented,
            isAggregationCategory=NotImplemented,
            aggregationCategories=NotImplemented,
            adminTags=NotImplemented):
        KalturaObjectBase.__init__(self)

        # The id of the Category
        # @var int
        # @readonly
        self.id = id

        # @var int
        self.parentId = parentId

        # @var int
        # @readonly
        self.depth = depth

        # @var int
        # @readonly
        self.partnerId = partnerId

        # The name of the Category. 
        # 	 The following characters are not allowed: '<', '>', ','
        # @var string
        self.name = name

        # The full name of the Category
        # @var string
        # @readonly
        self.fullName = fullName

        # The full ids of the Category
        # @var string
        # @readonly
        self.fullIds = fullIds

        # Number of entries in this Category (including child categories)
        # @var int
        # @readonly
        self.entriesCount = entriesCount

        # Creation date as Unix timestamp (In seconds)
        # @var int
        # @readonly
        self.createdAt = createdAt

        # Update date as Unix timestamp (In seconds)
        # @var int
        # @readonly
        self.updatedAt = updatedAt

        # Category description
        # @var string
        self.description = description

        # Category tags
        # @var string
        self.tags = tags

        # If category will be returned for list action.
        # @var KalturaAppearInListType
        self.appearInList = appearInList

        # defines the privacy of the entries that assigned to this category
        # @var KalturaPrivacyType
        self.privacy = privacy

        # If Category members are inherited from parent category or set manualy.
        # @var KalturaInheritanceType
        self.inheritanceType = inheritanceType

        # Who can ask to join this category
        # @var KalturaUserJoinPolicyType
        # @readonly
        self.userJoinPolicy = userJoinPolicy

        # Default permissionLevel for new users
        # @var KalturaCategoryUserPermissionLevel
        self.defaultPermissionLevel = defaultPermissionLevel

        # Category Owner (User id)
        # @var string
        self.owner = owner

        # Number of entries that belong to this category directly
        # @var int
        # @readonly
        self.directEntriesCount = directEntriesCount

        # Category external id, controlled and managed by the partner.
        # @var string
        self.referenceId = referenceId

        # who can assign entries to this category
        # @var KalturaContributionPolicyType
        self.contributionPolicy = contributionPolicy

        # Number of active members for this category
        # @var int
        # @readonly
        self.membersCount = membersCount

        # Number of pending members for this category
        # @var int
        # @readonly
        self.pendingMembersCount = pendingMembersCount

        # Set privacy context for search entries that assiged to private and public categories. the entries will be private if the search context is set with those categories.
        # @var string
        self.privacyContext = privacyContext

        # comma separated parents that defines a privacyContext for search
        # @var string
        # @readonly
        self.privacyContexts = privacyContexts

        # Status
        # @var KalturaCategoryStatus
        # @readonly
        self.status = status

        # The category id that this category inherit its members and members permission (for contribution and join)
        # @var int
        # @readonly
        self.inheritedParentId = inheritedParentId

        # Can be used to store various partner related data as a numeric value
        # @var int
        self.partnerSortValue = partnerSortValue

        # Can be used to store various partner related data as a string
        # @var string
        self.partnerData = partnerData

        # Enable client side applications to define how to sort the category child categories
        # @var KalturaCategoryOrderBy
        self.defaultOrderBy = defaultOrderBy

        # Number of direct children categories
        # @var int
        # @readonly
        self.directSubCategoriesCount = directSubCategoriesCount

        # Moderation to add entries to this category by users that are not of permission level Manager or Moderator.
        # @var KalturaNullableBoolean
        self.moderation = moderation

        # Nunber of pending moderation entries
        # @var int
        # @readonly
        self.pendingEntriesCount = pendingEntriesCount

        # Flag indicating that the category is an aggregation category
        # @var KalturaNullableBoolean
        self.isAggregationCategory = isAggregationCategory

        # List of aggregation channels the category belongs to
        # @var string
        self.aggregationCategories = aggregationCategories

        # @var string
        self.adminTags = adminTags


    PROPERTY_LOADERS = {
        'id': getXmlNodeInt, 
        'parentId': getXmlNodeInt, 
        'depth': getXmlNodeInt, 
        'partnerId': getXmlNodeInt, 
        'name': getXmlNodeText, 
        'fullName': getXmlNodeText, 
        'fullIds': getXmlNodeText, 
        'entriesCount': getXmlNodeInt, 
        'createdAt': getXmlNodeInt, 
        'updatedAt': getXmlNodeInt, 
        'description': getXmlNodeText, 
        'tags': getXmlNodeText, 
        'appearInList': (KalturaEnumsFactory.createInt, "KalturaAppearInListType"), 
        'privacy': (KalturaEnumsFactory.createInt, "KalturaPrivacyType"), 
        'inheritanceType': (KalturaEnumsFactory.createInt, "KalturaInheritanceType"), 
        'userJoinPolicy': (KalturaEnumsFactory.createInt, "KalturaUserJoinPolicyType"), 
        'defaultPermissionLevel': (KalturaEnumsFactory.createInt, "KalturaCategoryUserPermissionLevel"), 
        'owner': getXmlNodeText, 
        'directEntriesCount': getXmlNodeInt, 
        'referenceId': getXmlNodeText, 
        'contributionPolicy': (KalturaEnumsFactory.createInt, "KalturaContributionPolicyType"), 
        'membersCount': getXmlNodeInt, 
        'pendingMembersCount': getXmlNodeInt, 
        'privacyContext': getXmlNodeText, 
        'privacyContexts': getXmlNodeText, 
        'status': (KalturaEnumsFactory.createInt, "KalturaCategoryStatus"), 
        'inheritedParentId': getXmlNodeInt, 
        'partnerSortValue': getXmlNodeInt, 
        'partnerData': getXmlNodeText, 
        'defaultOrderBy': (KalturaEnumsFactory.createString, "KalturaCategoryOrderBy"), 
        'directSubCategoriesCount': getXmlNodeInt, 
        'moderation': (KalturaEnumsFactory.createInt, "KalturaNullableBoolean"), 
        'pendingEntriesCount': getXmlNodeInt, 
        'isAggregationCategory': (KalturaEnumsFactory.createInt, "KalturaNullableBoolean"), 
        'aggregationCategories': getXmlNodeText, 
        'adminTags': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaCategory.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaCategory")
        kparams.addIntIfDefined("parentId", self.parentId)
        kparams.addStringIfDefined("name", self.name)
        kparams.addStringIfDefined("description", self.description)
        kparams.addStringIfDefined("tags", self.tags)
        kparams.addIntEnumIfDefined("appearInList", self.appearInList)
        kparams.addIntEnumIfDefined("privacy", self.privacy)
        kparams.addIntEnumIfDefined("inheritanceType", self.inheritanceType)
        kparams.addIntEnumIfDefined("defaultPermissionLevel", self.defaultPermissionLevel)
        kparams.addStringIfDefined("owner", self.owner)
        kparams.addStringIfDefined("referenceId", self.referenceId)
        kparams.addIntEnumIfDefined("contributionPolicy", self.contributionPolicy)
        kparams.addStringIfDefined("privacyContext", self.privacyContext)
        kparams.addIntIfDefined("partnerSortValue", self.partnerSortValue)
        kparams.addStringIfDefined("partnerData", self.partnerData)
        kparams.addStringEnumIfDefined("defaultOrderBy", self.defaultOrderBy)
        kparams.addIntEnumIfDefined("moderation", self.moderation)
        kparams.addIntEnumIfDefined("isAggregationCategory", self.isAggregationCategory)
        kparams.addStringIfDefined("aggregationCategories", self.aggregationCategories)
        kparams.addStringIfDefined("adminTags", self.adminTags)
        return kparams

    def getId(self):
        return self.id

    def getParentId(self):
        return self.parentId

    def setParentId(self, newParentId):
        self.parentId = newParentId

    def getDepth(self):
        return self.depth

    def getPartnerId(self):
        return self.partnerId

    def getName(self):
        return self.name

    def setName(self, newName):
        self.name = newName

    def getFullName(self):
        return self.fullName

    def getFullIds(self):
        return self.fullIds

    def getEntriesCount(self):
        return self.entriesCount

    def getCreatedAt(self):
        return self.createdAt

    def getUpdatedAt(self):
        return self.updatedAt

    def getDescription(self):
        return self.description

    def setDescription(self, newDescription):
        self.description = newDescription

    def getTags(self):
        return self.tags

    def setTags(self, newTags):
        self.tags = newTags

    def getAppearInList(self):
        return self.appearInList

    def setAppearInList(self, newAppearInList):
        self.appearInList = newAppearInList

    def getPrivacy(self):
        return self.privacy

    def setPrivacy(self, newPrivacy):
        self.privacy = newPrivacy

    def getInheritanceType(self):
        return self.inheritanceType

    def setInheritanceType(self, newInheritanceType):
        self.inheritanceType = newInheritanceType

    def getUserJoinPolicy(self):
        return self.userJoinPolicy

    def getDefaultPermissionLevel(self):
        return self.defaultPermissionLevel

    def setDefaultPermissionLevel(self, newDefaultPermissionLevel):
        self.defaultPermissionLevel = newDefaultPermissionLevel

    def getOwner(self):
        return self.owner

    def setOwner(self, newOwner):
        self.owner = newOwner

    def getDirectEntriesCount(self):
        return self.directEntriesCount

    def getReferenceId(self):
        return self.referenceId

    def setReferenceId(self, newReferenceId):
        self.referenceId = newReferenceId

    def getContributionPolicy(self):
        return self.contributionPolicy

    def setContributionPolicy(self, newContributionPolicy):
        self.contributionPolicy = newContributionPolicy

    def getMembersCount(self):
        return self.membersCount

    def getPendingMembersCount(self):
        return self.pendingMembersCount

    def getPrivacyContext(self):
        return self.privacyContext

    def setPrivacyContext(self, newPrivacyContext):
        self.privacyContext = newPrivacyContext

    def getPrivacyContexts(self):
        return self.privacyContexts

    def getStatus(self):
        return self.status

    def getInheritedParentId(self):
        return self.inheritedParentId

    def getPartnerSortValue(self):
        return self.partnerSortValue

    def setPartnerSortValue(self, newPartnerSortValue):
        self.partnerSortValue = newPartnerSortValue

    def getPartnerData(self):
        return self.partnerData

    def setPartnerData(self, newPartnerData):
        self.partnerData = newPartnerData

    def getDefaultOrderBy(self):
        return self.defaultOrderBy

    def setDefaultOrderBy(self, newDefaultOrderBy):
        self.defaultOrderBy = newDefaultOrderBy

    def getDirectSubCategoriesCount(self):
        return self.directSubCategoriesCount

    def getModeration(self):
        return self.moderation

    def setModeration(self, newModeration):
        self.moderation = newModeration

    def getPendingEntriesCount(self):
        return self.pendingEntriesCount

    def getIsAggregationCategory(self):
        return self.isAggregationCategory

    def setIsAggregationCategory(self, newIsAggregationCategory):
        self.isAggregationCategory = newIsAggregationCategory

    def getAggregationCategories(self):
        return self.aggregationCategories

    def setAggregationCategories(self, newAggregationCategories):
        self.aggregationCategories = newAggregationCategories

    def getAdminTags(self):
        return self.adminTags

    def setAdminTags(self, newAdminTags):
        self.adminTags = newAdminTags


# @package Kaltura
# @subpackage Client
class KalturaCategoryEntry(KalturaObjectBase):
    def __init__(self,
            categoryId=NotImplemented,
            entryId=NotImplemented,
            createdAt=NotImplemented,
            categoryFullIds=NotImplemented,
            status=NotImplemented,
            creatorUserId=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var int
        self.categoryId = categoryId

        # entry id
        # @var string
        self.entryId = entryId

        # Creation date as Unix timestamp (In seconds)
        # @var int
        # @readonly
        self.createdAt = createdAt

        # The full ids of the Category
        # @var string
        # @readonly
        self.categoryFullIds = categoryFullIds

        # CategroyEntry status
        # @var KalturaCategoryEntryStatus
        # @readonly
        self.status = status

        # CategroyEntry creator puser ID
        # @var string
        # @readonly
        self.creatorUserId = creatorUserId


    PROPERTY_LOADERS = {
        'categoryId': getXmlNodeInt, 
        'entryId': getXmlNodeText, 
        'createdAt': getXmlNodeInt, 
        'categoryFullIds': getXmlNodeText, 
        'status': (KalturaEnumsFactory.createInt, "KalturaCategoryEntryStatus"), 
        'creatorUserId': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaCategoryEntry.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaCategoryEntry")
        kparams.addIntIfDefined("categoryId", self.categoryId)
        kparams.addStringIfDefined("entryId", self.entryId)
        return kparams

    def getCategoryId(self):
        return self.categoryId

    def setCategoryId(self, newCategoryId):
        self.categoryId = newCategoryId

    def getEntryId(self):
        return self.entryId

    def setEntryId(self, newEntryId):
        self.entryId = newEntryId

    def getCreatedAt(self):
        return self.createdAt

    def getCategoryFullIds(self):
        return self.categoryFullIds

    def getStatus(self):
        return self.status

    def getCreatorUserId(self):
        return self.creatorUserId


# @package Kaltura
# @subpackage Client
class KalturaCategoryUser(KalturaObjectBase):
    def __init__(self,
            categoryId=NotImplemented,
            userId=NotImplemented,
            partnerId=NotImplemented,
            permissionLevel=NotImplemented,
            status=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented,
            updateMethod=NotImplemented,
            categoryFullIds=NotImplemented,
            permissionNames=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var int
        # @insertonly
        self.categoryId = categoryId

        # User id
        # @var string
        # @insertonly
        self.userId = userId

        # Partner id
        # @var int
        # @readonly
        self.partnerId = partnerId

        # Permission level
        # @var KalturaCategoryUserPermissionLevel
        self.permissionLevel = permissionLevel

        # Status
        # @var KalturaCategoryUserStatus
        # @readonly
        self.status = status

        # CategoryUser creation date as Unix timestamp (In seconds)
        # @var int
        # @readonly
        self.createdAt = createdAt

        # CategoryUser update date as Unix timestamp (In seconds)
        # @var int
        # @readonly
        self.updatedAt = updatedAt

        # Update method can be either manual or automatic to distinguish between manual operations (for example in KMC) on automatic - using bulk upload
        # @var KalturaUpdateMethodType
        self.updateMethod = updateMethod

        # The full ids of the Category
        # @var string
        # @readonly
        self.categoryFullIds = categoryFullIds

        # Set of category-related permissions for the current category user.
        # @var string
        self.permissionNames = permissionNames


    PROPERTY_LOADERS = {
        'categoryId': getXmlNodeInt, 
        'userId': getXmlNodeText, 
        'partnerId': getXmlNodeInt, 
        'permissionLevel': (KalturaEnumsFactory.createInt, "KalturaCategoryUserPermissionLevel"), 
        'status': (KalturaEnumsFactory.createInt, "KalturaCategoryUserStatus"), 
        'createdAt': getXmlNodeInt, 
        'updatedAt': getXmlNodeInt, 
        'updateMethod': (KalturaEnumsFactory.createInt, "KalturaUpdateMethodType"), 
        'categoryFullIds': getXmlNodeText, 
        'permissionNames': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaCategoryUser.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaCategoryUser")
        kparams.addIntIfDefined("categoryId", self.categoryId)
        kparams.addStringIfDefined("userId", self.userId)
        kparams.addIntEnumIfDefined("permissionLevel", self.permissionLevel)
        kparams.addIntEnumIfDefined("updateMethod", self.updateMethod)
        kparams.addStringIfDefined("permissionNames", self.permissionNames)
        return kparams

    def getCategoryId(self):
        return self.categoryId

    def setCategoryId(self, newCategoryId):
        self.categoryId = newCategoryId

    def getUserId(self):
        return self.userId

    def setUserId(self, newUserId):
        self.userId = newUserId

    def getPartnerId(self):
        return self.partnerId

    def getPermissionLevel(self):
        return self.permissionLevel

    def setPermissionLevel(self, newPermissionLevel):
        self.permissionLevel = newPermissionLevel

    def getStatus(self):
        return self.status

    def getCreatedAt(self):
        return self.createdAt

    def getUpdatedAt(self):
        return self.updatedAt

    def getUpdateMethod(self):
        return self.updateMethod

    def setUpdateMethod(self, newUpdateMethod):
        self.updateMethod = newUpdateMethod

    def getCategoryFullIds(self):
        return self.categoryFullIds

    def getPermissionNames(self):
        return self.permissionNames

    def setPermissionNames(self, newPermissionNames):
        self.permissionNames = newPermissionNames


# @package Kaltura
# @subpackage Client
class KalturaClientConfiguration(KalturaObjectBase):
    """Define client optional configurations
     /"""

    def __init__(self,
            clientTag=NotImplemented,
            apiVersion=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.clientTag = clientTag

        # @var string
        self.apiVersion = apiVersion


    PROPERTY_LOADERS = {
        'clientTag': getXmlNodeText, 
        'apiVersion': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaClientConfiguration.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaClientConfiguration")
        kparams.addStringIfDefined("clientTag", self.clientTag)
        kparams.addStringIfDefined("apiVersion", self.apiVersion)
        return kparams

    def getClientTag(self):
        return self.clientTag

    def setClientTag(self, newClientTag):
        self.clientTag = newClientTag

    def getApiVersion(self):
        return self.apiVersion

    def setApiVersion(self, newApiVersion):
        self.apiVersion = newApiVersion


# @package Kaltura
# @subpackage Client
class KalturaClientNotification(KalturaObjectBase):
    """Client notification object to hold the notification url and the data when sending client side notifications"""

    def __init__(self,
            url=NotImplemented,
            data=NotImplemented):
        KalturaObjectBase.__init__(self)

        # The URL where the notification should be sent to
        # @var string
        self.url = url

        # The serialized notification data to send
        # @var string
        self.data = data


    PROPERTY_LOADERS = {
        'url': getXmlNodeText, 
        'data': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaClientNotification.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaClientNotification")
        kparams.addStringIfDefined("url", self.url)
        kparams.addStringIfDefined("data", self.data)
        return kparams

    def getUrl(self):
        return self.url

    def setUrl(self, newUrl):
        self.url = newUrl

    def getData(self):
        return self.data

    def setData(self, newData):
        self.data = newData


# @package Kaltura
# @subpackage Client
class KalturaClipDescription(KalturaObjectBase):
    def __init__(self,
            sourceEntryId=NotImplemented,
            startTime=NotImplemented,
            duration=NotImplemented,
            offsetInDestination=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.sourceEntryId = sourceEntryId

        # @var int
        self.startTime = startTime

        # @var int
        self.duration = duration

        # @var int
        self.offsetInDestination = offsetInDestination


    PROPERTY_LOADERS = {
        'sourceEntryId': getXmlNodeText, 
        'startTime': getXmlNodeInt, 
        'duration': getXmlNodeInt, 
        'offsetInDestination': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaClipDescription.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaClipDescription")
        kparams.addStringIfDefined("sourceEntryId", self.sourceEntryId)
        kparams.addIntIfDefined("startTime", self.startTime)
        kparams.addIntIfDefined("duration", self.duration)
        kparams.addIntIfDefined("offsetInDestination", self.offsetInDestination)
        return kparams

    def getSourceEntryId(self):
        return self.sourceEntryId

    def setSourceEntryId(self, newSourceEntryId):
        self.sourceEntryId = newSourceEntryId

    def getStartTime(self):
        return self.startTime

    def setStartTime(self, newStartTime):
        self.startTime = newStartTime

    def getDuration(self):
        return self.duration

    def setDuration(self, newDuration):
        self.duration = newDuration

    def getOffsetInDestination(self):
        return self.offsetInDestination

    def setOffsetInDestination(self, newOffsetInDestination):
        self.offsetInDestination = newOffsetInDestination


# @package Kaltura
# @subpackage Client
class KalturaContext(KalturaObjectBase):
    def __init__(self):
        KalturaObjectBase.__init__(self)


    PROPERTY_LOADERS = {
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaContext.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaContext")
        return kparams


# @package Kaltura
# @subpackage Client
class KalturaContextDataResult(KalturaObjectBase):
    def __init__(self,
            messages=NotImplemented,
            actions=NotImplemented):
        KalturaObjectBase.__init__(self)

        # Array of messages as received from the rules that invalidated
        # @var array of KalturaString
        self.messages = messages

        # Array of actions as received from the rules that invalidated
        # @var array of KalturaRuleAction
        self.actions = actions


    PROPERTY_LOADERS = {
        'messages': (KalturaObjectFactory.createArray, 'KalturaString'), 
        'actions': (KalturaObjectFactory.createArray, 'KalturaRuleAction'), 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaContextDataResult.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaContextDataResult")
        kparams.addArrayIfDefined("messages", self.messages)
        kparams.addArrayIfDefined("actions", self.actions)
        return kparams

    def getMessages(self):
        return self.messages

    def setMessages(self, newMessages):
        self.messages = newMessages

    def getActions(self):
        return self.actions

    def setActions(self, newActions):
        self.actions = newActions


# @package Kaltura
# @subpackage Client
class KalturaControlPanelCommand(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            createdAt=NotImplemented,
            createdBy=NotImplemented,
            updatedAt=NotImplemented,
            updatedBy=NotImplemented,
            createdById=NotImplemented,
            schedulerId=NotImplemented,
            workerId=NotImplemented,
            workerConfiguredId=NotImplemented,
            workerName=NotImplemented,
            batchIndex=NotImplemented,
            type=NotImplemented,
            targetType=NotImplemented,
            status=NotImplemented,
            cause=NotImplemented,
            description=NotImplemented,
            errorDescription=NotImplemented):
        KalturaObjectBase.__init__(self)

        # The id of the Category
        # @var int
        # @readonly
        self.id = id

        # Creation date as Unix timestamp (In seconds)
        # @var int
        # @readonly
        self.createdAt = createdAt

        # Creator name
        # @var string
        self.createdBy = createdBy

        # Update date as Unix timestamp (In seconds)
        # @var int
        # @readonly
        self.updatedAt = updatedAt

        # Updater name
        # @var string
        self.updatedBy = updatedBy

        # Creator id
        # @var int
        self.createdById = createdById

        # The id of the scheduler that the command refers to
        # @var int
        self.schedulerId = schedulerId

        # The id of the scheduler worker that the command refers to
        # @var int
        self.workerId = workerId

        # The id of the scheduler worker as configured in the ini file
        # @var int
        self.workerConfiguredId = workerConfiguredId

        # The name of the scheduler worker that the command refers to
        # @var int
        self.workerName = workerName

        # The index of the batch process that the command refers to
        # @var int
        self.batchIndex = batchIndex

        # The command type - stop / start / config
        # @var KalturaControlPanelCommandType
        self.type = type

        # The command target type - data center / scheduler / job / job type
        # @var KalturaControlPanelCommandTargetType
        self.targetType = targetType

        # The command status
        # @var KalturaControlPanelCommandStatus
        self.status = status

        # The reason for the command
        # @var string
        self.cause = cause

        # Command description
        # @var string
        self.description = description

        # Error description
        # @var string
        self.errorDescription = errorDescription


    PROPERTY_LOADERS = {
        'id': getXmlNodeInt, 
        'createdAt': getXmlNodeInt, 
        'createdBy': getXmlNodeText, 
        'updatedAt': getXmlNodeInt, 
        'updatedBy': getXmlNodeText, 
        'createdById': getXmlNodeInt, 
        'schedulerId': getXmlNodeInt, 
        'workerId': getXmlNodeInt, 
        'workerConfiguredId': getXmlNodeInt, 
        'workerName': getXmlNodeInt, 
        'batchIndex': getXmlNodeInt, 
        'type': (KalturaEnumsFactory.createInt, "KalturaControlPanelCommandType"), 
        'targetType': (KalturaEnumsFactory.createInt, "KalturaControlPanelCommandTargetType"), 
        'status': (KalturaEnumsFactory.createInt, "KalturaControlPanelCommandStatus"), 
        'cause': getXmlNodeText, 
        'description': getXmlNodeText, 
        'errorDescription': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaControlPanelCommand.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaControlPanelCommand")
        kparams.addStringIfDefined("createdBy", self.createdBy)
        kparams.addStringIfDefined("updatedBy", self.updatedBy)
        kparams.addIntIfDefined("createdById", self.createdById)
        kparams.addIntIfDefined("schedulerId", self.schedulerId)
        kparams.addIntIfDefined("workerId", self.workerId)
        kparams.addIntIfDefined("workerConfiguredId", self.workerConfiguredId)
        kparams.addIntIfDefined("workerName", self.workerName)
        kparams.addIntIfDefined("batchIndex", self.batchIndex)
        kparams.addIntEnumIfDefined("type", self.type)
        kparams.addIntEnumIfDefined("targetType", self.targetType)
        kparams.addIntEnumIfDefined("status", self.status)
        kparams.addStringIfDefined("cause", self.cause)
        kparams.addStringIfDefined("description", self.description)
        kparams.addStringIfDefined("errorDescription", self.errorDescription)
        return kparams

    def getId(self):
        return self.id

    def getCreatedAt(self):
        return self.createdAt

    def getCreatedBy(self):
        return self.createdBy

    def setCreatedBy(self, newCreatedBy):
        self.createdBy = newCreatedBy

    def getUpdatedAt(self):
        return self.updatedAt

    def getUpdatedBy(self):
        return self.updatedBy

    def setUpdatedBy(self, newUpdatedBy):
        self.updatedBy = newUpdatedBy

    def getCreatedById(self):
        return self.createdById

    def setCreatedById(self, newCreatedById):
        self.createdById = newCreatedById

    def getSchedulerId(self):
        return self.schedulerId

    def setSchedulerId(self, newSchedulerId):
        self.schedulerId = newSchedulerId

    def getWorkerId(self):
        return self.workerId

    def setWorkerId(self, newWorkerId):
        self.workerId = newWorkerId

    def getWorkerConfiguredId(self):
        return self.workerConfiguredId

    def setWorkerConfiguredId(self, newWorkerConfiguredId):
        self.workerConfiguredId = newWorkerConfiguredId

    def getWorkerName(self):
        return self.workerName

    def setWorkerName(self, newWorkerName):
        self.workerName = newWorkerName

    def getBatchIndex(self):
        return self.batchIndex

    def setBatchIndex(self, newBatchIndex):
        self.batchIndex = newBatchIndex

    def getType(self):
        return self.type

    def setType(self, newType):
        self.type = newType

    def getTargetType(self):
        return self.targetType

    def setTargetType(self, newTargetType):
        self.targetType = newTargetType

    def getStatus(self):
        return self.status

    def setStatus(self, newStatus):
        self.status = newStatus

    def getCause(self):
        return self.cause

    def setCause(self, newCause):
        self.cause = newCause

    def getDescription(self):
        return self.description

    def setDescription(self, newDescription):
        self.description = newDescription

    def getErrorDescription(self):
        return self.errorDescription

    def setErrorDescription(self, newErrorDescription):
        self.errorDescription = newErrorDescription


# @package Kaltura
# @subpackage Client
class KalturaConversionAttribute(KalturaObjectBase):
    def __init__(self,
            flavorParamsId=NotImplemented,
            name=NotImplemented,
            value=NotImplemented):
        KalturaObjectBase.__init__(self)

        # The id of the flavor params, set to null for source flavor
        # @var int
        self.flavorParamsId = flavorParamsId

        # Attribute name
        # @var string
        self.name = name

        # Attribute value
        # @var string
        self.value = value


    PROPERTY_LOADERS = {
        'flavorParamsId': getXmlNodeInt, 
        'name': getXmlNodeText, 
        'value': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaConversionAttribute.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaConversionAttribute")
        kparams.addIntIfDefined("flavorParamsId", self.flavorParamsId)
        kparams.addStringIfDefined("name", self.name)
        kparams.addStringIfDefined("value", self.value)
        return kparams

    def getFlavorParamsId(self):
        return self.flavorParamsId

    def setFlavorParamsId(self, newFlavorParamsId):
        self.flavorParamsId = newFlavorParamsId

    def getName(self):
        return self.name

    def setName(self, newName):
        self.name = newName

    def getValue(self):
        return self.value

    def setValue(self, newValue):
        self.value = newValue


# @package Kaltura
# @subpackage Client
class KalturaCropDimensions(KalturaObjectBase):
    def __init__(self,
            left=NotImplemented,
            top=NotImplemented,
            width=NotImplemented,
            height=NotImplemented):
        KalturaObjectBase.__init__(self)

        # Crop left point
        # @var int
        self.left = left

        # Crop top point
        # @var int
        self.top = top

        # Crop width
        # @var int
        self.width = width

        # Crop height
        # @var int
        self.height = height


    PROPERTY_LOADERS = {
        'left': getXmlNodeInt, 
        'top': getXmlNodeInt, 
        'width': getXmlNodeInt, 
        'height': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaCropDimensions.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaCropDimensions")
        kparams.addIntIfDefined("left", self.left)
        kparams.addIntIfDefined("top", self.top)
        kparams.addIntIfDefined("width", self.width)
        kparams.addIntIfDefined("height", self.height)
        return kparams

    def getLeft(self):
        return self.left

    def setLeft(self, newLeft):
        self.left = newLeft

    def getTop(self):
        return self.top

    def setTop(self, newTop):
        self.top = newTop

    def getWidth(self):
        return self.width

    def setWidth(self, newWidth):
        self.width = newWidth

    def getHeight(self):
        return self.height

    def setHeight(self, newHeight):
        self.height = newHeight


# @package Kaltura
# @subpackage Client
class KalturaPluginReplacementOptionsItem(KalturaObjectBase):
    def __init__(self):
        KalturaObjectBase.__init__(self)


    PROPERTY_LOADERS = {
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaPluginReplacementOptionsItem.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaPluginReplacementOptionsItem")
        return kparams


# @package Kaltura
# @subpackage Client
class KalturaEntryReplacementOptions(KalturaObjectBase):
    """Advanced configuration for entry replacement process"""

    def __init__(self,
            keepManualThumbnails=NotImplemented,
            pluginOptionItems=NotImplemented):
        KalturaObjectBase.__init__(self)

        # If true manually created thumbnails will not be deleted on entry replacement
        # @var int
        self.keepManualThumbnails = keepManualThumbnails

        # Array of plugin replacement options
        # @var array of KalturaPluginReplacementOptionsItem
        self.pluginOptionItems = pluginOptionItems


    PROPERTY_LOADERS = {
        'keepManualThumbnails': getXmlNodeInt, 
        'pluginOptionItems': (KalturaObjectFactory.createArray, 'KalturaPluginReplacementOptionsItem'), 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaEntryReplacementOptions.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaEntryReplacementOptions")
        kparams.addIntIfDefined("keepManualThumbnails", self.keepManualThumbnails)
        kparams.addArrayIfDefined("pluginOptionItems", self.pluginOptionItems)
        return kparams

    def getKeepManualThumbnails(self):
        return self.keepManualThumbnails

    def setKeepManualThumbnails(self, newKeepManualThumbnails):
        self.keepManualThumbnails = newKeepManualThumbnails

    def getPluginOptionItems(self):
        return self.pluginOptionItems

    def setPluginOptionItems(self, newPluginOptionItems):
        self.pluginOptionItems = newPluginOptionItems


# @package Kaltura
# @subpackage Client
class KalturaConversionProfile(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            partnerId=NotImplemented,
            status=NotImplemented,
            type=NotImplemented,
            name=NotImplemented,
            systemName=NotImplemented,
            tags=NotImplemented,
            description=NotImplemented,
            defaultEntryId=NotImplemented,
            createdAt=NotImplemented,
            flavorParamsIds=NotImplemented,
            isDefault=NotImplemented,
            isPartnerDefault=NotImplemented,
            cropDimensions=NotImplemented,
            clipStart=NotImplemented,
            clipDuration=NotImplemented,
            xslTransformation=NotImplemented,
            storageProfileId=NotImplemented,
            mediaParserType=NotImplemented,
            calculateComplexity=NotImplemented,
            collectionTags=NotImplemented,
            conditionalProfiles=NotImplemented,
            detectGOP=NotImplemented,
            mediaInfoXslTransformation=NotImplemented,
            defaultReplacementOptions=NotImplemented,
            defaultAudioLang=NotImplemented):
        KalturaObjectBase.__init__(self)

        # The id of the Conversion Profile
        # @var int
        # @readonly
        self.id = id

        # @var int
        # @readonly
        self.partnerId = partnerId

        # @var KalturaConversionProfileStatus
        self.status = status

        # @var KalturaConversionProfileType
        # @insertonly
        self.type = type

        # The name of the Conversion Profile
        # @var string
        self.name = name

        # System name of the Conversion Profile
        # @var string
        self.systemName = systemName

        # Comma separated tags
        # @var string
        self.tags = tags

        # The description of the Conversion Profile
        # @var string
        self.description = description

        # ID of the default entry to be used for template data
        # @var string
        self.defaultEntryId = defaultEntryId

        # Creation date as Unix timestamp (In seconds)
        # @var int
        # @readonly
        self.createdAt = createdAt

        # List of included flavor ids (comma separated)
        # @var string
        self.flavorParamsIds = flavorParamsIds

        # Indicates that this conversion profile is system default
        # @var KalturaNullableBoolean
        self.isDefault = isDefault

        # Indicates that this conversion profile is partner default
        # @var bool
        # @readonly
        self.isPartnerDefault = isPartnerDefault

        # Cropping dimensions
        # @var KalturaCropDimensions
        self.cropDimensions = cropDimensions

        # Clipping start position (in miliseconds)
        # @var int
        self.clipStart = clipStart

        # Clipping duration (in miliseconds)
        # @var int
        self.clipDuration = clipDuration

        # XSL to transform ingestion MRSS XML
        # @var string
        self.xslTransformation = xslTransformation

        # ID of default storage profile to be used for linked net-storage file syncs
        # @var int
        self.storageProfileId = storageProfileId

        # Media parser type to be used for extract media
        # @var KalturaMediaParserType
        self.mediaParserType = mediaParserType

        # Should calculate file conversion complexity
        # @var KalturaNullableBoolean
        self.calculateComplexity = calculateComplexity

        # Defines the tags that should be used to define 'collective'/group/multi-flavor processing,
        # 	 like 'mbr' or 'ism'
        # @var string
        self.collectionTags = collectionTags

        # JSON string with array of "condition,profile-id" pairs.
        # @var string
        self.conditionalProfiles = conditionalProfiles

        # When set, the ExtractMedia job should detect the source file GOP using this value as the max calculated period
        # @var int
        self.detectGOP = detectGOP

        # XSL to transform ingestion Media Info XML
        # @var string
        self.mediaInfoXslTransformation = mediaInfoXslTransformation

        # Default replacement options to be applied to entries
        # @var KalturaEntryReplacementOptions
        self.defaultReplacementOptions = defaultReplacementOptions

        # @var KalturaLanguage
        self.defaultAudioLang = defaultAudioLang


    PROPERTY_LOADERS = {
        'id': getXmlNodeInt, 
        'partnerId': getXmlNodeInt, 
        'status': (KalturaEnumsFactory.createString, "KalturaConversionProfileStatus"), 
        'type': (KalturaEnumsFactory.createString, "KalturaConversionProfileType"), 
        'name': getXmlNodeText, 
        'systemName': getXmlNodeText, 
        'tags': getXmlNodeText, 
        'description': getXmlNodeText, 
        'defaultEntryId': getXmlNodeText, 
        'createdAt': getXmlNodeInt, 
        'flavorParamsIds': getXmlNodeText, 
        'isDefault': (KalturaEnumsFactory.createInt, "KalturaNullableBoolean"), 
        'isPartnerDefault': getXmlNodeBool, 
        'cropDimensions': (KalturaObjectFactory.create, 'KalturaCropDimensions'), 
        'clipStart': getXmlNodeInt, 
        'clipDuration': getXmlNodeInt, 
        'xslTransformation': getXmlNodeText, 
        'storageProfileId': getXmlNodeInt, 
        'mediaParserType': (KalturaEnumsFactory.createString, "KalturaMediaParserType"), 
        'calculateComplexity': (KalturaEnumsFactory.createInt, "KalturaNullableBoolean"), 
        'collectionTags': getXmlNodeText, 
        'conditionalProfiles': getXmlNodeText, 
        'detectGOP': getXmlNodeInt, 
        'mediaInfoXslTransformation': getXmlNodeText, 
        'defaultReplacementOptions': (KalturaObjectFactory.create, 'KalturaEntryReplacementOptions'), 
        'defaultAudioLang': (KalturaEnumsFactory.createString, "KalturaLanguage"), 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaConversionProfile.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaConversionProfile")
        kparams.addStringEnumIfDefined("status", self.status)
        kparams.addStringEnumIfDefined("type", self.type)
        kparams.addStringIfDefined("name", self.name)
        kparams.addStringIfDefined("systemName", self.systemName)
        kparams.addStringIfDefined("tags", self.tags)
        kparams.addStringIfDefined("description", self.description)
        kparams.addStringIfDefined("defaultEntryId", self.defaultEntryId)
        kparams.addStringIfDefined("flavorParamsIds", self.flavorParamsIds)
        kparams.addIntEnumIfDefined("isDefault", self.isDefault)
        kparams.addObjectIfDefined("cropDimensions", self.cropDimensions)
        kparams.addIntIfDefined("clipStart", self.clipStart)
        kparams.addIntIfDefined("clipDuration", self.clipDuration)
        kparams.addStringIfDefined("xslTransformation", self.xslTransformation)
        kparams.addIntIfDefined("storageProfileId", self.storageProfileId)
        kparams.addStringEnumIfDefined("mediaParserType", self.mediaParserType)
        kparams.addIntEnumIfDefined("calculateComplexity", self.calculateComplexity)
        kparams.addStringIfDefined("collectionTags", self.collectionTags)
        kparams.addStringIfDefined("conditionalProfiles", self.conditionalProfiles)
        kparams.addIntIfDefined("detectGOP", self.detectGOP)
        kparams.addStringIfDefined("mediaInfoXslTransformation", self.mediaInfoXslTransformation)
        kparams.addObjectIfDefined("defaultReplacementOptions", self.defaultReplacementOptions)
        kparams.addStringEnumIfDefined("defaultAudioLang", self.defaultAudioLang)
        return kparams

    def getId(self):
        return self.id

    def getPartnerId(self):
        return self.partnerId

    def getStatus(self):
        return self.status

    def setStatus(self, newStatus):
        self.status = newStatus

    def getType(self):
        return self.type

    def setType(self, newType):
        self.type = newType

    def getName(self):
        return self.name

    def setName(self, newName):
        self.name = newName

    def getSystemName(self):
        return self.systemName

    def setSystemName(self, newSystemName):
        self.systemName = newSystemName

    def getTags(self):
        return self.tags

    def setTags(self, newTags):
        self.tags = newTags

    def getDescription(self):
        return self.description

    def setDescription(self, newDescription):
        self.description = newDescription

    def getDefaultEntryId(self):
        return self.defaultEntryId

    def setDefaultEntryId(self, newDefaultEntryId):
        self.defaultEntryId = newDefaultEntryId

    def getCreatedAt(self):
        return self.createdAt

    def getFlavorParamsIds(self):
        return self.flavorParamsIds

    def setFlavorParamsIds(self, newFlavorParamsIds):
        self.flavorParamsIds = newFlavorParamsIds

    def getIsDefault(self):
        return self.isDefault

    def setIsDefault(self, newIsDefault):
        self.isDefault = newIsDefault

    def getIsPartnerDefault(self):
        return self.isPartnerDefault

    def getCropDimensions(self):
        return self.cropDimensions

    def setCropDimensions(self, newCropDimensions):
        self.cropDimensions = newCropDimensions

    def getClipStart(self):
        return self.clipStart

    def setClipStart(self, newClipStart):
        self.clipStart = newClipStart

    def getClipDuration(self):
        return self.clipDuration

    def setClipDuration(self, newClipDuration):
        self.clipDuration = newClipDuration

    def getXslTransformation(self):
        return self.xslTransformation

    def setXslTransformation(self, newXslTransformation):
        self.xslTransformation = newXslTransformation

    def getStorageProfileId(self):
        return self.storageProfileId

    def setStorageProfileId(self, newStorageProfileId):
        self.storageProfileId = newStorageProfileId

    def getMediaParserType(self):
        return self.mediaParserType

    def setMediaParserType(self, newMediaParserType):
        self.mediaParserType = newMediaParserType

    def getCalculateComplexity(self):
        return self.calculateComplexity

    def setCalculateComplexity(self, newCalculateComplexity):
        self.calculateComplexity = newCalculateComplexity

    def getCollectionTags(self):
        return self.collectionTags

    def setCollectionTags(self, newCollectionTags):
        self.collectionTags = newCollectionTags

    def getConditionalProfiles(self):
        return self.conditionalProfiles

    def setConditionalProfiles(self, newConditionalProfiles):
        self.conditionalProfiles = newConditionalProfiles

    def getDetectGOP(self):
        return self.detectGOP

    def setDetectGOP(self, newDetectGOP):
        self.detectGOP = newDetectGOP

    def getMediaInfoXslTransformation(self):
        return self.mediaInfoXslTransformation

    def setMediaInfoXslTransformation(self, newMediaInfoXslTransformation):
        self.mediaInfoXslTransformation = newMediaInfoXslTransformation

    def getDefaultReplacementOptions(self):
        return self.defaultReplacementOptions

    def setDefaultReplacementOptions(self, newDefaultReplacementOptions):
        self.defaultReplacementOptions = newDefaultReplacementOptions

    def getDefaultAudioLang(self):
        return self.defaultAudioLang

    def setDefaultAudioLang(self, newDefaultAudioLang):
        self.defaultAudioLang = newDefaultAudioLang


# @package Kaltura
# @subpackage Client
class KalturaConversionProfileAssetParams(KalturaObjectBase):
    def __init__(self,
            conversionProfileId=NotImplemented,
            assetParamsId=NotImplemented,
            readyBehavior=NotImplemented,
            origin=NotImplemented,
            systemName=NotImplemented,
            forceNoneComplied=NotImplemented,
            deletePolicy=NotImplemented,
            isEncrypted=NotImplemented,
            contentAwareness=NotImplemented,
            chunkedEncodeMode=NotImplemented,
            twoPass=NotImplemented,
            tags=NotImplemented,
            overloadParams=NotImplemented):
        KalturaObjectBase.__init__(self)

        # The id of the conversion profile
        # @var int
        # @readonly
        self.conversionProfileId = conversionProfileId

        # The id of the asset params
        # @var int
        # @readonly
        self.assetParamsId = assetParamsId

        # The ingestion origin of the asset params
        # @var KalturaFlavorReadyBehaviorType
        self.readyBehavior = readyBehavior

        # The ingestion origin of the asset params
        # @var KalturaAssetParamsOrigin
        self.origin = origin

        # Asset params system name
        # @var string
        self.systemName = systemName

        # Starts conversion even if the decision layer reduced the configuration to comply with the source
        # @var KalturaNullableBoolean
        self.forceNoneComplied = forceNoneComplied

        # Specifies how to treat the flavor after conversion is finished
        # @var KalturaAssetParamsDeletePolicy
        self.deletePolicy = deletePolicy

        # @var KalturaNullableBoolean
        self.isEncrypted = isEncrypted

        # @var float
        self.contentAwareness = contentAwareness

        # @var int
        self.chunkedEncodeMode = chunkedEncodeMode

        # @var KalturaNullableBoolean
        self.twoPass = twoPass

        # @var string
        self.tags = tags

        # JSON string containing an array of flavotParams field-value pairs.
        # @var string
        self.overloadParams = overloadParams


    PROPERTY_LOADERS = {
        'conversionProfileId': getXmlNodeInt, 
        'assetParamsId': getXmlNodeInt, 
        'readyBehavior': (KalturaEnumsFactory.createInt, "KalturaFlavorReadyBehaviorType"), 
        'origin': (KalturaEnumsFactory.createInt, "KalturaAssetParamsOrigin"), 
        'systemName': getXmlNodeText, 
        'forceNoneComplied': (KalturaEnumsFactory.createInt, "KalturaNullableBoolean"), 
        'deletePolicy': (KalturaEnumsFactory.createInt, "KalturaAssetParamsDeletePolicy"), 
        'isEncrypted': (KalturaEnumsFactory.createInt, "KalturaNullableBoolean"), 
        'contentAwareness': getXmlNodeFloat, 
        'chunkedEncodeMode': getXmlNodeInt, 
        'twoPass': (KalturaEnumsFactory.createInt, "KalturaNullableBoolean"), 
        'tags': getXmlNodeText, 
        'overloadParams': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaConversionProfileAssetParams.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaConversionProfileAssetParams")
        kparams.addIntEnumIfDefined("readyBehavior", self.readyBehavior)
        kparams.addIntEnumIfDefined("origin", self.origin)
        kparams.addStringIfDefined("systemName", self.systemName)
        kparams.addIntEnumIfDefined("forceNoneComplied", self.forceNoneComplied)
        kparams.addIntEnumIfDefined("deletePolicy", self.deletePolicy)
        kparams.addIntEnumIfDefined("isEncrypted", self.isEncrypted)
        kparams.addFloatIfDefined("contentAwareness", self.contentAwareness)
        kparams.addIntIfDefined("chunkedEncodeMode", self.chunkedEncodeMode)
        kparams.addIntEnumIfDefined("twoPass", self.twoPass)
        kparams.addStringIfDefined("tags", self.tags)
        kparams.addStringIfDefined("overloadParams", self.overloadParams)
        return kparams

    def getConversionProfileId(self):
        return self.conversionProfileId

    def getAssetParamsId(self):
        return self.assetParamsId

    def getReadyBehavior(self):
        return self.readyBehavior

    def setReadyBehavior(self, newReadyBehavior):
        self.readyBehavior = newReadyBehavior

    def getOrigin(self):
        return self.origin

    def setOrigin(self, newOrigin):
        self.origin = newOrigin

    def getSystemName(self):
        return self.systemName

    def setSystemName(self, newSystemName):
        self.systemName = newSystemName

    def getForceNoneComplied(self):
        return self.forceNoneComplied

    def setForceNoneComplied(self, newForceNoneComplied):
        self.forceNoneComplied = newForceNoneComplied

    def getDeletePolicy(self):
        return self.deletePolicy

    def setDeletePolicy(self, newDeletePolicy):
        self.deletePolicy = newDeletePolicy

    def getIsEncrypted(self):
        return self.isEncrypted

    def setIsEncrypted(self, newIsEncrypted):
        self.isEncrypted = newIsEncrypted

    def getContentAwareness(self):
        return self.contentAwareness

    def setContentAwareness(self, newContentAwareness):
        self.contentAwareness = newContentAwareness

    def getChunkedEncodeMode(self):
        return self.chunkedEncodeMode

    def setChunkedEncodeMode(self, newChunkedEncodeMode):
        self.chunkedEncodeMode = newChunkedEncodeMode

    def getTwoPass(self):
        return self.twoPass

    def setTwoPass(self, newTwoPass):
        self.twoPass = newTwoPass

    def getTags(self):
        return self.tags

    def setTags(self, newTags):
        self.tags = newTags

    def getOverloadParams(self):
        return self.overloadParams

    def setOverloadParams(self, newOverloadParams):
        self.overloadParams = newOverloadParams


# @package Kaltura
# @subpackage Client
class KalturaConvertCollectionFlavorData(KalturaObjectBase):
    def __init__(self,
            flavorAssetId=NotImplemented,
            flavorParamsOutputId=NotImplemented,
            readyBehavior=NotImplemented,
            videoBitrate=NotImplemented,
            audioBitrate=NotImplemented,
            destFileSyncLocalPath=NotImplemented,
            destFileSyncRemoteUrl=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.flavorAssetId = flavorAssetId

        # @var int
        self.flavorParamsOutputId = flavorParamsOutputId

        # @var int
        self.readyBehavior = readyBehavior

        # @var int
        self.videoBitrate = videoBitrate

        # @var int
        self.audioBitrate = audioBitrate

        # @var string
        self.destFileSyncLocalPath = destFileSyncLocalPath

        # @var string
        self.destFileSyncRemoteUrl = destFileSyncRemoteUrl


    PROPERTY_LOADERS = {
        'flavorAssetId': getXmlNodeText, 
        'flavorParamsOutputId': getXmlNodeInt, 
        'readyBehavior': getXmlNodeInt, 
        'videoBitrate': getXmlNodeInt, 
        'audioBitrate': getXmlNodeInt, 
        'destFileSyncLocalPath': getXmlNodeText, 
        'destFileSyncRemoteUrl': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaConvertCollectionFlavorData.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaConvertCollectionFlavorData")
        kparams.addStringIfDefined("flavorAssetId", self.flavorAssetId)
        kparams.addIntIfDefined("flavorParamsOutputId", self.flavorParamsOutputId)
        kparams.addIntIfDefined("readyBehavior", self.readyBehavior)
        kparams.addIntIfDefined("videoBitrate", self.videoBitrate)
        kparams.addIntIfDefined("audioBitrate", self.audioBitrate)
        kparams.addStringIfDefined("destFileSyncLocalPath", self.destFileSyncLocalPath)
        kparams.addStringIfDefined("destFileSyncRemoteUrl", self.destFileSyncRemoteUrl)
        return kparams

    def getFlavorAssetId(self):
        return self.flavorAssetId

    def setFlavorAssetId(self, newFlavorAssetId):
        self.flavorAssetId = newFlavorAssetId

    def getFlavorParamsOutputId(self):
        return self.flavorParamsOutputId

    def setFlavorParamsOutputId(self, newFlavorParamsOutputId):
        self.flavorParamsOutputId = newFlavorParamsOutputId

    def getReadyBehavior(self):
        return self.readyBehavior

    def setReadyBehavior(self, newReadyBehavior):
        self.readyBehavior = newReadyBehavior

    def getVideoBitrate(self):
        return self.videoBitrate

    def setVideoBitrate(self, newVideoBitrate):
        self.videoBitrate = newVideoBitrate

    def getAudioBitrate(self):
        return self.audioBitrate

    def setAudioBitrate(self, newAudioBitrate):
        self.audioBitrate = newAudioBitrate

    def getDestFileSyncLocalPath(self):
        return self.destFileSyncLocalPath

    def setDestFileSyncLocalPath(self, newDestFileSyncLocalPath):
        self.destFileSyncLocalPath = newDestFileSyncLocalPath

    def getDestFileSyncRemoteUrl(self):
        return self.destFileSyncRemoteUrl

    def setDestFileSyncRemoteUrl(self, newDestFileSyncRemoteUrl):
        self.destFileSyncRemoteUrl = newDestFileSyncRemoteUrl


# @package Kaltura
# @subpackage Client
class KalturaCoordinate(KalturaObjectBase):
    def __init__(self,
            latitude=NotImplemented,
            longitude=NotImplemented,
            name=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var float
        self.latitude = latitude

        # @var float
        self.longitude = longitude

        # @var string
        self.name = name


    PROPERTY_LOADERS = {
        'latitude': getXmlNodeFloat, 
        'longitude': getXmlNodeFloat, 
        'name': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaCoordinate.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaCoordinate")
        kparams.addFloatIfDefined("latitude", self.latitude)
        kparams.addFloatIfDefined("longitude", self.longitude)
        kparams.addStringIfDefined("name", self.name)
        return kparams

    def getLatitude(self):
        return self.latitude

    def setLatitude(self, newLatitude):
        self.latitude = newLatitude

    def getLongitude(self):
        return self.longitude

    def setLongitude(self, newLongitude):
        self.longitude = newLongitude

    def getName(self):
        return self.name

    def setName(self, newName):
        self.name = newName


# @package Kaltura
# @subpackage Client
class KalturaCsvAdditionalFieldInfo(KalturaObjectBase):
    def __init__(self,
            fieldName=NotImplemented,
            xpath=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.fieldName = fieldName

        # @var string
        self.xpath = xpath


    PROPERTY_LOADERS = {
        'fieldName': getXmlNodeText, 
        'xpath': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaCsvAdditionalFieldInfo.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaCsvAdditionalFieldInfo")
        kparams.addStringIfDefined("fieldName", self.fieldName)
        kparams.addStringIfDefined("xpath", self.xpath)
        return kparams

    def getFieldName(self):
        return self.fieldName

    def setFieldName(self, newFieldName):
        self.fieldName = newFieldName

    def getXpath(self):
        return self.xpath

    def setXpath(self, newXpath):
        self.xpath = newXpath


# @package Kaltura
# @subpackage Client
class KalturaDataEntry(KalturaBaseEntry):
    def __init__(self,
            id=NotImplemented,
            name=NotImplemented,
            description=NotImplemented,
            partnerId=NotImplemented,
            userId=NotImplemented,
            creatorId=NotImplemented,
            tags=NotImplemented,
            adminTags=NotImplemented,
            categories=NotImplemented,
            categoriesIds=NotImplemented,
            status=NotImplemented,
            moderationStatus=NotImplemented,
            moderationCount=NotImplemented,
            type=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented,
            rank=NotImplemented,
            totalRank=NotImplemented,
            votes=NotImplemented,
            groupId=NotImplemented,
            partnerData=NotImplemented,
            downloadUrl=NotImplemented,
            searchText=NotImplemented,
            licenseType=NotImplemented,
            version=NotImplemented,
            thumbnailUrl=NotImplemented,
            accessControlId=NotImplemented,
            startDate=NotImplemented,
            endDate=NotImplemented,
            referenceId=NotImplemented,
            replacingEntryId=NotImplemented,
            replacedEntryId=NotImplemented,
            replacementStatus=NotImplemented,
            partnerSortValue=NotImplemented,
            conversionProfileId=NotImplemented,
            redirectEntryId=NotImplemented,
            rootEntryId=NotImplemented,
            parentEntryId=NotImplemented,
            operationAttributes=NotImplemented,
            entitledUsersEdit=NotImplemented,
            entitledUsersPublish=NotImplemented,
            entitledUsersView=NotImplemented,
            capabilities=NotImplemented,
            templateEntryId=NotImplemented,
            displayInSearch=NotImplemented,
            application=NotImplemented,
            applicationVersion=NotImplemented,
            blockAutoTranscript=NotImplemented,
            dataContent=NotImplemented,
            retrieveDataContentByGet=NotImplemented):
        KalturaBaseEntry.__init__(self,
            id,
            name,
            description,
            partnerId,
            userId,
            creatorId,
            tags,
            adminTags,
            categories,
            categoriesIds,
            status,
            moderationStatus,
            moderationCount,
            type,
            createdAt,
            updatedAt,
            rank,
            totalRank,
            votes,
            groupId,
            partnerData,
            downloadUrl,
            searchText,
            licenseType,
            version,
            thumbnailUrl,
            accessControlId,
            startDate,
            endDate,
            referenceId,
            replacingEntryId,
            replacedEntryId,
            replacementStatus,
            partnerSortValue,
            conversionProfileId,
            redirectEntryId,
            rootEntryId,
            parentEntryId,
            operationAttributes,
            entitledUsersEdit,
            entitledUsersPublish,
            entitledUsersView,
            capabilities,
            templateEntryId,
            displayInSearch,
            application,
            applicationVersion,
            blockAutoTranscript)

        # The data of the entry
        # @var string
        self.dataContent = dataContent

        # indicator whether to return the object for get action with the dataContent field.
        # @var bool
        # @insertonly
        self.retrieveDataContentByGet = retrieveDataContentByGet


    PROPERTY_LOADERS = {
        'dataContent': getXmlNodeText, 
        'retrieveDataContentByGet': getXmlNodeBool, 
    }

    def fromXml(self, node):
        KalturaBaseEntry.fromXml(self, node)
        self.fromXmlImpl(node, KalturaDataEntry.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaBaseEntry.toParams(self)
        kparams.put("objectType", "KalturaDataEntry")
        kparams.addStringIfDefined("dataContent", self.dataContent)
        kparams.addBoolIfDefined("retrieveDataContentByGet", self.retrieveDataContentByGet)
        return kparams

    def getDataContent(self):
        return self.dataContent

    def setDataContent(self, newDataContent):
        self.dataContent = newDataContent

    def getRetrieveDataContentByGet(self):
        return self.retrieveDataContentByGet

    def setRetrieveDataContentByGet(self, newRetrieveDataContentByGet):
        self.retrieveDataContentByGet = newRetrieveDataContentByGet


# @package Kaltura
# @subpackage Client
class KalturaUrlRecognizer(KalturaObjectBase):
    def __init__(self,
            hosts=NotImplemented,
            uriPrefix=NotImplemented):
        KalturaObjectBase.__init__(self)

        # The hosts that are recognized
        # @var string
        self.hosts = hosts

        # The URI prefix we use for security
        # @var string
        self.uriPrefix = uriPrefix


    PROPERTY_LOADERS = {
        'hosts': getXmlNodeText, 
        'uriPrefix': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaUrlRecognizer.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaUrlRecognizer")
        kparams.addStringIfDefined("hosts", self.hosts)
        kparams.addStringIfDefined("uriPrefix", self.uriPrefix)
        return kparams

    def getHosts(self):
        return self.hosts

    def setHosts(self, newHosts):
        self.hosts = newHosts

    def getUriPrefix(self):
        return self.uriPrefix

    def setUriPrefix(self, newUriPrefix):
        self.uriPrefix = newUriPrefix


# @package Kaltura
# @subpackage Client
class KalturaUrlTokenizer(KalturaObjectBase):
    def __init__(self,
            window=NotImplemented,
            key=NotImplemented,
            limitIpAddress=NotImplemented):
        KalturaObjectBase.__init__(self)

        # Window
        # @var int
        self.window = window

        # key
        # @var string
        self.key = key

        # @var bool
        self.limitIpAddress = limitIpAddress


    PROPERTY_LOADERS = {
        'window': getXmlNodeInt, 
        'key': getXmlNodeText, 
        'limitIpAddress': getXmlNodeBool, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaUrlTokenizer.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaUrlTokenizer")
        kparams.addIntIfDefined("window", self.window)
        kparams.addStringIfDefined("key", self.key)
        kparams.addBoolIfDefined("limitIpAddress", self.limitIpAddress)
        return kparams

    def getWindow(self):
        return self.window

    def setWindow(self, newWindow):
        self.window = newWindow

    def getKey(self):
        return self.key

    def setKey(self, newKey):
        self.key = newKey

    def getLimitIpAddress(self):
        return self.limitIpAddress

    def setLimitIpAddress(self, newLimitIpAddress):
        self.limitIpAddress = newLimitIpAddress


# @package Kaltura
# @subpackage Client
class KalturaSearchItem(KalturaObjectBase):
    def __init__(self):
        KalturaObjectBase.__init__(self)


    PROPERTY_LOADERS = {
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaSearchItem.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaSearchItem")
        return kparams


# @package Kaltura
# @subpackage Client
class KalturaFilter(KalturaObjectBase):
    def __init__(self,
            orderBy=NotImplemented,
            advancedSearch=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.orderBy = orderBy

        # @var KalturaSearchItem
        self.advancedSearch = advancedSearch


    PROPERTY_LOADERS = {
        'orderBy': getXmlNodeText, 
        'advancedSearch': (KalturaObjectFactory.create, 'KalturaSearchItem'), 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaFilter.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaFilter")
        kparams.addStringIfDefined("orderBy", self.orderBy)
        kparams.addObjectIfDefined("advancedSearch", self.advancedSearch)
        return kparams

    def getOrderBy(self):
        return self.orderBy

    def setOrderBy(self, newOrderBy):
        self.orderBy = newOrderBy

    def getAdvancedSearch(self):
        return self.advancedSearch

    def setAdvancedSearch(self, newAdvancedSearch):
        self.advancedSearch = newAdvancedSearch


# @package Kaltura
# @subpackage Client
class KalturaRelatedFilter(KalturaFilter):
    def __init__(self,
            orderBy=NotImplemented,
            advancedSearch=NotImplemented):
        KalturaFilter.__init__(self,
            orderBy,
            advancedSearch)


    PROPERTY_LOADERS = {
    }

    def fromXml(self, node):
        KalturaFilter.fromXml(self, node)
        self.fromXmlImpl(node, KalturaRelatedFilter.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaFilter.toParams(self)
        kparams.put("objectType", "KalturaRelatedFilter")
        return kparams


# @package Kaltura
# @subpackage Client
class KalturaAssetBaseFilter(KalturaRelatedFilter):
    def __init__(self,
            orderBy=NotImplemented,
            advancedSearch=NotImplemented,
            idEqual=NotImplemented,
            idIn=NotImplemented,
            entryIdEqual=NotImplemented,
            entryIdIn=NotImplemented,
            partnerIdEqual=NotImplemented,
            partnerIdIn=NotImplemented,
            sizeGreaterThanOrEqual=NotImplemented,
            sizeLessThanOrEqual=NotImplemented,
            tagsLike=NotImplemented,
            tagsMultiLikeOr=NotImplemented,
            tagsMultiLikeAnd=NotImplemented,
            createdAtGreaterThanOrEqual=NotImplemented,
            createdAtLessThanOrEqual=NotImplemented,
            updatedAtGreaterThanOrEqual=NotImplemented,
            updatedAtLessThanOrEqual=NotImplemented,
            deletedAtGreaterThanOrEqual=NotImplemented,
            deletedAtLessThanOrEqual=NotImplemented):
        KalturaRelatedFilter.__init__(self,
            orderBy,
            advancedSearch)

        # @var string
        self.idEqual = idEqual

        # @var string
        self.idIn = idIn

        # @var string
        self.entryIdEqual = entryIdEqual

        # @var string
        self.entryIdIn = entryIdIn

        # @var int
        self.partnerIdEqual = partnerIdEqual

        # @var string
        self.partnerIdIn = partnerIdIn

        # @var int
        self.sizeGreaterThanOrEqual = sizeGreaterThanOrEqual

        # @var int
        self.sizeLessThanOrEqual = sizeLessThanOrEqual

        # @var string
        self.tagsLike = tagsLike

        # @var string
        self.tagsMultiLikeOr = tagsMultiLikeOr

        # @var string
        self.tagsMultiLikeAnd = tagsMultiLikeAnd

        # @var int
        self.createdAtGreaterThanOrEqual = createdAtGreaterThanOrEqual

        # @var int
        self.createdAtLessThanOrEqual = createdAtLessThanOrEqual

        # @var int
        self.updatedAtGreaterThanOrEqual = updatedAtGreaterThanOrEqual

        # @var int
        self.updatedAtLessThanOrEqual = updatedAtLessThanOrEqual

        # @var int
        self.deletedAtGreaterThanOrEqual = deletedAtGreaterThanOrEqual

        # @var int
        self.deletedAtLessThanOrEqual = deletedAtLessThanOrEqual


    PROPERTY_LOADERS = {
        'idEqual': getXmlNodeText, 
        'idIn': getXmlNodeText, 
        'entryIdEqual': getXmlNodeText, 
        'entryIdIn': getXmlNodeText, 
        'partnerIdEqual': getXmlNodeInt, 
        'partnerIdIn': getXmlNodeText, 
        'sizeGreaterThanOrEqual': getXmlNodeInt, 
        'sizeLessThanOrEqual': getXmlNodeInt, 
        'tagsLike': getXmlNodeText, 
        'tagsMultiLikeOr': getXmlNodeText, 
        'tagsMultiLikeAnd': getXmlNodeText, 
        'createdAtGreaterThanOrEqual': getXmlNodeInt, 
        'createdAtLessThanOrEqual': getXmlNodeInt, 
        'updatedAtGreaterThanOrEqual': getXmlNodeInt, 
        'updatedAtLessThanOrEqual': getXmlNodeInt, 
        'deletedAtGreaterThanOrEqual': getXmlNodeInt, 
        'deletedAtLessThanOrEqual': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaRelatedFilter.fromXml(self, node)
        self.fromXmlImpl(node, KalturaAssetBaseFilter.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaRelatedFilter.toParams(self)
        kparams.put("objectType", "KalturaAssetBaseFilter")
        kparams.addStringIfDefined("idEqual", self.idEqual)
        kparams.addStringIfDefined("idIn", self.idIn)
        kparams.addStringIfDefined("entryIdEqual", self.entryIdEqual)
        kparams.addStringIfDefined("entryIdIn", self.entryIdIn)
        kparams.addIntIfDefined("partnerIdEqual", self.partnerIdEqual)
        kparams.addStringIfDefined("partnerIdIn", self.partnerIdIn)
        kparams.addIntIfDefined("sizeGreaterThanOrEqual", self.sizeGreaterThanOrEqual)
        kparams.addIntIfDefined("sizeLessThanOrEqual", self.sizeLessThanOrEqual)
        kparams.addStringIfDefined("tagsLike", self.tagsLike)
        kparams.addStringIfDefined("tagsMultiLikeOr", self.tagsMultiLikeOr)
        kparams.addStringIfDefined("tagsMultiLikeAnd", self.tagsMultiLikeAnd)
        kparams.addIntIfDefined("createdAtGreaterThanOrEqual", self.createdAtGreaterThanOrEqual)
        kparams.addIntIfDefined("createdAtLessThanOrEqual", self.createdAtLessThanOrEqual)
        kparams.addIntIfDefined("updatedAtGreaterThanOrEqual", self.updatedAtGreaterThanOrEqual)
        kparams.addIntIfDefined("updatedAtLessThanOrEqual", self.updatedAtLessThanOrEqual)
        kparams.addIntIfDefined("deletedAtGreaterThanOrEqual", self.deletedAtGreaterThanOrEqual)
        kparams.addIntIfDefined("deletedAtLessThanOrEqual", self.deletedAtLessThanOrEqual)
        return kparams

    def getIdEqual(self):
        return self.idEqual

    def setIdEqual(self, newIdEqual):
        self.idEqual = newIdEqual

    def getIdIn(self):
        return self.idIn

    def setIdIn(self, newIdIn):
        self.idIn = newIdIn

    def getEntryIdEqual(self):
        return self.entryIdEqual

    def setEntryIdEqual(self, newEntryIdEqual):
        self.entryIdEqual = newEntryIdEqual

    def getEntryIdIn(self):
        return self.entryIdIn

    def setEntryIdIn(self, newEntryIdIn):
        self.entryIdIn = newEntryIdIn

    def getPartnerIdEqual(self):
        return self.partnerIdEqual

    def setPartnerIdEqual(self, newPartnerIdEqual):
        self.partnerIdEqual = newPartnerIdEqual

    def getPartnerIdIn(self):
        return self.partnerIdIn

    def setPartnerIdIn(self, newPartnerIdIn):
        self.partnerIdIn = newPartnerIdIn

    def getSizeGreaterThanOrEqual(self):
        return self.sizeGreaterThanOrEqual

    def setSizeGreaterThanOrEqual(self, newSizeGreaterThanOrEqual):
        self.sizeGreaterThanOrEqual = newSizeGreaterThanOrEqual

    def getSizeLessThanOrEqual(self):
        return self.sizeLessThanOrEqual

    def setSizeLessThanOrEqual(self, newSizeLessThanOrEqual):
        self.sizeLessThanOrEqual = newSizeLessThanOrEqual

    def getTagsLike(self):
        return self.tagsLike

    def setTagsLike(self, newTagsLike):
        self.tagsLike = newTagsLike

    def getTagsMultiLikeOr(self):
        return self.tagsMultiLikeOr

    def setTagsMultiLikeOr(self, newTagsMultiLikeOr):
        self.tagsMultiLikeOr = newTagsMultiLikeOr

    def getTagsMultiLikeAnd(self):
        return self.tagsMultiLikeAnd

    def setTagsMultiLikeAnd(self, newTagsMultiLikeAnd):
        self.tagsMultiLikeAnd = newTagsMultiLikeAnd

    def getCreatedAtGreaterThanOrEqual(self):
        return self.createdAtGreaterThanOrEqual

    def setCreatedAtGreaterThanOrEqual(self, newCreatedAtGreaterThanOrEqual):
        self.createdAtGreaterThanOrEqual = newCreatedAtGreaterThanOrEqual

    def getCreatedAtLessThanOrEqual(self):
        return self.createdAtLessThanOrEqual

    def setCreatedAtLessThanOrEqual(self, newCreatedAtLessThanOrEqual):
        self.createdAtLessThanOrEqual = newCreatedAtLessThanOrEqual

    def getUpdatedAtGreaterThanOrEqual(self):
        return self.updatedAtGreaterThanOrEqual

    def setUpdatedAtGreaterThanOrEqual(self, newUpdatedAtGreaterThanOrEqual):
        self.updatedAtGreaterThanOrEqual = newUpdatedAtGreaterThanOrEqual

    def getUpdatedAtLessThanOrEqual(self):
        return self.updatedAtLessThanOrEqual

    def setUpdatedAtLessThanOrEqual(self, newUpdatedAtLessThanOrEqual):
        self.updatedAtLessThanOrEqual = newUpdatedAtLessThanOrEqual

    def getDeletedAtGreaterThanOrEqual(self):
        return self.deletedAtGreaterThanOrEqual

    def setDeletedAtGreaterThanOrEqual(self, newDeletedAtGreaterThanOrEqual):
        self.deletedAtGreaterThanOrEqual = newDeletedAtGreaterThanOrEqual

    def getDeletedAtLessThanOrEqual(self):
        return self.deletedAtLessThanOrEqual

    def setDeletedAtLessThanOrEqual(self, newDeletedAtLessThanOrEqual):
        self.deletedAtLessThanOrEqual = newDeletedAtLessThanOrEqual


# @package Kaltura
# @subpackage Client
class KalturaAssetFilter(KalturaAssetBaseFilter):
    def __init__(self,
            orderBy=NotImplemented,
            advancedSearch=NotImplemented,
            idEqual=NotImplemented,
            idIn=NotImplemented,
            entryIdEqual=NotImplemented,
            entryIdIn=NotImplemented,
            partnerIdEqual=NotImplemented,
            partnerIdIn=NotImplemented,
            sizeGreaterThanOrEqual=NotImplemented,
            sizeLessThanOrEqual=NotImplemented,
            tagsLike=NotImplemented,
            tagsMultiLikeOr=NotImplemented,
            tagsMultiLikeAnd=NotImplemented,
            createdAtGreaterThanOrEqual=NotImplemented,
            createdAtLessThanOrEqual=NotImplemented,
            updatedAtGreaterThanOrEqual=NotImplemented,
            updatedAtLessThanOrEqual=NotImplemented,
            deletedAtGreaterThanOrEqual=NotImplemented,
            deletedAtLessThanOrEqual=NotImplemented,
            typeIn=NotImplemented):
        KalturaAssetBaseFilter.__init__(self,
            orderBy,
            advancedSearch,
            idEqual,
            idIn,
            entryIdEqual,
            entryIdIn,
            partnerIdEqual,
            partnerIdIn,
            sizeGreaterThanOrEqual,
            sizeLessThanOrEqual,
            tagsLike,
            tagsMultiLikeOr,
            tagsMultiLikeAnd,
            createdAtGreaterThanOrEqual,
            createdAtLessThanOrEqual,
            updatedAtGreaterThanOrEqual,
            updatedAtLessThanOrEqual,
            deletedAtGreaterThanOrEqual,
            deletedAtLessThanOrEqual)

        # @var string
        self.typeIn = typeIn


    PROPERTY_LOADERS = {
        'typeIn': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaAssetBaseFilter.fromXml(self, node)
        self.fromXmlImpl(node, KalturaAssetFilter.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaAssetBaseFilter.toParams(self)
        kparams.put("objectType", "KalturaAssetFilter")
        kparams.addStringIfDefined("typeIn", self.typeIn)
        return kparams

    def getTypeIn(self):
        return self.typeIn

    def setTypeIn(self, newTypeIn):
        self.typeIn = newTypeIn


# @package Kaltura
# @subpackage Client
class KalturaDeliveryProfile(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            partnerId=NotImplemented,
            name=NotImplemented,
            type=NotImplemented,
            systemName=NotImplemented,
            description=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented,
            streamerType=NotImplemented,
            url=NotImplemented,
            hostName=NotImplemented,
            status=NotImplemented,
            recognizer=NotImplemented,
            tokenizer=NotImplemented,
            isDefault=NotImplemented,
            parentId=NotImplemented,
            mediaProtocols=NotImplemented,
            priority=NotImplemented,
            extraParams=NotImplemented,
            supplementaryAssetsFilter=NotImplemented):
        KalturaObjectBase.__init__(self)

        # The id of the Delivery
        # @var int
        # @readonly
        self.id = id

        # @var int
        # @readonly
        self.partnerId = partnerId

        # The name of the Delivery
        # @var string
        self.name = name

        # Delivery type
        # @var KalturaDeliveryProfileType
        self.type = type

        # System name of the delivery
        # @var string
        self.systemName = systemName

        # The description of the Delivery
        # @var string
        self.description = description

        # Creation time as Unix timestamp (In seconds)
        # @var int
        # @readonly
        self.createdAt = createdAt

        # Update time as Unix timestamp (In seconds)
        # @var int
        # @readonly
        self.updatedAt = updatedAt

        # @var KalturaPlaybackProtocol
        self.streamerType = streamerType

        # @var string
        self.url = url

        # the host part of the url
        # @var string
        # @readonly
        self.hostName = hostName

        # @var KalturaDeliveryStatus
        self.status = status

        # @var KalturaUrlRecognizer
        self.recognizer = recognizer

        # @var KalturaUrlTokenizer
        self.tokenizer = tokenizer

        # True if this is the systemwide default for the protocol
        # @var KalturaNullableBoolean
        # @readonly
        self.isDefault = isDefault

        # the object from which this object was cloned (or 0)
        # @var int
        # @readonly
        self.parentId = parentId

        # Comma separated list of supported media protocols. f.i. rtmpe
        # @var string
        self.mediaProtocols = mediaProtocols

        # priority used for ordering similar delivery profiles
        # @var int
        self.priority = priority

        # Extra query string parameters that should be added to the url
        # @var string
        self.extraParams = extraParams

        # A filter that can be used to include additional assets in the URL (e.g. captions)
        # @var KalturaAssetFilter
        self.supplementaryAssetsFilter = supplementaryAssetsFilter


    PROPERTY_LOADERS = {
        'id': getXmlNodeInt, 
        'partnerId': getXmlNodeInt, 
        'name': getXmlNodeText, 
        'type': (KalturaEnumsFactory.createString, "KalturaDeliveryProfileType"), 
        'systemName': getXmlNodeText, 
        'description': getXmlNodeText, 
        'createdAt': getXmlNodeInt, 
        'updatedAt': getXmlNodeInt, 
        'streamerType': (KalturaEnumsFactory.createString, "KalturaPlaybackProtocol"), 
        'url': getXmlNodeText, 
        'hostName': getXmlNodeText, 
        'status': (KalturaEnumsFactory.createInt, "KalturaDeliveryStatus"), 
        'recognizer': (KalturaObjectFactory.create, 'KalturaUrlRecognizer'), 
        'tokenizer': (KalturaObjectFactory.create, 'KalturaUrlTokenizer'), 
        'isDefault': (KalturaEnumsFactory.createInt, "KalturaNullableBoolean"), 
        'parentId': getXmlNodeInt, 
        'mediaProtocols': getXmlNodeText, 
        'priority': getXmlNodeInt, 
        'extraParams': getXmlNodeText, 
        'supplementaryAssetsFilter': (KalturaObjectFactory.create, 'KalturaAssetFilter'), 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaDeliveryProfile.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaDeliveryProfile")
        kparams.addStringIfDefined("name", self.name)
        kparams.addStringEnumIfDefined("type", self.type)
        kparams.addStringIfDefined("systemName", self.systemName)
        kparams.addStringIfDefined("description", self.description)
        kparams.addStringEnumIfDefined("streamerType", self.streamerType)
        kparams.addStringIfDefined("url", self.url)
        kparams.addIntEnumIfDefined("status", self.status)
        kparams.addObjectIfDefined("recognizer", self.recognizer)
        kparams.addObjectIfDefined("tokenizer", self.tokenizer)
        kparams.addStringIfDefined("mediaProtocols", self.mediaProtocols)
        kparams.addIntIfDefined("priority", self.priority)
        kparams.addStringIfDefined("extraParams", self.extraParams)
        kparams.addObjectIfDefined("supplementaryAssetsFilter", self.supplementaryAssetsFilter)
        return kparams

    def getId(self):
        return self.id

    def getPartnerId(self):
        return self.partnerId

    def getName(self):
        return self.name

    def setName(self, newName):
        self.name = newName

    def getType(self):
        return self.type

    def setType(self, newType):
        self.type = newType

    def getSystemName(self):
        return self.systemName

    def setSystemName(self, newSystemName):
        self.systemName = newSystemName

    def getDescription(self):
        return self.description

    def setDescription(self, newDescription):
        self.description = newDescription

    def getCreatedAt(self):
        return self.createdAt

    def getUpdatedAt(self):
        return self.updatedAt

    def getStreamerType(self):
        return self.streamerType

    def setStreamerType(self, newStreamerType):
        self.streamerType = newStreamerType

    def getUrl(self):
        return self.url

    def setUrl(self, newUrl):
        self.url = newUrl

    def getHostName(self):
        return self.hostName

    def getStatus(self):
        return self.status

    def setStatus(self, newStatus):
        self.status = newStatus

    def getRecognizer(self):
        return self.recognizer

    def setRecognizer(self, newRecognizer):
        self.recognizer = newRecognizer

    def getTokenizer(self):
        return self.tokenizer

    def setTokenizer(self, newTokenizer):
        self.tokenizer = newTokenizer

    def getIsDefault(self):
        return self.isDefault

    def getParentId(self):
        return self.parentId

    def getMediaProtocols(self):
        return self.mediaProtocols

    def setMediaProtocols(self, newMediaProtocols):
        self.mediaProtocols = newMediaProtocols

    def getPriority(self):
        return self.priority

    def setPriority(self, newPriority):
        self.priority = newPriority

    def getExtraParams(self):
        return self.extraParams

    def setExtraParams(self, newExtraParams):
        self.extraParams = newExtraParams

    def getSupplementaryAssetsFilter(self):
        return self.supplementaryAssetsFilter

    def setSupplementaryAssetsFilter(self, newSupplementaryAssetsFilter):
        self.supplementaryAssetsFilter = newSupplementaryAssetsFilter


# @package Kaltura
# @subpackage Client
class KalturaFileSyncDescriptor(KalturaObjectBase):
    def __init__(self,
            fileSyncLocalPath=NotImplemented,
            fileEncryptionKey=NotImplemented,
            fileSyncRemoteUrl=NotImplemented,
            fileSyncObjectSubType=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.fileSyncLocalPath = fileSyncLocalPath

        # @var string
        self.fileEncryptionKey = fileEncryptionKey

        # The translated path as used by the scheduler
        # @var string
        self.fileSyncRemoteUrl = fileSyncRemoteUrl

        # @var int
        self.fileSyncObjectSubType = fileSyncObjectSubType


    PROPERTY_LOADERS = {
        'fileSyncLocalPath': getXmlNodeText, 
        'fileEncryptionKey': getXmlNodeText, 
        'fileSyncRemoteUrl': getXmlNodeText, 
        'fileSyncObjectSubType': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaFileSyncDescriptor.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaFileSyncDescriptor")
        kparams.addStringIfDefined("fileSyncLocalPath", self.fileSyncLocalPath)
        kparams.addStringIfDefined("fileEncryptionKey", self.fileEncryptionKey)
        kparams.addStringIfDefined("fileSyncRemoteUrl", self.fileSyncRemoteUrl)
        kparams.addIntIfDefined("fileSyncObjectSubType", self.fileSyncObjectSubType)
        return kparams

    def getFileSyncLocalPath(self):
        return self.fileSyncLocalPath

    def setFileSyncLocalPath(self, newFileSyncLocalPath):
        self.fileSyncLocalPath = newFileSyncLocalPath

    def getFileEncryptionKey(self):
        return self.fileEncryptionKey

    def setFileEncryptionKey(self, newFileEncryptionKey):
        self.fileEncryptionKey = newFileEncryptionKey

    def getFileSyncRemoteUrl(self):
        return self.fileSyncRemoteUrl

    def setFileSyncRemoteUrl(self, newFileSyncRemoteUrl):
        self.fileSyncRemoteUrl = newFileSyncRemoteUrl

    def getFileSyncObjectSubType(self):
        return self.fileSyncObjectSubType

    def setFileSyncObjectSubType(self, newFileSyncObjectSubType):
        self.fileSyncObjectSubType = newFileSyncObjectSubType


# @package Kaltura
# @subpackage Client
class KalturaDestFileSyncDescriptor(KalturaFileSyncDescriptor):
    def __init__(self,
            fileSyncLocalPath=NotImplemented,
            fileEncryptionKey=NotImplemented,
            fileSyncRemoteUrl=NotImplemented,
            fileSyncObjectSubType=NotImplemented):
        KalturaFileSyncDescriptor.__init__(self,
            fileSyncLocalPath,
            fileEncryptionKey,
            fileSyncRemoteUrl,
            fileSyncObjectSubType)


    PROPERTY_LOADERS = {
    }

    def fromXml(self, node):
        KalturaFileSyncDescriptor.fromXml(self, node)
        self.fromXmlImpl(node, KalturaDestFileSyncDescriptor.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaFileSyncDescriptor.toParams(self)
        kparams.put("objectType", "KalturaDestFileSyncDescriptor")
        return kparams


# @package Kaltura
# @subpackage Client
class KalturaPager(KalturaObjectBase):
    """The KalturaPager object enables paging management to be applied upon service list/search actions."""

    def __init__(self,
            pageSize=NotImplemented,
            pageIndex=NotImplemented):
        KalturaObjectBase.__init__(self)

        # The number of objects to retrieve. (Default is 30, maximum page size is 500).
        # @var int
        self.pageSize = pageSize

        # The page number for which {pageSize} of objects should be retrieved (Default is 1).
        # @var int
        self.pageIndex = pageIndex


    PROPERTY_LOADERS = {
        'pageSize': getXmlNodeInt, 
        'pageIndex': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaPager.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaPager")
        kparams.addIntIfDefined("pageSize", self.pageSize)
        kparams.addIntIfDefined("pageIndex", self.pageIndex)
        return kparams

    def getPageSize(self):
        return self.pageSize

    def setPageSize(self, newPageSize):
        self.pageSize = newPageSize

    def getPageIndex(self):
        return self.pageIndex

    def setPageIndex(self, newPageIndex):
        self.pageIndex = newPageIndex


# @package Kaltura
# @subpackage Client
class KalturaFilterPager(KalturaPager):
    """The KalturaFilterPager object enables paging management to be applied upon service list actions."""

    def __init__(self,
            pageSize=NotImplemented,
            pageIndex=NotImplemented):
        KalturaPager.__init__(self,
            pageSize,
            pageIndex)


    PROPERTY_LOADERS = {
    }

    def fromXml(self, node):
        KalturaPager.fromXml(self, node)
        self.fromXmlImpl(node, KalturaFilterPager.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaPager.toParams(self)
        kparams.put("objectType", "KalturaFilterPager")
        return kparams


# @package Kaltura
# @subpackage Client
class KalturaResponseProfileMapping(KalturaObjectBase):
    def __init__(self,
            parentProperty=NotImplemented,
            filterProperty=NotImplemented,
            allowNull=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.parentProperty = parentProperty

        # @var string
        self.filterProperty = filterProperty

        # @var bool
        self.allowNull = allowNull


    PROPERTY_LOADERS = {
        'parentProperty': getXmlNodeText, 
        'filterProperty': getXmlNodeText, 
        'allowNull': getXmlNodeBool, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaResponseProfileMapping.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaResponseProfileMapping")
        kparams.addStringIfDefined("parentProperty", self.parentProperty)
        kparams.addStringIfDefined("filterProperty", self.filterProperty)
        kparams.addBoolIfDefined("allowNull", self.allowNull)
        return kparams

    def getParentProperty(self):
        return self.parentProperty

    def setParentProperty(self, newParentProperty):
        self.parentProperty = newParentProperty

    def getFilterProperty(self):
        return self.filterProperty

    def setFilterProperty(self, newFilterProperty):
        self.filterProperty = newFilterProperty

    def getAllowNull(self):
        return self.allowNull

    def setAllowNull(self, newAllowNull):
        self.allowNull = newAllowNull


# @package Kaltura
# @subpackage Client
class KalturaDetachedResponseProfile(KalturaBaseResponseProfile):
    def __init__(self,
            name=NotImplemented,
            type=NotImplemented,
            fields=NotImplemented,
            filter=NotImplemented,
            pager=NotImplemented,
            relatedProfiles=NotImplemented,
            mappings=NotImplemented):
        KalturaBaseResponseProfile.__init__(self)

        # Friendly name
        # @var string
        self.name = name

        # @var KalturaResponseProfileType
        self.type = type

        # Comma separated fields list to be included or excluded
        # @var string
        self.fields = fields

        # @var KalturaRelatedFilter
        self.filter = filter

        # @var KalturaFilterPager
        self.pager = pager

        # @var array of KalturaDetachedResponseProfile
        self.relatedProfiles = relatedProfiles

        # @var array of KalturaResponseProfileMapping
        self.mappings = mappings


    PROPERTY_LOADERS = {
        'name': getXmlNodeText, 
        'type': (KalturaEnumsFactory.createInt, "KalturaResponseProfileType"), 
        'fields': getXmlNodeText, 
        'filter': (KalturaObjectFactory.create, 'KalturaRelatedFilter'), 
        'pager': (KalturaObjectFactory.create, 'KalturaFilterPager'), 
        'relatedProfiles': (KalturaObjectFactory.createArray, 'KalturaObjectBase'), 
        'mappings': (KalturaObjectFactory.createArray, 'KalturaResponseProfileMapping'), 
    }

    def fromXml(self, node):
        KalturaBaseResponseProfile.fromXml(self, node)
        self.fromXmlImpl(node, KalturaDetachedResponseProfile.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaBaseResponseProfile.toParams(self)
        kparams.put("objectType", "KalturaDetachedResponseProfile")
        kparams.addStringIfDefined("name", self.name)
        kparams.addIntEnumIfDefined("type", self.type)
        kparams.addStringIfDefined("fields", self.fields)
        kparams.addObjectIfDefined("filter", self.filter)
        kparams.addObjectIfDefined("pager", self.pager)
        kparams.addArrayIfDefined("relatedProfiles", self.relatedProfiles)
        kparams.addArrayIfDefined("mappings", self.mappings)
        return kparams

    def getName(self):
        return self.name

    def setName(self, newName):
        self.name = newName

    def getType(self):
        return self.type

    def setType(self, newType):
        self.type = newType

    def getFields(self):
        return self.fields

    def setFields(self, newFields):
        self.fields = newFields

    def getFilter(self):
        return self.filter

    def setFilter(self, newFilter):
        self.filter = newFilter

    def getPager(self):
        return self.pager

    def setPager(self, newPager):
        self.pager = newPager

    def getRelatedProfiles(self):
        return self.relatedProfiles

    def setRelatedProfiles(self, newRelatedProfiles):
        self.relatedProfiles = newRelatedProfiles

    def getMappings(self):
        return self.mappings

    def setMappings(self, newMappings):
        self.mappings = newMappings


# @package Kaltura
# @subpackage Client
class KalturaPluginData(KalturaObjectBase):
    def __init__(self):
        KalturaObjectBase.__init__(self)


    PROPERTY_LOADERS = {
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaPluginData.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaPluginData")
        return kparams


# @package Kaltura
# @subpackage Client
class KalturaDrmPlaybackPluginData(KalturaPluginData):
    def __init__(self,
            scheme=NotImplemented,
            licenseURL=NotImplemented):
        KalturaPluginData.__init__(self)

        # @var KalturaDrmSchemeName
        self.scheme = scheme

        # @var string
        self.licenseURL = licenseURL


    PROPERTY_LOADERS = {
        'scheme': (KalturaEnumsFactory.createString, "KalturaDrmSchemeName"), 
        'licenseURL': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaPluginData.fromXml(self, node)
        self.fromXmlImpl(node, KalturaDrmPlaybackPluginData.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaPluginData.toParams(self)
        kparams.put("objectType", "KalturaDrmPlaybackPluginData")
        kparams.addStringEnumIfDefined("scheme", self.scheme)
        kparams.addStringIfDefined("licenseURL", self.licenseURL)
        return kparams

    def getScheme(self):
        return self.scheme

    def setScheme(self, newScheme):
        self.scheme = newScheme

    def getLicenseURL(self):
        return self.licenseURL

    def setLicenseURL(self, newLicenseURL):
        self.licenseURL = newLicenseURL


# @package Kaltura
# @subpackage Client
class KalturaDynamicEmailContents(KalturaObjectBase):
    def __init__(self,
            emailSubject=NotImplemented,
            emailBody=NotImplemented):
        KalturaObjectBase.__init__(self)

        # The subject of the customized email
        # @var string
        self.emailSubject = emailSubject

        # The body of the customized email
        # @var string
        self.emailBody = emailBody


    PROPERTY_LOADERS = {
        'emailSubject': getXmlNodeText, 
        'emailBody': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaDynamicEmailContents.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaDynamicEmailContents")
        kparams.addStringIfDefined("emailSubject", self.emailSubject)
        kparams.addStringIfDefined("emailBody", self.emailBody)
        return kparams

    def getEmailSubject(self):
        return self.emailSubject

    def setEmailSubject(self, newEmailSubject):
        self.emailSubject = newEmailSubject

    def getEmailBody(self):
        return self.emailBody

    def setEmailBody(self, newEmailBody):
        self.emailBody = newEmailBody


# @package Kaltura
# @subpackage Client
class KalturaUser(KalturaBaseUser):
    def __init__(self,
            id=NotImplemented,
            partnerId=NotImplemented,
            screenName=NotImplemented,
            fullName=NotImplemented,
            email=NotImplemented,
            country=NotImplemented,
            state=NotImplemented,
            city=NotImplemented,
            zip=NotImplemented,
            thumbnailUrl=NotImplemented,
            description=NotImplemented,
            tags=NotImplemented,
            adminTags=NotImplemented,
            status=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented,
            partnerData=NotImplemented,
            indexedPartnerDataInt=NotImplemented,
            indexedPartnerDataString=NotImplemented,
            storageSize=NotImplemented,
            language=NotImplemented,
            lastLoginTime=NotImplemented,
            statusUpdatedAt=NotImplemented,
            deletedAt=NotImplemented,
            allowedPartnerIds=NotImplemented,
            allowedPartnerPackages=NotImplemented,
            userMode=NotImplemented,
            type=NotImplemented,
            dateOfBirth=NotImplemented,
            gender=NotImplemented,
            isAdmin=NotImplemented,
            roleIds=NotImplemented,
            roleNames=NotImplemented,
            isAccountOwner=NotImplemented,
            password=NotImplemented,
            firstName=NotImplemented,
            lastName=NotImplemented,
            loginEnabled=NotImplemented,
            registrationInfo=NotImplemented,
            attendanceInfo=NotImplemented,
            title=NotImplemented,
            company=NotImplemented,
            ksPrivileges=NotImplemented,
            encryptedSeed=NotImplemented,
            isSsoExcluded=NotImplemented):
        KalturaBaseUser.__init__(self,
            id,
            partnerId,
            screenName,
            fullName,
            email,
            country,
            state,
            city,
            zip,
            thumbnailUrl,
            description,
            tags,
            adminTags,
            status,
            createdAt,
            updatedAt,
            partnerData,
            indexedPartnerDataInt,
            indexedPartnerDataString,
            storageSize,
            language,
            lastLoginTime,
            statusUpdatedAt,
            deletedAt,
            allowedPartnerIds,
            allowedPartnerPackages,
            userMode)

        # @var KalturaUserType
        self.type = type

        # @var int
        self.dateOfBirth = dateOfBirth

        # @var KalturaGender
        self.gender = gender

        # @var bool
        self.isAdmin = isAdmin

        # @var string
        self.roleIds = roleIds

        # @var string
        # @readonly
        self.roleNames = roleNames

        # @var bool
        # @insertonly
        self.isAccountOwner = isAccountOwner

        # @var string
        # @insertonly
        self.password = password

        # @var string
        self.firstName = firstName

        # @var string
        self.lastName = lastName

        # @var bool
        # @insertonly
        self.loginEnabled = loginEnabled

        # @var string
        self.registrationInfo = registrationInfo

        # @var string
        self.attendanceInfo = attendanceInfo

        # @var string
        self.title = title

        # @var string
        self.company = company

        # @var string
        self.ksPrivileges = ksPrivileges

        # @var string
        # @readonly
        self.encryptedSeed = encryptedSeed

        # @var bool
        self.isSsoExcluded = isSsoExcluded


    PROPERTY_LOADERS = {
        'type': (KalturaEnumsFactory.createInt, "KalturaUserType"), 
        'dateOfBirth': getXmlNodeInt, 
        'gender': (KalturaEnumsFactory.createInt, "KalturaGender"), 
        'isAdmin': getXmlNodeBool, 
        'roleIds': getXmlNodeText, 
        'roleNames': getXmlNodeText, 
        'isAccountOwner': getXmlNodeBool, 
        'password': getXmlNodeText, 
        'firstName': getXmlNodeText, 
        'lastName': getXmlNodeText, 
        'loginEnabled': getXmlNodeBool, 
        'registrationInfo': getXmlNodeText, 
        'attendanceInfo': getXmlNodeText, 
        'title': getXmlNodeText, 
        'company': getXmlNodeText, 
        'ksPrivileges': getXmlNodeText, 
        'encryptedSeed': getXmlNodeText, 
        'isSsoExcluded': getXmlNodeBool, 
    }

    def fromXml(self, node):
        KalturaBaseUser.fromXml(self, node)
        self.fromXmlImpl(node, KalturaUser.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaBaseUser.toParams(self)
        kparams.put("objectType", "KalturaUser")
        kparams.addIntEnumIfDefined("type", self.type)
        kparams.addIntIfDefined("dateOfBirth", self.dateOfBirth)
        kparams.addIntEnumIfDefined("gender", self.gender)
        kparams.addBoolIfDefined("isAdmin", self.isAdmin)
        kparams.addStringIfDefined("roleIds", self.roleIds)
        kparams.addBoolIfDefined("isAccountOwner", self.isAccountOwner)
        kparams.addStringIfDefined("password", self.password)
        kparams.addStringIfDefined("firstName", self.firstName)
        kparams.addStringIfDefined("lastName", self.lastName)
        kparams.addBoolIfDefined("loginEnabled", self.loginEnabled)
        kparams.addStringIfDefined("registrationInfo", self.registrationInfo)
        kparams.addStringIfDefined("attendanceInfo", self.attendanceInfo)
        kparams.addStringIfDefined("title", self.title)
        kparams.addStringIfDefined("company", self.company)
        kparams.addStringIfDefined("ksPrivileges", self.ksPrivileges)
        kparams.addBoolIfDefined("isSsoExcluded", self.isSsoExcluded)
        return kparams

    def getType(self):
        return self.type

    def setType(self, newType):
        self.type = newType

    def getDateOfBirth(self):
        return self.dateOfBirth

    def setDateOfBirth(self, newDateOfBirth):
        self.dateOfBirth = newDateOfBirth

    def getGender(self):
        return self.gender

    def setGender(self, newGender):
        self.gender = newGender

    def getIsAdmin(self):
        return self.isAdmin

    def setIsAdmin(self, newIsAdmin):
        self.isAdmin = newIsAdmin

    def getRoleIds(self):
        return self.roleIds

    def setRoleIds(self, newRoleIds):
        self.roleIds = newRoleIds

    def getRoleNames(self):
        return self.roleNames

    def getIsAccountOwner(self):
        return self.isAccountOwner

    def setIsAccountOwner(self, newIsAccountOwner):
        self.isAccountOwner = newIsAccountOwner

    def getPassword(self):
        return self.password

    def setPassword(self, newPassword):
        self.password = newPassword

    def getFirstName(self):
        return self.firstName

    def setFirstName(self, newFirstName):
        self.firstName = newFirstName

    def getLastName(self):
        return self.lastName

    def setLastName(self, newLastName):
        self.lastName = newLastName

    def getLoginEnabled(self):
        return self.loginEnabled

    def setLoginEnabled(self, newLoginEnabled):
        self.loginEnabled = newLoginEnabled

    def getRegistrationInfo(self):
        return self.registrationInfo

    def setRegistrationInfo(self, newRegistrationInfo):
        self.registrationInfo = newRegistrationInfo

    def getAttendanceInfo(self):
        return self.attendanceInfo

    def setAttendanceInfo(self, newAttendanceInfo):
        self.attendanceInfo = newAttendanceInfo

    def getTitle(self):
        return self.title

    def setTitle(self, newTitle):
        self.title = newTitle

    def getCompany(self):
        return self.company

    def setCompany(self, newCompany):
        self.company = newCompany

    def getKsPrivileges(self):
        return self.ksPrivileges

    def setKsPrivileges(self, newKsPrivileges):
        self.ksPrivileges = newKsPrivileges

    def getEncryptedSeed(self):
        return self.encryptedSeed

    def getIsSsoExcluded(self):
        return self.isSsoExcluded

    def setIsSsoExcluded(self, newIsSsoExcluded):
        self.isSsoExcluded = newIsSsoExcluded


# @package Kaltura
# @subpackage Client
class KalturaEffect(KalturaObjectBase):
    """Effects attributes"""

    def __init__(self,
            effectType=NotImplemented,
            value=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var KalturaEffectType
        self.effectType = effectType

        # value
        # @var string
        self.value = value


    PROPERTY_LOADERS = {
        'effectType': (KalturaEnumsFactory.createInt, "KalturaEffectType"), 
        'value': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaEffect.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaEffect")
        kparams.addIntEnumIfDefined("effectType", self.effectType)
        kparams.addStringIfDefined("value", self.value)
        return kparams

    def getEffectType(self):
        return self.effectType

    def setEffectType(self, newEffectType):
        self.effectType = newEffectType

    def getValue(self):
        return self.value

    def setValue(self, newValue):
        self.value = newValue


# @package Kaltura
# @subpackage Client
class KalturaEmailIngestionProfile(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            name=NotImplemented,
            description=NotImplemented,
            emailAddress=NotImplemented,
            mailboxId=NotImplemented,
            partnerId=NotImplemented,
            conversionProfile2Id=NotImplemented,
            moderationStatus=NotImplemented,
            status=NotImplemented,
            createdAt=NotImplemented,
            defaultCategory=NotImplemented,
            defaultUserId=NotImplemented,
            defaultTags=NotImplemented,
            defaultAdminTags=NotImplemented,
            maxAttachmentSizeKbytes=NotImplemented,
            maxAttachmentsPerMail=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var int
        # @readonly
        self.id = id

        # @var string
        self.name = name

        # @var string
        self.description = description

        # @var string
        self.emailAddress = emailAddress

        # @var string
        self.mailboxId = mailboxId

        # @var int
        # @readonly
        self.partnerId = partnerId

        # @var int
        self.conversionProfile2Id = conversionProfile2Id

        # @var KalturaEntryModerationStatus
        self.moderationStatus = moderationStatus

        # @var KalturaEmailIngestionProfileStatus
        # @readonly
        self.status = status

        # @var string
        # @readonly
        self.createdAt = createdAt

        # @var string
        self.defaultCategory = defaultCategory

        # @var string
        self.defaultUserId = defaultUserId

        # @var string
        self.defaultTags = defaultTags

        # @var string
        self.defaultAdminTags = defaultAdminTags

        # @var int
        self.maxAttachmentSizeKbytes = maxAttachmentSizeKbytes

        # @var int
        self.maxAttachmentsPerMail = maxAttachmentsPerMail


    PROPERTY_LOADERS = {
        'id': getXmlNodeInt, 
        'name': getXmlNodeText, 
        'description': getXmlNodeText, 
        'emailAddress': getXmlNodeText, 
        'mailboxId': getXmlNodeText, 
        'partnerId': getXmlNodeInt, 
        'conversionProfile2Id': getXmlNodeInt, 
        'moderationStatus': (KalturaEnumsFactory.createInt, "KalturaEntryModerationStatus"), 
        'status': (KalturaEnumsFactory.createInt, "KalturaEmailIngestionProfileStatus"), 
        'createdAt': getXmlNodeText, 
        'defaultCategory': getXmlNodeText, 
        'defaultUserId': getXmlNodeText, 
        'defaultTags': getXmlNodeText, 
        'defaultAdminTags': getXmlNodeText, 
        'maxAttachmentSizeKbytes': getXmlNodeInt, 
        'maxAttachmentsPerMail': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaEmailIngestionProfile.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaEmailIngestionProfile")
        kparams.addStringIfDefined("name", self.name)
        kparams.addStringIfDefined("description", self.description)
        kparams.addStringIfDefined("emailAddress", self.emailAddress)
        kparams.addStringIfDefined("mailboxId", self.mailboxId)
        kparams.addIntIfDefined("conversionProfile2Id", self.conversionProfile2Id)
        kparams.addIntEnumIfDefined("moderationStatus", self.moderationStatus)
        kparams.addStringIfDefined("defaultCategory", self.defaultCategory)
        kparams.addStringIfDefined("defaultUserId", self.defaultUserId)
        kparams.addStringIfDefined("defaultTags", self.defaultTags)
        kparams.addStringIfDefined("defaultAdminTags", self.defaultAdminTags)
        kparams.addIntIfDefined("maxAttachmentSizeKbytes", self.maxAttachmentSizeKbytes)
        kparams.addIntIfDefined("maxAttachmentsPerMail", self.maxAttachmentsPerMail)
        return kparams

    def getId(self):
        return self.id

    def getName(self):
        return self.name

    def setName(self, newName):
        self.name = newName

    def getDescription(self):
        return self.description

    def setDescription(self, newDescription):
        self.description = newDescription

    def getEmailAddress(self):
        return self.emailAddress

    def setEmailAddress(self, newEmailAddress):
        self.emailAddress = newEmailAddress

    def getMailboxId(self):
        return self.mailboxId

    def setMailboxId(self, newMailboxId):
        self.mailboxId = newMailboxId

    def getPartnerId(self):
        return self.partnerId

    def getConversionProfile2Id(self):
        return self.conversionProfile2Id

    def setConversionProfile2Id(self, newConversionProfile2Id):
        self.conversionProfile2Id = newConversionProfile2Id

    def getModerationStatus(self):
        return self.moderationStatus

    def setModerationStatus(self, newModerationStatus):
        self.moderationStatus = newModerationStatus

    def getStatus(self):
        return self.status

    def getCreatedAt(self):
        return self.createdAt

    def getDefaultCategory(self):
        return self.defaultCategory

    def setDefaultCategory(self, newDefaultCategory):
        self.defaultCategory = newDefaultCategory

    def getDefaultUserId(self):
        return self.defaultUserId

    def setDefaultUserId(self, newDefaultUserId):
        self.defaultUserId = newDefaultUserId

    def getDefaultTags(self):
        return self.defaultTags

    def setDefaultTags(self, newDefaultTags):
        self.defaultTags = newDefaultTags

    def getDefaultAdminTags(self):
        return self.defaultAdminTags

    def setDefaultAdminTags(self, newDefaultAdminTags):
        self.defaultAdminTags = newDefaultAdminTags

    def getMaxAttachmentSizeKbytes(self):
        return self.maxAttachmentSizeKbytes

    def setMaxAttachmentSizeKbytes(self, newMaxAttachmentSizeKbytes):
        self.maxAttachmentSizeKbytes = newMaxAttachmentSizeKbytes

    def getMaxAttachmentsPerMail(self):
        return self.maxAttachmentsPerMail

    def setMaxAttachmentsPerMail(self, newMaxAttachmentsPerMail):
        self.maxAttachmentsPerMail = newMaxAttachmentsPerMail


# @package Kaltura
# @subpackage Client
class KalturaStringValue(KalturaValue):
    """A string representation to return an array of strings"""

    def __init__(self,
            description=NotImplemented,
            value=NotImplemented):
        KalturaValue.__init__(self,
            description)

        # @var string
        self.value = value


    PROPERTY_LOADERS = {
        'value': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaValue.fromXml(self, node)
        self.fromXmlImpl(node, KalturaStringValue.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaValue.toParams(self)
        kparams.put("objectType", "KalturaStringValue")
        kparams.addStringIfDefined("value", self.value)
        return kparams

    def getValue(self):
        return self.value

    def setValue(self, newValue):
        self.value = newValue


# @package Kaltura
# @subpackage Client
class KalturaEntryServerNode(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            entryId=NotImplemented,
            serverNodeId=NotImplemented,
            partnerId=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented,
            status=NotImplemented,
            serverType=NotImplemented):
        KalturaObjectBase.__init__(self)

        # unique auto-generated identifier
        # @var int
        # @readonly
        self.id = id

        # @var string
        # @readonly
        self.entryId = entryId

        # @var int
        # @readonly
        self.serverNodeId = serverNodeId

        # @var int
        # @readonly
        self.partnerId = partnerId

        # @var int
        # @readonly
        self.createdAt = createdAt

        # @var int
        # @readonly
        self.updatedAt = updatedAt

        # @var KalturaEntryServerNodeStatus
        # @readonly
        self.status = status

        # @var KalturaEntryServerNodeType
        # @readonly
        self.serverType = serverType


    PROPERTY_LOADERS = {
        'id': getXmlNodeInt, 
        'entryId': getXmlNodeText, 
        'serverNodeId': getXmlNodeInt, 
        'partnerId': getXmlNodeInt, 
        'createdAt': getXmlNodeInt, 
        'updatedAt': getXmlNodeInt, 
        'status': (KalturaEnumsFactory.createInt, "KalturaEntryServerNodeStatus"), 
        'serverType': (KalturaEnumsFactory.createString, "KalturaEntryServerNodeType"), 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaEntryServerNode.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaEntryServerNode")
        return kparams

    def getId(self):
        return self.id

    def getEntryId(self):
        return self.entryId

    def getServerNodeId(self):
        return self.serverNodeId

    def getPartnerId(self):
        return self.partnerId

    def getCreatedAt(self):
        return self.createdAt

    def getUpdatedAt(self):
        return self.updatedAt

    def getStatus(self):
        return self.status

    def getServerType(self):
        return self.serverType


# @package Kaltura
# @subpackage Client
class KalturaExportToCsvOptions(KalturaObjectBase):
    def __init__(self,
            format=NotImplemented):
        KalturaObjectBase.__init__(self)

        # The format of the outputted date string. There are also several predefined date constants that may be used instead, so for example DATE_RSS contains the format string 'D, d M Y H:i:s'.
        # 	 https://www.php.net/manual/en/function.date.php
        # @var string
        self.format = format


    PROPERTY_LOADERS = {
        'format': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaExportToCsvOptions.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaExportToCsvOptions")
        kparams.addStringIfDefined("format", self.format)
        return kparams

    def getFormat(self):
        return self.format

    def setFormat(self, newFormat):
        self.format = newFormat


# @package Kaltura
# @subpackage Client
class KalturaObjectIdentifier(KalturaObjectBase):
    """Configuration for extended item in the Kaltura MRSS feeds"""

    def __init__(self,
            extendedFeatures=NotImplemented):
        KalturaObjectBase.__init__(self)

        # Comma separated string of enum values denoting which features of the item need to be included in the MRSS
        # @var string
        self.extendedFeatures = extendedFeatures


    PROPERTY_LOADERS = {
        'extendedFeatures': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaObjectIdentifier.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaObjectIdentifier")
        kparams.addStringIfDefined("extendedFeatures", self.extendedFeatures)
        return kparams

    def getExtendedFeatures(self):
        return self.extendedFeatures

    def setExtendedFeatures(self, newExtendedFeatures):
        self.extendedFeatures = newExtendedFeatures


# @package Kaltura
# @subpackage Client
class KalturaExtendingItemMrssParameter(KalturaObjectBase):
    def __init__(self,
            xpath=NotImplemented,
            identifier=NotImplemented,
            extensionMode=NotImplemented):
        KalturaObjectBase.__init__(self)

        # XPath for the extending item
        # @var string
        self.xpath = xpath

        # Object identifier
        # @var KalturaObjectIdentifier
        self.identifier = identifier

        # Mode of extension - append to MRSS or replace the xpath content.
        # @var KalturaMrssExtensionMode
        self.extensionMode = extensionMode


    PROPERTY_LOADERS = {
        'xpath': getXmlNodeText, 
        'identifier': (KalturaObjectFactory.create, 'KalturaObjectIdentifier'), 
        'extensionMode': (KalturaEnumsFactory.createInt, "KalturaMrssExtensionMode"), 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaExtendingItemMrssParameter.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaExtendingItemMrssParameter")
        kparams.addStringIfDefined("xpath", self.xpath)
        kparams.addObjectIfDefined("identifier", self.identifier)
        kparams.addIntEnumIfDefined("extensionMode", self.extensionMode)
        return kparams

    def getXpath(self):
        return self.xpath

    def setXpath(self, newXpath):
        self.xpath = newXpath

    def getIdentifier(self):
        return self.identifier

    def setIdentifier(self, newIdentifier):
        self.identifier = newIdentifier

    def getExtensionMode(self):
        return self.extensionMode

    def setExtensionMode(self, newExtensionMode):
        self.extensionMode = newExtensionMode


# @package Kaltura
# @subpackage Client
class KalturaPlayableEntry(KalturaBaseEntry):
    def __init__(self,
            id=NotImplemented,
            name=NotImplemented,
            description=NotImplemented,
            partnerId=NotImplemented,
            userId=NotImplemented,
            creatorId=NotImplemented,
            tags=NotImplemented,
            adminTags=NotImplemented,
            categories=NotImplemented,
            categoriesIds=NotImplemented,
            status=NotImplemented,
            moderationStatus=NotImplemented,
            moderationCount=NotImplemented,
            type=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented,
            rank=NotImplemented,
            totalRank=NotImplemented,
            votes=NotImplemented,
            groupId=NotImplemented,
            partnerData=NotImplemented,
            downloadUrl=NotImplemented,
            searchText=NotImplemented,
            licenseType=NotImplemented,
            version=NotImplemented,
            thumbnailUrl=NotImplemented,
            accessControlId=NotImplemented,
            startDate=NotImplemented,
            endDate=NotImplemented,
            referenceId=NotImplemented,
            replacingEntryId=NotImplemented,
            replacedEntryId=NotImplemented,
            replacementStatus=NotImplemented,
            partnerSortValue=NotImplemented,
            conversionProfileId=NotImplemented,
            redirectEntryId=NotImplemented,
            rootEntryId=NotImplemented,
            parentEntryId=NotImplemented,
            operationAttributes=NotImplemented,
            entitledUsersEdit=NotImplemented,
            entitledUsersPublish=NotImplemented,
            entitledUsersView=NotImplemented,
            capabilities=NotImplemented,
            templateEntryId=NotImplemented,
            displayInSearch=NotImplemented,
            application=NotImplemented,
            applicationVersion=NotImplemented,
            blockAutoTranscript=NotImplemented,
            plays=NotImplemented,
            views=NotImplemented,
            lastPlayedAt=NotImplemented,
            width=NotImplemented,
            height=NotImplemented,
            duration=NotImplemented,
            msDuration=NotImplemented,
            durationType=NotImplemented):
        KalturaBaseEntry.__init__(self,
            id,
            name,
            description,
            partnerId,
            userId,
            creatorId,
            tags,
            adminTags,
            categories,
            categoriesIds,
            status,
            moderationStatus,
            moderationCount,
            type,
            createdAt,
            updatedAt,
            rank,
            totalRank,
            votes,
            groupId,
            partnerData,
            downloadUrl,
            searchText,
            licenseType,
            version,
            thumbnailUrl,
            accessControlId,
            startDate,
            endDate,
            referenceId,
            replacingEntryId,
            replacedEntryId,
            replacementStatus,
            partnerSortValue,
            conversionProfileId,
            redirectEntryId,
            rootEntryId,
            parentEntryId,
            operationAttributes,
            entitledUsersEdit,
            entitledUsersPublish,
            entitledUsersView,
            capabilities,
            templateEntryId,
            displayInSearch,
            application,
            applicationVersion,
            blockAutoTranscript)

        # Number of plays
        # @var int
        # @readonly
        self.plays = plays

        # Number of views
        # @var int
        # @readonly
        self.views = views

        # The last time the entry was played
        # @var int
        # @readonly
        self.lastPlayedAt = lastPlayedAt

        # The width in pixels
        # @var int
        # @readonly
        self.width = width

        # The height in pixels
        # @var int
        # @readonly
        self.height = height

        # The duration in seconds
        # @var int
        # @readonly
        self.duration = duration

        # The duration in miliseconds
        # @var int
        self.msDuration = msDuration

        # The duration type (short for 0-4 mins, medium for 4-20 mins, long for 20+ mins)
        # @var KalturaDurationType
        # @readonly
        self.durationType = durationType


    PROPERTY_LOADERS = {
        'plays': getXmlNodeInt, 
        'views': getXmlNodeInt, 
        'lastPlayedAt': getXmlNodeInt, 
        'width': getXmlNodeInt, 
        'height': getXmlNodeInt, 
        'duration': getXmlNodeInt, 
        'msDuration': getXmlNodeInt, 
        'durationType': (KalturaEnumsFactory.createString, "KalturaDurationType"), 
    }

    def fromXml(self, node):
        KalturaBaseEntry.fromXml(self, node)
        self.fromXmlImpl(node, KalturaPlayableEntry.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaBaseEntry.toParams(self)
        kparams.put("objectType", "KalturaPlayableEntry")
        kparams.addIntIfDefined("msDuration", self.msDuration)
        return kparams

    def getPlays(self):
        return self.plays

    def getViews(self):
        return self.views

    def getLastPlayedAt(self):
        return self.lastPlayedAt

    def getWidth(self):
        return self.width

    def getHeight(self):
        return self.height

    def getDuration(self):
        return self.duration

    def getMsDuration(self):
        return self.msDuration

    def setMsDuration(self, newMsDuration):
        self.msDuration = newMsDuration

    def getDurationType(self):
        return self.durationType


# @package Kaltura
# @subpackage Client
class KalturaStreamContainer(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            type=NotImplemented,
            trackIndex=NotImplemented,
            language=NotImplemented,
            channelIndex=NotImplemented,
            label=NotImplemented,
            channelLayout=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.id = id

        # @var string
        self.type = type

        # @var int
        self.trackIndex = trackIndex

        # @var string
        self.language = language

        # @var int
        self.channelIndex = channelIndex

        # @var string
        self.label = label

        # @var string
        self.channelLayout = channelLayout


    PROPERTY_LOADERS = {
        'id': getXmlNodeText, 
        'type': getXmlNodeText, 
        'trackIndex': getXmlNodeInt, 
        'language': getXmlNodeText, 
        'channelIndex': getXmlNodeInt, 
        'label': getXmlNodeText, 
        'channelLayout': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaStreamContainer.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaStreamContainer")
        kparams.addStringIfDefined("id", self.id)
        kparams.addStringIfDefined("type", self.type)
        kparams.addIntIfDefined("trackIndex", self.trackIndex)
        kparams.addStringIfDefined("language", self.language)
        kparams.addIntIfDefined("channelIndex", self.channelIndex)
        kparams.addStringIfDefined("label", self.label)
        kparams.addStringIfDefined("channelLayout", self.channelLayout)
        return kparams

    def getId(self):
        return self.id

    def setId(self, newId):
        self.id = newId

    def getType(self):
        return self.type

    def setType(self, newType):
        self.type = newType

    def getTrackIndex(self):
        return self.trackIndex

    def setTrackIndex(self, newTrackIndex):
        self.trackIndex = newTrackIndex

    def getLanguage(self):
        return self.language

    def setLanguage(self, newLanguage):
        self.language = newLanguage

    def getChannelIndex(self):
        return self.channelIndex

    def setChannelIndex(self, newChannelIndex):
        self.channelIndex = newChannelIndex

    def getLabel(self):
        return self.label

    def setLabel(self, newLabel):
        self.label = newLabel

    def getChannelLayout(self):
        return self.channelLayout

    def setChannelLayout(self, newChannelLayout):
        self.channelLayout = newChannelLayout


# @package Kaltura
# @subpackage Client
class KalturaMediaEntry(KalturaPlayableEntry):
    def __init__(self,
            id=NotImplemented,
            name=NotImplemented,
            description=NotImplemented,
            partnerId=NotImplemented,
            userId=NotImplemented,
            creatorId=NotImplemented,
            tags=NotImplemented,
            adminTags=NotImplemented,
            categories=NotImplemented,
            categoriesIds=NotImplemented,
            status=NotImplemented,
            moderationStatus=NotImplemented,
            moderationCount=NotImplemented,
            type=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented,
            rank=NotImplemented,
            totalRank=NotImplemented,
            votes=NotImplemented,
            groupId=NotImplemented,
            partnerData=NotImplemented,
            downloadUrl=NotImplemented,
            searchText=NotImplemented,
            licenseType=NotImplemented,
            version=NotImplemented,
            thumbnailUrl=NotImplemented,
            accessControlId=NotImplemented,
            startDate=NotImplemented,
            endDate=NotImplemented,
            referenceId=NotImplemented,
            replacingEntryId=NotImplemented,
            replacedEntryId=NotImplemented,
            replacementStatus=NotImplemented,
            partnerSortValue=NotImplemented,
            conversionProfileId=NotImplemented,
            redirectEntryId=NotImplemented,
            rootEntryId=NotImplemented,
            parentEntryId=NotImplemented,
            operationAttributes=NotImplemented,
            entitledUsersEdit=NotImplemented,
            entitledUsersPublish=NotImplemented,
            entitledUsersView=NotImplemented,
            capabilities=NotImplemented,
            templateEntryId=NotImplemented,
            displayInSearch=NotImplemented,
            application=NotImplemented,
            applicationVersion=NotImplemented,
            blockAutoTranscript=NotImplemented,
            plays=NotImplemented,
            views=NotImplemented,
            lastPlayedAt=NotImplemented,
            width=NotImplemented,
            height=NotImplemented,
            duration=NotImplemented,
            msDuration=NotImplemented,
            durationType=NotImplemented,
            mediaType=NotImplemented,
            conversionQuality=NotImplemented,
            sourceType=NotImplemented,
            sourceVersion=NotImplemented,
            searchProviderType=NotImplemented,
            searchProviderId=NotImplemented,
            creditUserName=NotImplemented,
            creditUrl=NotImplemented,
            mediaDate=NotImplemented,
            dataUrl=NotImplemented,
            flavorParamsIds=NotImplemented,
            isTrimDisabled=NotImplemented,
            streams=NotImplemented):
        KalturaPlayableEntry.__init__(self,
            id,
            name,
            description,
            partnerId,
            userId,
            creatorId,
            tags,
            adminTags,
            categories,
            categoriesIds,
            status,
            moderationStatus,
            moderationCount,
            type,
            createdAt,
            updatedAt,
            rank,
            totalRank,
            votes,
            groupId,
            partnerData,
            downloadUrl,
            searchText,
            licenseType,
            version,
            thumbnailUrl,
            accessControlId,
            startDate,
            endDate,
            referenceId,
            replacingEntryId,
            replacedEntryId,
            replacementStatus,
            partnerSortValue,
            conversionProfileId,
            redirectEntryId,
            rootEntryId,
            parentEntryId,
            operationAttributes,
            entitledUsersEdit,
            entitledUsersPublish,
            entitledUsersView,
            capabilities,
            templateEntryId,
            displayInSearch,
            application,
            applicationVersion,
            blockAutoTranscript,
            plays,
            views,
            lastPlayedAt,
            width,
            height,
            duration,
            msDuration,
            durationType)

        # The media type of the entry
        # @var KalturaMediaType
        # @insertonly
        self.mediaType = mediaType

        # Override the default conversion quality
        # @var string
        # @insertonly
        self.conversionQuality = conversionQuality

        # The source type of the entry
        # @var KalturaSourceType
        # @insertonly
        self.sourceType = sourceType

        # The source version of the entry
        # @var string
        # @insertonly
        self.sourceVersion = sourceVersion

        # The search provider type used to import this entry
        # @var KalturaSearchProviderType
        # @insertonly
        self.searchProviderType = searchProviderType

        # The ID of the media in the importing site
        # @var string
        # @insertonly
        self.searchProviderId = searchProviderId

        # The user name used for credits
        # @var string
        self.creditUserName = creditUserName

        # The URL for credits
        # @var string
        self.creditUrl = creditUrl

        # The media date extracted from EXIF data (For images) as Unix timestamp (In seconds)
        # @var int
        # @readonly
        self.mediaDate = mediaDate

        # The URL used for playback. This is not the download URL.
        # @var string
        # @readonly
        self.dataUrl = dataUrl

        # Comma separated flavor params ids that exists for this media entry
        # @var string
        # @readonly
        self.flavorParamsIds = flavorParamsIds

        # True if trim action is disabled for this entry
        # @var KalturaNullableBoolean
        # @readonly
        self.isTrimDisabled = isTrimDisabled

        # Array of streams that exists on the entry
        # @var array of KalturaStreamContainer
        self.streams = streams


    PROPERTY_LOADERS = {
        'mediaType': (KalturaEnumsFactory.createInt, "KalturaMediaType"), 
        'conversionQuality': getXmlNodeText, 
        'sourceType': (KalturaEnumsFactory.createString, "KalturaSourceType"), 
        'sourceVersion': getXmlNodeText, 
        'searchProviderType': (KalturaEnumsFactory.createInt, "KalturaSearchProviderType"), 
        'searchProviderId': getXmlNodeText, 
        'creditUserName': getXmlNodeText, 
        'creditUrl': getXmlNodeText, 
        'mediaDate': getXmlNodeInt, 
        'dataUrl': getXmlNodeText, 
        'flavorParamsIds': getXmlNodeText, 
        'isTrimDisabled': (KalturaEnumsFactory.createInt, "KalturaNullableBoolean"), 
        'streams': (KalturaObjectFactory.createArray, 'KalturaStreamContainer'), 
    }

    def fromXml(self, node):
        KalturaPlayableEntry.fromXml(self, node)
        self.fromXmlImpl(node, KalturaMediaEntry.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaPlayableEntry.toParams(self)
        kparams.put("objectType", "KalturaMediaEntry")
        kparams.addIntEnumIfDefined("mediaType", self.mediaType)
        kparams.addStringIfDefined("conversionQuality", self.conversionQuality)
        kparams.addStringEnumIfDefined("sourceType", self.sourceType)
        kparams.addStringIfDefined("sourceVersion", self.sourceVersion)
        kparams.addIntEnumIfDefined("searchProviderType", self.searchProviderType)
        kparams.addStringIfDefined("searchProviderId", self.searchProviderId)
        kparams.addStringIfDefined("creditUserName", self.creditUserName)
        kparams.addStringIfDefined("creditUrl", self.creditUrl)
        kparams.addArrayIfDefined("streams", self.streams)
        return kparams

    def getMediaType(self):
        return self.mediaType

    def setMediaType(self, newMediaType):
        self.mediaType = newMediaType

    def getConversionQuality(self):
        return self.conversionQuality

    def setConversionQuality(self, newConversionQuality):
        self.conversionQuality = newConversionQuality

    def getSourceType(self):
        return self.sourceType

    def setSourceType(self, newSourceType):
        self.sourceType = newSourceType

    def getSourceVersion(self):
        return self.sourceVersion

    def setSourceVersion(self, newSourceVersion):
        self.sourceVersion = newSourceVersion

    def getSearchProviderType(self):
        return self.searchProviderType

    def setSearchProviderType(self, newSearchProviderType):
        self.searchProviderType = newSearchProviderType

    def getSearchProviderId(self):
        return self.searchProviderId

    def setSearchProviderId(self, newSearchProviderId):
        self.searchProviderId = newSearchProviderId

    def getCreditUserName(self):
        return self.creditUserName

    def setCreditUserName(self, newCreditUserName):
        self.creditUserName = newCreditUserName

    def getCreditUrl(self):
        return self.creditUrl

    def setCreditUrl(self, newCreditUrl):
        self.creditUrl = newCreditUrl

    def getMediaDate(self):
        return self.mediaDate

    def getDataUrl(self):
        return self.dataUrl

    def getFlavorParamsIds(self):
        return self.flavorParamsIds

    def getIsTrimDisabled(self):
        return self.isTrimDisabled

    def getStreams(self):
        return self.streams

    def setStreams(self, newStreams):
        self.streams = newStreams


# @package Kaltura
# @subpackage Client
class KalturaFeatureStatus(KalturaObjectBase):
    def __init__(self,
            type=NotImplemented,
            value=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var KalturaFeatureStatusType
        self.type = type

        # @var int
        self.value = value


    PROPERTY_LOADERS = {
        'type': (KalturaEnumsFactory.createInt, "KalturaFeatureStatusType"), 
        'value': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaFeatureStatus.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaFeatureStatus")
        kparams.addIntEnumIfDefined("type", self.type)
        kparams.addIntIfDefined("value", self.value)
        return kparams

    def getType(self):
        return self.type

    def setType(self, newType):
        self.type = newType

    def getValue(self):
        return self.value

    def setValue(self, newValue):
        self.value = newValue


# @package Kaltura
# @subpackage Client
class KalturaFileAsset(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            partnerId=NotImplemented,
            fileAssetObjectType=NotImplemented,
            objectId=NotImplemented,
            name=NotImplemented,
            systemName=NotImplemented,
            fileExt=NotImplemented,
            version=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented,
            status=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var int
        # @readonly
        self.id = id

        # @var int
        # @readonly
        self.partnerId = partnerId

        # @var KalturaFileAssetObjectType
        # @insertonly
        self.fileAssetObjectType = fileAssetObjectType

        # @var string
        # @insertonly
        self.objectId = objectId

        # @var string
        self.name = name

        # @var string
        self.systemName = systemName

        # @var string
        self.fileExt = fileExt

        # @var int
        # @readonly
        self.version = version

        # @var int
        # @readonly
        self.createdAt = createdAt

        # @var int
        # @readonly
        self.updatedAt = updatedAt

        # @var KalturaFileAssetStatus
        # @readonly
        self.status = status


    PROPERTY_LOADERS = {
        'id': getXmlNodeInt, 
        'partnerId': getXmlNodeInt, 
        'fileAssetObjectType': (KalturaEnumsFactory.createString, "KalturaFileAssetObjectType"), 
        'objectId': getXmlNodeText, 
        'name': getXmlNodeText, 
        'systemName': getXmlNodeText, 
        'fileExt': getXmlNodeText, 
        'version': getXmlNodeInt, 
        'createdAt': getXmlNodeInt, 
        'updatedAt': getXmlNodeInt, 
        'status': (KalturaEnumsFactory.createString, "KalturaFileAssetStatus"), 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaFileAsset.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaFileAsset")
        kparams.addStringEnumIfDefined("fileAssetObjectType", self.fileAssetObjectType)
        kparams.addStringIfDefined("objectId", self.objectId)
        kparams.addStringIfDefined("name", self.name)
        kparams.addStringIfDefined("systemName", self.systemName)
        kparams.addStringIfDefined("fileExt", self.fileExt)
        return kparams

    def getId(self):
        return self.id

    def getPartnerId(self):
        return self.partnerId

    def getFileAssetObjectType(self):
        return self.fileAssetObjectType

    def setFileAssetObjectType(self, newFileAssetObjectType):
        self.fileAssetObjectType = newFileAssetObjectType

    def getObjectId(self):
        return self.objectId

    def setObjectId(self, newObjectId):
        self.objectId = newObjectId

    def getName(self):
        return self.name

    def setName(self, newName):
        self.name = newName

    def getSystemName(self):
        return self.systemName

    def setSystemName(self, newSystemName):
        self.systemName = newSystemName

    def getFileExt(self):
        return self.fileExt

    def setFileExt(self, newFileExt):
        self.fileExt = newFileExt

    def getVersion(self):
        return self.version

    def getCreatedAt(self):
        return self.createdAt

    def getUpdatedAt(self):
        return self.updatedAt

    def getStatus(self):
        return self.status


# @package Kaltura
# @subpackage Client
class KalturaFileContainer(KalturaObjectBase):
    def __init__(self,
            filePath=NotImplemented,
            encryptionKey=NotImplemented,
            fileSize=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.filePath = filePath

        # @var string
        self.encryptionKey = encryptionKey

        # @var int
        self.fileSize = fileSize


    PROPERTY_LOADERS = {
        'filePath': getXmlNodeText, 
        'encryptionKey': getXmlNodeText, 
        'fileSize': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaFileContainer.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaFileContainer")
        kparams.addStringIfDefined("filePath", self.filePath)
        kparams.addStringIfDefined("encryptionKey", self.encryptionKey)
        kparams.addIntIfDefined("fileSize", self.fileSize)
        return kparams

    def getFilePath(self):
        return self.filePath

    def setFilePath(self, newFilePath):
        self.filePath = newFilePath

    def getEncryptionKey(self):
        return self.encryptionKey

    def setEncryptionKey(self, newEncryptionKey):
        self.encryptionKey = newEncryptionKey

    def getFileSize(self):
        return self.fileSize

    def setFileSize(self, newFileSize):
        self.fileSize = newFileSize


# @package Kaltura
# @subpackage Client
class KalturaFlavorAsset(KalturaAsset):
    def __init__(self,
            id=NotImplemented,
            entryId=NotImplemented,
            partnerId=NotImplemented,
            version=NotImplemented,
            size=NotImplemented,
            tags=NotImplemented,
            fileExt=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented,
            deletedAt=NotImplemented,
            description=NotImplemented,
            partnerData=NotImplemented,
            partnerDescription=NotImplemented,
            actualSourceAssetParamsIds=NotImplemented,
            sizeInBytes=NotImplemented,
            flavorParamsId=NotImplemented,
            width=NotImplemented,
            height=NotImplemented,
            bitrate=NotImplemented,
            frameRate=NotImplemented,
            isOriginal=NotImplemented,
            isWeb=NotImplemented,
            containerFormat=NotImplemented,
            videoCodecId=NotImplemented,
            status=NotImplemented,
            language=NotImplemented,
            label=NotImplemented,
            isDefault=NotImplemented):
        KalturaAsset.__init__(self,
            id,
            entryId,
            partnerId,
            version,
            size,
            tags,
            fileExt,
            createdAt,
            updatedAt,
            deletedAt,
            description,
            partnerData,
            partnerDescription,
            actualSourceAssetParamsIds,
            sizeInBytes)

        # The Flavor Params used to create this Flavor Asset
        # @var int
        # @insertonly
        self.flavorParamsId = flavorParamsId

        # The width of the Flavor Asset
        # @var int
        # @readonly
        self.width = width

        # The height of the Flavor Asset
        # @var int
        # @readonly
        self.height = height

        # The overall bitrate (in KBits) of the Flavor Asset
        # @var int
        # @readonly
        self.bitrate = bitrate

        # The frame rate (in FPS) of the Flavor Asset
        # @var float
        # @readonly
        self.frameRate = frameRate

        # True if this Flavor Asset is the original source
        # @var bool
        # @readonly
        self.isOriginal = isOriginal

        # True if this Flavor Asset is playable in KDP
        # @var bool
        # @readonly
        self.isWeb = isWeb

        # The container format
        # @var string
        # @readonly
        self.containerFormat = containerFormat

        # The video codec
        # @var string
        # @readonly
        self.videoCodecId = videoCodecId

        # The status of the Flavor Asset
        # @var KalturaFlavorAssetStatus
        # @readonly
        self.status = status

        # The language of the flavor asset
        # @var KalturaLanguage
        self.language = language

        # The label of the flavor asset
        # @var string
        self.label = label

        # Is default flavor asset of the entry (This field will be taken into account selectign which audio flavor will be selected as default)
        # @var KalturaNullableBoolean
        self.isDefault = isDefault


    PROPERTY_LOADERS = {
        'flavorParamsId': getXmlNodeInt, 
        'width': getXmlNodeInt, 
        'height': getXmlNodeInt, 
        'bitrate': getXmlNodeInt, 
        'frameRate': getXmlNodeFloat, 
        'isOriginal': getXmlNodeBool, 
        'isWeb': getXmlNodeBool, 
        'containerFormat': getXmlNodeText, 
        'videoCodecId': getXmlNodeText, 
        'status': (KalturaEnumsFactory.createInt, "KalturaFlavorAssetStatus"), 
        'language': (KalturaEnumsFactory.createString, "KalturaLanguage"), 
        'label': getXmlNodeText, 
        'isDefault': (KalturaEnumsFactory.createInt, "KalturaNullableBoolean"), 
    }

    def fromXml(self, node):
        KalturaAsset.fromXml(self, node)
        self.fromXmlImpl(node, KalturaFlavorAsset.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaAsset.toParams(self)
        kparams.put("objectType", "KalturaFlavorAsset")
        kparams.addIntIfDefined("flavorParamsId", self.flavorParamsId)
        kparams.addStringEnumIfDefined("language", self.language)
        kparams.addStringIfDefined("label", self.label)
        kparams.addIntEnumIfDefined("isDefault", self.isDefault)
        return kparams

    def getFlavorParamsId(self):
        return self.flavorParamsId

    def setFlavorParamsId(self, newFlavorParamsId):
        self.flavorParamsId = newFlavorParamsId

    def getWidth(self):
        return self.width

    def getHeight(self):
        return self.height

    def getBitrate(self):
        return self.bitrate

    def getFrameRate(self):
        return self.frameRate

    def getIsOriginal(self):
        return self.isOriginal

    def getIsWeb(self):
        return self.isWeb

    def getContainerFormat(self):
        return self.containerFormat

    def getVideoCodecId(self):
        return self.videoCodecId

    def getStatus(self):
        return self.status

    def getLanguage(self):
        return self.language

    def setLanguage(self, newLanguage):
        self.language = newLanguage

    def getLabel(self):
        return self.label

    def setLabel(self, newLabel):
        self.label = newLabel

    def getIsDefault(self):
        return self.isDefault

    def setIsDefault(self, newIsDefault):
        self.isDefault = newIsDefault


# @package Kaltura
# @subpackage Client
class KalturaFlavorAssetUrlOptions(KalturaObjectBase):
    def __init__(self,
            fileName=NotImplemented,
            referrer=NotImplemented):
        KalturaObjectBase.__init__(self)

        # The name of the downloaded file
        # @var string
        self.fileName = fileName

        # @var string
        self.referrer = referrer


    PROPERTY_LOADERS = {
        'fileName': getXmlNodeText, 
        'referrer': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaFlavorAssetUrlOptions.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaFlavorAssetUrlOptions")
        kparams.addStringIfDefined("fileName", self.fileName)
        kparams.addStringIfDefined("referrer", self.referrer)
        return kparams

    def getFileName(self):
        return self.fileName

    def setFileName(self, newFileName):
        self.fileName = newFileName

    def getReferrer(self):
        return self.referrer

    def setReferrer(self, newReferrer):
        self.referrer = newReferrer


# @package Kaltura
# @subpackage Client
class KalturaFlavorParams(KalturaAssetParams):
    def __init__(self,
            id=NotImplemented,
            partnerId=NotImplemented,
            name=NotImplemented,
            systemName=NotImplemented,
            description=NotImplemented,
            createdAt=NotImplemented,
            isSystemDefault=NotImplemented,
            tags=NotImplemented,
            requiredPermissions=NotImplemented,
            sourceRemoteStorageProfileId=NotImplemented,
            remoteStorageProfileIds=NotImplemented,
            mediaParserType=NotImplemented,
            sourceAssetParamsIds=NotImplemented,
            videoCodec=NotImplemented,
            videoBitrate=NotImplemented,
            audioCodec=NotImplemented,
            audioBitrate=NotImplemented,
            audioChannels=NotImplemented,
            audioSampleRate=NotImplemented,
            width=NotImplemented,
            height=NotImplemented,
            frameRate=NotImplemented,
            gopSize=NotImplemented,
            conversionEngines=NotImplemented,
            conversionEnginesExtraParams=NotImplemented,
            twoPass=NotImplemented,
            deinterlice=NotImplemented,
            rotate=NotImplemented,
            operators=NotImplemented,
            engineVersion=NotImplemented,
            format=NotImplemented,
            aspectRatioProcessingMode=NotImplemented,
            forceFrameToMultiplication16=NotImplemented,
            isGopInSec=NotImplemented,
            isAvoidVideoShrinkFramesizeToSource=NotImplemented,
            isAvoidVideoShrinkBitrateToSource=NotImplemented,
            isVideoFrameRateForLowBrAppleHls=NotImplemented,
            multiStream=NotImplemented,
            anamorphicPixels=NotImplemented,
            isAvoidForcedKeyFrames=NotImplemented,
            forcedKeyFramesMode=NotImplemented,
            isCropIMX=NotImplemented,
            optimizationPolicy=NotImplemented,
            maxFrameRate=NotImplemented,
            videoConstantBitrate=NotImplemented,
            videoBitrateTolerance=NotImplemented,
            watermarkData=NotImplemented,
            subtitlesData=NotImplemented,
            isEncrypted=NotImplemented,
            contentAwareness=NotImplemented,
            chunkedEncodeMode=NotImplemented,
            clipOffset=NotImplemented,
            clipDuration=NotImplemented):
        KalturaAssetParams.__init__(self,
            id,
            partnerId,
            name,
            systemName,
            description,
            createdAt,
            isSystemDefault,
            tags,
            requiredPermissions,
            sourceRemoteStorageProfileId,
            remoteStorageProfileIds,
            mediaParserType,
            sourceAssetParamsIds)

        # The video codec of the Flavor Params
        # @var KalturaVideoCodec
        self.videoCodec = videoCodec

        # The video bitrate (in KBits) of the Flavor Params
        # @var int
        self.videoBitrate = videoBitrate

        # The audio codec of the Flavor Params
        # @var KalturaAudioCodec
        self.audioCodec = audioCodec

        # The audio bitrate (in KBits) of the Flavor Params
        # @var int
        self.audioBitrate = audioBitrate

        # The number of audio channels for "downmixing"
        # @var int
        self.audioChannels = audioChannels

        # The audio sample rate of the Flavor Params
        # @var int
        self.audioSampleRate = audioSampleRate

        # The desired width of the Flavor Params
        # @var int
        self.width = width

        # The desired height of the Flavor Params
        # @var int
        self.height = height

        # The frame rate of the Flavor Params
        # @var float
        self.frameRate = frameRate

        # The gop size of the Flavor Params
        # @var int
        self.gopSize = gopSize

        # The list of conversion engines (comma separated)
        # @var string
        self.conversionEngines = conversionEngines

        # The list of conversion engines extra params (separated with "|")
        # @var string
        self.conversionEnginesExtraParams = conversionEnginesExtraParams

        # @var bool
        self.twoPass = twoPass

        # @var int
        self.deinterlice = deinterlice

        # @var int
        self.rotate = rotate

        # @var string
        self.operators = operators

        # @var int
        self.engineVersion = engineVersion

        # The container format of the Flavor Params
        # @var KalturaContainerFormat
        self.format = format

        # @var int
        self.aspectRatioProcessingMode = aspectRatioProcessingMode

        # @var int
        self.forceFrameToMultiplication16 = forceFrameToMultiplication16

        # @var int
        self.isGopInSec = isGopInSec

        # @var int
        self.isAvoidVideoShrinkFramesizeToSource = isAvoidVideoShrinkFramesizeToSource

        # @var int
        self.isAvoidVideoShrinkBitrateToSource = isAvoidVideoShrinkBitrateToSource

        # @var int
        self.isVideoFrameRateForLowBrAppleHls = isVideoFrameRateForLowBrAppleHls

        # @var string
        self.multiStream = multiStream

        # @var float
        self.anamorphicPixels = anamorphicPixels

        # @var int
        self.isAvoidForcedKeyFrames = isAvoidForcedKeyFrames

        # @var int
        self.forcedKeyFramesMode = forcedKeyFramesMode

        # @var int
        self.isCropIMX = isCropIMX

        # @var int
        self.optimizationPolicy = optimizationPolicy

        # @var int
        self.maxFrameRate = maxFrameRate

        # @var int
        self.videoConstantBitrate = videoConstantBitrate

        # @var int
        self.videoBitrateTolerance = videoBitrateTolerance

        # @var string
        self.watermarkData = watermarkData

        # @var string
        self.subtitlesData = subtitlesData

        # @var int
        self.isEncrypted = isEncrypted

        # @var float
        self.contentAwareness = contentAwareness

        # @var int
        self.chunkedEncodeMode = chunkedEncodeMode

        # @var int
        self.clipOffset = clipOffset

        # @var int
        self.clipDuration = clipDuration


    PROPERTY_LOADERS = {
        'videoCodec': (KalturaEnumsFactory.createString, "KalturaVideoCodec"), 
        'videoBitrate': getXmlNodeInt, 
        'audioCodec': (KalturaEnumsFactory.createString, "KalturaAudioCodec"), 
        'audioBitrate': getXmlNodeInt, 
        'audioChannels': getXmlNodeInt, 
        'audioSampleRate': getXmlNodeInt, 
        'width': getXmlNodeInt, 
        'height': getXmlNodeInt, 
        'frameRate': getXmlNodeFloat, 
        'gopSize': getXmlNodeInt, 
        'conversionEngines': getXmlNodeText, 
        'conversionEnginesExtraParams': getXmlNodeText, 
        'twoPass': getXmlNodeBool, 
        'deinterlice': getXmlNodeInt, 
        'rotate': getXmlNodeInt, 
        'operators': getXmlNodeText, 
        'engineVersion': getXmlNodeInt, 
        'format': (KalturaEnumsFactory.createString, "KalturaContainerFormat"), 
        'aspectRatioProcessingMode': getXmlNodeInt, 
        'forceFrameToMultiplication16': getXmlNodeInt, 
        'isGopInSec': getXmlNodeInt, 
        'isAvoidVideoShrinkFramesizeToSource': getXmlNodeInt, 
        'isAvoidVideoShrinkBitrateToSource': getXmlNodeInt, 
        'isVideoFrameRateForLowBrAppleHls': getXmlNodeInt, 
        'multiStream': getXmlNodeText, 
        'anamorphicPixels': getXmlNodeFloat, 
        'isAvoidForcedKeyFrames': getXmlNodeInt, 
        'forcedKeyFramesMode': getXmlNodeInt, 
        'isCropIMX': getXmlNodeInt, 
        'optimizationPolicy': getXmlNodeInt, 
        'maxFrameRate': getXmlNodeInt, 
        'videoConstantBitrate': getXmlNodeInt, 
        'videoBitrateTolerance': getXmlNodeInt, 
        'watermarkData': getXmlNodeText, 
        'subtitlesData': getXmlNodeText, 
        'isEncrypted': getXmlNodeInt, 
        'contentAwareness': getXmlNodeFloat, 
        'chunkedEncodeMode': getXmlNodeInt, 
        'clipOffset': getXmlNodeInt, 
        'clipDuration': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaAssetParams.fromXml(self, node)
        self.fromXmlImpl(node, KalturaFlavorParams.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaAssetParams.toParams(self)
        kparams.put("objectType", "KalturaFlavorParams")
        kparams.addStringEnumIfDefined("videoCodec", self.videoCodec)
        kparams.addIntIfDefined("videoBitrate", self.videoBitrate)
        kparams.addStringEnumIfDefined("audioCodec", self.audioCodec)
        kparams.addIntIfDefined("audioBitrate", self.audioBitrate)
        kparams.addIntIfDefined("audioChannels", self.audioChannels)
        kparams.addIntIfDefined("audioSampleRate", self.audioSampleRate)
        kparams.addIntIfDefined("width", self.width)
        kparams.addIntIfDefined("height", self.height)
        kparams.addFloatIfDefined("frameRate", self.frameRate)
        kparams.addIntIfDefined("gopSize", self.gopSize)
        kparams.addStringIfDefined("conversionEngines", self.conversionEngines)
        kparams.addStringIfDefined("conversionEnginesExtraParams", self.conversionEnginesExtraParams)
        kparams.addBoolIfDefined("twoPass", self.twoPass)
        kparams.addIntIfDefined("deinterlice", self.deinterlice)
        kparams.addIntIfDefined("rotate", self.rotate)
        kparams.addStringIfDefined("operators", self.operators)
        kparams.addIntIfDefined("engineVersion", self.engineVersion)
        kparams.addStringEnumIfDefined("format", self.format)
        kparams.addIntIfDefined("aspectRatioProcessingMode", self.aspectRatioProcessingMode)
        kparams.addIntIfDefined("forceFrameToMultiplication16", self.forceFrameToMultiplication16)
        kparams.addIntIfDefined("isGopInSec", self.isGopInSec)
        kparams.addIntIfDefined("isAvoidVideoShrinkFramesizeToSource", self.isAvoidVideoShrinkFramesizeToSource)
        kparams.addIntIfDefined("isAvoidVideoShrinkBitrateToSource", self.isAvoidVideoShrinkBitrateToSource)
        kparams.addIntIfDefined("isVideoFrameRateForLowBrAppleHls", self.isVideoFrameRateForLowBrAppleHls)
        kparams.addStringIfDefined("multiStream", self.multiStream)
        kparams.addFloatIfDefined("anamorphicPixels", self.anamorphicPixels)
        kparams.addIntIfDefined("isAvoidForcedKeyFrames", self.isAvoidForcedKeyFrames)
        kparams.addIntIfDefined("forcedKeyFramesMode", self.forcedKeyFramesMode)
        kparams.addIntIfDefined("isCropIMX", self.isCropIMX)
        kparams.addIntIfDefined("optimizationPolicy", self.optimizationPolicy)
        kparams.addIntIfDefined("maxFrameRate", self.maxFrameRate)
        kparams.addIntIfDefined("videoConstantBitrate", self.videoConstantBitrate)
        kparams.addIntIfDefined("videoBitrateTolerance", self.videoBitrateTolerance)
        kparams.addStringIfDefined("watermarkData", self.watermarkData)
        kparams.addStringIfDefined("subtitlesData", self.subtitlesData)
        kparams.addIntIfDefined("isEncrypted", self.isEncrypted)
        kparams.addFloatIfDefined("contentAwareness", self.contentAwareness)
        kparams.addIntIfDefined("chunkedEncodeMode", self.chunkedEncodeMode)
        kparams.addIntIfDefined("clipOffset", self.clipOffset)
        kparams.addIntIfDefined("clipDuration", self.clipDuration)
        return kparams

    def getVideoCodec(self):
        return self.videoCodec

    def setVideoCodec(self, newVideoCodec):
        self.videoCodec = newVideoCodec

    def getVideoBitrate(self):
        return self.videoBitrate

    def setVideoBitrate(self, newVideoBitrate):
        self.videoBitrate = newVideoBitrate

    def getAudioCodec(self):
        return self.audioCodec

    def setAudioCodec(self, newAudioCodec):
        self.audioCodec = newAudioCodec

    def getAudioBitrate(self):
        return self.audioBitrate

    def setAudioBitrate(self, newAudioBitrate):
        self.audioBitrate = newAudioBitrate

    def getAudioChannels(self):
        return self.audioChannels

    def setAudioChannels(self, newAudioChannels):
        self.audioChannels = newAudioChannels

    def getAudioSampleRate(self):
        return self.audioSampleRate

    def setAudioSampleRate(self, newAudioSampleRate):
        self.audioSampleRate = newAudioSampleRate

    def getWidth(self):
        return self.width

    def setWidth(self, newWidth):
        self.width = newWidth

    def getHeight(self):
        return self.height

    def setHeight(self, newHeight):
        self.height = newHeight

    def getFrameRate(self):
        return self.frameRate

    def setFrameRate(self, newFrameRate):
        self.frameRate = newFrameRate

    def getGopSize(self):
        return self.gopSize

    def setGopSize(self, newGopSize):
        self.gopSize = newGopSize

    def getConversionEngines(self):
        return self.conversionEngines

    def setConversionEngines(self, newConversionEngines):
        self.conversionEngines = newConversionEngines

    def getConversionEnginesExtraParams(self):
        return self.conversionEnginesExtraParams

    def setConversionEnginesExtraParams(self, newConversionEnginesExtraParams):
        self.conversionEnginesExtraParams = newConversionEnginesExtraParams

    def getTwoPass(self):
        return self.twoPass

    def setTwoPass(self, newTwoPass):
        self.twoPass = newTwoPass

    def getDeinterlice(self):
        return self.deinterlice

    def setDeinterlice(self, newDeinterlice):
        self.deinterlice = newDeinterlice

    def getRotate(self):
        return self.rotate

    def setRotate(self, newRotate):
        self.rotate = newRotate

    def getOperators(self):
        return self.operators

    def setOperators(self, newOperators):
        self.operators = newOperators

    def getEngineVersion(self):
        return self.engineVersion

    def setEngineVersion(self, newEngineVersion):
        self.engineVersion = newEngineVersion

    def getFormat(self):
        return self.format

    def setFormat(self, newFormat):
        self.format = newFormat

    def getAspectRatioProcessingMode(self):
        return self.aspectRatioProcessingMode

    def setAspectRatioProcessingMode(self, newAspectRatioProcessingMode):
        self.aspectRatioProcessingMode = newAspectRatioProcessingMode

    def getForceFrameToMultiplication16(self):
        return self.forceFrameToMultiplication16

    def setForceFrameToMultiplication16(self, newForceFrameToMultiplication16):
        self.forceFrameToMultiplication16 = newForceFrameToMultiplication16

    def getIsGopInSec(self):
        return self.isGopInSec

    def setIsGopInSec(self, newIsGopInSec):
        self.isGopInSec = newIsGopInSec

    def getIsAvoidVideoShrinkFramesizeToSource(self):
        return self.isAvoidVideoShrinkFramesizeToSource

    def setIsAvoidVideoShrinkFramesizeToSource(self, newIsAvoidVideoShrinkFramesizeToSource):
        self.isAvoidVideoShrinkFramesizeToSource = newIsAvoidVideoShrinkFramesizeToSource

    def getIsAvoidVideoShrinkBitrateToSource(self):
        return self.isAvoidVideoShrinkBitrateToSource

    def setIsAvoidVideoShrinkBitrateToSource(self, newIsAvoidVideoShrinkBitrateToSource):
        self.isAvoidVideoShrinkBitrateToSource = newIsAvoidVideoShrinkBitrateToSource

    def getIsVideoFrameRateForLowBrAppleHls(self):
        return self.isVideoFrameRateForLowBrAppleHls

    def setIsVideoFrameRateForLowBrAppleHls(self, newIsVideoFrameRateForLowBrAppleHls):
        self.isVideoFrameRateForLowBrAppleHls = newIsVideoFrameRateForLowBrAppleHls

    def getMultiStream(self):
        return self.multiStream

    def setMultiStream(self, newMultiStream):
        self.multiStream = newMultiStream

    def getAnamorphicPixels(self):
        return self.anamorphicPixels

    def setAnamorphicPixels(self, newAnamorphicPixels):
        self.anamorphicPixels = newAnamorphicPixels

    def getIsAvoidForcedKeyFrames(self):
        return self.isAvoidForcedKeyFrames

    def setIsAvoidForcedKeyFrames(self, newIsAvoidForcedKeyFrames):
        self.isAvoidForcedKeyFrames = newIsAvoidForcedKeyFrames

    def getForcedKeyFramesMode(self):
        return self.forcedKeyFramesMode

    def setForcedKeyFramesMode(self, newForcedKeyFramesMode):
        self.forcedKeyFramesMode = newForcedKeyFramesMode

    def getIsCropIMX(self):
        return self.isCropIMX

    def setIsCropIMX(self, newIsCropIMX):
        self.isCropIMX = newIsCropIMX

    def getOptimizationPolicy(self):
        return self.optimizationPolicy

    def setOptimizationPolicy(self, newOptimizationPolicy):
        self.optimizationPolicy = newOptimizationPolicy

    def getMaxFrameRate(self):
        return self.maxFrameRate

    def setMaxFrameRate(self, newMaxFrameRate):
        self.maxFrameRate = newMaxFrameRate

    def getVideoConstantBitrate(self):
        return self.videoConstantBitrate

    def setVideoConstantBitrate(self, newVideoConstantBitrate):
        self.videoConstantBitrate = newVideoConstantBitrate

    def getVideoBitrateTolerance(self):
        return self.videoBitrateTolerance

    def setVideoBitrateTolerance(self, newVideoBitrateTolerance):
        self.videoBitrateTolerance = newVideoBitrateTolerance

    def getWatermarkData(self):
        return self.watermarkData

    def setWatermarkData(self, newWatermarkData):
        self.watermarkData = newWatermarkData

    def getSubtitlesData(self):
        return self.subtitlesData

    def setSubtitlesData(self, newSubtitlesData):
        self.subtitlesData = newSubtitlesData

    def getIsEncrypted(self):
        return self.isEncrypted

    def setIsEncrypted(self, newIsEncrypted):
        self.isEncrypted = newIsEncrypted

    def getContentAwareness(self):
        return self.contentAwareness

    def setContentAwareness(self, newContentAwareness):
        self.contentAwareness = newContentAwareness

    def getChunkedEncodeMode(self):
        return self.chunkedEncodeMode

    def setChunkedEncodeMode(self, newChunkedEncodeMode):
        self.chunkedEncodeMode = newChunkedEncodeMode

    def getClipOffset(self):
        return self.clipOffset

    def setClipOffset(self, newClipOffset):
        self.clipOffset = newClipOffset

    def getClipDuration(self):
        return self.clipDuration

    def setClipDuration(self, newClipDuration):
        self.clipDuration = newClipDuration


# @package Kaltura
# @subpackage Client
class KalturaFlavorAssetWithParams(KalturaObjectBase):
    def __init__(self,
            flavorAsset=NotImplemented,
            flavorParams=NotImplemented,
            entryId=NotImplemented):
        KalturaObjectBase.__init__(self)

        # The Flavor Asset (Can be null when there are params without asset)
        # @var KalturaFlavorAsset
        self.flavorAsset = flavorAsset

        # The Flavor Params
        # @var KalturaFlavorParams
        self.flavorParams = flavorParams

        # The entry id
        # @var string
        self.entryId = entryId


    PROPERTY_LOADERS = {
        'flavorAsset': (KalturaObjectFactory.create, 'KalturaFlavorAsset'), 
        'flavorParams': (KalturaObjectFactory.create, 'KalturaFlavorParams'), 
        'entryId': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaFlavorAssetWithParams.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaFlavorAssetWithParams")
        kparams.addObjectIfDefined("flavorAsset", self.flavorAsset)
        kparams.addObjectIfDefined("flavorParams", self.flavorParams)
        kparams.addStringIfDefined("entryId", self.entryId)
        return kparams

    def getFlavorAsset(self):
        return self.flavorAsset

    def setFlavorAsset(self, newFlavorAsset):
        self.flavorAsset = newFlavorAsset

    def getFlavorParams(self):
        return self.flavorParams

    def setFlavorParams(self, newFlavorParams):
        self.flavorParams = newFlavorParams

    def getEntryId(self):
        return self.entryId

    def setEntryId(self, newEntryId):
        self.entryId = newEntryId


# @package Kaltura
# @subpackage Client
class KalturaFlavorParamsOutput(KalturaFlavorParams):
    def __init__(self,
            id=NotImplemented,
            partnerId=NotImplemented,
            name=NotImplemented,
            systemName=NotImplemented,
            description=NotImplemented,
            createdAt=NotImplemented,
            isSystemDefault=NotImplemented,
            tags=NotImplemented,
            requiredPermissions=NotImplemented,
            sourceRemoteStorageProfileId=NotImplemented,
            remoteStorageProfileIds=NotImplemented,
            mediaParserType=NotImplemented,
            sourceAssetParamsIds=NotImplemented,
            videoCodec=NotImplemented,
            videoBitrate=NotImplemented,
            audioCodec=NotImplemented,
            audioBitrate=NotImplemented,
            audioChannels=NotImplemented,
            audioSampleRate=NotImplemented,
            width=NotImplemented,
            height=NotImplemented,
            frameRate=NotImplemented,
            gopSize=NotImplemented,
            conversionEngines=NotImplemented,
            conversionEnginesExtraParams=NotImplemented,
            twoPass=NotImplemented,
            deinterlice=NotImplemented,
            rotate=NotImplemented,
            operators=NotImplemented,
            engineVersion=NotImplemented,
            format=NotImplemented,
            aspectRatioProcessingMode=NotImplemented,
            forceFrameToMultiplication16=NotImplemented,
            isGopInSec=NotImplemented,
            isAvoidVideoShrinkFramesizeToSource=NotImplemented,
            isAvoidVideoShrinkBitrateToSource=NotImplemented,
            isVideoFrameRateForLowBrAppleHls=NotImplemented,
            multiStream=NotImplemented,
            anamorphicPixels=NotImplemented,
            isAvoidForcedKeyFrames=NotImplemented,
            forcedKeyFramesMode=NotImplemented,
            isCropIMX=NotImplemented,
            optimizationPolicy=NotImplemented,
            maxFrameRate=NotImplemented,
            videoConstantBitrate=NotImplemented,
            videoBitrateTolerance=NotImplemented,
            watermarkData=NotImplemented,
            subtitlesData=NotImplemented,
            isEncrypted=NotImplemented,
            contentAwareness=NotImplemented,
            chunkedEncodeMode=NotImplemented,
            clipOffset=NotImplemented,
            clipDuration=NotImplemented,
            flavorParamsId=NotImplemented,
            commandLinesStr=NotImplemented,
            flavorParamsVersion=NotImplemented,
            flavorAssetId=NotImplemented,
            flavorAssetVersion=NotImplemented,
            readyBehavior=NotImplemented):
        KalturaFlavorParams.__init__(self,
            id,
            partnerId,
            name,
            systemName,
            description,
            createdAt,
            isSystemDefault,
            tags,
            requiredPermissions,
            sourceRemoteStorageProfileId,
            remoteStorageProfileIds,
            mediaParserType,
            sourceAssetParamsIds,
            videoCodec,
            videoBitrate,
            audioCodec,
            audioBitrate,
            audioChannels,
            audioSampleRate,
            width,
            height,
            frameRate,
            gopSize,
            conversionEngines,
            conversionEnginesExtraParams,
            twoPass,
            deinterlice,
            rotate,
            operators,
            engineVersion,
            format,
            aspectRatioProcessingMode,
            forceFrameToMultiplication16,
            isGopInSec,
            isAvoidVideoShrinkFramesizeToSource,
            isAvoidVideoShrinkBitrateToSource,
            isVideoFrameRateForLowBrAppleHls,
            multiStream,
            anamorphicPixels,
            isAvoidForcedKeyFrames,
            forcedKeyFramesMode,
            isCropIMX,
            optimizationPolicy,
            maxFrameRate,
            videoConstantBitrate,
            videoBitrateTolerance,
            watermarkData,
            subtitlesData,
            isEncrypted,
            contentAwareness,
            chunkedEncodeMode,
            clipOffset,
            clipDuration)

        # @var int
        self.flavorParamsId = flavorParamsId

        # @var string
        self.commandLinesStr = commandLinesStr

        # @var string
        self.flavorParamsVersion = flavorParamsVersion

        # @var string
        self.flavorAssetId = flavorAssetId

        # @var string
        self.flavorAssetVersion = flavorAssetVersion

        # @var int
        self.readyBehavior = readyBehavior


    PROPERTY_LOADERS = {
        'flavorParamsId': getXmlNodeInt, 
        'commandLinesStr': getXmlNodeText, 
        'flavorParamsVersion': getXmlNodeText, 
        'flavorAssetId': getXmlNodeText, 
        'flavorAssetVersion': getXmlNodeText, 
        'readyBehavior': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaFlavorParams.fromXml(self, node)
        self.fromXmlImpl(node, KalturaFlavorParamsOutput.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaFlavorParams.toParams(self)
        kparams.put("objectType", "KalturaFlavorParamsOutput")
        kparams.addIntIfDefined("flavorParamsId", self.flavorParamsId)
        kparams.addStringIfDefined("commandLinesStr", self.commandLinesStr)
        kparams.addStringIfDefined("flavorParamsVersion", self.flavorParamsVersion)
        kparams.addStringIfDefined("flavorAssetId", self.flavorAssetId)
        kparams.addStringIfDefined("flavorAssetVersion", self.flavorAssetVersion)
        kparams.addIntIfDefined("readyBehavior", self.readyBehavior)
        return kparams

    def getFlavorParamsId(self):
        return self.flavorParamsId

    def setFlavorParamsId(self, newFlavorParamsId):
        self.flavorParamsId = newFlavorParamsId

    def getCommandLinesStr(self):
        return self.commandLinesStr

    def setCommandLinesStr(self, newCommandLinesStr):
        self.commandLinesStr = newCommandLinesStr

    def getFlavorParamsVersion(self):
        return self.flavorParamsVersion

    def setFlavorParamsVersion(self, newFlavorParamsVersion):
        self.flavorParamsVersion = newFlavorParamsVersion

    def getFlavorAssetId(self):
        return self.flavorAssetId

    def setFlavorAssetId(self, newFlavorAssetId):
        self.flavorAssetId = newFlavorAssetId

    def getFlavorAssetVersion(self):
        return self.flavorAssetVersion

    def setFlavorAssetVersion(self, newFlavorAssetVersion):
        self.flavorAssetVersion = newFlavorAssetVersion

    def getReadyBehavior(self):
        return self.readyBehavior

    def setReadyBehavior(self, newReadyBehavior):
        self.readyBehavior = newReadyBehavior


# @package Kaltura
# @subpackage Client
class KalturaSchedulerStatus(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            schedulerConfiguredId=NotImplemented,
            workerConfiguredId=NotImplemented,
            workerType=NotImplemented,
            type=NotImplemented,
            value=NotImplemented,
            schedulerId=NotImplemented,
            workerId=NotImplemented):
        KalturaObjectBase.__init__(self)

        # The id of the Category
        # @var int
        # @readonly
        self.id = id

        # The configured id of the scheduler
        # @var int
        self.schedulerConfiguredId = schedulerConfiguredId

        # The configured id of the job worker
        # @var int
        self.workerConfiguredId = workerConfiguredId

        # The type of the job worker.
        # @var KalturaBatchJobType
        self.workerType = workerType

        # The status type
        # @var KalturaSchedulerStatusType
        self.type = type

        # The status value
        # @var int
        self.value = value

        # The id of the scheduler
        # @var int
        # @readonly
        self.schedulerId = schedulerId

        # The id of the worker
        # @var int
        # @readonly
        self.workerId = workerId


    PROPERTY_LOADERS = {
        'id': getXmlNodeInt, 
        'schedulerConfiguredId': getXmlNodeInt, 
        'workerConfiguredId': getXmlNodeInt, 
        'workerType': (KalturaEnumsFactory.createString, "KalturaBatchJobType"), 
        'type': (KalturaEnumsFactory.createInt, "KalturaSchedulerStatusType"), 
        'value': getXmlNodeInt, 
        'schedulerId': getXmlNodeInt, 
        'workerId': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaSchedulerStatus.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaSchedulerStatus")
        kparams.addIntIfDefined("schedulerConfiguredId", self.schedulerConfiguredId)
        kparams.addIntIfDefined("workerConfiguredId", self.workerConfiguredId)
        kparams.addStringEnumIfDefined("workerType", self.workerType)
        kparams.addIntEnumIfDefined("type", self.type)
        kparams.addIntIfDefined("value", self.value)
        return kparams

    def getId(self):
        return self.id

    def getSchedulerConfiguredId(self):
        return self.schedulerConfiguredId

    def setSchedulerConfiguredId(self, newSchedulerConfiguredId):
        self.schedulerConfiguredId = newSchedulerConfiguredId

    def getWorkerConfiguredId(self):
        return self.workerConfiguredId

    def setWorkerConfiguredId(self, newWorkerConfiguredId):
        self.workerConfiguredId = newWorkerConfiguredId

    def getWorkerType(self):
        return self.workerType

    def setWorkerType(self, newWorkerType):
        self.workerType = newWorkerType

    def getType(self):
        return self.type

    def setType(self, newType):
        self.type = newType

    def getValue(self):
        return self.value

    def setValue(self, newValue):
        self.value = newValue

    def getSchedulerId(self):
        return self.schedulerId

    def getWorkerId(self):
        return self.workerId


# @package Kaltura
# @subpackage Client
class KalturaSchedulerConfig(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            createdBy=NotImplemented,
            updatedBy=NotImplemented,
            commandId=NotImplemented,
            commandStatus=NotImplemented,
            schedulerId=NotImplemented,
            schedulerConfiguredId=NotImplemented,
            schedulerName=NotImplemented,
            workerId=NotImplemented,
            workerConfiguredId=NotImplemented,
            workerName=NotImplemented,
            variable=NotImplemented,
            variablePart=NotImplemented,
            value=NotImplemented):
        KalturaObjectBase.__init__(self)

        # The id of the Category
        # @var int
        # @readonly
        self.id = id

        # Creator name
        # @var string
        self.createdBy = createdBy

        # Updater name
        # @var string
        self.updatedBy = updatedBy

        # Id of the control panel command that created this config item
        # @var string
        self.commandId = commandId

        # The status of the control panel command
        # @var string
        self.commandStatus = commandStatus

        # The id of the scheduler
        # @var int
        self.schedulerId = schedulerId

        # The configured id of the scheduler
        # @var int
        self.schedulerConfiguredId = schedulerConfiguredId

        # The name of the scheduler
        # @var string
        self.schedulerName = schedulerName

        # The id of the job worker
        # @var int
        self.workerId = workerId

        # The configured id of the job worker
        # @var int
        self.workerConfiguredId = workerConfiguredId

        # The name of the job worker
        # @var string
        self.workerName = workerName

        # The name of the variable
        # @var string
        self.variable = variable

        # The part of the variable
        # @var string
        self.variablePart = variablePart

        # The value of the variable
        # @var string
        self.value = value


    PROPERTY_LOADERS = {
        'id': getXmlNodeInt, 
        'createdBy': getXmlNodeText, 
        'updatedBy': getXmlNodeText, 
        'commandId': getXmlNodeText, 
        'commandStatus': getXmlNodeText, 
        'schedulerId': getXmlNodeInt, 
        'schedulerConfiguredId': getXmlNodeInt, 
        'schedulerName': getXmlNodeText, 
        'workerId': getXmlNodeInt, 
        'workerConfiguredId': getXmlNodeInt, 
        'workerName': getXmlNodeText, 
        'variable': getXmlNodeText, 
        'variablePart': getXmlNodeText, 
        'value': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaSchedulerConfig.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaSchedulerConfig")
        kparams.addStringIfDefined("createdBy", self.createdBy)
        kparams.addStringIfDefined("updatedBy", self.updatedBy)
        kparams.addStringIfDefined("commandId", self.commandId)
        kparams.addStringIfDefined("commandStatus", self.commandStatus)
        kparams.addIntIfDefined("schedulerId", self.schedulerId)
        kparams.addIntIfDefined("schedulerConfiguredId", self.schedulerConfiguredId)
        kparams.addStringIfDefined("schedulerName", self.schedulerName)
        kparams.addIntIfDefined("workerId", self.workerId)
        kparams.addIntIfDefined("workerConfiguredId", self.workerConfiguredId)
        kparams.addStringIfDefined("workerName", self.workerName)
        kparams.addStringIfDefined("variable", self.variable)
        kparams.addStringIfDefined("variablePart", self.variablePart)
        kparams.addStringIfDefined("value", self.value)
        return kparams

    def getId(self):
        return self.id

    def getCreatedBy(self):
        return self.createdBy

    def setCreatedBy(self, newCreatedBy):
        self.createdBy = newCreatedBy

    def getUpdatedBy(self):
        return self.updatedBy

    def setUpdatedBy(self, newUpdatedBy):
        self.updatedBy = newUpdatedBy

    def getCommandId(self):
        return self.commandId

    def setCommandId(self, newCommandId):
        self.commandId = newCommandId

    def getCommandStatus(self):
        return self.commandStatus

    def setCommandStatus(self, newCommandStatus):
        self.commandStatus = newCommandStatus

    def getSchedulerId(self):
        return self.schedulerId

    def setSchedulerId(self, newSchedulerId):
        self.schedulerId = newSchedulerId

    def getSchedulerConfiguredId(self):
        return self.schedulerConfiguredId

    def setSchedulerConfiguredId(self, newSchedulerConfiguredId):
        self.schedulerConfiguredId = newSchedulerConfiguredId

    def getSchedulerName(self):
        return self.schedulerName

    def setSchedulerName(self, newSchedulerName):
        self.schedulerName = newSchedulerName

    def getWorkerId(self):
        return self.workerId

    def setWorkerId(self, newWorkerId):
        self.workerId = newWorkerId

    def getWorkerConfiguredId(self):
        return self.workerConfiguredId

    def setWorkerConfiguredId(self, newWorkerConfiguredId):
        self.workerConfiguredId = newWorkerConfiguredId

    def getWorkerName(self):
        return self.workerName

    def setWorkerName(self, newWorkerName):
        self.workerName = newWorkerName

    def getVariable(self):
        return self.variable

    def setVariable(self, newVariable):
        self.variable = newVariable

    def getVariablePart(self):
        return self.variablePart

    def setVariablePart(self, newVariablePart):
        self.variablePart = newVariablePart

    def getValue(self):
        return self.value

    def setValue(self, newValue):
        self.value = newValue


# @package Kaltura
# @subpackage Client
class KalturaSchedulerWorker(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            configuredId=NotImplemented,
            schedulerId=NotImplemented,
            schedulerConfiguredId=NotImplemented,
            type=NotImplemented,
            typeName=NotImplemented,
            name=NotImplemented,
            statuses=NotImplemented,
            configs=NotImplemented,
            lockedJobs=NotImplemented,
            avgWait=NotImplemented,
            avgWork=NotImplemented,
            lastStatus=NotImplemented,
            lastStatusStr=NotImplemented):
        KalturaObjectBase.__init__(self)

        # The id of the Worker
        # @var int
        # @readonly
        self.id = id

        # The id as configured in the batch config
        # @var int
        self.configuredId = configuredId

        # The id of the Scheduler
        # @var int
        self.schedulerId = schedulerId

        # The id of the scheduler as configured in the batch config
        # @var int
        self.schedulerConfiguredId = schedulerConfiguredId

        # The worker type
        # @var KalturaBatchJobType
        self.type = type

        # The friendly name of the type
        # @var string
        self.typeName = typeName

        # The scheduler name
        # @var string
        self.name = name

        # Array of the last statuses
        # @var array of KalturaSchedulerStatus
        self.statuses = statuses

        # Array of the last configs
        # @var array of KalturaSchedulerConfig
        self.configs = configs

        # Array of jobs that locked to this worker
        # @var array of KalturaBatchJob
        self.lockedJobs = lockedJobs

        # Avarage time between creation and queue time
        # @var int
        self.avgWait = avgWait

        # Avarage time between queue time end finish time
        # @var int
        self.avgWork = avgWork

        # last status time
        # @var int
        self.lastStatus = lastStatus

        # last status formated
        # @var string
        self.lastStatusStr = lastStatusStr


    PROPERTY_LOADERS = {
        'id': getXmlNodeInt, 
        'configuredId': getXmlNodeInt, 
        'schedulerId': getXmlNodeInt, 
        'schedulerConfiguredId': getXmlNodeInt, 
        'type': (KalturaEnumsFactory.createString, "KalturaBatchJobType"), 
        'typeName': getXmlNodeText, 
        'name': getXmlNodeText, 
        'statuses': (KalturaObjectFactory.createArray, 'KalturaSchedulerStatus'), 
        'configs': (KalturaObjectFactory.createArray, 'KalturaSchedulerConfig'), 
        'lockedJobs': (KalturaObjectFactory.createArray, 'KalturaBatchJob'), 
        'avgWait': getXmlNodeInt, 
        'avgWork': getXmlNodeInt, 
        'lastStatus': getXmlNodeInt, 
        'lastStatusStr': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaSchedulerWorker.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaSchedulerWorker")
        kparams.addIntIfDefined("configuredId", self.configuredId)
        kparams.addIntIfDefined("schedulerId", self.schedulerId)
        kparams.addIntIfDefined("schedulerConfiguredId", self.schedulerConfiguredId)
        kparams.addStringEnumIfDefined("type", self.type)
        kparams.addStringIfDefined("typeName", self.typeName)
        kparams.addStringIfDefined("name", self.name)
        kparams.addArrayIfDefined("statuses", self.statuses)
        kparams.addArrayIfDefined("configs", self.configs)
        kparams.addArrayIfDefined("lockedJobs", self.lockedJobs)
        kparams.addIntIfDefined("avgWait", self.avgWait)
        kparams.addIntIfDefined("avgWork", self.avgWork)
        kparams.addIntIfDefined("lastStatus", self.lastStatus)
        kparams.addStringIfDefined("lastStatusStr", self.lastStatusStr)
        return kparams

    def getId(self):
        return self.id

    def getConfiguredId(self):
        return self.configuredId

    def setConfiguredId(self, newConfiguredId):
        self.configuredId = newConfiguredId

    def getSchedulerId(self):
        return self.schedulerId

    def setSchedulerId(self, newSchedulerId):
        self.schedulerId = newSchedulerId

    def getSchedulerConfiguredId(self):
        return self.schedulerConfiguredId

    def setSchedulerConfiguredId(self, newSchedulerConfiguredId):
        self.schedulerConfiguredId = newSchedulerConfiguredId

    def getType(self):
        return self.type

    def setType(self, newType):
        self.type = newType

    def getTypeName(self):
        return self.typeName

    def setTypeName(self, newTypeName):
        self.typeName = newTypeName

    def getName(self):
        return self.name

    def setName(self, newName):
        self.name = newName

    def getStatuses(self):
        return self.statuses

    def setStatuses(self, newStatuses):
        self.statuses = newStatuses

    def getConfigs(self):
        return self.configs

    def setConfigs(self, newConfigs):
        self.configs = newConfigs

    def getLockedJobs(self):
        return self.lockedJobs

    def setLockedJobs(self, newLockedJobs):
        self.lockedJobs = newLockedJobs

    def getAvgWait(self):
        return self.avgWait

    def setAvgWait(self, newAvgWait):
        self.avgWait = newAvgWait

    def getAvgWork(self):
        return self.avgWork

    def setAvgWork(self, newAvgWork):
        self.avgWork = newAvgWork

    def getLastStatus(self):
        return self.lastStatus

    def setLastStatus(self, newLastStatus):
        self.lastStatus = newLastStatus

    def getLastStatusStr(self):
        return self.lastStatusStr

    def setLastStatusStr(self, newLastStatusStr):
        self.lastStatusStr = newLastStatusStr


# @package Kaltura
# @subpackage Client
class KalturaScheduler(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            configuredId=NotImplemented,
            name=NotImplemented,
            host=NotImplemented,
            statuses=NotImplemented,
            configs=NotImplemented,
            workers=NotImplemented,
            createdAt=NotImplemented,
            lastStatus=NotImplemented,
            lastStatusStr=NotImplemented):
        KalturaObjectBase.__init__(self)

        # The id of the Scheduler
        # @var int
        # @readonly
        self.id = id

        # The id as configured in the batch config
        # @var int
        self.configuredId = configuredId

        # The scheduler name
        # @var string
        self.name = name

        # The host name
        # @var string
        self.host = host

        # Array of the last statuses
        # @var array of KalturaSchedulerStatus
        # @readonly
        self.statuses = statuses

        # Array of the last configs
        # @var array of KalturaSchedulerConfig
        # @readonly
        self.configs = configs

        # Array of the workers
        # @var array of KalturaSchedulerWorker
        # @readonly
        self.workers = workers

        # creation time
        # @var int
        # @readonly
        self.createdAt = createdAt

        # last status time
        # @var int
        # @readonly
        self.lastStatus = lastStatus

        # last status formated
        # @var string
        # @readonly
        self.lastStatusStr = lastStatusStr


    PROPERTY_LOADERS = {
        'id': getXmlNodeInt, 
        'configuredId': getXmlNodeInt, 
        'name': getXmlNodeText, 
        'host': getXmlNodeText, 
        'statuses': (KalturaObjectFactory.createArray, 'KalturaSchedulerStatus'), 
        'configs': (KalturaObjectFactory.createArray, 'KalturaSchedulerConfig'), 
        'workers': (KalturaObjectFactory.createArray, 'KalturaSchedulerWorker'), 
        'createdAt': getXmlNodeInt, 
        'lastStatus': getXmlNodeInt, 
        'lastStatusStr': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaScheduler.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaScheduler")
        kparams.addIntIfDefined("configuredId", self.configuredId)
        kparams.addStringIfDefined("name", self.name)
        kparams.addStringIfDefined("host", self.host)
        return kparams

    def getId(self):
        return self.id

    def getConfiguredId(self):
        return self.configuredId

    def setConfiguredId(self, newConfiguredId):
        self.configuredId = newConfiguredId

    def getName(self):
        return self.name

    def setName(self, newName):
        self.name = newName

    def getHost(self):
        return self.host

    def setHost(self, newHost):
        self.host = newHost

    def getStatuses(self):
        return self.statuses

    def getConfigs(self):
        return self.configs

    def getWorkers(self):
        return self.workers

    def getCreatedAt(self):
        return self.createdAt

    def getLastStatus(self):
        return self.lastStatus

    def getLastStatusStr(self):
        return self.lastStatusStr


# @package Kaltura
# @subpackage Client
class KalturaGroupUser(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            userId=NotImplemented,
            groupId=NotImplemented,
            status=NotImplemented,
            partnerId=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented,
            creationMode=NotImplemented,
            userRole=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        # @readonly
        self.id = id

        # @var string
        # @insertonly
        self.userId = userId

        # @var string
        # @insertonly
        self.groupId = groupId

        # @var KalturaGroupUserStatus
        # @readonly
        self.status = status

        # @var int
        # @readonly
        self.partnerId = partnerId

        # Creation date as Unix timestamp (In seconds)
        # @var int
        # @readonly
        self.createdAt = createdAt

        # Last update date as Unix timestamp (In seconds)
        # @var int
        # @readonly
        self.updatedAt = updatedAt

        # @var KalturaGroupUserCreationMode
        # @insertonly
        self.creationMode = creationMode

        # @var KalturaGroupUserRole
        self.userRole = userRole


    PROPERTY_LOADERS = {
        'id': getXmlNodeText, 
        'userId': getXmlNodeText, 
        'groupId': getXmlNodeText, 
        'status': (KalturaEnumsFactory.createInt, "KalturaGroupUserStatus"), 
        'partnerId': getXmlNodeInt, 
        'createdAt': getXmlNodeInt, 
        'updatedAt': getXmlNodeInt, 
        'creationMode': (KalturaEnumsFactory.createInt, "KalturaGroupUserCreationMode"), 
        'userRole': (KalturaEnumsFactory.createInt, "KalturaGroupUserRole"), 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaGroupUser.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaGroupUser")
        kparams.addStringIfDefined("userId", self.userId)
        kparams.addStringIfDefined("groupId", self.groupId)
        kparams.addIntEnumIfDefined("creationMode", self.creationMode)
        kparams.addIntEnumIfDefined("userRole", self.userRole)
        return kparams

    def getId(self):
        return self.id

    def getUserId(self):
        return self.userId

    def setUserId(self, newUserId):
        self.userId = newUserId

    def getGroupId(self):
        return self.groupId

    def setGroupId(self, newGroupId):
        self.groupId = newGroupId

    def getStatus(self):
        return self.status

    def getPartnerId(self):
        return self.partnerId

    def getCreatedAt(self):
        return self.createdAt

    def getUpdatedAt(self):
        return self.updatedAt

    def getCreationMode(self):
        return self.creationMode

    def setCreationMode(self, newCreationMode):
        self.creationMode = newCreationMode

    def getUserRole(self):
        return self.userRole

    def setUserRole(self, newUserRole):
        self.userRole = newUserRole


# @package Kaltura
# @subpackage Client
class KalturaObject(KalturaObjectBase):
    def __init__(self,
            relatedObjects=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var map
        # @readonly
        self.relatedObjects = relatedObjects


    PROPERTY_LOADERS = {
        'relatedObjects': (KalturaObjectFactory.createMap, 'KalturaListResponse'), 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaObject.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaObject")
        return kparams

    def getRelatedObjects(self):
        return self.relatedObjects


# @package Kaltura
# @subpackage Client
class KalturaIntegerValue(KalturaValue):
    """An int representation to return an array of ints"""

    def __init__(self,
            description=NotImplemented,
            value=NotImplemented):
        KalturaValue.__init__(self,
            description)

        # @var int
        self.value = value


    PROPERTY_LOADERS = {
        'value': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaValue.fromXml(self, node)
        self.fromXmlImpl(node, KalturaIntegerValue.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaValue.toParams(self)
        kparams.put("objectType", "KalturaIntegerValue")
        kparams.addIntIfDefined("value", self.value)
        return kparams

    def getValue(self):
        return self.value

    def setValue(self, newValue):
        self.value = newValue


# @package Kaltura
# @subpackage Client
class KalturaBatchJobListResponse(KalturaListResponse):
    def __init__(self,
            totalCount=NotImplemented,
            objects=NotImplemented):
        KalturaListResponse.__init__(self,
            totalCount)

        # @var array of KalturaBatchJob
        # @readonly
        self.objects = objects


    PROPERTY_LOADERS = {
        'objects': (KalturaObjectFactory.createArray, 'KalturaBatchJob'), 
    }

    def fromXml(self, node):
        KalturaListResponse.fromXml(self, node)
        self.fromXmlImpl(node, KalturaBatchJobListResponse.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaListResponse.toParams(self)
        kparams.put("objectType", "KalturaBatchJobListResponse")
        return kparams

    def getObjects(self):
        return self.objects


# @package Kaltura
# @subpackage Client
class KalturaMediaInfo(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            flavorAssetId=NotImplemented,
            fileSize=NotImplemented,
            containerFormat=NotImplemented,
            containerId=NotImplemented,
            containerProfile=NotImplemented,
            containerDuration=NotImplemented,
            containerBitRate=NotImplemented,
            videoFormat=NotImplemented,
            videoCodecId=NotImplemented,
            videoDuration=NotImplemented,
            videoBitRate=NotImplemented,
            videoBitRateMode=NotImplemented,
            videoWidth=NotImplemented,
            videoHeight=NotImplemented,
            videoFrameRate=NotImplemented,
            videoDar=NotImplemented,
            videoRotation=NotImplemented,
            audioFormat=NotImplemented,
            audioCodecId=NotImplemented,
            audioDuration=NotImplemented,
            audioBitRate=NotImplemented,
            audioBitRateMode=NotImplemented,
            audioChannels=NotImplemented,
            audioSamplingRate=NotImplemented,
            audioResolution=NotImplemented,
            writingLib=NotImplemented,
            rawData=NotImplemented,
            multiStreamInfo=NotImplemented,
            scanType=NotImplemented,
            multiStream=NotImplemented,
            isFastStart=NotImplemented,
            contentStreams=NotImplemented,
            complexityValue=NotImplemented,
            maxGOP=NotImplemented,
            matrixCoefficients=NotImplemented,
            colorTransfer=NotImplemented,
            colorPrimaries=NotImplemented,
            pixelFormat=NotImplemented,
            colorSpace=NotImplemented,
            chromaSubsampling=NotImplemented,
            bitsDepth=NotImplemented):
        KalturaObjectBase.__init__(self)

        # The id of the media info
        # @var int
        # @readonly
        self.id = id

        # The id of the related flavor asset
        # @var string
        self.flavorAssetId = flavorAssetId

        # The file size
        # @var int
        self.fileSize = fileSize

        # The container format
        # @var string
        self.containerFormat = containerFormat

        # The container id
        # @var string
        self.containerId = containerId

        # The container profile
        # @var string
        self.containerProfile = containerProfile

        # The container duration
        # @var int
        self.containerDuration = containerDuration

        # The container bit rate
        # @var int
        self.containerBitRate = containerBitRate

        # The video format
        # @var string
        self.videoFormat = videoFormat

        # The video codec id
        # @var string
        self.videoCodecId = videoCodecId

        # The video duration
        # @var int
        self.videoDuration = videoDuration

        # The video bit rate
        # @var int
        self.videoBitRate = videoBitRate

        # The video bit rate mode
        # @var KalturaBitRateMode
        self.videoBitRateMode = videoBitRateMode

        # The video width
        # @var int
        self.videoWidth = videoWidth

        # The video height
        # @var int
        self.videoHeight = videoHeight

        # The video frame rate
        # @var float
        self.videoFrameRate = videoFrameRate

        # The video display aspect ratio (dar)
        # @var float
        self.videoDar = videoDar

        # @var int
        self.videoRotation = videoRotation

        # The audio format
        # @var string
        self.audioFormat = audioFormat

        # The audio codec id
        # @var string
        self.audioCodecId = audioCodecId

        # The audio duration
        # @var int
        self.audioDuration = audioDuration

        # The audio bit rate
        # @var int
        self.audioBitRate = audioBitRate

        # The audio bit rate mode
        # @var KalturaBitRateMode
        self.audioBitRateMode = audioBitRateMode

        # The number of audio channels
        # @var int
        self.audioChannels = audioChannels

        # The audio sampling rate
        # @var int
        self.audioSamplingRate = audioSamplingRate

        # The audio resolution
        # @var int
        self.audioResolution = audioResolution

        # The writing library
        # @var string
        self.writingLib = writingLib

        # The data as returned by the mediainfo command line
        # @var string
        self.rawData = rawData

        # @var string
        self.multiStreamInfo = multiStreamInfo

        # @var int
        self.scanType = scanType

        # @var string
        self.multiStream = multiStream

        # @var int
        self.isFastStart = isFastStart

        # @var string
        self.contentStreams = contentStreams

        # @var int
        self.complexityValue = complexityValue

        # @var float
        self.maxGOP = maxGOP

        # @var string
        self.matrixCoefficients = matrixCoefficients

        # @var string
        self.colorTransfer = colorTransfer

        # @var string
        self.colorPrimaries = colorPrimaries

        # @var string
        self.pixelFormat = pixelFormat

        # @var string
        self.colorSpace = colorSpace

        # @var string
        self.chromaSubsampling = chromaSubsampling

        # @var int
        self.bitsDepth = bitsDepth


    PROPERTY_LOADERS = {
        'id': getXmlNodeInt, 
        'flavorAssetId': getXmlNodeText, 
        'fileSize': getXmlNodeInt, 
        'containerFormat': getXmlNodeText, 
        'containerId': getXmlNodeText, 
        'containerProfile': getXmlNodeText, 
        'containerDuration': getXmlNodeInt, 
        'containerBitRate': getXmlNodeInt, 
        'videoFormat': getXmlNodeText, 
        'videoCodecId': getXmlNodeText, 
        'videoDuration': getXmlNodeInt, 
        'videoBitRate': getXmlNodeInt, 
        'videoBitRateMode': (KalturaEnumsFactory.createInt, "KalturaBitRateMode"), 
        'videoWidth': getXmlNodeInt, 
        'videoHeight': getXmlNodeInt, 
        'videoFrameRate': getXmlNodeFloat, 
        'videoDar': getXmlNodeFloat, 
        'videoRotation': getXmlNodeInt, 
        'audioFormat': getXmlNodeText, 
        'audioCodecId': getXmlNodeText, 
        'audioDuration': getXmlNodeInt, 
        'audioBitRate': getXmlNodeInt, 
        'audioBitRateMode': (KalturaEnumsFactory.createInt, "KalturaBitRateMode"), 
        'audioChannels': getXmlNodeInt, 
        'audioSamplingRate': getXmlNodeInt, 
        'audioResolution': getXmlNodeInt, 
        'writingLib': getXmlNodeText, 
        'rawData': getXmlNodeText, 
        'multiStreamInfo': getXmlNodeText, 
        'scanType': getXmlNodeInt, 
        'multiStream': getXmlNodeText, 
        'isFastStart': getXmlNodeInt, 
        'contentStreams': getXmlNodeText, 
        'complexityValue': getXmlNodeInt, 
        'maxGOP': getXmlNodeFloat, 
        'matrixCoefficients': getXmlNodeText, 
        'colorTransfer': getXmlNodeText, 
        'colorPrimaries': getXmlNodeText, 
        'pixelFormat': getXmlNodeText, 
        'colorSpace': getXmlNodeText, 
        'chromaSubsampling': getXmlNodeText, 
        'bitsDepth': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaMediaInfo.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaMediaInfo")
        kparams.addStringIfDefined("flavorAssetId", self.flavorAssetId)
        kparams.addIntIfDefined("fileSize", self.fileSize)
        kparams.addStringIfDefined("containerFormat", self.containerFormat)
        kparams.addStringIfDefined("containerId", self.containerId)
        kparams.addStringIfDefined("containerProfile", self.containerProfile)
        kparams.addIntIfDefined("containerDuration", self.containerDuration)
        kparams.addIntIfDefined("containerBitRate", self.containerBitRate)
        kparams.addStringIfDefined("videoFormat", self.videoFormat)
        kparams.addStringIfDefined("videoCodecId", self.videoCodecId)
        kparams.addIntIfDefined("videoDuration", self.videoDuration)
        kparams.addIntIfDefined("videoBitRate", self.videoBitRate)
        kparams.addIntEnumIfDefined("videoBitRateMode", self.videoBitRateMode)
        kparams.addIntIfDefined("videoWidth", self.videoWidth)
        kparams.addIntIfDefined("videoHeight", self.videoHeight)
        kparams.addFloatIfDefined("videoFrameRate", self.videoFrameRate)
        kparams.addFloatIfDefined("videoDar", self.videoDar)
        kparams.addIntIfDefined("videoRotation", self.videoRotation)
        kparams.addStringIfDefined("audioFormat", self.audioFormat)
        kparams.addStringIfDefined("audioCodecId", self.audioCodecId)
        kparams.addIntIfDefined("audioDuration", self.audioDuration)
        kparams.addIntIfDefined("audioBitRate", self.audioBitRate)
        kparams.addIntEnumIfDefined("audioBitRateMode", self.audioBitRateMode)
        kparams.addIntIfDefined("audioChannels", self.audioChannels)
        kparams.addIntIfDefined("audioSamplingRate", self.audioSamplingRate)
        kparams.addIntIfDefined("audioResolution", self.audioResolution)
        kparams.addStringIfDefined("writingLib", self.writingLib)
        kparams.addStringIfDefined("rawData", self.rawData)
        kparams.addStringIfDefined("multiStreamInfo", self.multiStreamInfo)
        kparams.addIntIfDefined("scanType", self.scanType)
        kparams.addStringIfDefined("multiStream", self.multiStream)
        kparams.addIntIfDefined("isFastStart", self.isFastStart)
        kparams.addStringIfDefined("contentStreams", self.contentStreams)
        kparams.addIntIfDefined("complexityValue", self.complexityValue)
        kparams.addFloatIfDefined("maxGOP", self.maxGOP)
        kparams.addStringIfDefined("matrixCoefficients", self.matrixCoefficients)
        kparams.addStringIfDefined("colorTransfer", self.colorTransfer)
        kparams.addStringIfDefined("colorPrimaries", self.colorPrimaries)
        kparams.addStringIfDefined("pixelFormat", self.pixelFormat)
        kparams.addStringIfDefined("colorSpace", self.colorSpace)
        kparams.addStringIfDefined("chromaSubsampling", self.chromaSubsampling)
        kparams.addIntIfDefined("bitsDepth", self.bitsDepth)
        return kparams

    def getId(self):
        return self.id

    def getFlavorAssetId(self):
        return self.flavorAssetId

    def setFlavorAssetId(self, newFlavorAssetId):
        self.flavorAssetId = newFlavorAssetId

    def getFileSize(self):
        return self.fileSize

    def setFileSize(self, newFileSize):
        self.fileSize = newFileSize

    def getContainerFormat(self):
        return self.containerFormat

    def setContainerFormat(self, newContainerFormat):
        self.containerFormat = newContainerFormat

    def getContainerId(self):
        return self.containerId

    def setContainerId(self, newContainerId):
        self.containerId = newContainerId

    def getContainerProfile(self):
        return self.containerProfile

    def setContainerProfile(self, newContainerProfile):
        self.containerProfile = newContainerProfile

    def getContainerDuration(self):
        return self.containerDuration

    def setContainerDuration(self, newContainerDuration):
        self.containerDuration = newContainerDuration

    def getContainerBitRate(self):
        return self.containerBitRate

    def setContainerBitRate(self, newContainerBitRate):
        self.containerBitRate = newContainerBitRate

    def getVideoFormat(self):
        return self.videoFormat

    def setVideoFormat(self, newVideoFormat):
        self.videoFormat = newVideoFormat

    def getVideoCodecId(self):
        return self.videoCodecId

    def setVideoCodecId(self, newVideoCodecId):
        self.videoCodecId = newVideoCodecId

    def getVideoDuration(self):
        return self.videoDuration

    def setVideoDuration(self, newVideoDuration):
        self.videoDuration = newVideoDuration

    def getVideoBitRate(self):
        return self.videoBitRate

    def setVideoBitRate(self, newVideoBitRate):
        self.videoBitRate = newVideoBitRate

    def getVideoBitRateMode(self):
        return self.videoBitRateMode

    def setVideoBitRateMode(self, newVideoBitRateMode):
        self.videoBitRateMode = newVideoBitRateMode

    def getVideoWidth(self):
        return self.videoWidth

    def setVideoWidth(self, newVideoWidth):
        self.videoWidth = newVideoWidth

    def getVideoHeight(self):
        return self.videoHeight

    def setVideoHeight(self, newVideoHeight):
        self.videoHeight = newVideoHeight

    def getVideoFrameRate(self):
        return self.videoFrameRate

    def setVideoFrameRate(self, newVideoFrameRate):
        self.videoFrameRate = newVideoFrameRate

    def getVideoDar(self):
        return self.videoDar

    def setVideoDar(self, newVideoDar):
        self.videoDar = newVideoDar

    def getVideoRotation(self):
        return self.videoRotation

    def setVideoRotation(self, newVideoRotation):
        self.videoRotation = newVideoRotation

    def getAudioFormat(self):
        return self.audioFormat

    def setAudioFormat(self, newAudioFormat):
        self.audioFormat = newAudioFormat

    def getAudioCodecId(self):
        return self.audioCodecId

    def setAudioCodecId(self, newAudioCodecId):
        self.audioCodecId = newAudioCodecId

    def getAudioDuration(self):
        return self.audioDuration

    def setAudioDuration(self, newAudioDuration):
        self.audioDuration = newAudioDuration

    def getAudioBitRate(self):
        return self.audioBitRate

    def setAudioBitRate(self, newAudioBitRate):
        self.audioBitRate = newAudioBitRate

    def getAudioBitRateMode(self):
        return self.audioBitRateMode

    def setAudioBitRateMode(self, newAudioBitRateMode):
        self.audioBitRateMode = newAudioBitRateMode

    def getAudioChannels(self):
        return self.audioChannels

    def setAudioChannels(self, newAudioChannels):
        self.audioChannels = newAudioChannels

    def getAudioSamplingRate(self):
        return self.audioSamplingRate

    def setAudioSamplingRate(self, newAudioSamplingRate):
        self.audioSamplingRate = newAudioSamplingRate

    def getAudioResolution(self):
        return self.audioResolution

    def setAudioResolution(self, newAudioResolution):
        self.audioResolution = newAudioResolution

    def getWritingLib(self):
        return self.writingLib

    def setWritingLib(self, newWritingLib):
        self.writingLib = newWritingLib

    def getRawData(self):
        return self.rawData

    def setRawData(self, newRawData):
        self.rawData = newRawData

    def getMultiStreamInfo(self):
        return self.multiStreamInfo

    def setMultiStreamInfo(self, newMultiStreamInfo):
        self.multiStreamInfo = newMultiStreamInfo

    def getScanType(self):
        return self.scanType

    def setScanType(self, newScanType):
        self.scanType = newScanType

    def getMultiStream(self):
        return self.multiStream

    def setMultiStream(self, newMultiStream):
        self.multiStream = newMultiStream

    def getIsFastStart(self):
        return self.isFastStart

    def setIsFastStart(self, newIsFastStart):
        self.isFastStart = newIsFastStart

    def getContentStreams(self):
        return self.contentStreams

    def setContentStreams(self, newContentStreams):
        self.contentStreams = newContentStreams

    def getComplexityValue(self):
        return self.complexityValue

    def setComplexityValue(self, newComplexityValue):
        self.complexityValue = newComplexityValue

    def getMaxGOP(self):
        return self.maxGOP

    def setMaxGOP(self, newMaxGOP):
        self.maxGOP = newMaxGOP

    def getMatrixCoefficients(self):
        return self.matrixCoefficients

    def setMatrixCoefficients(self, newMatrixCoefficients):
        self.matrixCoefficients = newMatrixCoefficients

    def getColorTransfer(self):
        return self.colorTransfer

    def setColorTransfer(self, newColorTransfer):
        self.colorTransfer = newColorTransfer

    def getColorPrimaries(self):
        return self.colorPrimaries

    def setColorPrimaries(self, newColorPrimaries):
        self.colorPrimaries = newColorPrimaries

    def getPixelFormat(self):
        return self.pixelFormat

    def setPixelFormat(self, newPixelFormat):
        self.pixelFormat = newPixelFormat

    def getColorSpace(self):
        return self.colorSpace

    def setColorSpace(self, newColorSpace):
        self.colorSpace = newColorSpace

    def getChromaSubsampling(self):
        return self.chromaSubsampling

    def setChromaSubsampling(self, newChromaSubsampling):
        self.chromaSubsampling = newChromaSubsampling

    def getBitsDepth(self):
        return self.bitsDepth

    def setBitsDepth(self, newBitsDepth):
        self.bitsDepth = newBitsDepth


# @package Kaltura
# @subpackage Client
class KalturaMediaInfoListResponse(KalturaListResponse):
    def __init__(self,
            totalCount=NotImplemented,
            objects=NotImplemented):
        KalturaListResponse.__init__(self,
            totalCount)

        # @var array of KalturaMediaInfo
        # @readonly
        self.objects = objects


    PROPERTY_LOADERS = {
        'objects': (KalturaObjectFactory.createArray, 'KalturaMediaInfo'), 
    }

    def fromXml(self, node):
        KalturaListResponse.fromXml(self, node)
        self.fromXmlImpl(node, KalturaMediaInfoListResponse.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaListResponse.toParams(self)
        kparams.put("objectType", "KalturaMediaInfoListResponse")
        return kparams

    def getObjects(self):
        return self.objects


# @package Kaltura
# @subpackage Client
class KalturaFlavorParamsOutputListResponse(KalturaListResponse):
    def __init__(self,
            totalCount=NotImplemented,
            objects=NotImplemented):
        KalturaListResponse.__init__(self,
            totalCount)

        # @var array of KalturaFlavorParamsOutput
        # @readonly
        self.objects = objects


    PROPERTY_LOADERS = {
        'objects': (KalturaObjectFactory.createArray, 'KalturaFlavorParamsOutput'), 
    }

    def fromXml(self, node):
        KalturaListResponse.fromXml(self, node)
        self.fromXmlImpl(node, KalturaFlavorParamsOutputListResponse.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaListResponse.toParams(self)
        kparams.put("objectType", "KalturaFlavorParamsOutputListResponse")
        return kparams

    def getObjects(self):
        return self.objects


# @package Kaltura
# @subpackage Client
class KalturaThumbAsset(KalturaAsset):
    def __init__(self,
            id=NotImplemented,
            entryId=NotImplemented,
            partnerId=NotImplemented,
            version=NotImplemented,
            size=NotImplemented,
            tags=NotImplemented,
            fileExt=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented,
            deletedAt=NotImplemented,
            description=NotImplemented,
            partnerData=NotImplemented,
            partnerDescription=NotImplemented,
            actualSourceAssetParamsIds=NotImplemented,
            sizeInBytes=NotImplemented,
            thumbParamsId=NotImplemented,
            width=NotImplemented,
            height=NotImplemented,
            status=NotImplemented):
        KalturaAsset.__init__(self,
            id,
            entryId,
            partnerId,
            version,
            size,
            tags,
            fileExt,
            createdAt,
            updatedAt,
            deletedAt,
            description,
            partnerData,
            partnerDescription,
            actualSourceAssetParamsIds,
            sizeInBytes)

        # The Flavor Params used to create this Flavor Asset
        # @var int
        # @insertonly
        self.thumbParamsId = thumbParamsId

        # The width of the Flavor Asset
        # @var int
        # @readonly
        self.width = width

        # The height of the Flavor Asset
        # @var int
        # @readonly
        self.height = height

        # The status of the asset
        # @var KalturaThumbAssetStatus
        # @readonly
        self.status = status


    PROPERTY_LOADERS = {
        'thumbParamsId': getXmlNodeInt, 
        'width': getXmlNodeInt, 
        'height': getXmlNodeInt, 
        'status': (KalturaEnumsFactory.createInt, "KalturaThumbAssetStatus"), 
    }

    def fromXml(self, node):
        KalturaAsset.fromXml(self, node)
        self.fromXmlImpl(node, KalturaThumbAsset.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaAsset.toParams(self)
        kparams.put("objectType", "KalturaThumbAsset")
        kparams.addIntIfDefined("thumbParamsId", self.thumbParamsId)
        return kparams

    def getThumbParamsId(self):
        return self.thumbParamsId

    def setThumbParamsId(self, newThumbParamsId):
        self.thumbParamsId = newThumbParamsId

    def getWidth(self):
        return self.width

    def getHeight(self):
        return self.height

    def getStatus(self):
        return self.status


# @package Kaltura
# @subpackage Client
class KalturaThumbParams(KalturaAssetParams):
    def __init__(self,
            id=NotImplemented,
            partnerId=NotImplemented,
            name=NotImplemented,
            systemName=NotImplemented,
            description=NotImplemented,
            createdAt=NotImplemented,
            isSystemDefault=NotImplemented,
            tags=NotImplemented,
            requiredPermissions=NotImplemented,
            sourceRemoteStorageProfileId=NotImplemented,
            remoteStorageProfileIds=NotImplemented,
            mediaParserType=NotImplemented,
            sourceAssetParamsIds=NotImplemented,
            cropType=NotImplemented,
            quality=NotImplemented,
            cropX=NotImplemented,
            cropY=NotImplemented,
            cropWidth=NotImplemented,
            cropHeight=NotImplemented,
            videoOffset=NotImplemented,
            width=NotImplemented,
            height=NotImplemented,
            scaleWidth=NotImplemented,
            scaleHeight=NotImplemented,
            backgroundColor=NotImplemented,
            sourceParamsId=NotImplemented,
            format=NotImplemented,
            density=NotImplemented,
            stripProfiles=NotImplemented,
            videoOffsetInPercentage=NotImplemented,
            interval=NotImplemented):
        KalturaAssetParams.__init__(self,
            id,
            partnerId,
            name,
            systemName,
            description,
            createdAt,
            isSystemDefault,
            tags,
            requiredPermissions,
            sourceRemoteStorageProfileId,
            remoteStorageProfileIds,
            mediaParserType,
            sourceAssetParamsIds)

        # @var KalturaThumbCropType
        self.cropType = cropType

        # @var int
        self.quality = quality

        # @var int
        self.cropX = cropX

        # @var int
        self.cropY = cropY

        # @var int
        self.cropWidth = cropWidth

        # @var int
        self.cropHeight = cropHeight

        # @var float
        self.videoOffset = videoOffset

        # @var int
        self.width = width

        # @var int
        self.height = height

        # @var float
        self.scaleWidth = scaleWidth

        # @var float
        self.scaleHeight = scaleHeight

        # Hexadecimal value
        # @var string
        self.backgroundColor = backgroundColor

        # Id of the flavor params or the thumbnail params to be used as source for the thumbnail creation
        # @var int
        self.sourceParamsId = sourceParamsId

        # The container format of the Flavor Params
        # @var KalturaContainerFormat
        self.format = format

        # The image density (dpi) for example: 72 or 96
        # @var int
        self.density = density

        # Strip profiles and comments
        # @var bool
        self.stripProfiles = stripProfiles

        # Create thumbnail from the videoLengthpercentage second
        # @var int
        self.videoOffsetInPercentage = videoOffsetInPercentage

        # interval in seconds for creating thumbnail
        # @var int
        self.interval = interval


    PROPERTY_LOADERS = {
        'cropType': (KalturaEnumsFactory.createInt, "KalturaThumbCropType"), 
        'quality': getXmlNodeInt, 
        'cropX': getXmlNodeInt, 
        'cropY': getXmlNodeInt, 
        'cropWidth': getXmlNodeInt, 
        'cropHeight': getXmlNodeInt, 
        'videoOffset': getXmlNodeFloat, 
        'width': getXmlNodeInt, 
        'height': getXmlNodeInt, 
        'scaleWidth': getXmlNodeFloat, 
        'scaleHeight': getXmlNodeFloat, 
        'backgroundColor': getXmlNodeText, 
        'sourceParamsId': getXmlNodeInt, 
        'format': (KalturaEnumsFactory.createString, "KalturaContainerFormat"), 
        'density': getXmlNodeInt, 
        'stripProfiles': getXmlNodeBool, 
        'videoOffsetInPercentage': getXmlNodeInt, 
        'interval': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaAssetParams.fromXml(self, node)
        self.fromXmlImpl(node, KalturaThumbParams.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaAssetParams.toParams(self)
        kparams.put("objectType", "KalturaThumbParams")
        kparams.addIntEnumIfDefined("cropType", self.cropType)
        kparams.addIntIfDefined("quality", self.quality)
        kparams.addIntIfDefined("cropX", self.cropX)
        kparams.addIntIfDefined("cropY", self.cropY)
        kparams.addIntIfDefined("cropWidth", self.cropWidth)
        kparams.addIntIfDefined("cropHeight", self.cropHeight)
        kparams.addFloatIfDefined("videoOffset", self.videoOffset)
        kparams.addIntIfDefined("width", self.width)
        kparams.addIntIfDefined("height", self.height)
        kparams.addFloatIfDefined("scaleWidth", self.scaleWidth)
        kparams.addFloatIfDefined("scaleHeight", self.scaleHeight)
        kparams.addStringIfDefined("backgroundColor", self.backgroundColor)
        kparams.addIntIfDefined("sourceParamsId", self.sourceParamsId)
        kparams.addStringEnumIfDefined("format", self.format)
        kparams.addIntIfDefined("density", self.density)
        kparams.addBoolIfDefined("stripProfiles", self.stripProfiles)
        kparams.addIntIfDefined("videoOffsetInPercentage", self.videoOffsetInPercentage)
        kparams.addIntIfDefined("interval", self.interval)
        return kparams

    def getCropType(self):
        return self.cropType

    def setCropType(self, newCropType):
        self.cropType = newCropType

    def getQuality(self):
        return self.quality

    def setQuality(self, newQuality):
        self.quality = newQuality

    def getCropX(self):
        return self.cropX

    def setCropX(self, newCropX):
        self.cropX = newCropX

    def getCropY(self):
        return self.cropY

    def setCropY(self, newCropY):
        self.cropY = newCropY

    def getCropWidth(self):
        return self.cropWidth

    def setCropWidth(self, newCropWidth):
        self.cropWidth = newCropWidth

    def getCropHeight(self):
        return self.cropHeight

    def setCropHeight(self, newCropHeight):
        self.cropHeight = newCropHeight

    def getVideoOffset(self):
        return self.videoOffset

    def setVideoOffset(self, newVideoOffset):
        self.videoOffset = newVideoOffset

    def getWidth(self):
        return self.width

    def setWidth(self, newWidth):
        self.width = newWidth

    def getHeight(self):
        return self.height

    def setHeight(self, newHeight):
        self.height = newHeight

    def getScaleWidth(self):
        return self.scaleWidth

    def setScaleWidth(self, newScaleWidth):
        self.scaleWidth = newScaleWidth

    def getScaleHeight(self):
        return self.scaleHeight

    def setScaleHeight(self, newScaleHeight):
        self.scaleHeight = newScaleHeight

    def getBackgroundColor(self):
        return self.backgroundColor

    def setBackgroundColor(self, newBackgroundColor):
        self.backgroundColor = newBackgroundColor

    def getSourceParamsId(self):
        return self.sourceParamsId

    def setSourceParamsId(self, newSourceParamsId):
        self.sourceParamsId = newSourceParamsId

    def getFormat(self):
        return self.format

    def setFormat(self, newFormat):
        self.format = newFormat

    def getDensity(self):
        return self.density

    def setDensity(self, newDensity):
        self.density = newDensity

    def getStripProfiles(self):
        return self.stripProfiles

    def setStripProfiles(self, newStripProfiles):
        self.stripProfiles = newStripProfiles

    def getVideoOffsetInPercentage(self):
        return self.videoOffsetInPercentage

    def setVideoOffsetInPercentage(self, newVideoOffsetInPercentage):
        self.videoOffsetInPercentage = newVideoOffsetInPercentage

    def getInterval(self):
        return self.interval

    def setInterval(self, newInterval):
        self.interval = newInterval


# @package Kaltura
# @subpackage Client
class KalturaThumbParamsOutput(KalturaThumbParams):
    def __init__(self,
            id=NotImplemented,
            partnerId=NotImplemented,
            name=NotImplemented,
            systemName=NotImplemented,
            description=NotImplemented,
            createdAt=NotImplemented,
            isSystemDefault=NotImplemented,
            tags=NotImplemented,
            requiredPermissions=NotImplemented,
            sourceRemoteStorageProfileId=NotImplemented,
            remoteStorageProfileIds=NotImplemented,
            mediaParserType=NotImplemented,
            sourceAssetParamsIds=NotImplemented,
            cropType=NotImplemented,
            quality=NotImplemented,
            cropX=NotImplemented,
            cropY=NotImplemented,
            cropWidth=NotImplemented,
            cropHeight=NotImplemented,
            videoOffset=NotImplemented,
            width=NotImplemented,
            height=NotImplemented,
            scaleWidth=NotImplemented,
            scaleHeight=NotImplemented,
            backgroundColor=NotImplemented,
            sourceParamsId=NotImplemented,
            format=NotImplemented,
            density=NotImplemented,
            stripProfiles=NotImplemented,
            videoOffsetInPercentage=NotImplemented,
            interval=NotImplemented,
            thumbParamsId=NotImplemented,
            thumbParamsVersion=NotImplemented,
            thumbAssetId=NotImplemented,
            thumbAssetVersion=NotImplemented,
            rotate=NotImplemented):
        KalturaThumbParams.__init__(self,
            id,
            partnerId,
            name,
            systemName,
            description,
            createdAt,
            isSystemDefault,
            tags,
            requiredPermissions,
            sourceRemoteStorageProfileId,
            remoteStorageProfileIds,
            mediaParserType,
            sourceAssetParamsIds,
            cropType,
            quality,
            cropX,
            cropY,
            cropWidth,
            cropHeight,
            videoOffset,
            width,
            height,
            scaleWidth,
            scaleHeight,
            backgroundColor,
            sourceParamsId,
            format,
            density,
            stripProfiles,
            videoOffsetInPercentage,
            interval)

        # @var int
        self.thumbParamsId = thumbParamsId

        # @var string
        self.thumbParamsVersion = thumbParamsVersion

        # @var string
        self.thumbAssetId = thumbAssetId

        # @var string
        self.thumbAssetVersion = thumbAssetVersion

        # @var int
        self.rotate = rotate


    PROPERTY_LOADERS = {
        'thumbParamsId': getXmlNodeInt, 
        'thumbParamsVersion': getXmlNodeText, 
        'thumbAssetId': getXmlNodeText, 
        'thumbAssetVersion': getXmlNodeText, 
        'rotate': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaThumbParams.fromXml(self, node)
        self.fromXmlImpl(node, KalturaThumbParamsOutput.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaThumbParams.toParams(self)
        kparams.put("objectType", "KalturaThumbParamsOutput")
        kparams.addIntIfDefined("thumbParamsId", self.thumbParamsId)
        kparams.addStringIfDefined("thumbParamsVersion", self.thumbParamsVersion)
        kparams.addStringIfDefined("thumbAssetId", self.thumbAssetId)
        kparams.addStringIfDefined("thumbAssetVersion", self.thumbAssetVersion)
        kparams.addIntIfDefined("rotate", self.rotate)
        return kparams

    def getThumbParamsId(self):
        return self.thumbParamsId

    def setThumbParamsId(self, newThumbParamsId):
        self.thumbParamsId = newThumbParamsId

    def getThumbParamsVersion(self):
        return self.thumbParamsVersion

    def setThumbParamsVersion(self, newThumbParamsVersion):
        self.thumbParamsVersion = newThumbParamsVersion

    def getThumbAssetId(self):
        return self.thumbAssetId

    def setThumbAssetId(self, newThumbAssetId):
        self.thumbAssetId = newThumbAssetId

    def getThumbAssetVersion(self):
        return self.thumbAssetVersion

    def setThumbAssetVersion(self, newThumbAssetVersion):
        self.thumbAssetVersion = newThumbAssetVersion

    def getRotate(self):
        return self.rotate

    def setRotate(self, newRotate):
        self.rotate = newRotate


# @package Kaltura
# @subpackage Client
class KalturaThumbParamsOutputListResponse(KalturaListResponse):
    def __init__(self,
            totalCount=NotImplemented,
            objects=NotImplemented):
        KalturaListResponse.__init__(self,
            totalCount)

        # @var array of KalturaThumbParamsOutput
        # @readonly
        self.objects = objects


    PROPERTY_LOADERS = {
        'objects': (KalturaObjectFactory.createArray, 'KalturaThumbParamsOutput'), 
    }

    def fromXml(self, node):
        KalturaListResponse.fromXml(self, node)
        self.fromXmlImpl(node, KalturaThumbParamsOutputListResponse.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaListResponse.toParams(self)
        kparams.put("objectType", "KalturaThumbParamsOutputListResponse")
        return kparams

    def getObjects(self):
        return self.objects


# @package Kaltura
# @subpackage Client
class KalturaLiveStreamConfiguration(KalturaObjectBase):
    """A representation of a live stream configuration"""

    def __init__(self,
            protocol=NotImplemented,
            url=NotImplemented,
            publishUrl=NotImplemented,
            backupUrl=NotImplemented,
            streamName=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var KalturaPlaybackProtocol
        self.protocol = protocol

        # @var string
        self.url = url

        # @var string
        self.publishUrl = publishUrl

        # @var string
        self.backupUrl = backupUrl

        # @var string
        self.streamName = streamName


    PROPERTY_LOADERS = {
        'protocol': (KalturaEnumsFactory.createString, "KalturaPlaybackProtocol"), 
        'url': getXmlNodeText, 
        'publishUrl': getXmlNodeText, 
        'backupUrl': getXmlNodeText, 
        'streamName': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaLiveStreamConfiguration.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaLiveStreamConfiguration")
        kparams.addStringEnumIfDefined("protocol", self.protocol)
        kparams.addStringIfDefined("url", self.url)
        kparams.addStringIfDefined("publishUrl", self.publishUrl)
        kparams.addStringIfDefined("backupUrl", self.backupUrl)
        kparams.addStringIfDefined("streamName", self.streamName)
        return kparams

    def getProtocol(self):
        return self.protocol

    def setProtocol(self, newProtocol):
        self.protocol = newProtocol

    def getUrl(self):
        return self.url

    def setUrl(self, newUrl):
        self.url = newUrl

    def getPublishUrl(self):
        return self.publishUrl

    def setPublishUrl(self, newPublishUrl):
        self.publishUrl = newPublishUrl

    def getBackupUrl(self):
        return self.backupUrl

    def setBackupUrl(self, newBackupUrl):
        self.backupUrl = newBackupUrl

    def getStreamName(self):
        return self.streamName

    def setStreamName(self, newStreamName):
        self.streamName = newStreamName


# @package Kaltura
# @subpackage Client
class KalturaLiveStreamPushPublishConfiguration(KalturaObjectBase):
    """Basic push-publish configuration for Kaltura live stream entry"""

    def __init__(self,
            publishUrl=NotImplemented,
            backupPublishUrl=NotImplemented,
            port=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.publishUrl = publishUrl

        # @var string
        self.backupPublishUrl = backupPublishUrl

        # @var string
        self.port = port


    PROPERTY_LOADERS = {
        'publishUrl': getXmlNodeText, 
        'backupPublishUrl': getXmlNodeText, 
        'port': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaLiveStreamPushPublishConfiguration.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaLiveStreamPushPublishConfiguration")
        kparams.addStringIfDefined("publishUrl", self.publishUrl)
        kparams.addStringIfDefined("backupPublishUrl", self.backupPublishUrl)
        kparams.addStringIfDefined("port", self.port)
        return kparams

    def getPublishUrl(self):
        return self.publishUrl

    def setPublishUrl(self, newPublishUrl):
        self.publishUrl = newPublishUrl

    def getBackupPublishUrl(self):
        return self.backupPublishUrl

    def setBackupPublishUrl(self, newBackupPublishUrl):
        self.backupPublishUrl = newBackupPublishUrl

    def getPort(self):
        return self.port

    def setPort(self, newPort):
        self.port = newPort


# @package Kaltura
# @subpackage Client
class KalturaLiveEntryRecordingOptions(KalturaObjectBase):
    """A representation of a live stream recording entry configuration"""

    def __init__(self,
            shouldCopyEntitlement=NotImplemented,
            shouldCopyScheduling=NotImplemented,
            shouldCopyThumbnail=NotImplemented,
            shouldMakeHidden=NotImplemented,
            shouldAutoArchive=NotImplemented,
            nonDeletedCuePointsTags=NotImplemented,
            archiveVodSuffixTimezone=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var KalturaNullableBoolean
        self.shouldCopyEntitlement = shouldCopyEntitlement

        # @var KalturaNullableBoolean
        self.shouldCopyScheduling = shouldCopyScheduling

        # @var KalturaNullableBoolean
        self.shouldCopyThumbnail = shouldCopyThumbnail

        # @var KalturaNullableBoolean
        self.shouldMakeHidden = shouldMakeHidden

        # @var KalturaNullableBoolean
        self.shouldAutoArchive = shouldAutoArchive

        # @var string
        self.nonDeletedCuePointsTags = nonDeletedCuePointsTags

        # @var string
        self.archiveVodSuffixTimezone = archiveVodSuffixTimezone


    PROPERTY_LOADERS = {
        'shouldCopyEntitlement': (KalturaEnumsFactory.createInt, "KalturaNullableBoolean"), 
        'shouldCopyScheduling': (KalturaEnumsFactory.createInt, "KalturaNullableBoolean"), 
        'shouldCopyThumbnail': (KalturaEnumsFactory.createInt, "KalturaNullableBoolean"), 
        'shouldMakeHidden': (KalturaEnumsFactory.createInt, "KalturaNullableBoolean"), 
        'shouldAutoArchive': (KalturaEnumsFactory.createInt, "KalturaNullableBoolean"), 
        'nonDeletedCuePointsTags': getXmlNodeText, 
        'archiveVodSuffixTimezone': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaLiveEntryRecordingOptions.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaLiveEntryRecordingOptions")
        kparams.addIntEnumIfDefined("shouldCopyEntitlement", self.shouldCopyEntitlement)
        kparams.addIntEnumIfDefined("shouldCopyScheduling", self.shouldCopyScheduling)
        kparams.addIntEnumIfDefined("shouldCopyThumbnail", self.shouldCopyThumbnail)
        kparams.addIntEnumIfDefined("shouldMakeHidden", self.shouldMakeHidden)
        kparams.addIntEnumIfDefined("shouldAutoArchive", self.shouldAutoArchive)
        kparams.addStringIfDefined("nonDeletedCuePointsTags", self.nonDeletedCuePointsTags)
        kparams.addStringIfDefined("archiveVodSuffixTimezone", self.archiveVodSuffixTimezone)
        return kparams

    def getShouldCopyEntitlement(self):
        return self.shouldCopyEntitlement

    def setShouldCopyEntitlement(self, newShouldCopyEntitlement):
        self.shouldCopyEntitlement = newShouldCopyEntitlement

    def getShouldCopyScheduling(self):
        return self.shouldCopyScheduling

    def setShouldCopyScheduling(self, newShouldCopyScheduling):
        self.shouldCopyScheduling = newShouldCopyScheduling

    def getShouldCopyThumbnail(self):
        return self.shouldCopyThumbnail

    def setShouldCopyThumbnail(self, newShouldCopyThumbnail):
        self.shouldCopyThumbnail = newShouldCopyThumbnail

    def getShouldMakeHidden(self):
        return self.shouldMakeHidden

    def setShouldMakeHidden(self, newShouldMakeHidden):
        self.shouldMakeHidden = newShouldMakeHidden

    def getShouldAutoArchive(self):
        return self.shouldAutoArchive

    def setShouldAutoArchive(self, newShouldAutoArchive):
        self.shouldAutoArchive = newShouldAutoArchive

    def getNonDeletedCuePointsTags(self):
        return self.nonDeletedCuePointsTags

    def setNonDeletedCuePointsTags(self, newNonDeletedCuePointsTags):
        self.nonDeletedCuePointsTags = newNonDeletedCuePointsTags

    def getArchiveVodSuffixTimezone(self):
        return self.archiveVodSuffixTimezone

    def setArchiveVodSuffixTimezone(self, newArchiveVodSuffixTimezone):
        self.archiveVodSuffixTimezone = newArchiveVodSuffixTimezone


# @package Kaltura
# @subpackage Client
class KalturaLiveEntry(KalturaMediaEntry):
    def __init__(self,
            id=NotImplemented,
            name=NotImplemented,
            description=NotImplemented,
            partnerId=NotImplemented,
            userId=NotImplemented,
            creatorId=NotImplemented,
            tags=NotImplemented,
            adminTags=NotImplemented,
            categories=NotImplemented,
            categoriesIds=NotImplemented,
            status=NotImplemented,
            moderationStatus=NotImplemented,
            moderationCount=NotImplemented,
            type=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented,
            rank=NotImplemented,
            totalRank=NotImplemented,
            votes=NotImplemented,
            groupId=NotImplemented,
            partnerData=NotImplemented,
            downloadUrl=NotImplemented,
            searchText=NotImplemented,
            licenseType=NotImplemented,
            version=NotImplemented,
            thumbnailUrl=NotImplemented,
            accessControlId=NotImplemented,
            startDate=NotImplemented,
            endDate=NotImplemented,
            referenceId=NotImplemented,
            replacingEntryId=NotImplemented,
            replacedEntryId=NotImplemented,
            replacementStatus=NotImplemented,
            partnerSortValue=NotImplemented,
            conversionProfileId=NotImplemented,
            redirectEntryId=NotImplemented,
            rootEntryId=NotImplemented,
            parentEntryId=NotImplemented,
            operationAttributes=NotImplemented,
            entitledUsersEdit=NotImplemented,
            entitledUsersPublish=NotImplemented,
            entitledUsersView=NotImplemented,
            capabilities=NotImplemented,
            templateEntryId=NotImplemented,
            displayInSearch=NotImplemented,
            application=NotImplemented,
            applicationVersion=NotImplemented,
            blockAutoTranscript=NotImplemented,
            plays=NotImplemented,
            views=NotImplemented,
            lastPlayedAt=NotImplemented,
            width=NotImplemented,
            height=NotImplemented,
            duration=NotImplemented,
            msDuration=NotImplemented,
            durationType=NotImplemented,
            mediaType=NotImplemented,
            conversionQuality=NotImplemented,
            sourceType=NotImplemented,
            sourceVersion=NotImplemented,
            searchProviderType=NotImplemented,
            searchProviderId=NotImplemented,
            creditUserName=NotImplemented,
            creditUrl=NotImplemented,
            mediaDate=NotImplemented,
            dataUrl=NotImplemented,
            flavorParamsIds=NotImplemented,
            isTrimDisabled=NotImplemented,
            streams=NotImplemented,
            offlineMessage=NotImplemented,
            recordStatus=NotImplemented,
            dvrStatus=NotImplemented,
            dvrWindow=NotImplemented,
            lastElapsedRecordingTime=NotImplemented,
            liveStreamConfigurations=NotImplemented,
            recordedEntryId=NotImplemented,
            pushPublishEnabled=NotImplemented,
            publishConfigurations=NotImplemented,
            firstBroadcast=NotImplemented,
            lastBroadcast=NotImplemented,
            currentBroadcastStartTime=NotImplemented,
            recordingOptions=NotImplemented,
            liveStatus=NotImplemented,
            segmentDuration=NotImplemented,
            explicitLive=NotImplemented,
            viewMode=NotImplemented,
            recordingStatus=NotImplemented,
            lastBroadcastEndTime=NotImplemented,
            broadcastTime=NotImplemented):
        KalturaMediaEntry.__init__(self,
            id,
            name,
            description,
            partnerId,
            userId,
            creatorId,
            tags,
            adminTags,
            categories,
            categoriesIds,
            status,
            moderationStatus,
            moderationCount,
            type,
            createdAt,
            updatedAt,
            rank,
            totalRank,
            votes,
            groupId,
            partnerData,
            downloadUrl,
            searchText,
            licenseType,
            version,
            thumbnailUrl,
            accessControlId,
            startDate,
            endDate,
            referenceId,
            replacingEntryId,
            replacedEntryId,
            replacementStatus,
            partnerSortValue,
            conversionProfileId,
            redirectEntryId,
            rootEntryId,
            parentEntryId,
            operationAttributes,
            entitledUsersEdit,
            entitledUsersPublish,
            entitledUsersView,
            capabilities,
            templateEntryId,
            displayInSearch,
            application,
            applicationVersion,
            blockAutoTranscript,
            plays,
            views,
            lastPlayedAt,
            width,
            height,
            duration,
            msDuration,
            durationType,
            mediaType,
            conversionQuality,
            sourceType,
            sourceVersion,
            searchProviderType,
            searchProviderId,
            creditUserName,
            creditUrl,
            mediaDate,
            dataUrl,
            flavorParamsIds,
            isTrimDisabled,
            streams)

        # The message to be presented when the stream is offline
        # @var string
        self.offlineMessage = offlineMessage

        # Recording Status Enabled/Disabled
        # @var KalturaRecordStatus
        self.recordStatus = recordStatus

        # DVR Status Enabled/Disabled
        # @var KalturaDVRStatus
        self.dvrStatus = dvrStatus

        # Window of time which the DVR allows for backwards scrubbing (in minutes)
        # @var int
        self.dvrWindow = dvrWindow

        # Elapsed recording time (in msec) up to the point where the live stream was last stopped (unpublished).
        # @var int
        self.lastElapsedRecordingTime = lastElapsedRecordingTime

        # Array of key value protocol->live stream url objects
        # @var array of KalturaLiveStreamConfiguration
        self.liveStreamConfigurations = liveStreamConfigurations

        # Recorded entry id
        # @var string
        self.recordedEntryId = recordedEntryId

        # Flag denoting whether entry should be published by the media server
        # @var KalturaLivePublishStatus
        self.pushPublishEnabled = pushPublishEnabled

        # Array of publish configurations
        # @var array of KalturaLiveStreamPushPublishConfiguration
        self.publishConfigurations = publishConfigurations

        # The first time in which the entry was broadcast
        # @var int
        # @readonly
        self.firstBroadcast = firstBroadcast

        # The Last time in which the entry was broadcast
        # @var int
        # @readonly
        self.lastBroadcast = lastBroadcast

        # The time (unix timestamp in milliseconds) in which the entry broadcast started or 0 when the entry is off the air
        # @var float
        self.currentBroadcastStartTime = currentBroadcastStartTime

        # @var KalturaLiveEntryRecordingOptions
        self.recordingOptions = recordingOptions

        # the status of the entry of type EntryServerNodeStatus
        # @var KalturaEntryServerNodeStatus
        # @readonly
        self.liveStatus = liveStatus

        # The chunk duration value in milliseconds
        # @var int
        self.segmentDuration = segmentDuration

        # @var KalturaNullableBoolean
        self.explicitLive = explicitLive

        # @var KalturaViewMode
        self.viewMode = viewMode

        # @var KalturaRecordingStatus
        self.recordingStatus = recordingStatus

        # The time the last broadcast finished.
        # @var int
        # @readonly
        self.lastBroadcastEndTime = lastBroadcastEndTime

        # The time when the entry was first live with view_all
        # @var int
        self.broadcastTime = broadcastTime


    PROPERTY_LOADERS = {
        'offlineMessage': getXmlNodeText, 
        'recordStatus': (KalturaEnumsFactory.createInt, "KalturaRecordStatus"), 
        'dvrStatus': (KalturaEnumsFactory.createInt, "KalturaDVRStatus"), 
        'dvrWindow': getXmlNodeInt, 
        'lastElapsedRecordingTime': getXmlNodeInt, 
        'liveStreamConfigurations': (KalturaObjectFactory.createArray, 'KalturaLiveStreamConfiguration'), 
        'recordedEntryId': getXmlNodeText, 
        'pushPublishEnabled': (KalturaEnumsFactory.createInt, "KalturaLivePublishStatus"), 
        'publishConfigurations': (KalturaObjectFactory.createArray, 'KalturaLiveStreamPushPublishConfiguration'), 
        'firstBroadcast': getXmlNodeInt, 
        'lastBroadcast': getXmlNodeInt, 
        'currentBroadcastStartTime': getXmlNodeFloat, 
        'recordingOptions': (KalturaObjectFactory.create, 'KalturaLiveEntryRecordingOptions'), 
        'liveStatus': (KalturaEnumsFactory.createInt, "KalturaEntryServerNodeStatus"), 
        'segmentDuration': getXmlNodeInt, 
        'explicitLive': (KalturaEnumsFactory.createInt, "KalturaNullableBoolean"), 
        'viewMode': (KalturaEnumsFactory.createInt, "KalturaViewMode"), 
        'recordingStatus': (KalturaEnumsFactory.createInt, "KalturaRecordingStatus"), 
        'lastBroadcastEndTime': getXmlNodeInt, 
        'broadcastTime': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaMediaEntry.fromXml(self, node)
        self.fromXmlImpl(node, KalturaLiveEntry.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaMediaEntry.toParams(self)
        kparams.put("objectType", "KalturaLiveEntry")
        kparams.addStringIfDefined("offlineMessage", self.offlineMessage)
        kparams.addIntEnumIfDefined("recordStatus", self.recordStatus)
        kparams.addIntEnumIfDefined("dvrStatus", self.dvrStatus)
        kparams.addIntIfDefined("dvrWindow", self.dvrWindow)
        kparams.addIntIfDefined("lastElapsedRecordingTime", self.lastElapsedRecordingTime)
        kparams.addArrayIfDefined("liveStreamConfigurations", self.liveStreamConfigurations)
        kparams.addStringIfDefined("recordedEntryId", self.recordedEntryId)
        kparams.addIntEnumIfDefined("pushPublishEnabled", self.pushPublishEnabled)
        kparams.addArrayIfDefined("publishConfigurations", self.publishConfigurations)
        kparams.addFloatIfDefined("currentBroadcastStartTime", self.currentBroadcastStartTime)
        kparams.addObjectIfDefined("recordingOptions", self.recordingOptions)
        kparams.addIntIfDefined("segmentDuration", self.segmentDuration)
        kparams.addIntEnumIfDefined("explicitLive", self.explicitLive)
        kparams.addIntEnumIfDefined("viewMode", self.viewMode)
        kparams.addIntEnumIfDefined("recordingStatus", self.recordingStatus)
        kparams.addIntIfDefined("broadcastTime", self.broadcastTime)
        return kparams

    def getOfflineMessage(self):
        return self.offlineMessage

    def setOfflineMessage(self, newOfflineMessage):
        self.offlineMessage = newOfflineMessage

    def getRecordStatus(self):
        return self.recordStatus

    def setRecordStatus(self, newRecordStatus):
        self.recordStatus = newRecordStatus

    def getDvrStatus(self):
        return self.dvrStatus

    def setDvrStatus(self, newDvrStatus):
        self.dvrStatus = newDvrStatus

    def getDvrWindow(self):
        return self.dvrWindow

    def setDvrWindow(self, newDvrWindow):
        self.dvrWindow = newDvrWindow

    def getLastElapsedRecordingTime(self):
        return self.lastElapsedRecordingTime

    def setLastElapsedRecordingTime(self, newLastElapsedRecordingTime):
        self.lastElapsedRecordingTime = newLastElapsedRecordingTime

    def getLiveStreamConfigurations(self):
        return self.liveStreamConfigurations

    def setLiveStreamConfigurations(self, newLiveStreamConfigurations):
        self.liveStreamConfigurations = newLiveStreamConfigurations

    def getRecordedEntryId(self):
        return self.recordedEntryId

    def setRecordedEntryId(self, newRecordedEntryId):
        self.recordedEntryId = newRecordedEntryId

    def getPushPublishEnabled(self):
        return self.pushPublishEnabled

    def setPushPublishEnabled(self, newPushPublishEnabled):
        self.pushPublishEnabled = newPushPublishEnabled

    def getPublishConfigurations(self):
        return self.publishConfigurations

    def setPublishConfigurations(self, newPublishConfigurations):
        self.publishConfigurations = newPublishConfigurations

    def getFirstBroadcast(self):
        return self.firstBroadcast

    def getLastBroadcast(self):
        return self.lastBroadcast

    def getCurrentBroadcastStartTime(self):
        return self.currentBroadcastStartTime

    def setCurrentBroadcastStartTime(self, newCurrentBroadcastStartTime):
        self.currentBroadcastStartTime = newCurrentBroadcastStartTime

    def getRecordingOptions(self):
        return self.recordingOptions

    def setRecordingOptions(self, newRecordingOptions):
        self.recordingOptions = newRecordingOptions

    def getLiveStatus(self):
        return self.liveStatus

    def getSegmentDuration(self):
        return self.segmentDuration

    def setSegmentDuration(self, newSegmentDuration):
        self.segmentDuration = newSegmentDuration

    def getExplicitLive(self):
        return self.explicitLive

    def setExplicitLive(self, newExplicitLive):
        self.explicitLive = newExplicitLive

    def getViewMode(self):
        return self.viewMode

    def setViewMode(self, newViewMode):
        self.viewMode = newViewMode

    def getRecordingStatus(self):
        return self.recordingStatus

    def setRecordingStatus(self, newRecordingStatus):
        self.recordingStatus = newRecordingStatus

    def getLastBroadcastEndTime(self):
        return self.lastBroadcastEndTime

    def getBroadcastTime(self):
        return self.broadcastTime

    def setBroadcastTime(self, newBroadcastTime):
        self.broadcastTime = newBroadcastTime


# @package Kaltura
# @subpackage Client
class KalturaLiveChannel(KalturaLiveEntry):
    def __init__(self,
            id=NotImplemented,
            name=NotImplemented,
            description=NotImplemented,
            partnerId=NotImplemented,
            userId=NotImplemented,
            creatorId=NotImplemented,
            tags=NotImplemented,
            adminTags=NotImplemented,
            categories=NotImplemented,
            categoriesIds=NotImplemented,
            status=NotImplemented,
            moderationStatus=NotImplemented,
            moderationCount=NotImplemented,
            type=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented,
            rank=NotImplemented,
            totalRank=NotImplemented,
            votes=NotImplemented,
            groupId=NotImplemented,
            partnerData=NotImplemented,
            downloadUrl=NotImplemented,
            searchText=NotImplemented,
            licenseType=NotImplemented,
            version=NotImplemented,
            thumbnailUrl=NotImplemented,
            accessControlId=NotImplemented,
            startDate=NotImplemented,
            endDate=NotImplemented,
            referenceId=NotImplemented,
            replacingEntryId=NotImplemented,
            replacedEntryId=NotImplemented,
            replacementStatus=NotImplemented,
            partnerSortValue=NotImplemented,
            conversionProfileId=NotImplemented,
            redirectEntryId=NotImplemented,
            rootEntryId=NotImplemented,
            parentEntryId=NotImplemented,
            operationAttributes=NotImplemented,
            entitledUsersEdit=NotImplemented,
            entitledUsersPublish=NotImplemented,
            entitledUsersView=NotImplemented,
            capabilities=NotImplemented,
            templateEntryId=NotImplemented,
            displayInSearch=NotImplemented,
            application=NotImplemented,
            applicationVersion=NotImplemented,
            blockAutoTranscript=NotImplemented,
            plays=NotImplemented,
            views=NotImplemented,
            lastPlayedAt=NotImplemented,
            width=NotImplemented,
            height=NotImplemented,
            duration=NotImplemented,
            msDuration=NotImplemented,
            durationType=NotImplemented,
            mediaType=NotImplemented,
            conversionQuality=NotImplemented,
            sourceType=NotImplemented,
            sourceVersion=NotImplemented,
            searchProviderType=NotImplemented,
            searchProviderId=NotImplemented,
            creditUserName=NotImplemented,
            creditUrl=NotImplemented,
            mediaDate=NotImplemented,
            dataUrl=NotImplemented,
            flavorParamsIds=NotImplemented,
            isTrimDisabled=NotImplemented,
            streams=NotImplemented,
            offlineMessage=NotImplemented,
            recordStatus=NotImplemented,
            dvrStatus=NotImplemented,
            dvrWindow=NotImplemented,
            lastElapsedRecordingTime=NotImplemented,
            liveStreamConfigurations=NotImplemented,
            recordedEntryId=NotImplemented,
            pushPublishEnabled=NotImplemented,
            publishConfigurations=NotImplemented,
            firstBroadcast=NotImplemented,
            lastBroadcast=NotImplemented,
            currentBroadcastStartTime=NotImplemented,
            recordingOptions=NotImplemented,
            liveStatus=NotImplemented,
            segmentDuration=NotImplemented,
            explicitLive=NotImplemented,
            viewMode=NotImplemented,
            recordingStatus=NotImplemented,
            lastBroadcastEndTime=NotImplemented,
            broadcastTime=NotImplemented,
            playlistId=NotImplemented,
            repeat=NotImplemented):
        KalturaLiveEntry.__init__(self,
            id,
            name,
            description,
            partnerId,
            userId,
            creatorId,
            tags,
            adminTags,
            categories,
            categoriesIds,
            status,
            moderationStatus,
            moderationCount,
            type,
            createdAt,
            updatedAt,
            rank,
            totalRank,
            votes,
            groupId,
            partnerData,
            downloadUrl,
            searchText,
            licenseType,
            version,
            thumbnailUrl,
            accessControlId,
            startDate,
            endDate,
            referenceId,
            replacingEntryId,
            replacedEntryId,
            replacementStatus,
            partnerSortValue,
            conversionProfileId,
            redirectEntryId,
            rootEntryId,
            parentEntryId,
            operationAttributes,
            entitledUsersEdit,
            entitledUsersPublish,
            entitledUsersView,
            capabilities,
            templateEntryId,
            displayInSearch,
            application,
            applicationVersion,
            blockAutoTranscript,
            plays,
            views,
            lastPlayedAt,
            width,
            height,
            duration,
            msDuration,
            durationType,
            mediaType,
            conversionQuality,
            sourceType,
            sourceVersion,
            searchProviderType,
            searchProviderId,
            creditUserName,
            creditUrl,
            mediaDate,
            dataUrl,
            flavorParamsIds,
            isTrimDisabled,
            streams,
            offlineMessage,
            recordStatus,
            dvrStatus,
            dvrWindow,
            lastElapsedRecordingTime,
            liveStreamConfigurations,
            recordedEntryId,
            pushPublishEnabled,
            publishConfigurations,
            firstBroadcast,
            lastBroadcast,
            currentBroadcastStartTime,
            recordingOptions,
            liveStatus,
            segmentDuration,
            explicitLive,
            viewMode,
            recordingStatus,
            lastBroadcastEndTime,
            broadcastTime)

        # Playlist id to be played
        # @var string
        self.playlistId = playlistId

        # Indicates that the segments should be repeated for ever
        # @var KalturaNullableBoolean
        self.repeat = repeat


    PROPERTY_LOADERS = {
        'playlistId': getXmlNodeText, 
        'repeat': (KalturaEnumsFactory.createInt, "KalturaNullableBoolean"), 
    }

    def fromXml(self, node):
        KalturaLiveEntry.fromXml(self, node)
        self.fromXmlImpl(node, KalturaLiveChannel.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaLiveEntry.toParams(self)
        kparams.put("objectType", "KalturaLiveChannel")
        kparams.addStringIfDefined("playlistId", self.playlistId)
        kparams.addIntEnumIfDefined("repeat", self.repeat)
        return kparams

    def getPlaylistId(self):
        return self.playlistId

    def setPlaylistId(self, newPlaylistId):
        self.playlistId = newPlaylistId

    def getRepeat(self):
        return self.repeat

    def setRepeat(self, newRepeat):
        self.repeat = newRepeat


# @package Kaltura
# @subpackage Client
class KalturaLiveChannelSegment(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            partnerId=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented,
            name=NotImplemented,
            description=NotImplemented,
            tags=NotImplemented,
            type=NotImplemented,
            status=NotImplemented,
            channelId=NotImplemented,
            entryId=NotImplemented,
            triggerType=NotImplemented,
            triggerSegmentId=NotImplemented,
            startTime=NotImplemented,
            duration=NotImplemented):
        KalturaObjectBase.__init__(self)

        # Unique identifier
        # @var int
        # @readonly
        self.id = id

        # @var int
        # @readonly
        self.partnerId = partnerId

        # Segment creation date as Unix timestamp (In seconds)
        # @var int
        # @readonly
        self.createdAt = createdAt

        # Segment update date as Unix timestamp (In seconds)
        # @var int
        # @readonly
        self.updatedAt = updatedAt

        # Segment name
        # @var string
        self.name = name

        # Segment description
        # @var string
        self.description = description

        # Segment tags
        # @var string
        self.tags = tags

        # Segment could be associated with the main stream, as additional stream or as overlay
        # @var KalturaLiveChannelSegmentType
        self.type = type

        # @var KalturaLiveChannelSegmentStatus
        # @readonly
        self.status = status

        # Live channel id
        # @var string
        self.channelId = channelId

        # Entry id to be played
        # @var string
        self.entryId = entryId

        # Segment start time trigger type
        # @var KalturaLiveChannelSegmentTriggerType
        self.triggerType = triggerType

        # Live channel segment that the trigger relates to
        # @var int
        self.triggerSegmentId = triggerSegmentId

        # Segment play start time, in mili-seconds, according to trigger type
        # @var float
        self.startTime = startTime

        # Segment play duration time, in mili-seconds
        # @var float
        self.duration = duration


    PROPERTY_LOADERS = {
        'id': getXmlNodeInt, 
        'partnerId': getXmlNodeInt, 
        'createdAt': getXmlNodeInt, 
        'updatedAt': getXmlNodeInt, 
        'name': getXmlNodeText, 
        'description': getXmlNodeText, 
        'tags': getXmlNodeText, 
        'type': (KalturaEnumsFactory.createString, "KalturaLiveChannelSegmentType"), 
        'status': (KalturaEnumsFactory.createString, "KalturaLiveChannelSegmentStatus"), 
        'channelId': getXmlNodeText, 
        'entryId': getXmlNodeText, 
        'triggerType': (KalturaEnumsFactory.createString, "KalturaLiveChannelSegmentTriggerType"), 
        'triggerSegmentId': getXmlNodeInt, 
        'startTime': getXmlNodeFloat, 
        'duration': getXmlNodeFloat, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaLiveChannelSegment.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaLiveChannelSegment")
        kparams.addStringIfDefined("name", self.name)
        kparams.addStringIfDefined("description", self.description)
        kparams.addStringIfDefined("tags", self.tags)
        kparams.addStringEnumIfDefined("type", self.type)
        kparams.addStringIfDefined("channelId", self.channelId)
        kparams.addStringIfDefined("entryId", self.entryId)
        kparams.addStringEnumIfDefined("triggerType", self.triggerType)
        kparams.addIntIfDefined("triggerSegmentId", self.triggerSegmentId)
        kparams.addFloatIfDefined("startTime", self.startTime)
        kparams.addFloatIfDefined("duration", self.duration)
        return kparams

    def getId(self):
        return self.id

    def getPartnerId(self):
        return self.partnerId

    def getCreatedAt(self):
        return self.createdAt

    def getUpdatedAt(self):
        return self.updatedAt

    def getName(self):
        return self.name

    def setName(self, newName):
        self.name = newName

    def getDescription(self):
        return self.description

    def setDescription(self, newDescription):
        self.description = newDescription

    def getTags(self):
        return self.tags

    def setTags(self, newTags):
        self.tags = newTags

    def getType(self):
        return self.type

    def setType(self, newType):
        self.type = newType

    def getStatus(self):
        return self.status

    def getChannelId(self):
        return self.channelId

    def setChannelId(self, newChannelId):
        self.channelId = newChannelId

    def getEntryId(self):
        return self.entryId

    def setEntryId(self, newEntryId):
        self.entryId = newEntryId

    def getTriggerType(self):
        return self.triggerType

    def setTriggerType(self, newTriggerType):
        self.triggerType = newTriggerType

    def getTriggerSegmentId(self):
        return self.triggerSegmentId

    def setTriggerSegmentId(self, newTriggerSegmentId):
        self.triggerSegmentId = newTriggerSegmentId

    def getStartTime(self):
        return self.startTime

    def setStartTime(self, newStartTime):
        self.startTime = newStartTime

    def getDuration(self):
        return self.duration

    def setDuration(self, newDuration):
        self.duration = newDuration


# @package Kaltura
# @subpackage Client
class KalturaLiveEntryServerNodeRecordingInfo(KalturaObjectBase):
    def __init__(self,
            recordedEntryId=NotImplemented,
            duration=NotImplemented,
            recordingStatus=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.recordedEntryId = recordedEntryId

        # @var int
        self.duration = duration

        # @var KalturaEntryServerNodeRecordingStatus
        self.recordingStatus = recordingStatus


    PROPERTY_LOADERS = {
        'recordedEntryId': getXmlNodeText, 
        'duration': getXmlNodeInt, 
        'recordingStatus': (KalturaEnumsFactory.createInt, "KalturaEntryServerNodeRecordingStatus"), 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaLiveEntryServerNodeRecordingInfo.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaLiveEntryServerNodeRecordingInfo")
        kparams.addStringIfDefined("recordedEntryId", self.recordedEntryId)
        kparams.addIntIfDefined("duration", self.duration)
        kparams.addIntEnumIfDefined("recordingStatus", self.recordingStatus)
        return kparams

    def getRecordedEntryId(self):
        return self.recordedEntryId

    def setRecordedEntryId(self, newRecordedEntryId):
        self.recordedEntryId = newRecordedEntryId

    def getDuration(self):
        return self.duration

    def setDuration(self, newDuration):
        self.duration = newDuration

    def getRecordingStatus(self):
        return self.recordingStatus

    def setRecordingStatus(self, newRecordingStatus):
        self.recordingStatus = newRecordingStatus


# @package Kaltura
# @subpackage Client
class KalturaLiveReportExportParams(KalturaObjectBase):
    def __init__(self,
            entryIds=NotImplemented,
            recpientEmail=NotImplemented,
            timeZoneOffset=NotImplemented,
            applicationUrlTemplate=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.entryIds = entryIds

        # @var string
        self.recpientEmail = recpientEmail

        # Time zone offset in minutes (between client to UTC)
        # @var int
        self.timeZoneOffset = timeZoneOffset

        # Optional argument that allows controlling the prefix of the exported csv url
        # @var string
        self.applicationUrlTemplate = applicationUrlTemplate


    PROPERTY_LOADERS = {
        'entryIds': getXmlNodeText, 
        'recpientEmail': getXmlNodeText, 
        'timeZoneOffset': getXmlNodeInt, 
        'applicationUrlTemplate': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaLiveReportExportParams.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaLiveReportExportParams")
        kparams.addStringIfDefined("entryIds", self.entryIds)
        kparams.addStringIfDefined("recpientEmail", self.recpientEmail)
        kparams.addIntIfDefined("timeZoneOffset", self.timeZoneOffset)
        kparams.addStringIfDefined("applicationUrlTemplate", self.applicationUrlTemplate)
        return kparams

    def getEntryIds(self):
        return self.entryIds

    def setEntryIds(self, newEntryIds):
        self.entryIds = newEntryIds

    def getRecpientEmail(self):
        return self.recpientEmail

    def setRecpientEmail(self, newRecpientEmail):
        self.recpientEmail = newRecpientEmail

    def getTimeZoneOffset(self):
        return self.timeZoneOffset

    def setTimeZoneOffset(self, newTimeZoneOffset):
        self.timeZoneOffset = newTimeZoneOffset

    def getApplicationUrlTemplate(self):
        return self.applicationUrlTemplate

    def setApplicationUrlTemplate(self, newApplicationUrlTemplate):
        self.applicationUrlTemplate = newApplicationUrlTemplate


# @package Kaltura
# @subpackage Client
class KalturaLiveReportExportResponse(KalturaObjectBase):
    def __init__(self,
            referenceJobId=NotImplemented,
            reportEmail=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var int
        self.referenceJobId = referenceJobId

        # @var string
        self.reportEmail = reportEmail


    PROPERTY_LOADERS = {
        'referenceJobId': getXmlNodeInt, 
        'reportEmail': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaLiveReportExportResponse.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaLiveReportExportResponse")
        kparams.addIntIfDefined("referenceJobId", self.referenceJobId)
        kparams.addStringIfDefined("reportEmail", self.reportEmail)
        return kparams

    def getReferenceJobId(self):
        return self.referenceJobId

    def setReferenceJobId(self, newReferenceJobId):
        self.referenceJobId = newReferenceJobId

    def getReportEmail(self):
        return self.reportEmail

    def setReportEmail(self, newReportEmail):
        self.reportEmail = newReportEmail


# @package Kaltura
# @subpackage Client
class KalturaLiveReportInputFilter(KalturaObjectBase):
    def __init__(self,
            entryIds=NotImplemented,
            fromTime=NotImplemented,
            toTime=NotImplemented,
            live=NotImplemented,
            orderBy=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.entryIds = entryIds

        # @var int
        self.fromTime = fromTime

        # @var int
        self.toTime = toTime

        # @var KalturaNullableBoolean
        self.live = live

        # @var KalturaLiveReportOrderBy
        self.orderBy = orderBy


    PROPERTY_LOADERS = {
        'entryIds': getXmlNodeText, 
        'fromTime': getXmlNodeInt, 
        'toTime': getXmlNodeInt, 
        'live': (KalturaEnumsFactory.createInt, "KalturaNullableBoolean"), 
        'orderBy': (KalturaEnumsFactory.createString, "KalturaLiveReportOrderBy"), 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaLiveReportInputFilter.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaLiveReportInputFilter")
        kparams.addStringIfDefined("entryIds", self.entryIds)
        kparams.addIntIfDefined("fromTime", self.fromTime)
        kparams.addIntIfDefined("toTime", self.toTime)
        kparams.addIntEnumIfDefined("live", self.live)
        kparams.addStringEnumIfDefined("orderBy", self.orderBy)
        return kparams

    def getEntryIds(self):
        return self.entryIds

    def setEntryIds(self, newEntryIds):
        self.entryIds = newEntryIds

    def getFromTime(self):
        return self.fromTime

    def setFromTime(self, newFromTime):
        self.fromTime = newFromTime

    def getToTime(self):
        return self.toTime

    def setToTime(self, newToTime):
        self.toTime = newToTime

    def getLive(self):
        return self.live

    def setLive(self, newLive):
        self.live = newLive

    def getOrderBy(self):
        return self.orderBy

    def setOrderBy(self, newOrderBy):
        self.orderBy = newOrderBy


# @package Kaltura
# @subpackage Client
class KalturaLiveStats(KalturaObjectBase):
    def __init__(self,
            audience=NotImplemented,
            dvrAudience=NotImplemented,
            avgBitrate=NotImplemented,
            bufferTime=NotImplemented,
            plays=NotImplemented,
            secondsViewed=NotImplemented,
            startEvent=NotImplemented,
            timestamp=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var int
        self.audience = audience

        # @var int
        self.dvrAudience = dvrAudience

        # @var float
        self.avgBitrate = avgBitrate

        # @var int
        self.bufferTime = bufferTime

        # @var int
        self.plays = plays

        # @var int
        self.secondsViewed = secondsViewed

        # @var int
        self.startEvent = startEvent

        # @var int
        self.timestamp = timestamp


    PROPERTY_LOADERS = {
        'audience': getXmlNodeInt, 
        'dvrAudience': getXmlNodeInt, 
        'avgBitrate': getXmlNodeFloat, 
        'bufferTime': getXmlNodeInt, 
        'plays': getXmlNodeInt, 
        'secondsViewed': getXmlNodeInt, 
        'startEvent': getXmlNodeInt, 
        'timestamp': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaLiveStats.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaLiveStats")
        kparams.addIntIfDefined("audience", self.audience)
        kparams.addIntIfDefined("dvrAudience", self.dvrAudience)
        kparams.addFloatIfDefined("avgBitrate", self.avgBitrate)
        kparams.addIntIfDefined("bufferTime", self.bufferTime)
        kparams.addIntIfDefined("plays", self.plays)
        kparams.addIntIfDefined("secondsViewed", self.secondsViewed)
        kparams.addIntIfDefined("startEvent", self.startEvent)
        kparams.addIntIfDefined("timestamp", self.timestamp)
        return kparams

    def getAudience(self):
        return self.audience

    def setAudience(self, newAudience):
        self.audience = newAudience

    def getDvrAudience(self):
        return self.dvrAudience

    def setDvrAudience(self, newDvrAudience):
        self.dvrAudience = newDvrAudience

    def getAvgBitrate(self):
        return self.avgBitrate

    def setAvgBitrate(self, newAvgBitrate):
        self.avgBitrate = newAvgBitrate

    def getBufferTime(self):
        return self.bufferTime

    def setBufferTime(self, newBufferTime):
        self.bufferTime = newBufferTime

    def getPlays(self):
        return self.plays

    def setPlays(self, newPlays):
        self.plays = newPlays

    def getSecondsViewed(self):
        return self.secondsViewed

    def setSecondsViewed(self, newSecondsViewed):
        self.secondsViewed = newSecondsViewed

    def getStartEvent(self):
        return self.startEvent

    def setStartEvent(self, newStartEvent):
        self.startEvent = newStartEvent

    def getTimestamp(self):
        return self.timestamp

    def setTimestamp(self, newTimestamp):
        self.timestamp = newTimestamp


# @package Kaltura
# @subpackage Client
class KalturaLiveStatsEvent(KalturaObjectBase):
    """Will hold data from the Kaltura Player components to be passed on to the live analytics system"""

    def __init__(self,
            partnerId=NotImplemented,
            entryId=NotImplemented,
            eventType=NotImplemented,
            sessionId=NotImplemented,
            eventIndex=NotImplemented,
            bufferTime=NotImplemented,
            bitrate=NotImplemented,
            referrer=NotImplemented,
            isLive=NotImplemented,
            startTime=NotImplemented,
            deliveryType=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var int
        self.partnerId = partnerId

        # @var string
        self.entryId = entryId

        # an integer representing the type of event being sent from the player
        # @var KalturaLiveStatsEventType
        self.eventType = eventType

        # a unique string generated by the client that will represent the client-side session: the primary component will pass it on to other components that sprout from it
        # @var string
        self.sessionId = sessionId

        # incremental sequence of the event
        # @var int
        self.eventIndex = eventIndex

        # buffer time in seconds from the last 10 seconds
        # @var int
        self.bufferTime = bufferTime

        # bitrate used in the last 10 seconds
        # @var int
        self.bitrate = bitrate

        # the referrer of the client
        # @var string
        self.referrer = referrer

        # @var bool
        self.isLive = isLive

        # the event start time as string
        # @var string
        self.startTime = startTime

        # delivery type used for this stream
        # @var KalturaPlaybackProtocol
        self.deliveryType = deliveryType


    PROPERTY_LOADERS = {
        'partnerId': getXmlNodeInt, 
        'entryId': getXmlNodeText, 
        'eventType': (KalturaEnumsFactory.createInt, "KalturaLiveStatsEventType"), 
        'sessionId': getXmlNodeText, 
        'eventIndex': getXmlNodeInt, 
        'bufferTime': getXmlNodeInt, 
        'bitrate': getXmlNodeInt, 
        'referrer': getXmlNodeText, 
        'isLive': getXmlNodeBool, 
        'startTime': getXmlNodeText, 
        'deliveryType': (KalturaEnumsFactory.createString, "KalturaPlaybackProtocol"), 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaLiveStatsEvent.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaLiveStatsEvent")
        kparams.addIntIfDefined("partnerId", self.partnerId)
        kparams.addStringIfDefined("entryId", self.entryId)
        kparams.addIntEnumIfDefined("eventType", self.eventType)
        kparams.addStringIfDefined("sessionId", self.sessionId)
        kparams.addIntIfDefined("eventIndex", self.eventIndex)
        kparams.addIntIfDefined("bufferTime", self.bufferTime)
        kparams.addIntIfDefined("bitrate", self.bitrate)
        kparams.addStringIfDefined("referrer", self.referrer)
        kparams.addBoolIfDefined("isLive", self.isLive)
        kparams.addStringIfDefined("startTime", self.startTime)
        kparams.addStringEnumIfDefined("deliveryType", self.deliveryType)
        return kparams

    def getPartnerId(self):
        return self.partnerId

    def setPartnerId(self, newPartnerId):
        self.partnerId = newPartnerId

    def getEntryId(self):
        return self.entryId

    def setEntryId(self, newEntryId):
        self.entryId = newEntryId

    def getEventType(self):
        return self.eventType

    def setEventType(self, newEventType):
        self.eventType = newEventType

    def getSessionId(self):
        return self.sessionId

    def setSessionId(self, newSessionId):
        self.sessionId = newSessionId

    def getEventIndex(self):
        return self.eventIndex

    def setEventIndex(self, newEventIndex):
        self.eventIndex = newEventIndex

    def getBufferTime(self):
        return self.bufferTime

    def setBufferTime(self, newBufferTime):
        self.bufferTime = newBufferTime

    def getBitrate(self):
        return self.bitrate

    def setBitrate(self, newBitrate):
        self.bitrate = newBitrate

    def getReferrer(self):
        return self.referrer

    def setReferrer(self, newReferrer):
        self.referrer = newReferrer

    def getIsLive(self):
        return self.isLive

    def setIsLive(self, newIsLive):
        self.isLive = newIsLive

    def getStartTime(self):
        return self.startTime

    def setStartTime(self, newStartTime):
        self.startTime = newStartTime

    def getDeliveryType(self):
        return self.deliveryType

    def setDeliveryType(self, newDeliveryType):
        self.deliveryType = newDeliveryType


# @package Kaltura
# @subpackage Client
class KalturaLiveStreamBitrate(KalturaObjectBase):
    def __init__(self,
            bitrate=NotImplemented,
            width=NotImplemented,
            height=NotImplemented,
            tags=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var int
        self.bitrate = bitrate

        # @var int
        self.width = width

        # @var int
        self.height = height

        # @var string
        self.tags = tags


    PROPERTY_LOADERS = {
        'bitrate': getXmlNodeInt, 
        'width': getXmlNodeInt, 
        'height': getXmlNodeInt, 
        'tags': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaLiveStreamBitrate.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaLiveStreamBitrate")
        kparams.addIntIfDefined("bitrate", self.bitrate)
        kparams.addIntIfDefined("width", self.width)
        kparams.addIntIfDefined("height", self.height)
        kparams.addStringIfDefined("tags", self.tags)
        return kparams

    def getBitrate(self):
        return self.bitrate

    def setBitrate(self, newBitrate):
        self.bitrate = newBitrate

    def getWidth(self):
        return self.width

    def setWidth(self, newWidth):
        self.width = newWidth

    def getHeight(self):
        return self.height

    def setHeight(self, newHeight):
        self.height = newHeight

    def getTags(self):
        return self.tags

    def setTags(self, newTags):
        self.tags = newTags


# @package Kaltura
# @subpackage Client
class KalturaLiveStreamDetails(KalturaObjectBase):
    def __init__(self,
            primaryStreamStatus=NotImplemented,
            secondaryStreamStatus=NotImplemented,
            viewMode=NotImplemented,
            wasBroadcast=NotImplemented,
            broadcastStatus=NotImplemented):
        KalturaObjectBase.__init__(self)

        # The status of the primary stream
        # @var KalturaEntryServerNodeStatus
        self.primaryStreamStatus = primaryStreamStatus

        # The status of the secondary stream
        # @var KalturaEntryServerNodeStatus
        self.secondaryStreamStatus = secondaryStreamStatus

        # @var KalturaViewMode
        self.viewMode = viewMode

        # @var bool
        self.wasBroadcast = wasBroadcast

        # @var KalturaLiveStreamBroadcastStatus
        self.broadcastStatus = broadcastStatus


    PROPERTY_LOADERS = {
        'primaryStreamStatus': (KalturaEnumsFactory.createInt, "KalturaEntryServerNodeStatus"), 
        'secondaryStreamStatus': (KalturaEnumsFactory.createInt, "KalturaEntryServerNodeStatus"), 
        'viewMode': (KalturaEnumsFactory.createInt, "KalturaViewMode"), 
        'wasBroadcast': getXmlNodeBool, 
        'broadcastStatus': (KalturaEnumsFactory.createInt, "KalturaLiveStreamBroadcastStatus"), 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaLiveStreamDetails.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaLiveStreamDetails")
        kparams.addIntEnumIfDefined("primaryStreamStatus", self.primaryStreamStatus)
        kparams.addIntEnumIfDefined("secondaryStreamStatus", self.secondaryStreamStatus)
        kparams.addIntEnumIfDefined("viewMode", self.viewMode)
        kparams.addBoolIfDefined("wasBroadcast", self.wasBroadcast)
        kparams.addIntEnumIfDefined("broadcastStatus", self.broadcastStatus)
        return kparams

    def getPrimaryStreamStatus(self):
        return self.primaryStreamStatus

    def setPrimaryStreamStatus(self, newPrimaryStreamStatus):
        self.primaryStreamStatus = newPrimaryStreamStatus

    def getSecondaryStreamStatus(self):
        return self.secondaryStreamStatus

    def setSecondaryStreamStatus(self, newSecondaryStreamStatus):
        self.secondaryStreamStatus = newSecondaryStreamStatus

    def getViewMode(self):
        return self.viewMode

    def setViewMode(self, newViewMode):
        self.viewMode = newViewMode

    def getWasBroadcast(self):
        return self.wasBroadcast

    def setWasBroadcast(self, newWasBroadcast):
        self.wasBroadcast = newWasBroadcast

    def getBroadcastStatus(self):
        return self.broadcastStatus

    def setBroadcastStatus(self, newBroadcastStatus):
        self.broadcastStatus = newBroadcastStatus


# @package Kaltura
# @subpackage Client
class KalturaLiveStreamEntry(KalturaLiveEntry):
    def __init__(self,
            id=NotImplemented,
            name=NotImplemented,
            description=NotImplemented,
            partnerId=NotImplemented,
            userId=NotImplemented,
            creatorId=NotImplemented,
            tags=NotImplemented,
            adminTags=NotImplemented,
            categories=NotImplemented,
            categoriesIds=NotImplemented,
            status=NotImplemented,
            moderationStatus=NotImplemented,
            moderationCount=NotImplemented,
            type=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented,
            rank=NotImplemented,
            totalRank=NotImplemented,
            votes=NotImplemented,
            groupId=NotImplemented,
            partnerData=NotImplemented,
            downloadUrl=NotImplemented,
            searchText=NotImplemented,
            licenseType=NotImplemented,
            version=NotImplemented,
            thumbnailUrl=NotImplemented,
            accessControlId=NotImplemented,
            startDate=NotImplemented,
            endDate=NotImplemented,
            referenceId=NotImplemented,
            replacingEntryId=NotImplemented,
            replacedEntryId=NotImplemented,
            replacementStatus=NotImplemented,
            partnerSortValue=NotImplemented,
            conversionProfileId=NotImplemented,
            redirectEntryId=NotImplemented,
            rootEntryId=NotImplemented,
            parentEntryId=NotImplemented,
            operationAttributes=NotImplemented,
            entitledUsersEdit=NotImplemented,
            entitledUsersPublish=NotImplemented,
            entitledUsersView=NotImplemented,
            capabilities=NotImplemented,
            templateEntryId=NotImplemented,
            displayInSearch=NotImplemented,
            application=NotImplemented,
            applicationVersion=NotImplemented,
            blockAutoTranscript=NotImplemented,
            plays=NotImplemented,
            views=NotImplemented,
            lastPlayedAt=NotImplemented,
            width=NotImplemented,
            height=NotImplemented,
            duration=NotImplemented,
            msDuration=NotImplemented,
            durationType=NotImplemented,
            mediaType=NotImplemented,
            conversionQuality=NotImplemented,
            sourceType=NotImplemented,
            sourceVersion=NotImplemented,
            searchProviderType=NotImplemented,
            searchProviderId=NotImplemented,
            creditUserName=NotImplemented,
            creditUrl=NotImplemented,
            mediaDate=NotImplemented,
            dataUrl=NotImplemented,
            flavorParamsIds=NotImplemented,
            isTrimDisabled=NotImplemented,
            streams=NotImplemented,
            offlineMessage=NotImplemented,
            recordStatus=NotImplemented,
            dvrStatus=NotImplemented,
            dvrWindow=NotImplemented,
            lastElapsedRecordingTime=NotImplemented,
            liveStreamConfigurations=NotImplemented,
            recordedEntryId=NotImplemented,
            pushPublishEnabled=NotImplemented,
            publishConfigurations=NotImplemented,
            firstBroadcast=NotImplemented,
            lastBroadcast=NotImplemented,
            currentBroadcastStartTime=NotImplemented,
            recordingOptions=NotImplemented,
            liveStatus=NotImplemented,
            segmentDuration=NotImplemented,
            explicitLive=NotImplemented,
            viewMode=NotImplemented,
            recordingStatus=NotImplemented,
            lastBroadcastEndTime=NotImplemented,
            broadcastTime=NotImplemented,
            streamRemoteId=NotImplemented,
            streamRemoteBackupId=NotImplemented,
            bitrates=NotImplemented,
            primaryBroadcastingUrl=NotImplemented,
            secondaryBroadcastingUrl=NotImplemented,
            primarySecuredBroadcastingUrl=NotImplemented,
            secondarySecuredBroadcastingUrl=NotImplemented,
            primaryRtspBroadcastingUrl=NotImplemented,
            secondaryRtspBroadcastingUrl=NotImplemented,
            primarySrtBroadcastingUrl=NotImplemented,
            primarySrtStreamId=NotImplemented,
            secondarySrtBroadcastingUrl=NotImplemented,
            secondarySrtStreamId=NotImplemented,
            streamName=NotImplemented,
            streamUrl=NotImplemented,
            hlsStreamUrl=NotImplemented,
            urlManager=NotImplemented,
            encodingIP1=NotImplemented,
            encodingIP2=NotImplemented,
            streamPassword=NotImplemented,
            streamUsername=NotImplemented,
            srtPass=NotImplemented,
            primaryServerNodeId=NotImplemented,
            sipToken=NotImplemented,
            sipSourceType=NotImplemented):
        KalturaLiveEntry.__init__(self,
            id,
            name,
            description,
            partnerId,
            userId,
            creatorId,
            tags,
            adminTags,
            categories,
            categoriesIds,
            status,
            moderationStatus,
            moderationCount,
            type,
            createdAt,
            updatedAt,
            rank,
            totalRank,
            votes,
            groupId,
            partnerData,
            downloadUrl,
            searchText,
            licenseType,
            version,
            thumbnailUrl,
            accessControlId,
            startDate,
            endDate,
            referenceId,
            replacingEntryId,
            replacedEntryId,
            replacementStatus,
            partnerSortValue,
            conversionProfileId,
            redirectEntryId,
            rootEntryId,
            parentEntryId,
            operationAttributes,
            entitledUsersEdit,
            entitledUsersPublish,
            entitledUsersView,
            capabilities,
            templateEntryId,
            displayInSearch,
            application,
            applicationVersion,
            blockAutoTranscript,
            plays,
            views,
            lastPlayedAt,
            width,
            height,
            duration,
            msDuration,
            durationType,
            mediaType,
            conversionQuality,
            sourceType,
            sourceVersion,
            searchProviderType,
            searchProviderId,
            creditUserName,
            creditUrl,
            mediaDate,
            dataUrl,
            flavorParamsIds,
            isTrimDisabled,
            streams,
            offlineMessage,
            recordStatus,
            dvrStatus,
            dvrWindow,
            lastElapsedRecordingTime,
            liveStreamConfigurations,
            recordedEntryId,
            pushPublishEnabled,
            publishConfigurations,
            firstBroadcast,
            lastBroadcast,
            currentBroadcastStartTime,
            recordingOptions,
            liveStatus,
            segmentDuration,
            explicitLive,
            viewMode,
            recordingStatus,
            lastBroadcastEndTime,
            broadcastTime)

        # The stream id as provided by the provider
        # @var string
        # @readonly
        self.streamRemoteId = streamRemoteId

        # The backup stream id as provided by the provider
        # @var string
        # @readonly
        self.streamRemoteBackupId = streamRemoteBackupId

        # Array of supported bitrates
        # @var array of KalturaLiveStreamBitrate
        self.bitrates = bitrates

        # @var string
        self.primaryBroadcastingUrl = primaryBroadcastingUrl

        # @var string
        self.secondaryBroadcastingUrl = secondaryBroadcastingUrl

        # @var string
        self.primarySecuredBroadcastingUrl = primarySecuredBroadcastingUrl

        # @var string
        self.secondarySecuredBroadcastingUrl = secondarySecuredBroadcastingUrl

        # @var string
        self.primaryRtspBroadcastingUrl = primaryRtspBroadcastingUrl

        # @var string
        self.secondaryRtspBroadcastingUrl = secondaryRtspBroadcastingUrl

        # @var string
        self.primarySrtBroadcastingUrl = primarySrtBroadcastingUrl

        # @var string
        self.primarySrtStreamId = primarySrtStreamId

        # @var string
        self.secondarySrtBroadcastingUrl = secondarySrtBroadcastingUrl

        # @var string
        self.secondarySrtStreamId = secondarySrtStreamId

        # @var string
        self.streamName = streamName

        # The stream url
        # @var string
        self.streamUrl = streamUrl

        # HLS URL - URL for live stream playback on mobile device
        # @var string
        self.hlsStreamUrl = hlsStreamUrl

        # URL Manager to handle the live stream URL (for instance, add token)
        # @var string
        self.urlManager = urlManager

        # The broadcast primary ip
        # @var string
        self.encodingIP1 = encodingIP1

        # The broadcast secondary ip
        # @var string
        self.encodingIP2 = encodingIP2

        # The broadcast password
        # @var string
        self.streamPassword = streamPassword

        # The broadcast username
        # @var string
        # @readonly
        self.streamUsername = streamUsername

        # @var string
        self.srtPass = srtPass

        # The Streams primary server node id
        # @var int
        # @readonly
        self.primaryServerNodeId = primaryServerNodeId

        # @var string
        # @readonly
        self.sipToken = sipToken

        # @var KalturaSipSourceType
        # @readonly
        self.sipSourceType = sipSourceType


    PROPERTY_LOADERS = {
        'streamRemoteId': getXmlNodeText, 
        'streamRemoteBackupId': getXmlNodeText, 
        'bitrates': (KalturaObjectFactory.createArray, 'KalturaLiveStreamBitrate'), 
        'primaryBroadcastingUrl': getXmlNodeText, 
        'secondaryBroadcastingUrl': getXmlNodeText, 
        'primarySecuredBroadcastingUrl': getXmlNodeText, 
        'secondarySecuredBroadcastingUrl': getXmlNodeText, 
        'primaryRtspBroadcastingUrl': getXmlNodeText, 
        'secondaryRtspBroadcastingUrl': getXmlNodeText, 
        'primarySrtBroadcastingUrl': getXmlNodeText, 
        'primarySrtStreamId': getXmlNodeText, 
        'secondarySrtBroadcastingUrl': getXmlNodeText, 
        'secondarySrtStreamId': getXmlNodeText, 
        'streamName': getXmlNodeText, 
        'streamUrl': getXmlNodeText, 
        'hlsStreamUrl': getXmlNodeText, 
        'urlManager': getXmlNodeText, 
        'encodingIP1': getXmlNodeText, 
        'encodingIP2': getXmlNodeText, 
        'streamPassword': getXmlNodeText, 
        'streamUsername': getXmlNodeText, 
        'srtPass': getXmlNodeText, 
        'primaryServerNodeId': getXmlNodeInt, 
        'sipToken': getXmlNodeText, 
        'sipSourceType': (KalturaEnumsFactory.createInt, "KalturaSipSourceType"), 
    }

    def fromXml(self, node):
        KalturaLiveEntry.fromXml(self, node)
        self.fromXmlImpl(node, KalturaLiveStreamEntry.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaLiveEntry.toParams(self)
        kparams.put("objectType", "KalturaLiveStreamEntry")
        kparams.addArrayIfDefined("bitrates", self.bitrates)
        kparams.addStringIfDefined("primaryBroadcastingUrl", self.primaryBroadcastingUrl)
        kparams.addStringIfDefined("secondaryBroadcastingUrl", self.secondaryBroadcastingUrl)
        kparams.addStringIfDefined("primarySecuredBroadcastingUrl", self.primarySecuredBroadcastingUrl)
        kparams.addStringIfDefined("secondarySecuredBroadcastingUrl", self.secondarySecuredBroadcastingUrl)
        kparams.addStringIfDefined("primaryRtspBroadcastingUrl", self.primaryRtspBroadcastingUrl)
        kparams.addStringIfDefined("secondaryRtspBroadcastingUrl", self.secondaryRtspBroadcastingUrl)
        kparams.addStringIfDefined("primarySrtBroadcastingUrl", self.primarySrtBroadcastingUrl)
        kparams.addStringIfDefined("primarySrtStreamId", self.primarySrtStreamId)
        kparams.addStringIfDefined("secondarySrtBroadcastingUrl", self.secondarySrtBroadcastingUrl)
        kparams.addStringIfDefined("secondarySrtStreamId", self.secondarySrtStreamId)
        kparams.addStringIfDefined("streamName", self.streamName)
        kparams.addStringIfDefined("streamUrl", self.streamUrl)
        kparams.addStringIfDefined("hlsStreamUrl", self.hlsStreamUrl)
        kparams.addStringIfDefined("urlManager", self.urlManager)
        kparams.addStringIfDefined("encodingIP1", self.encodingIP1)
        kparams.addStringIfDefined("encodingIP2", self.encodingIP2)
        kparams.addStringIfDefined("streamPassword", self.streamPassword)
        kparams.addStringIfDefined("srtPass", self.srtPass)
        return kparams

    def getStreamRemoteId(self):
        return self.streamRemoteId

    def getStreamRemoteBackupId(self):
        return self.streamRemoteBackupId

    def getBitrates(self):
        return self.bitrates

    def setBitrates(self, newBitrates):
        self.bitrates = newBitrates

    def getPrimaryBroadcastingUrl(self):
        return self.primaryBroadcastingUrl

    def setPrimaryBroadcastingUrl(self, newPrimaryBroadcastingUrl):
        self.primaryBroadcastingUrl = newPrimaryBroadcastingUrl

    def getSecondaryBroadcastingUrl(self):
        return self.secondaryBroadcastingUrl

    def setSecondaryBroadcastingUrl(self, newSecondaryBroadcastingUrl):
        self.secondaryBroadcastingUrl = newSecondaryBroadcastingUrl

    def getPrimarySecuredBroadcastingUrl(self):
        return self.primarySecuredBroadcastingUrl

    def setPrimarySecuredBroadcastingUrl(self, newPrimarySecuredBroadcastingUrl):
        self.primarySecuredBroadcastingUrl = newPrimarySecuredBroadcastingUrl

    def getSecondarySecuredBroadcastingUrl(self):
        return self.secondarySecuredBroadcastingUrl

    def setSecondarySecuredBroadcastingUrl(self, newSecondarySecuredBroadcastingUrl):
        self.secondarySecuredBroadcastingUrl = newSecondarySecuredBroadcastingUrl

    def getPrimaryRtspBroadcastingUrl(self):
        return self.primaryRtspBroadcastingUrl

    def setPrimaryRtspBroadcastingUrl(self, newPrimaryRtspBroadcastingUrl):
        self.primaryRtspBroadcastingUrl = newPrimaryRtspBroadcastingUrl

    def getSecondaryRtspBroadcastingUrl(self):
        return self.secondaryRtspBroadcastingUrl

    def setSecondaryRtspBroadcastingUrl(self, newSecondaryRtspBroadcastingUrl):
        self.secondaryRtspBroadcastingUrl = newSecondaryRtspBroadcastingUrl

    def getPrimarySrtBroadcastingUrl(self):
        return self.primarySrtBroadcastingUrl

    def setPrimarySrtBroadcastingUrl(self, newPrimarySrtBroadcastingUrl):
        self.primarySrtBroadcastingUrl = newPrimarySrtBroadcastingUrl

    def getPrimarySrtStreamId(self):
        return self.primarySrtStreamId

    def setPrimarySrtStreamId(self, newPrimarySrtStreamId):
        self.primarySrtStreamId = newPrimarySrtStreamId

    def getSecondarySrtBroadcastingUrl(self):
        return self.secondarySrtBroadcastingUrl

    def setSecondarySrtBroadcastingUrl(self, newSecondarySrtBroadcastingUrl):
        self.secondarySrtBroadcastingUrl = newSecondarySrtBroadcastingUrl

    def getSecondarySrtStreamId(self):
        return self.secondarySrtStreamId

    def setSecondarySrtStreamId(self, newSecondarySrtStreamId):
        self.secondarySrtStreamId = newSecondarySrtStreamId

    def getStreamName(self):
        return self.streamName

    def setStreamName(self, newStreamName):
        self.streamName = newStreamName

    def getStreamUrl(self):
        return self.streamUrl

    def setStreamUrl(self, newStreamUrl):
        self.streamUrl = newStreamUrl

    def getHlsStreamUrl(self):
        return self.hlsStreamUrl

    def setHlsStreamUrl(self, newHlsStreamUrl):
        self.hlsStreamUrl = newHlsStreamUrl

    def getUrlManager(self):
        return self.urlManager

    def setUrlManager(self, newUrlManager):
        self.urlManager = newUrlManager

    def getEncodingIP1(self):
        return self.encodingIP1

    def setEncodingIP1(self, newEncodingIP1):
        self.encodingIP1 = newEncodingIP1

    def getEncodingIP2(self):
        return self.encodingIP2

    def setEncodingIP2(self, newEncodingIP2):
        self.encodingIP2 = newEncodingIP2

    def getStreamPassword(self):
        return self.streamPassword

    def setStreamPassword(self, newStreamPassword):
        self.streamPassword = newStreamPassword

    def getStreamUsername(self):
        return self.streamUsername

    def getSrtPass(self):
        return self.srtPass

    def setSrtPass(self, newSrtPass):
        self.srtPass = newSrtPass

    def getPrimaryServerNodeId(self):
        return self.primaryServerNodeId

    def getSipToken(self):
        return self.sipToken

    def getSipSourceType(self):
        return self.sipSourceType


# @package Kaltura
# @subpackage Client
class KalturaLiveStreamParams(KalturaObjectBase):
    def __init__(self,
            bitrate=NotImplemented,
            flavorId=NotImplemented,
            width=NotImplemented,
            height=NotImplemented,
            codec=NotImplemented,
            frameRate=NotImplemented,
            keyFrameInterval=NotImplemented,
            language=NotImplemented):
        KalturaObjectBase.__init__(self)

        # Bit rate of the stream. (i.e. 900)
        # @var int
        self.bitrate = bitrate

        # flavor asset id
        # @var string
        self.flavorId = flavorId

        # Stream's width
        # @var int
        self.width = width

        # Stream's height
        # @var int
        self.height = height

        # Live stream's codec
        # @var string
        self.codec = codec

        # Live stream's farme rate
        # @var int
        self.frameRate = frameRate

        # Live stream's key frame interval
        # @var float
        self.keyFrameInterval = keyFrameInterval

        # Live stream's language
        # @var string
        self.language = language


    PROPERTY_LOADERS = {
        'bitrate': getXmlNodeInt, 
        'flavorId': getXmlNodeText, 
        'width': getXmlNodeInt, 
        'height': getXmlNodeInt, 
        'codec': getXmlNodeText, 
        'frameRate': getXmlNodeInt, 
        'keyFrameInterval': getXmlNodeFloat, 
        'language': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaLiveStreamParams.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaLiveStreamParams")
        kparams.addIntIfDefined("bitrate", self.bitrate)
        kparams.addStringIfDefined("flavorId", self.flavorId)
        kparams.addIntIfDefined("width", self.width)
        kparams.addIntIfDefined("height", self.height)
        kparams.addStringIfDefined("codec", self.codec)
        kparams.addIntIfDefined("frameRate", self.frameRate)
        kparams.addFloatIfDefined("keyFrameInterval", self.keyFrameInterval)
        kparams.addStringIfDefined("language", self.language)
        return kparams

    def getBitrate(self):
        return self.bitrate

    def setBitrate(self, newBitrate):
        self.bitrate = newBitrate

    def getFlavorId(self):
        return self.flavorId

    def setFlavorId(self, newFlavorId):
        self.flavorId = newFlavorId

    def getWidth(self):
        return self.width

    def setWidth(self, newWidth):
        self.width = newWidth

    def getHeight(self):
        return self.height

    def setHeight(self, newHeight):
        self.height = newHeight

    def getCodec(self):
        return self.codec

    def setCodec(self, newCodec):
        self.codec = newCodec

    def getFrameRate(self):
        return self.frameRate

    def setFrameRate(self, newFrameRate):
        self.frameRate = newFrameRate

    def getKeyFrameInterval(self):
        return self.keyFrameInterval

    def setKeyFrameInterval(self, newKeyFrameInterval):
        self.keyFrameInterval = newKeyFrameInterval

    def getLanguage(self):
        return self.language

    def setLanguage(self, newLanguage):
        self.language = newLanguage


# @package Kaltura
# @subpackage Client
class KalturaBaseEntryBaseFilter(KalturaRelatedFilter):
    def __init__(self,
            orderBy=NotImplemented,
            advancedSearch=NotImplemented,
            idEqual=NotImplemented,
            idIn=NotImplemented,
            idNotIn=NotImplemented,
            nameLike=NotImplemented,
            nameMultiLikeOr=NotImplemented,
            nameMultiLikeAnd=NotImplemented,
            nameEqual=NotImplemented,
            partnerIdEqual=NotImplemented,
            partnerIdIn=NotImplemented,
            userIdEqual=NotImplemented,
            userIdIn=NotImplemented,
            userIdNotIn=NotImplemented,
            creatorIdEqual=NotImplemented,
            tagsLike=NotImplemented,
            tagsMultiLikeOr=NotImplemented,
            tagsMultiLikeAnd=NotImplemented,
            adminTagsLike=NotImplemented,
            adminTagsMultiLikeOr=NotImplemented,
            adminTagsMultiLikeAnd=NotImplemented,
            categoriesMatchAnd=NotImplemented,
            categoriesMatchOr=NotImplemented,
            categoriesNotContains=NotImplemented,
            categoriesIdsMatchAnd=NotImplemented,
            categoriesIdsMatchOr=NotImplemented,
            categoriesIdsNotContains=NotImplemented,
            categoriesIdsEmpty=NotImplemented,
            statusEqual=NotImplemented,
            statusNotEqual=NotImplemented,
            statusIn=NotImplemented,
            statusNotIn=NotImplemented,
            moderationStatusEqual=NotImplemented,
            moderationStatusNotEqual=NotImplemented,
            moderationStatusIn=NotImplemented,
            moderationStatusNotIn=NotImplemented,
            typeEqual=NotImplemented,
            typeIn=NotImplemented,
            createdAtGreaterThanOrEqual=NotImplemented,
            createdAtLessThanOrEqual=NotImplemented,
            updatedAtGreaterThanOrEqual=NotImplemented,
            updatedAtLessThanOrEqual=NotImplemented,
            rankLessThanOrEqual=NotImplemented,
            rankGreaterThanOrEqual=NotImplemented,
            totalRankLessThanOrEqual=NotImplemented,
            totalRankGreaterThanOrEqual=NotImplemented,
            groupIdEqual=NotImplemented,
            searchTextMatchAnd=NotImplemented,
            searchTextMatchOr=NotImplemented,
            accessControlIdEqual=NotImplemented,
            accessControlIdIn=NotImplemented,
            startDateGreaterThanOrEqual=NotImplemented,
            startDateLessThanOrEqual=NotImplemented,
            startDateGreaterThanOrEqualOrNull=NotImplemented,
            startDateLessThanOrEqualOrNull=NotImplemented,
            endDateGreaterThanOrEqual=NotImplemented,
            endDateLessThanOrEqual=NotImplemented,
            endDateGreaterThanOrEqualOrNull=NotImplemented,
            endDateLessThanOrEqualOrNull=NotImplemented,
            referenceIdEqual=NotImplemented,
            referenceIdIn=NotImplemented,
            replacingEntryIdEqual=NotImplemented,
            replacingEntryIdIn=NotImplemented,
            replacedEntryIdEqual=NotImplemented,
            replacedEntryIdIn=NotImplemented,
            replacementStatusEqual=NotImplemented,
            replacementStatusIn=NotImplemented,
            partnerSortValueGreaterThanOrEqual=NotImplemented,
            partnerSortValueLessThanOrEqual=NotImplemented,
            rootEntryIdEqual=NotImplemented,
            rootEntryIdIn=NotImplemented,
            parentEntryIdEqual=NotImplemented,
            entitledUsersEditMatchAnd=NotImplemented,
            entitledUsersEditMatchOr=NotImplemented,
            entitledUsersPublishMatchAnd=NotImplemented,
            entitledUsersPublishMatchOr=NotImplemented,
            entitledUsersViewMatchAnd=NotImplemented,
            entitledUsersViewMatchOr=NotImplemented,
            tagsNameMultiLikeOr=NotImplemented,
            tagsAdminTagsMultiLikeOr=NotImplemented,
            tagsAdminTagsNameMultiLikeOr=NotImplemented,
            tagsNameMultiLikeAnd=NotImplemented,
            tagsAdminTagsMultiLikeAnd=NotImplemented,
            tagsAdminTagsNameMultiLikeAnd=NotImplemented):
        KalturaRelatedFilter.__init__(self,
            orderBy,
            advancedSearch)

        # This filter should be in use for retrieving only a specific entry (identified by its entryId).
        # @var string
        self.idEqual = idEqual

        # This filter should be in use for retrieving few specific entries (string should include comma separated list of entryId strings).
        # @var string
        self.idIn = idIn

        # @var string
        self.idNotIn = idNotIn

        # This filter should be in use for retrieving specific entries. It should include only one string to search for in entry names (no wildcards, spaces are treated as part of the string).
        # @var string
        self.nameLike = nameLike

        # This filter should be in use for retrieving specific entries. It could include few (comma separated) strings for searching in entry names, while applying an OR logic to retrieve entries that contain at least one input string (no wildcards, spaces are treated as part of the string).
        # @var string
        self.nameMultiLikeOr = nameMultiLikeOr

        # This filter should be in use for retrieving specific entries. It could include few (comma separated) strings for searching in entry names, while applying an AND logic to retrieve entries that contain all input strings (no wildcards, spaces are treated as part of the string).
        # @var string
        self.nameMultiLikeAnd = nameMultiLikeAnd

        # This filter should be in use for retrieving entries with a specific name.
        # @var string
        self.nameEqual = nameEqual

        # This filter should be in use for retrieving only entries which were uploaded by/assigned to users of a specific Kaltura Partner (identified by Partner ID).
        # @var int
        self.partnerIdEqual = partnerIdEqual

        # This filter should be in use for retrieving only entries within Kaltura network which were uploaded by/assigned to users of few Kaltura Partners  (string should include comma separated list of PartnerIDs)
        # @var string
        self.partnerIdIn = partnerIdIn

        # This filter parameter should be in use for retrieving only entries, uploaded by/assigned to a specific user (identified by user Id).
        # @var string
        self.userIdEqual = userIdEqual

        # @var string
        self.userIdIn = userIdIn

        # @var string
        self.userIdNotIn = userIdNotIn

        # @var string
        self.creatorIdEqual = creatorIdEqual

        # This filter should be in use for retrieving specific entries. It should include only one string to search for in entry tags (no wildcards, spaces are treated as part of the string).
        # @var string
        self.tagsLike = tagsLike

        # This filter should be in use for retrieving specific entries. It could include few (comma separated) strings for searching in entry tags, while applying an OR logic to retrieve entries that contain at least one input string (no wildcards, spaces are treated as part of the string).
        # @var string
        self.tagsMultiLikeOr = tagsMultiLikeOr

        # This filter should be in use for retrieving specific entries. It could include few (comma separated) strings for searching in entry tags, while applying an AND logic to retrieve entries that contain all input strings (no wildcards, spaces are treated as part of the string).
        # @var string
        self.tagsMultiLikeAnd = tagsMultiLikeAnd

        # This filter should be in use for retrieving specific entries. It should include only one string to search for in entry tags set by an ADMIN user (no wildcards, spaces are treated as part of the string).
        # @var string
        self.adminTagsLike = adminTagsLike

        # This filter should be in use for retrieving specific entries. It could include few (comma separated) strings for searching in entry tags, set by an ADMIN user, while applying an OR logic to retrieve entries that contain at least one input string (no wildcards, spaces are treated as part of the string).
        # @var string
        self.adminTagsMultiLikeOr = adminTagsMultiLikeOr

        # This filter should be in use for retrieving specific entries. It could include few (comma separated) strings for searching in entry tags, set by an ADMIN user, while applying an AND logic to retrieve entries that contain all input strings (no wildcards, spaces are treated as part of the string).
        # @var string
        self.adminTagsMultiLikeAnd = adminTagsMultiLikeAnd

        # @var string
        self.categoriesMatchAnd = categoriesMatchAnd

        # All entries within these categories or their child categories.
        # @var string
        self.categoriesMatchOr = categoriesMatchOr

        # @var string
        self.categoriesNotContains = categoriesNotContains

        # @var string
        self.categoriesIdsMatchAnd = categoriesIdsMatchAnd

        # All entries of the categories, excluding their child categories.
        # 	 To include entries of the child categories, use categoryAncestorIdIn, or categoriesMatchOr.
        # @var string
        self.categoriesIdsMatchOr = categoriesIdsMatchOr

        # @var string
        self.categoriesIdsNotContains = categoriesIdsNotContains

        # @var KalturaNullableBoolean
        self.categoriesIdsEmpty = categoriesIdsEmpty

        # This filter should be in use for retrieving only entries, at a specific {
        # @var KalturaEntryStatus
        self.statusEqual = statusEqual

        # This filter should be in use for retrieving only entries, not at a specific {
        # @var KalturaEntryStatus
        self.statusNotEqual = statusNotEqual

        # This filter should be in use for retrieving only entries, at few specific {
        # @var string
        self.statusIn = statusIn

        # This filter should be in use for retrieving only entries, not at few specific {
        # @var string
        self.statusNotIn = statusNotIn

        # @var KalturaEntryModerationStatus
        self.moderationStatusEqual = moderationStatusEqual

        # @var KalturaEntryModerationStatus
        self.moderationStatusNotEqual = moderationStatusNotEqual

        # @var string
        self.moderationStatusIn = moderationStatusIn

        # @var string
        self.moderationStatusNotIn = moderationStatusNotIn

        # @var KalturaEntryType
        self.typeEqual = typeEqual

        # This filter should be in use for retrieving entries of few {
        # @var string
        self.typeIn = typeIn

        # This filter parameter should be in use for retrieving only entries which were created at Kaltura system after a specific time/date (standard timestamp format).
        # @var int
        self.createdAtGreaterThanOrEqual = createdAtGreaterThanOrEqual

        # This filter parameter should be in use for retrieving only entries which were created at Kaltura system before a specific time/date (standard timestamp format).
        # @var int
        self.createdAtLessThanOrEqual = createdAtLessThanOrEqual

        # @var int
        self.updatedAtGreaterThanOrEqual = updatedAtGreaterThanOrEqual

        # @var int
        self.updatedAtLessThanOrEqual = updatedAtLessThanOrEqual

        # @var float
        self.rankLessThanOrEqual = rankLessThanOrEqual

        # @var float
        self.rankGreaterThanOrEqual = rankGreaterThanOrEqual

        # @var int
        self.totalRankLessThanOrEqual = totalRankLessThanOrEqual

        # @var int
        self.totalRankGreaterThanOrEqual = totalRankGreaterThanOrEqual

        # @var int
        self.groupIdEqual = groupIdEqual

        # This filter should be in use for retrieving specific entries while search match the input string within all of the following metadata attributes: name, description, tags, adminTags.
        # @var string
        self.searchTextMatchAnd = searchTextMatchAnd

        # This filter should be in use for retrieving specific entries while search match the input string within at least one of the following metadata attributes: name, description, tags, adminTags.
        # @var string
        self.searchTextMatchOr = searchTextMatchOr

        # @var int
        self.accessControlIdEqual = accessControlIdEqual

        # @var string
        self.accessControlIdIn = accessControlIdIn

        # @var int
        self.startDateGreaterThanOrEqual = startDateGreaterThanOrEqual

        # @var int
        self.startDateLessThanOrEqual = startDateLessThanOrEqual

        # @var int
        self.startDateGreaterThanOrEqualOrNull = startDateGreaterThanOrEqualOrNull

        # @var int
        self.startDateLessThanOrEqualOrNull = startDateLessThanOrEqualOrNull

        # @var int
        self.endDateGreaterThanOrEqual = endDateGreaterThanOrEqual

        # @var int
        self.endDateLessThanOrEqual = endDateLessThanOrEqual

        # @var int
        self.endDateGreaterThanOrEqualOrNull = endDateGreaterThanOrEqualOrNull

        # @var int
        self.endDateLessThanOrEqualOrNull = endDateLessThanOrEqualOrNull

        # @var string
        self.referenceIdEqual = referenceIdEqual

        # @var string
        self.referenceIdIn = referenceIdIn

        # @var string
        self.replacingEntryIdEqual = replacingEntryIdEqual

        # @var string
        self.replacingEntryIdIn = replacingEntryIdIn

        # @var string
        self.replacedEntryIdEqual = replacedEntryIdEqual

        # @var string
        self.replacedEntryIdIn = replacedEntryIdIn

        # @var KalturaEntryReplacementStatus
        self.replacementStatusEqual = replacementStatusEqual

        # @var string
        self.replacementStatusIn = replacementStatusIn

        # @var int
        self.partnerSortValueGreaterThanOrEqual = partnerSortValueGreaterThanOrEqual

        # @var int
        self.partnerSortValueLessThanOrEqual = partnerSortValueLessThanOrEqual

        # @var string
        self.rootEntryIdEqual = rootEntryIdEqual

        # @var string
        self.rootEntryIdIn = rootEntryIdIn

        # @var string
        self.parentEntryIdEqual = parentEntryIdEqual

        # @var string
        self.entitledUsersEditMatchAnd = entitledUsersEditMatchAnd

        # @var string
        self.entitledUsersEditMatchOr = entitledUsersEditMatchOr

        # @var string
        self.entitledUsersPublishMatchAnd = entitledUsersPublishMatchAnd

        # @var string
        self.entitledUsersPublishMatchOr = entitledUsersPublishMatchOr

        # @var string
        self.entitledUsersViewMatchAnd = entitledUsersViewMatchAnd

        # @var string
        self.entitledUsersViewMatchOr = entitledUsersViewMatchOr

        # @var string
        self.tagsNameMultiLikeOr = tagsNameMultiLikeOr

        # @var string
        self.tagsAdminTagsMultiLikeOr = tagsAdminTagsMultiLikeOr

        # @var string
        self.tagsAdminTagsNameMultiLikeOr = tagsAdminTagsNameMultiLikeOr

        # @var string
        self.tagsNameMultiLikeAnd = tagsNameMultiLikeAnd

        # @var string
        self.tagsAdminTagsMultiLikeAnd = tagsAdminTagsMultiLikeAnd

        # @var string
        self.tagsAdminTagsNameMultiLikeAnd = tagsAdminTagsNameMultiLikeAnd


    PROPERTY_LOADERS = {
        'idEqual': getXmlNodeText, 
        'idIn': getXmlNodeText, 
        'idNotIn': getXmlNodeText, 
        'nameLike': getXmlNodeText, 
        'nameMultiLikeOr': getXmlNodeText, 
        'nameMultiLikeAnd': getXmlNodeText, 
        'nameEqual': getXmlNodeText, 
        'partnerIdEqual': getXmlNodeInt, 
        'partnerIdIn': getXmlNodeText, 
        'userIdEqual': getXmlNodeText, 
        'userIdIn': getXmlNodeText, 
        'userIdNotIn': getXmlNodeText, 
        'creatorIdEqual': getXmlNodeText, 
        'tagsLike': getXmlNodeText, 
        'tagsMultiLikeOr': getXmlNodeText, 
        'tagsMultiLikeAnd': getXmlNodeText, 
        'adminTagsLike': getXmlNodeText, 
        'adminTagsMultiLikeOr': getXmlNodeText, 
        'adminTagsMultiLikeAnd': getXmlNodeText, 
        'categoriesMatchAnd': getXmlNodeText, 
        'categoriesMatchOr': getXmlNodeText, 
        'categoriesNotContains': getXmlNodeText, 
        'categoriesIdsMatchAnd': getXmlNodeText, 
        'categoriesIdsMatchOr': getXmlNodeText, 
        'categoriesIdsNotContains': getXmlNodeText, 
        'categoriesIdsEmpty': (KalturaEnumsFactory.createInt, "KalturaNullableBoolean"), 
        'statusEqual': (KalturaEnumsFactory.createString, "KalturaEntryStatus"), 
        'statusNotEqual': (KalturaEnumsFactory.createString, "KalturaEntryStatus"), 
        'statusIn': getXmlNodeText, 
        'statusNotIn': getXmlNodeText, 
        'moderationStatusEqual': (KalturaEnumsFactory.createInt, "KalturaEntryModerationStatus"), 
        'moderationStatusNotEqual': (KalturaEnumsFactory.createInt, "KalturaEntryModerationStatus"), 
        'moderationStatusIn': getXmlNodeText, 
        'moderationStatusNotIn': getXmlNodeText, 
        'typeEqual': (KalturaEnumsFactory.createString, "KalturaEntryType"), 
        'typeIn': getXmlNodeText, 
        'createdAtGreaterThanOrEqual': getXmlNodeInt, 
        'createdAtLessThanOrEqual': getXmlNodeInt, 
        'updatedAtGreaterThanOrEqual': getXmlNodeInt, 
        'updatedAtLessThanOrEqual': getXmlNodeInt, 
        'rankLessThanOrEqual': getXmlNodeFloat, 
        'rankGreaterThanOrEqual': getXmlNodeFloat, 
        'totalRankLessThanOrEqual': getXmlNodeInt, 
        'totalRankGreaterThanOrEqual': getXmlNodeInt, 
        'groupIdEqual': getXmlNodeInt, 
        'searchTextMatchAnd': getXmlNodeText, 
        'searchTextMatchOr': getXmlNodeText, 
        'accessControlIdEqual': getXmlNodeInt, 
        'accessControlIdIn': getXmlNodeText, 
        'startDateGreaterThanOrEqual': getXmlNodeInt, 
        'startDateLessThanOrEqual': getXmlNodeInt, 
        'startDateGreaterThanOrEqualOrNull': getXmlNodeInt, 
        'startDateLessThanOrEqualOrNull': getXmlNodeInt, 
        'endDateGreaterThanOrEqual': getXmlNodeInt, 
        'endDateLessThanOrEqual': getXmlNodeInt, 
        'endDateGreaterThanOrEqualOrNull': getXmlNodeInt, 
        'endDateLessThanOrEqualOrNull': getXmlNodeInt, 
        'referenceIdEqual': getXmlNodeText, 
        'referenceIdIn': getXmlNodeText, 
        'replacingEntryIdEqual': getXmlNodeText, 
        'replacingEntryIdIn': getXmlNodeText, 
        'replacedEntryIdEqual': getXmlNodeText, 
        'replacedEntryIdIn': getXmlNodeText, 
        'replacementStatusEqual': (KalturaEnumsFactory.createString, "KalturaEntryReplacementStatus"), 
        'replacementStatusIn': getXmlNodeText, 
        'partnerSortValueGreaterThanOrEqual': getXmlNodeInt, 
        'partnerSortValueLessThanOrEqual': getXmlNodeInt, 
        'rootEntryIdEqual': getXmlNodeText, 
        'rootEntryIdIn': getXmlNodeText, 
        'parentEntryIdEqual': getXmlNodeText, 
        'entitledUsersEditMatchAnd': getXmlNodeText, 
        'entitledUsersEditMatchOr': getXmlNodeText, 
        'entitledUsersPublishMatchAnd': getXmlNodeText, 
        'entitledUsersPublishMatchOr': getXmlNodeText, 
        'entitledUsersViewMatchAnd': getXmlNodeText, 
        'entitledUsersViewMatchOr': getXmlNodeText, 
        'tagsNameMultiLikeOr': getXmlNodeText, 
        'tagsAdminTagsMultiLikeOr': getXmlNodeText, 
        'tagsAdminTagsNameMultiLikeOr': getXmlNodeText, 
        'tagsNameMultiLikeAnd': getXmlNodeText, 
        'tagsAdminTagsMultiLikeAnd': getXmlNodeText, 
        'tagsAdminTagsNameMultiLikeAnd': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaRelatedFilter.fromXml(self, node)
        self.fromXmlImpl(node, KalturaBaseEntryBaseFilter.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaRelatedFilter.toParams(self)
        kparams.put("objectType", "KalturaBaseEntryBaseFilter")
        kparams.addStringIfDefined("idEqual", self.idEqual)
        kparams.addStringIfDefined("idIn", self.idIn)
        kparams.addStringIfDefined("idNotIn", self.idNotIn)
        kparams.addStringIfDefined("nameLike", self.nameLike)
        kparams.addStringIfDefined("nameMultiLikeOr", self.nameMultiLikeOr)
        kparams.addStringIfDefined("nameMultiLikeAnd", self.nameMultiLikeAnd)
        kparams.addStringIfDefined("nameEqual", self.nameEqual)
        kparams.addIntIfDefined("partnerIdEqual", self.partnerIdEqual)
        kparams.addStringIfDefined("partnerIdIn", self.partnerIdIn)
        kparams.addStringIfDefined("userIdEqual", self.userIdEqual)
        kparams.addStringIfDefined("userIdIn", self.userIdIn)
        kparams.addStringIfDefined("userIdNotIn", self.userIdNotIn)
        kparams.addStringIfDefined("creatorIdEqual", self.creatorIdEqual)
        kparams.addStringIfDefined("tagsLike", self.tagsLike)
        kparams.addStringIfDefined("tagsMultiLikeOr", self.tagsMultiLikeOr)
        kparams.addStringIfDefined("tagsMultiLikeAnd", self.tagsMultiLikeAnd)
        kparams.addStringIfDefined("adminTagsLike", self.adminTagsLike)
        kparams.addStringIfDefined("adminTagsMultiLikeOr", self.adminTagsMultiLikeOr)
        kparams.addStringIfDefined("adminTagsMultiLikeAnd", self.adminTagsMultiLikeAnd)
        kparams.addStringIfDefined("categoriesMatchAnd", self.categoriesMatchAnd)
        kparams.addStringIfDefined("categoriesMatchOr", self.categoriesMatchOr)
        kparams.addStringIfDefined("categoriesNotContains", self.categoriesNotContains)
        kparams.addStringIfDefined("categoriesIdsMatchAnd", self.categoriesIdsMatchAnd)
        kparams.addStringIfDefined("categoriesIdsMatchOr", self.categoriesIdsMatchOr)
        kparams.addStringIfDefined("categoriesIdsNotContains", self.categoriesIdsNotContains)
        kparams.addIntEnumIfDefined("categoriesIdsEmpty", self.categoriesIdsEmpty)
        kparams.addStringEnumIfDefined("statusEqual", self.statusEqual)
        kparams.addStringEnumIfDefined("statusNotEqual", self.statusNotEqual)
        kparams.addStringIfDefined("statusIn", self.statusIn)
        kparams.addStringIfDefined("statusNotIn", self.statusNotIn)
        kparams.addIntEnumIfDefined("moderationStatusEqual", self.moderationStatusEqual)
        kparams.addIntEnumIfDefined("moderationStatusNotEqual", self.moderationStatusNotEqual)
        kparams.addStringIfDefined("moderationStatusIn", self.moderationStatusIn)
        kparams.addStringIfDefined("moderationStatusNotIn", self.moderationStatusNotIn)
        kparams.addStringEnumIfDefined("typeEqual", self.typeEqual)
        kparams.addStringIfDefined("typeIn", self.typeIn)
        kparams.addIntIfDefined("createdAtGreaterThanOrEqual", self.createdAtGreaterThanOrEqual)
        kparams.addIntIfDefined("createdAtLessThanOrEqual", self.createdAtLessThanOrEqual)
        kparams.addIntIfDefined("updatedAtGreaterThanOrEqual", self.updatedAtGreaterThanOrEqual)
        kparams.addIntIfDefined("updatedAtLessThanOrEqual", self.updatedAtLessThanOrEqual)
        kparams.addFloatIfDefined("rankLessThanOrEqual", self.rankLessThanOrEqual)
        kparams.addFloatIfDefined("rankGreaterThanOrEqual", self.rankGreaterThanOrEqual)
        kparams.addIntIfDefined("totalRankLessThanOrEqual", self.totalRankLessThanOrEqual)
        kparams.addIntIfDefined("totalRankGreaterThanOrEqual", self.totalRankGreaterThanOrEqual)
        kparams.addIntIfDefined("groupIdEqual", self.groupIdEqual)
        kparams.addStringIfDefined("searchTextMatchAnd", self.searchTextMatchAnd)
        kparams.addStringIfDefined("searchTextMatchOr", self.searchTextMatchOr)
        kparams.addIntIfDefined("accessControlIdEqual", self.accessControlIdEqual)
        kparams.addStringIfDefined("accessControlIdIn", self.accessControlIdIn)
        kparams.addIntIfDefined("startDateGreaterThanOrEqual", self.startDateGreaterThanOrEqual)
        kparams.addIntIfDefined("startDateLessThanOrEqual", self.startDateLessThanOrEqual)
        kparams.addIntIfDefined("startDateGreaterThanOrEqualOrNull", self.startDateGreaterThanOrEqualOrNull)
        kparams.addIntIfDefined("startDateLessThanOrEqualOrNull", self.startDateLessThanOrEqualOrNull)
        kparams.addIntIfDefined("endDateGreaterThanOrEqual", self.endDateGreaterThanOrEqual)
        kparams.addIntIfDefined("endDateLessThanOrEqual", self.endDateLessThanOrEqual)
        kparams.addIntIfDefined("endDateGreaterThanOrEqualOrNull", self.endDateGreaterThanOrEqualOrNull)
        kparams.addIntIfDefined("endDateLessThanOrEqualOrNull", self.endDateLessThanOrEqualOrNull)
        kparams.addStringIfDefined("referenceIdEqual", self.referenceIdEqual)
        kparams.addStringIfDefined("referenceIdIn", self.referenceIdIn)
        kparams.addStringIfDefined("replacingEntryIdEqual", self.replacingEntryIdEqual)
        kparams.addStringIfDefined("replacingEntryIdIn", self.replacingEntryIdIn)
        kparams.addStringIfDefined("replacedEntryIdEqual", self.replacedEntryIdEqual)
        kparams.addStringIfDefined("replacedEntryIdIn", self.replacedEntryIdIn)
        kparams.addStringEnumIfDefined("replacementStatusEqual", self.replacementStatusEqual)
        kparams.addStringIfDefined("replacementStatusIn", self.replacementStatusIn)
        kparams.addIntIfDefined("partnerSortValueGreaterThanOrEqual", self.partnerSortValueGreaterThanOrEqual)
        kparams.addIntIfDefined("partnerSortValueLessThanOrEqual", self.partnerSortValueLessThanOrEqual)
        kparams.addStringIfDefined("rootEntryIdEqual", self.rootEntryIdEqual)
        kparams.addStringIfDefined("rootEntryIdIn", self.rootEntryIdIn)
        kparams.addStringIfDefined("parentEntryIdEqual", self.parentEntryIdEqual)
        kparams.addStringIfDefined("entitledUsersEditMatchAnd", self.entitledUsersEditMatchAnd)
        kparams.addStringIfDefined("entitledUsersEditMatchOr", self.entitledUsersEditMatchOr)
        kparams.addStringIfDefined("entitledUsersPublishMatchAnd", self.entitledUsersPublishMatchAnd)
        kparams.addStringIfDefined("entitledUsersPublishMatchOr", self.entitledUsersPublishMatchOr)
        kparams.addStringIfDefined("entitledUsersViewMatchAnd", self.entitledUsersViewMatchAnd)
        kparams.addStringIfDefined("entitledUsersViewMatchOr", self.entitledUsersViewMatchOr)
        kparams.addStringIfDefined("tagsNameMultiLikeOr", self.tagsNameMultiLikeOr)
        kparams.addStringIfDefined("tagsAdminTagsMultiLikeOr", self.tagsAdminTagsMultiLikeOr)
        kparams.addStringIfDefined("tagsAdminTagsNameMultiLikeOr", self.tagsAdminTagsNameMultiLikeOr)
        kparams.addStringIfDefined("tagsNameMultiLikeAnd", self.tagsNameMultiLikeAnd)
        kparams.addStringIfDefined("tagsAdminTagsMultiLikeAnd", self.tagsAdminTagsMultiLikeAnd)
        kparams.addStringIfDefined("tagsAdminTagsNameMultiLikeAnd", self.tagsAdminTagsNameMultiLikeAnd)
        return kparams

    def getIdEqual(self):
        return self.idEqual

    def setIdEqual(self, newIdEqual):
        self.idEqual = newIdEqual

    def getIdIn(self):
        return self.idIn

    def setIdIn(self, newIdIn):
        self.idIn = newIdIn

    def getIdNotIn(self):
        return self.idNotIn

    def setIdNotIn(self, newIdNotIn):
        self.idNotIn = newIdNotIn

    def getNameLike(self):
        return self.nameLike

    def setNameLike(self, newNameLike):
        self.nameLike = newNameLike

    def getNameMultiLikeOr(self):
        return self.nameMultiLikeOr

    def setNameMultiLikeOr(self, newNameMultiLikeOr):
        self.nameMultiLikeOr = newNameMultiLikeOr

    def getNameMultiLikeAnd(self):
        return self.nameMultiLikeAnd

    def setNameMultiLikeAnd(self, newNameMultiLikeAnd):
        self.nameMultiLikeAnd = newNameMultiLikeAnd

    def getNameEqual(self):
        return self.nameEqual

    def setNameEqual(self, newNameEqual):
        self.nameEqual = newNameEqual

    def getPartnerIdEqual(self):
        return self.partnerIdEqual

    def setPartnerIdEqual(self, newPartnerIdEqual):
        self.partnerIdEqual = newPartnerIdEqual

    def getPartnerIdIn(self):
        return self.partnerIdIn

    def setPartnerIdIn(self, newPartnerIdIn):
        self.partnerIdIn = newPartnerIdIn

    def getUserIdEqual(self):
        return self.userIdEqual

    def setUserIdEqual(self, newUserIdEqual):
        self.userIdEqual = newUserIdEqual

    def getUserIdIn(self):
        return self.userIdIn

    def setUserIdIn(self, newUserIdIn):
        self.userIdIn = newUserIdIn

    def getUserIdNotIn(self):
        return self.userIdNotIn

    def setUserIdNotIn(self, newUserIdNotIn):
        self.userIdNotIn = newUserIdNotIn

    def getCreatorIdEqual(self):
        return self.creatorIdEqual

    def setCreatorIdEqual(self, newCreatorIdEqual):
        self.creatorIdEqual = newCreatorIdEqual

    def getTagsLike(self):
        return self.tagsLike

    def setTagsLike(self, newTagsLike):
        self.tagsLike = newTagsLike

    def getTagsMultiLikeOr(self):
        return self.tagsMultiLikeOr

    def setTagsMultiLikeOr(self, newTagsMultiLikeOr):
        self.tagsMultiLikeOr = newTagsMultiLikeOr

    def getTagsMultiLikeAnd(self):
        return self.tagsMultiLikeAnd

    def setTagsMultiLikeAnd(self, newTagsMultiLikeAnd):
        self.tagsMultiLikeAnd = newTagsMultiLikeAnd

    def getAdminTagsLike(self):
        return self.adminTagsLike

    def setAdminTagsLike(self, newAdminTagsLike):
        self.adminTagsLike = newAdminTagsLike

    def getAdminTagsMultiLikeOr(self):
        return self.adminTagsMultiLikeOr

    def setAdminTagsMultiLikeOr(self, newAdminTagsMultiLikeOr):
        self.adminTagsMultiLikeOr = newAdminTagsMultiLikeOr

    def getAdminTagsMultiLikeAnd(self):
        return self.adminTagsMultiLikeAnd

    def setAdminTagsMultiLikeAnd(self, newAdminTagsMultiLikeAnd):
        self.adminTagsMultiLikeAnd = newAdminTagsMultiLikeAnd

    def getCategoriesMatchAnd(self):
        return self.categoriesMatchAnd

    def setCategoriesMatchAnd(self, newCategoriesMatchAnd):
        self.categoriesMatchAnd = newCategoriesMatchAnd

    def getCategoriesMatchOr(self):
        return self.categoriesMatchOr

    def setCategoriesMatchOr(self, newCategoriesMatchOr):
        self.categoriesMatchOr = newCategoriesMatchOr

    def getCategoriesNotContains(self):
        return self.categoriesNotContains

    def setCategoriesNotContains(self, newCategoriesNotContains):
        self.categoriesNotContains = newCategoriesNotContains

    def getCategoriesIdsMatchAnd(self):
        return self.categoriesIdsMatchAnd

    def setCategoriesIdsMatchAnd(self, newCategoriesIdsMatchAnd):
        self.categoriesIdsMatchAnd = newCategoriesIdsMatchAnd

    def getCategoriesIdsMatchOr(self):
        return self.categoriesIdsMatchOr

    def setCategoriesIdsMatchOr(self, newCategoriesIdsMatchOr):
        self.categoriesIdsMatchOr = newCategoriesIdsMatchOr

    def getCategoriesIdsNotContains(self):
        return self.categoriesIdsNotContains

    def setCategoriesIdsNotContains(self, newCategoriesIdsNotContains):
        self.categoriesIdsNotContains = newCategoriesIdsNotContains

    def getCategoriesIdsEmpty(self):
        return self.categoriesIdsEmpty

    def setCategoriesIdsEmpty(self, newCategoriesIdsEmpty):
        self.categoriesIdsEmpty = newCategoriesIdsEmpty

    def getStatusEqual(self):
        return self.statusEqual

    def setStatusEqual(self, newStatusEqual):
        self.statusEqual = newStatusEqual

    def getStatusNotEqual(self):
        return self.statusNotEqual

    def setStatusNotEqual(self, newStatusNotEqual):
        self.statusNotEqual = newStatusNotEqual

    def getStatusIn(self):
        return self.statusIn

    def setStatusIn(self, newStatusIn):
        self.statusIn = newStatusIn

    def getStatusNotIn(self):
        return self.statusNotIn

    def setStatusNotIn(self, newStatusNotIn):
        self.statusNotIn = newStatusNotIn

    def getModerationStatusEqual(self):
        return self.moderationStatusEqual

    def setModerationStatusEqual(self, newModerationStatusEqual):
        self.moderationStatusEqual = newModerationStatusEqual

    def getModerationStatusNotEqual(self):
        return self.moderationStatusNotEqual

    def setModerationStatusNotEqual(self, newModerationStatusNotEqual):
        self.moderationStatusNotEqual = newModerationStatusNotEqual

    def getModerationStatusIn(self):
        return self.moderationStatusIn

    def setModerationStatusIn(self, newModerationStatusIn):
        self.moderationStatusIn = newModerationStatusIn

    def getModerationStatusNotIn(self):
        return self.moderationStatusNotIn

    def setModerationStatusNotIn(self, newModerationStatusNotIn):
        self.moderationStatusNotIn = newModerationStatusNotIn

    def getTypeEqual(self):
        return self.typeEqual

    def setTypeEqual(self, newTypeEqual):
        self.typeEqual = newTypeEqual

    def getTypeIn(self):
        return self.typeIn

    def setTypeIn(self, newTypeIn):
        self.typeIn = newTypeIn

    def getCreatedAtGreaterThanOrEqual(self):
        return self.createdAtGreaterThanOrEqual

    def setCreatedAtGreaterThanOrEqual(self, newCreatedAtGreaterThanOrEqual):
        self.createdAtGreaterThanOrEqual = newCreatedAtGreaterThanOrEqual

    def getCreatedAtLessThanOrEqual(self):
        return self.createdAtLessThanOrEqual

    def setCreatedAtLessThanOrEqual(self, newCreatedAtLessThanOrEqual):
        self.createdAtLessThanOrEqual = newCreatedAtLessThanOrEqual

    def getUpdatedAtGreaterThanOrEqual(self):
        return self.updatedAtGreaterThanOrEqual

    def setUpdatedAtGreaterThanOrEqual(self, newUpdatedAtGreaterThanOrEqual):
        self.updatedAtGreaterThanOrEqual = newUpdatedAtGreaterThanOrEqual

    def getUpdatedAtLessThanOrEqual(self):
        return self.updatedAtLessThanOrEqual

    def setUpdatedAtLessThanOrEqual(self, newUpdatedAtLessThanOrEqual):
        self.updatedAtLessThanOrEqual = newUpdatedAtLessThanOrEqual

    def getRankLessThanOrEqual(self):
        return self.rankLessThanOrEqual

    def setRankLessThanOrEqual(self, newRankLessThanOrEqual):
        self.rankLessThanOrEqual = newRankLessThanOrEqual

    def getRankGreaterThanOrEqual(self):
        return self.rankGreaterThanOrEqual

    def setRankGreaterThanOrEqual(self, newRankGreaterThanOrEqual):
        self.rankGreaterThanOrEqual = newRankGreaterThanOrEqual

    def getTotalRankLessThanOrEqual(self):
        return self.totalRankLessThanOrEqual

    def setTotalRankLessThanOrEqual(self, newTotalRankLessThanOrEqual):
        self.totalRankLessThanOrEqual = newTotalRankLessThanOrEqual

    def getTotalRankGreaterThanOrEqual(self):
        return self.totalRankGreaterThanOrEqual

    def setTotalRankGreaterThanOrEqual(self, newTotalRankGreaterThanOrEqual):
        self.totalRankGreaterThanOrEqual = newTotalRankGreaterThanOrEqual

    def getGroupIdEqual(self):
        return self.groupIdEqual

    def setGroupIdEqual(self, newGroupIdEqual):
        self.groupIdEqual = newGroupIdEqual

    def getSearchTextMatchAnd(self):
        return self.searchTextMatchAnd

    def setSearchTextMatchAnd(self, newSearchTextMatchAnd):
        self.searchTextMatchAnd = newSearchTextMatchAnd

    def getSearchTextMatchOr(self):
        return self.searchTextMatchOr

    def setSearchTextMatchOr(self, newSearchTextMatchOr):
        self.searchTextMatchOr = newSearchTextMatchOr

    def getAccessControlIdEqual(self):
        return self.accessControlIdEqual

    def setAccessControlIdEqual(self, newAccessControlIdEqual):
        self.accessControlIdEqual = newAccessControlIdEqual

    def getAccessControlIdIn(self):
        return self.accessControlIdIn

    def setAccessControlIdIn(self, newAccessControlIdIn):
        self.accessControlIdIn = newAccessControlIdIn

    def getStartDateGreaterThanOrEqual(self):
        return self.startDateGreaterThanOrEqual

    def setStartDateGreaterThanOrEqual(self, newStartDateGreaterThanOrEqual):
        self.startDateGreaterThanOrEqual = newStartDateGreaterThanOrEqual

    def getStartDateLessThanOrEqual(self):
        return self.startDateLessThanOrEqual

    def setStartDateLessThanOrEqual(self, newStartDateLessThanOrEqual):
        self.startDateLessThanOrEqual = newStartDateLessThanOrEqual

    def getStartDateGreaterThanOrEqualOrNull(self):
        return self.startDateGreaterThanOrEqualOrNull

    def setStartDateGreaterThanOrEqualOrNull(self, newStartDateGreaterThanOrEqualOrNull):
        self.startDateGreaterThanOrEqualOrNull = newStartDateGreaterThanOrEqualOrNull

    def getStartDateLessThanOrEqualOrNull(self):
        return self.startDateLessThanOrEqualOrNull

    def setStartDateLessThanOrEqualOrNull(self, newStartDateLessThanOrEqualOrNull):
        self.startDateLessThanOrEqualOrNull = newStartDateLessThanOrEqualOrNull

    def getEndDateGreaterThanOrEqual(self):
        return self.endDateGreaterThanOrEqual

    def setEndDateGreaterThanOrEqual(self, newEndDateGreaterThanOrEqual):
        self.endDateGreaterThanOrEqual = newEndDateGreaterThanOrEqual

    def getEndDateLessThanOrEqual(self):
        return self.endDateLessThanOrEqual

    def setEndDateLessThanOrEqual(self, newEndDateLessThanOrEqual):
        self.endDateLessThanOrEqual = newEndDateLessThanOrEqual

    def getEndDateGreaterThanOrEqualOrNull(self):
        return self.endDateGreaterThanOrEqualOrNull

    def setEndDateGreaterThanOrEqualOrNull(self, newEndDateGreaterThanOrEqualOrNull):
        self.endDateGreaterThanOrEqualOrNull = newEndDateGreaterThanOrEqualOrNull

    def getEndDateLessThanOrEqualOrNull(self):
        return self.endDateLessThanOrEqualOrNull

    def setEndDateLessThanOrEqualOrNull(self, newEndDateLessThanOrEqualOrNull):
        self.endDateLessThanOrEqualOrNull = newEndDateLessThanOrEqualOrNull

    def getReferenceIdEqual(self):
        return self.referenceIdEqual

    def setReferenceIdEqual(self, newReferenceIdEqual):
        self.referenceIdEqual = newReferenceIdEqual

    def getReferenceIdIn(self):
        return self.referenceIdIn

    def setReferenceIdIn(self, newReferenceIdIn):
        self.referenceIdIn = newReferenceIdIn

    def getReplacingEntryIdEqual(self):
        return self.replacingEntryIdEqual

    def setReplacingEntryIdEqual(self, newReplacingEntryIdEqual):
        self.replacingEntryIdEqual = newReplacingEntryIdEqual

    def getReplacingEntryIdIn(self):
        return self.replacingEntryIdIn

    def setReplacingEntryIdIn(self, newReplacingEntryIdIn):
        self.replacingEntryIdIn = newReplacingEntryIdIn

    def getReplacedEntryIdEqual(self):
        return self.replacedEntryIdEqual

    def setReplacedEntryIdEqual(self, newReplacedEntryIdEqual):
        self.replacedEntryIdEqual = newReplacedEntryIdEqual

    def getReplacedEntryIdIn(self):
        return self.replacedEntryIdIn

    def setReplacedEntryIdIn(self, newReplacedEntryIdIn):
        self.replacedEntryIdIn = newReplacedEntryIdIn

    def getReplacementStatusEqual(self):
        return self.replacementStatusEqual

    def setReplacementStatusEqual(self, newReplacementStatusEqual):
        self.replacementStatusEqual = newReplacementStatusEqual

    def getReplacementStatusIn(self):
        return self.replacementStatusIn

    def setReplacementStatusIn(self, newReplacementStatusIn):
        self.replacementStatusIn = newReplacementStatusIn

    def getPartnerSortValueGreaterThanOrEqual(self):
        return self.partnerSortValueGreaterThanOrEqual

    def setPartnerSortValueGreaterThanOrEqual(self, newPartnerSortValueGreaterThanOrEqual):
        self.partnerSortValueGreaterThanOrEqual = newPartnerSortValueGreaterThanOrEqual

    def getPartnerSortValueLessThanOrEqual(self):
        return self.partnerSortValueLessThanOrEqual

    def setPartnerSortValueLessThanOrEqual(self, newPartnerSortValueLessThanOrEqual):
        self.partnerSortValueLessThanOrEqual = newPartnerSortValueLessThanOrEqual

    def getRootEntryIdEqual(self):
        return self.rootEntryIdEqual

    def setRootEntryIdEqual(self, newRootEntryIdEqual):
        self.rootEntryIdEqual = newRootEntryIdEqual

    def getRootEntryIdIn(self):
        return self.rootEntryIdIn

    def setRootEntryIdIn(self, newRootEntryIdIn):
        self.rootEntryIdIn = newRootEntryIdIn

    def getParentEntryIdEqual(self):
        return self.parentEntryIdEqual

    def setParentEntryIdEqual(self, newParentEntryIdEqual):
        self.parentEntryIdEqual = newParentEntryIdEqual

    def getEntitledUsersEditMatchAnd(self):
        return self.entitledUsersEditMatchAnd

    def setEntitledUsersEditMatchAnd(self, newEntitledUsersEditMatchAnd):
        self.entitledUsersEditMatchAnd = newEntitledUsersEditMatchAnd

    def getEntitledUsersEditMatchOr(self):
        return self.entitledUsersEditMatchOr

    def setEntitledUsersEditMatchOr(self, newEntitledUsersEditMatchOr):
        self.entitledUsersEditMatchOr = newEntitledUsersEditMatchOr

    def getEntitledUsersPublishMatchAnd(self):
        return self.entitledUsersPublishMatchAnd

    def setEntitledUsersPublishMatchAnd(self, newEntitledUsersPublishMatchAnd):
        self.entitledUsersPublishMatchAnd = newEntitledUsersPublishMatchAnd

    def getEntitledUsersPublishMatchOr(self):
        return self.entitledUsersPublishMatchOr

    def setEntitledUsersPublishMatchOr(self, newEntitledUsersPublishMatchOr):
        self.entitledUsersPublishMatchOr = newEntitledUsersPublishMatchOr

    def getEntitledUsersViewMatchAnd(self):
        return self.entitledUsersViewMatchAnd

    def setEntitledUsersViewMatchAnd(self, newEntitledUsersViewMatchAnd):
        self.entitledUsersViewMatchAnd = newEntitledUsersViewMatchAnd

    def getEntitledUsersViewMatchOr(self):
        return self.entitledUsersViewMatchOr

    def setEntitledUsersViewMatchOr(self, newEntitledUsersViewMatchOr):
        self.entitledUsersViewMatchOr = newEntitledUsersViewMatchOr

    def getTagsNameMultiLikeOr(self):
        return self.tagsNameMultiLikeOr

    def setTagsNameMultiLikeOr(self, newTagsNameMultiLikeOr):
        self.tagsNameMultiLikeOr = newTagsNameMultiLikeOr

    def getTagsAdminTagsMultiLikeOr(self):
        return self.tagsAdminTagsMultiLikeOr

    def setTagsAdminTagsMultiLikeOr(self, newTagsAdminTagsMultiLikeOr):
        self.tagsAdminTagsMultiLikeOr = newTagsAdminTagsMultiLikeOr

    def getTagsAdminTagsNameMultiLikeOr(self):
        return self.tagsAdminTagsNameMultiLikeOr

    def setTagsAdminTagsNameMultiLikeOr(self, newTagsAdminTagsNameMultiLikeOr):
        self.tagsAdminTagsNameMultiLikeOr = newTagsAdminTagsNameMultiLikeOr

    def getTagsNameMultiLikeAnd(self):
        return self.tagsNameMultiLikeAnd

    def setTagsNameMultiLikeAnd(self, newTagsNameMultiLikeAnd):
        self.tagsNameMultiLikeAnd = newTagsNameMultiLikeAnd

    def getTagsAdminTagsMultiLikeAnd(self):
        return self.tagsAdminTagsMultiLikeAnd

    def setTagsAdminTagsMultiLikeAnd(self, newTagsAdminTagsMultiLikeAnd):
        self.tagsAdminTagsMultiLikeAnd = newTagsAdminTagsMultiLikeAnd

    def getTagsAdminTagsNameMultiLikeAnd(self):
        return self.tagsAdminTagsNameMultiLikeAnd

    def setTagsAdminTagsNameMultiLikeAnd(self, newTagsAdminTagsNameMultiLikeAnd):
        self.tagsAdminTagsNameMultiLikeAnd = newTagsAdminTagsNameMultiLikeAnd


# @package Kaltura
# @subpackage Client
class KalturaBaseEntryFilter(KalturaBaseEntryBaseFilter):
    def __init__(self,
            orderBy=NotImplemented,
            advancedSearch=NotImplemented,
            idEqual=NotImplemented,
            idIn=NotImplemented,
            idNotIn=NotImplemented,
            nameLike=NotImplemented,
            nameMultiLikeOr=NotImplemented,
            nameMultiLikeAnd=NotImplemented,
            nameEqual=NotImplemented,
            partnerIdEqual=NotImplemented,
            partnerIdIn=NotImplemented,
            userIdEqual=NotImplemented,
            userIdIn=NotImplemented,
            userIdNotIn=NotImplemented,
            creatorIdEqual=NotImplemented,
            tagsLike=NotImplemented,
            tagsMultiLikeOr=NotImplemented,
            tagsMultiLikeAnd=NotImplemented,
            adminTagsLike=NotImplemented,
            adminTagsMultiLikeOr=NotImplemented,
            adminTagsMultiLikeAnd=NotImplemented,
            categoriesMatchAnd=NotImplemented,
            categoriesMatchOr=NotImplemented,
            categoriesNotContains=NotImplemented,
            categoriesIdsMatchAnd=NotImplemented,
            categoriesIdsMatchOr=NotImplemented,
            categoriesIdsNotContains=NotImplemented,
            categoriesIdsEmpty=NotImplemented,
            statusEqual=NotImplemented,
            statusNotEqual=NotImplemented,
            statusIn=NotImplemented,
            statusNotIn=NotImplemented,
            moderationStatusEqual=NotImplemented,
            moderationStatusNotEqual=NotImplemented,
            moderationStatusIn=NotImplemented,
            moderationStatusNotIn=NotImplemented,
            typeEqual=NotImplemented,
            typeIn=NotImplemented,
            createdAtGreaterThanOrEqual=NotImplemented,
            createdAtLessThanOrEqual=NotImplemented,
            updatedAtGreaterThanOrEqual=NotImplemented,
            updatedAtLessThanOrEqual=NotImplemented,
            rankLessThanOrEqual=NotImplemented,
            rankGreaterThanOrEqual=NotImplemented,
            totalRankLessThanOrEqual=NotImplemented,
            totalRankGreaterThanOrEqual=NotImplemented,
            groupIdEqual=NotImplemented,
            searchTextMatchAnd=NotImplemented,
            searchTextMatchOr=NotImplemented,
            accessControlIdEqual=NotImplemented,
            accessControlIdIn=NotImplemented,
            startDateGreaterThanOrEqual=NotImplemented,
            startDateLessThanOrEqual=NotImplemented,
            startDateGreaterThanOrEqualOrNull=NotImplemented,
            startDateLessThanOrEqualOrNull=NotImplemented,
            endDateGreaterThanOrEqual=NotImplemented,
            endDateLessThanOrEqual=NotImplemented,
            endDateGreaterThanOrEqualOrNull=NotImplemented,
            endDateLessThanOrEqualOrNull=NotImplemented,
            referenceIdEqual=NotImplemented,
            referenceIdIn=NotImplemented,
            replacingEntryIdEqual=NotImplemented,
            replacingEntryIdIn=NotImplemented,
            replacedEntryIdEqual=NotImplemented,
            replacedEntryIdIn=NotImplemented,
            replacementStatusEqual=NotImplemented,
            replacementStatusIn=NotImplemented,
            partnerSortValueGreaterThanOrEqual=NotImplemented,
            partnerSortValueLessThanOrEqual=NotImplemented,
            rootEntryIdEqual=NotImplemented,
            rootEntryIdIn=NotImplemented,
            parentEntryIdEqual=NotImplemented,
            entitledUsersEditMatchAnd=NotImplemented,
            entitledUsersEditMatchOr=NotImplemented,
            entitledUsersPublishMatchAnd=NotImplemented,
            entitledUsersPublishMatchOr=NotImplemented,
            entitledUsersViewMatchAnd=NotImplemented,
            entitledUsersViewMatchOr=NotImplemented,
            tagsNameMultiLikeOr=NotImplemented,
            tagsAdminTagsMultiLikeOr=NotImplemented,
            tagsAdminTagsNameMultiLikeOr=NotImplemented,
            tagsNameMultiLikeAnd=NotImplemented,
            tagsAdminTagsMultiLikeAnd=NotImplemented,
            tagsAdminTagsNameMultiLikeAnd=NotImplemented,
            freeText=NotImplemented,
            excludedFreeTextGroups=NotImplemented,
            descriptionLike=NotImplemented,
            isRoot=NotImplemented,
            categoriesFullNameIn=NotImplemented,
            categoryAncestorIdIn=NotImplemented,
            redirectFromEntryId=NotImplemented,
            conversionProfileIdEqual=NotImplemented):
        KalturaBaseEntryBaseFilter.__init__(self,
            orderBy,
            advancedSearch,
            idEqual,
            idIn,
            idNotIn,
            nameLike,
            nameMultiLikeOr,
            nameMultiLikeAnd,
            nameEqual,
            partnerIdEqual,
            partnerIdIn,
            userIdEqual,
            userIdIn,
            userIdNotIn,
            creatorIdEqual,
            tagsLike,
            tagsMultiLikeOr,
            tagsMultiLikeAnd,
            adminTagsLike,
            adminTagsMultiLikeOr,
            adminTagsMultiLikeAnd,
            categoriesMatchAnd,
            categoriesMatchOr,
            categoriesNotContains,
            categoriesIdsMatchAnd,
            categoriesIdsMatchOr,
            categoriesIdsNotContains,
            categoriesIdsEmpty,
            statusEqual,
            statusNotEqual,
            statusIn,
            statusNotIn,
            moderationStatusEqual,
            moderationStatusNotEqual,
            moderationStatusIn,
            moderationStatusNotIn,
            typeEqual,
            typeIn,
            createdAtGreaterThanOrEqual,
            createdAtLessThanOrEqual,
            updatedAtGreaterThanOrEqual,
            updatedAtLessThanOrEqual,
            rankLessThanOrEqual,
            rankGreaterThanOrEqual,
            totalRankLessThanOrEqual,
            totalRankGreaterThanOrEqual,
            groupIdEqual,
            searchTextMatchAnd,
            searchTextMatchOr,
            accessControlIdEqual,
            accessControlIdIn,
            startDateGreaterThanOrEqual,
            startDateLessThanOrEqual,
            startDateGreaterThanOrEqualOrNull,
            startDateLessThanOrEqualOrNull,
            endDateGreaterThanOrEqual,
            endDateLessThanOrEqual,
            endDateGreaterThanOrEqualOrNull,
            endDateLessThanOrEqualOrNull,
            referenceIdEqual,
            referenceIdIn,
            replacingEntryIdEqual,
            replacingEntryIdIn,
            replacedEntryIdEqual,
            replacedEntryIdIn,
            replacementStatusEqual,
            replacementStatusIn,
            partnerSortValueGreaterThanOrEqual,
            partnerSortValueLessThanOrEqual,
            rootEntryIdEqual,
            rootEntryIdIn,
            parentEntryIdEqual,
            entitledUsersEditMatchAnd,
            entitledUsersEditMatchOr,
            entitledUsersPublishMatchAnd,
            entitledUsersPublishMatchOr,
            entitledUsersViewMatchAnd,
            entitledUsersViewMatchOr,
            tagsNameMultiLikeOr,
            tagsAdminTagsMultiLikeOr,
            tagsAdminTagsNameMultiLikeOr,
            tagsNameMultiLikeAnd,
            tagsAdminTagsMultiLikeAnd,
            tagsAdminTagsNameMultiLikeAnd)

        # @var string
        self.freeText = freeText

        # @var string
        self.excludedFreeTextGroups = excludedFreeTextGroups

        # @var string
        self.descriptionLike = descriptionLike

        # @var KalturaNullableBoolean
        self.isRoot = isRoot

        # @var string
        self.categoriesFullNameIn = categoriesFullNameIn

        # All entries within this categoy or in child categories
        # @var string
        self.categoryAncestorIdIn = categoryAncestorIdIn

        # The id of the original entry
        # @var string
        self.redirectFromEntryId = redirectFromEntryId

        # @var int
        self.conversionProfileIdEqual = conversionProfileIdEqual


    PROPERTY_LOADERS = {
        'freeText': getXmlNodeText, 
        'excludedFreeTextGroups': getXmlNodeText, 
        'descriptionLike': getXmlNodeText, 
        'isRoot': (KalturaEnumsFactory.createInt, "KalturaNullableBoolean"), 
        'categoriesFullNameIn': getXmlNodeText, 
        'categoryAncestorIdIn': getXmlNodeText, 
        'redirectFromEntryId': getXmlNodeText, 
        'conversionProfileIdEqual': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaBaseEntryBaseFilter.fromXml(self, node)
        self.fromXmlImpl(node, KalturaBaseEntryFilter.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaBaseEntryBaseFilter.toParams(self)
        kparams.put("objectType", "KalturaBaseEntryFilter")
        kparams.addStringIfDefined("freeText", self.freeText)
        kparams.addStringIfDefined("excludedFreeTextGroups", self.excludedFreeTextGroups)
        kparams.addStringIfDefined("descriptionLike", self.descriptionLike)
        kparams.addIntEnumIfDefined("isRoot", self.isRoot)
        kparams.addStringIfDefined("categoriesFullNameIn", self.categoriesFullNameIn)
        kparams.addStringIfDefined("categoryAncestorIdIn", self.categoryAncestorIdIn)
        kparams.addStringIfDefined("redirectFromEntryId", self.redirectFromEntryId)
        kparams.addIntIfDefined("conversionProfileIdEqual", self.conversionProfileIdEqual)
        return kparams

    def getFreeText(self):
        return self.freeText

    def setFreeText(self, newFreeText):
        self.freeText = newFreeText

    def getExcludedFreeTextGroups(self):
        return self.excludedFreeTextGroups

    def setExcludedFreeTextGroups(self, newExcludedFreeTextGroups):
        self.excludedFreeTextGroups = newExcludedFreeTextGroups

    def getDescriptionLike(self):
        return self.descriptionLike

    def setDescriptionLike(self, newDescriptionLike):
        self.descriptionLike = newDescriptionLike

    def getIsRoot(self):
        return self.isRoot

    def setIsRoot(self, newIsRoot):
        self.isRoot = newIsRoot

    def getCategoriesFullNameIn(self):
        return self.categoriesFullNameIn

    def setCategoriesFullNameIn(self, newCategoriesFullNameIn):
        self.categoriesFullNameIn = newCategoriesFullNameIn

    def getCategoryAncestorIdIn(self):
        return self.categoryAncestorIdIn

    def setCategoryAncestorIdIn(self, newCategoryAncestorIdIn):
        self.categoryAncestorIdIn = newCategoryAncestorIdIn

    def getRedirectFromEntryId(self):
        return self.redirectFromEntryId

    def setRedirectFromEntryId(self, newRedirectFromEntryId):
        self.redirectFromEntryId = newRedirectFromEntryId

    def getConversionProfileIdEqual(self):
        return self.conversionProfileIdEqual

    def setConversionProfileIdEqual(self, newConversionProfileIdEqual):
        self.conversionProfileIdEqual = newConversionProfileIdEqual


# @package Kaltura
# @subpackage Client
class KalturaPlayableEntryBaseFilter(KalturaBaseEntryFilter):
    def __init__(self,
            orderBy=NotImplemented,
            advancedSearch=NotImplemented,
            idEqual=NotImplemented,
            idIn=NotImplemented,
            idNotIn=NotImplemented,
            nameLike=NotImplemented,
            nameMultiLikeOr=NotImplemented,
            nameMultiLikeAnd=NotImplemented,
            nameEqual=NotImplemented,
            partnerIdEqual=NotImplemented,
            partnerIdIn=NotImplemented,
            userIdEqual=NotImplemented,
            userIdIn=NotImplemented,
            userIdNotIn=NotImplemented,
            creatorIdEqual=NotImplemented,
            tagsLike=NotImplemented,
            tagsMultiLikeOr=NotImplemented,
            tagsMultiLikeAnd=NotImplemented,
            adminTagsLike=NotImplemented,
            adminTagsMultiLikeOr=NotImplemented,
            adminTagsMultiLikeAnd=NotImplemented,
            categoriesMatchAnd=NotImplemented,
            categoriesMatchOr=NotImplemented,
            categoriesNotContains=NotImplemented,
            categoriesIdsMatchAnd=NotImplemented,
            categoriesIdsMatchOr=NotImplemented,
            categoriesIdsNotContains=NotImplemented,
            categoriesIdsEmpty=NotImplemented,
            statusEqual=NotImplemented,
            statusNotEqual=NotImplemented,
            statusIn=NotImplemented,
            statusNotIn=NotImplemented,
            moderationStatusEqual=NotImplemented,
            moderationStatusNotEqual=NotImplemented,
            moderationStatusIn=NotImplemented,
            moderationStatusNotIn=NotImplemented,
            typeEqual=NotImplemented,
            typeIn=NotImplemented,
            createdAtGreaterThanOrEqual=NotImplemented,
            createdAtLessThanOrEqual=NotImplemented,
            updatedAtGreaterThanOrEqual=NotImplemented,
            updatedAtLessThanOrEqual=NotImplemented,
            rankLessThanOrEqual=NotImplemented,
            rankGreaterThanOrEqual=NotImplemented,
            totalRankLessThanOrEqual=NotImplemented,
            totalRankGreaterThanOrEqual=NotImplemented,
            groupIdEqual=NotImplemented,
            searchTextMatchAnd=NotImplemented,
            searchTextMatchOr=NotImplemented,
            accessControlIdEqual=NotImplemented,
            accessControlIdIn=NotImplemented,
            startDateGreaterThanOrEqual=NotImplemented,
            startDateLessThanOrEqual=NotImplemented,
            startDateGreaterThanOrEqualOrNull=NotImplemented,
            startDateLessThanOrEqualOrNull=NotImplemented,
            endDateGreaterThanOrEqual=NotImplemented,
            endDateLessThanOrEqual=NotImplemented,
            endDateGreaterThanOrEqualOrNull=NotImplemented,
            endDateLessThanOrEqualOrNull=NotImplemented,
            referenceIdEqual=NotImplemented,
            referenceIdIn=NotImplemented,
            replacingEntryIdEqual=NotImplemented,
            replacingEntryIdIn=NotImplemented,
            replacedEntryIdEqual=NotImplemented,
            replacedEntryIdIn=NotImplemented,
            replacementStatusEqual=NotImplemented,
            replacementStatusIn=NotImplemented,
            partnerSortValueGreaterThanOrEqual=NotImplemented,
            partnerSortValueLessThanOrEqual=NotImplemented,
            rootEntryIdEqual=NotImplemented,
            rootEntryIdIn=NotImplemented,
            parentEntryIdEqual=NotImplemented,
            entitledUsersEditMatchAnd=NotImplemented,
            entitledUsersEditMatchOr=NotImplemented,
            entitledUsersPublishMatchAnd=NotImplemented,
            entitledUsersPublishMatchOr=NotImplemented,
            entitledUsersViewMatchAnd=NotImplemented,
            entitledUsersViewMatchOr=NotImplemented,
            tagsNameMultiLikeOr=NotImplemented,
            tagsAdminTagsMultiLikeOr=NotImplemented,
            tagsAdminTagsNameMultiLikeOr=NotImplemented,
            tagsNameMultiLikeAnd=NotImplemented,
            tagsAdminTagsMultiLikeAnd=NotImplemented,
            tagsAdminTagsNameMultiLikeAnd=NotImplemented,
            freeText=NotImplemented,
            excludedFreeTextGroups=NotImplemented,
            descriptionLike=NotImplemented,
            isRoot=NotImplemented,
            categoriesFullNameIn=NotImplemented,
            categoryAncestorIdIn=NotImplemented,
            redirectFromEntryId=NotImplemented,
            conversionProfileIdEqual=NotImplemented,
            lastPlayedAtGreaterThanOrEqual=NotImplemented,
            lastPlayedAtLessThanOrEqual=NotImplemented,
            lastPlayedAtLessThanOrEqualOrNull=NotImplemented,
            durationLessThan=NotImplemented,
            durationGreaterThan=NotImplemented,
            durationLessThanOrEqual=NotImplemented,
            durationGreaterThanOrEqual=NotImplemented,
            durationTypeMatchOr=NotImplemented):
        KalturaBaseEntryFilter.__init__(self,
            orderBy,
            advancedSearch,
            idEqual,
            idIn,
            idNotIn,
            nameLike,
            nameMultiLikeOr,
            nameMultiLikeAnd,
            nameEqual,
            partnerIdEqual,
            partnerIdIn,
            userIdEqual,
            userIdIn,
            userIdNotIn,
            creatorIdEqual,
            tagsLike,
            tagsMultiLikeOr,
            tagsMultiLikeAnd,
            adminTagsLike,
            adminTagsMultiLikeOr,
            adminTagsMultiLikeAnd,
            categoriesMatchAnd,
            categoriesMatchOr,
            categoriesNotContains,
            categoriesIdsMatchAnd,
            categoriesIdsMatchOr,
            categoriesIdsNotContains,
            categoriesIdsEmpty,
            statusEqual,
            statusNotEqual,
            statusIn,
            statusNotIn,
            moderationStatusEqual,
            moderationStatusNotEqual,
            moderationStatusIn,
            moderationStatusNotIn,
            typeEqual,
            typeIn,
            createdAtGreaterThanOrEqual,
            createdAtLessThanOrEqual,
            updatedAtGreaterThanOrEqual,
            updatedAtLessThanOrEqual,
            rankLessThanOrEqual,
            rankGreaterThanOrEqual,
            totalRankLessThanOrEqual,
            totalRankGreaterThanOrEqual,
            groupIdEqual,
            searchTextMatchAnd,
            searchTextMatchOr,
            accessControlIdEqual,
            accessControlIdIn,
            startDateGreaterThanOrEqual,
            startDateLessThanOrEqual,
            startDateGreaterThanOrEqualOrNull,
            startDateLessThanOrEqualOrNull,
            endDateGreaterThanOrEqual,
            endDateLessThanOrEqual,
            endDateGreaterThanOrEqualOrNull,
            endDateLessThanOrEqualOrNull,
            referenceIdEqual,
            referenceIdIn,
            replacingEntryIdEqual,
            replacingEntryIdIn,
            replacedEntryIdEqual,
            replacedEntryIdIn,
            replacementStatusEqual,
            replacementStatusIn,
            partnerSortValueGreaterThanOrEqual,
            partnerSortValueLessThanOrEqual,
            rootEntryIdEqual,
            rootEntryIdIn,
            parentEntryIdEqual,
            entitledUsersEditMatchAnd,
            entitledUsersEditMatchOr,
            entitledUsersPublishMatchAnd,
            entitledUsersPublishMatchOr,
            entitledUsersViewMatchAnd,
            entitledUsersViewMatchOr,
            tagsNameMultiLikeOr,
            tagsAdminTagsMultiLikeOr,
            tagsAdminTagsNameMultiLikeOr,
            tagsNameMultiLikeAnd,
            tagsAdminTagsMultiLikeAnd,
            tagsAdminTagsNameMultiLikeAnd,
            freeText,
            excludedFreeTextGroups,
            descriptionLike,
            isRoot,
            categoriesFullNameIn,
            categoryAncestorIdIn,
            redirectFromEntryId,
            conversionProfileIdEqual)

        # @var int
        self.lastPlayedAtGreaterThanOrEqual = lastPlayedAtGreaterThanOrEqual

        # @var int
        self.lastPlayedAtLessThanOrEqual = lastPlayedAtLessThanOrEqual

        # @var int
        self.lastPlayedAtLessThanOrEqualOrNull = lastPlayedAtLessThanOrEqualOrNull

        # @var int
        self.durationLessThan = durationLessThan

        # @var int
        self.durationGreaterThan = durationGreaterThan

        # @var int
        self.durationLessThanOrEqual = durationLessThanOrEqual

        # @var int
        self.durationGreaterThanOrEqual = durationGreaterThanOrEqual

        # @var string
        self.durationTypeMatchOr = durationTypeMatchOr


    PROPERTY_LOADERS = {
        'lastPlayedAtGreaterThanOrEqual': getXmlNodeInt, 
        'lastPlayedAtLessThanOrEqual': getXmlNodeInt, 
        'lastPlayedAtLessThanOrEqualOrNull': getXmlNodeInt, 
        'durationLessThan': getXmlNodeInt, 
        'durationGreaterThan': getXmlNodeInt, 
        'durationLessThanOrEqual': getXmlNodeInt, 
        'durationGreaterThanOrEqual': getXmlNodeInt, 
        'durationTypeMatchOr': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaBaseEntryFilter.fromXml(self, node)
        self.fromXmlImpl(node, KalturaPlayableEntryBaseFilter.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaBaseEntryFilter.toParams(self)
        kparams.put("objectType", "KalturaPlayableEntryBaseFilter")
        kparams.addIntIfDefined("lastPlayedAtGreaterThanOrEqual", self.lastPlayedAtGreaterThanOrEqual)
        kparams.addIntIfDefined("lastPlayedAtLessThanOrEqual", self.lastPlayedAtLessThanOrEqual)
        kparams.addIntIfDefined("lastPlayedAtLessThanOrEqualOrNull", self.lastPlayedAtLessThanOrEqualOrNull)
        kparams.addIntIfDefined("durationLessThan", self.durationLessThan)
        kparams.addIntIfDefined("durationGreaterThan", self.durationGreaterThan)
        kparams.addIntIfDefined("durationLessThanOrEqual", self.durationLessThanOrEqual)
        kparams.addIntIfDefined("durationGreaterThanOrEqual", self.durationGreaterThanOrEqual)
        kparams.addStringIfDefined("durationTypeMatchOr", self.durationTypeMatchOr)
        return kparams

    def getLastPlayedAtGreaterThanOrEqual(self):
        return self.lastPlayedAtGreaterThanOrEqual

    def setLastPlayedAtGreaterThanOrEqual(self, newLastPlayedAtGreaterThanOrEqual):
        self.lastPlayedAtGreaterThanOrEqual = newLastPlayedAtGreaterThanOrEqual

    def getLastPlayedAtLessThanOrEqual(self):
        return self.lastPlayedAtLessThanOrEqual

    def setLastPlayedAtLessThanOrEqual(self, newLastPlayedAtLessThanOrEqual):
        self.lastPlayedAtLessThanOrEqual = newLastPlayedAtLessThanOrEqual

    def getLastPlayedAtLessThanOrEqualOrNull(self):
        return self.lastPlayedAtLessThanOrEqualOrNull

    def setLastPlayedAtLessThanOrEqualOrNull(self, newLastPlayedAtLessThanOrEqualOrNull):
        self.lastPlayedAtLessThanOrEqualOrNull = newLastPlayedAtLessThanOrEqualOrNull

    def getDurationLessThan(self):
        return self.durationLessThan

    def setDurationLessThan(self, newDurationLessThan):
        self.durationLessThan = newDurationLessThan

    def getDurationGreaterThan(self):
        return self.durationGreaterThan

    def setDurationGreaterThan(self, newDurationGreaterThan):
        self.durationGreaterThan = newDurationGreaterThan

    def getDurationLessThanOrEqual(self):
        return self.durationLessThanOrEqual

    def setDurationLessThanOrEqual(self, newDurationLessThanOrEqual):
        self.durationLessThanOrEqual = newDurationLessThanOrEqual

    def getDurationGreaterThanOrEqual(self):
        return self.durationGreaterThanOrEqual

    def setDurationGreaterThanOrEqual(self, newDurationGreaterThanOrEqual):
        self.durationGreaterThanOrEqual = newDurationGreaterThanOrEqual

    def getDurationTypeMatchOr(self):
        return self.durationTypeMatchOr

    def setDurationTypeMatchOr(self, newDurationTypeMatchOr):
        self.durationTypeMatchOr = newDurationTypeMatchOr


# @package Kaltura
# @subpackage Client
class KalturaPlayableEntryFilter(KalturaPlayableEntryBaseFilter):
    def __init__(self,
            orderBy=NotImplemented,
            advancedSearch=NotImplemented,
            idEqual=NotImplemented,
            idIn=NotImplemented,
            idNotIn=NotImplemented,
            nameLike=NotImplemented,
            nameMultiLikeOr=NotImplemented,
            nameMultiLikeAnd=NotImplemented,
            nameEqual=NotImplemented,
            partnerIdEqual=NotImplemented,
            partnerIdIn=NotImplemented,
            userIdEqual=NotImplemented,
            userIdIn=NotImplemented,
            userIdNotIn=NotImplemented,
            creatorIdEqual=NotImplemented,
            tagsLike=NotImplemented,
            tagsMultiLikeOr=NotImplemented,
            tagsMultiLikeAnd=NotImplemented,
            adminTagsLike=NotImplemented,
            adminTagsMultiLikeOr=NotImplemented,
            adminTagsMultiLikeAnd=NotImplemented,
            categoriesMatchAnd=NotImplemented,
            categoriesMatchOr=NotImplemented,
            categoriesNotContains=NotImplemented,
            categoriesIdsMatchAnd=NotImplemented,
            categoriesIdsMatchOr=NotImplemented,
            categoriesIdsNotContains=NotImplemented,
            categoriesIdsEmpty=NotImplemented,
            statusEqual=NotImplemented,
            statusNotEqual=NotImplemented,
            statusIn=NotImplemented,
            statusNotIn=NotImplemented,
            moderationStatusEqual=NotImplemented,
            moderationStatusNotEqual=NotImplemented,
            moderationStatusIn=NotImplemented,
            moderationStatusNotIn=NotImplemented,
            typeEqual=NotImplemented,
            typeIn=NotImplemented,
            createdAtGreaterThanOrEqual=NotImplemented,
            createdAtLessThanOrEqual=NotImplemented,
            updatedAtGreaterThanOrEqual=NotImplemented,
            updatedAtLessThanOrEqual=NotImplemented,
            rankLessThanOrEqual=NotImplemented,
            rankGreaterThanOrEqual=NotImplemented,
            totalRankLessThanOrEqual=NotImplemented,
            totalRankGreaterThanOrEqual=NotImplemented,
            groupIdEqual=NotImplemented,
            searchTextMatchAnd=NotImplemented,
            searchTextMatchOr=NotImplemented,
            accessControlIdEqual=NotImplemented,
            accessControlIdIn=NotImplemented,
            startDateGreaterThanOrEqual=NotImplemented,
            startDateLessThanOrEqual=NotImplemented,
            startDateGreaterThanOrEqualOrNull=NotImplemented,
            startDateLessThanOrEqualOrNull=NotImplemented,
            endDateGreaterThanOrEqual=NotImplemented,
            endDateLessThanOrEqual=NotImplemented,
            endDateGreaterThanOrEqualOrNull=NotImplemented,
            endDateLessThanOrEqualOrNull=NotImplemented,
            referenceIdEqual=NotImplemented,
            referenceIdIn=NotImplemented,
            replacingEntryIdEqual=NotImplemented,
            replacingEntryIdIn=NotImplemented,
            replacedEntryIdEqual=NotImplemented,
            replacedEntryIdIn=NotImplemented,
            replacementStatusEqual=NotImplemented,
            replacementStatusIn=NotImplemented,
            partnerSortValueGreaterThanOrEqual=NotImplemented,
            partnerSortValueLessThanOrEqual=NotImplemented,
            rootEntryIdEqual=NotImplemented,
            rootEntryIdIn=NotImplemented,
            parentEntryIdEqual=NotImplemented,
            entitledUsersEditMatchAnd=NotImplemented,
            entitledUsersEditMatchOr=NotImplemented,
            entitledUsersPublishMatchAnd=NotImplemented,
            entitledUsersPublishMatchOr=NotImplemented,
            entitledUsersViewMatchAnd=NotImplemented,
            entitledUsersViewMatchOr=NotImplemented,
            tagsNameMultiLikeOr=NotImplemented,
            tagsAdminTagsMultiLikeOr=NotImplemented,
            tagsAdminTagsNameMultiLikeOr=NotImplemented,
            tagsNameMultiLikeAnd=NotImplemented,
            tagsAdminTagsMultiLikeAnd=NotImplemented,
            tagsAdminTagsNameMultiLikeAnd=NotImplemented,
            freeText=NotImplemented,
            excludedFreeTextGroups=NotImplemented,
            descriptionLike=NotImplemented,
            isRoot=NotImplemented,
            categoriesFullNameIn=NotImplemented,
            categoryAncestorIdIn=NotImplemented,
            redirectFromEntryId=NotImplemented,
            conversionProfileIdEqual=NotImplemented,
            lastPlayedAtGreaterThanOrEqual=NotImplemented,
            lastPlayedAtLessThanOrEqual=NotImplemented,
            lastPlayedAtLessThanOrEqualOrNull=NotImplemented,
            durationLessThan=NotImplemented,
            durationGreaterThan=NotImplemented,
            durationLessThanOrEqual=NotImplemented,
            durationGreaterThanOrEqual=NotImplemented,
            durationTypeMatchOr=NotImplemented):
        KalturaPlayableEntryBaseFilter.__init__(self,
            orderBy,
            advancedSearch,
            idEqual,
            idIn,
            idNotIn,
            nameLike,
            nameMultiLikeOr,
            nameMultiLikeAnd,
            nameEqual,
            partnerIdEqual,
            partnerIdIn,
            userIdEqual,
            userIdIn,
            userIdNotIn,
            creatorIdEqual,
            tagsLike,
            tagsMultiLikeOr,
            tagsMultiLikeAnd,
            adminTagsLike,
            adminTagsMultiLikeOr,
            adminTagsMultiLikeAnd,
            categoriesMatchAnd,
            categoriesMatchOr,
            categoriesNotContains,
            categoriesIdsMatchAnd,
            categoriesIdsMatchOr,
            categoriesIdsNotContains,
            categoriesIdsEmpty,
            statusEqual,
            statusNotEqual,
            statusIn,
            statusNotIn,
            moderationStatusEqual,
            moderationStatusNotEqual,
            moderationStatusIn,
            moderationStatusNotIn,
            typeEqual,
            typeIn,
            createdAtGreaterThanOrEqual,
            createdAtLessThanOrEqual,
            updatedAtGreaterThanOrEqual,
            updatedAtLessThanOrEqual,
            rankLessThanOrEqual,
            rankGreaterThanOrEqual,
            totalRankLessThanOrEqual,
            totalRankGreaterThanOrEqual,
            groupIdEqual,
            searchTextMatchAnd,
            searchTextMatchOr,
            accessControlIdEqual,
            accessControlIdIn,
            startDateGreaterThanOrEqual,
            startDateLessThanOrEqual,
            startDateGreaterThanOrEqualOrNull,
            startDateLessThanOrEqualOrNull,
            endDateGreaterThanOrEqual,
            endDateLessThanOrEqual,
            endDateGreaterThanOrEqualOrNull,
            endDateLessThanOrEqualOrNull,
            referenceIdEqual,
            referenceIdIn,
            replacingEntryIdEqual,
            replacingEntryIdIn,
            replacedEntryIdEqual,
            replacedEntryIdIn,
            replacementStatusEqual,
            replacementStatusIn,
            partnerSortValueGreaterThanOrEqual,
            partnerSortValueLessThanOrEqual,
            rootEntryIdEqual,
            rootEntryIdIn,
            parentEntryIdEqual,
            entitledUsersEditMatchAnd,
            entitledUsersEditMatchOr,
            entitledUsersPublishMatchAnd,
            entitledUsersPublishMatchOr,
            entitledUsersViewMatchAnd,
            entitledUsersViewMatchOr,
            tagsNameMultiLikeOr,
            tagsAdminTagsMultiLikeOr,
            tagsAdminTagsNameMultiLikeOr,
            tagsNameMultiLikeAnd,
            tagsAdminTagsMultiLikeAnd,
            tagsAdminTagsNameMultiLikeAnd,
            freeText,
            excludedFreeTextGroups,
            descriptionLike,
            isRoot,
            categoriesFullNameIn,
            categoryAncestorIdIn,
            redirectFromEntryId,
            conversionProfileIdEqual,
            lastPlayedAtGreaterThanOrEqual,
            lastPlayedAtLessThanOrEqual,
            lastPlayedAtLessThanOrEqualOrNull,
            durationLessThan,
            durationGreaterThan,
            durationLessThanOrEqual,
            durationGreaterThanOrEqual,
            durationTypeMatchOr)


    PROPERTY_LOADERS = {
    }

    def fromXml(self, node):
        KalturaPlayableEntryBaseFilter.fromXml(self, node)
        self.fromXmlImpl(node, KalturaPlayableEntryFilter.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaPlayableEntryBaseFilter.toParams(self)
        kparams.put("objectType", "KalturaPlayableEntryFilter")
        return kparams


# @package Kaltura
# @subpackage Client
class KalturaMediaEntryBaseFilter(KalturaPlayableEntryFilter):
    def __init__(self,
            orderBy=NotImplemented,
            advancedSearch=NotImplemented,
            idEqual=NotImplemented,
            idIn=NotImplemented,
            idNotIn=NotImplemented,
            nameLike=NotImplemented,
            nameMultiLikeOr=NotImplemented,
            nameMultiLikeAnd=NotImplemented,
            nameEqual=NotImplemented,
            partnerIdEqual=NotImplemented,
            partnerIdIn=NotImplemented,
            userIdEqual=NotImplemented,
            userIdIn=NotImplemented,
            userIdNotIn=NotImplemented,
            creatorIdEqual=NotImplemented,
            tagsLike=NotImplemented,
            tagsMultiLikeOr=NotImplemented,
            tagsMultiLikeAnd=NotImplemented,
            adminTagsLike=NotImplemented,
            adminTagsMultiLikeOr=NotImplemented,
            adminTagsMultiLikeAnd=NotImplemented,
            categoriesMatchAnd=NotImplemented,
            categoriesMatchOr=NotImplemented,
            categoriesNotContains=NotImplemented,
            categoriesIdsMatchAnd=NotImplemented,
            categoriesIdsMatchOr=NotImplemented,
            categoriesIdsNotContains=NotImplemented,
            categoriesIdsEmpty=NotImplemented,
            statusEqual=NotImplemented,
            statusNotEqual=NotImplemented,
            statusIn=NotImplemented,
            statusNotIn=NotImplemented,
            moderationStatusEqual=NotImplemented,
            moderationStatusNotEqual=NotImplemented,
            moderationStatusIn=NotImplemented,
            moderationStatusNotIn=NotImplemented,
            typeEqual=NotImplemented,
            typeIn=NotImplemented,
            createdAtGreaterThanOrEqual=NotImplemented,
            createdAtLessThanOrEqual=NotImplemented,
            updatedAtGreaterThanOrEqual=NotImplemented,
            updatedAtLessThanOrEqual=NotImplemented,
            rankLessThanOrEqual=NotImplemented,
            rankGreaterThanOrEqual=NotImplemented,
            totalRankLessThanOrEqual=NotImplemented,
            totalRankGreaterThanOrEqual=NotImplemented,
            groupIdEqual=NotImplemented,
            searchTextMatchAnd=NotImplemented,
            searchTextMatchOr=NotImplemented,
            accessControlIdEqual=NotImplemented,
            accessControlIdIn=NotImplemented,
            startDateGreaterThanOrEqual=NotImplemented,
            startDateLessThanOrEqual=NotImplemented,
            startDateGreaterThanOrEqualOrNull=NotImplemented,
            startDateLessThanOrEqualOrNull=NotImplemented,
            endDateGreaterThanOrEqual=NotImplemented,
            endDateLessThanOrEqual=NotImplemented,
            endDateGreaterThanOrEqualOrNull=NotImplemented,
            endDateLessThanOrEqualOrNull=NotImplemented,
            referenceIdEqual=NotImplemented,
            referenceIdIn=NotImplemented,
            replacingEntryIdEqual=NotImplemented,
            replacingEntryIdIn=NotImplemented,
            replacedEntryIdEqual=NotImplemented,
            replacedEntryIdIn=NotImplemented,
            replacementStatusEqual=NotImplemented,
            replacementStatusIn=NotImplemented,
            partnerSortValueGreaterThanOrEqual=NotImplemented,
            partnerSortValueLessThanOrEqual=NotImplemented,
            rootEntryIdEqual=NotImplemented,
            rootEntryIdIn=NotImplemented,
            parentEntryIdEqual=NotImplemented,
            entitledUsersEditMatchAnd=NotImplemented,
            entitledUsersEditMatchOr=NotImplemented,
            entitledUsersPublishMatchAnd=NotImplemented,
            entitledUsersPublishMatchOr=NotImplemented,
            entitledUsersViewMatchAnd=NotImplemented,
            entitledUsersViewMatchOr=NotImplemented,
            tagsNameMultiLikeOr=NotImplemented,
            tagsAdminTagsMultiLikeOr=NotImplemented,
            tagsAdminTagsNameMultiLikeOr=NotImplemented,
            tagsNameMultiLikeAnd=NotImplemented,
            tagsAdminTagsMultiLikeAnd=NotImplemented,
            tagsAdminTagsNameMultiLikeAnd=NotImplemented,
            freeText=NotImplemented,
            excludedFreeTextGroups=NotImplemented,
            descriptionLike=NotImplemented,
            isRoot=NotImplemented,
            categoriesFullNameIn=NotImplemented,
            categoryAncestorIdIn=NotImplemented,
            redirectFromEntryId=NotImplemented,
            conversionProfileIdEqual=NotImplemented,
            lastPlayedAtGreaterThanOrEqual=NotImplemented,
            lastPlayedAtLessThanOrEqual=NotImplemented,
            lastPlayedAtLessThanOrEqualOrNull=NotImplemented,
            durationLessThan=NotImplemented,
            durationGreaterThan=NotImplemented,
            durationLessThanOrEqual=NotImplemented,
            durationGreaterThanOrEqual=NotImplemented,
            durationTypeMatchOr=NotImplemented,
            mediaTypeEqual=NotImplemented,
            mediaTypeIn=NotImplemented,
            sourceTypeEqual=NotImplemented,
            sourceTypeNotEqual=NotImplemented,
            sourceTypeIn=NotImplemented,
            sourceTypeNotIn=NotImplemented,
            mediaDateGreaterThanOrEqual=NotImplemented,
            mediaDateLessThanOrEqual=NotImplemented,
            flavorParamsIdsMatchOr=NotImplemented,
            flavorParamsIdsMatchAnd=NotImplemented):
        KalturaPlayableEntryFilter.__init__(self,
            orderBy,
            advancedSearch,
            idEqual,
            idIn,
            idNotIn,
            nameLike,
            nameMultiLikeOr,
            nameMultiLikeAnd,
            nameEqual,
            partnerIdEqual,
            partnerIdIn,
            userIdEqual,
            userIdIn,
            userIdNotIn,
            creatorIdEqual,
            tagsLike,
            tagsMultiLikeOr,
            tagsMultiLikeAnd,
            adminTagsLike,
            adminTagsMultiLikeOr,
            adminTagsMultiLikeAnd,
            categoriesMatchAnd,
            categoriesMatchOr,
            categoriesNotContains,
            categoriesIdsMatchAnd,
            categoriesIdsMatchOr,
            categoriesIdsNotContains,
            categoriesIdsEmpty,
            statusEqual,
            statusNotEqual,
            statusIn,
            statusNotIn,
            moderationStatusEqual,
            moderationStatusNotEqual,
            moderationStatusIn,
            moderationStatusNotIn,
            typeEqual,
            typeIn,
            createdAtGreaterThanOrEqual,
            createdAtLessThanOrEqual,
            updatedAtGreaterThanOrEqual,
            updatedAtLessThanOrEqual,
            rankLessThanOrEqual,
            rankGreaterThanOrEqual,
            totalRankLessThanOrEqual,
            totalRankGreaterThanOrEqual,
            groupIdEqual,
            searchTextMatchAnd,
            searchTextMatchOr,
            accessControlIdEqual,
            accessControlIdIn,
            startDateGreaterThanOrEqual,
            startDateLessThanOrEqual,
            startDateGreaterThanOrEqualOrNull,
            startDateLessThanOrEqualOrNull,
            endDateGreaterThanOrEqual,
            endDateLessThanOrEqual,
            endDateGreaterThanOrEqualOrNull,
            endDateLessThanOrEqualOrNull,
            referenceIdEqual,
            referenceIdIn,
            replacingEntryIdEqual,
            replacingEntryIdIn,
            replacedEntryIdEqual,
            replacedEntryIdIn,
            replacementStatusEqual,
            replacementStatusIn,
            partnerSortValueGreaterThanOrEqual,
            partnerSortValueLessThanOrEqual,
            rootEntryIdEqual,
            rootEntryIdIn,
            parentEntryIdEqual,
            entitledUsersEditMatchAnd,
            entitledUsersEditMatchOr,
            entitledUsersPublishMatchAnd,
            entitledUsersPublishMatchOr,
            entitledUsersViewMatchAnd,
            entitledUsersViewMatchOr,
            tagsNameMultiLikeOr,
            tagsAdminTagsMultiLikeOr,
            tagsAdminTagsNameMultiLikeOr,
            tagsNameMultiLikeAnd,
            tagsAdminTagsMultiLikeAnd,
            tagsAdminTagsNameMultiLikeAnd,
            freeText,
            excludedFreeTextGroups,
            descriptionLike,
            isRoot,
            categoriesFullNameIn,
            categoryAncestorIdIn,
            redirectFromEntryId,
            conversionProfileIdEqual,
            lastPlayedAtGreaterThanOrEqual,
            lastPlayedAtLessThanOrEqual,
            lastPlayedAtLessThanOrEqualOrNull,
            durationLessThan,
            durationGreaterThan,
            durationLessThanOrEqual,
            durationGreaterThanOrEqual,
            durationTypeMatchOr)

        # @var KalturaMediaType
        self.mediaTypeEqual = mediaTypeEqual

        # @var string
        self.mediaTypeIn = mediaTypeIn

        # @var KalturaSourceType
        self.sourceTypeEqual = sourceTypeEqual

        # @var KalturaSourceType
        self.sourceTypeNotEqual = sourceTypeNotEqual

        # @var string
        self.sourceTypeIn = sourceTypeIn

        # @var string
        self.sourceTypeNotIn = sourceTypeNotIn

        # @var int
        self.mediaDateGreaterThanOrEqual = mediaDateGreaterThanOrEqual

        # @var int
        self.mediaDateLessThanOrEqual = mediaDateLessThanOrEqual

        # @var string
        self.flavorParamsIdsMatchOr = flavorParamsIdsMatchOr

        # @var string
        self.flavorParamsIdsMatchAnd = flavorParamsIdsMatchAnd


    PROPERTY_LOADERS = {
        'mediaTypeEqual': (KalturaEnumsFactory.createInt, "KalturaMediaType"), 
        'mediaTypeIn': getXmlNodeText, 
        'sourceTypeEqual': (KalturaEnumsFactory.createString, "KalturaSourceType"), 
        'sourceTypeNotEqual': (KalturaEnumsFactory.createString, "KalturaSourceType"), 
        'sourceTypeIn': getXmlNodeText, 
        'sourceTypeNotIn': getXmlNodeText, 
        'mediaDateGreaterThanOrEqual': getXmlNodeInt, 
        'mediaDateLessThanOrEqual': getXmlNodeInt, 
        'flavorParamsIdsMatchOr': getXmlNodeText, 
        'flavorParamsIdsMatchAnd': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaPlayableEntryFilter.fromXml(self, node)
        self.fromXmlImpl(node, KalturaMediaEntryBaseFilter.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaPlayableEntryFilter.toParams(self)
        kparams.put("objectType", "KalturaMediaEntryBaseFilter")
        kparams.addIntEnumIfDefined("mediaTypeEqual", self.mediaTypeEqual)
        kparams.addStringIfDefined("mediaTypeIn", self.mediaTypeIn)
        kparams.addStringEnumIfDefined("sourceTypeEqual", self.sourceTypeEqual)
        kparams.addStringEnumIfDefined("sourceTypeNotEqual", self.sourceTypeNotEqual)
        kparams.addStringIfDefined("sourceTypeIn", self.sourceTypeIn)
        kparams.addStringIfDefined("sourceTypeNotIn", self.sourceTypeNotIn)
        kparams.addIntIfDefined("mediaDateGreaterThanOrEqual", self.mediaDateGreaterThanOrEqual)
        kparams.addIntIfDefined("mediaDateLessThanOrEqual", self.mediaDateLessThanOrEqual)
        kparams.addStringIfDefined("flavorParamsIdsMatchOr", self.flavorParamsIdsMatchOr)
        kparams.addStringIfDefined("flavorParamsIdsMatchAnd", self.flavorParamsIdsMatchAnd)
        return kparams

    def getMediaTypeEqual(self):
        return self.mediaTypeEqual

    def setMediaTypeEqual(self, newMediaTypeEqual):
        self.mediaTypeEqual = newMediaTypeEqual

    def getMediaTypeIn(self):
        return self.mediaTypeIn

    def setMediaTypeIn(self, newMediaTypeIn):
        self.mediaTypeIn = newMediaTypeIn

    def getSourceTypeEqual(self):
        return self.sourceTypeEqual

    def setSourceTypeEqual(self, newSourceTypeEqual):
        self.sourceTypeEqual = newSourceTypeEqual

    def getSourceTypeNotEqual(self):
        return self.sourceTypeNotEqual

    def setSourceTypeNotEqual(self, newSourceTypeNotEqual):
        self.sourceTypeNotEqual = newSourceTypeNotEqual

    def getSourceTypeIn(self):
        return self.sourceTypeIn

    def setSourceTypeIn(self, newSourceTypeIn):
        self.sourceTypeIn = newSourceTypeIn

    def getSourceTypeNotIn(self):
        return self.sourceTypeNotIn

    def setSourceTypeNotIn(self, newSourceTypeNotIn):
        self.sourceTypeNotIn = newSourceTypeNotIn

    def getMediaDateGreaterThanOrEqual(self):
        return self.mediaDateGreaterThanOrEqual

    def setMediaDateGreaterThanOrEqual(self, newMediaDateGreaterThanOrEqual):
        self.mediaDateGreaterThanOrEqual = newMediaDateGreaterThanOrEqual

    def getMediaDateLessThanOrEqual(self):
        return self.mediaDateLessThanOrEqual

    def setMediaDateLessThanOrEqual(self, newMediaDateLessThanOrEqual):
        self.mediaDateLessThanOrEqual = newMediaDateLessThanOrEqual

    def getFlavorParamsIdsMatchOr(self):
        return self.flavorParamsIdsMatchOr

    def setFlavorParamsIdsMatchOr(self, newFlavorParamsIdsMatchOr):
        self.flavorParamsIdsMatchOr = newFlavorParamsIdsMatchOr

    def getFlavorParamsIdsMatchAnd(self):
        return self.flavorParamsIdsMatchAnd

    def setFlavorParamsIdsMatchAnd(self, newFlavorParamsIdsMatchAnd):
        self.flavorParamsIdsMatchAnd = newFlavorParamsIdsMatchAnd


# @package Kaltura
# @subpackage Client
class KalturaMediaEntryFilter(KalturaMediaEntryBaseFilter):
    def __init__(self,
            orderBy=NotImplemented,
            advancedSearch=NotImplemented,
            idEqual=NotImplemented,
            idIn=NotImplemented,
            idNotIn=NotImplemented,
            nameLike=NotImplemented,
            nameMultiLikeOr=NotImplemented,
            nameMultiLikeAnd=NotImplemented,
            nameEqual=NotImplemented,
            partnerIdEqual=NotImplemented,
            partnerIdIn=NotImplemented,
            userIdEqual=NotImplemented,
            userIdIn=NotImplemented,
            userIdNotIn=NotImplemented,
            creatorIdEqual=NotImplemented,
            tagsLike=NotImplemented,
            tagsMultiLikeOr=NotImplemented,
            tagsMultiLikeAnd=NotImplemented,
            adminTagsLike=NotImplemented,
            adminTagsMultiLikeOr=NotImplemented,
            adminTagsMultiLikeAnd=NotImplemented,
            categoriesMatchAnd=NotImplemented,
            categoriesMatchOr=NotImplemented,
            categoriesNotContains=NotImplemented,
            categoriesIdsMatchAnd=NotImplemented,
            categoriesIdsMatchOr=NotImplemented,
            categoriesIdsNotContains=NotImplemented,
            categoriesIdsEmpty=NotImplemented,
            statusEqual=NotImplemented,
            statusNotEqual=NotImplemented,
            statusIn=NotImplemented,
            statusNotIn=NotImplemented,
            moderationStatusEqual=NotImplemented,
            moderationStatusNotEqual=NotImplemented,
            moderationStatusIn=NotImplemented,
            moderationStatusNotIn=NotImplemented,
            typeEqual=NotImplemented,
            typeIn=NotImplemented,
            createdAtGreaterThanOrEqual=NotImplemented,
            createdAtLessThanOrEqual=NotImplemented,
            updatedAtGreaterThanOrEqual=NotImplemented,
            updatedAtLessThanOrEqual=NotImplemented,
            rankLessThanOrEqual=NotImplemented,
            rankGreaterThanOrEqual=NotImplemented,
            totalRankLessThanOrEqual=NotImplemented,
            totalRankGreaterThanOrEqual=NotImplemented,
            groupIdEqual=NotImplemented,
            searchTextMatchAnd=NotImplemented,
            searchTextMatchOr=NotImplemented,
            accessControlIdEqual=NotImplemented,
            accessControlIdIn=NotImplemented,
            startDateGreaterThanOrEqual=NotImplemented,
            startDateLessThanOrEqual=NotImplemented,
            startDateGreaterThanOrEqualOrNull=NotImplemented,
            startDateLessThanOrEqualOrNull=NotImplemented,
            endDateGreaterThanOrEqual=NotImplemented,
            endDateLessThanOrEqual=NotImplemented,
            endDateGreaterThanOrEqualOrNull=NotImplemented,
            endDateLessThanOrEqualOrNull=NotImplemented,
            referenceIdEqual=NotImplemented,
            referenceIdIn=NotImplemented,
            replacingEntryIdEqual=NotImplemented,
            replacingEntryIdIn=NotImplemented,
            replacedEntryIdEqual=NotImplemented,
            replacedEntryIdIn=NotImplemented,
            replacementStatusEqual=NotImplemented,
            replacementStatusIn=NotImplemented,
            partnerSortValueGreaterThanOrEqual=NotImplemented,
            partnerSortValueLessThanOrEqual=NotImplemented,
            rootEntryIdEqual=NotImplemented,
            rootEntryIdIn=NotImplemented,
            parentEntryIdEqual=NotImplemented,
            entitledUsersEditMatchAnd=NotImplemented,
            entitledUsersEditMatchOr=NotImplemented,
            entitledUsersPublishMatchAnd=NotImplemented,
            entitledUsersPublishMatchOr=NotImplemented,
            entitledUsersViewMatchAnd=NotImplemented,
            entitledUsersViewMatchOr=NotImplemented,
            tagsNameMultiLikeOr=NotImplemented,
            tagsAdminTagsMultiLikeOr=NotImplemented,
            tagsAdminTagsNameMultiLikeOr=NotImplemented,
            tagsNameMultiLikeAnd=NotImplemented,
            tagsAdminTagsMultiLikeAnd=NotImplemented,
            tagsAdminTagsNameMultiLikeAnd=NotImplemented,
            freeText=NotImplemented,
            excludedFreeTextGroups=NotImplemented,
            descriptionLike=NotImplemented,
            isRoot=NotImplemented,
            categoriesFullNameIn=NotImplemented,
            categoryAncestorIdIn=NotImplemented,
            redirectFromEntryId=NotImplemented,
            conversionProfileIdEqual=NotImplemented,
            lastPlayedAtGreaterThanOrEqual=NotImplemented,
            lastPlayedAtLessThanOrEqual=NotImplemented,
            lastPlayedAtLessThanOrEqualOrNull=NotImplemented,
            durationLessThan=NotImplemented,
            durationGreaterThan=NotImplemented,
            durationLessThanOrEqual=NotImplemented,
            durationGreaterThanOrEqual=NotImplemented,
            durationTypeMatchOr=NotImplemented,
            mediaTypeEqual=NotImplemented,
            mediaTypeIn=NotImplemented,
            sourceTypeEqual=NotImplemented,
            sourceTypeNotEqual=NotImplemented,
            sourceTypeIn=NotImplemented,
            sourceTypeNotIn=NotImplemented,
            mediaDateGreaterThanOrEqual=NotImplemented,
            mediaDateLessThanOrEqual=NotImplemented,
            flavorParamsIdsMatchOr=NotImplemented,
            flavorParamsIdsMatchAnd=NotImplemented):
        KalturaMediaEntryBaseFilter.__init__(self,
            orderBy,
            advancedSearch,
            idEqual,
            idIn,
            idNotIn,
            nameLike,
            nameMultiLikeOr,
            nameMultiLikeAnd,
            nameEqual,
            partnerIdEqual,
            partnerIdIn,
            userIdEqual,
            userIdIn,
            userIdNotIn,
            creatorIdEqual,
            tagsLike,
            tagsMultiLikeOr,
            tagsMultiLikeAnd,
            adminTagsLike,
            adminTagsMultiLikeOr,
            adminTagsMultiLikeAnd,
            categoriesMatchAnd,
            categoriesMatchOr,
            categoriesNotContains,
            categoriesIdsMatchAnd,
            categoriesIdsMatchOr,
            categoriesIdsNotContains,
            categoriesIdsEmpty,
            statusEqual,
            statusNotEqual,
            statusIn,
            statusNotIn,
            moderationStatusEqual,
            moderationStatusNotEqual,
            moderationStatusIn,
            moderationStatusNotIn,
            typeEqual,
            typeIn,
            createdAtGreaterThanOrEqual,
            createdAtLessThanOrEqual,
            updatedAtGreaterThanOrEqual,
            updatedAtLessThanOrEqual,
            rankLessThanOrEqual,
            rankGreaterThanOrEqual,
            totalRankLessThanOrEqual,
            totalRankGreaterThanOrEqual,
            groupIdEqual,
            searchTextMatchAnd,
            searchTextMatchOr,
            accessControlIdEqual,
            accessControlIdIn,
            startDateGreaterThanOrEqual,
            startDateLessThanOrEqual,
            startDateGreaterThanOrEqualOrNull,
            startDateLessThanOrEqualOrNull,
            endDateGreaterThanOrEqual,
            endDateLessThanOrEqual,
            endDateGreaterThanOrEqualOrNull,
            endDateLessThanOrEqualOrNull,
            referenceIdEqual,
            referenceIdIn,
            replacingEntryIdEqual,
            replacingEntryIdIn,
            replacedEntryIdEqual,
            replacedEntryIdIn,
            replacementStatusEqual,
            replacementStatusIn,
            partnerSortValueGreaterThanOrEqual,
            partnerSortValueLessThanOrEqual,
            rootEntryIdEqual,
            rootEntryIdIn,
            parentEntryIdEqual,
            entitledUsersEditMatchAnd,
            entitledUsersEditMatchOr,
            entitledUsersPublishMatchAnd,
            entitledUsersPublishMatchOr,
            entitledUsersViewMatchAnd,
            entitledUsersViewMatchOr,
            tagsNameMultiLikeOr,
            tagsAdminTagsMultiLikeOr,
            tagsAdminTagsNameMultiLikeOr,
            tagsNameMultiLikeAnd,
            tagsAdminTagsMultiLikeAnd,
            tagsAdminTagsNameMultiLikeAnd,
            freeText,
            excludedFreeTextGroups,
            descriptionLike,
            isRoot,
            categoriesFullNameIn,
            categoryAncestorIdIn,
            redirectFromEntryId,
            conversionProfileIdEqual,
            lastPlayedAtGreaterThanOrEqual,
            lastPlayedAtLessThanOrEqual,
            lastPlayedAtLessThanOrEqualOrNull,
            durationLessThan,
            durationGreaterThan,
            durationLessThanOrEqual,
            durationGreaterThanOrEqual,
            durationTypeMatchOr,
            mediaTypeEqual,
            mediaTypeIn,
            sourceTypeEqual,
            sourceTypeNotEqual,
            sourceTypeIn,
            sourceTypeNotIn,
            mediaDateGreaterThanOrEqual,
            mediaDateLessThanOrEqual,
            flavorParamsIdsMatchOr,
            flavorParamsIdsMatchAnd)


    PROPERTY_LOADERS = {
    }

    def fromXml(self, node):
        KalturaMediaEntryBaseFilter.fromXml(self, node)
        self.fromXmlImpl(node, KalturaMediaEntryFilter.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaMediaEntryBaseFilter.toParams(self)
        kparams.put("objectType", "KalturaMediaEntryFilter")
        return kparams


# @package Kaltura
# @subpackage Client
class KalturaMediaEntryFilterForPlaylist(KalturaMediaEntryFilter):
    def __init__(self,
            orderBy=NotImplemented,
            advancedSearch=NotImplemented,
            idEqual=NotImplemented,
            idIn=NotImplemented,
            idNotIn=NotImplemented,
            nameLike=NotImplemented,
            nameMultiLikeOr=NotImplemented,
            nameMultiLikeAnd=NotImplemented,
            nameEqual=NotImplemented,
            partnerIdEqual=NotImplemented,
            partnerIdIn=NotImplemented,
            userIdEqual=NotImplemented,
            userIdIn=NotImplemented,
            userIdNotIn=NotImplemented,
            creatorIdEqual=NotImplemented,
            tagsLike=NotImplemented,
            tagsMultiLikeOr=NotImplemented,
            tagsMultiLikeAnd=NotImplemented,
            adminTagsLike=NotImplemented,
            adminTagsMultiLikeOr=NotImplemented,
            adminTagsMultiLikeAnd=NotImplemented,
            categoriesMatchAnd=NotImplemented,
            categoriesMatchOr=NotImplemented,
            categoriesNotContains=NotImplemented,
            categoriesIdsMatchAnd=NotImplemented,
            categoriesIdsMatchOr=NotImplemented,
            categoriesIdsNotContains=NotImplemented,
            categoriesIdsEmpty=NotImplemented,
            statusEqual=NotImplemented,
            statusNotEqual=NotImplemented,
            statusIn=NotImplemented,
            statusNotIn=NotImplemented,
            moderationStatusEqual=NotImplemented,
            moderationStatusNotEqual=NotImplemented,
            moderationStatusIn=NotImplemented,
            moderationStatusNotIn=NotImplemented,
            typeEqual=NotImplemented,
            typeIn=NotImplemented,
            createdAtGreaterThanOrEqual=NotImplemented,
            createdAtLessThanOrEqual=NotImplemented,
            updatedAtGreaterThanOrEqual=NotImplemented,
            updatedAtLessThanOrEqual=NotImplemented,
            rankLessThanOrEqual=NotImplemented,
            rankGreaterThanOrEqual=NotImplemented,
            totalRankLessThanOrEqual=NotImplemented,
            totalRankGreaterThanOrEqual=NotImplemented,
            groupIdEqual=NotImplemented,
            searchTextMatchAnd=NotImplemented,
            searchTextMatchOr=NotImplemented,
            accessControlIdEqual=NotImplemented,
            accessControlIdIn=NotImplemented,
            startDateGreaterThanOrEqual=NotImplemented,
            startDateLessThanOrEqual=NotImplemented,
            startDateGreaterThanOrEqualOrNull=NotImplemented,
            startDateLessThanOrEqualOrNull=NotImplemented,
            endDateGreaterThanOrEqual=NotImplemented,
            endDateLessThanOrEqual=NotImplemented,
            endDateGreaterThanOrEqualOrNull=NotImplemented,
            endDateLessThanOrEqualOrNull=NotImplemented,
            referenceIdEqual=NotImplemented,
            referenceIdIn=NotImplemented,
            replacingEntryIdEqual=NotImplemented,
            replacingEntryIdIn=NotImplemented,
            replacedEntryIdEqual=NotImplemented,
            replacedEntryIdIn=NotImplemented,
            replacementStatusEqual=NotImplemented,
            replacementStatusIn=NotImplemented,
            partnerSortValueGreaterThanOrEqual=NotImplemented,
            partnerSortValueLessThanOrEqual=NotImplemented,
            rootEntryIdEqual=NotImplemented,
            rootEntryIdIn=NotImplemented,
            parentEntryIdEqual=NotImplemented,
            entitledUsersEditMatchAnd=NotImplemented,
            entitledUsersEditMatchOr=NotImplemented,
            entitledUsersPublishMatchAnd=NotImplemented,
            entitledUsersPublishMatchOr=NotImplemented,
            entitledUsersViewMatchAnd=NotImplemented,
            entitledUsersViewMatchOr=NotImplemented,
            tagsNameMultiLikeOr=NotImplemented,
            tagsAdminTagsMultiLikeOr=NotImplemented,
            tagsAdminTagsNameMultiLikeOr=NotImplemented,
            tagsNameMultiLikeAnd=NotImplemented,
            tagsAdminTagsMultiLikeAnd=NotImplemented,
            tagsAdminTagsNameMultiLikeAnd=NotImplemented,
            freeText=NotImplemented,
            excludedFreeTextGroups=NotImplemented,
            descriptionLike=NotImplemented,
            isRoot=NotImplemented,
            categoriesFullNameIn=NotImplemented,
            categoryAncestorIdIn=NotImplemented,
            redirectFromEntryId=NotImplemented,
            conversionProfileIdEqual=NotImplemented,
            lastPlayedAtGreaterThanOrEqual=NotImplemented,
            lastPlayedAtLessThanOrEqual=NotImplemented,
            lastPlayedAtLessThanOrEqualOrNull=NotImplemented,
            durationLessThan=NotImplemented,
            durationGreaterThan=NotImplemented,
            durationLessThanOrEqual=NotImplemented,
            durationGreaterThanOrEqual=NotImplemented,
            durationTypeMatchOr=NotImplemented,
            mediaTypeEqual=NotImplemented,
            mediaTypeIn=NotImplemented,
            sourceTypeEqual=NotImplemented,
            sourceTypeNotEqual=NotImplemented,
            sourceTypeIn=NotImplemented,
            sourceTypeNotIn=NotImplemented,
            mediaDateGreaterThanOrEqual=NotImplemented,
            mediaDateLessThanOrEqual=NotImplemented,
            flavorParamsIdsMatchOr=NotImplemented,
            flavorParamsIdsMatchAnd=NotImplemented,
            limit=NotImplemented,
            name=NotImplemented):
        KalturaMediaEntryFilter.__init__(self,
            orderBy,
            advancedSearch,
            idEqual,
            idIn,
            idNotIn,
            nameLike,
            nameMultiLikeOr,
            nameMultiLikeAnd,
            nameEqual,
            partnerIdEqual,
            partnerIdIn,
            userIdEqual,
            userIdIn,
            userIdNotIn,
            creatorIdEqual,
            tagsLike,
            tagsMultiLikeOr,
            tagsMultiLikeAnd,
            adminTagsLike,
            adminTagsMultiLikeOr,
            adminTagsMultiLikeAnd,
            categoriesMatchAnd,
            categoriesMatchOr,
            categoriesNotContains,
            categoriesIdsMatchAnd,
            categoriesIdsMatchOr,
            categoriesIdsNotContains,
            categoriesIdsEmpty,
            statusEqual,
            statusNotEqual,
            statusIn,
            statusNotIn,
            moderationStatusEqual,
            moderationStatusNotEqual,
            moderationStatusIn,
            moderationStatusNotIn,
            typeEqual,
            typeIn,
            createdAtGreaterThanOrEqual,
            createdAtLessThanOrEqual,
            updatedAtGreaterThanOrEqual,
            updatedAtLessThanOrEqual,
            rankLessThanOrEqual,
            rankGreaterThanOrEqual,
            totalRankLessThanOrEqual,
            totalRankGreaterThanOrEqual,
            groupIdEqual,
            searchTextMatchAnd,
            searchTextMatchOr,
            accessControlIdEqual,
            accessControlIdIn,
            startDateGreaterThanOrEqual,
            startDateLessThanOrEqual,
            startDateGreaterThanOrEqualOrNull,
            startDateLessThanOrEqualOrNull,
            endDateGreaterThanOrEqual,
            endDateLessThanOrEqual,
            endDateGreaterThanOrEqualOrNull,
            endDateLessThanOrEqualOrNull,
            referenceIdEqual,
            referenceIdIn,
            replacingEntryIdEqual,
            replacingEntryIdIn,
            replacedEntryIdEqual,
            replacedEntryIdIn,
            replacementStatusEqual,
            replacementStatusIn,
            partnerSortValueGreaterThanOrEqual,
            partnerSortValueLessThanOrEqual,
            rootEntryIdEqual,
            rootEntryIdIn,
            parentEntryIdEqual,
            entitledUsersEditMatchAnd,
            entitledUsersEditMatchOr,
            entitledUsersPublishMatchAnd,
            entitledUsersPublishMatchOr,
            entitledUsersViewMatchAnd,
            entitledUsersViewMatchOr,
            tagsNameMultiLikeOr,
            tagsAdminTagsMultiLikeOr,
            tagsAdminTagsNameMultiLikeOr,
            tagsNameMultiLikeAnd,
            tagsAdminTagsMultiLikeAnd,
            tagsAdminTagsNameMultiLikeAnd,
            freeText,
            excludedFreeTextGroups,
            descriptionLike,
            isRoot,
            categoriesFullNameIn,
            categoryAncestorIdIn,
            redirectFromEntryId,
            conversionProfileIdEqual,
            lastPlayedAtGreaterThanOrEqual,
            lastPlayedAtLessThanOrEqual,
            lastPlayedAtLessThanOrEqualOrNull,
            durationLessThan,
            durationGreaterThan,
            durationLessThanOrEqual,
            durationGreaterThanOrEqual,
            durationTypeMatchOr,
            mediaTypeEqual,
            mediaTypeIn,
            sourceTypeEqual,
            sourceTypeNotEqual,
            sourceTypeIn,
            sourceTypeNotIn,
            mediaDateGreaterThanOrEqual,
            mediaDateLessThanOrEqual,
            flavorParamsIdsMatchOr,
            flavorParamsIdsMatchAnd)

        # @var int
        self.limit = limit

        # @var string
        self.name = name


    PROPERTY_LOADERS = {
        'limit': getXmlNodeInt, 
        'name': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaMediaEntryFilter.fromXml(self, node)
        self.fromXmlImpl(node, KalturaMediaEntryFilterForPlaylist.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaMediaEntryFilter.toParams(self)
        kparams.put("objectType", "KalturaMediaEntryFilterForPlaylist")
        kparams.addIntIfDefined("limit", self.limit)
        kparams.addStringIfDefined("name", self.name)
        return kparams

    def getLimit(self):
        return self.limit

    def setLimit(self, newLimit):
        self.limit = newLimit

    def getName(self):
        return self.name

    def setName(self, newName):
        self.name = newName


# @package Kaltura
# @subpackage Client
class KalturaMixEntry(KalturaPlayableEntry):
    def __init__(self,
            id=NotImplemented,
            name=NotImplemented,
            description=NotImplemented,
            partnerId=NotImplemented,
            userId=NotImplemented,
            creatorId=NotImplemented,
            tags=NotImplemented,
            adminTags=NotImplemented,
            categories=NotImplemented,
            categoriesIds=NotImplemented,
            status=NotImplemented,
            moderationStatus=NotImplemented,
            moderationCount=NotImplemented,
            type=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented,
            rank=NotImplemented,
            totalRank=NotImplemented,
            votes=NotImplemented,
            groupId=NotImplemented,
            partnerData=NotImplemented,
            downloadUrl=NotImplemented,
            searchText=NotImplemented,
            licenseType=NotImplemented,
            version=NotImplemented,
            thumbnailUrl=NotImplemented,
            accessControlId=NotImplemented,
            startDate=NotImplemented,
            endDate=NotImplemented,
            referenceId=NotImplemented,
            replacingEntryId=NotImplemented,
            replacedEntryId=NotImplemented,
            replacementStatus=NotImplemented,
            partnerSortValue=NotImplemented,
            conversionProfileId=NotImplemented,
            redirectEntryId=NotImplemented,
            rootEntryId=NotImplemented,
            parentEntryId=NotImplemented,
            operationAttributes=NotImplemented,
            entitledUsersEdit=NotImplemented,
            entitledUsersPublish=NotImplemented,
            entitledUsersView=NotImplemented,
            capabilities=NotImplemented,
            templateEntryId=NotImplemented,
            displayInSearch=NotImplemented,
            application=NotImplemented,
            applicationVersion=NotImplemented,
            blockAutoTranscript=NotImplemented,
            plays=NotImplemented,
            views=NotImplemented,
            lastPlayedAt=NotImplemented,
            width=NotImplemented,
            height=NotImplemented,
            duration=NotImplemented,
            msDuration=NotImplemented,
            durationType=NotImplemented,
            hasRealThumbnail=NotImplemented,
            editorType=NotImplemented,
            dataContent=NotImplemented):
        KalturaPlayableEntry.__init__(self,
            id,
            name,
            description,
            partnerId,
            userId,
            creatorId,
            tags,
            adminTags,
            categories,
            categoriesIds,
            status,
            moderationStatus,
            moderationCount,
            type,
            createdAt,
            updatedAt,
            rank,
            totalRank,
            votes,
            groupId,
            partnerData,
            downloadUrl,
            searchText,
            licenseType,
            version,
            thumbnailUrl,
            accessControlId,
            startDate,
            endDate,
            referenceId,
            replacingEntryId,
            replacedEntryId,
            replacementStatus,
            partnerSortValue,
            conversionProfileId,
            redirectEntryId,
            rootEntryId,
            parentEntryId,
            operationAttributes,
            entitledUsersEdit,
            entitledUsersPublish,
            entitledUsersView,
            capabilities,
            templateEntryId,
            displayInSearch,
            application,
            applicationVersion,
            blockAutoTranscript,
            plays,
            views,
            lastPlayedAt,
            width,
            height,
            duration,
            msDuration,
            durationType)

        # Indicates whether the user has submited a real thumbnail to the mix (Not the one that was generated automaticaly)
        # @var bool
        # @readonly
        self.hasRealThumbnail = hasRealThumbnail

        # The editor type used to edit the metadata
        # @var KalturaEditorType
        self.editorType = editorType

        # The xml data of the mix
        # @var string
        self.dataContent = dataContent


    PROPERTY_LOADERS = {
        'hasRealThumbnail': getXmlNodeBool, 
        'editorType': (KalturaEnumsFactory.createInt, "KalturaEditorType"), 
        'dataContent': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaPlayableEntry.fromXml(self, node)
        self.fromXmlImpl(node, KalturaMixEntry.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaPlayableEntry.toParams(self)
        kparams.put("objectType", "KalturaMixEntry")
        kparams.addIntEnumIfDefined("editorType", self.editorType)
        kparams.addStringIfDefined("dataContent", self.dataContent)
        return kparams

    def getHasRealThumbnail(self):
        return self.hasRealThumbnail

    def getEditorType(self):
        return self.editorType

    def setEditorType(self, newEditorType):
        self.editorType = newEditorType

    def getDataContent(self):
        return self.dataContent

    def setDataContent(self, newDataContent):
        self.dataContent = newDataContent


# @package Kaltura
# @subpackage Client
class KalturaModerationFlag(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            partnerId=NotImplemented,
            userId=NotImplemented,
            moderationObjectType=NotImplemented,
            flaggedEntryId=NotImplemented,
            flaggedUserId=NotImplemented,
            status=NotImplemented,
            comments=NotImplemented,
            flagType=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented):
        KalturaObjectBase.__init__(self)

        # Moderation flag id
        # @var int
        # @readonly
        self.id = id

        # @var int
        # @readonly
        self.partnerId = partnerId

        # The user id that added the moderation flag
        # @var string
        # @readonly
        self.userId = userId

        # The type of the moderation flag (entry or user)
        # @var KalturaModerationObjectType
        # @readonly
        self.moderationObjectType = moderationObjectType

        # If moderation flag is set for entry, this is the flagged entry id
        # @var string
        self.flaggedEntryId = flaggedEntryId

        # If moderation flag is set for user, this is the flagged user id
        # @var string
        self.flaggedUserId = flaggedUserId

        # The moderation flag status
        # @var KalturaModerationFlagStatus
        # @readonly
        self.status = status

        # The comment that was added to the flag
        # @var string
        self.comments = comments

        # @var KalturaModerationFlagType
        self.flagType = flagType

        # @var int
        # @readonly
        self.createdAt = createdAt

        # @var int
        # @readonly
        self.updatedAt = updatedAt


    PROPERTY_LOADERS = {
        'id': getXmlNodeInt, 
        'partnerId': getXmlNodeInt, 
        'userId': getXmlNodeText, 
        'moderationObjectType': (KalturaEnumsFactory.createString, "KalturaModerationObjectType"), 
        'flaggedEntryId': getXmlNodeText, 
        'flaggedUserId': getXmlNodeText, 
        'status': (KalturaEnumsFactory.createString, "KalturaModerationFlagStatus"), 
        'comments': getXmlNodeText, 
        'flagType': (KalturaEnumsFactory.createInt, "KalturaModerationFlagType"), 
        'createdAt': getXmlNodeInt, 
        'updatedAt': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaModerationFlag.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaModerationFlag")
        kparams.addStringIfDefined("flaggedEntryId", self.flaggedEntryId)
        kparams.addStringIfDefined("flaggedUserId", self.flaggedUserId)
        kparams.addStringIfDefined("comments", self.comments)
        kparams.addIntEnumIfDefined("flagType", self.flagType)
        return kparams

    def getId(self):
        return self.id

    def getPartnerId(self):
        return self.partnerId

    def getUserId(self):
        return self.userId

    def getModerationObjectType(self):
        return self.moderationObjectType

    def getFlaggedEntryId(self):
        return self.flaggedEntryId

    def setFlaggedEntryId(self, newFlaggedEntryId):
        self.flaggedEntryId = newFlaggedEntryId

    def getFlaggedUserId(self):
        return self.flaggedUserId

    def setFlaggedUserId(self, newFlaggedUserId):
        self.flaggedUserId = newFlaggedUserId

    def getStatus(self):
        return self.status

    def getComments(self):
        return self.comments

    def setComments(self, newComments):
        self.comments = newComments

    def getFlagType(self):
        return self.flagType

    def setFlagType(self, newFlagType):
        self.flagType = newFlagType

    def getCreatedAt(self):
        return self.createdAt

    def getUpdatedAt(self):
        return self.updatedAt


# @package Kaltura
# @subpackage Client
class KalturaPartnerPublicInfo(KalturaObjectBase):
    def __init__(self,
            analyticsUrl=NotImplemented,
            ottEnvironmentUrl=NotImplemented,
            analyticsPersistentSessionId=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.analyticsUrl = analyticsUrl

        # @var string
        self.ottEnvironmentUrl = ottEnvironmentUrl

        # @var bool
        self.analyticsPersistentSessionId = analyticsPersistentSessionId


    PROPERTY_LOADERS = {
        'analyticsUrl': getXmlNodeText, 
        'ottEnvironmentUrl': getXmlNodeText, 
        'analyticsPersistentSessionId': getXmlNodeBool, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaPartnerPublicInfo.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaPartnerPublicInfo")
        kparams.addStringIfDefined("analyticsUrl", self.analyticsUrl)
        kparams.addStringIfDefined("ottEnvironmentUrl", self.ottEnvironmentUrl)
        kparams.addBoolIfDefined("analyticsPersistentSessionId", self.analyticsPersistentSessionId)
        return kparams

    def getAnalyticsUrl(self):
        return self.analyticsUrl

    def setAnalyticsUrl(self, newAnalyticsUrl):
        self.analyticsUrl = newAnalyticsUrl

    def getOttEnvironmentUrl(self):
        return self.ottEnvironmentUrl

    def setOttEnvironmentUrl(self, newOttEnvironmentUrl):
        self.ottEnvironmentUrl = newOttEnvironmentUrl

    def getAnalyticsPersistentSessionId(self):
        return self.analyticsPersistentSessionId

    def setAnalyticsPersistentSessionId(self, newAnalyticsPersistentSessionId):
        self.analyticsPersistentSessionId = newAnalyticsPersistentSessionId


# @package Kaltura
# @subpackage Client
class KalturaPartnerStatistics(KalturaObjectBase):
    def __init__(self,
            packageBandwidthAndStorage=NotImplemented,
            hosting=NotImplemented,
            bandwidth=NotImplemented,
            usage=NotImplemented,
            usagePercent=NotImplemented,
            reachedLimitDate=NotImplemented):
        KalturaObjectBase.__init__(self)

        # Package total allowed bandwidth and storage
        # @var int
        # @readonly
        self.packageBandwidthAndStorage = packageBandwidthAndStorage

        # Partner total hosting in GB on the disk
        # @var float
        # @readonly
        self.hosting = hosting

        # Partner total bandwidth in GB
        # @var float
        # @readonly
        self.bandwidth = bandwidth

        # total usage in GB - including bandwidth and storage
        # @var int
        # @readonly
        self.usage = usage

        # Percent of usage out of partner's package. if usage is 5GB and package is 10GB, this value will be 50
        # @var float
        # @readonly
        self.usagePercent = usagePercent

        # date when partner reached the limit of his package (timestamp)
        # @var int
        # @readonly
        self.reachedLimitDate = reachedLimitDate


    PROPERTY_LOADERS = {
        'packageBandwidthAndStorage': getXmlNodeInt, 
        'hosting': getXmlNodeFloat, 
        'bandwidth': getXmlNodeFloat, 
        'usage': getXmlNodeInt, 
        'usagePercent': getXmlNodeFloat, 
        'reachedLimitDate': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaPartnerStatistics.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaPartnerStatistics")
        return kparams

    def getPackageBandwidthAndStorage(self):
        return self.packageBandwidthAndStorage

    def getHosting(self):
        return self.hosting

    def getBandwidth(self):
        return self.bandwidth

    def getUsage(self):
        return self.usage

    def getUsagePercent(self):
        return self.usagePercent

    def getReachedLimitDate(self):
        return self.reachedLimitDate


# @package Kaltura
# @subpackage Client
class KalturaPartnerUsage(KalturaObjectBase):
    def __init__(self,
            hostingGB=NotImplemented,
            Percent=NotImplemented,
            packageBW=NotImplemented,
            usageGB=NotImplemented,
            reachedLimitDate=NotImplemented,
            usageGraph=NotImplemented):
        KalturaObjectBase.__init__(self)

        # Partner total hosting in GB on the disk
        # @var float
        # @readonly
        self.hostingGB = hostingGB

        # percent of usage out of partner's package. if usageGB is 5 and package is 10GB, this value will be 50
        # @var float
        # @readonly
        self.Percent = Percent

        # package total BW - actually this is usage, which represents BW+storage
        # @var int
        # @readonly
        self.packageBW = packageBW

        # total usage in GB - including bandwidth and storage
        # @var float
        # @readonly
        self.usageGB = usageGB

        # date when partner reached the limit of his package (timestamp)
        # @var int
        # @readonly
        self.reachedLimitDate = reachedLimitDate

        # a semi-colon separated list of comma-separated key-values to represent a usage graph.
        # 	 keys could be 1-12 for a year view (1,1.2;2,1.1;3,0.9;...;12,1.4;)
        # 	 keys could be 1-[28,29,30,31] depending on the requested month, for a daily view in a given month (1,0.4;2,0.2;...;31,0.1;)
        # @var string
        # @readonly
        self.usageGraph = usageGraph


    PROPERTY_LOADERS = {
        'hostingGB': getXmlNodeFloat, 
        'Percent': getXmlNodeFloat, 
        'packageBW': getXmlNodeInt, 
        'usageGB': getXmlNodeFloat, 
        'reachedLimitDate': getXmlNodeInt, 
        'usageGraph': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaPartnerUsage.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaPartnerUsage")
        return kparams

    def getHostingGB(self):
        return self.hostingGB

    def getPercent(self):
        return self.Percent

    def getPackageBW(self):
        return self.packageBW

    def getUsageGB(self):
        return self.usageGB

    def getReachedLimitDate(self):
        return self.reachedLimitDate

    def getUsageGraph(self):
        return self.usageGraph


# @package Kaltura
# @subpackage Client
class KalturaPermission(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            type=NotImplemented,
            name=NotImplemented,
            friendlyName=NotImplemented,
            description=NotImplemented,
            status=NotImplemented,
            partnerId=NotImplemented,
            dependsOnPermissionNames=NotImplemented,
            tags=NotImplemented,
            permissionItemsIds=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented,
            partnerGroup=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var int
        # @readonly
        self.id = id

        # @var KalturaPermissionType
        # @readonly
        self.type = type

        # @var string
        self.name = name

        # @var string
        self.friendlyName = friendlyName

        # @var string
        self.description = description

        # @var KalturaPermissionStatus
        self.status = status

        # @var int
        # @readonly
        self.partnerId = partnerId

        # @var string
        self.dependsOnPermissionNames = dependsOnPermissionNames

        # @var string
        self.tags = tags

        # @var string
        self.permissionItemsIds = permissionItemsIds

        # @var int
        # @readonly
        self.createdAt = createdAt

        # @var int
        # @readonly
        self.updatedAt = updatedAt

        # @var string
        self.partnerGroup = partnerGroup


    PROPERTY_LOADERS = {
        'id': getXmlNodeInt, 
        'type': (KalturaEnumsFactory.createInt, "KalturaPermissionType"), 
        'name': getXmlNodeText, 
        'friendlyName': getXmlNodeText, 
        'description': getXmlNodeText, 
        'status': (KalturaEnumsFactory.createInt, "KalturaPermissionStatus"), 
        'partnerId': getXmlNodeInt, 
        'dependsOnPermissionNames': getXmlNodeText, 
        'tags': getXmlNodeText, 
        'permissionItemsIds': getXmlNodeText, 
        'createdAt': getXmlNodeInt, 
        'updatedAt': getXmlNodeInt, 
        'partnerGroup': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaPermission.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaPermission")
        kparams.addStringIfDefined("name", self.name)
        kparams.addStringIfDefined("friendlyName", self.friendlyName)
        kparams.addStringIfDefined("description", self.description)
        kparams.addIntEnumIfDefined("status", self.status)
        kparams.addStringIfDefined("dependsOnPermissionNames", self.dependsOnPermissionNames)
        kparams.addStringIfDefined("tags", self.tags)
        kparams.addStringIfDefined("permissionItemsIds", self.permissionItemsIds)
        kparams.addStringIfDefined("partnerGroup", self.partnerGroup)
        return kparams

    def getId(self):
        return self.id

    def getType(self):
        return self.type

    def getName(self):
        return self.name

    def setName(self, newName):
        self.name = newName

    def getFriendlyName(self):
        return self.friendlyName

    def setFriendlyName(self, newFriendlyName):
        self.friendlyName = newFriendlyName

    def getDescription(self):
        return self.description

    def setDescription(self, newDescription):
        self.description = newDescription

    def getStatus(self):
        return self.status

    def setStatus(self, newStatus):
        self.status = newStatus

    def getPartnerId(self):
        return self.partnerId

    def getDependsOnPermissionNames(self):
        return self.dependsOnPermissionNames

    def setDependsOnPermissionNames(self, newDependsOnPermissionNames):
        self.dependsOnPermissionNames = newDependsOnPermissionNames

    def getTags(self):
        return self.tags

    def setTags(self, newTags):
        self.tags = newTags

    def getPermissionItemsIds(self):
        return self.permissionItemsIds

    def setPermissionItemsIds(self, newPermissionItemsIds):
        self.permissionItemsIds = newPermissionItemsIds

    def getCreatedAt(self):
        return self.createdAt

    def getUpdatedAt(self):
        return self.updatedAt

    def getPartnerGroup(self):
        return self.partnerGroup

    def setPartnerGroup(self, newPartnerGroup):
        self.partnerGroup = newPartnerGroup


# @package Kaltura
# @subpackage Client
class KalturaPermissionItem(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            type=NotImplemented,
            partnerId=NotImplemented,
            tags=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var int
        # @readonly
        self.id = id

        # @var KalturaPermissionItemType
        # @readonly
        self.type = type

        # @var int
        # @readonly
        self.partnerId = partnerId

        # @var string
        self.tags = tags

        # @var int
        # @readonly
        self.createdAt = createdAt

        # @var int
        # @readonly
        self.updatedAt = updatedAt


    PROPERTY_LOADERS = {
        'id': getXmlNodeInt, 
        'type': (KalturaEnumsFactory.createString, "KalturaPermissionItemType"), 
        'partnerId': getXmlNodeInt, 
        'tags': getXmlNodeText, 
        'createdAt': getXmlNodeInt, 
        'updatedAt': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaPermissionItem.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaPermissionItem")
        kparams.addStringIfDefined("tags", self.tags)
        return kparams

    def getId(self):
        return self.id

    def getType(self):
        return self.type

    def getPartnerId(self):
        return self.partnerId

    def getTags(self):
        return self.tags

    def setTags(self, newTags):
        self.tags = newTags

    def getCreatedAt(self):
        return self.createdAt

    def getUpdatedAt(self):
        return self.updatedAt


# @package Kaltura
# @subpackage Client
class KalturaPlaybackSource(KalturaObjectBase):
    def __init__(self,
            deliveryProfileId=NotImplemented,
            format=NotImplemented,
            protocols=NotImplemented,
            flavorIds=NotImplemented,
            url=NotImplemented,
            drm=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.deliveryProfileId = deliveryProfileId

        # source format according to delivery profile streamer type (applehttp, mpegdash etc.)
        # @var string
        self.format = format

        # comma separated string according to deliveryProfile media protocols ('http,https' etc.)
        # @var string
        self.protocols = protocols

        # comma separated string of flavor ids
        # @var string
        self.flavorIds = flavorIds

        # @var string
        self.url = url

        # drm data object containing relevant license url ,scheme name and certificate
        # @var array of KalturaDrmPlaybackPluginData
        self.drm = drm


    PROPERTY_LOADERS = {
        'deliveryProfileId': getXmlNodeText, 
        'format': getXmlNodeText, 
        'protocols': getXmlNodeText, 
        'flavorIds': getXmlNodeText, 
        'url': getXmlNodeText, 
        'drm': (KalturaObjectFactory.createArray, 'KalturaDrmPlaybackPluginData'), 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaPlaybackSource.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaPlaybackSource")
        kparams.addStringIfDefined("deliveryProfileId", self.deliveryProfileId)
        kparams.addStringIfDefined("format", self.format)
        kparams.addStringIfDefined("protocols", self.protocols)
        kparams.addStringIfDefined("flavorIds", self.flavorIds)
        kparams.addStringIfDefined("url", self.url)
        kparams.addArrayIfDefined("drm", self.drm)
        return kparams

    def getDeliveryProfileId(self):
        return self.deliveryProfileId

    def setDeliveryProfileId(self, newDeliveryProfileId):
        self.deliveryProfileId = newDeliveryProfileId

    def getFormat(self):
        return self.format

    def setFormat(self, newFormat):
        self.format = newFormat

    def getProtocols(self):
        return self.protocols

    def setProtocols(self, newProtocols):
        self.protocols = newProtocols

    def getFlavorIds(self):
        return self.flavorIds

    def setFlavorIds(self, newFlavorIds):
        self.flavorIds = newFlavorIds

    def getUrl(self):
        return self.url

    def setUrl(self, newUrl):
        self.url = newUrl

    def getDrm(self):
        return self.drm

    def setDrm(self, newDrm):
        self.drm = newDrm


# @package Kaltura
# @subpackage Client
class KalturaPlaybackContext(KalturaObjectBase):
    def __init__(self,
            sources=NotImplemented,
            playbackCaptions=NotImplemented,
            flavorAssets=NotImplemented,
            actions=NotImplemented,
            messages=NotImplemented,
            bumperData=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var array of KalturaPlaybackSource
        self.sources = sources

        # @var array of KalturaCaptionPlaybackPluginData
        self.playbackCaptions = playbackCaptions

        # @var array of KalturaFlavorAsset
        self.flavorAssets = flavorAssets

        # Array of actions as received from the rules that invalidated
        # @var array of KalturaRuleAction
        self.actions = actions

        # Array of actions as received from the rules that invalidated
        # @var array of KalturaAccessControlMessage
        self.messages = messages

        # @var array of KalturaObject
        self.bumperData = bumperData


    PROPERTY_LOADERS = {
        'sources': (KalturaObjectFactory.createArray, 'KalturaPlaybackSource'), 
        'playbackCaptions': (KalturaObjectFactory.createArray, 'KalturaCaptionPlaybackPluginData'), 
        'flavorAssets': (KalturaObjectFactory.createArray, 'KalturaFlavorAsset'), 
        'actions': (KalturaObjectFactory.createArray, 'KalturaRuleAction'), 
        'messages': (KalturaObjectFactory.createArray, 'KalturaAccessControlMessage'), 
        'bumperData': (KalturaObjectFactory.createArray, 'KalturaObject'), 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaPlaybackContext.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaPlaybackContext")
        kparams.addArrayIfDefined("sources", self.sources)
        kparams.addArrayIfDefined("playbackCaptions", self.playbackCaptions)
        kparams.addArrayIfDefined("flavorAssets", self.flavorAssets)
        kparams.addArrayIfDefined("actions", self.actions)
        kparams.addArrayIfDefined("messages", self.messages)
        kparams.addArrayIfDefined("bumperData", self.bumperData)
        return kparams

    def getSources(self):
        return self.sources

    def setSources(self, newSources):
        self.sources = newSources

    def getPlaybackCaptions(self):
        return self.playbackCaptions

    def setPlaybackCaptions(self, newPlaybackCaptions):
        self.playbackCaptions = newPlaybackCaptions

    def getFlavorAssets(self):
        return self.flavorAssets

    def setFlavorAssets(self, newFlavorAssets):
        self.flavorAssets = newFlavorAssets

    def getActions(self):
        return self.actions

    def setActions(self, newActions):
        self.actions = newActions

    def getMessages(self):
        return self.messages

    def setMessages(self, newMessages):
        self.messages = newMessages

    def getBumperData(self):
        return self.bumperData

    def setBumperData(self, newBumperData):
        self.bumperData = newBumperData


# @package Kaltura
# @subpackage Client
class KalturaPlaylist(KalturaBaseEntry):
    def __init__(self,
            id=NotImplemented,
            name=NotImplemented,
            description=NotImplemented,
            partnerId=NotImplemented,
            userId=NotImplemented,
            creatorId=NotImplemented,
            tags=NotImplemented,
            adminTags=NotImplemented,
            categories=NotImplemented,
            categoriesIds=NotImplemented,
            status=NotImplemented,
            moderationStatus=NotImplemented,
            moderationCount=NotImplemented,
            type=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented,
            rank=NotImplemented,
            totalRank=NotImplemented,
            votes=NotImplemented,
            groupId=NotImplemented,
            partnerData=NotImplemented,
            downloadUrl=NotImplemented,
            searchText=NotImplemented,
            licenseType=NotImplemented,
            version=NotImplemented,
            thumbnailUrl=NotImplemented,
            accessControlId=NotImplemented,
            startDate=NotImplemented,
            endDate=NotImplemented,
            referenceId=NotImplemented,
            replacingEntryId=NotImplemented,
            replacedEntryId=NotImplemented,
            replacementStatus=NotImplemented,
            partnerSortValue=NotImplemented,
            conversionProfileId=NotImplemented,
            redirectEntryId=NotImplemented,
            rootEntryId=NotImplemented,
            parentEntryId=NotImplemented,
            operationAttributes=NotImplemented,
            entitledUsersEdit=NotImplemented,
            entitledUsersPublish=NotImplemented,
            entitledUsersView=NotImplemented,
            capabilities=NotImplemented,
            templateEntryId=NotImplemented,
            displayInSearch=NotImplemented,
            application=NotImplemented,
            applicationVersion=NotImplemented,
            blockAutoTranscript=NotImplemented,
            playlistContent=NotImplemented,
            filters=NotImplemented,
            totalResults=NotImplemented,
            playlistType=NotImplemented,
            plays=NotImplemented,
            views=NotImplemented,
            duration=NotImplemented,
            executeUrl=NotImplemented):
        KalturaBaseEntry.__init__(self,
            id,
            name,
            description,
            partnerId,
            userId,
            creatorId,
            tags,
            adminTags,
            categories,
            categoriesIds,
            status,
            moderationStatus,
            moderationCount,
            type,
            createdAt,
            updatedAt,
            rank,
            totalRank,
            votes,
            groupId,
            partnerData,
            downloadUrl,
            searchText,
            licenseType,
            version,
            thumbnailUrl,
            accessControlId,
            startDate,
            endDate,
            referenceId,
            replacingEntryId,
            replacedEntryId,
            replacementStatus,
            partnerSortValue,
            conversionProfileId,
            redirectEntryId,
            rootEntryId,
            parentEntryId,
            operationAttributes,
            entitledUsersEdit,
            entitledUsersPublish,
            entitledUsersView,
            capabilities,
            templateEntryId,
            displayInSearch,
            application,
            applicationVersion,
            blockAutoTranscript)

        # Content of the playlist - 
        # 	 XML if the playlistType is dynamic 
        # 	 text if the playlistType is static 
        # 	 url if the playlistType is mRss
        # @var string
        self.playlistContent = playlistContent

        # @var array of KalturaMediaEntryFilterForPlaylist
        self.filters = filters

        # Maximum count of results to be returned in playlist execution
        # @var int
        self.totalResults = totalResults

        # Type of playlist
        # @var KalturaPlaylistType
        # @insertonly
        self.playlistType = playlistType

        # Number of plays
        # @var int
        # @readonly
        self.plays = plays

        # Number of views
        # @var int
        # @readonly
        self.views = views

        # The duration in seconds
        # @var int
        # @readonly
        self.duration = duration

        # The url for this playlist
        # @var string
        # @readonly
        self.executeUrl = executeUrl


    PROPERTY_LOADERS = {
        'playlistContent': getXmlNodeText, 
        'filters': (KalturaObjectFactory.createArray, 'KalturaMediaEntryFilterForPlaylist'), 
        'totalResults': getXmlNodeInt, 
        'playlistType': (KalturaEnumsFactory.createInt, "KalturaPlaylistType"), 
        'plays': getXmlNodeInt, 
        'views': getXmlNodeInt, 
        'duration': getXmlNodeInt, 
        'executeUrl': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaBaseEntry.fromXml(self, node)
        self.fromXmlImpl(node, KalturaPlaylist.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaBaseEntry.toParams(self)
        kparams.put("objectType", "KalturaPlaylist")
        kparams.addStringIfDefined("playlistContent", self.playlistContent)
        kparams.addArrayIfDefined("filters", self.filters)
        kparams.addIntIfDefined("totalResults", self.totalResults)
        kparams.addIntEnumIfDefined("playlistType", self.playlistType)
        return kparams

    def getPlaylistContent(self):
        return self.playlistContent

    def setPlaylistContent(self, newPlaylistContent):
        self.playlistContent = newPlaylistContent

    def getFilters(self):
        return self.filters

    def setFilters(self, newFilters):
        self.filters = newFilters

    def getTotalResults(self):
        return self.totalResults

    def setTotalResults(self, newTotalResults):
        self.totalResults = newTotalResults

    def getPlaylistType(self):
        return self.playlistType

    def setPlaylistType(self, newPlaylistType):
        self.playlistType = newPlaylistType

    def getPlays(self):
        return self.plays

    def getViews(self):
        return self.views

    def getDuration(self):
        return self.duration

    def getExecuteUrl(self):
        return self.executeUrl


# @package Kaltura
# @subpackage Client
class KalturaRemotePath(KalturaObjectBase):
    def __init__(self,
            storageProfileId=NotImplemented,
            uri=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var int
        # @readonly
        self.storageProfileId = storageProfileId

        # @var string
        # @readonly
        self.uri = uri


    PROPERTY_LOADERS = {
        'storageProfileId': getXmlNodeInt, 
        'uri': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaRemotePath.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaRemotePath")
        return kparams

    def getStorageProfileId(self):
        return self.storageProfileId

    def getUri(self):
        return self.uri


# @package Kaltura
# @subpackage Client
class KalturaUrlResource(KalturaContentResource):
    """Used to ingest media that is available on remote server and accessible using the supplied URL, media file will be downloaded using import job in order to make the asset ready."""

    def __init__(self,
            url=NotImplemented,
            forceAsyncDownload=NotImplemented):
        KalturaContentResource.__init__(self)

        # Remote URL, FTP, HTTP or HTTPS
        # @var string
        self.url = url

        # Force Import Job
        # @var bool
        self.forceAsyncDownload = forceAsyncDownload


    PROPERTY_LOADERS = {
        'url': getXmlNodeText, 
        'forceAsyncDownload': getXmlNodeBool, 
    }

    def fromXml(self, node):
        KalturaContentResource.fromXml(self, node)
        self.fromXmlImpl(node, KalturaUrlResource.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaContentResource.toParams(self)
        kparams.put("objectType", "KalturaUrlResource")
        kparams.addStringIfDefined("url", self.url)
        kparams.addBoolIfDefined("forceAsyncDownload", self.forceAsyncDownload)
        return kparams

    def getUrl(self):
        return self.url

    def setUrl(self, newUrl):
        self.url = newUrl

    def getForceAsyncDownload(self):
        return self.forceAsyncDownload

    def setForceAsyncDownload(self, newForceAsyncDownload):
        self.forceAsyncDownload = newForceAsyncDownload


# @package Kaltura
# @subpackage Client
class KalturaRemoteStorageResource(KalturaUrlResource):
    """Used to ingest media that is available on remote server and accessible using the supplied URL, the media file won't be downloaded but a file sync object of URL type will point to the media URL."""

    def __init__(self,
            url=NotImplemented,
            forceAsyncDownload=NotImplemented,
            storageProfileId=NotImplemented):
        KalturaUrlResource.__init__(self,
            url,
            forceAsyncDownload)

        # ID of storage profile to be associated with the created file sync, used for file serving URL composing.
        # @var int
        self.storageProfileId = storageProfileId


    PROPERTY_LOADERS = {
        'storageProfileId': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaUrlResource.fromXml(self, node)
        self.fromXmlImpl(node, KalturaRemoteStorageResource.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaUrlResource.toParams(self)
        kparams.put("objectType", "KalturaRemoteStorageResource")
        kparams.addIntIfDefined("storageProfileId", self.storageProfileId)
        return kparams

    def getStorageProfileId(self):
        return self.storageProfileId

    def setStorageProfileId(self, newStorageProfileId):
        self.storageProfileId = newStorageProfileId


# @package Kaltura
# @subpackage Client
class KalturaReport(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            partnerId=NotImplemented,
            name=NotImplemented,
            systemName=NotImplemented,
            description=NotImplemented,
            query=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented):
        KalturaObjectBase.__init__(self)

        # Report id
        # @var int
        # @readonly
        self.id = id

        # Partner id associated with the report
        # @var int
        self.partnerId = partnerId

        # Report name
        # @var string
        self.name = name

        # Used to identify system reports in a friendly way
        # @var string
        self.systemName = systemName

        # Report description
        # @var string
        self.description = description

        # Report query
        # @var string
        self.query = query

        # Creation date as Unix timestamp (In seconds)
        # @var int
        # @readonly
        self.createdAt = createdAt

        # Last update date as Unix timestamp (In seconds)
        # @var int
        # @readonly
        self.updatedAt = updatedAt


    PROPERTY_LOADERS = {
        'id': getXmlNodeInt, 
        'partnerId': getXmlNodeInt, 
        'name': getXmlNodeText, 
        'systemName': getXmlNodeText, 
        'description': getXmlNodeText, 
        'query': getXmlNodeText, 
        'createdAt': getXmlNodeInt, 
        'updatedAt': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaReport.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaReport")
        kparams.addIntIfDefined("partnerId", self.partnerId)
        kparams.addStringIfDefined("name", self.name)
        kparams.addStringIfDefined("systemName", self.systemName)
        kparams.addStringIfDefined("description", self.description)
        kparams.addStringIfDefined("query", self.query)
        return kparams

    def getId(self):
        return self.id

    def getPartnerId(self):
        return self.partnerId

    def setPartnerId(self, newPartnerId):
        self.partnerId = newPartnerId

    def getName(self):
        return self.name

    def setName(self, newName):
        self.name = newName

    def getSystemName(self):
        return self.systemName

    def setSystemName(self, newSystemName):
        self.systemName = newSystemName

    def getDescription(self):
        return self.description

    def setDescription(self, newDescription):
        self.description = newDescription

    def getQuery(self):
        return self.query

    def setQuery(self, newQuery):
        self.query = newQuery

    def getCreatedAt(self):
        return self.createdAt

    def getUpdatedAt(self):
        return self.updatedAt


# @package Kaltura
# @subpackage Client
class KalturaReportBaseTotal(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            data=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.id = id

        # @var string
        self.data = data


    PROPERTY_LOADERS = {
        'id': getXmlNodeText, 
        'data': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaReportBaseTotal.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaReportBaseTotal")
        kparams.addStringIfDefined("id", self.id)
        kparams.addStringIfDefined("data", self.data)
        return kparams

    def getId(self):
        return self.id

    def setId(self, newId):
        self.id = newId

    def getData(self):
        return self.data

    def setData(self, newData):
        self.data = newData


# @package Kaltura
# @subpackage Client
class KalturaReportExportFile(KalturaObjectBase):
    def __init__(self,
            fileId=NotImplemented,
            fileName=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.fileId = fileId

        # @var string
        self.fileName = fileName


    PROPERTY_LOADERS = {
        'fileId': getXmlNodeText, 
        'fileName': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaReportExportFile.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaReportExportFile")
        kparams.addStringIfDefined("fileId", self.fileId)
        kparams.addStringIfDefined("fileName", self.fileName)
        return kparams

    def getFileId(self):
        return self.fileId

    def setFileId(self, newFileId):
        self.fileId = newFileId

    def getFileName(self):
        return self.fileName

    def setFileName(self, newFileName):
        self.fileName = newFileName


# @package Kaltura
# @subpackage Client
class KalturaReportInputBaseFilter(KalturaObjectBase):
    def __init__(self,
            fromDate=NotImplemented,
            toDate=NotImplemented,
            fromDay=NotImplemented,
            toDay=NotImplemented):
        KalturaObjectBase.__init__(self)

        # Start date as Unix timestamp (In seconds)
        # @var int
        self.fromDate = fromDate

        # End date as Unix timestamp (In seconds)
        # @var int
        self.toDate = toDate

        # Start day as string (YYYYMMDD)
        # @var string
        self.fromDay = fromDay

        # End date as string (YYYYMMDD)
        # @var string
        self.toDay = toDay


    PROPERTY_LOADERS = {
        'fromDate': getXmlNodeInt, 
        'toDate': getXmlNodeInt, 
        'fromDay': getXmlNodeText, 
        'toDay': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaReportInputBaseFilter.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaReportInputBaseFilter")
        kparams.addIntIfDefined("fromDate", self.fromDate)
        kparams.addIntIfDefined("toDate", self.toDate)
        kparams.addStringIfDefined("fromDay", self.fromDay)
        kparams.addStringIfDefined("toDay", self.toDay)
        return kparams

    def getFromDate(self):
        return self.fromDate

    def setFromDate(self, newFromDate):
        self.fromDate = newFromDate

    def getToDate(self):
        return self.toDate

    def setToDate(self, newToDate):
        self.toDate = newToDate

    def getFromDay(self):
        return self.fromDay

    def setFromDay(self, newFromDay):
        self.fromDay = newFromDay

    def getToDay(self):
        return self.toDay

    def setToDay(self, newToDay):
        self.toDay = newToDay


# @package Kaltura
# @subpackage Client
class KalturaReportInputFilter(KalturaReportInputBaseFilter):
    def __init__(self,
            fromDate=NotImplemented,
            toDate=NotImplemented,
            fromDay=NotImplemented,
            toDay=NotImplemented,
            keywords=NotImplemented,
            searchInTags=NotImplemented,
            searchInAdminTags=NotImplemented,
            categories=NotImplemented,
            categoriesIdsIn=NotImplemented,
            customVar1In=NotImplemented,
            customVar2In=NotImplemented,
            customVar3In=NotImplemented,
            deviceIn=NotImplemented,
            countryIn=NotImplemented,
            regionIn=NotImplemented,
            citiesIn=NotImplemented,
            operatingSystemFamilyIn=NotImplemented,
            operatingSystemIn=NotImplemented,
            browserFamilyIn=NotImplemented,
            browserIn=NotImplemented,
            timeZoneOffset=NotImplemented,
            interval=NotImplemented,
            mediaTypeIn=NotImplemented,
            sourceTypeIn=NotImplemented,
            ownerIdsIn=NotImplemented,
            entryOperator=NotImplemented,
            entryCreatedAtGreaterThanOrEqual=NotImplemented,
            entryCreatedAtLessThanOrEqual=NotImplemented,
            entryIdIn=NotImplemented,
            playbackTypeIn=NotImplemented,
            playbackContextIdsIn=NotImplemented,
            rootEntryIdIn=NotImplemented,
            errorCodeIn=NotImplemented,
            playerVersionIn=NotImplemented,
            ispIn=NotImplemented,
            applicationVersionIn=NotImplemented,
            nodeIdsIn=NotImplemented,
            categoriesAncestorIdIn=NotImplemented,
            hotspotIdIn=NotImplemented,
            crmIdIn=NotImplemented,
            playlistIdIn=NotImplemented,
            domainIn=NotImplemented,
            canonicalUrlIn=NotImplemented,
            virtualEventIdIn=NotImplemented,
            originIn=NotImplemented):
        KalturaReportInputBaseFilter.__init__(self,
            fromDate,
            toDate,
            fromDay,
            toDay)

        # Search keywords to filter objects
        # @var string
        self.keywords = keywords

        # Search keywords in objects tags
        # @var bool
        self.searchInTags = searchInTags

        # Search keywords in objects admin tags
        # @var bool
        self.searchInAdminTags = searchInAdminTags

        # Search objects in specified categories
        # @var string
        self.categories = categories

        # Search objects in specified category ids
        # @var string
        self.categoriesIdsIn = categoriesIdsIn

        # Filter by customVar1
        # @var string
        self.customVar1In = customVar1In

        # Filter by customVar2
        # @var string
        self.customVar2In = customVar2In

        # Filter by customVar3
        # @var string
        self.customVar3In = customVar3In

        # Filter by device
        # @var string
        self.deviceIn = deviceIn

        # Filter by country
        # @var string
        self.countryIn = countryIn

        # Filter by region
        # @var string
        self.regionIn = regionIn

        # Filter by city
        # @var string
        self.citiesIn = citiesIn

        # Filter by operating system family
        # @var string
        self.operatingSystemFamilyIn = operatingSystemFamilyIn

        # Filter by operating system
        # @var string
        self.operatingSystemIn = operatingSystemIn

        # Filter by browser family
        # @var string
        self.browserFamilyIn = browserFamilyIn

        # Filter by browser
        # @var string
        self.browserIn = browserIn

        # Time zone offset in minutes
        # @var int
        self.timeZoneOffset = timeZoneOffset

        # Aggregated results according to interval
        # @var KalturaReportInterval
        self.interval = interval

        # Filter by media types
        # @var string
        self.mediaTypeIn = mediaTypeIn

        # Filter by source types
        # @var string
        self.sourceTypeIn = sourceTypeIn

        # Filter by entry owner
        # @var string
        self.ownerIdsIn = ownerIdsIn

        # @var KalturaESearchEntryOperator
        self.entryOperator = entryOperator

        # Entry created at greater than or equal as Unix timestamp
        # @var int
        self.entryCreatedAtGreaterThanOrEqual = entryCreatedAtGreaterThanOrEqual

        # Entry created at less than or equal as Unix timestamp
        # @var int
        self.entryCreatedAtLessThanOrEqual = entryCreatedAtLessThanOrEqual

        # @var string
        self.entryIdIn = entryIdIn

        # @var string
        self.playbackTypeIn = playbackTypeIn

        # filter by playback context ids
        # @var string
        self.playbackContextIdsIn = playbackContextIdsIn

        # filter by root entry ids
        # @var string
        self.rootEntryIdIn = rootEntryIdIn

        # filter by error code
        # @var string
        self.errorCodeIn = errorCodeIn

        # filter by player version
        # @var string
        self.playerVersionIn = playerVersionIn

        # filter by isp
        # @var string
        self.ispIn = ispIn

        # filter by application version
        # @var string
        self.applicationVersionIn = applicationVersionIn

        # filter by node id
        # @var string
        self.nodeIdsIn = nodeIdsIn

        # filter by categories ancestor
        # @var string
        self.categoriesAncestorIdIn = categoriesAncestorIdIn

        # filter by hotspot id
        # @var string
        self.hotspotIdIn = hotspotIdIn

        # filter by crm id
        # @var string
        self.crmIdIn = crmIdIn

        # filter by playlist id
        # @var string
        self.playlistIdIn = playlistIdIn

        # filter by domain
        # @var string
        self.domainIn = domainIn

        # filter by canonical url
        # @var string
        self.canonicalUrlIn = canonicalUrlIn

        # filter by virtual event id
        # @var string
        self.virtualEventIdIn = virtualEventIdIn

        # filter by origin
        # @var string
        self.originIn = originIn


    PROPERTY_LOADERS = {
        'keywords': getXmlNodeText, 
        'searchInTags': getXmlNodeBool, 
        'searchInAdminTags': getXmlNodeBool, 
        'categories': getXmlNodeText, 
        'categoriesIdsIn': getXmlNodeText, 
        'customVar1In': getXmlNodeText, 
        'customVar2In': getXmlNodeText, 
        'customVar3In': getXmlNodeText, 
        'deviceIn': getXmlNodeText, 
        'countryIn': getXmlNodeText, 
        'regionIn': getXmlNodeText, 
        'citiesIn': getXmlNodeText, 
        'operatingSystemFamilyIn': getXmlNodeText, 
        'operatingSystemIn': getXmlNodeText, 
        'browserFamilyIn': getXmlNodeText, 
        'browserIn': getXmlNodeText, 
        'timeZoneOffset': getXmlNodeInt, 
        'interval': (KalturaEnumsFactory.createString, "KalturaReportInterval"), 
        'mediaTypeIn': getXmlNodeText, 
        'sourceTypeIn': getXmlNodeText, 
        'ownerIdsIn': getXmlNodeText, 
        'entryOperator': (KalturaObjectFactory.create, 'KalturaESearchEntryOperator'), 
        'entryCreatedAtGreaterThanOrEqual': getXmlNodeInt, 
        'entryCreatedAtLessThanOrEqual': getXmlNodeInt, 
        'entryIdIn': getXmlNodeText, 
        'playbackTypeIn': getXmlNodeText, 
        'playbackContextIdsIn': getXmlNodeText, 
        'rootEntryIdIn': getXmlNodeText, 
        'errorCodeIn': getXmlNodeText, 
        'playerVersionIn': getXmlNodeText, 
        'ispIn': getXmlNodeText, 
        'applicationVersionIn': getXmlNodeText, 
        'nodeIdsIn': getXmlNodeText, 
        'categoriesAncestorIdIn': getXmlNodeText, 
        'hotspotIdIn': getXmlNodeText, 
        'crmIdIn': getXmlNodeText, 
        'playlistIdIn': getXmlNodeText, 
        'domainIn': getXmlNodeText, 
        'canonicalUrlIn': getXmlNodeText, 
        'virtualEventIdIn': getXmlNodeText, 
        'originIn': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaReportInputBaseFilter.fromXml(self, node)
        self.fromXmlImpl(node, KalturaReportInputFilter.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaReportInputBaseFilter.toParams(self)
        kparams.put("objectType", "KalturaReportInputFilter")
        kparams.addStringIfDefined("keywords", self.keywords)
        kparams.addBoolIfDefined("searchInTags", self.searchInTags)
        kparams.addBoolIfDefined("searchInAdminTags", self.searchInAdminTags)
        kparams.addStringIfDefined("categories", self.categories)
        kparams.addStringIfDefined("categoriesIdsIn", self.categoriesIdsIn)
        kparams.addStringIfDefined("customVar1In", self.customVar1In)
        kparams.addStringIfDefined("customVar2In", self.customVar2In)
        kparams.addStringIfDefined("customVar3In", self.customVar3In)
        kparams.addStringIfDefined("deviceIn", self.deviceIn)
        kparams.addStringIfDefined("countryIn", self.countryIn)
        kparams.addStringIfDefined("regionIn", self.regionIn)
        kparams.addStringIfDefined("citiesIn", self.citiesIn)
        kparams.addStringIfDefined("operatingSystemFamilyIn", self.operatingSystemFamilyIn)
        kparams.addStringIfDefined("operatingSystemIn", self.operatingSystemIn)
        kparams.addStringIfDefined("browserFamilyIn", self.browserFamilyIn)
        kparams.addStringIfDefined("browserIn", self.browserIn)
        kparams.addIntIfDefined("timeZoneOffset", self.timeZoneOffset)
        kparams.addStringEnumIfDefined("interval", self.interval)
        kparams.addStringIfDefined("mediaTypeIn", self.mediaTypeIn)
        kparams.addStringIfDefined("sourceTypeIn", self.sourceTypeIn)
        kparams.addStringIfDefined("ownerIdsIn", self.ownerIdsIn)
        kparams.addObjectIfDefined("entryOperator", self.entryOperator)
        kparams.addIntIfDefined("entryCreatedAtGreaterThanOrEqual", self.entryCreatedAtGreaterThanOrEqual)
        kparams.addIntIfDefined("entryCreatedAtLessThanOrEqual", self.entryCreatedAtLessThanOrEqual)
        kparams.addStringIfDefined("entryIdIn", self.entryIdIn)
        kparams.addStringIfDefined("playbackTypeIn", self.playbackTypeIn)
        kparams.addStringIfDefined("playbackContextIdsIn", self.playbackContextIdsIn)
        kparams.addStringIfDefined("rootEntryIdIn", self.rootEntryIdIn)
        kparams.addStringIfDefined("errorCodeIn", self.errorCodeIn)
        kparams.addStringIfDefined("playerVersionIn", self.playerVersionIn)
        kparams.addStringIfDefined("ispIn", self.ispIn)
        kparams.addStringIfDefined("applicationVersionIn", self.applicationVersionIn)
        kparams.addStringIfDefined("nodeIdsIn", self.nodeIdsIn)
        kparams.addStringIfDefined("categoriesAncestorIdIn", self.categoriesAncestorIdIn)
        kparams.addStringIfDefined("hotspotIdIn", self.hotspotIdIn)
        kparams.addStringIfDefined("crmIdIn", self.crmIdIn)
        kparams.addStringIfDefined("playlistIdIn", self.playlistIdIn)
        kparams.addStringIfDefined("domainIn", self.domainIn)
        kparams.addStringIfDefined("canonicalUrlIn", self.canonicalUrlIn)
        kparams.addStringIfDefined("virtualEventIdIn", self.virtualEventIdIn)
        kparams.addStringIfDefined("originIn", self.originIn)
        return kparams

    def getKeywords(self):
        return self.keywords

    def setKeywords(self, newKeywords):
        self.keywords = newKeywords

    def getSearchInTags(self):
        return self.searchInTags

    def setSearchInTags(self, newSearchInTags):
        self.searchInTags = newSearchInTags

    def getSearchInAdminTags(self):
        return self.searchInAdminTags

    def setSearchInAdminTags(self, newSearchInAdminTags):
        self.searchInAdminTags = newSearchInAdminTags

    def getCategories(self):
        return self.categories

    def setCategories(self, newCategories):
        self.categories = newCategories

    def getCategoriesIdsIn(self):
        return self.categoriesIdsIn

    def setCategoriesIdsIn(self, newCategoriesIdsIn):
        self.categoriesIdsIn = newCategoriesIdsIn

    def getCustomVar1In(self):
        return self.customVar1In

    def setCustomVar1In(self, newCustomVar1In):
        self.customVar1In = newCustomVar1In

    def getCustomVar2In(self):
        return self.customVar2In

    def setCustomVar2In(self, newCustomVar2In):
        self.customVar2In = newCustomVar2In

    def getCustomVar3In(self):
        return self.customVar3In

    def setCustomVar3In(self, newCustomVar3In):
        self.customVar3In = newCustomVar3In

    def getDeviceIn(self):
        return self.deviceIn

    def setDeviceIn(self, newDeviceIn):
        self.deviceIn = newDeviceIn

    def getCountryIn(self):
        return self.countryIn

    def setCountryIn(self, newCountryIn):
        self.countryIn = newCountryIn

    def getRegionIn(self):
        return self.regionIn

    def setRegionIn(self, newRegionIn):
        self.regionIn = newRegionIn

    def getCitiesIn(self):
        return self.citiesIn

    def setCitiesIn(self, newCitiesIn):
        self.citiesIn = newCitiesIn

    def getOperatingSystemFamilyIn(self):
        return self.operatingSystemFamilyIn

    def setOperatingSystemFamilyIn(self, newOperatingSystemFamilyIn):
        self.operatingSystemFamilyIn = newOperatingSystemFamilyIn

    def getOperatingSystemIn(self):
        return self.operatingSystemIn

    def setOperatingSystemIn(self, newOperatingSystemIn):
        self.operatingSystemIn = newOperatingSystemIn

    def getBrowserFamilyIn(self):
        return self.browserFamilyIn

    def setBrowserFamilyIn(self, newBrowserFamilyIn):
        self.browserFamilyIn = newBrowserFamilyIn

    def getBrowserIn(self):
        return self.browserIn

    def setBrowserIn(self, newBrowserIn):
        self.browserIn = newBrowserIn

    def getTimeZoneOffset(self):
        return self.timeZoneOffset

    def setTimeZoneOffset(self, newTimeZoneOffset):
        self.timeZoneOffset = newTimeZoneOffset

    def getInterval(self):
        return self.interval

    def setInterval(self, newInterval):
        self.interval = newInterval

    def getMediaTypeIn(self):
        return self.mediaTypeIn

    def setMediaTypeIn(self, newMediaTypeIn):
        self.mediaTypeIn = newMediaTypeIn

    def getSourceTypeIn(self):
        return self.sourceTypeIn

    def setSourceTypeIn(self, newSourceTypeIn):
        self.sourceTypeIn = newSourceTypeIn

    def getOwnerIdsIn(self):
        return self.ownerIdsIn

    def setOwnerIdsIn(self, newOwnerIdsIn):
        self.ownerIdsIn = newOwnerIdsIn

    def getEntryOperator(self):
        return self.entryOperator

    def setEntryOperator(self, newEntryOperator):
        self.entryOperator = newEntryOperator

    def getEntryCreatedAtGreaterThanOrEqual(self):
        return self.entryCreatedAtGreaterThanOrEqual

    def setEntryCreatedAtGreaterThanOrEqual(self, newEntryCreatedAtGreaterThanOrEqual):
        self.entryCreatedAtGreaterThanOrEqual = newEntryCreatedAtGreaterThanOrEqual

    def getEntryCreatedAtLessThanOrEqual(self):
        return self.entryCreatedAtLessThanOrEqual

    def setEntryCreatedAtLessThanOrEqual(self, newEntryCreatedAtLessThanOrEqual):
        self.entryCreatedAtLessThanOrEqual = newEntryCreatedAtLessThanOrEqual

    def getEntryIdIn(self):
        return self.entryIdIn

    def setEntryIdIn(self, newEntryIdIn):
        self.entryIdIn = newEntryIdIn

    def getPlaybackTypeIn(self):
        return self.playbackTypeIn

    def setPlaybackTypeIn(self, newPlaybackTypeIn):
        self.playbackTypeIn = newPlaybackTypeIn

    def getPlaybackContextIdsIn(self):
        return self.playbackContextIdsIn

    def setPlaybackContextIdsIn(self, newPlaybackContextIdsIn):
        self.playbackContextIdsIn = newPlaybackContextIdsIn

    def getRootEntryIdIn(self):
        return self.rootEntryIdIn

    def setRootEntryIdIn(self, newRootEntryIdIn):
        self.rootEntryIdIn = newRootEntryIdIn

    def getErrorCodeIn(self):
        return self.errorCodeIn

    def setErrorCodeIn(self, newErrorCodeIn):
        self.errorCodeIn = newErrorCodeIn

    def getPlayerVersionIn(self):
        return self.playerVersionIn

    def setPlayerVersionIn(self, newPlayerVersionIn):
        self.playerVersionIn = newPlayerVersionIn

    def getIspIn(self):
        return self.ispIn

    def setIspIn(self, newIspIn):
        self.ispIn = newIspIn

    def getApplicationVersionIn(self):
        return self.applicationVersionIn

    def setApplicationVersionIn(self, newApplicationVersionIn):
        self.applicationVersionIn = newApplicationVersionIn

    def getNodeIdsIn(self):
        return self.nodeIdsIn

    def setNodeIdsIn(self, newNodeIdsIn):
        self.nodeIdsIn = newNodeIdsIn

    def getCategoriesAncestorIdIn(self):
        return self.categoriesAncestorIdIn

    def setCategoriesAncestorIdIn(self, newCategoriesAncestorIdIn):
        self.categoriesAncestorIdIn = newCategoriesAncestorIdIn

    def getHotspotIdIn(self):
        return self.hotspotIdIn

    def setHotspotIdIn(self, newHotspotIdIn):
        self.hotspotIdIn = newHotspotIdIn

    def getCrmIdIn(self):
        return self.crmIdIn

    def setCrmIdIn(self, newCrmIdIn):
        self.crmIdIn = newCrmIdIn

    def getPlaylistIdIn(self):
        return self.playlistIdIn

    def setPlaylistIdIn(self, newPlaylistIdIn):
        self.playlistIdIn = newPlaylistIdIn

    def getDomainIn(self):
        return self.domainIn

    def setDomainIn(self, newDomainIn):
        self.domainIn = newDomainIn

    def getCanonicalUrlIn(self):
        return self.canonicalUrlIn

    def setCanonicalUrlIn(self, newCanonicalUrlIn):
        self.canonicalUrlIn = newCanonicalUrlIn

    def getVirtualEventIdIn(self):
        return self.virtualEventIdIn

    def setVirtualEventIdIn(self, newVirtualEventIdIn):
        self.virtualEventIdIn = newVirtualEventIdIn

    def getOriginIn(self):
        return self.originIn

    def setOriginIn(self, newOriginIn):
        self.originIn = newOriginIn


# @package Kaltura
# @subpackage Client
class KalturaReportResponseOptions(KalturaObjectBase):
    def __init__(self,
            delimiter=NotImplemented,
            skipEmptyDates=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.delimiter = delimiter

        # @var bool
        self.skipEmptyDates = skipEmptyDates


    PROPERTY_LOADERS = {
        'delimiter': getXmlNodeText, 
        'skipEmptyDates': getXmlNodeBool, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaReportResponseOptions.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaReportResponseOptions")
        kparams.addStringIfDefined("delimiter", self.delimiter)
        kparams.addBoolIfDefined("skipEmptyDates", self.skipEmptyDates)
        return kparams

    def getDelimiter(self):
        return self.delimiter

    def setDelimiter(self, newDelimiter):
        self.delimiter = newDelimiter

    def getSkipEmptyDates(self):
        return self.skipEmptyDates

    def setSkipEmptyDates(self, newSkipEmptyDates):
        self.skipEmptyDates = newSkipEmptyDates


# @package Kaltura
# @subpackage Client
class KalturaReportExportItem(KalturaObjectBase):
    def __init__(self,
            reportTitle=NotImplemented,
            action=NotImplemented,
            reportType=NotImplemented,
            filter=NotImplemented,
            order=NotImplemented,
            objectIds=NotImplemented,
            responseOptions=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.reportTitle = reportTitle

        # @var KalturaReportExportItemType
        self.action = action

        # @var KalturaReportType
        self.reportType = reportType

        # @var KalturaReportInputFilter
        self.filter = filter

        # @var string
        self.order = order

        # @var string
        self.objectIds = objectIds

        # @var KalturaReportResponseOptions
        self.responseOptions = responseOptions


    PROPERTY_LOADERS = {
        'reportTitle': getXmlNodeText, 
        'action': (KalturaEnumsFactory.createInt, "KalturaReportExportItemType"), 
        'reportType': (KalturaEnumsFactory.createString, "KalturaReportType"), 
        'filter': (KalturaObjectFactory.create, 'KalturaReportInputFilter'), 
        'order': getXmlNodeText, 
        'objectIds': getXmlNodeText, 
        'responseOptions': (KalturaObjectFactory.create, 'KalturaReportResponseOptions'), 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaReportExportItem.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaReportExportItem")
        kparams.addStringIfDefined("reportTitle", self.reportTitle)
        kparams.addIntEnumIfDefined("action", self.action)
        kparams.addStringEnumIfDefined("reportType", self.reportType)
        kparams.addObjectIfDefined("filter", self.filter)
        kparams.addStringIfDefined("order", self.order)
        kparams.addStringIfDefined("objectIds", self.objectIds)
        kparams.addObjectIfDefined("responseOptions", self.responseOptions)
        return kparams

    def getReportTitle(self):
        return self.reportTitle

    def setReportTitle(self, newReportTitle):
        self.reportTitle = newReportTitle

    def getAction(self):
        return self.action

    def setAction(self, newAction):
        self.action = newAction

    def getReportType(self):
        return self.reportType

    def setReportType(self, newReportType):
        self.reportType = newReportType

    def getFilter(self):
        return self.filter

    def setFilter(self, newFilter):
        self.filter = newFilter

    def getOrder(self):
        return self.order

    def setOrder(self, newOrder):
        self.order = newOrder

    def getObjectIds(self):
        return self.objectIds

    def setObjectIds(self, newObjectIds):
        self.objectIds = newObjectIds

    def getResponseOptions(self):
        return self.responseOptions

    def setResponseOptions(self, newResponseOptions):
        self.responseOptions = newResponseOptions


# @package Kaltura
# @subpackage Client
class KalturaReportExportParams(KalturaObjectBase):
    def __init__(self,
            recipientEmail=NotImplemented,
            timeZoneOffset=NotImplemented,
            reportItems=NotImplemented,
            reportsItemsGroup=NotImplemented,
            baseUrl=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.recipientEmail = recipientEmail

        # Time zone offset in minutes (between client to UTC)
        # @var int
        self.timeZoneOffset = timeZoneOffset

        # @var array of KalturaReportExportItem
        self.reportItems = reportItems

        # @var string
        self.reportsItemsGroup = reportsItemsGroup

        # @var string
        self.baseUrl = baseUrl


    PROPERTY_LOADERS = {
        'recipientEmail': getXmlNodeText, 
        'timeZoneOffset': getXmlNodeInt, 
        'reportItems': (KalturaObjectFactory.createArray, 'KalturaReportExportItem'), 
        'reportsItemsGroup': getXmlNodeText, 
        'baseUrl': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaReportExportParams.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaReportExportParams")
        kparams.addStringIfDefined("recipientEmail", self.recipientEmail)
        kparams.addIntIfDefined("timeZoneOffset", self.timeZoneOffset)
        kparams.addArrayIfDefined("reportItems", self.reportItems)
        kparams.addStringIfDefined("reportsItemsGroup", self.reportsItemsGroup)
        kparams.addStringIfDefined("baseUrl", self.baseUrl)
        return kparams

    def getRecipientEmail(self):
        return self.recipientEmail

    def setRecipientEmail(self, newRecipientEmail):
        self.recipientEmail = newRecipientEmail

    def getTimeZoneOffset(self):
        return self.timeZoneOffset

    def setTimeZoneOffset(self, newTimeZoneOffset):
        self.timeZoneOffset = newTimeZoneOffset

    def getReportItems(self):
        return self.reportItems

    def setReportItems(self, newReportItems):
        self.reportItems = newReportItems

    def getReportsItemsGroup(self):
        return self.reportsItemsGroup

    def setReportsItemsGroup(self, newReportsItemsGroup):
        self.reportsItemsGroup = newReportsItemsGroup

    def getBaseUrl(self):
        return self.baseUrl

    def setBaseUrl(self, newBaseUrl):
        self.baseUrl = newBaseUrl


# @package Kaltura
# @subpackage Client
class KalturaReportExportResponse(KalturaObjectBase):
    def __init__(self,
            referenceJobId=NotImplemented,
            reportEmail=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var int
        self.referenceJobId = referenceJobId

        # @var string
        self.reportEmail = reportEmail


    PROPERTY_LOADERS = {
        'referenceJobId': getXmlNodeInt, 
        'reportEmail': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaReportExportResponse.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaReportExportResponse")
        kparams.addIntIfDefined("referenceJobId", self.referenceJobId)
        kparams.addStringIfDefined("reportEmail", self.reportEmail)
        return kparams

    def getReferenceJobId(self):
        return self.referenceJobId

    def setReferenceJobId(self, newReferenceJobId):
        self.referenceJobId = newReferenceJobId

    def getReportEmail(self):
        return self.reportEmail

    def setReportEmail(self, newReportEmail):
        self.reportEmail = newReportEmail


# @package Kaltura
# @subpackage Client
class KalturaReportGraph(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            data=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.id = id

        # @var string
        self.data = data


    PROPERTY_LOADERS = {
        'id': getXmlNodeText, 
        'data': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaReportGraph.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaReportGraph")
        kparams.addStringIfDefined("id", self.id)
        kparams.addStringIfDefined("data", self.data)
        return kparams

    def getId(self):
        return self.id

    def setId(self, newId):
        self.id = newId

    def getData(self):
        return self.data

    def setData(self, newData):
        self.data = newData


# @package Kaltura
# @subpackage Client
class KalturaReportResponse(KalturaObjectBase):
    def __init__(self,
            columns=NotImplemented,
            results=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.columns = columns

        # @var array of KalturaString
        self.results = results


    PROPERTY_LOADERS = {
        'columns': getXmlNodeText, 
        'results': (KalturaObjectFactory.createArray, 'KalturaString'), 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaReportResponse.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaReportResponse")
        kparams.addStringIfDefined("columns", self.columns)
        kparams.addArrayIfDefined("results", self.results)
        return kparams

    def getColumns(self):
        return self.columns

    def setColumns(self, newColumns):
        self.columns = newColumns

    def getResults(self):
        return self.results

    def setResults(self, newResults):
        self.results = newResults


# @package Kaltura
# @subpackage Client
class KalturaReportTable(KalturaObjectBase):
    def __init__(self,
            header=NotImplemented,
            data=NotImplemented,
            totalCount=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        # @readonly
        self.header = header

        # @var string
        # @readonly
        self.data = data

        # @var int
        # @readonly
        self.totalCount = totalCount


    PROPERTY_LOADERS = {
        'header': getXmlNodeText, 
        'data': getXmlNodeText, 
        'totalCount': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaReportTable.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaReportTable")
        return kparams

    def getHeader(self):
        return self.header

    def getData(self):
        return self.data

    def getTotalCount(self):
        return self.totalCount


# @package Kaltura
# @subpackage Client
class KalturaReportTotal(KalturaObjectBase):
    def __init__(self,
            header=NotImplemented,
            data=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.header = header

        # @var string
        self.data = data


    PROPERTY_LOADERS = {
        'header': getXmlNodeText, 
        'data': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaReportTotal.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaReportTotal")
        kparams.addStringIfDefined("header", self.header)
        kparams.addStringIfDefined("data", self.data)
        return kparams

    def getHeader(self):
        return self.header

    def setHeader(self, newHeader):
        self.header = newHeader

    def getData(self):
        return self.data

    def setData(self, newData):
        self.data = newData


# @package Kaltura
# @subpackage Client
class KalturaRequestConfiguration(KalturaObjectBase):
    """Define client request optional configurations
     /"""

    def __init__(self,
            partnerId=NotImplemented,
            ks=NotImplemented,
            responseProfile=NotImplemented):
        KalturaObjectBase.__init__(self)

        # Impersonated partner id
        # @var int
        self.partnerId = partnerId

        # Kaltura API session
        # @var string
        self.ks = ks

        # Response profile - this attribute will be automatically unset after every API call.
        # @var KalturaBaseResponseProfile
        self.responseProfile = responseProfile


    PROPERTY_LOADERS = {
        'partnerId': getXmlNodeInt, 
        'ks': getXmlNodeText, 
        'responseProfile': (KalturaObjectFactory.create, 'KalturaBaseResponseProfile'), 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaRequestConfiguration.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaRequestConfiguration")
        kparams.addIntIfDefined("partnerId", self.partnerId)
        kparams.addStringIfDefined("ks", self.ks)
        kparams.addObjectIfDefined("responseProfile", self.responseProfile)
        return kparams

    def getPartnerId(self):
        return self.partnerId

    def setPartnerId(self, newPartnerId):
        self.partnerId = newPartnerId

    def getKs(self):
        return self.ks

    def setKs(self, newKs):
        self.ks = newKs

    def getResponseProfile(self):
        return self.responseProfile

    def setResponseProfile(self, newResponseProfile):
        self.responseProfile = newResponseProfile


# @package Kaltura
# @subpackage Client
class KalturaResponseProfile(KalturaDetachedResponseProfile):
    def __init__(self,
            name=NotImplemented,
            type=NotImplemented,
            fields=NotImplemented,
            filter=NotImplemented,
            pager=NotImplemented,
            relatedProfiles=NotImplemented,
            mappings=NotImplemented,
            id=NotImplemented,
            systemName=NotImplemented,
            partnerId=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented,
            status=NotImplemented,
            version=NotImplemented):
        KalturaDetachedResponseProfile.__init__(self,
            name,
            type,
            fields,
            filter,
            pager,
            relatedProfiles,
            mappings)

        # Auto generated numeric identifier
        # @var int
        # @readonly
        self.id = id

        # Unique system name
        # @var string
        self.systemName = systemName

        # @var int
        # @readonly
        self.partnerId = partnerId

        # Creation time as Unix timestamp (In seconds)
        # @var int
        # @readonly
        self.createdAt = createdAt

        # Update time as Unix timestamp (In seconds)
        # @var int
        # @readonly
        self.updatedAt = updatedAt

        # @var KalturaResponseProfileStatus
        # @readonly
        self.status = status

        # @var int
        # @readonly
        self.version = version


    PROPERTY_LOADERS = {
        'id': getXmlNodeInt, 
        'systemName': getXmlNodeText, 
        'partnerId': getXmlNodeInt, 
        'createdAt': getXmlNodeInt, 
        'updatedAt': getXmlNodeInt, 
        'status': (KalturaEnumsFactory.createInt, "KalturaResponseProfileStatus"), 
        'version': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaDetachedResponseProfile.fromXml(self, node)
        self.fromXmlImpl(node, KalturaResponseProfile.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaDetachedResponseProfile.toParams(self)
        kparams.put("objectType", "KalturaResponseProfile")
        kparams.addStringIfDefined("systemName", self.systemName)
        return kparams

    def getId(self):
        return self.id

    def getSystemName(self):
        return self.systemName

    def setSystemName(self, newSystemName):
        self.systemName = newSystemName

    def getPartnerId(self):
        return self.partnerId

    def getCreatedAt(self):
        return self.createdAt

    def getUpdatedAt(self):
        return self.updatedAt

    def getStatus(self):
        return self.status

    def getVersion(self):
        return self.version


# @package Kaltura
# @subpackage Client
class KalturaResponseProfileCacheRecalculateOptions(KalturaObjectBase):
    def __init__(self,
            limit=NotImplemented,
            cachedObjectType=NotImplemented,
            objectId=NotImplemented,
            startObjectKey=NotImplemented,
            endObjectKey=NotImplemented,
            jobCreatedAt=NotImplemented,
            isFirstLoop=NotImplemented):
        KalturaObjectBase.__init__(self)

        # Maximum number of keys to recalculate
        # @var int
        self.limit = limit

        # Class name
        # @var string
        self.cachedObjectType = cachedObjectType

        # @var string
        self.objectId = objectId

        # @var string
        self.startObjectKey = startObjectKey

        # @var string
        self.endObjectKey = endObjectKey

        # @var int
        self.jobCreatedAt = jobCreatedAt

        # @var bool
        self.isFirstLoop = isFirstLoop


    PROPERTY_LOADERS = {
        'limit': getXmlNodeInt, 
        'cachedObjectType': getXmlNodeText, 
        'objectId': getXmlNodeText, 
        'startObjectKey': getXmlNodeText, 
        'endObjectKey': getXmlNodeText, 
        'jobCreatedAt': getXmlNodeInt, 
        'isFirstLoop': getXmlNodeBool, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaResponseProfileCacheRecalculateOptions.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaResponseProfileCacheRecalculateOptions")
        kparams.addIntIfDefined("limit", self.limit)
        kparams.addStringIfDefined("cachedObjectType", self.cachedObjectType)
        kparams.addStringIfDefined("objectId", self.objectId)
        kparams.addStringIfDefined("startObjectKey", self.startObjectKey)
        kparams.addStringIfDefined("endObjectKey", self.endObjectKey)
        kparams.addIntIfDefined("jobCreatedAt", self.jobCreatedAt)
        kparams.addBoolIfDefined("isFirstLoop", self.isFirstLoop)
        return kparams

    def getLimit(self):
        return self.limit

    def setLimit(self, newLimit):
        self.limit = newLimit

    def getCachedObjectType(self):
        return self.cachedObjectType

    def setCachedObjectType(self, newCachedObjectType):
        self.cachedObjectType = newCachedObjectType

    def getObjectId(self):
        return self.objectId

    def setObjectId(self, newObjectId):
        self.objectId = newObjectId

    def getStartObjectKey(self):
        return self.startObjectKey

    def setStartObjectKey(self, newStartObjectKey):
        self.startObjectKey = newStartObjectKey

    def getEndObjectKey(self):
        return self.endObjectKey

    def setEndObjectKey(self, newEndObjectKey):
        self.endObjectKey = newEndObjectKey

    def getJobCreatedAt(self):
        return self.jobCreatedAt

    def setJobCreatedAt(self, newJobCreatedAt):
        self.jobCreatedAt = newJobCreatedAt

    def getIsFirstLoop(self):
        return self.isFirstLoop

    def setIsFirstLoop(self, newIsFirstLoop):
        self.isFirstLoop = newIsFirstLoop


# @package Kaltura
# @subpackage Client
class KalturaResponseProfileCacheRecalculateResults(KalturaObjectBase):
    def __init__(self,
            lastObjectKey=NotImplemented,
            recalculated=NotImplemented):
        KalturaObjectBase.__init__(self)

        # Last recalculated id
        # @var string
        self.lastObjectKey = lastObjectKey

        # Number of recalculated keys
        # @var int
        self.recalculated = recalculated


    PROPERTY_LOADERS = {
        'lastObjectKey': getXmlNodeText, 
        'recalculated': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaResponseProfileCacheRecalculateResults.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaResponseProfileCacheRecalculateResults")
        kparams.addStringIfDefined("lastObjectKey", self.lastObjectKey)
        kparams.addIntIfDefined("recalculated", self.recalculated)
        return kparams

    def getLastObjectKey(self):
        return self.lastObjectKey

    def setLastObjectKey(self, newLastObjectKey):
        self.lastObjectKey = newLastObjectKey

    def getRecalculated(self):
        return self.recalculated

    def setRecalculated(self, newRecalculated):
        self.recalculated = newRecalculated


# @package Kaltura
# @subpackage Client
class KalturaScope(KalturaObjectBase):
    def __init__(self):
        KalturaObjectBase.__init__(self)


    PROPERTY_LOADERS = {
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaScope.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaScope")
        return kparams


# @package Kaltura
# @subpackage Client
class KalturaSearch(KalturaObjectBase):
    def __init__(self,
            keyWords=NotImplemented,
            searchSource=NotImplemented,
            mediaType=NotImplemented,
            extraData=NotImplemented,
            authData=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.keyWords = keyWords

        # @var KalturaSearchProviderType
        self.searchSource = searchSource

        # @var KalturaMediaType
        self.mediaType = mediaType

        # Use this field to pass dynamic data for searching
        # 	 For example - if you set this field to "mymovies_$partner_id"
        # 	 The $partner_id will be automatically replcaed with your real partner Id
        # @var string
        self.extraData = extraData

        # @var string
        self.authData = authData


    PROPERTY_LOADERS = {
        'keyWords': getXmlNodeText, 
        'searchSource': (KalturaEnumsFactory.createInt, "KalturaSearchProviderType"), 
        'mediaType': (KalturaEnumsFactory.createInt, "KalturaMediaType"), 
        'extraData': getXmlNodeText, 
        'authData': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaSearch.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaSearch")
        kparams.addStringIfDefined("keyWords", self.keyWords)
        kparams.addIntEnumIfDefined("searchSource", self.searchSource)
        kparams.addIntEnumIfDefined("mediaType", self.mediaType)
        kparams.addStringIfDefined("extraData", self.extraData)
        kparams.addStringIfDefined("authData", self.authData)
        return kparams

    def getKeyWords(self):
        return self.keyWords

    def setKeyWords(self, newKeyWords):
        self.keyWords = newKeyWords

    def getSearchSource(self):
        return self.searchSource

    def setSearchSource(self, newSearchSource):
        self.searchSource = newSearchSource

    def getMediaType(self):
        return self.mediaType

    def setMediaType(self, newMediaType):
        self.mediaType = newMediaType

    def getExtraData(self):
        return self.extraData

    def setExtraData(self, newExtraData):
        self.extraData = newExtraData

    def getAuthData(self):
        return self.authData

    def setAuthData(self, newAuthData):
        self.authData = newAuthData


# @package Kaltura
# @subpackage Client
class KalturaSearchAuthData(KalturaObjectBase):
    def __init__(self,
            authData=NotImplemented,
            loginUrl=NotImplemented,
            message=NotImplemented):
        KalturaObjectBase.__init__(self)

        # The authentication data that further should be used for search
        # @var string
        self.authData = authData

        # Login URL when user need to sign-in and authorize the search
        # @var string
        self.loginUrl = loginUrl

        # Information when there was an error
        # @var string
        self.message = message


    PROPERTY_LOADERS = {
        'authData': getXmlNodeText, 
        'loginUrl': getXmlNodeText, 
        'message': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaSearchAuthData.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaSearchAuthData")
        kparams.addStringIfDefined("authData", self.authData)
        kparams.addStringIfDefined("loginUrl", self.loginUrl)
        kparams.addStringIfDefined("message", self.message)
        return kparams

    def getAuthData(self):
        return self.authData

    def setAuthData(self, newAuthData):
        self.authData = newAuthData

    def getLoginUrl(self):
        return self.loginUrl

    def setLoginUrl(self, newLoginUrl):
        self.loginUrl = newLoginUrl

    def getMessage(self):
        return self.message

    def setMessage(self, newMessage):
        self.message = newMessage


# @package Kaltura
# @subpackage Client
class KalturaSearchResult(KalturaSearch):
    def __init__(self,
            keyWords=NotImplemented,
            searchSource=NotImplemented,
            mediaType=NotImplemented,
            extraData=NotImplemented,
            authData=NotImplemented,
            id=NotImplemented,
            title=NotImplemented,
            thumbUrl=NotImplemented,
            description=NotImplemented,
            tags=NotImplemented,
            url=NotImplemented,
            sourceLink=NotImplemented,
            credit=NotImplemented,
            licenseType=NotImplemented,
            flashPlaybackType=NotImplemented,
            fileExt=NotImplemented):
        KalturaSearch.__init__(self,
            keyWords,
            searchSource,
            mediaType,
            extraData,
            authData)

        # @var string
        self.id = id

        # @var string
        self.title = title

        # @var string
        self.thumbUrl = thumbUrl

        # @var string
        self.description = description

        # @var string
        self.tags = tags

        # @var string
        self.url = url

        # @var string
        self.sourceLink = sourceLink

        # @var string
        self.credit = credit

        # @var KalturaLicenseType
        self.licenseType = licenseType

        # @var string
        self.flashPlaybackType = flashPlaybackType

        # @var string
        self.fileExt = fileExt


    PROPERTY_LOADERS = {
        'id': getXmlNodeText, 
        'title': getXmlNodeText, 
        'thumbUrl': getXmlNodeText, 
        'description': getXmlNodeText, 
        'tags': getXmlNodeText, 
        'url': getXmlNodeText, 
        'sourceLink': getXmlNodeText, 
        'credit': getXmlNodeText, 
        'licenseType': (KalturaEnumsFactory.createInt, "KalturaLicenseType"), 
        'flashPlaybackType': getXmlNodeText, 
        'fileExt': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaSearch.fromXml(self, node)
        self.fromXmlImpl(node, KalturaSearchResult.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaSearch.toParams(self)
        kparams.put("objectType", "KalturaSearchResult")
        kparams.addStringIfDefined("id", self.id)
        kparams.addStringIfDefined("title", self.title)
        kparams.addStringIfDefined("thumbUrl", self.thumbUrl)
        kparams.addStringIfDefined("description", self.description)
        kparams.addStringIfDefined("tags", self.tags)
        kparams.addStringIfDefined("url", self.url)
        kparams.addStringIfDefined("sourceLink", self.sourceLink)
        kparams.addStringIfDefined("credit", self.credit)
        kparams.addIntEnumIfDefined("licenseType", self.licenseType)
        kparams.addStringIfDefined("flashPlaybackType", self.flashPlaybackType)
        kparams.addStringIfDefined("fileExt", self.fileExt)
        return kparams

    def getId(self):
        return self.id

    def setId(self, newId):
        self.id = newId

    def getTitle(self):
        return self.title

    def setTitle(self, newTitle):
        self.title = newTitle

    def getThumbUrl(self):
        return self.thumbUrl

    def setThumbUrl(self, newThumbUrl):
        self.thumbUrl = newThumbUrl

    def getDescription(self):
        return self.description

    def setDescription(self, newDescription):
        self.description = newDescription

    def getTags(self):
        return self.tags

    def setTags(self, newTags):
        self.tags = newTags

    def getUrl(self):
        return self.url

    def setUrl(self, newUrl):
        self.url = newUrl

    def getSourceLink(self):
        return self.sourceLink

    def setSourceLink(self, newSourceLink):
        self.sourceLink = newSourceLink

    def getCredit(self):
        return self.credit

    def setCredit(self, newCredit):
        self.credit = newCredit

    def getLicenseType(self):
        return self.licenseType

    def setLicenseType(self, newLicenseType):
        self.licenseType = newLicenseType

    def getFlashPlaybackType(self):
        return self.flashPlaybackType

    def setFlashPlaybackType(self, newFlashPlaybackType):
        self.flashPlaybackType = newFlashPlaybackType

    def getFileExt(self):
        return self.fileExt

    def setFileExt(self, newFileExt):
        self.fileExt = newFileExt


# @package Kaltura
# @subpackage Client
class KalturaSearchResultResponse(KalturaObjectBase):
    def __init__(self,
            objects=NotImplemented,
            needMediaInfo=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var array of KalturaSearchResult
        # @readonly
        self.objects = objects

        # @var bool
        # @readonly
        self.needMediaInfo = needMediaInfo


    PROPERTY_LOADERS = {
        'objects': (KalturaObjectFactory.createArray, 'KalturaSearchResult'), 
        'needMediaInfo': getXmlNodeBool, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaSearchResultResponse.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaSearchResultResponse")
        return kparams

    def getObjects(self):
        return self.objects

    def getNeedMediaInfo(self):
        return self.needMediaInfo


# @package Kaltura
# @subpackage Client
class KalturaServerNode(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            partnerId=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented,
            heartbeatTime=NotImplemented,
            name=NotImplemented,
            systemName=NotImplemented,
            description=NotImplemented,
            hostName=NotImplemented,
            status=NotImplemented,
            type=NotImplemented,
            tags=NotImplemented,
            dc=NotImplemented,
            parentId=NotImplemented,
            environment=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var int
        # @readonly
        self.id = id

        # @var int
        # @readonly
        self.partnerId = partnerId

        # @var int
        # @readonly
        self.createdAt = createdAt

        # @var int
        # @readonly
        self.updatedAt = updatedAt

        # @var int
        # @readonly
        self.heartbeatTime = heartbeatTime

        # serverNode name
        # @var string
        self.name = name

        # serverNode uniqe system name
        # @var string
        self.systemName = systemName

        # @var string
        self.description = description

        # serverNode hostName
        # @var string
        self.hostName = hostName

        # @var KalturaServerNodeStatus
        # @readonly
        self.status = status

        # @var KalturaServerNodeType
        # @readonly
        self.type = type

        # serverNode tags
        # @var string
        self.tags = tags

        # DC where the serverNode is located
        # @var int
        # @readonly
        self.dc = dc

        # Id of the parent serverNode
        # @var string
        self.parentId = parentId

        # Environment
        # @var string
        self.environment = environment


    PROPERTY_LOADERS = {
        'id': getXmlNodeInt, 
        'partnerId': getXmlNodeInt, 
        'createdAt': getXmlNodeInt, 
        'updatedAt': getXmlNodeInt, 
        'heartbeatTime': getXmlNodeInt, 
        'name': getXmlNodeText, 
        'systemName': getXmlNodeText, 
        'description': getXmlNodeText, 
        'hostName': getXmlNodeText, 
        'status': (KalturaEnumsFactory.createInt, "KalturaServerNodeStatus"), 
        'type': (KalturaEnumsFactory.createString, "KalturaServerNodeType"), 
        'tags': getXmlNodeText, 
        'dc': getXmlNodeInt, 
        'parentId': getXmlNodeText, 
        'environment': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaServerNode.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaServerNode")
        kparams.addStringIfDefined("name", self.name)
        kparams.addStringIfDefined("systemName", self.systemName)
        kparams.addStringIfDefined("description", self.description)
        kparams.addStringIfDefined("hostName", self.hostName)
        kparams.addStringIfDefined("tags", self.tags)
        kparams.addStringIfDefined("parentId", self.parentId)
        kparams.addStringIfDefined("environment", self.environment)
        return kparams

    def getId(self):
        return self.id

    def getPartnerId(self):
        return self.partnerId

    def getCreatedAt(self):
        return self.createdAt

    def getUpdatedAt(self):
        return self.updatedAt

    def getHeartbeatTime(self):
        return self.heartbeatTime

    def getName(self):
        return self.name

    def setName(self, newName):
        self.name = newName

    def getSystemName(self):
        return self.systemName

    def setSystemName(self, newSystemName):
        self.systemName = newSystemName

    def getDescription(self):
        return self.description

    def setDescription(self, newDescription):
        self.description = newDescription

    def getHostName(self):
        return self.hostName

    def setHostName(self, newHostName):
        self.hostName = newHostName

    def getStatus(self):
        return self.status

    def getType(self):
        return self.type

    def getTags(self):
        return self.tags

    def setTags(self, newTags):
        self.tags = newTags

    def getDc(self):
        return self.dc

    def getParentId(self):
        return self.parentId

    def setParentId(self, newParentId):
        self.parentId = newParentId

    def getEnvironment(self):
        return self.environment

    def setEnvironment(self, newEnvironment):
        self.environment = newEnvironment


# @package Kaltura
# @subpackage Client
class KalturaSessionInfo(KalturaObjectBase):
    def __init__(self,
            ks=NotImplemented,
            sessionType=NotImplemented,
            partnerId=NotImplemented,
            userId=NotImplemented,
            expiry=NotImplemented,
            privileges=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        # @readonly
        self.ks = ks

        # @var KalturaSessionType
        # @readonly
        self.sessionType = sessionType

        # @var int
        # @readonly
        self.partnerId = partnerId

        # @var string
        # @readonly
        self.userId = userId

        # @var int
        # @readonly
        self.expiry = expiry

        # @var string
        # @readonly
        self.privileges = privileges


    PROPERTY_LOADERS = {
        'ks': getXmlNodeText, 
        'sessionType': (KalturaEnumsFactory.createInt, "KalturaSessionType"), 
        'partnerId': getXmlNodeInt, 
        'userId': getXmlNodeText, 
        'expiry': getXmlNodeInt, 
        'privileges': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaSessionInfo.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaSessionInfo")
        return kparams

    def getKs(self):
        return self.ks

    def getSessionType(self):
        return self.sessionType

    def getPartnerId(self):
        return self.partnerId

    def getUserId(self):
        return self.userId

    def getExpiry(self):
        return self.expiry

    def getPrivileges(self):
        return self.privileges


# @package Kaltura
# @subpackage Client
class KalturaSourceFileSyncDescriptor(KalturaFileSyncDescriptor):
    def __init__(self,
            fileSyncLocalPath=NotImplemented,
            fileEncryptionKey=NotImplemented,
            fileSyncRemoteUrl=NotImplemented,
            fileSyncObjectSubType=NotImplemented,
            actualFileSyncLocalPath=NotImplemented,
            assetId=NotImplemented,
            assetParamsId=NotImplemented):
        KalturaFileSyncDescriptor.__init__(self,
            fileSyncLocalPath,
            fileEncryptionKey,
            fileSyncRemoteUrl,
            fileSyncObjectSubType)

        # The translated path as used by the scheduler
        # @var string
        self.actualFileSyncLocalPath = actualFileSyncLocalPath

        # @var string
        self.assetId = assetId

        # @var int
        self.assetParamsId = assetParamsId


    PROPERTY_LOADERS = {
        'actualFileSyncLocalPath': getXmlNodeText, 
        'assetId': getXmlNodeText, 
        'assetParamsId': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaFileSyncDescriptor.fromXml(self, node)
        self.fromXmlImpl(node, KalturaSourceFileSyncDescriptor.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaFileSyncDescriptor.toParams(self)
        kparams.put("objectType", "KalturaSourceFileSyncDescriptor")
        kparams.addStringIfDefined("actualFileSyncLocalPath", self.actualFileSyncLocalPath)
        kparams.addStringIfDefined("assetId", self.assetId)
        kparams.addIntIfDefined("assetParamsId", self.assetParamsId)
        return kparams

    def getActualFileSyncLocalPath(self):
        return self.actualFileSyncLocalPath

    def setActualFileSyncLocalPath(self, newActualFileSyncLocalPath):
        self.actualFileSyncLocalPath = newActualFileSyncLocalPath

    def getAssetId(self):
        return self.assetId

    def setAssetId(self, newAssetId):
        self.assetId = newAssetId

    def getAssetParamsId(self):
        return self.assetParamsId

    def setAssetParamsId(self, newAssetParamsId):
        self.assetParamsId = newAssetParamsId


# @package Kaltura
# @subpackage Client
class KalturaStartWidgetSessionResponse(KalturaObjectBase):
    def __init__(self,
            partnerId=NotImplemented,
            ks=NotImplemented,
            userId=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var int
        # @readonly
        self.partnerId = partnerId

        # @var string
        # @readonly
        self.ks = ks

        # @var string
        # @readonly
        self.userId = userId


    PROPERTY_LOADERS = {
        'partnerId': getXmlNodeInt, 
        'ks': getXmlNodeText, 
        'userId': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaStartWidgetSessionResponse.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaStartWidgetSessionResponse")
        return kparams

    def getPartnerId(self):
        return self.partnerId

    def getKs(self):
        return self.ks

    def getUserId(self):
        return self.userId


# @package Kaltura
# @subpackage Client
class KalturaStatsEvent(KalturaObjectBase):
    """Will hold data from the Kaltura UI components to be passed on to the reports and analytics system"""

    def __init__(self,
            clientVer=NotImplemented,
            eventType=NotImplemented,
            eventTimestamp=NotImplemented,
            sessionId=NotImplemented,
            partnerId=NotImplemented,
            entryId=NotImplemented,
            uniqueViewer=NotImplemented,
            widgetId=NotImplemented,
            uiconfId=NotImplemented,
            userId=NotImplemented,
            currentPoint=NotImplemented,
            duration=NotImplemented,
            userIp=NotImplemented,
            processDuration=NotImplemented,
            controlId=NotImplemented,
            seek=NotImplemented,
            newPoint=NotImplemented,
            referrer=NotImplemented,
            isFirstInSession=NotImplemented,
            applicationId=NotImplemented,
            contextId=NotImplemented,
            featureType=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.clientVer = clientVer

        # @var KalturaStatsEventType
        self.eventType = eventType

        # the client's timestamp of this event
        # @var float
        self.eventTimestamp = eventTimestamp

        # a unique string generated by the client that will represent the client-side session: the primary component will pass it on to other components that sprout from it
        # @var string
        self.sessionId = sessionId

        # @var int
        self.partnerId = partnerId

        # @var string
        self.entryId = entryId

        # the UV cookie - creates in the operational system and should be passed on ofr every event
        # @var string
        self.uniqueViewer = uniqueViewer

        # @var string
        self.widgetId = widgetId

        # @var int
        self.uiconfId = uiconfId

        # the partner's user id
        # @var string
        self.userId = userId

        # the timestamp along the video when the event happend
        # @var int
        self.currentPoint = currentPoint

        # the duration of the video in milliseconds - will make it much faster than quering the db for each entry
        # @var int
        self.duration = duration

        # will be retrieved from the request of the user
        # @var string
        # @readonly
        self.userIp = userIp

        # the time in milliseconds the event took
        # @var int
        self.processDuration = processDuration

        # the id of the GUI control - will be used in the future to better understand what the user clicked
        # @var string
        self.controlId = controlId

        # true if the user ever used seek in this session
        # @var bool
        self.seek = seek

        # timestamp of the new point on the timeline of the video after the user seeks
        # @var int
        self.newPoint = newPoint

        # the referrer of the client
        # @var string
        self.referrer = referrer

        # will indicate if the event is thrown for the first video in the session
        # @var bool
        self.isFirstInSession = isFirstInSession

        # kaltura application name
        # @var string
        self.applicationId = applicationId

        # @var int
        self.contextId = contextId

        # @var KalturaStatsFeatureType
        self.featureType = featureType


    PROPERTY_LOADERS = {
        'clientVer': getXmlNodeText, 
        'eventType': (KalturaEnumsFactory.createInt, "KalturaStatsEventType"), 
        'eventTimestamp': getXmlNodeFloat, 
        'sessionId': getXmlNodeText, 
        'partnerId': getXmlNodeInt, 
        'entryId': getXmlNodeText, 
        'uniqueViewer': getXmlNodeText, 
        'widgetId': getXmlNodeText, 
        'uiconfId': getXmlNodeInt, 
        'userId': getXmlNodeText, 
        'currentPoint': getXmlNodeInt, 
        'duration': getXmlNodeInt, 
        'userIp': getXmlNodeText, 
        'processDuration': getXmlNodeInt, 
        'controlId': getXmlNodeText, 
        'seek': getXmlNodeBool, 
        'newPoint': getXmlNodeInt, 
        'referrer': getXmlNodeText, 
        'isFirstInSession': getXmlNodeBool, 
        'applicationId': getXmlNodeText, 
        'contextId': getXmlNodeInt, 
        'featureType': (KalturaEnumsFactory.createInt, "KalturaStatsFeatureType"), 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaStatsEvent.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaStatsEvent")
        kparams.addStringIfDefined("clientVer", self.clientVer)
        kparams.addIntEnumIfDefined("eventType", self.eventType)
        kparams.addFloatIfDefined("eventTimestamp", self.eventTimestamp)
        kparams.addStringIfDefined("sessionId", self.sessionId)
        kparams.addIntIfDefined("partnerId", self.partnerId)
        kparams.addStringIfDefined("entryId", self.entryId)
        kparams.addStringIfDefined("uniqueViewer", self.uniqueViewer)
        kparams.addStringIfDefined("widgetId", self.widgetId)
        kparams.addIntIfDefined("uiconfId", self.uiconfId)
        kparams.addStringIfDefined("userId", self.userId)
        kparams.addIntIfDefined("currentPoint", self.currentPoint)
        kparams.addIntIfDefined("duration", self.duration)
        kparams.addIntIfDefined("processDuration", self.processDuration)
        kparams.addStringIfDefined("controlId", self.controlId)
        kparams.addBoolIfDefined("seek", self.seek)
        kparams.addIntIfDefined("newPoint", self.newPoint)
        kparams.addStringIfDefined("referrer", self.referrer)
        kparams.addBoolIfDefined("isFirstInSession", self.isFirstInSession)
        kparams.addStringIfDefined("applicationId", self.applicationId)
        kparams.addIntIfDefined("contextId", self.contextId)
        kparams.addIntEnumIfDefined("featureType", self.featureType)
        return kparams

    def getClientVer(self):
        return self.clientVer

    def setClientVer(self, newClientVer):
        self.clientVer = newClientVer

    def getEventType(self):
        return self.eventType

    def setEventType(self, newEventType):
        self.eventType = newEventType

    def getEventTimestamp(self):
        return self.eventTimestamp

    def setEventTimestamp(self, newEventTimestamp):
        self.eventTimestamp = newEventTimestamp

    def getSessionId(self):
        return self.sessionId

    def setSessionId(self, newSessionId):
        self.sessionId = newSessionId

    def getPartnerId(self):
        return self.partnerId

    def setPartnerId(self, newPartnerId):
        self.partnerId = newPartnerId

    def getEntryId(self):
        return self.entryId

    def setEntryId(self, newEntryId):
        self.entryId = newEntryId

    def getUniqueViewer(self):
        return self.uniqueViewer

    def setUniqueViewer(self, newUniqueViewer):
        self.uniqueViewer = newUniqueViewer

    def getWidgetId(self):
        return self.widgetId

    def setWidgetId(self, newWidgetId):
        self.widgetId = newWidgetId

    def getUiconfId(self):
        return self.uiconfId

    def setUiconfId(self, newUiconfId):
        self.uiconfId = newUiconfId

    def getUserId(self):
        return self.userId

    def setUserId(self, newUserId):
        self.userId = newUserId

    def getCurrentPoint(self):
        return self.currentPoint

    def setCurrentPoint(self, newCurrentPoint):
        self.currentPoint = newCurrentPoint

    def getDuration(self):
        return self.duration

    def setDuration(self, newDuration):
        self.duration = newDuration

    def getUserIp(self):
        return self.userIp

    def getProcessDuration(self):
        return self.processDuration

    def setProcessDuration(self, newProcessDuration):
        self.processDuration = newProcessDuration

    def getControlId(self):
        return self.controlId

    def setControlId(self, newControlId):
        self.controlId = newControlId

    def getSeek(self):
        return self.seek

    def setSeek(self, newSeek):
        self.seek = newSeek

    def getNewPoint(self):
        return self.newPoint

    def setNewPoint(self, newNewPoint):
        self.newPoint = newNewPoint

    def getReferrer(self):
        return self.referrer

    def setReferrer(self, newReferrer):
        self.referrer = newReferrer

    def getIsFirstInSession(self):
        return self.isFirstInSession

    def setIsFirstInSession(self, newIsFirstInSession):
        self.isFirstInSession = newIsFirstInSession

    def getApplicationId(self):
        return self.applicationId

    def setApplicationId(self, newApplicationId):
        self.applicationId = newApplicationId

    def getContextId(self):
        return self.contextId

    def setContextId(self, newContextId):
        self.contextId = newContextId

    def getFeatureType(self):
        return self.featureType

    def setFeatureType(self, newFeatureType):
        self.featureType = newFeatureType


# @package Kaltura
# @subpackage Client
class KalturaStatsKmcEvent(KalturaObjectBase):
    """Will hold data from the Kaltura UI components to be passed on to the reports and analytics system"""

    def __init__(self,
            clientVer=NotImplemented,
            kmcEventActionPath=NotImplemented,
            kmcEventType=NotImplemented,
            eventTimestamp=NotImplemented,
            sessionId=NotImplemented,
            partnerId=NotImplemented,
            entryId=NotImplemented,
            widgetId=NotImplemented,
            uiconfId=NotImplemented,
            userId=NotImplemented,
            userIp=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.clientVer = clientVer

        # @var string
        self.kmcEventActionPath = kmcEventActionPath

        # @var KalturaStatsKmcEventType
        self.kmcEventType = kmcEventType

        # the client's timestamp of this event
        # @var float
        self.eventTimestamp = eventTimestamp

        # a unique string generated by the client that will represent the client-side session: the primary component will pass it on to other components that sprout from it
        # @var string
        self.sessionId = sessionId

        # @var int
        self.partnerId = partnerId

        # @var string
        self.entryId = entryId

        # @var string
        self.widgetId = widgetId

        # @var int
        self.uiconfId = uiconfId

        # the partner's user id
        # @var string
        self.userId = userId

        # will be retrieved from the request of the user
        # @var string
        # @readonly
        self.userIp = userIp


    PROPERTY_LOADERS = {
        'clientVer': getXmlNodeText, 
        'kmcEventActionPath': getXmlNodeText, 
        'kmcEventType': (KalturaEnumsFactory.createInt, "KalturaStatsKmcEventType"), 
        'eventTimestamp': getXmlNodeFloat, 
        'sessionId': getXmlNodeText, 
        'partnerId': getXmlNodeInt, 
        'entryId': getXmlNodeText, 
        'widgetId': getXmlNodeText, 
        'uiconfId': getXmlNodeInt, 
        'userId': getXmlNodeText, 
        'userIp': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaStatsKmcEvent.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaStatsKmcEvent")
        kparams.addStringIfDefined("clientVer", self.clientVer)
        kparams.addStringIfDefined("kmcEventActionPath", self.kmcEventActionPath)
        kparams.addIntEnumIfDefined("kmcEventType", self.kmcEventType)
        kparams.addFloatIfDefined("eventTimestamp", self.eventTimestamp)
        kparams.addStringIfDefined("sessionId", self.sessionId)
        kparams.addIntIfDefined("partnerId", self.partnerId)
        kparams.addStringIfDefined("entryId", self.entryId)
        kparams.addStringIfDefined("widgetId", self.widgetId)
        kparams.addIntIfDefined("uiconfId", self.uiconfId)
        kparams.addStringIfDefined("userId", self.userId)
        return kparams

    def getClientVer(self):
        return self.clientVer

    def setClientVer(self, newClientVer):
        self.clientVer = newClientVer

    def getKmcEventActionPath(self):
        return self.kmcEventActionPath

    def setKmcEventActionPath(self, newKmcEventActionPath):
        self.kmcEventActionPath = newKmcEventActionPath

    def getKmcEventType(self):
        return self.kmcEventType

    def setKmcEventType(self, newKmcEventType):
        self.kmcEventType = newKmcEventType

    def getEventTimestamp(self):
        return self.eventTimestamp

    def setEventTimestamp(self, newEventTimestamp):
        self.eventTimestamp = newEventTimestamp

    def getSessionId(self):
        return self.sessionId

    def setSessionId(self, newSessionId):
        self.sessionId = newSessionId

    def getPartnerId(self):
        return self.partnerId

    def setPartnerId(self, newPartnerId):
        self.partnerId = newPartnerId

    def getEntryId(self):
        return self.entryId

    def setEntryId(self, newEntryId):
        self.entryId = newEntryId

    def getWidgetId(self):
        return self.widgetId

    def setWidgetId(self, newWidgetId):
        self.widgetId = newWidgetId

    def getUiconfId(self):
        return self.uiconfId

    def setUiconfId(self, newUiconfId):
        self.uiconfId = newUiconfId

    def getUserId(self):
        return self.userId

    def setUserId(self, newUserId):
        self.userId = newUserId

    def getUserIp(self):
        return self.userIp


# @package Kaltura
# @subpackage Client
class KalturaStorageProfile(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented,
            partnerId=NotImplemented,
            name=NotImplemented,
            systemName=NotImplemented,
            desciption=NotImplemented,
            status=NotImplemented,
            protocol=NotImplemented,
            storageUrl=NotImplemented,
            storageBaseDir=NotImplemented,
            pathPrefix=NotImplemented,
            storageUsername=NotImplemented,
            storagePassword=NotImplemented,
            storageFtpPassiveMode=NotImplemented,
            minFileSize=NotImplemented,
            maxFileSize=NotImplemented,
            flavorParamsIds=NotImplemented,
            maxConcurrentConnections=NotImplemented,
            pathManagerClass=NotImplemented,
            pathManagerParams=NotImplemented,
            trigger=NotImplemented,
            deliveryPriority=NotImplemented,
            deliveryStatus=NotImplemented,
            readyBehavior=NotImplemented,
            allowAutoDelete=NotImplemented,
            createFileLink=NotImplemented,
            rules=NotImplemented,
            deliveryProfileIds=NotImplemented,
            privateKey=NotImplemented,
            publicKey=NotImplemented,
            passPhrase=NotImplemented,
            port=NotImplemented,
            shouldExportThumbs=NotImplemented,
            packagerUrl=NotImplemented,
            exportPeriodically=NotImplemented,
            excludedFlavorParamsIds=NotImplemented,
            shouldExportCaptions=NotImplemented,
            excludedEntryTypes=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var int
        # @readonly
        self.id = id

        # @var int
        # @readonly
        self.createdAt = createdAt

        # @var int
        # @readonly
        self.updatedAt = updatedAt

        # @var int
        # @readonly
        self.partnerId = partnerId

        # @var string
        self.name = name

        # @var string
        self.systemName = systemName

        # @var string
        self.desciption = desciption

        # @var KalturaStorageProfileStatus
        self.status = status

        # @var KalturaStorageProfileProtocol
        self.protocol = protocol

        # @var string
        self.storageUrl = storageUrl

        # @var string
        self.storageBaseDir = storageBaseDir

        # @var string
        self.pathPrefix = pathPrefix

        # @var string
        self.storageUsername = storageUsername

        # @var string
        self.storagePassword = storagePassword

        # @var bool
        self.storageFtpPassiveMode = storageFtpPassiveMode

        # @var int
        self.minFileSize = minFileSize

        # @var int
        self.maxFileSize = maxFileSize

        # @var string
        self.flavorParamsIds = flavorParamsIds

        # @var int
        self.maxConcurrentConnections = maxConcurrentConnections

        # @var string
        self.pathManagerClass = pathManagerClass

        # @var array of KalturaKeyValue
        self.pathManagerParams = pathManagerParams

        # No need to create enum for temp field
        # @var int
        self.trigger = trigger

        # Delivery Priority
        # @var int
        self.deliveryPriority = deliveryPriority

        # @var KalturaStorageProfileDeliveryStatus
        self.deliveryStatus = deliveryStatus

        # @var KalturaStorageProfileReadyBehavior
        self.readyBehavior = readyBehavior

        # Flag sugnifying that the storage exported content should be deleted when soure entry is deleted
        # @var int
        self.allowAutoDelete = allowAutoDelete

        # Indicates to the local file transfer manager to create a link to the file instead of copying it
        # @var bool
        self.createFileLink = createFileLink

        # Holds storage profile export rules
        # @var array of KalturaRule
        self.rules = rules

        # Delivery profile ids
        # @var array of KalturaKeyValue
        self.deliveryProfileIds = deliveryProfileIds

        # @var string
        self.privateKey = privateKey

        # @var string
        self.publicKey = publicKey

        # @var string
        self.passPhrase = passPhrase

        # @var int
        self.port = port

        # @var bool
        self.shouldExportThumbs = shouldExportThumbs

        # @var string
        self.packagerUrl = packagerUrl

        # @var bool
        self.exportPeriodically = exportPeriodically

        # @var string
        self.excludedFlavorParamsIds = excludedFlavorParamsIds

        # @var bool
        self.shouldExportCaptions = shouldExportCaptions

        # @var string
        self.excludedEntryTypes = excludedEntryTypes


    PROPERTY_LOADERS = {
        'id': getXmlNodeInt, 
        'createdAt': getXmlNodeInt, 
        'updatedAt': getXmlNodeInt, 
        'partnerId': getXmlNodeInt, 
        'name': getXmlNodeText, 
        'systemName': getXmlNodeText, 
        'desciption': getXmlNodeText, 
        'status': (KalturaEnumsFactory.createInt, "KalturaStorageProfileStatus"), 
        'protocol': (KalturaEnumsFactory.createString, "KalturaStorageProfileProtocol"), 
        'storageUrl': getXmlNodeText, 
        'storageBaseDir': getXmlNodeText, 
        'pathPrefix': getXmlNodeText, 
        'storageUsername': getXmlNodeText, 
        'storagePassword': getXmlNodeText, 
        'storageFtpPassiveMode': getXmlNodeBool, 
        'minFileSize': getXmlNodeInt, 
        'maxFileSize': getXmlNodeInt, 
        'flavorParamsIds': getXmlNodeText, 
        'maxConcurrentConnections': getXmlNodeInt, 
        'pathManagerClass': getXmlNodeText, 
        'pathManagerParams': (KalturaObjectFactory.createArray, 'KalturaKeyValue'), 
        'trigger': getXmlNodeInt, 
        'deliveryPriority': getXmlNodeInt, 
        'deliveryStatus': (KalturaEnumsFactory.createInt, "KalturaStorageProfileDeliveryStatus"), 
        'readyBehavior': (KalturaEnumsFactory.createInt, "KalturaStorageProfileReadyBehavior"), 
        'allowAutoDelete': getXmlNodeInt, 
        'createFileLink': getXmlNodeBool, 
        'rules': (KalturaObjectFactory.createArray, 'KalturaRule'), 
        'deliveryProfileIds': (KalturaObjectFactory.createArray, 'KalturaKeyValue'), 
        'privateKey': getXmlNodeText, 
        'publicKey': getXmlNodeText, 
        'passPhrase': getXmlNodeText, 
        'port': getXmlNodeInt, 
        'shouldExportThumbs': getXmlNodeBool, 
        'packagerUrl': getXmlNodeText, 
        'exportPeriodically': getXmlNodeBool, 
        'excludedFlavorParamsIds': getXmlNodeText, 
        'shouldExportCaptions': getXmlNodeBool, 
        'excludedEntryTypes': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaStorageProfile.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaStorageProfile")
        kparams.addStringIfDefined("name", self.name)
        kparams.addStringIfDefined("systemName", self.systemName)
        kparams.addStringIfDefined("desciption", self.desciption)
        kparams.addIntEnumIfDefined("status", self.status)
        kparams.addStringEnumIfDefined("protocol", self.protocol)
        kparams.addStringIfDefined("storageUrl", self.storageUrl)
        kparams.addStringIfDefined("storageBaseDir", self.storageBaseDir)
        kparams.addStringIfDefined("pathPrefix", self.pathPrefix)
        kparams.addStringIfDefined("storageUsername", self.storageUsername)
        kparams.addStringIfDefined("storagePassword", self.storagePassword)
        kparams.addBoolIfDefined("storageFtpPassiveMode", self.storageFtpPassiveMode)
        kparams.addIntIfDefined("minFileSize", self.minFileSize)
        kparams.addIntIfDefined("maxFileSize", self.maxFileSize)
        kparams.addStringIfDefined("flavorParamsIds", self.flavorParamsIds)
        kparams.addIntIfDefined("maxConcurrentConnections", self.maxConcurrentConnections)
        kparams.addStringIfDefined("pathManagerClass", self.pathManagerClass)
        kparams.addArrayIfDefined("pathManagerParams", self.pathManagerParams)
        kparams.addIntIfDefined("trigger", self.trigger)
        kparams.addIntIfDefined("deliveryPriority", self.deliveryPriority)
        kparams.addIntEnumIfDefined("deliveryStatus", self.deliveryStatus)
        kparams.addIntEnumIfDefined("readyBehavior", self.readyBehavior)
        kparams.addIntIfDefined("allowAutoDelete", self.allowAutoDelete)
        kparams.addBoolIfDefined("createFileLink", self.createFileLink)
        kparams.addArrayIfDefined("rules", self.rules)
        kparams.addArrayIfDefined("deliveryProfileIds", self.deliveryProfileIds)
        kparams.addStringIfDefined("privateKey", self.privateKey)
        kparams.addStringIfDefined("publicKey", self.publicKey)
        kparams.addStringIfDefined("passPhrase", self.passPhrase)
        kparams.addIntIfDefined("port", self.port)
        kparams.addBoolIfDefined("shouldExportThumbs", self.shouldExportThumbs)
        kparams.addStringIfDefined("packagerUrl", self.packagerUrl)
        kparams.addBoolIfDefined("exportPeriodically", self.exportPeriodically)
        kparams.addStringIfDefined("excludedFlavorParamsIds", self.excludedFlavorParamsIds)
        kparams.addBoolIfDefined("shouldExportCaptions", self.shouldExportCaptions)
        kparams.addStringIfDefined("excludedEntryTypes", self.excludedEntryTypes)
        return kparams

    def getId(self):
        return self.id

    def getCreatedAt(self):
        return self.createdAt

    def getUpdatedAt(self):
        return self.updatedAt

    def getPartnerId(self):
        return self.partnerId

    def getName(self):
        return self.name

    def setName(self, newName):
        self.name = newName

    def getSystemName(self):
        return self.systemName

    def setSystemName(self, newSystemName):
        self.systemName = newSystemName

    def getDesciption(self):
        return self.desciption

    def setDesciption(self, newDesciption):
        self.desciption = newDesciption

    def getStatus(self):
        return self.status

    def setStatus(self, newStatus):
        self.status = newStatus

    def getProtocol(self):
        return self.protocol

    def setProtocol(self, newProtocol):
        self.protocol = newProtocol

    def getStorageUrl(self):
        return self.storageUrl

    def setStorageUrl(self, newStorageUrl):
        self.storageUrl = newStorageUrl

    def getStorageBaseDir(self):
        return self.storageBaseDir

    def setStorageBaseDir(self, newStorageBaseDir):
        self.storageBaseDir = newStorageBaseDir

    def getPathPrefix(self):
        return self.pathPrefix

    def setPathPrefix(self, newPathPrefix):
        self.pathPrefix = newPathPrefix

    def getStorageUsername(self):
        return self.storageUsername

    def setStorageUsername(self, newStorageUsername):
        self.storageUsername = newStorageUsername

    def getStoragePassword(self):
        return self.storagePassword

    def setStoragePassword(self, newStoragePassword):
        self.storagePassword = newStoragePassword

    def getStorageFtpPassiveMode(self):
        return self.storageFtpPassiveMode

    def setStorageFtpPassiveMode(self, newStorageFtpPassiveMode):
        self.storageFtpPassiveMode = newStorageFtpPassiveMode

    def getMinFileSize(self):
        return self.minFileSize

    def setMinFileSize(self, newMinFileSize):
        self.minFileSize = newMinFileSize

    def getMaxFileSize(self):
        return self.maxFileSize

    def setMaxFileSize(self, newMaxFileSize):
        self.maxFileSize = newMaxFileSize

    def getFlavorParamsIds(self):
        return self.flavorParamsIds

    def setFlavorParamsIds(self, newFlavorParamsIds):
        self.flavorParamsIds = newFlavorParamsIds

    def getMaxConcurrentConnections(self):
        return self.maxConcurrentConnections

    def setMaxConcurrentConnections(self, newMaxConcurrentConnections):
        self.maxConcurrentConnections = newMaxConcurrentConnections

    def getPathManagerClass(self):
        return self.pathManagerClass

    def setPathManagerClass(self, newPathManagerClass):
        self.pathManagerClass = newPathManagerClass

    def getPathManagerParams(self):
        return self.pathManagerParams

    def setPathManagerParams(self, newPathManagerParams):
        self.pathManagerParams = newPathManagerParams

    def getTrigger(self):
        return self.trigger

    def setTrigger(self, newTrigger):
        self.trigger = newTrigger

    def getDeliveryPriority(self):
        return self.deliveryPriority

    def setDeliveryPriority(self, newDeliveryPriority):
        self.deliveryPriority = newDeliveryPriority

    def getDeliveryStatus(self):
        return self.deliveryStatus

    def setDeliveryStatus(self, newDeliveryStatus):
        self.deliveryStatus = newDeliveryStatus

    def getReadyBehavior(self):
        return self.readyBehavior

    def setReadyBehavior(self, newReadyBehavior):
        self.readyBehavior = newReadyBehavior

    def getAllowAutoDelete(self):
        return self.allowAutoDelete

    def setAllowAutoDelete(self, newAllowAutoDelete):
        self.allowAutoDelete = newAllowAutoDelete

    def getCreateFileLink(self):
        return self.createFileLink

    def setCreateFileLink(self, newCreateFileLink):
        self.createFileLink = newCreateFileLink

    def getRules(self):
        return self.rules

    def setRules(self, newRules):
        self.rules = newRules

    def getDeliveryProfileIds(self):
        return self.deliveryProfileIds

    def setDeliveryProfileIds(self, newDeliveryProfileIds):
        self.deliveryProfileIds = newDeliveryProfileIds

    def getPrivateKey(self):
        return self.privateKey

    def setPrivateKey(self, newPrivateKey):
        self.privateKey = newPrivateKey

    def getPublicKey(self):
        return self.publicKey

    def setPublicKey(self, newPublicKey):
        self.publicKey = newPublicKey

    def getPassPhrase(self):
        return self.passPhrase

    def setPassPhrase(self, newPassPhrase):
        self.passPhrase = newPassPhrase

    def getPort(self):
        return self.port

    def setPort(self, newPort):
        self.port = newPort

    def getShouldExportThumbs(self):
        return self.shouldExportThumbs

    def setShouldExportThumbs(self, newShouldExportThumbs):
        self.shouldExportThumbs = newShouldExportThumbs

    def getPackagerUrl(self):
        return self.packagerUrl

    def setPackagerUrl(self, newPackagerUrl):
        self.packagerUrl = newPackagerUrl

    def getExportPeriodically(self):
        return self.exportPeriodically

    def setExportPeriodically(self, newExportPeriodically):
        self.exportPeriodically = newExportPeriodically

    def getExcludedFlavorParamsIds(self):
        return self.excludedFlavorParamsIds

    def setExcludedFlavorParamsIds(self, newExcludedFlavorParamsIds):
        self.excludedFlavorParamsIds = newExcludedFlavorParamsIds

    def getShouldExportCaptions(self):
        return self.shouldExportCaptions

    def setShouldExportCaptions(self, newShouldExportCaptions):
        self.shouldExportCaptions = newShouldExportCaptions

    def getExcludedEntryTypes(self):
        return self.excludedEntryTypes

    def setExcludedEntryTypes(self, newExcludedEntryTypes):
        self.excludedEntryTypes = newExcludedEntryTypes


# @package Kaltura
# @subpackage Client
class KalturaSyndicationFeedEntryCount(KalturaObjectBase):
    def __init__(self,
            totalEntryCount=NotImplemented,
            actualEntryCount=NotImplemented,
            requireTranscodingCount=NotImplemented):
        KalturaObjectBase.__init__(self)

        # the total count of entries that should appear in the feed without flavor filtering
        # @var int
        self.totalEntryCount = totalEntryCount

        # count of entries that will appear in the feed (including all relevant filters)
        # @var int
        self.actualEntryCount = actualEntryCount

        # count of entries that requires transcoding in order to be included in feed
        # @var int
        self.requireTranscodingCount = requireTranscodingCount


    PROPERTY_LOADERS = {
        'totalEntryCount': getXmlNodeInt, 
        'actualEntryCount': getXmlNodeInt, 
        'requireTranscodingCount': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaSyndicationFeedEntryCount.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaSyndicationFeedEntryCount")
        kparams.addIntIfDefined("totalEntryCount", self.totalEntryCount)
        kparams.addIntIfDefined("actualEntryCount", self.actualEntryCount)
        kparams.addIntIfDefined("requireTranscodingCount", self.requireTranscodingCount)
        return kparams

    def getTotalEntryCount(self):
        return self.totalEntryCount

    def setTotalEntryCount(self, newTotalEntryCount):
        self.totalEntryCount = newTotalEntryCount

    def getActualEntryCount(self):
        return self.actualEntryCount

    def setActualEntryCount(self, newActualEntryCount):
        self.actualEntryCount = newActualEntryCount

    def getRequireTranscodingCount(self):
        return self.requireTranscodingCount

    def setRequireTranscodingCount(self, newRequireTranscodingCount):
        self.requireTranscodingCount = newRequireTranscodingCount


# @package Kaltura
# @subpackage Client
class KalturaUiConf(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            name=NotImplemented,
            description=NotImplemented,
            partnerId=NotImplemented,
            objType=NotImplemented,
            objTypeAsString=NotImplemented,
            width=NotImplemented,
            height=NotImplemented,
            htmlParams=NotImplemented,
            swfUrl=NotImplemented,
            confFilePath=NotImplemented,
            confFile=NotImplemented,
            confFileFeatures=NotImplemented,
            config=NotImplemented,
            confVars=NotImplemented,
            useCdn=NotImplemented,
            tags=NotImplemented,
            swfUrlVersion=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented,
            creationMode=NotImplemented,
            html5Url=NotImplemented,
            version=NotImplemented,
            partnerTags=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var int
        # @readonly
        self.id = id

        # Name of the uiConf, this is not a primary key
        # @var string
        self.name = name

        # @var string
        self.description = description

        # @var int
        # @readonly
        self.partnerId = partnerId

        # @var KalturaUiConfObjType
        self.objType = objType

        # @var string
        # @readonly
        self.objTypeAsString = objTypeAsString

        # @var int
        self.width = width

        # @var int
        self.height = height

        # @var string
        self.htmlParams = htmlParams

        # @var string
        self.swfUrl = swfUrl

        # @var string
        # @readonly
        self.confFilePath = confFilePath

        # @var string
        self.confFile = confFile

        # @var string
        self.confFileFeatures = confFileFeatures

        # @var string
        self.config = config

        # @var string
        self.confVars = confVars

        # @var bool
        self.useCdn = useCdn

        # @var string
        self.tags = tags

        # @var string
        self.swfUrlVersion = swfUrlVersion

        # Entry creation date as Unix timestamp (In seconds)
        # @var int
        # @readonly
        self.createdAt = createdAt

        # Entry creation date as Unix timestamp (In seconds)
        # @var int
        # @readonly
        self.updatedAt = updatedAt

        # @var KalturaUiConfCreationMode
        self.creationMode = creationMode

        # @var string
        self.html5Url = html5Url

        # UiConf version
        # @var string
        # @readonly
        self.version = version

        # @var string
        self.partnerTags = partnerTags


    PROPERTY_LOADERS = {
        'id': getXmlNodeInt, 
        'name': getXmlNodeText, 
        'description': getXmlNodeText, 
        'partnerId': getXmlNodeInt, 
        'objType': (KalturaEnumsFactory.createInt, "KalturaUiConfObjType"), 
        'objTypeAsString': getXmlNodeText, 
        'width': getXmlNodeInt, 
        'height': getXmlNodeInt, 
        'htmlParams': getXmlNodeText, 
        'swfUrl': getXmlNodeText, 
        'confFilePath': getXmlNodeText, 
        'confFile': getXmlNodeText, 
        'confFileFeatures': getXmlNodeText, 
        'config': getXmlNodeText, 
        'confVars': getXmlNodeText, 
        'useCdn': getXmlNodeBool, 
        'tags': getXmlNodeText, 
        'swfUrlVersion': getXmlNodeText, 
        'createdAt': getXmlNodeInt, 
        'updatedAt': getXmlNodeInt, 
        'creationMode': (KalturaEnumsFactory.createInt, "KalturaUiConfCreationMode"), 
        'html5Url': getXmlNodeText, 
        'version': getXmlNodeText, 
        'partnerTags': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaUiConf.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaUiConf")
        kparams.addStringIfDefined("name", self.name)
        kparams.addStringIfDefined("description", self.description)
        kparams.addIntEnumIfDefined("objType", self.objType)
        kparams.addIntIfDefined("width", self.width)
        kparams.addIntIfDefined("height", self.height)
        kparams.addStringIfDefined("htmlParams", self.htmlParams)
        kparams.addStringIfDefined("swfUrl", self.swfUrl)
        kparams.addStringIfDefined("confFile", self.confFile)
        kparams.addStringIfDefined("confFileFeatures", self.confFileFeatures)
        kparams.addStringIfDefined("config", self.config)
        kparams.addStringIfDefined("confVars", self.confVars)
        kparams.addBoolIfDefined("useCdn", self.useCdn)
        kparams.addStringIfDefined("tags", self.tags)
        kparams.addStringIfDefined("swfUrlVersion", self.swfUrlVersion)
        kparams.addIntEnumIfDefined("creationMode", self.creationMode)
        kparams.addStringIfDefined("html5Url", self.html5Url)
        kparams.addStringIfDefined("partnerTags", self.partnerTags)
        return kparams

    def getId(self):
        return self.id

    def getName(self):
        return self.name

    def setName(self, newName):
        self.name = newName

    def getDescription(self):
        return self.description

    def setDescription(self, newDescription):
        self.description = newDescription

    def getPartnerId(self):
        return self.partnerId

    def getObjType(self):
        return self.objType

    def setObjType(self, newObjType):
        self.objType = newObjType

    def getObjTypeAsString(self):
        return self.objTypeAsString

    def getWidth(self):
        return self.width

    def setWidth(self, newWidth):
        self.width = newWidth

    def getHeight(self):
        return self.height

    def setHeight(self, newHeight):
        self.height = newHeight

    def getHtmlParams(self):
        return self.htmlParams

    def setHtmlParams(self, newHtmlParams):
        self.htmlParams = newHtmlParams

    def getSwfUrl(self):
        return self.swfUrl

    def setSwfUrl(self, newSwfUrl):
        self.swfUrl = newSwfUrl

    def getConfFilePath(self):
        return self.confFilePath

    def getConfFile(self):
        return self.confFile

    def setConfFile(self, newConfFile):
        self.confFile = newConfFile

    def getConfFileFeatures(self):
        return self.confFileFeatures

    def setConfFileFeatures(self, newConfFileFeatures):
        self.confFileFeatures = newConfFileFeatures

    def getConfig(self):
        return self.config

    def setConfig(self, newConfig):
        self.config = newConfig

    def getConfVars(self):
        return self.confVars

    def setConfVars(self, newConfVars):
        self.confVars = newConfVars

    def getUseCdn(self):
        return self.useCdn

    def setUseCdn(self, newUseCdn):
        self.useCdn = newUseCdn

    def getTags(self):
        return self.tags

    def setTags(self, newTags):
        self.tags = newTags

    def getSwfUrlVersion(self):
        return self.swfUrlVersion

    def setSwfUrlVersion(self, newSwfUrlVersion):
        self.swfUrlVersion = newSwfUrlVersion

    def getCreatedAt(self):
        return self.createdAt

    def getUpdatedAt(self):
        return self.updatedAt

    def getCreationMode(self):
        return self.creationMode

    def setCreationMode(self, newCreationMode):
        self.creationMode = newCreationMode

    def getHtml5Url(self):
        return self.html5Url

    def setHtml5Url(self, newHtml5Url):
        self.html5Url = newHtml5Url

    def getVersion(self):
        return self.version

    def getPartnerTags(self):
        return self.partnerTags

    def setPartnerTags(self, newPartnerTags):
        self.partnerTags = newPartnerTags


# @package Kaltura
# @subpackage Client
class KalturaUiConfTypeInfo(KalturaObjectBase):
    """Info about uiconf type"""

    def __init__(self,
            type=NotImplemented,
            versions=NotImplemented,
            directory=NotImplemented,
            filename=NotImplemented):
        KalturaObjectBase.__init__(self)

        # UiConf Type
        # @var KalturaUiConfObjType
        self.type = type

        # Available versions
        # @var array of KalturaString
        self.versions = versions

        # The direcotry this type is saved at
        # @var string
        self.directory = directory

        # Filename for this UiConf type
        # @var string
        self.filename = filename


    PROPERTY_LOADERS = {
        'type': (KalturaEnumsFactory.createInt, "KalturaUiConfObjType"), 
        'versions': (KalturaObjectFactory.createArray, 'KalturaString'), 
        'directory': getXmlNodeText, 
        'filename': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaUiConfTypeInfo.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaUiConfTypeInfo")
        kparams.addIntEnumIfDefined("type", self.type)
        kparams.addArrayIfDefined("versions", self.versions)
        kparams.addStringIfDefined("directory", self.directory)
        kparams.addStringIfDefined("filename", self.filename)
        return kparams

    def getType(self):
        return self.type

    def setType(self, newType):
        self.type = newType

    def getVersions(self):
        return self.versions

    def setVersions(self, newVersions):
        self.versions = newVersions

    def getDirectory(self):
        return self.directory

    def setDirectory(self, newDirectory):
        self.directory = newDirectory

    def getFilename(self):
        return self.filename

    def setFilename(self, newFilename):
        self.filename = newFilename


# @package Kaltura
# @subpackage Client
class KalturaUploadResponse(KalturaObjectBase):
    def __init__(self,
            uploadTokenId=NotImplemented,
            fileSize=NotImplemented,
            errorCode=NotImplemented,
            errorDescription=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.uploadTokenId = uploadTokenId

        # @var int
        self.fileSize = fileSize

        # @var KalturaUploadErrorCode
        self.errorCode = errorCode

        # @var string
        self.errorDescription = errorDescription


    PROPERTY_LOADERS = {
        'uploadTokenId': getXmlNodeText, 
        'fileSize': getXmlNodeInt, 
        'errorCode': (KalturaEnumsFactory.createInt, "KalturaUploadErrorCode"), 
        'errorDescription': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaUploadResponse.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaUploadResponse")
        kparams.addStringIfDefined("uploadTokenId", self.uploadTokenId)
        kparams.addIntIfDefined("fileSize", self.fileSize)
        kparams.addIntEnumIfDefined("errorCode", self.errorCode)
        kparams.addStringIfDefined("errorDescription", self.errorDescription)
        return kparams

    def getUploadTokenId(self):
        return self.uploadTokenId

    def setUploadTokenId(self, newUploadTokenId):
        self.uploadTokenId = newUploadTokenId

    def getFileSize(self):
        return self.fileSize

    def setFileSize(self, newFileSize):
        self.fileSize = newFileSize

    def getErrorCode(self):
        return self.errorCode

    def setErrorCode(self, newErrorCode):
        self.errorCode = newErrorCode

    def getErrorDescription(self):
        return self.errorDescription

    def setErrorDescription(self, newErrorDescription):
        self.errorDescription = newErrorDescription


# @package Kaltura
# @subpackage Client
class KalturaUploadToken(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            partnerId=NotImplemented,
            userId=NotImplemented,
            status=NotImplemented,
            fileName=NotImplemented,
            fileSize=NotImplemented,
            uploadedFileSize=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented,
            uploadUrl=NotImplemented,
            autoFinalize=NotImplemented):
        KalturaObjectBase.__init__(self)

        # Upload token unique ID
        # @var string
        # @readonly
        self.id = id

        # Partner ID of the upload token
        # @var int
        # @readonly
        self.partnerId = partnerId

        # User id for the upload token
        # @var string
        # @readonly
        self.userId = userId

        # Status of the upload token
        # @var KalturaUploadTokenStatus
        # @readonly
        self.status = status

        # Name of the file for the upload token, can be empty when the upload token is created and will be updated internally after the file is uploaded
        # @var string
        # @insertonly
        self.fileName = fileName

        # File size in bytes, can be empty when the upload token is created and will be updated internally after the file is uploaded
        # @var float
        # @insertonly
        self.fileSize = fileSize

        # Uploaded file size in bytes, can be used to identify how many bytes were uploaded before resuming
        # @var float
        # @readonly
        self.uploadedFileSize = uploadedFileSize

        # Creation date as Unix timestamp (In seconds)
        # @var int
        # @readonly
        self.createdAt = createdAt

        # Last update date as Unix timestamp (In seconds)
        # @var int
        # @readonly
        self.updatedAt = updatedAt

        # Upload url - to explicitly determine to which domain to adress the uploadToken->upload call
        # @var string
        # @readonly
        self.uploadUrl = uploadUrl

        # autoFinalize - Should the upload be finalized once the file size on disk matches the file size reproted when adding the upload token.
        # @var KalturaNullableBoolean
        # @insertonly
        self.autoFinalize = autoFinalize


    PROPERTY_LOADERS = {
        'id': getXmlNodeText, 
        'partnerId': getXmlNodeInt, 
        'userId': getXmlNodeText, 
        'status': (KalturaEnumsFactory.createInt, "KalturaUploadTokenStatus"), 
        'fileName': getXmlNodeText, 
        'fileSize': getXmlNodeFloat, 
        'uploadedFileSize': getXmlNodeFloat, 
        'createdAt': getXmlNodeInt, 
        'updatedAt': getXmlNodeInt, 
        'uploadUrl': getXmlNodeText, 
        'autoFinalize': (KalturaEnumsFactory.createInt, "KalturaNullableBoolean"), 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaUploadToken.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaUploadToken")
        kparams.addStringIfDefined("fileName", self.fileName)
        kparams.addFloatIfDefined("fileSize", self.fileSize)
        kparams.addIntEnumIfDefined("autoFinalize", self.autoFinalize)
        return kparams

    def getId(self):
        return self.id

    def getPartnerId(self):
        return self.partnerId

    def getUserId(self):
        return self.userId

    def getStatus(self):
        return self.status

    def getFileName(self):
        return self.fileName

    def setFileName(self, newFileName):
        self.fileName = newFileName

    def getFileSize(self):
        return self.fileSize

    def setFileSize(self, newFileSize):
        self.fileSize = newFileSize

    def getUploadedFileSize(self):
        return self.uploadedFileSize

    def getCreatedAt(self):
        return self.createdAt

    def getUpdatedAt(self):
        return self.updatedAt

    def getUploadUrl(self):
        return self.uploadUrl

    def getAutoFinalize(self):
        return self.autoFinalize

    def setAutoFinalize(self, newAutoFinalize):
        self.autoFinalize = newAutoFinalize


# @package Kaltura
# @subpackage Client
class KalturaUserEntry(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            entryId=NotImplemented,
            userId=NotImplemented,
            partnerId=NotImplemented,
            status=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented,
            type=NotImplemented,
            extendedStatus=NotImplemented):
        KalturaObjectBase.__init__(self)

        # unique auto-generated identifier
        # @var int
        # @readonly
        self.id = id

        # @var string
        # @insertonly
        self.entryId = entryId

        # @var string
        # @insertonly
        self.userId = userId

        # @var int
        # @readonly
        self.partnerId = partnerId

        # @var KalturaUserEntryStatus
        # @readonly
        self.status = status

        # @var int
        # @readonly
        self.createdAt = createdAt

        # @var int
        # @readonly
        self.updatedAt = updatedAt

        # @var KalturaUserEntryType
        # @readonly
        self.type = type

        # @var KalturaUserEntryExtendedStatus
        self.extendedStatus = extendedStatus


    PROPERTY_LOADERS = {
        'id': getXmlNodeInt, 
        'entryId': getXmlNodeText, 
        'userId': getXmlNodeText, 
        'partnerId': getXmlNodeInt, 
        'status': (KalturaEnumsFactory.createString, "KalturaUserEntryStatus"), 
        'createdAt': getXmlNodeInt, 
        'updatedAt': getXmlNodeInt, 
        'type': (KalturaEnumsFactory.createString, "KalturaUserEntryType"), 
        'extendedStatus': (KalturaEnumsFactory.createString, "KalturaUserEntryExtendedStatus"), 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaUserEntry.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaUserEntry")
        kparams.addStringIfDefined("entryId", self.entryId)
        kparams.addStringIfDefined("userId", self.userId)
        kparams.addStringEnumIfDefined("extendedStatus", self.extendedStatus)
        return kparams

    def getId(self):
        return self.id

    def getEntryId(self):
        return self.entryId

    def setEntryId(self, newEntryId):
        self.entryId = newEntryId

    def getUserId(self):
        return self.userId

    def setUserId(self, newUserId):
        self.userId = newUserId

    def getPartnerId(self):
        return self.partnerId

    def getStatus(self):
        return self.status

    def getCreatedAt(self):
        return self.createdAt

    def getUpdatedAt(self):
        return self.updatedAt

    def getType(self):
        return self.type

    def getExtendedStatus(self):
        return self.extendedStatus

    def setExtendedStatus(self, newExtendedStatus):
        self.extendedStatus = newExtendedStatus


# @package Kaltura
# @subpackage Client
class KalturaUserLoginData(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            loginEmail=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        self.id = id

        # @var string
        self.loginEmail = loginEmail


    PROPERTY_LOADERS = {
        'id': getXmlNodeText, 
        'loginEmail': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaUserLoginData.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaUserLoginData")
        kparams.addStringIfDefined("id", self.id)
        kparams.addStringIfDefined("loginEmail", self.loginEmail)
        return kparams

    def getId(self):
        return self.id

    def setId(self, newId):
        self.id = newId

    def getLoginEmail(self):
        return self.loginEmail

    def setLoginEmail(self, newLoginEmail):
        self.loginEmail = newLoginEmail


# @package Kaltura
# @subpackage Client
class KalturaUserRole(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            name=NotImplemented,
            systemName=NotImplemented,
            description=NotImplemented,
            status=NotImplemented,
            partnerId=NotImplemented,
            permissionNames=NotImplemented,
            tags=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var int
        # @readonly
        self.id = id

        # @var string
        self.name = name

        # @var string
        self.systemName = systemName

        # @var string
        self.description = description

        # @var KalturaUserRoleStatus
        self.status = status

        # @var int
        # @readonly
        self.partnerId = partnerId

        # @var string
        self.permissionNames = permissionNames

        # @var string
        self.tags = tags

        # @var int
        # @readonly
        self.createdAt = createdAt

        # @var int
        # @readonly
        self.updatedAt = updatedAt


    PROPERTY_LOADERS = {
        'id': getXmlNodeInt, 
        'name': getXmlNodeText, 
        'systemName': getXmlNodeText, 
        'description': getXmlNodeText, 
        'status': (KalturaEnumsFactory.createInt, "KalturaUserRoleStatus"), 
        'partnerId': getXmlNodeInt, 
        'permissionNames': getXmlNodeText, 
        'tags': getXmlNodeText, 
        'createdAt': getXmlNodeInt, 
        'updatedAt': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaUserRole.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaUserRole")
        kparams.addStringIfDefined("name", self.name)
        kparams.addStringIfDefined("systemName", self.systemName)
        kparams.addStringIfDefined("description", self.description)
        kparams.addIntEnumIfDefined("status", self.status)
        kparams.addStringIfDefined("permissionNames", self.permissionNames)
        kparams.addStringIfDefined("tags", self.tags)
        return kparams

    def getId(self):
        return self.id

    def getName(self):
        return self.name

    def setName(self, newName):
        self.name = newName

    def getSystemName(self):
        return self.systemName

    def setSystemName(self, newSystemName):
        self.systemName = newSystemName

    def getDescription(self):
        return self.description

    def setDescription(self, newDescription):
        self.description = newDescription

    def getStatus(self):
        return self.status

    def setStatus(self, newStatus):
        self.status = newStatus

    def getPartnerId(self):
        return self.partnerId

    def getPermissionNames(self):
        return self.permissionNames

    def setPermissionNames(self, newPermissionNames):
        self.permissionNames = newPermissionNames

    def getTags(self):
        return self.tags

    def setTags(self, newTags):
        self.tags = newTags

    def getCreatedAt(self):
        return self.createdAt

    def getUpdatedAt(self):
        return self.updatedAt


# @package Kaltura
# @subpackage Client
class KalturaWidget(KalturaObjectBase):
    def __init__(self,
            id=NotImplemented,
            sourceWidgetId=NotImplemented,
            rootWidgetId=NotImplemented,
            partnerId=NotImplemented,
            entryId=NotImplemented,
            uiConfId=NotImplemented,
            securityType=NotImplemented,
            securityPolicy=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented,
            partnerData=NotImplemented,
            widgetHTML=NotImplemented,
            enforceEntitlement=NotImplemented,
            privacyContext=NotImplemented,
            addEmbedHtml5Support=NotImplemented,
            roles=NotImplemented,
            privileges=NotImplemented):
        KalturaObjectBase.__init__(self)

        # @var string
        # @readonly
        self.id = id

        # @var string
        self.sourceWidgetId = sourceWidgetId

        # @var string
        # @readonly
        self.rootWidgetId = rootWidgetId

        # @var int
        # @readonly
        self.partnerId = partnerId

        # @var string
        self.entryId = entryId

        # @var int
        self.uiConfId = uiConfId

        # @var KalturaWidgetSecurityType
        self.securityType = securityType

        # @var int
        self.securityPolicy = securityPolicy

        # @var int
        # @readonly
        self.createdAt = createdAt

        # @var int
        # @readonly
        self.updatedAt = updatedAt

        # Can be used to store various partner related data as a string
        # @var string
        self.partnerData = partnerData

        # @var string
        # @readonly
        self.widgetHTML = widgetHTML

        # Should enforce entitlement on feed entries
        # @var bool
        self.enforceEntitlement = enforceEntitlement

        # Set privacy context for search entries that assiged to private and public categories within a category privacy context.
        # @var string
        self.privacyContext = privacyContext

        # Addes the HTML5 script line to the widget's embed code
        # @var bool
        self.addEmbedHtml5Support = addEmbedHtml5Support

        # @var string
        self.roles = roles

        # @var string
        self.privileges = privileges


    PROPERTY_LOADERS = {
        'id': getXmlNodeText, 
        'sourceWidgetId': getXmlNodeText, 
        'rootWidgetId': getXmlNodeText, 
        'partnerId': getXmlNodeInt, 
        'entryId': getXmlNodeText, 
        'uiConfId': getXmlNodeInt, 
        'securityType': (KalturaEnumsFactory.createInt, "KalturaWidgetSecurityType"), 
        'securityPolicy': getXmlNodeInt, 
        'createdAt': getXmlNodeInt, 
        'updatedAt': getXmlNodeInt, 
        'partnerData': getXmlNodeText, 
        'widgetHTML': getXmlNodeText, 
        'enforceEntitlement': getXmlNodeBool, 
        'privacyContext': getXmlNodeText, 
        'addEmbedHtml5Support': getXmlNodeBool, 
        'roles': getXmlNodeText, 
        'privileges': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaObjectBase.fromXml(self, node)
        self.fromXmlImpl(node, KalturaWidget.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaObjectBase.toParams(self)
        kparams.put("objectType", "KalturaWidget")
        kparams.addStringIfDefined("sourceWidgetId", self.sourceWidgetId)
        kparams.addStringIfDefined("entryId", self.entryId)
        kparams.addIntIfDefined("uiConfId", self.uiConfId)
        kparams.addIntEnumIfDefined("securityType", self.securityType)
        kparams.addIntIfDefined("securityPolicy", self.securityPolicy)
        kparams.addStringIfDefined("partnerData", self.partnerData)
        kparams.addBoolIfDefined("enforceEntitlement", self.enforceEntitlement)
        kparams.addStringIfDefined("privacyContext", self.privacyContext)
        kparams.addBoolIfDefined("addEmbedHtml5Support", self.addEmbedHtml5Support)
        kparams.addStringIfDefined("roles", self.roles)
        kparams.addStringIfDefined("privileges", self.privileges)
        return kparams

    def getId(self):
        return self.id

    def getSourceWidgetId(self):
        return self.sourceWidgetId

    def setSourceWidgetId(self, newSourceWidgetId):
        self.sourceWidgetId = newSourceWidgetId

    def getRootWidgetId(self):
        return self.rootWidgetId

    def getPartnerId(self):
        return self.partnerId

    def getEntryId(self):
        return self.entryId

    def setEntryId(self, newEntryId):
        self.entryId = newEntryId

    def getUiConfId(self):
        return self.uiConfId

    def setUiConfId(self, newUiConfId):
        self.uiConfId = newUiConfId

    def getSecurityType(self):
        return self.securityType

    def setSecurityType(self, newSecurityType):
        self.securityType = newSecurityType

    def getSecurityPolicy(self):
        return self.securityPolicy

    def setSecurityPolicy(self, newSecurityPolicy):
        self.securityPolicy = newSecurityPolicy

    def getCreatedAt(self):
        return self.createdAt

    def getUpdatedAt(self):
        return self.updatedAt

    def getPartnerData(self):
        return self.partnerData

    def setPartnerData(self, newPartnerData):
        self.partnerData = newPartnerData

    def getWidgetHTML(self):
        return self.widgetHTML

    def getEnforceEntitlement(self):
        return self.enforceEntitlement

    def setEnforceEntitlement(self, newEnforceEntitlement):
        self.enforceEntitlement = newEnforceEntitlement

    def getPrivacyContext(self):
        return self.privacyContext

    def setPrivacyContext(self, newPrivacyContext):
        self.privacyContext = newPrivacyContext

    def getAddEmbedHtml5Support(self):
        return self.addEmbedHtml5Support

    def setAddEmbedHtml5Support(self, newAddEmbedHtml5Support):
        self.addEmbedHtml5Support = newAddEmbedHtml5Support

    def getRoles(self):
        return self.roles

    def setRoles(self, newRoles):
        self.roles = newRoles

    def getPrivileges(self):
        return self.privileges

    def setPrivileges(self, newPrivileges):
        self.privileges = newPrivileges


# @package Kaltura
# @subpackage Client
class KalturaBatchJobBaseFilter(KalturaFilter):
    def __init__(self,
            orderBy=NotImplemented,
            advancedSearch=NotImplemented,
            idEqual=NotImplemented,
            idGreaterThanOrEqual=NotImplemented,
            partnerIdEqual=NotImplemented,
            partnerIdIn=NotImplemented,
            partnerIdNotIn=NotImplemented,
            createdAtGreaterThanOrEqual=NotImplemented,
            createdAtLessThanOrEqual=NotImplemented,
            updatedAtGreaterThanOrEqual=NotImplemented,
            updatedAtLessThanOrEqual=NotImplemented,
            executionAttemptsGreaterThanOrEqual=NotImplemented,
            executionAttemptsLessThanOrEqual=NotImplemented,
            lockVersionGreaterThanOrEqual=NotImplemented,
            lockVersionLessThanOrEqual=NotImplemented,
            entryIdEqual=NotImplemented,
            jobTypeEqual=NotImplemented,
            jobTypeIn=NotImplemented,
            jobTypeNotIn=NotImplemented,
            jobSubTypeEqual=NotImplemented,
            jobSubTypeIn=NotImplemented,
            jobSubTypeNotIn=NotImplemented,
            statusEqual=NotImplemented,
            statusIn=NotImplemented,
            statusNotIn=NotImplemented,
            priorityGreaterThanOrEqual=NotImplemented,
            priorityLessThanOrEqual=NotImplemented,
            priorityEqual=NotImplemented,
            priorityIn=NotImplemented,
            priorityNotIn=NotImplemented,
            batchVersionGreaterThanOrEqual=NotImplemented,
            batchVersionLessThanOrEqual=NotImplemented,
            batchVersionEqual=NotImplemented,
            queueTimeGreaterThanOrEqual=NotImplemented,
            queueTimeLessThanOrEqual=NotImplemented,
            finishTimeGreaterThanOrEqual=NotImplemented,
            finishTimeLessThanOrEqual=NotImplemented,
            errTypeEqual=NotImplemented,
            errTypeIn=NotImplemented,
            errTypeNotIn=NotImplemented,
            errNumberEqual=NotImplemented,
            errNumberIn=NotImplemented,
            errNumberNotIn=NotImplemented,
            estimatedEffortLessThan=NotImplemented,
            estimatedEffortGreaterThan=NotImplemented,
            urgencyLessThanOrEqual=NotImplemented,
            urgencyGreaterThanOrEqual=NotImplemented):
        KalturaFilter.__init__(self,
            orderBy,
            advancedSearch)

        # @var int
        self.idEqual = idEqual

        # @var int
        self.idGreaterThanOrEqual = idGreaterThanOrEqual

        # @var int
        self.partnerIdEqual = partnerIdEqual

        # @var string
        self.partnerIdIn = partnerIdIn

        # @var string
        self.partnerIdNotIn = partnerIdNotIn

        # @var int
        self.createdAtGreaterThanOrEqual = createdAtGreaterThanOrEqual

        # @var int
        self.createdAtLessThanOrEqual = createdAtLessThanOrEqual

        # @var int
        self.updatedAtGreaterThanOrEqual = updatedAtGreaterThanOrEqual

        # @var int
        self.updatedAtLessThanOrEqual = updatedAtLessThanOrEqual

        # @var int
        self.executionAttemptsGreaterThanOrEqual = executionAttemptsGreaterThanOrEqual

        # @var int
        self.executionAttemptsLessThanOrEqual = executionAttemptsLessThanOrEqual

        # @var int
        self.lockVersionGreaterThanOrEqual = lockVersionGreaterThanOrEqual

        # @var int
        self.lockVersionLessThanOrEqual = lockVersionLessThanOrEqual

        # @var string
        self.entryIdEqual = entryIdEqual

        # @var KalturaBatchJobType
        self.jobTypeEqual = jobTypeEqual

        # @var string
        self.jobTypeIn = jobTypeIn

        # @var string
        self.jobTypeNotIn = jobTypeNotIn

        # @var int
        self.jobSubTypeEqual = jobSubTypeEqual

        # @var string
        self.jobSubTypeIn = jobSubTypeIn

        # @var string
        self.jobSubTypeNotIn = jobSubTypeNotIn

        # @var KalturaBatchJobStatus
        self.statusEqual = statusEqual

        # @var string
        self.statusIn = statusIn

        # @var string
        self.statusNotIn = statusNotIn

        # @var int
        self.priorityGreaterThanOrEqual = priorityGreaterThanOrEqual

        # @var int
        self.priorityLessThanOrEqual = priorityLessThanOrEqual

        # @var int
        self.priorityEqual = priorityEqual

        # @var string
        self.priorityIn = priorityIn

        # @var string
        self.priorityNotIn = priorityNotIn

        # @var int
        self.batchVersionGreaterThanOrEqual = batchVersionGreaterThanOrEqual

        # @var int
        self.batchVersionLessThanOrEqual = batchVersionLessThanOrEqual

        # @var int
        self.batchVersionEqual = batchVersionEqual

        # @var int
        self.queueTimeGreaterThanOrEqual = queueTimeGreaterThanOrEqual

        # @var int
        self.queueTimeLessThanOrEqual = queueTimeLessThanOrEqual

        # @var int
        self.finishTimeGreaterThanOrEqual = finishTimeGreaterThanOrEqual

        # @var int
        self.finishTimeLessThanOrEqual = finishTimeLessThanOrEqual

        # @var KalturaBatchJobErrorTypes
        self.errTypeEqual = errTypeEqual

        # @var string
        self.errTypeIn = errTypeIn

        # @var string
        self.errTypeNotIn = errTypeNotIn

        # @var int
        self.errNumberEqual = errNumberEqual

        # @var string
        self.errNumberIn = errNumberIn

        # @var string
        self.errNumberNotIn = errNumberNotIn

        # @var int
        self.estimatedEffortLessThan = estimatedEffortLessThan

        # @var int
        self.estimatedEffortGreaterThan = estimatedEffortGreaterThan

        # @var int
        self.urgencyLessThanOrEqual = urgencyLessThanOrEqual

        # @var int
        self.urgencyGreaterThanOrEqual = urgencyGreaterThanOrEqual


    PROPERTY_LOADERS = {
        'idEqual': getXmlNodeInt, 
        'idGreaterThanOrEqual': getXmlNodeInt, 
        'partnerIdEqual': getXmlNodeInt, 
        'partnerIdIn': getXmlNodeText, 
        'partnerIdNotIn': getXmlNodeText, 
        'createdAtGreaterThanOrEqual': getXmlNodeInt, 
        'createdAtLessThanOrEqual': getXmlNodeInt, 
        'updatedAtGreaterThanOrEqual': getXmlNodeInt, 
        'updatedAtLessThanOrEqual': getXmlNodeInt, 
        'executionAttemptsGreaterThanOrEqual': getXmlNodeInt, 
        'executionAttemptsLessThanOrEqual': getXmlNodeInt, 
        'lockVersionGreaterThanOrEqual': getXmlNodeInt, 
        'lockVersionLessThanOrEqual': getXmlNodeInt, 
        'entryIdEqual': getXmlNodeText, 
        'jobTypeEqual': (KalturaEnumsFactory.createString, "KalturaBatchJobType"), 
        'jobTypeIn': getXmlNodeText, 
        'jobTypeNotIn': getXmlNodeText, 
        'jobSubTypeEqual': getXmlNodeInt, 
        'jobSubTypeIn': getXmlNodeText, 
        'jobSubTypeNotIn': getXmlNodeText, 
        'statusEqual': (KalturaEnumsFactory.createInt, "KalturaBatchJobStatus"), 
        'statusIn': getXmlNodeText, 
        'statusNotIn': getXmlNodeText, 
        'priorityGreaterThanOrEqual': getXmlNodeInt, 
        'priorityLessThanOrEqual': getXmlNodeInt, 
        'priorityEqual': getXmlNodeInt, 
        'priorityIn': getXmlNodeText, 
        'priorityNotIn': getXmlNodeText, 
        'batchVersionGreaterThanOrEqual': getXmlNodeInt, 
        'batchVersionLessThanOrEqual': getXmlNodeInt, 
        'batchVersionEqual': getXmlNodeInt, 
        'queueTimeGreaterThanOrEqual': getXmlNodeInt, 
        'queueTimeLessThanOrEqual': getXmlNodeInt, 
        'finishTimeGreaterThanOrEqual': getXmlNodeInt, 
        'finishTimeLessThanOrEqual': getXmlNodeInt, 
        'errTypeEqual': (KalturaEnumsFactory.createInt, "KalturaBatchJobErrorTypes"), 
        'errTypeIn': getXmlNodeText, 
        'errTypeNotIn': getXmlNodeText, 
        'errNumberEqual': getXmlNodeInt, 
        'errNumberIn': getXmlNodeText, 
        'errNumberNotIn': getXmlNodeText, 
        'estimatedEffortLessThan': getXmlNodeInt, 
        'estimatedEffortGreaterThan': getXmlNodeInt, 
        'urgencyLessThanOrEqual': getXmlNodeInt, 
        'urgencyGreaterThanOrEqual': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaFilter.fromXml(self, node)
        self.fromXmlImpl(node, KalturaBatchJobBaseFilter.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaFilter.toParams(self)
        kparams.put("objectType", "KalturaBatchJobBaseFilter")
        kparams.addIntIfDefined("idEqual", self.idEqual)
        kparams.addIntIfDefined("idGreaterThanOrEqual", self.idGreaterThanOrEqual)
        kparams.addIntIfDefined("partnerIdEqual", self.partnerIdEqual)
        kparams.addStringIfDefined("partnerIdIn", self.partnerIdIn)
        kparams.addStringIfDefined("partnerIdNotIn", self.partnerIdNotIn)
        kparams.addIntIfDefined("createdAtGreaterThanOrEqual", self.createdAtGreaterThanOrEqual)
        kparams.addIntIfDefined("createdAtLessThanOrEqual", self.createdAtLessThanOrEqual)
        kparams.addIntIfDefined("updatedAtGreaterThanOrEqual", self.updatedAtGreaterThanOrEqual)
        kparams.addIntIfDefined("updatedAtLessThanOrEqual", self.updatedAtLessThanOrEqual)
        kparams.addIntIfDefined("executionAttemptsGreaterThanOrEqual", self.executionAttemptsGreaterThanOrEqual)
        kparams.addIntIfDefined("executionAttemptsLessThanOrEqual", self.executionAttemptsLessThanOrEqual)
        kparams.addIntIfDefined("lockVersionGreaterThanOrEqual", self.lockVersionGreaterThanOrEqual)
        kparams.addIntIfDefined("lockVersionLessThanOrEqual", self.lockVersionLessThanOrEqual)
        kparams.addStringIfDefined("entryIdEqual", self.entryIdEqual)
        kparams.addStringEnumIfDefined("jobTypeEqual", self.jobTypeEqual)
        kparams.addStringIfDefined("jobTypeIn", self.jobTypeIn)
        kparams.addStringIfDefined("jobTypeNotIn", self.jobTypeNotIn)
        kparams.addIntIfDefined("jobSubTypeEqual", self.jobSubTypeEqual)
        kparams.addStringIfDefined("jobSubTypeIn", self.jobSubTypeIn)
        kparams.addStringIfDefined("jobSubTypeNotIn", self.jobSubTypeNotIn)
        kparams.addIntEnumIfDefined("statusEqual", self.statusEqual)
        kparams.addStringIfDefined("statusIn", self.statusIn)
        kparams.addStringIfDefined("statusNotIn", self.statusNotIn)
        kparams.addIntIfDefined("priorityGreaterThanOrEqual", self.priorityGreaterThanOrEqual)
        kparams.addIntIfDefined("priorityLessThanOrEqual", self.priorityLessThanOrEqual)
        kparams.addIntIfDefined("priorityEqual", self.priorityEqual)
        kparams.addStringIfDefined("priorityIn", self.priorityIn)
        kparams.addStringIfDefined("priorityNotIn", self.priorityNotIn)
        kparams.addIntIfDefined("batchVersionGreaterThanOrEqual", self.batchVersionGreaterThanOrEqual)
        kparams.addIntIfDefined("batchVersionLessThanOrEqual", self.batchVersionLessThanOrEqual)
        kparams.addIntIfDefined("batchVersionEqual", self.batchVersionEqual)
        kparams.addIntIfDefined("queueTimeGreaterThanOrEqual", self.queueTimeGreaterThanOrEqual)
        kparams.addIntIfDefined("queueTimeLessThanOrEqual", self.queueTimeLessThanOrEqual)
        kparams.addIntIfDefined("finishTimeGreaterThanOrEqual", self.finishTimeGreaterThanOrEqual)
        kparams.addIntIfDefined("finishTimeLessThanOrEqual", self.finishTimeLessThanOrEqual)
        kparams.addIntEnumIfDefined("errTypeEqual", self.errTypeEqual)
        kparams.addStringIfDefined("errTypeIn", self.errTypeIn)
        kparams.addStringIfDefined("errTypeNotIn", self.errTypeNotIn)
        kparams.addIntIfDefined("errNumberEqual", self.errNumberEqual)
        kparams.addStringIfDefined("errNumberIn", self.errNumberIn)
        kparams.addStringIfDefined("errNumberNotIn", self.errNumberNotIn)
        kparams.addIntIfDefined("estimatedEffortLessThan", self.estimatedEffortLessThan)
        kparams.addIntIfDefined("estimatedEffortGreaterThan", self.estimatedEffortGreaterThan)
        kparams.addIntIfDefined("urgencyLessThanOrEqual", self.urgencyLessThanOrEqual)
        kparams.addIntIfDefined("urgencyGreaterThanOrEqual", self.urgencyGreaterThanOrEqual)
        return kparams

    def getIdEqual(self):
        return self.idEqual

    def setIdEqual(self, newIdEqual):
        self.idEqual = newIdEqual

    def getIdGreaterThanOrEqual(self):
        return self.idGreaterThanOrEqual

    def setIdGreaterThanOrEqual(self, newIdGreaterThanOrEqual):
        self.idGreaterThanOrEqual = newIdGreaterThanOrEqual

    def getPartnerIdEqual(self):
        return self.partnerIdEqual

    def setPartnerIdEqual(self, newPartnerIdEqual):
        self.partnerIdEqual = newPartnerIdEqual

    def getPartnerIdIn(self):
        return self.partnerIdIn

    def setPartnerIdIn(self, newPartnerIdIn):
        self.partnerIdIn = newPartnerIdIn

    def getPartnerIdNotIn(self):
        return self.partnerIdNotIn

    def setPartnerIdNotIn(self, newPartnerIdNotIn):
        self.partnerIdNotIn = newPartnerIdNotIn

    def getCreatedAtGreaterThanOrEqual(self):
        return self.createdAtGreaterThanOrEqual

    def setCreatedAtGreaterThanOrEqual(self, newCreatedAtGreaterThanOrEqual):
        self.createdAtGreaterThanOrEqual = newCreatedAtGreaterThanOrEqual

    def getCreatedAtLessThanOrEqual(self):
        return self.createdAtLessThanOrEqual

    def setCreatedAtLessThanOrEqual(self, newCreatedAtLessThanOrEqual):
        self.createdAtLessThanOrEqual = newCreatedAtLessThanOrEqual

    def getUpdatedAtGreaterThanOrEqual(self):
        return self.updatedAtGreaterThanOrEqual

    def setUpdatedAtGreaterThanOrEqual(self, newUpdatedAtGreaterThanOrEqual):
        self.updatedAtGreaterThanOrEqual = newUpdatedAtGreaterThanOrEqual

    def getUpdatedAtLessThanOrEqual(self):
        return self.updatedAtLessThanOrEqual

    def setUpdatedAtLessThanOrEqual(self, newUpdatedAtLessThanOrEqual):
        self.updatedAtLessThanOrEqual = newUpdatedAtLessThanOrEqual

    def getExecutionAttemptsGreaterThanOrEqual(self):
        return self.executionAttemptsGreaterThanOrEqual

    def setExecutionAttemptsGreaterThanOrEqual(self, newExecutionAttemptsGreaterThanOrEqual):
        self.executionAttemptsGreaterThanOrEqual = newExecutionAttemptsGreaterThanOrEqual

    def getExecutionAttemptsLessThanOrEqual(self):
        return self.executionAttemptsLessThanOrEqual

    def setExecutionAttemptsLessThanOrEqual(self, newExecutionAttemptsLessThanOrEqual):
        self.executionAttemptsLessThanOrEqual = newExecutionAttemptsLessThanOrEqual

    def getLockVersionGreaterThanOrEqual(self):
        return self.lockVersionGreaterThanOrEqual

    def setLockVersionGreaterThanOrEqual(self, newLockVersionGreaterThanOrEqual):
        self.lockVersionGreaterThanOrEqual = newLockVersionGreaterThanOrEqual

    def getLockVersionLessThanOrEqual(self):
        return self.lockVersionLessThanOrEqual

    def setLockVersionLessThanOrEqual(self, newLockVersionLessThanOrEqual):
        self.lockVersionLessThanOrEqual = newLockVersionLessThanOrEqual

    def getEntryIdEqual(self):
        return self.entryIdEqual

    def setEntryIdEqual(self, newEntryIdEqual):
        self.entryIdEqual = newEntryIdEqual

    def getJobTypeEqual(self):
        return self.jobTypeEqual

    def setJobTypeEqual(self, newJobTypeEqual):
        self.jobTypeEqual = newJobTypeEqual

    def getJobTypeIn(self):
        return self.jobTypeIn

    def setJobTypeIn(self, newJobTypeIn):
        self.jobTypeIn = newJobTypeIn

    def getJobTypeNotIn(self):
        return self.jobTypeNotIn

    def setJobTypeNotIn(self, newJobTypeNotIn):
        self.jobTypeNotIn = newJobTypeNotIn

    def getJobSubTypeEqual(self):
        return self.jobSubTypeEqual

    def setJobSubTypeEqual(self, newJobSubTypeEqual):
        self.jobSubTypeEqual = newJobSubTypeEqual

    def getJobSubTypeIn(self):
        return self.jobSubTypeIn

    def setJobSubTypeIn(self, newJobSubTypeIn):
        self.jobSubTypeIn = newJobSubTypeIn

    def getJobSubTypeNotIn(self):
        return self.jobSubTypeNotIn

    def setJobSubTypeNotIn(self, newJobSubTypeNotIn):
        self.jobSubTypeNotIn = newJobSubTypeNotIn

    def getStatusEqual(self):
        return self.statusEqual

    def setStatusEqual(self, newStatusEqual):
        self.statusEqual = newStatusEqual

    def getStatusIn(self):
        return self.statusIn

    def setStatusIn(self, newStatusIn):
        self.statusIn = newStatusIn

    def getStatusNotIn(self):
        return self.statusNotIn

    def setStatusNotIn(self, newStatusNotIn):
        self.statusNotIn = newStatusNotIn

    def getPriorityGreaterThanOrEqual(self):
        return self.priorityGreaterThanOrEqual

    def setPriorityGreaterThanOrEqual(self, newPriorityGreaterThanOrEqual):
        self.priorityGreaterThanOrEqual = newPriorityGreaterThanOrEqual

    def getPriorityLessThanOrEqual(self):
        return self.priorityLessThanOrEqual

    def setPriorityLessThanOrEqual(self, newPriorityLessThanOrEqual):
        self.priorityLessThanOrEqual = newPriorityLessThanOrEqual

    def getPriorityEqual(self):
        return self.priorityEqual

    def setPriorityEqual(self, newPriorityEqual):
        self.priorityEqual = newPriorityEqual

    def getPriorityIn(self):
        return self.priorityIn

    def setPriorityIn(self, newPriorityIn):
        self.priorityIn = newPriorityIn

    def getPriorityNotIn(self):
        return self.priorityNotIn

    def setPriorityNotIn(self, newPriorityNotIn):
        self.priorityNotIn = newPriorityNotIn

    def getBatchVersionGreaterThanOrEqual(self):
        return self.batchVersionGreaterThanOrEqual

    def setBatchVersionGreaterThanOrEqual(self, newBatchVersionGreaterThanOrEqual):
        self.batchVersionGreaterThanOrEqual = newBatchVersionGreaterThanOrEqual

    def getBatchVersionLessThanOrEqual(self):
        return self.batchVersionLessThanOrEqual

    def setBatchVersionLessThanOrEqual(self, newBatchVersionLessThanOrEqual):
        self.batchVersionLessThanOrEqual = newBatchVersionLessThanOrEqual

    def getBatchVersionEqual(self):
        return self.batchVersionEqual

    def setBatchVersionEqual(self, newBatchVersionEqual):
        self.batchVersionEqual = newBatchVersionEqual

    def getQueueTimeGreaterThanOrEqual(self):
        return self.queueTimeGreaterThanOrEqual

    def setQueueTimeGreaterThanOrEqual(self, newQueueTimeGreaterThanOrEqual):
        self.queueTimeGreaterThanOrEqual = newQueueTimeGreaterThanOrEqual

    def getQueueTimeLessThanOrEqual(self):
        return self.queueTimeLessThanOrEqual

    def setQueueTimeLessThanOrEqual(self, newQueueTimeLessThanOrEqual):
        self.queueTimeLessThanOrEqual = newQueueTimeLessThanOrEqual

    def getFinishTimeGreaterThanOrEqual(self):
        return self.finishTimeGreaterThanOrEqual

    def setFinishTimeGreaterThanOrEqual(self, newFinishTimeGreaterThanOrEqual):
        self.finishTimeGreaterThanOrEqual = newFinishTimeGreaterThanOrEqual

    def getFinishTimeLessThanOrEqual(self):
        return self.finishTimeLessThanOrEqual

    def setFinishTimeLessThanOrEqual(self, newFinishTimeLessThanOrEqual):
        self.finishTimeLessThanOrEqual = newFinishTimeLessThanOrEqual

    def getErrTypeEqual(self):
        return self.errTypeEqual

    def setErrTypeEqual(self, newErrTypeEqual):
        self.errTypeEqual = newErrTypeEqual

    def getErrTypeIn(self):
        return self.errTypeIn

    def setErrTypeIn(self, newErrTypeIn):
        self.errTypeIn = newErrTypeIn

    def getErrTypeNotIn(self):
        return self.errTypeNotIn

    def setErrTypeNotIn(self, newErrTypeNotIn):
        self.errTypeNotIn = newErrTypeNotIn

    def getErrNumberEqual(self):
        return self.errNumberEqual

    def setErrNumberEqual(self, newErrNumberEqual):
        self.errNumberEqual = newErrNumberEqual

    def getErrNumberIn(self):
        return self.errNumberIn

    def setErrNumberIn(self, newErrNumberIn):
        self.errNumberIn = newErrNumberIn

    def getErrNumberNotIn(self):
        return self.errNumberNotIn

    def setErrNumberNotIn(self, newErrNumberNotIn):
        self.errNumberNotIn = newErrNumberNotIn

    def getEstimatedEffortLessThan(self):
        return self.estimatedEffortLessThan

    def setEstimatedEffortLessThan(self, newEstimatedEffortLessThan):
        self.estimatedEffortLessThan = newEstimatedEffortLessThan

    def getEstimatedEffortGreaterThan(self):
        return self.estimatedEffortGreaterThan

    def setEstimatedEffortGreaterThan(self, newEstimatedEffortGreaterThan):
        self.estimatedEffortGreaterThan = newEstimatedEffortGreaterThan

    def getUrgencyLessThanOrEqual(self):
        return self.urgencyLessThanOrEqual

    def setUrgencyLessThanOrEqual(self, newUrgencyLessThanOrEqual):
        self.urgencyLessThanOrEqual = newUrgencyLessThanOrEqual

    def getUrgencyGreaterThanOrEqual(self):
        return self.urgencyGreaterThanOrEqual

    def setUrgencyGreaterThanOrEqual(self, newUrgencyGreaterThanOrEqual):
        self.urgencyGreaterThanOrEqual = newUrgencyGreaterThanOrEqual


# @package Kaltura
# @subpackage Client
class KalturaBatchJobFilter(KalturaBatchJobBaseFilter):
    def __init__(self,
            orderBy=NotImplemented,
            advancedSearch=NotImplemented,
            idEqual=NotImplemented,
            idGreaterThanOrEqual=NotImplemented,
            partnerIdEqual=NotImplemented,
            partnerIdIn=NotImplemented,
            partnerIdNotIn=NotImplemented,
            createdAtGreaterThanOrEqual=NotImplemented,
            createdAtLessThanOrEqual=NotImplemented,
            updatedAtGreaterThanOrEqual=NotImplemented,
            updatedAtLessThanOrEqual=NotImplemented,
            executionAttemptsGreaterThanOrEqual=NotImplemented,
            executionAttemptsLessThanOrEqual=NotImplemented,
            lockVersionGreaterThanOrEqual=NotImplemented,
            lockVersionLessThanOrEqual=NotImplemented,
            entryIdEqual=NotImplemented,
            jobTypeEqual=NotImplemented,
            jobTypeIn=NotImplemented,
            jobTypeNotIn=NotImplemented,
            jobSubTypeEqual=NotImplemented,
            jobSubTypeIn=NotImplemented,
            jobSubTypeNotIn=NotImplemented,
            statusEqual=NotImplemented,
            statusIn=NotImplemented,
            statusNotIn=NotImplemented,
            priorityGreaterThanOrEqual=NotImplemented,
            priorityLessThanOrEqual=NotImplemented,
            priorityEqual=NotImplemented,
            priorityIn=NotImplemented,
            priorityNotIn=NotImplemented,
            batchVersionGreaterThanOrEqual=NotImplemented,
            batchVersionLessThanOrEqual=NotImplemented,
            batchVersionEqual=NotImplemented,
            queueTimeGreaterThanOrEqual=NotImplemented,
            queueTimeLessThanOrEqual=NotImplemented,
            finishTimeGreaterThanOrEqual=NotImplemented,
            finishTimeLessThanOrEqual=NotImplemented,
            errTypeEqual=NotImplemented,
            errTypeIn=NotImplemented,
            errTypeNotIn=NotImplemented,
            errNumberEqual=NotImplemented,
            errNumberIn=NotImplemented,
            errNumberNotIn=NotImplemented,
            estimatedEffortLessThan=NotImplemented,
            estimatedEffortGreaterThan=NotImplemented,
            urgencyLessThanOrEqual=NotImplemented,
            urgencyGreaterThanOrEqual=NotImplemented):
        KalturaBatchJobBaseFilter.__init__(self,
            orderBy,
            advancedSearch,
            idEqual,
            idGreaterThanOrEqual,
            partnerIdEqual,
            partnerIdIn,
            partnerIdNotIn,
            createdAtGreaterThanOrEqual,
            createdAtLessThanOrEqual,
            updatedAtGreaterThanOrEqual,
            updatedAtLessThanOrEqual,
            executionAttemptsGreaterThanOrEqual,
            executionAttemptsLessThanOrEqual,
            lockVersionGreaterThanOrEqual,
            lockVersionLessThanOrEqual,
            entryIdEqual,
            jobTypeEqual,
            jobTypeIn,
            jobTypeNotIn,
            jobSubTypeEqual,
            jobSubTypeIn,
            jobSubTypeNotIn,
            statusEqual,
            statusIn,
            statusNotIn,
            priorityGreaterThanOrEqual,
            priorityLessThanOrEqual,
            priorityEqual,
            priorityIn,
            priorityNotIn,
            batchVersionGreaterThanOrEqual,
            batchVersionLessThanOrEqual,
            batchVersionEqual,
            queueTimeGreaterThanOrEqual,
            queueTimeLessThanOrEqual,
            finishTimeGreaterThanOrEqual,
            finishTimeLessThanOrEqual,
            errTypeEqual,
            errTypeIn,
            errTypeNotIn,
            errNumberEqual,
            errNumberIn,
            errNumberNotIn,
            estimatedEffortLessThan,
            estimatedEffortGreaterThan,
            urgencyLessThanOrEqual,
            urgencyGreaterThanOrEqual)


    PROPERTY_LOADERS = {
    }

    def fromXml(self, node):
        KalturaBatchJobBaseFilter.fromXml(self, node)
        self.fromXmlImpl(node, KalturaBatchJobFilter.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaBatchJobBaseFilter.toParams(self)
        kparams.put("objectType", "KalturaBatchJobFilter")
        return kparams


# @package Kaltura
# @subpackage Client
class KalturaAccessControlBlockAction(KalturaRuleAction):
    def __init__(self,
            type=NotImplemented):
        KalturaRuleAction.__init__(self,
            type)


    PROPERTY_LOADERS = {
    }

    def fromXml(self, node):
        KalturaRuleAction.fromXml(self, node)
        self.fromXmlImpl(node, KalturaAccessControlBlockAction.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaRuleAction.toParams(self)
        kparams.put("objectType", "KalturaAccessControlBlockAction")
        return kparams


# @package Kaltura
# @subpackage Client
class KalturaAccessControlLimitDeliveryProfilesAction(KalturaRuleAction):
    def __init__(self,
            type=NotImplemented,
            deliveryProfileIds=NotImplemented,
            isBlockedList=NotImplemented):
        KalturaRuleAction.__init__(self,
            type)

        # Comma separated list of delivery profile ids
        # @var string
        self.deliveryProfileIds = deliveryProfileIds

        # @var bool
        self.isBlockedList = isBlockedList


    PROPERTY_LOADERS = {
        'deliveryProfileIds': getXmlNodeText, 
        'isBlockedList': getXmlNodeBool, 
    }

    def fromXml(self, node):
        KalturaRuleAction.fromXml(self, node)
        self.fromXmlImpl(node, KalturaAccessControlLimitDeliveryProfilesAction.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaRuleAction.toParams(self)
        kparams.put("objectType", "KalturaAccessControlLimitDeliveryProfilesAction")
        kparams.addStringIfDefined("deliveryProfileIds", self.deliveryProfileIds)
        kparams.addBoolIfDefined("isBlockedList", self.isBlockedList)
        return kparams

    def getDeliveryProfileIds(self):
        return self.deliveryProfileIds

    def setDeliveryProfileIds(self, newDeliveryProfileIds):
        self.deliveryProfileIds = newDeliveryProfileIds

    def getIsBlockedList(self):
        return self.isBlockedList

    def setIsBlockedList(self, newIsBlockedList):
        self.isBlockedList = newIsBlockedList


# @package Kaltura
# @subpackage Client
class KalturaAccessControlLimitFlavorsAction(KalturaRuleAction):
    def __init__(self,
            type=NotImplemented,
            flavorParamsIds=NotImplemented,
            isBlockedList=NotImplemented):
        KalturaRuleAction.__init__(self,
            type)

        # Comma separated list of flavor ids
        # @var string
        self.flavorParamsIds = flavorParamsIds

        # @var bool
        self.isBlockedList = isBlockedList


    PROPERTY_LOADERS = {
        'flavorParamsIds': getXmlNodeText, 
        'isBlockedList': getXmlNodeBool, 
    }

    def fromXml(self, node):
        KalturaRuleAction.fromXml(self, node)
        self.fromXmlImpl(node, KalturaAccessControlLimitFlavorsAction.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaRuleAction.toParams(self)
        kparams.put("objectType", "KalturaAccessControlLimitFlavorsAction")
        kparams.addStringIfDefined("flavorParamsIds", self.flavorParamsIds)
        kparams.addBoolIfDefined("isBlockedList", self.isBlockedList)
        return kparams

    def getFlavorParamsIds(self):
        return self.flavorParamsIds

    def setFlavorParamsIds(self, newFlavorParamsIds):
        self.flavorParamsIds = newFlavorParamsIds

    def getIsBlockedList(self):
        return self.isBlockedList

    def setIsBlockedList(self, newIsBlockedList):
        self.isBlockedList = newIsBlockedList


# @package Kaltura
# @subpackage Client
class KalturaAccessControlLimitThumbnailCaptureAction(KalturaRuleAction):
    def __init__(self,
            type=NotImplemented):
        KalturaRuleAction.__init__(self,
            type)


    PROPERTY_LOADERS = {
    }

    def fromXml(self, node):
        KalturaRuleAction.fromXml(self, node)
        self.fromXmlImpl(node, KalturaAccessControlLimitThumbnailCaptureAction.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaRuleAction.toParams(self)
        kparams.put("objectType", "KalturaAccessControlLimitThumbnailCaptureAction")
        return kparams


# @package Kaltura
# @subpackage Client
class KalturaAccessControlListResponse(KalturaListResponse):
    def __init__(self,
            totalCount=NotImplemented,
            objects=NotImplemented):
        KalturaListResponse.__init__(self,
            totalCount)

        # @var array of KalturaAccessControl
        # @readonly
        self.objects = objects


    PROPERTY_LOADERS = {
        'objects': (KalturaObjectFactory.createArray, 'KalturaAccessControl'), 
    }

    def fromXml(self, node):
        KalturaListResponse.fromXml(self, node)
        self.fromXmlImpl(node, KalturaAccessControlListResponse.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaListResponse.toParams(self)
        kparams.put("objectType", "KalturaAccessControlListResponse")
        return kparams

    def getObjects(self):
        return self.objects


# @package Kaltura
# @subpackage Client
class KalturaAccessControlModifyRequestHostRegexAction(KalturaRuleAction):
    def __init__(self,
            type=NotImplemented,
            pattern=NotImplemented,
            replacement=NotImplemented,
            replacmenServerNodeId=NotImplemented):
        KalturaRuleAction.__init__(self,
            type)

        # Request host regex pattern
        # @var string
        self.pattern = pattern

        # Request host regex replacment
        # @var string
        self.replacement = replacement

        # serverNodeId to generate replacment host from
        # @var int
        self.replacmenServerNodeId = replacmenServerNodeId


    PROPERTY_LOADERS = {
        'pattern': getXmlNodeText, 
        'replacement': getXmlNodeText, 
        'replacmenServerNodeId': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaRuleAction.fromXml(self, node)
        self.fromXmlImpl(node, KalturaAccessControlModifyRequestHostRegexAction.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaRuleAction.toParams(self)
        kparams.put("objectType", "KalturaAccessControlModifyRequestHostRegexAction")
        kparams.addStringIfDefined("pattern", self.pattern)
        kparams.addStringIfDefined("replacement", self.replacement)
        kparams.addIntIfDefined("replacmenServerNodeId", self.replacmenServerNodeId)
        return kparams

    def getPattern(self):
        return self.pattern

    def setPattern(self, newPattern):
        self.pattern = newPattern

    def getReplacement(self):
        return self.replacement

    def setReplacement(self, newReplacement):
        self.replacement = newReplacement

    def getReplacmenServerNodeId(self):
        return self.replacmenServerNodeId

    def setReplacmenServerNodeId(self, newReplacmenServerNodeId):
        self.replacmenServerNodeId = newReplacmenServerNodeId


# @package Kaltura
# @subpackage Client
class KalturaAccessControlPreviewAction(KalturaRuleAction):
    def __init__(self,
            type=NotImplemented,
            limit=NotImplemented):
        KalturaRuleAction.__init__(self,
            type)

        # @var int
        self.limit = limit


    PROPERTY_LOADERS = {
        'limit': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaRuleAction.fromXml(self, node)
        self.fromXmlImpl(node, KalturaAccessControlPreviewAction.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaRuleAction.toParams(self)
        kparams.put("objectType", "KalturaAccessControlPreviewAction")
        kparams.addIntIfDefined("limit", self.limit)
        return kparams

    def getLimit(self):
        return self.limit

    def setLimit(self, newLimit):
        self.limit = newLimit


# @package Kaltura
# @subpackage Client
class KalturaAccessControlProfileListResponse(KalturaListResponse):
    def __init__(self,
            totalCount=NotImplemented,
            objects=NotImplemented):
        KalturaListResponse.__init__(self,
            totalCount)

        # @var array of KalturaAccessControlProfile
        # @readonly
        self.objects = objects


    PROPERTY_LOADERS = {
        'objects': (KalturaObjectFactory.createArray, 'KalturaAccessControlProfile'), 
    }

    def fromXml(self, node):
        KalturaListResponse.fromXml(self, node)
        self.fromXmlImpl(node, KalturaAccessControlProfileListResponse.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaListResponse.toParams(self)
        kparams.put("objectType", "KalturaAccessControlProfileListResponse")
        return kparams

    def getObjects(self):
        return self.objects


# @package Kaltura
# @subpackage Client
class KalturaAccessControlServeRemoteEdgeServerAction(KalturaRuleAction):
    def __init__(self,
            type=NotImplemented,
            edgeServerIds=NotImplemented,
            seamlessFallbackEnabled=NotImplemented):
        KalturaRuleAction.__init__(self,
            type)

        # Comma separated list of edge servers playBack should be done from
        # @var string
        self.edgeServerIds = edgeServerIds

        # @var KalturaNullableBoolean
        self.seamlessFallbackEnabled = seamlessFallbackEnabled


    PROPERTY_LOADERS = {
        'edgeServerIds': getXmlNodeText, 
        'seamlessFallbackEnabled': (KalturaEnumsFactory.createInt, "KalturaNullableBoolean"), 
    }

    def fromXml(self, node):
        KalturaRuleAction.fromXml(self, node)
        self.fromXmlImpl(node, KalturaAccessControlServeRemoteEdgeServerAction.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaRuleAction.toParams(self)
        kparams.put("objectType", "KalturaAccessControlServeRemoteEdgeServerAction")
        kparams.addStringIfDefined("edgeServerIds", self.edgeServerIds)
        kparams.addIntEnumIfDefined("seamlessFallbackEnabled", self.seamlessFallbackEnabled)
        return kparams

    def getEdgeServerIds(self):
        return self.edgeServerIds

    def setEdgeServerIds(self, newEdgeServerIds):
        self.edgeServerIds = newEdgeServerIds

    def getSeamlessFallbackEnabled(self):
        return self.seamlessFallbackEnabled

    def setSeamlessFallbackEnabled(self, newSeamlessFallbackEnabled):
        self.seamlessFallbackEnabled = newSeamlessFallbackEnabled


# @package Kaltura
# @subpackage Client
class KalturaAmazonS3StorageProfile(KalturaStorageProfile):
    def __init__(self,
            id=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented,
            partnerId=NotImplemented,
            name=NotImplemented,
            systemName=NotImplemented,
            desciption=NotImplemented,
            status=NotImplemented,
            protocol=NotImplemented,
            storageUrl=NotImplemented,
            storageBaseDir=NotImplemented,
            pathPrefix=NotImplemented,
            storageUsername=NotImplemented,
            storagePassword=NotImplemented,
            storageFtpPassiveMode=NotImplemented,
            minFileSize=NotImplemented,
            maxFileSize=NotImplemented,
            flavorParamsIds=NotImplemented,
            maxConcurrentConnections=NotImplemented,
            pathManagerClass=NotImplemented,
            pathManagerParams=NotImplemented,
            trigger=NotImplemented,
            deliveryPriority=NotImplemented,
            deliveryStatus=NotImplemented,
            readyBehavior=NotImplemented,
            allowAutoDelete=NotImplemented,
            createFileLink=NotImplemented,
            rules=NotImplemented,
            deliveryProfileIds=NotImplemented,
            privateKey=NotImplemented,
            publicKey=NotImplemented,
            passPhrase=NotImplemented,
            port=NotImplemented,
            shouldExportThumbs=NotImplemented,
            packagerUrl=NotImplemented,
            exportPeriodically=NotImplemented,
            excludedFlavorParamsIds=NotImplemented,
            shouldExportCaptions=NotImplemented,
            excludedEntryTypes=NotImplemented,
            filesPermissionInS3=NotImplemented,
            s3Region=NotImplemented,
            sseType=NotImplemented,
            sseKmsKeyId=NotImplemented,
            signatureType=NotImplemented,
            endPoint=NotImplemented):
        KalturaStorageProfile.__init__(self,
            id,
            createdAt,
            updatedAt,
            partnerId,
            name,
            systemName,
            desciption,
            status,
            protocol,
            storageUrl,
            storageBaseDir,
            pathPrefix,
            storageUsername,
            storagePassword,
            storageFtpPassiveMode,
            minFileSize,
            maxFileSize,
            flavorParamsIds,
            maxConcurrentConnections,
            pathManagerClass,
            pathManagerParams,
            trigger,
            deliveryPriority,
            deliveryStatus,
            readyBehavior,
            allowAutoDelete,
            createFileLink,
            rules,
            deliveryProfileIds,
            privateKey,
            publicKey,
            passPhrase,
            port,
            shouldExportThumbs,
            packagerUrl,
            exportPeriodically,
            excludedFlavorParamsIds,
            shouldExportCaptions,
            excludedEntryTypes)

        # @var KalturaAmazonS3StorageProfileFilesPermissionLevel
        self.filesPermissionInS3 = filesPermissionInS3

        # @var string
        self.s3Region = s3Region

        # @var string
        self.sseType = sseType

        # @var string
        self.sseKmsKeyId = sseKmsKeyId

        # @var string
        self.signatureType = signatureType

        # @var string
        self.endPoint = endPoint


    PROPERTY_LOADERS = {
        'filesPermissionInS3': (KalturaEnumsFactory.createString, "KalturaAmazonS3StorageProfileFilesPermissionLevel"), 
        's3Region': getXmlNodeText, 
        'sseType': getXmlNodeText, 
        'sseKmsKeyId': getXmlNodeText, 
        'signatureType': getXmlNodeText, 
        'endPoint': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaStorageProfile.fromXml(self, node)
        self.fromXmlImpl(node, KalturaAmazonS3StorageProfile.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaStorageProfile.toParams(self)
        kparams.put("objectType", "KalturaAmazonS3StorageProfile")
        kparams.addStringEnumIfDefined("filesPermissionInS3", self.filesPermissionInS3)
        kparams.addStringIfDefined("s3Region", self.s3Region)
        kparams.addStringIfDefined("sseType", self.sseType)
        kparams.addStringIfDefined("sseKmsKeyId", self.sseKmsKeyId)
        kparams.addStringIfDefined("signatureType", self.signatureType)
        kparams.addStringIfDefined("endPoint", self.endPoint)
        return kparams

    def getFilesPermissionInS3(self):
        return self.filesPermissionInS3

    def setFilesPermissionInS3(self, newFilesPermissionInS3):
        self.filesPermissionInS3 = newFilesPermissionInS3

    def getS3Region(self):
        return self.s3Region

    def setS3Region(self, newS3Region):
        self.s3Region = newS3Region

    def getSseType(self):
        return self.sseType

    def setSseType(self, newSseType):
        self.sseType = newSseType

    def getSseKmsKeyId(self):
        return self.sseKmsKeyId

    def setSseKmsKeyId(self, newSseKmsKeyId):
        self.sseKmsKeyId = newSseKmsKeyId

    def getSignatureType(self):
        return self.signatureType

    def setSignatureType(self, newSignatureType):
        self.signatureType = newSignatureType

    def getEndPoint(self):
        return self.endPoint

    def setEndPoint(self, newEndPoint):
        self.endPoint = newEndPoint


# @package Kaltura
# @subpackage Client
class KalturaApiActionPermissionItem(KalturaPermissionItem):
    def __init__(self,
            id=NotImplemented,
            type=NotImplemented,
            partnerId=NotImplemented,
            tags=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented,
            service=NotImplemented,
            action=NotImplemented):
        KalturaPermissionItem.__init__(self,
            id,
            type,
            partnerId,
            tags,
            createdAt,
            updatedAt)

        # @var string
        self.service = service

        # @var string
        self.action = action


    PROPERTY_LOADERS = {
        'service': getXmlNodeText, 
        'action': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaPermissionItem.fromXml(self, node)
        self.fromXmlImpl(node, KalturaApiActionPermissionItem.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaPermissionItem.toParams(self)
        kparams.put("objectType", "KalturaApiActionPermissionItem")
        kparams.addStringIfDefined("service", self.service)
        kparams.addStringIfDefined("action", self.action)
        return kparams

    def getService(self):
        return self.service

    def setService(self, newService):
        self.service = newService

    def getAction(self):
        return self.action

    def setAction(self, newAction):
        self.action = newAction


# @package Kaltura
# @subpackage Client
class KalturaApiParameterPermissionItem(KalturaPermissionItem):
    def __init__(self,
            id=NotImplemented,
            type=NotImplemented,
            partnerId=NotImplemented,
            tags=NotImplemented,
            createdAt=NotImplemented,
            updatedAt=NotImplemented,
            object=NotImplemented,
            parameter=NotImplemented,
            action=NotImplemented):
        KalturaPermissionItem.__init__(self,
            id,
            type,
            partnerId,
            tags,
            createdAt,
            updatedAt)

        # @var string
        self.object = object

        # @var string
        self.parameter = parameter

        # @var KalturaApiParameterPermissionItemAction
        self.action = action


    PROPERTY_LOADERS = {
        'object': getXmlNodeText, 
        'parameter': getXmlNodeText, 
        'action': (KalturaEnumsFactory.createString, "KalturaApiParameterPermissionItemAction"), 
    }

    def fromXml(self, node):
        KalturaPermissionItem.fromXml(self, node)
        self.fromXmlImpl(node, KalturaApiParameterPermissionItem.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaPermissionItem.toParams(self)
        kparams.put("objectType", "KalturaApiParameterPermissionItem")
        kparams.addStringIfDefined("object", self.object)
        kparams.addStringIfDefined("parameter", self.parameter)
        kparams.addStringEnumIfDefined("action", self.action)
        return kparams

    def getObject(self):
        return self.object

    def setObject(self, newObject):
        self.object = newObject

    def getParameter(self):
        return self.parameter

    def setParameter(self, newParameter):
        self.parameter = newParameter

    def getAction(self):
        return self.action

    def setAction(self, newAction):
        self.action = newAction


# @package Kaltura
# @subpackage Client
class KalturaAppTokenBaseFilter(KalturaFilter):
    def __init__(self,
            orderBy=NotImplemented,
            advancedSearch=NotImplemented,
            idEqual=NotImplemented,
            idIn=NotImplemented,
            createdAtGreaterThanOrEqual=NotImplemented,
            createdAtLessThanOrEqual=NotImplemented,
            updatedAtGreaterThanOrEqual=NotImplemented,
            updatedAtLessThanOrEqual=NotImplemented,
            statusEqual=NotImplemented,
            statusIn=NotImplemented,
            sessionUserIdEqual=NotImplemented):
        KalturaFilter.__init__(self,
            orderBy,
            advancedSearch)

        # @var string
        self.idEqual = idEqual

        # @var string
        self.idIn = idIn

        # @var int
        self.createdAtGreaterThanOrEqual = createdAtGreaterThanOrEqual

        # @var int
        self.createdAtLessThanOrEqual = createdAtLessThanOrEqual

        # @var int
        self.updatedAtGreaterThanOrEqual = updatedAtGreaterThanOrEqual

        # @var int
        self.updatedAtLessThanOrEqual = updatedAtLessThanOrEqual

        # @var KalturaAppTokenStatus
        self.statusEqual = statusEqual

        # @var string
        self.statusIn = statusIn

        # @var string
        self.sessionUserIdEqual = sessionUserIdEqual


    PROPERTY_LOADERS = {
        'idEqual': getXmlNodeText, 
        'idIn': getXmlNodeText, 
        'createdAtGreaterThanOrEqual': getXmlNodeInt, 
        'createdAtLessThanOrEqual': getXmlNodeInt, 
        'updatedAtGreaterThanOrEqual': getXmlNodeInt, 
        'updatedAtLessThanOrEqual': getXmlNodeInt, 
        'statusEqual': (KalturaEnumsFactory.createInt, "KalturaAppTokenStatus"), 
        'statusIn': getXmlNodeText, 
        'sessionUserIdEqual': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaFilter.fromXml(self, node)
        self.fromXmlImpl(node, KalturaAppTokenBaseFilter.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaFilter.toParams(self)
        kparams.put("objectType", "KalturaAppTokenBaseFilter")
        kparams.addStringIfDefined("idEqual", self.idEqual)
        kparams.addStringIfDefined("idIn", self.idIn)
        kparams.addIntIfDefined("createdAtGreaterThanOrEqual", self.createdAtGreaterThanOrEqual)
        kparams.addIntIfDefined("createdAtLessThanOrEqual", self.createdAtLessThanOrEqual)
        kparams.addIntIfDefined("updatedAtGreaterThanOrEqual", self.updatedAtGreaterThanOrEqual)
        kparams.addIntIfDefined("updatedAtLessThanOrEqual", self.updatedAtLessThanOrEqual)
        kparams.addIntEnumIfDefined("statusEqual", self.statusEqual)
        kparams.addStringIfDefined("statusIn", self.statusIn)
        kparams.addStringIfDefined("sessionUserIdEqual", self.sessionUserIdEqual)
        return kparams

    def getIdEqual(self):
        return self.idEqual

    def setIdEqual(self, newIdEqual):
        self.idEqual = newIdEqual

    def getIdIn(self):
        return self.idIn

    def setIdIn(self, newIdIn):
        self.idIn = newIdIn

    def getCreatedAtGreaterThanOrEqual(self):
        return self.createdAtGreaterThanOrEqual

    def setCreatedAtGreaterThanOrEqual(self, newCreatedAtGreaterThanOrEqual):
        self.createdAtGreaterThanOrEqual = newCreatedAtGreaterThanOrEqual

    def getCreatedAtLessThanOrEqual(self):
        return self.createdAtLessThanOrEqual

    def setCreatedAtLessThanOrEqual(self, newCreatedAtLessThanOrEqual):
        self.createdAtLessThanOrEqual = newCreatedAtLessThanOrEqual

    def getUpdatedAtGreaterThanOrEqual(self):
        return self.updatedAtGreaterThanOrEqual

    def setUpdatedAtGreaterThanOrEqual(self, newUpdatedAtGreaterThanOrEqual):
        self.updatedAtGreaterThanOrEqual = newUpdatedAtGreaterThanOrEqual

    def getUpdatedAtLessThanOrEqual(self):
        return self.updatedAtLessThanOrEqual

    def setUpdatedAtLessThanOrEqual(self, newUpdatedAtLessThanOrEqual):
        self.updatedAtLessThanOrEqual = newUpdatedAtLessThanOrEqual

    def getStatusEqual(self):
        return self.statusEqual

    def setStatusEqual(self, newStatusEqual):
        self.statusEqual = newStatusEqual

    def getStatusIn(self):
        return self.statusIn

    def setStatusIn(self, newStatusIn):
        self.statusIn = newStatusIn

    def getSessionUserIdEqual(self):
        return self.sessionUserIdEqual

    def setSessionUserIdEqual(self, newSessionUserIdEqual):
        self.sessionUserIdEqual = newSessionUserIdEqual


# @package Kaltura
# @subpackage Client
class KalturaAppTokenListResponse(KalturaListResponse):
    def __init__(self,
            totalCount=NotImplemented,
            objects=NotImplemented):
        KalturaListResponse.__init__(self,
            totalCount)

        # @var array of KalturaAppToken
        # @readonly
        self.objects = objects


    PROPERTY_LOADERS = {
        'objects': (KalturaObjectFactory.createArray, 'KalturaAppToken'), 
    }

    def fromXml(self, node):
        KalturaListResponse.fromXml(self, node)
        self.fromXmlImpl(node, KalturaAppTokenListResponse.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaListResponse.toParams(self)
        kparams.put("objectType", "KalturaAppTokenListResponse")
        return kparams

    def getObjects(self):
        return self.objects


# @package Kaltura
# @subpackage Client
class KalturaAssetParamsOutput(KalturaAssetParams):
    def __init__(self,
            id=NotImplemented,
            partnerId=NotImplemented,
            name=NotImplemented,
            systemName=NotImplemented,
            description=NotImplemented,
            createdAt=NotImplemented,
            isSystemDefault=NotImplemented,
            tags=NotImplemented,
            requiredPermissions=NotImplemented,
            sourceRemoteStorageProfileId=NotImplemented,
            remoteStorageProfileIds=NotImplemented,
            mediaParserType=NotImplemented,
            sourceAssetParamsIds=NotImplemented,
            assetParamsId=NotImplemented,
            assetParamsVersion=NotImplemented,
            assetId=NotImplemented,
            assetVersion=NotImplemented,
            readyBehavior=NotImplemented,
            format=NotImplemented):
        KalturaAssetParams.__init__(self,
            id,
            partnerId,
            name,
            systemName,
            description,
            createdAt,
            isSystemDefault,
            tags,
            requiredPermissions,
            sourceRemoteStorageProfileId,
            remoteStorageProfileIds,
            mediaParserType,
            sourceAssetParamsIds)

        # @var int
        self.assetParamsId = assetParamsId

        # @var string
        self.assetParamsVersion = assetParamsVersion

        # @var string
        self.assetId = assetId

        # @var string
        self.assetVersion = assetVersion

        # @var int
        self.readyBehavior = readyBehavior

        # The container format of the Flavor Params
        # @var KalturaContainerFormat
        self.format = format


    PROPERTY_LOADERS = {
        'assetParamsId': getXmlNodeInt, 
        'assetParamsVersion': getXmlNodeText, 
        'assetId': getXmlNodeText, 
        'assetVersion': getXmlNodeText, 
        'readyBehavior': getXmlNodeInt, 
        'format': (KalturaEnumsFactory.createString, "KalturaContainerFormat"), 
    }

    def fromXml(self, node):
        KalturaAssetParams.fromXml(self, node)
        self.fromXmlImpl(node, KalturaAssetParamsOutput.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaAssetParams.toParams(self)
        kparams.put("objectType", "KalturaAssetParamsOutput")
        kparams.addIntIfDefined("assetParamsId", self.assetParamsId)
        kparams.addStringIfDefined("assetParamsVersion", self.assetParamsVersion)
        kparams.addStringIfDefined("assetId", self.assetId)
        kparams.addStringIfDefined("assetVersion", self.assetVersion)
        kparams.addIntIfDefined("readyBehavior", self.readyBehavior)
        kparams.addStringEnumIfDefined("format", self.format)
        return kparams

    def getAssetParamsId(self):
        return self.assetParamsId

    def setAssetParamsId(self, newAssetParamsId):
        self.assetParamsId = newAssetParamsId

    def getAssetParamsVersion(self):
        return self.assetParamsVersion

    def setAssetParamsVersion(self, newAssetParamsVersion):
        self.assetParamsVersion = newAssetParamsVersion

    def getAssetId(self):
        return self.assetId

    def setAssetId(self, newAssetId):
        self.assetId = newAssetId

    def getAssetVersion(self):
        return self.assetVersion

    def setAssetVersion(self, newAssetVersion):
        self.assetVersion = newAssetVersion

    def getReadyBehavior(self):
        return self.readyBehavior

    def setReadyBehavior(self, newReadyBehavior):
        self.readyBehavior = newReadyBehavior

    def getFormat(self):
        return self.format

    def setFormat(self, newFormat):
        self.format = newFormat


# @package Kaltura
# @subpackage Client
class KalturaAssetPropertiesCompareCondition(KalturaCondition):
    def __init__(self,
            type=NotImplemented,
            description=NotImplemented,
            not_=NotImplemented,
            properties=NotImplemented):
        KalturaCondition.__init__(self,
            type,
            description,
            not_)

        # Array of key/value objects that holds the property and the value to find and compare on an asset object
        # @var array of KalturaKeyValue
        self.properties = properties


    PROPERTY_LOADERS = {
        'properties': (KalturaObjectFactory.createArray, 'KalturaKeyValue'), 
    }

    def fromXml(self, node):
        KalturaCondition.fromXml(self, node)
        self.fromXmlImpl(node, KalturaAssetPropertiesCompareCondition.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaCondition.toParams(self)
        kparams.put("objectType", "KalturaAssetPropertiesCompareCondition")
        kparams.addArrayIfDefined("properties", self.properties)
        return kparams

    def getProperties(self):
        return self.properties

    def setProperties(self, newProperties):
        self.properties = newProperties


# @package Kaltura
# @subpackage Client
class KalturaAssetTypeCondition(KalturaCondition):
    def __init__(self,
            type=NotImplemented,
            description=NotImplemented,
            not_=NotImplemented,
            assetTypes=NotImplemented):
        KalturaCondition.__init__(self,
            type,
            description,
            not_)

        # @var string
        self.assetTypes = assetTypes


    PROPERTY_LOADERS = {
        'assetTypes': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaCondition.fromXml(self, node)
        self.fromXmlImpl(node, KalturaAssetTypeCondition.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaCondition.toParams(self)
        kparams.put("objectType", "KalturaAssetTypeCondition")
        kparams.addStringIfDefined("assetTypes", self.assetTypes)
        return kparams

    def getAssetTypes(self):
        return self.assetTypes

    def setAssetTypes(self, newAssetTypes):
        self.assetTypes = newAssetTypes


# @package Kaltura
# @subpackage Client
class KalturaAssetsParamsResourceContainers(KalturaResource):
    def __init__(self,
            resources=NotImplemented):
        KalturaResource.__init__(self)

        # Array of resources associated with asset params ids
        # @var array of KalturaAssetParamsResourceContainer
        self.resources = resources


    PROPERTY_LOADERS = {
        'resources': (KalturaObjectFactory.createArray, 'KalturaAssetParamsResourceContainer'), 
    }

    def fromXml(self, node):
        KalturaResource.fromXml(self, node)
        self.fromXmlImpl(node, KalturaAssetsParamsResourceContainers.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaResource.toParams(self)
        kparams.put("objectType", "KalturaAssetsParamsResourceContainers")
        kparams.addArrayIfDefined("resources", self.resources)
        return kparams

    def getResources(self):
        return self.resources

    def setResources(self, newResources):
        self.resources = newResources


# @package Kaltura
# @subpackage Client
class KalturaAttributeCondition(KalturaSearchItem):
    def __init__(self,
            value=NotImplemented):
        KalturaSearchItem.__init__(self)

        # @var string
        self.value = value


    PROPERTY_LOADERS = {
        'value': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaSearchItem.fromXml(self, node)
        self.fromXmlImpl(node, KalturaAttributeCondition.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaSearchItem.toParams(self)
        kparams.put("objectType", "KalturaAttributeCondition")
        kparams.addStringIfDefined("value", self.value)
        return kparams

    def getValue(self):
        return self.value

    def setValue(self, newValue):
        self.value = newValue


# @package Kaltura
# @subpackage Client
class KalturaAuthenticatedCondition(KalturaCondition):
    def __init__(self,
            type=NotImplemented,
            description=NotImplemented,
            not_=NotImplemented,
            privileges=NotImplemented):
        KalturaCondition.__init__(self,
            type,
            description,
            not_)

        # The privelege needed to remove the restriction
        # @var array of KalturaStringValue
        self.privileges = privileges


    PROPERTY_LOADERS = {
        'privileges': (KalturaObjectFactory.createArray, 'KalturaStringValue'), 
    }

    def fromXml(self, node):
        KalturaCondition.fromXml(self, node)
        self.fromXmlImpl(node, KalturaAuthenticatedCondition.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaCondition.toParams(self)
        kparams.put("objectType", "KalturaAuthenticatedCondition")
        kparams.addArrayIfDefined("privileges", self.privileges)
        return kparams

    def getPrivileges(self):
        return self.privileges

    def setPrivileges(self, newPrivileges):
        self.privileges = newPrivileges


# @package Kaltura
# @subpackage Client
class KalturaBaseEntryCloneOptionComponent(KalturaBaseEntryCloneOptionItem):
    def __init__(self,
            itemType=NotImplemented,
            rule=NotImplemented):
        KalturaBaseEntryCloneOptionItem.__init__(self)

        # @var KalturaBaseEntryCloneOptions
        self.itemType = itemType

        # condition rule (include/exclude)
        # @var KalturaCloneComponentSelectorType
        self.rule = rule


    PROPERTY_LOADERS = {
        'itemType': (KalturaEnumsFactory.createString, "KalturaBaseEntryCloneOptions"), 
        'rule': (KalturaEnumsFactory.createString, "KalturaCloneComponentSelectorType"), 
    }

    def fromXml(self, node):
        KalturaBaseEntryCloneOptionItem.fromXml(self, node)
        self.fromXmlImpl(node, KalturaBaseEntryCloneOptionComponent.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaBaseEntryCloneOptionItem.toParams(self)
        kparams.put("objectType", "KalturaBaseEntryCloneOptionComponent")
        kparams.addStringEnumIfDefined("itemType", self.itemType)
        kparams.addStringEnumIfDefined("rule", self.rule)
        return kparams

    def getItemType(self):
        return self.itemType

    def setItemType(self, newItemType):
        self.itemType = newItemType

    def getRule(self):
        return self.rule

    def setRule(self, newRule):
        self.rule = newRule


# @package Kaltura
# @subpackage Client
class KalturaBaseEntryListResponse(KalturaListResponse):
    def __init__(self,
            totalCount=NotImplemented,
            objects=NotImplemented):
        KalturaListResponse.__init__(self,
            totalCount)

        # @var array of KalturaBaseEntry
        # @readonly
        self.objects = objects


    PROPERTY_LOADERS = {
        'objects': (KalturaObjectFactory.createArray, 'KalturaBaseEntry'), 
    }

    def fromXml(self, node):
        KalturaListResponse.fromXml(self, node)
        self.fromXmlImpl(node, KalturaBaseEntryListResponse.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaListResponse.toParams(self)
        kparams.put("objectType", "KalturaBaseEntryListResponse")
        return kparams

    def getObjects(self):
        return self.objects


# @package Kaltura
# @subpackage Client
class KalturaBaseSyndicationFeedBaseFilter(KalturaFilter):
    def __init__(self,
            orderBy=NotImplemented,
            advancedSearch=NotImplemented):
        KalturaFilter.__init__(self,
            orderBy,
            advancedSearch)


    PROPERTY_LOADERS = {
    }

    def fromXml(self, node):
        KalturaFilter.fromXml(self, node)
        self.fromXmlImpl(node, KalturaBaseSyndicationFeedBaseFilter.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaFilter.toParams(self)
        kparams.put("objectType", "KalturaBaseSyndicationFeedBaseFilter")
        return kparams


# @package Kaltura
# @subpackage Client
class KalturaBaseSyndicationFeedListResponse(KalturaListResponse):
    def __init__(self,
            totalCount=NotImplemented,
            objects=NotImplemented):
        KalturaListResponse.__init__(self,
            totalCount)

        # @var array of KalturaBaseSyndicationFeed
        # @readonly
        self.objects = objects


    PROPERTY_LOADERS = {
        'objects': (KalturaObjectFactory.createArray, 'KalturaBaseSyndicationFeed'), 
    }

    def fromXml(self, node):
        KalturaListResponse.fromXml(self, node)
        self.fromXmlImpl(node, KalturaBaseSyndicationFeedListResponse.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaListResponse.toParams(self)
        kparams.put("objectType", "KalturaBaseSyndicationFeedListResponse")
        return kparams

    def getObjects(self):
        return self.objects


# @package Kaltura
# @subpackage Client
class KalturaBooleanEventNotificationCondition(KalturaCondition):
    def __init__(self,
            type=NotImplemented,
            description=NotImplemented,
            not_=NotImplemented,
            booleanEventNotificationIds=NotImplemented):
        KalturaCondition.__init__(self,
            type,
            description,
            not_)

        # The boolean event notification ids
        # @var string
        self.booleanEventNotificationIds = booleanEventNotificationIds


    PROPERTY_LOADERS = {
        'booleanEventNotificationIds': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaCondition.fromXml(self, node)
        self.fromXmlImpl(node, KalturaBooleanEventNotificationCondition.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaCondition.toParams(self)
        kparams.put("objectType", "KalturaBooleanEventNotificationCondition")
        kparams.addStringIfDefined("booleanEventNotificationIds", self.booleanEventNotificationIds)
        return kparams

    def getBooleanEventNotificationIds(self):
        return self.booleanEventNotificationIds

    def setBooleanEventNotificationIds(self, newBooleanEventNotificationIds):
        self.booleanEventNotificationIds = newBooleanEventNotificationIds


# @package Kaltura
# @subpackage Client
class KalturaBulkDownloadJobData(KalturaJobData):
    def __init__(self,
            entryIds=NotImplemented,
            flavorParamsId=NotImplemented,
            puserId=NotImplemented):
        KalturaJobData.__init__(self)

        # Comma separated list of entry ids
        # @var string
        self.entryIds = entryIds

        # Flavor params id to use for conversion
        # @var int
        self.flavorParamsId = flavorParamsId

        # The id of the requesting user
        # @var string
        self.puserId = puserId


    PROPERTY_LOADERS = {
        'entryIds': getXmlNodeText, 
        'flavorParamsId': getXmlNodeInt, 
        'puserId': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaJobData.fromXml(self, node)
        self.fromXmlImpl(node, KalturaBulkDownloadJobData.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaJobData.toParams(self)
        kparams.put("objectType", "KalturaBulkDownloadJobData")
        kparams.addStringIfDefined("entryIds", self.entryIds)
        kparams.addIntIfDefined("flavorParamsId", self.flavorParamsId)
        kparams.addStringIfDefined("puserId", self.puserId)
        return kparams

    def getEntryIds(self):
        return self.entryIds

    def setEntryIds(self, newEntryIds):
        self.entryIds = newEntryIds

    def getFlavorParamsId(self):
        return self.flavorParamsId

    def setFlavorParamsId(self, newFlavorParamsId):
        self.flavorParamsId = newFlavorParamsId

    def getPuserId(self):
        return self.puserId

    def setPuserId(self, newPuserId):
        self.puserId = newPuserId


# @package Kaltura
# @subpackage Client
class KalturaBulkUploadBaseFilter(KalturaFilter):
    def __init__(self,
            orderBy=NotImplemented,
            advancedSearch=NotImplemented,
            uploadedOnGreaterThanOrEqual=NotImplemented,
            uploadedOnLessThanOrEqual=NotImplemented,
            uploadedOnEqual=NotImplemented,
            statusIn=NotImplemented,
            statusEqual=NotImplemented,
            bulkUploadObjectTypeEqual=NotImplemented,
            bulkUploadObjectTypeIn=NotImplemented):
        KalturaFilter.__init__(self,
            orderBy,
            advancedSearch)

        # @var int
        self.uploadedOnGreaterThanOrEqual = uploadedOnGreaterThanOrEqual

        # @var int
        self.uploadedOnLessThanOrEqual = uploadedOnLessThanOrEqual

        # @var int
        self.uploadedOnEqual = uploadedOnEqual

        # @var string
        self.statusIn = statusIn

        # @var KalturaBatchJobStatus
        self.statusEqual = statusEqual

        # @var KalturaBulkUploadObjectType
        self.bulkUploadObjectTypeEqual = bulkUploadObjectTypeEqual

        # @var string
        self.bulkUploadObjectTypeIn = bulkUploadObjectTypeIn


    PROPERTY_LOADERS = {
        'uploadedOnGreaterThanOrEqual': getXmlNodeInt, 
        'uploadedOnLessThanOrEqual': getXmlNodeInt, 
        'uploadedOnEqual': getXmlNodeInt, 
        'statusIn': getXmlNodeText, 
        'statusEqual': (KalturaEnumsFactory.createInt, "KalturaBatchJobStatus"), 
        'bulkUploadObjectTypeEqual': (KalturaEnumsFactory.createString, "KalturaBulkUploadObjectType"), 
        'bulkUploadObjectTypeIn': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaFilter.fromXml(self, node)
        self.fromXmlImpl(node, KalturaBulkUploadBaseFilter.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaFilter.toParams(self)
        kparams.put("objectType", "KalturaBulkUploadBaseFilter")
        kparams.addIntIfDefined("uploadedOnGreaterThanOrEqual", self.uploadedOnGreaterThanOrEqual)
        kparams.addIntIfDefined("uploadedOnLessThanOrEqual", self.uploadedOnLessThanOrEqual)
        kparams.addIntIfDefined("uploadedOnEqual", self.uploadedOnEqual)
        kparams.addStringIfDefined("statusIn", self.statusIn)
        kparams.addIntEnumIfDefined("statusEqual", self.statusEqual)
        kparams.addStringEnumIfDefined("bulkUploadObjectTypeEqual", self.bulkUploadObjectTypeEqual)
        kparams.addStringIfDefined("bulkUploadObjectTypeIn", self.bulkUploadObjectTypeIn)
        return kparams

    def getUploadedOnGreaterThanOrEqual(self):
        return self.uploadedOnGreaterThanOrEqual

    def setUploadedOnGreaterThanOrEqual(self, newUploadedOnGreaterThanOrEqual):
        self.uploadedOnGreaterThanOrEqual = newUploadedOnGreaterThanOrEqual

    def getUploadedOnLessThanOrEqual(self):
        return self.uploadedOnLessThanOrEqual

    def setUploadedOnLessThanOrEqual(self, newUploadedOnLessThanOrEqual):
        self.uploadedOnLessThanOrEqual = newUploadedOnLessThanOrEqual

    def getUploadedOnEqual(self):
        return self.uploadedOnEqual

    def setUploadedOnEqual(self, newUploadedOnEqual):
        self.uploadedOnEqual = newUploadedOnEqual

    def getStatusIn(self):
        return self.statusIn

    def setStatusIn(self, newStatusIn):
        self.statusIn = newStatusIn

    def getStatusEqual(self):
        return self.statusEqual

    def setStatusEqual(self, newStatusEqual):
        self.statusEqual = newStatusEqual

    def getBulkUploadObjectTypeEqual(self):
        return self.bulkUploadObjectTypeEqual

    def setBulkUploadObjectTypeEqual(self, newBulkUploadObjectTypeEqual):
        self.bulkUploadObjectTypeEqual = newBulkUploadObjectTypeEqual

    def getBulkUploadObjectTypeIn(self):
        return self.bulkUploadObjectTypeIn

    def setBulkUploadObjectTypeIn(self, newBulkUploadObjectTypeIn):
        self.bulkUploadObjectTypeIn = newBulkUploadObjectTypeIn


# @package Kaltura
# @subpackage Client
class KalturaBulkUploadCategoryData(KalturaBulkUploadObjectData):
    """This class represents object-specific data passed to the 
     bulk upload job."""

    def __init__(self):
        KalturaBulkUploadObjectData.__init__(self)


    PROPERTY_LOADERS = {
    }

    def fromXml(self, node):
        KalturaBulkUploadObjectData.fromXml(self, node)
        self.fromXmlImpl(node, KalturaBulkUploadCategoryData.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaBulkUploadObjectData.toParams(self)
        kparams.put("objectType", "KalturaBulkUploadCategoryData")
        return kparams


# @package Kaltura
# @subpackage Client
class KalturaBulkUploadCategoryEntryData(KalturaBulkUploadObjectData):
    """This class represents object-specific data passed to the 
     bulk upload job."""

    def __init__(self):
        KalturaBulkUploadObjectData.__init__(self)


    PROPERTY_LOADERS = {
    }

    def fromXml(self, node):
        KalturaBulkUploadObjectData.fromXml(self, node)
        self.fromXmlImpl(node, KalturaBulkUploadCategoryEntryData.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaBulkUploadObjectData.toParams(self)
        kparams.put("objectType", "KalturaBulkUploadCategoryEntryData")
        return kparams


# @package Kaltura
# @subpackage Client
class KalturaBulkUploadCategoryUserData(KalturaBulkUploadObjectData):
    """This class represents object-specific data passed to the 
     bulk upload job."""

    def __init__(self):
        KalturaBulkUploadObjectData.__init__(self)


    PROPERTY_LOADERS = {
    }

    def fromXml(self, node):
        KalturaBulkUploadObjectData.fromXml(self, node)
        self.fromXmlImpl(node, KalturaBulkUploadCategoryUserData.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaBulkUploadObjectData.toParams(self)
        kparams.put("objectType", "KalturaBulkUploadCategoryUserData")
        return kparams


# @package Kaltura
# @subpackage Client
class KalturaBulkUploadEntryData(KalturaBulkUploadObjectData):
    """This class represents object-specific data passed to the 
     bulk upload job."""

    def __init__(self,
            conversionProfileId=NotImplemented):
        KalturaBulkUploadObjectData.__init__(self)

        # Selected profile id for all bulk entries
        # @var int
        self.conversionProfileId = conversionProfileId


    PROPERTY_LOADERS = {
        'conversionProfileId': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaBulkUploadObjectData.fromXml(self, node)
        self.fromXmlImpl(node, KalturaBulkUploadEntryData.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaBulkUploadObjectData.toParams(self)
        kparams.put("objectType", "KalturaBulkUploadEntryData")
        kparams.addIntIfDefined("conversionProfileId", self.conversionProfileId)
        return kparams

    def getConversionProfileId(self):
        return self.conversionProfileId

    def setConversionProfileId(self, newConversionProfileId):
        self.conversionProfileId = newConversionProfileId


# @package Kaltura
# @subpackage Client
class KalturaBulkUploadJobData(KalturaJobData):
    def __init__(self,
            userId=NotImplemented,
            uploadedBy=NotImplemented,
            conversionProfileId=NotImplemented,
            resultsFileLocalPath=NotImplemented,
            resultsFileUrl=NotImplemented,
            numOfEntries=NotImplemented,
            numOfObjects=NotImplemented,
            filePath=NotImplemented,
            bulkUploadObjectType=NotImplemented,
            fileName=NotImplemented,
            objectData=NotImplemented,
            type=NotImplemented,
            emailRecipients=NotImplemented,
            numOfErrorObjects=NotImplemented,
            privileges=NotImplemented):
        KalturaJobData.__init__(self)

        # @var string
        # @readonly
        self.userId = userId

        # The screen name of the user
        # @var string
        # @readonly
        self.uploadedBy = uploadedBy

        # Selected profile id for all bulk entries
        # @var int
        # @readonly
        self.conversionProfileId = conversionProfileId

        # Created by the API
        # @var string
        # @readonly
        self.resultsFileLocalPath = resultsFileLocalPath

        # Created by the API
        # @var string
        # @readonly
        self.resultsFileUrl = resultsFileUrl

        # Number of created entries
        # @var int
        # @readonly
        self.numOfEntries = numOfEntries

        # Number of created objects
        # @var int
        # @readonly
        self.numOfObjects = numOfObjects

        # The bulk upload file path
        # @var string
        # @readonly
        self.filePath = filePath

        # Type of object for bulk upload
        # @var KalturaBulkUploadObjectType
        # @readonly
        self.bulkUploadObjectType = bulkUploadObjectType

        # Friendly name of the file, used to be recognized later in the logs.
        # @var string
        self.fileName = fileName

        # Data pertaining to the objects being uploaded
        # @var KalturaBulkUploadObjectData
        # @readonly
        self.objectData = objectData

        # Type of bulk upload
        # @var KalturaBulkUploadType
        # @readonly
        self.type = type

        # Recipients of the email for bulk upload success/failure
        # @var string
        self.emailRecipients = emailRecipients

        # Number of objects that finished on error status
        # @var int
        self.numOfErrorObjects = numOfErrorObjects

        # privileges for the job
        # @var string
        self.privileges = privileges


    PROPERTY_LOADERS = {
        'userId': getXmlNodeText, 
        'uploadedBy': getXmlNodeText, 
        'conversionProfileId': getXmlNodeInt, 
        'resultsFileLocalPath': getXmlNodeText, 
        'resultsFileUrl': getXmlNodeText, 
        'numOfEntries': getXmlNodeInt, 
        'numOfObjects': getXmlNodeInt, 
        'filePath': getXmlNodeText, 
        'bulkUploadObjectType': (KalturaEnumsFactory.createString, "KalturaBulkUploadObjectType"), 
        'fileName': getXmlNodeText, 
        'objectData': (KalturaObjectFactory.create, 'KalturaBulkUploadObjectData'), 
        'type': (KalturaEnumsFactory.createString, "KalturaBulkUploadType"), 
        'emailRecipients': getXmlNodeText, 
        'numOfErrorObjects': getXmlNodeInt, 
        'privileges': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaJobData.fromXml(self, node)
        self.fromXmlImpl(node, KalturaBulkUploadJobData.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaJobData.toParams(self)
        kparams.put("objectType", "KalturaBulkUploadJobData")
        kparams.addStringIfDefined("fileName", self.fileName)
        kparams.addStringIfDefined("emailRecipients", self.emailRecipients)
        kparams.addIntIfDefined("numOfErrorObjects", self.numOfErrorObjects)
        kparams.addStringIfDefined("privileges", self.privileges)
        return kparams

    def getUserId(self):
        return self.userId

    def getUploadedBy(self):
        return self.uploadedBy

    def getConversionProfileId(self):
        return self.conversionProfileId

    def getResultsFileLocalPath(self):
        return self.resultsFileLocalPath

    def getResultsFileUrl(self):
        return self.resultsFileUrl

    def getNumOfEntries(self):
        return self.numOfEntries

    def getNumOfObjects(self):
        return self.numOfObjects

    def getFilePath(self):
        return self.filePath

    def getBulkUploadObjectType(self):
        return self.bulkUploadObjectType

    def getFileName(self):
        return self.fileName

    def setFileName(self, newFileName):
        self.fileName = newFileName

    def getObjectData(self):
        return self.objectData

    def getType(self):
        return self.type

    def getEmailRecipients(self):
        return self.emailRecipients

    def setEmailRecipients(self, newEmailRecipients):
        self.emailRecipients = newEmailRecipients

    def getNumOfErrorObjects(self):
        return self.numOfErrorObjects

    def setNumOfErrorObjects(self, newNumOfErrorObjects):
        self.numOfErrorObjects = newNumOfErrorObjects

    def getPrivileges(self):
        return self.privileges

    def setPrivileges(self, newPrivileges):
        self.privileges = newPrivileges


# @package Kaltura
# @subpackage Client
class KalturaBulkUploadListResponse(KalturaListResponse):
    def __init__(self,
            totalCount=NotImplemented,
            objects=NotImplemented):
        KalturaListResponse.__init__(self,
            totalCount)

        # @var array of KalturaBulkUpload
        # @readonly
        self.objects = objects


    PROPERTY_LOADERS = {
        'objects': (KalturaObjectFactory.createArray, 'KalturaBulkUpload'), 
    }

    def fromXml(self, node):
        KalturaListResponse.fromXml(self, node)
        self.fromXmlImpl(node, KalturaBulkUploadListResponse.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaListResponse.toParams(self)
        kparams.put("objectType", "KalturaBulkUploadListResponse")
        return kparams

    def getObjects(self):
        return self.objects


# @package Kaltura
# @subpackage Client
class KalturaBulkUploadResultCategory(KalturaBulkUploadResult):
    def __init__(self,
            id=NotImplemented,
            bulkUploadJobId=NotImplemented,
            lineIndex=NotImplemented,
            partnerId=NotImplemented,
            status=NotImplemented,
            action=NotImplemented,
            objectId=NotImplemented,
            objectStatus=NotImplemented,
            bulkUploadResultObjectType=NotImplemented,
            rowData=NotImplemented,
            partnerData=NotImplemented,
            objectErrorDescription=NotImplemented,
            pluginsData=NotImplemented,
            errorDescription=NotImplemented,
            errorCode=NotImplemented,
            errorType=NotImplemented,
            relativePath=NotImplemented,
            name=NotImplemented,
            referenceId=NotImplemented,
            description=NotImplemented,
            tags=NotImplemented,
            appearInList=NotImplemented,
            privacy=NotImplemented,
            inheritanceType=NotImplemented,
            userJoinPolicy=NotImplemented,
            defaultPermissionLevel=NotImplemented,
            owner=NotImplemented,
            contributionPolicy=NotImplemented,
            partnerSortValue=NotImplemented,
            moderation=NotImplemented):
        KalturaBulkUploadResult.__init__(self,
            id,
            bulkUploadJobId,
            lineIndex,
            partnerId,
            status,
            action,
            objectId,
            objectStatus,
            bulkUploadResultObjectType,
            rowData,
            partnerData,
            objectErrorDescription,
            pluginsData,
            errorDescription,
            errorCode,
            errorType)

        # @var string
        self.relativePath = relativePath

        # @var string
        self.name = name

        # @var string
        self.referenceId = referenceId

        # @var string
        self.description = description

        # @var string
        self.tags = tags

        # @var int
        self.appearInList = appearInList

        # @var int
        self.privacy = privacy

        # @var int
        self.inheritanceType = inheritanceType

        # @var int
        self.userJoinPolicy = userJoinPolicy

        # @var int
        self.defaultPermissionLevel = defaultPermissionLevel

        # @var string
        self.owner = owner

        # @var int
        self.contributionPolicy = contributionPolicy

        # @var int
        self.partnerSortValue = partnerSortValue

        # @var bool
        self.moderation = moderation


    PROPERTY_LOADERS = {
        'relativePath': getXmlNodeText, 
        'name': getXmlNodeText, 
        'referenceId': getXmlNodeText, 
        'description': getXmlNodeText, 
        'tags': getXmlNodeText, 
        'appearInList': getXmlNodeInt, 
        'privacy': getXmlNodeInt, 
        'inheritanceType': getXmlNodeInt, 
        'userJoinPolicy': getXmlNodeInt, 
        'defaultPermissionLevel': getXmlNodeInt, 
        'owner': getXmlNodeText, 
        'contributionPolicy': getXmlNodeInt, 
        'partnerSortValue': getXmlNodeInt, 
        'moderation': getXmlNodeBool, 
    }

    def fromXml(self, node):
        KalturaBulkUploadResult.fromXml(self, node)
        self.fromXmlImpl(node, KalturaBulkUploadResultCategory.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaBulkUploadResult.toParams(self)
        kparams.put("objectType", "KalturaBulkUploadResultCategory")
        kparams.addStringIfDefined("relativePath", self.relativePath)
        kparams.addStringIfDefined("name", self.name)
        kparams.addStringIfDefined("referenceId", self.referenceId)
        kparams.addStringIfDefined("description", self.description)
        kparams.addStringIfDefined("tags", self.tags)
        kparams.addIntIfDefined("appearInList", self.appearInList)
        kparams.addIntIfDefined("privacy", self.privacy)
        kparams.addIntIfDefined("inheritanceType", self.inheritanceType)
        kparams.addIntIfDefined("userJoinPolicy", self.userJoinPolicy)
        kparams.addIntIfDefined("defaultPermissionLevel", self.defaultPermissionLevel)
        kparams.addStringIfDefined("owner", self.owner)
        kparams.addIntIfDefined("contributionPolicy", self.contributionPolicy)
        kparams.addIntIfDefined("partnerSortValue", self.partnerSortValue)
        kparams.addBoolIfDefined("moderation", self.moderation)
        return kparams

    def getRelativePath(self):
        return self.relativePath

    def setRelativePath(self, newRelativePath):
        self.relativePath = newRelativePath

    def getName(self):
        return self.name

    def setName(self, newName):
        self.name = newName

    def getReferenceId(self):
        return self.referenceId

    def setReferenceId(self, newReferenceId):
        self.referenceId = newReferenceId

    def getDescription(self):
        return self.description

    def setDescription(self, newDescription):
        self.description = newDescription

    def getTags(self):
        return self.tags

    def setTags(self, newTags):
        self.tags = newTags

    def getAppearInList(self):
        return self.appearInList

    def setAppearInList(self, newAppearInList):
        self.appearInList = newAppearInList

    def getPrivacy(self):
        return self.privacy

    def setPrivacy(self, newPrivacy):
        self.privacy = newPrivacy

    def getInheritanceType(self):
        return self.inheritanceType

    def setInheritanceType(self, newInheritanceType):
        self.inheritanceType = newInheritanceType

    def getUserJoinPolicy(self):
        return self.userJoinPolicy

    def setUserJoinPolicy(self, newUserJoinPolicy):
        self.userJoinPolicy = newUserJoinPolicy

    def getDefaultPermissionLevel(self):
        return self.defaultPermissionLevel

    def setDefaultPermissionLevel(self, newDefaultPermissionLevel):
        self.defaultPermissionLevel = newDefaultPermissionLevel

    def getOwner(self):
        return self.owner

    def setOwner(self, newOwner):
        self.owner = newOwner

    def getContributionPolicy(self):
        return self.contributionPolicy

    def setContributionPolicy(self, newContributionPolicy):
        self.contributionPolicy = newContributionPolicy

    def getPartnerSortValue(self):
        return self.partnerSortValue

    def setPartnerSortValue(self, newPartnerSortValue):
        self.partnerSortValue = newPartnerSortValue

    def getModeration(self):
        return self.moderation

    def setModeration(self, newModeration):
        self.moderation = newModeration


# @package Kaltura
# @subpackage Client
class KalturaBulkUploadResultCategoryEntry(KalturaBulkUploadResult):
    def __init__(self,
            id=NotImplemented,
            bulkUploadJobId=NotImplemented,
            lineIndex=NotImplemented,
            partnerId=NotImplemented,
            status=NotImplemented,
            action=NotImplemented,
            objectId=NotImplemented,
            objectStatus=NotImplemented,
            bulkUploadResultObjectType=NotImplemented,
            rowData=NotImplemented,
            partnerData=NotImplemented,
            objectErrorDescription=NotImplemented,
            pluginsData=NotImplemented,
            errorDescription=NotImplemented,
            errorCode=NotImplemented,
            errorType=NotImplemented,
            categoryId=NotImplemented,
            entryId=NotImplemented):
        KalturaBulkUploadResult.__init__(self,
            id,
            bulkUploadJobId,
            lineIndex,
            partnerId,
            status,
            action,
            objectId,
            objectStatus,
            bulkUploadResultObjectType,
            rowData,
            partnerData,
            objectErrorDescription,
            pluginsData,
            errorDescription,
            errorCode,
            errorType)

        # @var int
        self.categoryId = categoryId

        # @var string
        self.entryId = entryId


    PROPERTY_LOADERS = {
        'categoryId': getXmlNodeInt, 
        'entryId': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaBulkUploadResult.fromXml(self, node)
        self.fromXmlImpl(node, KalturaBulkUploadResultCategoryEntry.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaBulkUploadResult.toParams(self)
        kparams.put("objectType", "KalturaBulkUploadResultCategoryEntry")
        kparams.addIntIfDefined("categoryId", self.categoryId)
        kparams.addStringIfDefined("entryId", self.entryId)
        return kparams

    def getCategoryId(self):
        return self.categoryId

    def setCategoryId(self, newCategoryId):
        self.categoryId = newCategoryId

    def getEntryId(self):
        return self.entryId

    def setEntryId(self, newEntryId):
        self.entryId = newEntryId


# @package Kaltura
# @subpackage Client
class KalturaBulkUploadResultCategoryUser(KalturaBulkUploadResult):
    def __init__(self,
            id=NotImplemented,
            bulkUploadJobId=NotImplemented,
            lineIndex=NotImplemented,
            partnerId=NotImplemented,
            status=NotImplemented,
            action=NotImplemented,
            objectId=NotImplemented,
            objectStatus=NotImplemented,
            bulkUploadResultObjectType=NotImplemented,
            rowData=NotImplemented,
            partnerData=NotImplemented,
            objectErrorDescription=NotImplemented,
            pluginsData=NotImplemented,
            errorDescription=NotImplemented,
            errorCode=NotImplemented,
            errorType=NotImplemented,
            categoryId=NotImplemented,
            categoryReferenceId=NotImplemented,
            userId=NotImplemented,
            permissionLevel=NotImplemented,
            updateMethod=NotImplemented,
            requiredObjectStatus=NotImplemented):
        KalturaBulkUploadResult.__init__(self,
            id,
            bulkUploadJobId,
            lineIndex,
            partnerId,
            status,
            action,
            objectId,
            objectStatus,
            bulkUploadResultObjectType,
            rowData,
            partnerData,
            objectErrorDescription,
            pluginsData,
            errorDescription,
            errorCode,
            errorType)

        # @var int
        self.categoryId = categoryId

        # @var string
        self.categoryReferenceId = categoryReferenceId

        # @var string
        self.userId = userId

        # @var int
        self.permissionLevel = permissionLevel

        # @var int
        self.updateMethod = updateMethod

        # @var int
        self.requiredObjectStatus = requiredObjectStatus


    PROPERTY_LOADERS = {
        'categoryId': getXmlNodeInt, 
        'categoryReferenceId': getXmlNodeText, 
        'userId': getXmlNodeText, 
        'permissionLevel': getXmlNodeInt, 
        'updateMethod': getXmlNodeInt, 
        'requiredObjectStatus': getXmlNodeInt, 
    }

    def fromXml(self, node):
        KalturaBulkUploadResult.fromXml(self, node)
        self.fromXmlImpl(node, KalturaBulkUploadResultCategoryUser.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaBulkUploadResult.toParams(self)
        kparams.put("objectType", "KalturaBulkUploadResultCategoryUser")
        kparams.addIntIfDefined("categoryId", self.categoryId)
        kparams.addStringIfDefined("categoryReferenceId", self.categoryReferenceId)
        kparams.addStringIfDefined("userId", self.userId)
        kparams.addIntIfDefined("permissionLevel", self.permissionLevel)
        kparams.addIntIfDefined("updateMethod", self.updateMethod)
        kparams.addIntIfDefined("requiredObjectStatus", self.requiredObjectStatus)
        return kparams

    def getCategoryId(self):
        return self.categoryId

    def setCategoryId(self, newCategoryId):
        self.categoryId = newCategoryId

    def getCategoryReferenceId(self):
        return self.categoryReferenceId

    def setCategoryReferenceId(self, newCategoryReferenceId):
        self.categoryReferenceId = newCategoryReferenceId

    def getUserId(self):
        return self.userId

    def setUserId(self, newUserId):
        self.userId = newUserId

    def getPermissionLevel(self):
        return self.permissionLevel

    def setPermissionLevel(self, newPermissionLevel):
        self.permissionLevel = newPermissionLevel

    def getUpdateMethod(self):
        return self.updateMethod

    def setUpdateMethod(self, newUpdateMethod):
        self.updateMethod = newUpdateMethod

    def getRequiredObjectStatus(self):
        return self.requiredObjectStatus

    def setRequiredObjectStatus(self, newRequiredObjectStatus):
        self.requiredObjectStatus = newRequiredObjectStatus


# @package Kaltura
# @subpackage Client
class KalturaBulkUploadResultEntry(KalturaBulkUploadResult):
    def __init__(self,
            id=NotImplemented,
            bulkUploadJobId=NotImplemented,
            lineIndex=NotImplemented,
            partnerId=NotImplemented,
            status=NotImplemented,
            action=NotImplemented,
            objectId=NotImplemented,
            objectStatus=NotImplemented,
            bulkUploadResultObjectType=NotImplemented,
            rowData=NotImplemented,
            partnerData=NotImplemented,
            objectErrorDescription=NotImplemented,
            pluginsData=NotImplemented,
            errorDescription=NotImplemented,
            errorCode=NotImplemented,
            errorType=NotImplemented,
            entryId=NotImplemented,
            title=NotImplemented,
            description=NotImplemented,
            tags=NotImplemented,
            url=NotImplemented,
            contentType=NotImplemented,
            conversionProfileId=NotImplemented,
            accessControlProfileId=NotImplemented,
            category=NotImplemented,
            scheduleStartDate=NotImplemented,
            scheduleEndDate=NotImplemented,
            entryStatus=NotImplemented,
            thumbnailUrl=NotImplemented,
            thumbnailSaved=NotImplemented,
            sshPrivateKey=NotImplemented,
            sshPublicKey=NotImplemented,
            sshKeyPassphrase=NotImplemented,
            creatorId=NotImplemented,
            entitledUsersEdit=NotImplemented,
            entitledUsersPublish=NotImplemented,
            ownerId=NotImplemented,
            referenceId=NotImplemented,
            templateEntryId=NotImplemented):
        KalturaBulkUploadResult.__init__(self,
            id,
            bulkUploadJobId,
            lineIndex,
            partnerId,
            status,
            action,
            objectId,
            objectStatus,
            bulkUploadResultObjectType,
            rowData,
            partnerData,
            objectErrorDescription,
            pluginsData,
            errorDescription,
            errorCode,
            errorType)

        # @var string
        self.entryId = entryId

        # @var string
        self.title = title

        # @var string
        self.description = description

        # @var string
        self.tags = tags

        # @var string
        self.url = url

        # @var string
        self.contentType = contentType

        # @var int
        self.conversionProfileId = conversionProfileId

        # @var int
        self.accessControlProfileId = accessControlProfileId

        # @var string
        self.category = category

        # @var int
        self.scheduleStartDate = scheduleStartDate

        # @var int
        self.scheduleEndDate = scheduleEndDate

        # @var int
        self.entryStatus = entryStatus

        # @var string
        self.thumbnailUrl = thumbnailUrl

        # @var bool
        self.thumbnailSaved = thumbnailSaved

        # @var string
        self.sshPrivateKey = sshPrivateKey

        # @var string
        self.sshPublicKey = sshPublicKey

        # @var string
        self.sshKeyPassphrase = sshKeyPassphrase

        # @var string
        self.creatorId = creatorId

        # @var string
        self.entitledUsersEdit = entitledUsersEdit

        # @var string
        self.entitledUsersPublish = entitledUsersPublish

        # @var string
        self.ownerId = ownerId

        # @var string
        self.referenceId = referenceId

        # @var string
        self.templateEntryId = templateEntryId


    PROPERTY_LOADERS = {
        'entryId': getXmlNodeText, 
        'title': getXmlNodeText, 
        'description': getXmlNodeText, 
        'tags': getXmlNodeText, 
        'url': getXmlNodeText, 
        'contentType': getXmlNodeText, 
        'conversionProfileId': getXmlNodeInt, 
        'accessControlProfileId': getXmlNodeInt, 
        'category': getXmlNodeText, 
        'scheduleStartDate': getXmlNodeInt, 
        'scheduleEndDate': getXmlNodeInt, 
        'entryStatus': getXmlNodeInt, 
        'thumbnailUrl': getXmlNodeText, 
        'thumbnailSaved': getXmlNodeBool, 
        'sshPrivateKey': getXmlNodeText, 
        'sshPublicKey': getXmlNodeText, 
        'sshKeyPassphrase': getXmlNodeText, 
        'creatorId': getXmlNodeText, 
        'entitledUsersEdit': getXmlNodeText, 
        'entitledUsersPublish': getXmlNodeText, 
        'ownerId': getXmlNodeText, 
        'referenceId': getXmlNodeText, 
        'templateEntryId': getXmlNodeText, 
    }

    def fromXml(self, node):
        KalturaBulkUploadResult.fromXml(self, node)
        self.fromXmlImpl(node, KalturaBulkUploadResultEntry.PROPERTY_LOADERS)

    def toParams(self):
        kparams = KalturaBulkUploadResult.toParams(self)
        kparams.put("objectType", "KalturaBulkUploadResultEntry")
        kparams.addStringIfDefined("entryId", self.entryId)
        kparams.addStringIfDefined("title", self.title)
        kparams.addStringIfDefined("description", self.description)
        kparams.addStringIfDefined("tags", self.tags)
        kparams.addStringIfDefined("url", self.url)
        kparams.addStringIfDefined("contentType", self.contentType)
        kparams.addIntIfDefined("conversionProfileId", self.conversionProfileId)
        kparams.addIntIfDefined("accessControlProfileId", self.accessControlProfileId)
        kparams.addStringIfDefined("category", self.category)
        kparams.addIntIfDefined("scheduleStartDate", self.scheduleStartDate)
        kparams.addIntIfDefined("scheduleEndDate", self.scheduleEndDate)
        kparams.addIntIfDefined("entryStatus", self.entryStatus)
        kparams.addStringIfDefined("thumbnailUrl", self.thumbnailUrl)
        kparams.addBoolIfDefined("thumbnailSaved", self.thumbnailSaved)
        kparams.addStringIfDefined("sshPrivateKey", self.sshPrivateKey)
        kparams.addStringIfDefined("sshPublicKey", self.sshPublicKey)
        kparams.addStringIfDefined("sshKeyPassphrase", self.sshKeyPassphrase)
        kparams.addStringIfDefined("creatorId", self.creatorId)
        kparams.addStringIfDefined("entitledUsersEdit", self.entitledUsersEdit)
        kparams.addStringIfDefined("entitledUsersPublish", self.entitledUsersPublish)
        kparams.addStringIfDefined("ownerId", self.ownerId)
        kparams.addStringIfDefined("referenceId", self.referenceId)
        kparams.addStringIfDefined("templateEntryId", self.templateEntryId)
        return kparams

    def getEntryId(self):
        return self.entryId

    def setEntryId(self, newEntryId):
        self.entryId = newEntryId

    def getTitle(self):
        return self.title

    def setTitle(self, newTitle):
        self.title = newTitle

    def getDescription(self):
        return self.description

    def setDescription(self, newDescription):
        self.description = newDescription

    def getTags(self):
        return self.tags

    def setTags(self, newTags):
        self.tags = newTags

    def getUrl(self):
        return self.url

    def setUrl(self, newUrl):
        self.url = newUrl

    def getContentType(self):
        return self.contentType

    def setContentType(self, newContentType):
        self.contentType = newContentType

    def getConversionProfileId(self):
        return self.conversionProfileId

    def setConversionProfileId(self, newConversionProfileId):
        self.conversionProfileId = newConversionProfileId

    def getAccessControlProfileId(self):
        return self.accessControlProfileId

    def setAccessControlProfileId(self, newAccessControlProfileId):
        self.accessControlProfileId = newAccessControlProfileId

    def getCategory(self):
        return self.category

    def setCategory(self, newCategory):
        self.category = newCategory

    def getScheduleStartDate(self):
        return self.scheduleStartDate

    def setScheduleStartDate(self, newScheduleStartDate):
        self.scheduleStartDate = newScheduleStartDate

    def getScheduleEndDate(self):
        return self.scheduleEndDate

    def setScheduleEndDate(self, newScheduleEndDate):
        self.scheduleEndDate = newScheduleEndDate

    def getEntryStatus(self):
        return self.entryStatus

    def setEntryStatus(self, newEntryStatus):
        self.entryStatus = newEntryStatus

    def getThumbnailUrl(self):
        return self.thumbnailUrl

    def setThumbnailUrl(self, newThumbnailUrl):
        self.thumbnailUrl = newThumbnailUrl

    def getThumbnailSaved(self):
        return self.thumbnailSaved

    def setThumbnailSaved(self, newThumbnailSaved):
        self.thumbnailSaved = newThumbnailSaved

    def getSshPrivateKey(self):
        return self.sshPrivateKey

    def setSshPrivateKey(self, newSshPrivateKey):
        self.sshPrivateKey = newSshPrivateKey

    def getSshPublicKey(self):
        return self.sshPublicKey

    def setSshPublicKey(self, newSshPublicKey):
        self.sshPublicKey = newSshPublicKey

    def getSshKeyPassphrase(self):
        return self.sshKeyPassphrase

    def setSshKeyPassphrase(self, newSshKeyPassphrase):
        self.sshKeyPassphrase = newSshKeyPassphrase

    def getCreatorId(self):
        return self.creatorId

    def setCreatorId(self, newCreatorId):
        self.creatorId = newCreatorId

    def getEntitledUsersEdit(self):
        return self.entitledUsersEdit

    def setEntitledUsersEdit(self, newEntitledUsersEdit):
        self.entitledUsersEdit = newEntitledUsersEdit

    def getEntitledUsersPublish(self):
        return self.entitledUsersPublish

    def setEntitledUsersPublish(self, newEntitledUsersPublish):
        self.entitledUsersPublish = newEntitledUsersPublish

    def getOwnerId(self):
        return self.ownerId

    def setOwnerId(self, newOwnerId):
        self.ownerId = newOwnerId

    def getReferenceId(self):
        return self.referenceId

    def setReferenceId(self, newReferenceId):
        self.referenceId = newReferenceId

    def getTemplateEntryId(self):
        return self.templateEntryId

    def setTemplateEntryId(self, newTemplateEntryId):
        self.templateEntryId = newTemplateEntryId


# @package Kaltura
# @subpackage Client
class KalturaBulkUploadResultUser(KalturaBulkUploadResult):
    def __init__(self,
            id=NotImplemented,
            bulkUploadJobId=NotImplemented,
            lineIndex=NotImplemented,
            partnerId=NotImplemented,
            status=NotImplemented,
            action=NotImplemented,
            objectId=NotImplemented,
            objectStatus=NotImplemented,
            bulkUploadResultObjectType=NotImplemented,
            rowData=NotImplemented,
            partnerData=NotImplemented,
            objectErrorDescription=NotImplemented,
            pluginsData=NotImplemented,
            errorDescription=NotImplemented,
            errorCode=NotImplemented,
            errorType=NotImplemented,
            userId=NotImplemented,
            screenName=NotImplemented,
            email=NotImplemented,
            description=NotImplemented,
            tags=NotImplemented,
            dateOfBirth=NotImplemented,
            country=NotImplemented,
            state=NotImplemented,
            city=NotImplemented,
            zip=NotImplemented,
            gender=NotImplemented,
            firstName=NotImplemented,
            lastName=NotImplemented,
            group=NotImplemented):
        KalturaBulkUploadResult.__init__(self,
            id,
            bulkUploadJobId,
            lineIndex,
            partnerId,
            status,
            action,
            objectId,
            objectStatus,
            bulkUploadResultObjectType,
            rowData,
            partnerData,
            objectErrorDescription,
            pluginsData,
            errorDescription,
            errorCode,
            errorType)

        # @var string
        self.userId = userId

        # @var string
        self.screenName = screenName

        # @var string
        self.email = email

        # @var string
        self.description = description

        # @var string
        self.tags = tags

        # @var int
        self.dateOfBirth = dateOfBirth

        # @var string
        self.country = country

        # @var string
        self.state = state

        # @var string
        self.city = city

        # @var string
        self.zip = zip

        # @var int
        self.gender = gender

        # @var string
        self.firstName = firstName

        # @var string
        self.lastName = lastName

        # @var string
        self.group = group


    PROPERTY_LOADERS = {
        'userId': getXmlNodeText, 
        'screenName': getXmlNo