# Pipeline-Normalizer

### Persian normalizer implemented with Space

### Installation:
pip install mofid-normalizer==0.3.0
### requierment:

- hazm == 0.7.0
- nltk == 3.3 
- num2fawords == 1.1
- spacy >= 3.0.6
- googledrivedownloader

### Pipelines
- char_normalizer
- spell_checker
- date2str
- time2str
- num2str
- abbreviation2word
- affix2norm
- punctuation_remover
- word_level_tokenizer

### Usage

```
>>> from spacy_loader import nlp
>>> with nlp.select_pipes(enable=["char_normalizer"]):
    print(nlp("اﯙ ایراني ٲست"))
>>>او ایرانی است

>>> with nlp.select_pipes(enable=["num2str"]):
        print(nlp("من مقدار 35.75 تومان پول دارم."))
>>> من مقدار سی و پنج ممیز هفتاد و چهار تومان پول دارم.

>>> with nlp.select_pipes(enable=["time2str"]):
        print(nlp("ساعت 20:27 است."))
>>> ساعت بیست و  بیست و هفت دقیقه است.

>>> with nlp.select_pipes(enable=["date2str"]):
        print(nlp("من در تاریخ 30-2-1375 به دنیا آمدم."))
>>> ['من در تاریخ سیم اردیبهشت ماه  یک هزار و سیصد و هفتاد و پنج به دنیا آمدم.',
     'من در تاریخ سیم اردیبهشت ماه  یک هزار و سیصد و هفتاد و پنج شمسی به دنیا آمدم.',
     'من در تاریخ سی اردیبهشت یک هزار و سیصد و هفتاد و پنج شمسی به دنیا آمدم.',
     'من در تاریخ سی دو یک هزار و سیصد و هفتاد و پنج شمسی به دنیا آمدم.',
     'من در تاریخ سی اردیبهشت یک هزار و سیصد و هفتاد و پنج به دنیا آمدم.',
     'من در تاریخ سیم اردیبهشت سال یک هزار و سیصد و هفتاد و پنج شمسی به دنیا آمدم.',
     'من در تاریخ سیم اردیبهشت سال یک هزار و سیصد و هفتاد و پنج به دنیا آمدم.',
     'من در تاریخ سیم اردیبهشت یک هزار و سیصد و هفتاد و پنج به دنیا آمدم.',
     'من در تاریخ سی دو یک هزار و سیصد و هفتاد و پنج به دنیا آمدم.',
     'من در تاریخ سیم اردیبهشت یک هزار و سیصد و هفتاد و پنج شمسی به دنیا آمدم.',
     'ن در تاریخ سی اردیبهشت سال یک هزار و سیصد و هفتاد و پنج به دنیا آمدم.',
     'من در تاریخ سیم دو سال یک هزار و سیصد و هفتاد و پنج به دنیا آمدم.',
     'من در تاریخ سی اردیبهشت سال یک هزار و سیصد و هفتاد و پنج شمسی به دنیا آمدم.',
     'من در تاریخ سیم دو یک هزار و سیصد و هفتاد و پنج به دنیا آمدم.',
     'من در تاریخ سیم اردیبهشت ماه  سال یک هزار و سیصد و هفتاد و پنج شمسی به دنیا آمدم.',
     'من در تاریخ سی اردیبهشت ماه  یک هزار و سیصد و هفتاد و پنج به دنیا آمدم.',
     'من در تاریخ سی اردیبهشت ماه  یک هزار و سیصد و هفتاد و پنج شمسی به دنیا آمدم.',
     'من در تاریخ سی اردیبهشت ماه  سال یک هزار و سیصد و هفتاد و پنج به دنیا آمدم.',
     'من در تاریخ سیم اردیبهشت ماه  سال یک هزار و سیصد و هفتاد و پنج به دنیا آمدم.',
     'من در تاریخ سی دو سال یک هزار و سیصد و هفتاد و پنج به دنیا آمدم.',
     'من در تاریخ سیم دو سال یک هزار و سیصد و هفتاد و پنج شمسی به دنیا آمدم.',
     'من در تاریخ سی اردیبهشت ماه  سال یک هزار و سیصد و هفتاد و پنج شمسی به دنیا آمدم.',
     'من در تاریخ سیم دو یک هزار و سیصد و هفتاد و پنج شمسی به دنیا آمدم.',
     'من در تاریخ سی دو سال یک هزار و سیصد و هفتاد و پنج شمسی به دنیا آمدم.']

>>> with nlp.select_pipes(enable=["abbreviation2word"]):
        print(nlp("امام علی ع در 1 ه.ق به دنیا آمدند."))
>>> امام علی علیه السلام در 1 هجری قمری به دنیا آمدند.

>>> with nlp.select_pipes(enable=["affix2norm"]):
        print(nlp("شما رفته بودهباشید))
>>> شما رفته بوده باشید

>>> with nlp.select_pipes(enable=["punctuation_remover"]):
        print(nlp("شما! به علایم نگارشی، تماشا+- نمیکنید. شما هیچ علایم نگارشی ( نخواهید دید./")

>>> شما به علایم نگارشی تماشا نمیکنید شما هیچ علایم نگارشی  نخواهید دید
  
>>> with nlp.select_pipes(enable=["word_level_tokenizer"]):
        print(nlp("من در تاریخ 30-2-1375 در راس ساعت 20:30 به منزل رفتم. آنها در این تاریخ بیست سال از ه.ق عقبلتر هستند."))
>>> ['من', 'در', 'تاریخ', '30-2-1375', 'در', 'راس', 'ساعت', '20:30', 'به', 'منزل', 'رفتم.', 'آنها', 'در', 'این', 'تاریخ', 'بیست', 'سال', 'از', 'ه.ق', 'عقبلتر', 'هستند.']

>>> print(nlp("این یک نمونه کامل از مثالهای نرمالایزر موجود خواهدبود. این نرمالایزر در ساعت 20:47 ساخته شدهاست. شما هیچ گونه علایم نگارشی ﺆ کاراکتر غیر عادی نخواهیدخواند. هدف ما نرمالسازی تمامی کتابها است."))

>>> ['این', 'یک', 'نمونه', 'کامل', 'از', 'مثال', 'های', 'نرمالایزر', 'موجود', 'خواهد', 'بود', 'این', 'نرمالایزر', 'در', 'ساعت', 'بیست', 'و', 'چهل', 'و', 'هفت', 'دقیقه', 'ساخته', 'شده', 'است', 'شما', 'هیچ', 'گونه', 'علا', 'یم', 'نگارشی', 'و', 'کاراکتر', 'غیر', 'عادی', 'نخواهید', 'خواند', 'هدف', 'ما', 'نرمالسازی', 'تمامی', 'کتاب', 'ها', 'است']


```


### Multiprocessing
#### Multiprocessing with 4 processes
`>>> docs = nlp.pipe(texts, n_process=4)`

#### With as many processes as CPUs (use with caution!)
`>>> docs = nlp.pipe(texts, n_process=-1)`

#### Default batch size is `nlp.batch_size` (typically 1000)
`>>> docs = nlp.pipe(texts, n_process=2, batch_size=2000)`

### Disabling
```
>>> with nlp.select_pipes(disable=["affix2norm", "date2str"]):
        print(nlp(texts))
```


### Enabling multiple pipe

```
>>> with nlp.select_pipes(enable=["char_normalizer","spell_checker"]):
        print(nlp(texts))

```

### Remove pipe

```
>>> nlp.remove_pipe("spell_checker")
```


