"use strict";
const cdk = require("@aws-cdk/core");
const lib_1 = require("../lib");
const util = require("../lib/util");
module.exports = {
    'throws when zone name ending with a \'.\''(test) {
        test.throws(() => util.validateZoneName('zone.name.'), /trailing dot/);
        test.done();
    },
    'accepts a valid domain name'(test) {
        const domainName = 'amazonaws.com';
        util.validateZoneName(domainName);
        test.done();
    },
    'providedName ending with a dot returns the name'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        const providedName = 'test.domain.com.';
        const qualified = util.determineFullyQualifiedDomainName(providedName, lib_1.HostedZone.fromHostedZoneAttributes(stack, 'HostedZone', {
            hostedZoneId: 'fakeId',
            zoneName: 'ignored',
        }));
        // THEN
        test.equal(qualified, 'test.domain.com.');
        test.done();
    },
    'providedName that matches zoneName returns providedName with a trailing dot'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        const providedName = 'test.domain.com';
        const qualified = util.determineFullyQualifiedDomainName(providedName, lib_1.HostedZone.fromHostedZoneAttributes(stack, 'HostedZone', {
            hostedZoneId: 'fakeId',
            zoneName: 'test.domain.com.',
        }));
        // THEN
        test.equal(qualified, 'test.domain.com.');
        test.done();
    },
    'providedName that ends with zoneName returns providedName with a trailing dot'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        const providedName = 'test.domain.com';
        const qualified = util.determineFullyQualifiedDomainName(providedName, lib_1.HostedZone.fromHostedZoneAttributes(stack, 'HostedZone', {
            hostedZoneId: 'fakeId',
            zoneName: 'domain.com.',
        }));
        // THEN
        test.equal(qualified, 'test.domain.com.');
        test.done();
    },
    'providedName that does not match zoneName concatenates providedName and zoneName'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        const providedName = 'test';
        const qualified = util.determineFullyQualifiedDomainName(providedName, lib_1.HostedZone.fromHostedZoneAttributes(stack, 'HostedZone', {
            hostedZoneId: 'fakeId',
            zoneName: 'domain.com.',
        }));
        // THEN
        test.equal(qualified, 'test.domain.com.');
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVzdC51dGlsLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsidGVzdC51dGlsLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQSxxQ0FBcUM7QUFFckMsZ0NBQW9DO0FBQ3BDLG9DQUFvQztBQUVwQyxpQkFBUztJQUNQLDJDQUEyQyxDQUFDLElBQVU7UUFDcEQsSUFBSSxDQUFDLE1BQU0sQ0FBQyxHQUFHLEVBQUUsQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsWUFBWSxDQUFDLEVBQUUsY0FBYyxDQUFDLENBQUM7UUFDdkUsSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDO0lBQ2QsQ0FBQztJQUVELDZCQUE2QixDQUFDLElBQVU7UUFDdEMsTUFBTSxVQUFVLEdBQUcsZUFBZSxDQUFDO1FBQ25DLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztRQUNsQyxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7SUFDZCxDQUFDO0lBRUQsaURBQWlELENBQUMsSUFBVTtRQUMxRCxRQUFRO1FBQ1IsTUFBTSxLQUFLLEdBQUcsSUFBSSxHQUFHLENBQUMsS0FBSyxFQUFFLENBQUM7UUFFOUIsT0FBTztRQUNQLE1BQU0sWUFBWSxHQUFHLGtCQUFrQixDQUFDO1FBQ3hDLE1BQU0sU0FBUyxHQUFHLElBQUksQ0FBQyxpQ0FBaUMsQ0FBQyxZQUFZLEVBQUUsZ0JBQVUsQ0FBQyx3QkFBd0IsQ0FBQyxLQUFLLEVBQUUsWUFBWSxFQUFFO1lBQzlILFlBQVksRUFBRSxRQUFRO1lBQ3RCLFFBQVEsRUFBRSxTQUFTO1NBQ3BCLENBQUMsQ0FBQyxDQUFDO1FBRUosT0FBTztRQUNQLElBQUksQ0FBQyxLQUFLLENBQUMsU0FBUyxFQUFFLGtCQUFrQixDQUFDLENBQUM7UUFDMUMsSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDO0lBQ2QsQ0FBQztJQUVELDZFQUE2RSxDQUFDLElBQVU7UUFDdEYsUUFBUTtRQUNSLE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDO1FBRTlCLE9BQU87UUFDUCxNQUFNLFlBQVksR0FBRyxpQkFBaUIsQ0FBQztRQUN2QyxNQUFNLFNBQVMsR0FBRyxJQUFJLENBQUMsaUNBQWlDLENBQUMsWUFBWSxFQUFFLGdCQUFVLENBQUMsd0JBQXdCLENBQUMsS0FBSyxFQUFFLFlBQVksRUFBRTtZQUM5SCxZQUFZLEVBQUUsUUFBUTtZQUN0QixRQUFRLEVBQUUsa0JBQWtCO1NBQzdCLENBQUMsQ0FBQyxDQUFDO1FBRUosT0FBTztRQUNQLElBQUksQ0FBQyxLQUFLLENBQUMsU0FBUyxFQUFFLGtCQUFrQixDQUFDLENBQUM7UUFDMUMsSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDO0lBQ2QsQ0FBQztJQUVELCtFQUErRSxDQUFDLElBQVU7UUFDeEYsUUFBUTtRQUNSLE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDO1FBRTlCLE9BQU87UUFDUCxNQUFNLFlBQVksR0FBRyxpQkFBaUIsQ0FBQztRQUN2QyxNQUFNLFNBQVMsR0FBRyxJQUFJLENBQUMsaUNBQWlDLENBQUMsWUFBWSxFQUFFLGdCQUFVLENBQUMsd0JBQXdCLENBQUMsS0FBSyxFQUFFLFlBQVksRUFBRTtZQUM5SCxZQUFZLEVBQUUsUUFBUTtZQUN0QixRQUFRLEVBQUUsYUFBYTtTQUN4QixDQUFDLENBQUMsQ0FBQztRQUVKLE9BQU87UUFDUCxJQUFJLENBQUMsS0FBSyxDQUFDLFNBQVMsRUFBRSxrQkFBa0IsQ0FBQyxDQUFDO1FBQzFDLElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQztJQUNkLENBQUM7SUFFRCxrRkFBa0YsQ0FBQyxJQUFVO1FBQzNGLFFBQVE7UUFDUixNQUFNLEtBQUssR0FBRyxJQUFJLEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQztRQUU5QixPQUFPO1FBQ1AsTUFBTSxZQUFZLEdBQUcsTUFBTSxDQUFDO1FBQzVCLE1BQU0sU0FBUyxHQUFHLElBQUksQ0FBQyxpQ0FBaUMsQ0FBQyxZQUFZLEVBQUUsZ0JBQVUsQ0FBQyx3QkFBd0IsQ0FBQyxLQUFLLEVBQUUsWUFBWSxFQUFFO1lBQzlILFlBQVksRUFBRSxRQUFRO1lBQ3RCLFFBQVEsRUFBRSxhQUFhO1NBQ3hCLENBQUMsQ0FBQyxDQUFDO1FBRUosT0FBTztRQUNQLElBQUksQ0FBQyxLQUFLLENBQUMsU0FBUyxFQUFFLGtCQUFrQixDQUFDLENBQUM7UUFDMUMsSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDO0lBQ2QsQ0FBQztDQUNGLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjZGsgZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBUZXN0IH0gZnJvbSAnbm9kZXVuaXQnO1xuaW1wb3J0IHsgSG9zdGVkWm9uZSB9IGZyb20gJy4uL2xpYic7XG5pbXBvcnQgKiBhcyB1dGlsIGZyb20gJy4uL2xpYi91dGlsJztcblxuZXhwb3J0ID0ge1xuICAndGhyb3dzIHdoZW4gem9uZSBuYW1lIGVuZGluZyB3aXRoIGEgXFwnLlxcJycodGVzdDogVGVzdCkge1xuICAgIHRlc3QudGhyb3dzKCgpID0+IHV0aWwudmFsaWRhdGVab25lTmFtZSgnem9uZS5uYW1lLicpLCAvdHJhaWxpbmcgZG90Lyk7XG4gICAgdGVzdC5kb25lKCk7XG4gIH0sXG5cbiAgJ2FjY2VwdHMgYSB2YWxpZCBkb21haW4gbmFtZScodGVzdDogVGVzdCkge1xuICAgIGNvbnN0IGRvbWFpbk5hbWUgPSAnYW1hem9uYXdzLmNvbSc7XG4gICAgdXRpbC52YWxpZGF0ZVpvbmVOYW1lKGRvbWFpbk5hbWUpO1xuICAgIHRlc3QuZG9uZSgpO1xuICB9LFxuXG4gICdwcm92aWRlZE5hbWUgZW5kaW5nIHdpdGggYSBkb3QgcmV0dXJucyB0aGUgbmFtZScodGVzdDogVGVzdCkge1xuICAgIC8vIEdJVkVOXG4gICAgY29uc3Qgc3RhY2sgPSBuZXcgY2RrLlN0YWNrKCk7XG5cbiAgICAvLyBXSEVOXG4gICAgY29uc3QgcHJvdmlkZWROYW1lID0gJ3Rlc3QuZG9tYWluLmNvbS4nO1xuICAgIGNvbnN0IHF1YWxpZmllZCA9IHV0aWwuZGV0ZXJtaW5lRnVsbHlRdWFsaWZpZWREb21haW5OYW1lKHByb3ZpZGVkTmFtZSwgSG9zdGVkWm9uZS5mcm9tSG9zdGVkWm9uZUF0dHJpYnV0ZXMoc3RhY2ssICdIb3N0ZWRab25lJywge1xuICAgICAgaG9zdGVkWm9uZUlkOiAnZmFrZUlkJyxcbiAgICAgIHpvbmVOYW1lOiAnaWdub3JlZCcsXG4gICAgfSkpO1xuXG4gICAgLy8gVEhFTlxuICAgIHRlc3QuZXF1YWwocXVhbGlmaWVkLCAndGVzdC5kb21haW4uY29tLicpO1xuICAgIHRlc3QuZG9uZSgpO1xuICB9LFxuXG4gICdwcm92aWRlZE5hbWUgdGhhdCBtYXRjaGVzIHpvbmVOYW1lIHJldHVybnMgcHJvdmlkZWROYW1lIHdpdGggYSB0cmFpbGluZyBkb3QnKHRlc3Q6IFRlc3QpIHtcbiAgICAvLyBHSVZFTlxuICAgIGNvbnN0IHN0YWNrID0gbmV3IGNkay5TdGFjaygpO1xuXG4gICAgLy8gV0hFTlxuICAgIGNvbnN0IHByb3ZpZGVkTmFtZSA9ICd0ZXN0LmRvbWFpbi5jb20nO1xuICAgIGNvbnN0IHF1YWxpZmllZCA9IHV0aWwuZGV0ZXJtaW5lRnVsbHlRdWFsaWZpZWREb21haW5OYW1lKHByb3ZpZGVkTmFtZSwgSG9zdGVkWm9uZS5mcm9tSG9zdGVkWm9uZUF0dHJpYnV0ZXMoc3RhY2ssICdIb3N0ZWRab25lJywge1xuICAgICAgaG9zdGVkWm9uZUlkOiAnZmFrZUlkJyxcbiAgICAgIHpvbmVOYW1lOiAndGVzdC5kb21haW4uY29tLicsXG4gICAgfSkpO1xuXG4gICAgLy8gVEhFTlxuICAgIHRlc3QuZXF1YWwocXVhbGlmaWVkLCAndGVzdC5kb21haW4uY29tLicpO1xuICAgIHRlc3QuZG9uZSgpO1xuICB9LFxuXG4gICdwcm92aWRlZE5hbWUgdGhhdCBlbmRzIHdpdGggem9uZU5hbWUgcmV0dXJucyBwcm92aWRlZE5hbWUgd2l0aCBhIHRyYWlsaW5nIGRvdCcodGVzdDogVGVzdCkge1xuICAgIC8vIEdJVkVOXG4gICAgY29uc3Qgc3RhY2sgPSBuZXcgY2RrLlN0YWNrKCk7XG5cbiAgICAvLyBXSEVOXG4gICAgY29uc3QgcHJvdmlkZWROYW1lID0gJ3Rlc3QuZG9tYWluLmNvbSc7XG4gICAgY29uc3QgcXVhbGlmaWVkID0gdXRpbC5kZXRlcm1pbmVGdWxseVF1YWxpZmllZERvbWFpbk5hbWUocHJvdmlkZWROYW1lLCBIb3N0ZWRab25lLmZyb21Ib3N0ZWRab25lQXR0cmlidXRlcyhzdGFjaywgJ0hvc3RlZFpvbmUnLCB7XG4gICAgICBob3N0ZWRab25lSWQ6ICdmYWtlSWQnLFxuICAgICAgem9uZU5hbWU6ICdkb21haW4uY29tLicsXG4gICAgfSkpO1xuXG4gICAgLy8gVEhFTlxuICAgIHRlc3QuZXF1YWwocXVhbGlmaWVkLCAndGVzdC5kb21haW4uY29tLicpO1xuICAgIHRlc3QuZG9uZSgpO1xuICB9LFxuXG4gICdwcm92aWRlZE5hbWUgdGhhdCBkb2VzIG5vdCBtYXRjaCB6b25lTmFtZSBjb25jYXRlbmF0ZXMgcHJvdmlkZWROYW1lIGFuZCB6b25lTmFtZScodGVzdDogVGVzdCkge1xuICAgIC8vIEdJVkVOXG4gICAgY29uc3Qgc3RhY2sgPSBuZXcgY2RrLlN0YWNrKCk7XG5cbiAgICAvLyBXSEVOXG4gICAgY29uc3QgcHJvdmlkZWROYW1lID0gJ3Rlc3QnO1xuICAgIGNvbnN0IHF1YWxpZmllZCA9IHV0aWwuZGV0ZXJtaW5lRnVsbHlRdWFsaWZpZWREb21haW5OYW1lKHByb3ZpZGVkTmFtZSwgSG9zdGVkWm9uZS5mcm9tSG9zdGVkWm9uZUF0dHJpYnV0ZXMoc3RhY2ssICdIb3N0ZWRab25lJywge1xuICAgICAgaG9zdGVkWm9uZUlkOiAnZmFrZUlkJyxcbiAgICAgIHpvbmVOYW1lOiAnZG9tYWluLmNvbS4nLFxuICAgIH0pKTtcblxuICAgIC8vIFRIRU5cbiAgICB0ZXN0LmVxdWFsKHF1YWxpZmllZCwgJ3Rlc3QuZG9tYWluLmNvbS4nKTtcbiAgICB0ZXN0LmRvbmUoKTtcbiAgfSxcbn07XG4iXX0=