# VoiceS

根据 ASS 文件将多种类的音频文件切片为指定格式的文件，并生成对应的 .lab 文件。

## 功能与计划

### 功能

- [x] 导出多音字列表
- [x] [交互式多音字修复](#交互式多音字修复)
- [x] [交互式中根据输入历史**自动选择**高可能性的发音](#校对建议)
- [x] [交互式中根据输入历史**高亮**可能性较复杂的字](#校对建议)
- [x] 联机获取词库`tracker.json`
- [x] [断点续切](#断点续切)
- [ ] 整合mfa？

### 输入文件类型

- [x] ass(aegisub)
- [ ] 其他的类型？(欢迎提交issue或pr)

## 使用方法

### 下载时间轴工具

下载 [AgeiSub](https://github.com/Aegisub/Aegisub/releases/tag/v3.2.2) 或其他能够根据音频生成 `.ass` 文件的时间轴工具。

### 打轴

导入音频文件并生成对应的时间轴，可参考 <https://www.bilibili.com/video/BV19F411w7m5>。

注意：

1. 生成的时间轴中每行将会被视为一个“切片”
2. 歌词中不应出现任何标点符号，可以出现空格，也可提前将多音字替换为拼音 (但不可出现连续的拼音，可能会被合并到一起)

### 配置运行环境

直接通过 pypi 进行安装: `pip install voices`

### 启动脚本

>注意：若时间轴中某一切片超过 `配置项` 中设定的范围，将会报错并跳过**整个文件**，但不会影响到其他文件的处理。

使用 `voices [-f] -i <src> -o <des>` 指令来启动脚本，或在脚本中自行输入 `<src>` 或 `<des>`，随后根据脚本的提示修改配置项后即可开始切片。

- `--force(-f)`: 跳过 `<des>` 检查，使你的 `<des>` 即使不为空也可以使用。
- `--input(-i)`: 输入路径 `<src>`，也就是需要处理的文件夹。
- `--output(-o)`: 输出路径 `<des>`，也就是处理后输出的文件夹。

#### 断点续切

如果你想中途停止切片，那么你可以随时关闭此脚本 (除非是你赶在写入文件的那几毫秒的时候关闭)，再次启动时如果脚本检测到 `<des>` 包含了对应的 `.lab` 文件，那么将会**跳过**此切片。

#### 修正原始数据

在输出目录下 (也就是 `des`) 会生成 `exception.json` 文件，其中记录了包含多音字的切片。此时可以根据此文件对 `.lab` 文件进行修正 (当然你也可以头铁直接拿去mfa，此时生成的文件格式上是没有错误的)。

#### 交互式多音字修复

在程序启动时会询问 `是否开启 **交互式** 多音字检查` 如果你按照提示开启了该功能，在程序遇到多音字时会记录并在终端开启一个 CLI 来辅助你动态的更改多音字的发音。

如果你在交互式修复过程中未对 **全部** 多音字进行修复，在 `exception.json` 中也会记录未修复的部分。

##### 校对建议

在 **配置项中填写的路径** 中会自动下载 `tracker.json` 文件，也可手动导入此文件(注意读写权限)，在使用过程中会根据 **文件中的记录** 和 **本次操作记录** 将多音字划分为四个等级。

- ⚪: 数据量小于5, 无法形成有效提示
- 🟢: 当前选项占记录中可能性的 97% 以上
- 🟡: 当前选项占记录中可能性的 97% 以下
- 🔴: 当前选项中，**本次操作记录** 与 **文件中的记录** 中最大可能性的选项不一致

同时，系统也会对多音字列表按照可能性进行排序，默认选中可能性最高的选项。**本次操作记录** 的优先级要高于 **文件中的记录**，如果二者在排序中 **有冲突** 的话会采用 **本次操作记录** 并标记为 `🔴`。

当然，这套系统本质上依然是 `if else`，并不能真正的“识别”此处的发音，因此即便是 `🟢` 也建议**不要直接跳过**。

由于 `tracker.json` 需要**大量的积累**才能更加准确，因此也再此呼吁使用该项目的用户**分享**出来自己的 `tracker.json`，详情可见 [issue区置顶](https://github.com/Well2333/VoiceS/issues/1)。
