"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScheduleShutdown = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const security_tag_1 = require("./security-tag");
class ScheduleShutdown extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const securityTag = props?.securityTag
            ? props.securityTag
            : security_tag_1.DefaultSecurityTag;
        const maintanenceWindow = new aws_cdk_lib_1.aws_ssm.CfnMaintenanceWindow(this, 'BastionMaintanenceWindow', {
            allowUnassociatedTargets: false,
            cutoff: 0,
            duration: 1,
            name: aws_cdk_lib_1.Stack.of(scope).stackName + '-Maintanence-Window',
            schedule: props?.shutdownSchedule
                ? props.shutdownSchedule
                : 'cron(0 2 ? * * *)',
            scheduleTimezone: props?.timezone
                ? props.timezone
                : 'Australia/Melbourne',
        });
        const maintanenceTarget = new aws_cdk_lib_1.aws_ssm.CfnMaintenanceWindowTarget(this, 'BastionMaintanenceTarget', {
            resourceType: 'INSTANCE',
            targets: [
                {
                    key: `tag:${securityTag.key}`,
                    values: [securityTag.value],
                },
            ],
            windowId: maintanenceWindow.ref,
        });
        const taskRole = new aws_cdk_lib_1.aws_iam.Role(this, 'AutomationRole', {
            inlinePolicies: {
                ec2Stop: new aws_cdk_lib_1.aws_iam.PolicyDocument({
                    statements: [
                        new aws_cdk_lib_1.aws_iam.PolicyStatement({
                            effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                            resources: ['*'],
                            actions: ['ec2:StopInstances'],
                            conditions: {
                                StringEquals: JSON.parse(`{"aws:ResourceTag/${securityTag.key}": "${securityTag.value}"}`),
                            },
                        }),
                        new aws_cdk_lib_1.aws_iam.PolicyStatement({
                            effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                            resources: ['*'],
                            actions: ['ec2:DescribeInstances', 'ec2:DescribeInstanceStatus'],
                        }),
                    ],
                }),
            },
            assumedBy: new aws_cdk_lib_1.aws_iam.ServicePrincipal('ssm.amazonaws.com'),
        });
        new aws_cdk_lib_1.aws_ssm.CfnMaintenanceWindowTask(this, 'BastionStop', {
            priority: 1,
            taskArn: 'AWS-StopEC2Instance',
            taskType: 'AUTOMATION',
            windowId: maintanenceWindow.ref,
            taskInvocationParameters: {
                maintenanceWindowAutomationParameters: {
                    documentVersion: '1',
                    parameters: {
                        InstanceId: ['{{RESOURCE_ID}}'],
                        AutomationAssumeRole: [taskRole.roleArn],
                    },
                },
            },
            maxErrors: '1',
            maxConcurrency: '1',
            targets: [
                {
                    key: 'WindowTargetIds',
                    values: [maintanenceTarget.ref],
                },
            ],
        });
    }
}
exports.ScheduleShutdown = ScheduleShutdown;
_a = JSII_RTTI_SYMBOL_1;
ScheduleShutdown[_a] = { fqn: "pwed-cdk.bastion.ScheduleShutdown", version: "0.0.56" };
//# sourceMappingURL=data:application/json;base64,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