"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StaticSite = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const child_process = require("child_process");
const crypto = require("crypto");
const fs = require("fs");
const path = require("path");
const process = require("process");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const glob_1 = require("glob");
class StaticSite extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const bucket = new aws_cdk_lib_1.aws_s3.Bucket(this, 'Bucket', {
            encryption: aws_cdk_lib_1.aws_s3.BucketEncryption.S3_MANAGED,
            lifecycleRules: [
                {
                    transitions: [
                        {
                            storageClass: aws_cdk_lib_1.aws_s3.StorageClass.INTELLIGENT_TIERING,
                            transitionAfter: aws_cdk_lib_1.Duration.days(7),
                        },
                    ],
                },
            ],
        });
        const hostedZone = props.hostedZone
            ? props.hostedZone
            : aws_cdk_lib_1.aws_route53.HostedZone.fromLookup(this, 'HostedZone', {
                domainName: props.domain,
            });
        const certificate = new aws_cdk_lib_1.aws_certificatemanager.Certificate(this, 'Certificate', {
            domainName: props.domain,
            validation: aws_cdk_lib_1.aws_certificatemanager.CertificateValidation.fromDns(hostedZone),
        });
        const originAccessIdentity = new aws_cdk_lib_1.aws_cloudfront.OriginAccessIdentity(this, 'OriginAccessIdentity');
        bucket.grantRead(originAccessIdentity);
        this.distribution = new aws_cdk_lib_1.aws_cloudfront.Distribution(this, 'Distribution', {
            defaultBehavior: {
                origin: new aws_cdk_lib_1.aws_cloudfront_origins.S3Origin(bucket, {
                    originAccessIdentity,
                }),
                allowedMethods: aws_cdk_lib_1.aws_cloudfront.AllowedMethods.ALLOW_GET_HEAD_OPTIONS,
                viewerProtocolPolicy: aws_cdk_lib_1.aws_cloudfront.ViewerProtocolPolicy.REDIRECT_TO_HTTPS,
            },
            domainNames: [props.domain],
            certificate,
            errorResponses: [
                {
                    httpStatus: 404,
                    responseHttpStatus: 404,
                    responsePagePath: '/404.html',
                },
            ],
            defaultRootObject: 'index.html',
        });
        const cfnDistribution = this.distribution.node
            .defaultChild;
        cfnDistribution.addOverride('Properties.DistributionConfig.HttpVersion', 'http2and3');
        new aws_cdk_lib_1.aws_route53.ARecord(this, 'AAliasRecord', {
            recordName: props.domain,
            zone: hostedZone,
            target: aws_cdk_lib_1.aws_route53.RecordTarget.fromAlias(new aws_cdk_lib_1.aws_route53_targets.CloudFrontTarget(this.distribution)),
        });
        new aws_cdk_lib_1.aws_route53.AaaaRecord(this, 'AaaaAliasRecord', {
            recordName: props.domain,
            zone: hostedZone,
            target: aws_cdk_lib_1.aws_route53.RecordTarget.fromAlias(new aws_cdk_lib_1.aws_route53_targets.CloudFrontTarget(this.distribution)),
        });
        const hashFile = '/.hashfile';
        let invalidations = [hashFile];
        invalidations.push(...compareRemoteToLocal(props.domain, hashFile, props.path));
        new aws_cdk_lib_1.aws_s3_deployment.BucketDeployment(this, 'StaticDeployment', {
            sources: [aws_cdk_lib_1.aws_s3_deployment.Source.asset(props.path)],
            destinationBucket: bucket,
            distribution: this.distribution,
            distributionPaths: invalidations,
        });
    }
}
exports.StaticSite = StaticSite;
_a = JSII_RTTI_SYMBOL_1;
StaticSite[_a] = { fqn: "pwed-cdk.static_site.StaticSite", version: "0.0.56" };
function getHashes(globPattern, dir) {
    let fh = new Map();
    const gs = glob_1.sync(globPattern, { cwd: dir, nodir: true });
    const pwd = process.cwd();
    process.chdir(dir);
    gs.forEach(function (file) {
        const fileBuffer = fs.readFileSync(file, {});
        const hashSum = crypto.createHash('sha256');
        hashSum.update(fileBuffer);
        const hex = hashSum.digest('hex');
        fh.set(file, hex);
    });
    process.chdir(pwd);
    return fh;
}
function getInvalidations(oldHashes, newHashes) {
    let invalidations = [];
    oldHashes.forEach(function (v, k) {
        if (newHashes.get(k) !== v) {
            invalidations.push(`/${k}`);
        }
    });
    return invalidations;
}
function compareRemoteToLocal(domain, hashFile, localFolder) {
    let oldHashesJSON;
    const newHashes = getHashes('**', localFolder);
    fs.writeFileSync(path.join(localFolder, hashFile), JSON.stringify(Object.fromEntries(newHashes)));
    try {
        oldHashesJSON = child_process
            .execSync(`curl -s https://${domain}/${hashFile}`)
            .toString();
    }
    catch {
        return ['/*'];
    }
    let oldHashes;
    try {
        oldHashes = new Map(Object.entries(JSON.parse(oldHashesJSON)));
    }
    catch (e) {
        return ['/*'];
    }
    return getInvalidations(oldHashes, newHashes);
}
//# sourceMappingURL=data:application/json;base64,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