<a id="mypy-boto3-imagebuilder"></a>

# mypy-boto3-imagebuilder

[![PyPI - mypy-boto3-imagebuilder](https://img.shields.io/pypi/v/mypy-boto3-imagebuilder.svg?color=blue)](https://pypi.org/project/mypy-boto3-imagebuilder)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-imagebuilder.svg?color=blue)](https://pypi.org/project/mypy-boto3-imagebuilder)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-imagebuilder?color=blue)](https://pypistats.org/packages/mypy-boto3-imagebuilder)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.imagebuilder 1.18.31](https://boto3.amazonaws.com/v1/documentation/api/1.18.31/reference/services/imagebuilder.html#imagebuilder)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 5.1.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-imagebuilder docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_imagebuilder/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-imagebuilder](#mypy-boto3-imagebuilder)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `imagebuilder` service.

```bash
python -m pip install boto3-stubs[imagebuilder]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[imagebuilder]` in your environment:
  `python -m pip install 'boto3-stubs[imagebuilder]'`

Both type checking and auto-complete should work for `imagebuilder` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[imagebuilder]` in your environment:
  `python -m pip install 'boto3-stubs[imagebuilder]'`

Both type checking and auto-complete should work for `imagebuilder` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[imagebuilder]` in your environment:
  `python -m pip install 'boto3-stubs[imagebuilder]'`
- Run `mypy` as usual

Type checking should work for `imagebuilder` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[imagebuilder]` in your environment:
  `python -m pip install 'boto3-stubs[imagebuilder]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `imagebuilder` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`imagebuilderClient` provides annotations for `boto3.client("imagebuilder")`.

```python
import boto3

from mypy_boto3_imagebuilder import imagebuilderClient

client: imagebuilderClient = boto3.client("imagebuilder")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: imagebuilderClient = session.client("imagebuilder")
```

<a id="literals"></a>

### Literals

`mypy_boto3_imagebuilder.literals` module contains literals extracted from
shapes that can be used in user code for type checking.

```python
from mypy_boto3_imagebuilder.literals import (
    ComponentFormatType,
    ComponentTypeType,
    ContainerRepositoryServiceType,
    ContainerTypeType,
    EbsVolumeTypeType,
    ImageStatusType,
    ImageTypeType,
    OwnershipType,
    PipelineExecutionStartConditionType,
    PipelineStatusType,
    PlatformType,
)

def check_value(value: ComponentFormatType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_imagebuilder.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_imagebuilder.type_defs import (
    AdditionalInstanceConfigurationTypeDef,
    AmiDistributionConfigurationTypeDef,
    AmiTypeDef,
    CancelImageCreationRequestRequestTypeDef,
    CancelImageCreationResponseTypeDef,
    ComponentConfigurationTypeDef,
    ComponentParameterDetailTypeDef,
    ComponentParameterTypeDef,
    ComponentSummaryTypeDef,
    ComponentTypeDef,
    ComponentVersionTypeDef,
    ContainerDistributionConfigurationTypeDef,
    ContainerRecipeSummaryTypeDef,
    ContainerRecipeTypeDef,
    ContainerTypeDef,
    CreateComponentRequestRequestTypeDef,
    CreateComponentResponseTypeDef,
    CreateContainerRecipeRequestRequestTypeDef,
    CreateContainerRecipeResponseTypeDef,
    CreateDistributionConfigurationRequestRequestTypeDef,
    CreateDistributionConfigurationResponseTypeDef,
    CreateImagePipelineRequestRequestTypeDef,
    CreateImagePipelineResponseTypeDef,
    CreateImageRecipeRequestRequestTypeDef,
    CreateImageRecipeResponseTypeDef,
    CreateImageRequestRequestTypeDef,
    CreateImageResponseTypeDef,
    CreateInfrastructureConfigurationRequestRequestTypeDef,
    CreateInfrastructureConfigurationResponseTypeDef,
    DeleteComponentRequestRequestTypeDef,
    DeleteComponentResponseTypeDef,
    DeleteContainerRecipeRequestRequestTypeDef,
    DeleteContainerRecipeResponseTypeDef,
    DeleteDistributionConfigurationRequestRequestTypeDef,
    DeleteDistributionConfigurationResponseTypeDef,
    DeleteImagePipelineRequestRequestTypeDef,
    DeleteImagePipelineResponseTypeDef,
    DeleteImageRecipeRequestRequestTypeDef,
    DeleteImageRecipeResponseTypeDef,
    DeleteImageRequestRequestTypeDef,
    DeleteImageResponseTypeDef,
    DeleteInfrastructureConfigurationRequestRequestTypeDef,
    DeleteInfrastructureConfigurationResponseTypeDef,
    DistributionConfigurationSummaryTypeDef,
    DistributionConfigurationTypeDef,
    DistributionTypeDef,
    EbsInstanceBlockDeviceSpecificationTypeDef,
    FilterTypeDef,
    GetComponentPolicyRequestRequestTypeDef,
    GetComponentPolicyResponseTypeDef,
    GetComponentRequestRequestTypeDef,
    GetComponentResponseTypeDef,
    GetContainerRecipePolicyRequestRequestTypeDef,
    GetContainerRecipePolicyResponseTypeDef,
    GetContainerRecipeRequestRequestTypeDef,
    GetContainerRecipeResponseTypeDef,
    GetDistributionConfigurationRequestRequestTypeDef,
    GetDistributionConfigurationResponseTypeDef,
    GetImagePipelineRequestRequestTypeDef,
    GetImagePipelineResponseTypeDef,
    GetImagePolicyRequestRequestTypeDef,
    GetImagePolicyResponseTypeDef,
    GetImageRecipePolicyRequestRequestTypeDef,
    GetImageRecipePolicyResponseTypeDef,
    GetImageRecipeRequestRequestTypeDef,
    GetImageRecipeResponseTypeDef,
    GetImageRequestRequestTypeDef,
    GetImageResponseTypeDef,
    GetInfrastructureConfigurationRequestRequestTypeDef,
    GetInfrastructureConfigurationResponseTypeDef,
    ImagePackageTypeDef,
    ImagePipelineTypeDef,
    ImageRecipeSummaryTypeDef,
    ImageRecipeTypeDef,
    ImageStateTypeDef,
    ImageSummaryTypeDef,
    ImageTestsConfigurationTypeDef,
    ImageTypeDef,
    ImageVersionTypeDef,
    ImportComponentRequestRequestTypeDef,
    ImportComponentResponseTypeDef,
    InfrastructureConfigurationSummaryTypeDef,
    InfrastructureConfigurationTypeDef,
    InstanceBlockDeviceMappingTypeDef,
    InstanceConfigurationTypeDef,
    LaunchPermissionConfigurationTypeDef,
    LaunchTemplateConfigurationTypeDef,
    ListComponentBuildVersionsRequestRequestTypeDef,
    ListComponentBuildVersionsResponseTypeDef,
    ListComponentsRequestRequestTypeDef,
    ListComponentsResponseTypeDef,
    ListContainerRecipesRequestRequestTypeDef,
    ListContainerRecipesResponseTypeDef,
    ListDistributionConfigurationsRequestRequestTypeDef,
    ListDistributionConfigurationsResponseTypeDef,
    ListImageBuildVersionsRequestRequestTypeDef,
    ListImageBuildVersionsResponseTypeDef,
    ListImagePackagesRequestRequestTypeDef,
    ListImagePackagesResponseTypeDef,
    ListImagePipelineImagesRequestRequestTypeDef,
    ListImagePipelineImagesResponseTypeDef,
    ListImagePipelinesRequestRequestTypeDef,
    ListImagePipelinesResponseTypeDef,
    ListImageRecipesRequestRequestTypeDef,
    ListImageRecipesResponseTypeDef,
    ListImagesRequestRequestTypeDef,
    ListImagesResponseTypeDef,
    ListInfrastructureConfigurationsRequestRequestTypeDef,
    ListInfrastructureConfigurationsResponseTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResponseTypeDef,
    LoggingTypeDef,
    OutputResourcesTypeDef,
    PutComponentPolicyRequestRequestTypeDef,
    PutComponentPolicyResponseTypeDef,
    PutContainerRecipePolicyRequestRequestTypeDef,
    PutContainerRecipePolicyResponseTypeDef,
    PutImagePolicyRequestRequestTypeDef,
    PutImagePolicyResponseTypeDef,
    PutImageRecipePolicyRequestRequestTypeDef,
    PutImageRecipePolicyResponseTypeDef,
    ResponseMetadataTypeDef,
    S3LogsTypeDef,
    ScheduleTypeDef,
    StartImagePipelineExecutionRequestRequestTypeDef,
    StartImagePipelineExecutionResponseTypeDef,
    SystemsManagerAgentTypeDef,
    TagResourceRequestRequestTypeDef,
    TargetContainerRepositoryTypeDef,
    UntagResourceRequestRequestTypeDef,
    UpdateDistributionConfigurationRequestRequestTypeDef,
    UpdateDistributionConfigurationResponseTypeDef,
    UpdateImagePipelineRequestRequestTypeDef,
    UpdateImagePipelineResponseTypeDef,
    UpdateInfrastructureConfigurationRequestRequestTypeDef,
    UpdateInfrastructureConfigurationResponseTypeDef,
)

def get_structure() -> AdditionalInstanceConfigurationTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-imagebuilder` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-imagebuilder docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_imagebuilder/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
