import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::MediaConnect::Flow`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html
 */
export interface CfnFlowProps {
    /**
     * `AWS::MediaConnect::Flow.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-name
     */
    readonly name: string;
    /**
     * `AWS::MediaConnect::Flow.Source`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-source
     */
    readonly source: CfnFlow.SourceProperty | cdk.IResolvable;
    /**
     * `AWS::MediaConnect::Flow.AvailabilityZone`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-availabilityzone
     */
    readonly availabilityZone?: string;
    /**
     * `AWS::MediaConnect::Flow.SourceFailoverConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-sourcefailoverconfig
     */
    readonly sourceFailoverConfig?: CfnFlow.FailoverConfigProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::MediaConnect::Flow`.
 *
 * @external
 * @cloudformationResource AWS::MediaConnect::Flow
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html
 */
export declare class CfnFlow extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MediaConnect::Flow";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnFlow;
    /**
     * @external
     * @cloudformationAttribute FlowArn
     */
    readonly attrFlowArn: string;
    /**
     * @external
     * @cloudformationAttribute FlowAvailabilityZone
     */
    readonly attrFlowAvailabilityZone: string;
    /**
     * @external
     * @cloudformationAttribute IngestIp
     */
    readonly attrIngestIp: string;
    /**
     * @external
     * @cloudformationAttribute SourceArn
     */
    readonly attrSourceArn: string;
    /**
     * `AWS::MediaConnect::Flow.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-name
     */
    name: string;
    /**
     * `AWS::MediaConnect::Flow.Source`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-source
     */
    source: CfnFlow.SourceProperty | cdk.IResolvable;
    /**
     * `AWS::MediaConnect::Flow.AvailabilityZone`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-availabilityzone
     */
    availabilityZone: string | undefined;
    /**
     * `AWS::MediaConnect::Flow.SourceFailoverConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-sourcefailoverconfig
     */
    sourceFailoverConfig: CfnFlow.FailoverConfigProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::MediaConnect::Flow`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFlowProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::MediaConnect::Flow`.
 *
 * @external
 * @cloudformationResource AWS::MediaConnect::Flow
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html
 */
export declare namespace CfnFlow {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html
     */
    interface EncryptionProperty {
        /**
         * `CfnFlow.EncryptionProperty.Algorithm`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html#cfn-mediaconnect-flow-encryption-algorithm
         */
        readonly algorithm: string;
        /**
         * `CfnFlow.EncryptionProperty.ConstantInitializationVector`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html#cfn-mediaconnect-flow-encryption-constantinitializationvector
         */
        readonly constantInitializationVector?: string;
        /**
         * `CfnFlow.EncryptionProperty.DeviceId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html#cfn-mediaconnect-flow-encryption-deviceid
         */
        readonly deviceId?: string;
        /**
         * `CfnFlow.EncryptionProperty.KeyType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html#cfn-mediaconnect-flow-encryption-keytype
         */
        readonly keyType?: string;
        /**
         * `CfnFlow.EncryptionProperty.Region`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html#cfn-mediaconnect-flow-encryption-region
         */
        readonly region?: string;
        /**
         * `CfnFlow.EncryptionProperty.ResourceId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html#cfn-mediaconnect-flow-encryption-resourceid
         */
        readonly resourceId?: string;
        /**
         * `CfnFlow.EncryptionProperty.RoleArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html#cfn-mediaconnect-flow-encryption-rolearn
         */
        readonly roleArn: string;
        /**
         * `CfnFlow.EncryptionProperty.SecretArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html#cfn-mediaconnect-flow-encryption-secretarn
         */
        readonly secretArn?: string;
        /**
         * `CfnFlow.EncryptionProperty.Url`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html#cfn-mediaconnect-flow-encryption-url
         */
        readonly url?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaConnect::Flow`.
 *
 * @external
 * @cloudformationResource AWS::MediaConnect::Flow
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html
 */
export declare namespace CfnFlow {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-failoverconfig.html
     */
    interface FailoverConfigProperty {
        /**
         * `CfnFlow.FailoverConfigProperty.RecoveryWindow`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-failoverconfig.html#cfn-mediaconnect-flow-failoverconfig-recoverywindow
         */
        readonly recoveryWindow?: number;
        /**
         * `CfnFlow.FailoverConfigProperty.State`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-failoverconfig.html#cfn-mediaconnect-flow-failoverconfig-state
         */
        readonly state?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaConnect::Flow`.
 *
 * @external
 * @cloudformationResource AWS::MediaConnect::Flow
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html
 */
export declare namespace CfnFlow {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html
     */
    interface SourceProperty {
        /**
         * `CfnFlow.SourceProperty.Decryption`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-decryption
         */
        readonly decryption?: CfnFlow.EncryptionProperty | cdk.IResolvable;
        /**
         * `CfnFlow.SourceProperty.Description`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-description
         */
        readonly description?: string;
        /**
         * `CfnFlow.SourceProperty.EntitlementArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-entitlementarn
         */
        readonly entitlementArn?: string;
        /**
         * `CfnFlow.SourceProperty.IngestIp`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-ingestip
         */
        readonly ingestIp?: string;
        /**
         * `CfnFlow.SourceProperty.IngestPort`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-ingestport
         */
        readonly ingestPort?: number;
        /**
         * `CfnFlow.SourceProperty.MaxBitrate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-maxbitrate
         */
        readonly maxBitrate?: number;
        /**
         * `CfnFlow.SourceProperty.MaxLatency`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-maxlatency
         */
        readonly maxLatency?: number;
        /**
         * `CfnFlow.SourceProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-name
         */
        readonly name?: string;
        /**
         * `CfnFlow.SourceProperty.Protocol`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-protocol
         */
        readonly protocol?: string;
        /**
         * `CfnFlow.SourceProperty.SourceArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-sourcearn
         */
        readonly sourceArn?: string;
        /**
         * `CfnFlow.SourceProperty.StreamId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-streamid
         */
        readonly streamId?: string;
        /**
         * `CfnFlow.SourceProperty.VpcInterfaceName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-vpcinterfacename
         */
        readonly vpcInterfaceName?: string;
        /**
         * `CfnFlow.SourceProperty.WhitelistCidr`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-whitelistcidr
         */
        readonly whitelistCidr?: string;
    }
}
/**
 * Properties for defining a `AWS::MediaConnect::FlowEntitlement`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html
 */
export interface CfnFlowEntitlementProps {
    /**
     * `AWS::MediaConnect::FlowEntitlement.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-description
     */
    readonly description: string;
    /**
     * `AWS::MediaConnect::FlowEntitlement.FlowArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-flowarn
     */
    readonly flowArn: string;
    /**
     * `AWS::MediaConnect::FlowEntitlement.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-name
     */
    readonly name: string;
    /**
     * `AWS::MediaConnect::FlowEntitlement.Subscribers`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-subscribers
     */
    readonly subscribers: string[];
    /**
     * `AWS::MediaConnect::FlowEntitlement.DataTransferSubscriberFeePercent`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-datatransfersubscriberfeepercent
     */
    readonly dataTransferSubscriberFeePercent?: number;
    /**
     * `AWS::MediaConnect::FlowEntitlement.Encryption`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-encryption
     */
    readonly encryption?: CfnFlowEntitlement.EncryptionProperty | cdk.IResolvable;
    /**
     * `AWS::MediaConnect::FlowEntitlement.EntitlementStatus`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-entitlementstatus
     */
    readonly entitlementStatus?: string;
}
/**
 * A CloudFormation `AWS::MediaConnect::FlowEntitlement`.
 *
 * @external
 * @cloudformationResource AWS::MediaConnect::FlowEntitlement
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html
 */
export declare class CfnFlowEntitlement extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MediaConnect::FlowEntitlement";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnFlowEntitlement;
    /**
     * @external
     * @cloudformationAttribute EntitlementArn
     */
    readonly attrEntitlementArn: string;
    /**
     * `AWS::MediaConnect::FlowEntitlement.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-description
     */
    description: string;
    /**
     * `AWS::MediaConnect::FlowEntitlement.FlowArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-flowarn
     */
    flowArn: string;
    /**
     * `AWS::MediaConnect::FlowEntitlement.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-name
     */
    name: string;
    /**
     * `AWS::MediaConnect::FlowEntitlement.Subscribers`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-subscribers
     */
    subscribers: string[];
    /**
     * `AWS::MediaConnect::FlowEntitlement.DataTransferSubscriberFeePercent`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-datatransfersubscriberfeepercent
     */
    dataTransferSubscriberFeePercent: number | undefined;
    /**
     * `AWS::MediaConnect::FlowEntitlement.Encryption`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-encryption
     */
    encryption: CfnFlowEntitlement.EncryptionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaConnect::FlowEntitlement.EntitlementStatus`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-entitlementstatus
     */
    entitlementStatus: string | undefined;
    /**
     * Create a new `AWS::MediaConnect::FlowEntitlement`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFlowEntitlementProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::MediaConnect::FlowEntitlement`.
 *
 * @external
 * @cloudformationResource AWS::MediaConnect::FlowEntitlement
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html
 */
export declare namespace CfnFlowEntitlement {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html
     */
    interface EncryptionProperty {
        /**
         * `CfnFlowEntitlement.EncryptionProperty.Algorithm`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html#cfn-mediaconnect-flowentitlement-encryption-algorithm
         */
        readonly algorithm: string;
        /**
         * `CfnFlowEntitlement.EncryptionProperty.ConstantInitializationVector`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html#cfn-mediaconnect-flowentitlement-encryption-constantinitializationvector
         */
        readonly constantInitializationVector?: string;
        /**
         * `CfnFlowEntitlement.EncryptionProperty.DeviceId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html#cfn-mediaconnect-flowentitlement-encryption-deviceid
         */
        readonly deviceId?: string;
        /**
         * `CfnFlowEntitlement.EncryptionProperty.KeyType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html#cfn-mediaconnect-flowentitlement-encryption-keytype
         */
        readonly keyType?: string;
        /**
         * `CfnFlowEntitlement.EncryptionProperty.Region`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html#cfn-mediaconnect-flowentitlement-encryption-region
         */
        readonly region?: string;
        /**
         * `CfnFlowEntitlement.EncryptionProperty.ResourceId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html#cfn-mediaconnect-flowentitlement-encryption-resourceid
         */
        readonly resourceId?: string;
        /**
         * `CfnFlowEntitlement.EncryptionProperty.RoleArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html#cfn-mediaconnect-flowentitlement-encryption-rolearn
         */
        readonly roleArn: string;
        /**
         * `CfnFlowEntitlement.EncryptionProperty.SecretArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html#cfn-mediaconnect-flowentitlement-encryption-secretarn
         */
        readonly secretArn?: string;
        /**
         * `CfnFlowEntitlement.EncryptionProperty.Url`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html#cfn-mediaconnect-flowentitlement-encryption-url
         */
        readonly url?: string;
    }
}
/**
 * Properties for defining a `AWS::MediaConnect::FlowOutput`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html
 */
export interface CfnFlowOutputProps {
    /**
     * `AWS::MediaConnect::FlowOutput.FlowArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-flowarn
     */
    readonly flowArn: string;
    /**
     * `AWS::MediaConnect::FlowOutput.Protocol`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-protocol
     */
    readonly protocol: string;
    /**
     * `AWS::MediaConnect::FlowOutput.CidrAllowList`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-cidrallowlist
     */
    readonly cidrAllowList?: string[];
    /**
     * `AWS::MediaConnect::FlowOutput.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-description
     */
    readonly description?: string;
    /**
     * `AWS::MediaConnect::FlowOutput.Destination`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-destination
     */
    readonly destination?: string;
    /**
     * `AWS::MediaConnect::FlowOutput.Encryption`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-encryption
     */
    readonly encryption?: CfnFlowOutput.EncryptionProperty | cdk.IResolvable;
    /**
     * `AWS::MediaConnect::FlowOutput.MaxLatency`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-maxlatency
     */
    readonly maxLatency?: number;
    /**
     * `AWS::MediaConnect::FlowOutput.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-name
     */
    readonly name?: string;
    /**
     * `AWS::MediaConnect::FlowOutput.Port`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-port
     */
    readonly port?: number;
    /**
     * `AWS::MediaConnect::FlowOutput.RemoteId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-remoteid
     */
    readonly remoteId?: string;
    /**
     * `AWS::MediaConnect::FlowOutput.SmoothingLatency`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-smoothinglatency
     */
    readonly smoothingLatency?: number;
    /**
     * `AWS::MediaConnect::FlowOutput.StreamId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-streamid
     */
    readonly streamId?: string;
    /**
     * `AWS::MediaConnect::FlowOutput.VpcInterfaceAttachment`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-vpcinterfaceattachment
     */
    readonly vpcInterfaceAttachment?: CfnFlowOutput.VpcInterfaceAttachmentProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::MediaConnect::FlowOutput`.
 *
 * @external
 * @cloudformationResource AWS::MediaConnect::FlowOutput
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html
 */
export declare class CfnFlowOutput extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MediaConnect::FlowOutput";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnFlowOutput;
    /**
     * @external
     * @cloudformationAttribute OutputArn
     */
    readonly attrOutputArn: string;
    /**
     * `AWS::MediaConnect::FlowOutput.FlowArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-flowarn
     */
    flowArn: string;
    /**
     * `AWS::MediaConnect::FlowOutput.Protocol`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-protocol
     */
    protocol: string;
    /**
     * `AWS::MediaConnect::FlowOutput.CidrAllowList`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-cidrallowlist
     */
    cidrAllowList: string[] | undefined;
    /**
     * `AWS::MediaConnect::FlowOutput.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-description
     */
    description: string | undefined;
    /**
     * `AWS::MediaConnect::FlowOutput.Destination`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-destination
     */
    destination: string | undefined;
    /**
     * `AWS::MediaConnect::FlowOutput.Encryption`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-encryption
     */
    encryption: CfnFlowOutput.EncryptionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaConnect::FlowOutput.MaxLatency`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-maxlatency
     */
    maxLatency: number | undefined;
    /**
     * `AWS::MediaConnect::FlowOutput.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-name
     */
    name: string | undefined;
    /**
     * `AWS::MediaConnect::FlowOutput.Port`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-port
     */
    port: number | undefined;
    /**
     * `AWS::MediaConnect::FlowOutput.RemoteId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-remoteid
     */
    remoteId: string | undefined;
    /**
     * `AWS::MediaConnect::FlowOutput.SmoothingLatency`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-smoothinglatency
     */
    smoothingLatency: number | undefined;
    /**
     * `AWS::MediaConnect::FlowOutput.StreamId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-streamid
     */
    streamId: string | undefined;
    /**
     * `AWS::MediaConnect::FlowOutput.VpcInterfaceAttachment`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-vpcinterfaceattachment
     */
    vpcInterfaceAttachment: CfnFlowOutput.VpcInterfaceAttachmentProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::MediaConnect::FlowOutput`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFlowOutputProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::MediaConnect::FlowOutput`.
 *
 * @external
 * @cloudformationResource AWS::MediaConnect::FlowOutput
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html
 */
export declare namespace CfnFlowOutput {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-encryption.html
     */
    interface EncryptionProperty {
        /**
         * `CfnFlowOutput.EncryptionProperty.Algorithm`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-encryption.html#cfn-mediaconnect-flowoutput-encryption-algorithm
         */
        readonly algorithm: string;
        /**
         * `CfnFlowOutput.EncryptionProperty.KeyType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-encryption.html#cfn-mediaconnect-flowoutput-encryption-keytype
         */
        readonly keyType?: string;
        /**
         * `CfnFlowOutput.EncryptionProperty.RoleArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-encryption.html#cfn-mediaconnect-flowoutput-encryption-rolearn
         */
        readonly roleArn: string;
        /**
         * `CfnFlowOutput.EncryptionProperty.SecretArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-encryption.html#cfn-mediaconnect-flowoutput-encryption-secretarn
         */
        readonly secretArn: string;
    }
}
/**
 * A CloudFormation `AWS::MediaConnect::FlowOutput`.
 *
 * @external
 * @cloudformationResource AWS::MediaConnect::FlowOutput
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html
 */
export declare namespace CfnFlowOutput {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-vpcinterfaceattachment.html
     */
    interface VpcInterfaceAttachmentProperty {
        /**
         * `CfnFlowOutput.VpcInterfaceAttachmentProperty.VpcInterfaceName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-vpcinterfaceattachment.html#cfn-mediaconnect-flowoutput-vpcinterfaceattachment-vpcinterfacename
         */
        readonly vpcInterfaceName?: string;
    }
}
/**
 * Properties for defining a `AWS::MediaConnect::FlowSource`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html
 */
export interface CfnFlowSourceProps {
    /**
     * `AWS::MediaConnect::FlowSource.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-description
     */
    readonly description: string;
    /**
     * `AWS::MediaConnect::FlowSource.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-name
     */
    readonly name: string;
    /**
     * `AWS::MediaConnect::FlowSource.Decryption`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-decryption
     */
    readonly decryption?: CfnFlowSource.EncryptionProperty | cdk.IResolvable;
    /**
     * `AWS::MediaConnect::FlowSource.EntitlementArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-entitlementarn
     */
    readonly entitlementArn?: string;
    /**
     * `AWS::MediaConnect::FlowSource.FlowArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-flowarn
     */
    readonly flowArn?: string;
    /**
     * `AWS::MediaConnect::FlowSource.IngestPort`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-ingestport
     */
    readonly ingestPort?: number;
    /**
     * `AWS::MediaConnect::FlowSource.MaxBitrate`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-maxbitrate
     */
    readonly maxBitrate?: number;
    /**
     * `AWS::MediaConnect::FlowSource.MaxLatency`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-maxlatency
     */
    readonly maxLatency?: number;
    /**
     * `AWS::MediaConnect::FlowSource.Protocol`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-protocol
     */
    readonly protocol?: string;
    /**
     * `AWS::MediaConnect::FlowSource.StreamId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-streamid
     */
    readonly streamId?: string;
    /**
     * `AWS::MediaConnect::FlowSource.VpcInterfaceName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-vpcinterfacename
     */
    readonly vpcInterfaceName?: string;
    /**
     * `AWS::MediaConnect::FlowSource.WhitelistCidr`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-whitelistcidr
     */
    readonly whitelistCidr?: string;
}
/**
 * A CloudFormation `AWS::MediaConnect::FlowSource`.
 *
 * @external
 * @cloudformationResource AWS::MediaConnect::FlowSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html
 */
export declare class CfnFlowSource extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MediaConnect::FlowSource";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnFlowSource;
    /**
     * @external
     * @cloudformationAttribute IngestIp
     */
    readonly attrIngestIp: string;
    /**
     * @external
     * @cloudformationAttribute SourceArn
     */
    readonly attrSourceArn: string;
    /**
     * `AWS::MediaConnect::FlowSource.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-description
     */
    description: string;
    /**
     * `AWS::MediaConnect::FlowSource.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-name
     */
    name: string;
    /**
     * `AWS::MediaConnect::FlowSource.Decryption`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-decryption
     */
    decryption: CfnFlowSource.EncryptionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaConnect::FlowSource.EntitlementArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-entitlementarn
     */
    entitlementArn: string | undefined;
    /**
     * `AWS::MediaConnect::FlowSource.FlowArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-flowarn
     */
    flowArn: string | undefined;
    /**
     * `AWS::MediaConnect::FlowSource.IngestPort`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-ingestport
     */
    ingestPort: number | undefined;
    /**
     * `AWS::MediaConnect::FlowSource.MaxBitrate`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-maxbitrate
     */
    maxBitrate: number | undefined;
    /**
     * `AWS::MediaConnect::FlowSource.MaxLatency`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-maxlatency
     */
    maxLatency: number | undefined;
    /**
     * `AWS::MediaConnect::FlowSource.Protocol`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-protocol
     */
    protocol: string | undefined;
    /**
     * `AWS::MediaConnect::FlowSource.StreamId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-streamid
     */
    streamId: string | undefined;
    /**
     * `AWS::MediaConnect::FlowSource.VpcInterfaceName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-vpcinterfacename
     */
    vpcInterfaceName: string | undefined;
    /**
     * `AWS::MediaConnect::FlowSource.WhitelistCidr`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-whitelistcidr
     */
    whitelistCidr: string | undefined;
    /**
     * Create a new `AWS::MediaConnect::FlowSource`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFlowSourceProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::MediaConnect::FlowSource`.
 *
 * @external
 * @cloudformationResource AWS::MediaConnect::FlowSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html
 */
export declare namespace CfnFlowSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html
     */
    interface EncryptionProperty {
        /**
         * `CfnFlowSource.EncryptionProperty.Algorithm`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html#cfn-mediaconnect-flowsource-encryption-algorithm
         */
        readonly algorithm: string;
        /**
         * `CfnFlowSource.EncryptionProperty.ConstantInitializationVector`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html#cfn-mediaconnect-flowsource-encryption-constantinitializationvector
         */
        readonly constantInitializationVector?: string;
        /**
         * `CfnFlowSource.EncryptionProperty.DeviceId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html#cfn-mediaconnect-flowsource-encryption-deviceid
         */
        readonly deviceId?: string;
        /**
         * `CfnFlowSource.EncryptionProperty.KeyType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html#cfn-mediaconnect-flowsource-encryption-keytype
         */
        readonly keyType?: string;
        /**
         * `CfnFlowSource.EncryptionProperty.Region`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html#cfn-mediaconnect-flowsource-encryption-region
         */
        readonly region?: string;
        /**
         * `CfnFlowSource.EncryptionProperty.ResourceId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html#cfn-mediaconnect-flowsource-encryption-resourceid
         */
        readonly resourceId?: string;
        /**
         * `CfnFlowSource.EncryptionProperty.RoleArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html#cfn-mediaconnect-flowsource-encryption-rolearn
         */
        readonly roleArn: string;
        /**
         * `CfnFlowSource.EncryptionProperty.SecretArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html#cfn-mediaconnect-flowsource-encryption-secretarn
         */
        readonly secretArn?: string;
        /**
         * `CfnFlowSource.EncryptionProperty.Url`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html#cfn-mediaconnect-flowsource-encryption-url
         */
        readonly url?: string;
    }
}
/**
 * Properties for defining a `AWS::MediaConnect::FlowVpcInterface`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowvpcinterface.html
 */
export interface CfnFlowVpcInterfaceProps {
    /**
     * `AWS::MediaConnect::FlowVpcInterface.FlowArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowvpcinterface.html#cfn-mediaconnect-flowvpcinterface-flowarn
     */
    readonly flowArn: string;
    /**
     * `AWS::MediaConnect::FlowVpcInterface.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowvpcinterface.html#cfn-mediaconnect-flowvpcinterface-name
     */
    readonly name: string;
    /**
     * `AWS::MediaConnect::FlowVpcInterface.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowvpcinterface.html#cfn-mediaconnect-flowvpcinterface-rolearn
     */
    readonly roleArn: string;
    /**
     * `AWS::MediaConnect::FlowVpcInterface.SecurityGroupIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowvpcinterface.html#cfn-mediaconnect-flowvpcinterface-securitygroupids
     */
    readonly securityGroupIds: string[];
    /**
     * `AWS::MediaConnect::FlowVpcInterface.SubnetId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowvpcinterface.html#cfn-mediaconnect-flowvpcinterface-subnetid
     */
    readonly subnetId: string;
}
/**
 * A CloudFormation `AWS::MediaConnect::FlowVpcInterface`.
 *
 * @external
 * @cloudformationResource AWS::MediaConnect::FlowVpcInterface
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowvpcinterface.html
 */
export declare class CfnFlowVpcInterface extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MediaConnect::FlowVpcInterface";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnFlowVpcInterface;
    /**
     * @external
     * @cloudformationAttribute NetworkInterfaceIds
     */
    readonly attrNetworkInterfaceIds: string[];
    /**
     * `AWS::MediaConnect::FlowVpcInterface.FlowArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowvpcinterface.html#cfn-mediaconnect-flowvpcinterface-flowarn
     */
    flowArn: string;
    /**
     * `AWS::MediaConnect::FlowVpcInterface.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowvpcinterface.html#cfn-mediaconnect-flowvpcinterface-name
     */
    name: string;
    /**
     * `AWS::MediaConnect::FlowVpcInterface.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowvpcinterface.html#cfn-mediaconnect-flowvpcinterface-rolearn
     */
    roleArn: string;
    /**
     * `AWS::MediaConnect::FlowVpcInterface.SecurityGroupIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowvpcinterface.html#cfn-mediaconnect-flowvpcinterface-securitygroupids
     */
    securityGroupIds: string[];
    /**
     * `AWS::MediaConnect::FlowVpcInterface.SubnetId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowvpcinterface.html#cfn-mediaconnect-flowvpcinterface-subnetid
     */
    subnetId: string;
    /**
     * Create a new `AWS::MediaConnect::FlowVpcInterface`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFlowVpcInterfaceProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
