"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Redis = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const service_deployment_1 = require("./service-deployment");
class Redis extends constructs_1.Construct {
    constructor(scope, id, options = {}) {
        var _b;
        super(scope, id);
        const primary = new service_deployment_1.ServiceDeployment(this, 'primary', {
            image: 'k8s.gcr.io/redis:e2e',
            containerPort: 6379,
            externalPort: 6379,
            containerName: 'primary',
            env: { GET_HOSTS_FROM: 'dns' },
            labels: {
                app: 'redis',
                role: 'primary',
                ...options.labels,
            },
        });
        this.primaryHost = primary.host;
        const replicas = (_b = options.replicas) !== null && _b !== void 0 ? _b : 2;
        if (replicas > 0) {
            const replica = new service_deployment_1.ServiceDeployment(this, 'replica', {
                image: 'gcr.io/google_samples/gb-redisslave:v1',
                containerName: 'replica',
                containerPort: 6379,
                externalPort: 6379,
                env: { GET_HOSTS_FROM: 'env', REDIS_MASTER_SERVICE_HOST: this.primaryHost },
                replicas: replicas,
                labels: {
                    app: 'redis',
                    role: 'replica',
                    ...options.labels,
                },
            });
            this.replicaHost = replica.host;
        }
        else {
            // if we have no slave, then use the same host as the primary
            this.replicaHost = primary.host;
        }
    }
}
exports.Redis = Redis;
_a = JSII_RTTI_SYMBOL_1;
Redis[_a] = { fqn: "cdk8s-redis.Redis", version: "0.1.278" };
//# sourceMappingURL=data:application/json;base64,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