# Copyright 2004-2021 Bright Computing Holding BV
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""Blobs of text common to multiple packages, or simply too long."""
from __future__ import absolute_import

import textwrap

HR = "-" * 69

CONFIG_GENERATE_DESC = textwrap.dedent("""
This command generates a config files to stdout.
Redirect the stdout to a file to save it as a config file. Run the tool with Use '-c <path>' to
use it later. Save to ~/cm-cluster-on-demand.conf to always load it automatically.
""")

CONFIG_GENERATE_MINIMAL = textwrap.dedent("""
Only include the minimal subset of values in the config files. Value included are defaults which
typically have to be configure. The omitted values will use defaults
""")

CONFIG_GENERATE_RUNTIME = textwrap.dedent("""
Embed the runtime config values (determined from other config files) in the
config, instead of the basic defaults. Useful for enforcing the current runtime values event if
the underlying config values change.
""")


CONFIG_SHOW = textwrap.dedent("""
This command display a preview of the current runtime configuration. That is, after loading
any present config files, environment variables, command line arguments, and overlaying all
of those on each other.
""")


OPENSTACK_CLUSTER_CREATE_DESC = textwrap.dedent("""
This command creates a new cluster in OpenStack. It will create the head node, compute nodes,
and the networking required for the cluster to work.

By default the name of the cluster is autogenerated from the selected/implied version
and distribution, and optionally appended with a label.

If you want to force a full name for a cluster, use --name
""")
