CREATE EXTENSION IF NOT EXISTS postgis;
CREATE SCHEMA IF NOT EXISTS partman;
CREATE EXTENSION IF NOT EXISTS pg_partman SCHEMA partman;
create schema if not exists "pgstac";

create table "pgstac"."collections" (
    "id" character varying not null generated always as ((content ->> 'id'::text)) stored,
    "content" jsonb
);


create table "pgstac"."items" (
    "id" character varying not null generated always as ((content ->> 'id'::text)) stored,
    "content" jsonb
);


create table "pgstac"."items_search" (
    "id" text not null,
    "geometry" geometry not null,
    "properties" jsonb,
    "collection_id" text not null,
    "datetime" timestamp with time zone not null
) partition by RANGE (datetime);


create table "pgstac"."items_search_default" partition of "pgstac"."items_search" DEFAULT;


create table "pgstac"."items_search_p1999w52" partition of "pgstac"."items_search" FOR VALUES FROM ('1999-12-27 00:00:00+00') TO ('2000-01-03 00:00:00+00');


create table "pgstac"."items_search_p2000w01" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-01-03 00:00:00+00') TO ('2000-01-10 00:00:00+00');


create table "pgstac"."items_search_p2000w02" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-01-10 00:00:00+00') TO ('2000-01-17 00:00:00+00');


create table "pgstac"."items_search_p2000w03" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-01-17 00:00:00+00') TO ('2000-01-24 00:00:00+00');


create table "pgstac"."items_search_p2000w04" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-01-24 00:00:00+00') TO ('2000-01-31 00:00:00+00');


create table "pgstac"."items_search_p2000w05" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-01-31 00:00:00+00') TO ('2000-02-07 00:00:00+00');


create table "pgstac"."items_search_p2000w06" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-02-07 00:00:00+00') TO ('2000-02-14 00:00:00+00');


create table "pgstac"."items_search_p2000w07" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-02-14 00:00:00+00') TO ('2000-02-21 00:00:00+00');


create table "pgstac"."items_search_p2000w08" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-02-21 00:00:00+00') TO ('2000-02-28 00:00:00+00');


create table "pgstac"."items_search_p2000w09" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-02-28 00:00:00+00') TO ('2000-03-06 00:00:00+00');


create table "pgstac"."items_search_p2000w10" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-03-06 00:00:00+00') TO ('2000-03-13 00:00:00+00');


create table "pgstac"."items_search_p2000w11" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-03-13 00:00:00+00') TO ('2000-03-20 00:00:00+00');


create table "pgstac"."items_search_p2000w12" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-03-20 00:00:00+00') TO ('2000-03-27 00:00:00+00');


create table "pgstac"."items_search_p2000w13" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-03-27 00:00:00+00') TO ('2000-04-03 00:00:00+00');


create table "pgstac"."items_search_p2000w14" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-04-03 00:00:00+00') TO ('2000-04-10 00:00:00+00');


create table "pgstac"."items_search_p2000w15" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-04-10 00:00:00+00') TO ('2000-04-17 00:00:00+00');


create table "pgstac"."items_search_p2000w16" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-04-17 00:00:00+00') TO ('2000-04-24 00:00:00+00');


create table "pgstac"."items_search_p2000w17" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-04-24 00:00:00+00') TO ('2000-05-01 00:00:00+00');


create table "pgstac"."items_search_p2000w18" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-05-01 00:00:00+00') TO ('2000-05-08 00:00:00+00');


create table "pgstac"."items_search_p2000w19" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-05-08 00:00:00+00') TO ('2000-05-15 00:00:00+00');


create table "pgstac"."items_search_p2000w20" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-05-15 00:00:00+00') TO ('2000-05-22 00:00:00+00');


create table "pgstac"."items_search_p2000w21" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-05-22 00:00:00+00') TO ('2000-05-29 00:00:00+00');


create table "pgstac"."items_search_p2000w22" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-05-29 00:00:00+00') TO ('2000-06-05 00:00:00+00');


create table "pgstac"."items_search_p2000w23" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-06-05 00:00:00+00') TO ('2000-06-12 00:00:00+00');


create table "pgstac"."items_search_p2000w24" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-06-12 00:00:00+00') TO ('2000-06-19 00:00:00+00');


create table "pgstac"."items_search_p2000w25" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-06-19 00:00:00+00') TO ('2000-06-26 00:00:00+00');


create table "pgstac"."items_search_p2000w26" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-06-26 00:00:00+00') TO ('2000-07-03 00:00:00+00');


create table "pgstac"."items_search_p2000w27" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-07-03 00:00:00+00') TO ('2000-07-10 00:00:00+00');


create table "pgstac"."items_search_p2000w28" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-07-10 00:00:00+00') TO ('2000-07-17 00:00:00+00');


create table "pgstac"."items_search_p2000w29" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-07-17 00:00:00+00') TO ('2000-07-24 00:00:00+00');


create table "pgstac"."items_search_p2000w30" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-07-24 00:00:00+00') TO ('2000-07-31 00:00:00+00');


create table "pgstac"."items_search_p2000w31" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-07-31 00:00:00+00') TO ('2000-08-07 00:00:00+00');


create table "pgstac"."items_search_p2000w32" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-08-07 00:00:00+00') TO ('2000-08-14 00:00:00+00');


create table "pgstac"."items_search_p2000w33" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-08-14 00:00:00+00') TO ('2000-08-21 00:00:00+00');


create table "pgstac"."items_search_p2000w34" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-08-21 00:00:00+00') TO ('2000-08-28 00:00:00+00');


create table "pgstac"."items_search_p2000w35" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-08-28 00:00:00+00') TO ('2000-09-04 00:00:00+00');


create table "pgstac"."items_search_p2000w36" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-09-04 00:00:00+00') TO ('2000-09-11 00:00:00+00');


create table "pgstac"."items_search_p2000w37" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-09-11 00:00:00+00') TO ('2000-09-18 00:00:00+00');


create table "pgstac"."items_search_p2000w38" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-09-18 00:00:00+00') TO ('2000-09-25 00:00:00+00');


create table "pgstac"."items_search_p2000w39" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-09-25 00:00:00+00') TO ('2000-10-02 00:00:00+00');


create table "pgstac"."items_search_p2000w40" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-10-02 00:00:00+00') TO ('2000-10-09 00:00:00+00');


create table "pgstac"."items_search_p2000w41" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-10-09 00:00:00+00') TO ('2000-10-16 00:00:00+00');


create table "pgstac"."items_search_p2000w42" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-10-16 00:00:00+00') TO ('2000-10-23 00:00:00+00');


create table "pgstac"."items_search_p2000w43" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-10-23 00:00:00+00') TO ('2000-10-30 00:00:00+00');


create table "pgstac"."items_search_p2000w44" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-10-30 00:00:00+00') TO ('2000-11-06 00:00:00+00');


create table "pgstac"."items_search_p2000w45" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-11-06 00:00:00+00') TO ('2000-11-13 00:00:00+00');


create table "pgstac"."items_search_p2000w46" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-11-13 00:00:00+00') TO ('2000-11-20 00:00:00+00');


create table "pgstac"."items_search_p2000w47" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-11-20 00:00:00+00') TO ('2000-11-27 00:00:00+00');


create table "pgstac"."items_search_p2000w48" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-11-27 00:00:00+00') TO ('2000-12-04 00:00:00+00');


create table "pgstac"."items_search_p2000w49" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-12-04 00:00:00+00') TO ('2000-12-11 00:00:00+00');


create table "pgstac"."items_search_p2000w50" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-12-11 00:00:00+00') TO ('2000-12-18 00:00:00+00');


create table "pgstac"."items_search_p2000w51" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-12-18 00:00:00+00') TO ('2000-12-25 00:00:00+00');


create table "pgstac"."items_search_p2000w52" partition of "pgstac"."items_search" FOR VALUES FROM ('2000-12-25 00:00:00+00') TO ('2001-01-01 00:00:00+00');


create table "pgstac"."items_search_p2001w01" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-01-01 00:00:00+00') TO ('2001-01-08 00:00:00+00');


create table "pgstac"."items_search_p2001w02" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-01-08 00:00:00+00') TO ('2001-01-15 00:00:00+00');


create table "pgstac"."items_search_p2001w03" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-01-15 00:00:00+00') TO ('2001-01-22 00:00:00+00');


create table "pgstac"."items_search_p2001w04" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-01-22 00:00:00+00') TO ('2001-01-29 00:00:00+00');


create table "pgstac"."items_search_p2001w05" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-01-29 00:00:00+00') TO ('2001-02-05 00:00:00+00');


create table "pgstac"."items_search_p2001w06" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-02-05 00:00:00+00') TO ('2001-02-12 00:00:00+00');


create table "pgstac"."items_search_p2001w07" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-02-12 00:00:00+00') TO ('2001-02-19 00:00:00+00');


create table "pgstac"."items_search_p2001w08" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-02-19 00:00:00+00') TO ('2001-02-26 00:00:00+00');


create table "pgstac"."items_search_p2001w09" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-02-26 00:00:00+00') TO ('2001-03-05 00:00:00+00');


create table "pgstac"."items_search_p2001w10" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-03-05 00:00:00+00') TO ('2001-03-12 00:00:00+00');


create table "pgstac"."items_search_p2001w11" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-03-12 00:00:00+00') TO ('2001-03-19 00:00:00+00');


create table "pgstac"."items_search_p2001w12" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-03-19 00:00:00+00') TO ('2001-03-26 00:00:00+00');


create table "pgstac"."items_search_p2001w13" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-03-26 00:00:00+00') TO ('2001-04-02 00:00:00+00');


create table "pgstac"."items_search_p2001w14" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-04-02 00:00:00+00') TO ('2001-04-09 00:00:00+00');


create table "pgstac"."items_search_p2001w15" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-04-09 00:00:00+00') TO ('2001-04-16 00:00:00+00');


create table "pgstac"."items_search_p2001w16" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-04-16 00:00:00+00') TO ('2001-04-23 00:00:00+00');


create table "pgstac"."items_search_p2001w17" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-04-23 00:00:00+00') TO ('2001-04-30 00:00:00+00');


create table "pgstac"."items_search_p2001w18" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-04-30 00:00:00+00') TO ('2001-05-07 00:00:00+00');


create table "pgstac"."items_search_p2001w19" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-05-07 00:00:00+00') TO ('2001-05-14 00:00:00+00');


create table "pgstac"."items_search_p2001w20" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-05-14 00:00:00+00') TO ('2001-05-21 00:00:00+00');


create table "pgstac"."items_search_p2001w21" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-05-21 00:00:00+00') TO ('2001-05-28 00:00:00+00');


create table "pgstac"."items_search_p2001w22" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-05-28 00:00:00+00') TO ('2001-06-04 00:00:00+00');


create table "pgstac"."items_search_p2001w23" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-06-04 00:00:00+00') TO ('2001-06-11 00:00:00+00');


create table "pgstac"."items_search_p2001w24" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-06-11 00:00:00+00') TO ('2001-06-18 00:00:00+00');


create table "pgstac"."items_search_p2001w25" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-06-18 00:00:00+00') TO ('2001-06-25 00:00:00+00');


create table "pgstac"."items_search_p2001w26" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-06-25 00:00:00+00') TO ('2001-07-02 00:00:00+00');


create table "pgstac"."items_search_p2001w27" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-07-02 00:00:00+00') TO ('2001-07-09 00:00:00+00');


create table "pgstac"."items_search_p2001w28" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-07-09 00:00:00+00') TO ('2001-07-16 00:00:00+00');


create table "pgstac"."items_search_p2001w29" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-07-16 00:00:00+00') TO ('2001-07-23 00:00:00+00');


create table "pgstac"."items_search_p2001w30" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-07-23 00:00:00+00') TO ('2001-07-30 00:00:00+00');


create table "pgstac"."items_search_p2001w31" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-07-30 00:00:00+00') TO ('2001-08-06 00:00:00+00');


create table "pgstac"."items_search_p2001w32" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-08-06 00:00:00+00') TO ('2001-08-13 00:00:00+00');


create table "pgstac"."items_search_p2001w33" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-08-13 00:00:00+00') TO ('2001-08-20 00:00:00+00');


create table "pgstac"."items_search_p2001w34" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-08-20 00:00:00+00') TO ('2001-08-27 00:00:00+00');


create table "pgstac"."items_search_p2001w35" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-08-27 00:00:00+00') TO ('2001-09-03 00:00:00+00');


create table "pgstac"."items_search_p2001w36" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-09-03 00:00:00+00') TO ('2001-09-10 00:00:00+00');


create table "pgstac"."items_search_p2001w37" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-09-10 00:00:00+00') TO ('2001-09-17 00:00:00+00');


create table "pgstac"."items_search_p2001w38" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-09-17 00:00:00+00') TO ('2001-09-24 00:00:00+00');


create table "pgstac"."items_search_p2001w39" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-09-24 00:00:00+00') TO ('2001-10-01 00:00:00+00');


create table "pgstac"."items_search_p2001w40" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-10-01 00:00:00+00') TO ('2001-10-08 00:00:00+00');


create table "pgstac"."items_search_p2001w41" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-10-08 00:00:00+00') TO ('2001-10-15 00:00:00+00');


create table "pgstac"."items_search_p2001w42" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-10-15 00:00:00+00') TO ('2001-10-22 00:00:00+00');


create table "pgstac"."items_search_p2001w43" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-10-22 00:00:00+00') TO ('2001-10-29 00:00:00+00');


create table "pgstac"."items_search_p2001w44" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-10-29 00:00:00+00') TO ('2001-11-05 00:00:00+00');


create table "pgstac"."items_search_p2001w45" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-11-05 00:00:00+00') TO ('2001-11-12 00:00:00+00');


create table "pgstac"."items_search_p2001w46" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-11-12 00:00:00+00') TO ('2001-11-19 00:00:00+00');


create table "pgstac"."items_search_p2001w47" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-11-19 00:00:00+00') TO ('2001-11-26 00:00:00+00');


create table "pgstac"."items_search_p2001w48" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-11-26 00:00:00+00') TO ('2001-12-03 00:00:00+00');


create table "pgstac"."items_search_p2001w49" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-12-03 00:00:00+00') TO ('2001-12-10 00:00:00+00');


create table "pgstac"."items_search_p2001w50" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-12-10 00:00:00+00') TO ('2001-12-17 00:00:00+00');


create table "pgstac"."items_search_p2001w51" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-12-17 00:00:00+00') TO ('2001-12-24 00:00:00+00');


create table "pgstac"."items_search_p2001w52" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-12-24 00:00:00+00') TO ('2001-12-31 00:00:00+00');


create table "pgstac"."items_search_p2002w01" partition of "pgstac"."items_search" FOR VALUES FROM ('2001-12-31 00:00:00+00') TO ('2002-01-07 00:00:00+00');


create table "pgstac"."items_search_p2002w02" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-01-07 00:00:00+00') TO ('2002-01-14 00:00:00+00');


create table "pgstac"."items_search_p2002w03" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-01-14 00:00:00+00') TO ('2002-01-21 00:00:00+00');


create table "pgstac"."items_search_p2002w04" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-01-21 00:00:00+00') TO ('2002-01-28 00:00:00+00');


create table "pgstac"."items_search_p2002w05" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-01-28 00:00:00+00') TO ('2002-02-04 00:00:00+00');


create table "pgstac"."items_search_p2002w06" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-02-04 00:00:00+00') TO ('2002-02-11 00:00:00+00');


create table "pgstac"."items_search_p2002w07" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-02-11 00:00:00+00') TO ('2002-02-18 00:00:00+00');


create table "pgstac"."items_search_p2002w08" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-02-18 00:00:00+00') TO ('2002-02-25 00:00:00+00');


create table "pgstac"."items_search_p2002w09" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-02-25 00:00:00+00') TO ('2002-03-04 00:00:00+00');


create table "pgstac"."items_search_p2002w10" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-03-04 00:00:00+00') TO ('2002-03-11 00:00:00+00');


create table "pgstac"."items_search_p2002w11" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-03-11 00:00:00+00') TO ('2002-03-18 00:00:00+00');


create table "pgstac"."items_search_p2002w12" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-03-18 00:00:00+00') TO ('2002-03-25 00:00:00+00');


create table "pgstac"."items_search_p2002w13" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-03-25 00:00:00+00') TO ('2002-04-01 00:00:00+00');


create table "pgstac"."items_search_p2002w14" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-04-01 00:00:00+00') TO ('2002-04-08 00:00:00+00');


create table "pgstac"."items_search_p2002w15" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-04-08 00:00:00+00') TO ('2002-04-15 00:00:00+00');


create table "pgstac"."items_search_p2002w16" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-04-15 00:00:00+00') TO ('2002-04-22 00:00:00+00');


create table "pgstac"."items_search_p2002w17" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-04-22 00:00:00+00') TO ('2002-04-29 00:00:00+00');


create table "pgstac"."items_search_p2002w18" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-04-29 00:00:00+00') TO ('2002-05-06 00:00:00+00');


create table "pgstac"."items_search_p2002w19" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-05-06 00:00:00+00') TO ('2002-05-13 00:00:00+00');


create table "pgstac"."items_search_p2002w20" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-05-13 00:00:00+00') TO ('2002-05-20 00:00:00+00');


create table "pgstac"."items_search_p2002w21" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-05-20 00:00:00+00') TO ('2002-05-27 00:00:00+00');


create table "pgstac"."items_search_p2002w22" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-05-27 00:00:00+00') TO ('2002-06-03 00:00:00+00');


create table "pgstac"."items_search_p2002w23" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-06-03 00:00:00+00') TO ('2002-06-10 00:00:00+00');


create table "pgstac"."items_search_p2002w24" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-06-10 00:00:00+00') TO ('2002-06-17 00:00:00+00');


create table "pgstac"."items_search_p2002w25" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-06-17 00:00:00+00') TO ('2002-06-24 00:00:00+00');


create table "pgstac"."items_search_p2002w26" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-06-24 00:00:00+00') TO ('2002-07-01 00:00:00+00');


create table "pgstac"."items_search_p2002w27" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-07-01 00:00:00+00') TO ('2002-07-08 00:00:00+00');


create table "pgstac"."items_search_p2002w28" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-07-08 00:00:00+00') TO ('2002-07-15 00:00:00+00');


create table "pgstac"."items_search_p2002w29" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-07-15 00:00:00+00') TO ('2002-07-22 00:00:00+00');


create table "pgstac"."items_search_p2002w30" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-07-22 00:00:00+00') TO ('2002-07-29 00:00:00+00');


create table "pgstac"."items_search_p2002w31" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-07-29 00:00:00+00') TO ('2002-08-05 00:00:00+00');


create table "pgstac"."items_search_p2002w32" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-08-05 00:00:00+00') TO ('2002-08-12 00:00:00+00');


create table "pgstac"."items_search_p2002w33" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-08-12 00:00:00+00') TO ('2002-08-19 00:00:00+00');


create table "pgstac"."items_search_p2002w34" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-08-19 00:00:00+00') TO ('2002-08-26 00:00:00+00');


create table "pgstac"."items_search_p2002w35" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-08-26 00:00:00+00') TO ('2002-09-02 00:00:00+00');


create table "pgstac"."items_search_p2002w36" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-09-02 00:00:00+00') TO ('2002-09-09 00:00:00+00');


create table "pgstac"."items_search_p2002w37" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-09-09 00:00:00+00') TO ('2002-09-16 00:00:00+00');


create table "pgstac"."items_search_p2002w38" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-09-16 00:00:00+00') TO ('2002-09-23 00:00:00+00');


create table "pgstac"."items_search_p2002w39" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-09-23 00:00:00+00') TO ('2002-09-30 00:00:00+00');


create table "pgstac"."items_search_p2002w40" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-09-30 00:00:00+00') TO ('2002-10-07 00:00:00+00');


create table "pgstac"."items_search_p2002w41" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-10-07 00:00:00+00') TO ('2002-10-14 00:00:00+00');


create table "pgstac"."items_search_p2002w42" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-10-14 00:00:00+00') TO ('2002-10-21 00:00:00+00');


create table "pgstac"."items_search_p2002w43" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-10-21 00:00:00+00') TO ('2002-10-28 00:00:00+00');


create table "pgstac"."items_search_p2002w44" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-10-28 00:00:00+00') TO ('2002-11-04 00:00:00+00');


create table "pgstac"."items_search_p2002w45" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-11-04 00:00:00+00') TO ('2002-11-11 00:00:00+00');


create table "pgstac"."items_search_p2002w46" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-11-11 00:00:00+00') TO ('2002-11-18 00:00:00+00');


create table "pgstac"."items_search_p2002w47" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-11-18 00:00:00+00') TO ('2002-11-25 00:00:00+00');


create table "pgstac"."items_search_p2002w48" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-11-25 00:00:00+00') TO ('2002-12-02 00:00:00+00');


create table "pgstac"."items_search_p2002w49" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-12-02 00:00:00+00') TO ('2002-12-09 00:00:00+00');


create table "pgstac"."items_search_p2002w50" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-12-09 00:00:00+00') TO ('2002-12-16 00:00:00+00');


create table "pgstac"."items_search_p2002w51" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-12-16 00:00:00+00') TO ('2002-12-23 00:00:00+00');


create table "pgstac"."items_search_p2002w52" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-12-23 00:00:00+00') TO ('2002-12-30 00:00:00+00');


create table "pgstac"."items_search_p2003w01" partition of "pgstac"."items_search" FOR VALUES FROM ('2002-12-30 00:00:00+00') TO ('2003-01-06 00:00:00+00');


create table "pgstac"."items_search_p2003w02" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-01-06 00:00:00+00') TO ('2003-01-13 00:00:00+00');


create table "pgstac"."items_search_p2003w03" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-01-13 00:00:00+00') TO ('2003-01-20 00:00:00+00');


create table "pgstac"."items_search_p2003w04" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-01-20 00:00:00+00') TO ('2003-01-27 00:00:00+00');


create table "pgstac"."items_search_p2003w05" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-01-27 00:00:00+00') TO ('2003-02-03 00:00:00+00');


create table "pgstac"."items_search_p2003w06" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-02-03 00:00:00+00') TO ('2003-02-10 00:00:00+00');


create table "pgstac"."items_search_p2003w07" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-02-10 00:00:00+00') TO ('2003-02-17 00:00:00+00');


create table "pgstac"."items_search_p2003w08" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-02-17 00:00:00+00') TO ('2003-02-24 00:00:00+00');


create table "pgstac"."items_search_p2003w09" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-02-24 00:00:00+00') TO ('2003-03-03 00:00:00+00');


create table "pgstac"."items_search_p2003w10" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-03-03 00:00:00+00') TO ('2003-03-10 00:00:00+00');


create table "pgstac"."items_search_p2003w11" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-03-10 00:00:00+00') TO ('2003-03-17 00:00:00+00');


create table "pgstac"."items_search_p2003w12" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-03-17 00:00:00+00') TO ('2003-03-24 00:00:00+00');


create table "pgstac"."items_search_p2003w13" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-03-24 00:00:00+00') TO ('2003-03-31 00:00:00+00');


create table "pgstac"."items_search_p2003w14" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-03-31 00:00:00+00') TO ('2003-04-07 00:00:00+00');


create table "pgstac"."items_search_p2003w15" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-04-07 00:00:00+00') TO ('2003-04-14 00:00:00+00');


create table "pgstac"."items_search_p2003w16" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-04-14 00:00:00+00') TO ('2003-04-21 00:00:00+00');


create table "pgstac"."items_search_p2003w17" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-04-21 00:00:00+00') TO ('2003-04-28 00:00:00+00');


create table "pgstac"."items_search_p2003w18" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-04-28 00:00:00+00') TO ('2003-05-05 00:00:00+00');


create table "pgstac"."items_search_p2003w19" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-05-05 00:00:00+00') TO ('2003-05-12 00:00:00+00');


create table "pgstac"."items_search_p2003w20" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-05-12 00:00:00+00') TO ('2003-05-19 00:00:00+00');


create table "pgstac"."items_search_p2003w21" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-05-19 00:00:00+00') TO ('2003-05-26 00:00:00+00');


create table "pgstac"."items_search_p2003w22" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-05-26 00:00:00+00') TO ('2003-06-02 00:00:00+00');


create table "pgstac"."items_search_p2003w23" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-06-02 00:00:00+00') TO ('2003-06-09 00:00:00+00');


create table "pgstac"."items_search_p2003w24" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-06-09 00:00:00+00') TO ('2003-06-16 00:00:00+00');


create table "pgstac"."items_search_p2003w25" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-06-16 00:00:00+00') TO ('2003-06-23 00:00:00+00');


create table "pgstac"."items_search_p2003w26" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-06-23 00:00:00+00') TO ('2003-06-30 00:00:00+00');


create table "pgstac"."items_search_p2003w27" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-06-30 00:00:00+00') TO ('2003-07-07 00:00:00+00');


create table "pgstac"."items_search_p2003w28" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-07-07 00:00:00+00') TO ('2003-07-14 00:00:00+00');


create table "pgstac"."items_search_p2003w29" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-07-14 00:00:00+00') TO ('2003-07-21 00:00:00+00');


create table "pgstac"."items_search_p2003w30" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-07-21 00:00:00+00') TO ('2003-07-28 00:00:00+00');


create table "pgstac"."items_search_p2003w31" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-07-28 00:00:00+00') TO ('2003-08-04 00:00:00+00');


create table "pgstac"."items_search_p2003w32" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-08-04 00:00:00+00') TO ('2003-08-11 00:00:00+00');


create table "pgstac"."items_search_p2003w33" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-08-11 00:00:00+00') TO ('2003-08-18 00:00:00+00');


create table "pgstac"."items_search_p2003w34" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-08-18 00:00:00+00') TO ('2003-08-25 00:00:00+00');


create table "pgstac"."items_search_p2003w35" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-08-25 00:00:00+00') TO ('2003-09-01 00:00:00+00');


create table "pgstac"."items_search_p2003w36" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-09-01 00:00:00+00') TO ('2003-09-08 00:00:00+00');


create table "pgstac"."items_search_p2003w37" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-09-08 00:00:00+00') TO ('2003-09-15 00:00:00+00');


create table "pgstac"."items_search_p2003w38" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-09-15 00:00:00+00') TO ('2003-09-22 00:00:00+00');


create table "pgstac"."items_search_p2003w39" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-09-22 00:00:00+00') TO ('2003-09-29 00:00:00+00');


create table "pgstac"."items_search_p2003w40" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-09-29 00:00:00+00') TO ('2003-10-06 00:00:00+00');


create table "pgstac"."items_search_p2003w41" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-10-06 00:00:00+00') TO ('2003-10-13 00:00:00+00');


create table "pgstac"."items_search_p2003w42" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-10-13 00:00:00+00') TO ('2003-10-20 00:00:00+00');


create table "pgstac"."items_search_p2003w43" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-10-20 00:00:00+00') TO ('2003-10-27 00:00:00+00');


create table "pgstac"."items_search_p2003w44" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-10-27 00:00:00+00') TO ('2003-11-03 00:00:00+00');


create table "pgstac"."items_search_p2003w45" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-11-03 00:00:00+00') TO ('2003-11-10 00:00:00+00');


create table "pgstac"."items_search_p2003w46" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-11-10 00:00:00+00') TO ('2003-11-17 00:00:00+00');


create table "pgstac"."items_search_p2003w47" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-11-17 00:00:00+00') TO ('2003-11-24 00:00:00+00');


create table "pgstac"."items_search_p2003w48" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-11-24 00:00:00+00') TO ('2003-12-01 00:00:00+00');


create table "pgstac"."items_search_p2003w49" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-12-01 00:00:00+00') TO ('2003-12-08 00:00:00+00');


create table "pgstac"."items_search_p2003w50" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-12-08 00:00:00+00') TO ('2003-12-15 00:00:00+00');


create table "pgstac"."items_search_p2003w51" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-12-15 00:00:00+00') TO ('2003-12-22 00:00:00+00');


create table "pgstac"."items_search_p2003w52" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-12-22 00:00:00+00') TO ('2003-12-29 00:00:00+00');


create table "pgstac"."items_search_p2004w01" partition of "pgstac"."items_search" FOR VALUES FROM ('2003-12-29 00:00:00+00') TO ('2004-01-05 00:00:00+00');


create table "pgstac"."items_search_p2004w02" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-01-05 00:00:00+00') TO ('2004-01-12 00:00:00+00');


create table "pgstac"."items_search_p2004w03" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-01-12 00:00:00+00') TO ('2004-01-19 00:00:00+00');


create table "pgstac"."items_search_p2004w04" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-01-19 00:00:00+00') TO ('2004-01-26 00:00:00+00');


create table "pgstac"."items_search_p2004w05" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-01-26 00:00:00+00') TO ('2004-02-02 00:00:00+00');


create table "pgstac"."items_search_p2004w06" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-02-02 00:00:00+00') TO ('2004-02-09 00:00:00+00');


create table "pgstac"."items_search_p2004w07" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-02-09 00:00:00+00') TO ('2004-02-16 00:00:00+00');


create table "pgstac"."items_search_p2004w08" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-02-16 00:00:00+00') TO ('2004-02-23 00:00:00+00');


create table "pgstac"."items_search_p2004w09" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-02-23 00:00:00+00') TO ('2004-03-01 00:00:00+00');


create table "pgstac"."items_search_p2004w10" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-03-01 00:00:00+00') TO ('2004-03-08 00:00:00+00');


create table "pgstac"."items_search_p2004w11" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-03-08 00:00:00+00') TO ('2004-03-15 00:00:00+00');


create table "pgstac"."items_search_p2004w12" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-03-15 00:00:00+00') TO ('2004-03-22 00:00:00+00');


create table "pgstac"."items_search_p2004w13" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-03-22 00:00:00+00') TO ('2004-03-29 00:00:00+00');


create table "pgstac"."items_search_p2004w14" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-03-29 00:00:00+00') TO ('2004-04-05 00:00:00+00');


create table "pgstac"."items_search_p2004w15" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-04-05 00:00:00+00') TO ('2004-04-12 00:00:00+00');


create table "pgstac"."items_search_p2004w16" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-04-12 00:00:00+00') TO ('2004-04-19 00:00:00+00');


create table "pgstac"."items_search_p2004w17" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-04-19 00:00:00+00') TO ('2004-04-26 00:00:00+00');


create table "pgstac"."items_search_p2004w18" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-04-26 00:00:00+00') TO ('2004-05-03 00:00:00+00');


create table "pgstac"."items_search_p2004w19" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-05-03 00:00:00+00') TO ('2004-05-10 00:00:00+00');


create table "pgstac"."items_search_p2004w20" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-05-10 00:00:00+00') TO ('2004-05-17 00:00:00+00');


create table "pgstac"."items_search_p2004w21" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-05-17 00:00:00+00') TO ('2004-05-24 00:00:00+00');


create table "pgstac"."items_search_p2004w22" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-05-24 00:00:00+00') TO ('2004-05-31 00:00:00+00');


create table "pgstac"."items_search_p2004w23" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-05-31 00:00:00+00') TO ('2004-06-07 00:00:00+00');


create table "pgstac"."items_search_p2004w24" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-06-07 00:00:00+00') TO ('2004-06-14 00:00:00+00');


create table "pgstac"."items_search_p2004w25" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-06-14 00:00:00+00') TO ('2004-06-21 00:00:00+00');


create table "pgstac"."items_search_p2004w26" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-06-21 00:00:00+00') TO ('2004-06-28 00:00:00+00');


create table "pgstac"."items_search_p2004w27" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-06-28 00:00:00+00') TO ('2004-07-05 00:00:00+00');


create table "pgstac"."items_search_p2004w28" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-07-05 00:00:00+00') TO ('2004-07-12 00:00:00+00');


create table "pgstac"."items_search_p2004w29" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-07-12 00:00:00+00') TO ('2004-07-19 00:00:00+00');


create table "pgstac"."items_search_p2004w30" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-07-19 00:00:00+00') TO ('2004-07-26 00:00:00+00');


create table "pgstac"."items_search_p2004w31" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-07-26 00:00:00+00') TO ('2004-08-02 00:00:00+00');


create table "pgstac"."items_search_p2004w32" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-08-02 00:00:00+00') TO ('2004-08-09 00:00:00+00');


create table "pgstac"."items_search_p2004w33" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-08-09 00:00:00+00') TO ('2004-08-16 00:00:00+00');


create table "pgstac"."items_search_p2004w34" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-08-16 00:00:00+00') TO ('2004-08-23 00:00:00+00');


create table "pgstac"."items_search_p2004w35" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-08-23 00:00:00+00') TO ('2004-08-30 00:00:00+00');


create table "pgstac"."items_search_p2004w36" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-08-30 00:00:00+00') TO ('2004-09-06 00:00:00+00');


create table "pgstac"."items_search_p2004w37" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-09-06 00:00:00+00') TO ('2004-09-13 00:00:00+00');


create table "pgstac"."items_search_p2004w38" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-09-13 00:00:00+00') TO ('2004-09-20 00:00:00+00');


create table "pgstac"."items_search_p2004w39" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-09-20 00:00:00+00') TO ('2004-09-27 00:00:00+00');


create table "pgstac"."items_search_p2004w40" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-09-27 00:00:00+00') TO ('2004-10-04 00:00:00+00');


create table "pgstac"."items_search_p2004w41" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-10-04 00:00:00+00') TO ('2004-10-11 00:00:00+00');


create table "pgstac"."items_search_p2004w42" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-10-11 00:00:00+00') TO ('2004-10-18 00:00:00+00');


create table "pgstac"."items_search_p2004w43" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-10-18 00:00:00+00') TO ('2004-10-25 00:00:00+00');


create table "pgstac"."items_search_p2004w44" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-10-25 00:00:00+00') TO ('2004-11-01 00:00:00+00');


create table "pgstac"."items_search_p2004w45" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-11-01 00:00:00+00') TO ('2004-11-08 00:00:00+00');


create table "pgstac"."items_search_p2004w46" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-11-08 00:00:00+00') TO ('2004-11-15 00:00:00+00');


create table "pgstac"."items_search_p2004w47" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-11-15 00:00:00+00') TO ('2004-11-22 00:00:00+00');


create table "pgstac"."items_search_p2004w48" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-11-22 00:00:00+00') TO ('2004-11-29 00:00:00+00');


create table "pgstac"."items_search_p2004w49" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-11-29 00:00:00+00') TO ('2004-12-06 00:00:00+00');


create table "pgstac"."items_search_p2004w50" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-12-06 00:00:00+00') TO ('2004-12-13 00:00:00+00');


create table "pgstac"."items_search_p2004w51" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-12-13 00:00:00+00') TO ('2004-12-20 00:00:00+00');


create table "pgstac"."items_search_p2004w52" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-12-20 00:00:00+00') TO ('2004-12-27 00:00:00+00');


create table "pgstac"."items_search_p2004w53" partition of "pgstac"."items_search" FOR VALUES FROM ('2004-12-27 00:00:00+00') TO ('2005-01-03 00:00:00+00');


create table "pgstac"."items_search_p2005w01" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-01-03 00:00:00+00') TO ('2005-01-10 00:00:00+00');


create table "pgstac"."items_search_p2005w02" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-01-10 00:00:00+00') TO ('2005-01-17 00:00:00+00');


create table "pgstac"."items_search_p2005w03" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-01-17 00:00:00+00') TO ('2005-01-24 00:00:00+00');


create table "pgstac"."items_search_p2005w04" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-01-24 00:00:00+00') TO ('2005-01-31 00:00:00+00');


create table "pgstac"."items_search_p2005w05" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-01-31 00:00:00+00') TO ('2005-02-07 00:00:00+00');


create table "pgstac"."items_search_p2005w06" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-02-07 00:00:00+00') TO ('2005-02-14 00:00:00+00');


create table "pgstac"."items_search_p2005w07" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-02-14 00:00:00+00') TO ('2005-02-21 00:00:00+00');


create table "pgstac"."items_search_p2005w08" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-02-21 00:00:00+00') TO ('2005-02-28 00:00:00+00');


create table "pgstac"."items_search_p2005w09" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-02-28 00:00:00+00') TO ('2005-03-07 00:00:00+00');


create table "pgstac"."items_search_p2005w10" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-03-07 00:00:00+00') TO ('2005-03-14 00:00:00+00');


create table "pgstac"."items_search_p2005w11" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-03-14 00:00:00+00') TO ('2005-03-21 00:00:00+00');


create table "pgstac"."items_search_p2005w12" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-03-21 00:00:00+00') TO ('2005-03-28 00:00:00+00');


create table "pgstac"."items_search_p2005w13" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-03-28 00:00:00+00') TO ('2005-04-04 00:00:00+00');


create table "pgstac"."items_search_p2005w14" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-04-04 00:00:00+00') TO ('2005-04-11 00:00:00+00');


create table "pgstac"."items_search_p2005w15" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-04-11 00:00:00+00') TO ('2005-04-18 00:00:00+00');


create table "pgstac"."items_search_p2005w16" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-04-18 00:00:00+00') TO ('2005-04-25 00:00:00+00');


create table "pgstac"."items_search_p2005w17" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-04-25 00:00:00+00') TO ('2005-05-02 00:00:00+00');


create table "pgstac"."items_search_p2005w18" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-05-02 00:00:00+00') TO ('2005-05-09 00:00:00+00');


create table "pgstac"."items_search_p2005w19" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-05-09 00:00:00+00') TO ('2005-05-16 00:00:00+00');


create table "pgstac"."items_search_p2005w20" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-05-16 00:00:00+00') TO ('2005-05-23 00:00:00+00');


create table "pgstac"."items_search_p2005w21" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-05-23 00:00:00+00') TO ('2005-05-30 00:00:00+00');


create table "pgstac"."items_search_p2005w22" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-05-30 00:00:00+00') TO ('2005-06-06 00:00:00+00');


create table "pgstac"."items_search_p2005w23" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-06-06 00:00:00+00') TO ('2005-06-13 00:00:00+00');


create table "pgstac"."items_search_p2005w24" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-06-13 00:00:00+00') TO ('2005-06-20 00:00:00+00');


create table "pgstac"."items_search_p2005w25" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-06-20 00:00:00+00') TO ('2005-06-27 00:00:00+00');


create table "pgstac"."items_search_p2005w26" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-06-27 00:00:00+00') TO ('2005-07-04 00:00:00+00');


create table "pgstac"."items_search_p2005w27" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-07-04 00:00:00+00') TO ('2005-07-11 00:00:00+00');


create table "pgstac"."items_search_p2005w28" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-07-11 00:00:00+00') TO ('2005-07-18 00:00:00+00');


create table "pgstac"."items_search_p2005w29" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-07-18 00:00:00+00') TO ('2005-07-25 00:00:00+00');


create table "pgstac"."items_search_p2005w30" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-07-25 00:00:00+00') TO ('2005-08-01 00:00:00+00');


create table "pgstac"."items_search_p2005w31" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-08-01 00:00:00+00') TO ('2005-08-08 00:00:00+00');


create table "pgstac"."items_search_p2005w32" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-08-08 00:00:00+00') TO ('2005-08-15 00:00:00+00');


create table "pgstac"."items_search_p2005w33" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-08-15 00:00:00+00') TO ('2005-08-22 00:00:00+00');


create table "pgstac"."items_search_p2005w34" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-08-22 00:00:00+00') TO ('2005-08-29 00:00:00+00');


create table "pgstac"."items_search_p2005w35" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-08-29 00:00:00+00') TO ('2005-09-05 00:00:00+00');


create table "pgstac"."items_search_p2005w36" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-09-05 00:00:00+00') TO ('2005-09-12 00:00:00+00');


create table "pgstac"."items_search_p2005w37" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-09-12 00:00:00+00') TO ('2005-09-19 00:00:00+00');


create table "pgstac"."items_search_p2005w38" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-09-19 00:00:00+00') TO ('2005-09-26 00:00:00+00');


create table "pgstac"."items_search_p2005w39" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-09-26 00:00:00+00') TO ('2005-10-03 00:00:00+00');


create table "pgstac"."items_search_p2005w40" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-10-03 00:00:00+00') TO ('2005-10-10 00:00:00+00');


create table "pgstac"."items_search_p2005w41" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-10-10 00:00:00+00') TO ('2005-10-17 00:00:00+00');


create table "pgstac"."items_search_p2005w42" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-10-17 00:00:00+00') TO ('2005-10-24 00:00:00+00');


create table "pgstac"."items_search_p2005w43" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-10-24 00:00:00+00') TO ('2005-10-31 00:00:00+00');


create table "pgstac"."items_search_p2005w44" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-10-31 00:00:00+00') TO ('2005-11-07 00:00:00+00');


create table "pgstac"."items_search_p2005w45" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-11-07 00:00:00+00') TO ('2005-11-14 00:00:00+00');


create table "pgstac"."items_search_p2005w46" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-11-14 00:00:00+00') TO ('2005-11-21 00:00:00+00');


create table "pgstac"."items_search_p2005w47" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-11-21 00:00:00+00') TO ('2005-11-28 00:00:00+00');


create table "pgstac"."items_search_p2005w48" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-11-28 00:00:00+00') TO ('2005-12-05 00:00:00+00');


create table "pgstac"."items_search_p2005w49" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-12-05 00:00:00+00') TO ('2005-12-12 00:00:00+00');


create table "pgstac"."items_search_p2005w50" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-12-12 00:00:00+00') TO ('2005-12-19 00:00:00+00');


create table "pgstac"."items_search_p2005w51" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-12-19 00:00:00+00') TO ('2005-12-26 00:00:00+00');


create table "pgstac"."items_search_p2005w52" partition of "pgstac"."items_search" FOR VALUES FROM ('2005-12-26 00:00:00+00') TO ('2006-01-02 00:00:00+00');


create table "pgstac"."items_search_p2006w01" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-01-02 00:00:00+00') TO ('2006-01-09 00:00:00+00');


create table "pgstac"."items_search_p2006w02" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-01-09 00:00:00+00') TO ('2006-01-16 00:00:00+00');


create table "pgstac"."items_search_p2006w03" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-01-16 00:00:00+00') TO ('2006-01-23 00:00:00+00');


create table "pgstac"."items_search_p2006w04" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-01-23 00:00:00+00') TO ('2006-01-30 00:00:00+00');


create table "pgstac"."items_search_p2006w05" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-01-30 00:00:00+00') TO ('2006-02-06 00:00:00+00');


create table "pgstac"."items_search_p2006w06" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-02-06 00:00:00+00') TO ('2006-02-13 00:00:00+00');


create table "pgstac"."items_search_p2006w07" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-02-13 00:00:00+00') TO ('2006-02-20 00:00:00+00');


create table "pgstac"."items_search_p2006w08" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-02-20 00:00:00+00') TO ('2006-02-27 00:00:00+00');


create table "pgstac"."items_search_p2006w09" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-02-27 00:00:00+00') TO ('2006-03-06 00:00:00+00');


create table "pgstac"."items_search_p2006w10" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-03-06 00:00:00+00') TO ('2006-03-13 00:00:00+00');


create table "pgstac"."items_search_p2006w11" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-03-13 00:00:00+00') TO ('2006-03-20 00:00:00+00');


create table "pgstac"."items_search_p2006w12" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-03-20 00:00:00+00') TO ('2006-03-27 00:00:00+00');


create table "pgstac"."items_search_p2006w13" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-03-27 00:00:00+00') TO ('2006-04-03 00:00:00+00');


create table "pgstac"."items_search_p2006w14" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-04-03 00:00:00+00') TO ('2006-04-10 00:00:00+00');


create table "pgstac"."items_search_p2006w15" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-04-10 00:00:00+00') TO ('2006-04-17 00:00:00+00');


create table "pgstac"."items_search_p2006w16" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-04-17 00:00:00+00') TO ('2006-04-24 00:00:00+00');


create table "pgstac"."items_search_p2006w17" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-04-24 00:00:00+00') TO ('2006-05-01 00:00:00+00');


create table "pgstac"."items_search_p2006w18" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-05-01 00:00:00+00') TO ('2006-05-08 00:00:00+00');


create table "pgstac"."items_search_p2006w19" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-05-08 00:00:00+00') TO ('2006-05-15 00:00:00+00');


create table "pgstac"."items_search_p2006w20" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-05-15 00:00:00+00') TO ('2006-05-22 00:00:00+00');


create table "pgstac"."items_search_p2006w21" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-05-22 00:00:00+00') TO ('2006-05-29 00:00:00+00');


create table "pgstac"."items_search_p2006w22" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-05-29 00:00:00+00') TO ('2006-06-05 00:00:00+00');


create table "pgstac"."items_search_p2006w23" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-06-05 00:00:00+00') TO ('2006-06-12 00:00:00+00');


create table "pgstac"."items_search_p2006w24" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-06-12 00:00:00+00') TO ('2006-06-19 00:00:00+00');


create table "pgstac"."items_search_p2006w25" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-06-19 00:00:00+00') TO ('2006-06-26 00:00:00+00');


create table "pgstac"."items_search_p2006w26" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-06-26 00:00:00+00') TO ('2006-07-03 00:00:00+00');


create table "pgstac"."items_search_p2006w27" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-07-03 00:00:00+00') TO ('2006-07-10 00:00:00+00');


create table "pgstac"."items_search_p2006w28" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-07-10 00:00:00+00') TO ('2006-07-17 00:00:00+00');


create table "pgstac"."items_search_p2006w29" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-07-17 00:00:00+00') TO ('2006-07-24 00:00:00+00');


create table "pgstac"."items_search_p2006w30" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-07-24 00:00:00+00') TO ('2006-07-31 00:00:00+00');


create table "pgstac"."items_search_p2006w31" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-07-31 00:00:00+00') TO ('2006-08-07 00:00:00+00');


create table "pgstac"."items_search_p2006w32" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-08-07 00:00:00+00') TO ('2006-08-14 00:00:00+00');


create table "pgstac"."items_search_p2006w33" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-08-14 00:00:00+00') TO ('2006-08-21 00:00:00+00');


create table "pgstac"."items_search_p2006w34" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-08-21 00:00:00+00') TO ('2006-08-28 00:00:00+00');


create table "pgstac"."items_search_p2006w35" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-08-28 00:00:00+00') TO ('2006-09-04 00:00:00+00');


create table "pgstac"."items_search_p2006w36" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-09-04 00:00:00+00') TO ('2006-09-11 00:00:00+00');


create table "pgstac"."items_search_p2006w37" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-09-11 00:00:00+00') TO ('2006-09-18 00:00:00+00');


create table "pgstac"."items_search_p2006w38" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-09-18 00:00:00+00') TO ('2006-09-25 00:00:00+00');


create table "pgstac"."items_search_p2006w39" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-09-25 00:00:00+00') TO ('2006-10-02 00:00:00+00');


create table "pgstac"."items_search_p2006w40" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-10-02 00:00:00+00') TO ('2006-10-09 00:00:00+00');


create table "pgstac"."items_search_p2006w41" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-10-09 00:00:00+00') TO ('2006-10-16 00:00:00+00');


create table "pgstac"."items_search_p2006w42" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-10-16 00:00:00+00') TO ('2006-10-23 00:00:00+00');


create table "pgstac"."items_search_p2006w43" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-10-23 00:00:00+00') TO ('2006-10-30 00:00:00+00');


create table "pgstac"."items_search_p2006w44" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-10-30 00:00:00+00') TO ('2006-11-06 00:00:00+00');


create table "pgstac"."items_search_p2006w45" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-11-06 00:00:00+00') TO ('2006-11-13 00:00:00+00');


create table "pgstac"."items_search_p2006w46" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-11-13 00:00:00+00') TO ('2006-11-20 00:00:00+00');


create table "pgstac"."items_search_p2006w47" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-11-20 00:00:00+00') TO ('2006-11-27 00:00:00+00');


create table "pgstac"."items_search_p2006w48" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-11-27 00:00:00+00') TO ('2006-12-04 00:00:00+00');


create table "pgstac"."items_search_p2006w49" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-12-04 00:00:00+00') TO ('2006-12-11 00:00:00+00');


create table "pgstac"."items_search_p2006w50" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-12-11 00:00:00+00') TO ('2006-12-18 00:00:00+00');


create table "pgstac"."items_search_p2006w51" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-12-18 00:00:00+00') TO ('2006-12-25 00:00:00+00');


create table "pgstac"."items_search_p2006w52" partition of "pgstac"."items_search" FOR VALUES FROM ('2006-12-25 00:00:00+00') TO ('2007-01-01 00:00:00+00');


create table "pgstac"."items_search_p2007w01" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-01-01 00:00:00+00') TO ('2007-01-08 00:00:00+00');


create table "pgstac"."items_search_p2007w02" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-01-08 00:00:00+00') TO ('2007-01-15 00:00:00+00');


create table "pgstac"."items_search_p2007w03" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-01-15 00:00:00+00') TO ('2007-01-22 00:00:00+00');


create table "pgstac"."items_search_p2007w04" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-01-22 00:00:00+00') TO ('2007-01-29 00:00:00+00');


create table "pgstac"."items_search_p2007w05" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-01-29 00:00:00+00') TO ('2007-02-05 00:00:00+00');


create table "pgstac"."items_search_p2007w06" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-02-05 00:00:00+00') TO ('2007-02-12 00:00:00+00');


create table "pgstac"."items_search_p2007w07" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-02-12 00:00:00+00') TO ('2007-02-19 00:00:00+00');


create table "pgstac"."items_search_p2007w08" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-02-19 00:00:00+00') TO ('2007-02-26 00:00:00+00');


create table "pgstac"."items_search_p2007w09" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-02-26 00:00:00+00') TO ('2007-03-05 00:00:00+00');


create table "pgstac"."items_search_p2007w10" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-03-05 00:00:00+00') TO ('2007-03-12 00:00:00+00');


create table "pgstac"."items_search_p2007w11" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-03-12 00:00:00+00') TO ('2007-03-19 00:00:00+00');


create table "pgstac"."items_search_p2007w12" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-03-19 00:00:00+00') TO ('2007-03-26 00:00:00+00');


create table "pgstac"."items_search_p2007w13" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-03-26 00:00:00+00') TO ('2007-04-02 00:00:00+00');


create table "pgstac"."items_search_p2007w14" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-04-02 00:00:00+00') TO ('2007-04-09 00:00:00+00');


create table "pgstac"."items_search_p2007w15" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-04-09 00:00:00+00') TO ('2007-04-16 00:00:00+00');


create table "pgstac"."items_search_p2007w16" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-04-16 00:00:00+00') TO ('2007-04-23 00:00:00+00');


create table "pgstac"."items_search_p2007w17" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-04-23 00:00:00+00') TO ('2007-04-30 00:00:00+00');


create table "pgstac"."items_search_p2007w18" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-04-30 00:00:00+00') TO ('2007-05-07 00:00:00+00');


create table "pgstac"."items_search_p2007w19" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-05-07 00:00:00+00') TO ('2007-05-14 00:00:00+00');


create table "pgstac"."items_search_p2007w20" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-05-14 00:00:00+00') TO ('2007-05-21 00:00:00+00');


create table "pgstac"."items_search_p2007w21" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-05-21 00:00:00+00') TO ('2007-05-28 00:00:00+00');


create table "pgstac"."items_search_p2007w22" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-05-28 00:00:00+00') TO ('2007-06-04 00:00:00+00');


create table "pgstac"."items_search_p2007w23" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-06-04 00:00:00+00') TO ('2007-06-11 00:00:00+00');


create table "pgstac"."items_search_p2007w24" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-06-11 00:00:00+00') TO ('2007-06-18 00:00:00+00');


create table "pgstac"."items_search_p2007w25" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-06-18 00:00:00+00') TO ('2007-06-25 00:00:00+00');


create table "pgstac"."items_search_p2007w26" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-06-25 00:00:00+00') TO ('2007-07-02 00:00:00+00');


create table "pgstac"."items_search_p2007w27" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-07-02 00:00:00+00') TO ('2007-07-09 00:00:00+00');


create table "pgstac"."items_search_p2007w28" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-07-09 00:00:00+00') TO ('2007-07-16 00:00:00+00');


create table "pgstac"."items_search_p2007w29" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-07-16 00:00:00+00') TO ('2007-07-23 00:00:00+00');


create table "pgstac"."items_search_p2007w30" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-07-23 00:00:00+00') TO ('2007-07-30 00:00:00+00');


create table "pgstac"."items_search_p2007w31" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-07-30 00:00:00+00') TO ('2007-08-06 00:00:00+00');


create table "pgstac"."items_search_p2007w32" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-08-06 00:00:00+00') TO ('2007-08-13 00:00:00+00');


create table "pgstac"."items_search_p2007w33" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-08-13 00:00:00+00') TO ('2007-08-20 00:00:00+00');


create table "pgstac"."items_search_p2007w34" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-08-20 00:00:00+00') TO ('2007-08-27 00:00:00+00');


create table "pgstac"."items_search_p2007w35" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-08-27 00:00:00+00') TO ('2007-09-03 00:00:00+00');


create table "pgstac"."items_search_p2007w36" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-09-03 00:00:00+00') TO ('2007-09-10 00:00:00+00');


create table "pgstac"."items_search_p2007w37" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-09-10 00:00:00+00') TO ('2007-09-17 00:00:00+00');


create table "pgstac"."items_search_p2007w38" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-09-17 00:00:00+00') TO ('2007-09-24 00:00:00+00');


create table "pgstac"."items_search_p2007w39" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-09-24 00:00:00+00') TO ('2007-10-01 00:00:00+00');


create table "pgstac"."items_search_p2007w40" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-10-01 00:00:00+00') TO ('2007-10-08 00:00:00+00');


create table "pgstac"."items_search_p2007w41" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-10-08 00:00:00+00') TO ('2007-10-15 00:00:00+00');


create table "pgstac"."items_search_p2007w42" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-10-15 00:00:00+00') TO ('2007-10-22 00:00:00+00');


create table "pgstac"."items_search_p2007w43" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-10-22 00:00:00+00') TO ('2007-10-29 00:00:00+00');


create table "pgstac"."items_search_p2007w44" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-10-29 00:00:00+00') TO ('2007-11-05 00:00:00+00');


create table "pgstac"."items_search_p2007w45" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-11-05 00:00:00+00') TO ('2007-11-12 00:00:00+00');


create table "pgstac"."items_search_p2007w46" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-11-12 00:00:00+00') TO ('2007-11-19 00:00:00+00');


create table "pgstac"."items_search_p2007w47" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-11-19 00:00:00+00') TO ('2007-11-26 00:00:00+00');


create table "pgstac"."items_search_p2007w48" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-11-26 00:00:00+00') TO ('2007-12-03 00:00:00+00');


create table "pgstac"."items_search_p2007w49" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-12-03 00:00:00+00') TO ('2007-12-10 00:00:00+00');


create table "pgstac"."items_search_p2007w50" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-12-10 00:00:00+00') TO ('2007-12-17 00:00:00+00');


create table "pgstac"."items_search_p2007w51" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-12-17 00:00:00+00') TO ('2007-12-24 00:00:00+00');


create table "pgstac"."items_search_p2007w52" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-12-24 00:00:00+00') TO ('2007-12-31 00:00:00+00');


create table "pgstac"."items_search_p2008w01" partition of "pgstac"."items_search" FOR VALUES FROM ('2007-12-31 00:00:00+00') TO ('2008-01-07 00:00:00+00');


create table "pgstac"."items_search_p2008w02" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-01-07 00:00:00+00') TO ('2008-01-14 00:00:00+00');


create table "pgstac"."items_search_p2008w03" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-01-14 00:00:00+00') TO ('2008-01-21 00:00:00+00');


create table "pgstac"."items_search_p2008w04" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-01-21 00:00:00+00') TO ('2008-01-28 00:00:00+00');


create table "pgstac"."items_search_p2008w05" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-01-28 00:00:00+00') TO ('2008-02-04 00:00:00+00');


create table "pgstac"."items_search_p2008w06" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-02-04 00:00:00+00') TO ('2008-02-11 00:00:00+00');


create table "pgstac"."items_search_p2008w07" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-02-11 00:00:00+00') TO ('2008-02-18 00:00:00+00');


create table "pgstac"."items_search_p2008w08" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-02-18 00:00:00+00') TO ('2008-02-25 00:00:00+00');


create table "pgstac"."items_search_p2008w09" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-02-25 00:00:00+00') TO ('2008-03-03 00:00:00+00');


create table "pgstac"."items_search_p2008w10" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-03-03 00:00:00+00') TO ('2008-03-10 00:00:00+00');


create table "pgstac"."items_search_p2008w11" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-03-10 00:00:00+00') TO ('2008-03-17 00:00:00+00');


create table "pgstac"."items_search_p2008w12" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-03-17 00:00:00+00') TO ('2008-03-24 00:00:00+00');


create table "pgstac"."items_search_p2008w13" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-03-24 00:00:00+00') TO ('2008-03-31 00:00:00+00');


create table "pgstac"."items_search_p2008w14" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-03-31 00:00:00+00') TO ('2008-04-07 00:00:00+00');


create table "pgstac"."items_search_p2008w15" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-04-07 00:00:00+00') TO ('2008-04-14 00:00:00+00');


create table "pgstac"."items_search_p2008w16" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-04-14 00:00:00+00') TO ('2008-04-21 00:00:00+00');


create table "pgstac"."items_search_p2008w17" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-04-21 00:00:00+00') TO ('2008-04-28 00:00:00+00');


create table "pgstac"."items_search_p2008w18" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-04-28 00:00:00+00') TO ('2008-05-05 00:00:00+00');


create table "pgstac"."items_search_p2008w19" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-05-05 00:00:00+00') TO ('2008-05-12 00:00:00+00');


create table "pgstac"."items_search_p2008w20" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-05-12 00:00:00+00') TO ('2008-05-19 00:00:00+00');


create table "pgstac"."items_search_p2008w21" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-05-19 00:00:00+00') TO ('2008-05-26 00:00:00+00');


create table "pgstac"."items_search_p2008w22" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-05-26 00:00:00+00') TO ('2008-06-02 00:00:00+00');


create table "pgstac"."items_search_p2008w23" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-06-02 00:00:00+00') TO ('2008-06-09 00:00:00+00');


create table "pgstac"."items_search_p2008w24" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-06-09 00:00:00+00') TO ('2008-06-16 00:00:00+00');


create table "pgstac"."items_search_p2008w25" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-06-16 00:00:00+00') TO ('2008-06-23 00:00:00+00');


create table "pgstac"."items_search_p2008w26" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-06-23 00:00:00+00') TO ('2008-06-30 00:00:00+00');


create table "pgstac"."items_search_p2008w27" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-06-30 00:00:00+00') TO ('2008-07-07 00:00:00+00');


create table "pgstac"."items_search_p2008w28" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-07-07 00:00:00+00') TO ('2008-07-14 00:00:00+00');


create table "pgstac"."items_search_p2008w29" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-07-14 00:00:00+00') TO ('2008-07-21 00:00:00+00');


create table "pgstac"."items_search_p2008w30" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-07-21 00:00:00+00') TO ('2008-07-28 00:00:00+00');


create table "pgstac"."items_search_p2008w31" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-07-28 00:00:00+00') TO ('2008-08-04 00:00:00+00');


create table "pgstac"."items_search_p2008w32" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-08-04 00:00:00+00') TO ('2008-08-11 00:00:00+00');


create table "pgstac"."items_search_p2008w33" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-08-11 00:00:00+00') TO ('2008-08-18 00:00:00+00');


create table "pgstac"."items_search_p2008w34" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-08-18 00:00:00+00') TO ('2008-08-25 00:00:00+00');


create table "pgstac"."items_search_p2008w35" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-08-25 00:00:00+00') TO ('2008-09-01 00:00:00+00');


create table "pgstac"."items_search_p2008w36" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-09-01 00:00:00+00') TO ('2008-09-08 00:00:00+00');


create table "pgstac"."items_search_p2008w37" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-09-08 00:00:00+00') TO ('2008-09-15 00:00:00+00');


create table "pgstac"."items_search_p2008w38" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-09-15 00:00:00+00') TO ('2008-09-22 00:00:00+00');


create table "pgstac"."items_search_p2008w39" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-09-22 00:00:00+00') TO ('2008-09-29 00:00:00+00');


create table "pgstac"."items_search_p2008w40" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-09-29 00:00:00+00') TO ('2008-10-06 00:00:00+00');


create table "pgstac"."items_search_p2008w41" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-10-06 00:00:00+00') TO ('2008-10-13 00:00:00+00');


create table "pgstac"."items_search_p2008w42" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-10-13 00:00:00+00') TO ('2008-10-20 00:00:00+00');


create table "pgstac"."items_search_p2008w43" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-10-20 00:00:00+00') TO ('2008-10-27 00:00:00+00');


create table "pgstac"."items_search_p2008w44" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-10-27 00:00:00+00') TO ('2008-11-03 00:00:00+00');


create table "pgstac"."items_search_p2008w45" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-11-03 00:00:00+00') TO ('2008-11-10 00:00:00+00');


create table "pgstac"."items_search_p2008w46" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-11-10 00:00:00+00') TO ('2008-11-17 00:00:00+00');


create table "pgstac"."items_search_p2008w47" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-11-17 00:00:00+00') TO ('2008-11-24 00:00:00+00');


create table "pgstac"."items_search_p2008w48" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-11-24 00:00:00+00') TO ('2008-12-01 00:00:00+00');


create table "pgstac"."items_search_p2008w49" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-12-01 00:00:00+00') TO ('2008-12-08 00:00:00+00');


create table "pgstac"."items_search_p2008w50" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-12-08 00:00:00+00') TO ('2008-12-15 00:00:00+00');


create table "pgstac"."items_search_p2008w51" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-12-15 00:00:00+00') TO ('2008-12-22 00:00:00+00');


create table "pgstac"."items_search_p2008w52" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-12-22 00:00:00+00') TO ('2008-12-29 00:00:00+00');


create table "pgstac"."items_search_p2009w01" partition of "pgstac"."items_search" FOR VALUES FROM ('2008-12-29 00:00:00+00') TO ('2009-01-05 00:00:00+00');


create table "pgstac"."items_search_p2009w02" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-01-05 00:00:00+00') TO ('2009-01-12 00:00:00+00');


create table "pgstac"."items_search_p2009w03" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-01-12 00:00:00+00') TO ('2009-01-19 00:00:00+00');


create table "pgstac"."items_search_p2009w04" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-01-19 00:00:00+00') TO ('2009-01-26 00:00:00+00');


create table "pgstac"."items_search_p2009w05" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-01-26 00:00:00+00') TO ('2009-02-02 00:00:00+00');


create table "pgstac"."items_search_p2009w06" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-02-02 00:00:00+00') TO ('2009-02-09 00:00:00+00');


create table "pgstac"."items_search_p2009w07" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-02-09 00:00:00+00') TO ('2009-02-16 00:00:00+00');


create table "pgstac"."items_search_p2009w08" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-02-16 00:00:00+00') TO ('2009-02-23 00:00:00+00');


create table "pgstac"."items_search_p2009w09" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-02-23 00:00:00+00') TO ('2009-03-02 00:00:00+00');


create table "pgstac"."items_search_p2009w10" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-03-02 00:00:00+00') TO ('2009-03-09 00:00:00+00');


create table "pgstac"."items_search_p2009w11" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-03-09 00:00:00+00') TO ('2009-03-16 00:00:00+00');


create table "pgstac"."items_search_p2009w12" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-03-16 00:00:00+00') TO ('2009-03-23 00:00:00+00');


create table "pgstac"."items_search_p2009w13" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-03-23 00:00:00+00') TO ('2009-03-30 00:00:00+00');


create table "pgstac"."items_search_p2009w14" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-03-30 00:00:00+00') TO ('2009-04-06 00:00:00+00');


create table "pgstac"."items_search_p2009w15" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-04-06 00:00:00+00') TO ('2009-04-13 00:00:00+00');


create table "pgstac"."items_search_p2009w16" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-04-13 00:00:00+00') TO ('2009-04-20 00:00:00+00');


create table "pgstac"."items_search_p2009w17" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-04-20 00:00:00+00') TO ('2009-04-27 00:00:00+00');


create table "pgstac"."items_search_p2009w18" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-04-27 00:00:00+00') TO ('2009-05-04 00:00:00+00');


create table "pgstac"."items_search_p2009w19" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-05-04 00:00:00+00') TO ('2009-05-11 00:00:00+00');


create table "pgstac"."items_search_p2009w20" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-05-11 00:00:00+00') TO ('2009-05-18 00:00:00+00');


create table "pgstac"."items_search_p2009w21" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-05-18 00:00:00+00') TO ('2009-05-25 00:00:00+00');


create table "pgstac"."items_search_p2009w22" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-05-25 00:00:00+00') TO ('2009-06-01 00:00:00+00');


create table "pgstac"."items_search_p2009w23" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-06-01 00:00:00+00') TO ('2009-06-08 00:00:00+00');


create table "pgstac"."items_search_p2009w24" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-06-08 00:00:00+00') TO ('2009-06-15 00:00:00+00');


create table "pgstac"."items_search_p2009w25" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-06-15 00:00:00+00') TO ('2009-06-22 00:00:00+00');


create table "pgstac"."items_search_p2009w26" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-06-22 00:00:00+00') TO ('2009-06-29 00:00:00+00');


create table "pgstac"."items_search_p2009w27" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-06-29 00:00:00+00') TO ('2009-07-06 00:00:00+00');


create table "pgstac"."items_search_p2009w28" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-07-06 00:00:00+00') TO ('2009-07-13 00:00:00+00');


create table "pgstac"."items_search_p2009w29" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-07-13 00:00:00+00') TO ('2009-07-20 00:00:00+00');


create table "pgstac"."items_search_p2009w30" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-07-20 00:00:00+00') TO ('2009-07-27 00:00:00+00');


create table "pgstac"."items_search_p2009w31" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-07-27 00:00:00+00') TO ('2009-08-03 00:00:00+00');


create table "pgstac"."items_search_p2009w32" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-08-03 00:00:00+00') TO ('2009-08-10 00:00:00+00');


create table "pgstac"."items_search_p2009w33" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-08-10 00:00:00+00') TO ('2009-08-17 00:00:00+00');


create table "pgstac"."items_search_p2009w34" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-08-17 00:00:00+00') TO ('2009-08-24 00:00:00+00');


create table "pgstac"."items_search_p2009w35" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-08-24 00:00:00+00') TO ('2009-08-31 00:00:00+00');


create table "pgstac"."items_search_p2009w36" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-08-31 00:00:00+00') TO ('2009-09-07 00:00:00+00');


create table "pgstac"."items_search_p2009w37" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-09-07 00:00:00+00') TO ('2009-09-14 00:00:00+00');


create table "pgstac"."items_search_p2009w38" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-09-14 00:00:00+00') TO ('2009-09-21 00:00:00+00');


create table "pgstac"."items_search_p2009w39" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-09-21 00:00:00+00') TO ('2009-09-28 00:00:00+00');


create table "pgstac"."items_search_p2009w40" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-09-28 00:00:00+00') TO ('2009-10-05 00:00:00+00');


create table "pgstac"."items_search_p2009w41" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-10-05 00:00:00+00') TO ('2009-10-12 00:00:00+00');


create table "pgstac"."items_search_p2009w42" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-10-12 00:00:00+00') TO ('2009-10-19 00:00:00+00');


create table "pgstac"."items_search_p2009w43" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-10-19 00:00:00+00') TO ('2009-10-26 00:00:00+00');


create table "pgstac"."items_search_p2009w44" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-10-26 00:00:00+00') TO ('2009-11-02 00:00:00+00');


create table "pgstac"."items_search_p2009w45" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-11-02 00:00:00+00') TO ('2009-11-09 00:00:00+00');


create table "pgstac"."items_search_p2009w46" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-11-09 00:00:00+00') TO ('2009-11-16 00:00:00+00');


create table "pgstac"."items_search_p2009w47" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-11-16 00:00:00+00') TO ('2009-11-23 00:00:00+00');


create table "pgstac"."items_search_p2009w48" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-11-23 00:00:00+00') TO ('2009-11-30 00:00:00+00');


create table "pgstac"."items_search_p2009w49" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-11-30 00:00:00+00') TO ('2009-12-07 00:00:00+00');


create table "pgstac"."items_search_p2009w50" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-12-07 00:00:00+00') TO ('2009-12-14 00:00:00+00');


create table "pgstac"."items_search_p2009w51" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-12-14 00:00:00+00') TO ('2009-12-21 00:00:00+00');


create table "pgstac"."items_search_p2009w52" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-12-21 00:00:00+00') TO ('2009-12-28 00:00:00+00');


create table "pgstac"."items_search_p2009w53" partition of "pgstac"."items_search" FOR VALUES FROM ('2009-12-28 00:00:00+00') TO ('2010-01-04 00:00:00+00');


create table "pgstac"."items_search_p2010w01" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-01-04 00:00:00+00') TO ('2010-01-11 00:00:00+00');


create table "pgstac"."items_search_p2010w02" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-01-11 00:00:00+00') TO ('2010-01-18 00:00:00+00');


create table "pgstac"."items_search_p2010w03" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-01-18 00:00:00+00') TO ('2010-01-25 00:00:00+00');


create table "pgstac"."items_search_p2010w04" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-01-25 00:00:00+00') TO ('2010-02-01 00:00:00+00');


create table "pgstac"."items_search_p2010w05" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-02-01 00:00:00+00') TO ('2010-02-08 00:00:00+00');


create table "pgstac"."items_search_p2010w06" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-02-08 00:00:00+00') TO ('2010-02-15 00:00:00+00');


create table "pgstac"."items_search_p2010w07" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-02-15 00:00:00+00') TO ('2010-02-22 00:00:00+00');


create table "pgstac"."items_search_p2010w08" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-02-22 00:00:00+00') TO ('2010-03-01 00:00:00+00');


create table "pgstac"."items_search_p2010w09" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-03-01 00:00:00+00') TO ('2010-03-08 00:00:00+00');


create table "pgstac"."items_search_p2010w10" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-03-08 00:00:00+00') TO ('2010-03-15 00:00:00+00');


create table "pgstac"."items_search_p2010w11" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-03-15 00:00:00+00') TO ('2010-03-22 00:00:00+00');


create table "pgstac"."items_search_p2010w12" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-03-22 00:00:00+00') TO ('2010-03-29 00:00:00+00');


create table "pgstac"."items_search_p2010w13" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-03-29 00:00:00+00') TO ('2010-04-05 00:00:00+00');


create table "pgstac"."items_search_p2010w14" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-04-05 00:00:00+00') TO ('2010-04-12 00:00:00+00');


create table "pgstac"."items_search_p2010w15" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-04-12 00:00:00+00') TO ('2010-04-19 00:00:00+00');


create table "pgstac"."items_search_p2010w16" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-04-19 00:00:00+00') TO ('2010-04-26 00:00:00+00');


create table "pgstac"."items_search_p2010w17" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-04-26 00:00:00+00') TO ('2010-05-03 00:00:00+00');


create table "pgstac"."items_search_p2010w18" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-05-03 00:00:00+00') TO ('2010-05-10 00:00:00+00');


create table "pgstac"."items_search_p2010w19" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-05-10 00:00:00+00') TO ('2010-05-17 00:00:00+00');


create table "pgstac"."items_search_p2010w20" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-05-17 00:00:00+00') TO ('2010-05-24 00:00:00+00');


create table "pgstac"."items_search_p2010w21" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-05-24 00:00:00+00') TO ('2010-05-31 00:00:00+00');


create table "pgstac"."items_search_p2010w22" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-05-31 00:00:00+00') TO ('2010-06-07 00:00:00+00');


create table "pgstac"."items_search_p2010w23" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-06-07 00:00:00+00') TO ('2010-06-14 00:00:00+00');


create table "pgstac"."items_search_p2010w24" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-06-14 00:00:00+00') TO ('2010-06-21 00:00:00+00');


create table "pgstac"."items_search_p2010w25" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-06-21 00:00:00+00') TO ('2010-06-28 00:00:00+00');


create table "pgstac"."items_search_p2010w26" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-06-28 00:00:00+00') TO ('2010-07-05 00:00:00+00');


create table "pgstac"."items_search_p2010w27" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-07-05 00:00:00+00') TO ('2010-07-12 00:00:00+00');


create table "pgstac"."items_search_p2010w28" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-07-12 00:00:00+00') TO ('2010-07-19 00:00:00+00');


create table "pgstac"."items_search_p2010w29" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-07-19 00:00:00+00') TO ('2010-07-26 00:00:00+00');


create table "pgstac"."items_search_p2010w30" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-07-26 00:00:00+00') TO ('2010-08-02 00:00:00+00');


create table "pgstac"."items_search_p2010w31" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-08-02 00:00:00+00') TO ('2010-08-09 00:00:00+00');


create table "pgstac"."items_search_p2010w32" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-08-09 00:00:00+00') TO ('2010-08-16 00:00:00+00');


create table "pgstac"."items_search_p2010w33" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-08-16 00:00:00+00') TO ('2010-08-23 00:00:00+00');


create table "pgstac"."items_search_p2010w34" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-08-23 00:00:00+00') TO ('2010-08-30 00:00:00+00');


create table "pgstac"."items_search_p2010w35" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-08-30 00:00:00+00') TO ('2010-09-06 00:00:00+00');


create table "pgstac"."items_search_p2010w36" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-09-06 00:00:00+00') TO ('2010-09-13 00:00:00+00');


create table "pgstac"."items_search_p2010w37" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-09-13 00:00:00+00') TO ('2010-09-20 00:00:00+00');


create table "pgstac"."items_search_p2010w38" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-09-20 00:00:00+00') TO ('2010-09-27 00:00:00+00');


create table "pgstac"."items_search_p2010w39" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-09-27 00:00:00+00') TO ('2010-10-04 00:00:00+00');


create table "pgstac"."items_search_p2010w40" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-10-04 00:00:00+00') TO ('2010-10-11 00:00:00+00');


create table "pgstac"."items_search_p2010w41" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-10-11 00:00:00+00') TO ('2010-10-18 00:00:00+00');


create table "pgstac"."items_search_p2010w42" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-10-18 00:00:00+00') TO ('2010-10-25 00:00:00+00');


create table "pgstac"."items_search_p2010w43" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-10-25 00:00:00+00') TO ('2010-11-01 00:00:00+00');


create table "pgstac"."items_search_p2010w44" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-11-01 00:00:00+00') TO ('2010-11-08 00:00:00+00');


create table "pgstac"."items_search_p2010w45" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-11-08 00:00:00+00') TO ('2010-11-15 00:00:00+00');


create table "pgstac"."items_search_p2010w46" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-11-15 00:00:00+00') TO ('2010-11-22 00:00:00+00');


create table "pgstac"."items_search_p2010w47" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-11-22 00:00:00+00') TO ('2010-11-29 00:00:00+00');


create table "pgstac"."items_search_p2010w48" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-11-29 00:00:00+00') TO ('2010-12-06 00:00:00+00');


create table "pgstac"."items_search_p2010w49" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-12-06 00:00:00+00') TO ('2010-12-13 00:00:00+00');


create table "pgstac"."items_search_p2010w50" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-12-13 00:00:00+00') TO ('2010-12-20 00:00:00+00');


create table "pgstac"."items_search_p2010w51" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-12-20 00:00:00+00') TO ('2010-12-27 00:00:00+00');


create table "pgstac"."items_search_p2010w52" partition of "pgstac"."items_search" FOR VALUES FROM ('2010-12-27 00:00:00+00') TO ('2011-01-03 00:00:00+00');


create table "pgstac"."items_search_p2011w01" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-01-03 00:00:00+00') TO ('2011-01-10 00:00:00+00');


create table "pgstac"."items_search_p2011w02" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-01-10 00:00:00+00') TO ('2011-01-17 00:00:00+00');


create table "pgstac"."items_search_p2011w03" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-01-17 00:00:00+00') TO ('2011-01-24 00:00:00+00');


create table "pgstac"."items_search_p2011w04" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-01-24 00:00:00+00') TO ('2011-01-31 00:00:00+00');


create table "pgstac"."items_search_p2011w05" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-01-31 00:00:00+00') TO ('2011-02-07 00:00:00+00');


create table "pgstac"."items_search_p2011w06" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-02-07 00:00:00+00') TO ('2011-02-14 00:00:00+00');


create table "pgstac"."items_search_p2011w07" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-02-14 00:00:00+00') TO ('2011-02-21 00:00:00+00');


create table "pgstac"."items_search_p2011w08" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-02-21 00:00:00+00') TO ('2011-02-28 00:00:00+00');


create table "pgstac"."items_search_p2011w09" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-02-28 00:00:00+00') TO ('2011-03-07 00:00:00+00');


create table "pgstac"."items_search_p2011w10" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-03-07 00:00:00+00') TO ('2011-03-14 00:00:00+00');


create table "pgstac"."items_search_p2011w11" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-03-14 00:00:00+00') TO ('2011-03-21 00:00:00+00');


create table "pgstac"."items_search_p2011w12" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-03-21 00:00:00+00') TO ('2011-03-28 00:00:00+00');


create table "pgstac"."items_search_p2011w13" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-03-28 00:00:00+00') TO ('2011-04-04 00:00:00+00');


create table "pgstac"."items_search_p2011w14" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-04-04 00:00:00+00') TO ('2011-04-11 00:00:00+00');


create table "pgstac"."items_search_p2011w15" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-04-11 00:00:00+00') TO ('2011-04-18 00:00:00+00');


create table "pgstac"."items_search_p2011w16" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-04-18 00:00:00+00') TO ('2011-04-25 00:00:00+00');


create table "pgstac"."items_search_p2011w17" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-04-25 00:00:00+00') TO ('2011-05-02 00:00:00+00');


create table "pgstac"."items_search_p2011w18" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-05-02 00:00:00+00') TO ('2011-05-09 00:00:00+00');


create table "pgstac"."items_search_p2011w19" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-05-09 00:00:00+00') TO ('2011-05-16 00:00:00+00');


create table "pgstac"."items_search_p2011w20" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-05-16 00:00:00+00') TO ('2011-05-23 00:00:00+00');


create table "pgstac"."items_search_p2011w21" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-05-23 00:00:00+00') TO ('2011-05-30 00:00:00+00');


create table "pgstac"."items_search_p2011w22" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-05-30 00:00:00+00') TO ('2011-06-06 00:00:00+00');


create table "pgstac"."items_search_p2011w23" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-06-06 00:00:00+00') TO ('2011-06-13 00:00:00+00');


create table "pgstac"."items_search_p2011w24" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-06-13 00:00:00+00') TO ('2011-06-20 00:00:00+00');


create table "pgstac"."items_search_p2011w25" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-06-20 00:00:00+00') TO ('2011-06-27 00:00:00+00');


create table "pgstac"."items_search_p2011w26" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-06-27 00:00:00+00') TO ('2011-07-04 00:00:00+00');


create table "pgstac"."items_search_p2011w27" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-07-04 00:00:00+00') TO ('2011-07-11 00:00:00+00');


create table "pgstac"."items_search_p2011w28" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-07-11 00:00:00+00') TO ('2011-07-18 00:00:00+00');


create table "pgstac"."items_search_p2011w29" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-07-18 00:00:00+00') TO ('2011-07-25 00:00:00+00');


create table "pgstac"."items_search_p2011w30" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-07-25 00:00:00+00') TO ('2011-08-01 00:00:00+00');


create table "pgstac"."items_search_p2011w31" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-08-01 00:00:00+00') TO ('2011-08-08 00:00:00+00');


create table "pgstac"."items_search_p2011w32" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-08-08 00:00:00+00') TO ('2011-08-15 00:00:00+00');


create table "pgstac"."items_search_p2011w33" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-08-15 00:00:00+00') TO ('2011-08-22 00:00:00+00');


create table "pgstac"."items_search_p2011w34" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-08-22 00:00:00+00') TO ('2011-08-29 00:00:00+00');


create table "pgstac"."items_search_p2011w35" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-08-29 00:00:00+00') TO ('2011-09-05 00:00:00+00');


create table "pgstac"."items_search_p2011w36" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-09-05 00:00:00+00') TO ('2011-09-12 00:00:00+00');


create table "pgstac"."items_search_p2011w37" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-09-12 00:00:00+00') TO ('2011-09-19 00:00:00+00');


create table "pgstac"."items_search_p2011w38" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-09-19 00:00:00+00') TO ('2011-09-26 00:00:00+00');


create table "pgstac"."items_search_p2011w39" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-09-26 00:00:00+00') TO ('2011-10-03 00:00:00+00');


create table "pgstac"."items_search_p2011w40" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-10-03 00:00:00+00') TO ('2011-10-10 00:00:00+00');


create table "pgstac"."items_search_p2011w41" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-10-10 00:00:00+00') TO ('2011-10-17 00:00:00+00');


create table "pgstac"."items_search_p2011w42" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-10-17 00:00:00+00') TO ('2011-10-24 00:00:00+00');


create table "pgstac"."items_search_p2011w43" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-10-24 00:00:00+00') TO ('2011-10-31 00:00:00+00');


create table "pgstac"."items_search_p2011w44" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-10-31 00:00:00+00') TO ('2011-11-07 00:00:00+00');


create table "pgstac"."items_search_p2011w45" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-11-07 00:00:00+00') TO ('2011-11-14 00:00:00+00');


create table "pgstac"."items_search_p2011w46" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-11-14 00:00:00+00') TO ('2011-11-21 00:00:00+00');


create table "pgstac"."items_search_p2011w47" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-11-21 00:00:00+00') TO ('2011-11-28 00:00:00+00');


create table "pgstac"."items_search_p2011w48" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-11-28 00:00:00+00') TO ('2011-12-05 00:00:00+00');


create table "pgstac"."items_search_p2011w49" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-12-05 00:00:00+00') TO ('2011-12-12 00:00:00+00');


create table "pgstac"."items_search_p2011w50" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-12-12 00:00:00+00') TO ('2011-12-19 00:00:00+00');


create table "pgstac"."items_search_p2011w51" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-12-19 00:00:00+00') TO ('2011-12-26 00:00:00+00');


create table "pgstac"."items_search_p2011w52" partition of "pgstac"."items_search" FOR VALUES FROM ('2011-12-26 00:00:00+00') TO ('2012-01-02 00:00:00+00');


create table "pgstac"."items_search_p2012w01" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-01-02 00:00:00+00') TO ('2012-01-09 00:00:00+00');


create table "pgstac"."items_search_p2012w02" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-01-09 00:00:00+00') TO ('2012-01-16 00:00:00+00');


create table "pgstac"."items_search_p2012w03" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-01-16 00:00:00+00') TO ('2012-01-23 00:00:00+00');


create table "pgstac"."items_search_p2012w04" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-01-23 00:00:00+00') TO ('2012-01-30 00:00:00+00');


create table "pgstac"."items_search_p2012w05" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-01-30 00:00:00+00') TO ('2012-02-06 00:00:00+00');


create table "pgstac"."items_search_p2012w06" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-02-06 00:00:00+00') TO ('2012-02-13 00:00:00+00');


create table "pgstac"."items_search_p2012w07" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-02-13 00:00:00+00') TO ('2012-02-20 00:00:00+00');


create table "pgstac"."items_search_p2012w08" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-02-20 00:00:00+00') TO ('2012-02-27 00:00:00+00');


create table "pgstac"."items_search_p2012w09" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-02-27 00:00:00+00') TO ('2012-03-05 00:00:00+00');


create table "pgstac"."items_search_p2012w10" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-03-05 00:00:00+00') TO ('2012-03-12 00:00:00+00');


create table "pgstac"."items_search_p2012w11" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-03-12 00:00:00+00') TO ('2012-03-19 00:00:00+00');


create table "pgstac"."items_search_p2012w12" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-03-19 00:00:00+00') TO ('2012-03-26 00:00:00+00');


create table "pgstac"."items_search_p2012w13" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-03-26 00:00:00+00') TO ('2012-04-02 00:00:00+00');


create table "pgstac"."items_search_p2012w14" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-04-02 00:00:00+00') TO ('2012-04-09 00:00:00+00');


create table "pgstac"."items_search_p2012w15" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-04-09 00:00:00+00') TO ('2012-04-16 00:00:00+00');


create table "pgstac"."items_search_p2012w16" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-04-16 00:00:00+00') TO ('2012-04-23 00:00:00+00');


create table "pgstac"."items_search_p2012w17" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-04-23 00:00:00+00') TO ('2012-04-30 00:00:00+00');


create table "pgstac"."items_search_p2012w18" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-04-30 00:00:00+00') TO ('2012-05-07 00:00:00+00');


create table "pgstac"."items_search_p2012w19" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-05-07 00:00:00+00') TO ('2012-05-14 00:00:00+00');


create table "pgstac"."items_search_p2012w20" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-05-14 00:00:00+00') TO ('2012-05-21 00:00:00+00');


create table "pgstac"."items_search_p2012w21" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-05-21 00:00:00+00') TO ('2012-05-28 00:00:00+00');


create table "pgstac"."items_search_p2012w22" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-05-28 00:00:00+00') TO ('2012-06-04 00:00:00+00');


create table "pgstac"."items_search_p2012w23" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-06-04 00:00:00+00') TO ('2012-06-11 00:00:00+00');


create table "pgstac"."items_search_p2012w24" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-06-11 00:00:00+00') TO ('2012-06-18 00:00:00+00');


create table "pgstac"."items_search_p2012w25" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-06-18 00:00:00+00') TO ('2012-06-25 00:00:00+00');


create table "pgstac"."items_search_p2012w26" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-06-25 00:00:00+00') TO ('2012-07-02 00:00:00+00');


create table "pgstac"."items_search_p2012w27" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-07-02 00:00:00+00') TO ('2012-07-09 00:00:00+00');


create table "pgstac"."items_search_p2012w28" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-07-09 00:00:00+00') TO ('2012-07-16 00:00:00+00');


create table "pgstac"."items_search_p2012w29" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-07-16 00:00:00+00') TO ('2012-07-23 00:00:00+00');


create table "pgstac"."items_search_p2012w30" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-07-23 00:00:00+00') TO ('2012-07-30 00:00:00+00');


create table "pgstac"."items_search_p2012w31" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-07-30 00:00:00+00') TO ('2012-08-06 00:00:00+00');


create table "pgstac"."items_search_p2012w32" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-08-06 00:00:00+00') TO ('2012-08-13 00:00:00+00');


create table "pgstac"."items_search_p2012w33" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-08-13 00:00:00+00') TO ('2012-08-20 00:00:00+00');


create table "pgstac"."items_search_p2012w34" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-08-20 00:00:00+00') TO ('2012-08-27 00:00:00+00');


create table "pgstac"."items_search_p2012w35" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-08-27 00:00:00+00') TO ('2012-09-03 00:00:00+00');


create table "pgstac"."items_search_p2012w36" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-09-03 00:00:00+00') TO ('2012-09-10 00:00:00+00');


create table "pgstac"."items_search_p2012w37" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-09-10 00:00:00+00') TO ('2012-09-17 00:00:00+00');


create table "pgstac"."items_search_p2012w38" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-09-17 00:00:00+00') TO ('2012-09-24 00:00:00+00');


create table "pgstac"."items_search_p2012w39" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-09-24 00:00:00+00') TO ('2012-10-01 00:00:00+00');


create table "pgstac"."items_search_p2012w40" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-10-01 00:00:00+00') TO ('2012-10-08 00:00:00+00');


create table "pgstac"."items_search_p2012w41" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-10-08 00:00:00+00') TO ('2012-10-15 00:00:00+00');


create table "pgstac"."items_search_p2012w42" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-10-15 00:00:00+00') TO ('2012-10-22 00:00:00+00');


create table "pgstac"."items_search_p2012w43" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-10-22 00:00:00+00') TO ('2012-10-29 00:00:00+00');


create table "pgstac"."items_search_p2012w44" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-10-29 00:00:00+00') TO ('2012-11-05 00:00:00+00');


create table "pgstac"."items_search_p2012w45" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-11-05 00:00:00+00') TO ('2012-11-12 00:00:00+00');


create table "pgstac"."items_search_p2012w46" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-11-12 00:00:00+00') TO ('2012-11-19 00:00:00+00');


create table "pgstac"."items_search_p2012w47" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-11-19 00:00:00+00') TO ('2012-11-26 00:00:00+00');


create table "pgstac"."items_search_p2012w48" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-11-26 00:00:00+00') TO ('2012-12-03 00:00:00+00');


create table "pgstac"."items_search_p2012w49" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-12-03 00:00:00+00') TO ('2012-12-10 00:00:00+00');


create table "pgstac"."items_search_p2012w50" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-12-10 00:00:00+00') TO ('2012-12-17 00:00:00+00');


create table "pgstac"."items_search_p2012w51" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-12-17 00:00:00+00') TO ('2012-12-24 00:00:00+00');


create table "pgstac"."items_search_p2012w52" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-12-24 00:00:00+00') TO ('2012-12-31 00:00:00+00');


create table "pgstac"."items_search_p2013w01" partition of "pgstac"."items_search" FOR VALUES FROM ('2012-12-31 00:00:00+00') TO ('2013-01-07 00:00:00+00');


create table "pgstac"."items_search_p2013w02" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-01-07 00:00:00+00') TO ('2013-01-14 00:00:00+00');


create table "pgstac"."items_search_p2013w03" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-01-14 00:00:00+00') TO ('2013-01-21 00:00:00+00');


create table "pgstac"."items_search_p2013w04" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-01-21 00:00:00+00') TO ('2013-01-28 00:00:00+00');


create table "pgstac"."items_search_p2013w05" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-01-28 00:00:00+00') TO ('2013-02-04 00:00:00+00');


create table "pgstac"."items_search_p2013w06" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-02-04 00:00:00+00') TO ('2013-02-11 00:00:00+00');


create table "pgstac"."items_search_p2013w07" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-02-11 00:00:00+00') TO ('2013-02-18 00:00:00+00');


create table "pgstac"."items_search_p2013w08" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-02-18 00:00:00+00') TO ('2013-02-25 00:00:00+00');


create table "pgstac"."items_search_p2013w09" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-02-25 00:00:00+00') TO ('2013-03-04 00:00:00+00');


create table "pgstac"."items_search_p2013w10" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-03-04 00:00:00+00') TO ('2013-03-11 00:00:00+00');


create table "pgstac"."items_search_p2013w11" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-03-11 00:00:00+00') TO ('2013-03-18 00:00:00+00');


create table "pgstac"."items_search_p2013w12" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-03-18 00:00:00+00') TO ('2013-03-25 00:00:00+00');


create table "pgstac"."items_search_p2013w13" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-03-25 00:00:00+00') TO ('2013-04-01 00:00:00+00');


create table "pgstac"."items_search_p2013w14" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-04-01 00:00:00+00') TO ('2013-04-08 00:00:00+00');


create table "pgstac"."items_search_p2013w15" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-04-08 00:00:00+00') TO ('2013-04-15 00:00:00+00');


create table "pgstac"."items_search_p2013w16" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-04-15 00:00:00+00') TO ('2013-04-22 00:00:00+00');


create table "pgstac"."items_search_p2013w17" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-04-22 00:00:00+00') TO ('2013-04-29 00:00:00+00');


create table "pgstac"."items_search_p2013w18" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-04-29 00:00:00+00') TO ('2013-05-06 00:00:00+00');


create table "pgstac"."items_search_p2013w19" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-05-06 00:00:00+00') TO ('2013-05-13 00:00:00+00');


create table "pgstac"."items_search_p2013w20" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-05-13 00:00:00+00') TO ('2013-05-20 00:00:00+00');


create table "pgstac"."items_search_p2013w21" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-05-20 00:00:00+00') TO ('2013-05-27 00:00:00+00');


create table "pgstac"."items_search_p2013w22" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-05-27 00:00:00+00') TO ('2013-06-03 00:00:00+00');


create table "pgstac"."items_search_p2013w23" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-06-03 00:00:00+00') TO ('2013-06-10 00:00:00+00');


create table "pgstac"."items_search_p2013w24" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-06-10 00:00:00+00') TO ('2013-06-17 00:00:00+00');


create table "pgstac"."items_search_p2013w25" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-06-17 00:00:00+00') TO ('2013-06-24 00:00:00+00');


create table "pgstac"."items_search_p2013w26" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-06-24 00:00:00+00') TO ('2013-07-01 00:00:00+00');


create table "pgstac"."items_search_p2013w27" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-07-01 00:00:00+00') TO ('2013-07-08 00:00:00+00');


create table "pgstac"."items_search_p2013w28" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-07-08 00:00:00+00') TO ('2013-07-15 00:00:00+00');


create table "pgstac"."items_search_p2013w29" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-07-15 00:00:00+00') TO ('2013-07-22 00:00:00+00');


create table "pgstac"."items_search_p2013w30" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-07-22 00:00:00+00') TO ('2013-07-29 00:00:00+00');


create table "pgstac"."items_search_p2013w31" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-07-29 00:00:00+00') TO ('2013-08-05 00:00:00+00');


create table "pgstac"."items_search_p2013w32" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-08-05 00:00:00+00') TO ('2013-08-12 00:00:00+00');


create table "pgstac"."items_search_p2013w33" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-08-12 00:00:00+00') TO ('2013-08-19 00:00:00+00');


create table "pgstac"."items_search_p2013w34" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-08-19 00:00:00+00') TO ('2013-08-26 00:00:00+00');


create table "pgstac"."items_search_p2013w35" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-08-26 00:00:00+00') TO ('2013-09-02 00:00:00+00');


create table "pgstac"."items_search_p2013w36" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-09-02 00:00:00+00') TO ('2013-09-09 00:00:00+00');


create table "pgstac"."items_search_p2013w37" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-09-09 00:00:00+00') TO ('2013-09-16 00:00:00+00');


create table "pgstac"."items_search_p2013w38" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-09-16 00:00:00+00') TO ('2013-09-23 00:00:00+00');


create table "pgstac"."items_search_p2013w39" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-09-23 00:00:00+00') TO ('2013-09-30 00:00:00+00');


create table "pgstac"."items_search_p2013w40" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-09-30 00:00:00+00') TO ('2013-10-07 00:00:00+00');


create table "pgstac"."items_search_p2013w41" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-10-07 00:00:00+00') TO ('2013-10-14 00:00:00+00');


create table "pgstac"."items_search_p2013w42" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-10-14 00:00:00+00') TO ('2013-10-21 00:00:00+00');


create table "pgstac"."items_search_p2013w43" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-10-21 00:00:00+00') TO ('2013-10-28 00:00:00+00');


create table "pgstac"."items_search_p2013w44" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-10-28 00:00:00+00') TO ('2013-11-04 00:00:00+00');


create table "pgstac"."items_search_p2013w45" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-11-04 00:00:00+00') TO ('2013-11-11 00:00:00+00');


create table "pgstac"."items_search_p2013w46" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-11-11 00:00:00+00') TO ('2013-11-18 00:00:00+00');


create table "pgstac"."items_search_p2013w47" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-11-18 00:00:00+00') TO ('2013-11-25 00:00:00+00');


create table "pgstac"."items_search_p2013w48" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-11-25 00:00:00+00') TO ('2013-12-02 00:00:00+00');


create table "pgstac"."items_search_p2013w49" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-12-02 00:00:00+00') TO ('2013-12-09 00:00:00+00');


create table "pgstac"."items_search_p2013w50" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-12-09 00:00:00+00') TO ('2013-12-16 00:00:00+00');


create table "pgstac"."items_search_p2013w51" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-12-16 00:00:00+00') TO ('2013-12-23 00:00:00+00');


create table "pgstac"."items_search_p2013w52" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-12-23 00:00:00+00') TO ('2013-12-30 00:00:00+00');


create table "pgstac"."items_search_p2014w01" partition of "pgstac"."items_search" FOR VALUES FROM ('2013-12-30 00:00:00+00') TO ('2014-01-06 00:00:00+00');


create table "pgstac"."items_search_p2014w02" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-01-06 00:00:00+00') TO ('2014-01-13 00:00:00+00');


create table "pgstac"."items_search_p2014w03" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-01-13 00:00:00+00') TO ('2014-01-20 00:00:00+00');


create table "pgstac"."items_search_p2014w04" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-01-20 00:00:00+00') TO ('2014-01-27 00:00:00+00');


create table "pgstac"."items_search_p2014w05" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-01-27 00:00:00+00') TO ('2014-02-03 00:00:00+00');


create table "pgstac"."items_search_p2014w06" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-02-03 00:00:00+00') TO ('2014-02-10 00:00:00+00');


create table "pgstac"."items_search_p2014w07" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-02-10 00:00:00+00') TO ('2014-02-17 00:00:00+00');


create table "pgstac"."items_search_p2014w08" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-02-17 00:00:00+00') TO ('2014-02-24 00:00:00+00');


create table "pgstac"."items_search_p2014w09" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-02-24 00:00:00+00') TO ('2014-03-03 00:00:00+00');


create table "pgstac"."items_search_p2014w10" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-03-03 00:00:00+00') TO ('2014-03-10 00:00:00+00');


create table "pgstac"."items_search_p2014w11" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-03-10 00:00:00+00') TO ('2014-03-17 00:00:00+00');


create table "pgstac"."items_search_p2014w12" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-03-17 00:00:00+00') TO ('2014-03-24 00:00:00+00');


create table "pgstac"."items_search_p2014w13" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-03-24 00:00:00+00') TO ('2014-03-31 00:00:00+00');


create table "pgstac"."items_search_p2014w14" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-03-31 00:00:00+00') TO ('2014-04-07 00:00:00+00');


create table "pgstac"."items_search_p2014w15" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-04-07 00:00:00+00') TO ('2014-04-14 00:00:00+00');


create table "pgstac"."items_search_p2014w16" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-04-14 00:00:00+00') TO ('2014-04-21 00:00:00+00');


create table "pgstac"."items_search_p2014w17" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-04-21 00:00:00+00') TO ('2014-04-28 00:00:00+00');


create table "pgstac"."items_search_p2014w18" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-04-28 00:00:00+00') TO ('2014-05-05 00:00:00+00');


create table "pgstac"."items_search_p2014w19" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-05-05 00:00:00+00') TO ('2014-05-12 00:00:00+00');


create table "pgstac"."items_search_p2014w20" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-05-12 00:00:00+00') TO ('2014-05-19 00:00:00+00');


create table "pgstac"."items_search_p2014w21" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-05-19 00:00:00+00') TO ('2014-05-26 00:00:00+00');


create table "pgstac"."items_search_p2014w22" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-05-26 00:00:00+00') TO ('2014-06-02 00:00:00+00');


create table "pgstac"."items_search_p2014w23" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-06-02 00:00:00+00') TO ('2014-06-09 00:00:00+00');


create table "pgstac"."items_search_p2014w24" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-06-09 00:00:00+00') TO ('2014-06-16 00:00:00+00');


create table "pgstac"."items_search_p2014w25" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-06-16 00:00:00+00') TO ('2014-06-23 00:00:00+00');


create table "pgstac"."items_search_p2014w26" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-06-23 00:00:00+00') TO ('2014-06-30 00:00:00+00');


create table "pgstac"."items_search_p2014w27" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-06-30 00:00:00+00') TO ('2014-07-07 00:00:00+00');


create table "pgstac"."items_search_p2014w28" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-07-07 00:00:00+00') TO ('2014-07-14 00:00:00+00');


create table "pgstac"."items_search_p2014w29" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-07-14 00:00:00+00') TO ('2014-07-21 00:00:00+00');


create table "pgstac"."items_search_p2014w30" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-07-21 00:00:00+00') TO ('2014-07-28 00:00:00+00');


create table "pgstac"."items_search_p2014w31" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-07-28 00:00:00+00') TO ('2014-08-04 00:00:00+00');


create table "pgstac"."items_search_p2014w32" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-08-04 00:00:00+00') TO ('2014-08-11 00:00:00+00');


create table "pgstac"."items_search_p2014w33" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-08-11 00:00:00+00') TO ('2014-08-18 00:00:00+00');


create table "pgstac"."items_search_p2014w34" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-08-18 00:00:00+00') TO ('2014-08-25 00:00:00+00');


create table "pgstac"."items_search_p2014w35" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-08-25 00:00:00+00') TO ('2014-09-01 00:00:00+00');


create table "pgstac"."items_search_p2014w36" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-09-01 00:00:00+00') TO ('2014-09-08 00:00:00+00');


create table "pgstac"."items_search_p2014w37" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-09-08 00:00:00+00') TO ('2014-09-15 00:00:00+00');


create table "pgstac"."items_search_p2014w38" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-09-15 00:00:00+00') TO ('2014-09-22 00:00:00+00');


create table "pgstac"."items_search_p2014w39" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-09-22 00:00:00+00') TO ('2014-09-29 00:00:00+00');


create table "pgstac"."items_search_p2014w40" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-09-29 00:00:00+00') TO ('2014-10-06 00:00:00+00');


create table "pgstac"."items_search_p2014w41" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-10-06 00:00:00+00') TO ('2014-10-13 00:00:00+00');


create table "pgstac"."items_search_p2014w42" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-10-13 00:00:00+00') TO ('2014-10-20 00:00:00+00');


create table "pgstac"."items_search_p2014w43" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-10-20 00:00:00+00') TO ('2014-10-27 00:00:00+00');


create table "pgstac"."items_search_p2014w44" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-10-27 00:00:00+00') TO ('2014-11-03 00:00:00+00');


create table "pgstac"."items_search_p2014w45" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-11-03 00:00:00+00') TO ('2014-11-10 00:00:00+00');


create table "pgstac"."items_search_p2014w46" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-11-10 00:00:00+00') TO ('2014-11-17 00:00:00+00');


create table "pgstac"."items_search_p2014w47" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-11-17 00:00:00+00') TO ('2014-11-24 00:00:00+00');


create table "pgstac"."items_search_p2014w48" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-11-24 00:00:00+00') TO ('2014-12-01 00:00:00+00');


create table "pgstac"."items_search_p2014w49" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-12-01 00:00:00+00') TO ('2014-12-08 00:00:00+00');


create table "pgstac"."items_search_p2014w50" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-12-08 00:00:00+00') TO ('2014-12-15 00:00:00+00');


create table "pgstac"."items_search_p2014w51" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-12-15 00:00:00+00') TO ('2014-12-22 00:00:00+00');


create table "pgstac"."items_search_p2014w52" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-12-22 00:00:00+00') TO ('2014-12-29 00:00:00+00');


create table "pgstac"."items_search_p2015w01" partition of "pgstac"."items_search" FOR VALUES FROM ('2014-12-29 00:00:00+00') TO ('2015-01-05 00:00:00+00');


create table "pgstac"."items_search_p2015w02" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-01-05 00:00:00+00') TO ('2015-01-12 00:00:00+00');


create table "pgstac"."items_search_p2015w03" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-01-12 00:00:00+00') TO ('2015-01-19 00:00:00+00');


create table "pgstac"."items_search_p2015w04" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-01-19 00:00:00+00') TO ('2015-01-26 00:00:00+00');


create table "pgstac"."items_search_p2015w05" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-01-26 00:00:00+00') TO ('2015-02-02 00:00:00+00');


create table "pgstac"."items_search_p2015w06" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-02-02 00:00:00+00') TO ('2015-02-09 00:00:00+00');


create table "pgstac"."items_search_p2015w07" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-02-09 00:00:00+00') TO ('2015-02-16 00:00:00+00');


create table "pgstac"."items_search_p2015w08" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-02-16 00:00:00+00') TO ('2015-02-23 00:00:00+00');


create table "pgstac"."items_search_p2015w09" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-02-23 00:00:00+00') TO ('2015-03-02 00:00:00+00');


create table "pgstac"."items_search_p2015w10" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-03-02 00:00:00+00') TO ('2015-03-09 00:00:00+00');


create table "pgstac"."items_search_p2015w11" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-03-09 00:00:00+00') TO ('2015-03-16 00:00:00+00');


create table "pgstac"."items_search_p2015w12" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-03-16 00:00:00+00') TO ('2015-03-23 00:00:00+00');


create table "pgstac"."items_search_p2015w13" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-03-23 00:00:00+00') TO ('2015-03-30 00:00:00+00');


create table "pgstac"."items_search_p2015w14" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-03-30 00:00:00+00') TO ('2015-04-06 00:00:00+00');


create table "pgstac"."items_search_p2015w15" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-04-06 00:00:00+00') TO ('2015-04-13 00:00:00+00');


create table "pgstac"."items_search_p2015w16" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-04-13 00:00:00+00') TO ('2015-04-20 00:00:00+00');


create table "pgstac"."items_search_p2015w17" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-04-20 00:00:00+00') TO ('2015-04-27 00:00:00+00');


create table "pgstac"."items_search_p2015w18" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-04-27 00:00:00+00') TO ('2015-05-04 00:00:00+00');


create table "pgstac"."items_search_p2015w19" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-05-04 00:00:00+00') TO ('2015-05-11 00:00:00+00');


create table "pgstac"."items_search_p2015w20" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-05-11 00:00:00+00') TO ('2015-05-18 00:00:00+00');


create table "pgstac"."items_search_p2015w21" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-05-18 00:00:00+00') TO ('2015-05-25 00:00:00+00');


create table "pgstac"."items_search_p2015w22" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-05-25 00:00:00+00') TO ('2015-06-01 00:00:00+00');


create table "pgstac"."items_search_p2015w23" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-06-01 00:00:00+00') TO ('2015-06-08 00:00:00+00');


create table "pgstac"."items_search_p2015w24" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-06-08 00:00:00+00') TO ('2015-06-15 00:00:00+00');


create table "pgstac"."items_search_p2015w25" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-06-15 00:00:00+00') TO ('2015-06-22 00:00:00+00');


create table "pgstac"."items_search_p2015w26" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-06-22 00:00:00+00') TO ('2015-06-29 00:00:00+00');


create table "pgstac"."items_search_p2015w27" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-06-29 00:00:00+00') TO ('2015-07-06 00:00:00+00');


create table "pgstac"."items_search_p2015w28" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-07-06 00:00:00+00') TO ('2015-07-13 00:00:00+00');


create table "pgstac"."items_search_p2015w29" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-07-13 00:00:00+00') TO ('2015-07-20 00:00:00+00');


create table "pgstac"."items_search_p2015w30" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-07-20 00:00:00+00') TO ('2015-07-27 00:00:00+00');


create table "pgstac"."items_search_p2015w31" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-07-27 00:00:00+00') TO ('2015-08-03 00:00:00+00');


create table "pgstac"."items_search_p2015w32" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-08-03 00:00:00+00') TO ('2015-08-10 00:00:00+00');


create table "pgstac"."items_search_p2015w33" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-08-10 00:00:00+00') TO ('2015-08-17 00:00:00+00');


create table "pgstac"."items_search_p2015w34" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-08-17 00:00:00+00') TO ('2015-08-24 00:00:00+00');


create table "pgstac"."items_search_p2015w35" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-08-24 00:00:00+00') TO ('2015-08-31 00:00:00+00');


create table "pgstac"."items_search_p2015w36" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-08-31 00:00:00+00') TO ('2015-09-07 00:00:00+00');


create table "pgstac"."items_search_p2015w37" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-09-07 00:00:00+00') TO ('2015-09-14 00:00:00+00');


create table "pgstac"."items_search_p2015w38" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-09-14 00:00:00+00') TO ('2015-09-21 00:00:00+00');


create table "pgstac"."items_search_p2015w39" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-09-21 00:00:00+00') TO ('2015-09-28 00:00:00+00');


create table "pgstac"."items_search_p2015w40" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-09-28 00:00:00+00') TO ('2015-10-05 00:00:00+00');


create table "pgstac"."items_search_p2015w41" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-10-05 00:00:00+00') TO ('2015-10-12 00:00:00+00');


create table "pgstac"."items_search_p2015w42" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-10-12 00:00:00+00') TO ('2015-10-19 00:00:00+00');


create table "pgstac"."items_search_p2015w43" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-10-19 00:00:00+00') TO ('2015-10-26 00:00:00+00');


create table "pgstac"."items_search_p2015w44" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-10-26 00:00:00+00') TO ('2015-11-02 00:00:00+00');


create table "pgstac"."items_search_p2015w45" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-11-02 00:00:00+00') TO ('2015-11-09 00:00:00+00');


create table "pgstac"."items_search_p2015w46" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-11-09 00:00:00+00') TO ('2015-11-16 00:00:00+00');


create table "pgstac"."items_search_p2015w47" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-11-16 00:00:00+00') TO ('2015-11-23 00:00:00+00');


create table "pgstac"."items_search_p2015w48" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-11-23 00:00:00+00') TO ('2015-11-30 00:00:00+00');


create table "pgstac"."items_search_p2015w49" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-11-30 00:00:00+00') TO ('2015-12-07 00:00:00+00');


create table "pgstac"."items_search_p2015w50" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-12-07 00:00:00+00') TO ('2015-12-14 00:00:00+00');


create table "pgstac"."items_search_p2015w51" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-12-14 00:00:00+00') TO ('2015-12-21 00:00:00+00');


create table "pgstac"."items_search_p2015w52" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-12-21 00:00:00+00') TO ('2015-12-28 00:00:00+00');


create table "pgstac"."items_search_p2015w53" partition of "pgstac"."items_search" FOR VALUES FROM ('2015-12-28 00:00:00+00') TO ('2016-01-04 00:00:00+00');


create table "pgstac"."items_search_p2016w01" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-01-04 00:00:00+00') TO ('2016-01-11 00:00:00+00');


create table "pgstac"."items_search_p2016w02" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-01-11 00:00:00+00') TO ('2016-01-18 00:00:00+00');


create table "pgstac"."items_search_p2016w03" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-01-18 00:00:00+00') TO ('2016-01-25 00:00:00+00');


create table "pgstac"."items_search_p2016w04" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-01-25 00:00:00+00') TO ('2016-02-01 00:00:00+00');


create table "pgstac"."items_search_p2016w05" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-02-01 00:00:00+00') TO ('2016-02-08 00:00:00+00');


create table "pgstac"."items_search_p2016w06" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-02-08 00:00:00+00') TO ('2016-02-15 00:00:00+00');


create table "pgstac"."items_search_p2016w07" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-02-15 00:00:00+00') TO ('2016-02-22 00:00:00+00');


create table "pgstac"."items_search_p2016w08" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-02-22 00:00:00+00') TO ('2016-02-29 00:00:00+00');


create table "pgstac"."items_search_p2016w09" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-02-29 00:00:00+00') TO ('2016-03-07 00:00:00+00');


create table "pgstac"."items_search_p2016w10" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-03-07 00:00:00+00') TO ('2016-03-14 00:00:00+00');


create table "pgstac"."items_search_p2016w11" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-03-14 00:00:00+00') TO ('2016-03-21 00:00:00+00');


create table "pgstac"."items_search_p2016w12" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-03-21 00:00:00+00') TO ('2016-03-28 00:00:00+00');


create table "pgstac"."items_search_p2016w13" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-03-28 00:00:00+00') TO ('2016-04-04 00:00:00+00');


create table "pgstac"."items_search_p2016w14" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-04-04 00:00:00+00') TO ('2016-04-11 00:00:00+00');


create table "pgstac"."items_search_p2016w15" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-04-11 00:00:00+00') TO ('2016-04-18 00:00:00+00');


create table "pgstac"."items_search_p2016w16" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-04-18 00:00:00+00') TO ('2016-04-25 00:00:00+00');


create table "pgstac"."items_search_p2016w17" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-04-25 00:00:00+00') TO ('2016-05-02 00:00:00+00');


create table "pgstac"."items_search_p2016w18" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-05-02 00:00:00+00') TO ('2016-05-09 00:00:00+00');


create table "pgstac"."items_search_p2016w19" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-05-09 00:00:00+00') TO ('2016-05-16 00:00:00+00');


create table "pgstac"."items_search_p2016w20" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-05-16 00:00:00+00') TO ('2016-05-23 00:00:00+00');


create table "pgstac"."items_search_p2016w21" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-05-23 00:00:00+00') TO ('2016-05-30 00:00:00+00');


create table "pgstac"."items_search_p2016w22" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-05-30 00:00:00+00') TO ('2016-06-06 00:00:00+00');


create table "pgstac"."items_search_p2016w23" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-06-06 00:00:00+00') TO ('2016-06-13 00:00:00+00');


create table "pgstac"."items_search_p2016w24" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-06-13 00:00:00+00') TO ('2016-06-20 00:00:00+00');


create table "pgstac"."items_search_p2016w25" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-06-20 00:00:00+00') TO ('2016-06-27 00:00:00+00');


create table "pgstac"."items_search_p2016w26" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-06-27 00:00:00+00') TO ('2016-07-04 00:00:00+00');


create table "pgstac"."items_search_p2016w27" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-07-04 00:00:00+00') TO ('2016-07-11 00:00:00+00');


create table "pgstac"."items_search_p2016w28" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-07-11 00:00:00+00') TO ('2016-07-18 00:00:00+00');


create table "pgstac"."items_search_p2016w29" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-07-18 00:00:00+00') TO ('2016-07-25 00:00:00+00');


create table "pgstac"."items_search_p2016w30" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-07-25 00:00:00+00') TO ('2016-08-01 00:00:00+00');


create table "pgstac"."items_search_p2016w31" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-08-01 00:00:00+00') TO ('2016-08-08 00:00:00+00');


create table "pgstac"."items_search_p2016w32" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-08-08 00:00:00+00') TO ('2016-08-15 00:00:00+00');


create table "pgstac"."items_search_p2016w33" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-08-15 00:00:00+00') TO ('2016-08-22 00:00:00+00');


create table "pgstac"."items_search_p2016w34" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-08-22 00:00:00+00') TO ('2016-08-29 00:00:00+00');


create table "pgstac"."items_search_p2016w35" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-08-29 00:00:00+00') TO ('2016-09-05 00:00:00+00');


create table "pgstac"."items_search_p2016w36" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-09-05 00:00:00+00') TO ('2016-09-12 00:00:00+00');


create table "pgstac"."items_search_p2016w37" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-09-12 00:00:00+00') TO ('2016-09-19 00:00:00+00');


create table "pgstac"."items_search_p2016w38" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-09-19 00:00:00+00') TO ('2016-09-26 00:00:00+00');


create table "pgstac"."items_search_p2016w39" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-09-26 00:00:00+00') TO ('2016-10-03 00:00:00+00');


create table "pgstac"."items_search_p2016w40" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-10-03 00:00:00+00') TO ('2016-10-10 00:00:00+00');


create table "pgstac"."items_search_p2016w41" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-10-10 00:00:00+00') TO ('2016-10-17 00:00:00+00');


create table "pgstac"."items_search_p2016w42" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-10-17 00:00:00+00') TO ('2016-10-24 00:00:00+00');


create table "pgstac"."items_search_p2016w43" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-10-24 00:00:00+00') TO ('2016-10-31 00:00:00+00');


create table "pgstac"."items_search_p2016w44" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-10-31 00:00:00+00') TO ('2016-11-07 00:00:00+00');


create table "pgstac"."items_search_p2016w45" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-11-07 00:00:00+00') TO ('2016-11-14 00:00:00+00');


create table "pgstac"."items_search_p2016w46" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-11-14 00:00:00+00') TO ('2016-11-21 00:00:00+00');


create table "pgstac"."items_search_p2016w47" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-11-21 00:00:00+00') TO ('2016-11-28 00:00:00+00');


create table "pgstac"."items_search_p2016w48" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-11-28 00:00:00+00') TO ('2016-12-05 00:00:00+00');


create table "pgstac"."items_search_p2016w49" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-12-05 00:00:00+00') TO ('2016-12-12 00:00:00+00');


create table "pgstac"."items_search_p2016w50" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-12-12 00:00:00+00') TO ('2016-12-19 00:00:00+00');


create table "pgstac"."items_search_p2016w51" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-12-19 00:00:00+00') TO ('2016-12-26 00:00:00+00');


create table "pgstac"."items_search_p2016w52" partition of "pgstac"."items_search" FOR VALUES FROM ('2016-12-26 00:00:00+00') TO ('2017-01-02 00:00:00+00');


create table "pgstac"."items_search_p2017w01" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-01-02 00:00:00+00') TO ('2017-01-09 00:00:00+00');


create table "pgstac"."items_search_p2017w02" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-01-09 00:00:00+00') TO ('2017-01-16 00:00:00+00');


create table "pgstac"."items_search_p2017w03" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-01-16 00:00:00+00') TO ('2017-01-23 00:00:00+00');


create table "pgstac"."items_search_p2017w04" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-01-23 00:00:00+00') TO ('2017-01-30 00:00:00+00');


create table "pgstac"."items_search_p2017w05" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-01-30 00:00:00+00') TO ('2017-02-06 00:00:00+00');


create table "pgstac"."items_search_p2017w06" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-02-06 00:00:00+00') TO ('2017-02-13 00:00:00+00');


create table "pgstac"."items_search_p2017w07" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-02-13 00:00:00+00') TO ('2017-02-20 00:00:00+00');


create table "pgstac"."items_search_p2017w08" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-02-20 00:00:00+00') TO ('2017-02-27 00:00:00+00');


create table "pgstac"."items_search_p2017w09" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-02-27 00:00:00+00') TO ('2017-03-06 00:00:00+00');


create table "pgstac"."items_search_p2017w10" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-03-06 00:00:00+00') TO ('2017-03-13 00:00:00+00');


create table "pgstac"."items_search_p2017w11" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-03-13 00:00:00+00') TO ('2017-03-20 00:00:00+00');


create table "pgstac"."items_search_p2017w12" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-03-20 00:00:00+00') TO ('2017-03-27 00:00:00+00');


create table "pgstac"."items_search_p2017w13" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-03-27 00:00:00+00') TO ('2017-04-03 00:00:00+00');


create table "pgstac"."items_search_p2017w14" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-04-03 00:00:00+00') TO ('2017-04-10 00:00:00+00');


create table "pgstac"."items_search_p2017w15" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-04-10 00:00:00+00') TO ('2017-04-17 00:00:00+00');


create table "pgstac"."items_search_p2017w16" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-04-17 00:00:00+00') TO ('2017-04-24 00:00:00+00');


create table "pgstac"."items_search_p2017w17" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-04-24 00:00:00+00') TO ('2017-05-01 00:00:00+00');


create table "pgstac"."items_search_p2017w18" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-05-01 00:00:00+00') TO ('2017-05-08 00:00:00+00');


create table "pgstac"."items_search_p2017w19" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-05-08 00:00:00+00') TO ('2017-05-15 00:00:00+00');


create table "pgstac"."items_search_p2017w20" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-05-15 00:00:00+00') TO ('2017-05-22 00:00:00+00');


create table "pgstac"."items_search_p2017w21" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-05-22 00:00:00+00') TO ('2017-05-29 00:00:00+00');


create table "pgstac"."items_search_p2017w22" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-05-29 00:00:00+00') TO ('2017-06-05 00:00:00+00');


create table "pgstac"."items_search_p2017w23" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-06-05 00:00:00+00') TO ('2017-06-12 00:00:00+00');


create table "pgstac"."items_search_p2017w24" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-06-12 00:00:00+00') TO ('2017-06-19 00:00:00+00');


create table "pgstac"."items_search_p2017w25" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-06-19 00:00:00+00') TO ('2017-06-26 00:00:00+00');


create table "pgstac"."items_search_p2017w26" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-06-26 00:00:00+00') TO ('2017-07-03 00:00:00+00');


create table "pgstac"."items_search_p2017w27" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-07-03 00:00:00+00') TO ('2017-07-10 00:00:00+00');


create table "pgstac"."items_search_p2017w28" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-07-10 00:00:00+00') TO ('2017-07-17 00:00:00+00');


create table "pgstac"."items_search_p2017w29" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-07-17 00:00:00+00') TO ('2017-07-24 00:00:00+00');


create table "pgstac"."items_search_p2017w30" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-07-24 00:00:00+00') TO ('2017-07-31 00:00:00+00');


create table "pgstac"."items_search_p2017w31" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-07-31 00:00:00+00') TO ('2017-08-07 00:00:00+00');


create table "pgstac"."items_search_p2017w32" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-08-07 00:00:00+00') TO ('2017-08-14 00:00:00+00');


create table "pgstac"."items_search_p2017w33" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-08-14 00:00:00+00') TO ('2017-08-21 00:00:00+00');


create table "pgstac"."items_search_p2017w34" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-08-21 00:00:00+00') TO ('2017-08-28 00:00:00+00');


create table "pgstac"."items_search_p2017w35" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-08-28 00:00:00+00') TO ('2017-09-04 00:00:00+00');


create table "pgstac"."items_search_p2017w36" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-09-04 00:00:00+00') TO ('2017-09-11 00:00:00+00');


create table "pgstac"."items_search_p2017w37" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-09-11 00:00:00+00') TO ('2017-09-18 00:00:00+00');


create table "pgstac"."items_search_p2017w38" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-09-18 00:00:00+00') TO ('2017-09-25 00:00:00+00');


create table "pgstac"."items_search_p2017w39" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-09-25 00:00:00+00') TO ('2017-10-02 00:00:00+00');


create table "pgstac"."items_search_p2017w40" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-10-02 00:00:00+00') TO ('2017-10-09 00:00:00+00');


create table "pgstac"."items_search_p2017w41" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-10-09 00:00:00+00') TO ('2017-10-16 00:00:00+00');


create table "pgstac"."items_search_p2017w42" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-10-16 00:00:00+00') TO ('2017-10-23 00:00:00+00');


create table "pgstac"."items_search_p2017w43" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-10-23 00:00:00+00') TO ('2017-10-30 00:00:00+00');


create table "pgstac"."items_search_p2017w44" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-10-30 00:00:00+00') TO ('2017-11-06 00:00:00+00');


create table "pgstac"."items_search_p2017w45" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-11-06 00:00:00+00') TO ('2017-11-13 00:00:00+00');


create table "pgstac"."items_search_p2017w46" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-11-13 00:00:00+00') TO ('2017-11-20 00:00:00+00');


create table "pgstac"."items_search_p2017w47" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-11-20 00:00:00+00') TO ('2017-11-27 00:00:00+00');


create table "pgstac"."items_search_p2017w48" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-11-27 00:00:00+00') TO ('2017-12-04 00:00:00+00');


create table "pgstac"."items_search_p2017w49" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-12-04 00:00:00+00') TO ('2017-12-11 00:00:00+00');


create table "pgstac"."items_search_p2017w50" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-12-11 00:00:00+00') TO ('2017-12-18 00:00:00+00');


create table "pgstac"."items_search_p2017w51" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-12-18 00:00:00+00') TO ('2017-12-25 00:00:00+00');


create table "pgstac"."items_search_p2017w52" partition of "pgstac"."items_search" FOR VALUES FROM ('2017-12-25 00:00:00+00') TO ('2018-01-01 00:00:00+00');


create table "pgstac"."items_search_p2018w01" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-01-01 00:00:00+00') TO ('2018-01-08 00:00:00+00');


create table "pgstac"."items_search_p2018w02" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-01-08 00:00:00+00') TO ('2018-01-15 00:00:00+00');


create table "pgstac"."items_search_p2018w03" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-01-15 00:00:00+00') TO ('2018-01-22 00:00:00+00');


create table "pgstac"."items_search_p2018w04" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-01-22 00:00:00+00') TO ('2018-01-29 00:00:00+00');


create table "pgstac"."items_search_p2018w05" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-01-29 00:00:00+00') TO ('2018-02-05 00:00:00+00');


create table "pgstac"."items_search_p2018w06" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-02-05 00:00:00+00') TO ('2018-02-12 00:00:00+00');


create table "pgstac"."items_search_p2018w07" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-02-12 00:00:00+00') TO ('2018-02-19 00:00:00+00');


create table "pgstac"."items_search_p2018w08" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-02-19 00:00:00+00') TO ('2018-02-26 00:00:00+00');


create table "pgstac"."items_search_p2018w09" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-02-26 00:00:00+00') TO ('2018-03-05 00:00:00+00');


create table "pgstac"."items_search_p2018w10" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-03-05 00:00:00+00') TO ('2018-03-12 00:00:00+00');


create table "pgstac"."items_search_p2018w11" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-03-12 00:00:00+00') TO ('2018-03-19 00:00:00+00');


create table "pgstac"."items_search_p2018w12" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-03-19 00:00:00+00') TO ('2018-03-26 00:00:00+00');


create table "pgstac"."items_search_p2018w13" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-03-26 00:00:00+00') TO ('2018-04-02 00:00:00+00');


create table "pgstac"."items_search_p2018w14" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-04-02 00:00:00+00') TO ('2018-04-09 00:00:00+00');


create table "pgstac"."items_search_p2018w15" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-04-09 00:00:00+00') TO ('2018-04-16 00:00:00+00');


create table "pgstac"."items_search_p2018w16" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-04-16 00:00:00+00') TO ('2018-04-23 00:00:00+00');


create table "pgstac"."items_search_p2018w17" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-04-23 00:00:00+00') TO ('2018-04-30 00:00:00+00');


create table "pgstac"."items_search_p2018w18" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-04-30 00:00:00+00') TO ('2018-05-07 00:00:00+00');


create table "pgstac"."items_search_p2018w19" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-05-07 00:00:00+00') TO ('2018-05-14 00:00:00+00');


create table "pgstac"."items_search_p2018w20" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-05-14 00:00:00+00') TO ('2018-05-21 00:00:00+00');


create table "pgstac"."items_search_p2018w21" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-05-21 00:00:00+00') TO ('2018-05-28 00:00:00+00');


create table "pgstac"."items_search_p2018w22" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-05-28 00:00:00+00') TO ('2018-06-04 00:00:00+00');


create table "pgstac"."items_search_p2018w23" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-06-04 00:00:00+00') TO ('2018-06-11 00:00:00+00');


create table "pgstac"."items_search_p2018w24" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-06-11 00:00:00+00') TO ('2018-06-18 00:00:00+00');


create table "pgstac"."items_search_p2018w25" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-06-18 00:00:00+00') TO ('2018-06-25 00:00:00+00');


create table "pgstac"."items_search_p2018w26" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-06-25 00:00:00+00') TO ('2018-07-02 00:00:00+00');


create table "pgstac"."items_search_p2018w27" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-07-02 00:00:00+00') TO ('2018-07-09 00:00:00+00');


create table "pgstac"."items_search_p2018w28" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-07-09 00:00:00+00') TO ('2018-07-16 00:00:00+00');


create table "pgstac"."items_search_p2018w29" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-07-16 00:00:00+00') TO ('2018-07-23 00:00:00+00');


create table "pgstac"."items_search_p2018w30" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-07-23 00:00:00+00') TO ('2018-07-30 00:00:00+00');


create table "pgstac"."items_search_p2018w31" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-07-30 00:00:00+00') TO ('2018-08-06 00:00:00+00');


create table "pgstac"."items_search_p2018w32" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-08-06 00:00:00+00') TO ('2018-08-13 00:00:00+00');


create table "pgstac"."items_search_p2018w33" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-08-13 00:00:00+00') TO ('2018-08-20 00:00:00+00');


create table "pgstac"."items_search_p2018w34" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-08-20 00:00:00+00') TO ('2018-08-27 00:00:00+00');


create table "pgstac"."items_search_p2018w35" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-08-27 00:00:00+00') TO ('2018-09-03 00:00:00+00');


create table "pgstac"."items_search_p2018w36" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-09-03 00:00:00+00') TO ('2018-09-10 00:00:00+00');


create table "pgstac"."items_search_p2018w37" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-09-10 00:00:00+00') TO ('2018-09-17 00:00:00+00');


create table "pgstac"."items_search_p2018w38" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-09-17 00:00:00+00') TO ('2018-09-24 00:00:00+00');


create table "pgstac"."items_search_p2018w39" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-09-24 00:00:00+00') TO ('2018-10-01 00:00:00+00');


create table "pgstac"."items_search_p2018w40" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-10-01 00:00:00+00') TO ('2018-10-08 00:00:00+00');


create table "pgstac"."items_search_p2018w41" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-10-08 00:00:00+00') TO ('2018-10-15 00:00:00+00');


create table "pgstac"."items_search_p2018w42" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-10-15 00:00:00+00') TO ('2018-10-22 00:00:00+00');


create table "pgstac"."items_search_p2018w43" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-10-22 00:00:00+00') TO ('2018-10-29 00:00:00+00');


create table "pgstac"."items_search_p2018w44" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-10-29 00:00:00+00') TO ('2018-11-05 00:00:00+00');


create table "pgstac"."items_search_p2018w45" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-11-05 00:00:00+00') TO ('2018-11-12 00:00:00+00');


create table "pgstac"."items_search_p2018w46" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-11-12 00:00:00+00') TO ('2018-11-19 00:00:00+00');


create table "pgstac"."items_search_p2018w47" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-11-19 00:00:00+00') TO ('2018-11-26 00:00:00+00');


create table "pgstac"."items_search_p2018w48" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-11-26 00:00:00+00') TO ('2018-12-03 00:00:00+00');


create table "pgstac"."items_search_p2018w49" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-12-03 00:00:00+00') TO ('2018-12-10 00:00:00+00');


create table "pgstac"."items_search_p2018w50" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-12-10 00:00:00+00') TO ('2018-12-17 00:00:00+00');


create table "pgstac"."items_search_p2018w51" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-12-17 00:00:00+00') TO ('2018-12-24 00:00:00+00');


create table "pgstac"."items_search_p2018w52" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-12-24 00:00:00+00') TO ('2018-12-31 00:00:00+00');


create table "pgstac"."items_search_p2019w01" partition of "pgstac"."items_search" FOR VALUES FROM ('2018-12-31 00:00:00+00') TO ('2019-01-07 00:00:00+00');


create table "pgstac"."items_search_p2019w02" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-01-07 00:00:00+00') TO ('2019-01-14 00:00:00+00');


create table "pgstac"."items_search_p2019w03" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-01-14 00:00:00+00') TO ('2019-01-21 00:00:00+00');


create table "pgstac"."items_search_p2019w04" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-01-21 00:00:00+00') TO ('2019-01-28 00:00:00+00');


create table "pgstac"."items_search_p2019w05" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-01-28 00:00:00+00') TO ('2019-02-04 00:00:00+00');


create table "pgstac"."items_search_p2019w06" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-02-04 00:00:00+00') TO ('2019-02-11 00:00:00+00');


create table "pgstac"."items_search_p2019w07" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-02-11 00:00:00+00') TO ('2019-02-18 00:00:00+00');


create table "pgstac"."items_search_p2019w08" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-02-18 00:00:00+00') TO ('2019-02-25 00:00:00+00');


create table "pgstac"."items_search_p2019w09" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-02-25 00:00:00+00') TO ('2019-03-04 00:00:00+00');


create table "pgstac"."items_search_p2019w10" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-03-04 00:00:00+00') TO ('2019-03-11 00:00:00+00');


create table "pgstac"."items_search_p2019w11" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-03-11 00:00:00+00') TO ('2019-03-18 00:00:00+00');


create table "pgstac"."items_search_p2019w12" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-03-18 00:00:00+00') TO ('2019-03-25 00:00:00+00');


create table "pgstac"."items_search_p2019w13" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-03-25 00:00:00+00') TO ('2019-04-01 00:00:00+00');


create table "pgstac"."items_search_p2019w14" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-04-01 00:00:00+00') TO ('2019-04-08 00:00:00+00');


create table "pgstac"."items_search_p2019w15" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-04-08 00:00:00+00') TO ('2019-04-15 00:00:00+00');


create table "pgstac"."items_search_p2019w16" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-04-15 00:00:00+00') TO ('2019-04-22 00:00:00+00');


create table "pgstac"."items_search_p2019w17" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-04-22 00:00:00+00') TO ('2019-04-29 00:00:00+00');


create table "pgstac"."items_search_p2019w18" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-04-29 00:00:00+00') TO ('2019-05-06 00:00:00+00');


create table "pgstac"."items_search_p2019w19" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-05-06 00:00:00+00') TO ('2019-05-13 00:00:00+00');


create table "pgstac"."items_search_p2019w20" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-05-13 00:00:00+00') TO ('2019-05-20 00:00:00+00');


create table "pgstac"."items_search_p2019w21" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-05-20 00:00:00+00') TO ('2019-05-27 00:00:00+00');


create table "pgstac"."items_search_p2019w22" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-05-27 00:00:00+00') TO ('2019-06-03 00:00:00+00');


create table "pgstac"."items_search_p2019w23" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-06-03 00:00:00+00') TO ('2019-06-10 00:00:00+00');


create table "pgstac"."items_search_p2019w24" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-06-10 00:00:00+00') TO ('2019-06-17 00:00:00+00');


create table "pgstac"."items_search_p2019w25" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-06-17 00:00:00+00') TO ('2019-06-24 00:00:00+00');


create table "pgstac"."items_search_p2019w26" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-06-24 00:00:00+00') TO ('2019-07-01 00:00:00+00');


create table "pgstac"."items_search_p2019w27" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-07-01 00:00:00+00') TO ('2019-07-08 00:00:00+00');


create table "pgstac"."items_search_p2019w28" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-07-08 00:00:00+00') TO ('2019-07-15 00:00:00+00');


create table "pgstac"."items_search_p2019w29" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-07-15 00:00:00+00') TO ('2019-07-22 00:00:00+00');


create table "pgstac"."items_search_p2019w30" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-07-22 00:00:00+00') TO ('2019-07-29 00:00:00+00');


create table "pgstac"."items_search_p2019w31" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-07-29 00:00:00+00') TO ('2019-08-05 00:00:00+00');


create table "pgstac"."items_search_p2019w32" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-08-05 00:00:00+00') TO ('2019-08-12 00:00:00+00');


create table "pgstac"."items_search_p2019w33" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-08-12 00:00:00+00') TO ('2019-08-19 00:00:00+00');


create table "pgstac"."items_search_p2019w34" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-08-19 00:00:00+00') TO ('2019-08-26 00:00:00+00');


create table "pgstac"."items_search_p2019w35" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-08-26 00:00:00+00') TO ('2019-09-02 00:00:00+00');


create table "pgstac"."items_search_p2019w36" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-09-02 00:00:00+00') TO ('2019-09-09 00:00:00+00');


create table "pgstac"."items_search_p2019w37" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-09-09 00:00:00+00') TO ('2019-09-16 00:00:00+00');


create table "pgstac"."items_search_p2019w38" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-09-16 00:00:00+00') TO ('2019-09-23 00:00:00+00');


create table "pgstac"."items_search_p2019w39" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-09-23 00:00:00+00') TO ('2019-09-30 00:00:00+00');


create table "pgstac"."items_search_p2019w40" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-09-30 00:00:00+00') TO ('2019-10-07 00:00:00+00');


create table "pgstac"."items_search_p2019w41" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-10-07 00:00:00+00') TO ('2019-10-14 00:00:00+00');


create table "pgstac"."items_search_p2019w42" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-10-14 00:00:00+00') TO ('2019-10-21 00:00:00+00');


create table "pgstac"."items_search_p2019w43" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-10-21 00:00:00+00') TO ('2019-10-28 00:00:00+00');


create table "pgstac"."items_search_p2019w44" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-10-28 00:00:00+00') TO ('2019-11-04 00:00:00+00');


create table "pgstac"."items_search_p2019w45" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-11-04 00:00:00+00') TO ('2019-11-11 00:00:00+00');


create table "pgstac"."items_search_p2019w46" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-11-11 00:00:00+00') TO ('2019-11-18 00:00:00+00');


create table "pgstac"."items_search_p2019w47" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-11-18 00:00:00+00') TO ('2019-11-25 00:00:00+00');


create table "pgstac"."items_search_p2019w48" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-11-25 00:00:00+00') TO ('2019-12-02 00:00:00+00');


create table "pgstac"."items_search_p2019w49" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-12-02 00:00:00+00') TO ('2019-12-09 00:00:00+00');


create table "pgstac"."items_search_p2019w50" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-12-09 00:00:00+00') TO ('2019-12-16 00:00:00+00');


create table "pgstac"."items_search_p2019w51" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-12-16 00:00:00+00') TO ('2019-12-23 00:00:00+00');


create table "pgstac"."items_search_p2019w52" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-12-23 00:00:00+00') TO ('2019-12-30 00:00:00+00');


create table "pgstac"."items_search_p2020w01" partition of "pgstac"."items_search" FOR VALUES FROM ('2019-12-30 00:00:00+00') TO ('2020-01-06 00:00:00+00');


create table "pgstac"."items_search_p2020w02" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-01-06 00:00:00+00') TO ('2020-01-13 00:00:00+00');


create table "pgstac"."items_search_p2020w03" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-01-13 00:00:00+00') TO ('2020-01-20 00:00:00+00');


create table "pgstac"."items_search_p2020w04" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-01-20 00:00:00+00') TO ('2020-01-27 00:00:00+00');


create table "pgstac"."items_search_p2020w05" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-01-27 00:00:00+00') TO ('2020-02-03 00:00:00+00');


create table "pgstac"."items_search_p2020w06" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-02-03 00:00:00+00') TO ('2020-02-10 00:00:00+00');


create table "pgstac"."items_search_p2020w07" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-02-10 00:00:00+00') TO ('2020-02-17 00:00:00+00');


create table "pgstac"."items_search_p2020w08" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-02-17 00:00:00+00') TO ('2020-02-24 00:00:00+00');


create table "pgstac"."items_search_p2020w09" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-02-24 00:00:00+00') TO ('2020-03-02 00:00:00+00');


create table "pgstac"."items_search_p2020w10" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-03-02 00:00:00+00') TO ('2020-03-09 00:00:00+00');


create table "pgstac"."items_search_p2020w11" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-03-09 00:00:00+00') TO ('2020-03-16 00:00:00+00');


create table "pgstac"."items_search_p2020w12" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-03-16 00:00:00+00') TO ('2020-03-23 00:00:00+00');


create table "pgstac"."items_search_p2020w13" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-03-23 00:00:00+00') TO ('2020-03-30 00:00:00+00');


create table "pgstac"."items_search_p2020w14" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-03-30 00:00:00+00') TO ('2020-04-06 00:00:00+00');


create table "pgstac"."items_search_p2020w15" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-04-06 00:00:00+00') TO ('2020-04-13 00:00:00+00');


create table "pgstac"."items_search_p2020w16" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-04-13 00:00:00+00') TO ('2020-04-20 00:00:00+00');


create table "pgstac"."items_search_p2020w17" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-04-20 00:00:00+00') TO ('2020-04-27 00:00:00+00');


create table "pgstac"."items_search_p2020w18" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-04-27 00:00:00+00') TO ('2020-05-04 00:00:00+00');


create table "pgstac"."items_search_p2020w19" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-05-04 00:00:00+00') TO ('2020-05-11 00:00:00+00');


create table "pgstac"."items_search_p2020w20" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-05-11 00:00:00+00') TO ('2020-05-18 00:00:00+00');


create table "pgstac"."items_search_p2020w21" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-05-18 00:00:00+00') TO ('2020-05-25 00:00:00+00');


create table "pgstac"."items_search_p2020w22" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-05-25 00:00:00+00') TO ('2020-06-01 00:00:00+00');


create table "pgstac"."items_search_p2020w23" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-06-01 00:00:00+00') TO ('2020-06-08 00:00:00+00');


create table "pgstac"."items_search_p2020w24" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-06-08 00:00:00+00') TO ('2020-06-15 00:00:00+00');


create table "pgstac"."items_search_p2020w25" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-06-15 00:00:00+00') TO ('2020-06-22 00:00:00+00');


create table "pgstac"."items_search_p2020w26" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-06-22 00:00:00+00') TO ('2020-06-29 00:00:00+00');


create table "pgstac"."items_search_p2020w27" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-06-29 00:00:00+00') TO ('2020-07-06 00:00:00+00');


create table "pgstac"."items_search_p2020w28" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-07-06 00:00:00+00') TO ('2020-07-13 00:00:00+00');


create table "pgstac"."items_search_p2020w29" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-07-13 00:00:00+00') TO ('2020-07-20 00:00:00+00');


create table "pgstac"."items_search_p2020w30" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-07-20 00:00:00+00') TO ('2020-07-27 00:00:00+00');


create table "pgstac"."items_search_p2020w31" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-07-27 00:00:00+00') TO ('2020-08-03 00:00:00+00');


create table "pgstac"."items_search_p2020w32" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-08-03 00:00:00+00') TO ('2020-08-10 00:00:00+00');


create table "pgstac"."items_search_p2020w33" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-08-10 00:00:00+00') TO ('2020-08-17 00:00:00+00');


create table "pgstac"."items_search_p2020w34" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-08-17 00:00:00+00') TO ('2020-08-24 00:00:00+00');


create table "pgstac"."items_search_p2020w35" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-08-24 00:00:00+00') TO ('2020-08-31 00:00:00+00');


create table "pgstac"."items_search_p2020w36" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-08-31 00:00:00+00') TO ('2020-09-07 00:00:00+00');


create table "pgstac"."items_search_p2020w37" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-09-07 00:00:00+00') TO ('2020-09-14 00:00:00+00');


create table "pgstac"."items_search_p2020w38" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-09-14 00:00:00+00') TO ('2020-09-21 00:00:00+00');


create table "pgstac"."items_search_p2020w39" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-09-21 00:00:00+00') TO ('2020-09-28 00:00:00+00');


create table "pgstac"."items_search_p2020w40" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-09-28 00:00:00+00') TO ('2020-10-05 00:00:00+00');


create table "pgstac"."items_search_p2020w41" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-10-05 00:00:00+00') TO ('2020-10-12 00:00:00+00');


create table "pgstac"."items_search_p2020w42" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-10-12 00:00:00+00') TO ('2020-10-19 00:00:00+00');


create table "pgstac"."items_search_p2020w43" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-10-19 00:00:00+00') TO ('2020-10-26 00:00:00+00');


create table "pgstac"."items_search_p2020w44" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-10-26 00:00:00+00') TO ('2020-11-02 00:00:00+00');


create table "pgstac"."items_search_p2020w45" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-11-02 00:00:00+00') TO ('2020-11-09 00:00:00+00');


create table "pgstac"."items_search_p2020w46" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-11-09 00:00:00+00') TO ('2020-11-16 00:00:00+00');


create table "pgstac"."items_search_p2020w47" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-11-16 00:00:00+00') TO ('2020-11-23 00:00:00+00');


create table "pgstac"."items_search_p2020w48" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-11-23 00:00:00+00') TO ('2020-11-30 00:00:00+00');


create table "pgstac"."items_search_p2020w49" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-11-30 00:00:00+00') TO ('2020-12-07 00:00:00+00');


create table "pgstac"."items_search_p2020w50" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-12-07 00:00:00+00') TO ('2020-12-14 00:00:00+00');


create table "pgstac"."items_search_p2020w51" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-12-14 00:00:00+00') TO ('2020-12-21 00:00:00+00');


create table "pgstac"."items_search_p2020w52" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-12-21 00:00:00+00') TO ('2020-12-28 00:00:00+00');


create table "pgstac"."items_search_p2020w53" partition of "pgstac"."items_search" FOR VALUES FROM ('2020-12-28 00:00:00+00') TO ('2021-01-04 00:00:00+00');


create table "pgstac"."items_search_p2021w01" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-01-04 00:00:00+00') TO ('2021-01-11 00:00:00+00');


create table "pgstac"."items_search_p2021w02" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-01-11 00:00:00+00') TO ('2021-01-18 00:00:00+00');


create table "pgstac"."items_search_p2021w03" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-01-18 00:00:00+00') TO ('2021-01-25 00:00:00+00');


create table "pgstac"."items_search_p2021w04" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-01-25 00:00:00+00') TO ('2021-02-01 00:00:00+00');


create table "pgstac"."items_search_p2021w05" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-02-01 00:00:00+00') TO ('2021-02-08 00:00:00+00');


create table "pgstac"."items_search_p2021w06" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-02-08 00:00:00+00') TO ('2021-02-15 00:00:00+00');


create table "pgstac"."items_search_p2021w07" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-02-15 00:00:00+00') TO ('2021-02-22 00:00:00+00');


create table "pgstac"."items_search_p2021w08" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-02-22 00:00:00+00') TO ('2021-03-01 00:00:00+00');


create table "pgstac"."items_search_p2021w09" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-03-01 00:00:00+00') TO ('2021-03-08 00:00:00+00');


create table "pgstac"."items_search_p2021w10" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-03-08 00:00:00+00') TO ('2021-03-15 00:00:00+00');


create table "pgstac"."items_search_p2021w11" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-03-15 00:00:00+00') TO ('2021-03-22 00:00:00+00');


create table "pgstac"."items_search_p2021w12" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-03-22 00:00:00+00') TO ('2021-03-29 00:00:00+00');


create table "pgstac"."items_search_p2021w13" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-03-29 00:00:00+00') TO ('2021-04-05 00:00:00+00');


create table "pgstac"."items_search_p2021w14" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-04-05 00:00:00+00') TO ('2021-04-12 00:00:00+00');


create table "pgstac"."items_search_p2021w15" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-04-12 00:00:00+00') TO ('2021-04-19 00:00:00+00');


create table "pgstac"."items_search_p2021w16" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-04-19 00:00:00+00') TO ('2021-04-26 00:00:00+00');


create table "pgstac"."items_search_p2021w17" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-04-26 00:00:00+00') TO ('2021-05-03 00:00:00+00');


create table "pgstac"."items_search_p2021w18" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-05-03 00:00:00+00') TO ('2021-05-10 00:00:00+00');


create table "pgstac"."items_search_p2021w19" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-05-10 00:00:00+00') TO ('2021-05-17 00:00:00+00');


create table "pgstac"."items_search_p2021w20" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-05-17 00:00:00+00') TO ('2021-05-24 00:00:00+00');


create table "pgstac"."items_search_p2021w21" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-05-24 00:00:00+00') TO ('2021-05-31 00:00:00+00');


create table "pgstac"."items_search_p2021w22" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-05-31 00:00:00+00') TO ('2021-06-07 00:00:00+00');


create table "pgstac"."items_search_p2021w23" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-06-07 00:00:00+00') TO ('2021-06-14 00:00:00+00');


create table "pgstac"."items_search_p2021w24" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-06-14 00:00:00+00') TO ('2021-06-21 00:00:00+00');


create table "pgstac"."items_search_p2021w25" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-06-21 00:00:00+00') TO ('2021-06-28 00:00:00+00');


create table "pgstac"."items_search_p2021w26" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-06-28 00:00:00+00') TO ('2021-07-05 00:00:00+00');


create table "pgstac"."items_search_p2021w27" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-07-05 00:00:00+00') TO ('2021-07-12 00:00:00+00');


create table "pgstac"."items_search_p2021w28" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-07-12 00:00:00+00') TO ('2021-07-19 00:00:00+00');


create table "pgstac"."items_search_p2021w29" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-07-19 00:00:00+00') TO ('2021-07-26 00:00:00+00');


create table "pgstac"."items_search_p2021w30" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-07-26 00:00:00+00') TO ('2021-08-02 00:00:00+00');


create table "pgstac"."items_search_p2021w31" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-08-02 00:00:00+00') TO ('2021-08-09 00:00:00+00');


create table "pgstac"."items_search_p2021w32" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-08-09 00:00:00+00') TO ('2021-08-16 00:00:00+00');


create table "pgstac"."items_search_p2021w33" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-08-16 00:00:00+00') TO ('2021-08-23 00:00:00+00');


create table "pgstac"."items_search_p2021w34" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-08-23 00:00:00+00') TO ('2021-08-30 00:00:00+00');


create table "pgstac"."items_search_p2021w35" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-08-30 00:00:00+00') TO ('2021-09-06 00:00:00+00');


create table "pgstac"."items_search_p2021w36" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-09-06 00:00:00+00') TO ('2021-09-13 00:00:00+00');


create table "pgstac"."items_search_p2021w37" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-09-13 00:00:00+00') TO ('2021-09-20 00:00:00+00');


create table "pgstac"."items_search_p2021w38" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-09-20 00:00:00+00') TO ('2021-09-27 00:00:00+00');


create table "pgstac"."items_search_p2021w39" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-09-27 00:00:00+00') TO ('2021-10-04 00:00:00+00');


create table "pgstac"."items_search_p2021w40" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-10-04 00:00:00+00') TO ('2021-10-11 00:00:00+00');


create table "pgstac"."items_search_p2021w41" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-10-11 00:00:00+00') TO ('2021-10-18 00:00:00+00');


create table "pgstac"."items_search_p2021w42" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-10-18 00:00:00+00') TO ('2021-10-25 00:00:00+00');


create table "pgstac"."items_search_p2021w43" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-10-25 00:00:00+00') TO ('2021-11-01 00:00:00+00');


create table "pgstac"."items_search_p2021w44" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-11-01 00:00:00+00') TO ('2021-11-08 00:00:00+00');


create table "pgstac"."items_search_p2021w45" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-11-08 00:00:00+00') TO ('2021-11-15 00:00:00+00');


create table "pgstac"."items_search_p2021w46" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-11-15 00:00:00+00') TO ('2021-11-22 00:00:00+00');


create table "pgstac"."items_search_p2021w47" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-11-22 00:00:00+00') TO ('2021-11-29 00:00:00+00');


create table "pgstac"."items_search_p2021w48" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-11-29 00:00:00+00') TO ('2021-12-06 00:00:00+00');


create table "pgstac"."items_search_p2021w49" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-12-06 00:00:00+00') TO ('2021-12-13 00:00:00+00');


create table "pgstac"."items_search_p2021w50" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-12-13 00:00:00+00') TO ('2021-12-20 00:00:00+00');


create table "pgstac"."items_search_p2021w51" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-12-20 00:00:00+00') TO ('2021-12-27 00:00:00+00');


create table "pgstac"."items_search_p2021w52" partition of "pgstac"."items_search" FOR VALUES FROM ('2021-12-27 00:00:00+00') TO ('2022-01-03 00:00:00+00');


create table "pgstac"."items_search_p2022w01" partition of "pgstac"."items_search" FOR VALUES FROM ('2022-01-03 00:00:00+00') TO ('2022-01-10 00:00:00+00');


create table "pgstac"."items_search_p2022w02" partition of "pgstac"."items_search" FOR VALUES FROM ('2022-01-10 00:00:00+00') TO ('2022-01-17 00:00:00+00');


create table "pgstac"."items_search_p2022w03" partition of "pgstac"."items_search" FOR VALUES FROM ('2022-01-17 00:00:00+00') TO ('2022-01-24 00:00:00+00');


create table "pgstac"."items_search_p2022w04" partition of "pgstac"."items_search" FOR VALUES FROM ('2022-01-24 00:00:00+00') TO ('2022-01-31 00:00:00+00');


create table "pgstac"."items_search_p2022w05" partition of "pgstac"."items_search" FOR VALUES FROM ('2022-01-31 00:00:00+00') TO ('2022-02-07 00:00:00+00');


create table "pgstac"."items_search_p2022w06" partition of "pgstac"."items_search" FOR VALUES FROM ('2022-02-07 00:00:00+00') TO ('2022-02-14 00:00:00+00');


create table "pgstac"."items_search_p2022w07" partition of "pgstac"."items_search" FOR VALUES FROM ('2022-02-14 00:00:00+00') TO ('2022-02-21 00:00:00+00');


create table "pgstac"."items_search_p2022w08" partition of "pgstac"."items_search" FOR VALUES FROM ('2022-02-21 00:00:00+00') TO ('2022-02-28 00:00:00+00');


create table "pgstac"."items_search_p2022w09" partition of "pgstac"."items_search" FOR VALUES FROM ('2022-02-28 00:00:00+00') TO ('2022-03-07 00:00:00+00');


create table "pgstac"."items_search_p2022w10" partition of "pgstac"."items_search" FOR VALUES FROM ('2022-03-07 00:00:00+00') TO ('2022-03-14 00:00:00+00');


create table "pgstac"."items_search_p2022w11" partition of "pgstac"."items_search" FOR VALUES FROM ('2022-03-14 00:00:00+00') TO ('2022-03-21 00:00:00+00');


create table "pgstac"."items_search_p2022w12" partition of "pgstac"."items_search" FOR VALUES FROM ('2022-03-21 00:00:00+00') TO ('2022-03-28 00:00:00+00');


create table "pgstac"."items_search_p2022w13" partition of "pgstac"."items_search" FOR VALUES FROM ('2022-03-28 00:00:00+00') TO ('2022-04-04 00:00:00+00');


create table "pgstac"."items_search_p2022w14" partition of "pgstac"."items_search" FOR VALUES FROM ('2022-04-04 00:00:00+00') TO ('2022-04-11 00:00:00+00');


create table "pgstac"."items_search_p2022w15" partition of "pgstac"."items_search" FOR VALUES FROM ('2022-04-11 00:00:00+00') TO ('2022-04-18 00:00:00+00');


create table "pgstac"."items_search_p2022w16" partition of "pgstac"."items_search" FOR VALUES FROM ('2022-04-18 00:00:00+00') TO ('2022-04-25 00:00:00+00');


create table "pgstac"."items_search_p2022w17" partition of "pgstac"."items_search" FOR VALUES FROM ('2022-04-25 00:00:00+00') TO ('2022-05-02 00:00:00+00');


create table "pgstac"."items_search_p2022w18" partition of "pgstac"."items_search" FOR VALUES FROM ('2022-05-02 00:00:00+00') TO ('2022-05-09 00:00:00+00');


create table "pgstac"."items_search_template" (
    "id" text not null,
    "geometry" geometry not null,
    "properties" jsonb,
    "collection_id" text not null,
    "datetime" timestamp with time zone not null
);


CREATE INDEX collection_idx ON ONLY pgstac.items_search USING btree (collection_id);

CREATE UNIQUE INDEX collections_pkey ON pgstac.collections USING btree (id);

CREATE INDEX datetime_id_idx ON ONLY pgstac.items_search USING btree (datetime, id);

CREATE INDEX geometry_idx ON ONLY pgstac.items_search USING gist (geometry);

CREATE UNIQUE INDEX items_pkey ON pgstac.items USING btree (id);

CREATE INDEX items_search_default_collection_id_idx ON pgstac.items_search_default USING btree (collection_id);

CREATE INDEX items_search_default_datetime_id_idx ON pgstac.items_search_default USING btree (datetime, id);

CREATE INDEX items_search_default_geometry_idx ON pgstac.items_search_default USING gist (geometry);

CREATE UNIQUE INDEX items_search_default_pkey ON pgstac.items_search_default USING btree (id);

CREATE INDEX items_search_default_properties_idx ON pgstac.items_search_default USING gin (properties);

CREATE INDEX items_search_p1999w52_collection_id_idx ON pgstac.items_search_p1999w52 USING btree (collection_id);

CREATE INDEX items_search_p1999w52_datetime_id_idx ON pgstac.items_search_p1999w52 USING btree (datetime, id);

CREATE INDEX items_search_p1999w52_geometry_idx ON pgstac.items_search_p1999w52 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p1999w52_pkey ON pgstac.items_search_p1999w52 USING btree (id);

CREATE INDEX items_search_p1999w52_properties_idx ON pgstac.items_search_p1999w52 USING gin (properties);

CREATE INDEX items_search_p2000w01_collection_id_idx ON pgstac.items_search_p2000w01 USING btree (collection_id);

CREATE INDEX items_search_p2000w01_datetime_id_idx ON pgstac.items_search_p2000w01 USING btree (datetime, id);

CREATE INDEX items_search_p2000w01_geometry_idx ON pgstac.items_search_p2000w01 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w01_pkey ON pgstac.items_search_p2000w01 USING btree (id);

CREATE INDEX items_search_p2000w01_properties_idx ON pgstac.items_search_p2000w01 USING gin (properties);

CREATE INDEX items_search_p2000w02_collection_id_idx ON pgstac.items_search_p2000w02 USING btree (collection_id);

CREATE INDEX items_search_p2000w02_datetime_id_idx ON pgstac.items_search_p2000w02 USING btree (datetime, id);

CREATE INDEX items_search_p2000w02_geometry_idx ON pgstac.items_search_p2000w02 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w02_pkey ON pgstac.items_search_p2000w02 USING btree (id);

CREATE INDEX items_search_p2000w02_properties_idx ON pgstac.items_search_p2000w02 USING gin (properties);

CREATE INDEX items_search_p2000w03_collection_id_idx ON pgstac.items_search_p2000w03 USING btree (collection_id);

CREATE INDEX items_search_p2000w03_datetime_id_idx ON pgstac.items_search_p2000w03 USING btree (datetime, id);

CREATE INDEX items_search_p2000w03_geometry_idx ON pgstac.items_search_p2000w03 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w03_pkey ON pgstac.items_search_p2000w03 USING btree (id);

CREATE INDEX items_search_p2000w03_properties_idx ON pgstac.items_search_p2000w03 USING gin (properties);

CREATE INDEX items_search_p2000w04_collection_id_idx ON pgstac.items_search_p2000w04 USING btree (collection_id);

CREATE INDEX items_search_p2000w04_datetime_id_idx ON pgstac.items_search_p2000w04 USING btree (datetime, id);

CREATE INDEX items_search_p2000w04_geometry_idx ON pgstac.items_search_p2000w04 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w04_pkey ON pgstac.items_search_p2000w04 USING btree (id);

CREATE INDEX items_search_p2000w04_properties_idx ON pgstac.items_search_p2000w04 USING gin (properties);

CREATE INDEX items_search_p2000w05_collection_id_idx ON pgstac.items_search_p2000w05 USING btree (collection_id);

CREATE INDEX items_search_p2000w05_datetime_id_idx ON pgstac.items_search_p2000w05 USING btree (datetime, id);

CREATE INDEX items_search_p2000w05_geometry_idx ON pgstac.items_search_p2000w05 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w05_pkey ON pgstac.items_search_p2000w05 USING btree (id);

CREATE INDEX items_search_p2000w05_properties_idx ON pgstac.items_search_p2000w05 USING gin (properties);

CREATE INDEX items_search_p2000w06_collection_id_idx ON pgstac.items_search_p2000w06 USING btree (collection_id);

CREATE INDEX items_search_p2000w06_datetime_id_idx ON pgstac.items_search_p2000w06 USING btree (datetime, id);

CREATE INDEX items_search_p2000w06_geometry_idx ON pgstac.items_search_p2000w06 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w06_pkey ON pgstac.items_search_p2000w06 USING btree (id);

CREATE INDEX items_search_p2000w06_properties_idx ON pgstac.items_search_p2000w06 USING gin (properties);

CREATE INDEX items_search_p2000w07_collection_id_idx ON pgstac.items_search_p2000w07 USING btree (collection_id);

CREATE INDEX items_search_p2000w07_datetime_id_idx ON pgstac.items_search_p2000w07 USING btree (datetime, id);

CREATE INDEX items_search_p2000w07_geometry_idx ON pgstac.items_search_p2000w07 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w07_pkey ON pgstac.items_search_p2000w07 USING btree (id);

CREATE INDEX items_search_p2000w07_properties_idx ON pgstac.items_search_p2000w07 USING gin (properties);

CREATE INDEX items_search_p2000w08_collection_id_idx ON pgstac.items_search_p2000w08 USING btree (collection_id);

CREATE INDEX items_search_p2000w08_datetime_id_idx ON pgstac.items_search_p2000w08 USING btree (datetime, id);

CREATE INDEX items_search_p2000w08_geometry_idx ON pgstac.items_search_p2000w08 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w08_pkey ON pgstac.items_search_p2000w08 USING btree (id);

CREATE INDEX items_search_p2000w08_properties_idx ON pgstac.items_search_p2000w08 USING gin (properties);

CREATE INDEX items_search_p2000w09_collection_id_idx ON pgstac.items_search_p2000w09 USING btree (collection_id);

CREATE INDEX items_search_p2000w09_datetime_id_idx ON pgstac.items_search_p2000w09 USING btree (datetime, id);

CREATE INDEX items_search_p2000w09_geometry_idx ON pgstac.items_search_p2000w09 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w09_pkey ON pgstac.items_search_p2000w09 USING btree (id);

CREATE INDEX items_search_p2000w09_properties_idx ON pgstac.items_search_p2000w09 USING gin (properties);

CREATE INDEX items_search_p2000w10_collection_id_idx ON pgstac.items_search_p2000w10 USING btree (collection_id);

CREATE INDEX items_search_p2000w10_datetime_id_idx ON pgstac.items_search_p2000w10 USING btree (datetime, id);

CREATE INDEX items_search_p2000w10_geometry_idx ON pgstac.items_search_p2000w10 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w10_pkey ON pgstac.items_search_p2000w10 USING btree (id);

CREATE INDEX items_search_p2000w10_properties_idx ON pgstac.items_search_p2000w10 USING gin (properties);

CREATE INDEX items_search_p2000w11_collection_id_idx ON pgstac.items_search_p2000w11 USING btree (collection_id);

CREATE INDEX items_search_p2000w11_datetime_id_idx ON pgstac.items_search_p2000w11 USING btree (datetime, id);

CREATE INDEX items_search_p2000w11_geometry_idx ON pgstac.items_search_p2000w11 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w11_pkey ON pgstac.items_search_p2000w11 USING btree (id);

CREATE INDEX items_search_p2000w11_properties_idx ON pgstac.items_search_p2000w11 USING gin (properties);

CREATE INDEX items_search_p2000w12_collection_id_idx ON pgstac.items_search_p2000w12 USING btree (collection_id);

CREATE INDEX items_search_p2000w12_datetime_id_idx ON pgstac.items_search_p2000w12 USING btree (datetime, id);

CREATE INDEX items_search_p2000w12_geometry_idx ON pgstac.items_search_p2000w12 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w12_pkey ON pgstac.items_search_p2000w12 USING btree (id);

CREATE INDEX items_search_p2000w12_properties_idx ON pgstac.items_search_p2000w12 USING gin (properties);

CREATE INDEX items_search_p2000w13_collection_id_idx ON pgstac.items_search_p2000w13 USING btree (collection_id);

CREATE INDEX items_search_p2000w13_datetime_id_idx ON pgstac.items_search_p2000w13 USING btree (datetime, id);

CREATE INDEX items_search_p2000w13_geometry_idx ON pgstac.items_search_p2000w13 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w13_pkey ON pgstac.items_search_p2000w13 USING btree (id);

CREATE INDEX items_search_p2000w13_properties_idx ON pgstac.items_search_p2000w13 USING gin (properties);

CREATE INDEX items_search_p2000w14_collection_id_idx ON pgstac.items_search_p2000w14 USING btree (collection_id);

CREATE INDEX items_search_p2000w14_datetime_id_idx ON pgstac.items_search_p2000w14 USING btree (datetime, id);

CREATE INDEX items_search_p2000w14_geometry_idx ON pgstac.items_search_p2000w14 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w14_pkey ON pgstac.items_search_p2000w14 USING btree (id);

CREATE INDEX items_search_p2000w14_properties_idx ON pgstac.items_search_p2000w14 USING gin (properties);

CREATE INDEX items_search_p2000w15_collection_id_idx ON pgstac.items_search_p2000w15 USING btree (collection_id);

CREATE INDEX items_search_p2000w15_datetime_id_idx ON pgstac.items_search_p2000w15 USING btree (datetime, id);

CREATE INDEX items_search_p2000w15_geometry_idx ON pgstac.items_search_p2000w15 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w15_pkey ON pgstac.items_search_p2000w15 USING btree (id);

CREATE INDEX items_search_p2000w15_properties_idx ON pgstac.items_search_p2000w15 USING gin (properties);

CREATE INDEX items_search_p2000w16_collection_id_idx ON pgstac.items_search_p2000w16 USING btree (collection_id);

CREATE INDEX items_search_p2000w16_datetime_id_idx ON pgstac.items_search_p2000w16 USING btree (datetime, id);

CREATE INDEX items_search_p2000w16_geometry_idx ON pgstac.items_search_p2000w16 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w16_pkey ON pgstac.items_search_p2000w16 USING btree (id);

CREATE INDEX items_search_p2000w16_properties_idx ON pgstac.items_search_p2000w16 USING gin (properties);

CREATE INDEX items_search_p2000w17_collection_id_idx ON pgstac.items_search_p2000w17 USING btree (collection_id);

CREATE INDEX items_search_p2000w17_datetime_id_idx ON pgstac.items_search_p2000w17 USING btree (datetime, id);

CREATE INDEX items_search_p2000w17_geometry_idx ON pgstac.items_search_p2000w17 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w17_pkey ON pgstac.items_search_p2000w17 USING btree (id);

CREATE INDEX items_search_p2000w17_properties_idx ON pgstac.items_search_p2000w17 USING gin (properties);

CREATE INDEX items_search_p2000w18_collection_id_idx ON pgstac.items_search_p2000w18 USING btree (collection_id);

CREATE INDEX items_search_p2000w18_datetime_id_idx ON pgstac.items_search_p2000w18 USING btree (datetime, id);

CREATE INDEX items_search_p2000w18_geometry_idx ON pgstac.items_search_p2000w18 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w18_pkey ON pgstac.items_search_p2000w18 USING btree (id);

CREATE INDEX items_search_p2000w18_properties_idx ON pgstac.items_search_p2000w18 USING gin (properties);

CREATE INDEX items_search_p2000w19_collection_id_idx ON pgstac.items_search_p2000w19 USING btree (collection_id);

CREATE INDEX items_search_p2000w19_datetime_id_idx ON pgstac.items_search_p2000w19 USING btree (datetime, id);

CREATE INDEX items_search_p2000w19_geometry_idx ON pgstac.items_search_p2000w19 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w19_pkey ON pgstac.items_search_p2000w19 USING btree (id);

CREATE INDEX items_search_p2000w19_properties_idx ON pgstac.items_search_p2000w19 USING gin (properties);

CREATE INDEX items_search_p2000w20_collection_id_idx ON pgstac.items_search_p2000w20 USING btree (collection_id);

CREATE INDEX items_search_p2000w20_datetime_id_idx ON pgstac.items_search_p2000w20 USING btree (datetime, id);

CREATE INDEX items_search_p2000w20_geometry_idx ON pgstac.items_search_p2000w20 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w20_pkey ON pgstac.items_search_p2000w20 USING btree (id);

CREATE INDEX items_search_p2000w20_properties_idx ON pgstac.items_search_p2000w20 USING gin (properties);

CREATE INDEX items_search_p2000w21_collection_id_idx ON pgstac.items_search_p2000w21 USING btree (collection_id);

CREATE INDEX items_search_p2000w21_datetime_id_idx ON pgstac.items_search_p2000w21 USING btree (datetime, id);

CREATE INDEX items_search_p2000w21_geometry_idx ON pgstac.items_search_p2000w21 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w21_pkey ON pgstac.items_search_p2000w21 USING btree (id);

CREATE INDEX items_search_p2000w21_properties_idx ON pgstac.items_search_p2000w21 USING gin (properties);

CREATE INDEX items_search_p2000w22_collection_id_idx ON pgstac.items_search_p2000w22 USING btree (collection_id);

CREATE INDEX items_search_p2000w22_datetime_id_idx ON pgstac.items_search_p2000w22 USING btree (datetime, id);

CREATE INDEX items_search_p2000w22_geometry_idx ON pgstac.items_search_p2000w22 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w22_pkey ON pgstac.items_search_p2000w22 USING btree (id);

CREATE INDEX items_search_p2000w22_properties_idx ON pgstac.items_search_p2000w22 USING gin (properties);

CREATE INDEX items_search_p2000w23_collection_id_idx ON pgstac.items_search_p2000w23 USING btree (collection_id);

CREATE INDEX items_search_p2000w23_datetime_id_idx ON pgstac.items_search_p2000w23 USING btree (datetime, id);

CREATE INDEX items_search_p2000w23_geometry_idx ON pgstac.items_search_p2000w23 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w23_pkey ON pgstac.items_search_p2000w23 USING btree (id);

CREATE INDEX items_search_p2000w23_properties_idx ON pgstac.items_search_p2000w23 USING gin (properties);

CREATE INDEX items_search_p2000w24_collection_id_idx ON pgstac.items_search_p2000w24 USING btree (collection_id);

CREATE INDEX items_search_p2000w24_datetime_id_idx ON pgstac.items_search_p2000w24 USING btree (datetime, id);

CREATE INDEX items_search_p2000w24_geometry_idx ON pgstac.items_search_p2000w24 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w24_pkey ON pgstac.items_search_p2000w24 USING btree (id);

CREATE INDEX items_search_p2000w24_properties_idx ON pgstac.items_search_p2000w24 USING gin (properties);

CREATE INDEX items_search_p2000w25_collection_id_idx ON pgstac.items_search_p2000w25 USING btree (collection_id);

CREATE INDEX items_search_p2000w25_datetime_id_idx ON pgstac.items_search_p2000w25 USING btree (datetime, id);

CREATE INDEX items_search_p2000w25_geometry_idx ON pgstac.items_search_p2000w25 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w25_pkey ON pgstac.items_search_p2000w25 USING btree (id);

CREATE INDEX items_search_p2000w25_properties_idx ON pgstac.items_search_p2000w25 USING gin (properties);

CREATE INDEX items_search_p2000w26_collection_id_idx ON pgstac.items_search_p2000w26 USING btree (collection_id);

CREATE INDEX items_search_p2000w26_datetime_id_idx ON pgstac.items_search_p2000w26 USING btree (datetime, id);

CREATE INDEX items_search_p2000w26_geometry_idx ON pgstac.items_search_p2000w26 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w26_pkey ON pgstac.items_search_p2000w26 USING btree (id);

CREATE INDEX items_search_p2000w26_properties_idx ON pgstac.items_search_p2000w26 USING gin (properties);

CREATE INDEX items_search_p2000w27_collection_id_idx ON pgstac.items_search_p2000w27 USING btree (collection_id);

CREATE INDEX items_search_p2000w27_datetime_id_idx ON pgstac.items_search_p2000w27 USING btree (datetime, id);

CREATE INDEX items_search_p2000w27_geometry_idx ON pgstac.items_search_p2000w27 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w27_pkey ON pgstac.items_search_p2000w27 USING btree (id);

CREATE INDEX items_search_p2000w27_properties_idx ON pgstac.items_search_p2000w27 USING gin (properties);

CREATE INDEX items_search_p2000w28_collection_id_idx ON pgstac.items_search_p2000w28 USING btree (collection_id);

CREATE INDEX items_search_p2000w28_datetime_id_idx ON pgstac.items_search_p2000w28 USING btree (datetime, id);

CREATE INDEX items_search_p2000w28_geometry_idx ON pgstac.items_search_p2000w28 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w28_pkey ON pgstac.items_search_p2000w28 USING btree (id);

CREATE INDEX items_search_p2000w28_properties_idx ON pgstac.items_search_p2000w28 USING gin (properties);

CREATE INDEX items_search_p2000w29_collection_id_idx ON pgstac.items_search_p2000w29 USING btree (collection_id);

CREATE INDEX items_search_p2000w29_datetime_id_idx ON pgstac.items_search_p2000w29 USING btree (datetime, id);

CREATE INDEX items_search_p2000w29_geometry_idx ON pgstac.items_search_p2000w29 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w29_pkey ON pgstac.items_search_p2000w29 USING btree (id);

CREATE INDEX items_search_p2000w29_properties_idx ON pgstac.items_search_p2000w29 USING gin (properties);

CREATE INDEX items_search_p2000w30_collection_id_idx ON pgstac.items_search_p2000w30 USING btree (collection_id);

CREATE INDEX items_search_p2000w30_datetime_id_idx ON pgstac.items_search_p2000w30 USING btree (datetime, id);

CREATE INDEX items_search_p2000w30_geometry_idx ON pgstac.items_search_p2000w30 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w30_pkey ON pgstac.items_search_p2000w30 USING btree (id);

CREATE INDEX items_search_p2000w30_properties_idx ON pgstac.items_search_p2000w30 USING gin (properties);

CREATE INDEX items_search_p2000w31_collection_id_idx ON pgstac.items_search_p2000w31 USING btree (collection_id);

CREATE INDEX items_search_p2000w31_datetime_id_idx ON pgstac.items_search_p2000w31 USING btree (datetime, id);

CREATE INDEX items_search_p2000w31_geometry_idx ON pgstac.items_search_p2000w31 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w31_pkey ON pgstac.items_search_p2000w31 USING btree (id);

CREATE INDEX items_search_p2000w31_properties_idx ON pgstac.items_search_p2000w31 USING gin (properties);

CREATE INDEX items_search_p2000w32_collection_id_idx ON pgstac.items_search_p2000w32 USING btree (collection_id);

CREATE INDEX items_search_p2000w32_datetime_id_idx ON pgstac.items_search_p2000w32 USING btree (datetime, id);

CREATE INDEX items_search_p2000w32_geometry_idx ON pgstac.items_search_p2000w32 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w32_pkey ON pgstac.items_search_p2000w32 USING btree (id);

CREATE INDEX items_search_p2000w32_properties_idx ON pgstac.items_search_p2000w32 USING gin (properties);

CREATE INDEX items_search_p2000w33_collection_id_idx ON pgstac.items_search_p2000w33 USING btree (collection_id);

CREATE INDEX items_search_p2000w33_datetime_id_idx ON pgstac.items_search_p2000w33 USING btree (datetime, id);

CREATE INDEX items_search_p2000w33_geometry_idx ON pgstac.items_search_p2000w33 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w33_pkey ON pgstac.items_search_p2000w33 USING btree (id);

CREATE INDEX items_search_p2000w33_properties_idx ON pgstac.items_search_p2000w33 USING gin (properties);

CREATE INDEX items_search_p2000w34_collection_id_idx ON pgstac.items_search_p2000w34 USING btree (collection_id);

CREATE INDEX items_search_p2000w34_datetime_id_idx ON pgstac.items_search_p2000w34 USING btree (datetime, id);

CREATE INDEX items_search_p2000w34_geometry_idx ON pgstac.items_search_p2000w34 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w34_pkey ON pgstac.items_search_p2000w34 USING btree (id);

CREATE INDEX items_search_p2000w34_properties_idx ON pgstac.items_search_p2000w34 USING gin (properties);

CREATE INDEX items_search_p2000w35_collection_id_idx ON pgstac.items_search_p2000w35 USING btree (collection_id);

CREATE INDEX items_search_p2000w35_datetime_id_idx ON pgstac.items_search_p2000w35 USING btree (datetime, id);

CREATE INDEX items_search_p2000w35_geometry_idx ON pgstac.items_search_p2000w35 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w35_pkey ON pgstac.items_search_p2000w35 USING btree (id);

CREATE INDEX items_search_p2000w35_properties_idx ON pgstac.items_search_p2000w35 USING gin (properties);

CREATE INDEX items_search_p2000w36_collection_id_idx ON pgstac.items_search_p2000w36 USING btree (collection_id);

CREATE INDEX items_search_p2000w36_datetime_id_idx ON pgstac.items_search_p2000w36 USING btree (datetime, id);

CREATE INDEX items_search_p2000w36_geometry_idx ON pgstac.items_search_p2000w36 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w36_pkey ON pgstac.items_search_p2000w36 USING btree (id);

CREATE INDEX items_search_p2000w36_properties_idx ON pgstac.items_search_p2000w36 USING gin (properties);

CREATE INDEX items_search_p2000w37_collection_id_idx ON pgstac.items_search_p2000w37 USING btree (collection_id);

CREATE INDEX items_search_p2000w37_datetime_id_idx ON pgstac.items_search_p2000w37 USING btree (datetime, id);

CREATE INDEX items_search_p2000w37_geometry_idx ON pgstac.items_search_p2000w37 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w37_pkey ON pgstac.items_search_p2000w37 USING btree (id);

CREATE INDEX items_search_p2000w37_properties_idx ON pgstac.items_search_p2000w37 USING gin (properties);

CREATE INDEX items_search_p2000w38_collection_id_idx ON pgstac.items_search_p2000w38 USING btree (collection_id);

CREATE INDEX items_search_p2000w38_datetime_id_idx ON pgstac.items_search_p2000w38 USING btree (datetime, id);

CREATE INDEX items_search_p2000w38_geometry_idx ON pgstac.items_search_p2000w38 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w38_pkey ON pgstac.items_search_p2000w38 USING btree (id);

CREATE INDEX items_search_p2000w38_properties_idx ON pgstac.items_search_p2000w38 USING gin (properties);

CREATE INDEX items_search_p2000w39_collection_id_idx ON pgstac.items_search_p2000w39 USING btree (collection_id);

CREATE INDEX items_search_p2000w39_datetime_id_idx ON pgstac.items_search_p2000w39 USING btree (datetime, id);

CREATE INDEX items_search_p2000w39_geometry_idx ON pgstac.items_search_p2000w39 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w39_pkey ON pgstac.items_search_p2000w39 USING btree (id);

CREATE INDEX items_search_p2000w39_properties_idx ON pgstac.items_search_p2000w39 USING gin (properties);

CREATE INDEX items_search_p2000w40_collection_id_idx ON pgstac.items_search_p2000w40 USING btree (collection_id);

CREATE INDEX items_search_p2000w40_datetime_id_idx ON pgstac.items_search_p2000w40 USING btree (datetime, id);

CREATE INDEX items_search_p2000w40_geometry_idx ON pgstac.items_search_p2000w40 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w40_pkey ON pgstac.items_search_p2000w40 USING btree (id);

CREATE INDEX items_search_p2000w40_properties_idx ON pgstac.items_search_p2000w40 USING gin (properties);

CREATE INDEX items_search_p2000w41_collection_id_idx ON pgstac.items_search_p2000w41 USING btree (collection_id);

CREATE INDEX items_search_p2000w41_datetime_id_idx ON pgstac.items_search_p2000w41 USING btree (datetime, id);

CREATE INDEX items_search_p2000w41_geometry_idx ON pgstac.items_search_p2000w41 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w41_pkey ON pgstac.items_search_p2000w41 USING btree (id);

CREATE INDEX items_search_p2000w41_properties_idx ON pgstac.items_search_p2000w41 USING gin (properties);

CREATE INDEX items_search_p2000w42_collection_id_idx ON pgstac.items_search_p2000w42 USING btree (collection_id);

CREATE INDEX items_search_p2000w42_datetime_id_idx ON pgstac.items_search_p2000w42 USING btree (datetime, id);

CREATE INDEX items_search_p2000w42_geometry_idx ON pgstac.items_search_p2000w42 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w42_pkey ON pgstac.items_search_p2000w42 USING btree (id);

CREATE INDEX items_search_p2000w42_properties_idx ON pgstac.items_search_p2000w42 USING gin (properties);

CREATE INDEX items_search_p2000w43_collection_id_idx ON pgstac.items_search_p2000w43 USING btree (collection_id);

CREATE INDEX items_search_p2000w43_datetime_id_idx ON pgstac.items_search_p2000w43 USING btree (datetime, id);

CREATE INDEX items_search_p2000w43_geometry_idx ON pgstac.items_search_p2000w43 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w43_pkey ON pgstac.items_search_p2000w43 USING btree (id);

CREATE INDEX items_search_p2000w43_properties_idx ON pgstac.items_search_p2000w43 USING gin (properties);

CREATE INDEX items_search_p2000w44_collection_id_idx ON pgstac.items_search_p2000w44 USING btree (collection_id);

CREATE INDEX items_search_p2000w44_datetime_id_idx ON pgstac.items_search_p2000w44 USING btree (datetime, id);

CREATE INDEX items_search_p2000w44_geometry_idx ON pgstac.items_search_p2000w44 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w44_pkey ON pgstac.items_search_p2000w44 USING btree (id);

CREATE INDEX items_search_p2000w44_properties_idx ON pgstac.items_search_p2000w44 USING gin (properties);

CREATE INDEX items_search_p2000w45_collection_id_idx ON pgstac.items_search_p2000w45 USING btree (collection_id);

CREATE INDEX items_search_p2000w45_datetime_id_idx ON pgstac.items_search_p2000w45 USING btree (datetime, id);

CREATE INDEX items_search_p2000w45_geometry_idx ON pgstac.items_search_p2000w45 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w45_pkey ON pgstac.items_search_p2000w45 USING btree (id);

CREATE INDEX items_search_p2000w45_properties_idx ON pgstac.items_search_p2000w45 USING gin (properties);

CREATE INDEX items_search_p2000w46_collection_id_idx ON pgstac.items_search_p2000w46 USING btree (collection_id);

CREATE INDEX items_search_p2000w46_datetime_id_idx ON pgstac.items_search_p2000w46 USING btree (datetime, id);

CREATE INDEX items_search_p2000w46_geometry_idx ON pgstac.items_search_p2000w46 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w46_pkey ON pgstac.items_search_p2000w46 USING btree (id);

CREATE INDEX items_search_p2000w46_properties_idx ON pgstac.items_search_p2000w46 USING gin (properties);

CREATE INDEX items_search_p2000w47_collection_id_idx ON pgstac.items_search_p2000w47 USING btree (collection_id);

CREATE INDEX items_search_p2000w47_datetime_id_idx ON pgstac.items_search_p2000w47 USING btree (datetime, id);

CREATE INDEX items_search_p2000w47_geometry_idx ON pgstac.items_search_p2000w47 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w47_pkey ON pgstac.items_search_p2000w47 USING btree (id);

CREATE INDEX items_search_p2000w47_properties_idx ON pgstac.items_search_p2000w47 USING gin (properties);

CREATE INDEX items_search_p2000w48_collection_id_idx ON pgstac.items_search_p2000w48 USING btree (collection_id);

CREATE INDEX items_search_p2000w48_datetime_id_idx ON pgstac.items_search_p2000w48 USING btree (datetime, id);

CREATE INDEX items_search_p2000w48_geometry_idx ON pgstac.items_search_p2000w48 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w48_pkey ON pgstac.items_search_p2000w48 USING btree (id);

CREATE INDEX items_search_p2000w48_properties_idx ON pgstac.items_search_p2000w48 USING gin (properties);

CREATE INDEX items_search_p2000w49_collection_id_idx ON pgstac.items_search_p2000w49 USING btree (collection_id);

CREATE INDEX items_search_p2000w49_datetime_id_idx ON pgstac.items_search_p2000w49 USING btree (datetime, id);

CREATE INDEX items_search_p2000w49_geometry_idx ON pgstac.items_search_p2000w49 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w49_pkey ON pgstac.items_search_p2000w49 USING btree (id);

CREATE INDEX items_search_p2000w49_properties_idx ON pgstac.items_search_p2000w49 USING gin (properties);

CREATE INDEX items_search_p2000w50_collection_id_idx ON pgstac.items_search_p2000w50 USING btree (collection_id);

CREATE INDEX items_search_p2000w50_datetime_id_idx ON pgstac.items_search_p2000w50 USING btree (datetime, id);

CREATE INDEX items_search_p2000w50_geometry_idx ON pgstac.items_search_p2000w50 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w50_pkey ON pgstac.items_search_p2000w50 USING btree (id);

CREATE INDEX items_search_p2000w50_properties_idx ON pgstac.items_search_p2000w50 USING gin (properties);

CREATE INDEX items_search_p2000w51_collection_id_idx ON pgstac.items_search_p2000w51 USING btree (collection_id);

CREATE INDEX items_search_p2000w51_datetime_id_idx ON pgstac.items_search_p2000w51 USING btree (datetime, id);

CREATE INDEX items_search_p2000w51_geometry_idx ON pgstac.items_search_p2000w51 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w51_pkey ON pgstac.items_search_p2000w51 USING btree (id);

CREATE INDEX items_search_p2000w51_properties_idx ON pgstac.items_search_p2000w51 USING gin (properties);

CREATE INDEX items_search_p2000w52_collection_id_idx ON pgstac.items_search_p2000w52 USING btree (collection_id);

CREATE INDEX items_search_p2000w52_datetime_id_idx ON pgstac.items_search_p2000w52 USING btree (datetime, id);

CREATE INDEX items_search_p2000w52_geometry_idx ON pgstac.items_search_p2000w52 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2000w52_pkey ON pgstac.items_search_p2000w52 USING btree (id);

CREATE INDEX items_search_p2000w52_properties_idx ON pgstac.items_search_p2000w52 USING gin (properties);

CREATE INDEX items_search_p2001w01_collection_id_idx ON pgstac.items_search_p2001w01 USING btree (collection_id);

CREATE INDEX items_search_p2001w01_datetime_id_idx ON pgstac.items_search_p2001w01 USING btree (datetime, id);

CREATE INDEX items_search_p2001w01_geometry_idx ON pgstac.items_search_p2001w01 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w01_pkey ON pgstac.items_search_p2001w01 USING btree (id);

CREATE INDEX items_search_p2001w01_properties_idx ON pgstac.items_search_p2001w01 USING gin (properties);

CREATE INDEX items_search_p2001w02_collection_id_idx ON pgstac.items_search_p2001w02 USING btree (collection_id);

CREATE INDEX items_search_p2001w02_datetime_id_idx ON pgstac.items_search_p2001w02 USING btree (datetime, id);

CREATE INDEX items_search_p2001w02_geometry_idx ON pgstac.items_search_p2001w02 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w02_pkey ON pgstac.items_search_p2001w02 USING btree (id);

CREATE INDEX items_search_p2001w02_properties_idx ON pgstac.items_search_p2001w02 USING gin (properties);

CREATE INDEX items_search_p2001w03_collection_id_idx ON pgstac.items_search_p2001w03 USING btree (collection_id);

CREATE INDEX items_search_p2001w03_datetime_id_idx ON pgstac.items_search_p2001w03 USING btree (datetime, id);

CREATE INDEX items_search_p2001w03_geometry_idx ON pgstac.items_search_p2001w03 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w03_pkey ON pgstac.items_search_p2001w03 USING btree (id);

CREATE INDEX items_search_p2001w03_properties_idx ON pgstac.items_search_p2001w03 USING gin (properties);

CREATE INDEX items_search_p2001w04_collection_id_idx ON pgstac.items_search_p2001w04 USING btree (collection_id);

CREATE INDEX items_search_p2001w04_datetime_id_idx ON pgstac.items_search_p2001w04 USING btree (datetime, id);

CREATE INDEX items_search_p2001w04_geometry_idx ON pgstac.items_search_p2001w04 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w04_pkey ON pgstac.items_search_p2001w04 USING btree (id);

CREATE INDEX items_search_p2001w04_properties_idx ON pgstac.items_search_p2001w04 USING gin (properties);

CREATE INDEX items_search_p2001w05_collection_id_idx ON pgstac.items_search_p2001w05 USING btree (collection_id);

CREATE INDEX items_search_p2001w05_datetime_id_idx ON pgstac.items_search_p2001w05 USING btree (datetime, id);

CREATE INDEX items_search_p2001w05_geometry_idx ON pgstac.items_search_p2001w05 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w05_pkey ON pgstac.items_search_p2001w05 USING btree (id);

CREATE INDEX items_search_p2001w05_properties_idx ON pgstac.items_search_p2001w05 USING gin (properties);

CREATE INDEX items_search_p2001w06_collection_id_idx ON pgstac.items_search_p2001w06 USING btree (collection_id);

CREATE INDEX items_search_p2001w06_datetime_id_idx ON pgstac.items_search_p2001w06 USING btree (datetime, id);

CREATE INDEX items_search_p2001w06_geometry_idx ON pgstac.items_search_p2001w06 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w06_pkey ON pgstac.items_search_p2001w06 USING btree (id);

CREATE INDEX items_search_p2001w06_properties_idx ON pgstac.items_search_p2001w06 USING gin (properties);

CREATE INDEX items_search_p2001w07_collection_id_idx ON pgstac.items_search_p2001w07 USING btree (collection_id);

CREATE INDEX items_search_p2001w07_datetime_id_idx ON pgstac.items_search_p2001w07 USING btree (datetime, id);

CREATE INDEX items_search_p2001w07_geometry_idx ON pgstac.items_search_p2001w07 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w07_pkey ON pgstac.items_search_p2001w07 USING btree (id);

CREATE INDEX items_search_p2001w07_properties_idx ON pgstac.items_search_p2001w07 USING gin (properties);

CREATE INDEX items_search_p2001w08_collection_id_idx ON pgstac.items_search_p2001w08 USING btree (collection_id);

CREATE INDEX items_search_p2001w08_datetime_id_idx ON pgstac.items_search_p2001w08 USING btree (datetime, id);

CREATE INDEX items_search_p2001w08_geometry_idx ON pgstac.items_search_p2001w08 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w08_pkey ON pgstac.items_search_p2001w08 USING btree (id);

CREATE INDEX items_search_p2001w08_properties_idx ON pgstac.items_search_p2001w08 USING gin (properties);

CREATE INDEX items_search_p2001w09_collection_id_idx ON pgstac.items_search_p2001w09 USING btree (collection_id);

CREATE INDEX items_search_p2001w09_datetime_id_idx ON pgstac.items_search_p2001w09 USING btree (datetime, id);

CREATE INDEX items_search_p2001w09_geometry_idx ON pgstac.items_search_p2001w09 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w09_pkey ON pgstac.items_search_p2001w09 USING btree (id);

CREATE INDEX items_search_p2001w09_properties_idx ON pgstac.items_search_p2001w09 USING gin (properties);

CREATE INDEX items_search_p2001w10_collection_id_idx ON pgstac.items_search_p2001w10 USING btree (collection_id);

CREATE INDEX items_search_p2001w10_datetime_id_idx ON pgstac.items_search_p2001w10 USING btree (datetime, id);

CREATE INDEX items_search_p2001w10_geometry_idx ON pgstac.items_search_p2001w10 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w10_pkey ON pgstac.items_search_p2001w10 USING btree (id);

CREATE INDEX items_search_p2001w10_properties_idx ON pgstac.items_search_p2001w10 USING gin (properties);

CREATE INDEX items_search_p2001w11_collection_id_idx ON pgstac.items_search_p2001w11 USING btree (collection_id);

CREATE INDEX items_search_p2001w11_datetime_id_idx ON pgstac.items_search_p2001w11 USING btree (datetime, id);

CREATE INDEX items_search_p2001w11_geometry_idx ON pgstac.items_search_p2001w11 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w11_pkey ON pgstac.items_search_p2001w11 USING btree (id);

CREATE INDEX items_search_p2001w11_properties_idx ON pgstac.items_search_p2001w11 USING gin (properties);

CREATE INDEX items_search_p2001w12_collection_id_idx ON pgstac.items_search_p2001w12 USING btree (collection_id);

CREATE INDEX items_search_p2001w12_datetime_id_idx ON pgstac.items_search_p2001w12 USING btree (datetime, id);

CREATE INDEX items_search_p2001w12_geometry_idx ON pgstac.items_search_p2001w12 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w12_pkey ON pgstac.items_search_p2001w12 USING btree (id);

CREATE INDEX items_search_p2001w12_properties_idx ON pgstac.items_search_p2001w12 USING gin (properties);

CREATE INDEX items_search_p2001w13_collection_id_idx ON pgstac.items_search_p2001w13 USING btree (collection_id);

CREATE INDEX items_search_p2001w13_datetime_id_idx ON pgstac.items_search_p2001w13 USING btree (datetime, id);

CREATE INDEX items_search_p2001w13_geometry_idx ON pgstac.items_search_p2001w13 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w13_pkey ON pgstac.items_search_p2001w13 USING btree (id);

CREATE INDEX items_search_p2001w13_properties_idx ON pgstac.items_search_p2001w13 USING gin (properties);

CREATE INDEX items_search_p2001w14_collection_id_idx ON pgstac.items_search_p2001w14 USING btree (collection_id);

CREATE INDEX items_search_p2001w14_datetime_id_idx ON pgstac.items_search_p2001w14 USING btree (datetime, id);

CREATE INDEX items_search_p2001w14_geometry_idx ON pgstac.items_search_p2001w14 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w14_pkey ON pgstac.items_search_p2001w14 USING btree (id);

CREATE INDEX items_search_p2001w14_properties_idx ON pgstac.items_search_p2001w14 USING gin (properties);

CREATE INDEX items_search_p2001w15_collection_id_idx ON pgstac.items_search_p2001w15 USING btree (collection_id);

CREATE INDEX items_search_p2001w15_datetime_id_idx ON pgstac.items_search_p2001w15 USING btree (datetime, id);

CREATE INDEX items_search_p2001w15_geometry_idx ON pgstac.items_search_p2001w15 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w15_pkey ON pgstac.items_search_p2001w15 USING btree (id);

CREATE INDEX items_search_p2001w15_properties_idx ON pgstac.items_search_p2001w15 USING gin (properties);

CREATE INDEX items_search_p2001w16_collection_id_idx ON pgstac.items_search_p2001w16 USING btree (collection_id);

CREATE INDEX items_search_p2001w16_datetime_id_idx ON pgstac.items_search_p2001w16 USING btree (datetime, id);

CREATE INDEX items_search_p2001w16_geometry_idx ON pgstac.items_search_p2001w16 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w16_pkey ON pgstac.items_search_p2001w16 USING btree (id);

CREATE INDEX items_search_p2001w16_properties_idx ON pgstac.items_search_p2001w16 USING gin (properties);

CREATE INDEX items_search_p2001w17_collection_id_idx ON pgstac.items_search_p2001w17 USING btree (collection_id);

CREATE INDEX items_search_p2001w17_datetime_id_idx ON pgstac.items_search_p2001w17 USING btree (datetime, id);

CREATE INDEX items_search_p2001w17_geometry_idx ON pgstac.items_search_p2001w17 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w17_pkey ON pgstac.items_search_p2001w17 USING btree (id);

CREATE INDEX items_search_p2001w17_properties_idx ON pgstac.items_search_p2001w17 USING gin (properties);

CREATE INDEX items_search_p2001w18_collection_id_idx ON pgstac.items_search_p2001w18 USING btree (collection_id);

CREATE INDEX items_search_p2001w18_datetime_id_idx ON pgstac.items_search_p2001w18 USING btree (datetime, id);

CREATE INDEX items_search_p2001w18_geometry_idx ON pgstac.items_search_p2001w18 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w18_pkey ON pgstac.items_search_p2001w18 USING btree (id);

CREATE INDEX items_search_p2001w18_properties_idx ON pgstac.items_search_p2001w18 USING gin (properties);

CREATE INDEX items_search_p2001w19_collection_id_idx ON pgstac.items_search_p2001w19 USING btree (collection_id);

CREATE INDEX items_search_p2001w19_datetime_id_idx ON pgstac.items_search_p2001w19 USING btree (datetime, id);

CREATE INDEX items_search_p2001w19_geometry_idx ON pgstac.items_search_p2001w19 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w19_pkey ON pgstac.items_search_p2001w19 USING btree (id);

CREATE INDEX items_search_p2001w19_properties_idx ON pgstac.items_search_p2001w19 USING gin (properties);

CREATE INDEX items_search_p2001w20_collection_id_idx ON pgstac.items_search_p2001w20 USING btree (collection_id);

CREATE INDEX items_search_p2001w20_datetime_id_idx ON pgstac.items_search_p2001w20 USING btree (datetime, id);

CREATE INDEX items_search_p2001w20_geometry_idx ON pgstac.items_search_p2001w20 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w20_pkey ON pgstac.items_search_p2001w20 USING btree (id);

CREATE INDEX items_search_p2001w20_properties_idx ON pgstac.items_search_p2001w20 USING gin (properties);

CREATE INDEX items_search_p2001w21_collection_id_idx ON pgstac.items_search_p2001w21 USING btree (collection_id);

CREATE INDEX items_search_p2001w21_datetime_id_idx ON pgstac.items_search_p2001w21 USING btree (datetime, id);

CREATE INDEX items_search_p2001w21_geometry_idx ON pgstac.items_search_p2001w21 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w21_pkey ON pgstac.items_search_p2001w21 USING btree (id);

CREATE INDEX items_search_p2001w21_properties_idx ON pgstac.items_search_p2001w21 USING gin (properties);

CREATE INDEX items_search_p2001w22_collection_id_idx ON pgstac.items_search_p2001w22 USING btree (collection_id);

CREATE INDEX items_search_p2001w22_datetime_id_idx ON pgstac.items_search_p2001w22 USING btree (datetime, id);

CREATE INDEX items_search_p2001w22_geometry_idx ON pgstac.items_search_p2001w22 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w22_pkey ON pgstac.items_search_p2001w22 USING btree (id);

CREATE INDEX items_search_p2001w22_properties_idx ON pgstac.items_search_p2001w22 USING gin (properties);

CREATE INDEX items_search_p2001w23_collection_id_idx ON pgstac.items_search_p2001w23 USING btree (collection_id);

CREATE INDEX items_search_p2001w23_datetime_id_idx ON pgstac.items_search_p2001w23 USING btree (datetime, id);

CREATE INDEX items_search_p2001w23_geometry_idx ON pgstac.items_search_p2001w23 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w23_pkey ON pgstac.items_search_p2001w23 USING btree (id);

CREATE INDEX items_search_p2001w23_properties_idx ON pgstac.items_search_p2001w23 USING gin (properties);

CREATE INDEX items_search_p2001w24_collection_id_idx ON pgstac.items_search_p2001w24 USING btree (collection_id);

CREATE INDEX items_search_p2001w24_datetime_id_idx ON pgstac.items_search_p2001w24 USING btree (datetime, id);

CREATE INDEX items_search_p2001w24_geometry_idx ON pgstac.items_search_p2001w24 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w24_pkey ON pgstac.items_search_p2001w24 USING btree (id);

CREATE INDEX items_search_p2001w24_properties_idx ON pgstac.items_search_p2001w24 USING gin (properties);

CREATE INDEX items_search_p2001w25_collection_id_idx ON pgstac.items_search_p2001w25 USING btree (collection_id);

CREATE INDEX items_search_p2001w25_datetime_id_idx ON pgstac.items_search_p2001w25 USING btree (datetime, id);

CREATE INDEX items_search_p2001w25_geometry_idx ON pgstac.items_search_p2001w25 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w25_pkey ON pgstac.items_search_p2001w25 USING btree (id);

CREATE INDEX items_search_p2001w25_properties_idx ON pgstac.items_search_p2001w25 USING gin (properties);

CREATE INDEX items_search_p2001w26_collection_id_idx ON pgstac.items_search_p2001w26 USING btree (collection_id);

CREATE INDEX items_search_p2001w26_datetime_id_idx ON pgstac.items_search_p2001w26 USING btree (datetime, id);

CREATE INDEX items_search_p2001w26_geometry_idx ON pgstac.items_search_p2001w26 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w26_pkey ON pgstac.items_search_p2001w26 USING btree (id);

CREATE INDEX items_search_p2001w26_properties_idx ON pgstac.items_search_p2001w26 USING gin (properties);

CREATE INDEX items_search_p2001w27_collection_id_idx ON pgstac.items_search_p2001w27 USING btree (collection_id);

CREATE INDEX items_search_p2001w27_datetime_id_idx ON pgstac.items_search_p2001w27 USING btree (datetime, id);

CREATE INDEX items_search_p2001w27_geometry_idx ON pgstac.items_search_p2001w27 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w27_pkey ON pgstac.items_search_p2001w27 USING btree (id);

CREATE INDEX items_search_p2001w27_properties_idx ON pgstac.items_search_p2001w27 USING gin (properties);

CREATE INDEX items_search_p2001w28_collection_id_idx ON pgstac.items_search_p2001w28 USING btree (collection_id);

CREATE INDEX items_search_p2001w28_datetime_id_idx ON pgstac.items_search_p2001w28 USING btree (datetime, id);

CREATE INDEX items_search_p2001w28_geometry_idx ON pgstac.items_search_p2001w28 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w28_pkey ON pgstac.items_search_p2001w28 USING btree (id);

CREATE INDEX items_search_p2001w28_properties_idx ON pgstac.items_search_p2001w28 USING gin (properties);

CREATE INDEX items_search_p2001w29_collection_id_idx ON pgstac.items_search_p2001w29 USING btree (collection_id);

CREATE INDEX items_search_p2001w29_datetime_id_idx ON pgstac.items_search_p2001w29 USING btree (datetime, id);

CREATE INDEX items_search_p2001w29_geometry_idx ON pgstac.items_search_p2001w29 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w29_pkey ON pgstac.items_search_p2001w29 USING btree (id);

CREATE INDEX items_search_p2001w29_properties_idx ON pgstac.items_search_p2001w29 USING gin (properties);

CREATE INDEX items_search_p2001w30_collection_id_idx ON pgstac.items_search_p2001w30 USING btree (collection_id);

CREATE INDEX items_search_p2001w30_datetime_id_idx ON pgstac.items_search_p2001w30 USING btree (datetime, id);

CREATE INDEX items_search_p2001w30_geometry_idx ON pgstac.items_search_p2001w30 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w30_pkey ON pgstac.items_search_p2001w30 USING btree (id);

CREATE INDEX items_search_p2001w30_properties_idx ON pgstac.items_search_p2001w30 USING gin (properties);

CREATE INDEX items_search_p2001w31_collection_id_idx ON pgstac.items_search_p2001w31 USING btree (collection_id);

CREATE INDEX items_search_p2001w31_datetime_id_idx ON pgstac.items_search_p2001w31 USING btree (datetime, id);

CREATE INDEX items_search_p2001w31_geometry_idx ON pgstac.items_search_p2001w31 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w31_pkey ON pgstac.items_search_p2001w31 USING btree (id);

CREATE INDEX items_search_p2001w31_properties_idx ON pgstac.items_search_p2001w31 USING gin (properties);

CREATE INDEX items_search_p2001w32_collection_id_idx ON pgstac.items_search_p2001w32 USING btree (collection_id);

CREATE INDEX items_search_p2001w32_datetime_id_idx ON pgstac.items_search_p2001w32 USING btree (datetime, id);

CREATE INDEX items_search_p2001w32_geometry_idx ON pgstac.items_search_p2001w32 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w32_pkey ON pgstac.items_search_p2001w32 USING btree (id);

CREATE INDEX items_search_p2001w32_properties_idx ON pgstac.items_search_p2001w32 USING gin (properties);

CREATE INDEX items_search_p2001w33_collection_id_idx ON pgstac.items_search_p2001w33 USING btree (collection_id);

CREATE INDEX items_search_p2001w33_datetime_id_idx ON pgstac.items_search_p2001w33 USING btree (datetime, id);

CREATE INDEX items_search_p2001w33_geometry_idx ON pgstac.items_search_p2001w33 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w33_pkey ON pgstac.items_search_p2001w33 USING btree (id);

CREATE INDEX items_search_p2001w33_properties_idx ON pgstac.items_search_p2001w33 USING gin (properties);

CREATE INDEX items_search_p2001w34_collection_id_idx ON pgstac.items_search_p2001w34 USING btree (collection_id);

CREATE INDEX items_search_p2001w34_datetime_id_idx ON pgstac.items_search_p2001w34 USING btree (datetime, id);

CREATE INDEX items_search_p2001w34_geometry_idx ON pgstac.items_search_p2001w34 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w34_pkey ON pgstac.items_search_p2001w34 USING btree (id);

CREATE INDEX items_search_p2001w34_properties_idx ON pgstac.items_search_p2001w34 USING gin (properties);

CREATE INDEX items_search_p2001w35_collection_id_idx ON pgstac.items_search_p2001w35 USING btree (collection_id);

CREATE INDEX items_search_p2001w35_datetime_id_idx ON pgstac.items_search_p2001w35 USING btree (datetime, id);

CREATE INDEX items_search_p2001w35_geometry_idx ON pgstac.items_search_p2001w35 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w35_pkey ON pgstac.items_search_p2001w35 USING btree (id);

CREATE INDEX items_search_p2001w35_properties_idx ON pgstac.items_search_p2001w35 USING gin (properties);

CREATE INDEX items_search_p2001w36_collection_id_idx ON pgstac.items_search_p2001w36 USING btree (collection_id);

CREATE INDEX items_search_p2001w36_datetime_id_idx ON pgstac.items_search_p2001w36 USING btree (datetime, id);

CREATE INDEX items_search_p2001w36_geometry_idx ON pgstac.items_search_p2001w36 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w36_pkey ON pgstac.items_search_p2001w36 USING btree (id);

CREATE INDEX items_search_p2001w36_properties_idx ON pgstac.items_search_p2001w36 USING gin (properties);

CREATE INDEX items_search_p2001w37_collection_id_idx ON pgstac.items_search_p2001w37 USING btree (collection_id);

CREATE INDEX items_search_p2001w37_datetime_id_idx ON pgstac.items_search_p2001w37 USING btree (datetime, id);

CREATE INDEX items_search_p2001w37_geometry_idx ON pgstac.items_search_p2001w37 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w37_pkey ON pgstac.items_search_p2001w37 USING btree (id);

CREATE INDEX items_search_p2001w37_properties_idx ON pgstac.items_search_p2001w37 USING gin (properties);

CREATE INDEX items_search_p2001w38_collection_id_idx ON pgstac.items_search_p2001w38 USING btree (collection_id);

CREATE INDEX items_search_p2001w38_datetime_id_idx ON pgstac.items_search_p2001w38 USING btree (datetime, id);

CREATE INDEX items_search_p2001w38_geometry_idx ON pgstac.items_search_p2001w38 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w38_pkey ON pgstac.items_search_p2001w38 USING btree (id);

CREATE INDEX items_search_p2001w38_properties_idx ON pgstac.items_search_p2001w38 USING gin (properties);

CREATE INDEX items_search_p2001w39_collection_id_idx ON pgstac.items_search_p2001w39 USING btree (collection_id);

CREATE INDEX items_search_p2001w39_datetime_id_idx ON pgstac.items_search_p2001w39 USING btree (datetime, id);

CREATE INDEX items_search_p2001w39_geometry_idx ON pgstac.items_search_p2001w39 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w39_pkey ON pgstac.items_search_p2001w39 USING btree (id);

CREATE INDEX items_search_p2001w39_properties_idx ON pgstac.items_search_p2001w39 USING gin (properties);

CREATE INDEX items_search_p2001w40_collection_id_idx ON pgstac.items_search_p2001w40 USING btree (collection_id);

CREATE INDEX items_search_p2001w40_datetime_id_idx ON pgstac.items_search_p2001w40 USING btree (datetime, id);

CREATE INDEX items_search_p2001w40_geometry_idx ON pgstac.items_search_p2001w40 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w40_pkey ON pgstac.items_search_p2001w40 USING btree (id);

CREATE INDEX items_search_p2001w40_properties_idx ON pgstac.items_search_p2001w40 USING gin (properties);

CREATE INDEX items_search_p2001w41_collection_id_idx ON pgstac.items_search_p2001w41 USING btree (collection_id);

CREATE INDEX items_search_p2001w41_datetime_id_idx ON pgstac.items_search_p2001w41 USING btree (datetime, id);

CREATE INDEX items_search_p2001w41_geometry_idx ON pgstac.items_search_p2001w41 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w41_pkey ON pgstac.items_search_p2001w41 USING btree (id);

CREATE INDEX items_search_p2001w41_properties_idx ON pgstac.items_search_p2001w41 USING gin (properties);

CREATE INDEX items_search_p2001w42_collection_id_idx ON pgstac.items_search_p2001w42 USING btree (collection_id);

CREATE INDEX items_search_p2001w42_datetime_id_idx ON pgstac.items_search_p2001w42 USING btree (datetime, id);

CREATE INDEX items_search_p2001w42_geometry_idx ON pgstac.items_search_p2001w42 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w42_pkey ON pgstac.items_search_p2001w42 USING btree (id);

CREATE INDEX items_search_p2001w42_properties_idx ON pgstac.items_search_p2001w42 USING gin (properties);

CREATE INDEX items_search_p2001w43_collection_id_idx ON pgstac.items_search_p2001w43 USING btree (collection_id);

CREATE INDEX items_search_p2001w43_datetime_id_idx ON pgstac.items_search_p2001w43 USING btree (datetime, id);

CREATE INDEX items_search_p2001w43_geometry_idx ON pgstac.items_search_p2001w43 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w43_pkey ON pgstac.items_search_p2001w43 USING btree (id);

CREATE INDEX items_search_p2001w43_properties_idx ON pgstac.items_search_p2001w43 USING gin (properties);

CREATE INDEX items_search_p2001w44_collection_id_idx ON pgstac.items_search_p2001w44 USING btree (collection_id);

CREATE INDEX items_search_p2001w44_datetime_id_idx ON pgstac.items_search_p2001w44 USING btree (datetime, id);

CREATE INDEX items_search_p2001w44_geometry_idx ON pgstac.items_search_p2001w44 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w44_pkey ON pgstac.items_search_p2001w44 USING btree (id);

CREATE INDEX items_search_p2001w44_properties_idx ON pgstac.items_search_p2001w44 USING gin (properties);

CREATE INDEX items_search_p2001w45_collection_id_idx ON pgstac.items_search_p2001w45 USING btree (collection_id);

CREATE INDEX items_search_p2001w45_datetime_id_idx ON pgstac.items_search_p2001w45 USING btree (datetime, id);

CREATE INDEX items_search_p2001w45_geometry_idx ON pgstac.items_search_p2001w45 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w45_pkey ON pgstac.items_search_p2001w45 USING btree (id);

CREATE INDEX items_search_p2001w45_properties_idx ON pgstac.items_search_p2001w45 USING gin (properties);

CREATE INDEX items_search_p2001w46_collection_id_idx ON pgstac.items_search_p2001w46 USING btree (collection_id);

CREATE INDEX items_search_p2001w46_datetime_id_idx ON pgstac.items_search_p2001w46 USING btree (datetime, id);

CREATE INDEX items_search_p2001w46_geometry_idx ON pgstac.items_search_p2001w46 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w46_pkey ON pgstac.items_search_p2001w46 USING btree (id);

CREATE INDEX items_search_p2001w46_properties_idx ON pgstac.items_search_p2001w46 USING gin (properties);

CREATE INDEX items_search_p2001w47_collection_id_idx ON pgstac.items_search_p2001w47 USING btree (collection_id);

CREATE INDEX items_search_p2001w47_datetime_id_idx ON pgstac.items_search_p2001w47 USING btree (datetime, id);

CREATE INDEX items_search_p2001w47_geometry_idx ON pgstac.items_search_p2001w47 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w47_pkey ON pgstac.items_search_p2001w47 USING btree (id);

CREATE INDEX items_search_p2001w47_properties_idx ON pgstac.items_search_p2001w47 USING gin (properties);

CREATE INDEX items_search_p2001w48_collection_id_idx ON pgstac.items_search_p2001w48 USING btree (collection_id);

CREATE INDEX items_search_p2001w48_datetime_id_idx ON pgstac.items_search_p2001w48 USING btree (datetime, id);

CREATE INDEX items_search_p2001w48_geometry_idx ON pgstac.items_search_p2001w48 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w48_pkey ON pgstac.items_search_p2001w48 USING btree (id);

CREATE INDEX items_search_p2001w48_properties_idx ON pgstac.items_search_p2001w48 USING gin (properties);

CREATE INDEX items_search_p2001w49_collection_id_idx ON pgstac.items_search_p2001w49 USING btree (collection_id);

CREATE INDEX items_search_p2001w49_datetime_id_idx ON pgstac.items_search_p2001w49 USING btree (datetime, id);

CREATE INDEX items_search_p2001w49_geometry_idx ON pgstac.items_search_p2001w49 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w49_pkey ON pgstac.items_search_p2001w49 USING btree (id);

CREATE INDEX items_search_p2001w49_properties_idx ON pgstac.items_search_p2001w49 USING gin (properties);

CREATE INDEX items_search_p2001w50_collection_id_idx ON pgstac.items_search_p2001w50 USING btree (collection_id);

CREATE INDEX items_search_p2001w50_datetime_id_idx ON pgstac.items_search_p2001w50 USING btree (datetime, id);

CREATE INDEX items_search_p2001w50_geometry_idx ON pgstac.items_search_p2001w50 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w50_pkey ON pgstac.items_search_p2001w50 USING btree (id);

CREATE INDEX items_search_p2001w50_properties_idx ON pgstac.items_search_p2001w50 USING gin (properties);

CREATE INDEX items_search_p2001w51_collection_id_idx ON pgstac.items_search_p2001w51 USING btree (collection_id);

CREATE INDEX items_search_p2001w51_datetime_id_idx ON pgstac.items_search_p2001w51 USING btree (datetime, id);

CREATE INDEX items_search_p2001w51_geometry_idx ON pgstac.items_search_p2001w51 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w51_pkey ON pgstac.items_search_p2001w51 USING btree (id);

CREATE INDEX items_search_p2001w51_properties_idx ON pgstac.items_search_p2001w51 USING gin (properties);

CREATE INDEX items_search_p2001w52_collection_id_idx ON pgstac.items_search_p2001w52 USING btree (collection_id);

CREATE INDEX items_search_p2001w52_datetime_id_idx ON pgstac.items_search_p2001w52 USING btree (datetime, id);

CREATE INDEX items_search_p2001w52_geometry_idx ON pgstac.items_search_p2001w52 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2001w52_pkey ON pgstac.items_search_p2001w52 USING btree (id);

CREATE INDEX items_search_p2001w52_properties_idx ON pgstac.items_search_p2001w52 USING gin (properties);

CREATE INDEX items_search_p2002w01_collection_id_idx ON pgstac.items_search_p2002w01 USING btree (collection_id);

CREATE INDEX items_search_p2002w01_datetime_id_idx ON pgstac.items_search_p2002w01 USING btree (datetime, id);

CREATE INDEX items_search_p2002w01_geometry_idx ON pgstac.items_search_p2002w01 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w01_pkey ON pgstac.items_search_p2002w01 USING btree (id);

CREATE INDEX items_search_p2002w01_properties_idx ON pgstac.items_search_p2002w01 USING gin (properties);

CREATE INDEX items_search_p2002w02_collection_id_idx ON pgstac.items_search_p2002w02 USING btree (collection_id);

CREATE INDEX items_search_p2002w02_datetime_id_idx ON pgstac.items_search_p2002w02 USING btree (datetime, id);

CREATE INDEX items_search_p2002w02_geometry_idx ON pgstac.items_search_p2002w02 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w02_pkey ON pgstac.items_search_p2002w02 USING btree (id);

CREATE INDEX items_search_p2002w02_properties_idx ON pgstac.items_search_p2002w02 USING gin (properties);

CREATE INDEX items_search_p2002w03_collection_id_idx ON pgstac.items_search_p2002w03 USING btree (collection_id);

CREATE INDEX items_search_p2002w03_datetime_id_idx ON pgstac.items_search_p2002w03 USING btree (datetime, id);

CREATE INDEX items_search_p2002w03_geometry_idx ON pgstac.items_search_p2002w03 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w03_pkey ON pgstac.items_search_p2002w03 USING btree (id);

CREATE INDEX items_search_p2002w03_properties_idx ON pgstac.items_search_p2002w03 USING gin (properties);

CREATE INDEX items_search_p2002w04_collection_id_idx ON pgstac.items_search_p2002w04 USING btree (collection_id);

CREATE INDEX items_search_p2002w04_datetime_id_idx ON pgstac.items_search_p2002w04 USING btree (datetime, id);

CREATE INDEX items_search_p2002w04_geometry_idx ON pgstac.items_search_p2002w04 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w04_pkey ON pgstac.items_search_p2002w04 USING btree (id);

CREATE INDEX items_search_p2002w04_properties_idx ON pgstac.items_search_p2002w04 USING gin (properties);

CREATE INDEX items_search_p2002w05_collection_id_idx ON pgstac.items_search_p2002w05 USING btree (collection_id);

CREATE INDEX items_search_p2002w05_datetime_id_idx ON pgstac.items_search_p2002w05 USING btree (datetime, id);

CREATE INDEX items_search_p2002w05_geometry_idx ON pgstac.items_search_p2002w05 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w05_pkey ON pgstac.items_search_p2002w05 USING btree (id);

CREATE INDEX items_search_p2002w05_properties_idx ON pgstac.items_search_p2002w05 USING gin (properties);

CREATE INDEX items_search_p2002w06_collection_id_idx ON pgstac.items_search_p2002w06 USING btree (collection_id);

CREATE INDEX items_search_p2002w06_datetime_id_idx ON pgstac.items_search_p2002w06 USING btree (datetime, id);

CREATE INDEX items_search_p2002w06_geometry_idx ON pgstac.items_search_p2002w06 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w06_pkey ON pgstac.items_search_p2002w06 USING btree (id);

CREATE INDEX items_search_p2002w06_properties_idx ON pgstac.items_search_p2002w06 USING gin (properties);

CREATE INDEX items_search_p2002w07_collection_id_idx ON pgstac.items_search_p2002w07 USING btree (collection_id);

CREATE INDEX items_search_p2002w07_datetime_id_idx ON pgstac.items_search_p2002w07 USING btree (datetime, id);

CREATE INDEX items_search_p2002w07_geometry_idx ON pgstac.items_search_p2002w07 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w07_pkey ON pgstac.items_search_p2002w07 USING btree (id);

CREATE INDEX items_search_p2002w07_properties_idx ON pgstac.items_search_p2002w07 USING gin (properties);

CREATE INDEX items_search_p2002w08_collection_id_idx ON pgstac.items_search_p2002w08 USING btree (collection_id);

CREATE INDEX items_search_p2002w08_datetime_id_idx ON pgstac.items_search_p2002w08 USING btree (datetime, id);

CREATE INDEX items_search_p2002w08_geometry_idx ON pgstac.items_search_p2002w08 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w08_pkey ON pgstac.items_search_p2002w08 USING btree (id);

CREATE INDEX items_search_p2002w08_properties_idx ON pgstac.items_search_p2002w08 USING gin (properties);

CREATE INDEX items_search_p2002w09_collection_id_idx ON pgstac.items_search_p2002w09 USING btree (collection_id);

CREATE INDEX items_search_p2002w09_datetime_id_idx ON pgstac.items_search_p2002w09 USING btree (datetime, id);

CREATE INDEX items_search_p2002w09_geometry_idx ON pgstac.items_search_p2002w09 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w09_pkey ON pgstac.items_search_p2002w09 USING btree (id);

CREATE INDEX items_search_p2002w09_properties_idx ON pgstac.items_search_p2002w09 USING gin (properties);

CREATE INDEX items_search_p2002w10_collection_id_idx ON pgstac.items_search_p2002w10 USING btree (collection_id);

CREATE INDEX items_search_p2002w10_datetime_id_idx ON pgstac.items_search_p2002w10 USING btree (datetime, id);

CREATE INDEX items_search_p2002w10_geometry_idx ON pgstac.items_search_p2002w10 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w10_pkey ON pgstac.items_search_p2002w10 USING btree (id);

CREATE INDEX items_search_p2002w10_properties_idx ON pgstac.items_search_p2002w10 USING gin (properties);

CREATE INDEX items_search_p2002w11_collection_id_idx ON pgstac.items_search_p2002w11 USING btree (collection_id);

CREATE INDEX items_search_p2002w11_datetime_id_idx ON pgstac.items_search_p2002w11 USING btree (datetime, id);

CREATE INDEX items_search_p2002w11_geometry_idx ON pgstac.items_search_p2002w11 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w11_pkey ON pgstac.items_search_p2002w11 USING btree (id);

CREATE INDEX items_search_p2002w11_properties_idx ON pgstac.items_search_p2002w11 USING gin (properties);

CREATE INDEX items_search_p2002w12_collection_id_idx ON pgstac.items_search_p2002w12 USING btree (collection_id);

CREATE INDEX items_search_p2002w12_datetime_id_idx ON pgstac.items_search_p2002w12 USING btree (datetime, id);

CREATE INDEX items_search_p2002w12_geometry_idx ON pgstac.items_search_p2002w12 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w12_pkey ON pgstac.items_search_p2002w12 USING btree (id);

CREATE INDEX items_search_p2002w12_properties_idx ON pgstac.items_search_p2002w12 USING gin (properties);

CREATE INDEX items_search_p2002w13_collection_id_idx ON pgstac.items_search_p2002w13 USING btree (collection_id);

CREATE INDEX items_search_p2002w13_datetime_id_idx ON pgstac.items_search_p2002w13 USING btree (datetime, id);

CREATE INDEX items_search_p2002w13_geometry_idx ON pgstac.items_search_p2002w13 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w13_pkey ON pgstac.items_search_p2002w13 USING btree (id);

CREATE INDEX items_search_p2002w13_properties_idx ON pgstac.items_search_p2002w13 USING gin (properties);

CREATE INDEX items_search_p2002w14_collection_id_idx ON pgstac.items_search_p2002w14 USING btree (collection_id);

CREATE INDEX items_search_p2002w14_datetime_id_idx ON pgstac.items_search_p2002w14 USING btree (datetime, id);

CREATE INDEX items_search_p2002w14_geometry_idx ON pgstac.items_search_p2002w14 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w14_pkey ON pgstac.items_search_p2002w14 USING btree (id);

CREATE INDEX items_search_p2002w14_properties_idx ON pgstac.items_search_p2002w14 USING gin (properties);

CREATE INDEX items_search_p2002w15_collection_id_idx ON pgstac.items_search_p2002w15 USING btree (collection_id);

CREATE INDEX items_search_p2002w15_datetime_id_idx ON pgstac.items_search_p2002w15 USING btree (datetime, id);

CREATE INDEX items_search_p2002w15_geometry_idx ON pgstac.items_search_p2002w15 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w15_pkey ON pgstac.items_search_p2002w15 USING btree (id);

CREATE INDEX items_search_p2002w15_properties_idx ON pgstac.items_search_p2002w15 USING gin (properties);

CREATE INDEX items_search_p2002w16_collection_id_idx ON pgstac.items_search_p2002w16 USING btree (collection_id);

CREATE INDEX items_search_p2002w16_datetime_id_idx ON pgstac.items_search_p2002w16 USING btree (datetime, id);

CREATE INDEX items_search_p2002w16_geometry_idx ON pgstac.items_search_p2002w16 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w16_pkey ON pgstac.items_search_p2002w16 USING btree (id);

CREATE INDEX items_search_p2002w16_properties_idx ON pgstac.items_search_p2002w16 USING gin (properties);

CREATE INDEX items_search_p2002w17_collection_id_idx ON pgstac.items_search_p2002w17 USING btree (collection_id);

CREATE INDEX items_search_p2002w17_datetime_id_idx ON pgstac.items_search_p2002w17 USING btree (datetime, id);

CREATE INDEX items_search_p2002w17_geometry_idx ON pgstac.items_search_p2002w17 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w17_pkey ON pgstac.items_search_p2002w17 USING btree (id);

CREATE INDEX items_search_p2002w17_properties_idx ON pgstac.items_search_p2002w17 USING gin (properties);

CREATE INDEX items_search_p2002w18_collection_id_idx ON pgstac.items_search_p2002w18 USING btree (collection_id);

CREATE INDEX items_search_p2002w18_datetime_id_idx ON pgstac.items_search_p2002w18 USING btree (datetime, id);

CREATE INDEX items_search_p2002w18_geometry_idx ON pgstac.items_search_p2002w18 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w18_pkey ON pgstac.items_search_p2002w18 USING btree (id);

CREATE INDEX items_search_p2002w18_properties_idx ON pgstac.items_search_p2002w18 USING gin (properties);

CREATE INDEX items_search_p2002w19_collection_id_idx ON pgstac.items_search_p2002w19 USING btree (collection_id);

CREATE INDEX items_search_p2002w19_datetime_id_idx ON pgstac.items_search_p2002w19 USING btree (datetime, id);

CREATE INDEX items_search_p2002w19_geometry_idx ON pgstac.items_search_p2002w19 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w19_pkey ON pgstac.items_search_p2002w19 USING btree (id);

CREATE INDEX items_search_p2002w19_properties_idx ON pgstac.items_search_p2002w19 USING gin (properties);

CREATE INDEX items_search_p2002w20_collection_id_idx ON pgstac.items_search_p2002w20 USING btree (collection_id);

CREATE INDEX items_search_p2002w20_datetime_id_idx ON pgstac.items_search_p2002w20 USING btree (datetime, id);

CREATE INDEX items_search_p2002w20_geometry_idx ON pgstac.items_search_p2002w20 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w20_pkey ON pgstac.items_search_p2002w20 USING btree (id);

CREATE INDEX items_search_p2002w20_properties_idx ON pgstac.items_search_p2002w20 USING gin (properties);

CREATE INDEX items_search_p2002w21_collection_id_idx ON pgstac.items_search_p2002w21 USING btree (collection_id);

CREATE INDEX items_search_p2002w21_datetime_id_idx ON pgstac.items_search_p2002w21 USING btree (datetime, id);

CREATE INDEX items_search_p2002w21_geometry_idx ON pgstac.items_search_p2002w21 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w21_pkey ON pgstac.items_search_p2002w21 USING btree (id);

CREATE INDEX items_search_p2002w21_properties_idx ON pgstac.items_search_p2002w21 USING gin (properties);

CREATE INDEX items_search_p2002w22_collection_id_idx ON pgstac.items_search_p2002w22 USING btree (collection_id);

CREATE INDEX items_search_p2002w22_datetime_id_idx ON pgstac.items_search_p2002w22 USING btree (datetime, id);

CREATE INDEX items_search_p2002w22_geometry_idx ON pgstac.items_search_p2002w22 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w22_pkey ON pgstac.items_search_p2002w22 USING btree (id);

CREATE INDEX items_search_p2002w22_properties_idx ON pgstac.items_search_p2002w22 USING gin (properties);

CREATE INDEX items_search_p2002w23_collection_id_idx ON pgstac.items_search_p2002w23 USING btree (collection_id);

CREATE INDEX items_search_p2002w23_datetime_id_idx ON pgstac.items_search_p2002w23 USING btree (datetime, id);

CREATE INDEX items_search_p2002w23_geometry_idx ON pgstac.items_search_p2002w23 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w23_pkey ON pgstac.items_search_p2002w23 USING btree (id);

CREATE INDEX items_search_p2002w23_properties_idx ON pgstac.items_search_p2002w23 USING gin (properties);

CREATE INDEX items_search_p2002w24_collection_id_idx ON pgstac.items_search_p2002w24 USING btree (collection_id);

CREATE INDEX items_search_p2002w24_datetime_id_idx ON pgstac.items_search_p2002w24 USING btree (datetime, id);

CREATE INDEX items_search_p2002w24_geometry_idx ON pgstac.items_search_p2002w24 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w24_pkey ON pgstac.items_search_p2002w24 USING btree (id);

CREATE INDEX items_search_p2002w24_properties_idx ON pgstac.items_search_p2002w24 USING gin (properties);

CREATE INDEX items_search_p2002w25_collection_id_idx ON pgstac.items_search_p2002w25 USING btree (collection_id);

CREATE INDEX items_search_p2002w25_datetime_id_idx ON pgstac.items_search_p2002w25 USING btree (datetime, id);

CREATE INDEX items_search_p2002w25_geometry_idx ON pgstac.items_search_p2002w25 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w25_pkey ON pgstac.items_search_p2002w25 USING btree (id);

CREATE INDEX items_search_p2002w25_properties_idx ON pgstac.items_search_p2002w25 USING gin (properties);

CREATE INDEX items_search_p2002w26_collection_id_idx ON pgstac.items_search_p2002w26 USING btree (collection_id);

CREATE INDEX items_search_p2002w26_datetime_id_idx ON pgstac.items_search_p2002w26 USING btree (datetime, id);

CREATE INDEX items_search_p2002w26_geometry_idx ON pgstac.items_search_p2002w26 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w26_pkey ON pgstac.items_search_p2002w26 USING btree (id);

CREATE INDEX items_search_p2002w26_properties_idx ON pgstac.items_search_p2002w26 USING gin (properties);

CREATE INDEX items_search_p2002w27_collection_id_idx ON pgstac.items_search_p2002w27 USING btree (collection_id);

CREATE INDEX items_search_p2002w27_datetime_id_idx ON pgstac.items_search_p2002w27 USING btree (datetime, id);

CREATE INDEX items_search_p2002w27_geometry_idx ON pgstac.items_search_p2002w27 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w27_pkey ON pgstac.items_search_p2002w27 USING btree (id);

CREATE INDEX items_search_p2002w27_properties_idx ON pgstac.items_search_p2002w27 USING gin (properties);

CREATE INDEX items_search_p2002w28_collection_id_idx ON pgstac.items_search_p2002w28 USING btree (collection_id);

CREATE INDEX items_search_p2002w28_datetime_id_idx ON pgstac.items_search_p2002w28 USING btree (datetime, id);

CREATE INDEX items_search_p2002w28_geometry_idx ON pgstac.items_search_p2002w28 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w28_pkey ON pgstac.items_search_p2002w28 USING btree (id);

CREATE INDEX items_search_p2002w28_properties_idx ON pgstac.items_search_p2002w28 USING gin (properties);

CREATE INDEX items_search_p2002w29_collection_id_idx ON pgstac.items_search_p2002w29 USING btree (collection_id);

CREATE INDEX items_search_p2002w29_datetime_id_idx ON pgstac.items_search_p2002w29 USING btree (datetime, id);

CREATE INDEX items_search_p2002w29_geometry_idx ON pgstac.items_search_p2002w29 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w29_pkey ON pgstac.items_search_p2002w29 USING btree (id);

CREATE INDEX items_search_p2002w29_properties_idx ON pgstac.items_search_p2002w29 USING gin (properties);

CREATE INDEX items_search_p2002w30_collection_id_idx ON pgstac.items_search_p2002w30 USING btree (collection_id);

CREATE INDEX items_search_p2002w30_datetime_id_idx ON pgstac.items_search_p2002w30 USING btree (datetime, id);

CREATE INDEX items_search_p2002w30_geometry_idx ON pgstac.items_search_p2002w30 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w30_pkey ON pgstac.items_search_p2002w30 USING btree (id);

CREATE INDEX items_search_p2002w30_properties_idx ON pgstac.items_search_p2002w30 USING gin (properties);

CREATE INDEX items_search_p2002w31_collection_id_idx ON pgstac.items_search_p2002w31 USING btree (collection_id);

CREATE INDEX items_search_p2002w31_datetime_id_idx ON pgstac.items_search_p2002w31 USING btree (datetime, id);

CREATE INDEX items_search_p2002w31_geometry_idx ON pgstac.items_search_p2002w31 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w31_pkey ON pgstac.items_search_p2002w31 USING btree (id);

CREATE INDEX items_search_p2002w31_properties_idx ON pgstac.items_search_p2002w31 USING gin (properties);

CREATE INDEX items_search_p2002w32_collection_id_idx ON pgstac.items_search_p2002w32 USING btree (collection_id);

CREATE INDEX items_search_p2002w32_datetime_id_idx ON pgstac.items_search_p2002w32 USING btree (datetime, id);

CREATE INDEX items_search_p2002w32_geometry_idx ON pgstac.items_search_p2002w32 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w32_pkey ON pgstac.items_search_p2002w32 USING btree (id);

CREATE INDEX items_search_p2002w32_properties_idx ON pgstac.items_search_p2002w32 USING gin (properties);

CREATE INDEX items_search_p2002w33_collection_id_idx ON pgstac.items_search_p2002w33 USING btree (collection_id);

CREATE INDEX items_search_p2002w33_datetime_id_idx ON pgstac.items_search_p2002w33 USING btree (datetime, id);

CREATE INDEX items_search_p2002w33_geometry_idx ON pgstac.items_search_p2002w33 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w33_pkey ON pgstac.items_search_p2002w33 USING btree (id);

CREATE INDEX items_search_p2002w33_properties_idx ON pgstac.items_search_p2002w33 USING gin (properties);

CREATE INDEX items_search_p2002w34_collection_id_idx ON pgstac.items_search_p2002w34 USING btree (collection_id);

CREATE INDEX items_search_p2002w34_datetime_id_idx ON pgstac.items_search_p2002w34 USING btree (datetime, id);

CREATE INDEX items_search_p2002w34_geometry_idx ON pgstac.items_search_p2002w34 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w34_pkey ON pgstac.items_search_p2002w34 USING btree (id);

CREATE INDEX items_search_p2002w34_properties_idx ON pgstac.items_search_p2002w34 USING gin (properties);

CREATE INDEX items_search_p2002w35_collection_id_idx ON pgstac.items_search_p2002w35 USING btree (collection_id);

CREATE INDEX items_search_p2002w35_datetime_id_idx ON pgstac.items_search_p2002w35 USING btree (datetime, id);

CREATE INDEX items_search_p2002w35_geometry_idx ON pgstac.items_search_p2002w35 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w35_pkey ON pgstac.items_search_p2002w35 USING btree (id);

CREATE INDEX items_search_p2002w35_properties_idx ON pgstac.items_search_p2002w35 USING gin (properties);

CREATE INDEX items_search_p2002w36_collection_id_idx ON pgstac.items_search_p2002w36 USING btree (collection_id);

CREATE INDEX items_search_p2002w36_datetime_id_idx ON pgstac.items_search_p2002w36 USING btree (datetime, id);

CREATE INDEX items_search_p2002w36_geometry_idx ON pgstac.items_search_p2002w36 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w36_pkey ON pgstac.items_search_p2002w36 USING btree (id);

CREATE INDEX items_search_p2002w36_properties_idx ON pgstac.items_search_p2002w36 USING gin (properties);

CREATE INDEX items_search_p2002w37_collection_id_idx ON pgstac.items_search_p2002w37 USING btree (collection_id);

CREATE INDEX items_search_p2002w37_datetime_id_idx ON pgstac.items_search_p2002w37 USING btree (datetime, id);

CREATE INDEX items_search_p2002w37_geometry_idx ON pgstac.items_search_p2002w37 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w37_pkey ON pgstac.items_search_p2002w37 USING btree (id);

CREATE INDEX items_search_p2002w37_properties_idx ON pgstac.items_search_p2002w37 USING gin (properties);

CREATE INDEX items_search_p2002w38_collection_id_idx ON pgstac.items_search_p2002w38 USING btree (collection_id);

CREATE INDEX items_search_p2002w38_datetime_id_idx ON pgstac.items_search_p2002w38 USING btree (datetime, id);

CREATE INDEX items_search_p2002w38_geometry_idx ON pgstac.items_search_p2002w38 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w38_pkey ON pgstac.items_search_p2002w38 USING btree (id);

CREATE INDEX items_search_p2002w38_properties_idx ON pgstac.items_search_p2002w38 USING gin (properties);

CREATE INDEX items_search_p2002w39_collection_id_idx ON pgstac.items_search_p2002w39 USING btree (collection_id);

CREATE INDEX items_search_p2002w39_datetime_id_idx ON pgstac.items_search_p2002w39 USING btree (datetime, id);

CREATE INDEX items_search_p2002w39_geometry_idx ON pgstac.items_search_p2002w39 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w39_pkey ON pgstac.items_search_p2002w39 USING btree (id);

CREATE INDEX items_search_p2002w39_properties_idx ON pgstac.items_search_p2002w39 USING gin (properties);

CREATE INDEX items_search_p2002w40_collection_id_idx ON pgstac.items_search_p2002w40 USING btree (collection_id);

CREATE INDEX items_search_p2002w40_datetime_id_idx ON pgstac.items_search_p2002w40 USING btree (datetime, id);

CREATE INDEX items_search_p2002w40_geometry_idx ON pgstac.items_search_p2002w40 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w40_pkey ON pgstac.items_search_p2002w40 USING btree (id);

CREATE INDEX items_search_p2002w40_properties_idx ON pgstac.items_search_p2002w40 USING gin (properties);

CREATE INDEX items_search_p2002w41_collection_id_idx ON pgstac.items_search_p2002w41 USING btree (collection_id);

CREATE INDEX items_search_p2002w41_datetime_id_idx ON pgstac.items_search_p2002w41 USING btree (datetime, id);

CREATE INDEX items_search_p2002w41_geometry_idx ON pgstac.items_search_p2002w41 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w41_pkey ON pgstac.items_search_p2002w41 USING btree (id);

CREATE INDEX items_search_p2002w41_properties_idx ON pgstac.items_search_p2002w41 USING gin (properties);

CREATE INDEX items_search_p2002w42_collection_id_idx ON pgstac.items_search_p2002w42 USING btree (collection_id);

CREATE INDEX items_search_p2002w42_datetime_id_idx ON pgstac.items_search_p2002w42 USING btree (datetime, id);

CREATE INDEX items_search_p2002w42_geometry_idx ON pgstac.items_search_p2002w42 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w42_pkey ON pgstac.items_search_p2002w42 USING btree (id);

CREATE INDEX items_search_p2002w42_properties_idx ON pgstac.items_search_p2002w42 USING gin (properties);

CREATE INDEX items_search_p2002w43_collection_id_idx ON pgstac.items_search_p2002w43 USING btree (collection_id);

CREATE INDEX items_search_p2002w43_datetime_id_idx ON pgstac.items_search_p2002w43 USING btree (datetime, id);

CREATE INDEX items_search_p2002w43_geometry_idx ON pgstac.items_search_p2002w43 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w43_pkey ON pgstac.items_search_p2002w43 USING btree (id);

CREATE INDEX items_search_p2002w43_properties_idx ON pgstac.items_search_p2002w43 USING gin (properties);

CREATE INDEX items_search_p2002w44_collection_id_idx ON pgstac.items_search_p2002w44 USING btree (collection_id);

CREATE INDEX items_search_p2002w44_datetime_id_idx ON pgstac.items_search_p2002w44 USING btree (datetime, id);

CREATE INDEX items_search_p2002w44_geometry_idx ON pgstac.items_search_p2002w44 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w44_pkey ON pgstac.items_search_p2002w44 USING btree (id);

CREATE INDEX items_search_p2002w44_properties_idx ON pgstac.items_search_p2002w44 USING gin (properties);

CREATE INDEX items_search_p2002w45_collection_id_idx ON pgstac.items_search_p2002w45 USING btree (collection_id);

CREATE INDEX items_search_p2002w45_datetime_id_idx ON pgstac.items_search_p2002w45 USING btree (datetime, id);

CREATE INDEX items_search_p2002w45_geometry_idx ON pgstac.items_search_p2002w45 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w45_pkey ON pgstac.items_search_p2002w45 USING btree (id);

CREATE INDEX items_search_p2002w45_properties_idx ON pgstac.items_search_p2002w45 USING gin (properties);

CREATE INDEX items_search_p2002w46_collection_id_idx ON pgstac.items_search_p2002w46 USING btree (collection_id);

CREATE INDEX items_search_p2002w46_datetime_id_idx ON pgstac.items_search_p2002w46 USING btree (datetime, id);

CREATE INDEX items_search_p2002w46_geometry_idx ON pgstac.items_search_p2002w46 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w46_pkey ON pgstac.items_search_p2002w46 USING btree (id);

CREATE INDEX items_search_p2002w46_properties_idx ON pgstac.items_search_p2002w46 USING gin (properties);

CREATE INDEX items_search_p2002w47_collection_id_idx ON pgstac.items_search_p2002w47 USING btree (collection_id);

CREATE INDEX items_search_p2002w47_datetime_id_idx ON pgstac.items_search_p2002w47 USING btree (datetime, id);

CREATE INDEX items_search_p2002w47_geometry_idx ON pgstac.items_search_p2002w47 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w47_pkey ON pgstac.items_search_p2002w47 USING btree (id);

CREATE INDEX items_search_p2002w47_properties_idx ON pgstac.items_search_p2002w47 USING gin (properties);

CREATE INDEX items_search_p2002w48_collection_id_idx ON pgstac.items_search_p2002w48 USING btree (collection_id);

CREATE INDEX items_search_p2002w48_datetime_id_idx ON pgstac.items_search_p2002w48 USING btree (datetime, id);

CREATE INDEX items_search_p2002w48_geometry_idx ON pgstac.items_search_p2002w48 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w48_pkey ON pgstac.items_search_p2002w48 USING btree (id);

CREATE INDEX items_search_p2002w48_properties_idx ON pgstac.items_search_p2002w48 USING gin (properties);

CREATE INDEX items_search_p2002w49_collection_id_idx ON pgstac.items_search_p2002w49 USING btree (collection_id);

CREATE INDEX items_search_p2002w49_datetime_id_idx ON pgstac.items_search_p2002w49 USING btree (datetime, id);

CREATE INDEX items_search_p2002w49_geometry_idx ON pgstac.items_search_p2002w49 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w49_pkey ON pgstac.items_search_p2002w49 USING btree (id);

CREATE INDEX items_search_p2002w49_properties_idx ON pgstac.items_search_p2002w49 USING gin (properties);

CREATE INDEX items_search_p2002w50_collection_id_idx ON pgstac.items_search_p2002w50 USING btree (collection_id);

CREATE INDEX items_search_p2002w50_datetime_id_idx ON pgstac.items_search_p2002w50 USING btree (datetime, id);

CREATE INDEX items_search_p2002w50_geometry_idx ON pgstac.items_search_p2002w50 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w50_pkey ON pgstac.items_search_p2002w50 USING btree (id);

CREATE INDEX items_search_p2002w50_properties_idx ON pgstac.items_search_p2002w50 USING gin (properties);

CREATE INDEX items_search_p2002w51_collection_id_idx ON pgstac.items_search_p2002w51 USING btree (collection_id);

CREATE INDEX items_search_p2002w51_datetime_id_idx ON pgstac.items_search_p2002w51 USING btree (datetime, id);

CREATE INDEX items_search_p2002w51_geometry_idx ON pgstac.items_search_p2002w51 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w51_pkey ON pgstac.items_search_p2002w51 USING btree (id);

CREATE INDEX items_search_p2002w51_properties_idx ON pgstac.items_search_p2002w51 USING gin (properties);

CREATE INDEX items_search_p2002w52_collection_id_idx ON pgstac.items_search_p2002w52 USING btree (collection_id);

CREATE INDEX items_search_p2002w52_datetime_id_idx ON pgstac.items_search_p2002w52 USING btree (datetime, id);

CREATE INDEX items_search_p2002w52_geometry_idx ON pgstac.items_search_p2002w52 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2002w52_pkey ON pgstac.items_search_p2002w52 USING btree (id);

CREATE INDEX items_search_p2002w52_properties_idx ON pgstac.items_search_p2002w52 USING gin (properties);

CREATE INDEX items_search_p2003w01_collection_id_idx ON pgstac.items_search_p2003w01 USING btree (collection_id);

CREATE INDEX items_search_p2003w01_datetime_id_idx ON pgstac.items_search_p2003w01 USING btree (datetime, id);

CREATE INDEX items_search_p2003w01_geometry_idx ON pgstac.items_search_p2003w01 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w01_pkey ON pgstac.items_search_p2003w01 USING btree (id);

CREATE INDEX items_search_p2003w01_properties_idx ON pgstac.items_search_p2003w01 USING gin (properties);

CREATE INDEX items_search_p2003w02_collection_id_idx ON pgstac.items_search_p2003w02 USING btree (collection_id);

CREATE INDEX items_search_p2003w02_datetime_id_idx ON pgstac.items_search_p2003w02 USING btree (datetime, id);

CREATE INDEX items_search_p2003w02_geometry_idx ON pgstac.items_search_p2003w02 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w02_pkey ON pgstac.items_search_p2003w02 USING btree (id);

CREATE INDEX items_search_p2003w02_properties_idx ON pgstac.items_search_p2003w02 USING gin (properties);

CREATE INDEX items_search_p2003w03_collection_id_idx ON pgstac.items_search_p2003w03 USING btree (collection_id);

CREATE INDEX items_search_p2003w03_datetime_id_idx ON pgstac.items_search_p2003w03 USING btree (datetime, id);

CREATE INDEX items_search_p2003w03_geometry_idx ON pgstac.items_search_p2003w03 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w03_pkey ON pgstac.items_search_p2003w03 USING btree (id);

CREATE INDEX items_search_p2003w03_properties_idx ON pgstac.items_search_p2003w03 USING gin (properties);

CREATE INDEX items_search_p2003w04_collection_id_idx ON pgstac.items_search_p2003w04 USING btree (collection_id);

CREATE INDEX items_search_p2003w04_datetime_id_idx ON pgstac.items_search_p2003w04 USING btree (datetime, id);

CREATE INDEX items_search_p2003w04_geometry_idx ON pgstac.items_search_p2003w04 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w04_pkey ON pgstac.items_search_p2003w04 USING btree (id);

CREATE INDEX items_search_p2003w04_properties_idx ON pgstac.items_search_p2003w04 USING gin (properties);

CREATE INDEX items_search_p2003w05_collection_id_idx ON pgstac.items_search_p2003w05 USING btree (collection_id);

CREATE INDEX items_search_p2003w05_datetime_id_idx ON pgstac.items_search_p2003w05 USING btree (datetime, id);

CREATE INDEX items_search_p2003w05_geometry_idx ON pgstac.items_search_p2003w05 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w05_pkey ON pgstac.items_search_p2003w05 USING btree (id);

CREATE INDEX items_search_p2003w05_properties_idx ON pgstac.items_search_p2003w05 USING gin (properties);

CREATE INDEX items_search_p2003w06_collection_id_idx ON pgstac.items_search_p2003w06 USING btree (collection_id);

CREATE INDEX items_search_p2003w06_datetime_id_idx ON pgstac.items_search_p2003w06 USING btree (datetime, id);

CREATE INDEX items_search_p2003w06_geometry_idx ON pgstac.items_search_p2003w06 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w06_pkey ON pgstac.items_search_p2003w06 USING btree (id);

CREATE INDEX items_search_p2003w06_properties_idx ON pgstac.items_search_p2003w06 USING gin (properties);

CREATE INDEX items_search_p2003w07_collection_id_idx ON pgstac.items_search_p2003w07 USING btree (collection_id);

CREATE INDEX items_search_p2003w07_datetime_id_idx ON pgstac.items_search_p2003w07 USING btree (datetime, id);

CREATE INDEX items_search_p2003w07_geometry_idx ON pgstac.items_search_p2003w07 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w07_pkey ON pgstac.items_search_p2003w07 USING btree (id);

CREATE INDEX items_search_p2003w07_properties_idx ON pgstac.items_search_p2003w07 USING gin (properties);

CREATE INDEX items_search_p2003w08_collection_id_idx ON pgstac.items_search_p2003w08 USING btree (collection_id);

CREATE INDEX items_search_p2003w08_datetime_id_idx ON pgstac.items_search_p2003w08 USING btree (datetime, id);

CREATE INDEX items_search_p2003w08_geometry_idx ON pgstac.items_search_p2003w08 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w08_pkey ON pgstac.items_search_p2003w08 USING btree (id);

CREATE INDEX items_search_p2003w08_properties_idx ON pgstac.items_search_p2003w08 USING gin (properties);

CREATE INDEX items_search_p2003w09_collection_id_idx ON pgstac.items_search_p2003w09 USING btree (collection_id);

CREATE INDEX items_search_p2003w09_datetime_id_idx ON pgstac.items_search_p2003w09 USING btree (datetime, id);

CREATE INDEX items_search_p2003w09_geometry_idx ON pgstac.items_search_p2003w09 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w09_pkey ON pgstac.items_search_p2003w09 USING btree (id);

CREATE INDEX items_search_p2003w09_properties_idx ON pgstac.items_search_p2003w09 USING gin (properties);

CREATE INDEX items_search_p2003w10_collection_id_idx ON pgstac.items_search_p2003w10 USING btree (collection_id);

CREATE INDEX items_search_p2003w10_datetime_id_idx ON pgstac.items_search_p2003w10 USING btree (datetime, id);

CREATE INDEX items_search_p2003w10_geometry_idx ON pgstac.items_search_p2003w10 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w10_pkey ON pgstac.items_search_p2003w10 USING btree (id);

CREATE INDEX items_search_p2003w10_properties_idx ON pgstac.items_search_p2003w10 USING gin (properties);

CREATE INDEX items_search_p2003w11_collection_id_idx ON pgstac.items_search_p2003w11 USING btree (collection_id);

CREATE INDEX items_search_p2003w11_datetime_id_idx ON pgstac.items_search_p2003w11 USING btree (datetime, id);

CREATE INDEX items_search_p2003w11_geometry_idx ON pgstac.items_search_p2003w11 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w11_pkey ON pgstac.items_search_p2003w11 USING btree (id);

CREATE INDEX items_search_p2003w11_properties_idx ON pgstac.items_search_p2003w11 USING gin (properties);

CREATE INDEX items_search_p2003w12_collection_id_idx ON pgstac.items_search_p2003w12 USING btree (collection_id);

CREATE INDEX items_search_p2003w12_datetime_id_idx ON pgstac.items_search_p2003w12 USING btree (datetime, id);

CREATE INDEX items_search_p2003w12_geometry_idx ON pgstac.items_search_p2003w12 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w12_pkey ON pgstac.items_search_p2003w12 USING btree (id);

CREATE INDEX items_search_p2003w12_properties_idx ON pgstac.items_search_p2003w12 USING gin (properties);

CREATE INDEX items_search_p2003w13_collection_id_idx ON pgstac.items_search_p2003w13 USING btree (collection_id);

CREATE INDEX items_search_p2003w13_datetime_id_idx ON pgstac.items_search_p2003w13 USING btree (datetime, id);

CREATE INDEX items_search_p2003w13_geometry_idx ON pgstac.items_search_p2003w13 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w13_pkey ON pgstac.items_search_p2003w13 USING btree (id);

CREATE INDEX items_search_p2003w13_properties_idx ON pgstac.items_search_p2003w13 USING gin (properties);

CREATE INDEX items_search_p2003w14_collection_id_idx ON pgstac.items_search_p2003w14 USING btree (collection_id);

CREATE INDEX items_search_p2003w14_datetime_id_idx ON pgstac.items_search_p2003w14 USING btree (datetime, id);

CREATE INDEX items_search_p2003w14_geometry_idx ON pgstac.items_search_p2003w14 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w14_pkey ON pgstac.items_search_p2003w14 USING btree (id);

CREATE INDEX items_search_p2003w14_properties_idx ON pgstac.items_search_p2003w14 USING gin (properties);

CREATE INDEX items_search_p2003w15_collection_id_idx ON pgstac.items_search_p2003w15 USING btree (collection_id);

CREATE INDEX items_search_p2003w15_datetime_id_idx ON pgstac.items_search_p2003w15 USING btree (datetime, id);

CREATE INDEX items_search_p2003w15_geometry_idx ON pgstac.items_search_p2003w15 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w15_pkey ON pgstac.items_search_p2003w15 USING btree (id);

CREATE INDEX items_search_p2003w15_properties_idx ON pgstac.items_search_p2003w15 USING gin (properties);

CREATE INDEX items_search_p2003w16_collection_id_idx ON pgstac.items_search_p2003w16 USING btree (collection_id);

CREATE INDEX items_search_p2003w16_datetime_id_idx ON pgstac.items_search_p2003w16 USING btree (datetime, id);

CREATE INDEX items_search_p2003w16_geometry_idx ON pgstac.items_search_p2003w16 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w16_pkey ON pgstac.items_search_p2003w16 USING btree (id);

CREATE INDEX items_search_p2003w16_properties_idx ON pgstac.items_search_p2003w16 USING gin (properties);

CREATE INDEX items_search_p2003w17_collection_id_idx ON pgstac.items_search_p2003w17 USING btree (collection_id);

CREATE INDEX items_search_p2003w17_datetime_id_idx ON pgstac.items_search_p2003w17 USING btree (datetime, id);

CREATE INDEX items_search_p2003w17_geometry_idx ON pgstac.items_search_p2003w17 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w17_pkey ON pgstac.items_search_p2003w17 USING btree (id);

CREATE INDEX items_search_p2003w17_properties_idx ON pgstac.items_search_p2003w17 USING gin (properties);

CREATE INDEX items_search_p2003w18_collection_id_idx ON pgstac.items_search_p2003w18 USING btree (collection_id);

CREATE INDEX items_search_p2003w18_datetime_id_idx ON pgstac.items_search_p2003w18 USING btree (datetime, id);

CREATE INDEX items_search_p2003w18_geometry_idx ON pgstac.items_search_p2003w18 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w18_pkey ON pgstac.items_search_p2003w18 USING btree (id);

CREATE INDEX items_search_p2003w18_properties_idx ON pgstac.items_search_p2003w18 USING gin (properties);

CREATE INDEX items_search_p2003w19_collection_id_idx ON pgstac.items_search_p2003w19 USING btree (collection_id);

CREATE INDEX items_search_p2003w19_datetime_id_idx ON pgstac.items_search_p2003w19 USING btree (datetime, id);

CREATE INDEX items_search_p2003w19_geometry_idx ON pgstac.items_search_p2003w19 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w19_pkey ON pgstac.items_search_p2003w19 USING btree (id);

CREATE INDEX items_search_p2003w19_properties_idx ON pgstac.items_search_p2003w19 USING gin (properties);

CREATE INDEX items_search_p2003w20_collection_id_idx ON pgstac.items_search_p2003w20 USING btree (collection_id);

CREATE INDEX items_search_p2003w20_datetime_id_idx ON pgstac.items_search_p2003w20 USING btree (datetime, id);

CREATE INDEX items_search_p2003w20_geometry_idx ON pgstac.items_search_p2003w20 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w20_pkey ON pgstac.items_search_p2003w20 USING btree (id);

CREATE INDEX items_search_p2003w20_properties_idx ON pgstac.items_search_p2003w20 USING gin (properties);

CREATE INDEX items_search_p2003w21_collection_id_idx ON pgstac.items_search_p2003w21 USING btree (collection_id);

CREATE INDEX items_search_p2003w21_datetime_id_idx ON pgstac.items_search_p2003w21 USING btree (datetime, id);

CREATE INDEX items_search_p2003w21_geometry_idx ON pgstac.items_search_p2003w21 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w21_pkey ON pgstac.items_search_p2003w21 USING btree (id);

CREATE INDEX items_search_p2003w21_properties_idx ON pgstac.items_search_p2003w21 USING gin (properties);

CREATE INDEX items_search_p2003w22_collection_id_idx ON pgstac.items_search_p2003w22 USING btree (collection_id);

CREATE INDEX items_search_p2003w22_datetime_id_idx ON pgstac.items_search_p2003w22 USING btree (datetime, id);

CREATE INDEX items_search_p2003w22_geometry_idx ON pgstac.items_search_p2003w22 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w22_pkey ON pgstac.items_search_p2003w22 USING btree (id);

CREATE INDEX items_search_p2003w22_properties_idx ON pgstac.items_search_p2003w22 USING gin (properties);

CREATE INDEX items_search_p2003w23_collection_id_idx ON pgstac.items_search_p2003w23 USING btree (collection_id);

CREATE INDEX items_search_p2003w23_datetime_id_idx ON pgstac.items_search_p2003w23 USING btree (datetime, id);

CREATE INDEX items_search_p2003w23_geometry_idx ON pgstac.items_search_p2003w23 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w23_pkey ON pgstac.items_search_p2003w23 USING btree (id);

CREATE INDEX items_search_p2003w23_properties_idx ON pgstac.items_search_p2003w23 USING gin (properties);

CREATE INDEX items_search_p2003w24_collection_id_idx ON pgstac.items_search_p2003w24 USING btree (collection_id);

CREATE INDEX items_search_p2003w24_datetime_id_idx ON pgstac.items_search_p2003w24 USING btree (datetime, id);

CREATE INDEX items_search_p2003w24_geometry_idx ON pgstac.items_search_p2003w24 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w24_pkey ON pgstac.items_search_p2003w24 USING btree (id);

CREATE INDEX items_search_p2003w24_properties_idx ON pgstac.items_search_p2003w24 USING gin (properties);

CREATE INDEX items_search_p2003w25_collection_id_idx ON pgstac.items_search_p2003w25 USING btree (collection_id);

CREATE INDEX items_search_p2003w25_datetime_id_idx ON pgstac.items_search_p2003w25 USING btree (datetime, id);

CREATE INDEX items_search_p2003w25_geometry_idx ON pgstac.items_search_p2003w25 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w25_pkey ON pgstac.items_search_p2003w25 USING btree (id);

CREATE INDEX items_search_p2003w25_properties_idx ON pgstac.items_search_p2003w25 USING gin (properties);

CREATE INDEX items_search_p2003w26_collection_id_idx ON pgstac.items_search_p2003w26 USING btree (collection_id);

CREATE INDEX items_search_p2003w26_datetime_id_idx ON pgstac.items_search_p2003w26 USING btree (datetime, id);

CREATE INDEX items_search_p2003w26_geometry_idx ON pgstac.items_search_p2003w26 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w26_pkey ON pgstac.items_search_p2003w26 USING btree (id);

CREATE INDEX items_search_p2003w26_properties_idx ON pgstac.items_search_p2003w26 USING gin (properties);

CREATE INDEX items_search_p2003w27_collection_id_idx ON pgstac.items_search_p2003w27 USING btree (collection_id);

CREATE INDEX items_search_p2003w27_datetime_id_idx ON pgstac.items_search_p2003w27 USING btree (datetime, id);

CREATE INDEX items_search_p2003w27_geometry_idx ON pgstac.items_search_p2003w27 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w27_pkey ON pgstac.items_search_p2003w27 USING btree (id);

CREATE INDEX items_search_p2003w27_properties_idx ON pgstac.items_search_p2003w27 USING gin (properties);

CREATE INDEX items_search_p2003w28_collection_id_idx ON pgstac.items_search_p2003w28 USING btree (collection_id);

CREATE INDEX items_search_p2003w28_datetime_id_idx ON pgstac.items_search_p2003w28 USING btree (datetime, id);

CREATE INDEX items_search_p2003w28_geometry_idx ON pgstac.items_search_p2003w28 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w28_pkey ON pgstac.items_search_p2003w28 USING btree (id);

CREATE INDEX items_search_p2003w28_properties_idx ON pgstac.items_search_p2003w28 USING gin (properties);

CREATE INDEX items_search_p2003w29_collection_id_idx ON pgstac.items_search_p2003w29 USING btree (collection_id);

CREATE INDEX items_search_p2003w29_datetime_id_idx ON pgstac.items_search_p2003w29 USING btree (datetime, id);

CREATE INDEX items_search_p2003w29_geometry_idx ON pgstac.items_search_p2003w29 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w29_pkey ON pgstac.items_search_p2003w29 USING btree (id);

CREATE INDEX items_search_p2003w29_properties_idx ON pgstac.items_search_p2003w29 USING gin (properties);

CREATE INDEX items_search_p2003w30_collection_id_idx ON pgstac.items_search_p2003w30 USING btree (collection_id);

CREATE INDEX items_search_p2003w30_datetime_id_idx ON pgstac.items_search_p2003w30 USING btree (datetime, id);

CREATE INDEX items_search_p2003w30_geometry_idx ON pgstac.items_search_p2003w30 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w30_pkey ON pgstac.items_search_p2003w30 USING btree (id);

CREATE INDEX items_search_p2003w30_properties_idx ON pgstac.items_search_p2003w30 USING gin (properties);

CREATE INDEX items_search_p2003w31_collection_id_idx ON pgstac.items_search_p2003w31 USING btree (collection_id);

CREATE INDEX items_search_p2003w31_datetime_id_idx ON pgstac.items_search_p2003w31 USING btree (datetime, id);

CREATE INDEX items_search_p2003w31_geometry_idx ON pgstac.items_search_p2003w31 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w31_pkey ON pgstac.items_search_p2003w31 USING btree (id);

CREATE INDEX items_search_p2003w31_properties_idx ON pgstac.items_search_p2003w31 USING gin (properties);

CREATE INDEX items_search_p2003w32_collection_id_idx ON pgstac.items_search_p2003w32 USING btree (collection_id);

CREATE INDEX items_search_p2003w32_datetime_id_idx ON pgstac.items_search_p2003w32 USING btree (datetime, id);

CREATE INDEX items_search_p2003w32_geometry_idx ON pgstac.items_search_p2003w32 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w32_pkey ON pgstac.items_search_p2003w32 USING btree (id);

CREATE INDEX items_search_p2003w32_properties_idx ON pgstac.items_search_p2003w32 USING gin (properties);

CREATE INDEX items_search_p2003w33_collection_id_idx ON pgstac.items_search_p2003w33 USING btree (collection_id);

CREATE INDEX items_search_p2003w33_datetime_id_idx ON pgstac.items_search_p2003w33 USING btree (datetime, id);

CREATE INDEX items_search_p2003w33_geometry_idx ON pgstac.items_search_p2003w33 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w33_pkey ON pgstac.items_search_p2003w33 USING btree (id);

CREATE INDEX items_search_p2003w33_properties_idx ON pgstac.items_search_p2003w33 USING gin (properties);

CREATE INDEX items_search_p2003w34_collection_id_idx ON pgstac.items_search_p2003w34 USING btree (collection_id);

CREATE INDEX items_search_p2003w34_datetime_id_idx ON pgstac.items_search_p2003w34 USING btree (datetime, id);

CREATE INDEX items_search_p2003w34_geometry_idx ON pgstac.items_search_p2003w34 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w34_pkey ON pgstac.items_search_p2003w34 USING btree (id);

CREATE INDEX items_search_p2003w34_properties_idx ON pgstac.items_search_p2003w34 USING gin (properties);

CREATE INDEX items_search_p2003w35_collection_id_idx ON pgstac.items_search_p2003w35 USING btree (collection_id);

CREATE INDEX items_search_p2003w35_datetime_id_idx ON pgstac.items_search_p2003w35 USING btree (datetime, id);

CREATE INDEX items_search_p2003w35_geometry_idx ON pgstac.items_search_p2003w35 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w35_pkey ON pgstac.items_search_p2003w35 USING btree (id);

CREATE INDEX items_search_p2003w35_properties_idx ON pgstac.items_search_p2003w35 USING gin (properties);

CREATE INDEX items_search_p2003w36_collection_id_idx ON pgstac.items_search_p2003w36 USING btree (collection_id);

CREATE INDEX items_search_p2003w36_datetime_id_idx ON pgstac.items_search_p2003w36 USING btree (datetime, id);

CREATE INDEX items_search_p2003w36_geometry_idx ON pgstac.items_search_p2003w36 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w36_pkey ON pgstac.items_search_p2003w36 USING btree (id);

CREATE INDEX items_search_p2003w36_properties_idx ON pgstac.items_search_p2003w36 USING gin (properties);

CREATE INDEX items_search_p2003w37_collection_id_idx ON pgstac.items_search_p2003w37 USING btree (collection_id);

CREATE INDEX items_search_p2003w37_datetime_id_idx ON pgstac.items_search_p2003w37 USING btree (datetime, id);

CREATE INDEX items_search_p2003w37_geometry_idx ON pgstac.items_search_p2003w37 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w37_pkey ON pgstac.items_search_p2003w37 USING btree (id);

CREATE INDEX items_search_p2003w37_properties_idx ON pgstac.items_search_p2003w37 USING gin (properties);

CREATE INDEX items_search_p2003w38_collection_id_idx ON pgstac.items_search_p2003w38 USING btree (collection_id);

CREATE INDEX items_search_p2003w38_datetime_id_idx ON pgstac.items_search_p2003w38 USING btree (datetime, id);

CREATE INDEX items_search_p2003w38_geometry_idx ON pgstac.items_search_p2003w38 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w38_pkey ON pgstac.items_search_p2003w38 USING btree (id);

CREATE INDEX items_search_p2003w38_properties_idx ON pgstac.items_search_p2003w38 USING gin (properties);

CREATE INDEX items_search_p2003w39_collection_id_idx ON pgstac.items_search_p2003w39 USING btree (collection_id);

CREATE INDEX items_search_p2003w39_datetime_id_idx ON pgstac.items_search_p2003w39 USING btree (datetime, id);

CREATE INDEX items_search_p2003w39_geometry_idx ON pgstac.items_search_p2003w39 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w39_pkey ON pgstac.items_search_p2003w39 USING btree (id);

CREATE INDEX items_search_p2003w39_properties_idx ON pgstac.items_search_p2003w39 USING gin (properties);

CREATE INDEX items_search_p2003w40_collection_id_idx ON pgstac.items_search_p2003w40 USING btree (collection_id);

CREATE INDEX items_search_p2003w40_datetime_id_idx ON pgstac.items_search_p2003w40 USING btree (datetime, id);

CREATE INDEX items_search_p2003w40_geometry_idx ON pgstac.items_search_p2003w40 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w40_pkey ON pgstac.items_search_p2003w40 USING btree (id);

CREATE INDEX items_search_p2003w40_properties_idx ON pgstac.items_search_p2003w40 USING gin (properties);

CREATE INDEX items_search_p2003w41_collection_id_idx ON pgstac.items_search_p2003w41 USING btree (collection_id);

CREATE INDEX items_search_p2003w41_datetime_id_idx ON pgstac.items_search_p2003w41 USING btree (datetime, id);

CREATE INDEX items_search_p2003w41_geometry_idx ON pgstac.items_search_p2003w41 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w41_pkey ON pgstac.items_search_p2003w41 USING btree (id);

CREATE INDEX items_search_p2003w41_properties_idx ON pgstac.items_search_p2003w41 USING gin (properties);

CREATE INDEX items_search_p2003w42_collection_id_idx ON pgstac.items_search_p2003w42 USING btree (collection_id);

CREATE INDEX items_search_p2003w42_datetime_id_idx ON pgstac.items_search_p2003w42 USING btree (datetime, id);

CREATE INDEX items_search_p2003w42_geometry_idx ON pgstac.items_search_p2003w42 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w42_pkey ON pgstac.items_search_p2003w42 USING btree (id);

CREATE INDEX items_search_p2003w42_properties_idx ON pgstac.items_search_p2003w42 USING gin (properties);

CREATE INDEX items_search_p2003w43_collection_id_idx ON pgstac.items_search_p2003w43 USING btree (collection_id);

CREATE INDEX items_search_p2003w43_datetime_id_idx ON pgstac.items_search_p2003w43 USING btree (datetime, id);

CREATE INDEX items_search_p2003w43_geometry_idx ON pgstac.items_search_p2003w43 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w43_pkey ON pgstac.items_search_p2003w43 USING btree (id);

CREATE INDEX items_search_p2003w43_properties_idx ON pgstac.items_search_p2003w43 USING gin (properties);

CREATE INDEX items_search_p2003w44_collection_id_idx ON pgstac.items_search_p2003w44 USING btree (collection_id);

CREATE INDEX items_search_p2003w44_datetime_id_idx ON pgstac.items_search_p2003w44 USING btree (datetime, id);

CREATE INDEX items_search_p2003w44_geometry_idx ON pgstac.items_search_p2003w44 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w44_pkey ON pgstac.items_search_p2003w44 USING btree (id);

CREATE INDEX items_search_p2003w44_properties_idx ON pgstac.items_search_p2003w44 USING gin (properties);

CREATE INDEX items_search_p2003w45_collection_id_idx ON pgstac.items_search_p2003w45 USING btree (collection_id);

CREATE INDEX items_search_p2003w45_datetime_id_idx ON pgstac.items_search_p2003w45 USING btree (datetime, id);

CREATE INDEX items_search_p2003w45_geometry_idx ON pgstac.items_search_p2003w45 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w45_pkey ON pgstac.items_search_p2003w45 USING btree (id);

CREATE INDEX items_search_p2003w45_properties_idx ON pgstac.items_search_p2003w45 USING gin (properties);

CREATE INDEX items_search_p2003w46_collection_id_idx ON pgstac.items_search_p2003w46 USING btree (collection_id);

CREATE INDEX items_search_p2003w46_datetime_id_idx ON pgstac.items_search_p2003w46 USING btree (datetime, id);

CREATE INDEX items_search_p2003w46_geometry_idx ON pgstac.items_search_p2003w46 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w46_pkey ON pgstac.items_search_p2003w46 USING btree (id);

CREATE INDEX items_search_p2003w46_properties_idx ON pgstac.items_search_p2003w46 USING gin (properties);

CREATE INDEX items_search_p2003w47_collection_id_idx ON pgstac.items_search_p2003w47 USING btree (collection_id);

CREATE INDEX items_search_p2003w47_datetime_id_idx ON pgstac.items_search_p2003w47 USING btree (datetime, id);

CREATE INDEX items_search_p2003w47_geometry_idx ON pgstac.items_search_p2003w47 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w47_pkey ON pgstac.items_search_p2003w47 USING btree (id);

CREATE INDEX items_search_p2003w47_properties_idx ON pgstac.items_search_p2003w47 USING gin (properties);

CREATE INDEX items_search_p2003w48_collection_id_idx ON pgstac.items_search_p2003w48 USING btree (collection_id);

CREATE INDEX items_search_p2003w48_datetime_id_idx ON pgstac.items_search_p2003w48 USING btree (datetime, id);

CREATE INDEX items_search_p2003w48_geometry_idx ON pgstac.items_search_p2003w48 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w48_pkey ON pgstac.items_search_p2003w48 USING btree (id);

CREATE INDEX items_search_p2003w48_properties_idx ON pgstac.items_search_p2003w48 USING gin (properties);

CREATE INDEX items_search_p2003w49_collection_id_idx ON pgstac.items_search_p2003w49 USING btree (collection_id);

CREATE INDEX items_search_p2003w49_datetime_id_idx ON pgstac.items_search_p2003w49 USING btree (datetime, id);

CREATE INDEX items_search_p2003w49_geometry_idx ON pgstac.items_search_p2003w49 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w49_pkey ON pgstac.items_search_p2003w49 USING btree (id);

CREATE INDEX items_search_p2003w49_properties_idx ON pgstac.items_search_p2003w49 USING gin (properties);

CREATE INDEX items_search_p2003w50_collection_id_idx ON pgstac.items_search_p2003w50 USING btree (collection_id);

CREATE INDEX items_search_p2003w50_datetime_id_idx ON pgstac.items_search_p2003w50 USING btree (datetime, id);

CREATE INDEX items_search_p2003w50_geometry_idx ON pgstac.items_search_p2003w50 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w50_pkey ON pgstac.items_search_p2003w50 USING btree (id);

CREATE INDEX items_search_p2003w50_properties_idx ON pgstac.items_search_p2003w50 USING gin (properties);

CREATE INDEX items_search_p2003w51_collection_id_idx ON pgstac.items_search_p2003w51 USING btree (collection_id);

CREATE INDEX items_search_p2003w51_datetime_id_idx ON pgstac.items_search_p2003w51 USING btree (datetime, id);

CREATE INDEX items_search_p2003w51_geometry_idx ON pgstac.items_search_p2003w51 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w51_pkey ON pgstac.items_search_p2003w51 USING btree (id);

CREATE INDEX items_search_p2003w51_properties_idx ON pgstac.items_search_p2003w51 USING gin (properties);

CREATE INDEX items_search_p2003w52_collection_id_idx ON pgstac.items_search_p2003w52 USING btree (collection_id);

CREATE INDEX items_search_p2003w52_datetime_id_idx ON pgstac.items_search_p2003w52 USING btree (datetime, id);

CREATE INDEX items_search_p2003w52_geometry_idx ON pgstac.items_search_p2003w52 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2003w52_pkey ON pgstac.items_search_p2003w52 USING btree (id);

CREATE INDEX items_search_p2003w52_properties_idx ON pgstac.items_search_p2003w52 USING gin (properties);

CREATE INDEX items_search_p2004w01_collection_id_idx ON pgstac.items_search_p2004w01 USING btree (collection_id);

CREATE INDEX items_search_p2004w01_datetime_id_idx ON pgstac.items_search_p2004w01 USING btree (datetime, id);

CREATE INDEX items_search_p2004w01_geometry_idx ON pgstac.items_search_p2004w01 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w01_pkey ON pgstac.items_search_p2004w01 USING btree (id);

CREATE INDEX items_search_p2004w01_properties_idx ON pgstac.items_search_p2004w01 USING gin (properties);

CREATE INDEX items_search_p2004w02_collection_id_idx ON pgstac.items_search_p2004w02 USING btree (collection_id);

CREATE INDEX items_search_p2004w02_datetime_id_idx ON pgstac.items_search_p2004w02 USING btree (datetime, id);

CREATE INDEX items_search_p2004w02_geometry_idx ON pgstac.items_search_p2004w02 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w02_pkey ON pgstac.items_search_p2004w02 USING btree (id);

CREATE INDEX items_search_p2004w02_properties_idx ON pgstac.items_search_p2004w02 USING gin (properties);

CREATE INDEX items_search_p2004w03_collection_id_idx ON pgstac.items_search_p2004w03 USING btree (collection_id);

CREATE INDEX items_search_p2004w03_datetime_id_idx ON pgstac.items_search_p2004w03 USING btree (datetime, id);

CREATE INDEX items_search_p2004w03_geometry_idx ON pgstac.items_search_p2004w03 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w03_pkey ON pgstac.items_search_p2004w03 USING btree (id);

CREATE INDEX items_search_p2004w03_properties_idx ON pgstac.items_search_p2004w03 USING gin (properties);

CREATE INDEX items_search_p2004w04_collection_id_idx ON pgstac.items_search_p2004w04 USING btree (collection_id);

CREATE INDEX items_search_p2004w04_datetime_id_idx ON pgstac.items_search_p2004w04 USING btree (datetime, id);

CREATE INDEX items_search_p2004w04_geometry_idx ON pgstac.items_search_p2004w04 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w04_pkey ON pgstac.items_search_p2004w04 USING btree (id);

CREATE INDEX items_search_p2004w04_properties_idx ON pgstac.items_search_p2004w04 USING gin (properties);

CREATE INDEX items_search_p2004w05_collection_id_idx ON pgstac.items_search_p2004w05 USING btree (collection_id);

CREATE INDEX items_search_p2004w05_datetime_id_idx ON pgstac.items_search_p2004w05 USING btree (datetime, id);

CREATE INDEX items_search_p2004w05_geometry_idx ON pgstac.items_search_p2004w05 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w05_pkey ON pgstac.items_search_p2004w05 USING btree (id);

CREATE INDEX items_search_p2004w05_properties_idx ON pgstac.items_search_p2004w05 USING gin (properties);

CREATE INDEX items_search_p2004w06_collection_id_idx ON pgstac.items_search_p2004w06 USING btree (collection_id);

CREATE INDEX items_search_p2004w06_datetime_id_idx ON pgstac.items_search_p2004w06 USING btree (datetime, id);

CREATE INDEX items_search_p2004w06_geometry_idx ON pgstac.items_search_p2004w06 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w06_pkey ON pgstac.items_search_p2004w06 USING btree (id);

CREATE INDEX items_search_p2004w06_properties_idx ON pgstac.items_search_p2004w06 USING gin (properties);

CREATE INDEX items_search_p2004w07_collection_id_idx ON pgstac.items_search_p2004w07 USING btree (collection_id);

CREATE INDEX items_search_p2004w07_datetime_id_idx ON pgstac.items_search_p2004w07 USING btree (datetime, id);

CREATE INDEX items_search_p2004w07_geometry_idx ON pgstac.items_search_p2004w07 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w07_pkey ON pgstac.items_search_p2004w07 USING btree (id);

CREATE INDEX items_search_p2004w07_properties_idx ON pgstac.items_search_p2004w07 USING gin (properties);

CREATE INDEX items_search_p2004w08_collection_id_idx ON pgstac.items_search_p2004w08 USING btree (collection_id);

CREATE INDEX items_search_p2004w08_datetime_id_idx ON pgstac.items_search_p2004w08 USING btree (datetime, id);

CREATE INDEX items_search_p2004w08_geometry_idx ON pgstac.items_search_p2004w08 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w08_pkey ON pgstac.items_search_p2004w08 USING btree (id);

CREATE INDEX items_search_p2004w08_properties_idx ON pgstac.items_search_p2004w08 USING gin (properties);

CREATE INDEX items_search_p2004w09_collection_id_idx ON pgstac.items_search_p2004w09 USING btree (collection_id);

CREATE INDEX items_search_p2004w09_datetime_id_idx ON pgstac.items_search_p2004w09 USING btree (datetime, id);

CREATE INDEX items_search_p2004w09_geometry_idx ON pgstac.items_search_p2004w09 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w09_pkey ON pgstac.items_search_p2004w09 USING btree (id);

CREATE INDEX items_search_p2004w09_properties_idx ON pgstac.items_search_p2004w09 USING gin (properties);

CREATE INDEX items_search_p2004w10_collection_id_idx ON pgstac.items_search_p2004w10 USING btree (collection_id);

CREATE INDEX items_search_p2004w10_datetime_id_idx ON pgstac.items_search_p2004w10 USING btree (datetime, id);

CREATE INDEX items_search_p2004w10_geometry_idx ON pgstac.items_search_p2004w10 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w10_pkey ON pgstac.items_search_p2004w10 USING btree (id);

CREATE INDEX items_search_p2004w10_properties_idx ON pgstac.items_search_p2004w10 USING gin (properties);

CREATE INDEX items_search_p2004w11_collection_id_idx ON pgstac.items_search_p2004w11 USING btree (collection_id);

CREATE INDEX items_search_p2004w11_datetime_id_idx ON pgstac.items_search_p2004w11 USING btree (datetime, id);

CREATE INDEX items_search_p2004w11_geometry_idx ON pgstac.items_search_p2004w11 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w11_pkey ON pgstac.items_search_p2004w11 USING btree (id);

CREATE INDEX items_search_p2004w11_properties_idx ON pgstac.items_search_p2004w11 USING gin (properties);

CREATE INDEX items_search_p2004w12_collection_id_idx ON pgstac.items_search_p2004w12 USING btree (collection_id);

CREATE INDEX items_search_p2004w12_datetime_id_idx ON pgstac.items_search_p2004w12 USING btree (datetime, id);

CREATE INDEX items_search_p2004w12_geometry_idx ON pgstac.items_search_p2004w12 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w12_pkey ON pgstac.items_search_p2004w12 USING btree (id);

CREATE INDEX items_search_p2004w12_properties_idx ON pgstac.items_search_p2004w12 USING gin (properties);

CREATE INDEX items_search_p2004w13_collection_id_idx ON pgstac.items_search_p2004w13 USING btree (collection_id);

CREATE INDEX items_search_p2004w13_datetime_id_idx ON pgstac.items_search_p2004w13 USING btree (datetime, id);

CREATE INDEX items_search_p2004w13_geometry_idx ON pgstac.items_search_p2004w13 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w13_pkey ON pgstac.items_search_p2004w13 USING btree (id);

CREATE INDEX items_search_p2004w13_properties_idx ON pgstac.items_search_p2004w13 USING gin (properties);

CREATE INDEX items_search_p2004w14_collection_id_idx ON pgstac.items_search_p2004w14 USING btree (collection_id);

CREATE INDEX items_search_p2004w14_datetime_id_idx ON pgstac.items_search_p2004w14 USING btree (datetime, id);

CREATE INDEX items_search_p2004w14_geometry_idx ON pgstac.items_search_p2004w14 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w14_pkey ON pgstac.items_search_p2004w14 USING btree (id);

CREATE INDEX items_search_p2004w14_properties_idx ON pgstac.items_search_p2004w14 USING gin (properties);

CREATE INDEX items_search_p2004w15_collection_id_idx ON pgstac.items_search_p2004w15 USING btree (collection_id);

CREATE INDEX items_search_p2004w15_datetime_id_idx ON pgstac.items_search_p2004w15 USING btree (datetime, id);

CREATE INDEX items_search_p2004w15_geometry_idx ON pgstac.items_search_p2004w15 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w15_pkey ON pgstac.items_search_p2004w15 USING btree (id);

CREATE INDEX items_search_p2004w15_properties_idx ON pgstac.items_search_p2004w15 USING gin (properties);

CREATE INDEX items_search_p2004w16_collection_id_idx ON pgstac.items_search_p2004w16 USING btree (collection_id);

CREATE INDEX items_search_p2004w16_datetime_id_idx ON pgstac.items_search_p2004w16 USING btree (datetime, id);

CREATE INDEX items_search_p2004w16_geometry_idx ON pgstac.items_search_p2004w16 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w16_pkey ON pgstac.items_search_p2004w16 USING btree (id);

CREATE INDEX items_search_p2004w16_properties_idx ON pgstac.items_search_p2004w16 USING gin (properties);

CREATE INDEX items_search_p2004w17_collection_id_idx ON pgstac.items_search_p2004w17 USING btree (collection_id);

CREATE INDEX items_search_p2004w17_datetime_id_idx ON pgstac.items_search_p2004w17 USING btree (datetime, id);

CREATE INDEX items_search_p2004w17_geometry_idx ON pgstac.items_search_p2004w17 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w17_pkey ON pgstac.items_search_p2004w17 USING btree (id);

CREATE INDEX items_search_p2004w17_properties_idx ON pgstac.items_search_p2004w17 USING gin (properties);

CREATE INDEX items_search_p2004w18_collection_id_idx ON pgstac.items_search_p2004w18 USING btree (collection_id);

CREATE INDEX items_search_p2004w18_datetime_id_idx ON pgstac.items_search_p2004w18 USING btree (datetime, id);

CREATE INDEX items_search_p2004w18_geometry_idx ON pgstac.items_search_p2004w18 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w18_pkey ON pgstac.items_search_p2004w18 USING btree (id);

CREATE INDEX items_search_p2004w18_properties_idx ON pgstac.items_search_p2004w18 USING gin (properties);

CREATE INDEX items_search_p2004w19_collection_id_idx ON pgstac.items_search_p2004w19 USING btree (collection_id);

CREATE INDEX items_search_p2004w19_datetime_id_idx ON pgstac.items_search_p2004w19 USING btree (datetime, id);

CREATE INDEX items_search_p2004w19_geometry_idx ON pgstac.items_search_p2004w19 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w19_pkey ON pgstac.items_search_p2004w19 USING btree (id);

CREATE INDEX items_search_p2004w19_properties_idx ON pgstac.items_search_p2004w19 USING gin (properties);

CREATE INDEX items_search_p2004w20_collection_id_idx ON pgstac.items_search_p2004w20 USING btree (collection_id);

CREATE INDEX items_search_p2004w20_datetime_id_idx ON pgstac.items_search_p2004w20 USING btree (datetime, id);

CREATE INDEX items_search_p2004w20_geometry_idx ON pgstac.items_search_p2004w20 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w20_pkey ON pgstac.items_search_p2004w20 USING btree (id);

CREATE INDEX items_search_p2004w20_properties_idx ON pgstac.items_search_p2004w20 USING gin (properties);

CREATE INDEX items_search_p2004w21_collection_id_idx ON pgstac.items_search_p2004w21 USING btree (collection_id);

CREATE INDEX items_search_p2004w21_datetime_id_idx ON pgstac.items_search_p2004w21 USING btree (datetime, id);

CREATE INDEX items_search_p2004w21_geometry_idx ON pgstac.items_search_p2004w21 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w21_pkey ON pgstac.items_search_p2004w21 USING btree (id);

CREATE INDEX items_search_p2004w21_properties_idx ON pgstac.items_search_p2004w21 USING gin (properties);

CREATE INDEX items_search_p2004w22_collection_id_idx ON pgstac.items_search_p2004w22 USING btree (collection_id);

CREATE INDEX items_search_p2004w22_datetime_id_idx ON pgstac.items_search_p2004w22 USING btree (datetime, id);

CREATE INDEX items_search_p2004w22_geometry_idx ON pgstac.items_search_p2004w22 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w22_pkey ON pgstac.items_search_p2004w22 USING btree (id);

CREATE INDEX items_search_p2004w22_properties_idx ON pgstac.items_search_p2004w22 USING gin (properties);

CREATE INDEX items_search_p2004w23_collection_id_idx ON pgstac.items_search_p2004w23 USING btree (collection_id);

CREATE INDEX items_search_p2004w23_datetime_id_idx ON pgstac.items_search_p2004w23 USING btree (datetime, id);

CREATE INDEX items_search_p2004w23_geometry_idx ON pgstac.items_search_p2004w23 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w23_pkey ON pgstac.items_search_p2004w23 USING btree (id);

CREATE INDEX items_search_p2004w23_properties_idx ON pgstac.items_search_p2004w23 USING gin (properties);

CREATE INDEX items_search_p2004w24_collection_id_idx ON pgstac.items_search_p2004w24 USING btree (collection_id);

CREATE INDEX items_search_p2004w24_datetime_id_idx ON pgstac.items_search_p2004w24 USING btree (datetime, id);

CREATE INDEX items_search_p2004w24_geometry_idx ON pgstac.items_search_p2004w24 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w24_pkey ON pgstac.items_search_p2004w24 USING btree (id);

CREATE INDEX items_search_p2004w24_properties_idx ON pgstac.items_search_p2004w24 USING gin (properties);

CREATE INDEX items_search_p2004w25_collection_id_idx ON pgstac.items_search_p2004w25 USING btree (collection_id);

CREATE INDEX items_search_p2004w25_datetime_id_idx ON pgstac.items_search_p2004w25 USING btree (datetime, id);

CREATE INDEX items_search_p2004w25_geometry_idx ON pgstac.items_search_p2004w25 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w25_pkey ON pgstac.items_search_p2004w25 USING btree (id);

CREATE INDEX items_search_p2004w25_properties_idx ON pgstac.items_search_p2004w25 USING gin (properties);

CREATE INDEX items_search_p2004w26_collection_id_idx ON pgstac.items_search_p2004w26 USING btree (collection_id);

CREATE INDEX items_search_p2004w26_datetime_id_idx ON pgstac.items_search_p2004w26 USING btree (datetime, id);

CREATE INDEX items_search_p2004w26_geometry_idx ON pgstac.items_search_p2004w26 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w26_pkey ON pgstac.items_search_p2004w26 USING btree (id);

CREATE INDEX items_search_p2004w26_properties_idx ON pgstac.items_search_p2004w26 USING gin (properties);

CREATE INDEX items_search_p2004w27_collection_id_idx ON pgstac.items_search_p2004w27 USING btree (collection_id);

CREATE INDEX items_search_p2004w27_datetime_id_idx ON pgstac.items_search_p2004w27 USING btree (datetime, id);

CREATE INDEX items_search_p2004w27_geometry_idx ON pgstac.items_search_p2004w27 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w27_pkey ON pgstac.items_search_p2004w27 USING btree (id);

CREATE INDEX items_search_p2004w27_properties_idx ON pgstac.items_search_p2004w27 USING gin (properties);

CREATE INDEX items_search_p2004w28_collection_id_idx ON pgstac.items_search_p2004w28 USING btree (collection_id);

CREATE INDEX items_search_p2004w28_datetime_id_idx ON pgstac.items_search_p2004w28 USING btree (datetime, id);

CREATE INDEX items_search_p2004w28_geometry_idx ON pgstac.items_search_p2004w28 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w28_pkey ON pgstac.items_search_p2004w28 USING btree (id);

CREATE INDEX items_search_p2004w28_properties_idx ON pgstac.items_search_p2004w28 USING gin (properties);

CREATE INDEX items_search_p2004w29_collection_id_idx ON pgstac.items_search_p2004w29 USING btree (collection_id);

CREATE INDEX items_search_p2004w29_datetime_id_idx ON pgstac.items_search_p2004w29 USING btree (datetime, id);

CREATE INDEX items_search_p2004w29_geometry_idx ON pgstac.items_search_p2004w29 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w29_pkey ON pgstac.items_search_p2004w29 USING btree (id);

CREATE INDEX items_search_p2004w29_properties_idx ON pgstac.items_search_p2004w29 USING gin (properties);

CREATE INDEX items_search_p2004w30_collection_id_idx ON pgstac.items_search_p2004w30 USING btree (collection_id);

CREATE INDEX items_search_p2004w30_datetime_id_idx ON pgstac.items_search_p2004w30 USING btree (datetime, id);

CREATE INDEX items_search_p2004w30_geometry_idx ON pgstac.items_search_p2004w30 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w30_pkey ON pgstac.items_search_p2004w30 USING btree (id);

CREATE INDEX items_search_p2004w30_properties_idx ON pgstac.items_search_p2004w30 USING gin (properties);

CREATE INDEX items_search_p2004w31_collection_id_idx ON pgstac.items_search_p2004w31 USING btree (collection_id);

CREATE INDEX items_search_p2004w31_datetime_id_idx ON pgstac.items_search_p2004w31 USING btree (datetime, id);

CREATE INDEX items_search_p2004w31_geometry_idx ON pgstac.items_search_p2004w31 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w31_pkey ON pgstac.items_search_p2004w31 USING btree (id);

CREATE INDEX items_search_p2004w31_properties_idx ON pgstac.items_search_p2004w31 USING gin (properties);

CREATE INDEX items_search_p2004w32_collection_id_idx ON pgstac.items_search_p2004w32 USING btree (collection_id);

CREATE INDEX items_search_p2004w32_datetime_id_idx ON pgstac.items_search_p2004w32 USING btree (datetime, id);

CREATE INDEX items_search_p2004w32_geometry_idx ON pgstac.items_search_p2004w32 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w32_pkey ON pgstac.items_search_p2004w32 USING btree (id);

CREATE INDEX items_search_p2004w32_properties_idx ON pgstac.items_search_p2004w32 USING gin (properties);

CREATE INDEX items_search_p2004w33_collection_id_idx ON pgstac.items_search_p2004w33 USING btree (collection_id);

CREATE INDEX items_search_p2004w33_datetime_id_idx ON pgstac.items_search_p2004w33 USING btree (datetime, id);

CREATE INDEX items_search_p2004w33_geometry_idx ON pgstac.items_search_p2004w33 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w33_pkey ON pgstac.items_search_p2004w33 USING btree (id);

CREATE INDEX items_search_p2004w33_properties_idx ON pgstac.items_search_p2004w33 USING gin (properties);

CREATE INDEX items_search_p2004w34_collection_id_idx ON pgstac.items_search_p2004w34 USING btree (collection_id);

CREATE INDEX items_search_p2004w34_datetime_id_idx ON pgstac.items_search_p2004w34 USING btree (datetime, id);

CREATE INDEX items_search_p2004w34_geometry_idx ON pgstac.items_search_p2004w34 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w34_pkey ON pgstac.items_search_p2004w34 USING btree (id);

CREATE INDEX items_search_p2004w34_properties_idx ON pgstac.items_search_p2004w34 USING gin (properties);

CREATE INDEX items_search_p2004w35_collection_id_idx ON pgstac.items_search_p2004w35 USING btree (collection_id);

CREATE INDEX items_search_p2004w35_datetime_id_idx ON pgstac.items_search_p2004w35 USING btree (datetime, id);

CREATE INDEX items_search_p2004w35_geometry_idx ON pgstac.items_search_p2004w35 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w35_pkey ON pgstac.items_search_p2004w35 USING btree (id);

CREATE INDEX items_search_p2004w35_properties_idx ON pgstac.items_search_p2004w35 USING gin (properties);

CREATE INDEX items_search_p2004w36_collection_id_idx ON pgstac.items_search_p2004w36 USING btree (collection_id);

CREATE INDEX items_search_p2004w36_datetime_id_idx ON pgstac.items_search_p2004w36 USING btree (datetime, id);

CREATE INDEX items_search_p2004w36_geometry_idx ON pgstac.items_search_p2004w36 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w36_pkey ON pgstac.items_search_p2004w36 USING btree (id);

CREATE INDEX items_search_p2004w36_properties_idx ON pgstac.items_search_p2004w36 USING gin (properties);

CREATE INDEX items_search_p2004w37_collection_id_idx ON pgstac.items_search_p2004w37 USING btree (collection_id);

CREATE INDEX items_search_p2004w37_datetime_id_idx ON pgstac.items_search_p2004w37 USING btree (datetime, id);

CREATE INDEX items_search_p2004w37_geometry_idx ON pgstac.items_search_p2004w37 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w37_pkey ON pgstac.items_search_p2004w37 USING btree (id);

CREATE INDEX items_search_p2004w37_properties_idx ON pgstac.items_search_p2004w37 USING gin (properties);

CREATE INDEX items_search_p2004w38_collection_id_idx ON pgstac.items_search_p2004w38 USING btree (collection_id);

CREATE INDEX items_search_p2004w38_datetime_id_idx ON pgstac.items_search_p2004w38 USING btree (datetime, id);

CREATE INDEX items_search_p2004w38_geometry_idx ON pgstac.items_search_p2004w38 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w38_pkey ON pgstac.items_search_p2004w38 USING btree (id);

CREATE INDEX items_search_p2004w38_properties_idx ON pgstac.items_search_p2004w38 USING gin (properties);

CREATE INDEX items_search_p2004w39_collection_id_idx ON pgstac.items_search_p2004w39 USING btree (collection_id);

CREATE INDEX items_search_p2004w39_datetime_id_idx ON pgstac.items_search_p2004w39 USING btree (datetime, id);

CREATE INDEX items_search_p2004w39_geometry_idx ON pgstac.items_search_p2004w39 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w39_pkey ON pgstac.items_search_p2004w39 USING btree (id);

CREATE INDEX items_search_p2004w39_properties_idx ON pgstac.items_search_p2004w39 USING gin (properties);

CREATE INDEX items_search_p2004w40_collection_id_idx ON pgstac.items_search_p2004w40 USING btree (collection_id);

CREATE INDEX items_search_p2004w40_datetime_id_idx ON pgstac.items_search_p2004w40 USING btree (datetime, id);

CREATE INDEX items_search_p2004w40_geometry_idx ON pgstac.items_search_p2004w40 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w40_pkey ON pgstac.items_search_p2004w40 USING btree (id);

CREATE INDEX items_search_p2004w40_properties_idx ON pgstac.items_search_p2004w40 USING gin (properties);

CREATE INDEX items_search_p2004w41_collection_id_idx ON pgstac.items_search_p2004w41 USING btree (collection_id);

CREATE INDEX items_search_p2004w41_datetime_id_idx ON pgstac.items_search_p2004w41 USING btree (datetime, id);

CREATE INDEX items_search_p2004w41_geometry_idx ON pgstac.items_search_p2004w41 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w41_pkey ON pgstac.items_search_p2004w41 USING btree (id);

CREATE INDEX items_search_p2004w41_properties_idx ON pgstac.items_search_p2004w41 USING gin (properties);

CREATE INDEX items_search_p2004w42_collection_id_idx ON pgstac.items_search_p2004w42 USING btree (collection_id);

CREATE INDEX items_search_p2004w42_datetime_id_idx ON pgstac.items_search_p2004w42 USING btree (datetime, id);

CREATE INDEX items_search_p2004w42_geometry_idx ON pgstac.items_search_p2004w42 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w42_pkey ON pgstac.items_search_p2004w42 USING btree (id);

CREATE INDEX items_search_p2004w42_properties_idx ON pgstac.items_search_p2004w42 USING gin (properties);

CREATE INDEX items_search_p2004w43_collection_id_idx ON pgstac.items_search_p2004w43 USING btree (collection_id);

CREATE INDEX items_search_p2004w43_datetime_id_idx ON pgstac.items_search_p2004w43 USING btree (datetime, id);

CREATE INDEX items_search_p2004w43_geometry_idx ON pgstac.items_search_p2004w43 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w43_pkey ON pgstac.items_search_p2004w43 USING btree (id);

CREATE INDEX items_search_p2004w43_properties_idx ON pgstac.items_search_p2004w43 USING gin (properties);

CREATE INDEX items_search_p2004w44_collection_id_idx ON pgstac.items_search_p2004w44 USING btree (collection_id);

CREATE INDEX items_search_p2004w44_datetime_id_idx ON pgstac.items_search_p2004w44 USING btree (datetime, id);

CREATE INDEX items_search_p2004w44_geometry_idx ON pgstac.items_search_p2004w44 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w44_pkey ON pgstac.items_search_p2004w44 USING btree (id);

CREATE INDEX items_search_p2004w44_properties_idx ON pgstac.items_search_p2004w44 USING gin (properties);

CREATE INDEX items_search_p2004w45_collection_id_idx ON pgstac.items_search_p2004w45 USING btree (collection_id);

CREATE INDEX items_search_p2004w45_datetime_id_idx ON pgstac.items_search_p2004w45 USING btree (datetime, id);

CREATE INDEX items_search_p2004w45_geometry_idx ON pgstac.items_search_p2004w45 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w45_pkey ON pgstac.items_search_p2004w45 USING btree (id);

CREATE INDEX items_search_p2004w45_properties_idx ON pgstac.items_search_p2004w45 USING gin (properties);

CREATE INDEX items_search_p2004w46_collection_id_idx ON pgstac.items_search_p2004w46 USING btree (collection_id);

CREATE INDEX items_search_p2004w46_datetime_id_idx ON pgstac.items_search_p2004w46 USING btree (datetime, id);

CREATE INDEX items_search_p2004w46_geometry_idx ON pgstac.items_search_p2004w46 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w46_pkey ON pgstac.items_search_p2004w46 USING btree (id);

CREATE INDEX items_search_p2004w46_properties_idx ON pgstac.items_search_p2004w46 USING gin (properties);

CREATE INDEX items_search_p2004w47_collection_id_idx ON pgstac.items_search_p2004w47 USING btree (collection_id);

CREATE INDEX items_search_p2004w47_datetime_id_idx ON pgstac.items_search_p2004w47 USING btree (datetime, id);

CREATE INDEX items_search_p2004w47_geometry_idx ON pgstac.items_search_p2004w47 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w47_pkey ON pgstac.items_search_p2004w47 USING btree (id);

CREATE INDEX items_search_p2004w47_properties_idx ON pgstac.items_search_p2004w47 USING gin (properties);

CREATE INDEX items_search_p2004w48_collection_id_idx ON pgstac.items_search_p2004w48 USING btree (collection_id);

CREATE INDEX items_search_p2004w48_datetime_id_idx ON pgstac.items_search_p2004w48 USING btree (datetime, id);

CREATE INDEX items_search_p2004w48_geometry_idx ON pgstac.items_search_p2004w48 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w48_pkey ON pgstac.items_search_p2004w48 USING btree (id);

CREATE INDEX items_search_p2004w48_properties_idx ON pgstac.items_search_p2004w48 USING gin (properties);

CREATE INDEX items_search_p2004w49_collection_id_idx ON pgstac.items_search_p2004w49 USING btree (collection_id);

CREATE INDEX items_search_p2004w49_datetime_id_idx ON pgstac.items_search_p2004w49 USING btree (datetime, id);

CREATE INDEX items_search_p2004w49_geometry_idx ON pgstac.items_search_p2004w49 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w49_pkey ON pgstac.items_search_p2004w49 USING btree (id);

CREATE INDEX items_search_p2004w49_properties_idx ON pgstac.items_search_p2004w49 USING gin (properties);

CREATE INDEX items_search_p2004w50_collection_id_idx ON pgstac.items_search_p2004w50 USING btree (collection_id);

CREATE INDEX items_search_p2004w50_datetime_id_idx ON pgstac.items_search_p2004w50 USING btree (datetime, id);

CREATE INDEX items_search_p2004w50_geometry_idx ON pgstac.items_search_p2004w50 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w50_pkey ON pgstac.items_search_p2004w50 USING btree (id);

CREATE INDEX items_search_p2004w50_properties_idx ON pgstac.items_search_p2004w50 USING gin (properties);

CREATE INDEX items_search_p2004w51_collection_id_idx ON pgstac.items_search_p2004w51 USING btree (collection_id);

CREATE INDEX items_search_p2004w51_datetime_id_idx ON pgstac.items_search_p2004w51 USING btree (datetime, id);

CREATE INDEX items_search_p2004w51_geometry_idx ON pgstac.items_search_p2004w51 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w51_pkey ON pgstac.items_search_p2004w51 USING btree (id);

CREATE INDEX items_search_p2004w51_properties_idx ON pgstac.items_search_p2004w51 USING gin (properties);

CREATE INDEX items_search_p2004w52_collection_id_idx ON pgstac.items_search_p2004w52 USING btree (collection_id);

CREATE INDEX items_search_p2004w52_datetime_id_idx ON pgstac.items_search_p2004w52 USING btree (datetime, id);

CREATE INDEX items_search_p2004w52_geometry_idx ON pgstac.items_search_p2004w52 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w52_pkey ON pgstac.items_search_p2004w52 USING btree (id);

CREATE INDEX items_search_p2004w52_properties_idx ON pgstac.items_search_p2004w52 USING gin (properties);

CREATE INDEX items_search_p2004w53_collection_id_idx ON pgstac.items_search_p2004w53 USING btree (collection_id);

CREATE INDEX items_search_p2004w53_datetime_id_idx ON pgstac.items_search_p2004w53 USING btree (datetime, id);

CREATE INDEX items_search_p2004w53_geometry_idx ON pgstac.items_search_p2004w53 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2004w53_pkey ON pgstac.items_search_p2004w53 USING btree (id);

CREATE INDEX items_search_p2004w53_properties_idx ON pgstac.items_search_p2004w53 USING gin (properties);

CREATE INDEX items_search_p2005w01_collection_id_idx ON pgstac.items_search_p2005w01 USING btree (collection_id);

CREATE INDEX items_search_p2005w01_datetime_id_idx ON pgstac.items_search_p2005w01 USING btree (datetime, id);

CREATE INDEX items_search_p2005w01_geometry_idx ON pgstac.items_search_p2005w01 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w01_pkey ON pgstac.items_search_p2005w01 USING btree (id);

CREATE INDEX items_search_p2005w01_properties_idx ON pgstac.items_search_p2005w01 USING gin (properties);

CREATE INDEX items_search_p2005w02_collection_id_idx ON pgstac.items_search_p2005w02 USING btree (collection_id);

CREATE INDEX items_search_p2005w02_datetime_id_idx ON pgstac.items_search_p2005w02 USING btree (datetime, id);

CREATE INDEX items_search_p2005w02_geometry_idx ON pgstac.items_search_p2005w02 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w02_pkey ON pgstac.items_search_p2005w02 USING btree (id);

CREATE INDEX items_search_p2005w02_properties_idx ON pgstac.items_search_p2005w02 USING gin (properties);

CREATE INDEX items_search_p2005w03_collection_id_idx ON pgstac.items_search_p2005w03 USING btree (collection_id);

CREATE INDEX items_search_p2005w03_datetime_id_idx ON pgstac.items_search_p2005w03 USING btree (datetime, id);

CREATE INDEX items_search_p2005w03_geometry_idx ON pgstac.items_search_p2005w03 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w03_pkey ON pgstac.items_search_p2005w03 USING btree (id);

CREATE INDEX items_search_p2005w03_properties_idx ON pgstac.items_search_p2005w03 USING gin (properties);

CREATE INDEX items_search_p2005w04_collection_id_idx ON pgstac.items_search_p2005w04 USING btree (collection_id);

CREATE INDEX items_search_p2005w04_datetime_id_idx ON pgstac.items_search_p2005w04 USING btree (datetime, id);

CREATE INDEX items_search_p2005w04_geometry_idx ON pgstac.items_search_p2005w04 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w04_pkey ON pgstac.items_search_p2005w04 USING btree (id);

CREATE INDEX items_search_p2005w04_properties_idx ON pgstac.items_search_p2005w04 USING gin (properties);

CREATE INDEX items_search_p2005w05_collection_id_idx ON pgstac.items_search_p2005w05 USING btree (collection_id);

CREATE INDEX items_search_p2005w05_datetime_id_idx ON pgstac.items_search_p2005w05 USING btree (datetime, id);

CREATE INDEX items_search_p2005w05_geometry_idx ON pgstac.items_search_p2005w05 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w05_pkey ON pgstac.items_search_p2005w05 USING btree (id);

CREATE INDEX items_search_p2005w05_properties_idx ON pgstac.items_search_p2005w05 USING gin (properties);

CREATE INDEX items_search_p2005w06_collection_id_idx ON pgstac.items_search_p2005w06 USING btree (collection_id);

CREATE INDEX items_search_p2005w06_datetime_id_idx ON pgstac.items_search_p2005w06 USING btree (datetime, id);

CREATE INDEX items_search_p2005w06_geometry_idx ON pgstac.items_search_p2005w06 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w06_pkey ON pgstac.items_search_p2005w06 USING btree (id);

CREATE INDEX items_search_p2005w06_properties_idx ON pgstac.items_search_p2005w06 USING gin (properties);

CREATE INDEX items_search_p2005w07_collection_id_idx ON pgstac.items_search_p2005w07 USING btree (collection_id);

CREATE INDEX items_search_p2005w07_datetime_id_idx ON pgstac.items_search_p2005w07 USING btree (datetime, id);

CREATE INDEX items_search_p2005w07_geometry_idx ON pgstac.items_search_p2005w07 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w07_pkey ON pgstac.items_search_p2005w07 USING btree (id);

CREATE INDEX items_search_p2005w07_properties_idx ON pgstac.items_search_p2005w07 USING gin (properties);

CREATE INDEX items_search_p2005w08_collection_id_idx ON pgstac.items_search_p2005w08 USING btree (collection_id);

CREATE INDEX items_search_p2005w08_datetime_id_idx ON pgstac.items_search_p2005w08 USING btree (datetime, id);

CREATE INDEX items_search_p2005w08_geometry_idx ON pgstac.items_search_p2005w08 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w08_pkey ON pgstac.items_search_p2005w08 USING btree (id);

CREATE INDEX items_search_p2005w08_properties_idx ON pgstac.items_search_p2005w08 USING gin (properties);

CREATE INDEX items_search_p2005w09_collection_id_idx ON pgstac.items_search_p2005w09 USING btree (collection_id);

CREATE INDEX items_search_p2005w09_datetime_id_idx ON pgstac.items_search_p2005w09 USING btree (datetime, id);

CREATE INDEX items_search_p2005w09_geometry_idx ON pgstac.items_search_p2005w09 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w09_pkey ON pgstac.items_search_p2005w09 USING btree (id);

CREATE INDEX items_search_p2005w09_properties_idx ON pgstac.items_search_p2005w09 USING gin (properties);

CREATE INDEX items_search_p2005w10_collection_id_idx ON pgstac.items_search_p2005w10 USING btree (collection_id);

CREATE INDEX items_search_p2005w10_datetime_id_idx ON pgstac.items_search_p2005w10 USING btree (datetime, id);

CREATE INDEX items_search_p2005w10_geometry_idx ON pgstac.items_search_p2005w10 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w10_pkey ON pgstac.items_search_p2005w10 USING btree (id);

CREATE INDEX items_search_p2005w10_properties_idx ON pgstac.items_search_p2005w10 USING gin (properties);

CREATE INDEX items_search_p2005w11_collection_id_idx ON pgstac.items_search_p2005w11 USING btree (collection_id);

CREATE INDEX items_search_p2005w11_datetime_id_idx ON pgstac.items_search_p2005w11 USING btree (datetime, id);

CREATE INDEX items_search_p2005w11_geometry_idx ON pgstac.items_search_p2005w11 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w11_pkey ON pgstac.items_search_p2005w11 USING btree (id);

CREATE INDEX items_search_p2005w11_properties_idx ON pgstac.items_search_p2005w11 USING gin (properties);

CREATE INDEX items_search_p2005w12_collection_id_idx ON pgstac.items_search_p2005w12 USING btree (collection_id);

CREATE INDEX items_search_p2005w12_datetime_id_idx ON pgstac.items_search_p2005w12 USING btree (datetime, id);

CREATE INDEX items_search_p2005w12_geometry_idx ON pgstac.items_search_p2005w12 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w12_pkey ON pgstac.items_search_p2005w12 USING btree (id);

CREATE INDEX items_search_p2005w12_properties_idx ON pgstac.items_search_p2005w12 USING gin (properties);

CREATE INDEX items_search_p2005w13_collection_id_idx ON pgstac.items_search_p2005w13 USING btree (collection_id);

CREATE INDEX items_search_p2005w13_datetime_id_idx ON pgstac.items_search_p2005w13 USING btree (datetime, id);

CREATE INDEX items_search_p2005w13_geometry_idx ON pgstac.items_search_p2005w13 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w13_pkey ON pgstac.items_search_p2005w13 USING btree (id);

CREATE INDEX items_search_p2005w13_properties_idx ON pgstac.items_search_p2005w13 USING gin (properties);

CREATE INDEX items_search_p2005w14_collection_id_idx ON pgstac.items_search_p2005w14 USING btree (collection_id);

CREATE INDEX items_search_p2005w14_datetime_id_idx ON pgstac.items_search_p2005w14 USING btree (datetime, id);

CREATE INDEX items_search_p2005w14_geometry_idx ON pgstac.items_search_p2005w14 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w14_pkey ON pgstac.items_search_p2005w14 USING btree (id);

CREATE INDEX items_search_p2005w14_properties_idx ON pgstac.items_search_p2005w14 USING gin (properties);

CREATE INDEX items_search_p2005w15_collection_id_idx ON pgstac.items_search_p2005w15 USING btree (collection_id);

CREATE INDEX items_search_p2005w15_datetime_id_idx ON pgstac.items_search_p2005w15 USING btree (datetime, id);

CREATE INDEX items_search_p2005w15_geometry_idx ON pgstac.items_search_p2005w15 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w15_pkey ON pgstac.items_search_p2005w15 USING btree (id);

CREATE INDEX items_search_p2005w15_properties_idx ON pgstac.items_search_p2005w15 USING gin (properties);

CREATE INDEX items_search_p2005w16_collection_id_idx ON pgstac.items_search_p2005w16 USING btree (collection_id);

CREATE INDEX items_search_p2005w16_datetime_id_idx ON pgstac.items_search_p2005w16 USING btree (datetime, id);

CREATE INDEX items_search_p2005w16_geometry_idx ON pgstac.items_search_p2005w16 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w16_pkey ON pgstac.items_search_p2005w16 USING btree (id);

CREATE INDEX items_search_p2005w16_properties_idx ON pgstac.items_search_p2005w16 USING gin (properties);

CREATE INDEX items_search_p2005w17_collection_id_idx ON pgstac.items_search_p2005w17 USING btree (collection_id);

CREATE INDEX items_search_p2005w17_datetime_id_idx ON pgstac.items_search_p2005w17 USING btree (datetime, id);

CREATE INDEX items_search_p2005w17_geometry_idx ON pgstac.items_search_p2005w17 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w17_pkey ON pgstac.items_search_p2005w17 USING btree (id);

CREATE INDEX items_search_p2005w17_properties_idx ON pgstac.items_search_p2005w17 USING gin (properties);

CREATE INDEX items_search_p2005w18_collection_id_idx ON pgstac.items_search_p2005w18 USING btree (collection_id);

CREATE INDEX items_search_p2005w18_datetime_id_idx ON pgstac.items_search_p2005w18 USING btree (datetime, id);

CREATE INDEX items_search_p2005w18_geometry_idx ON pgstac.items_search_p2005w18 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w18_pkey ON pgstac.items_search_p2005w18 USING btree (id);

CREATE INDEX items_search_p2005w18_properties_idx ON pgstac.items_search_p2005w18 USING gin (properties);

CREATE INDEX items_search_p2005w19_collection_id_idx ON pgstac.items_search_p2005w19 USING btree (collection_id);

CREATE INDEX items_search_p2005w19_datetime_id_idx ON pgstac.items_search_p2005w19 USING btree (datetime, id);

CREATE INDEX items_search_p2005w19_geometry_idx ON pgstac.items_search_p2005w19 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w19_pkey ON pgstac.items_search_p2005w19 USING btree (id);

CREATE INDEX items_search_p2005w19_properties_idx ON pgstac.items_search_p2005w19 USING gin (properties);

CREATE INDEX items_search_p2005w20_collection_id_idx ON pgstac.items_search_p2005w20 USING btree (collection_id);

CREATE INDEX items_search_p2005w20_datetime_id_idx ON pgstac.items_search_p2005w20 USING btree (datetime, id);

CREATE INDEX items_search_p2005w20_geometry_idx ON pgstac.items_search_p2005w20 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w20_pkey ON pgstac.items_search_p2005w20 USING btree (id);

CREATE INDEX items_search_p2005w20_properties_idx ON pgstac.items_search_p2005w20 USING gin (properties);

CREATE INDEX items_search_p2005w21_collection_id_idx ON pgstac.items_search_p2005w21 USING btree (collection_id);

CREATE INDEX items_search_p2005w21_datetime_id_idx ON pgstac.items_search_p2005w21 USING btree (datetime, id);

CREATE INDEX items_search_p2005w21_geometry_idx ON pgstac.items_search_p2005w21 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w21_pkey ON pgstac.items_search_p2005w21 USING btree (id);

CREATE INDEX items_search_p2005w21_properties_idx ON pgstac.items_search_p2005w21 USING gin (properties);

CREATE INDEX items_search_p2005w22_collection_id_idx ON pgstac.items_search_p2005w22 USING btree (collection_id);

CREATE INDEX items_search_p2005w22_datetime_id_idx ON pgstac.items_search_p2005w22 USING btree (datetime, id);

CREATE INDEX items_search_p2005w22_geometry_idx ON pgstac.items_search_p2005w22 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w22_pkey ON pgstac.items_search_p2005w22 USING btree (id);

CREATE INDEX items_search_p2005w22_properties_idx ON pgstac.items_search_p2005w22 USING gin (properties);

CREATE INDEX items_search_p2005w23_collection_id_idx ON pgstac.items_search_p2005w23 USING btree (collection_id);

CREATE INDEX items_search_p2005w23_datetime_id_idx ON pgstac.items_search_p2005w23 USING btree (datetime, id);

CREATE INDEX items_search_p2005w23_geometry_idx ON pgstac.items_search_p2005w23 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w23_pkey ON pgstac.items_search_p2005w23 USING btree (id);

CREATE INDEX items_search_p2005w23_properties_idx ON pgstac.items_search_p2005w23 USING gin (properties);

CREATE INDEX items_search_p2005w24_collection_id_idx ON pgstac.items_search_p2005w24 USING btree (collection_id);

CREATE INDEX items_search_p2005w24_datetime_id_idx ON pgstac.items_search_p2005w24 USING btree (datetime, id);

CREATE INDEX items_search_p2005w24_geometry_idx ON pgstac.items_search_p2005w24 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w24_pkey ON pgstac.items_search_p2005w24 USING btree (id);

CREATE INDEX items_search_p2005w24_properties_idx ON pgstac.items_search_p2005w24 USING gin (properties);

CREATE INDEX items_search_p2005w25_collection_id_idx ON pgstac.items_search_p2005w25 USING btree (collection_id);

CREATE INDEX items_search_p2005w25_datetime_id_idx ON pgstac.items_search_p2005w25 USING btree (datetime, id);

CREATE INDEX items_search_p2005w25_geometry_idx ON pgstac.items_search_p2005w25 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w25_pkey ON pgstac.items_search_p2005w25 USING btree (id);

CREATE INDEX items_search_p2005w25_properties_idx ON pgstac.items_search_p2005w25 USING gin (properties);

CREATE INDEX items_search_p2005w26_collection_id_idx ON pgstac.items_search_p2005w26 USING btree (collection_id);

CREATE INDEX items_search_p2005w26_datetime_id_idx ON pgstac.items_search_p2005w26 USING btree (datetime, id);

CREATE INDEX items_search_p2005w26_geometry_idx ON pgstac.items_search_p2005w26 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w26_pkey ON pgstac.items_search_p2005w26 USING btree (id);

CREATE INDEX items_search_p2005w26_properties_idx ON pgstac.items_search_p2005w26 USING gin (properties);

CREATE INDEX items_search_p2005w27_collection_id_idx ON pgstac.items_search_p2005w27 USING btree (collection_id);

CREATE INDEX items_search_p2005w27_datetime_id_idx ON pgstac.items_search_p2005w27 USING btree (datetime, id);

CREATE INDEX items_search_p2005w27_geometry_idx ON pgstac.items_search_p2005w27 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w27_pkey ON pgstac.items_search_p2005w27 USING btree (id);

CREATE INDEX items_search_p2005w27_properties_idx ON pgstac.items_search_p2005w27 USING gin (properties);

CREATE INDEX items_search_p2005w28_collection_id_idx ON pgstac.items_search_p2005w28 USING btree (collection_id);

CREATE INDEX items_search_p2005w28_datetime_id_idx ON pgstac.items_search_p2005w28 USING btree (datetime, id);

CREATE INDEX items_search_p2005w28_geometry_idx ON pgstac.items_search_p2005w28 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w28_pkey ON pgstac.items_search_p2005w28 USING btree (id);

CREATE INDEX items_search_p2005w28_properties_idx ON pgstac.items_search_p2005w28 USING gin (properties);

CREATE INDEX items_search_p2005w29_collection_id_idx ON pgstac.items_search_p2005w29 USING btree (collection_id);

CREATE INDEX items_search_p2005w29_datetime_id_idx ON pgstac.items_search_p2005w29 USING btree (datetime, id);

CREATE INDEX items_search_p2005w29_geometry_idx ON pgstac.items_search_p2005w29 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w29_pkey ON pgstac.items_search_p2005w29 USING btree (id);

CREATE INDEX items_search_p2005w29_properties_idx ON pgstac.items_search_p2005w29 USING gin (properties);

CREATE INDEX items_search_p2005w30_collection_id_idx ON pgstac.items_search_p2005w30 USING btree (collection_id);

CREATE INDEX items_search_p2005w30_datetime_id_idx ON pgstac.items_search_p2005w30 USING btree (datetime, id);

CREATE INDEX items_search_p2005w30_geometry_idx ON pgstac.items_search_p2005w30 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w30_pkey ON pgstac.items_search_p2005w30 USING btree (id);

CREATE INDEX items_search_p2005w30_properties_idx ON pgstac.items_search_p2005w30 USING gin (properties);

CREATE INDEX items_search_p2005w31_collection_id_idx ON pgstac.items_search_p2005w31 USING btree (collection_id);

CREATE INDEX items_search_p2005w31_datetime_id_idx ON pgstac.items_search_p2005w31 USING btree (datetime, id);

CREATE INDEX items_search_p2005w31_geometry_idx ON pgstac.items_search_p2005w31 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w31_pkey ON pgstac.items_search_p2005w31 USING btree (id);

CREATE INDEX items_search_p2005w31_properties_idx ON pgstac.items_search_p2005w31 USING gin (properties);

CREATE INDEX items_search_p2005w32_collection_id_idx ON pgstac.items_search_p2005w32 USING btree (collection_id);

CREATE INDEX items_search_p2005w32_datetime_id_idx ON pgstac.items_search_p2005w32 USING btree (datetime, id);

CREATE INDEX items_search_p2005w32_geometry_idx ON pgstac.items_search_p2005w32 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w32_pkey ON pgstac.items_search_p2005w32 USING btree (id);

CREATE INDEX items_search_p2005w32_properties_idx ON pgstac.items_search_p2005w32 USING gin (properties);

CREATE INDEX items_search_p2005w33_collection_id_idx ON pgstac.items_search_p2005w33 USING btree (collection_id);

CREATE INDEX items_search_p2005w33_datetime_id_idx ON pgstac.items_search_p2005w33 USING btree (datetime, id);

CREATE INDEX items_search_p2005w33_geometry_idx ON pgstac.items_search_p2005w33 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w33_pkey ON pgstac.items_search_p2005w33 USING btree (id);

CREATE INDEX items_search_p2005w33_properties_idx ON pgstac.items_search_p2005w33 USING gin (properties);

CREATE INDEX items_search_p2005w34_collection_id_idx ON pgstac.items_search_p2005w34 USING btree (collection_id);

CREATE INDEX items_search_p2005w34_datetime_id_idx ON pgstac.items_search_p2005w34 USING btree (datetime, id);

CREATE INDEX items_search_p2005w34_geometry_idx ON pgstac.items_search_p2005w34 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w34_pkey ON pgstac.items_search_p2005w34 USING btree (id);

CREATE INDEX items_search_p2005w34_properties_idx ON pgstac.items_search_p2005w34 USING gin (properties);

CREATE INDEX items_search_p2005w35_collection_id_idx ON pgstac.items_search_p2005w35 USING btree (collection_id);

CREATE INDEX items_search_p2005w35_datetime_id_idx ON pgstac.items_search_p2005w35 USING btree (datetime, id);

CREATE INDEX items_search_p2005w35_geometry_idx ON pgstac.items_search_p2005w35 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w35_pkey ON pgstac.items_search_p2005w35 USING btree (id);

CREATE INDEX items_search_p2005w35_properties_idx ON pgstac.items_search_p2005w35 USING gin (properties);

CREATE INDEX items_search_p2005w36_collection_id_idx ON pgstac.items_search_p2005w36 USING btree (collection_id);

CREATE INDEX items_search_p2005w36_datetime_id_idx ON pgstac.items_search_p2005w36 USING btree (datetime, id);

CREATE INDEX items_search_p2005w36_geometry_idx ON pgstac.items_search_p2005w36 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w36_pkey ON pgstac.items_search_p2005w36 USING btree (id);

CREATE INDEX items_search_p2005w36_properties_idx ON pgstac.items_search_p2005w36 USING gin (properties);

CREATE INDEX items_search_p2005w37_collection_id_idx ON pgstac.items_search_p2005w37 USING btree (collection_id);

CREATE INDEX items_search_p2005w37_datetime_id_idx ON pgstac.items_search_p2005w37 USING btree (datetime, id);

CREATE INDEX items_search_p2005w37_geometry_idx ON pgstac.items_search_p2005w37 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w37_pkey ON pgstac.items_search_p2005w37 USING btree (id);

CREATE INDEX items_search_p2005w37_properties_idx ON pgstac.items_search_p2005w37 USING gin (properties);

CREATE INDEX items_search_p2005w38_collection_id_idx ON pgstac.items_search_p2005w38 USING btree (collection_id);

CREATE INDEX items_search_p2005w38_datetime_id_idx ON pgstac.items_search_p2005w38 USING btree (datetime, id);

CREATE INDEX items_search_p2005w38_geometry_idx ON pgstac.items_search_p2005w38 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w38_pkey ON pgstac.items_search_p2005w38 USING btree (id);

CREATE INDEX items_search_p2005w38_properties_idx ON pgstac.items_search_p2005w38 USING gin (properties);

CREATE INDEX items_search_p2005w39_collection_id_idx ON pgstac.items_search_p2005w39 USING btree (collection_id);

CREATE INDEX items_search_p2005w39_datetime_id_idx ON pgstac.items_search_p2005w39 USING btree (datetime, id);

CREATE INDEX items_search_p2005w39_geometry_idx ON pgstac.items_search_p2005w39 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w39_pkey ON pgstac.items_search_p2005w39 USING btree (id);

CREATE INDEX items_search_p2005w39_properties_idx ON pgstac.items_search_p2005w39 USING gin (properties);

CREATE INDEX items_search_p2005w40_collection_id_idx ON pgstac.items_search_p2005w40 USING btree (collection_id);

CREATE INDEX items_search_p2005w40_datetime_id_idx ON pgstac.items_search_p2005w40 USING btree (datetime, id);

CREATE INDEX items_search_p2005w40_geometry_idx ON pgstac.items_search_p2005w40 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w40_pkey ON pgstac.items_search_p2005w40 USING btree (id);

CREATE INDEX items_search_p2005w40_properties_idx ON pgstac.items_search_p2005w40 USING gin (properties);

CREATE INDEX items_search_p2005w41_collection_id_idx ON pgstac.items_search_p2005w41 USING btree (collection_id);

CREATE INDEX items_search_p2005w41_datetime_id_idx ON pgstac.items_search_p2005w41 USING btree (datetime, id);

CREATE INDEX items_search_p2005w41_geometry_idx ON pgstac.items_search_p2005w41 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w41_pkey ON pgstac.items_search_p2005w41 USING btree (id);

CREATE INDEX items_search_p2005w41_properties_idx ON pgstac.items_search_p2005w41 USING gin (properties);

CREATE INDEX items_search_p2005w42_collection_id_idx ON pgstac.items_search_p2005w42 USING btree (collection_id);

CREATE INDEX items_search_p2005w42_datetime_id_idx ON pgstac.items_search_p2005w42 USING btree (datetime, id);

CREATE INDEX items_search_p2005w42_geometry_idx ON pgstac.items_search_p2005w42 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w42_pkey ON pgstac.items_search_p2005w42 USING btree (id);

CREATE INDEX items_search_p2005w42_properties_idx ON pgstac.items_search_p2005w42 USING gin (properties);

CREATE INDEX items_search_p2005w43_collection_id_idx ON pgstac.items_search_p2005w43 USING btree (collection_id);

CREATE INDEX items_search_p2005w43_datetime_id_idx ON pgstac.items_search_p2005w43 USING btree (datetime, id);

CREATE INDEX items_search_p2005w43_geometry_idx ON pgstac.items_search_p2005w43 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w43_pkey ON pgstac.items_search_p2005w43 USING btree (id);

CREATE INDEX items_search_p2005w43_properties_idx ON pgstac.items_search_p2005w43 USING gin (properties);

CREATE INDEX items_search_p2005w44_collection_id_idx ON pgstac.items_search_p2005w44 USING btree (collection_id);

CREATE INDEX items_search_p2005w44_datetime_id_idx ON pgstac.items_search_p2005w44 USING btree (datetime, id);

CREATE INDEX items_search_p2005w44_geometry_idx ON pgstac.items_search_p2005w44 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w44_pkey ON pgstac.items_search_p2005w44 USING btree (id);

CREATE INDEX items_search_p2005w44_properties_idx ON pgstac.items_search_p2005w44 USING gin (properties);

CREATE INDEX items_search_p2005w45_collection_id_idx ON pgstac.items_search_p2005w45 USING btree (collection_id);

CREATE INDEX items_search_p2005w45_datetime_id_idx ON pgstac.items_search_p2005w45 USING btree (datetime, id);

CREATE INDEX items_search_p2005w45_geometry_idx ON pgstac.items_search_p2005w45 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w45_pkey ON pgstac.items_search_p2005w45 USING btree (id);

CREATE INDEX items_search_p2005w45_properties_idx ON pgstac.items_search_p2005w45 USING gin (properties);

CREATE INDEX items_search_p2005w46_collection_id_idx ON pgstac.items_search_p2005w46 USING btree (collection_id);

CREATE INDEX items_search_p2005w46_datetime_id_idx ON pgstac.items_search_p2005w46 USING btree (datetime, id);

CREATE INDEX items_search_p2005w46_geometry_idx ON pgstac.items_search_p2005w46 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w46_pkey ON pgstac.items_search_p2005w46 USING btree (id);

CREATE INDEX items_search_p2005w46_properties_idx ON pgstac.items_search_p2005w46 USING gin (properties);

CREATE INDEX items_search_p2005w47_collection_id_idx ON pgstac.items_search_p2005w47 USING btree (collection_id);

CREATE INDEX items_search_p2005w47_datetime_id_idx ON pgstac.items_search_p2005w47 USING btree (datetime, id);

CREATE INDEX items_search_p2005w47_geometry_idx ON pgstac.items_search_p2005w47 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w47_pkey ON pgstac.items_search_p2005w47 USING btree (id);

CREATE INDEX items_search_p2005w47_properties_idx ON pgstac.items_search_p2005w47 USING gin (properties);

CREATE INDEX items_search_p2005w48_collection_id_idx ON pgstac.items_search_p2005w48 USING btree (collection_id);

CREATE INDEX items_search_p2005w48_datetime_id_idx ON pgstac.items_search_p2005w48 USING btree (datetime, id);

CREATE INDEX items_search_p2005w48_geometry_idx ON pgstac.items_search_p2005w48 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w48_pkey ON pgstac.items_search_p2005w48 USING btree (id);

CREATE INDEX items_search_p2005w48_properties_idx ON pgstac.items_search_p2005w48 USING gin (properties);

CREATE INDEX items_search_p2005w49_collection_id_idx ON pgstac.items_search_p2005w49 USING btree (collection_id);

CREATE INDEX items_search_p2005w49_datetime_id_idx ON pgstac.items_search_p2005w49 USING btree (datetime, id);

CREATE INDEX items_search_p2005w49_geometry_idx ON pgstac.items_search_p2005w49 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w49_pkey ON pgstac.items_search_p2005w49 USING btree (id);

CREATE INDEX items_search_p2005w49_properties_idx ON pgstac.items_search_p2005w49 USING gin (properties);

CREATE INDEX items_search_p2005w50_collection_id_idx ON pgstac.items_search_p2005w50 USING btree (collection_id);

CREATE INDEX items_search_p2005w50_datetime_id_idx ON pgstac.items_search_p2005w50 USING btree (datetime, id);

CREATE INDEX items_search_p2005w50_geometry_idx ON pgstac.items_search_p2005w50 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w50_pkey ON pgstac.items_search_p2005w50 USING btree (id);

CREATE INDEX items_search_p2005w50_properties_idx ON pgstac.items_search_p2005w50 USING gin (properties);

CREATE INDEX items_search_p2005w51_collection_id_idx ON pgstac.items_search_p2005w51 USING btree (collection_id);

CREATE INDEX items_search_p2005w51_datetime_id_idx ON pgstac.items_search_p2005w51 USING btree (datetime, id);

CREATE INDEX items_search_p2005w51_geometry_idx ON pgstac.items_search_p2005w51 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w51_pkey ON pgstac.items_search_p2005w51 USING btree (id);

CREATE INDEX items_search_p2005w51_properties_idx ON pgstac.items_search_p2005w51 USING gin (properties);

CREATE INDEX items_search_p2005w52_collection_id_idx ON pgstac.items_search_p2005w52 USING btree (collection_id);

CREATE INDEX items_search_p2005w52_datetime_id_idx ON pgstac.items_search_p2005w52 USING btree (datetime, id);

CREATE INDEX items_search_p2005w52_geometry_idx ON pgstac.items_search_p2005w52 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2005w52_pkey ON pgstac.items_search_p2005w52 USING btree (id);

CREATE INDEX items_search_p2005w52_properties_idx ON pgstac.items_search_p2005w52 USING gin (properties);

CREATE INDEX items_search_p2006w01_collection_id_idx ON pgstac.items_search_p2006w01 USING btree (collection_id);

CREATE INDEX items_search_p2006w01_datetime_id_idx ON pgstac.items_search_p2006w01 USING btree (datetime, id);

CREATE INDEX items_search_p2006w01_geometry_idx ON pgstac.items_search_p2006w01 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w01_pkey ON pgstac.items_search_p2006w01 USING btree (id);

CREATE INDEX items_search_p2006w01_properties_idx ON pgstac.items_search_p2006w01 USING gin (properties);

CREATE INDEX items_search_p2006w02_collection_id_idx ON pgstac.items_search_p2006w02 USING btree (collection_id);

CREATE INDEX items_search_p2006w02_datetime_id_idx ON pgstac.items_search_p2006w02 USING btree (datetime, id);

CREATE INDEX items_search_p2006w02_geometry_idx ON pgstac.items_search_p2006w02 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w02_pkey ON pgstac.items_search_p2006w02 USING btree (id);

CREATE INDEX items_search_p2006w02_properties_idx ON pgstac.items_search_p2006w02 USING gin (properties);

CREATE INDEX items_search_p2006w03_collection_id_idx ON pgstac.items_search_p2006w03 USING btree (collection_id);

CREATE INDEX items_search_p2006w03_datetime_id_idx ON pgstac.items_search_p2006w03 USING btree (datetime, id);

CREATE INDEX items_search_p2006w03_geometry_idx ON pgstac.items_search_p2006w03 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w03_pkey ON pgstac.items_search_p2006w03 USING btree (id);

CREATE INDEX items_search_p2006w03_properties_idx ON pgstac.items_search_p2006w03 USING gin (properties);

CREATE INDEX items_search_p2006w04_collection_id_idx ON pgstac.items_search_p2006w04 USING btree (collection_id);

CREATE INDEX items_search_p2006w04_datetime_id_idx ON pgstac.items_search_p2006w04 USING btree (datetime, id);

CREATE INDEX items_search_p2006w04_geometry_idx ON pgstac.items_search_p2006w04 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w04_pkey ON pgstac.items_search_p2006w04 USING btree (id);

CREATE INDEX items_search_p2006w04_properties_idx ON pgstac.items_search_p2006w04 USING gin (properties);

CREATE INDEX items_search_p2006w05_collection_id_idx ON pgstac.items_search_p2006w05 USING btree (collection_id);

CREATE INDEX items_search_p2006w05_datetime_id_idx ON pgstac.items_search_p2006w05 USING btree (datetime, id);

CREATE INDEX items_search_p2006w05_geometry_idx ON pgstac.items_search_p2006w05 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w05_pkey ON pgstac.items_search_p2006w05 USING btree (id);

CREATE INDEX items_search_p2006w05_properties_idx ON pgstac.items_search_p2006w05 USING gin (properties);

CREATE INDEX items_search_p2006w06_collection_id_idx ON pgstac.items_search_p2006w06 USING btree (collection_id);

CREATE INDEX items_search_p2006w06_datetime_id_idx ON pgstac.items_search_p2006w06 USING btree (datetime, id);

CREATE INDEX items_search_p2006w06_geometry_idx ON pgstac.items_search_p2006w06 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w06_pkey ON pgstac.items_search_p2006w06 USING btree (id);

CREATE INDEX items_search_p2006w06_properties_idx ON pgstac.items_search_p2006w06 USING gin (properties);

CREATE INDEX items_search_p2006w07_collection_id_idx ON pgstac.items_search_p2006w07 USING btree (collection_id);

CREATE INDEX items_search_p2006w07_datetime_id_idx ON pgstac.items_search_p2006w07 USING btree (datetime, id);

CREATE INDEX items_search_p2006w07_geometry_idx ON pgstac.items_search_p2006w07 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w07_pkey ON pgstac.items_search_p2006w07 USING btree (id);

CREATE INDEX items_search_p2006w07_properties_idx ON pgstac.items_search_p2006w07 USING gin (properties);

CREATE INDEX items_search_p2006w08_collection_id_idx ON pgstac.items_search_p2006w08 USING btree (collection_id);

CREATE INDEX items_search_p2006w08_datetime_id_idx ON pgstac.items_search_p2006w08 USING btree (datetime, id);

CREATE INDEX items_search_p2006w08_geometry_idx ON pgstac.items_search_p2006w08 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w08_pkey ON pgstac.items_search_p2006w08 USING btree (id);

CREATE INDEX items_search_p2006w08_properties_idx ON pgstac.items_search_p2006w08 USING gin (properties);

CREATE INDEX items_search_p2006w09_collection_id_idx ON pgstac.items_search_p2006w09 USING btree (collection_id);

CREATE INDEX items_search_p2006w09_datetime_id_idx ON pgstac.items_search_p2006w09 USING btree (datetime, id);

CREATE INDEX items_search_p2006w09_geometry_idx ON pgstac.items_search_p2006w09 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w09_pkey ON pgstac.items_search_p2006w09 USING btree (id);

CREATE INDEX items_search_p2006w09_properties_idx ON pgstac.items_search_p2006w09 USING gin (properties);

CREATE INDEX items_search_p2006w10_collection_id_idx ON pgstac.items_search_p2006w10 USING btree (collection_id);

CREATE INDEX items_search_p2006w10_datetime_id_idx ON pgstac.items_search_p2006w10 USING btree (datetime, id);

CREATE INDEX items_search_p2006w10_geometry_idx ON pgstac.items_search_p2006w10 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w10_pkey ON pgstac.items_search_p2006w10 USING btree (id);

CREATE INDEX items_search_p2006w10_properties_idx ON pgstac.items_search_p2006w10 USING gin (properties);

CREATE INDEX items_search_p2006w11_collection_id_idx ON pgstac.items_search_p2006w11 USING btree (collection_id);

CREATE INDEX items_search_p2006w11_datetime_id_idx ON pgstac.items_search_p2006w11 USING btree (datetime, id);

CREATE INDEX items_search_p2006w11_geometry_idx ON pgstac.items_search_p2006w11 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w11_pkey ON pgstac.items_search_p2006w11 USING btree (id);

CREATE INDEX items_search_p2006w11_properties_idx ON pgstac.items_search_p2006w11 USING gin (properties);

CREATE INDEX items_search_p2006w12_collection_id_idx ON pgstac.items_search_p2006w12 USING btree (collection_id);

CREATE INDEX items_search_p2006w12_datetime_id_idx ON pgstac.items_search_p2006w12 USING btree (datetime, id);

CREATE INDEX items_search_p2006w12_geometry_idx ON pgstac.items_search_p2006w12 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w12_pkey ON pgstac.items_search_p2006w12 USING btree (id);

CREATE INDEX items_search_p2006w12_properties_idx ON pgstac.items_search_p2006w12 USING gin (properties);

CREATE INDEX items_search_p2006w13_collection_id_idx ON pgstac.items_search_p2006w13 USING btree (collection_id);

CREATE INDEX items_search_p2006w13_datetime_id_idx ON pgstac.items_search_p2006w13 USING btree (datetime, id);

CREATE INDEX items_search_p2006w13_geometry_idx ON pgstac.items_search_p2006w13 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w13_pkey ON pgstac.items_search_p2006w13 USING btree (id);

CREATE INDEX items_search_p2006w13_properties_idx ON pgstac.items_search_p2006w13 USING gin (properties);

CREATE INDEX items_search_p2006w14_collection_id_idx ON pgstac.items_search_p2006w14 USING btree (collection_id);

CREATE INDEX items_search_p2006w14_datetime_id_idx ON pgstac.items_search_p2006w14 USING btree (datetime, id);

CREATE INDEX items_search_p2006w14_geometry_idx ON pgstac.items_search_p2006w14 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w14_pkey ON pgstac.items_search_p2006w14 USING btree (id);

CREATE INDEX items_search_p2006w14_properties_idx ON pgstac.items_search_p2006w14 USING gin (properties);

CREATE INDEX items_search_p2006w15_collection_id_idx ON pgstac.items_search_p2006w15 USING btree (collection_id);

CREATE INDEX items_search_p2006w15_datetime_id_idx ON pgstac.items_search_p2006w15 USING btree (datetime, id);

CREATE INDEX items_search_p2006w15_geometry_idx ON pgstac.items_search_p2006w15 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w15_pkey ON pgstac.items_search_p2006w15 USING btree (id);

CREATE INDEX items_search_p2006w15_properties_idx ON pgstac.items_search_p2006w15 USING gin (properties);

CREATE INDEX items_search_p2006w16_collection_id_idx ON pgstac.items_search_p2006w16 USING btree (collection_id);

CREATE INDEX items_search_p2006w16_datetime_id_idx ON pgstac.items_search_p2006w16 USING btree (datetime, id);

CREATE INDEX items_search_p2006w16_geometry_idx ON pgstac.items_search_p2006w16 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w16_pkey ON pgstac.items_search_p2006w16 USING btree (id);

CREATE INDEX items_search_p2006w16_properties_idx ON pgstac.items_search_p2006w16 USING gin (properties);

CREATE INDEX items_search_p2006w17_collection_id_idx ON pgstac.items_search_p2006w17 USING btree (collection_id);

CREATE INDEX items_search_p2006w17_datetime_id_idx ON pgstac.items_search_p2006w17 USING btree (datetime, id);

CREATE INDEX items_search_p2006w17_geometry_idx ON pgstac.items_search_p2006w17 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w17_pkey ON pgstac.items_search_p2006w17 USING btree (id);

CREATE INDEX items_search_p2006w17_properties_idx ON pgstac.items_search_p2006w17 USING gin (properties);

CREATE INDEX items_search_p2006w18_collection_id_idx ON pgstac.items_search_p2006w18 USING btree (collection_id);

CREATE INDEX items_search_p2006w18_datetime_id_idx ON pgstac.items_search_p2006w18 USING btree (datetime, id);

CREATE INDEX items_search_p2006w18_geometry_idx ON pgstac.items_search_p2006w18 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w18_pkey ON pgstac.items_search_p2006w18 USING btree (id);

CREATE INDEX items_search_p2006w18_properties_idx ON pgstac.items_search_p2006w18 USING gin (properties);

CREATE INDEX items_search_p2006w19_collection_id_idx ON pgstac.items_search_p2006w19 USING btree (collection_id);

CREATE INDEX items_search_p2006w19_datetime_id_idx ON pgstac.items_search_p2006w19 USING btree (datetime, id);

CREATE INDEX items_search_p2006w19_geometry_idx ON pgstac.items_search_p2006w19 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w19_pkey ON pgstac.items_search_p2006w19 USING btree (id);

CREATE INDEX items_search_p2006w19_properties_idx ON pgstac.items_search_p2006w19 USING gin (properties);

CREATE INDEX items_search_p2006w20_collection_id_idx ON pgstac.items_search_p2006w20 USING btree (collection_id);

CREATE INDEX items_search_p2006w20_datetime_id_idx ON pgstac.items_search_p2006w20 USING btree (datetime, id);

CREATE INDEX items_search_p2006w20_geometry_idx ON pgstac.items_search_p2006w20 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w20_pkey ON pgstac.items_search_p2006w20 USING btree (id);

CREATE INDEX items_search_p2006w20_properties_idx ON pgstac.items_search_p2006w20 USING gin (properties);

CREATE INDEX items_search_p2006w21_collection_id_idx ON pgstac.items_search_p2006w21 USING btree (collection_id);

CREATE INDEX items_search_p2006w21_datetime_id_idx ON pgstac.items_search_p2006w21 USING btree (datetime, id);

CREATE INDEX items_search_p2006w21_geometry_idx ON pgstac.items_search_p2006w21 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w21_pkey ON pgstac.items_search_p2006w21 USING btree (id);

CREATE INDEX items_search_p2006w21_properties_idx ON pgstac.items_search_p2006w21 USING gin (properties);

CREATE INDEX items_search_p2006w22_collection_id_idx ON pgstac.items_search_p2006w22 USING btree (collection_id);

CREATE INDEX items_search_p2006w22_datetime_id_idx ON pgstac.items_search_p2006w22 USING btree (datetime, id);

CREATE INDEX items_search_p2006w22_geometry_idx ON pgstac.items_search_p2006w22 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w22_pkey ON pgstac.items_search_p2006w22 USING btree (id);

CREATE INDEX items_search_p2006w22_properties_idx ON pgstac.items_search_p2006w22 USING gin (properties);

CREATE INDEX items_search_p2006w23_collection_id_idx ON pgstac.items_search_p2006w23 USING btree (collection_id);

CREATE INDEX items_search_p2006w23_datetime_id_idx ON pgstac.items_search_p2006w23 USING btree (datetime, id);

CREATE INDEX items_search_p2006w23_geometry_idx ON pgstac.items_search_p2006w23 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w23_pkey ON pgstac.items_search_p2006w23 USING btree (id);

CREATE INDEX items_search_p2006w23_properties_idx ON pgstac.items_search_p2006w23 USING gin (properties);

CREATE INDEX items_search_p2006w24_collection_id_idx ON pgstac.items_search_p2006w24 USING btree (collection_id);

CREATE INDEX items_search_p2006w24_datetime_id_idx ON pgstac.items_search_p2006w24 USING btree (datetime, id);

CREATE INDEX items_search_p2006w24_geometry_idx ON pgstac.items_search_p2006w24 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w24_pkey ON pgstac.items_search_p2006w24 USING btree (id);

CREATE INDEX items_search_p2006w24_properties_idx ON pgstac.items_search_p2006w24 USING gin (properties);

CREATE INDEX items_search_p2006w25_collection_id_idx ON pgstac.items_search_p2006w25 USING btree (collection_id);

CREATE INDEX items_search_p2006w25_datetime_id_idx ON pgstac.items_search_p2006w25 USING btree (datetime, id);

CREATE INDEX items_search_p2006w25_geometry_idx ON pgstac.items_search_p2006w25 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w25_pkey ON pgstac.items_search_p2006w25 USING btree (id);

CREATE INDEX items_search_p2006w25_properties_idx ON pgstac.items_search_p2006w25 USING gin (properties);

CREATE INDEX items_search_p2006w26_collection_id_idx ON pgstac.items_search_p2006w26 USING btree (collection_id);

CREATE INDEX items_search_p2006w26_datetime_id_idx ON pgstac.items_search_p2006w26 USING btree (datetime, id);

CREATE INDEX items_search_p2006w26_geometry_idx ON pgstac.items_search_p2006w26 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w26_pkey ON pgstac.items_search_p2006w26 USING btree (id);

CREATE INDEX items_search_p2006w26_properties_idx ON pgstac.items_search_p2006w26 USING gin (properties);

CREATE INDEX items_search_p2006w27_collection_id_idx ON pgstac.items_search_p2006w27 USING btree (collection_id);

CREATE INDEX items_search_p2006w27_datetime_id_idx ON pgstac.items_search_p2006w27 USING btree (datetime, id);

CREATE INDEX items_search_p2006w27_geometry_idx ON pgstac.items_search_p2006w27 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w27_pkey ON pgstac.items_search_p2006w27 USING btree (id);

CREATE INDEX items_search_p2006w27_properties_idx ON pgstac.items_search_p2006w27 USING gin (properties);

CREATE INDEX items_search_p2006w28_collection_id_idx ON pgstac.items_search_p2006w28 USING btree (collection_id);

CREATE INDEX items_search_p2006w28_datetime_id_idx ON pgstac.items_search_p2006w28 USING btree (datetime, id);

CREATE INDEX items_search_p2006w28_geometry_idx ON pgstac.items_search_p2006w28 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w28_pkey ON pgstac.items_search_p2006w28 USING btree (id);

CREATE INDEX items_search_p2006w28_properties_idx ON pgstac.items_search_p2006w28 USING gin (properties);

CREATE INDEX items_search_p2006w29_collection_id_idx ON pgstac.items_search_p2006w29 USING btree (collection_id);

CREATE INDEX items_search_p2006w29_datetime_id_idx ON pgstac.items_search_p2006w29 USING btree (datetime, id);

CREATE INDEX items_search_p2006w29_geometry_idx ON pgstac.items_search_p2006w29 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w29_pkey ON pgstac.items_search_p2006w29 USING btree (id);

CREATE INDEX items_search_p2006w29_properties_idx ON pgstac.items_search_p2006w29 USING gin (properties);

CREATE INDEX items_search_p2006w30_collection_id_idx ON pgstac.items_search_p2006w30 USING btree (collection_id);

CREATE INDEX items_search_p2006w30_datetime_id_idx ON pgstac.items_search_p2006w30 USING btree (datetime, id);

CREATE INDEX items_search_p2006w30_geometry_idx ON pgstac.items_search_p2006w30 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w30_pkey ON pgstac.items_search_p2006w30 USING btree (id);

CREATE INDEX items_search_p2006w30_properties_idx ON pgstac.items_search_p2006w30 USING gin (properties);

CREATE INDEX items_search_p2006w31_collection_id_idx ON pgstac.items_search_p2006w31 USING btree (collection_id);

CREATE INDEX items_search_p2006w31_datetime_id_idx ON pgstac.items_search_p2006w31 USING btree (datetime, id);

CREATE INDEX items_search_p2006w31_geometry_idx ON pgstac.items_search_p2006w31 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w31_pkey ON pgstac.items_search_p2006w31 USING btree (id);

CREATE INDEX items_search_p2006w31_properties_idx ON pgstac.items_search_p2006w31 USING gin (properties);

CREATE INDEX items_search_p2006w32_collection_id_idx ON pgstac.items_search_p2006w32 USING btree (collection_id);

CREATE INDEX items_search_p2006w32_datetime_id_idx ON pgstac.items_search_p2006w32 USING btree (datetime, id);

CREATE INDEX items_search_p2006w32_geometry_idx ON pgstac.items_search_p2006w32 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w32_pkey ON pgstac.items_search_p2006w32 USING btree (id);

CREATE INDEX items_search_p2006w32_properties_idx ON pgstac.items_search_p2006w32 USING gin (properties);

CREATE INDEX items_search_p2006w33_collection_id_idx ON pgstac.items_search_p2006w33 USING btree (collection_id);

CREATE INDEX items_search_p2006w33_datetime_id_idx ON pgstac.items_search_p2006w33 USING btree (datetime, id);

CREATE INDEX items_search_p2006w33_geometry_idx ON pgstac.items_search_p2006w33 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w33_pkey ON pgstac.items_search_p2006w33 USING btree (id);

CREATE INDEX items_search_p2006w33_properties_idx ON pgstac.items_search_p2006w33 USING gin (properties);

CREATE INDEX items_search_p2006w34_collection_id_idx ON pgstac.items_search_p2006w34 USING btree (collection_id);

CREATE INDEX items_search_p2006w34_datetime_id_idx ON pgstac.items_search_p2006w34 USING btree (datetime, id);

CREATE INDEX items_search_p2006w34_geometry_idx ON pgstac.items_search_p2006w34 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w34_pkey ON pgstac.items_search_p2006w34 USING btree (id);

CREATE INDEX items_search_p2006w34_properties_idx ON pgstac.items_search_p2006w34 USING gin (properties);

CREATE INDEX items_search_p2006w35_collection_id_idx ON pgstac.items_search_p2006w35 USING btree (collection_id);

CREATE INDEX items_search_p2006w35_datetime_id_idx ON pgstac.items_search_p2006w35 USING btree (datetime, id);

CREATE INDEX items_search_p2006w35_geometry_idx ON pgstac.items_search_p2006w35 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w35_pkey ON pgstac.items_search_p2006w35 USING btree (id);

CREATE INDEX items_search_p2006w35_properties_idx ON pgstac.items_search_p2006w35 USING gin (properties);

CREATE INDEX items_search_p2006w36_collection_id_idx ON pgstac.items_search_p2006w36 USING btree (collection_id);

CREATE INDEX items_search_p2006w36_datetime_id_idx ON pgstac.items_search_p2006w36 USING btree (datetime, id);

CREATE INDEX items_search_p2006w36_geometry_idx ON pgstac.items_search_p2006w36 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w36_pkey ON pgstac.items_search_p2006w36 USING btree (id);

CREATE INDEX items_search_p2006w36_properties_idx ON pgstac.items_search_p2006w36 USING gin (properties);

CREATE INDEX items_search_p2006w37_collection_id_idx ON pgstac.items_search_p2006w37 USING btree (collection_id);

CREATE INDEX items_search_p2006w37_datetime_id_idx ON pgstac.items_search_p2006w37 USING btree (datetime, id);

CREATE INDEX items_search_p2006w37_geometry_idx ON pgstac.items_search_p2006w37 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w37_pkey ON pgstac.items_search_p2006w37 USING btree (id);

CREATE INDEX items_search_p2006w37_properties_idx ON pgstac.items_search_p2006w37 USING gin (properties);

CREATE INDEX items_search_p2006w38_collection_id_idx ON pgstac.items_search_p2006w38 USING btree (collection_id);

CREATE INDEX items_search_p2006w38_datetime_id_idx ON pgstac.items_search_p2006w38 USING btree (datetime, id);

CREATE INDEX items_search_p2006w38_geometry_idx ON pgstac.items_search_p2006w38 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w38_pkey ON pgstac.items_search_p2006w38 USING btree (id);

CREATE INDEX items_search_p2006w38_properties_idx ON pgstac.items_search_p2006w38 USING gin (properties);

CREATE INDEX items_search_p2006w39_collection_id_idx ON pgstac.items_search_p2006w39 USING btree (collection_id);

CREATE INDEX items_search_p2006w39_datetime_id_idx ON pgstac.items_search_p2006w39 USING btree (datetime, id);

CREATE INDEX items_search_p2006w39_geometry_idx ON pgstac.items_search_p2006w39 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w39_pkey ON pgstac.items_search_p2006w39 USING btree (id);

CREATE INDEX items_search_p2006w39_properties_idx ON pgstac.items_search_p2006w39 USING gin (properties);

CREATE INDEX items_search_p2006w40_collection_id_idx ON pgstac.items_search_p2006w40 USING btree (collection_id);

CREATE INDEX items_search_p2006w40_datetime_id_idx ON pgstac.items_search_p2006w40 USING btree (datetime, id);

CREATE INDEX items_search_p2006w40_geometry_idx ON pgstac.items_search_p2006w40 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w40_pkey ON pgstac.items_search_p2006w40 USING btree (id);

CREATE INDEX items_search_p2006w40_properties_idx ON pgstac.items_search_p2006w40 USING gin (properties);

CREATE INDEX items_search_p2006w41_collection_id_idx ON pgstac.items_search_p2006w41 USING btree (collection_id);

CREATE INDEX items_search_p2006w41_datetime_id_idx ON pgstac.items_search_p2006w41 USING btree (datetime, id);

CREATE INDEX items_search_p2006w41_geometry_idx ON pgstac.items_search_p2006w41 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w41_pkey ON pgstac.items_search_p2006w41 USING btree (id);

CREATE INDEX items_search_p2006w41_properties_idx ON pgstac.items_search_p2006w41 USING gin (properties);

CREATE INDEX items_search_p2006w42_collection_id_idx ON pgstac.items_search_p2006w42 USING btree (collection_id);

CREATE INDEX items_search_p2006w42_datetime_id_idx ON pgstac.items_search_p2006w42 USING btree (datetime, id);

CREATE INDEX items_search_p2006w42_geometry_idx ON pgstac.items_search_p2006w42 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w42_pkey ON pgstac.items_search_p2006w42 USING btree (id);

CREATE INDEX items_search_p2006w42_properties_idx ON pgstac.items_search_p2006w42 USING gin (properties);

CREATE INDEX items_search_p2006w43_collection_id_idx ON pgstac.items_search_p2006w43 USING btree (collection_id);

CREATE INDEX items_search_p2006w43_datetime_id_idx ON pgstac.items_search_p2006w43 USING btree (datetime, id);

CREATE INDEX items_search_p2006w43_geometry_idx ON pgstac.items_search_p2006w43 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w43_pkey ON pgstac.items_search_p2006w43 USING btree (id);

CREATE INDEX items_search_p2006w43_properties_idx ON pgstac.items_search_p2006w43 USING gin (properties);

CREATE INDEX items_search_p2006w44_collection_id_idx ON pgstac.items_search_p2006w44 USING btree (collection_id);

CREATE INDEX items_search_p2006w44_datetime_id_idx ON pgstac.items_search_p2006w44 USING btree (datetime, id);

CREATE INDEX items_search_p2006w44_geometry_idx ON pgstac.items_search_p2006w44 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w44_pkey ON pgstac.items_search_p2006w44 USING btree (id);

CREATE INDEX items_search_p2006w44_properties_idx ON pgstac.items_search_p2006w44 USING gin (properties);

CREATE INDEX items_search_p2006w45_collection_id_idx ON pgstac.items_search_p2006w45 USING btree (collection_id);

CREATE INDEX items_search_p2006w45_datetime_id_idx ON pgstac.items_search_p2006w45 USING btree (datetime, id);

CREATE INDEX items_search_p2006w45_geometry_idx ON pgstac.items_search_p2006w45 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w45_pkey ON pgstac.items_search_p2006w45 USING btree (id);

CREATE INDEX items_search_p2006w45_properties_idx ON pgstac.items_search_p2006w45 USING gin (properties);

CREATE INDEX items_search_p2006w46_collection_id_idx ON pgstac.items_search_p2006w46 USING btree (collection_id);

CREATE INDEX items_search_p2006w46_datetime_id_idx ON pgstac.items_search_p2006w46 USING btree (datetime, id);

CREATE INDEX items_search_p2006w46_geometry_idx ON pgstac.items_search_p2006w46 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w46_pkey ON pgstac.items_search_p2006w46 USING btree (id);

CREATE INDEX items_search_p2006w46_properties_idx ON pgstac.items_search_p2006w46 USING gin (properties);

CREATE INDEX items_search_p2006w47_collection_id_idx ON pgstac.items_search_p2006w47 USING btree (collection_id);

CREATE INDEX items_search_p2006w47_datetime_id_idx ON pgstac.items_search_p2006w47 USING btree (datetime, id);

CREATE INDEX items_search_p2006w47_geometry_idx ON pgstac.items_search_p2006w47 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w47_pkey ON pgstac.items_search_p2006w47 USING btree (id);

CREATE INDEX items_search_p2006w47_properties_idx ON pgstac.items_search_p2006w47 USING gin (properties);

CREATE INDEX items_search_p2006w48_collection_id_idx ON pgstac.items_search_p2006w48 USING btree (collection_id);

CREATE INDEX items_search_p2006w48_datetime_id_idx ON pgstac.items_search_p2006w48 USING btree (datetime, id);

CREATE INDEX items_search_p2006w48_geometry_idx ON pgstac.items_search_p2006w48 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w48_pkey ON pgstac.items_search_p2006w48 USING btree (id);

CREATE INDEX items_search_p2006w48_properties_idx ON pgstac.items_search_p2006w48 USING gin (properties);

CREATE INDEX items_search_p2006w49_collection_id_idx ON pgstac.items_search_p2006w49 USING btree (collection_id);

CREATE INDEX items_search_p2006w49_datetime_id_idx ON pgstac.items_search_p2006w49 USING btree (datetime, id);

CREATE INDEX items_search_p2006w49_geometry_idx ON pgstac.items_search_p2006w49 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w49_pkey ON pgstac.items_search_p2006w49 USING btree (id);

CREATE INDEX items_search_p2006w49_properties_idx ON pgstac.items_search_p2006w49 USING gin (properties);

CREATE INDEX items_search_p2006w50_collection_id_idx ON pgstac.items_search_p2006w50 USING btree (collection_id);

CREATE INDEX items_search_p2006w50_datetime_id_idx ON pgstac.items_search_p2006w50 USING btree (datetime, id);

CREATE INDEX items_search_p2006w50_geometry_idx ON pgstac.items_search_p2006w50 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w50_pkey ON pgstac.items_search_p2006w50 USING btree (id);

CREATE INDEX items_search_p2006w50_properties_idx ON pgstac.items_search_p2006w50 USING gin (properties);

CREATE INDEX items_search_p2006w51_collection_id_idx ON pgstac.items_search_p2006w51 USING btree (collection_id);

CREATE INDEX items_search_p2006w51_datetime_id_idx ON pgstac.items_search_p2006w51 USING btree (datetime, id);

CREATE INDEX items_search_p2006w51_geometry_idx ON pgstac.items_search_p2006w51 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w51_pkey ON pgstac.items_search_p2006w51 USING btree (id);

CREATE INDEX items_search_p2006w51_properties_idx ON pgstac.items_search_p2006w51 USING gin (properties);

CREATE INDEX items_search_p2006w52_collection_id_idx ON pgstac.items_search_p2006w52 USING btree (collection_id);

CREATE INDEX items_search_p2006w52_datetime_id_idx ON pgstac.items_search_p2006w52 USING btree (datetime, id);

CREATE INDEX items_search_p2006w52_geometry_idx ON pgstac.items_search_p2006w52 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2006w52_pkey ON pgstac.items_search_p2006w52 USING btree (id);

CREATE INDEX items_search_p2006w52_properties_idx ON pgstac.items_search_p2006w52 USING gin (properties);

CREATE INDEX items_search_p2007w01_collection_id_idx ON pgstac.items_search_p2007w01 USING btree (collection_id);

CREATE INDEX items_search_p2007w01_datetime_id_idx ON pgstac.items_search_p2007w01 USING btree (datetime, id);

CREATE INDEX items_search_p2007w01_geometry_idx ON pgstac.items_search_p2007w01 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w01_pkey ON pgstac.items_search_p2007w01 USING btree (id);

CREATE INDEX items_search_p2007w01_properties_idx ON pgstac.items_search_p2007w01 USING gin (properties);

CREATE INDEX items_search_p2007w02_collection_id_idx ON pgstac.items_search_p2007w02 USING btree (collection_id);

CREATE INDEX items_search_p2007w02_datetime_id_idx ON pgstac.items_search_p2007w02 USING btree (datetime, id);

CREATE INDEX items_search_p2007w02_geometry_idx ON pgstac.items_search_p2007w02 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w02_pkey ON pgstac.items_search_p2007w02 USING btree (id);

CREATE INDEX items_search_p2007w02_properties_idx ON pgstac.items_search_p2007w02 USING gin (properties);

CREATE INDEX items_search_p2007w03_collection_id_idx ON pgstac.items_search_p2007w03 USING btree (collection_id);

CREATE INDEX items_search_p2007w03_datetime_id_idx ON pgstac.items_search_p2007w03 USING btree (datetime, id);

CREATE INDEX items_search_p2007w03_geometry_idx ON pgstac.items_search_p2007w03 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w03_pkey ON pgstac.items_search_p2007w03 USING btree (id);

CREATE INDEX items_search_p2007w03_properties_idx ON pgstac.items_search_p2007w03 USING gin (properties);

CREATE INDEX items_search_p2007w04_collection_id_idx ON pgstac.items_search_p2007w04 USING btree (collection_id);

CREATE INDEX items_search_p2007w04_datetime_id_idx ON pgstac.items_search_p2007w04 USING btree (datetime, id);

CREATE INDEX items_search_p2007w04_geometry_idx ON pgstac.items_search_p2007w04 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w04_pkey ON pgstac.items_search_p2007w04 USING btree (id);

CREATE INDEX items_search_p2007w04_properties_idx ON pgstac.items_search_p2007w04 USING gin (properties);

CREATE INDEX items_search_p2007w05_collection_id_idx ON pgstac.items_search_p2007w05 USING btree (collection_id);

CREATE INDEX items_search_p2007w05_datetime_id_idx ON pgstac.items_search_p2007w05 USING btree (datetime, id);

CREATE INDEX items_search_p2007w05_geometry_idx ON pgstac.items_search_p2007w05 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w05_pkey ON pgstac.items_search_p2007w05 USING btree (id);

CREATE INDEX items_search_p2007w05_properties_idx ON pgstac.items_search_p2007w05 USING gin (properties);

CREATE INDEX items_search_p2007w06_collection_id_idx ON pgstac.items_search_p2007w06 USING btree (collection_id);

CREATE INDEX items_search_p2007w06_datetime_id_idx ON pgstac.items_search_p2007w06 USING btree (datetime, id);

CREATE INDEX items_search_p2007w06_geometry_idx ON pgstac.items_search_p2007w06 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w06_pkey ON pgstac.items_search_p2007w06 USING btree (id);

CREATE INDEX items_search_p2007w06_properties_idx ON pgstac.items_search_p2007w06 USING gin (properties);

CREATE INDEX items_search_p2007w07_collection_id_idx ON pgstac.items_search_p2007w07 USING btree (collection_id);

CREATE INDEX items_search_p2007w07_datetime_id_idx ON pgstac.items_search_p2007w07 USING btree (datetime, id);

CREATE INDEX items_search_p2007w07_geometry_idx ON pgstac.items_search_p2007w07 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w07_pkey ON pgstac.items_search_p2007w07 USING btree (id);

CREATE INDEX items_search_p2007w07_properties_idx ON pgstac.items_search_p2007w07 USING gin (properties);

CREATE INDEX items_search_p2007w08_collection_id_idx ON pgstac.items_search_p2007w08 USING btree (collection_id);

CREATE INDEX items_search_p2007w08_datetime_id_idx ON pgstac.items_search_p2007w08 USING btree (datetime, id);

CREATE INDEX items_search_p2007w08_geometry_idx ON pgstac.items_search_p2007w08 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w08_pkey ON pgstac.items_search_p2007w08 USING btree (id);

CREATE INDEX items_search_p2007w08_properties_idx ON pgstac.items_search_p2007w08 USING gin (properties);

CREATE INDEX items_search_p2007w09_collection_id_idx ON pgstac.items_search_p2007w09 USING btree (collection_id);

CREATE INDEX items_search_p2007w09_datetime_id_idx ON pgstac.items_search_p2007w09 USING btree (datetime, id);

CREATE INDEX items_search_p2007w09_geometry_idx ON pgstac.items_search_p2007w09 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w09_pkey ON pgstac.items_search_p2007w09 USING btree (id);

CREATE INDEX items_search_p2007w09_properties_idx ON pgstac.items_search_p2007w09 USING gin (properties);

CREATE INDEX items_search_p2007w10_collection_id_idx ON pgstac.items_search_p2007w10 USING btree (collection_id);

CREATE INDEX items_search_p2007w10_datetime_id_idx ON pgstac.items_search_p2007w10 USING btree (datetime, id);

CREATE INDEX items_search_p2007w10_geometry_idx ON pgstac.items_search_p2007w10 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w10_pkey ON pgstac.items_search_p2007w10 USING btree (id);

CREATE INDEX items_search_p2007w10_properties_idx ON pgstac.items_search_p2007w10 USING gin (properties);

CREATE INDEX items_search_p2007w11_collection_id_idx ON pgstac.items_search_p2007w11 USING btree (collection_id);

CREATE INDEX items_search_p2007w11_datetime_id_idx ON pgstac.items_search_p2007w11 USING btree (datetime, id);

CREATE INDEX items_search_p2007w11_geometry_idx ON pgstac.items_search_p2007w11 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w11_pkey ON pgstac.items_search_p2007w11 USING btree (id);

CREATE INDEX items_search_p2007w11_properties_idx ON pgstac.items_search_p2007w11 USING gin (properties);

CREATE INDEX items_search_p2007w12_collection_id_idx ON pgstac.items_search_p2007w12 USING btree (collection_id);

CREATE INDEX items_search_p2007w12_datetime_id_idx ON pgstac.items_search_p2007w12 USING btree (datetime, id);

CREATE INDEX items_search_p2007w12_geometry_idx ON pgstac.items_search_p2007w12 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w12_pkey ON pgstac.items_search_p2007w12 USING btree (id);

CREATE INDEX items_search_p2007w12_properties_idx ON pgstac.items_search_p2007w12 USING gin (properties);

CREATE INDEX items_search_p2007w13_collection_id_idx ON pgstac.items_search_p2007w13 USING btree (collection_id);

CREATE INDEX items_search_p2007w13_datetime_id_idx ON pgstac.items_search_p2007w13 USING btree (datetime, id);

CREATE INDEX items_search_p2007w13_geometry_idx ON pgstac.items_search_p2007w13 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w13_pkey ON pgstac.items_search_p2007w13 USING btree (id);

CREATE INDEX items_search_p2007w13_properties_idx ON pgstac.items_search_p2007w13 USING gin (properties);

CREATE INDEX items_search_p2007w14_collection_id_idx ON pgstac.items_search_p2007w14 USING btree (collection_id);

CREATE INDEX items_search_p2007w14_datetime_id_idx ON pgstac.items_search_p2007w14 USING btree (datetime, id);

CREATE INDEX items_search_p2007w14_geometry_idx ON pgstac.items_search_p2007w14 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w14_pkey ON pgstac.items_search_p2007w14 USING btree (id);

CREATE INDEX items_search_p2007w14_properties_idx ON pgstac.items_search_p2007w14 USING gin (properties);

CREATE INDEX items_search_p2007w15_collection_id_idx ON pgstac.items_search_p2007w15 USING btree (collection_id);

CREATE INDEX items_search_p2007w15_datetime_id_idx ON pgstac.items_search_p2007w15 USING btree (datetime, id);

CREATE INDEX items_search_p2007w15_geometry_idx ON pgstac.items_search_p2007w15 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w15_pkey ON pgstac.items_search_p2007w15 USING btree (id);

CREATE INDEX items_search_p2007w15_properties_idx ON pgstac.items_search_p2007w15 USING gin (properties);

CREATE INDEX items_search_p2007w16_collection_id_idx ON pgstac.items_search_p2007w16 USING btree (collection_id);

CREATE INDEX items_search_p2007w16_datetime_id_idx ON pgstac.items_search_p2007w16 USING btree (datetime, id);

CREATE INDEX items_search_p2007w16_geometry_idx ON pgstac.items_search_p2007w16 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w16_pkey ON pgstac.items_search_p2007w16 USING btree (id);

CREATE INDEX items_search_p2007w16_properties_idx ON pgstac.items_search_p2007w16 USING gin (properties);

CREATE INDEX items_search_p2007w17_collection_id_idx ON pgstac.items_search_p2007w17 USING btree (collection_id);

CREATE INDEX items_search_p2007w17_datetime_id_idx ON pgstac.items_search_p2007w17 USING btree (datetime, id);

CREATE INDEX items_search_p2007w17_geometry_idx ON pgstac.items_search_p2007w17 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w17_pkey ON pgstac.items_search_p2007w17 USING btree (id);

CREATE INDEX items_search_p2007w17_properties_idx ON pgstac.items_search_p2007w17 USING gin (properties);

CREATE INDEX items_search_p2007w18_collection_id_idx ON pgstac.items_search_p2007w18 USING btree (collection_id);

CREATE INDEX items_search_p2007w18_datetime_id_idx ON pgstac.items_search_p2007w18 USING btree (datetime, id);

CREATE INDEX items_search_p2007w18_geometry_idx ON pgstac.items_search_p2007w18 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w18_pkey ON pgstac.items_search_p2007w18 USING btree (id);

CREATE INDEX items_search_p2007w18_properties_idx ON pgstac.items_search_p2007w18 USING gin (properties);

CREATE INDEX items_search_p2007w19_collection_id_idx ON pgstac.items_search_p2007w19 USING btree (collection_id);

CREATE INDEX items_search_p2007w19_datetime_id_idx ON pgstac.items_search_p2007w19 USING btree (datetime, id);

CREATE INDEX items_search_p2007w19_geometry_idx ON pgstac.items_search_p2007w19 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w19_pkey ON pgstac.items_search_p2007w19 USING btree (id);

CREATE INDEX items_search_p2007w19_properties_idx ON pgstac.items_search_p2007w19 USING gin (properties);

CREATE INDEX items_search_p2007w20_collection_id_idx ON pgstac.items_search_p2007w20 USING btree (collection_id);

CREATE INDEX items_search_p2007w20_datetime_id_idx ON pgstac.items_search_p2007w20 USING btree (datetime, id);

CREATE INDEX items_search_p2007w20_geometry_idx ON pgstac.items_search_p2007w20 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w20_pkey ON pgstac.items_search_p2007w20 USING btree (id);

CREATE INDEX items_search_p2007w20_properties_idx ON pgstac.items_search_p2007w20 USING gin (properties);

CREATE INDEX items_search_p2007w21_collection_id_idx ON pgstac.items_search_p2007w21 USING btree (collection_id);

CREATE INDEX items_search_p2007w21_datetime_id_idx ON pgstac.items_search_p2007w21 USING btree (datetime, id);

CREATE INDEX items_search_p2007w21_geometry_idx ON pgstac.items_search_p2007w21 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w21_pkey ON pgstac.items_search_p2007w21 USING btree (id);

CREATE INDEX items_search_p2007w21_properties_idx ON pgstac.items_search_p2007w21 USING gin (properties);

CREATE INDEX items_search_p2007w22_collection_id_idx ON pgstac.items_search_p2007w22 USING btree (collection_id);

CREATE INDEX items_search_p2007w22_datetime_id_idx ON pgstac.items_search_p2007w22 USING btree (datetime, id);

CREATE INDEX items_search_p2007w22_geometry_idx ON pgstac.items_search_p2007w22 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w22_pkey ON pgstac.items_search_p2007w22 USING btree (id);

CREATE INDEX items_search_p2007w22_properties_idx ON pgstac.items_search_p2007w22 USING gin (properties);

CREATE INDEX items_search_p2007w23_collection_id_idx ON pgstac.items_search_p2007w23 USING btree (collection_id);

CREATE INDEX items_search_p2007w23_datetime_id_idx ON pgstac.items_search_p2007w23 USING btree (datetime, id);

CREATE INDEX items_search_p2007w23_geometry_idx ON pgstac.items_search_p2007w23 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w23_pkey ON pgstac.items_search_p2007w23 USING btree (id);

CREATE INDEX items_search_p2007w23_properties_idx ON pgstac.items_search_p2007w23 USING gin (properties);

CREATE INDEX items_search_p2007w24_collection_id_idx ON pgstac.items_search_p2007w24 USING btree (collection_id);

CREATE INDEX items_search_p2007w24_datetime_id_idx ON pgstac.items_search_p2007w24 USING btree (datetime, id);

CREATE INDEX items_search_p2007w24_geometry_idx ON pgstac.items_search_p2007w24 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w24_pkey ON pgstac.items_search_p2007w24 USING btree (id);

CREATE INDEX items_search_p2007w24_properties_idx ON pgstac.items_search_p2007w24 USING gin (properties);

CREATE INDEX items_search_p2007w25_collection_id_idx ON pgstac.items_search_p2007w25 USING btree (collection_id);

CREATE INDEX items_search_p2007w25_datetime_id_idx ON pgstac.items_search_p2007w25 USING btree (datetime, id);

CREATE INDEX items_search_p2007w25_geometry_idx ON pgstac.items_search_p2007w25 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w25_pkey ON pgstac.items_search_p2007w25 USING btree (id);

CREATE INDEX items_search_p2007w25_properties_idx ON pgstac.items_search_p2007w25 USING gin (properties);

CREATE INDEX items_search_p2007w26_collection_id_idx ON pgstac.items_search_p2007w26 USING btree (collection_id);

CREATE INDEX items_search_p2007w26_datetime_id_idx ON pgstac.items_search_p2007w26 USING btree (datetime, id);

CREATE INDEX items_search_p2007w26_geometry_idx ON pgstac.items_search_p2007w26 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w26_pkey ON pgstac.items_search_p2007w26 USING btree (id);

CREATE INDEX items_search_p2007w26_properties_idx ON pgstac.items_search_p2007w26 USING gin (properties);

CREATE INDEX items_search_p2007w27_collection_id_idx ON pgstac.items_search_p2007w27 USING btree (collection_id);

CREATE INDEX items_search_p2007w27_datetime_id_idx ON pgstac.items_search_p2007w27 USING btree (datetime, id);

CREATE INDEX items_search_p2007w27_geometry_idx ON pgstac.items_search_p2007w27 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w27_pkey ON pgstac.items_search_p2007w27 USING btree (id);

CREATE INDEX items_search_p2007w27_properties_idx ON pgstac.items_search_p2007w27 USING gin (properties);

CREATE INDEX items_search_p2007w28_collection_id_idx ON pgstac.items_search_p2007w28 USING btree (collection_id);

CREATE INDEX items_search_p2007w28_datetime_id_idx ON pgstac.items_search_p2007w28 USING btree (datetime, id);

CREATE INDEX items_search_p2007w28_geometry_idx ON pgstac.items_search_p2007w28 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w28_pkey ON pgstac.items_search_p2007w28 USING btree (id);

CREATE INDEX items_search_p2007w28_properties_idx ON pgstac.items_search_p2007w28 USING gin (properties);

CREATE INDEX items_search_p2007w29_collection_id_idx ON pgstac.items_search_p2007w29 USING btree (collection_id);

CREATE INDEX items_search_p2007w29_datetime_id_idx ON pgstac.items_search_p2007w29 USING btree (datetime, id);

CREATE INDEX items_search_p2007w29_geometry_idx ON pgstac.items_search_p2007w29 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w29_pkey ON pgstac.items_search_p2007w29 USING btree (id);

CREATE INDEX items_search_p2007w29_properties_idx ON pgstac.items_search_p2007w29 USING gin (properties);

CREATE INDEX items_search_p2007w30_collection_id_idx ON pgstac.items_search_p2007w30 USING btree (collection_id);

CREATE INDEX items_search_p2007w30_datetime_id_idx ON pgstac.items_search_p2007w30 USING btree (datetime, id);

CREATE INDEX items_search_p2007w30_geometry_idx ON pgstac.items_search_p2007w30 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w30_pkey ON pgstac.items_search_p2007w30 USING btree (id);

CREATE INDEX items_search_p2007w30_properties_idx ON pgstac.items_search_p2007w30 USING gin (properties);

CREATE INDEX items_search_p2007w31_collection_id_idx ON pgstac.items_search_p2007w31 USING btree (collection_id);

CREATE INDEX items_search_p2007w31_datetime_id_idx ON pgstac.items_search_p2007w31 USING btree (datetime, id);

CREATE INDEX items_search_p2007w31_geometry_idx ON pgstac.items_search_p2007w31 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w31_pkey ON pgstac.items_search_p2007w31 USING btree (id);

CREATE INDEX items_search_p2007w31_properties_idx ON pgstac.items_search_p2007w31 USING gin (properties);

CREATE INDEX items_search_p2007w32_collection_id_idx ON pgstac.items_search_p2007w32 USING btree (collection_id);

CREATE INDEX items_search_p2007w32_datetime_id_idx ON pgstac.items_search_p2007w32 USING btree (datetime, id);

CREATE INDEX items_search_p2007w32_geometry_idx ON pgstac.items_search_p2007w32 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w32_pkey ON pgstac.items_search_p2007w32 USING btree (id);

CREATE INDEX items_search_p2007w32_properties_idx ON pgstac.items_search_p2007w32 USING gin (properties);

CREATE INDEX items_search_p2007w33_collection_id_idx ON pgstac.items_search_p2007w33 USING btree (collection_id);

CREATE INDEX items_search_p2007w33_datetime_id_idx ON pgstac.items_search_p2007w33 USING btree (datetime, id);

CREATE INDEX items_search_p2007w33_geometry_idx ON pgstac.items_search_p2007w33 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w33_pkey ON pgstac.items_search_p2007w33 USING btree (id);

CREATE INDEX items_search_p2007w33_properties_idx ON pgstac.items_search_p2007w33 USING gin (properties);

CREATE INDEX items_search_p2007w34_collection_id_idx ON pgstac.items_search_p2007w34 USING btree (collection_id);

CREATE INDEX items_search_p2007w34_datetime_id_idx ON pgstac.items_search_p2007w34 USING btree (datetime, id);

CREATE INDEX items_search_p2007w34_geometry_idx ON pgstac.items_search_p2007w34 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w34_pkey ON pgstac.items_search_p2007w34 USING btree (id);

CREATE INDEX items_search_p2007w34_properties_idx ON pgstac.items_search_p2007w34 USING gin (properties);

CREATE INDEX items_search_p2007w35_collection_id_idx ON pgstac.items_search_p2007w35 USING btree (collection_id);

CREATE INDEX items_search_p2007w35_datetime_id_idx ON pgstac.items_search_p2007w35 USING btree (datetime, id);

CREATE INDEX items_search_p2007w35_geometry_idx ON pgstac.items_search_p2007w35 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w35_pkey ON pgstac.items_search_p2007w35 USING btree (id);

CREATE INDEX items_search_p2007w35_properties_idx ON pgstac.items_search_p2007w35 USING gin (properties);

CREATE INDEX items_search_p2007w36_collection_id_idx ON pgstac.items_search_p2007w36 USING btree (collection_id);

CREATE INDEX items_search_p2007w36_datetime_id_idx ON pgstac.items_search_p2007w36 USING btree (datetime, id);

CREATE INDEX items_search_p2007w36_geometry_idx ON pgstac.items_search_p2007w36 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w36_pkey ON pgstac.items_search_p2007w36 USING btree (id);

CREATE INDEX items_search_p2007w36_properties_idx ON pgstac.items_search_p2007w36 USING gin (properties);

CREATE INDEX items_search_p2007w37_collection_id_idx ON pgstac.items_search_p2007w37 USING btree (collection_id);

CREATE INDEX items_search_p2007w37_datetime_id_idx ON pgstac.items_search_p2007w37 USING btree (datetime, id);

CREATE INDEX items_search_p2007w37_geometry_idx ON pgstac.items_search_p2007w37 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w37_pkey ON pgstac.items_search_p2007w37 USING btree (id);

CREATE INDEX items_search_p2007w37_properties_idx ON pgstac.items_search_p2007w37 USING gin (properties);

CREATE INDEX items_search_p2007w38_collection_id_idx ON pgstac.items_search_p2007w38 USING btree (collection_id);

CREATE INDEX items_search_p2007w38_datetime_id_idx ON pgstac.items_search_p2007w38 USING btree (datetime, id);

CREATE INDEX items_search_p2007w38_geometry_idx ON pgstac.items_search_p2007w38 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w38_pkey ON pgstac.items_search_p2007w38 USING btree (id);

CREATE INDEX items_search_p2007w38_properties_idx ON pgstac.items_search_p2007w38 USING gin (properties);

CREATE INDEX items_search_p2007w39_collection_id_idx ON pgstac.items_search_p2007w39 USING btree (collection_id);

CREATE INDEX items_search_p2007w39_datetime_id_idx ON pgstac.items_search_p2007w39 USING btree (datetime, id);

CREATE INDEX items_search_p2007w39_geometry_idx ON pgstac.items_search_p2007w39 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w39_pkey ON pgstac.items_search_p2007w39 USING btree (id);

CREATE INDEX items_search_p2007w39_properties_idx ON pgstac.items_search_p2007w39 USING gin (properties);

CREATE INDEX items_search_p2007w40_collection_id_idx ON pgstac.items_search_p2007w40 USING btree (collection_id);

CREATE INDEX items_search_p2007w40_datetime_id_idx ON pgstac.items_search_p2007w40 USING btree (datetime, id);

CREATE INDEX items_search_p2007w40_geometry_idx ON pgstac.items_search_p2007w40 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w40_pkey ON pgstac.items_search_p2007w40 USING btree (id);

CREATE INDEX items_search_p2007w40_properties_idx ON pgstac.items_search_p2007w40 USING gin (properties);

CREATE INDEX items_search_p2007w41_collection_id_idx ON pgstac.items_search_p2007w41 USING btree (collection_id);

CREATE INDEX items_search_p2007w41_datetime_id_idx ON pgstac.items_search_p2007w41 USING btree (datetime, id);

CREATE INDEX items_search_p2007w41_geometry_idx ON pgstac.items_search_p2007w41 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w41_pkey ON pgstac.items_search_p2007w41 USING btree (id);

CREATE INDEX items_search_p2007w41_properties_idx ON pgstac.items_search_p2007w41 USING gin (properties);

CREATE INDEX items_search_p2007w42_collection_id_idx ON pgstac.items_search_p2007w42 USING btree (collection_id);

CREATE INDEX items_search_p2007w42_datetime_id_idx ON pgstac.items_search_p2007w42 USING btree (datetime, id);

CREATE INDEX items_search_p2007w42_geometry_idx ON pgstac.items_search_p2007w42 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w42_pkey ON pgstac.items_search_p2007w42 USING btree (id);

CREATE INDEX items_search_p2007w42_properties_idx ON pgstac.items_search_p2007w42 USING gin (properties);

CREATE INDEX items_search_p2007w43_collection_id_idx ON pgstac.items_search_p2007w43 USING btree (collection_id);

CREATE INDEX items_search_p2007w43_datetime_id_idx ON pgstac.items_search_p2007w43 USING btree (datetime, id);

CREATE INDEX items_search_p2007w43_geometry_idx ON pgstac.items_search_p2007w43 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w43_pkey ON pgstac.items_search_p2007w43 USING btree (id);

CREATE INDEX items_search_p2007w43_properties_idx ON pgstac.items_search_p2007w43 USING gin (properties);

CREATE INDEX items_search_p2007w44_collection_id_idx ON pgstac.items_search_p2007w44 USING btree (collection_id);

CREATE INDEX items_search_p2007w44_datetime_id_idx ON pgstac.items_search_p2007w44 USING btree (datetime, id);

CREATE INDEX items_search_p2007w44_geometry_idx ON pgstac.items_search_p2007w44 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w44_pkey ON pgstac.items_search_p2007w44 USING btree (id);

CREATE INDEX items_search_p2007w44_properties_idx ON pgstac.items_search_p2007w44 USING gin (properties);

CREATE INDEX items_search_p2007w45_collection_id_idx ON pgstac.items_search_p2007w45 USING btree (collection_id);

CREATE INDEX items_search_p2007w45_datetime_id_idx ON pgstac.items_search_p2007w45 USING btree (datetime, id);

CREATE INDEX items_search_p2007w45_geometry_idx ON pgstac.items_search_p2007w45 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w45_pkey ON pgstac.items_search_p2007w45 USING btree (id);

CREATE INDEX items_search_p2007w45_properties_idx ON pgstac.items_search_p2007w45 USING gin (properties);

CREATE INDEX items_search_p2007w46_collection_id_idx ON pgstac.items_search_p2007w46 USING btree (collection_id);

CREATE INDEX items_search_p2007w46_datetime_id_idx ON pgstac.items_search_p2007w46 USING btree (datetime, id);

CREATE INDEX items_search_p2007w46_geometry_idx ON pgstac.items_search_p2007w46 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w46_pkey ON pgstac.items_search_p2007w46 USING btree (id);

CREATE INDEX items_search_p2007w46_properties_idx ON pgstac.items_search_p2007w46 USING gin (properties);

CREATE INDEX items_search_p2007w47_collection_id_idx ON pgstac.items_search_p2007w47 USING btree (collection_id);

CREATE INDEX items_search_p2007w47_datetime_id_idx ON pgstac.items_search_p2007w47 USING btree (datetime, id);

CREATE INDEX items_search_p2007w47_geometry_idx ON pgstac.items_search_p2007w47 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w47_pkey ON pgstac.items_search_p2007w47 USING btree (id);

CREATE INDEX items_search_p2007w47_properties_idx ON pgstac.items_search_p2007w47 USING gin (properties);

CREATE INDEX items_search_p2007w48_collection_id_idx ON pgstac.items_search_p2007w48 USING btree (collection_id);

CREATE INDEX items_search_p2007w48_datetime_id_idx ON pgstac.items_search_p2007w48 USING btree (datetime, id);

CREATE INDEX items_search_p2007w48_geometry_idx ON pgstac.items_search_p2007w48 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w48_pkey ON pgstac.items_search_p2007w48 USING btree (id);

CREATE INDEX items_search_p2007w48_properties_idx ON pgstac.items_search_p2007w48 USING gin (properties);

CREATE INDEX items_search_p2007w49_collection_id_idx ON pgstac.items_search_p2007w49 USING btree (collection_id);

CREATE INDEX items_search_p2007w49_datetime_id_idx ON pgstac.items_search_p2007w49 USING btree (datetime, id);

CREATE INDEX items_search_p2007w49_geometry_idx ON pgstac.items_search_p2007w49 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w49_pkey ON pgstac.items_search_p2007w49 USING btree (id);

CREATE INDEX items_search_p2007w49_properties_idx ON pgstac.items_search_p2007w49 USING gin (properties);

CREATE INDEX items_search_p2007w50_collection_id_idx ON pgstac.items_search_p2007w50 USING btree (collection_id);

CREATE INDEX items_search_p2007w50_datetime_id_idx ON pgstac.items_search_p2007w50 USING btree (datetime, id);

CREATE INDEX items_search_p2007w50_geometry_idx ON pgstac.items_search_p2007w50 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w50_pkey ON pgstac.items_search_p2007w50 USING btree (id);

CREATE INDEX items_search_p2007w50_properties_idx ON pgstac.items_search_p2007w50 USING gin (properties);

CREATE INDEX items_search_p2007w51_collection_id_idx ON pgstac.items_search_p2007w51 USING btree (collection_id);

CREATE INDEX items_search_p2007w51_datetime_id_idx ON pgstac.items_search_p2007w51 USING btree (datetime, id);

CREATE INDEX items_search_p2007w51_geometry_idx ON pgstac.items_search_p2007w51 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w51_pkey ON pgstac.items_search_p2007w51 USING btree (id);

CREATE INDEX items_search_p2007w51_properties_idx ON pgstac.items_search_p2007w51 USING gin (properties);

CREATE INDEX items_search_p2007w52_collection_id_idx ON pgstac.items_search_p2007w52 USING btree (collection_id);

CREATE INDEX items_search_p2007w52_datetime_id_idx ON pgstac.items_search_p2007w52 USING btree (datetime, id);

CREATE INDEX items_search_p2007w52_geometry_idx ON pgstac.items_search_p2007w52 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2007w52_pkey ON pgstac.items_search_p2007w52 USING btree (id);

CREATE INDEX items_search_p2007w52_properties_idx ON pgstac.items_search_p2007w52 USING gin (properties);

CREATE INDEX items_search_p2008w01_collection_id_idx ON pgstac.items_search_p2008w01 USING btree (collection_id);

CREATE INDEX items_search_p2008w01_datetime_id_idx ON pgstac.items_search_p2008w01 USING btree (datetime, id);

CREATE INDEX items_search_p2008w01_geometry_idx ON pgstac.items_search_p2008w01 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w01_pkey ON pgstac.items_search_p2008w01 USING btree (id);

CREATE INDEX items_search_p2008w01_properties_idx ON pgstac.items_search_p2008w01 USING gin (properties);

CREATE INDEX items_search_p2008w02_collection_id_idx ON pgstac.items_search_p2008w02 USING btree (collection_id);

CREATE INDEX items_search_p2008w02_datetime_id_idx ON pgstac.items_search_p2008w02 USING btree (datetime, id);

CREATE INDEX items_search_p2008w02_geometry_idx ON pgstac.items_search_p2008w02 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w02_pkey ON pgstac.items_search_p2008w02 USING btree (id);

CREATE INDEX items_search_p2008w02_properties_idx ON pgstac.items_search_p2008w02 USING gin (properties);

CREATE INDEX items_search_p2008w03_collection_id_idx ON pgstac.items_search_p2008w03 USING btree (collection_id);

CREATE INDEX items_search_p2008w03_datetime_id_idx ON pgstac.items_search_p2008w03 USING btree (datetime, id);

CREATE INDEX items_search_p2008w03_geometry_idx ON pgstac.items_search_p2008w03 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w03_pkey ON pgstac.items_search_p2008w03 USING btree (id);

CREATE INDEX items_search_p2008w03_properties_idx ON pgstac.items_search_p2008w03 USING gin (properties);

CREATE INDEX items_search_p2008w04_collection_id_idx ON pgstac.items_search_p2008w04 USING btree (collection_id);

CREATE INDEX items_search_p2008w04_datetime_id_idx ON pgstac.items_search_p2008w04 USING btree (datetime, id);

CREATE INDEX items_search_p2008w04_geometry_idx ON pgstac.items_search_p2008w04 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w04_pkey ON pgstac.items_search_p2008w04 USING btree (id);

CREATE INDEX items_search_p2008w04_properties_idx ON pgstac.items_search_p2008w04 USING gin (properties);

CREATE INDEX items_search_p2008w05_collection_id_idx ON pgstac.items_search_p2008w05 USING btree (collection_id);

CREATE INDEX items_search_p2008w05_datetime_id_idx ON pgstac.items_search_p2008w05 USING btree (datetime, id);

CREATE INDEX items_search_p2008w05_geometry_idx ON pgstac.items_search_p2008w05 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w05_pkey ON pgstac.items_search_p2008w05 USING btree (id);

CREATE INDEX items_search_p2008w05_properties_idx ON pgstac.items_search_p2008w05 USING gin (properties);

CREATE INDEX items_search_p2008w06_collection_id_idx ON pgstac.items_search_p2008w06 USING btree (collection_id);

CREATE INDEX items_search_p2008w06_datetime_id_idx ON pgstac.items_search_p2008w06 USING btree (datetime, id);

CREATE INDEX items_search_p2008w06_geometry_idx ON pgstac.items_search_p2008w06 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w06_pkey ON pgstac.items_search_p2008w06 USING btree (id);

CREATE INDEX items_search_p2008w06_properties_idx ON pgstac.items_search_p2008w06 USING gin (properties);

CREATE INDEX items_search_p2008w07_collection_id_idx ON pgstac.items_search_p2008w07 USING btree (collection_id);

CREATE INDEX items_search_p2008w07_datetime_id_idx ON pgstac.items_search_p2008w07 USING btree (datetime, id);

CREATE INDEX items_search_p2008w07_geometry_idx ON pgstac.items_search_p2008w07 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w07_pkey ON pgstac.items_search_p2008w07 USING btree (id);

CREATE INDEX items_search_p2008w07_properties_idx ON pgstac.items_search_p2008w07 USING gin (properties);

CREATE INDEX items_search_p2008w08_collection_id_idx ON pgstac.items_search_p2008w08 USING btree (collection_id);

CREATE INDEX items_search_p2008w08_datetime_id_idx ON pgstac.items_search_p2008w08 USING btree (datetime, id);

CREATE INDEX items_search_p2008w08_geometry_idx ON pgstac.items_search_p2008w08 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w08_pkey ON pgstac.items_search_p2008w08 USING btree (id);

CREATE INDEX items_search_p2008w08_properties_idx ON pgstac.items_search_p2008w08 USING gin (properties);

CREATE INDEX items_search_p2008w09_collection_id_idx ON pgstac.items_search_p2008w09 USING btree (collection_id);

CREATE INDEX items_search_p2008w09_datetime_id_idx ON pgstac.items_search_p2008w09 USING btree (datetime, id);

CREATE INDEX items_search_p2008w09_geometry_idx ON pgstac.items_search_p2008w09 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w09_pkey ON pgstac.items_search_p2008w09 USING btree (id);

CREATE INDEX items_search_p2008w09_properties_idx ON pgstac.items_search_p2008w09 USING gin (properties);

CREATE INDEX items_search_p2008w10_collection_id_idx ON pgstac.items_search_p2008w10 USING btree (collection_id);

CREATE INDEX items_search_p2008w10_datetime_id_idx ON pgstac.items_search_p2008w10 USING btree (datetime, id);

CREATE INDEX items_search_p2008w10_geometry_idx ON pgstac.items_search_p2008w10 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w10_pkey ON pgstac.items_search_p2008w10 USING btree (id);

CREATE INDEX items_search_p2008w10_properties_idx ON pgstac.items_search_p2008w10 USING gin (properties);

CREATE INDEX items_search_p2008w11_collection_id_idx ON pgstac.items_search_p2008w11 USING btree (collection_id);

CREATE INDEX items_search_p2008w11_datetime_id_idx ON pgstac.items_search_p2008w11 USING btree (datetime, id);

CREATE INDEX items_search_p2008w11_geometry_idx ON pgstac.items_search_p2008w11 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w11_pkey ON pgstac.items_search_p2008w11 USING btree (id);

CREATE INDEX items_search_p2008w11_properties_idx ON pgstac.items_search_p2008w11 USING gin (properties);

CREATE INDEX items_search_p2008w12_collection_id_idx ON pgstac.items_search_p2008w12 USING btree (collection_id);

CREATE INDEX items_search_p2008w12_datetime_id_idx ON pgstac.items_search_p2008w12 USING btree (datetime, id);

CREATE INDEX items_search_p2008w12_geometry_idx ON pgstac.items_search_p2008w12 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w12_pkey ON pgstac.items_search_p2008w12 USING btree (id);

CREATE INDEX items_search_p2008w12_properties_idx ON pgstac.items_search_p2008w12 USING gin (properties);

CREATE INDEX items_search_p2008w13_collection_id_idx ON pgstac.items_search_p2008w13 USING btree (collection_id);

CREATE INDEX items_search_p2008w13_datetime_id_idx ON pgstac.items_search_p2008w13 USING btree (datetime, id);

CREATE INDEX items_search_p2008w13_geometry_idx ON pgstac.items_search_p2008w13 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w13_pkey ON pgstac.items_search_p2008w13 USING btree (id);

CREATE INDEX items_search_p2008w13_properties_idx ON pgstac.items_search_p2008w13 USING gin (properties);

CREATE INDEX items_search_p2008w14_collection_id_idx ON pgstac.items_search_p2008w14 USING btree (collection_id);

CREATE INDEX items_search_p2008w14_datetime_id_idx ON pgstac.items_search_p2008w14 USING btree (datetime, id);

CREATE INDEX items_search_p2008w14_geometry_idx ON pgstac.items_search_p2008w14 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w14_pkey ON pgstac.items_search_p2008w14 USING btree (id);

CREATE INDEX items_search_p2008w14_properties_idx ON pgstac.items_search_p2008w14 USING gin (properties);

CREATE INDEX items_search_p2008w15_collection_id_idx ON pgstac.items_search_p2008w15 USING btree (collection_id);

CREATE INDEX items_search_p2008w15_datetime_id_idx ON pgstac.items_search_p2008w15 USING btree (datetime, id);

CREATE INDEX items_search_p2008w15_geometry_idx ON pgstac.items_search_p2008w15 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w15_pkey ON pgstac.items_search_p2008w15 USING btree (id);

CREATE INDEX items_search_p2008w15_properties_idx ON pgstac.items_search_p2008w15 USING gin (properties);

CREATE INDEX items_search_p2008w16_collection_id_idx ON pgstac.items_search_p2008w16 USING btree (collection_id);

CREATE INDEX items_search_p2008w16_datetime_id_idx ON pgstac.items_search_p2008w16 USING btree (datetime, id);

CREATE INDEX items_search_p2008w16_geometry_idx ON pgstac.items_search_p2008w16 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w16_pkey ON pgstac.items_search_p2008w16 USING btree (id);

CREATE INDEX items_search_p2008w16_properties_idx ON pgstac.items_search_p2008w16 USING gin (properties);

CREATE INDEX items_search_p2008w17_collection_id_idx ON pgstac.items_search_p2008w17 USING btree (collection_id);

CREATE INDEX items_search_p2008w17_datetime_id_idx ON pgstac.items_search_p2008w17 USING btree (datetime, id);

CREATE INDEX items_search_p2008w17_geometry_idx ON pgstac.items_search_p2008w17 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w17_pkey ON pgstac.items_search_p2008w17 USING btree (id);

CREATE INDEX items_search_p2008w17_properties_idx ON pgstac.items_search_p2008w17 USING gin (properties);

CREATE INDEX items_search_p2008w18_collection_id_idx ON pgstac.items_search_p2008w18 USING btree (collection_id);

CREATE INDEX items_search_p2008w18_datetime_id_idx ON pgstac.items_search_p2008w18 USING btree (datetime, id);

CREATE INDEX items_search_p2008w18_geometry_idx ON pgstac.items_search_p2008w18 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w18_pkey ON pgstac.items_search_p2008w18 USING btree (id);

CREATE INDEX items_search_p2008w18_properties_idx ON pgstac.items_search_p2008w18 USING gin (properties);

CREATE INDEX items_search_p2008w19_collection_id_idx ON pgstac.items_search_p2008w19 USING btree (collection_id);

CREATE INDEX items_search_p2008w19_datetime_id_idx ON pgstac.items_search_p2008w19 USING btree (datetime, id);

CREATE INDEX items_search_p2008w19_geometry_idx ON pgstac.items_search_p2008w19 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w19_pkey ON pgstac.items_search_p2008w19 USING btree (id);

CREATE INDEX items_search_p2008w19_properties_idx ON pgstac.items_search_p2008w19 USING gin (properties);

CREATE INDEX items_search_p2008w20_collection_id_idx ON pgstac.items_search_p2008w20 USING btree (collection_id);

CREATE INDEX items_search_p2008w20_datetime_id_idx ON pgstac.items_search_p2008w20 USING btree (datetime, id);

CREATE INDEX items_search_p2008w20_geometry_idx ON pgstac.items_search_p2008w20 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w20_pkey ON pgstac.items_search_p2008w20 USING btree (id);

CREATE INDEX items_search_p2008w20_properties_idx ON pgstac.items_search_p2008w20 USING gin (properties);

CREATE INDEX items_search_p2008w21_collection_id_idx ON pgstac.items_search_p2008w21 USING btree (collection_id);

CREATE INDEX items_search_p2008w21_datetime_id_idx ON pgstac.items_search_p2008w21 USING btree (datetime, id);

CREATE INDEX items_search_p2008w21_geometry_idx ON pgstac.items_search_p2008w21 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w21_pkey ON pgstac.items_search_p2008w21 USING btree (id);

CREATE INDEX items_search_p2008w21_properties_idx ON pgstac.items_search_p2008w21 USING gin (properties);

CREATE INDEX items_search_p2008w22_collection_id_idx ON pgstac.items_search_p2008w22 USING btree (collection_id);

CREATE INDEX items_search_p2008w22_datetime_id_idx ON pgstac.items_search_p2008w22 USING btree (datetime, id);

CREATE INDEX items_search_p2008w22_geometry_idx ON pgstac.items_search_p2008w22 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w22_pkey ON pgstac.items_search_p2008w22 USING btree (id);

CREATE INDEX items_search_p2008w22_properties_idx ON pgstac.items_search_p2008w22 USING gin (properties);

CREATE INDEX items_search_p2008w23_collection_id_idx ON pgstac.items_search_p2008w23 USING btree (collection_id);

CREATE INDEX items_search_p2008w23_datetime_id_idx ON pgstac.items_search_p2008w23 USING btree (datetime, id);

CREATE INDEX items_search_p2008w23_geometry_idx ON pgstac.items_search_p2008w23 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w23_pkey ON pgstac.items_search_p2008w23 USING btree (id);

CREATE INDEX items_search_p2008w23_properties_idx ON pgstac.items_search_p2008w23 USING gin (properties);

CREATE INDEX items_search_p2008w24_collection_id_idx ON pgstac.items_search_p2008w24 USING btree (collection_id);

CREATE INDEX items_search_p2008w24_datetime_id_idx ON pgstac.items_search_p2008w24 USING btree (datetime, id);

CREATE INDEX items_search_p2008w24_geometry_idx ON pgstac.items_search_p2008w24 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w24_pkey ON pgstac.items_search_p2008w24 USING btree (id);

CREATE INDEX items_search_p2008w24_properties_idx ON pgstac.items_search_p2008w24 USING gin (properties);

CREATE INDEX items_search_p2008w25_collection_id_idx ON pgstac.items_search_p2008w25 USING btree (collection_id);

CREATE INDEX items_search_p2008w25_datetime_id_idx ON pgstac.items_search_p2008w25 USING btree (datetime, id);

CREATE INDEX items_search_p2008w25_geometry_idx ON pgstac.items_search_p2008w25 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w25_pkey ON pgstac.items_search_p2008w25 USING btree (id);

CREATE INDEX items_search_p2008w25_properties_idx ON pgstac.items_search_p2008w25 USING gin (properties);

CREATE INDEX items_search_p2008w26_collection_id_idx ON pgstac.items_search_p2008w26 USING btree (collection_id);

CREATE INDEX items_search_p2008w26_datetime_id_idx ON pgstac.items_search_p2008w26 USING btree (datetime, id);

CREATE INDEX items_search_p2008w26_geometry_idx ON pgstac.items_search_p2008w26 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w26_pkey ON pgstac.items_search_p2008w26 USING btree (id);

CREATE INDEX items_search_p2008w26_properties_idx ON pgstac.items_search_p2008w26 USING gin (properties);

CREATE INDEX items_search_p2008w27_collection_id_idx ON pgstac.items_search_p2008w27 USING btree (collection_id);

CREATE INDEX items_search_p2008w27_datetime_id_idx ON pgstac.items_search_p2008w27 USING btree (datetime, id);

CREATE INDEX items_search_p2008w27_geometry_idx ON pgstac.items_search_p2008w27 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w27_pkey ON pgstac.items_search_p2008w27 USING btree (id);

CREATE INDEX items_search_p2008w27_properties_idx ON pgstac.items_search_p2008w27 USING gin (properties);

CREATE INDEX items_search_p2008w28_collection_id_idx ON pgstac.items_search_p2008w28 USING btree (collection_id);

CREATE INDEX items_search_p2008w28_datetime_id_idx ON pgstac.items_search_p2008w28 USING btree (datetime, id);

CREATE INDEX items_search_p2008w28_geometry_idx ON pgstac.items_search_p2008w28 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w28_pkey ON pgstac.items_search_p2008w28 USING btree (id);

CREATE INDEX items_search_p2008w28_properties_idx ON pgstac.items_search_p2008w28 USING gin (properties);

CREATE INDEX items_search_p2008w29_collection_id_idx ON pgstac.items_search_p2008w29 USING btree (collection_id);

CREATE INDEX items_search_p2008w29_datetime_id_idx ON pgstac.items_search_p2008w29 USING btree (datetime, id);

CREATE INDEX items_search_p2008w29_geometry_idx ON pgstac.items_search_p2008w29 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w29_pkey ON pgstac.items_search_p2008w29 USING btree (id);

CREATE INDEX items_search_p2008w29_properties_idx ON pgstac.items_search_p2008w29 USING gin (properties);

CREATE INDEX items_search_p2008w30_collection_id_idx ON pgstac.items_search_p2008w30 USING btree (collection_id);

CREATE INDEX items_search_p2008w30_datetime_id_idx ON pgstac.items_search_p2008w30 USING btree (datetime, id);

CREATE INDEX items_search_p2008w30_geometry_idx ON pgstac.items_search_p2008w30 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w30_pkey ON pgstac.items_search_p2008w30 USING btree (id);

CREATE INDEX items_search_p2008w30_properties_idx ON pgstac.items_search_p2008w30 USING gin (properties);

CREATE INDEX items_search_p2008w31_collection_id_idx ON pgstac.items_search_p2008w31 USING btree (collection_id);

CREATE INDEX items_search_p2008w31_datetime_id_idx ON pgstac.items_search_p2008w31 USING btree (datetime, id);

CREATE INDEX items_search_p2008w31_geometry_idx ON pgstac.items_search_p2008w31 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w31_pkey ON pgstac.items_search_p2008w31 USING btree (id);

CREATE INDEX items_search_p2008w31_properties_idx ON pgstac.items_search_p2008w31 USING gin (properties);

CREATE INDEX items_search_p2008w32_collection_id_idx ON pgstac.items_search_p2008w32 USING btree (collection_id);

CREATE INDEX items_search_p2008w32_datetime_id_idx ON pgstac.items_search_p2008w32 USING btree (datetime, id);

CREATE INDEX items_search_p2008w32_geometry_idx ON pgstac.items_search_p2008w32 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w32_pkey ON pgstac.items_search_p2008w32 USING btree (id);

CREATE INDEX items_search_p2008w32_properties_idx ON pgstac.items_search_p2008w32 USING gin (properties);

CREATE INDEX items_search_p2008w33_collection_id_idx ON pgstac.items_search_p2008w33 USING btree (collection_id);

CREATE INDEX items_search_p2008w33_datetime_id_idx ON pgstac.items_search_p2008w33 USING btree (datetime, id);

CREATE INDEX items_search_p2008w33_geometry_idx ON pgstac.items_search_p2008w33 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w33_pkey ON pgstac.items_search_p2008w33 USING btree (id);

CREATE INDEX items_search_p2008w33_properties_idx ON pgstac.items_search_p2008w33 USING gin (properties);

CREATE INDEX items_search_p2008w34_collection_id_idx ON pgstac.items_search_p2008w34 USING btree (collection_id);

CREATE INDEX items_search_p2008w34_datetime_id_idx ON pgstac.items_search_p2008w34 USING btree (datetime, id);

CREATE INDEX items_search_p2008w34_geometry_idx ON pgstac.items_search_p2008w34 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w34_pkey ON pgstac.items_search_p2008w34 USING btree (id);

CREATE INDEX items_search_p2008w34_properties_idx ON pgstac.items_search_p2008w34 USING gin (properties);

CREATE INDEX items_search_p2008w35_collection_id_idx ON pgstac.items_search_p2008w35 USING btree (collection_id);

CREATE INDEX items_search_p2008w35_datetime_id_idx ON pgstac.items_search_p2008w35 USING btree (datetime, id);

CREATE INDEX items_search_p2008w35_geometry_idx ON pgstac.items_search_p2008w35 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w35_pkey ON pgstac.items_search_p2008w35 USING btree (id);

CREATE INDEX items_search_p2008w35_properties_idx ON pgstac.items_search_p2008w35 USING gin (properties);

CREATE INDEX items_search_p2008w36_collection_id_idx ON pgstac.items_search_p2008w36 USING btree (collection_id);

CREATE INDEX items_search_p2008w36_datetime_id_idx ON pgstac.items_search_p2008w36 USING btree (datetime, id);

CREATE INDEX items_search_p2008w36_geometry_idx ON pgstac.items_search_p2008w36 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w36_pkey ON pgstac.items_search_p2008w36 USING btree (id);

CREATE INDEX items_search_p2008w36_properties_idx ON pgstac.items_search_p2008w36 USING gin (properties);

CREATE INDEX items_search_p2008w37_collection_id_idx ON pgstac.items_search_p2008w37 USING btree (collection_id);

CREATE INDEX items_search_p2008w37_datetime_id_idx ON pgstac.items_search_p2008w37 USING btree (datetime, id);

CREATE INDEX items_search_p2008w37_geometry_idx ON pgstac.items_search_p2008w37 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w37_pkey ON pgstac.items_search_p2008w37 USING btree (id);

CREATE INDEX items_search_p2008w37_properties_idx ON pgstac.items_search_p2008w37 USING gin (properties);

CREATE INDEX items_search_p2008w38_collection_id_idx ON pgstac.items_search_p2008w38 USING btree (collection_id);

CREATE INDEX items_search_p2008w38_datetime_id_idx ON pgstac.items_search_p2008w38 USING btree (datetime, id);

CREATE INDEX items_search_p2008w38_geometry_idx ON pgstac.items_search_p2008w38 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w38_pkey ON pgstac.items_search_p2008w38 USING btree (id);

CREATE INDEX items_search_p2008w38_properties_idx ON pgstac.items_search_p2008w38 USING gin (properties);

CREATE INDEX items_search_p2008w39_collection_id_idx ON pgstac.items_search_p2008w39 USING btree (collection_id);

CREATE INDEX items_search_p2008w39_datetime_id_idx ON pgstac.items_search_p2008w39 USING btree (datetime, id);

CREATE INDEX items_search_p2008w39_geometry_idx ON pgstac.items_search_p2008w39 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w39_pkey ON pgstac.items_search_p2008w39 USING btree (id);

CREATE INDEX items_search_p2008w39_properties_idx ON pgstac.items_search_p2008w39 USING gin (properties);

CREATE INDEX items_search_p2008w40_collection_id_idx ON pgstac.items_search_p2008w40 USING btree (collection_id);

CREATE INDEX items_search_p2008w40_datetime_id_idx ON pgstac.items_search_p2008w40 USING btree (datetime, id);

CREATE INDEX items_search_p2008w40_geometry_idx ON pgstac.items_search_p2008w40 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w40_pkey ON pgstac.items_search_p2008w40 USING btree (id);

CREATE INDEX items_search_p2008w40_properties_idx ON pgstac.items_search_p2008w40 USING gin (properties);

CREATE INDEX items_search_p2008w41_collection_id_idx ON pgstac.items_search_p2008w41 USING btree (collection_id);

CREATE INDEX items_search_p2008w41_datetime_id_idx ON pgstac.items_search_p2008w41 USING btree (datetime, id);

CREATE INDEX items_search_p2008w41_geometry_idx ON pgstac.items_search_p2008w41 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w41_pkey ON pgstac.items_search_p2008w41 USING btree (id);

CREATE INDEX items_search_p2008w41_properties_idx ON pgstac.items_search_p2008w41 USING gin (properties);

CREATE INDEX items_search_p2008w42_collection_id_idx ON pgstac.items_search_p2008w42 USING btree (collection_id);

CREATE INDEX items_search_p2008w42_datetime_id_idx ON pgstac.items_search_p2008w42 USING btree (datetime, id);

CREATE INDEX items_search_p2008w42_geometry_idx ON pgstac.items_search_p2008w42 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w42_pkey ON pgstac.items_search_p2008w42 USING btree (id);

CREATE INDEX items_search_p2008w42_properties_idx ON pgstac.items_search_p2008w42 USING gin (properties);

CREATE INDEX items_search_p2008w43_collection_id_idx ON pgstac.items_search_p2008w43 USING btree (collection_id);

CREATE INDEX items_search_p2008w43_datetime_id_idx ON pgstac.items_search_p2008w43 USING btree (datetime, id);

CREATE INDEX items_search_p2008w43_geometry_idx ON pgstac.items_search_p2008w43 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w43_pkey ON pgstac.items_search_p2008w43 USING btree (id);

CREATE INDEX items_search_p2008w43_properties_idx ON pgstac.items_search_p2008w43 USING gin (properties);

CREATE INDEX items_search_p2008w44_collection_id_idx ON pgstac.items_search_p2008w44 USING btree (collection_id);

CREATE INDEX items_search_p2008w44_datetime_id_idx ON pgstac.items_search_p2008w44 USING btree (datetime, id);

CREATE INDEX items_search_p2008w44_geometry_idx ON pgstac.items_search_p2008w44 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w44_pkey ON pgstac.items_search_p2008w44 USING btree (id);

CREATE INDEX items_search_p2008w44_properties_idx ON pgstac.items_search_p2008w44 USING gin (properties);

CREATE INDEX items_search_p2008w45_collection_id_idx ON pgstac.items_search_p2008w45 USING btree (collection_id);

CREATE INDEX items_search_p2008w45_datetime_id_idx ON pgstac.items_search_p2008w45 USING btree (datetime, id);

CREATE INDEX items_search_p2008w45_geometry_idx ON pgstac.items_search_p2008w45 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w45_pkey ON pgstac.items_search_p2008w45 USING btree (id);

CREATE INDEX items_search_p2008w45_properties_idx ON pgstac.items_search_p2008w45 USING gin (properties);

CREATE INDEX items_search_p2008w46_collection_id_idx ON pgstac.items_search_p2008w46 USING btree (collection_id);

CREATE INDEX items_search_p2008w46_datetime_id_idx ON pgstac.items_search_p2008w46 USING btree (datetime, id);

CREATE INDEX items_search_p2008w46_geometry_idx ON pgstac.items_search_p2008w46 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w46_pkey ON pgstac.items_search_p2008w46 USING btree (id);

CREATE INDEX items_search_p2008w46_properties_idx ON pgstac.items_search_p2008w46 USING gin (properties);

CREATE INDEX items_search_p2008w47_collection_id_idx ON pgstac.items_search_p2008w47 USING btree (collection_id);

CREATE INDEX items_search_p2008w47_datetime_id_idx ON pgstac.items_search_p2008w47 USING btree (datetime, id);

CREATE INDEX items_search_p2008w47_geometry_idx ON pgstac.items_search_p2008w47 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w47_pkey ON pgstac.items_search_p2008w47 USING btree (id);

CREATE INDEX items_search_p2008w47_properties_idx ON pgstac.items_search_p2008w47 USING gin (properties);

CREATE INDEX items_search_p2008w48_collection_id_idx ON pgstac.items_search_p2008w48 USING btree (collection_id);

CREATE INDEX items_search_p2008w48_datetime_id_idx ON pgstac.items_search_p2008w48 USING btree (datetime, id);

CREATE INDEX items_search_p2008w48_geometry_idx ON pgstac.items_search_p2008w48 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w48_pkey ON pgstac.items_search_p2008w48 USING btree (id);

CREATE INDEX items_search_p2008w48_properties_idx ON pgstac.items_search_p2008w48 USING gin (properties);

CREATE INDEX items_search_p2008w49_collection_id_idx ON pgstac.items_search_p2008w49 USING btree (collection_id);

CREATE INDEX items_search_p2008w49_datetime_id_idx ON pgstac.items_search_p2008w49 USING btree (datetime, id);

CREATE INDEX items_search_p2008w49_geometry_idx ON pgstac.items_search_p2008w49 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w49_pkey ON pgstac.items_search_p2008w49 USING btree (id);

CREATE INDEX items_search_p2008w49_properties_idx ON pgstac.items_search_p2008w49 USING gin (properties);

CREATE INDEX items_search_p2008w50_collection_id_idx ON pgstac.items_search_p2008w50 USING btree (collection_id);

CREATE INDEX items_search_p2008w50_datetime_id_idx ON pgstac.items_search_p2008w50 USING btree (datetime, id);

CREATE INDEX items_search_p2008w50_geometry_idx ON pgstac.items_search_p2008w50 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w50_pkey ON pgstac.items_search_p2008w50 USING btree (id);

CREATE INDEX items_search_p2008w50_properties_idx ON pgstac.items_search_p2008w50 USING gin (properties);

CREATE INDEX items_search_p2008w51_collection_id_idx ON pgstac.items_search_p2008w51 USING btree (collection_id);

CREATE INDEX items_search_p2008w51_datetime_id_idx ON pgstac.items_search_p2008w51 USING btree (datetime, id);

CREATE INDEX items_search_p2008w51_geometry_idx ON pgstac.items_search_p2008w51 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w51_pkey ON pgstac.items_search_p2008w51 USING btree (id);

CREATE INDEX items_search_p2008w51_properties_idx ON pgstac.items_search_p2008w51 USING gin (properties);

CREATE INDEX items_search_p2008w52_collection_id_idx ON pgstac.items_search_p2008w52 USING btree (collection_id);

CREATE INDEX items_search_p2008w52_datetime_id_idx ON pgstac.items_search_p2008w52 USING btree (datetime, id);

CREATE INDEX items_search_p2008w52_geometry_idx ON pgstac.items_search_p2008w52 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2008w52_pkey ON pgstac.items_search_p2008w52 USING btree (id);

CREATE INDEX items_search_p2008w52_properties_idx ON pgstac.items_search_p2008w52 USING gin (properties);

CREATE INDEX items_search_p2009w01_collection_id_idx ON pgstac.items_search_p2009w01 USING btree (collection_id);

CREATE INDEX items_search_p2009w01_datetime_id_idx ON pgstac.items_search_p2009w01 USING btree (datetime, id);

CREATE INDEX items_search_p2009w01_geometry_idx ON pgstac.items_search_p2009w01 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w01_pkey ON pgstac.items_search_p2009w01 USING btree (id);

CREATE INDEX items_search_p2009w01_properties_idx ON pgstac.items_search_p2009w01 USING gin (properties);

CREATE INDEX items_search_p2009w02_collection_id_idx ON pgstac.items_search_p2009w02 USING btree (collection_id);

CREATE INDEX items_search_p2009w02_datetime_id_idx ON pgstac.items_search_p2009w02 USING btree (datetime, id);

CREATE INDEX items_search_p2009w02_geometry_idx ON pgstac.items_search_p2009w02 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w02_pkey ON pgstac.items_search_p2009w02 USING btree (id);

CREATE INDEX items_search_p2009w02_properties_idx ON pgstac.items_search_p2009w02 USING gin (properties);

CREATE INDEX items_search_p2009w03_collection_id_idx ON pgstac.items_search_p2009w03 USING btree (collection_id);

CREATE INDEX items_search_p2009w03_datetime_id_idx ON pgstac.items_search_p2009w03 USING btree (datetime, id);

CREATE INDEX items_search_p2009w03_geometry_idx ON pgstac.items_search_p2009w03 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w03_pkey ON pgstac.items_search_p2009w03 USING btree (id);

CREATE INDEX items_search_p2009w03_properties_idx ON pgstac.items_search_p2009w03 USING gin (properties);

CREATE INDEX items_search_p2009w04_collection_id_idx ON pgstac.items_search_p2009w04 USING btree (collection_id);

CREATE INDEX items_search_p2009w04_datetime_id_idx ON pgstac.items_search_p2009w04 USING btree (datetime, id);

CREATE INDEX items_search_p2009w04_geometry_idx ON pgstac.items_search_p2009w04 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w04_pkey ON pgstac.items_search_p2009w04 USING btree (id);

CREATE INDEX items_search_p2009w04_properties_idx ON pgstac.items_search_p2009w04 USING gin (properties);

CREATE INDEX items_search_p2009w05_collection_id_idx ON pgstac.items_search_p2009w05 USING btree (collection_id);

CREATE INDEX items_search_p2009w05_datetime_id_idx ON pgstac.items_search_p2009w05 USING btree (datetime, id);

CREATE INDEX items_search_p2009w05_geometry_idx ON pgstac.items_search_p2009w05 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w05_pkey ON pgstac.items_search_p2009w05 USING btree (id);

CREATE INDEX items_search_p2009w05_properties_idx ON pgstac.items_search_p2009w05 USING gin (properties);

CREATE INDEX items_search_p2009w06_collection_id_idx ON pgstac.items_search_p2009w06 USING btree (collection_id);

CREATE INDEX items_search_p2009w06_datetime_id_idx ON pgstac.items_search_p2009w06 USING btree (datetime, id);

CREATE INDEX items_search_p2009w06_geometry_idx ON pgstac.items_search_p2009w06 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w06_pkey ON pgstac.items_search_p2009w06 USING btree (id);

CREATE INDEX items_search_p2009w06_properties_idx ON pgstac.items_search_p2009w06 USING gin (properties);

CREATE INDEX items_search_p2009w07_collection_id_idx ON pgstac.items_search_p2009w07 USING btree (collection_id);

CREATE INDEX items_search_p2009w07_datetime_id_idx ON pgstac.items_search_p2009w07 USING btree (datetime, id);

CREATE INDEX items_search_p2009w07_geometry_idx ON pgstac.items_search_p2009w07 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w07_pkey ON pgstac.items_search_p2009w07 USING btree (id);

CREATE INDEX items_search_p2009w07_properties_idx ON pgstac.items_search_p2009w07 USING gin (properties);

CREATE INDEX items_search_p2009w08_collection_id_idx ON pgstac.items_search_p2009w08 USING btree (collection_id);

CREATE INDEX items_search_p2009w08_datetime_id_idx ON pgstac.items_search_p2009w08 USING btree (datetime, id);

CREATE INDEX items_search_p2009w08_geometry_idx ON pgstac.items_search_p2009w08 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w08_pkey ON pgstac.items_search_p2009w08 USING btree (id);

CREATE INDEX items_search_p2009w08_properties_idx ON pgstac.items_search_p2009w08 USING gin (properties);

CREATE INDEX items_search_p2009w09_collection_id_idx ON pgstac.items_search_p2009w09 USING btree (collection_id);

CREATE INDEX items_search_p2009w09_datetime_id_idx ON pgstac.items_search_p2009w09 USING btree (datetime, id);

CREATE INDEX items_search_p2009w09_geometry_idx ON pgstac.items_search_p2009w09 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w09_pkey ON pgstac.items_search_p2009w09 USING btree (id);

CREATE INDEX items_search_p2009w09_properties_idx ON pgstac.items_search_p2009w09 USING gin (properties);

CREATE INDEX items_search_p2009w10_collection_id_idx ON pgstac.items_search_p2009w10 USING btree (collection_id);

CREATE INDEX items_search_p2009w10_datetime_id_idx ON pgstac.items_search_p2009w10 USING btree (datetime, id);

CREATE INDEX items_search_p2009w10_geometry_idx ON pgstac.items_search_p2009w10 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w10_pkey ON pgstac.items_search_p2009w10 USING btree (id);

CREATE INDEX items_search_p2009w10_properties_idx ON pgstac.items_search_p2009w10 USING gin (properties);

CREATE INDEX items_search_p2009w11_collection_id_idx ON pgstac.items_search_p2009w11 USING btree (collection_id);

CREATE INDEX items_search_p2009w11_datetime_id_idx ON pgstac.items_search_p2009w11 USING btree (datetime, id);

CREATE INDEX items_search_p2009w11_geometry_idx ON pgstac.items_search_p2009w11 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w11_pkey ON pgstac.items_search_p2009w11 USING btree (id);

CREATE INDEX items_search_p2009w11_properties_idx ON pgstac.items_search_p2009w11 USING gin (properties);

CREATE INDEX items_search_p2009w12_collection_id_idx ON pgstac.items_search_p2009w12 USING btree (collection_id);

CREATE INDEX items_search_p2009w12_datetime_id_idx ON pgstac.items_search_p2009w12 USING btree (datetime, id);

CREATE INDEX items_search_p2009w12_geometry_idx ON pgstac.items_search_p2009w12 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w12_pkey ON pgstac.items_search_p2009w12 USING btree (id);

CREATE INDEX items_search_p2009w12_properties_idx ON pgstac.items_search_p2009w12 USING gin (properties);

CREATE INDEX items_search_p2009w13_collection_id_idx ON pgstac.items_search_p2009w13 USING btree (collection_id);

CREATE INDEX items_search_p2009w13_datetime_id_idx ON pgstac.items_search_p2009w13 USING btree (datetime, id);

CREATE INDEX items_search_p2009w13_geometry_idx ON pgstac.items_search_p2009w13 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w13_pkey ON pgstac.items_search_p2009w13 USING btree (id);

CREATE INDEX items_search_p2009w13_properties_idx ON pgstac.items_search_p2009w13 USING gin (properties);

CREATE INDEX items_search_p2009w14_collection_id_idx ON pgstac.items_search_p2009w14 USING btree (collection_id);

CREATE INDEX items_search_p2009w14_datetime_id_idx ON pgstac.items_search_p2009w14 USING btree (datetime, id);

CREATE INDEX items_search_p2009w14_geometry_idx ON pgstac.items_search_p2009w14 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w14_pkey ON pgstac.items_search_p2009w14 USING btree (id);

CREATE INDEX items_search_p2009w14_properties_idx ON pgstac.items_search_p2009w14 USING gin (properties);

CREATE INDEX items_search_p2009w15_collection_id_idx ON pgstac.items_search_p2009w15 USING btree (collection_id);

CREATE INDEX items_search_p2009w15_datetime_id_idx ON pgstac.items_search_p2009w15 USING btree (datetime, id);

CREATE INDEX items_search_p2009w15_geometry_idx ON pgstac.items_search_p2009w15 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w15_pkey ON pgstac.items_search_p2009w15 USING btree (id);

CREATE INDEX items_search_p2009w15_properties_idx ON pgstac.items_search_p2009w15 USING gin (properties);

CREATE INDEX items_search_p2009w16_collection_id_idx ON pgstac.items_search_p2009w16 USING btree (collection_id);

CREATE INDEX items_search_p2009w16_datetime_id_idx ON pgstac.items_search_p2009w16 USING btree (datetime, id);

CREATE INDEX items_search_p2009w16_geometry_idx ON pgstac.items_search_p2009w16 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w16_pkey ON pgstac.items_search_p2009w16 USING btree (id);

CREATE INDEX items_search_p2009w16_properties_idx ON pgstac.items_search_p2009w16 USING gin (properties);

CREATE INDEX items_search_p2009w17_collection_id_idx ON pgstac.items_search_p2009w17 USING btree (collection_id);

CREATE INDEX items_search_p2009w17_datetime_id_idx ON pgstac.items_search_p2009w17 USING btree (datetime, id);

CREATE INDEX items_search_p2009w17_geometry_idx ON pgstac.items_search_p2009w17 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w17_pkey ON pgstac.items_search_p2009w17 USING btree (id);

CREATE INDEX items_search_p2009w17_properties_idx ON pgstac.items_search_p2009w17 USING gin (properties);

CREATE INDEX items_search_p2009w18_collection_id_idx ON pgstac.items_search_p2009w18 USING btree (collection_id);

CREATE INDEX items_search_p2009w18_datetime_id_idx ON pgstac.items_search_p2009w18 USING btree (datetime, id);

CREATE INDEX items_search_p2009w18_geometry_idx ON pgstac.items_search_p2009w18 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w18_pkey ON pgstac.items_search_p2009w18 USING btree (id);

CREATE INDEX items_search_p2009w18_properties_idx ON pgstac.items_search_p2009w18 USING gin (properties);

CREATE INDEX items_search_p2009w19_collection_id_idx ON pgstac.items_search_p2009w19 USING btree (collection_id);

CREATE INDEX items_search_p2009w19_datetime_id_idx ON pgstac.items_search_p2009w19 USING btree (datetime, id);

CREATE INDEX items_search_p2009w19_geometry_idx ON pgstac.items_search_p2009w19 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w19_pkey ON pgstac.items_search_p2009w19 USING btree (id);

CREATE INDEX items_search_p2009w19_properties_idx ON pgstac.items_search_p2009w19 USING gin (properties);

CREATE INDEX items_search_p2009w20_collection_id_idx ON pgstac.items_search_p2009w20 USING btree (collection_id);

CREATE INDEX items_search_p2009w20_datetime_id_idx ON pgstac.items_search_p2009w20 USING btree (datetime, id);

CREATE INDEX items_search_p2009w20_geometry_idx ON pgstac.items_search_p2009w20 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w20_pkey ON pgstac.items_search_p2009w20 USING btree (id);

CREATE INDEX items_search_p2009w20_properties_idx ON pgstac.items_search_p2009w20 USING gin (properties);

CREATE INDEX items_search_p2009w21_collection_id_idx ON pgstac.items_search_p2009w21 USING btree (collection_id);

CREATE INDEX items_search_p2009w21_datetime_id_idx ON pgstac.items_search_p2009w21 USING btree (datetime, id);

CREATE INDEX items_search_p2009w21_geometry_idx ON pgstac.items_search_p2009w21 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w21_pkey ON pgstac.items_search_p2009w21 USING btree (id);

CREATE INDEX items_search_p2009w21_properties_idx ON pgstac.items_search_p2009w21 USING gin (properties);

CREATE INDEX items_search_p2009w22_collection_id_idx ON pgstac.items_search_p2009w22 USING btree (collection_id);

CREATE INDEX items_search_p2009w22_datetime_id_idx ON pgstac.items_search_p2009w22 USING btree (datetime, id);

CREATE INDEX items_search_p2009w22_geometry_idx ON pgstac.items_search_p2009w22 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w22_pkey ON pgstac.items_search_p2009w22 USING btree (id);

CREATE INDEX items_search_p2009w22_properties_idx ON pgstac.items_search_p2009w22 USING gin (properties);

CREATE INDEX items_search_p2009w23_collection_id_idx ON pgstac.items_search_p2009w23 USING btree (collection_id);

CREATE INDEX items_search_p2009w23_datetime_id_idx ON pgstac.items_search_p2009w23 USING btree (datetime, id);

CREATE INDEX items_search_p2009w23_geometry_idx ON pgstac.items_search_p2009w23 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w23_pkey ON pgstac.items_search_p2009w23 USING btree (id);

CREATE INDEX items_search_p2009w23_properties_idx ON pgstac.items_search_p2009w23 USING gin (properties);

CREATE INDEX items_search_p2009w24_collection_id_idx ON pgstac.items_search_p2009w24 USING btree (collection_id);

CREATE INDEX items_search_p2009w24_datetime_id_idx ON pgstac.items_search_p2009w24 USING btree (datetime, id);

CREATE INDEX items_search_p2009w24_geometry_idx ON pgstac.items_search_p2009w24 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w24_pkey ON pgstac.items_search_p2009w24 USING btree (id);

CREATE INDEX items_search_p2009w24_properties_idx ON pgstac.items_search_p2009w24 USING gin (properties);

CREATE INDEX items_search_p2009w25_collection_id_idx ON pgstac.items_search_p2009w25 USING btree (collection_id);

CREATE INDEX items_search_p2009w25_datetime_id_idx ON pgstac.items_search_p2009w25 USING btree (datetime, id);

CREATE INDEX items_search_p2009w25_geometry_idx ON pgstac.items_search_p2009w25 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w25_pkey ON pgstac.items_search_p2009w25 USING btree (id);

CREATE INDEX items_search_p2009w25_properties_idx ON pgstac.items_search_p2009w25 USING gin (properties);

CREATE INDEX items_search_p2009w26_collection_id_idx ON pgstac.items_search_p2009w26 USING btree (collection_id);

CREATE INDEX items_search_p2009w26_datetime_id_idx ON pgstac.items_search_p2009w26 USING btree (datetime, id);

CREATE INDEX items_search_p2009w26_geometry_idx ON pgstac.items_search_p2009w26 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w26_pkey ON pgstac.items_search_p2009w26 USING btree (id);

CREATE INDEX items_search_p2009w26_properties_idx ON pgstac.items_search_p2009w26 USING gin (properties);

CREATE INDEX items_search_p2009w27_collection_id_idx ON pgstac.items_search_p2009w27 USING btree (collection_id);

CREATE INDEX items_search_p2009w27_datetime_id_idx ON pgstac.items_search_p2009w27 USING btree (datetime, id);

CREATE INDEX items_search_p2009w27_geometry_idx ON pgstac.items_search_p2009w27 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w27_pkey ON pgstac.items_search_p2009w27 USING btree (id);

CREATE INDEX items_search_p2009w27_properties_idx ON pgstac.items_search_p2009w27 USING gin (properties);

CREATE INDEX items_search_p2009w28_collection_id_idx ON pgstac.items_search_p2009w28 USING btree (collection_id);

CREATE INDEX items_search_p2009w28_datetime_id_idx ON pgstac.items_search_p2009w28 USING btree (datetime, id);

CREATE INDEX items_search_p2009w28_geometry_idx ON pgstac.items_search_p2009w28 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w28_pkey ON pgstac.items_search_p2009w28 USING btree (id);

CREATE INDEX items_search_p2009w28_properties_idx ON pgstac.items_search_p2009w28 USING gin (properties);

CREATE INDEX items_search_p2009w29_collection_id_idx ON pgstac.items_search_p2009w29 USING btree (collection_id);

CREATE INDEX items_search_p2009w29_datetime_id_idx ON pgstac.items_search_p2009w29 USING btree (datetime, id);

CREATE INDEX items_search_p2009w29_geometry_idx ON pgstac.items_search_p2009w29 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w29_pkey ON pgstac.items_search_p2009w29 USING btree (id);

CREATE INDEX items_search_p2009w29_properties_idx ON pgstac.items_search_p2009w29 USING gin (properties);

CREATE INDEX items_search_p2009w30_collection_id_idx ON pgstac.items_search_p2009w30 USING btree (collection_id);

CREATE INDEX items_search_p2009w30_datetime_id_idx ON pgstac.items_search_p2009w30 USING btree (datetime, id);

CREATE INDEX items_search_p2009w30_geometry_idx ON pgstac.items_search_p2009w30 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w30_pkey ON pgstac.items_search_p2009w30 USING btree (id);

CREATE INDEX items_search_p2009w30_properties_idx ON pgstac.items_search_p2009w30 USING gin (properties);

CREATE INDEX items_search_p2009w31_collection_id_idx ON pgstac.items_search_p2009w31 USING btree (collection_id);

CREATE INDEX items_search_p2009w31_datetime_id_idx ON pgstac.items_search_p2009w31 USING btree (datetime, id);

CREATE INDEX items_search_p2009w31_geometry_idx ON pgstac.items_search_p2009w31 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w31_pkey ON pgstac.items_search_p2009w31 USING btree (id);

CREATE INDEX items_search_p2009w31_properties_idx ON pgstac.items_search_p2009w31 USING gin (properties);

CREATE INDEX items_search_p2009w32_collection_id_idx ON pgstac.items_search_p2009w32 USING btree (collection_id);

CREATE INDEX items_search_p2009w32_datetime_id_idx ON pgstac.items_search_p2009w32 USING btree (datetime, id);

CREATE INDEX items_search_p2009w32_geometry_idx ON pgstac.items_search_p2009w32 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w32_pkey ON pgstac.items_search_p2009w32 USING btree (id);

CREATE INDEX items_search_p2009w32_properties_idx ON pgstac.items_search_p2009w32 USING gin (properties);

CREATE INDEX items_search_p2009w33_collection_id_idx ON pgstac.items_search_p2009w33 USING btree (collection_id);

CREATE INDEX items_search_p2009w33_datetime_id_idx ON pgstac.items_search_p2009w33 USING btree (datetime, id);

CREATE INDEX items_search_p2009w33_geometry_idx ON pgstac.items_search_p2009w33 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w33_pkey ON pgstac.items_search_p2009w33 USING btree (id);

CREATE INDEX items_search_p2009w33_properties_idx ON pgstac.items_search_p2009w33 USING gin (properties);

CREATE INDEX items_search_p2009w34_collection_id_idx ON pgstac.items_search_p2009w34 USING btree (collection_id);

CREATE INDEX items_search_p2009w34_datetime_id_idx ON pgstac.items_search_p2009w34 USING btree (datetime, id);

CREATE INDEX items_search_p2009w34_geometry_idx ON pgstac.items_search_p2009w34 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w34_pkey ON pgstac.items_search_p2009w34 USING btree (id);

CREATE INDEX items_search_p2009w34_properties_idx ON pgstac.items_search_p2009w34 USING gin (properties);

CREATE INDEX items_search_p2009w35_collection_id_idx ON pgstac.items_search_p2009w35 USING btree (collection_id);

CREATE INDEX items_search_p2009w35_datetime_id_idx ON pgstac.items_search_p2009w35 USING btree (datetime, id);

CREATE INDEX items_search_p2009w35_geometry_idx ON pgstac.items_search_p2009w35 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w35_pkey ON pgstac.items_search_p2009w35 USING btree (id);

CREATE INDEX items_search_p2009w35_properties_idx ON pgstac.items_search_p2009w35 USING gin (properties);

CREATE INDEX items_search_p2009w36_collection_id_idx ON pgstac.items_search_p2009w36 USING btree (collection_id);

CREATE INDEX items_search_p2009w36_datetime_id_idx ON pgstac.items_search_p2009w36 USING btree (datetime, id);

CREATE INDEX items_search_p2009w36_geometry_idx ON pgstac.items_search_p2009w36 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w36_pkey ON pgstac.items_search_p2009w36 USING btree (id);

CREATE INDEX items_search_p2009w36_properties_idx ON pgstac.items_search_p2009w36 USING gin (properties);

CREATE INDEX items_search_p2009w37_collection_id_idx ON pgstac.items_search_p2009w37 USING btree (collection_id);

CREATE INDEX items_search_p2009w37_datetime_id_idx ON pgstac.items_search_p2009w37 USING btree (datetime, id);

CREATE INDEX items_search_p2009w37_geometry_idx ON pgstac.items_search_p2009w37 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w37_pkey ON pgstac.items_search_p2009w37 USING btree (id);

CREATE INDEX items_search_p2009w37_properties_idx ON pgstac.items_search_p2009w37 USING gin (properties);

CREATE INDEX items_search_p2009w38_collection_id_idx ON pgstac.items_search_p2009w38 USING btree (collection_id);

CREATE INDEX items_search_p2009w38_datetime_id_idx ON pgstac.items_search_p2009w38 USING btree (datetime, id);

CREATE INDEX items_search_p2009w38_geometry_idx ON pgstac.items_search_p2009w38 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w38_pkey ON pgstac.items_search_p2009w38 USING btree (id);

CREATE INDEX items_search_p2009w38_properties_idx ON pgstac.items_search_p2009w38 USING gin (properties);

CREATE INDEX items_search_p2009w39_collection_id_idx ON pgstac.items_search_p2009w39 USING btree (collection_id);

CREATE INDEX items_search_p2009w39_datetime_id_idx ON pgstac.items_search_p2009w39 USING btree (datetime, id);

CREATE INDEX items_search_p2009w39_geometry_idx ON pgstac.items_search_p2009w39 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w39_pkey ON pgstac.items_search_p2009w39 USING btree (id);

CREATE INDEX items_search_p2009w39_properties_idx ON pgstac.items_search_p2009w39 USING gin (properties);

CREATE INDEX items_search_p2009w40_collection_id_idx ON pgstac.items_search_p2009w40 USING btree (collection_id);

CREATE INDEX items_search_p2009w40_datetime_id_idx ON pgstac.items_search_p2009w40 USING btree (datetime, id);

CREATE INDEX items_search_p2009w40_geometry_idx ON pgstac.items_search_p2009w40 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w40_pkey ON pgstac.items_search_p2009w40 USING btree (id);

CREATE INDEX items_search_p2009w40_properties_idx ON pgstac.items_search_p2009w40 USING gin (properties);

CREATE INDEX items_search_p2009w41_collection_id_idx ON pgstac.items_search_p2009w41 USING btree (collection_id);

CREATE INDEX items_search_p2009w41_datetime_id_idx ON pgstac.items_search_p2009w41 USING btree (datetime, id);

CREATE INDEX items_search_p2009w41_geometry_idx ON pgstac.items_search_p2009w41 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w41_pkey ON pgstac.items_search_p2009w41 USING btree (id);

CREATE INDEX items_search_p2009w41_properties_idx ON pgstac.items_search_p2009w41 USING gin (properties);

CREATE INDEX items_search_p2009w42_collection_id_idx ON pgstac.items_search_p2009w42 USING btree (collection_id);

CREATE INDEX items_search_p2009w42_datetime_id_idx ON pgstac.items_search_p2009w42 USING btree (datetime, id);

CREATE INDEX items_search_p2009w42_geometry_idx ON pgstac.items_search_p2009w42 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w42_pkey ON pgstac.items_search_p2009w42 USING btree (id);

CREATE INDEX items_search_p2009w42_properties_idx ON pgstac.items_search_p2009w42 USING gin (properties);

CREATE INDEX items_search_p2009w43_collection_id_idx ON pgstac.items_search_p2009w43 USING btree (collection_id);

CREATE INDEX items_search_p2009w43_datetime_id_idx ON pgstac.items_search_p2009w43 USING btree (datetime, id);

CREATE INDEX items_search_p2009w43_geometry_idx ON pgstac.items_search_p2009w43 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w43_pkey ON pgstac.items_search_p2009w43 USING btree (id);

CREATE INDEX items_search_p2009w43_properties_idx ON pgstac.items_search_p2009w43 USING gin (properties);

CREATE INDEX items_search_p2009w44_collection_id_idx ON pgstac.items_search_p2009w44 USING btree (collection_id);

CREATE INDEX items_search_p2009w44_datetime_id_idx ON pgstac.items_search_p2009w44 USING btree (datetime, id);

CREATE INDEX items_search_p2009w44_geometry_idx ON pgstac.items_search_p2009w44 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w44_pkey ON pgstac.items_search_p2009w44 USING btree (id);

CREATE INDEX items_search_p2009w44_properties_idx ON pgstac.items_search_p2009w44 USING gin (properties);

CREATE INDEX items_search_p2009w45_collection_id_idx ON pgstac.items_search_p2009w45 USING btree (collection_id);

CREATE INDEX items_search_p2009w45_datetime_id_idx ON pgstac.items_search_p2009w45 USING btree (datetime, id);

CREATE INDEX items_search_p2009w45_geometry_idx ON pgstac.items_search_p2009w45 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w45_pkey ON pgstac.items_search_p2009w45 USING btree (id);

CREATE INDEX items_search_p2009w45_properties_idx ON pgstac.items_search_p2009w45 USING gin (properties);

CREATE INDEX items_search_p2009w46_collection_id_idx ON pgstac.items_search_p2009w46 USING btree (collection_id);

CREATE INDEX items_search_p2009w46_datetime_id_idx ON pgstac.items_search_p2009w46 USING btree (datetime, id);

CREATE INDEX items_search_p2009w46_geometry_idx ON pgstac.items_search_p2009w46 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w46_pkey ON pgstac.items_search_p2009w46 USING btree (id);

CREATE INDEX items_search_p2009w46_properties_idx ON pgstac.items_search_p2009w46 USING gin (properties);

CREATE INDEX items_search_p2009w47_collection_id_idx ON pgstac.items_search_p2009w47 USING btree (collection_id);

CREATE INDEX items_search_p2009w47_datetime_id_idx ON pgstac.items_search_p2009w47 USING btree (datetime, id);

CREATE INDEX items_search_p2009w47_geometry_idx ON pgstac.items_search_p2009w47 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w47_pkey ON pgstac.items_search_p2009w47 USING btree (id);

CREATE INDEX items_search_p2009w47_properties_idx ON pgstac.items_search_p2009w47 USING gin (properties);

CREATE INDEX items_search_p2009w48_collection_id_idx ON pgstac.items_search_p2009w48 USING btree (collection_id);

CREATE INDEX items_search_p2009w48_datetime_id_idx ON pgstac.items_search_p2009w48 USING btree (datetime, id);

CREATE INDEX items_search_p2009w48_geometry_idx ON pgstac.items_search_p2009w48 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w48_pkey ON pgstac.items_search_p2009w48 USING btree (id);

CREATE INDEX items_search_p2009w48_properties_idx ON pgstac.items_search_p2009w48 USING gin (properties);

CREATE INDEX items_search_p2009w49_collection_id_idx ON pgstac.items_search_p2009w49 USING btree (collection_id);

CREATE INDEX items_search_p2009w49_datetime_id_idx ON pgstac.items_search_p2009w49 USING btree (datetime, id);

CREATE INDEX items_search_p2009w49_geometry_idx ON pgstac.items_search_p2009w49 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w49_pkey ON pgstac.items_search_p2009w49 USING btree (id);

CREATE INDEX items_search_p2009w49_properties_idx ON pgstac.items_search_p2009w49 USING gin (properties);

CREATE INDEX items_search_p2009w50_collection_id_idx ON pgstac.items_search_p2009w50 USING btree (collection_id);

CREATE INDEX items_search_p2009w50_datetime_id_idx ON pgstac.items_search_p2009w50 USING btree (datetime, id);

CREATE INDEX items_search_p2009w50_geometry_idx ON pgstac.items_search_p2009w50 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w50_pkey ON pgstac.items_search_p2009w50 USING btree (id);

CREATE INDEX items_search_p2009w50_properties_idx ON pgstac.items_search_p2009w50 USING gin (properties);

CREATE INDEX items_search_p2009w51_collection_id_idx ON pgstac.items_search_p2009w51 USING btree (collection_id);

CREATE INDEX items_search_p2009w51_datetime_id_idx ON pgstac.items_search_p2009w51 USING btree (datetime, id);

CREATE INDEX items_search_p2009w51_geometry_idx ON pgstac.items_search_p2009w51 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w51_pkey ON pgstac.items_search_p2009w51 USING btree (id);

CREATE INDEX items_search_p2009w51_properties_idx ON pgstac.items_search_p2009w51 USING gin (properties);

CREATE INDEX items_search_p2009w52_collection_id_idx ON pgstac.items_search_p2009w52 USING btree (collection_id);

CREATE INDEX items_search_p2009w52_datetime_id_idx ON pgstac.items_search_p2009w52 USING btree (datetime, id);

CREATE INDEX items_search_p2009w52_geometry_idx ON pgstac.items_search_p2009w52 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w52_pkey ON pgstac.items_search_p2009w52 USING btree (id);

CREATE INDEX items_search_p2009w52_properties_idx ON pgstac.items_search_p2009w52 USING gin (properties);

CREATE INDEX items_search_p2009w53_collection_id_idx ON pgstac.items_search_p2009w53 USING btree (collection_id);

CREATE INDEX items_search_p2009w53_datetime_id_idx ON pgstac.items_search_p2009w53 USING btree (datetime, id);

CREATE INDEX items_search_p2009w53_geometry_idx ON pgstac.items_search_p2009w53 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2009w53_pkey ON pgstac.items_search_p2009w53 USING btree (id);

CREATE INDEX items_search_p2009w53_properties_idx ON pgstac.items_search_p2009w53 USING gin (properties);

CREATE INDEX items_search_p2010w01_collection_id_idx ON pgstac.items_search_p2010w01 USING btree (collection_id);

CREATE INDEX items_search_p2010w01_datetime_id_idx ON pgstac.items_search_p2010w01 USING btree (datetime, id);

CREATE INDEX items_search_p2010w01_geometry_idx ON pgstac.items_search_p2010w01 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w01_pkey ON pgstac.items_search_p2010w01 USING btree (id);

CREATE INDEX items_search_p2010w01_properties_idx ON pgstac.items_search_p2010w01 USING gin (properties);

CREATE INDEX items_search_p2010w02_collection_id_idx ON pgstac.items_search_p2010w02 USING btree (collection_id);

CREATE INDEX items_search_p2010w02_datetime_id_idx ON pgstac.items_search_p2010w02 USING btree (datetime, id);

CREATE INDEX items_search_p2010w02_geometry_idx ON pgstac.items_search_p2010w02 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w02_pkey ON pgstac.items_search_p2010w02 USING btree (id);

CREATE INDEX items_search_p2010w02_properties_idx ON pgstac.items_search_p2010w02 USING gin (properties);

CREATE INDEX items_search_p2010w03_collection_id_idx ON pgstac.items_search_p2010w03 USING btree (collection_id);

CREATE INDEX items_search_p2010w03_datetime_id_idx ON pgstac.items_search_p2010w03 USING btree (datetime, id);

CREATE INDEX items_search_p2010w03_geometry_idx ON pgstac.items_search_p2010w03 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w03_pkey ON pgstac.items_search_p2010w03 USING btree (id);

CREATE INDEX items_search_p2010w03_properties_idx ON pgstac.items_search_p2010w03 USING gin (properties);

CREATE INDEX items_search_p2010w04_collection_id_idx ON pgstac.items_search_p2010w04 USING btree (collection_id);

CREATE INDEX items_search_p2010w04_datetime_id_idx ON pgstac.items_search_p2010w04 USING btree (datetime, id);

CREATE INDEX items_search_p2010w04_geometry_idx ON pgstac.items_search_p2010w04 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w04_pkey ON pgstac.items_search_p2010w04 USING btree (id);

CREATE INDEX items_search_p2010w04_properties_idx ON pgstac.items_search_p2010w04 USING gin (properties);

CREATE INDEX items_search_p2010w05_collection_id_idx ON pgstac.items_search_p2010w05 USING btree (collection_id);

CREATE INDEX items_search_p2010w05_datetime_id_idx ON pgstac.items_search_p2010w05 USING btree (datetime, id);

CREATE INDEX items_search_p2010w05_geometry_idx ON pgstac.items_search_p2010w05 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w05_pkey ON pgstac.items_search_p2010w05 USING btree (id);

CREATE INDEX items_search_p2010w05_properties_idx ON pgstac.items_search_p2010w05 USING gin (properties);

CREATE INDEX items_search_p2010w06_collection_id_idx ON pgstac.items_search_p2010w06 USING btree (collection_id);

CREATE INDEX items_search_p2010w06_datetime_id_idx ON pgstac.items_search_p2010w06 USING btree (datetime, id);

CREATE INDEX items_search_p2010w06_geometry_idx ON pgstac.items_search_p2010w06 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w06_pkey ON pgstac.items_search_p2010w06 USING btree (id);

CREATE INDEX items_search_p2010w06_properties_idx ON pgstac.items_search_p2010w06 USING gin (properties);

CREATE INDEX items_search_p2010w07_collection_id_idx ON pgstac.items_search_p2010w07 USING btree (collection_id);

CREATE INDEX items_search_p2010w07_datetime_id_idx ON pgstac.items_search_p2010w07 USING btree (datetime, id);

CREATE INDEX items_search_p2010w07_geometry_idx ON pgstac.items_search_p2010w07 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w07_pkey ON pgstac.items_search_p2010w07 USING btree (id);

CREATE INDEX items_search_p2010w07_properties_idx ON pgstac.items_search_p2010w07 USING gin (properties);

CREATE INDEX items_search_p2010w08_collection_id_idx ON pgstac.items_search_p2010w08 USING btree (collection_id);

CREATE INDEX items_search_p2010w08_datetime_id_idx ON pgstac.items_search_p2010w08 USING btree (datetime, id);

CREATE INDEX items_search_p2010w08_geometry_idx ON pgstac.items_search_p2010w08 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w08_pkey ON pgstac.items_search_p2010w08 USING btree (id);

CREATE INDEX items_search_p2010w08_properties_idx ON pgstac.items_search_p2010w08 USING gin (properties);

CREATE INDEX items_search_p2010w09_collection_id_idx ON pgstac.items_search_p2010w09 USING btree (collection_id);

CREATE INDEX items_search_p2010w09_datetime_id_idx ON pgstac.items_search_p2010w09 USING btree (datetime, id);

CREATE INDEX items_search_p2010w09_geometry_idx ON pgstac.items_search_p2010w09 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w09_pkey ON pgstac.items_search_p2010w09 USING btree (id);

CREATE INDEX items_search_p2010w09_properties_idx ON pgstac.items_search_p2010w09 USING gin (properties);

CREATE INDEX items_search_p2010w10_collection_id_idx ON pgstac.items_search_p2010w10 USING btree (collection_id);

CREATE INDEX items_search_p2010w10_datetime_id_idx ON pgstac.items_search_p2010w10 USING btree (datetime, id);

CREATE INDEX items_search_p2010w10_geometry_idx ON pgstac.items_search_p2010w10 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w10_pkey ON pgstac.items_search_p2010w10 USING btree (id);

CREATE INDEX items_search_p2010w10_properties_idx ON pgstac.items_search_p2010w10 USING gin (properties);

CREATE INDEX items_search_p2010w11_collection_id_idx ON pgstac.items_search_p2010w11 USING btree (collection_id);

CREATE INDEX items_search_p2010w11_datetime_id_idx ON pgstac.items_search_p2010w11 USING btree (datetime, id);

CREATE INDEX items_search_p2010w11_geometry_idx ON pgstac.items_search_p2010w11 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w11_pkey ON pgstac.items_search_p2010w11 USING btree (id);

CREATE INDEX items_search_p2010w11_properties_idx ON pgstac.items_search_p2010w11 USING gin (properties);

CREATE INDEX items_search_p2010w12_collection_id_idx ON pgstac.items_search_p2010w12 USING btree (collection_id);

CREATE INDEX items_search_p2010w12_datetime_id_idx ON pgstac.items_search_p2010w12 USING btree (datetime, id);

CREATE INDEX items_search_p2010w12_geometry_idx ON pgstac.items_search_p2010w12 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w12_pkey ON pgstac.items_search_p2010w12 USING btree (id);

CREATE INDEX items_search_p2010w12_properties_idx ON pgstac.items_search_p2010w12 USING gin (properties);

CREATE INDEX items_search_p2010w13_collection_id_idx ON pgstac.items_search_p2010w13 USING btree (collection_id);

CREATE INDEX items_search_p2010w13_datetime_id_idx ON pgstac.items_search_p2010w13 USING btree (datetime, id);

CREATE INDEX items_search_p2010w13_geometry_idx ON pgstac.items_search_p2010w13 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w13_pkey ON pgstac.items_search_p2010w13 USING btree (id);

CREATE INDEX items_search_p2010w13_properties_idx ON pgstac.items_search_p2010w13 USING gin (properties);

CREATE INDEX items_search_p2010w14_collection_id_idx ON pgstac.items_search_p2010w14 USING btree (collection_id);

CREATE INDEX items_search_p2010w14_datetime_id_idx ON pgstac.items_search_p2010w14 USING btree (datetime, id);

CREATE INDEX items_search_p2010w14_geometry_idx ON pgstac.items_search_p2010w14 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w14_pkey ON pgstac.items_search_p2010w14 USING btree (id);

CREATE INDEX items_search_p2010w14_properties_idx ON pgstac.items_search_p2010w14 USING gin (properties);

CREATE INDEX items_search_p2010w15_collection_id_idx ON pgstac.items_search_p2010w15 USING btree (collection_id);

CREATE INDEX items_search_p2010w15_datetime_id_idx ON pgstac.items_search_p2010w15 USING btree (datetime, id);

CREATE INDEX items_search_p2010w15_geometry_idx ON pgstac.items_search_p2010w15 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w15_pkey ON pgstac.items_search_p2010w15 USING btree (id);

CREATE INDEX items_search_p2010w15_properties_idx ON pgstac.items_search_p2010w15 USING gin (properties);

CREATE INDEX items_search_p2010w16_collection_id_idx ON pgstac.items_search_p2010w16 USING btree (collection_id);

CREATE INDEX items_search_p2010w16_datetime_id_idx ON pgstac.items_search_p2010w16 USING btree (datetime, id);

CREATE INDEX items_search_p2010w16_geometry_idx ON pgstac.items_search_p2010w16 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w16_pkey ON pgstac.items_search_p2010w16 USING btree (id);

CREATE INDEX items_search_p2010w16_properties_idx ON pgstac.items_search_p2010w16 USING gin (properties);

CREATE INDEX items_search_p2010w17_collection_id_idx ON pgstac.items_search_p2010w17 USING btree (collection_id);

CREATE INDEX items_search_p2010w17_datetime_id_idx ON pgstac.items_search_p2010w17 USING btree (datetime, id);

CREATE INDEX items_search_p2010w17_geometry_idx ON pgstac.items_search_p2010w17 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w17_pkey ON pgstac.items_search_p2010w17 USING btree (id);

CREATE INDEX items_search_p2010w17_properties_idx ON pgstac.items_search_p2010w17 USING gin (properties);

CREATE INDEX items_search_p2010w18_collection_id_idx ON pgstac.items_search_p2010w18 USING btree (collection_id);

CREATE INDEX items_search_p2010w18_datetime_id_idx ON pgstac.items_search_p2010w18 USING btree (datetime, id);

CREATE INDEX items_search_p2010w18_geometry_idx ON pgstac.items_search_p2010w18 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w18_pkey ON pgstac.items_search_p2010w18 USING btree (id);

CREATE INDEX items_search_p2010w18_properties_idx ON pgstac.items_search_p2010w18 USING gin (properties);

CREATE INDEX items_search_p2010w19_collection_id_idx ON pgstac.items_search_p2010w19 USING btree (collection_id);

CREATE INDEX items_search_p2010w19_datetime_id_idx ON pgstac.items_search_p2010w19 USING btree (datetime, id);

CREATE INDEX items_search_p2010w19_geometry_idx ON pgstac.items_search_p2010w19 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w19_pkey ON pgstac.items_search_p2010w19 USING btree (id);

CREATE INDEX items_search_p2010w19_properties_idx ON pgstac.items_search_p2010w19 USING gin (properties);

CREATE INDEX items_search_p2010w20_collection_id_idx ON pgstac.items_search_p2010w20 USING btree (collection_id);

CREATE INDEX items_search_p2010w20_datetime_id_idx ON pgstac.items_search_p2010w20 USING btree (datetime, id);

CREATE INDEX items_search_p2010w20_geometry_idx ON pgstac.items_search_p2010w20 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w20_pkey ON pgstac.items_search_p2010w20 USING btree (id);

CREATE INDEX items_search_p2010w20_properties_idx ON pgstac.items_search_p2010w20 USING gin (properties);

CREATE INDEX items_search_p2010w21_collection_id_idx ON pgstac.items_search_p2010w21 USING btree (collection_id);

CREATE INDEX items_search_p2010w21_datetime_id_idx ON pgstac.items_search_p2010w21 USING btree (datetime, id);

CREATE INDEX items_search_p2010w21_geometry_idx ON pgstac.items_search_p2010w21 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w21_pkey ON pgstac.items_search_p2010w21 USING btree (id);

CREATE INDEX items_search_p2010w21_properties_idx ON pgstac.items_search_p2010w21 USING gin (properties);

CREATE INDEX items_search_p2010w22_collection_id_idx ON pgstac.items_search_p2010w22 USING btree (collection_id);

CREATE INDEX items_search_p2010w22_datetime_id_idx ON pgstac.items_search_p2010w22 USING btree (datetime, id);

CREATE INDEX items_search_p2010w22_geometry_idx ON pgstac.items_search_p2010w22 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w22_pkey ON pgstac.items_search_p2010w22 USING btree (id);

CREATE INDEX items_search_p2010w22_properties_idx ON pgstac.items_search_p2010w22 USING gin (properties);

CREATE INDEX items_search_p2010w23_collection_id_idx ON pgstac.items_search_p2010w23 USING btree (collection_id);

CREATE INDEX items_search_p2010w23_datetime_id_idx ON pgstac.items_search_p2010w23 USING btree (datetime, id);

CREATE INDEX items_search_p2010w23_geometry_idx ON pgstac.items_search_p2010w23 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w23_pkey ON pgstac.items_search_p2010w23 USING btree (id);

CREATE INDEX items_search_p2010w23_properties_idx ON pgstac.items_search_p2010w23 USING gin (properties);

CREATE INDEX items_search_p2010w24_collection_id_idx ON pgstac.items_search_p2010w24 USING btree (collection_id);

CREATE INDEX items_search_p2010w24_datetime_id_idx ON pgstac.items_search_p2010w24 USING btree (datetime, id);

CREATE INDEX items_search_p2010w24_geometry_idx ON pgstac.items_search_p2010w24 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w24_pkey ON pgstac.items_search_p2010w24 USING btree (id);

CREATE INDEX items_search_p2010w24_properties_idx ON pgstac.items_search_p2010w24 USING gin (properties);

CREATE INDEX items_search_p2010w25_collection_id_idx ON pgstac.items_search_p2010w25 USING btree (collection_id);

CREATE INDEX items_search_p2010w25_datetime_id_idx ON pgstac.items_search_p2010w25 USING btree (datetime, id);

CREATE INDEX items_search_p2010w25_geometry_idx ON pgstac.items_search_p2010w25 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w25_pkey ON pgstac.items_search_p2010w25 USING btree (id);

CREATE INDEX items_search_p2010w25_properties_idx ON pgstac.items_search_p2010w25 USING gin (properties);

CREATE INDEX items_search_p2010w26_collection_id_idx ON pgstac.items_search_p2010w26 USING btree (collection_id);

CREATE INDEX items_search_p2010w26_datetime_id_idx ON pgstac.items_search_p2010w26 USING btree (datetime, id);

CREATE INDEX items_search_p2010w26_geometry_idx ON pgstac.items_search_p2010w26 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w26_pkey ON pgstac.items_search_p2010w26 USING btree (id);

CREATE INDEX items_search_p2010w26_properties_idx ON pgstac.items_search_p2010w26 USING gin (properties);

CREATE INDEX items_search_p2010w27_collection_id_idx ON pgstac.items_search_p2010w27 USING btree (collection_id);

CREATE INDEX items_search_p2010w27_datetime_id_idx ON pgstac.items_search_p2010w27 USING btree (datetime, id);

CREATE INDEX items_search_p2010w27_geometry_idx ON pgstac.items_search_p2010w27 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w27_pkey ON pgstac.items_search_p2010w27 USING btree (id);

CREATE INDEX items_search_p2010w27_properties_idx ON pgstac.items_search_p2010w27 USING gin (properties);

CREATE INDEX items_search_p2010w28_collection_id_idx ON pgstac.items_search_p2010w28 USING btree (collection_id);

CREATE INDEX items_search_p2010w28_datetime_id_idx ON pgstac.items_search_p2010w28 USING btree (datetime, id);

CREATE INDEX items_search_p2010w28_geometry_idx ON pgstac.items_search_p2010w28 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w28_pkey ON pgstac.items_search_p2010w28 USING btree (id);

CREATE INDEX items_search_p2010w28_properties_idx ON pgstac.items_search_p2010w28 USING gin (properties);

CREATE INDEX items_search_p2010w29_collection_id_idx ON pgstac.items_search_p2010w29 USING btree (collection_id);

CREATE INDEX items_search_p2010w29_datetime_id_idx ON pgstac.items_search_p2010w29 USING btree (datetime, id);

CREATE INDEX items_search_p2010w29_geometry_idx ON pgstac.items_search_p2010w29 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w29_pkey ON pgstac.items_search_p2010w29 USING btree (id);

CREATE INDEX items_search_p2010w29_properties_idx ON pgstac.items_search_p2010w29 USING gin (properties);

CREATE INDEX items_search_p2010w30_collection_id_idx ON pgstac.items_search_p2010w30 USING btree (collection_id);

CREATE INDEX items_search_p2010w30_datetime_id_idx ON pgstac.items_search_p2010w30 USING btree (datetime, id);

CREATE INDEX items_search_p2010w30_geometry_idx ON pgstac.items_search_p2010w30 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w30_pkey ON pgstac.items_search_p2010w30 USING btree (id);

CREATE INDEX items_search_p2010w30_properties_idx ON pgstac.items_search_p2010w30 USING gin (properties);

CREATE INDEX items_search_p2010w31_collection_id_idx ON pgstac.items_search_p2010w31 USING btree (collection_id);

CREATE INDEX items_search_p2010w31_datetime_id_idx ON pgstac.items_search_p2010w31 USING btree (datetime, id);

CREATE INDEX items_search_p2010w31_geometry_idx ON pgstac.items_search_p2010w31 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w31_pkey ON pgstac.items_search_p2010w31 USING btree (id);

CREATE INDEX items_search_p2010w31_properties_idx ON pgstac.items_search_p2010w31 USING gin (properties);

CREATE INDEX items_search_p2010w32_collection_id_idx ON pgstac.items_search_p2010w32 USING btree (collection_id);

CREATE INDEX items_search_p2010w32_datetime_id_idx ON pgstac.items_search_p2010w32 USING btree (datetime, id);

CREATE INDEX items_search_p2010w32_geometry_idx ON pgstac.items_search_p2010w32 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w32_pkey ON pgstac.items_search_p2010w32 USING btree (id);

CREATE INDEX items_search_p2010w32_properties_idx ON pgstac.items_search_p2010w32 USING gin (properties);

CREATE INDEX items_search_p2010w33_collection_id_idx ON pgstac.items_search_p2010w33 USING btree (collection_id);

CREATE INDEX items_search_p2010w33_datetime_id_idx ON pgstac.items_search_p2010w33 USING btree (datetime, id);

CREATE INDEX items_search_p2010w33_geometry_idx ON pgstac.items_search_p2010w33 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w33_pkey ON pgstac.items_search_p2010w33 USING btree (id);

CREATE INDEX items_search_p2010w33_properties_idx ON pgstac.items_search_p2010w33 USING gin (properties);

CREATE INDEX items_search_p2010w34_collection_id_idx ON pgstac.items_search_p2010w34 USING btree (collection_id);

CREATE INDEX items_search_p2010w34_datetime_id_idx ON pgstac.items_search_p2010w34 USING btree (datetime, id);

CREATE INDEX items_search_p2010w34_geometry_idx ON pgstac.items_search_p2010w34 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w34_pkey ON pgstac.items_search_p2010w34 USING btree (id);

CREATE INDEX items_search_p2010w34_properties_idx ON pgstac.items_search_p2010w34 USING gin (properties);

CREATE INDEX items_search_p2010w35_collection_id_idx ON pgstac.items_search_p2010w35 USING btree (collection_id);

CREATE INDEX items_search_p2010w35_datetime_id_idx ON pgstac.items_search_p2010w35 USING btree (datetime, id);

CREATE INDEX items_search_p2010w35_geometry_idx ON pgstac.items_search_p2010w35 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w35_pkey ON pgstac.items_search_p2010w35 USING btree (id);

CREATE INDEX items_search_p2010w35_properties_idx ON pgstac.items_search_p2010w35 USING gin (properties);

CREATE INDEX items_search_p2010w36_collection_id_idx ON pgstac.items_search_p2010w36 USING btree (collection_id);

CREATE INDEX items_search_p2010w36_datetime_id_idx ON pgstac.items_search_p2010w36 USING btree (datetime, id);

CREATE INDEX items_search_p2010w36_geometry_idx ON pgstac.items_search_p2010w36 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w36_pkey ON pgstac.items_search_p2010w36 USING btree (id);

CREATE INDEX items_search_p2010w36_properties_idx ON pgstac.items_search_p2010w36 USING gin (properties);

CREATE INDEX items_search_p2010w37_collection_id_idx ON pgstac.items_search_p2010w37 USING btree (collection_id);

CREATE INDEX items_search_p2010w37_datetime_id_idx ON pgstac.items_search_p2010w37 USING btree (datetime, id);

CREATE INDEX items_search_p2010w37_geometry_idx ON pgstac.items_search_p2010w37 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w37_pkey ON pgstac.items_search_p2010w37 USING btree (id);

CREATE INDEX items_search_p2010w37_properties_idx ON pgstac.items_search_p2010w37 USING gin (properties);

CREATE INDEX items_search_p2010w38_collection_id_idx ON pgstac.items_search_p2010w38 USING btree (collection_id);

CREATE INDEX items_search_p2010w38_datetime_id_idx ON pgstac.items_search_p2010w38 USING btree (datetime, id);

CREATE INDEX items_search_p2010w38_geometry_idx ON pgstac.items_search_p2010w38 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w38_pkey ON pgstac.items_search_p2010w38 USING btree (id);

CREATE INDEX items_search_p2010w38_properties_idx ON pgstac.items_search_p2010w38 USING gin (properties);

CREATE INDEX items_search_p2010w39_collection_id_idx ON pgstac.items_search_p2010w39 USING btree (collection_id);

CREATE INDEX items_search_p2010w39_datetime_id_idx ON pgstac.items_search_p2010w39 USING btree (datetime, id);

CREATE INDEX items_search_p2010w39_geometry_idx ON pgstac.items_search_p2010w39 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w39_pkey ON pgstac.items_search_p2010w39 USING btree (id);

CREATE INDEX items_search_p2010w39_properties_idx ON pgstac.items_search_p2010w39 USING gin (properties);

CREATE INDEX items_search_p2010w40_collection_id_idx ON pgstac.items_search_p2010w40 USING btree (collection_id);

CREATE INDEX items_search_p2010w40_datetime_id_idx ON pgstac.items_search_p2010w40 USING btree (datetime, id);

CREATE INDEX items_search_p2010w40_geometry_idx ON pgstac.items_search_p2010w40 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w40_pkey ON pgstac.items_search_p2010w40 USING btree (id);

CREATE INDEX items_search_p2010w40_properties_idx ON pgstac.items_search_p2010w40 USING gin (properties);

CREATE INDEX items_search_p2010w41_collection_id_idx ON pgstac.items_search_p2010w41 USING btree (collection_id);

CREATE INDEX items_search_p2010w41_datetime_id_idx ON pgstac.items_search_p2010w41 USING btree (datetime, id);

CREATE INDEX items_search_p2010w41_geometry_idx ON pgstac.items_search_p2010w41 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w41_pkey ON pgstac.items_search_p2010w41 USING btree (id);

CREATE INDEX items_search_p2010w41_properties_idx ON pgstac.items_search_p2010w41 USING gin (properties);

CREATE INDEX items_search_p2010w42_collection_id_idx ON pgstac.items_search_p2010w42 USING btree (collection_id);

CREATE INDEX items_search_p2010w42_datetime_id_idx ON pgstac.items_search_p2010w42 USING btree (datetime, id);

CREATE INDEX items_search_p2010w42_geometry_idx ON pgstac.items_search_p2010w42 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w42_pkey ON pgstac.items_search_p2010w42 USING btree (id);

CREATE INDEX items_search_p2010w42_properties_idx ON pgstac.items_search_p2010w42 USING gin (properties);

CREATE INDEX items_search_p2010w43_collection_id_idx ON pgstac.items_search_p2010w43 USING btree (collection_id);

CREATE INDEX items_search_p2010w43_datetime_id_idx ON pgstac.items_search_p2010w43 USING btree (datetime, id);

CREATE INDEX items_search_p2010w43_geometry_idx ON pgstac.items_search_p2010w43 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w43_pkey ON pgstac.items_search_p2010w43 USING btree (id);

CREATE INDEX items_search_p2010w43_properties_idx ON pgstac.items_search_p2010w43 USING gin (properties);

CREATE INDEX items_search_p2010w44_collection_id_idx ON pgstac.items_search_p2010w44 USING btree (collection_id);

CREATE INDEX items_search_p2010w44_datetime_id_idx ON pgstac.items_search_p2010w44 USING btree (datetime, id);

CREATE INDEX items_search_p2010w44_geometry_idx ON pgstac.items_search_p2010w44 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w44_pkey ON pgstac.items_search_p2010w44 USING btree (id);

CREATE INDEX items_search_p2010w44_properties_idx ON pgstac.items_search_p2010w44 USING gin (properties);

CREATE INDEX items_search_p2010w45_collection_id_idx ON pgstac.items_search_p2010w45 USING btree (collection_id);

CREATE INDEX items_search_p2010w45_datetime_id_idx ON pgstac.items_search_p2010w45 USING btree (datetime, id);

CREATE INDEX items_search_p2010w45_geometry_idx ON pgstac.items_search_p2010w45 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w45_pkey ON pgstac.items_search_p2010w45 USING btree (id);

CREATE INDEX items_search_p2010w45_properties_idx ON pgstac.items_search_p2010w45 USING gin (properties);

CREATE INDEX items_search_p2010w46_collection_id_idx ON pgstac.items_search_p2010w46 USING btree (collection_id);

CREATE INDEX items_search_p2010w46_datetime_id_idx ON pgstac.items_search_p2010w46 USING btree (datetime, id);

CREATE INDEX items_search_p2010w46_geometry_idx ON pgstac.items_search_p2010w46 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w46_pkey ON pgstac.items_search_p2010w46 USING btree (id);

CREATE INDEX items_search_p2010w46_properties_idx ON pgstac.items_search_p2010w46 USING gin (properties);

CREATE INDEX items_search_p2010w47_collection_id_idx ON pgstac.items_search_p2010w47 USING btree (collection_id);

CREATE INDEX items_search_p2010w47_datetime_id_idx ON pgstac.items_search_p2010w47 USING btree (datetime, id);

CREATE INDEX items_search_p2010w47_geometry_idx ON pgstac.items_search_p2010w47 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w47_pkey ON pgstac.items_search_p2010w47 USING btree (id);

CREATE INDEX items_search_p2010w47_properties_idx ON pgstac.items_search_p2010w47 USING gin (properties);

CREATE INDEX items_search_p2010w48_collection_id_idx ON pgstac.items_search_p2010w48 USING btree (collection_id);

CREATE INDEX items_search_p2010w48_datetime_id_idx ON pgstac.items_search_p2010w48 USING btree (datetime, id);

CREATE INDEX items_search_p2010w48_geometry_idx ON pgstac.items_search_p2010w48 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w48_pkey ON pgstac.items_search_p2010w48 USING btree (id);

CREATE INDEX items_search_p2010w48_properties_idx ON pgstac.items_search_p2010w48 USING gin (properties);

CREATE INDEX items_search_p2010w49_collection_id_idx ON pgstac.items_search_p2010w49 USING btree (collection_id);

CREATE INDEX items_search_p2010w49_datetime_id_idx ON pgstac.items_search_p2010w49 USING btree (datetime, id);

CREATE INDEX items_search_p2010w49_geometry_idx ON pgstac.items_search_p2010w49 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w49_pkey ON pgstac.items_search_p2010w49 USING btree (id);

CREATE INDEX items_search_p2010w49_properties_idx ON pgstac.items_search_p2010w49 USING gin (properties);

CREATE INDEX items_search_p2010w50_collection_id_idx ON pgstac.items_search_p2010w50 USING btree (collection_id);

CREATE INDEX items_search_p2010w50_datetime_id_idx ON pgstac.items_search_p2010w50 USING btree (datetime, id);

CREATE INDEX items_search_p2010w50_geometry_idx ON pgstac.items_search_p2010w50 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w50_pkey ON pgstac.items_search_p2010w50 USING btree (id);

CREATE INDEX items_search_p2010w50_properties_idx ON pgstac.items_search_p2010w50 USING gin (properties);

CREATE INDEX items_search_p2010w51_collection_id_idx ON pgstac.items_search_p2010w51 USING btree (collection_id);

CREATE INDEX items_search_p2010w51_datetime_id_idx ON pgstac.items_search_p2010w51 USING btree (datetime, id);

CREATE INDEX items_search_p2010w51_geometry_idx ON pgstac.items_search_p2010w51 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w51_pkey ON pgstac.items_search_p2010w51 USING btree (id);

CREATE INDEX items_search_p2010w51_properties_idx ON pgstac.items_search_p2010w51 USING gin (properties);

CREATE INDEX items_search_p2010w52_collection_id_idx ON pgstac.items_search_p2010w52 USING btree (collection_id);

CREATE INDEX items_search_p2010w52_datetime_id_idx ON pgstac.items_search_p2010w52 USING btree (datetime, id);

CREATE INDEX items_search_p2010w52_geometry_idx ON pgstac.items_search_p2010w52 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2010w52_pkey ON pgstac.items_search_p2010w52 USING btree (id);

CREATE INDEX items_search_p2010w52_properties_idx ON pgstac.items_search_p2010w52 USING gin (properties);

CREATE INDEX items_search_p2011w01_collection_id_idx ON pgstac.items_search_p2011w01 USING btree (collection_id);

CREATE INDEX items_search_p2011w01_datetime_id_idx ON pgstac.items_search_p2011w01 USING btree (datetime, id);

CREATE INDEX items_search_p2011w01_geometry_idx ON pgstac.items_search_p2011w01 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w01_pkey ON pgstac.items_search_p2011w01 USING btree (id);

CREATE INDEX items_search_p2011w01_properties_idx ON pgstac.items_search_p2011w01 USING gin (properties);

CREATE INDEX items_search_p2011w02_collection_id_idx ON pgstac.items_search_p2011w02 USING btree (collection_id);

CREATE INDEX items_search_p2011w02_datetime_id_idx ON pgstac.items_search_p2011w02 USING btree (datetime, id);

CREATE INDEX items_search_p2011w02_geometry_idx ON pgstac.items_search_p2011w02 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w02_pkey ON pgstac.items_search_p2011w02 USING btree (id);

CREATE INDEX items_search_p2011w02_properties_idx ON pgstac.items_search_p2011w02 USING gin (properties);

CREATE INDEX items_search_p2011w03_collection_id_idx ON pgstac.items_search_p2011w03 USING btree (collection_id);

CREATE INDEX items_search_p2011w03_datetime_id_idx ON pgstac.items_search_p2011w03 USING btree (datetime, id);

CREATE INDEX items_search_p2011w03_geometry_idx ON pgstac.items_search_p2011w03 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w03_pkey ON pgstac.items_search_p2011w03 USING btree (id);

CREATE INDEX items_search_p2011w03_properties_idx ON pgstac.items_search_p2011w03 USING gin (properties);

CREATE INDEX items_search_p2011w04_collection_id_idx ON pgstac.items_search_p2011w04 USING btree (collection_id);

CREATE INDEX items_search_p2011w04_datetime_id_idx ON pgstac.items_search_p2011w04 USING btree (datetime, id);

CREATE INDEX items_search_p2011w04_geometry_idx ON pgstac.items_search_p2011w04 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w04_pkey ON pgstac.items_search_p2011w04 USING btree (id);

CREATE INDEX items_search_p2011w04_properties_idx ON pgstac.items_search_p2011w04 USING gin (properties);

CREATE INDEX items_search_p2011w05_collection_id_idx ON pgstac.items_search_p2011w05 USING btree (collection_id);

CREATE INDEX items_search_p2011w05_datetime_id_idx ON pgstac.items_search_p2011w05 USING btree (datetime, id);

CREATE INDEX items_search_p2011w05_geometry_idx ON pgstac.items_search_p2011w05 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w05_pkey ON pgstac.items_search_p2011w05 USING btree (id);

CREATE INDEX items_search_p2011w05_properties_idx ON pgstac.items_search_p2011w05 USING gin (properties);

CREATE INDEX items_search_p2011w06_collection_id_idx ON pgstac.items_search_p2011w06 USING btree (collection_id);

CREATE INDEX items_search_p2011w06_datetime_id_idx ON pgstac.items_search_p2011w06 USING btree (datetime, id);

CREATE INDEX items_search_p2011w06_geometry_idx ON pgstac.items_search_p2011w06 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w06_pkey ON pgstac.items_search_p2011w06 USING btree (id);

CREATE INDEX items_search_p2011w06_properties_idx ON pgstac.items_search_p2011w06 USING gin (properties);

CREATE INDEX items_search_p2011w07_collection_id_idx ON pgstac.items_search_p2011w07 USING btree (collection_id);

CREATE INDEX items_search_p2011w07_datetime_id_idx ON pgstac.items_search_p2011w07 USING btree (datetime, id);

CREATE INDEX items_search_p2011w07_geometry_idx ON pgstac.items_search_p2011w07 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w07_pkey ON pgstac.items_search_p2011w07 USING btree (id);

CREATE INDEX items_search_p2011w07_properties_idx ON pgstac.items_search_p2011w07 USING gin (properties);

CREATE INDEX items_search_p2011w08_collection_id_idx ON pgstac.items_search_p2011w08 USING btree (collection_id);

CREATE INDEX items_search_p2011w08_datetime_id_idx ON pgstac.items_search_p2011w08 USING btree (datetime, id);

CREATE INDEX items_search_p2011w08_geometry_idx ON pgstac.items_search_p2011w08 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w08_pkey ON pgstac.items_search_p2011w08 USING btree (id);

CREATE INDEX items_search_p2011w08_properties_idx ON pgstac.items_search_p2011w08 USING gin (properties);

CREATE INDEX items_search_p2011w09_collection_id_idx ON pgstac.items_search_p2011w09 USING btree (collection_id);

CREATE INDEX items_search_p2011w09_datetime_id_idx ON pgstac.items_search_p2011w09 USING btree (datetime, id);

CREATE INDEX items_search_p2011w09_geometry_idx ON pgstac.items_search_p2011w09 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w09_pkey ON pgstac.items_search_p2011w09 USING btree (id);

CREATE INDEX items_search_p2011w09_properties_idx ON pgstac.items_search_p2011w09 USING gin (properties);

CREATE INDEX items_search_p2011w10_collection_id_idx ON pgstac.items_search_p2011w10 USING btree (collection_id);

CREATE INDEX items_search_p2011w10_datetime_id_idx ON pgstac.items_search_p2011w10 USING btree (datetime, id);

CREATE INDEX items_search_p2011w10_geometry_idx ON pgstac.items_search_p2011w10 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w10_pkey ON pgstac.items_search_p2011w10 USING btree (id);

CREATE INDEX items_search_p2011w10_properties_idx ON pgstac.items_search_p2011w10 USING gin (properties);

CREATE INDEX items_search_p2011w11_collection_id_idx ON pgstac.items_search_p2011w11 USING btree (collection_id);

CREATE INDEX items_search_p2011w11_datetime_id_idx ON pgstac.items_search_p2011w11 USING btree (datetime, id);

CREATE INDEX items_search_p2011w11_geometry_idx ON pgstac.items_search_p2011w11 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w11_pkey ON pgstac.items_search_p2011w11 USING btree (id);

CREATE INDEX items_search_p2011w11_properties_idx ON pgstac.items_search_p2011w11 USING gin (properties);

CREATE INDEX items_search_p2011w12_collection_id_idx ON pgstac.items_search_p2011w12 USING btree (collection_id);

CREATE INDEX items_search_p2011w12_datetime_id_idx ON pgstac.items_search_p2011w12 USING btree (datetime, id);

CREATE INDEX items_search_p2011w12_geometry_idx ON pgstac.items_search_p2011w12 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w12_pkey ON pgstac.items_search_p2011w12 USING btree (id);

CREATE INDEX items_search_p2011w12_properties_idx ON pgstac.items_search_p2011w12 USING gin (properties);

CREATE INDEX items_search_p2011w13_collection_id_idx ON pgstac.items_search_p2011w13 USING btree (collection_id);

CREATE INDEX items_search_p2011w13_datetime_id_idx ON pgstac.items_search_p2011w13 USING btree (datetime, id);

CREATE INDEX items_search_p2011w13_geometry_idx ON pgstac.items_search_p2011w13 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w13_pkey ON pgstac.items_search_p2011w13 USING btree (id);

CREATE INDEX items_search_p2011w13_properties_idx ON pgstac.items_search_p2011w13 USING gin (properties);

CREATE INDEX items_search_p2011w14_collection_id_idx ON pgstac.items_search_p2011w14 USING btree (collection_id);

CREATE INDEX items_search_p2011w14_datetime_id_idx ON pgstac.items_search_p2011w14 USING btree (datetime, id);

CREATE INDEX items_search_p2011w14_geometry_idx ON pgstac.items_search_p2011w14 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w14_pkey ON pgstac.items_search_p2011w14 USING btree (id);

CREATE INDEX items_search_p2011w14_properties_idx ON pgstac.items_search_p2011w14 USING gin (properties);

CREATE INDEX items_search_p2011w15_collection_id_idx ON pgstac.items_search_p2011w15 USING btree (collection_id);

CREATE INDEX items_search_p2011w15_datetime_id_idx ON pgstac.items_search_p2011w15 USING btree (datetime, id);

CREATE INDEX items_search_p2011w15_geometry_idx ON pgstac.items_search_p2011w15 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w15_pkey ON pgstac.items_search_p2011w15 USING btree (id);

CREATE INDEX items_search_p2011w15_properties_idx ON pgstac.items_search_p2011w15 USING gin (properties);

CREATE INDEX items_search_p2011w16_collection_id_idx ON pgstac.items_search_p2011w16 USING btree (collection_id);

CREATE INDEX items_search_p2011w16_datetime_id_idx ON pgstac.items_search_p2011w16 USING btree (datetime, id);

CREATE INDEX items_search_p2011w16_geometry_idx ON pgstac.items_search_p2011w16 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w16_pkey ON pgstac.items_search_p2011w16 USING btree (id);

CREATE INDEX items_search_p2011w16_properties_idx ON pgstac.items_search_p2011w16 USING gin (properties);

CREATE INDEX items_search_p2011w17_collection_id_idx ON pgstac.items_search_p2011w17 USING btree (collection_id);

CREATE INDEX items_search_p2011w17_datetime_id_idx ON pgstac.items_search_p2011w17 USING btree (datetime, id);

CREATE INDEX items_search_p2011w17_geometry_idx ON pgstac.items_search_p2011w17 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w17_pkey ON pgstac.items_search_p2011w17 USING btree (id);

CREATE INDEX items_search_p2011w17_properties_idx ON pgstac.items_search_p2011w17 USING gin (properties);

CREATE INDEX items_search_p2011w18_collection_id_idx ON pgstac.items_search_p2011w18 USING btree (collection_id);

CREATE INDEX items_search_p2011w18_datetime_id_idx ON pgstac.items_search_p2011w18 USING btree (datetime, id);

CREATE INDEX items_search_p2011w18_geometry_idx ON pgstac.items_search_p2011w18 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w18_pkey ON pgstac.items_search_p2011w18 USING btree (id);

CREATE INDEX items_search_p2011w18_properties_idx ON pgstac.items_search_p2011w18 USING gin (properties);

CREATE INDEX items_search_p2011w19_collection_id_idx ON pgstac.items_search_p2011w19 USING btree (collection_id);

CREATE INDEX items_search_p2011w19_datetime_id_idx ON pgstac.items_search_p2011w19 USING btree (datetime, id);

CREATE INDEX items_search_p2011w19_geometry_idx ON pgstac.items_search_p2011w19 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w19_pkey ON pgstac.items_search_p2011w19 USING btree (id);

CREATE INDEX items_search_p2011w19_properties_idx ON pgstac.items_search_p2011w19 USING gin (properties);

CREATE INDEX items_search_p2011w20_collection_id_idx ON pgstac.items_search_p2011w20 USING btree (collection_id);

CREATE INDEX items_search_p2011w20_datetime_id_idx ON pgstac.items_search_p2011w20 USING btree (datetime, id);

CREATE INDEX items_search_p2011w20_geometry_idx ON pgstac.items_search_p2011w20 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w20_pkey ON pgstac.items_search_p2011w20 USING btree (id);

CREATE INDEX items_search_p2011w20_properties_idx ON pgstac.items_search_p2011w20 USING gin (properties);

CREATE INDEX items_search_p2011w21_collection_id_idx ON pgstac.items_search_p2011w21 USING btree (collection_id);

CREATE INDEX items_search_p2011w21_datetime_id_idx ON pgstac.items_search_p2011w21 USING btree (datetime, id);

CREATE INDEX items_search_p2011w21_geometry_idx ON pgstac.items_search_p2011w21 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w21_pkey ON pgstac.items_search_p2011w21 USING btree (id);

CREATE INDEX items_search_p2011w21_properties_idx ON pgstac.items_search_p2011w21 USING gin (properties);

CREATE INDEX items_search_p2011w22_collection_id_idx ON pgstac.items_search_p2011w22 USING btree (collection_id);

CREATE INDEX items_search_p2011w22_datetime_id_idx ON pgstac.items_search_p2011w22 USING btree (datetime, id);

CREATE INDEX items_search_p2011w22_geometry_idx ON pgstac.items_search_p2011w22 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w22_pkey ON pgstac.items_search_p2011w22 USING btree (id);

CREATE INDEX items_search_p2011w22_properties_idx ON pgstac.items_search_p2011w22 USING gin (properties);

CREATE INDEX items_search_p2011w23_collection_id_idx ON pgstac.items_search_p2011w23 USING btree (collection_id);

CREATE INDEX items_search_p2011w23_datetime_id_idx ON pgstac.items_search_p2011w23 USING btree (datetime, id);

CREATE INDEX items_search_p2011w23_geometry_idx ON pgstac.items_search_p2011w23 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w23_pkey ON pgstac.items_search_p2011w23 USING btree (id);

CREATE INDEX items_search_p2011w23_properties_idx ON pgstac.items_search_p2011w23 USING gin (properties);

CREATE INDEX items_search_p2011w24_collection_id_idx ON pgstac.items_search_p2011w24 USING btree (collection_id);

CREATE INDEX items_search_p2011w24_datetime_id_idx ON pgstac.items_search_p2011w24 USING btree (datetime, id);

CREATE INDEX items_search_p2011w24_geometry_idx ON pgstac.items_search_p2011w24 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w24_pkey ON pgstac.items_search_p2011w24 USING btree (id);

CREATE INDEX items_search_p2011w24_properties_idx ON pgstac.items_search_p2011w24 USING gin (properties);

CREATE INDEX items_search_p2011w25_collection_id_idx ON pgstac.items_search_p2011w25 USING btree (collection_id);

CREATE INDEX items_search_p2011w25_datetime_id_idx ON pgstac.items_search_p2011w25 USING btree (datetime, id);

CREATE INDEX items_search_p2011w25_geometry_idx ON pgstac.items_search_p2011w25 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w25_pkey ON pgstac.items_search_p2011w25 USING btree (id);

CREATE INDEX items_search_p2011w25_properties_idx ON pgstac.items_search_p2011w25 USING gin (properties);

CREATE INDEX items_search_p2011w26_collection_id_idx ON pgstac.items_search_p2011w26 USING btree (collection_id);

CREATE INDEX items_search_p2011w26_datetime_id_idx ON pgstac.items_search_p2011w26 USING btree (datetime, id);

CREATE INDEX items_search_p2011w26_geometry_idx ON pgstac.items_search_p2011w26 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w26_pkey ON pgstac.items_search_p2011w26 USING btree (id);

CREATE INDEX items_search_p2011w26_properties_idx ON pgstac.items_search_p2011w26 USING gin (properties);

CREATE INDEX items_search_p2011w27_collection_id_idx ON pgstac.items_search_p2011w27 USING btree (collection_id);

CREATE INDEX items_search_p2011w27_datetime_id_idx ON pgstac.items_search_p2011w27 USING btree (datetime, id);

CREATE INDEX items_search_p2011w27_geometry_idx ON pgstac.items_search_p2011w27 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w27_pkey ON pgstac.items_search_p2011w27 USING btree (id);

CREATE INDEX items_search_p2011w27_properties_idx ON pgstac.items_search_p2011w27 USING gin (properties);

CREATE INDEX items_search_p2011w28_collection_id_idx ON pgstac.items_search_p2011w28 USING btree (collection_id);

CREATE INDEX items_search_p2011w28_datetime_id_idx ON pgstac.items_search_p2011w28 USING btree (datetime, id);

CREATE INDEX items_search_p2011w28_geometry_idx ON pgstac.items_search_p2011w28 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w28_pkey ON pgstac.items_search_p2011w28 USING btree (id);

CREATE INDEX items_search_p2011w28_properties_idx ON pgstac.items_search_p2011w28 USING gin (properties);

CREATE INDEX items_search_p2011w29_collection_id_idx ON pgstac.items_search_p2011w29 USING btree (collection_id);

CREATE INDEX items_search_p2011w29_datetime_id_idx ON pgstac.items_search_p2011w29 USING btree (datetime, id);

CREATE INDEX items_search_p2011w29_geometry_idx ON pgstac.items_search_p2011w29 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w29_pkey ON pgstac.items_search_p2011w29 USING btree (id);

CREATE INDEX items_search_p2011w29_properties_idx ON pgstac.items_search_p2011w29 USING gin (properties);

CREATE INDEX items_search_p2011w30_collection_id_idx ON pgstac.items_search_p2011w30 USING btree (collection_id);

CREATE INDEX items_search_p2011w30_datetime_id_idx ON pgstac.items_search_p2011w30 USING btree (datetime, id);

CREATE INDEX items_search_p2011w30_geometry_idx ON pgstac.items_search_p2011w30 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w30_pkey ON pgstac.items_search_p2011w30 USING btree (id);

CREATE INDEX items_search_p2011w30_properties_idx ON pgstac.items_search_p2011w30 USING gin (properties);

CREATE INDEX items_search_p2011w31_collection_id_idx ON pgstac.items_search_p2011w31 USING btree (collection_id);

CREATE INDEX items_search_p2011w31_datetime_id_idx ON pgstac.items_search_p2011w31 USING btree (datetime, id);

CREATE INDEX items_search_p2011w31_geometry_idx ON pgstac.items_search_p2011w31 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w31_pkey ON pgstac.items_search_p2011w31 USING btree (id);

CREATE INDEX items_search_p2011w31_properties_idx ON pgstac.items_search_p2011w31 USING gin (properties);

CREATE INDEX items_search_p2011w32_collection_id_idx ON pgstac.items_search_p2011w32 USING btree (collection_id);

CREATE INDEX items_search_p2011w32_datetime_id_idx ON pgstac.items_search_p2011w32 USING btree (datetime, id);

CREATE INDEX items_search_p2011w32_geometry_idx ON pgstac.items_search_p2011w32 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w32_pkey ON pgstac.items_search_p2011w32 USING btree (id);

CREATE INDEX items_search_p2011w32_properties_idx ON pgstac.items_search_p2011w32 USING gin (properties);

CREATE INDEX items_search_p2011w33_collection_id_idx ON pgstac.items_search_p2011w33 USING btree (collection_id);

CREATE INDEX items_search_p2011w33_datetime_id_idx ON pgstac.items_search_p2011w33 USING btree (datetime, id);

CREATE INDEX items_search_p2011w33_geometry_idx ON pgstac.items_search_p2011w33 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w33_pkey ON pgstac.items_search_p2011w33 USING btree (id);

CREATE INDEX items_search_p2011w33_properties_idx ON pgstac.items_search_p2011w33 USING gin (properties);

CREATE INDEX items_search_p2011w34_collection_id_idx ON pgstac.items_search_p2011w34 USING btree (collection_id);

CREATE INDEX items_search_p2011w34_datetime_id_idx ON pgstac.items_search_p2011w34 USING btree (datetime, id);

CREATE INDEX items_search_p2011w34_geometry_idx ON pgstac.items_search_p2011w34 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w34_pkey ON pgstac.items_search_p2011w34 USING btree (id);

CREATE INDEX items_search_p2011w34_properties_idx ON pgstac.items_search_p2011w34 USING gin (properties);

CREATE INDEX items_search_p2011w35_collection_id_idx ON pgstac.items_search_p2011w35 USING btree (collection_id);

CREATE INDEX items_search_p2011w35_datetime_id_idx ON pgstac.items_search_p2011w35 USING btree (datetime, id);

CREATE INDEX items_search_p2011w35_geometry_idx ON pgstac.items_search_p2011w35 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w35_pkey ON pgstac.items_search_p2011w35 USING btree (id);

CREATE INDEX items_search_p2011w35_properties_idx ON pgstac.items_search_p2011w35 USING gin (properties);

CREATE INDEX items_search_p2011w36_collection_id_idx ON pgstac.items_search_p2011w36 USING btree (collection_id);

CREATE INDEX items_search_p2011w36_datetime_id_idx ON pgstac.items_search_p2011w36 USING btree (datetime, id);

CREATE INDEX items_search_p2011w36_geometry_idx ON pgstac.items_search_p2011w36 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w36_pkey ON pgstac.items_search_p2011w36 USING btree (id);

CREATE INDEX items_search_p2011w36_properties_idx ON pgstac.items_search_p2011w36 USING gin (properties);

CREATE INDEX items_search_p2011w37_collection_id_idx ON pgstac.items_search_p2011w37 USING btree (collection_id);

CREATE INDEX items_search_p2011w37_datetime_id_idx ON pgstac.items_search_p2011w37 USING btree (datetime, id);

CREATE INDEX items_search_p2011w37_geometry_idx ON pgstac.items_search_p2011w37 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w37_pkey ON pgstac.items_search_p2011w37 USING btree (id);

CREATE INDEX items_search_p2011w37_properties_idx ON pgstac.items_search_p2011w37 USING gin (properties);

CREATE INDEX items_search_p2011w38_collection_id_idx ON pgstac.items_search_p2011w38 USING btree (collection_id);

CREATE INDEX items_search_p2011w38_datetime_id_idx ON pgstac.items_search_p2011w38 USING btree (datetime, id);

CREATE INDEX items_search_p2011w38_geometry_idx ON pgstac.items_search_p2011w38 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w38_pkey ON pgstac.items_search_p2011w38 USING btree (id);

CREATE INDEX items_search_p2011w38_properties_idx ON pgstac.items_search_p2011w38 USING gin (properties);

CREATE INDEX items_search_p2011w39_collection_id_idx ON pgstac.items_search_p2011w39 USING btree (collection_id);

CREATE INDEX items_search_p2011w39_datetime_id_idx ON pgstac.items_search_p2011w39 USING btree (datetime, id);

CREATE INDEX items_search_p2011w39_geometry_idx ON pgstac.items_search_p2011w39 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w39_pkey ON pgstac.items_search_p2011w39 USING btree (id);

CREATE INDEX items_search_p2011w39_properties_idx ON pgstac.items_search_p2011w39 USING gin (properties);

CREATE INDEX items_search_p2011w40_collection_id_idx ON pgstac.items_search_p2011w40 USING btree (collection_id);

CREATE INDEX items_search_p2011w40_datetime_id_idx ON pgstac.items_search_p2011w40 USING btree (datetime, id);

CREATE INDEX items_search_p2011w40_geometry_idx ON pgstac.items_search_p2011w40 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w40_pkey ON pgstac.items_search_p2011w40 USING btree (id);

CREATE INDEX items_search_p2011w40_properties_idx ON pgstac.items_search_p2011w40 USING gin (properties);

CREATE INDEX items_search_p2011w41_collection_id_idx ON pgstac.items_search_p2011w41 USING btree (collection_id);

CREATE INDEX items_search_p2011w41_datetime_id_idx ON pgstac.items_search_p2011w41 USING btree (datetime, id);

CREATE INDEX items_search_p2011w41_geometry_idx ON pgstac.items_search_p2011w41 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w41_pkey ON pgstac.items_search_p2011w41 USING btree (id);

CREATE INDEX items_search_p2011w41_properties_idx ON pgstac.items_search_p2011w41 USING gin (properties);

CREATE INDEX items_search_p2011w42_collection_id_idx ON pgstac.items_search_p2011w42 USING btree (collection_id);

CREATE INDEX items_search_p2011w42_datetime_id_idx ON pgstac.items_search_p2011w42 USING btree (datetime, id);

CREATE INDEX items_search_p2011w42_geometry_idx ON pgstac.items_search_p2011w42 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w42_pkey ON pgstac.items_search_p2011w42 USING btree (id);

CREATE INDEX items_search_p2011w42_properties_idx ON pgstac.items_search_p2011w42 USING gin (properties);

CREATE INDEX items_search_p2011w43_collection_id_idx ON pgstac.items_search_p2011w43 USING btree (collection_id);

CREATE INDEX items_search_p2011w43_datetime_id_idx ON pgstac.items_search_p2011w43 USING btree (datetime, id);

CREATE INDEX items_search_p2011w43_geometry_idx ON pgstac.items_search_p2011w43 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w43_pkey ON pgstac.items_search_p2011w43 USING btree (id);

CREATE INDEX items_search_p2011w43_properties_idx ON pgstac.items_search_p2011w43 USING gin (properties);

CREATE INDEX items_search_p2011w44_collection_id_idx ON pgstac.items_search_p2011w44 USING btree (collection_id);

CREATE INDEX items_search_p2011w44_datetime_id_idx ON pgstac.items_search_p2011w44 USING btree (datetime, id);

CREATE INDEX items_search_p2011w44_geometry_idx ON pgstac.items_search_p2011w44 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w44_pkey ON pgstac.items_search_p2011w44 USING btree (id);

CREATE INDEX items_search_p2011w44_properties_idx ON pgstac.items_search_p2011w44 USING gin (properties);

CREATE INDEX items_search_p2011w45_collection_id_idx ON pgstac.items_search_p2011w45 USING btree (collection_id);

CREATE INDEX items_search_p2011w45_datetime_id_idx ON pgstac.items_search_p2011w45 USING btree (datetime, id);

CREATE INDEX items_search_p2011w45_geometry_idx ON pgstac.items_search_p2011w45 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w45_pkey ON pgstac.items_search_p2011w45 USING btree (id);

CREATE INDEX items_search_p2011w45_properties_idx ON pgstac.items_search_p2011w45 USING gin (properties);

CREATE INDEX items_search_p2011w46_collection_id_idx ON pgstac.items_search_p2011w46 USING btree (collection_id);

CREATE INDEX items_search_p2011w46_datetime_id_idx ON pgstac.items_search_p2011w46 USING btree (datetime, id);

CREATE INDEX items_search_p2011w46_geometry_idx ON pgstac.items_search_p2011w46 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w46_pkey ON pgstac.items_search_p2011w46 USING btree (id);

CREATE INDEX items_search_p2011w46_properties_idx ON pgstac.items_search_p2011w46 USING gin (properties);

CREATE INDEX items_search_p2011w47_collection_id_idx ON pgstac.items_search_p2011w47 USING btree (collection_id);

CREATE INDEX items_search_p2011w47_datetime_id_idx ON pgstac.items_search_p2011w47 USING btree (datetime, id);

CREATE INDEX items_search_p2011w47_geometry_idx ON pgstac.items_search_p2011w47 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w47_pkey ON pgstac.items_search_p2011w47 USING btree (id);

CREATE INDEX items_search_p2011w47_properties_idx ON pgstac.items_search_p2011w47 USING gin (properties);

CREATE INDEX items_search_p2011w48_collection_id_idx ON pgstac.items_search_p2011w48 USING btree (collection_id);

CREATE INDEX items_search_p2011w48_datetime_id_idx ON pgstac.items_search_p2011w48 USING btree (datetime, id);

CREATE INDEX items_search_p2011w48_geometry_idx ON pgstac.items_search_p2011w48 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w48_pkey ON pgstac.items_search_p2011w48 USING btree (id);

CREATE INDEX items_search_p2011w48_properties_idx ON pgstac.items_search_p2011w48 USING gin (properties);

CREATE INDEX items_search_p2011w49_collection_id_idx ON pgstac.items_search_p2011w49 USING btree (collection_id);

CREATE INDEX items_search_p2011w49_datetime_id_idx ON pgstac.items_search_p2011w49 USING btree (datetime, id);

CREATE INDEX items_search_p2011w49_geometry_idx ON pgstac.items_search_p2011w49 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w49_pkey ON pgstac.items_search_p2011w49 USING btree (id);

CREATE INDEX items_search_p2011w49_properties_idx ON pgstac.items_search_p2011w49 USING gin (properties);

CREATE INDEX items_search_p2011w50_collection_id_idx ON pgstac.items_search_p2011w50 USING btree (collection_id);

CREATE INDEX items_search_p2011w50_datetime_id_idx ON pgstac.items_search_p2011w50 USING btree (datetime, id);

CREATE INDEX items_search_p2011w50_geometry_idx ON pgstac.items_search_p2011w50 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w50_pkey ON pgstac.items_search_p2011w50 USING btree (id);

CREATE INDEX items_search_p2011w50_properties_idx ON pgstac.items_search_p2011w50 USING gin (properties);

CREATE INDEX items_search_p2011w51_collection_id_idx ON pgstac.items_search_p2011w51 USING btree (collection_id);

CREATE INDEX items_search_p2011w51_datetime_id_idx ON pgstac.items_search_p2011w51 USING btree (datetime, id);

CREATE INDEX items_search_p2011w51_geometry_idx ON pgstac.items_search_p2011w51 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w51_pkey ON pgstac.items_search_p2011w51 USING btree (id);

CREATE INDEX items_search_p2011w51_properties_idx ON pgstac.items_search_p2011w51 USING gin (properties);

CREATE INDEX items_search_p2011w52_collection_id_idx ON pgstac.items_search_p2011w52 USING btree (collection_id);

CREATE INDEX items_search_p2011w52_datetime_id_idx ON pgstac.items_search_p2011w52 USING btree (datetime, id);

CREATE INDEX items_search_p2011w52_geometry_idx ON pgstac.items_search_p2011w52 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2011w52_pkey ON pgstac.items_search_p2011w52 USING btree (id);

CREATE INDEX items_search_p2011w52_properties_idx ON pgstac.items_search_p2011w52 USING gin (properties);

CREATE INDEX items_search_p2012w01_collection_id_idx ON pgstac.items_search_p2012w01 USING btree (collection_id);

CREATE INDEX items_search_p2012w01_datetime_id_idx ON pgstac.items_search_p2012w01 USING btree (datetime, id);

CREATE INDEX items_search_p2012w01_geometry_idx ON pgstac.items_search_p2012w01 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w01_pkey ON pgstac.items_search_p2012w01 USING btree (id);

CREATE INDEX items_search_p2012w01_properties_idx ON pgstac.items_search_p2012w01 USING gin (properties);

CREATE INDEX items_search_p2012w02_collection_id_idx ON pgstac.items_search_p2012w02 USING btree (collection_id);

CREATE INDEX items_search_p2012w02_datetime_id_idx ON pgstac.items_search_p2012w02 USING btree (datetime, id);

CREATE INDEX items_search_p2012w02_geometry_idx ON pgstac.items_search_p2012w02 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w02_pkey ON pgstac.items_search_p2012w02 USING btree (id);

CREATE INDEX items_search_p2012w02_properties_idx ON pgstac.items_search_p2012w02 USING gin (properties);

CREATE INDEX items_search_p2012w03_collection_id_idx ON pgstac.items_search_p2012w03 USING btree (collection_id);

CREATE INDEX items_search_p2012w03_datetime_id_idx ON pgstac.items_search_p2012w03 USING btree (datetime, id);

CREATE INDEX items_search_p2012w03_geometry_idx ON pgstac.items_search_p2012w03 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w03_pkey ON pgstac.items_search_p2012w03 USING btree (id);

CREATE INDEX items_search_p2012w03_properties_idx ON pgstac.items_search_p2012w03 USING gin (properties);

CREATE INDEX items_search_p2012w04_collection_id_idx ON pgstac.items_search_p2012w04 USING btree (collection_id);

CREATE INDEX items_search_p2012w04_datetime_id_idx ON pgstac.items_search_p2012w04 USING btree (datetime, id);

CREATE INDEX items_search_p2012w04_geometry_idx ON pgstac.items_search_p2012w04 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w04_pkey ON pgstac.items_search_p2012w04 USING btree (id);

CREATE INDEX items_search_p2012w04_properties_idx ON pgstac.items_search_p2012w04 USING gin (properties);

CREATE INDEX items_search_p2012w05_collection_id_idx ON pgstac.items_search_p2012w05 USING btree (collection_id);

CREATE INDEX items_search_p2012w05_datetime_id_idx ON pgstac.items_search_p2012w05 USING btree (datetime, id);

CREATE INDEX items_search_p2012w05_geometry_idx ON pgstac.items_search_p2012w05 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w05_pkey ON pgstac.items_search_p2012w05 USING btree (id);

CREATE INDEX items_search_p2012w05_properties_idx ON pgstac.items_search_p2012w05 USING gin (properties);

CREATE INDEX items_search_p2012w06_collection_id_idx ON pgstac.items_search_p2012w06 USING btree (collection_id);

CREATE INDEX items_search_p2012w06_datetime_id_idx ON pgstac.items_search_p2012w06 USING btree (datetime, id);

CREATE INDEX items_search_p2012w06_geometry_idx ON pgstac.items_search_p2012w06 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w06_pkey ON pgstac.items_search_p2012w06 USING btree (id);

CREATE INDEX items_search_p2012w06_properties_idx ON pgstac.items_search_p2012w06 USING gin (properties);

CREATE INDEX items_search_p2012w07_collection_id_idx ON pgstac.items_search_p2012w07 USING btree (collection_id);

CREATE INDEX items_search_p2012w07_datetime_id_idx ON pgstac.items_search_p2012w07 USING btree (datetime, id);

CREATE INDEX items_search_p2012w07_geometry_idx ON pgstac.items_search_p2012w07 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w07_pkey ON pgstac.items_search_p2012w07 USING btree (id);

CREATE INDEX items_search_p2012w07_properties_idx ON pgstac.items_search_p2012w07 USING gin (properties);

CREATE INDEX items_search_p2012w08_collection_id_idx ON pgstac.items_search_p2012w08 USING btree (collection_id);

CREATE INDEX items_search_p2012w08_datetime_id_idx ON pgstac.items_search_p2012w08 USING btree (datetime, id);

CREATE INDEX items_search_p2012w08_geometry_idx ON pgstac.items_search_p2012w08 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w08_pkey ON pgstac.items_search_p2012w08 USING btree (id);

CREATE INDEX items_search_p2012w08_properties_idx ON pgstac.items_search_p2012w08 USING gin (properties);

CREATE INDEX items_search_p2012w09_collection_id_idx ON pgstac.items_search_p2012w09 USING btree (collection_id);

CREATE INDEX items_search_p2012w09_datetime_id_idx ON pgstac.items_search_p2012w09 USING btree (datetime, id);

CREATE INDEX items_search_p2012w09_geometry_idx ON pgstac.items_search_p2012w09 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w09_pkey ON pgstac.items_search_p2012w09 USING btree (id);

CREATE INDEX items_search_p2012w09_properties_idx ON pgstac.items_search_p2012w09 USING gin (properties);

CREATE INDEX items_search_p2012w10_collection_id_idx ON pgstac.items_search_p2012w10 USING btree (collection_id);

CREATE INDEX items_search_p2012w10_datetime_id_idx ON pgstac.items_search_p2012w10 USING btree (datetime, id);

CREATE INDEX items_search_p2012w10_geometry_idx ON pgstac.items_search_p2012w10 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w10_pkey ON pgstac.items_search_p2012w10 USING btree (id);

CREATE INDEX items_search_p2012w10_properties_idx ON pgstac.items_search_p2012w10 USING gin (properties);

CREATE INDEX items_search_p2012w11_collection_id_idx ON pgstac.items_search_p2012w11 USING btree (collection_id);

CREATE INDEX items_search_p2012w11_datetime_id_idx ON pgstac.items_search_p2012w11 USING btree (datetime, id);

CREATE INDEX items_search_p2012w11_geometry_idx ON pgstac.items_search_p2012w11 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w11_pkey ON pgstac.items_search_p2012w11 USING btree (id);

CREATE INDEX items_search_p2012w11_properties_idx ON pgstac.items_search_p2012w11 USING gin (properties);

CREATE INDEX items_search_p2012w12_collection_id_idx ON pgstac.items_search_p2012w12 USING btree (collection_id);

CREATE INDEX items_search_p2012w12_datetime_id_idx ON pgstac.items_search_p2012w12 USING btree (datetime, id);

CREATE INDEX items_search_p2012w12_geometry_idx ON pgstac.items_search_p2012w12 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w12_pkey ON pgstac.items_search_p2012w12 USING btree (id);

CREATE INDEX items_search_p2012w12_properties_idx ON pgstac.items_search_p2012w12 USING gin (properties);

CREATE INDEX items_search_p2012w13_collection_id_idx ON pgstac.items_search_p2012w13 USING btree (collection_id);

CREATE INDEX items_search_p2012w13_datetime_id_idx ON pgstac.items_search_p2012w13 USING btree (datetime, id);

CREATE INDEX items_search_p2012w13_geometry_idx ON pgstac.items_search_p2012w13 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w13_pkey ON pgstac.items_search_p2012w13 USING btree (id);

CREATE INDEX items_search_p2012w13_properties_idx ON pgstac.items_search_p2012w13 USING gin (properties);

CREATE INDEX items_search_p2012w14_collection_id_idx ON pgstac.items_search_p2012w14 USING btree (collection_id);

CREATE INDEX items_search_p2012w14_datetime_id_idx ON pgstac.items_search_p2012w14 USING btree (datetime, id);

CREATE INDEX items_search_p2012w14_geometry_idx ON pgstac.items_search_p2012w14 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w14_pkey ON pgstac.items_search_p2012w14 USING btree (id);

CREATE INDEX items_search_p2012w14_properties_idx ON pgstac.items_search_p2012w14 USING gin (properties);

CREATE INDEX items_search_p2012w15_collection_id_idx ON pgstac.items_search_p2012w15 USING btree (collection_id);

CREATE INDEX items_search_p2012w15_datetime_id_idx ON pgstac.items_search_p2012w15 USING btree (datetime, id);

CREATE INDEX items_search_p2012w15_geometry_idx ON pgstac.items_search_p2012w15 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w15_pkey ON pgstac.items_search_p2012w15 USING btree (id);

CREATE INDEX items_search_p2012w15_properties_idx ON pgstac.items_search_p2012w15 USING gin (properties);

CREATE INDEX items_search_p2012w16_collection_id_idx ON pgstac.items_search_p2012w16 USING btree (collection_id);

CREATE INDEX items_search_p2012w16_datetime_id_idx ON pgstac.items_search_p2012w16 USING btree (datetime, id);

CREATE INDEX items_search_p2012w16_geometry_idx ON pgstac.items_search_p2012w16 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w16_pkey ON pgstac.items_search_p2012w16 USING btree (id);

CREATE INDEX items_search_p2012w16_properties_idx ON pgstac.items_search_p2012w16 USING gin (properties);

CREATE INDEX items_search_p2012w17_collection_id_idx ON pgstac.items_search_p2012w17 USING btree (collection_id);

CREATE INDEX items_search_p2012w17_datetime_id_idx ON pgstac.items_search_p2012w17 USING btree (datetime, id);

CREATE INDEX items_search_p2012w17_geometry_idx ON pgstac.items_search_p2012w17 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w17_pkey ON pgstac.items_search_p2012w17 USING btree (id);

CREATE INDEX items_search_p2012w17_properties_idx ON pgstac.items_search_p2012w17 USING gin (properties);

CREATE INDEX items_search_p2012w18_collection_id_idx ON pgstac.items_search_p2012w18 USING btree (collection_id);

CREATE INDEX items_search_p2012w18_datetime_id_idx ON pgstac.items_search_p2012w18 USING btree (datetime, id);

CREATE INDEX items_search_p2012w18_geometry_idx ON pgstac.items_search_p2012w18 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w18_pkey ON pgstac.items_search_p2012w18 USING btree (id);

CREATE INDEX items_search_p2012w18_properties_idx ON pgstac.items_search_p2012w18 USING gin (properties);

CREATE INDEX items_search_p2012w19_collection_id_idx ON pgstac.items_search_p2012w19 USING btree (collection_id);

CREATE INDEX items_search_p2012w19_datetime_id_idx ON pgstac.items_search_p2012w19 USING btree (datetime, id);

CREATE INDEX items_search_p2012w19_geometry_idx ON pgstac.items_search_p2012w19 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w19_pkey ON pgstac.items_search_p2012w19 USING btree (id);

CREATE INDEX items_search_p2012w19_properties_idx ON pgstac.items_search_p2012w19 USING gin (properties);

CREATE INDEX items_search_p2012w20_collection_id_idx ON pgstac.items_search_p2012w20 USING btree (collection_id);

CREATE INDEX items_search_p2012w20_datetime_id_idx ON pgstac.items_search_p2012w20 USING btree (datetime, id);

CREATE INDEX items_search_p2012w20_geometry_idx ON pgstac.items_search_p2012w20 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w20_pkey ON pgstac.items_search_p2012w20 USING btree (id);

CREATE INDEX items_search_p2012w20_properties_idx ON pgstac.items_search_p2012w20 USING gin (properties);

CREATE INDEX items_search_p2012w21_collection_id_idx ON pgstac.items_search_p2012w21 USING btree (collection_id);

CREATE INDEX items_search_p2012w21_datetime_id_idx ON pgstac.items_search_p2012w21 USING btree (datetime, id);

CREATE INDEX items_search_p2012w21_geometry_idx ON pgstac.items_search_p2012w21 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w21_pkey ON pgstac.items_search_p2012w21 USING btree (id);

CREATE INDEX items_search_p2012w21_properties_idx ON pgstac.items_search_p2012w21 USING gin (properties);

CREATE INDEX items_search_p2012w22_collection_id_idx ON pgstac.items_search_p2012w22 USING btree (collection_id);

CREATE INDEX items_search_p2012w22_datetime_id_idx ON pgstac.items_search_p2012w22 USING btree (datetime, id);

CREATE INDEX items_search_p2012w22_geometry_idx ON pgstac.items_search_p2012w22 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w22_pkey ON pgstac.items_search_p2012w22 USING btree (id);

CREATE INDEX items_search_p2012w22_properties_idx ON pgstac.items_search_p2012w22 USING gin (properties);

CREATE INDEX items_search_p2012w23_collection_id_idx ON pgstac.items_search_p2012w23 USING btree (collection_id);

CREATE INDEX items_search_p2012w23_datetime_id_idx ON pgstac.items_search_p2012w23 USING btree (datetime, id);

CREATE INDEX items_search_p2012w23_geometry_idx ON pgstac.items_search_p2012w23 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w23_pkey ON pgstac.items_search_p2012w23 USING btree (id);

CREATE INDEX items_search_p2012w23_properties_idx ON pgstac.items_search_p2012w23 USING gin (properties);

CREATE INDEX items_search_p2012w24_collection_id_idx ON pgstac.items_search_p2012w24 USING btree (collection_id);

CREATE INDEX items_search_p2012w24_datetime_id_idx ON pgstac.items_search_p2012w24 USING btree (datetime, id);

CREATE INDEX items_search_p2012w24_geometry_idx ON pgstac.items_search_p2012w24 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w24_pkey ON pgstac.items_search_p2012w24 USING btree (id);

CREATE INDEX items_search_p2012w24_properties_idx ON pgstac.items_search_p2012w24 USING gin (properties);

CREATE INDEX items_search_p2012w25_collection_id_idx ON pgstac.items_search_p2012w25 USING btree (collection_id);

CREATE INDEX items_search_p2012w25_datetime_id_idx ON pgstac.items_search_p2012w25 USING btree (datetime, id);

CREATE INDEX items_search_p2012w25_geometry_idx ON pgstac.items_search_p2012w25 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w25_pkey ON pgstac.items_search_p2012w25 USING btree (id);

CREATE INDEX items_search_p2012w25_properties_idx ON pgstac.items_search_p2012w25 USING gin (properties);

CREATE INDEX items_search_p2012w26_collection_id_idx ON pgstac.items_search_p2012w26 USING btree (collection_id);

CREATE INDEX items_search_p2012w26_datetime_id_idx ON pgstac.items_search_p2012w26 USING btree (datetime, id);

CREATE INDEX items_search_p2012w26_geometry_idx ON pgstac.items_search_p2012w26 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w26_pkey ON pgstac.items_search_p2012w26 USING btree (id);

CREATE INDEX items_search_p2012w26_properties_idx ON pgstac.items_search_p2012w26 USING gin (properties);

CREATE INDEX items_search_p2012w27_collection_id_idx ON pgstac.items_search_p2012w27 USING btree (collection_id);

CREATE INDEX items_search_p2012w27_datetime_id_idx ON pgstac.items_search_p2012w27 USING btree (datetime, id);

CREATE INDEX items_search_p2012w27_geometry_idx ON pgstac.items_search_p2012w27 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w27_pkey ON pgstac.items_search_p2012w27 USING btree (id);

CREATE INDEX items_search_p2012w27_properties_idx ON pgstac.items_search_p2012w27 USING gin (properties);

CREATE INDEX items_search_p2012w28_collection_id_idx ON pgstac.items_search_p2012w28 USING btree (collection_id);

CREATE INDEX items_search_p2012w28_datetime_id_idx ON pgstac.items_search_p2012w28 USING btree (datetime, id);

CREATE INDEX items_search_p2012w28_geometry_idx ON pgstac.items_search_p2012w28 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w28_pkey ON pgstac.items_search_p2012w28 USING btree (id);

CREATE INDEX items_search_p2012w28_properties_idx ON pgstac.items_search_p2012w28 USING gin (properties);

CREATE INDEX items_search_p2012w29_collection_id_idx ON pgstac.items_search_p2012w29 USING btree (collection_id);

CREATE INDEX items_search_p2012w29_datetime_id_idx ON pgstac.items_search_p2012w29 USING btree (datetime, id);

CREATE INDEX items_search_p2012w29_geometry_idx ON pgstac.items_search_p2012w29 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w29_pkey ON pgstac.items_search_p2012w29 USING btree (id);

CREATE INDEX items_search_p2012w29_properties_idx ON pgstac.items_search_p2012w29 USING gin (properties);

CREATE INDEX items_search_p2012w30_collection_id_idx ON pgstac.items_search_p2012w30 USING btree (collection_id);

CREATE INDEX items_search_p2012w30_datetime_id_idx ON pgstac.items_search_p2012w30 USING btree (datetime, id);

CREATE INDEX items_search_p2012w30_geometry_idx ON pgstac.items_search_p2012w30 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w30_pkey ON pgstac.items_search_p2012w30 USING btree (id);

CREATE INDEX items_search_p2012w30_properties_idx ON pgstac.items_search_p2012w30 USING gin (properties);

CREATE INDEX items_search_p2012w31_collection_id_idx ON pgstac.items_search_p2012w31 USING btree (collection_id);

CREATE INDEX items_search_p2012w31_datetime_id_idx ON pgstac.items_search_p2012w31 USING btree (datetime, id);

CREATE INDEX items_search_p2012w31_geometry_idx ON pgstac.items_search_p2012w31 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w31_pkey ON pgstac.items_search_p2012w31 USING btree (id);

CREATE INDEX items_search_p2012w31_properties_idx ON pgstac.items_search_p2012w31 USING gin (properties);

CREATE INDEX items_search_p2012w32_collection_id_idx ON pgstac.items_search_p2012w32 USING btree (collection_id);

CREATE INDEX items_search_p2012w32_datetime_id_idx ON pgstac.items_search_p2012w32 USING btree (datetime, id);

CREATE INDEX items_search_p2012w32_geometry_idx ON pgstac.items_search_p2012w32 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w32_pkey ON pgstac.items_search_p2012w32 USING btree (id);

CREATE INDEX items_search_p2012w32_properties_idx ON pgstac.items_search_p2012w32 USING gin (properties);

CREATE INDEX items_search_p2012w33_collection_id_idx ON pgstac.items_search_p2012w33 USING btree (collection_id);

CREATE INDEX items_search_p2012w33_datetime_id_idx ON pgstac.items_search_p2012w33 USING btree (datetime, id);

CREATE INDEX items_search_p2012w33_geometry_idx ON pgstac.items_search_p2012w33 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w33_pkey ON pgstac.items_search_p2012w33 USING btree (id);

CREATE INDEX items_search_p2012w33_properties_idx ON pgstac.items_search_p2012w33 USING gin (properties);

CREATE INDEX items_search_p2012w34_collection_id_idx ON pgstac.items_search_p2012w34 USING btree (collection_id);

CREATE INDEX items_search_p2012w34_datetime_id_idx ON pgstac.items_search_p2012w34 USING btree (datetime, id);

CREATE INDEX items_search_p2012w34_geometry_idx ON pgstac.items_search_p2012w34 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w34_pkey ON pgstac.items_search_p2012w34 USING btree (id);

CREATE INDEX items_search_p2012w34_properties_idx ON pgstac.items_search_p2012w34 USING gin (properties);

CREATE INDEX items_search_p2012w35_collection_id_idx ON pgstac.items_search_p2012w35 USING btree (collection_id);

CREATE INDEX items_search_p2012w35_datetime_id_idx ON pgstac.items_search_p2012w35 USING btree (datetime, id);

CREATE INDEX items_search_p2012w35_geometry_idx ON pgstac.items_search_p2012w35 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w35_pkey ON pgstac.items_search_p2012w35 USING btree (id);

CREATE INDEX items_search_p2012w35_properties_idx ON pgstac.items_search_p2012w35 USING gin (properties);

CREATE INDEX items_search_p2012w36_collection_id_idx ON pgstac.items_search_p2012w36 USING btree (collection_id);

CREATE INDEX items_search_p2012w36_datetime_id_idx ON pgstac.items_search_p2012w36 USING btree (datetime, id);

CREATE INDEX items_search_p2012w36_geometry_idx ON pgstac.items_search_p2012w36 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w36_pkey ON pgstac.items_search_p2012w36 USING btree (id);

CREATE INDEX items_search_p2012w36_properties_idx ON pgstac.items_search_p2012w36 USING gin (properties);

CREATE INDEX items_search_p2012w37_collection_id_idx ON pgstac.items_search_p2012w37 USING btree (collection_id);

CREATE INDEX items_search_p2012w37_datetime_id_idx ON pgstac.items_search_p2012w37 USING btree (datetime, id);

CREATE INDEX items_search_p2012w37_geometry_idx ON pgstac.items_search_p2012w37 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w37_pkey ON pgstac.items_search_p2012w37 USING btree (id);

CREATE INDEX items_search_p2012w37_properties_idx ON pgstac.items_search_p2012w37 USING gin (properties);

CREATE INDEX items_search_p2012w38_collection_id_idx ON pgstac.items_search_p2012w38 USING btree (collection_id);

CREATE INDEX items_search_p2012w38_datetime_id_idx ON pgstac.items_search_p2012w38 USING btree (datetime, id);

CREATE INDEX items_search_p2012w38_geometry_idx ON pgstac.items_search_p2012w38 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w38_pkey ON pgstac.items_search_p2012w38 USING btree (id);

CREATE INDEX items_search_p2012w38_properties_idx ON pgstac.items_search_p2012w38 USING gin (properties);

CREATE INDEX items_search_p2012w39_collection_id_idx ON pgstac.items_search_p2012w39 USING btree (collection_id);

CREATE INDEX items_search_p2012w39_datetime_id_idx ON pgstac.items_search_p2012w39 USING btree (datetime, id);

CREATE INDEX items_search_p2012w39_geometry_idx ON pgstac.items_search_p2012w39 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w39_pkey ON pgstac.items_search_p2012w39 USING btree (id);

CREATE INDEX items_search_p2012w39_properties_idx ON pgstac.items_search_p2012w39 USING gin (properties);

CREATE INDEX items_search_p2012w40_collection_id_idx ON pgstac.items_search_p2012w40 USING btree (collection_id);

CREATE INDEX items_search_p2012w40_datetime_id_idx ON pgstac.items_search_p2012w40 USING btree (datetime, id);

CREATE INDEX items_search_p2012w40_geometry_idx ON pgstac.items_search_p2012w40 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w40_pkey ON pgstac.items_search_p2012w40 USING btree (id);

CREATE INDEX items_search_p2012w40_properties_idx ON pgstac.items_search_p2012w40 USING gin (properties);

CREATE INDEX items_search_p2012w41_collection_id_idx ON pgstac.items_search_p2012w41 USING btree (collection_id);

CREATE INDEX items_search_p2012w41_datetime_id_idx ON pgstac.items_search_p2012w41 USING btree (datetime, id);

CREATE INDEX items_search_p2012w41_geometry_idx ON pgstac.items_search_p2012w41 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w41_pkey ON pgstac.items_search_p2012w41 USING btree (id);

CREATE INDEX items_search_p2012w41_properties_idx ON pgstac.items_search_p2012w41 USING gin (properties);

CREATE INDEX items_search_p2012w42_collection_id_idx ON pgstac.items_search_p2012w42 USING btree (collection_id);

CREATE INDEX items_search_p2012w42_datetime_id_idx ON pgstac.items_search_p2012w42 USING btree (datetime, id);

CREATE INDEX items_search_p2012w42_geometry_idx ON pgstac.items_search_p2012w42 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w42_pkey ON pgstac.items_search_p2012w42 USING btree (id);

CREATE INDEX items_search_p2012w42_properties_idx ON pgstac.items_search_p2012w42 USING gin (properties);

CREATE INDEX items_search_p2012w43_collection_id_idx ON pgstac.items_search_p2012w43 USING btree (collection_id);

CREATE INDEX items_search_p2012w43_datetime_id_idx ON pgstac.items_search_p2012w43 USING btree (datetime, id);

CREATE INDEX items_search_p2012w43_geometry_idx ON pgstac.items_search_p2012w43 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w43_pkey ON pgstac.items_search_p2012w43 USING btree (id);

CREATE INDEX items_search_p2012w43_properties_idx ON pgstac.items_search_p2012w43 USING gin (properties);

CREATE INDEX items_search_p2012w44_collection_id_idx ON pgstac.items_search_p2012w44 USING btree (collection_id);

CREATE INDEX items_search_p2012w44_datetime_id_idx ON pgstac.items_search_p2012w44 USING btree (datetime, id);

CREATE INDEX items_search_p2012w44_geometry_idx ON pgstac.items_search_p2012w44 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w44_pkey ON pgstac.items_search_p2012w44 USING btree (id);

CREATE INDEX items_search_p2012w44_properties_idx ON pgstac.items_search_p2012w44 USING gin (properties);

CREATE INDEX items_search_p2012w45_collection_id_idx ON pgstac.items_search_p2012w45 USING btree (collection_id);

CREATE INDEX items_search_p2012w45_datetime_id_idx ON pgstac.items_search_p2012w45 USING btree (datetime, id);

CREATE INDEX items_search_p2012w45_geometry_idx ON pgstac.items_search_p2012w45 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w45_pkey ON pgstac.items_search_p2012w45 USING btree (id);

CREATE INDEX items_search_p2012w45_properties_idx ON pgstac.items_search_p2012w45 USING gin (properties);

CREATE INDEX items_search_p2012w46_collection_id_idx ON pgstac.items_search_p2012w46 USING btree (collection_id);

CREATE INDEX items_search_p2012w46_datetime_id_idx ON pgstac.items_search_p2012w46 USING btree (datetime, id);

CREATE INDEX items_search_p2012w46_geometry_idx ON pgstac.items_search_p2012w46 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w46_pkey ON pgstac.items_search_p2012w46 USING btree (id);

CREATE INDEX items_search_p2012w46_properties_idx ON pgstac.items_search_p2012w46 USING gin (properties);

CREATE INDEX items_search_p2012w47_collection_id_idx ON pgstac.items_search_p2012w47 USING btree (collection_id);

CREATE INDEX items_search_p2012w47_datetime_id_idx ON pgstac.items_search_p2012w47 USING btree (datetime, id);

CREATE INDEX items_search_p2012w47_geometry_idx ON pgstac.items_search_p2012w47 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w47_pkey ON pgstac.items_search_p2012w47 USING btree (id);

CREATE INDEX items_search_p2012w47_properties_idx ON pgstac.items_search_p2012w47 USING gin (properties);

CREATE INDEX items_search_p2012w48_collection_id_idx ON pgstac.items_search_p2012w48 USING btree (collection_id);

CREATE INDEX items_search_p2012w48_datetime_id_idx ON pgstac.items_search_p2012w48 USING btree (datetime, id);

CREATE INDEX items_search_p2012w48_geometry_idx ON pgstac.items_search_p2012w48 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w48_pkey ON pgstac.items_search_p2012w48 USING btree (id);

CREATE INDEX items_search_p2012w48_properties_idx ON pgstac.items_search_p2012w48 USING gin (properties);

CREATE INDEX items_search_p2012w49_collection_id_idx ON pgstac.items_search_p2012w49 USING btree (collection_id);

CREATE INDEX items_search_p2012w49_datetime_id_idx ON pgstac.items_search_p2012w49 USING btree (datetime, id);

CREATE INDEX items_search_p2012w49_geometry_idx ON pgstac.items_search_p2012w49 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w49_pkey ON pgstac.items_search_p2012w49 USING btree (id);

CREATE INDEX items_search_p2012w49_properties_idx ON pgstac.items_search_p2012w49 USING gin (properties);

CREATE INDEX items_search_p2012w50_collection_id_idx ON pgstac.items_search_p2012w50 USING btree (collection_id);

CREATE INDEX items_search_p2012w50_datetime_id_idx ON pgstac.items_search_p2012w50 USING btree (datetime, id);

CREATE INDEX items_search_p2012w50_geometry_idx ON pgstac.items_search_p2012w50 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w50_pkey ON pgstac.items_search_p2012w50 USING btree (id);

CREATE INDEX items_search_p2012w50_properties_idx ON pgstac.items_search_p2012w50 USING gin (properties);

CREATE INDEX items_search_p2012w51_collection_id_idx ON pgstac.items_search_p2012w51 USING btree (collection_id);

CREATE INDEX items_search_p2012w51_datetime_id_idx ON pgstac.items_search_p2012w51 USING btree (datetime, id);

CREATE INDEX items_search_p2012w51_geometry_idx ON pgstac.items_search_p2012w51 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w51_pkey ON pgstac.items_search_p2012w51 USING btree (id);

CREATE INDEX items_search_p2012w51_properties_idx ON pgstac.items_search_p2012w51 USING gin (properties);

CREATE INDEX items_search_p2012w52_collection_id_idx ON pgstac.items_search_p2012w52 USING btree (collection_id);

CREATE INDEX items_search_p2012w52_datetime_id_idx ON pgstac.items_search_p2012w52 USING btree (datetime, id);

CREATE INDEX items_search_p2012w52_geometry_idx ON pgstac.items_search_p2012w52 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2012w52_pkey ON pgstac.items_search_p2012w52 USING btree (id);

CREATE INDEX items_search_p2012w52_properties_idx ON pgstac.items_search_p2012w52 USING gin (properties);

CREATE INDEX items_search_p2013w01_collection_id_idx ON pgstac.items_search_p2013w01 USING btree (collection_id);

CREATE INDEX items_search_p2013w01_datetime_id_idx ON pgstac.items_search_p2013w01 USING btree (datetime, id);

CREATE INDEX items_search_p2013w01_geometry_idx ON pgstac.items_search_p2013w01 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w01_pkey ON pgstac.items_search_p2013w01 USING btree (id);

CREATE INDEX items_search_p2013w01_properties_idx ON pgstac.items_search_p2013w01 USING gin (properties);

CREATE INDEX items_search_p2013w02_collection_id_idx ON pgstac.items_search_p2013w02 USING btree (collection_id);

CREATE INDEX items_search_p2013w02_datetime_id_idx ON pgstac.items_search_p2013w02 USING btree (datetime, id);

CREATE INDEX items_search_p2013w02_geometry_idx ON pgstac.items_search_p2013w02 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w02_pkey ON pgstac.items_search_p2013w02 USING btree (id);

CREATE INDEX items_search_p2013w02_properties_idx ON pgstac.items_search_p2013w02 USING gin (properties);

CREATE INDEX items_search_p2013w03_collection_id_idx ON pgstac.items_search_p2013w03 USING btree (collection_id);

CREATE INDEX items_search_p2013w03_datetime_id_idx ON pgstac.items_search_p2013w03 USING btree (datetime, id);

CREATE INDEX items_search_p2013w03_geometry_idx ON pgstac.items_search_p2013w03 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w03_pkey ON pgstac.items_search_p2013w03 USING btree (id);

CREATE INDEX items_search_p2013w03_properties_idx ON pgstac.items_search_p2013w03 USING gin (properties);

CREATE INDEX items_search_p2013w04_collection_id_idx ON pgstac.items_search_p2013w04 USING btree (collection_id);

CREATE INDEX items_search_p2013w04_datetime_id_idx ON pgstac.items_search_p2013w04 USING btree (datetime, id);

CREATE INDEX items_search_p2013w04_geometry_idx ON pgstac.items_search_p2013w04 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w04_pkey ON pgstac.items_search_p2013w04 USING btree (id);

CREATE INDEX items_search_p2013w04_properties_idx ON pgstac.items_search_p2013w04 USING gin (properties);

CREATE INDEX items_search_p2013w05_collection_id_idx ON pgstac.items_search_p2013w05 USING btree (collection_id);

CREATE INDEX items_search_p2013w05_datetime_id_idx ON pgstac.items_search_p2013w05 USING btree (datetime, id);

CREATE INDEX items_search_p2013w05_geometry_idx ON pgstac.items_search_p2013w05 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w05_pkey ON pgstac.items_search_p2013w05 USING btree (id);

CREATE INDEX items_search_p2013w05_properties_idx ON pgstac.items_search_p2013w05 USING gin (properties);

CREATE INDEX items_search_p2013w06_collection_id_idx ON pgstac.items_search_p2013w06 USING btree (collection_id);

CREATE INDEX items_search_p2013w06_datetime_id_idx ON pgstac.items_search_p2013w06 USING btree (datetime, id);

CREATE INDEX items_search_p2013w06_geometry_idx ON pgstac.items_search_p2013w06 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w06_pkey ON pgstac.items_search_p2013w06 USING btree (id);

CREATE INDEX items_search_p2013w06_properties_idx ON pgstac.items_search_p2013w06 USING gin (properties);

CREATE INDEX items_search_p2013w07_collection_id_idx ON pgstac.items_search_p2013w07 USING btree (collection_id);

CREATE INDEX items_search_p2013w07_datetime_id_idx ON pgstac.items_search_p2013w07 USING btree (datetime, id);

CREATE INDEX items_search_p2013w07_geometry_idx ON pgstac.items_search_p2013w07 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w07_pkey ON pgstac.items_search_p2013w07 USING btree (id);

CREATE INDEX items_search_p2013w07_properties_idx ON pgstac.items_search_p2013w07 USING gin (properties);

CREATE INDEX items_search_p2013w08_collection_id_idx ON pgstac.items_search_p2013w08 USING btree (collection_id);

CREATE INDEX items_search_p2013w08_datetime_id_idx ON pgstac.items_search_p2013w08 USING btree (datetime, id);

CREATE INDEX items_search_p2013w08_geometry_idx ON pgstac.items_search_p2013w08 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w08_pkey ON pgstac.items_search_p2013w08 USING btree (id);

CREATE INDEX items_search_p2013w08_properties_idx ON pgstac.items_search_p2013w08 USING gin (properties);

CREATE INDEX items_search_p2013w09_collection_id_idx ON pgstac.items_search_p2013w09 USING btree (collection_id);

CREATE INDEX items_search_p2013w09_datetime_id_idx ON pgstac.items_search_p2013w09 USING btree (datetime, id);

CREATE INDEX items_search_p2013w09_geometry_idx ON pgstac.items_search_p2013w09 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w09_pkey ON pgstac.items_search_p2013w09 USING btree (id);

CREATE INDEX items_search_p2013w09_properties_idx ON pgstac.items_search_p2013w09 USING gin (properties);

CREATE INDEX items_search_p2013w10_collection_id_idx ON pgstac.items_search_p2013w10 USING btree (collection_id);

CREATE INDEX items_search_p2013w10_datetime_id_idx ON pgstac.items_search_p2013w10 USING btree (datetime, id);

CREATE INDEX items_search_p2013w10_geometry_idx ON pgstac.items_search_p2013w10 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w10_pkey ON pgstac.items_search_p2013w10 USING btree (id);

CREATE INDEX items_search_p2013w10_properties_idx ON pgstac.items_search_p2013w10 USING gin (properties);

CREATE INDEX items_search_p2013w11_collection_id_idx ON pgstac.items_search_p2013w11 USING btree (collection_id);

CREATE INDEX items_search_p2013w11_datetime_id_idx ON pgstac.items_search_p2013w11 USING btree (datetime, id);

CREATE INDEX items_search_p2013w11_geometry_idx ON pgstac.items_search_p2013w11 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w11_pkey ON pgstac.items_search_p2013w11 USING btree (id);

CREATE INDEX items_search_p2013w11_properties_idx ON pgstac.items_search_p2013w11 USING gin (properties);

CREATE INDEX items_search_p2013w12_collection_id_idx ON pgstac.items_search_p2013w12 USING btree (collection_id);

CREATE INDEX items_search_p2013w12_datetime_id_idx ON pgstac.items_search_p2013w12 USING btree (datetime, id);

CREATE INDEX items_search_p2013w12_geometry_idx ON pgstac.items_search_p2013w12 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w12_pkey ON pgstac.items_search_p2013w12 USING btree (id);

CREATE INDEX items_search_p2013w12_properties_idx ON pgstac.items_search_p2013w12 USING gin (properties);

CREATE INDEX items_search_p2013w13_collection_id_idx ON pgstac.items_search_p2013w13 USING btree (collection_id);

CREATE INDEX items_search_p2013w13_datetime_id_idx ON pgstac.items_search_p2013w13 USING btree (datetime, id);

CREATE INDEX items_search_p2013w13_geometry_idx ON pgstac.items_search_p2013w13 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w13_pkey ON pgstac.items_search_p2013w13 USING btree (id);

CREATE INDEX items_search_p2013w13_properties_idx ON pgstac.items_search_p2013w13 USING gin (properties);

CREATE INDEX items_search_p2013w14_collection_id_idx ON pgstac.items_search_p2013w14 USING btree (collection_id);

CREATE INDEX items_search_p2013w14_datetime_id_idx ON pgstac.items_search_p2013w14 USING btree (datetime, id);

CREATE INDEX items_search_p2013w14_geometry_idx ON pgstac.items_search_p2013w14 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w14_pkey ON pgstac.items_search_p2013w14 USING btree (id);

CREATE INDEX items_search_p2013w14_properties_idx ON pgstac.items_search_p2013w14 USING gin (properties);

CREATE INDEX items_search_p2013w15_collection_id_idx ON pgstac.items_search_p2013w15 USING btree (collection_id);

CREATE INDEX items_search_p2013w15_datetime_id_idx ON pgstac.items_search_p2013w15 USING btree (datetime, id);

CREATE INDEX items_search_p2013w15_geometry_idx ON pgstac.items_search_p2013w15 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w15_pkey ON pgstac.items_search_p2013w15 USING btree (id);

CREATE INDEX items_search_p2013w15_properties_idx ON pgstac.items_search_p2013w15 USING gin (properties);

CREATE INDEX items_search_p2013w16_collection_id_idx ON pgstac.items_search_p2013w16 USING btree (collection_id);

CREATE INDEX items_search_p2013w16_datetime_id_idx ON pgstac.items_search_p2013w16 USING btree (datetime, id);

CREATE INDEX items_search_p2013w16_geometry_idx ON pgstac.items_search_p2013w16 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w16_pkey ON pgstac.items_search_p2013w16 USING btree (id);

CREATE INDEX items_search_p2013w16_properties_idx ON pgstac.items_search_p2013w16 USING gin (properties);

CREATE INDEX items_search_p2013w17_collection_id_idx ON pgstac.items_search_p2013w17 USING btree (collection_id);

CREATE INDEX items_search_p2013w17_datetime_id_idx ON pgstac.items_search_p2013w17 USING btree (datetime, id);

CREATE INDEX items_search_p2013w17_geometry_idx ON pgstac.items_search_p2013w17 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w17_pkey ON pgstac.items_search_p2013w17 USING btree (id);

CREATE INDEX items_search_p2013w17_properties_idx ON pgstac.items_search_p2013w17 USING gin (properties);

CREATE INDEX items_search_p2013w18_collection_id_idx ON pgstac.items_search_p2013w18 USING btree (collection_id);

CREATE INDEX items_search_p2013w18_datetime_id_idx ON pgstac.items_search_p2013w18 USING btree (datetime, id);

CREATE INDEX items_search_p2013w18_geometry_idx ON pgstac.items_search_p2013w18 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w18_pkey ON pgstac.items_search_p2013w18 USING btree (id);

CREATE INDEX items_search_p2013w18_properties_idx ON pgstac.items_search_p2013w18 USING gin (properties);

CREATE INDEX items_search_p2013w19_collection_id_idx ON pgstac.items_search_p2013w19 USING btree (collection_id);

CREATE INDEX items_search_p2013w19_datetime_id_idx ON pgstac.items_search_p2013w19 USING btree (datetime, id);

CREATE INDEX items_search_p2013w19_geometry_idx ON pgstac.items_search_p2013w19 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w19_pkey ON pgstac.items_search_p2013w19 USING btree (id);

CREATE INDEX items_search_p2013w19_properties_idx ON pgstac.items_search_p2013w19 USING gin (properties);

CREATE INDEX items_search_p2013w20_collection_id_idx ON pgstac.items_search_p2013w20 USING btree (collection_id);

CREATE INDEX items_search_p2013w20_datetime_id_idx ON pgstac.items_search_p2013w20 USING btree (datetime, id);

CREATE INDEX items_search_p2013w20_geometry_idx ON pgstac.items_search_p2013w20 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w20_pkey ON pgstac.items_search_p2013w20 USING btree (id);

CREATE INDEX items_search_p2013w20_properties_idx ON pgstac.items_search_p2013w20 USING gin (properties);

CREATE INDEX items_search_p2013w21_collection_id_idx ON pgstac.items_search_p2013w21 USING btree (collection_id);

CREATE INDEX items_search_p2013w21_datetime_id_idx ON pgstac.items_search_p2013w21 USING btree (datetime, id);

CREATE INDEX items_search_p2013w21_geometry_idx ON pgstac.items_search_p2013w21 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w21_pkey ON pgstac.items_search_p2013w21 USING btree (id);

CREATE INDEX items_search_p2013w21_properties_idx ON pgstac.items_search_p2013w21 USING gin (properties);

CREATE INDEX items_search_p2013w22_collection_id_idx ON pgstac.items_search_p2013w22 USING btree (collection_id);

CREATE INDEX items_search_p2013w22_datetime_id_idx ON pgstac.items_search_p2013w22 USING btree (datetime, id);

CREATE INDEX items_search_p2013w22_geometry_idx ON pgstac.items_search_p2013w22 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w22_pkey ON pgstac.items_search_p2013w22 USING btree (id);

CREATE INDEX items_search_p2013w22_properties_idx ON pgstac.items_search_p2013w22 USING gin (properties);

CREATE INDEX items_search_p2013w23_collection_id_idx ON pgstac.items_search_p2013w23 USING btree (collection_id);

CREATE INDEX items_search_p2013w23_datetime_id_idx ON pgstac.items_search_p2013w23 USING btree (datetime, id);

CREATE INDEX items_search_p2013w23_geometry_idx ON pgstac.items_search_p2013w23 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w23_pkey ON pgstac.items_search_p2013w23 USING btree (id);

CREATE INDEX items_search_p2013w23_properties_idx ON pgstac.items_search_p2013w23 USING gin (properties);

CREATE INDEX items_search_p2013w24_collection_id_idx ON pgstac.items_search_p2013w24 USING btree (collection_id);

CREATE INDEX items_search_p2013w24_datetime_id_idx ON pgstac.items_search_p2013w24 USING btree (datetime, id);

CREATE INDEX items_search_p2013w24_geometry_idx ON pgstac.items_search_p2013w24 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w24_pkey ON pgstac.items_search_p2013w24 USING btree (id);

CREATE INDEX items_search_p2013w24_properties_idx ON pgstac.items_search_p2013w24 USING gin (properties);

CREATE INDEX items_search_p2013w25_collection_id_idx ON pgstac.items_search_p2013w25 USING btree (collection_id);

CREATE INDEX items_search_p2013w25_datetime_id_idx ON pgstac.items_search_p2013w25 USING btree (datetime, id);

CREATE INDEX items_search_p2013w25_geometry_idx ON pgstac.items_search_p2013w25 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w25_pkey ON pgstac.items_search_p2013w25 USING btree (id);

CREATE INDEX items_search_p2013w25_properties_idx ON pgstac.items_search_p2013w25 USING gin (properties);

CREATE INDEX items_search_p2013w26_collection_id_idx ON pgstac.items_search_p2013w26 USING btree (collection_id);

CREATE INDEX items_search_p2013w26_datetime_id_idx ON pgstac.items_search_p2013w26 USING btree (datetime, id);

CREATE INDEX items_search_p2013w26_geometry_idx ON pgstac.items_search_p2013w26 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w26_pkey ON pgstac.items_search_p2013w26 USING btree (id);

CREATE INDEX items_search_p2013w26_properties_idx ON pgstac.items_search_p2013w26 USING gin (properties);

CREATE INDEX items_search_p2013w27_collection_id_idx ON pgstac.items_search_p2013w27 USING btree (collection_id);

CREATE INDEX items_search_p2013w27_datetime_id_idx ON pgstac.items_search_p2013w27 USING btree (datetime, id);

CREATE INDEX items_search_p2013w27_geometry_idx ON pgstac.items_search_p2013w27 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w27_pkey ON pgstac.items_search_p2013w27 USING btree (id);

CREATE INDEX items_search_p2013w27_properties_idx ON pgstac.items_search_p2013w27 USING gin (properties);

CREATE INDEX items_search_p2013w28_collection_id_idx ON pgstac.items_search_p2013w28 USING btree (collection_id);

CREATE INDEX items_search_p2013w28_datetime_id_idx ON pgstac.items_search_p2013w28 USING btree (datetime, id);

CREATE INDEX items_search_p2013w28_geometry_idx ON pgstac.items_search_p2013w28 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w28_pkey ON pgstac.items_search_p2013w28 USING btree (id);

CREATE INDEX items_search_p2013w28_properties_idx ON pgstac.items_search_p2013w28 USING gin (properties);

CREATE INDEX items_search_p2013w29_collection_id_idx ON pgstac.items_search_p2013w29 USING btree (collection_id);

CREATE INDEX items_search_p2013w29_datetime_id_idx ON pgstac.items_search_p2013w29 USING btree (datetime, id);

CREATE INDEX items_search_p2013w29_geometry_idx ON pgstac.items_search_p2013w29 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w29_pkey ON pgstac.items_search_p2013w29 USING btree (id);

CREATE INDEX items_search_p2013w29_properties_idx ON pgstac.items_search_p2013w29 USING gin (properties);

CREATE INDEX items_search_p2013w30_collection_id_idx ON pgstac.items_search_p2013w30 USING btree (collection_id);

CREATE INDEX items_search_p2013w30_datetime_id_idx ON pgstac.items_search_p2013w30 USING btree (datetime, id);

CREATE INDEX items_search_p2013w30_geometry_idx ON pgstac.items_search_p2013w30 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w30_pkey ON pgstac.items_search_p2013w30 USING btree (id);

CREATE INDEX items_search_p2013w30_properties_idx ON pgstac.items_search_p2013w30 USING gin (properties);

CREATE INDEX items_search_p2013w31_collection_id_idx ON pgstac.items_search_p2013w31 USING btree (collection_id);

CREATE INDEX items_search_p2013w31_datetime_id_idx ON pgstac.items_search_p2013w31 USING btree (datetime, id);

CREATE INDEX items_search_p2013w31_geometry_idx ON pgstac.items_search_p2013w31 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w31_pkey ON pgstac.items_search_p2013w31 USING btree (id);

CREATE INDEX items_search_p2013w31_properties_idx ON pgstac.items_search_p2013w31 USING gin (properties);

CREATE INDEX items_search_p2013w32_collection_id_idx ON pgstac.items_search_p2013w32 USING btree (collection_id);

CREATE INDEX items_search_p2013w32_datetime_id_idx ON pgstac.items_search_p2013w32 USING btree (datetime, id);

CREATE INDEX items_search_p2013w32_geometry_idx ON pgstac.items_search_p2013w32 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w32_pkey ON pgstac.items_search_p2013w32 USING btree (id);

CREATE INDEX items_search_p2013w32_properties_idx ON pgstac.items_search_p2013w32 USING gin (properties);

CREATE INDEX items_search_p2013w33_collection_id_idx ON pgstac.items_search_p2013w33 USING btree (collection_id);

CREATE INDEX items_search_p2013w33_datetime_id_idx ON pgstac.items_search_p2013w33 USING btree (datetime, id);

CREATE INDEX items_search_p2013w33_geometry_idx ON pgstac.items_search_p2013w33 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w33_pkey ON pgstac.items_search_p2013w33 USING btree (id);

CREATE INDEX items_search_p2013w33_properties_idx ON pgstac.items_search_p2013w33 USING gin (properties);

CREATE INDEX items_search_p2013w34_collection_id_idx ON pgstac.items_search_p2013w34 USING btree (collection_id);

CREATE INDEX items_search_p2013w34_datetime_id_idx ON pgstac.items_search_p2013w34 USING btree (datetime, id);

CREATE INDEX items_search_p2013w34_geometry_idx ON pgstac.items_search_p2013w34 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w34_pkey ON pgstac.items_search_p2013w34 USING btree (id);

CREATE INDEX items_search_p2013w34_properties_idx ON pgstac.items_search_p2013w34 USING gin (properties);

CREATE INDEX items_search_p2013w35_collection_id_idx ON pgstac.items_search_p2013w35 USING btree (collection_id);

CREATE INDEX items_search_p2013w35_datetime_id_idx ON pgstac.items_search_p2013w35 USING btree (datetime, id);

CREATE INDEX items_search_p2013w35_geometry_idx ON pgstac.items_search_p2013w35 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w35_pkey ON pgstac.items_search_p2013w35 USING btree (id);

CREATE INDEX items_search_p2013w35_properties_idx ON pgstac.items_search_p2013w35 USING gin (properties);

CREATE INDEX items_search_p2013w36_collection_id_idx ON pgstac.items_search_p2013w36 USING btree (collection_id);

CREATE INDEX items_search_p2013w36_datetime_id_idx ON pgstac.items_search_p2013w36 USING btree (datetime, id);

CREATE INDEX items_search_p2013w36_geometry_idx ON pgstac.items_search_p2013w36 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w36_pkey ON pgstac.items_search_p2013w36 USING btree (id);

CREATE INDEX items_search_p2013w36_properties_idx ON pgstac.items_search_p2013w36 USING gin (properties);

CREATE INDEX items_search_p2013w37_collection_id_idx ON pgstac.items_search_p2013w37 USING btree (collection_id);

CREATE INDEX items_search_p2013w37_datetime_id_idx ON pgstac.items_search_p2013w37 USING btree (datetime, id);

CREATE INDEX items_search_p2013w37_geometry_idx ON pgstac.items_search_p2013w37 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w37_pkey ON pgstac.items_search_p2013w37 USING btree (id);

CREATE INDEX items_search_p2013w37_properties_idx ON pgstac.items_search_p2013w37 USING gin (properties);

CREATE INDEX items_search_p2013w38_collection_id_idx ON pgstac.items_search_p2013w38 USING btree (collection_id);

CREATE INDEX items_search_p2013w38_datetime_id_idx ON pgstac.items_search_p2013w38 USING btree (datetime, id);

CREATE INDEX items_search_p2013w38_geometry_idx ON pgstac.items_search_p2013w38 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w38_pkey ON pgstac.items_search_p2013w38 USING btree (id);

CREATE INDEX items_search_p2013w38_properties_idx ON pgstac.items_search_p2013w38 USING gin (properties);

CREATE INDEX items_search_p2013w39_collection_id_idx ON pgstac.items_search_p2013w39 USING btree (collection_id);

CREATE INDEX items_search_p2013w39_datetime_id_idx ON pgstac.items_search_p2013w39 USING btree (datetime, id);

CREATE INDEX items_search_p2013w39_geometry_idx ON pgstac.items_search_p2013w39 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w39_pkey ON pgstac.items_search_p2013w39 USING btree (id);

CREATE INDEX items_search_p2013w39_properties_idx ON pgstac.items_search_p2013w39 USING gin (properties);

CREATE INDEX items_search_p2013w40_collection_id_idx ON pgstac.items_search_p2013w40 USING btree (collection_id);

CREATE INDEX items_search_p2013w40_datetime_id_idx ON pgstac.items_search_p2013w40 USING btree (datetime, id);

CREATE INDEX items_search_p2013w40_geometry_idx ON pgstac.items_search_p2013w40 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w40_pkey ON pgstac.items_search_p2013w40 USING btree (id);

CREATE INDEX items_search_p2013w40_properties_idx ON pgstac.items_search_p2013w40 USING gin (properties);

CREATE INDEX items_search_p2013w41_collection_id_idx ON pgstac.items_search_p2013w41 USING btree (collection_id);

CREATE INDEX items_search_p2013w41_datetime_id_idx ON pgstac.items_search_p2013w41 USING btree (datetime, id);

CREATE INDEX items_search_p2013w41_geometry_idx ON pgstac.items_search_p2013w41 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w41_pkey ON pgstac.items_search_p2013w41 USING btree (id);

CREATE INDEX items_search_p2013w41_properties_idx ON pgstac.items_search_p2013w41 USING gin (properties);

CREATE INDEX items_search_p2013w42_collection_id_idx ON pgstac.items_search_p2013w42 USING btree (collection_id);

CREATE INDEX items_search_p2013w42_datetime_id_idx ON pgstac.items_search_p2013w42 USING btree (datetime, id);

CREATE INDEX items_search_p2013w42_geometry_idx ON pgstac.items_search_p2013w42 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w42_pkey ON pgstac.items_search_p2013w42 USING btree (id);

CREATE INDEX items_search_p2013w42_properties_idx ON pgstac.items_search_p2013w42 USING gin (properties);

CREATE INDEX items_search_p2013w43_collection_id_idx ON pgstac.items_search_p2013w43 USING btree (collection_id);

CREATE INDEX items_search_p2013w43_datetime_id_idx ON pgstac.items_search_p2013w43 USING btree (datetime, id);

CREATE INDEX items_search_p2013w43_geometry_idx ON pgstac.items_search_p2013w43 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w43_pkey ON pgstac.items_search_p2013w43 USING btree (id);

CREATE INDEX items_search_p2013w43_properties_idx ON pgstac.items_search_p2013w43 USING gin (properties);

CREATE INDEX items_search_p2013w44_collection_id_idx ON pgstac.items_search_p2013w44 USING btree (collection_id);

CREATE INDEX items_search_p2013w44_datetime_id_idx ON pgstac.items_search_p2013w44 USING btree (datetime, id);

CREATE INDEX items_search_p2013w44_geometry_idx ON pgstac.items_search_p2013w44 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w44_pkey ON pgstac.items_search_p2013w44 USING btree (id);

CREATE INDEX items_search_p2013w44_properties_idx ON pgstac.items_search_p2013w44 USING gin (properties);

CREATE INDEX items_search_p2013w45_collection_id_idx ON pgstac.items_search_p2013w45 USING btree (collection_id);

CREATE INDEX items_search_p2013w45_datetime_id_idx ON pgstac.items_search_p2013w45 USING btree (datetime, id);

CREATE INDEX items_search_p2013w45_geometry_idx ON pgstac.items_search_p2013w45 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w45_pkey ON pgstac.items_search_p2013w45 USING btree (id);

CREATE INDEX items_search_p2013w45_properties_idx ON pgstac.items_search_p2013w45 USING gin (properties);

CREATE INDEX items_search_p2013w46_collection_id_idx ON pgstac.items_search_p2013w46 USING btree (collection_id);

CREATE INDEX items_search_p2013w46_datetime_id_idx ON pgstac.items_search_p2013w46 USING btree (datetime, id);

CREATE INDEX items_search_p2013w46_geometry_idx ON pgstac.items_search_p2013w46 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w46_pkey ON pgstac.items_search_p2013w46 USING btree (id);

CREATE INDEX items_search_p2013w46_properties_idx ON pgstac.items_search_p2013w46 USING gin (properties);

CREATE INDEX items_search_p2013w47_collection_id_idx ON pgstac.items_search_p2013w47 USING btree (collection_id);

CREATE INDEX items_search_p2013w47_datetime_id_idx ON pgstac.items_search_p2013w47 USING btree (datetime, id);

CREATE INDEX items_search_p2013w47_geometry_idx ON pgstac.items_search_p2013w47 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w47_pkey ON pgstac.items_search_p2013w47 USING btree (id);

CREATE INDEX items_search_p2013w47_properties_idx ON pgstac.items_search_p2013w47 USING gin (properties);

CREATE INDEX items_search_p2013w48_collection_id_idx ON pgstac.items_search_p2013w48 USING btree (collection_id);

CREATE INDEX items_search_p2013w48_datetime_id_idx ON pgstac.items_search_p2013w48 USING btree (datetime, id);

CREATE INDEX items_search_p2013w48_geometry_idx ON pgstac.items_search_p2013w48 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w48_pkey ON pgstac.items_search_p2013w48 USING btree (id);

CREATE INDEX items_search_p2013w48_properties_idx ON pgstac.items_search_p2013w48 USING gin (properties);

CREATE INDEX items_search_p2013w49_collection_id_idx ON pgstac.items_search_p2013w49 USING btree (collection_id);

CREATE INDEX items_search_p2013w49_datetime_id_idx ON pgstac.items_search_p2013w49 USING btree (datetime, id);

CREATE INDEX items_search_p2013w49_geometry_idx ON pgstac.items_search_p2013w49 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w49_pkey ON pgstac.items_search_p2013w49 USING btree (id);

CREATE INDEX items_search_p2013w49_properties_idx ON pgstac.items_search_p2013w49 USING gin (properties);

CREATE INDEX items_search_p2013w50_collection_id_idx ON pgstac.items_search_p2013w50 USING btree (collection_id);

CREATE INDEX items_search_p2013w50_datetime_id_idx ON pgstac.items_search_p2013w50 USING btree (datetime, id);

CREATE INDEX items_search_p2013w50_geometry_idx ON pgstac.items_search_p2013w50 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w50_pkey ON pgstac.items_search_p2013w50 USING btree (id);

CREATE INDEX items_search_p2013w50_properties_idx ON pgstac.items_search_p2013w50 USING gin (properties);

CREATE INDEX items_search_p2013w51_collection_id_idx ON pgstac.items_search_p2013w51 USING btree (collection_id);

CREATE INDEX items_search_p2013w51_datetime_id_idx ON pgstac.items_search_p2013w51 USING btree (datetime, id);

CREATE INDEX items_search_p2013w51_geometry_idx ON pgstac.items_search_p2013w51 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w51_pkey ON pgstac.items_search_p2013w51 USING btree (id);

CREATE INDEX items_search_p2013w51_properties_idx ON pgstac.items_search_p2013w51 USING gin (properties);

CREATE INDEX items_search_p2013w52_collection_id_idx ON pgstac.items_search_p2013w52 USING btree (collection_id);

CREATE INDEX items_search_p2013w52_datetime_id_idx ON pgstac.items_search_p2013w52 USING btree (datetime, id);

CREATE INDEX items_search_p2013w52_geometry_idx ON pgstac.items_search_p2013w52 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2013w52_pkey ON pgstac.items_search_p2013w52 USING btree (id);

CREATE INDEX items_search_p2013w52_properties_idx ON pgstac.items_search_p2013w52 USING gin (properties);

CREATE INDEX items_search_p2014w01_collection_id_idx ON pgstac.items_search_p2014w01 USING btree (collection_id);

CREATE INDEX items_search_p2014w01_datetime_id_idx ON pgstac.items_search_p2014w01 USING btree (datetime, id);

CREATE INDEX items_search_p2014w01_geometry_idx ON pgstac.items_search_p2014w01 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w01_pkey ON pgstac.items_search_p2014w01 USING btree (id);

CREATE INDEX items_search_p2014w01_properties_idx ON pgstac.items_search_p2014w01 USING gin (properties);

CREATE INDEX items_search_p2014w02_collection_id_idx ON pgstac.items_search_p2014w02 USING btree (collection_id);

CREATE INDEX items_search_p2014w02_datetime_id_idx ON pgstac.items_search_p2014w02 USING btree (datetime, id);

CREATE INDEX items_search_p2014w02_geometry_idx ON pgstac.items_search_p2014w02 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w02_pkey ON pgstac.items_search_p2014w02 USING btree (id);

CREATE INDEX items_search_p2014w02_properties_idx ON pgstac.items_search_p2014w02 USING gin (properties);

CREATE INDEX items_search_p2014w03_collection_id_idx ON pgstac.items_search_p2014w03 USING btree (collection_id);

CREATE INDEX items_search_p2014w03_datetime_id_idx ON pgstac.items_search_p2014w03 USING btree (datetime, id);

CREATE INDEX items_search_p2014w03_geometry_idx ON pgstac.items_search_p2014w03 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w03_pkey ON pgstac.items_search_p2014w03 USING btree (id);

CREATE INDEX items_search_p2014w03_properties_idx ON pgstac.items_search_p2014w03 USING gin (properties);

CREATE INDEX items_search_p2014w04_collection_id_idx ON pgstac.items_search_p2014w04 USING btree (collection_id);

CREATE INDEX items_search_p2014w04_datetime_id_idx ON pgstac.items_search_p2014w04 USING btree (datetime, id);

CREATE INDEX items_search_p2014w04_geometry_idx ON pgstac.items_search_p2014w04 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w04_pkey ON pgstac.items_search_p2014w04 USING btree (id);

CREATE INDEX items_search_p2014w04_properties_idx ON pgstac.items_search_p2014w04 USING gin (properties);

CREATE INDEX items_search_p2014w05_collection_id_idx ON pgstac.items_search_p2014w05 USING btree (collection_id);

CREATE INDEX items_search_p2014w05_datetime_id_idx ON pgstac.items_search_p2014w05 USING btree (datetime, id);

CREATE INDEX items_search_p2014w05_geometry_idx ON pgstac.items_search_p2014w05 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w05_pkey ON pgstac.items_search_p2014w05 USING btree (id);

CREATE INDEX items_search_p2014w05_properties_idx ON pgstac.items_search_p2014w05 USING gin (properties);

CREATE INDEX items_search_p2014w06_collection_id_idx ON pgstac.items_search_p2014w06 USING btree (collection_id);

CREATE INDEX items_search_p2014w06_datetime_id_idx ON pgstac.items_search_p2014w06 USING btree (datetime, id);

CREATE INDEX items_search_p2014w06_geometry_idx ON pgstac.items_search_p2014w06 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w06_pkey ON pgstac.items_search_p2014w06 USING btree (id);

CREATE INDEX items_search_p2014w06_properties_idx ON pgstac.items_search_p2014w06 USING gin (properties);

CREATE INDEX items_search_p2014w07_collection_id_idx ON pgstac.items_search_p2014w07 USING btree (collection_id);

CREATE INDEX items_search_p2014w07_datetime_id_idx ON pgstac.items_search_p2014w07 USING btree (datetime, id);

CREATE INDEX items_search_p2014w07_geometry_idx ON pgstac.items_search_p2014w07 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w07_pkey ON pgstac.items_search_p2014w07 USING btree (id);

CREATE INDEX items_search_p2014w07_properties_idx ON pgstac.items_search_p2014w07 USING gin (properties);

CREATE INDEX items_search_p2014w08_collection_id_idx ON pgstac.items_search_p2014w08 USING btree (collection_id);

CREATE INDEX items_search_p2014w08_datetime_id_idx ON pgstac.items_search_p2014w08 USING btree (datetime, id);

CREATE INDEX items_search_p2014w08_geometry_idx ON pgstac.items_search_p2014w08 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w08_pkey ON pgstac.items_search_p2014w08 USING btree (id);

CREATE INDEX items_search_p2014w08_properties_idx ON pgstac.items_search_p2014w08 USING gin (properties);

CREATE INDEX items_search_p2014w09_collection_id_idx ON pgstac.items_search_p2014w09 USING btree (collection_id);

CREATE INDEX items_search_p2014w09_datetime_id_idx ON pgstac.items_search_p2014w09 USING btree (datetime, id);

CREATE INDEX items_search_p2014w09_geometry_idx ON pgstac.items_search_p2014w09 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w09_pkey ON pgstac.items_search_p2014w09 USING btree (id);

CREATE INDEX items_search_p2014w09_properties_idx ON pgstac.items_search_p2014w09 USING gin (properties);

CREATE INDEX items_search_p2014w10_collection_id_idx ON pgstac.items_search_p2014w10 USING btree (collection_id);

CREATE INDEX items_search_p2014w10_datetime_id_idx ON pgstac.items_search_p2014w10 USING btree (datetime, id);

CREATE INDEX items_search_p2014w10_geometry_idx ON pgstac.items_search_p2014w10 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w10_pkey ON pgstac.items_search_p2014w10 USING btree (id);

CREATE INDEX items_search_p2014w10_properties_idx ON pgstac.items_search_p2014w10 USING gin (properties);

CREATE INDEX items_search_p2014w11_collection_id_idx ON pgstac.items_search_p2014w11 USING btree (collection_id);

CREATE INDEX items_search_p2014w11_datetime_id_idx ON pgstac.items_search_p2014w11 USING btree (datetime, id);

CREATE INDEX items_search_p2014w11_geometry_idx ON pgstac.items_search_p2014w11 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w11_pkey ON pgstac.items_search_p2014w11 USING btree (id);

CREATE INDEX items_search_p2014w11_properties_idx ON pgstac.items_search_p2014w11 USING gin (properties);

CREATE INDEX items_search_p2014w12_collection_id_idx ON pgstac.items_search_p2014w12 USING btree (collection_id);

CREATE INDEX items_search_p2014w12_datetime_id_idx ON pgstac.items_search_p2014w12 USING btree (datetime, id);

CREATE INDEX items_search_p2014w12_geometry_idx ON pgstac.items_search_p2014w12 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w12_pkey ON pgstac.items_search_p2014w12 USING btree (id);

CREATE INDEX items_search_p2014w12_properties_idx ON pgstac.items_search_p2014w12 USING gin (properties);

CREATE INDEX items_search_p2014w13_collection_id_idx ON pgstac.items_search_p2014w13 USING btree (collection_id);

CREATE INDEX items_search_p2014w13_datetime_id_idx ON pgstac.items_search_p2014w13 USING btree (datetime, id);

CREATE INDEX items_search_p2014w13_geometry_idx ON pgstac.items_search_p2014w13 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w13_pkey ON pgstac.items_search_p2014w13 USING btree (id);

CREATE INDEX items_search_p2014w13_properties_idx ON pgstac.items_search_p2014w13 USING gin (properties);

CREATE INDEX items_search_p2014w14_collection_id_idx ON pgstac.items_search_p2014w14 USING btree (collection_id);

CREATE INDEX items_search_p2014w14_datetime_id_idx ON pgstac.items_search_p2014w14 USING btree (datetime, id);

CREATE INDEX items_search_p2014w14_geometry_idx ON pgstac.items_search_p2014w14 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w14_pkey ON pgstac.items_search_p2014w14 USING btree (id);

CREATE INDEX items_search_p2014w14_properties_idx ON pgstac.items_search_p2014w14 USING gin (properties);

CREATE INDEX items_search_p2014w15_collection_id_idx ON pgstac.items_search_p2014w15 USING btree (collection_id);

CREATE INDEX items_search_p2014w15_datetime_id_idx ON pgstac.items_search_p2014w15 USING btree (datetime, id);

CREATE INDEX items_search_p2014w15_geometry_idx ON pgstac.items_search_p2014w15 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w15_pkey ON pgstac.items_search_p2014w15 USING btree (id);

CREATE INDEX items_search_p2014w15_properties_idx ON pgstac.items_search_p2014w15 USING gin (properties);

CREATE INDEX items_search_p2014w16_collection_id_idx ON pgstac.items_search_p2014w16 USING btree (collection_id);

CREATE INDEX items_search_p2014w16_datetime_id_idx ON pgstac.items_search_p2014w16 USING btree (datetime, id);

CREATE INDEX items_search_p2014w16_geometry_idx ON pgstac.items_search_p2014w16 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w16_pkey ON pgstac.items_search_p2014w16 USING btree (id);

CREATE INDEX items_search_p2014w16_properties_idx ON pgstac.items_search_p2014w16 USING gin (properties);

CREATE INDEX items_search_p2014w17_collection_id_idx ON pgstac.items_search_p2014w17 USING btree (collection_id);

CREATE INDEX items_search_p2014w17_datetime_id_idx ON pgstac.items_search_p2014w17 USING btree (datetime, id);

CREATE INDEX items_search_p2014w17_geometry_idx ON pgstac.items_search_p2014w17 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w17_pkey ON pgstac.items_search_p2014w17 USING btree (id);

CREATE INDEX items_search_p2014w17_properties_idx ON pgstac.items_search_p2014w17 USING gin (properties);

CREATE INDEX items_search_p2014w18_collection_id_idx ON pgstac.items_search_p2014w18 USING btree (collection_id);

CREATE INDEX items_search_p2014w18_datetime_id_idx ON pgstac.items_search_p2014w18 USING btree (datetime, id);

CREATE INDEX items_search_p2014w18_geometry_idx ON pgstac.items_search_p2014w18 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w18_pkey ON pgstac.items_search_p2014w18 USING btree (id);

CREATE INDEX items_search_p2014w18_properties_idx ON pgstac.items_search_p2014w18 USING gin (properties);

CREATE INDEX items_search_p2014w19_collection_id_idx ON pgstac.items_search_p2014w19 USING btree (collection_id);

CREATE INDEX items_search_p2014w19_datetime_id_idx ON pgstac.items_search_p2014w19 USING btree (datetime, id);

CREATE INDEX items_search_p2014w19_geometry_idx ON pgstac.items_search_p2014w19 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w19_pkey ON pgstac.items_search_p2014w19 USING btree (id);

CREATE INDEX items_search_p2014w19_properties_idx ON pgstac.items_search_p2014w19 USING gin (properties);

CREATE INDEX items_search_p2014w20_collection_id_idx ON pgstac.items_search_p2014w20 USING btree (collection_id);

CREATE INDEX items_search_p2014w20_datetime_id_idx ON pgstac.items_search_p2014w20 USING btree (datetime, id);

CREATE INDEX items_search_p2014w20_geometry_idx ON pgstac.items_search_p2014w20 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w20_pkey ON pgstac.items_search_p2014w20 USING btree (id);

CREATE INDEX items_search_p2014w20_properties_idx ON pgstac.items_search_p2014w20 USING gin (properties);

CREATE INDEX items_search_p2014w21_collection_id_idx ON pgstac.items_search_p2014w21 USING btree (collection_id);

CREATE INDEX items_search_p2014w21_datetime_id_idx ON pgstac.items_search_p2014w21 USING btree (datetime, id);

CREATE INDEX items_search_p2014w21_geometry_idx ON pgstac.items_search_p2014w21 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w21_pkey ON pgstac.items_search_p2014w21 USING btree (id);

CREATE INDEX items_search_p2014w21_properties_idx ON pgstac.items_search_p2014w21 USING gin (properties);

CREATE INDEX items_search_p2014w22_collection_id_idx ON pgstac.items_search_p2014w22 USING btree (collection_id);

CREATE INDEX items_search_p2014w22_datetime_id_idx ON pgstac.items_search_p2014w22 USING btree (datetime, id);

CREATE INDEX items_search_p2014w22_geometry_idx ON pgstac.items_search_p2014w22 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w22_pkey ON pgstac.items_search_p2014w22 USING btree (id);

CREATE INDEX items_search_p2014w22_properties_idx ON pgstac.items_search_p2014w22 USING gin (properties);

CREATE INDEX items_search_p2014w23_collection_id_idx ON pgstac.items_search_p2014w23 USING btree (collection_id);

CREATE INDEX items_search_p2014w23_datetime_id_idx ON pgstac.items_search_p2014w23 USING btree (datetime, id);

CREATE INDEX items_search_p2014w23_geometry_idx ON pgstac.items_search_p2014w23 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w23_pkey ON pgstac.items_search_p2014w23 USING btree (id);

CREATE INDEX items_search_p2014w23_properties_idx ON pgstac.items_search_p2014w23 USING gin (properties);

CREATE INDEX items_search_p2014w24_collection_id_idx ON pgstac.items_search_p2014w24 USING btree (collection_id);

CREATE INDEX items_search_p2014w24_datetime_id_idx ON pgstac.items_search_p2014w24 USING btree (datetime, id);

CREATE INDEX items_search_p2014w24_geometry_idx ON pgstac.items_search_p2014w24 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w24_pkey ON pgstac.items_search_p2014w24 USING btree (id);

CREATE INDEX items_search_p2014w24_properties_idx ON pgstac.items_search_p2014w24 USING gin (properties);

CREATE INDEX items_search_p2014w25_collection_id_idx ON pgstac.items_search_p2014w25 USING btree (collection_id);

CREATE INDEX items_search_p2014w25_datetime_id_idx ON pgstac.items_search_p2014w25 USING btree (datetime, id);

CREATE INDEX items_search_p2014w25_geometry_idx ON pgstac.items_search_p2014w25 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w25_pkey ON pgstac.items_search_p2014w25 USING btree (id);

CREATE INDEX items_search_p2014w25_properties_idx ON pgstac.items_search_p2014w25 USING gin (properties);

CREATE INDEX items_search_p2014w26_collection_id_idx ON pgstac.items_search_p2014w26 USING btree (collection_id);

CREATE INDEX items_search_p2014w26_datetime_id_idx ON pgstac.items_search_p2014w26 USING btree (datetime, id);

CREATE INDEX items_search_p2014w26_geometry_idx ON pgstac.items_search_p2014w26 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w26_pkey ON pgstac.items_search_p2014w26 USING btree (id);

CREATE INDEX items_search_p2014w26_properties_idx ON pgstac.items_search_p2014w26 USING gin (properties);

CREATE INDEX items_search_p2014w27_collection_id_idx ON pgstac.items_search_p2014w27 USING btree (collection_id);

CREATE INDEX items_search_p2014w27_datetime_id_idx ON pgstac.items_search_p2014w27 USING btree (datetime, id);

CREATE INDEX items_search_p2014w27_geometry_idx ON pgstac.items_search_p2014w27 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w27_pkey ON pgstac.items_search_p2014w27 USING btree (id);

CREATE INDEX items_search_p2014w27_properties_idx ON pgstac.items_search_p2014w27 USING gin (properties);

CREATE INDEX items_search_p2014w28_collection_id_idx ON pgstac.items_search_p2014w28 USING btree (collection_id);

CREATE INDEX items_search_p2014w28_datetime_id_idx ON pgstac.items_search_p2014w28 USING btree (datetime, id);

CREATE INDEX items_search_p2014w28_geometry_idx ON pgstac.items_search_p2014w28 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w28_pkey ON pgstac.items_search_p2014w28 USING btree (id);

CREATE INDEX items_search_p2014w28_properties_idx ON pgstac.items_search_p2014w28 USING gin (properties);

CREATE INDEX items_search_p2014w29_collection_id_idx ON pgstac.items_search_p2014w29 USING btree (collection_id);

CREATE INDEX items_search_p2014w29_datetime_id_idx ON pgstac.items_search_p2014w29 USING btree (datetime, id);

CREATE INDEX items_search_p2014w29_geometry_idx ON pgstac.items_search_p2014w29 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w29_pkey ON pgstac.items_search_p2014w29 USING btree (id);

CREATE INDEX items_search_p2014w29_properties_idx ON pgstac.items_search_p2014w29 USING gin (properties);

CREATE INDEX items_search_p2014w30_collection_id_idx ON pgstac.items_search_p2014w30 USING btree (collection_id);

CREATE INDEX items_search_p2014w30_datetime_id_idx ON pgstac.items_search_p2014w30 USING btree (datetime, id);

CREATE INDEX items_search_p2014w30_geometry_idx ON pgstac.items_search_p2014w30 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w30_pkey ON pgstac.items_search_p2014w30 USING btree (id);

CREATE INDEX items_search_p2014w30_properties_idx ON pgstac.items_search_p2014w30 USING gin (properties);

CREATE INDEX items_search_p2014w31_collection_id_idx ON pgstac.items_search_p2014w31 USING btree (collection_id);

CREATE INDEX items_search_p2014w31_datetime_id_idx ON pgstac.items_search_p2014w31 USING btree (datetime, id);

CREATE INDEX items_search_p2014w31_geometry_idx ON pgstac.items_search_p2014w31 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w31_pkey ON pgstac.items_search_p2014w31 USING btree (id);

CREATE INDEX items_search_p2014w31_properties_idx ON pgstac.items_search_p2014w31 USING gin (properties);

CREATE INDEX items_search_p2014w32_collection_id_idx ON pgstac.items_search_p2014w32 USING btree (collection_id);

CREATE INDEX items_search_p2014w32_datetime_id_idx ON pgstac.items_search_p2014w32 USING btree (datetime, id);

CREATE INDEX items_search_p2014w32_geometry_idx ON pgstac.items_search_p2014w32 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w32_pkey ON pgstac.items_search_p2014w32 USING btree (id);

CREATE INDEX items_search_p2014w32_properties_idx ON pgstac.items_search_p2014w32 USING gin (properties);

CREATE INDEX items_search_p2014w33_collection_id_idx ON pgstac.items_search_p2014w33 USING btree (collection_id);

CREATE INDEX items_search_p2014w33_datetime_id_idx ON pgstac.items_search_p2014w33 USING btree (datetime, id);

CREATE INDEX items_search_p2014w33_geometry_idx ON pgstac.items_search_p2014w33 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w33_pkey ON pgstac.items_search_p2014w33 USING btree (id);

CREATE INDEX items_search_p2014w33_properties_idx ON pgstac.items_search_p2014w33 USING gin (properties);

CREATE INDEX items_search_p2014w34_collection_id_idx ON pgstac.items_search_p2014w34 USING btree (collection_id);

CREATE INDEX items_search_p2014w34_datetime_id_idx ON pgstac.items_search_p2014w34 USING btree (datetime, id);

CREATE INDEX items_search_p2014w34_geometry_idx ON pgstac.items_search_p2014w34 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w34_pkey ON pgstac.items_search_p2014w34 USING btree (id);

CREATE INDEX items_search_p2014w34_properties_idx ON pgstac.items_search_p2014w34 USING gin (properties);

CREATE INDEX items_search_p2014w35_collection_id_idx ON pgstac.items_search_p2014w35 USING btree (collection_id);

CREATE INDEX items_search_p2014w35_datetime_id_idx ON pgstac.items_search_p2014w35 USING btree (datetime, id);

CREATE INDEX items_search_p2014w35_geometry_idx ON pgstac.items_search_p2014w35 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w35_pkey ON pgstac.items_search_p2014w35 USING btree (id);

CREATE INDEX items_search_p2014w35_properties_idx ON pgstac.items_search_p2014w35 USING gin (properties);

CREATE INDEX items_search_p2014w36_collection_id_idx ON pgstac.items_search_p2014w36 USING btree (collection_id);

CREATE INDEX items_search_p2014w36_datetime_id_idx ON pgstac.items_search_p2014w36 USING btree (datetime, id);

CREATE INDEX items_search_p2014w36_geometry_idx ON pgstac.items_search_p2014w36 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w36_pkey ON pgstac.items_search_p2014w36 USING btree (id);

CREATE INDEX items_search_p2014w36_properties_idx ON pgstac.items_search_p2014w36 USING gin (properties);

CREATE INDEX items_search_p2014w37_collection_id_idx ON pgstac.items_search_p2014w37 USING btree (collection_id);

CREATE INDEX items_search_p2014w37_datetime_id_idx ON pgstac.items_search_p2014w37 USING btree (datetime, id);

CREATE INDEX items_search_p2014w37_geometry_idx ON pgstac.items_search_p2014w37 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w37_pkey ON pgstac.items_search_p2014w37 USING btree (id);

CREATE INDEX items_search_p2014w37_properties_idx ON pgstac.items_search_p2014w37 USING gin (properties);

CREATE INDEX items_search_p2014w38_collection_id_idx ON pgstac.items_search_p2014w38 USING btree (collection_id);

CREATE INDEX items_search_p2014w38_datetime_id_idx ON pgstac.items_search_p2014w38 USING btree (datetime, id);

CREATE INDEX items_search_p2014w38_geometry_idx ON pgstac.items_search_p2014w38 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w38_pkey ON pgstac.items_search_p2014w38 USING btree (id);

CREATE INDEX items_search_p2014w38_properties_idx ON pgstac.items_search_p2014w38 USING gin (properties);

CREATE INDEX items_search_p2014w39_collection_id_idx ON pgstac.items_search_p2014w39 USING btree (collection_id);

CREATE INDEX items_search_p2014w39_datetime_id_idx ON pgstac.items_search_p2014w39 USING btree (datetime, id);

CREATE INDEX items_search_p2014w39_geometry_idx ON pgstac.items_search_p2014w39 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w39_pkey ON pgstac.items_search_p2014w39 USING btree (id);

CREATE INDEX items_search_p2014w39_properties_idx ON pgstac.items_search_p2014w39 USING gin (properties);

CREATE INDEX items_search_p2014w40_collection_id_idx ON pgstac.items_search_p2014w40 USING btree (collection_id);

CREATE INDEX items_search_p2014w40_datetime_id_idx ON pgstac.items_search_p2014w40 USING btree (datetime, id);

CREATE INDEX items_search_p2014w40_geometry_idx ON pgstac.items_search_p2014w40 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w40_pkey ON pgstac.items_search_p2014w40 USING btree (id);

CREATE INDEX items_search_p2014w40_properties_idx ON pgstac.items_search_p2014w40 USING gin (properties);

CREATE INDEX items_search_p2014w41_collection_id_idx ON pgstac.items_search_p2014w41 USING btree (collection_id);

CREATE INDEX items_search_p2014w41_datetime_id_idx ON pgstac.items_search_p2014w41 USING btree (datetime, id);

CREATE INDEX items_search_p2014w41_geometry_idx ON pgstac.items_search_p2014w41 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w41_pkey ON pgstac.items_search_p2014w41 USING btree (id);

CREATE INDEX items_search_p2014w41_properties_idx ON pgstac.items_search_p2014w41 USING gin (properties);

CREATE INDEX items_search_p2014w42_collection_id_idx ON pgstac.items_search_p2014w42 USING btree (collection_id);

CREATE INDEX items_search_p2014w42_datetime_id_idx ON pgstac.items_search_p2014w42 USING btree (datetime, id);

CREATE INDEX items_search_p2014w42_geometry_idx ON pgstac.items_search_p2014w42 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w42_pkey ON pgstac.items_search_p2014w42 USING btree (id);

CREATE INDEX items_search_p2014w42_properties_idx ON pgstac.items_search_p2014w42 USING gin (properties);

CREATE INDEX items_search_p2014w43_collection_id_idx ON pgstac.items_search_p2014w43 USING btree (collection_id);

CREATE INDEX items_search_p2014w43_datetime_id_idx ON pgstac.items_search_p2014w43 USING btree (datetime, id);

CREATE INDEX items_search_p2014w43_geometry_idx ON pgstac.items_search_p2014w43 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w43_pkey ON pgstac.items_search_p2014w43 USING btree (id);

CREATE INDEX items_search_p2014w43_properties_idx ON pgstac.items_search_p2014w43 USING gin (properties);

CREATE INDEX items_search_p2014w44_collection_id_idx ON pgstac.items_search_p2014w44 USING btree (collection_id);

CREATE INDEX items_search_p2014w44_datetime_id_idx ON pgstac.items_search_p2014w44 USING btree (datetime, id);

CREATE INDEX items_search_p2014w44_geometry_idx ON pgstac.items_search_p2014w44 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w44_pkey ON pgstac.items_search_p2014w44 USING btree (id);

CREATE INDEX items_search_p2014w44_properties_idx ON pgstac.items_search_p2014w44 USING gin (properties);

CREATE INDEX items_search_p2014w45_collection_id_idx ON pgstac.items_search_p2014w45 USING btree (collection_id);

CREATE INDEX items_search_p2014w45_datetime_id_idx ON pgstac.items_search_p2014w45 USING btree (datetime, id);

CREATE INDEX items_search_p2014w45_geometry_idx ON pgstac.items_search_p2014w45 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w45_pkey ON pgstac.items_search_p2014w45 USING btree (id);

CREATE INDEX items_search_p2014w45_properties_idx ON pgstac.items_search_p2014w45 USING gin (properties);

CREATE INDEX items_search_p2014w46_collection_id_idx ON pgstac.items_search_p2014w46 USING btree (collection_id);

CREATE INDEX items_search_p2014w46_datetime_id_idx ON pgstac.items_search_p2014w46 USING btree (datetime, id);

CREATE INDEX items_search_p2014w46_geometry_idx ON pgstac.items_search_p2014w46 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w46_pkey ON pgstac.items_search_p2014w46 USING btree (id);

CREATE INDEX items_search_p2014w46_properties_idx ON pgstac.items_search_p2014w46 USING gin (properties);

CREATE INDEX items_search_p2014w47_collection_id_idx ON pgstac.items_search_p2014w47 USING btree (collection_id);

CREATE INDEX items_search_p2014w47_datetime_id_idx ON pgstac.items_search_p2014w47 USING btree (datetime, id);

CREATE INDEX items_search_p2014w47_geometry_idx ON pgstac.items_search_p2014w47 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w47_pkey ON pgstac.items_search_p2014w47 USING btree (id);

CREATE INDEX items_search_p2014w47_properties_idx ON pgstac.items_search_p2014w47 USING gin (properties);

CREATE INDEX items_search_p2014w48_collection_id_idx ON pgstac.items_search_p2014w48 USING btree (collection_id);

CREATE INDEX items_search_p2014w48_datetime_id_idx ON pgstac.items_search_p2014w48 USING btree (datetime, id);

CREATE INDEX items_search_p2014w48_geometry_idx ON pgstac.items_search_p2014w48 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w48_pkey ON pgstac.items_search_p2014w48 USING btree (id);

CREATE INDEX items_search_p2014w48_properties_idx ON pgstac.items_search_p2014w48 USING gin (properties);

CREATE INDEX items_search_p2014w49_collection_id_idx ON pgstac.items_search_p2014w49 USING btree (collection_id);

CREATE INDEX items_search_p2014w49_datetime_id_idx ON pgstac.items_search_p2014w49 USING btree (datetime, id);

CREATE INDEX items_search_p2014w49_geometry_idx ON pgstac.items_search_p2014w49 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w49_pkey ON pgstac.items_search_p2014w49 USING btree (id);

CREATE INDEX items_search_p2014w49_properties_idx ON pgstac.items_search_p2014w49 USING gin (properties);

CREATE INDEX items_search_p2014w50_collection_id_idx ON pgstac.items_search_p2014w50 USING btree (collection_id);

CREATE INDEX items_search_p2014w50_datetime_id_idx ON pgstac.items_search_p2014w50 USING btree (datetime, id);

CREATE INDEX items_search_p2014w50_geometry_idx ON pgstac.items_search_p2014w50 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w50_pkey ON pgstac.items_search_p2014w50 USING btree (id);

CREATE INDEX items_search_p2014w50_properties_idx ON pgstac.items_search_p2014w50 USING gin (properties);

CREATE INDEX items_search_p2014w51_collection_id_idx ON pgstac.items_search_p2014w51 USING btree (collection_id);

CREATE INDEX items_search_p2014w51_datetime_id_idx ON pgstac.items_search_p2014w51 USING btree (datetime, id);

CREATE INDEX items_search_p2014w51_geometry_idx ON pgstac.items_search_p2014w51 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w51_pkey ON pgstac.items_search_p2014w51 USING btree (id);

CREATE INDEX items_search_p2014w51_properties_idx ON pgstac.items_search_p2014w51 USING gin (properties);

CREATE INDEX items_search_p2014w52_collection_id_idx ON pgstac.items_search_p2014w52 USING btree (collection_id);

CREATE INDEX items_search_p2014w52_datetime_id_idx ON pgstac.items_search_p2014w52 USING btree (datetime, id);

CREATE INDEX items_search_p2014w52_geometry_idx ON pgstac.items_search_p2014w52 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2014w52_pkey ON pgstac.items_search_p2014w52 USING btree (id);

CREATE INDEX items_search_p2014w52_properties_idx ON pgstac.items_search_p2014w52 USING gin (properties);

CREATE INDEX items_search_p2015w01_collection_id_idx ON pgstac.items_search_p2015w01 USING btree (collection_id);

CREATE INDEX items_search_p2015w01_datetime_id_idx ON pgstac.items_search_p2015w01 USING btree (datetime, id);

CREATE INDEX items_search_p2015w01_geometry_idx ON pgstac.items_search_p2015w01 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w01_pkey ON pgstac.items_search_p2015w01 USING btree (id);

CREATE INDEX items_search_p2015w01_properties_idx ON pgstac.items_search_p2015w01 USING gin (properties);

CREATE INDEX items_search_p2015w02_collection_id_idx ON pgstac.items_search_p2015w02 USING btree (collection_id);

CREATE INDEX items_search_p2015w02_datetime_id_idx ON pgstac.items_search_p2015w02 USING btree (datetime, id);

CREATE INDEX items_search_p2015w02_geometry_idx ON pgstac.items_search_p2015w02 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w02_pkey ON pgstac.items_search_p2015w02 USING btree (id);

CREATE INDEX items_search_p2015w02_properties_idx ON pgstac.items_search_p2015w02 USING gin (properties);

CREATE INDEX items_search_p2015w03_collection_id_idx ON pgstac.items_search_p2015w03 USING btree (collection_id);

CREATE INDEX items_search_p2015w03_datetime_id_idx ON pgstac.items_search_p2015w03 USING btree (datetime, id);

CREATE INDEX items_search_p2015w03_geometry_idx ON pgstac.items_search_p2015w03 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w03_pkey ON pgstac.items_search_p2015w03 USING btree (id);

CREATE INDEX items_search_p2015w03_properties_idx ON pgstac.items_search_p2015w03 USING gin (properties);

CREATE INDEX items_search_p2015w04_collection_id_idx ON pgstac.items_search_p2015w04 USING btree (collection_id);

CREATE INDEX items_search_p2015w04_datetime_id_idx ON pgstac.items_search_p2015w04 USING btree (datetime, id);

CREATE INDEX items_search_p2015w04_geometry_idx ON pgstac.items_search_p2015w04 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w04_pkey ON pgstac.items_search_p2015w04 USING btree (id);

CREATE INDEX items_search_p2015w04_properties_idx ON pgstac.items_search_p2015w04 USING gin (properties);

CREATE INDEX items_search_p2015w05_collection_id_idx ON pgstac.items_search_p2015w05 USING btree (collection_id);

CREATE INDEX items_search_p2015w05_datetime_id_idx ON pgstac.items_search_p2015w05 USING btree (datetime, id);

CREATE INDEX items_search_p2015w05_geometry_idx ON pgstac.items_search_p2015w05 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w05_pkey ON pgstac.items_search_p2015w05 USING btree (id);

CREATE INDEX items_search_p2015w05_properties_idx ON pgstac.items_search_p2015w05 USING gin (properties);

CREATE INDEX items_search_p2015w06_collection_id_idx ON pgstac.items_search_p2015w06 USING btree (collection_id);

CREATE INDEX items_search_p2015w06_datetime_id_idx ON pgstac.items_search_p2015w06 USING btree (datetime, id);

CREATE INDEX items_search_p2015w06_geometry_idx ON pgstac.items_search_p2015w06 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w06_pkey ON pgstac.items_search_p2015w06 USING btree (id);

CREATE INDEX items_search_p2015w06_properties_idx ON pgstac.items_search_p2015w06 USING gin (properties);

CREATE INDEX items_search_p2015w07_collection_id_idx ON pgstac.items_search_p2015w07 USING btree (collection_id);

CREATE INDEX items_search_p2015w07_datetime_id_idx ON pgstac.items_search_p2015w07 USING btree (datetime, id);

CREATE INDEX items_search_p2015w07_geometry_idx ON pgstac.items_search_p2015w07 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w07_pkey ON pgstac.items_search_p2015w07 USING btree (id);

CREATE INDEX items_search_p2015w07_properties_idx ON pgstac.items_search_p2015w07 USING gin (properties);

CREATE INDEX items_search_p2015w08_collection_id_idx ON pgstac.items_search_p2015w08 USING btree (collection_id);

CREATE INDEX items_search_p2015w08_datetime_id_idx ON pgstac.items_search_p2015w08 USING btree (datetime, id);

CREATE INDEX items_search_p2015w08_geometry_idx ON pgstac.items_search_p2015w08 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w08_pkey ON pgstac.items_search_p2015w08 USING btree (id);

CREATE INDEX items_search_p2015w08_properties_idx ON pgstac.items_search_p2015w08 USING gin (properties);

CREATE INDEX items_search_p2015w09_collection_id_idx ON pgstac.items_search_p2015w09 USING btree (collection_id);

CREATE INDEX items_search_p2015w09_datetime_id_idx ON pgstac.items_search_p2015w09 USING btree (datetime, id);

CREATE INDEX items_search_p2015w09_geometry_idx ON pgstac.items_search_p2015w09 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w09_pkey ON pgstac.items_search_p2015w09 USING btree (id);

CREATE INDEX items_search_p2015w09_properties_idx ON pgstac.items_search_p2015w09 USING gin (properties);

CREATE INDEX items_search_p2015w10_collection_id_idx ON pgstac.items_search_p2015w10 USING btree (collection_id);

CREATE INDEX items_search_p2015w10_datetime_id_idx ON pgstac.items_search_p2015w10 USING btree (datetime, id);

CREATE INDEX items_search_p2015w10_geometry_idx ON pgstac.items_search_p2015w10 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w10_pkey ON pgstac.items_search_p2015w10 USING btree (id);

CREATE INDEX items_search_p2015w10_properties_idx ON pgstac.items_search_p2015w10 USING gin (properties);

CREATE INDEX items_search_p2015w11_collection_id_idx ON pgstac.items_search_p2015w11 USING btree (collection_id);

CREATE INDEX items_search_p2015w11_datetime_id_idx ON pgstac.items_search_p2015w11 USING btree (datetime, id);

CREATE INDEX items_search_p2015w11_geometry_idx ON pgstac.items_search_p2015w11 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w11_pkey ON pgstac.items_search_p2015w11 USING btree (id);

CREATE INDEX items_search_p2015w11_properties_idx ON pgstac.items_search_p2015w11 USING gin (properties);

CREATE INDEX items_search_p2015w12_collection_id_idx ON pgstac.items_search_p2015w12 USING btree (collection_id);

CREATE INDEX items_search_p2015w12_datetime_id_idx ON pgstac.items_search_p2015w12 USING btree (datetime, id);

CREATE INDEX items_search_p2015w12_geometry_idx ON pgstac.items_search_p2015w12 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w12_pkey ON pgstac.items_search_p2015w12 USING btree (id);

CREATE INDEX items_search_p2015w12_properties_idx ON pgstac.items_search_p2015w12 USING gin (properties);

CREATE INDEX items_search_p2015w13_collection_id_idx ON pgstac.items_search_p2015w13 USING btree (collection_id);

CREATE INDEX items_search_p2015w13_datetime_id_idx ON pgstac.items_search_p2015w13 USING btree (datetime, id);

CREATE INDEX items_search_p2015w13_geometry_idx ON pgstac.items_search_p2015w13 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w13_pkey ON pgstac.items_search_p2015w13 USING btree (id);

CREATE INDEX items_search_p2015w13_properties_idx ON pgstac.items_search_p2015w13 USING gin (properties);

CREATE INDEX items_search_p2015w14_collection_id_idx ON pgstac.items_search_p2015w14 USING btree (collection_id);

CREATE INDEX items_search_p2015w14_datetime_id_idx ON pgstac.items_search_p2015w14 USING btree (datetime, id);

CREATE INDEX items_search_p2015w14_geometry_idx ON pgstac.items_search_p2015w14 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w14_pkey ON pgstac.items_search_p2015w14 USING btree (id);

CREATE INDEX items_search_p2015w14_properties_idx ON pgstac.items_search_p2015w14 USING gin (properties);

CREATE INDEX items_search_p2015w15_collection_id_idx ON pgstac.items_search_p2015w15 USING btree (collection_id);

CREATE INDEX items_search_p2015w15_datetime_id_idx ON pgstac.items_search_p2015w15 USING btree (datetime, id);

CREATE INDEX items_search_p2015w15_geometry_idx ON pgstac.items_search_p2015w15 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w15_pkey ON pgstac.items_search_p2015w15 USING btree (id);

CREATE INDEX items_search_p2015w15_properties_idx ON pgstac.items_search_p2015w15 USING gin (properties);

CREATE INDEX items_search_p2015w16_collection_id_idx ON pgstac.items_search_p2015w16 USING btree (collection_id);

CREATE INDEX items_search_p2015w16_datetime_id_idx ON pgstac.items_search_p2015w16 USING btree (datetime, id);

CREATE INDEX items_search_p2015w16_geometry_idx ON pgstac.items_search_p2015w16 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w16_pkey ON pgstac.items_search_p2015w16 USING btree (id);

CREATE INDEX items_search_p2015w16_properties_idx ON pgstac.items_search_p2015w16 USING gin (properties);

CREATE INDEX items_search_p2015w17_collection_id_idx ON pgstac.items_search_p2015w17 USING btree (collection_id);

CREATE INDEX items_search_p2015w17_datetime_id_idx ON pgstac.items_search_p2015w17 USING btree (datetime, id);

CREATE INDEX items_search_p2015w17_geometry_idx ON pgstac.items_search_p2015w17 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w17_pkey ON pgstac.items_search_p2015w17 USING btree (id);

CREATE INDEX items_search_p2015w17_properties_idx ON pgstac.items_search_p2015w17 USING gin (properties);

CREATE INDEX items_search_p2015w18_collection_id_idx ON pgstac.items_search_p2015w18 USING btree (collection_id);

CREATE INDEX items_search_p2015w18_datetime_id_idx ON pgstac.items_search_p2015w18 USING btree (datetime, id);

CREATE INDEX items_search_p2015w18_geometry_idx ON pgstac.items_search_p2015w18 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w18_pkey ON pgstac.items_search_p2015w18 USING btree (id);

CREATE INDEX items_search_p2015w18_properties_idx ON pgstac.items_search_p2015w18 USING gin (properties);

CREATE INDEX items_search_p2015w19_collection_id_idx ON pgstac.items_search_p2015w19 USING btree (collection_id);

CREATE INDEX items_search_p2015w19_datetime_id_idx ON pgstac.items_search_p2015w19 USING btree (datetime, id);

CREATE INDEX items_search_p2015w19_geometry_idx ON pgstac.items_search_p2015w19 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w19_pkey ON pgstac.items_search_p2015w19 USING btree (id);

CREATE INDEX items_search_p2015w19_properties_idx ON pgstac.items_search_p2015w19 USING gin (properties);

CREATE INDEX items_search_p2015w20_collection_id_idx ON pgstac.items_search_p2015w20 USING btree (collection_id);

CREATE INDEX items_search_p2015w20_datetime_id_idx ON pgstac.items_search_p2015w20 USING btree (datetime, id);

CREATE INDEX items_search_p2015w20_geometry_idx ON pgstac.items_search_p2015w20 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w20_pkey ON pgstac.items_search_p2015w20 USING btree (id);

CREATE INDEX items_search_p2015w20_properties_idx ON pgstac.items_search_p2015w20 USING gin (properties);

CREATE INDEX items_search_p2015w21_collection_id_idx ON pgstac.items_search_p2015w21 USING btree (collection_id);

CREATE INDEX items_search_p2015w21_datetime_id_idx ON pgstac.items_search_p2015w21 USING btree (datetime, id);

CREATE INDEX items_search_p2015w21_geometry_idx ON pgstac.items_search_p2015w21 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w21_pkey ON pgstac.items_search_p2015w21 USING btree (id);

CREATE INDEX items_search_p2015w21_properties_idx ON pgstac.items_search_p2015w21 USING gin (properties);

CREATE INDEX items_search_p2015w22_collection_id_idx ON pgstac.items_search_p2015w22 USING btree (collection_id);

CREATE INDEX items_search_p2015w22_datetime_id_idx ON pgstac.items_search_p2015w22 USING btree (datetime, id);

CREATE INDEX items_search_p2015w22_geometry_idx ON pgstac.items_search_p2015w22 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w22_pkey ON pgstac.items_search_p2015w22 USING btree (id);

CREATE INDEX items_search_p2015w22_properties_idx ON pgstac.items_search_p2015w22 USING gin (properties);

CREATE INDEX items_search_p2015w23_collection_id_idx ON pgstac.items_search_p2015w23 USING btree (collection_id);

CREATE INDEX items_search_p2015w23_datetime_id_idx ON pgstac.items_search_p2015w23 USING btree (datetime, id);

CREATE INDEX items_search_p2015w23_geometry_idx ON pgstac.items_search_p2015w23 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w23_pkey ON pgstac.items_search_p2015w23 USING btree (id);

CREATE INDEX items_search_p2015w23_properties_idx ON pgstac.items_search_p2015w23 USING gin (properties);

CREATE INDEX items_search_p2015w24_collection_id_idx ON pgstac.items_search_p2015w24 USING btree (collection_id);

CREATE INDEX items_search_p2015w24_datetime_id_idx ON pgstac.items_search_p2015w24 USING btree (datetime, id);

CREATE INDEX items_search_p2015w24_geometry_idx ON pgstac.items_search_p2015w24 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w24_pkey ON pgstac.items_search_p2015w24 USING btree (id);

CREATE INDEX items_search_p2015w24_properties_idx ON pgstac.items_search_p2015w24 USING gin (properties);

CREATE INDEX items_search_p2015w25_collection_id_idx ON pgstac.items_search_p2015w25 USING btree (collection_id);

CREATE INDEX items_search_p2015w25_datetime_id_idx ON pgstac.items_search_p2015w25 USING btree (datetime, id);

CREATE INDEX items_search_p2015w25_geometry_idx ON pgstac.items_search_p2015w25 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w25_pkey ON pgstac.items_search_p2015w25 USING btree (id);

CREATE INDEX items_search_p2015w25_properties_idx ON pgstac.items_search_p2015w25 USING gin (properties);

CREATE INDEX items_search_p2015w26_collection_id_idx ON pgstac.items_search_p2015w26 USING btree (collection_id);

CREATE INDEX items_search_p2015w26_datetime_id_idx ON pgstac.items_search_p2015w26 USING btree (datetime, id);

CREATE INDEX items_search_p2015w26_geometry_idx ON pgstac.items_search_p2015w26 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w26_pkey ON pgstac.items_search_p2015w26 USING btree (id);

CREATE INDEX items_search_p2015w26_properties_idx ON pgstac.items_search_p2015w26 USING gin (properties);

CREATE INDEX items_search_p2015w27_collection_id_idx ON pgstac.items_search_p2015w27 USING btree (collection_id);

CREATE INDEX items_search_p2015w27_datetime_id_idx ON pgstac.items_search_p2015w27 USING btree (datetime, id);

CREATE INDEX items_search_p2015w27_geometry_idx ON pgstac.items_search_p2015w27 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w27_pkey ON pgstac.items_search_p2015w27 USING btree (id);

CREATE INDEX items_search_p2015w27_properties_idx ON pgstac.items_search_p2015w27 USING gin (properties);

CREATE INDEX items_search_p2015w28_collection_id_idx ON pgstac.items_search_p2015w28 USING btree (collection_id);

CREATE INDEX items_search_p2015w28_datetime_id_idx ON pgstac.items_search_p2015w28 USING btree (datetime, id);

CREATE INDEX items_search_p2015w28_geometry_idx ON pgstac.items_search_p2015w28 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w28_pkey ON pgstac.items_search_p2015w28 USING btree (id);

CREATE INDEX items_search_p2015w28_properties_idx ON pgstac.items_search_p2015w28 USING gin (properties);

CREATE INDEX items_search_p2015w29_collection_id_idx ON pgstac.items_search_p2015w29 USING btree (collection_id);

CREATE INDEX items_search_p2015w29_datetime_id_idx ON pgstac.items_search_p2015w29 USING btree (datetime, id);

CREATE INDEX items_search_p2015w29_geometry_idx ON pgstac.items_search_p2015w29 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w29_pkey ON pgstac.items_search_p2015w29 USING btree (id);

CREATE INDEX items_search_p2015w29_properties_idx ON pgstac.items_search_p2015w29 USING gin (properties);

CREATE INDEX items_search_p2015w30_collection_id_idx ON pgstac.items_search_p2015w30 USING btree (collection_id);

CREATE INDEX items_search_p2015w30_datetime_id_idx ON pgstac.items_search_p2015w30 USING btree (datetime, id);

CREATE INDEX items_search_p2015w30_geometry_idx ON pgstac.items_search_p2015w30 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w30_pkey ON pgstac.items_search_p2015w30 USING btree (id);

CREATE INDEX items_search_p2015w30_properties_idx ON pgstac.items_search_p2015w30 USING gin (properties);

CREATE INDEX items_search_p2015w31_collection_id_idx ON pgstac.items_search_p2015w31 USING btree (collection_id);

CREATE INDEX items_search_p2015w31_datetime_id_idx ON pgstac.items_search_p2015w31 USING btree (datetime, id);

CREATE INDEX items_search_p2015w31_geometry_idx ON pgstac.items_search_p2015w31 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w31_pkey ON pgstac.items_search_p2015w31 USING btree (id);

CREATE INDEX items_search_p2015w31_properties_idx ON pgstac.items_search_p2015w31 USING gin (properties);

CREATE INDEX items_search_p2015w32_collection_id_idx ON pgstac.items_search_p2015w32 USING btree (collection_id);

CREATE INDEX items_search_p2015w32_datetime_id_idx ON pgstac.items_search_p2015w32 USING btree (datetime, id);

CREATE INDEX items_search_p2015w32_geometry_idx ON pgstac.items_search_p2015w32 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w32_pkey ON pgstac.items_search_p2015w32 USING btree (id);

CREATE INDEX items_search_p2015w32_properties_idx ON pgstac.items_search_p2015w32 USING gin (properties);

CREATE INDEX items_search_p2015w33_collection_id_idx ON pgstac.items_search_p2015w33 USING btree (collection_id);

CREATE INDEX items_search_p2015w33_datetime_id_idx ON pgstac.items_search_p2015w33 USING btree (datetime, id);

CREATE INDEX items_search_p2015w33_geometry_idx ON pgstac.items_search_p2015w33 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w33_pkey ON pgstac.items_search_p2015w33 USING btree (id);

CREATE INDEX items_search_p2015w33_properties_idx ON pgstac.items_search_p2015w33 USING gin (properties);

CREATE INDEX items_search_p2015w34_collection_id_idx ON pgstac.items_search_p2015w34 USING btree (collection_id);

CREATE INDEX items_search_p2015w34_datetime_id_idx ON pgstac.items_search_p2015w34 USING btree (datetime, id);

CREATE INDEX items_search_p2015w34_geometry_idx ON pgstac.items_search_p2015w34 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w34_pkey ON pgstac.items_search_p2015w34 USING btree (id);

CREATE INDEX items_search_p2015w34_properties_idx ON pgstac.items_search_p2015w34 USING gin (properties);

CREATE INDEX items_search_p2015w35_collection_id_idx ON pgstac.items_search_p2015w35 USING btree (collection_id);

CREATE INDEX items_search_p2015w35_datetime_id_idx ON pgstac.items_search_p2015w35 USING btree (datetime, id);

CREATE INDEX items_search_p2015w35_geometry_idx ON pgstac.items_search_p2015w35 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w35_pkey ON pgstac.items_search_p2015w35 USING btree (id);

CREATE INDEX items_search_p2015w35_properties_idx ON pgstac.items_search_p2015w35 USING gin (properties);

CREATE INDEX items_search_p2015w36_collection_id_idx ON pgstac.items_search_p2015w36 USING btree (collection_id);

CREATE INDEX items_search_p2015w36_datetime_id_idx ON pgstac.items_search_p2015w36 USING btree (datetime, id);

CREATE INDEX items_search_p2015w36_geometry_idx ON pgstac.items_search_p2015w36 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w36_pkey ON pgstac.items_search_p2015w36 USING btree (id);

CREATE INDEX items_search_p2015w36_properties_idx ON pgstac.items_search_p2015w36 USING gin (properties);

CREATE INDEX items_search_p2015w37_collection_id_idx ON pgstac.items_search_p2015w37 USING btree (collection_id);

CREATE INDEX items_search_p2015w37_datetime_id_idx ON pgstac.items_search_p2015w37 USING btree (datetime, id);

CREATE INDEX items_search_p2015w37_geometry_idx ON pgstac.items_search_p2015w37 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w37_pkey ON pgstac.items_search_p2015w37 USING btree (id);

CREATE INDEX items_search_p2015w37_properties_idx ON pgstac.items_search_p2015w37 USING gin (properties);

CREATE INDEX items_search_p2015w38_collection_id_idx ON pgstac.items_search_p2015w38 USING btree (collection_id);

CREATE INDEX items_search_p2015w38_datetime_id_idx ON pgstac.items_search_p2015w38 USING btree (datetime, id);

CREATE INDEX items_search_p2015w38_geometry_idx ON pgstac.items_search_p2015w38 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w38_pkey ON pgstac.items_search_p2015w38 USING btree (id);

CREATE INDEX items_search_p2015w38_properties_idx ON pgstac.items_search_p2015w38 USING gin (properties);

CREATE INDEX items_search_p2015w39_collection_id_idx ON pgstac.items_search_p2015w39 USING btree (collection_id);

CREATE INDEX items_search_p2015w39_datetime_id_idx ON pgstac.items_search_p2015w39 USING btree (datetime, id);

CREATE INDEX items_search_p2015w39_geometry_idx ON pgstac.items_search_p2015w39 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w39_pkey ON pgstac.items_search_p2015w39 USING btree (id);

CREATE INDEX items_search_p2015w39_properties_idx ON pgstac.items_search_p2015w39 USING gin (properties);

CREATE INDEX items_search_p2015w40_collection_id_idx ON pgstac.items_search_p2015w40 USING btree (collection_id);

CREATE INDEX items_search_p2015w40_datetime_id_idx ON pgstac.items_search_p2015w40 USING btree (datetime, id);

CREATE INDEX items_search_p2015w40_geometry_idx ON pgstac.items_search_p2015w40 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w40_pkey ON pgstac.items_search_p2015w40 USING btree (id);

CREATE INDEX items_search_p2015w40_properties_idx ON pgstac.items_search_p2015w40 USING gin (properties);

CREATE INDEX items_search_p2015w41_collection_id_idx ON pgstac.items_search_p2015w41 USING btree (collection_id);

CREATE INDEX items_search_p2015w41_datetime_id_idx ON pgstac.items_search_p2015w41 USING btree (datetime, id);

CREATE INDEX items_search_p2015w41_geometry_idx ON pgstac.items_search_p2015w41 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w41_pkey ON pgstac.items_search_p2015w41 USING btree (id);

CREATE INDEX items_search_p2015w41_properties_idx ON pgstac.items_search_p2015w41 USING gin (properties);

CREATE INDEX items_search_p2015w42_collection_id_idx ON pgstac.items_search_p2015w42 USING btree (collection_id);

CREATE INDEX items_search_p2015w42_datetime_id_idx ON pgstac.items_search_p2015w42 USING btree (datetime, id);

CREATE INDEX items_search_p2015w42_geometry_idx ON pgstac.items_search_p2015w42 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w42_pkey ON pgstac.items_search_p2015w42 USING btree (id);

CREATE INDEX items_search_p2015w42_properties_idx ON pgstac.items_search_p2015w42 USING gin (properties);

CREATE INDEX items_search_p2015w43_collection_id_idx ON pgstac.items_search_p2015w43 USING btree (collection_id);

CREATE INDEX items_search_p2015w43_datetime_id_idx ON pgstac.items_search_p2015w43 USING btree (datetime, id);

CREATE INDEX items_search_p2015w43_geometry_idx ON pgstac.items_search_p2015w43 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w43_pkey ON pgstac.items_search_p2015w43 USING btree (id);

CREATE INDEX items_search_p2015w43_properties_idx ON pgstac.items_search_p2015w43 USING gin (properties);

CREATE INDEX items_search_p2015w44_collection_id_idx ON pgstac.items_search_p2015w44 USING btree (collection_id);

CREATE INDEX items_search_p2015w44_datetime_id_idx ON pgstac.items_search_p2015w44 USING btree (datetime, id);

CREATE INDEX items_search_p2015w44_geometry_idx ON pgstac.items_search_p2015w44 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w44_pkey ON pgstac.items_search_p2015w44 USING btree (id);

CREATE INDEX items_search_p2015w44_properties_idx ON pgstac.items_search_p2015w44 USING gin (properties);

CREATE INDEX items_search_p2015w45_collection_id_idx ON pgstac.items_search_p2015w45 USING btree (collection_id);

CREATE INDEX items_search_p2015w45_datetime_id_idx ON pgstac.items_search_p2015w45 USING btree (datetime, id);

CREATE INDEX items_search_p2015w45_geometry_idx ON pgstac.items_search_p2015w45 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w45_pkey ON pgstac.items_search_p2015w45 USING btree (id);

CREATE INDEX items_search_p2015w45_properties_idx ON pgstac.items_search_p2015w45 USING gin (properties);

CREATE INDEX items_search_p2015w46_collection_id_idx ON pgstac.items_search_p2015w46 USING btree (collection_id);

CREATE INDEX items_search_p2015w46_datetime_id_idx ON pgstac.items_search_p2015w46 USING btree (datetime, id);

CREATE INDEX items_search_p2015w46_geometry_idx ON pgstac.items_search_p2015w46 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w46_pkey ON pgstac.items_search_p2015w46 USING btree (id);

CREATE INDEX items_search_p2015w46_properties_idx ON pgstac.items_search_p2015w46 USING gin (properties);

CREATE INDEX items_search_p2015w47_collection_id_idx ON pgstac.items_search_p2015w47 USING btree (collection_id);

CREATE INDEX items_search_p2015w47_datetime_id_idx ON pgstac.items_search_p2015w47 USING btree (datetime, id);

CREATE INDEX items_search_p2015w47_geometry_idx ON pgstac.items_search_p2015w47 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w47_pkey ON pgstac.items_search_p2015w47 USING btree (id);

CREATE INDEX items_search_p2015w47_properties_idx ON pgstac.items_search_p2015w47 USING gin (properties);

CREATE INDEX items_search_p2015w48_collection_id_idx ON pgstac.items_search_p2015w48 USING btree (collection_id);

CREATE INDEX items_search_p2015w48_datetime_id_idx ON pgstac.items_search_p2015w48 USING btree (datetime, id);

CREATE INDEX items_search_p2015w48_geometry_idx ON pgstac.items_search_p2015w48 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w48_pkey ON pgstac.items_search_p2015w48 USING btree (id);

CREATE INDEX items_search_p2015w48_properties_idx ON pgstac.items_search_p2015w48 USING gin (properties);

CREATE INDEX items_search_p2015w49_collection_id_idx ON pgstac.items_search_p2015w49 USING btree (collection_id);

CREATE INDEX items_search_p2015w49_datetime_id_idx ON pgstac.items_search_p2015w49 USING btree (datetime, id);

CREATE INDEX items_search_p2015w49_geometry_idx ON pgstac.items_search_p2015w49 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w49_pkey ON pgstac.items_search_p2015w49 USING btree (id);

CREATE INDEX items_search_p2015w49_properties_idx ON pgstac.items_search_p2015w49 USING gin (properties);

CREATE INDEX items_search_p2015w50_collection_id_idx ON pgstac.items_search_p2015w50 USING btree (collection_id);

CREATE INDEX items_search_p2015w50_datetime_id_idx ON pgstac.items_search_p2015w50 USING btree (datetime, id);

CREATE INDEX items_search_p2015w50_geometry_idx ON pgstac.items_search_p2015w50 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w50_pkey ON pgstac.items_search_p2015w50 USING btree (id);

CREATE INDEX items_search_p2015w50_properties_idx ON pgstac.items_search_p2015w50 USING gin (properties);

CREATE INDEX items_search_p2015w51_collection_id_idx ON pgstac.items_search_p2015w51 USING btree (collection_id);

CREATE INDEX items_search_p2015w51_datetime_id_idx ON pgstac.items_search_p2015w51 USING btree (datetime, id);

CREATE INDEX items_search_p2015w51_geometry_idx ON pgstac.items_search_p2015w51 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w51_pkey ON pgstac.items_search_p2015w51 USING btree (id);

CREATE INDEX items_search_p2015w51_properties_idx ON pgstac.items_search_p2015w51 USING gin (properties);

CREATE INDEX items_search_p2015w52_collection_id_idx ON pgstac.items_search_p2015w52 USING btree (collection_id);

CREATE INDEX items_search_p2015w52_datetime_id_idx ON pgstac.items_search_p2015w52 USING btree (datetime, id);

CREATE INDEX items_search_p2015w52_geometry_idx ON pgstac.items_search_p2015w52 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w52_pkey ON pgstac.items_search_p2015w52 USING btree (id);

CREATE INDEX items_search_p2015w52_properties_idx ON pgstac.items_search_p2015w52 USING gin (properties);

CREATE INDEX items_search_p2015w53_collection_id_idx ON pgstac.items_search_p2015w53 USING btree (collection_id);

CREATE INDEX items_search_p2015w53_datetime_id_idx ON pgstac.items_search_p2015w53 USING btree (datetime, id);

CREATE INDEX items_search_p2015w53_geometry_idx ON pgstac.items_search_p2015w53 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2015w53_pkey ON pgstac.items_search_p2015w53 USING btree (id);

CREATE INDEX items_search_p2015w53_properties_idx ON pgstac.items_search_p2015w53 USING gin (properties);

CREATE INDEX items_search_p2016w01_collection_id_idx ON pgstac.items_search_p2016w01 USING btree (collection_id);

CREATE INDEX items_search_p2016w01_datetime_id_idx ON pgstac.items_search_p2016w01 USING btree (datetime, id);

CREATE INDEX items_search_p2016w01_geometry_idx ON pgstac.items_search_p2016w01 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w01_pkey ON pgstac.items_search_p2016w01 USING btree (id);

CREATE INDEX items_search_p2016w01_properties_idx ON pgstac.items_search_p2016w01 USING gin (properties);

CREATE INDEX items_search_p2016w02_collection_id_idx ON pgstac.items_search_p2016w02 USING btree (collection_id);

CREATE INDEX items_search_p2016w02_datetime_id_idx ON pgstac.items_search_p2016w02 USING btree (datetime, id);

CREATE INDEX items_search_p2016w02_geometry_idx ON pgstac.items_search_p2016w02 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w02_pkey ON pgstac.items_search_p2016w02 USING btree (id);

CREATE INDEX items_search_p2016w02_properties_idx ON pgstac.items_search_p2016w02 USING gin (properties);

CREATE INDEX items_search_p2016w03_collection_id_idx ON pgstac.items_search_p2016w03 USING btree (collection_id);

CREATE INDEX items_search_p2016w03_datetime_id_idx ON pgstac.items_search_p2016w03 USING btree (datetime, id);

CREATE INDEX items_search_p2016w03_geometry_idx ON pgstac.items_search_p2016w03 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w03_pkey ON pgstac.items_search_p2016w03 USING btree (id);

CREATE INDEX items_search_p2016w03_properties_idx ON pgstac.items_search_p2016w03 USING gin (properties);

CREATE INDEX items_search_p2016w04_collection_id_idx ON pgstac.items_search_p2016w04 USING btree (collection_id);

CREATE INDEX items_search_p2016w04_datetime_id_idx ON pgstac.items_search_p2016w04 USING btree (datetime, id);

CREATE INDEX items_search_p2016w04_geometry_idx ON pgstac.items_search_p2016w04 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w04_pkey ON pgstac.items_search_p2016w04 USING btree (id);

CREATE INDEX items_search_p2016w04_properties_idx ON pgstac.items_search_p2016w04 USING gin (properties);

CREATE INDEX items_search_p2016w05_collection_id_idx ON pgstac.items_search_p2016w05 USING btree (collection_id);

CREATE INDEX items_search_p2016w05_datetime_id_idx ON pgstac.items_search_p2016w05 USING btree (datetime, id);

CREATE INDEX items_search_p2016w05_geometry_idx ON pgstac.items_search_p2016w05 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w05_pkey ON pgstac.items_search_p2016w05 USING btree (id);

CREATE INDEX items_search_p2016w05_properties_idx ON pgstac.items_search_p2016w05 USING gin (properties);

CREATE INDEX items_search_p2016w06_collection_id_idx ON pgstac.items_search_p2016w06 USING btree (collection_id);

CREATE INDEX items_search_p2016w06_datetime_id_idx ON pgstac.items_search_p2016w06 USING btree (datetime, id);

CREATE INDEX items_search_p2016w06_geometry_idx ON pgstac.items_search_p2016w06 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w06_pkey ON pgstac.items_search_p2016w06 USING btree (id);

CREATE INDEX items_search_p2016w06_properties_idx ON pgstac.items_search_p2016w06 USING gin (properties);

CREATE INDEX items_search_p2016w07_collection_id_idx ON pgstac.items_search_p2016w07 USING btree (collection_id);

CREATE INDEX items_search_p2016w07_datetime_id_idx ON pgstac.items_search_p2016w07 USING btree (datetime, id);

CREATE INDEX items_search_p2016w07_geometry_idx ON pgstac.items_search_p2016w07 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w07_pkey ON pgstac.items_search_p2016w07 USING btree (id);

CREATE INDEX items_search_p2016w07_properties_idx ON pgstac.items_search_p2016w07 USING gin (properties);

CREATE INDEX items_search_p2016w08_collection_id_idx ON pgstac.items_search_p2016w08 USING btree (collection_id);

CREATE INDEX items_search_p2016w08_datetime_id_idx ON pgstac.items_search_p2016w08 USING btree (datetime, id);

CREATE INDEX items_search_p2016w08_geometry_idx ON pgstac.items_search_p2016w08 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w08_pkey ON pgstac.items_search_p2016w08 USING btree (id);

CREATE INDEX items_search_p2016w08_properties_idx ON pgstac.items_search_p2016w08 USING gin (properties);

CREATE INDEX items_search_p2016w09_collection_id_idx ON pgstac.items_search_p2016w09 USING btree (collection_id);

CREATE INDEX items_search_p2016w09_datetime_id_idx ON pgstac.items_search_p2016w09 USING btree (datetime, id);

CREATE INDEX items_search_p2016w09_geometry_idx ON pgstac.items_search_p2016w09 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w09_pkey ON pgstac.items_search_p2016w09 USING btree (id);

CREATE INDEX items_search_p2016w09_properties_idx ON pgstac.items_search_p2016w09 USING gin (properties);

CREATE INDEX items_search_p2016w10_collection_id_idx ON pgstac.items_search_p2016w10 USING btree (collection_id);

CREATE INDEX items_search_p2016w10_datetime_id_idx ON pgstac.items_search_p2016w10 USING btree (datetime, id);

CREATE INDEX items_search_p2016w10_geometry_idx ON pgstac.items_search_p2016w10 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w10_pkey ON pgstac.items_search_p2016w10 USING btree (id);

CREATE INDEX items_search_p2016w10_properties_idx ON pgstac.items_search_p2016w10 USING gin (properties);

CREATE INDEX items_search_p2016w11_collection_id_idx ON pgstac.items_search_p2016w11 USING btree (collection_id);

CREATE INDEX items_search_p2016w11_datetime_id_idx ON pgstac.items_search_p2016w11 USING btree (datetime, id);

CREATE INDEX items_search_p2016w11_geometry_idx ON pgstac.items_search_p2016w11 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w11_pkey ON pgstac.items_search_p2016w11 USING btree (id);

CREATE INDEX items_search_p2016w11_properties_idx ON pgstac.items_search_p2016w11 USING gin (properties);

CREATE INDEX items_search_p2016w12_collection_id_idx ON pgstac.items_search_p2016w12 USING btree (collection_id);

CREATE INDEX items_search_p2016w12_datetime_id_idx ON pgstac.items_search_p2016w12 USING btree (datetime, id);

CREATE INDEX items_search_p2016w12_geometry_idx ON pgstac.items_search_p2016w12 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w12_pkey ON pgstac.items_search_p2016w12 USING btree (id);

CREATE INDEX items_search_p2016w12_properties_idx ON pgstac.items_search_p2016w12 USING gin (properties);

CREATE INDEX items_search_p2016w13_collection_id_idx ON pgstac.items_search_p2016w13 USING btree (collection_id);

CREATE INDEX items_search_p2016w13_datetime_id_idx ON pgstac.items_search_p2016w13 USING btree (datetime, id);

CREATE INDEX items_search_p2016w13_geometry_idx ON pgstac.items_search_p2016w13 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w13_pkey ON pgstac.items_search_p2016w13 USING btree (id);

CREATE INDEX items_search_p2016w13_properties_idx ON pgstac.items_search_p2016w13 USING gin (properties);

CREATE INDEX items_search_p2016w14_collection_id_idx ON pgstac.items_search_p2016w14 USING btree (collection_id);

CREATE INDEX items_search_p2016w14_datetime_id_idx ON pgstac.items_search_p2016w14 USING btree (datetime, id);

CREATE INDEX items_search_p2016w14_geometry_idx ON pgstac.items_search_p2016w14 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w14_pkey ON pgstac.items_search_p2016w14 USING btree (id);

CREATE INDEX items_search_p2016w14_properties_idx ON pgstac.items_search_p2016w14 USING gin (properties);

CREATE INDEX items_search_p2016w15_collection_id_idx ON pgstac.items_search_p2016w15 USING btree (collection_id);

CREATE INDEX items_search_p2016w15_datetime_id_idx ON pgstac.items_search_p2016w15 USING btree (datetime, id);

CREATE INDEX items_search_p2016w15_geometry_idx ON pgstac.items_search_p2016w15 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w15_pkey ON pgstac.items_search_p2016w15 USING btree (id);

CREATE INDEX items_search_p2016w15_properties_idx ON pgstac.items_search_p2016w15 USING gin (properties);

CREATE INDEX items_search_p2016w16_collection_id_idx ON pgstac.items_search_p2016w16 USING btree (collection_id);

CREATE INDEX items_search_p2016w16_datetime_id_idx ON pgstac.items_search_p2016w16 USING btree (datetime, id);

CREATE INDEX items_search_p2016w16_geometry_idx ON pgstac.items_search_p2016w16 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w16_pkey ON pgstac.items_search_p2016w16 USING btree (id);

CREATE INDEX items_search_p2016w16_properties_idx ON pgstac.items_search_p2016w16 USING gin (properties);

CREATE INDEX items_search_p2016w17_collection_id_idx ON pgstac.items_search_p2016w17 USING btree (collection_id);

CREATE INDEX items_search_p2016w17_datetime_id_idx ON pgstac.items_search_p2016w17 USING btree (datetime, id);

CREATE INDEX items_search_p2016w17_geometry_idx ON pgstac.items_search_p2016w17 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w17_pkey ON pgstac.items_search_p2016w17 USING btree (id);

CREATE INDEX items_search_p2016w17_properties_idx ON pgstac.items_search_p2016w17 USING gin (properties);

CREATE INDEX items_search_p2016w18_collection_id_idx ON pgstac.items_search_p2016w18 USING btree (collection_id);

CREATE INDEX items_search_p2016w18_datetime_id_idx ON pgstac.items_search_p2016w18 USING btree (datetime, id);

CREATE INDEX items_search_p2016w18_geometry_idx ON pgstac.items_search_p2016w18 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w18_pkey ON pgstac.items_search_p2016w18 USING btree (id);

CREATE INDEX items_search_p2016w18_properties_idx ON pgstac.items_search_p2016w18 USING gin (properties);

CREATE INDEX items_search_p2016w19_collection_id_idx ON pgstac.items_search_p2016w19 USING btree (collection_id);

CREATE INDEX items_search_p2016w19_datetime_id_idx ON pgstac.items_search_p2016w19 USING btree (datetime, id);

CREATE INDEX items_search_p2016w19_geometry_idx ON pgstac.items_search_p2016w19 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w19_pkey ON pgstac.items_search_p2016w19 USING btree (id);

CREATE INDEX items_search_p2016w19_properties_idx ON pgstac.items_search_p2016w19 USING gin (properties);

CREATE INDEX items_search_p2016w20_collection_id_idx ON pgstac.items_search_p2016w20 USING btree (collection_id);

CREATE INDEX items_search_p2016w20_datetime_id_idx ON pgstac.items_search_p2016w20 USING btree (datetime, id);

CREATE INDEX items_search_p2016w20_geometry_idx ON pgstac.items_search_p2016w20 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w20_pkey ON pgstac.items_search_p2016w20 USING btree (id);

CREATE INDEX items_search_p2016w20_properties_idx ON pgstac.items_search_p2016w20 USING gin (properties);

CREATE INDEX items_search_p2016w21_collection_id_idx ON pgstac.items_search_p2016w21 USING btree (collection_id);

CREATE INDEX items_search_p2016w21_datetime_id_idx ON pgstac.items_search_p2016w21 USING btree (datetime, id);

CREATE INDEX items_search_p2016w21_geometry_idx ON pgstac.items_search_p2016w21 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w21_pkey ON pgstac.items_search_p2016w21 USING btree (id);

CREATE INDEX items_search_p2016w21_properties_idx ON pgstac.items_search_p2016w21 USING gin (properties);

CREATE INDEX items_search_p2016w22_collection_id_idx ON pgstac.items_search_p2016w22 USING btree (collection_id);

CREATE INDEX items_search_p2016w22_datetime_id_idx ON pgstac.items_search_p2016w22 USING btree (datetime, id);

CREATE INDEX items_search_p2016w22_geometry_idx ON pgstac.items_search_p2016w22 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w22_pkey ON pgstac.items_search_p2016w22 USING btree (id);

CREATE INDEX items_search_p2016w22_properties_idx ON pgstac.items_search_p2016w22 USING gin (properties);

CREATE INDEX items_search_p2016w23_collection_id_idx ON pgstac.items_search_p2016w23 USING btree (collection_id);

CREATE INDEX items_search_p2016w23_datetime_id_idx ON pgstac.items_search_p2016w23 USING btree (datetime, id);

CREATE INDEX items_search_p2016w23_geometry_idx ON pgstac.items_search_p2016w23 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w23_pkey ON pgstac.items_search_p2016w23 USING btree (id);

CREATE INDEX items_search_p2016w23_properties_idx ON pgstac.items_search_p2016w23 USING gin (properties);

CREATE INDEX items_search_p2016w24_collection_id_idx ON pgstac.items_search_p2016w24 USING btree (collection_id);

CREATE INDEX items_search_p2016w24_datetime_id_idx ON pgstac.items_search_p2016w24 USING btree (datetime, id);

CREATE INDEX items_search_p2016w24_geometry_idx ON pgstac.items_search_p2016w24 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w24_pkey ON pgstac.items_search_p2016w24 USING btree (id);

CREATE INDEX items_search_p2016w24_properties_idx ON pgstac.items_search_p2016w24 USING gin (properties);

CREATE INDEX items_search_p2016w25_collection_id_idx ON pgstac.items_search_p2016w25 USING btree (collection_id);

CREATE INDEX items_search_p2016w25_datetime_id_idx ON pgstac.items_search_p2016w25 USING btree (datetime, id);

CREATE INDEX items_search_p2016w25_geometry_idx ON pgstac.items_search_p2016w25 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w25_pkey ON pgstac.items_search_p2016w25 USING btree (id);

CREATE INDEX items_search_p2016w25_properties_idx ON pgstac.items_search_p2016w25 USING gin (properties);

CREATE INDEX items_search_p2016w26_collection_id_idx ON pgstac.items_search_p2016w26 USING btree (collection_id);

CREATE INDEX items_search_p2016w26_datetime_id_idx ON pgstac.items_search_p2016w26 USING btree (datetime, id);

CREATE INDEX items_search_p2016w26_geometry_idx ON pgstac.items_search_p2016w26 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w26_pkey ON pgstac.items_search_p2016w26 USING btree (id);

CREATE INDEX items_search_p2016w26_properties_idx ON pgstac.items_search_p2016w26 USING gin (properties);

CREATE INDEX items_search_p2016w27_collection_id_idx ON pgstac.items_search_p2016w27 USING btree (collection_id);

CREATE INDEX items_search_p2016w27_datetime_id_idx ON pgstac.items_search_p2016w27 USING btree (datetime, id);

CREATE INDEX items_search_p2016w27_geometry_idx ON pgstac.items_search_p2016w27 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w27_pkey ON pgstac.items_search_p2016w27 USING btree (id);

CREATE INDEX items_search_p2016w27_properties_idx ON pgstac.items_search_p2016w27 USING gin (properties);

CREATE INDEX items_search_p2016w28_collection_id_idx ON pgstac.items_search_p2016w28 USING btree (collection_id);

CREATE INDEX items_search_p2016w28_datetime_id_idx ON pgstac.items_search_p2016w28 USING btree (datetime, id);

CREATE INDEX items_search_p2016w28_geometry_idx ON pgstac.items_search_p2016w28 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w28_pkey ON pgstac.items_search_p2016w28 USING btree (id);

CREATE INDEX items_search_p2016w28_properties_idx ON pgstac.items_search_p2016w28 USING gin (properties);

CREATE INDEX items_search_p2016w29_collection_id_idx ON pgstac.items_search_p2016w29 USING btree (collection_id);

CREATE INDEX items_search_p2016w29_datetime_id_idx ON pgstac.items_search_p2016w29 USING btree (datetime, id);

CREATE INDEX items_search_p2016w29_geometry_idx ON pgstac.items_search_p2016w29 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w29_pkey ON pgstac.items_search_p2016w29 USING btree (id);

CREATE INDEX items_search_p2016w29_properties_idx ON pgstac.items_search_p2016w29 USING gin (properties);

CREATE INDEX items_search_p2016w30_collection_id_idx ON pgstac.items_search_p2016w30 USING btree (collection_id);

CREATE INDEX items_search_p2016w30_datetime_id_idx ON pgstac.items_search_p2016w30 USING btree (datetime, id);

CREATE INDEX items_search_p2016w30_geometry_idx ON pgstac.items_search_p2016w30 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w30_pkey ON pgstac.items_search_p2016w30 USING btree (id);

CREATE INDEX items_search_p2016w30_properties_idx ON pgstac.items_search_p2016w30 USING gin (properties);

CREATE INDEX items_search_p2016w31_collection_id_idx ON pgstac.items_search_p2016w31 USING btree (collection_id);

CREATE INDEX items_search_p2016w31_datetime_id_idx ON pgstac.items_search_p2016w31 USING btree (datetime, id);

CREATE INDEX items_search_p2016w31_geometry_idx ON pgstac.items_search_p2016w31 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w31_pkey ON pgstac.items_search_p2016w31 USING btree (id);

CREATE INDEX items_search_p2016w31_properties_idx ON pgstac.items_search_p2016w31 USING gin (properties);

CREATE INDEX items_search_p2016w32_collection_id_idx ON pgstac.items_search_p2016w32 USING btree (collection_id);

CREATE INDEX items_search_p2016w32_datetime_id_idx ON pgstac.items_search_p2016w32 USING btree (datetime, id);

CREATE INDEX items_search_p2016w32_geometry_idx ON pgstac.items_search_p2016w32 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w32_pkey ON pgstac.items_search_p2016w32 USING btree (id);

CREATE INDEX items_search_p2016w32_properties_idx ON pgstac.items_search_p2016w32 USING gin (properties);

CREATE INDEX items_search_p2016w33_collection_id_idx ON pgstac.items_search_p2016w33 USING btree (collection_id);

CREATE INDEX items_search_p2016w33_datetime_id_idx ON pgstac.items_search_p2016w33 USING btree (datetime, id);

CREATE INDEX items_search_p2016w33_geometry_idx ON pgstac.items_search_p2016w33 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w33_pkey ON pgstac.items_search_p2016w33 USING btree (id);

CREATE INDEX items_search_p2016w33_properties_idx ON pgstac.items_search_p2016w33 USING gin (properties);

CREATE INDEX items_search_p2016w34_collection_id_idx ON pgstac.items_search_p2016w34 USING btree (collection_id);

CREATE INDEX items_search_p2016w34_datetime_id_idx ON pgstac.items_search_p2016w34 USING btree (datetime, id);

CREATE INDEX items_search_p2016w34_geometry_idx ON pgstac.items_search_p2016w34 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w34_pkey ON pgstac.items_search_p2016w34 USING btree (id);

CREATE INDEX items_search_p2016w34_properties_idx ON pgstac.items_search_p2016w34 USING gin (properties);

CREATE INDEX items_search_p2016w35_collection_id_idx ON pgstac.items_search_p2016w35 USING btree (collection_id);

CREATE INDEX items_search_p2016w35_datetime_id_idx ON pgstac.items_search_p2016w35 USING btree (datetime, id);

CREATE INDEX items_search_p2016w35_geometry_idx ON pgstac.items_search_p2016w35 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w35_pkey ON pgstac.items_search_p2016w35 USING btree (id);

CREATE INDEX items_search_p2016w35_properties_idx ON pgstac.items_search_p2016w35 USING gin (properties);

CREATE INDEX items_search_p2016w36_collection_id_idx ON pgstac.items_search_p2016w36 USING btree (collection_id);

CREATE INDEX items_search_p2016w36_datetime_id_idx ON pgstac.items_search_p2016w36 USING btree (datetime, id);

CREATE INDEX items_search_p2016w36_geometry_idx ON pgstac.items_search_p2016w36 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w36_pkey ON pgstac.items_search_p2016w36 USING btree (id);

CREATE INDEX items_search_p2016w36_properties_idx ON pgstac.items_search_p2016w36 USING gin (properties);

CREATE INDEX items_search_p2016w37_collection_id_idx ON pgstac.items_search_p2016w37 USING btree (collection_id);

CREATE INDEX items_search_p2016w37_datetime_id_idx ON pgstac.items_search_p2016w37 USING btree (datetime, id);

CREATE INDEX items_search_p2016w37_geometry_idx ON pgstac.items_search_p2016w37 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w37_pkey ON pgstac.items_search_p2016w37 USING btree (id);

CREATE INDEX items_search_p2016w37_properties_idx ON pgstac.items_search_p2016w37 USING gin (properties);

CREATE INDEX items_search_p2016w38_collection_id_idx ON pgstac.items_search_p2016w38 USING btree (collection_id);

CREATE INDEX items_search_p2016w38_datetime_id_idx ON pgstac.items_search_p2016w38 USING btree (datetime, id);

CREATE INDEX items_search_p2016w38_geometry_idx ON pgstac.items_search_p2016w38 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w38_pkey ON pgstac.items_search_p2016w38 USING btree (id);

CREATE INDEX items_search_p2016w38_properties_idx ON pgstac.items_search_p2016w38 USING gin (properties);

CREATE INDEX items_search_p2016w39_collection_id_idx ON pgstac.items_search_p2016w39 USING btree (collection_id);

CREATE INDEX items_search_p2016w39_datetime_id_idx ON pgstac.items_search_p2016w39 USING btree (datetime, id);

CREATE INDEX items_search_p2016w39_geometry_idx ON pgstac.items_search_p2016w39 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w39_pkey ON pgstac.items_search_p2016w39 USING btree (id);

CREATE INDEX items_search_p2016w39_properties_idx ON pgstac.items_search_p2016w39 USING gin (properties);

CREATE INDEX items_search_p2016w40_collection_id_idx ON pgstac.items_search_p2016w40 USING btree (collection_id);

CREATE INDEX items_search_p2016w40_datetime_id_idx ON pgstac.items_search_p2016w40 USING btree (datetime, id);

CREATE INDEX items_search_p2016w40_geometry_idx ON pgstac.items_search_p2016w40 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w40_pkey ON pgstac.items_search_p2016w40 USING btree (id);

CREATE INDEX items_search_p2016w40_properties_idx ON pgstac.items_search_p2016w40 USING gin (properties);

CREATE INDEX items_search_p2016w41_collection_id_idx ON pgstac.items_search_p2016w41 USING btree (collection_id);

CREATE INDEX items_search_p2016w41_datetime_id_idx ON pgstac.items_search_p2016w41 USING btree (datetime, id);

CREATE INDEX items_search_p2016w41_geometry_idx ON pgstac.items_search_p2016w41 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w41_pkey ON pgstac.items_search_p2016w41 USING btree (id);

CREATE INDEX items_search_p2016w41_properties_idx ON pgstac.items_search_p2016w41 USING gin (properties);

CREATE INDEX items_search_p2016w42_collection_id_idx ON pgstac.items_search_p2016w42 USING btree (collection_id);

CREATE INDEX items_search_p2016w42_datetime_id_idx ON pgstac.items_search_p2016w42 USING btree (datetime, id);

CREATE INDEX items_search_p2016w42_geometry_idx ON pgstac.items_search_p2016w42 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w42_pkey ON pgstac.items_search_p2016w42 USING btree (id);

CREATE INDEX items_search_p2016w42_properties_idx ON pgstac.items_search_p2016w42 USING gin (properties);

CREATE INDEX items_search_p2016w43_collection_id_idx ON pgstac.items_search_p2016w43 USING btree (collection_id);

CREATE INDEX items_search_p2016w43_datetime_id_idx ON pgstac.items_search_p2016w43 USING btree (datetime, id);

CREATE INDEX items_search_p2016w43_geometry_idx ON pgstac.items_search_p2016w43 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w43_pkey ON pgstac.items_search_p2016w43 USING btree (id);

CREATE INDEX items_search_p2016w43_properties_idx ON pgstac.items_search_p2016w43 USING gin (properties);

CREATE INDEX items_search_p2016w44_collection_id_idx ON pgstac.items_search_p2016w44 USING btree (collection_id);

CREATE INDEX items_search_p2016w44_datetime_id_idx ON pgstac.items_search_p2016w44 USING btree (datetime, id);

CREATE INDEX items_search_p2016w44_geometry_idx ON pgstac.items_search_p2016w44 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w44_pkey ON pgstac.items_search_p2016w44 USING btree (id);

CREATE INDEX items_search_p2016w44_properties_idx ON pgstac.items_search_p2016w44 USING gin (properties);

CREATE INDEX items_search_p2016w45_collection_id_idx ON pgstac.items_search_p2016w45 USING btree (collection_id);

CREATE INDEX items_search_p2016w45_datetime_id_idx ON pgstac.items_search_p2016w45 USING btree (datetime, id);

CREATE INDEX items_search_p2016w45_geometry_idx ON pgstac.items_search_p2016w45 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w45_pkey ON pgstac.items_search_p2016w45 USING btree (id);

CREATE INDEX items_search_p2016w45_properties_idx ON pgstac.items_search_p2016w45 USING gin (properties);

CREATE INDEX items_search_p2016w46_collection_id_idx ON pgstac.items_search_p2016w46 USING btree (collection_id);

CREATE INDEX items_search_p2016w46_datetime_id_idx ON pgstac.items_search_p2016w46 USING btree (datetime, id);

CREATE INDEX items_search_p2016w46_geometry_idx ON pgstac.items_search_p2016w46 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w46_pkey ON pgstac.items_search_p2016w46 USING btree (id);

CREATE INDEX items_search_p2016w46_properties_idx ON pgstac.items_search_p2016w46 USING gin (properties);

CREATE INDEX items_search_p2016w47_collection_id_idx ON pgstac.items_search_p2016w47 USING btree (collection_id);

CREATE INDEX items_search_p2016w47_datetime_id_idx ON pgstac.items_search_p2016w47 USING btree (datetime, id);

CREATE INDEX items_search_p2016w47_geometry_idx ON pgstac.items_search_p2016w47 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w47_pkey ON pgstac.items_search_p2016w47 USING btree (id);

CREATE INDEX items_search_p2016w47_properties_idx ON pgstac.items_search_p2016w47 USING gin (properties);

CREATE INDEX items_search_p2016w48_collection_id_idx ON pgstac.items_search_p2016w48 USING btree (collection_id);

CREATE INDEX items_search_p2016w48_datetime_id_idx ON pgstac.items_search_p2016w48 USING btree (datetime, id);

CREATE INDEX items_search_p2016w48_geometry_idx ON pgstac.items_search_p2016w48 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w48_pkey ON pgstac.items_search_p2016w48 USING btree (id);

CREATE INDEX items_search_p2016w48_properties_idx ON pgstac.items_search_p2016w48 USING gin (properties);

CREATE INDEX items_search_p2016w49_collection_id_idx ON pgstac.items_search_p2016w49 USING btree (collection_id);

CREATE INDEX items_search_p2016w49_datetime_id_idx ON pgstac.items_search_p2016w49 USING btree (datetime, id);

CREATE INDEX items_search_p2016w49_geometry_idx ON pgstac.items_search_p2016w49 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w49_pkey ON pgstac.items_search_p2016w49 USING btree (id);

CREATE INDEX items_search_p2016w49_properties_idx ON pgstac.items_search_p2016w49 USING gin (properties);

CREATE INDEX items_search_p2016w50_collection_id_idx ON pgstac.items_search_p2016w50 USING btree (collection_id);

CREATE INDEX items_search_p2016w50_datetime_id_idx ON pgstac.items_search_p2016w50 USING btree (datetime, id);

CREATE INDEX items_search_p2016w50_geometry_idx ON pgstac.items_search_p2016w50 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w50_pkey ON pgstac.items_search_p2016w50 USING btree (id);

CREATE INDEX items_search_p2016w50_properties_idx ON pgstac.items_search_p2016w50 USING gin (properties);

CREATE INDEX items_search_p2016w51_collection_id_idx ON pgstac.items_search_p2016w51 USING btree (collection_id);

CREATE INDEX items_search_p2016w51_datetime_id_idx ON pgstac.items_search_p2016w51 USING btree (datetime, id);

CREATE INDEX items_search_p2016w51_geometry_idx ON pgstac.items_search_p2016w51 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w51_pkey ON pgstac.items_search_p2016w51 USING btree (id);

CREATE INDEX items_search_p2016w51_properties_idx ON pgstac.items_search_p2016w51 USING gin (properties);

CREATE INDEX items_search_p2016w52_collection_id_idx ON pgstac.items_search_p2016w52 USING btree (collection_id);

CREATE INDEX items_search_p2016w52_datetime_id_idx ON pgstac.items_search_p2016w52 USING btree (datetime, id);

CREATE INDEX items_search_p2016w52_geometry_idx ON pgstac.items_search_p2016w52 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2016w52_pkey ON pgstac.items_search_p2016w52 USING btree (id);

CREATE INDEX items_search_p2016w52_properties_idx ON pgstac.items_search_p2016w52 USING gin (properties);

CREATE INDEX items_search_p2017w01_collection_id_idx ON pgstac.items_search_p2017w01 USING btree (collection_id);

CREATE INDEX items_search_p2017w01_datetime_id_idx ON pgstac.items_search_p2017w01 USING btree (datetime, id);

CREATE INDEX items_search_p2017w01_geometry_idx ON pgstac.items_search_p2017w01 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w01_pkey ON pgstac.items_search_p2017w01 USING btree (id);

CREATE INDEX items_search_p2017w01_properties_idx ON pgstac.items_search_p2017w01 USING gin (properties);

CREATE INDEX items_search_p2017w02_collection_id_idx ON pgstac.items_search_p2017w02 USING btree (collection_id);

CREATE INDEX items_search_p2017w02_datetime_id_idx ON pgstac.items_search_p2017w02 USING btree (datetime, id);

CREATE INDEX items_search_p2017w02_geometry_idx ON pgstac.items_search_p2017w02 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w02_pkey ON pgstac.items_search_p2017w02 USING btree (id);

CREATE INDEX items_search_p2017w02_properties_idx ON pgstac.items_search_p2017w02 USING gin (properties);

CREATE INDEX items_search_p2017w03_collection_id_idx ON pgstac.items_search_p2017w03 USING btree (collection_id);

CREATE INDEX items_search_p2017w03_datetime_id_idx ON pgstac.items_search_p2017w03 USING btree (datetime, id);

CREATE INDEX items_search_p2017w03_geometry_idx ON pgstac.items_search_p2017w03 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w03_pkey ON pgstac.items_search_p2017w03 USING btree (id);

CREATE INDEX items_search_p2017w03_properties_idx ON pgstac.items_search_p2017w03 USING gin (properties);

CREATE INDEX items_search_p2017w04_collection_id_idx ON pgstac.items_search_p2017w04 USING btree (collection_id);

CREATE INDEX items_search_p2017w04_datetime_id_idx ON pgstac.items_search_p2017w04 USING btree (datetime, id);

CREATE INDEX items_search_p2017w04_geometry_idx ON pgstac.items_search_p2017w04 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w04_pkey ON pgstac.items_search_p2017w04 USING btree (id);

CREATE INDEX items_search_p2017w04_properties_idx ON pgstac.items_search_p2017w04 USING gin (properties);

CREATE INDEX items_search_p2017w05_collection_id_idx ON pgstac.items_search_p2017w05 USING btree (collection_id);

CREATE INDEX items_search_p2017w05_datetime_id_idx ON pgstac.items_search_p2017w05 USING btree (datetime, id);

CREATE INDEX items_search_p2017w05_geometry_idx ON pgstac.items_search_p2017w05 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w05_pkey ON pgstac.items_search_p2017w05 USING btree (id);

CREATE INDEX items_search_p2017w05_properties_idx ON pgstac.items_search_p2017w05 USING gin (properties);

CREATE INDEX items_search_p2017w06_collection_id_idx ON pgstac.items_search_p2017w06 USING btree (collection_id);

CREATE INDEX items_search_p2017w06_datetime_id_idx ON pgstac.items_search_p2017w06 USING btree (datetime, id);

CREATE INDEX items_search_p2017w06_geometry_idx ON pgstac.items_search_p2017w06 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w06_pkey ON pgstac.items_search_p2017w06 USING btree (id);

CREATE INDEX items_search_p2017w06_properties_idx ON pgstac.items_search_p2017w06 USING gin (properties);

CREATE INDEX items_search_p2017w07_collection_id_idx ON pgstac.items_search_p2017w07 USING btree (collection_id);

CREATE INDEX items_search_p2017w07_datetime_id_idx ON pgstac.items_search_p2017w07 USING btree (datetime, id);

CREATE INDEX items_search_p2017w07_geometry_idx ON pgstac.items_search_p2017w07 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w07_pkey ON pgstac.items_search_p2017w07 USING btree (id);

CREATE INDEX items_search_p2017w07_properties_idx ON pgstac.items_search_p2017w07 USING gin (properties);

CREATE INDEX items_search_p2017w08_collection_id_idx ON pgstac.items_search_p2017w08 USING btree (collection_id);

CREATE INDEX items_search_p2017w08_datetime_id_idx ON pgstac.items_search_p2017w08 USING btree (datetime, id);

CREATE INDEX items_search_p2017w08_geometry_idx ON pgstac.items_search_p2017w08 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w08_pkey ON pgstac.items_search_p2017w08 USING btree (id);

CREATE INDEX items_search_p2017w08_properties_idx ON pgstac.items_search_p2017w08 USING gin (properties);

CREATE INDEX items_search_p2017w09_collection_id_idx ON pgstac.items_search_p2017w09 USING btree (collection_id);

CREATE INDEX items_search_p2017w09_datetime_id_idx ON pgstac.items_search_p2017w09 USING btree (datetime, id);

CREATE INDEX items_search_p2017w09_geometry_idx ON pgstac.items_search_p2017w09 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w09_pkey ON pgstac.items_search_p2017w09 USING btree (id);

CREATE INDEX items_search_p2017w09_properties_idx ON pgstac.items_search_p2017w09 USING gin (properties);

CREATE INDEX items_search_p2017w10_collection_id_idx ON pgstac.items_search_p2017w10 USING btree (collection_id);

CREATE INDEX items_search_p2017w10_datetime_id_idx ON pgstac.items_search_p2017w10 USING btree (datetime, id);

CREATE INDEX items_search_p2017w10_geometry_idx ON pgstac.items_search_p2017w10 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w10_pkey ON pgstac.items_search_p2017w10 USING btree (id);

CREATE INDEX items_search_p2017w10_properties_idx ON pgstac.items_search_p2017w10 USING gin (properties);

CREATE INDEX items_search_p2017w11_collection_id_idx ON pgstac.items_search_p2017w11 USING btree (collection_id);

CREATE INDEX items_search_p2017w11_datetime_id_idx ON pgstac.items_search_p2017w11 USING btree (datetime, id);

CREATE INDEX items_search_p2017w11_geometry_idx ON pgstac.items_search_p2017w11 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w11_pkey ON pgstac.items_search_p2017w11 USING btree (id);

CREATE INDEX items_search_p2017w11_properties_idx ON pgstac.items_search_p2017w11 USING gin (properties);

CREATE INDEX items_search_p2017w12_collection_id_idx ON pgstac.items_search_p2017w12 USING btree (collection_id);

CREATE INDEX items_search_p2017w12_datetime_id_idx ON pgstac.items_search_p2017w12 USING btree (datetime, id);

CREATE INDEX items_search_p2017w12_geometry_idx ON pgstac.items_search_p2017w12 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w12_pkey ON pgstac.items_search_p2017w12 USING btree (id);

CREATE INDEX items_search_p2017w12_properties_idx ON pgstac.items_search_p2017w12 USING gin (properties);

CREATE INDEX items_search_p2017w13_collection_id_idx ON pgstac.items_search_p2017w13 USING btree (collection_id);

CREATE INDEX items_search_p2017w13_datetime_id_idx ON pgstac.items_search_p2017w13 USING btree (datetime, id);

CREATE INDEX items_search_p2017w13_geometry_idx ON pgstac.items_search_p2017w13 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w13_pkey ON pgstac.items_search_p2017w13 USING btree (id);

CREATE INDEX items_search_p2017w13_properties_idx ON pgstac.items_search_p2017w13 USING gin (properties);

CREATE INDEX items_search_p2017w14_collection_id_idx ON pgstac.items_search_p2017w14 USING btree (collection_id);

CREATE INDEX items_search_p2017w14_datetime_id_idx ON pgstac.items_search_p2017w14 USING btree (datetime, id);

CREATE INDEX items_search_p2017w14_geometry_idx ON pgstac.items_search_p2017w14 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w14_pkey ON pgstac.items_search_p2017w14 USING btree (id);

CREATE INDEX items_search_p2017w14_properties_idx ON pgstac.items_search_p2017w14 USING gin (properties);

CREATE INDEX items_search_p2017w15_collection_id_idx ON pgstac.items_search_p2017w15 USING btree (collection_id);

CREATE INDEX items_search_p2017w15_datetime_id_idx ON pgstac.items_search_p2017w15 USING btree (datetime, id);

CREATE INDEX items_search_p2017w15_geometry_idx ON pgstac.items_search_p2017w15 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w15_pkey ON pgstac.items_search_p2017w15 USING btree (id);

CREATE INDEX items_search_p2017w15_properties_idx ON pgstac.items_search_p2017w15 USING gin (properties);

CREATE INDEX items_search_p2017w16_collection_id_idx ON pgstac.items_search_p2017w16 USING btree (collection_id);

CREATE INDEX items_search_p2017w16_datetime_id_idx ON pgstac.items_search_p2017w16 USING btree (datetime, id);

CREATE INDEX items_search_p2017w16_geometry_idx ON pgstac.items_search_p2017w16 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w16_pkey ON pgstac.items_search_p2017w16 USING btree (id);

CREATE INDEX items_search_p2017w16_properties_idx ON pgstac.items_search_p2017w16 USING gin (properties);

CREATE INDEX items_search_p2017w17_collection_id_idx ON pgstac.items_search_p2017w17 USING btree (collection_id);

CREATE INDEX items_search_p2017w17_datetime_id_idx ON pgstac.items_search_p2017w17 USING btree (datetime, id);

CREATE INDEX items_search_p2017w17_geometry_idx ON pgstac.items_search_p2017w17 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w17_pkey ON pgstac.items_search_p2017w17 USING btree (id);

CREATE INDEX items_search_p2017w17_properties_idx ON pgstac.items_search_p2017w17 USING gin (properties);

CREATE INDEX items_search_p2017w18_collection_id_idx ON pgstac.items_search_p2017w18 USING btree (collection_id);

CREATE INDEX items_search_p2017w18_datetime_id_idx ON pgstac.items_search_p2017w18 USING btree (datetime, id);

CREATE INDEX items_search_p2017w18_geometry_idx ON pgstac.items_search_p2017w18 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w18_pkey ON pgstac.items_search_p2017w18 USING btree (id);

CREATE INDEX items_search_p2017w18_properties_idx ON pgstac.items_search_p2017w18 USING gin (properties);

CREATE INDEX items_search_p2017w19_collection_id_idx ON pgstac.items_search_p2017w19 USING btree (collection_id);

CREATE INDEX items_search_p2017w19_datetime_id_idx ON pgstac.items_search_p2017w19 USING btree (datetime, id);

CREATE INDEX items_search_p2017w19_geometry_idx ON pgstac.items_search_p2017w19 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w19_pkey ON pgstac.items_search_p2017w19 USING btree (id);

CREATE INDEX items_search_p2017w19_properties_idx ON pgstac.items_search_p2017w19 USING gin (properties);

CREATE INDEX items_search_p2017w20_collection_id_idx ON pgstac.items_search_p2017w20 USING btree (collection_id);

CREATE INDEX items_search_p2017w20_datetime_id_idx ON pgstac.items_search_p2017w20 USING btree (datetime, id);

CREATE INDEX items_search_p2017w20_geometry_idx ON pgstac.items_search_p2017w20 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w20_pkey ON pgstac.items_search_p2017w20 USING btree (id);

CREATE INDEX items_search_p2017w20_properties_idx ON pgstac.items_search_p2017w20 USING gin (properties);

CREATE INDEX items_search_p2017w21_collection_id_idx ON pgstac.items_search_p2017w21 USING btree (collection_id);

CREATE INDEX items_search_p2017w21_datetime_id_idx ON pgstac.items_search_p2017w21 USING btree (datetime, id);

CREATE INDEX items_search_p2017w21_geometry_idx ON pgstac.items_search_p2017w21 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w21_pkey ON pgstac.items_search_p2017w21 USING btree (id);

CREATE INDEX items_search_p2017w21_properties_idx ON pgstac.items_search_p2017w21 USING gin (properties);

CREATE INDEX items_search_p2017w22_collection_id_idx ON pgstac.items_search_p2017w22 USING btree (collection_id);

CREATE INDEX items_search_p2017w22_datetime_id_idx ON pgstac.items_search_p2017w22 USING btree (datetime, id);

CREATE INDEX items_search_p2017w22_geometry_idx ON pgstac.items_search_p2017w22 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w22_pkey ON pgstac.items_search_p2017w22 USING btree (id);

CREATE INDEX items_search_p2017w22_properties_idx ON pgstac.items_search_p2017w22 USING gin (properties);

CREATE INDEX items_search_p2017w23_collection_id_idx ON pgstac.items_search_p2017w23 USING btree (collection_id);

CREATE INDEX items_search_p2017w23_datetime_id_idx ON pgstac.items_search_p2017w23 USING btree (datetime, id);

CREATE INDEX items_search_p2017w23_geometry_idx ON pgstac.items_search_p2017w23 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w23_pkey ON pgstac.items_search_p2017w23 USING btree (id);

CREATE INDEX items_search_p2017w23_properties_idx ON pgstac.items_search_p2017w23 USING gin (properties);

CREATE INDEX items_search_p2017w24_collection_id_idx ON pgstac.items_search_p2017w24 USING btree (collection_id);

CREATE INDEX items_search_p2017w24_datetime_id_idx ON pgstac.items_search_p2017w24 USING btree (datetime, id);

CREATE INDEX items_search_p2017w24_geometry_idx ON pgstac.items_search_p2017w24 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w24_pkey ON pgstac.items_search_p2017w24 USING btree (id);

CREATE INDEX items_search_p2017w24_properties_idx ON pgstac.items_search_p2017w24 USING gin (properties);

CREATE INDEX items_search_p2017w25_collection_id_idx ON pgstac.items_search_p2017w25 USING btree (collection_id);

CREATE INDEX items_search_p2017w25_datetime_id_idx ON pgstac.items_search_p2017w25 USING btree (datetime, id);

CREATE INDEX items_search_p2017w25_geometry_idx ON pgstac.items_search_p2017w25 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w25_pkey ON pgstac.items_search_p2017w25 USING btree (id);

CREATE INDEX items_search_p2017w25_properties_idx ON pgstac.items_search_p2017w25 USING gin (properties);

CREATE INDEX items_search_p2017w26_collection_id_idx ON pgstac.items_search_p2017w26 USING btree (collection_id);

CREATE INDEX items_search_p2017w26_datetime_id_idx ON pgstac.items_search_p2017w26 USING btree (datetime, id);

CREATE INDEX items_search_p2017w26_geometry_idx ON pgstac.items_search_p2017w26 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w26_pkey ON pgstac.items_search_p2017w26 USING btree (id);

CREATE INDEX items_search_p2017w26_properties_idx ON pgstac.items_search_p2017w26 USING gin (properties);

CREATE INDEX items_search_p2017w27_collection_id_idx ON pgstac.items_search_p2017w27 USING btree (collection_id);

CREATE INDEX items_search_p2017w27_datetime_id_idx ON pgstac.items_search_p2017w27 USING btree (datetime, id);

CREATE INDEX items_search_p2017w27_geometry_idx ON pgstac.items_search_p2017w27 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w27_pkey ON pgstac.items_search_p2017w27 USING btree (id);

CREATE INDEX items_search_p2017w27_properties_idx ON pgstac.items_search_p2017w27 USING gin (properties);

CREATE INDEX items_search_p2017w28_collection_id_idx ON pgstac.items_search_p2017w28 USING btree (collection_id);

CREATE INDEX items_search_p2017w28_datetime_id_idx ON pgstac.items_search_p2017w28 USING btree (datetime, id);

CREATE INDEX items_search_p2017w28_geometry_idx ON pgstac.items_search_p2017w28 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w28_pkey ON pgstac.items_search_p2017w28 USING btree (id);

CREATE INDEX items_search_p2017w28_properties_idx ON pgstac.items_search_p2017w28 USING gin (properties);

CREATE INDEX items_search_p2017w29_collection_id_idx ON pgstac.items_search_p2017w29 USING btree (collection_id);

CREATE INDEX items_search_p2017w29_datetime_id_idx ON pgstac.items_search_p2017w29 USING btree (datetime, id);

CREATE INDEX items_search_p2017w29_geometry_idx ON pgstac.items_search_p2017w29 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w29_pkey ON pgstac.items_search_p2017w29 USING btree (id);

CREATE INDEX items_search_p2017w29_properties_idx ON pgstac.items_search_p2017w29 USING gin (properties);

CREATE INDEX items_search_p2017w30_collection_id_idx ON pgstac.items_search_p2017w30 USING btree (collection_id);

CREATE INDEX items_search_p2017w30_datetime_id_idx ON pgstac.items_search_p2017w30 USING btree (datetime, id);

CREATE INDEX items_search_p2017w30_geometry_idx ON pgstac.items_search_p2017w30 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w30_pkey ON pgstac.items_search_p2017w30 USING btree (id);

CREATE INDEX items_search_p2017w30_properties_idx ON pgstac.items_search_p2017w30 USING gin (properties);

CREATE INDEX items_search_p2017w31_collection_id_idx ON pgstac.items_search_p2017w31 USING btree (collection_id);

CREATE INDEX items_search_p2017w31_datetime_id_idx ON pgstac.items_search_p2017w31 USING btree (datetime, id);

CREATE INDEX items_search_p2017w31_geometry_idx ON pgstac.items_search_p2017w31 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w31_pkey ON pgstac.items_search_p2017w31 USING btree (id);

CREATE INDEX items_search_p2017w31_properties_idx ON pgstac.items_search_p2017w31 USING gin (properties);

CREATE INDEX items_search_p2017w32_collection_id_idx ON pgstac.items_search_p2017w32 USING btree (collection_id);

CREATE INDEX items_search_p2017w32_datetime_id_idx ON pgstac.items_search_p2017w32 USING btree (datetime, id);

CREATE INDEX items_search_p2017w32_geometry_idx ON pgstac.items_search_p2017w32 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w32_pkey ON pgstac.items_search_p2017w32 USING btree (id);

CREATE INDEX items_search_p2017w32_properties_idx ON pgstac.items_search_p2017w32 USING gin (properties);

CREATE INDEX items_search_p2017w33_collection_id_idx ON pgstac.items_search_p2017w33 USING btree (collection_id);

CREATE INDEX items_search_p2017w33_datetime_id_idx ON pgstac.items_search_p2017w33 USING btree (datetime, id);

CREATE INDEX items_search_p2017w33_geometry_idx ON pgstac.items_search_p2017w33 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w33_pkey ON pgstac.items_search_p2017w33 USING btree (id);

CREATE INDEX items_search_p2017w33_properties_idx ON pgstac.items_search_p2017w33 USING gin (properties);

CREATE INDEX items_search_p2017w34_collection_id_idx ON pgstac.items_search_p2017w34 USING btree (collection_id);

CREATE INDEX items_search_p2017w34_datetime_id_idx ON pgstac.items_search_p2017w34 USING btree (datetime, id);

CREATE INDEX items_search_p2017w34_geometry_idx ON pgstac.items_search_p2017w34 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w34_pkey ON pgstac.items_search_p2017w34 USING btree (id);

CREATE INDEX items_search_p2017w34_properties_idx ON pgstac.items_search_p2017w34 USING gin (properties);

CREATE INDEX items_search_p2017w35_collection_id_idx ON pgstac.items_search_p2017w35 USING btree (collection_id);

CREATE INDEX items_search_p2017w35_datetime_id_idx ON pgstac.items_search_p2017w35 USING btree (datetime, id);

CREATE INDEX items_search_p2017w35_geometry_idx ON pgstac.items_search_p2017w35 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w35_pkey ON pgstac.items_search_p2017w35 USING btree (id);

CREATE INDEX items_search_p2017w35_properties_idx ON pgstac.items_search_p2017w35 USING gin (properties);

CREATE INDEX items_search_p2017w36_collection_id_idx ON pgstac.items_search_p2017w36 USING btree (collection_id);

CREATE INDEX items_search_p2017w36_datetime_id_idx ON pgstac.items_search_p2017w36 USING btree (datetime, id);

CREATE INDEX items_search_p2017w36_geometry_idx ON pgstac.items_search_p2017w36 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w36_pkey ON pgstac.items_search_p2017w36 USING btree (id);

CREATE INDEX items_search_p2017w36_properties_idx ON pgstac.items_search_p2017w36 USING gin (properties);

CREATE INDEX items_search_p2017w37_collection_id_idx ON pgstac.items_search_p2017w37 USING btree (collection_id);

CREATE INDEX items_search_p2017w37_datetime_id_idx ON pgstac.items_search_p2017w37 USING btree (datetime, id);

CREATE INDEX items_search_p2017w37_geometry_idx ON pgstac.items_search_p2017w37 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w37_pkey ON pgstac.items_search_p2017w37 USING btree (id);

CREATE INDEX items_search_p2017w37_properties_idx ON pgstac.items_search_p2017w37 USING gin (properties);

CREATE INDEX items_search_p2017w38_collection_id_idx ON pgstac.items_search_p2017w38 USING btree (collection_id);

CREATE INDEX items_search_p2017w38_datetime_id_idx ON pgstac.items_search_p2017w38 USING btree (datetime, id);

CREATE INDEX items_search_p2017w38_geometry_idx ON pgstac.items_search_p2017w38 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w38_pkey ON pgstac.items_search_p2017w38 USING btree (id);

CREATE INDEX items_search_p2017w38_properties_idx ON pgstac.items_search_p2017w38 USING gin (properties);

CREATE INDEX items_search_p2017w39_collection_id_idx ON pgstac.items_search_p2017w39 USING btree (collection_id);

CREATE INDEX items_search_p2017w39_datetime_id_idx ON pgstac.items_search_p2017w39 USING btree (datetime, id);

CREATE INDEX items_search_p2017w39_geometry_idx ON pgstac.items_search_p2017w39 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w39_pkey ON pgstac.items_search_p2017w39 USING btree (id);

CREATE INDEX items_search_p2017w39_properties_idx ON pgstac.items_search_p2017w39 USING gin (properties);

CREATE INDEX items_search_p2017w40_collection_id_idx ON pgstac.items_search_p2017w40 USING btree (collection_id);

CREATE INDEX items_search_p2017w40_datetime_id_idx ON pgstac.items_search_p2017w40 USING btree (datetime, id);

CREATE INDEX items_search_p2017w40_geometry_idx ON pgstac.items_search_p2017w40 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w40_pkey ON pgstac.items_search_p2017w40 USING btree (id);

CREATE INDEX items_search_p2017w40_properties_idx ON pgstac.items_search_p2017w40 USING gin (properties);

CREATE INDEX items_search_p2017w41_collection_id_idx ON pgstac.items_search_p2017w41 USING btree (collection_id);

CREATE INDEX items_search_p2017w41_datetime_id_idx ON pgstac.items_search_p2017w41 USING btree (datetime, id);

CREATE INDEX items_search_p2017w41_geometry_idx ON pgstac.items_search_p2017w41 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w41_pkey ON pgstac.items_search_p2017w41 USING btree (id);

CREATE INDEX items_search_p2017w41_properties_idx ON pgstac.items_search_p2017w41 USING gin (properties);

CREATE INDEX items_search_p2017w42_collection_id_idx ON pgstac.items_search_p2017w42 USING btree (collection_id);

CREATE INDEX items_search_p2017w42_datetime_id_idx ON pgstac.items_search_p2017w42 USING btree (datetime, id);

CREATE INDEX items_search_p2017w42_geometry_idx ON pgstac.items_search_p2017w42 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w42_pkey ON pgstac.items_search_p2017w42 USING btree (id);

CREATE INDEX items_search_p2017w42_properties_idx ON pgstac.items_search_p2017w42 USING gin (properties);

CREATE INDEX items_search_p2017w43_collection_id_idx ON pgstac.items_search_p2017w43 USING btree (collection_id);

CREATE INDEX items_search_p2017w43_datetime_id_idx ON pgstac.items_search_p2017w43 USING btree (datetime, id);

CREATE INDEX items_search_p2017w43_geometry_idx ON pgstac.items_search_p2017w43 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w43_pkey ON pgstac.items_search_p2017w43 USING btree (id);

CREATE INDEX items_search_p2017w43_properties_idx ON pgstac.items_search_p2017w43 USING gin (properties);

CREATE INDEX items_search_p2017w44_collection_id_idx ON pgstac.items_search_p2017w44 USING btree (collection_id);

CREATE INDEX items_search_p2017w44_datetime_id_idx ON pgstac.items_search_p2017w44 USING btree (datetime, id);

CREATE INDEX items_search_p2017w44_geometry_idx ON pgstac.items_search_p2017w44 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w44_pkey ON pgstac.items_search_p2017w44 USING btree (id);

CREATE INDEX items_search_p2017w44_properties_idx ON pgstac.items_search_p2017w44 USING gin (properties);

CREATE INDEX items_search_p2017w45_collection_id_idx ON pgstac.items_search_p2017w45 USING btree (collection_id);

CREATE INDEX items_search_p2017w45_datetime_id_idx ON pgstac.items_search_p2017w45 USING btree (datetime, id);

CREATE INDEX items_search_p2017w45_geometry_idx ON pgstac.items_search_p2017w45 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w45_pkey ON pgstac.items_search_p2017w45 USING btree (id);

CREATE INDEX items_search_p2017w45_properties_idx ON pgstac.items_search_p2017w45 USING gin (properties);

CREATE INDEX items_search_p2017w46_collection_id_idx ON pgstac.items_search_p2017w46 USING btree (collection_id);

CREATE INDEX items_search_p2017w46_datetime_id_idx ON pgstac.items_search_p2017w46 USING btree (datetime, id);

CREATE INDEX items_search_p2017w46_geometry_idx ON pgstac.items_search_p2017w46 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w46_pkey ON pgstac.items_search_p2017w46 USING btree (id);

CREATE INDEX items_search_p2017w46_properties_idx ON pgstac.items_search_p2017w46 USING gin (properties);

CREATE INDEX items_search_p2017w47_collection_id_idx ON pgstac.items_search_p2017w47 USING btree (collection_id);

CREATE INDEX items_search_p2017w47_datetime_id_idx ON pgstac.items_search_p2017w47 USING btree (datetime, id);

CREATE INDEX items_search_p2017w47_geometry_idx ON pgstac.items_search_p2017w47 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w47_pkey ON pgstac.items_search_p2017w47 USING btree (id);

CREATE INDEX items_search_p2017w47_properties_idx ON pgstac.items_search_p2017w47 USING gin (properties);

CREATE INDEX items_search_p2017w48_collection_id_idx ON pgstac.items_search_p2017w48 USING btree (collection_id);

CREATE INDEX items_search_p2017w48_datetime_id_idx ON pgstac.items_search_p2017w48 USING btree (datetime, id);

CREATE INDEX items_search_p2017w48_geometry_idx ON pgstac.items_search_p2017w48 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w48_pkey ON pgstac.items_search_p2017w48 USING btree (id);

CREATE INDEX items_search_p2017w48_properties_idx ON pgstac.items_search_p2017w48 USING gin (properties);

CREATE INDEX items_search_p2017w49_collection_id_idx ON pgstac.items_search_p2017w49 USING btree (collection_id);

CREATE INDEX items_search_p2017w49_datetime_id_idx ON pgstac.items_search_p2017w49 USING btree (datetime, id);

CREATE INDEX items_search_p2017w49_geometry_idx ON pgstac.items_search_p2017w49 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w49_pkey ON pgstac.items_search_p2017w49 USING btree (id);

CREATE INDEX items_search_p2017w49_properties_idx ON pgstac.items_search_p2017w49 USING gin (properties);

CREATE INDEX items_search_p2017w50_collection_id_idx ON pgstac.items_search_p2017w50 USING btree (collection_id);

CREATE INDEX items_search_p2017w50_datetime_id_idx ON pgstac.items_search_p2017w50 USING btree (datetime, id);

CREATE INDEX items_search_p2017w50_geometry_idx ON pgstac.items_search_p2017w50 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w50_pkey ON pgstac.items_search_p2017w50 USING btree (id);

CREATE INDEX items_search_p2017w50_properties_idx ON pgstac.items_search_p2017w50 USING gin (properties);

CREATE INDEX items_search_p2017w51_collection_id_idx ON pgstac.items_search_p2017w51 USING btree (collection_id);

CREATE INDEX items_search_p2017w51_datetime_id_idx ON pgstac.items_search_p2017w51 USING btree (datetime, id);

CREATE INDEX items_search_p2017w51_geometry_idx ON pgstac.items_search_p2017w51 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w51_pkey ON pgstac.items_search_p2017w51 USING btree (id);

CREATE INDEX items_search_p2017w51_properties_idx ON pgstac.items_search_p2017w51 USING gin (properties);

CREATE INDEX items_search_p2017w52_collection_id_idx ON pgstac.items_search_p2017w52 USING btree (collection_id);

CREATE INDEX items_search_p2017w52_datetime_id_idx ON pgstac.items_search_p2017w52 USING btree (datetime, id);

CREATE INDEX items_search_p2017w52_geometry_idx ON pgstac.items_search_p2017w52 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2017w52_pkey ON pgstac.items_search_p2017w52 USING btree (id);

CREATE INDEX items_search_p2017w52_properties_idx ON pgstac.items_search_p2017w52 USING gin (properties);

CREATE INDEX items_search_p2018w01_collection_id_idx ON pgstac.items_search_p2018w01 USING btree (collection_id);

CREATE INDEX items_search_p2018w01_datetime_id_idx ON pgstac.items_search_p2018w01 USING btree (datetime, id);

CREATE INDEX items_search_p2018w01_geometry_idx ON pgstac.items_search_p2018w01 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w01_pkey ON pgstac.items_search_p2018w01 USING btree (id);

CREATE INDEX items_search_p2018w01_properties_idx ON pgstac.items_search_p2018w01 USING gin (properties);

CREATE INDEX items_search_p2018w02_collection_id_idx ON pgstac.items_search_p2018w02 USING btree (collection_id);

CREATE INDEX items_search_p2018w02_datetime_id_idx ON pgstac.items_search_p2018w02 USING btree (datetime, id);

CREATE INDEX items_search_p2018w02_geometry_idx ON pgstac.items_search_p2018w02 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w02_pkey ON pgstac.items_search_p2018w02 USING btree (id);

CREATE INDEX items_search_p2018w02_properties_idx ON pgstac.items_search_p2018w02 USING gin (properties);

CREATE INDEX items_search_p2018w03_collection_id_idx ON pgstac.items_search_p2018w03 USING btree (collection_id);

CREATE INDEX items_search_p2018w03_datetime_id_idx ON pgstac.items_search_p2018w03 USING btree (datetime, id);

CREATE INDEX items_search_p2018w03_geometry_idx ON pgstac.items_search_p2018w03 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w03_pkey ON pgstac.items_search_p2018w03 USING btree (id);

CREATE INDEX items_search_p2018w03_properties_idx ON pgstac.items_search_p2018w03 USING gin (properties);

CREATE INDEX items_search_p2018w04_collection_id_idx ON pgstac.items_search_p2018w04 USING btree (collection_id);

CREATE INDEX items_search_p2018w04_datetime_id_idx ON pgstac.items_search_p2018w04 USING btree (datetime, id);

CREATE INDEX items_search_p2018w04_geometry_idx ON pgstac.items_search_p2018w04 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w04_pkey ON pgstac.items_search_p2018w04 USING btree (id);

CREATE INDEX items_search_p2018w04_properties_idx ON pgstac.items_search_p2018w04 USING gin (properties);

CREATE INDEX items_search_p2018w05_collection_id_idx ON pgstac.items_search_p2018w05 USING btree (collection_id);

CREATE INDEX items_search_p2018w05_datetime_id_idx ON pgstac.items_search_p2018w05 USING btree (datetime, id);

CREATE INDEX items_search_p2018w05_geometry_idx ON pgstac.items_search_p2018w05 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w05_pkey ON pgstac.items_search_p2018w05 USING btree (id);

CREATE INDEX items_search_p2018w05_properties_idx ON pgstac.items_search_p2018w05 USING gin (properties);

CREATE INDEX items_search_p2018w06_collection_id_idx ON pgstac.items_search_p2018w06 USING btree (collection_id);

CREATE INDEX items_search_p2018w06_datetime_id_idx ON pgstac.items_search_p2018w06 USING btree (datetime, id);

CREATE INDEX items_search_p2018w06_geometry_idx ON pgstac.items_search_p2018w06 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w06_pkey ON pgstac.items_search_p2018w06 USING btree (id);

CREATE INDEX items_search_p2018w06_properties_idx ON pgstac.items_search_p2018w06 USING gin (properties);

CREATE INDEX items_search_p2018w07_collection_id_idx ON pgstac.items_search_p2018w07 USING btree (collection_id);

CREATE INDEX items_search_p2018w07_datetime_id_idx ON pgstac.items_search_p2018w07 USING btree (datetime, id);

CREATE INDEX items_search_p2018w07_geometry_idx ON pgstac.items_search_p2018w07 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w07_pkey ON pgstac.items_search_p2018w07 USING btree (id);

CREATE INDEX items_search_p2018w07_properties_idx ON pgstac.items_search_p2018w07 USING gin (properties);

CREATE INDEX items_search_p2018w08_collection_id_idx ON pgstac.items_search_p2018w08 USING btree (collection_id);

CREATE INDEX items_search_p2018w08_datetime_id_idx ON pgstac.items_search_p2018w08 USING btree (datetime, id);

CREATE INDEX items_search_p2018w08_geometry_idx ON pgstac.items_search_p2018w08 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w08_pkey ON pgstac.items_search_p2018w08 USING btree (id);

CREATE INDEX items_search_p2018w08_properties_idx ON pgstac.items_search_p2018w08 USING gin (properties);

CREATE INDEX items_search_p2018w09_collection_id_idx ON pgstac.items_search_p2018w09 USING btree (collection_id);

CREATE INDEX items_search_p2018w09_datetime_id_idx ON pgstac.items_search_p2018w09 USING btree (datetime, id);

CREATE INDEX items_search_p2018w09_geometry_idx ON pgstac.items_search_p2018w09 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w09_pkey ON pgstac.items_search_p2018w09 USING btree (id);

CREATE INDEX items_search_p2018w09_properties_idx ON pgstac.items_search_p2018w09 USING gin (properties);

CREATE INDEX items_search_p2018w10_collection_id_idx ON pgstac.items_search_p2018w10 USING btree (collection_id);

CREATE INDEX items_search_p2018w10_datetime_id_idx ON pgstac.items_search_p2018w10 USING btree (datetime, id);

CREATE INDEX items_search_p2018w10_geometry_idx ON pgstac.items_search_p2018w10 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w10_pkey ON pgstac.items_search_p2018w10 USING btree (id);

CREATE INDEX items_search_p2018w10_properties_idx ON pgstac.items_search_p2018w10 USING gin (properties);

CREATE INDEX items_search_p2018w11_collection_id_idx ON pgstac.items_search_p2018w11 USING btree (collection_id);

CREATE INDEX items_search_p2018w11_datetime_id_idx ON pgstac.items_search_p2018w11 USING btree (datetime, id);

CREATE INDEX items_search_p2018w11_geometry_idx ON pgstac.items_search_p2018w11 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w11_pkey ON pgstac.items_search_p2018w11 USING btree (id);

CREATE INDEX items_search_p2018w11_properties_idx ON pgstac.items_search_p2018w11 USING gin (properties);

CREATE INDEX items_search_p2018w12_collection_id_idx ON pgstac.items_search_p2018w12 USING btree (collection_id);

CREATE INDEX items_search_p2018w12_datetime_id_idx ON pgstac.items_search_p2018w12 USING btree (datetime, id);

CREATE INDEX items_search_p2018w12_geometry_idx ON pgstac.items_search_p2018w12 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w12_pkey ON pgstac.items_search_p2018w12 USING btree (id);

CREATE INDEX items_search_p2018w12_properties_idx ON pgstac.items_search_p2018w12 USING gin (properties);

CREATE INDEX items_search_p2018w13_collection_id_idx ON pgstac.items_search_p2018w13 USING btree (collection_id);

CREATE INDEX items_search_p2018w13_datetime_id_idx ON pgstac.items_search_p2018w13 USING btree (datetime, id);

CREATE INDEX items_search_p2018w13_geometry_idx ON pgstac.items_search_p2018w13 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w13_pkey ON pgstac.items_search_p2018w13 USING btree (id);

CREATE INDEX items_search_p2018w13_properties_idx ON pgstac.items_search_p2018w13 USING gin (properties);

CREATE INDEX items_search_p2018w14_collection_id_idx ON pgstac.items_search_p2018w14 USING btree (collection_id);

CREATE INDEX items_search_p2018w14_datetime_id_idx ON pgstac.items_search_p2018w14 USING btree (datetime, id);

CREATE INDEX items_search_p2018w14_geometry_idx ON pgstac.items_search_p2018w14 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w14_pkey ON pgstac.items_search_p2018w14 USING btree (id);

CREATE INDEX items_search_p2018w14_properties_idx ON pgstac.items_search_p2018w14 USING gin (properties);

CREATE INDEX items_search_p2018w15_collection_id_idx ON pgstac.items_search_p2018w15 USING btree (collection_id);

CREATE INDEX items_search_p2018w15_datetime_id_idx ON pgstac.items_search_p2018w15 USING btree (datetime, id);

CREATE INDEX items_search_p2018w15_geometry_idx ON pgstac.items_search_p2018w15 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w15_pkey ON pgstac.items_search_p2018w15 USING btree (id);

CREATE INDEX items_search_p2018w15_properties_idx ON pgstac.items_search_p2018w15 USING gin (properties);

CREATE INDEX items_search_p2018w16_collection_id_idx ON pgstac.items_search_p2018w16 USING btree (collection_id);

CREATE INDEX items_search_p2018w16_datetime_id_idx ON pgstac.items_search_p2018w16 USING btree (datetime, id);

CREATE INDEX items_search_p2018w16_geometry_idx ON pgstac.items_search_p2018w16 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w16_pkey ON pgstac.items_search_p2018w16 USING btree (id);

CREATE INDEX items_search_p2018w16_properties_idx ON pgstac.items_search_p2018w16 USING gin (properties);

CREATE INDEX items_search_p2018w17_collection_id_idx ON pgstac.items_search_p2018w17 USING btree (collection_id);

CREATE INDEX items_search_p2018w17_datetime_id_idx ON pgstac.items_search_p2018w17 USING btree (datetime, id);

CREATE INDEX items_search_p2018w17_geometry_idx ON pgstac.items_search_p2018w17 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w17_pkey ON pgstac.items_search_p2018w17 USING btree (id);

CREATE INDEX items_search_p2018w17_properties_idx ON pgstac.items_search_p2018w17 USING gin (properties);

CREATE INDEX items_search_p2018w18_collection_id_idx ON pgstac.items_search_p2018w18 USING btree (collection_id);

CREATE INDEX items_search_p2018w18_datetime_id_idx ON pgstac.items_search_p2018w18 USING btree (datetime, id);

CREATE INDEX items_search_p2018w18_geometry_idx ON pgstac.items_search_p2018w18 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w18_pkey ON pgstac.items_search_p2018w18 USING btree (id);

CREATE INDEX items_search_p2018w18_properties_idx ON pgstac.items_search_p2018w18 USING gin (properties);

CREATE INDEX items_search_p2018w19_collection_id_idx ON pgstac.items_search_p2018w19 USING btree (collection_id);

CREATE INDEX items_search_p2018w19_datetime_id_idx ON pgstac.items_search_p2018w19 USING btree (datetime, id);

CREATE INDEX items_search_p2018w19_geometry_idx ON pgstac.items_search_p2018w19 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w19_pkey ON pgstac.items_search_p2018w19 USING btree (id);

CREATE INDEX items_search_p2018w19_properties_idx ON pgstac.items_search_p2018w19 USING gin (properties);

CREATE INDEX items_search_p2018w20_collection_id_idx ON pgstac.items_search_p2018w20 USING btree (collection_id);

CREATE INDEX items_search_p2018w20_datetime_id_idx ON pgstac.items_search_p2018w20 USING btree (datetime, id);

CREATE INDEX items_search_p2018w20_geometry_idx ON pgstac.items_search_p2018w20 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w20_pkey ON pgstac.items_search_p2018w20 USING btree (id);

CREATE INDEX items_search_p2018w20_properties_idx ON pgstac.items_search_p2018w20 USING gin (properties);

CREATE INDEX items_search_p2018w21_collection_id_idx ON pgstac.items_search_p2018w21 USING btree (collection_id);

CREATE INDEX items_search_p2018w21_datetime_id_idx ON pgstac.items_search_p2018w21 USING btree (datetime, id);

CREATE INDEX items_search_p2018w21_geometry_idx ON pgstac.items_search_p2018w21 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w21_pkey ON pgstac.items_search_p2018w21 USING btree (id);

CREATE INDEX items_search_p2018w21_properties_idx ON pgstac.items_search_p2018w21 USING gin (properties);

CREATE INDEX items_search_p2018w22_collection_id_idx ON pgstac.items_search_p2018w22 USING btree (collection_id);

CREATE INDEX items_search_p2018w22_datetime_id_idx ON pgstac.items_search_p2018w22 USING btree (datetime, id);

CREATE INDEX items_search_p2018w22_geometry_idx ON pgstac.items_search_p2018w22 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w22_pkey ON pgstac.items_search_p2018w22 USING btree (id);

CREATE INDEX items_search_p2018w22_properties_idx ON pgstac.items_search_p2018w22 USING gin (properties);

CREATE INDEX items_search_p2018w23_collection_id_idx ON pgstac.items_search_p2018w23 USING btree (collection_id);

CREATE INDEX items_search_p2018w23_datetime_id_idx ON pgstac.items_search_p2018w23 USING btree (datetime, id);

CREATE INDEX items_search_p2018w23_geometry_idx ON pgstac.items_search_p2018w23 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w23_pkey ON pgstac.items_search_p2018w23 USING btree (id);

CREATE INDEX items_search_p2018w23_properties_idx ON pgstac.items_search_p2018w23 USING gin (properties);

CREATE INDEX items_search_p2018w24_collection_id_idx ON pgstac.items_search_p2018w24 USING btree (collection_id);

CREATE INDEX items_search_p2018w24_datetime_id_idx ON pgstac.items_search_p2018w24 USING btree (datetime, id);

CREATE INDEX items_search_p2018w24_geometry_idx ON pgstac.items_search_p2018w24 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w24_pkey ON pgstac.items_search_p2018w24 USING btree (id);

CREATE INDEX items_search_p2018w24_properties_idx ON pgstac.items_search_p2018w24 USING gin (properties);

CREATE INDEX items_search_p2018w25_collection_id_idx ON pgstac.items_search_p2018w25 USING btree (collection_id);

CREATE INDEX items_search_p2018w25_datetime_id_idx ON pgstac.items_search_p2018w25 USING btree (datetime, id);

CREATE INDEX items_search_p2018w25_geometry_idx ON pgstac.items_search_p2018w25 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w25_pkey ON pgstac.items_search_p2018w25 USING btree (id);

CREATE INDEX items_search_p2018w25_properties_idx ON pgstac.items_search_p2018w25 USING gin (properties);

CREATE INDEX items_search_p2018w26_collection_id_idx ON pgstac.items_search_p2018w26 USING btree (collection_id);

CREATE INDEX items_search_p2018w26_datetime_id_idx ON pgstac.items_search_p2018w26 USING btree (datetime, id);

CREATE INDEX items_search_p2018w26_geometry_idx ON pgstac.items_search_p2018w26 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w26_pkey ON pgstac.items_search_p2018w26 USING btree (id);

CREATE INDEX items_search_p2018w26_properties_idx ON pgstac.items_search_p2018w26 USING gin (properties);

CREATE INDEX items_search_p2018w27_collection_id_idx ON pgstac.items_search_p2018w27 USING btree (collection_id);

CREATE INDEX items_search_p2018w27_datetime_id_idx ON pgstac.items_search_p2018w27 USING btree (datetime, id);

CREATE INDEX items_search_p2018w27_geometry_idx ON pgstac.items_search_p2018w27 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w27_pkey ON pgstac.items_search_p2018w27 USING btree (id);

CREATE INDEX items_search_p2018w27_properties_idx ON pgstac.items_search_p2018w27 USING gin (properties);

CREATE INDEX items_search_p2018w28_collection_id_idx ON pgstac.items_search_p2018w28 USING btree (collection_id);

CREATE INDEX items_search_p2018w28_datetime_id_idx ON pgstac.items_search_p2018w28 USING btree (datetime, id);

CREATE INDEX items_search_p2018w28_geometry_idx ON pgstac.items_search_p2018w28 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w28_pkey ON pgstac.items_search_p2018w28 USING btree (id);

CREATE INDEX items_search_p2018w28_properties_idx ON pgstac.items_search_p2018w28 USING gin (properties);

CREATE INDEX items_search_p2018w29_collection_id_idx ON pgstac.items_search_p2018w29 USING btree (collection_id);

CREATE INDEX items_search_p2018w29_datetime_id_idx ON pgstac.items_search_p2018w29 USING btree (datetime, id);

CREATE INDEX items_search_p2018w29_geometry_idx ON pgstac.items_search_p2018w29 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w29_pkey ON pgstac.items_search_p2018w29 USING btree (id);

CREATE INDEX items_search_p2018w29_properties_idx ON pgstac.items_search_p2018w29 USING gin (properties);

CREATE INDEX items_search_p2018w30_collection_id_idx ON pgstac.items_search_p2018w30 USING btree (collection_id);

CREATE INDEX items_search_p2018w30_datetime_id_idx ON pgstac.items_search_p2018w30 USING btree (datetime, id);

CREATE INDEX items_search_p2018w30_geometry_idx ON pgstac.items_search_p2018w30 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w30_pkey ON pgstac.items_search_p2018w30 USING btree (id);

CREATE INDEX items_search_p2018w30_properties_idx ON pgstac.items_search_p2018w30 USING gin (properties);

CREATE INDEX items_search_p2018w31_collection_id_idx ON pgstac.items_search_p2018w31 USING btree (collection_id);

CREATE INDEX items_search_p2018w31_datetime_id_idx ON pgstac.items_search_p2018w31 USING btree (datetime, id);

CREATE INDEX items_search_p2018w31_geometry_idx ON pgstac.items_search_p2018w31 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w31_pkey ON pgstac.items_search_p2018w31 USING btree (id);

CREATE INDEX items_search_p2018w31_properties_idx ON pgstac.items_search_p2018w31 USING gin (properties);

CREATE INDEX items_search_p2018w32_collection_id_idx ON pgstac.items_search_p2018w32 USING btree (collection_id);

CREATE INDEX items_search_p2018w32_datetime_id_idx ON pgstac.items_search_p2018w32 USING btree (datetime, id);

CREATE INDEX items_search_p2018w32_geometry_idx ON pgstac.items_search_p2018w32 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w32_pkey ON pgstac.items_search_p2018w32 USING btree (id);

CREATE INDEX items_search_p2018w32_properties_idx ON pgstac.items_search_p2018w32 USING gin (properties);

CREATE INDEX items_search_p2018w33_collection_id_idx ON pgstac.items_search_p2018w33 USING btree (collection_id);

CREATE INDEX items_search_p2018w33_datetime_id_idx ON pgstac.items_search_p2018w33 USING btree (datetime, id);

CREATE INDEX items_search_p2018w33_geometry_idx ON pgstac.items_search_p2018w33 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w33_pkey ON pgstac.items_search_p2018w33 USING btree (id);

CREATE INDEX items_search_p2018w33_properties_idx ON pgstac.items_search_p2018w33 USING gin (properties);

CREATE INDEX items_search_p2018w34_collection_id_idx ON pgstac.items_search_p2018w34 USING btree (collection_id);

CREATE INDEX items_search_p2018w34_datetime_id_idx ON pgstac.items_search_p2018w34 USING btree (datetime, id);

CREATE INDEX items_search_p2018w34_geometry_idx ON pgstac.items_search_p2018w34 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w34_pkey ON pgstac.items_search_p2018w34 USING btree (id);

CREATE INDEX items_search_p2018w34_properties_idx ON pgstac.items_search_p2018w34 USING gin (properties);

CREATE INDEX items_search_p2018w35_collection_id_idx ON pgstac.items_search_p2018w35 USING btree (collection_id);

CREATE INDEX items_search_p2018w35_datetime_id_idx ON pgstac.items_search_p2018w35 USING btree (datetime, id);

CREATE INDEX items_search_p2018w35_geometry_idx ON pgstac.items_search_p2018w35 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w35_pkey ON pgstac.items_search_p2018w35 USING btree (id);

CREATE INDEX items_search_p2018w35_properties_idx ON pgstac.items_search_p2018w35 USING gin (properties);

CREATE INDEX items_search_p2018w36_collection_id_idx ON pgstac.items_search_p2018w36 USING btree (collection_id);

CREATE INDEX items_search_p2018w36_datetime_id_idx ON pgstac.items_search_p2018w36 USING btree (datetime, id);

CREATE INDEX items_search_p2018w36_geometry_idx ON pgstac.items_search_p2018w36 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w36_pkey ON pgstac.items_search_p2018w36 USING btree (id);

CREATE INDEX items_search_p2018w36_properties_idx ON pgstac.items_search_p2018w36 USING gin (properties);

CREATE INDEX items_search_p2018w37_collection_id_idx ON pgstac.items_search_p2018w37 USING btree (collection_id);

CREATE INDEX items_search_p2018w37_datetime_id_idx ON pgstac.items_search_p2018w37 USING btree (datetime, id);

CREATE INDEX items_search_p2018w37_geometry_idx ON pgstac.items_search_p2018w37 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w37_pkey ON pgstac.items_search_p2018w37 USING btree (id);

CREATE INDEX items_search_p2018w37_properties_idx ON pgstac.items_search_p2018w37 USING gin (properties);

CREATE INDEX items_search_p2018w38_collection_id_idx ON pgstac.items_search_p2018w38 USING btree (collection_id);

CREATE INDEX items_search_p2018w38_datetime_id_idx ON pgstac.items_search_p2018w38 USING btree (datetime, id);

CREATE INDEX items_search_p2018w38_geometry_idx ON pgstac.items_search_p2018w38 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w38_pkey ON pgstac.items_search_p2018w38 USING btree (id);

CREATE INDEX items_search_p2018w38_properties_idx ON pgstac.items_search_p2018w38 USING gin (properties);

CREATE INDEX items_search_p2018w39_collection_id_idx ON pgstac.items_search_p2018w39 USING btree (collection_id);

CREATE INDEX items_search_p2018w39_datetime_id_idx ON pgstac.items_search_p2018w39 USING btree (datetime, id);

CREATE INDEX items_search_p2018w39_geometry_idx ON pgstac.items_search_p2018w39 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w39_pkey ON pgstac.items_search_p2018w39 USING btree (id);

CREATE INDEX items_search_p2018w39_properties_idx ON pgstac.items_search_p2018w39 USING gin (properties);

CREATE INDEX items_search_p2018w40_collection_id_idx ON pgstac.items_search_p2018w40 USING btree (collection_id);

CREATE INDEX items_search_p2018w40_datetime_id_idx ON pgstac.items_search_p2018w40 USING btree (datetime, id);

CREATE INDEX items_search_p2018w40_geometry_idx ON pgstac.items_search_p2018w40 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w40_pkey ON pgstac.items_search_p2018w40 USING btree (id);

CREATE INDEX items_search_p2018w40_properties_idx ON pgstac.items_search_p2018w40 USING gin (properties);

CREATE INDEX items_search_p2018w41_collection_id_idx ON pgstac.items_search_p2018w41 USING btree (collection_id);

CREATE INDEX items_search_p2018w41_datetime_id_idx ON pgstac.items_search_p2018w41 USING btree (datetime, id);

CREATE INDEX items_search_p2018w41_geometry_idx ON pgstac.items_search_p2018w41 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w41_pkey ON pgstac.items_search_p2018w41 USING btree (id);

CREATE INDEX items_search_p2018w41_properties_idx ON pgstac.items_search_p2018w41 USING gin (properties);

CREATE INDEX items_search_p2018w42_collection_id_idx ON pgstac.items_search_p2018w42 USING btree (collection_id);

CREATE INDEX items_search_p2018w42_datetime_id_idx ON pgstac.items_search_p2018w42 USING btree (datetime, id);

CREATE INDEX items_search_p2018w42_geometry_idx ON pgstac.items_search_p2018w42 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w42_pkey ON pgstac.items_search_p2018w42 USING btree (id);

CREATE INDEX items_search_p2018w42_properties_idx ON pgstac.items_search_p2018w42 USING gin (properties);

CREATE INDEX items_search_p2018w43_collection_id_idx ON pgstac.items_search_p2018w43 USING btree (collection_id);

CREATE INDEX items_search_p2018w43_datetime_id_idx ON pgstac.items_search_p2018w43 USING btree (datetime, id);

CREATE INDEX items_search_p2018w43_geometry_idx ON pgstac.items_search_p2018w43 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w43_pkey ON pgstac.items_search_p2018w43 USING btree (id);

CREATE INDEX items_search_p2018w43_properties_idx ON pgstac.items_search_p2018w43 USING gin (properties);

CREATE INDEX items_search_p2018w44_collection_id_idx ON pgstac.items_search_p2018w44 USING btree (collection_id);

CREATE INDEX items_search_p2018w44_datetime_id_idx ON pgstac.items_search_p2018w44 USING btree (datetime, id);

CREATE INDEX items_search_p2018w44_geometry_idx ON pgstac.items_search_p2018w44 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w44_pkey ON pgstac.items_search_p2018w44 USING btree (id);

CREATE INDEX items_search_p2018w44_properties_idx ON pgstac.items_search_p2018w44 USING gin (properties);

CREATE INDEX items_search_p2018w45_collection_id_idx ON pgstac.items_search_p2018w45 USING btree (collection_id);

CREATE INDEX items_search_p2018w45_datetime_id_idx ON pgstac.items_search_p2018w45 USING btree (datetime, id);

CREATE INDEX items_search_p2018w45_geometry_idx ON pgstac.items_search_p2018w45 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w45_pkey ON pgstac.items_search_p2018w45 USING btree (id);

CREATE INDEX items_search_p2018w45_properties_idx ON pgstac.items_search_p2018w45 USING gin (properties);

CREATE INDEX items_search_p2018w46_collection_id_idx ON pgstac.items_search_p2018w46 USING btree (collection_id);

CREATE INDEX items_search_p2018w46_datetime_id_idx ON pgstac.items_search_p2018w46 USING btree (datetime, id);

CREATE INDEX items_search_p2018w46_geometry_idx ON pgstac.items_search_p2018w46 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w46_pkey ON pgstac.items_search_p2018w46 USING btree (id);

CREATE INDEX items_search_p2018w46_properties_idx ON pgstac.items_search_p2018w46 USING gin (properties);

CREATE INDEX items_search_p2018w47_collection_id_idx ON pgstac.items_search_p2018w47 USING btree (collection_id);

CREATE INDEX items_search_p2018w47_datetime_id_idx ON pgstac.items_search_p2018w47 USING btree (datetime, id);

CREATE INDEX items_search_p2018w47_geometry_idx ON pgstac.items_search_p2018w47 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w47_pkey ON pgstac.items_search_p2018w47 USING btree (id);

CREATE INDEX items_search_p2018w47_properties_idx ON pgstac.items_search_p2018w47 USING gin (properties);

CREATE INDEX items_search_p2018w48_collection_id_idx ON pgstac.items_search_p2018w48 USING btree (collection_id);

CREATE INDEX items_search_p2018w48_datetime_id_idx ON pgstac.items_search_p2018w48 USING btree (datetime, id);

CREATE INDEX items_search_p2018w48_geometry_idx ON pgstac.items_search_p2018w48 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w48_pkey ON pgstac.items_search_p2018w48 USING btree (id);

CREATE INDEX items_search_p2018w48_properties_idx ON pgstac.items_search_p2018w48 USING gin (properties);

CREATE INDEX items_search_p2018w49_collection_id_idx ON pgstac.items_search_p2018w49 USING btree (collection_id);

CREATE INDEX items_search_p2018w49_datetime_id_idx ON pgstac.items_search_p2018w49 USING btree (datetime, id);

CREATE INDEX items_search_p2018w49_geometry_idx ON pgstac.items_search_p2018w49 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w49_pkey ON pgstac.items_search_p2018w49 USING btree (id);

CREATE INDEX items_search_p2018w49_properties_idx ON pgstac.items_search_p2018w49 USING gin (properties);

CREATE INDEX items_search_p2018w50_collection_id_idx ON pgstac.items_search_p2018w50 USING btree (collection_id);

CREATE INDEX items_search_p2018w50_datetime_id_idx ON pgstac.items_search_p2018w50 USING btree (datetime, id);

CREATE INDEX items_search_p2018w50_geometry_idx ON pgstac.items_search_p2018w50 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w50_pkey ON pgstac.items_search_p2018w50 USING btree (id);

CREATE INDEX items_search_p2018w50_properties_idx ON pgstac.items_search_p2018w50 USING gin (properties);

CREATE INDEX items_search_p2018w51_collection_id_idx ON pgstac.items_search_p2018w51 USING btree (collection_id);

CREATE INDEX items_search_p2018w51_datetime_id_idx ON pgstac.items_search_p2018w51 USING btree (datetime, id);

CREATE INDEX items_search_p2018w51_geometry_idx ON pgstac.items_search_p2018w51 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w51_pkey ON pgstac.items_search_p2018w51 USING btree (id);

CREATE INDEX items_search_p2018w51_properties_idx ON pgstac.items_search_p2018w51 USING gin (properties);

CREATE INDEX items_search_p2018w52_collection_id_idx ON pgstac.items_search_p2018w52 USING btree (collection_id);

CREATE INDEX items_search_p2018w52_datetime_id_idx ON pgstac.items_search_p2018w52 USING btree (datetime, id);

CREATE INDEX items_search_p2018w52_geometry_idx ON pgstac.items_search_p2018w52 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2018w52_pkey ON pgstac.items_search_p2018w52 USING btree (id);

CREATE INDEX items_search_p2018w52_properties_idx ON pgstac.items_search_p2018w52 USING gin (properties);

CREATE INDEX items_search_p2019w01_collection_id_idx ON pgstac.items_search_p2019w01 USING btree (collection_id);

CREATE INDEX items_search_p2019w01_datetime_id_idx ON pgstac.items_search_p2019w01 USING btree (datetime, id);

CREATE INDEX items_search_p2019w01_geometry_idx ON pgstac.items_search_p2019w01 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w01_pkey ON pgstac.items_search_p2019w01 USING btree (id);

CREATE INDEX items_search_p2019w01_properties_idx ON pgstac.items_search_p2019w01 USING gin (properties);

CREATE INDEX items_search_p2019w02_collection_id_idx ON pgstac.items_search_p2019w02 USING btree (collection_id);

CREATE INDEX items_search_p2019w02_datetime_id_idx ON pgstac.items_search_p2019w02 USING btree (datetime, id);

CREATE INDEX items_search_p2019w02_geometry_idx ON pgstac.items_search_p2019w02 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w02_pkey ON pgstac.items_search_p2019w02 USING btree (id);

CREATE INDEX items_search_p2019w02_properties_idx ON pgstac.items_search_p2019w02 USING gin (properties);

CREATE INDEX items_search_p2019w03_collection_id_idx ON pgstac.items_search_p2019w03 USING btree (collection_id);

CREATE INDEX items_search_p2019w03_datetime_id_idx ON pgstac.items_search_p2019w03 USING btree (datetime, id);

CREATE INDEX items_search_p2019w03_geometry_idx ON pgstac.items_search_p2019w03 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w03_pkey ON pgstac.items_search_p2019w03 USING btree (id);

CREATE INDEX items_search_p2019w03_properties_idx ON pgstac.items_search_p2019w03 USING gin (properties);

CREATE INDEX items_search_p2019w04_collection_id_idx ON pgstac.items_search_p2019w04 USING btree (collection_id);

CREATE INDEX items_search_p2019w04_datetime_id_idx ON pgstac.items_search_p2019w04 USING btree (datetime, id);

CREATE INDEX items_search_p2019w04_geometry_idx ON pgstac.items_search_p2019w04 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w04_pkey ON pgstac.items_search_p2019w04 USING btree (id);

CREATE INDEX items_search_p2019w04_properties_idx ON pgstac.items_search_p2019w04 USING gin (properties);

CREATE INDEX items_search_p2019w05_collection_id_idx ON pgstac.items_search_p2019w05 USING btree (collection_id);

CREATE INDEX items_search_p2019w05_datetime_id_idx ON pgstac.items_search_p2019w05 USING btree (datetime, id);

CREATE INDEX items_search_p2019w05_geometry_idx ON pgstac.items_search_p2019w05 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w05_pkey ON pgstac.items_search_p2019w05 USING btree (id);

CREATE INDEX items_search_p2019w05_properties_idx ON pgstac.items_search_p2019w05 USING gin (properties);

CREATE INDEX items_search_p2019w06_collection_id_idx ON pgstac.items_search_p2019w06 USING btree (collection_id);

CREATE INDEX items_search_p2019w06_datetime_id_idx ON pgstac.items_search_p2019w06 USING btree (datetime, id);

CREATE INDEX items_search_p2019w06_geometry_idx ON pgstac.items_search_p2019w06 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w06_pkey ON pgstac.items_search_p2019w06 USING btree (id);

CREATE INDEX items_search_p2019w06_properties_idx ON pgstac.items_search_p2019w06 USING gin (properties);

CREATE INDEX items_search_p2019w07_collection_id_idx ON pgstac.items_search_p2019w07 USING btree (collection_id);

CREATE INDEX items_search_p2019w07_datetime_id_idx ON pgstac.items_search_p2019w07 USING btree (datetime, id);

CREATE INDEX items_search_p2019w07_geometry_idx ON pgstac.items_search_p2019w07 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w07_pkey ON pgstac.items_search_p2019w07 USING btree (id);

CREATE INDEX items_search_p2019w07_properties_idx ON pgstac.items_search_p2019w07 USING gin (properties);

CREATE INDEX items_search_p2019w08_collection_id_idx ON pgstac.items_search_p2019w08 USING btree (collection_id);

CREATE INDEX items_search_p2019w08_datetime_id_idx ON pgstac.items_search_p2019w08 USING btree (datetime, id);

CREATE INDEX items_search_p2019w08_geometry_idx ON pgstac.items_search_p2019w08 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w08_pkey ON pgstac.items_search_p2019w08 USING btree (id);

CREATE INDEX items_search_p2019w08_properties_idx ON pgstac.items_search_p2019w08 USING gin (properties);

CREATE INDEX items_search_p2019w09_collection_id_idx ON pgstac.items_search_p2019w09 USING btree (collection_id);

CREATE INDEX items_search_p2019w09_datetime_id_idx ON pgstac.items_search_p2019w09 USING btree (datetime, id);

CREATE INDEX items_search_p2019w09_geometry_idx ON pgstac.items_search_p2019w09 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w09_pkey ON pgstac.items_search_p2019w09 USING btree (id);

CREATE INDEX items_search_p2019w09_properties_idx ON pgstac.items_search_p2019w09 USING gin (properties);

CREATE INDEX items_search_p2019w10_collection_id_idx ON pgstac.items_search_p2019w10 USING btree (collection_id);

CREATE INDEX items_search_p2019w10_datetime_id_idx ON pgstac.items_search_p2019w10 USING btree (datetime, id);

CREATE INDEX items_search_p2019w10_geometry_idx ON pgstac.items_search_p2019w10 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w10_pkey ON pgstac.items_search_p2019w10 USING btree (id);

CREATE INDEX items_search_p2019w10_properties_idx ON pgstac.items_search_p2019w10 USING gin (properties);

CREATE INDEX items_search_p2019w11_collection_id_idx ON pgstac.items_search_p2019w11 USING btree (collection_id);

CREATE INDEX items_search_p2019w11_datetime_id_idx ON pgstac.items_search_p2019w11 USING btree (datetime, id);

CREATE INDEX items_search_p2019w11_geometry_idx ON pgstac.items_search_p2019w11 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w11_pkey ON pgstac.items_search_p2019w11 USING btree (id);

CREATE INDEX items_search_p2019w11_properties_idx ON pgstac.items_search_p2019w11 USING gin (properties);

CREATE INDEX items_search_p2019w12_collection_id_idx ON pgstac.items_search_p2019w12 USING btree (collection_id);

CREATE INDEX items_search_p2019w12_datetime_id_idx ON pgstac.items_search_p2019w12 USING btree (datetime, id);

CREATE INDEX items_search_p2019w12_geometry_idx ON pgstac.items_search_p2019w12 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w12_pkey ON pgstac.items_search_p2019w12 USING btree (id);

CREATE INDEX items_search_p2019w12_properties_idx ON pgstac.items_search_p2019w12 USING gin (properties);

CREATE INDEX items_search_p2019w13_collection_id_idx ON pgstac.items_search_p2019w13 USING btree (collection_id);

CREATE INDEX items_search_p2019w13_datetime_id_idx ON pgstac.items_search_p2019w13 USING btree (datetime, id);

CREATE INDEX items_search_p2019w13_geometry_idx ON pgstac.items_search_p2019w13 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w13_pkey ON pgstac.items_search_p2019w13 USING btree (id);

CREATE INDEX items_search_p2019w13_properties_idx ON pgstac.items_search_p2019w13 USING gin (properties);

CREATE INDEX items_search_p2019w14_collection_id_idx ON pgstac.items_search_p2019w14 USING btree (collection_id);

CREATE INDEX items_search_p2019w14_datetime_id_idx ON pgstac.items_search_p2019w14 USING btree (datetime, id);

CREATE INDEX items_search_p2019w14_geometry_idx ON pgstac.items_search_p2019w14 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w14_pkey ON pgstac.items_search_p2019w14 USING btree (id);

CREATE INDEX items_search_p2019w14_properties_idx ON pgstac.items_search_p2019w14 USING gin (properties);

CREATE INDEX items_search_p2019w15_collection_id_idx ON pgstac.items_search_p2019w15 USING btree (collection_id);

CREATE INDEX items_search_p2019w15_datetime_id_idx ON pgstac.items_search_p2019w15 USING btree (datetime, id);

CREATE INDEX items_search_p2019w15_geometry_idx ON pgstac.items_search_p2019w15 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w15_pkey ON pgstac.items_search_p2019w15 USING btree (id);

CREATE INDEX items_search_p2019w15_properties_idx ON pgstac.items_search_p2019w15 USING gin (properties);

CREATE INDEX items_search_p2019w16_collection_id_idx ON pgstac.items_search_p2019w16 USING btree (collection_id);

CREATE INDEX items_search_p2019w16_datetime_id_idx ON pgstac.items_search_p2019w16 USING btree (datetime, id);

CREATE INDEX items_search_p2019w16_geometry_idx ON pgstac.items_search_p2019w16 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w16_pkey ON pgstac.items_search_p2019w16 USING btree (id);

CREATE INDEX items_search_p2019w16_properties_idx ON pgstac.items_search_p2019w16 USING gin (properties);

CREATE INDEX items_search_p2019w17_collection_id_idx ON pgstac.items_search_p2019w17 USING btree (collection_id);

CREATE INDEX items_search_p2019w17_datetime_id_idx ON pgstac.items_search_p2019w17 USING btree (datetime, id);

CREATE INDEX items_search_p2019w17_geometry_idx ON pgstac.items_search_p2019w17 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w17_pkey ON pgstac.items_search_p2019w17 USING btree (id);

CREATE INDEX items_search_p2019w17_properties_idx ON pgstac.items_search_p2019w17 USING gin (properties);

CREATE INDEX items_search_p2019w18_collection_id_idx ON pgstac.items_search_p2019w18 USING btree (collection_id);

CREATE INDEX items_search_p2019w18_datetime_id_idx ON pgstac.items_search_p2019w18 USING btree (datetime, id);

CREATE INDEX items_search_p2019w18_geometry_idx ON pgstac.items_search_p2019w18 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w18_pkey ON pgstac.items_search_p2019w18 USING btree (id);

CREATE INDEX items_search_p2019w18_properties_idx ON pgstac.items_search_p2019w18 USING gin (properties);

CREATE INDEX items_search_p2019w19_collection_id_idx ON pgstac.items_search_p2019w19 USING btree (collection_id);

CREATE INDEX items_search_p2019w19_datetime_id_idx ON pgstac.items_search_p2019w19 USING btree (datetime, id);

CREATE INDEX items_search_p2019w19_geometry_idx ON pgstac.items_search_p2019w19 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w19_pkey ON pgstac.items_search_p2019w19 USING btree (id);

CREATE INDEX items_search_p2019w19_properties_idx ON pgstac.items_search_p2019w19 USING gin (properties);

CREATE INDEX items_search_p2019w20_collection_id_idx ON pgstac.items_search_p2019w20 USING btree (collection_id);

CREATE INDEX items_search_p2019w20_datetime_id_idx ON pgstac.items_search_p2019w20 USING btree (datetime, id);

CREATE INDEX items_search_p2019w20_geometry_idx ON pgstac.items_search_p2019w20 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w20_pkey ON pgstac.items_search_p2019w20 USING btree (id);

CREATE INDEX items_search_p2019w20_properties_idx ON pgstac.items_search_p2019w20 USING gin (properties);

CREATE INDEX items_search_p2019w21_collection_id_idx ON pgstac.items_search_p2019w21 USING btree (collection_id);

CREATE INDEX items_search_p2019w21_datetime_id_idx ON pgstac.items_search_p2019w21 USING btree (datetime, id);

CREATE INDEX items_search_p2019w21_geometry_idx ON pgstac.items_search_p2019w21 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w21_pkey ON pgstac.items_search_p2019w21 USING btree (id);

CREATE INDEX items_search_p2019w21_properties_idx ON pgstac.items_search_p2019w21 USING gin (properties);

CREATE INDEX items_search_p2019w22_collection_id_idx ON pgstac.items_search_p2019w22 USING btree (collection_id);

CREATE INDEX items_search_p2019w22_datetime_id_idx ON pgstac.items_search_p2019w22 USING btree (datetime, id);

CREATE INDEX items_search_p2019w22_geometry_idx ON pgstac.items_search_p2019w22 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w22_pkey ON pgstac.items_search_p2019w22 USING btree (id);

CREATE INDEX items_search_p2019w22_properties_idx ON pgstac.items_search_p2019w22 USING gin (properties);

CREATE INDEX items_search_p2019w23_collection_id_idx ON pgstac.items_search_p2019w23 USING btree (collection_id);

CREATE INDEX items_search_p2019w23_datetime_id_idx ON pgstac.items_search_p2019w23 USING btree (datetime, id);

CREATE INDEX items_search_p2019w23_geometry_idx ON pgstac.items_search_p2019w23 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w23_pkey ON pgstac.items_search_p2019w23 USING btree (id);

CREATE INDEX items_search_p2019w23_properties_idx ON pgstac.items_search_p2019w23 USING gin (properties);

CREATE INDEX items_search_p2019w24_collection_id_idx ON pgstac.items_search_p2019w24 USING btree (collection_id);

CREATE INDEX items_search_p2019w24_datetime_id_idx ON pgstac.items_search_p2019w24 USING btree (datetime, id);

CREATE INDEX items_search_p2019w24_geometry_idx ON pgstac.items_search_p2019w24 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w24_pkey ON pgstac.items_search_p2019w24 USING btree (id);

CREATE INDEX items_search_p2019w24_properties_idx ON pgstac.items_search_p2019w24 USING gin (properties);

CREATE INDEX items_search_p2019w25_collection_id_idx ON pgstac.items_search_p2019w25 USING btree (collection_id);

CREATE INDEX items_search_p2019w25_datetime_id_idx ON pgstac.items_search_p2019w25 USING btree (datetime, id);

CREATE INDEX items_search_p2019w25_geometry_idx ON pgstac.items_search_p2019w25 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w25_pkey ON pgstac.items_search_p2019w25 USING btree (id);

CREATE INDEX items_search_p2019w25_properties_idx ON pgstac.items_search_p2019w25 USING gin (properties);

CREATE INDEX items_search_p2019w26_collection_id_idx ON pgstac.items_search_p2019w26 USING btree (collection_id);

CREATE INDEX items_search_p2019w26_datetime_id_idx ON pgstac.items_search_p2019w26 USING btree (datetime, id);

CREATE INDEX items_search_p2019w26_geometry_idx ON pgstac.items_search_p2019w26 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w26_pkey ON pgstac.items_search_p2019w26 USING btree (id);

CREATE INDEX items_search_p2019w26_properties_idx ON pgstac.items_search_p2019w26 USING gin (properties);

CREATE INDEX items_search_p2019w27_collection_id_idx ON pgstac.items_search_p2019w27 USING btree (collection_id);

CREATE INDEX items_search_p2019w27_datetime_id_idx ON pgstac.items_search_p2019w27 USING btree (datetime, id);

CREATE INDEX items_search_p2019w27_geometry_idx ON pgstac.items_search_p2019w27 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w27_pkey ON pgstac.items_search_p2019w27 USING btree (id);

CREATE INDEX items_search_p2019w27_properties_idx ON pgstac.items_search_p2019w27 USING gin (properties);

CREATE INDEX items_search_p2019w28_collection_id_idx ON pgstac.items_search_p2019w28 USING btree (collection_id);

CREATE INDEX items_search_p2019w28_datetime_id_idx ON pgstac.items_search_p2019w28 USING btree (datetime, id);

CREATE INDEX items_search_p2019w28_geometry_idx ON pgstac.items_search_p2019w28 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w28_pkey ON pgstac.items_search_p2019w28 USING btree (id);

CREATE INDEX items_search_p2019w28_properties_idx ON pgstac.items_search_p2019w28 USING gin (properties);

CREATE INDEX items_search_p2019w29_collection_id_idx ON pgstac.items_search_p2019w29 USING btree (collection_id);

CREATE INDEX items_search_p2019w29_datetime_id_idx ON pgstac.items_search_p2019w29 USING btree (datetime, id);

CREATE INDEX items_search_p2019w29_geometry_idx ON pgstac.items_search_p2019w29 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w29_pkey ON pgstac.items_search_p2019w29 USING btree (id);

CREATE INDEX items_search_p2019w29_properties_idx ON pgstac.items_search_p2019w29 USING gin (properties);

CREATE INDEX items_search_p2019w30_collection_id_idx ON pgstac.items_search_p2019w30 USING btree (collection_id);

CREATE INDEX items_search_p2019w30_datetime_id_idx ON pgstac.items_search_p2019w30 USING btree (datetime, id);

CREATE INDEX items_search_p2019w30_geometry_idx ON pgstac.items_search_p2019w30 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w30_pkey ON pgstac.items_search_p2019w30 USING btree (id);

CREATE INDEX items_search_p2019w30_properties_idx ON pgstac.items_search_p2019w30 USING gin (properties);

CREATE INDEX items_search_p2019w31_collection_id_idx ON pgstac.items_search_p2019w31 USING btree (collection_id);

CREATE INDEX items_search_p2019w31_datetime_id_idx ON pgstac.items_search_p2019w31 USING btree (datetime, id);

CREATE INDEX items_search_p2019w31_geometry_idx ON pgstac.items_search_p2019w31 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w31_pkey ON pgstac.items_search_p2019w31 USING btree (id);

CREATE INDEX items_search_p2019w31_properties_idx ON pgstac.items_search_p2019w31 USING gin (properties);

CREATE INDEX items_search_p2019w32_collection_id_idx ON pgstac.items_search_p2019w32 USING btree (collection_id);

CREATE INDEX items_search_p2019w32_datetime_id_idx ON pgstac.items_search_p2019w32 USING btree (datetime, id);

CREATE INDEX items_search_p2019w32_geometry_idx ON pgstac.items_search_p2019w32 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w32_pkey ON pgstac.items_search_p2019w32 USING btree (id);

CREATE INDEX items_search_p2019w32_properties_idx ON pgstac.items_search_p2019w32 USING gin (properties);

CREATE INDEX items_search_p2019w33_collection_id_idx ON pgstac.items_search_p2019w33 USING btree (collection_id);

CREATE INDEX items_search_p2019w33_datetime_id_idx ON pgstac.items_search_p2019w33 USING btree (datetime, id);

CREATE INDEX items_search_p2019w33_geometry_idx ON pgstac.items_search_p2019w33 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w33_pkey ON pgstac.items_search_p2019w33 USING btree (id);

CREATE INDEX items_search_p2019w33_properties_idx ON pgstac.items_search_p2019w33 USING gin (properties);

CREATE INDEX items_search_p2019w34_collection_id_idx ON pgstac.items_search_p2019w34 USING btree (collection_id);

CREATE INDEX items_search_p2019w34_datetime_id_idx ON pgstac.items_search_p2019w34 USING btree (datetime, id);

CREATE INDEX items_search_p2019w34_geometry_idx ON pgstac.items_search_p2019w34 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w34_pkey ON pgstac.items_search_p2019w34 USING btree (id);

CREATE INDEX items_search_p2019w34_properties_idx ON pgstac.items_search_p2019w34 USING gin (properties);

CREATE INDEX items_search_p2019w35_collection_id_idx ON pgstac.items_search_p2019w35 USING btree (collection_id);

CREATE INDEX items_search_p2019w35_datetime_id_idx ON pgstac.items_search_p2019w35 USING btree (datetime, id);

CREATE INDEX items_search_p2019w35_geometry_idx ON pgstac.items_search_p2019w35 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w35_pkey ON pgstac.items_search_p2019w35 USING btree (id);

CREATE INDEX items_search_p2019w35_properties_idx ON pgstac.items_search_p2019w35 USING gin (properties);

CREATE INDEX items_search_p2019w36_collection_id_idx ON pgstac.items_search_p2019w36 USING btree (collection_id);

CREATE INDEX items_search_p2019w36_datetime_id_idx ON pgstac.items_search_p2019w36 USING btree (datetime, id);

CREATE INDEX items_search_p2019w36_geometry_idx ON pgstac.items_search_p2019w36 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w36_pkey ON pgstac.items_search_p2019w36 USING btree (id);

CREATE INDEX items_search_p2019w36_properties_idx ON pgstac.items_search_p2019w36 USING gin (properties);

CREATE INDEX items_search_p2019w37_collection_id_idx ON pgstac.items_search_p2019w37 USING btree (collection_id);

CREATE INDEX items_search_p2019w37_datetime_id_idx ON pgstac.items_search_p2019w37 USING btree (datetime, id);

CREATE INDEX items_search_p2019w37_geometry_idx ON pgstac.items_search_p2019w37 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w37_pkey ON pgstac.items_search_p2019w37 USING btree (id);

CREATE INDEX items_search_p2019w37_properties_idx ON pgstac.items_search_p2019w37 USING gin (properties);

CREATE INDEX items_search_p2019w38_collection_id_idx ON pgstac.items_search_p2019w38 USING btree (collection_id);

CREATE INDEX items_search_p2019w38_datetime_id_idx ON pgstac.items_search_p2019w38 USING btree (datetime, id);

CREATE INDEX items_search_p2019w38_geometry_idx ON pgstac.items_search_p2019w38 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w38_pkey ON pgstac.items_search_p2019w38 USING btree (id);

CREATE INDEX items_search_p2019w38_properties_idx ON pgstac.items_search_p2019w38 USING gin (properties);

CREATE INDEX items_search_p2019w39_collection_id_idx ON pgstac.items_search_p2019w39 USING btree (collection_id);

CREATE INDEX items_search_p2019w39_datetime_id_idx ON pgstac.items_search_p2019w39 USING btree (datetime, id);

CREATE INDEX items_search_p2019w39_geometry_idx ON pgstac.items_search_p2019w39 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w39_pkey ON pgstac.items_search_p2019w39 USING btree (id);

CREATE INDEX items_search_p2019w39_properties_idx ON pgstac.items_search_p2019w39 USING gin (properties);

CREATE INDEX items_search_p2019w40_collection_id_idx ON pgstac.items_search_p2019w40 USING btree (collection_id);

CREATE INDEX items_search_p2019w40_datetime_id_idx ON pgstac.items_search_p2019w40 USING btree (datetime, id);

CREATE INDEX items_search_p2019w40_geometry_idx ON pgstac.items_search_p2019w40 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w40_pkey ON pgstac.items_search_p2019w40 USING btree (id);

CREATE INDEX items_search_p2019w40_properties_idx ON pgstac.items_search_p2019w40 USING gin (properties);

CREATE INDEX items_search_p2019w41_collection_id_idx ON pgstac.items_search_p2019w41 USING btree (collection_id);

CREATE INDEX items_search_p2019w41_datetime_id_idx ON pgstac.items_search_p2019w41 USING btree (datetime, id);

CREATE INDEX items_search_p2019w41_geometry_idx ON pgstac.items_search_p2019w41 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w41_pkey ON pgstac.items_search_p2019w41 USING btree (id);

CREATE INDEX items_search_p2019w41_properties_idx ON pgstac.items_search_p2019w41 USING gin (properties);

CREATE INDEX items_search_p2019w42_collection_id_idx ON pgstac.items_search_p2019w42 USING btree (collection_id);

CREATE INDEX items_search_p2019w42_datetime_id_idx ON pgstac.items_search_p2019w42 USING btree (datetime, id);

CREATE INDEX items_search_p2019w42_geometry_idx ON pgstac.items_search_p2019w42 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w42_pkey ON pgstac.items_search_p2019w42 USING btree (id);

CREATE INDEX items_search_p2019w42_properties_idx ON pgstac.items_search_p2019w42 USING gin (properties);

CREATE INDEX items_search_p2019w43_collection_id_idx ON pgstac.items_search_p2019w43 USING btree (collection_id);

CREATE INDEX items_search_p2019w43_datetime_id_idx ON pgstac.items_search_p2019w43 USING btree (datetime, id);

CREATE INDEX items_search_p2019w43_geometry_idx ON pgstac.items_search_p2019w43 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w43_pkey ON pgstac.items_search_p2019w43 USING btree (id);

CREATE INDEX items_search_p2019w43_properties_idx ON pgstac.items_search_p2019w43 USING gin (properties);

CREATE INDEX items_search_p2019w44_collection_id_idx ON pgstac.items_search_p2019w44 USING btree (collection_id);

CREATE INDEX items_search_p2019w44_datetime_id_idx ON pgstac.items_search_p2019w44 USING btree (datetime, id);

CREATE INDEX items_search_p2019w44_geometry_idx ON pgstac.items_search_p2019w44 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w44_pkey ON pgstac.items_search_p2019w44 USING btree (id);

CREATE INDEX items_search_p2019w44_properties_idx ON pgstac.items_search_p2019w44 USING gin (properties);

CREATE INDEX items_search_p2019w45_collection_id_idx ON pgstac.items_search_p2019w45 USING btree (collection_id);

CREATE INDEX items_search_p2019w45_datetime_id_idx ON pgstac.items_search_p2019w45 USING btree (datetime, id);

CREATE INDEX items_search_p2019w45_geometry_idx ON pgstac.items_search_p2019w45 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w45_pkey ON pgstac.items_search_p2019w45 USING btree (id);

CREATE INDEX items_search_p2019w45_properties_idx ON pgstac.items_search_p2019w45 USING gin (properties);

CREATE INDEX items_search_p2019w46_collection_id_idx ON pgstac.items_search_p2019w46 USING btree (collection_id);

CREATE INDEX items_search_p2019w46_datetime_id_idx ON pgstac.items_search_p2019w46 USING btree (datetime, id);

CREATE INDEX items_search_p2019w46_geometry_idx ON pgstac.items_search_p2019w46 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w46_pkey ON pgstac.items_search_p2019w46 USING btree (id);

CREATE INDEX items_search_p2019w46_properties_idx ON pgstac.items_search_p2019w46 USING gin (properties);

CREATE INDEX items_search_p2019w47_collection_id_idx ON pgstac.items_search_p2019w47 USING btree (collection_id);

CREATE INDEX items_search_p2019w47_datetime_id_idx ON pgstac.items_search_p2019w47 USING btree (datetime, id);

CREATE INDEX items_search_p2019w47_geometry_idx ON pgstac.items_search_p2019w47 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w47_pkey ON pgstac.items_search_p2019w47 USING btree (id);

CREATE INDEX items_search_p2019w47_properties_idx ON pgstac.items_search_p2019w47 USING gin (properties);

CREATE INDEX items_search_p2019w48_collection_id_idx ON pgstac.items_search_p2019w48 USING btree (collection_id);

CREATE INDEX items_search_p2019w48_datetime_id_idx ON pgstac.items_search_p2019w48 USING btree (datetime, id);

CREATE INDEX items_search_p2019w48_geometry_idx ON pgstac.items_search_p2019w48 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w48_pkey ON pgstac.items_search_p2019w48 USING btree (id);

CREATE INDEX items_search_p2019w48_properties_idx ON pgstac.items_search_p2019w48 USING gin (properties);

CREATE INDEX items_search_p2019w49_collection_id_idx ON pgstac.items_search_p2019w49 USING btree (collection_id);

CREATE INDEX items_search_p2019w49_datetime_id_idx ON pgstac.items_search_p2019w49 USING btree (datetime, id);

CREATE INDEX items_search_p2019w49_geometry_idx ON pgstac.items_search_p2019w49 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w49_pkey ON pgstac.items_search_p2019w49 USING btree (id);

CREATE INDEX items_search_p2019w49_properties_idx ON pgstac.items_search_p2019w49 USING gin (properties);

CREATE INDEX items_search_p2019w50_collection_id_idx ON pgstac.items_search_p2019w50 USING btree (collection_id);

CREATE INDEX items_search_p2019w50_datetime_id_idx ON pgstac.items_search_p2019w50 USING btree (datetime, id);

CREATE INDEX items_search_p2019w50_geometry_idx ON pgstac.items_search_p2019w50 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w50_pkey ON pgstac.items_search_p2019w50 USING btree (id);

CREATE INDEX items_search_p2019w50_properties_idx ON pgstac.items_search_p2019w50 USING gin (properties);

CREATE INDEX items_search_p2019w51_collection_id_idx ON pgstac.items_search_p2019w51 USING btree (collection_id);

CREATE INDEX items_search_p2019w51_datetime_id_idx ON pgstac.items_search_p2019w51 USING btree (datetime, id);

CREATE INDEX items_search_p2019w51_geometry_idx ON pgstac.items_search_p2019w51 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w51_pkey ON pgstac.items_search_p2019w51 USING btree (id);

CREATE INDEX items_search_p2019w51_properties_idx ON pgstac.items_search_p2019w51 USING gin (properties);

CREATE INDEX items_search_p2019w52_collection_id_idx ON pgstac.items_search_p2019w52 USING btree (collection_id);

CREATE INDEX items_search_p2019w52_datetime_id_idx ON pgstac.items_search_p2019w52 USING btree (datetime, id);

CREATE INDEX items_search_p2019w52_geometry_idx ON pgstac.items_search_p2019w52 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2019w52_pkey ON pgstac.items_search_p2019w52 USING btree (id);

CREATE INDEX items_search_p2019w52_properties_idx ON pgstac.items_search_p2019w52 USING gin (properties);

CREATE INDEX items_search_p2020w01_collection_id_idx ON pgstac.items_search_p2020w01 USING btree (collection_id);

CREATE INDEX items_search_p2020w01_datetime_id_idx ON pgstac.items_search_p2020w01 USING btree (datetime, id);

CREATE INDEX items_search_p2020w01_geometry_idx ON pgstac.items_search_p2020w01 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w01_pkey ON pgstac.items_search_p2020w01 USING btree (id);

CREATE INDEX items_search_p2020w01_properties_idx ON pgstac.items_search_p2020w01 USING gin (properties);

CREATE INDEX items_search_p2020w02_collection_id_idx ON pgstac.items_search_p2020w02 USING btree (collection_id);

CREATE INDEX items_search_p2020w02_datetime_id_idx ON pgstac.items_search_p2020w02 USING btree (datetime, id);

CREATE INDEX items_search_p2020w02_geometry_idx ON pgstac.items_search_p2020w02 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w02_pkey ON pgstac.items_search_p2020w02 USING btree (id);

CREATE INDEX items_search_p2020w02_properties_idx ON pgstac.items_search_p2020w02 USING gin (properties);

CREATE INDEX items_search_p2020w03_collection_id_idx ON pgstac.items_search_p2020w03 USING btree (collection_id);

CREATE INDEX items_search_p2020w03_datetime_id_idx ON pgstac.items_search_p2020w03 USING btree (datetime, id);

CREATE INDEX items_search_p2020w03_geometry_idx ON pgstac.items_search_p2020w03 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w03_pkey ON pgstac.items_search_p2020w03 USING btree (id);

CREATE INDEX items_search_p2020w03_properties_idx ON pgstac.items_search_p2020w03 USING gin (properties);

CREATE INDEX items_search_p2020w04_collection_id_idx ON pgstac.items_search_p2020w04 USING btree (collection_id);

CREATE INDEX items_search_p2020w04_datetime_id_idx ON pgstac.items_search_p2020w04 USING btree (datetime, id);

CREATE INDEX items_search_p2020w04_geometry_idx ON pgstac.items_search_p2020w04 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w04_pkey ON pgstac.items_search_p2020w04 USING btree (id);

CREATE INDEX items_search_p2020w04_properties_idx ON pgstac.items_search_p2020w04 USING gin (properties);

CREATE INDEX items_search_p2020w05_collection_id_idx ON pgstac.items_search_p2020w05 USING btree (collection_id);

CREATE INDEX items_search_p2020w05_datetime_id_idx ON pgstac.items_search_p2020w05 USING btree (datetime, id);

CREATE INDEX items_search_p2020w05_geometry_idx ON pgstac.items_search_p2020w05 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w05_pkey ON pgstac.items_search_p2020w05 USING btree (id);

CREATE INDEX items_search_p2020w05_properties_idx ON pgstac.items_search_p2020w05 USING gin (properties);

CREATE INDEX items_search_p2020w06_collection_id_idx ON pgstac.items_search_p2020w06 USING btree (collection_id);

CREATE INDEX items_search_p2020w06_datetime_id_idx ON pgstac.items_search_p2020w06 USING btree (datetime, id);

CREATE INDEX items_search_p2020w06_geometry_idx ON pgstac.items_search_p2020w06 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w06_pkey ON pgstac.items_search_p2020w06 USING btree (id);

CREATE INDEX items_search_p2020w06_properties_idx ON pgstac.items_search_p2020w06 USING gin (properties);

CREATE INDEX items_search_p2020w07_collection_id_idx ON pgstac.items_search_p2020w07 USING btree (collection_id);

CREATE INDEX items_search_p2020w07_datetime_id_idx ON pgstac.items_search_p2020w07 USING btree (datetime, id);

CREATE INDEX items_search_p2020w07_geometry_idx ON pgstac.items_search_p2020w07 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w07_pkey ON pgstac.items_search_p2020w07 USING btree (id);

CREATE INDEX items_search_p2020w07_properties_idx ON pgstac.items_search_p2020w07 USING gin (properties);

CREATE INDEX items_search_p2020w08_collection_id_idx ON pgstac.items_search_p2020w08 USING btree (collection_id);

CREATE INDEX items_search_p2020w08_datetime_id_idx ON pgstac.items_search_p2020w08 USING btree (datetime, id);

CREATE INDEX items_search_p2020w08_geometry_idx ON pgstac.items_search_p2020w08 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w08_pkey ON pgstac.items_search_p2020w08 USING btree (id);

CREATE INDEX items_search_p2020w08_properties_idx ON pgstac.items_search_p2020w08 USING gin (properties);

CREATE INDEX items_search_p2020w09_collection_id_idx ON pgstac.items_search_p2020w09 USING btree (collection_id);

CREATE INDEX items_search_p2020w09_datetime_id_idx ON pgstac.items_search_p2020w09 USING btree (datetime, id);

CREATE INDEX items_search_p2020w09_geometry_idx ON pgstac.items_search_p2020w09 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w09_pkey ON pgstac.items_search_p2020w09 USING btree (id);

CREATE INDEX items_search_p2020w09_properties_idx ON pgstac.items_search_p2020w09 USING gin (properties);

CREATE INDEX items_search_p2020w10_collection_id_idx ON pgstac.items_search_p2020w10 USING btree (collection_id);

CREATE INDEX items_search_p2020w10_datetime_id_idx ON pgstac.items_search_p2020w10 USING btree (datetime, id);

CREATE INDEX items_search_p2020w10_geometry_idx ON pgstac.items_search_p2020w10 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w10_pkey ON pgstac.items_search_p2020w10 USING btree (id);

CREATE INDEX items_search_p2020w10_properties_idx ON pgstac.items_search_p2020w10 USING gin (properties);

CREATE INDEX items_search_p2020w11_collection_id_idx ON pgstac.items_search_p2020w11 USING btree (collection_id);

CREATE INDEX items_search_p2020w11_datetime_id_idx ON pgstac.items_search_p2020w11 USING btree (datetime, id);

CREATE INDEX items_search_p2020w11_geometry_idx ON pgstac.items_search_p2020w11 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w11_pkey ON pgstac.items_search_p2020w11 USING btree (id);

CREATE INDEX items_search_p2020w11_properties_idx ON pgstac.items_search_p2020w11 USING gin (properties);

CREATE INDEX items_search_p2020w12_collection_id_idx ON pgstac.items_search_p2020w12 USING btree (collection_id);

CREATE INDEX items_search_p2020w12_datetime_id_idx ON pgstac.items_search_p2020w12 USING btree (datetime, id);

CREATE INDEX items_search_p2020w12_geometry_idx ON pgstac.items_search_p2020w12 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w12_pkey ON pgstac.items_search_p2020w12 USING btree (id);

CREATE INDEX items_search_p2020w12_properties_idx ON pgstac.items_search_p2020w12 USING gin (properties);

CREATE INDEX items_search_p2020w13_collection_id_idx ON pgstac.items_search_p2020w13 USING btree (collection_id);

CREATE INDEX items_search_p2020w13_datetime_id_idx ON pgstac.items_search_p2020w13 USING btree (datetime, id);

CREATE INDEX items_search_p2020w13_geometry_idx ON pgstac.items_search_p2020w13 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w13_pkey ON pgstac.items_search_p2020w13 USING btree (id);

CREATE INDEX items_search_p2020w13_properties_idx ON pgstac.items_search_p2020w13 USING gin (properties);

CREATE INDEX items_search_p2020w14_collection_id_idx ON pgstac.items_search_p2020w14 USING btree (collection_id);

CREATE INDEX items_search_p2020w14_datetime_id_idx ON pgstac.items_search_p2020w14 USING btree (datetime, id);

CREATE INDEX items_search_p2020w14_geometry_idx ON pgstac.items_search_p2020w14 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w14_pkey ON pgstac.items_search_p2020w14 USING btree (id);

CREATE INDEX items_search_p2020w14_properties_idx ON pgstac.items_search_p2020w14 USING gin (properties);

CREATE INDEX items_search_p2020w15_collection_id_idx ON pgstac.items_search_p2020w15 USING btree (collection_id);

CREATE INDEX items_search_p2020w15_datetime_id_idx ON pgstac.items_search_p2020w15 USING btree (datetime, id);

CREATE INDEX items_search_p2020w15_geometry_idx ON pgstac.items_search_p2020w15 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w15_pkey ON pgstac.items_search_p2020w15 USING btree (id);

CREATE INDEX items_search_p2020w15_properties_idx ON pgstac.items_search_p2020w15 USING gin (properties);

CREATE INDEX items_search_p2020w16_collection_id_idx ON pgstac.items_search_p2020w16 USING btree (collection_id);

CREATE INDEX items_search_p2020w16_datetime_id_idx ON pgstac.items_search_p2020w16 USING btree (datetime, id);

CREATE INDEX items_search_p2020w16_geometry_idx ON pgstac.items_search_p2020w16 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w16_pkey ON pgstac.items_search_p2020w16 USING btree (id);

CREATE INDEX items_search_p2020w16_properties_idx ON pgstac.items_search_p2020w16 USING gin (properties);

CREATE INDEX items_search_p2020w17_collection_id_idx ON pgstac.items_search_p2020w17 USING btree (collection_id);

CREATE INDEX items_search_p2020w17_datetime_id_idx ON pgstac.items_search_p2020w17 USING btree (datetime, id);

CREATE INDEX items_search_p2020w17_geometry_idx ON pgstac.items_search_p2020w17 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w17_pkey ON pgstac.items_search_p2020w17 USING btree (id);

CREATE INDEX items_search_p2020w17_properties_idx ON pgstac.items_search_p2020w17 USING gin (properties);

CREATE INDEX items_search_p2020w18_collection_id_idx ON pgstac.items_search_p2020w18 USING btree (collection_id);

CREATE INDEX items_search_p2020w18_datetime_id_idx ON pgstac.items_search_p2020w18 USING btree (datetime, id);

CREATE INDEX items_search_p2020w18_geometry_idx ON pgstac.items_search_p2020w18 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w18_pkey ON pgstac.items_search_p2020w18 USING btree (id);

CREATE INDEX items_search_p2020w18_properties_idx ON pgstac.items_search_p2020w18 USING gin (properties);

CREATE INDEX items_search_p2020w19_collection_id_idx ON pgstac.items_search_p2020w19 USING btree (collection_id);

CREATE INDEX items_search_p2020w19_datetime_id_idx ON pgstac.items_search_p2020w19 USING btree (datetime, id);

CREATE INDEX items_search_p2020w19_geometry_idx ON pgstac.items_search_p2020w19 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w19_pkey ON pgstac.items_search_p2020w19 USING btree (id);

CREATE INDEX items_search_p2020w19_properties_idx ON pgstac.items_search_p2020w19 USING gin (properties);

CREATE INDEX items_search_p2020w20_collection_id_idx ON pgstac.items_search_p2020w20 USING btree (collection_id);

CREATE INDEX items_search_p2020w20_datetime_id_idx ON pgstac.items_search_p2020w20 USING btree (datetime, id);

CREATE INDEX items_search_p2020w20_geometry_idx ON pgstac.items_search_p2020w20 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w20_pkey ON pgstac.items_search_p2020w20 USING btree (id);

CREATE INDEX items_search_p2020w20_properties_idx ON pgstac.items_search_p2020w20 USING gin (properties);

CREATE INDEX items_search_p2020w21_collection_id_idx ON pgstac.items_search_p2020w21 USING btree (collection_id);

CREATE INDEX items_search_p2020w21_datetime_id_idx ON pgstac.items_search_p2020w21 USING btree (datetime, id);

CREATE INDEX items_search_p2020w21_geometry_idx ON pgstac.items_search_p2020w21 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w21_pkey ON pgstac.items_search_p2020w21 USING btree (id);

CREATE INDEX items_search_p2020w21_properties_idx ON pgstac.items_search_p2020w21 USING gin (properties);

CREATE INDEX items_search_p2020w22_collection_id_idx ON pgstac.items_search_p2020w22 USING btree (collection_id);

CREATE INDEX items_search_p2020w22_datetime_id_idx ON pgstac.items_search_p2020w22 USING btree (datetime, id);

CREATE INDEX items_search_p2020w22_geometry_idx ON pgstac.items_search_p2020w22 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w22_pkey ON pgstac.items_search_p2020w22 USING btree (id);

CREATE INDEX items_search_p2020w22_properties_idx ON pgstac.items_search_p2020w22 USING gin (properties);

CREATE INDEX items_search_p2020w23_collection_id_idx ON pgstac.items_search_p2020w23 USING btree (collection_id);

CREATE INDEX items_search_p2020w23_datetime_id_idx ON pgstac.items_search_p2020w23 USING btree (datetime, id);

CREATE INDEX items_search_p2020w23_geometry_idx ON pgstac.items_search_p2020w23 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w23_pkey ON pgstac.items_search_p2020w23 USING btree (id);

CREATE INDEX items_search_p2020w23_properties_idx ON pgstac.items_search_p2020w23 USING gin (properties);

CREATE INDEX items_search_p2020w24_collection_id_idx ON pgstac.items_search_p2020w24 USING btree (collection_id);

CREATE INDEX items_search_p2020w24_datetime_id_idx ON pgstac.items_search_p2020w24 USING btree (datetime, id);

CREATE INDEX items_search_p2020w24_geometry_idx ON pgstac.items_search_p2020w24 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w24_pkey ON pgstac.items_search_p2020w24 USING btree (id);

CREATE INDEX items_search_p2020w24_properties_idx ON pgstac.items_search_p2020w24 USING gin (properties);

CREATE INDEX items_search_p2020w25_collection_id_idx ON pgstac.items_search_p2020w25 USING btree (collection_id);

CREATE INDEX items_search_p2020w25_datetime_id_idx ON pgstac.items_search_p2020w25 USING btree (datetime, id);

CREATE INDEX items_search_p2020w25_geometry_idx ON pgstac.items_search_p2020w25 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w25_pkey ON pgstac.items_search_p2020w25 USING btree (id);

CREATE INDEX items_search_p2020w25_properties_idx ON pgstac.items_search_p2020w25 USING gin (properties);

CREATE INDEX items_search_p2020w26_collection_id_idx ON pgstac.items_search_p2020w26 USING btree (collection_id);

CREATE INDEX items_search_p2020w26_datetime_id_idx ON pgstac.items_search_p2020w26 USING btree (datetime, id);

CREATE INDEX items_search_p2020w26_geometry_idx ON pgstac.items_search_p2020w26 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w26_pkey ON pgstac.items_search_p2020w26 USING btree (id);

CREATE INDEX items_search_p2020w26_properties_idx ON pgstac.items_search_p2020w26 USING gin (properties);

CREATE INDEX items_search_p2020w27_collection_id_idx ON pgstac.items_search_p2020w27 USING btree (collection_id);

CREATE INDEX items_search_p2020w27_datetime_id_idx ON pgstac.items_search_p2020w27 USING btree (datetime, id);

CREATE INDEX items_search_p2020w27_geometry_idx ON pgstac.items_search_p2020w27 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w27_pkey ON pgstac.items_search_p2020w27 USING btree (id);

CREATE INDEX items_search_p2020w27_properties_idx ON pgstac.items_search_p2020w27 USING gin (properties);

CREATE INDEX items_search_p2020w28_collection_id_idx ON pgstac.items_search_p2020w28 USING btree (collection_id);

CREATE INDEX items_search_p2020w28_datetime_id_idx ON pgstac.items_search_p2020w28 USING btree (datetime, id);

CREATE INDEX items_search_p2020w28_geometry_idx ON pgstac.items_search_p2020w28 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w28_pkey ON pgstac.items_search_p2020w28 USING btree (id);

CREATE INDEX items_search_p2020w28_properties_idx ON pgstac.items_search_p2020w28 USING gin (properties);

CREATE INDEX items_search_p2020w29_collection_id_idx ON pgstac.items_search_p2020w29 USING btree (collection_id);

CREATE INDEX items_search_p2020w29_datetime_id_idx ON pgstac.items_search_p2020w29 USING btree (datetime, id);

CREATE INDEX items_search_p2020w29_geometry_idx ON pgstac.items_search_p2020w29 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w29_pkey ON pgstac.items_search_p2020w29 USING btree (id);

CREATE INDEX items_search_p2020w29_properties_idx ON pgstac.items_search_p2020w29 USING gin (properties);

CREATE INDEX items_search_p2020w30_collection_id_idx ON pgstac.items_search_p2020w30 USING btree (collection_id);

CREATE INDEX items_search_p2020w30_datetime_id_idx ON pgstac.items_search_p2020w30 USING btree (datetime, id);

CREATE INDEX items_search_p2020w30_geometry_idx ON pgstac.items_search_p2020w30 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w30_pkey ON pgstac.items_search_p2020w30 USING btree (id);

CREATE INDEX items_search_p2020w30_properties_idx ON pgstac.items_search_p2020w30 USING gin (properties);

CREATE INDEX items_search_p2020w31_collection_id_idx ON pgstac.items_search_p2020w31 USING btree (collection_id);

CREATE INDEX items_search_p2020w31_datetime_id_idx ON pgstac.items_search_p2020w31 USING btree (datetime, id);

CREATE INDEX items_search_p2020w31_geometry_idx ON pgstac.items_search_p2020w31 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w31_pkey ON pgstac.items_search_p2020w31 USING btree (id);

CREATE INDEX items_search_p2020w31_properties_idx ON pgstac.items_search_p2020w31 USING gin (properties);

CREATE INDEX items_search_p2020w32_collection_id_idx ON pgstac.items_search_p2020w32 USING btree (collection_id);

CREATE INDEX items_search_p2020w32_datetime_id_idx ON pgstac.items_search_p2020w32 USING btree (datetime, id);

CREATE INDEX items_search_p2020w32_geometry_idx ON pgstac.items_search_p2020w32 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w32_pkey ON pgstac.items_search_p2020w32 USING btree (id);

CREATE INDEX items_search_p2020w32_properties_idx ON pgstac.items_search_p2020w32 USING gin (properties);

CREATE INDEX items_search_p2020w33_collection_id_idx ON pgstac.items_search_p2020w33 USING btree (collection_id);

CREATE INDEX items_search_p2020w33_datetime_id_idx ON pgstac.items_search_p2020w33 USING btree (datetime, id);

CREATE INDEX items_search_p2020w33_geometry_idx ON pgstac.items_search_p2020w33 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w33_pkey ON pgstac.items_search_p2020w33 USING btree (id);

CREATE INDEX items_search_p2020w33_properties_idx ON pgstac.items_search_p2020w33 USING gin (properties);

CREATE INDEX items_search_p2020w34_collection_id_idx ON pgstac.items_search_p2020w34 USING btree (collection_id);

CREATE INDEX items_search_p2020w34_datetime_id_idx ON pgstac.items_search_p2020w34 USING btree (datetime, id);

CREATE INDEX items_search_p2020w34_geometry_idx ON pgstac.items_search_p2020w34 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w34_pkey ON pgstac.items_search_p2020w34 USING btree (id);

CREATE INDEX items_search_p2020w34_properties_idx ON pgstac.items_search_p2020w34 USING gin (properties);

CREATE INDEX items_search_p2020w35_collection_id_idx ON pgstac.items_search_p2020w35 USING btree (collection_id);

CREATE INDEX items_search_p2020w35_datetime_id_idx ON pgstac.items_search_p2020w35 USING btree (datetime, id);

CREATE INDEX items_search_p2020w35_geometry_idx ON pgstac.items_search_p2020w35 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w35_pkey ON pgstac.items_search_p2020w35 USING btree (id);

CREATE INDEX items_search_p2020w35_properties_idx ON pgstac.items_search_p2020w35 USING gin (properties);

CREATE INDEX items_search_p2020w36_collection_id_idx ON pgstac.items_search_p2020w36 USING btree (collection_id);

CREATE INDEX items_search_p2020w36_datetime_id_idx ON pgstac.items_search_p2020w36 USING btree (datetime, id);

CREATE INDEX items_search_p2020w36_geometry_idx ON pgstac.items_search_p2020w36 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w36_pkey ON pgstac.items_search_p2020w36 USING btree (id);

CREATE INDEX items_search_p2020w36_properties_idx ON pgstac.items_search_p2020w36 USING gin (properties);

CREATE INDEX items_search_p2020w37_collection_id_idx ON pgstac.items_search_p2020w37 USING btree (collection_id);

CREATE INDEX items_search_p2020w37_datetime_id_idx ON pgstac.items_search_p2020w37 USING btree (datetime, id);

CREATE INDEX items_search_p2020w37_geometry_idx ON pgstac.items_search_p2020w37 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w37_pkey ON pgstac.items_search_p2020w37 USING btree (id);

CREATE INDEX items_search_p2020w37_properties_idx ON pgstac.items_search_p2020w37 USING gin (properties);

CREATE INDEX items_search_p2020w38_collection_id_idx ON pgstac.items_search_p2020w38 USING btree (collection_id);

CREATE INDEX items_search_p2020w38_datetime_id_idx ON pgstac.items_search_p2020w38 USING btree (datetime, id);

CREATE INDEX items_search_p2020w38_geometry_idx ON pgstac.items_search_p2020w38 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w38_pkey ON pgstac.items_search_p2020w38 USING btree (id);

CREATE INDEX items_search_p2020w38_properties_idx ON pgstac.items_search_p2020w38 USING gin (properties);

CREATE INDEX items_search_p2020w39_collection_id_idx ON pgstac.items_search_p2020w39 USING btree (collection_id);

CREATE INDEX items_search_p2020w39_datetime_id_idx ON pgstac.items_search_p2020w39 USING btree (datetime, id);

CREATE INDEX items_search_p2020w39_geometry_idx ON pgstac.items_search_p2020w39 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w39_pkey ON pgstac.items_search_p2020w39 USING btree (id);

CREATE INDEX items_search_p2020w39_properties_idx ON pgstac.items_search_p2020w39 USING gin (properties);

CREATE INDEX items_search_p2020w40_collection_id_idx ON pgstac.items_search_p2020w40 USING btree (collection_id);

CREATE INDEX items_search_p2020w40_datetime_id_idx ON pgstac.items_search_p2020w40 USING btree (datetime, id);

CREATE INDEX items_search_p2020w40_geometry_idx ON pgstac.items_search_p2020w40 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w40_pkey ON pgstac.items_search_p2020w40 USING btree (id);

CREATE INDEX items_search_p2020w40_properties_idx ON pgstac.items_search_p2020w40 USING gin (properties);

CREATE INDEX items_search_p2020w41_collection_id_idx ON pgstac.items_search_p2020w41 USING btree (collection_id);

CREATE INDEX items_search_p2020w41_datetime_id_idx ON pgstac.items_search_p2020w41 USING btree (datetime, id);

CREATE INDEX items_search_p2020w41_geometry_idx ON pgstac.items_search_p2020w41 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w41_pkey ON pgstac.items_search_p2020w41 USING btree (id);

CREATE INDEX items_search_p2020w41_properties_idx ON pgstac.items_search_p2020w41 USING gin (properties);

CREATE INDEX items_search_p2020w42_collection_id_idx ON pgstac.items_search_p2020w42 USING btree (collection_id);

CREATE INDEX items_search_p2020w42_datetime_id_idx ON pgstac.items_search_p2020w42 USING btree (datetime, id);

CREATE INDEX items_search_p2020w42_geometry_idx ON pgstac.items_search_p2020w42 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w42_pkey ON pgstac.items_search_p2020w42 USING btree (id);

CREATE INDEX items_search_p2020w42_properties_idx ON pgstac.items_search_p2020w42 USING gin (properties);

CREATE INDEX items_search_p2020w43_collection_id_idx ON pgstac.items_search_p2020w43 USING btree (collection_id);

CREATE INDEX items_search_p2020w43_datetime_id_idx ON pgstac.items_search_p2020w43 USING btree (datetime, id);

CREATE INDEX items_search_p2020w43_geometry_idx ON pgstac.items_search_p2020w43 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w43_pkey ON pgstac.items_search_p2020w43 USING btree (id);

CREATE INDEX items_search_p2020w43_properties_idx ON pgstac.items_search_p2020w43 USING gin (properties);

CREATE INDEX items_search_p2020w44_collection_id_idx ON pgstac.items_search_p2020w44 USING btree (collection_id);

CREATE INDEX items_search_p2020w44_datetime_id_idx ON pgstac.items_search_p2020w44 USING btree (datetime, id);

CREATE INDEX items_search_p2020w44_geometry_idx ON pgstac.items_search_p2020w44 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w44_pkey ON pgstac.items_search_p2020w44 USING btree (id);

CREATE INDEX items_search_p2020w44_properties_idx ON pgstac.items_search_p2020w44 USING gin (properties);

CREATE INDEX items_search_p2020w45_collection_id_idx ON pgstac.items_search_p2020w45 USING btree (collection_id);

CREATE INDEX items_search_p2020w45_datetime_id_idx ON pgstac.items_search_p2020w45 USING btree (datetime, id);

CREATE INDEX items_search_p2020w45_geometry_idx ON pgstac.items_search_p2020w45 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w45_pkey ON pgstac.items_search_p2020w45 USING btree (id);

CREATE INDEX items_search_p2020w45_properties_idx ON pgstac.items_search_p2020w45 USING gin (properties);

CREATE INDEX items_search_p2020w46_collection_id_idx ON pgstac.items_search_p2020w46 USING btree (collection_id);

CREATE INDEX items_search_p2020w46_datetime_id_idx ON pgstac.items_search_p2020w46 USING btree (datetime, id);

CREATE INDEX items_search_p2020w46_geometry_idx ON pgstac.items_search_p2020w46 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w46_pkey ON pgstac.items_search_p2020w46 USING btree (id);

CREATE INDEX items_search_p2020w46_properties_idx ON pgstac.items_search_p2020w46 USING gin (properties);

CREATE INDEX items_search_p2020w47_collection_id_idx ON pgstac.items_search_p2020w47 USING btree (collection_id);

CREATE INDEX items_search_p2020w47_datetime_id_idx ON pgstac.items_search_p2020w47 USING btree (datetime, id);

CREATE INDEX items_search_p2020w47_geometry_idx ON pgstac.items_search_p2020w47 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w47_pkey ON pgstac.items_search_p2020w47 USING btree (id);

CREATE INDEX items_search_p2020w47_properties_idx ON pgstac.items_search_p2020w47 USING gin (properties);

CREATE INDEX items_search_p2020w48_collection_id_idx ON pgstac.items_search_p2020w48 USING btree (collection_id);

CREATE INDEX items_search_p2020w48_datetime_id_idx ON pgstac.items_search_p2020w48 USING btree (datetime, id);

CREATE INDEX items_search_p2020w48_geometry_idx ON pgstac.items_search_p2020w48 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w48_pkey ON pgstac.items_search_p2020w48 USING btree (id);

CREATE INDEX items_search_p2020w48_properties_idx ON pgstac.items_search_p2020w48 USING gin (properties);

CREATE INDEX items_search_p2020w49_collection_id_idx ON pgstac.items_search_p2020w49 USING btree (collection_id);

CREATE INDEX items_search_p2020w49_datetime_id_idx ON pgstac.items_search_p2020w49 USING btree (datetime, id);

CREATE INDEX items_search_p2020w49_geometry_idx ON pgstac.items_search_p2020w49 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w49_pkey ON pgstac.items_search_p2020w49 USING btree (id);

CREATE INDEX items_search_p2020w49_properties_idx ON pgstac.items_search_p2020w49 USING gin (properties);

CREATE INDEX items_search_p2020w50_collection_id_idx ON pgstac.items_search_p2020w50 USING btree (collection_id);

CREATE INDEX items_search_p2020w50_datetime_id_idx ON pgstac.items_search_p2020w50 USING btree (datetime, id);

CREATE INDEX items_search_p2020w50_geometry_idx ON pgstac.items_search_p2020w50 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w50_pkey ON pgstac.items_search_p2020w50 USING btree (id);

CREATE INDEX items_search_p2020w50_properties_idx ON pgstac.items_search_p2020w50 USING gin (properties);

CREATE INDEX items_search_p2020w51_collection_id_idx ON pgstac.items_search_p2020w51 USING btree (collection_id);

CREATE INDEX items_search_p2020w51_datetime_id_idx ON pgstac.items_search_p2020w51 USING btree (datetime, id);

CREATE INDEX items_search_p2020w51_geometry_idx ON pgstac.items_search_p2020w51 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w51_pkey ON pgstac.items_search_p2020w51 USING btree (id);

CREATE INDEX items_search_p2020w51_properties_idx ON pgstac.items_search_p2020w51 USING gin (properties);

CREATE INDEX items_search_p2020w52_collection_id_idx ON pgstac.items_search_p2020w52 USING btree (collection_id);

CREATE INDEX items_search_p2020w52_datetime_id_idx ON pgstac.items_search_p2020w52 USING btree (datetime, id);

CREATE INDEX items_search_p2020w52_geometry_idx ON pgstac.items_search_p2020w52 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w52_pkey ON pgstac.items_search_p2020w52 USING btree (id);

CREATE INDEX items_search_p2020w52_properties_idx ON pgstac.items_search_p2020w52 USING gin (properties);

CREATE INDEX items_search_p2020w53_collection_id_idx ON pgstac.items_search_p2020w53 USING btree (collection_id);

CREATE INDEX items_search_p2020w53_datetime_id_idx ON pgstac.items_search_p2020w53 USING btree (datetime, id);

CREATE INDEX items_search_p2020w53_geometry_idx ON pgstac.items_search_p2020w53 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2020w53_pkey ON pgstac.items_search_p2020w53 USING btree (id);

CREATE INDEX items_search_p2020w53_properties_idx ON pgstac.items_search_p2020w53 USING gin (properties);

CREATE INDEX items_search_p2021w01_collection_id_idx ON pgstac.items_search_p2021w01 USING btree (collection_id);

CREATE INDEX items_search_p2021w01_datetime_id_idx ON pgstac.items_search_p2021w01 USING btree (datetime, id);

CREATE INDEX items_search_p2021w01_geometry_idx ON pgstac.items_search_p2021w01 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w01_pkey ON pgstac.items_search_p2021w01 USING btree (id);

CREATE INDEX items_search_p2021w01_properties_idx ON pgstac.items_search_p2021w01 USING gin (properties);

CREATE INDEX items_search_p2021w02_collection_id_idx ON pgstac.items_search_p2021w02 USING btree (collection_id);

CREATE INDEX items_search_p2021w02_datetime_id_idx ON pgstac.items_search_p2021w02 USING btree (datetime, id);

CREATE INDEX items_search_p2021w02_geometry_idx ON pgstac.items_search_p2021w02 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w02_pkey ON pgstac.items_search_p2021w02 USING btree (id);

CREATE INDEX items_search_p2021w02_properties_idx ON pgstac.items_search_p2021w02 USING gin (properties);

CREATE INDEX items_search_p2021w03_collection_id_idx ON pgstac.items_search_p2021w03 USING btree (collection_id);

CREATE INDEX items_search_p2021w03_datetime_id_idx ON pgstac.items_search_p2021w03 USING btree (datetime, id);

CREATE INDEX items_search_p2021w03_geometry_idx ON pgstac.items_search_p2021w03 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w03_pkey ON pgstac.items_search_p2021w03 USING btree (id);

CREATE INDEX items_search_p2021w03_properties_idx ON pgstac.items_search_p2021w03 USING gin (properties);

CREATE INDEX items_search_p2021w04_collection_id_idx ON pgstac.items_search_p2021w04 USING btree (collection_id);

CREATE INDEX items_search_p2021w04_datetime_id_idx ON pgstac.items_search_p2021w04 USING btree (datetime, id);

CREATE INDEX items_search_p2021w04_geometry_idx ON pgstac.items_search_p2021w04 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w04_pkey ON pgstac.items_search_p2021w04 USING btree (id);

CREATE INDEX items_search_p2021w04_properties_idx ON pgstac.items_search_p2021w04 USING gin (properties);

CREATE INDEX items_search_p2021w05_collection_id_idx ON pgstac.items_search_p2021w05 USING btree (collection_id);

CREATE INDEX items_search_p2021w05_datetime_id_idx ON pgstac.items_search_p2021w05 USING btree (datetime, id);

CREATE INDEX items_search_p2021w05_geometry_idx ON pgstac.items_search_p2021w05 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w05_pkey ON pgstac.items_search_p2021w05 USING btree (id);

CREATE INDEX items_search_p2021w05_properties_idx ON pgstac.items_search_p2021w05 USING gin (properties);

CREATE INDEX items_search_p2021w06_collection_id_idx ON pgstac.items_search_p2021w06 USING btree (collection_id);

CREATE INDEX items_search_p2021w06_datetime_id_idx ON pgstac.items_search_p2021w06 USING btree (datetime, id);

CREATE INDEX items_search_p2021w06_geometry_idx ON pgstac.items_search_p2021w06 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w06_pkey ON pgstac.items_search_p2021w06 USING btree (id);

CREATE INDEX items_search_p2021w06_properties_idx ON pgstac.items_search_p2021w06 USING gin (properties);

CREATE INDEX items_search_p2021w07_collection_id_idx ON pgstac.items_search_p2021w07 USING btree (collection_id);

CREATE INDEX items_search_p2021w07_datetime_id_idx ON pgstac.items_search_p2021w07 USING btree (datetime, id);

CREATE INDEX items_search_p2021w07_geometry_idx ON pgstac.items_search_p2021w07 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w07_pkey ON pgstac.items_search_p2021w07 USING btree (id);

CREATE INDEX items_search_p2021w07_properties_idx ON pgstac.items_search_p2021w07 USING gin (properties);

CREATE INDEX items_search_p2021w08_collection_id_idx ON pgstac.items_search_p2021w08 USING btree (collection_id);

CREATE INDEX items_search_p2021w08_datetime_id_idx ON pgstac.items_search_p2021w08 USING btree (datetime, id);

CREATE INDEX items_search_p2021w08_geometry_idx ON pgstac.items_search_p2021w08 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w08_pkey ON pgstac.items_search_p2021w08 USING btree (id);

CREATE INDEX items_search_p2021w08_properties_idx ON pgstac.items_search_p2021w08 USING gin (properties);

CREATE INDEX items_search_p2021w09_collection_id_idx ON pgstac.items_search_p2021w09 USING btree (collection_id);

CREATE INDEX items_search_p2021w09_datetime_id_idx ON pgstac.items_search_p2021w09 USING btree (datetime, id);

CREATE INDEX items_search_p2021w09_geometry_idx ON pgstac.items_search_p2021w09 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w09_pkey ON pgstac.items_search_p2021w09 USING btree (id);

CREATE INDEX items_search_p2021w09_properties_idx ON pgstac.items_search_p2021w09 USING gin (properties);

CREATE INDEX items_search_p2021w10_collection_id_idx ON pgstac.items_search_p2021w10 USING btree (collection_id);

CREATE INDEX items_search_p2021w10_datetime_id_idx ON pgstac.items_search_p2021w10 USING btree (datetime, id);

CREATE INDEX items_search_p2021w10_geometry_idx ON pgstac.items_search_p2021w10 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w10_pkey ON pgstac.items_search_p2021w10 USING btree (id);

CREATE INDEX items_search_p2021w10_properties_idx ON pgstac.items_search_p2021w10 USING gin (properties);

CREATE INDEX items_search_p2021w11_collection_id_idx ON pgstac.items_search_p2021w11 USING btree (collection_id);

CREATE INDEX items_search_p2021w11_datetime_id_idx ON pgstac.items_search_p2021w11 USING btree (datetime, id);

CREATE INDEX items_search_p2021w11_geometry_idx ON pgstac.items_search_p2021w11 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w11_pkey ON pgstac.items_search_p2021w11 USING btree (id);

CREATE INDEX items_search_p2021w11_properties_idx ON pgstac.items_search_p2021w11 USING gin (properties);

CREATE INDEX items_search_p2021w12_collection_id_idx ON pgstac.items_search_p2021w12 USING btree (collection_id);

CREATE INDEX items_search_p2021w12_datetime_id_idx ON pgstac.items_search_p2021w12 USING btree (datetime, id);

CREATE INDEX items_search_p2021w12_geometry_idx ON pgstac.items_search_p2021w12 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w12_pkey ON pgstac.items_search_p2021w12 USING btree (id);

CREATE INDEX items_search_p2021w12_properties_idx ON pgstac.items_search_p2021w12 USING gin (properties);

CREATE INDEX items_search_p2021w13_collection_id_idx ON pgstac.items_search_p2021w13 USING btree (collection_id);

CREATE INDEX items_search_p2021w13_datetime_id_idx ON pgstac.items_search_p2021w13 USING btree (datetime, id);

CREATE INDEX items_search_p2021w13_geometry_idx ON pgstac.items_search_p2021w13 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w13_pkey ON pgstac.items_search_p2021w13 USING btree (id);

CREATE INDEX items_search_p2021w13_properties_idx ON pgstac.items_search_p2021w13 USING gin (properties);

CREATE INDEX items_search_p2021w14_collection_id_idx ON pgstac.items_search_p2021w14 USING btree (collection_id);

CREATE INDEX items_search_p2021w14_datetime_id_idx ON pgstac.items_search_p2021w14 USING btree (datetime, id);

CREATE INDEX items_search_p2021w14_geometry_idx ON pgstac.items_search_p2021w14 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w14_pkey ON pgstac.items_search_p2021w14 USING btree (id);

CREATE INDEX items_search_p2021w14_properties_idx ON pgstac.items_search_p2021w14 USING gin (properties);

CREATE INDEX items_search_p2021w15_collection_id_idx ON pgstac.items_search_p2021w15 USING btree (collection_id);

CREATE INDEX items_search_p2021w15_datetime_id_idx ON pgstac.items_search_p2021w15 USING btree (datetime, id);

CREATE INDEX items_search_p2021w15_geometry_idx ON pgstac.items_search_p2021w15 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w15_pkey ON pgstac.items_search_p2021w15 USING btree (id);

CREATE INDEX items_search_p2021w15_properties_idx ON pgstac.items_search_p2021w15 USING gin (properties);

CREATE INDEX items_search_p2021w16_collection_id_idx ON pgstac.items_search_p2021w16 USING btree (collection_id);

CREATE INDEX items_search_p2021w16_datetime_id_idx ON pgstac.items_search_p2021w16 USING btree (datetime, id);

CREATE INDEX items_search_p2021w16_geometry_idx ON pgstac.items_search_p2021w16 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w16_pkey ON pgstac.items_search_p2021w16 USING btree (id);

CREATE INDEX items_search_p2021w16_properties_idx ON pgstac.items_search_p2021w16 USING gin (properties);

CREATE INDEX items_search_p2021w17_collection_id_idx ON pgstac.items_search_p2021w17 USING btree (collection_id);

CREATE INDEX items_search_p2021w17_datetime_id_idx ON pgstac.items_search_p2021w17 USING btree (datetime, id);

CREATE INDEX items_search_p2021w17_geometry_idx ON pgstac.items_search_p2021w17 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w17_pkey ON pgstac.items_search_p2021w17 USING btree (id);

CREATE INDEX items_search_p2021w17_properties_idx ON pgstac.items_search_p2021w17 USING gin (properties);

CREATE INDEX items_search_p2021w18_collection_id_idx ON pgstac.items_search_p2021w18 USING btree (collection_id);

CREATE INDEX items_search_p2021w18_datetime_id_idx ON pgstac.items_search_p2021w18 USING btree (datetime, id);

CREATE INDEX items_search_p2021w18_geometry_idx ON pgstac.items_search_p2021w18 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w18_pkey ON pgstac.items_search_p2021w18 USING btree (id);

CREATE INDEX items_search_p2021w18_properties_idx ON pgstac.items_search_p2021w18 USING gin (properties);

CREATE INDEX items_search_p2021w19_collection_id_idx ON pgstac.items_search_p2021w19 USING btree (collection_id);

CREATE INDEX items_search_p2021w19_datetime_id_idx ON pgstac.items_search_p2021w19 USING btree (datetime, id);

CREATE INDEX items_search_p2021w19_geometry_idx ON pgstac.items_search_p2021w19 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w19_pkey ON pgstac.items_search_p2021w19 USING btree (id);

CREATE INDEX items_search_p2021w19_properties_idx ON pgstac.items_search_p2021w19 USING gin (properties);

CREATE INDEX items_search_p2021w20_collection_id_idx ON pgstac.items_search_p2021w20 USING btree (collection_id);

CREATE INDEX items_search_p2021w20_datetime_id_idx ON pgstac.items_search_p2021w20 USING btree (datetime, id);

CREATE INDEX items_search_p2021w20_geometry_idx ON pgstac.items_search_p2021w20 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w20_pkey ON pgstac.items_search_p2021w20 USING btree (id);

CREATE INDEX items_search_p2021w20_properties_idx ON pgstac.items_search_p2021w20 USING gin (properties);

CREATE INDEX items_search_p2021w21_collection_id_idx ON pgstac.items_search_p2021w21 USING btree (collection_id);

CREATE INDEX items_search_p2021w21_datetime_id_idx ON pgstac.items_search_p2021w21 USING btree (datetime, id);

CREATE INDEX items_search_p2021w21_geometry_idx ON pgstac.items_search_p2021w21 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w21_pkey ON pgstac.items_search_p2021w21 USING btree (id);

CREATE INDEX items_search_p2021w21_properties_idx ON pgstac.items_search_p2021w21 USING gin (properties);

CREATE INDEX items_search_p2021w22_collection_id_idx ON pgstac.items_search_p2021w22 USING btree (collection_id);

CREATE INDEX items_search_p2021w22_datetime_id_idx ON pgstac.items_search_p2021w22 USING btree (datetime, id);

CREATE INDEX items_search_p2021w22_geometry_idx ON pgstac.items_search_p2021w22 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w22_pkey ON pgstac.items_search_p2021w22 USING btree (id);

CREATE INDEX items_search_p2021w22_properties_idx ON pgstac.items_search_p2021w22 USING gin (properties);

CREATE INDEX items_search_p2021w23_collection_id_idx ON pgstac.items_search_p2021w23 USING btree (collection_id);

CREATE INDEX items_search_p2021w23_datetime_id_idx ON pgstac.items_search_p2021w23 USING btree (datetime, id);

CREATE INDEX items_search_p2021w23_geometry_idx ON pgstac.items_search_p2021w23 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w23_pkey ON pgstac.items_search_p2021w23 USING btree (id);

CREATE INDEX items_search_p2021w23_properties_idx ON pgstac.items_search_p2021w23 USING gin (properties);

CREATE INDEX items_search_p2021w24_collection_id_idx ON pgstac.items_search_p2021w24 USING btree (collection_id);

CREATE INDEX items_search_p2021w24_datetime_id_idx ON pgstac.items_search_p2021w24 USING btree (datetime, id);

CREATE INDEX items_search_p2021w24_geometry_idx ON pgstac.items_search_p2021w24 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w24_pkey ON pgstac.items_search_p2021w24 USING btree (id);

CREATE INDEX items_search_p2021w24_properties_idx ON pgstac.items_search_p2021w24 USING gin (properties);

CREATE INDEX items_search_p2021w25_collection_id_idx ON pgstac.items_search_p2021w25 USING btree (collection_id);

CREATE INDEX items_search_p2021w25_datetime_id_idx ON pgstac.items_search_p2021w25 USING btree (datetime, id);

CREATE INDEX items_search_p2021w25_geometry_idx ON pgstac.items_search_p2021w25 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w25_pkey ON pgstac.items_search_p2021w25 USING btree (id);

CREATE INDEX items_search_p2021w25_properties_idx ON pgstac.items_search_p2021w25 USING gin (properties);

CREATE INDEX items_search_p2021w26_collection_id_idx ON pgstac.items_search_p2021w26 USING btree (collection_id);

CREATE INDEX items_search_p2021w26_datetime_id_idx ON pgstac.items_search_p2021w26 USING btree (datetime, id);

CREATE INDEX items_search_p2021w26_geometry_idx ON pgstac.items_search_p2021w26 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w26_pkey ON pgstac.items_search_p2021w26 USING btree (id);

CREATE INDEX items_search_p2021w26_properties_idx ON pgstac.items_search_p2021w26 USING gin (properties);

CREATE INDEX items_search_p2021w27_collection_id_idx ON pgstac.items_search_p2021w27 USING btree (collection_id);

CREATE INDEX items_search_p2021w27_datetime_id_idx ON pgstac.items_search_p2021w27 USING btree (datetime, id);

CREATE INDEX items_search_p2021w27_geometry_idx ON pgstac.items_search_p2021w27 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w27_pkey ON pgstac.items_search_p2021w27 USING btree (id);

CREATE INDEX items_search_p2021w27_properties_idx ON pgstac.items_search_p2021w27 USING gin (properties);

CREATE INDEX items_search_p2021w28_collection_id_idx ON pgstac.items_search_p2021w28 USING btree (collection_id);

CREATE INDEX items_search_p2021w28_datetime_id_idx ON pgstac.items_search_p2021w28 USING btree (datetime, id);

CREATE INDEX items_search_p2021w28_geometry_idx ON pgstac.items_search_p2021w28 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w28_pkey ON pgstac.items_search_p2021w28 USING btree (id);

CREATE INDEX items_search_p2021w28_properties_idx ON pgstac.items_search_p2021w28 USING gin (properties);

CREATE INDEX items_search_p2021w29_collection_id_idx ON pgstac.items_search_p2021w29 USING btree (collection_id);

CREATE INDEX items_search_p2021w29_datetime_id_idx ON pgstac.items_search_p2021w29 USING btree (datetime, id);

CREATE INDEX items_search_p2021w29_geometry_idx ON pgstac.items_search_p2021w29 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w29_pkey ON pgstac.items_search_p2021w29 USING btree (id);

CREATE INDEX items_search_p2021w29_properties_idx ON pgstac.items_search_p2021w29 USING gin (properties);

CREATE INDEX items_search_p2021w30_collection_id_idx ON pgstac.items_search_p2021w30 USING btree (collection_id);

CREATE INDEX items_search_p2021w30_datetime_id_idx ON pgstac.items_search_p2021w30 USING btree (datetime, id);

CREATE INDEX items_search_p2021w30_geometry_idx ON pgstac.items_search_p2021w30 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w30_pkey ON pgstac.items_search_p2021w30 USING btree (id);

CREATE INDEX items_search_p2021w30_properties_idx ON pgstac.items_search_p2021w30 USING gin (properties);

CREATE INDEX items_search_p2021w31_collection_id_idx ON pgstac.items_search_p2021w31 USING btree (collection_id);

CREATE INDEX items_search_p2021w31_datetime_id_idx ON pgstac.items_search_p2021w31 USING btree (datetime, id);

CREATE INDEX items_search_p2021w31_geometry_idx ON pgstac.items_search_p2021w31 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w31_pkey ON pgstac.items_search_p2021w31 USING btree (id);

CREATE INDEX items_search_p2021w31_properties_idx ON pgstac.items_search_p2021w31 USING gin (properties);

CREATE INDEX items_search_p2021w32_collection_id_idx ON pgstac.items_search_p2021w32 USING btree (collection_id);

CREATE INDEX items_search_p2021w32_datetime_id_idx ON pgstac.items_search_p2021w32 USING btree (datetime, id);

CREATE INDEX items_search_p2021w32_geometry_idx ON pgstac.items_search_p2021w32 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w32_pkey ON pgstac.items_search_p2021w32 USING btree (id);

CREATE INDEX items_search_p2021w32_properties_idx ON pgstac.items_search_p2021w32 USING gin (properties);

CREATE INDEX items_search_p2021w33_collection_id_idx ON pgstac.items_search_p2021w33 USING btree (collection_id);

CREATE INDEX items_search_p2021w33_datetime_id_idx ON pgstac.items_search_p2021w33 USING btree (datetime, id);

CREATE INDEX items_search_p2021w33_geometry_idx ON pgstac.items_search_p2021w33 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w33_pkey ON pgstac.items_search_p2021w33 USING btree (id);

CREATE INDEX items_search_p2021w33_properties_idx ON pgstac.items_search_p2021w33 USING gin (properties);

CREATE INDEX items_search_p2021w34_collection_id_idx ON pgstac.items_search_p2021w34 USING btree (collection_id);

CREATE INDEX items_search_p2021w34_datetime_id_idx ON pgstac.items_search_p2021w34 USING btree (datetime, id);

CREATE INDEX items_search_p2021w34_geometry_idx ON pgstac.items_search_p2021w34 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w34_pkey ON pgstac.items_search_p2021w34 USING btree (id);

CREATE INDEX items_search_p2021w34_properties_idx ON pgstac.items_search_p2021w34 USING gin (properties);

CREATE INDEX items_search_p2021w35_collection_id_idx ON pgstac.items_search_p2021w35 USING btree (collection_id);

CREATE INDEX items_search_p2021w35_datetime_id_idx ON pgstac.items_search_p2021w35 USING btree (datetime, id);

CREATE INDEX items_search_p2021w35_geometry_idx ON pgstac.items_search_p2021w35 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w35_pkey ON pgstac.items_search_p2021w35 USING btree (id);

CREATE INDEX items_search_p2021w35_properties_idx ON pgstac.items_search_p2021w35 USING gin (properties);

CREATE INDEX items_search_p2021w36_collection_id_idx ON pgstac.items_search_p2021w36 USING btree (collection_id);

CREATE INDEX items_search_p2021w36_datetime_id_idx ON pgstac.items_search_p2021w36 USING btree (datetime, id);

CREATE INDEX items_search_p2021w36_geometry_idx ON pgstac.items_search_p2021w36 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w36_pkey ON pgstac.items_search_p2021w36 USING btree (id);

CREATE INDEX items_search_p2021w36_properties_idx ON pgstac.items_search_p2021w36 USING gin (properties);

CREATE INDEX items_search_p2021w37_collection_id_idx ON pgstac.items_search_p2021w37 USING btree (collection_id);

CREATE INDEX items_search_p2021w37_datetime_id_idx ON pgstac.items_search_p2021w37 USING btree (datetime, id);

CREATE INDEX items_search_p2021w37_geometry_idx ON pgstac.items_search_p2021w37 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w37_pkey ON pgstac.items_search_p2021w37 USING btree (id);

CREATE INDEX items_search_p2021w37_properties_idx ON pgstac.items_search_p2021w37 USING gin (properties);

CREATE INDEX items_search_p2021w38_collection_id_idx ON pgstac.items_search_p2021w38 USING btree (collection_id);

CREATE INDEX items_search_p2021w38_datetime_id_idx ON pgstac.items_search_p2021w38 USING btree (datetime, id);

CREATE INDEX items_search_p2021w38_geometry_idx ON pgstac.items_search_p2021w38 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w38_pkey ON pgstac.items_search_p2021w38 USING btree (id);

CREATE INDEX items_search_p2021w38_properties_idx ON pgstac.items_search_p2021w38 USING gin (properties);

CREATE INDEX items_search_p2021w39_collection_id_idx ON pgstac.items_search_p2021w39 USING btree (collection_id);

CREATE INDEX items_search_p2021w39_datetime_id_idx ON pgstac.items_search_p2021w39 USING btree (datetime, id);

CREATE INDEX items_search_p2021w39_geometry_idx ON pgstac.items_search_p2021w39 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w39_pkey ON pgstac.items_search_p2021w39 USING btree (id);

CREATE INDEX items_search_p2021w39_properties_idx ON pgstac.items_search_p2021w39 USING gin (properties);

CREATE INDEX items_search_p2021w40_collection_id_idx ON pgstac.items_search_p2021w40 USING btree (collection_id);

CREATE INDEX items_search_p2021w40_datetime_id_idx ON pgstac.items_search_p2021w40 USING btree (datetime, id);

CREATE INDEX items_search_p2021w40_geometry_idx ON pgstac.items_search_p2021w40 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w40_pkey ON pgstac.items_search_p2021w40 USING btree (id);

CREATE INDEX items_search_p2021w40_properties_idx ON pgstac.items_search_p2021w40 USING gin (properties);

CREATE INDEX items_search_p2021w41_collection_id_idx ON pgstac.items_search_p2021w41 USING btree (collection_id);

CREATE INDEX items_search_p2021w41_datetime_id_idx ON pgstac.items_search_p2021w41 USING btree (datetime, id);

CREATE INDEX items_search_p2021w41_geometry_idx ON pgstac.items_search_p2021w41 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w41_pkey ON pgstac.items_search_p2021w41 USING btree (id);

CREATE INDEX items_search_p2021w41_properties_idx ON pgstac.items_search_p2021w41 USING gin (properties);

CREATE INDEX items_search_p2021w42_collection_id_idx ON pgstac.items_search_p2021w42 USING btree (collection_id);

CREATE INDEX items_search_p2021w42_datetime_id_idx ON pgstac.items_search_p2021w42 USING btree (datetime, id);

CREATE INDEX items_search_p2021w42_geometry_idx ON pgstac.items_search_p2021w42 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w42_pkey ON pgstac.items_search_p2021w42 USING btree (id);

CREATE INDEX items_search_p2021w42_properties_idx ON pgstac.items_search_p2021w42 USING gin (properties);

CREATE INDEX items_search_p2021w43_collection_id_idx ON pgstac.items_search_p2021w43 USING btree (collection_id);

CREATE INDEX items_search_p2021w43_datetime_id_idx ON pgstac.items_search_p2021w43 USING btree (datetime, id);

CREATE INDEX items_search_p2021w43_geometry_idx ON pgstac.items_search_p2021w43 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w43_pkey ON pgstac.items_search_p2021w43 USING btree (id);

CREATE INDEX items_search_p2021w43_properties_idx ON pgstac.items_search_p2021w43 USING gin (properties);

CREATE INDEX items_search_p2021w44_collection_id_idx ON pgstac.items_search_p2021w44 USING btree (collection_id);

CREATE INDEX items_search_p2021w44_datetime_id_idx ON pgstac.items_search_p2021w44 USING btree (datetime, id);

CREATE INDEX items_search_p2021w44_geometry_idx ON pgstac.items_search_p2021w44 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w44_pkey ON pgstac.items_search_p2021w44 USING btree (id);

CREATE INDEX items_search_p2021w44_properties_idx ON pgstac.items_search_p2021w44 USING gin (properties);

CREATE INDEX items_search_p2021w45_collection_id_idx ON pgstac.items_search_p2021w45 USING btree (collection_id);

CREATE INDEX items_search_p2021w45_datetime_id_idx ON pgstac.items_search_p2021w45 USING btree (datetime, id);

CREATE INDEX items_search_p2021w45_geometry_idx ON pgstac.items_search_p2021w45 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w45_pkey ON pgstac.items_search_p2021w45 USING btree (id);

CREATE INDEX items_search_p2021w45_properties_idx ON pgstac.items_search_p2021w45 USING gin (properties);

CREATE INDEX items_search_p2021w46_collection_id_idx ON pgstac.items_search_p2021w46 USING btree (collection_id);

CREATE INDEX items_search_p2021w46_datetime_id_idx ON pgstac.items_search_p2021w46 USING btree (datetime, id);

CREATE INDEX items_search_p2021w46_geometry_idx ON pgstac.items_search_p2021w46 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w46_pkey ON pgstac.items_search_p2021w46 USING btree (id);

CREATE INDEX items_search_p2021w46_properties_idx ON pgstac.items_search_p2021w46 USING gin (properties);

CREATE INDEX items_search_p2021w47_collection_id_idx ON pgstac.items_search_p2021w47 USING btree (collection_id);

CREATE INDEX items_search_p2021w47_datetime_id_idx ON pgstac.items_search_p2021w47 USING btree (datetime, id);

CREATE INDEX items_search_p2021w47_geometry_idx ON pgstac.items_search_p2021w47 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w47_pkey ON pgstac.items_search_p2021w47 USING btree (id);

CREATE INDEX items_search_p2021w47_properties_idx ON pgstac.items_search_p2021w47 USING gin (properties);

CREATE INDEX items_search_p2021w48_collection_id_idx ON pgstac.items_search_p2021w48 USING btree (collection_id);

CREATE INDEX items_search_p2021w48_datetime_id_idx ON pgstac.items_search_p2021w48 USING btree (datetime, id);

CREATE INDEX items_search_p2021w48_geometry_idx ON pgstac.items_search_p2021w48 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w48_pkey ON pgstac.items_search_p2021w48 USING btree (id);

CREATE INDEX items_search_p2021w48_properties_idx ON pgstac.items_search_p2021w48 USING gin (properties);

CREATE INDEX items_search_p2021w49_collection_id_idx ON pgstac.items_search_p2021w49 USING btree (collection_id);

CREATE INDEX items_search_p2021w49_datetime_id_idx ON pgstac.items_search_p2021w49 USING btree (datetime, id);

CREATE INDEX items_search_p2021w49_geometry_idx ON pgstac.items_search_p2021w49 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w49_pkey ON pgstac.items_search_p2021w49 USING btree (id);

CREATE INDEX items_search_p2021w49_properties_idx ON pgstac.items_search_p2021w49 USING gin (properties);

CREATE INDEX items_search_p2021w50_collection_id_idx ON pgstac.items_search_p2021w50 USING btree (collection_id);

CREATE INDEX items_search_p2021w50_datetime_id_idx ON pgstac.items_search_p2021w50 USING btree (datetime, id);

CREATE INDEX items_search_p2021w50_geometry_idx ON pgstac.items_search_p2021w50 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w50_pkey ON pgstac.items_search_p2021w50 USING btree (id);

CREATE INDEX items_search_p2021w50_properties_idx ON pgstac.items_search_p2021w50 USING gin (properties);

CREATE INDEX items_search_p2021w51_collection_id_idx ON pgstac.items_search_p2021w51 USING btree (collection_id);

CREATE INDEX items_search_p2021w51_datetime_id_idx ON pgstac.items_search_p2021w51 USING btree (datetime, id);

CREATE INDEX items_search_p2021w51_geometry_idx ON pgstac.items_search_p2021w51 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w51_pkey ON pgstac.items_search_p2021w51 USING btree (id);

CREATE INDEX items_search_p2021w51_properties_idx ON pgstac.items_search_p2021w51 USING gin (properties);

CREATE INDEX items_search_p2021w52_collection_id_idx ON pgstac.items_search_p2021w52 USING btree (collection_id);

CREATE INDEX items_search_p2021w52_datetime_id_idx ON pgstac.items_search_p2021w52 USING btree (datetime, id);

CREATE INDEX items_search_p2021w52_geometry_idx ON pgstac.items_search_p2021w52 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2021w52_pkey ON pgstac.items_search_p2021w52 USING btree (id);

CREATE INDEX items_search_p2021w52_properties_idx ON pgstac.items_search_p2021w52 USING gin (properties);

CREATE INDEX items_search_p2022w01_collection_id_idx ON pgstac.items_search_p2022w01 USING btree (collection_id);

CREATE INDEX items_search_p2022w01_datetime_id_idx ON pgstac.items_search_p2022w01 USING btree (datetime, id);

CREATE INDEX items_search_p2022w01_geometry_idx ON pgstac.items_search_p2022w01 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2022w01_pkey ON pgstac.items_search_p2022w01 USING btree (id);

CREATE INDEX items_search_p2022w01_properties_idx ON pgstac.items_search_p2022w01 USING gin (properties);

CREATE INDEX items_search_p2022w02_collection_id_idx ON pgstac.items_search_p2022w02 USING btree (collection_id);

CREATE INDEX items_search_p2022w02_datetime_id_idx ON pgstac.items_search_p2022w02 USING btree (datetime, id);

CREATE INDEX items_search_p2022w02_geometry_idx ON pgstac.items_search_p2022w02 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2022w02_pkey ON pgstac.items_search_p2022w02 USING btree (id);

CREATE INDEX items_search_p2022w02_properties_idx ON pgstac.items_search_p2022w02 USING gin (properties);

CREATE INDEX items_search_p2022w03_collection_id_idx ON pgstac.items_search_p2022w03 USING btree (collection_id);

CREATE INDEX items_search_p2022w03_datetime_id_idx ON pgstac.items_search_p2022w03 USING btree (datetime, id);

CREATE INDEX items_search_p2022w03_geometry_idx ON pgstac.items_search_p2022w03 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2022w03_pkey ON pgstac.items_search_p2022w03 USING btree (id);

CREATE INDEX items_search_p2022w03_properties_idx ON pgstac.items_search_p2022w03 USING gin (properties);

CREATE INDEX items_search_p2022w04_collection_id_idx ON pgstac.items_search_p2022w04 USING btree (collection_id);

CREATE INDEX items_search_p2022w04_datetime_id_idx ON pgstac.items_search_p2022w04 USING btree (datetime, id);

CREATE INDEX items_search_p2022w04_geometry_idx ON pgstac.items_search_p2022w04 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2022w04_pkey ON pgstac.items_search_p2022w04 USING btree (id);

CREATE INDEX items_search_p2022w04_properties_idx ON pgstac.items_search_p2022w04 USING gin (properties);

CREATE INDEX items_search_p2022w05_collection_id_idx ON pgstac.items_search_p2022w05 USING btree (collection_id);

CREATE INDEX items_search_p2022w05_datetime_id_idx ON pgstac.items_search_p2022w05 USING btree (datetime, id);

CREATE INDEX items_search_p2022w05_geometry_idx ON pgstac.items_search_p2022w05 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2022w05_pkey ON pgstac.items_search_p2022w05 USING btree (id);

CREATE INDEX items_search_p2022w05_properties_idx ON pgstac.items_search_p2022w05 USING gin (properties);

CREATE INDEX items_search_p2022w06_collection_id_idx ON pgstac.items_search_p2022w06 USING btree (collection_id);

CREATE INDEX items_search_p2022w06_datetime_id_idx ON pgstac.items_search_p2022w06 USING btree (datetime, id);

CREATE INDEX items_search_p2022w06_geometry_idx ON pgstac.items_search_p2022w06 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2022w06_pkey ON pgstac.items_search_p2022w06 USING btree (id);

CREATE INDEX items_search_p2022w06_properties_idx ON pgstac.items_search_p2022w06 USING gin (properties);

CREATE INDEX items_search_p2022w07_collection_id_idx ON pgstac.items_search_p2022w07 USING btree (collection_id);

CREATE INDEX items_search_p2022w07_datetime_id_idx ON pgstac.items_search_p2022w07 USING btree (datetime, id);

CREATE INDEX items_search_p2022w07_geometry_idx ON pgstac.items_search_p2022w07 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2022w07_pkey ON pgstac.items_search_p2022w07 USING btree (id);

CREATE INDEX items_search_p2022w07_properties_idx ON pgstac.items_search_p2022w07 USING gin (properties);

CREATE INDEX items_search_p2022w08_collection_id_idx ON pgstac.items_search_p2022w08 USING btree (collection_id);

CREATE INDEX items_search_p2022w08_datetime_id_idx ON pgstac.items_search_p2022w08 USING btree (datetime, id);

CREATE INDEX items_search_p2022w08_geometry_idx ON pgstac.items_search_p2022w08 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2022w08_pkey ON pgstac.items_search_p2022w08 USING btree (id);

CREATE INDEX items_search_p2022w08_properties_idx ON pgstac.items_search_p2022w08 USING gin (properties);

CREATE INDEX items_search_p2022w09_collection_id_idx ON pgstac.items_search_p2022w09 USING btree (collection_id);

CREATE INDEX items_search_p2022w09_datetime_id_idx ON pgstac.items_search_p2022w09 USING btree (datetime, id);

CREATE INDEX items_search_p2022w09_geometry_idx ON pgstac.items_search_p2022w09 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2022w09_pkey ON pgstac.items_search_p2022w09 USING btree (id);

CREATE INDEX items_search_p2022w09_properties_idx ON pgstac.items_search_p2022w09 USING gin (properties);

CREATE INDEX items_search_p2022w10_collection_id_idx ON pgstac.items_search_p2022w10 USING btree (collection_id);

CREATE INDEX items_search_p2022w10_datetime_id_idx ON pgstac.items_search_p2022w10 USING btree (datetime, id);

CREATE INDEX items_search_p2022w10_geometry_idx ON pgstac.items_search_p2022w10 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2022w10_pkey ON pgstac.items_search_p2022w10 USING btree (id);

CREATE INDEX items_search_p2022w10_properties_idx ON pgstac.items_search_p2022w10 USING gin (properties);

CREATE INDEX items_search_p2022w11_collection_id_idx ON pgstac.items_search_p2022w11 USING btree (collection_id);

CREATE INDEX items_search_p2022w11_datetime_id_idx ON pgstac.items_search_p2022w11 USING btree (datetime, id);

CREATE INDEX items_search_p2022w11_geometry_idx ON pgstac.items_search_p2022w11 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2022w11_pkey ON pgstac.items_search_p2022w11 USING btree (id);

CREATE INDEX items_search_p2022w11_properties_idx ON pgstac.items_search_p2022w11 USING gin (properties);

CREATE INDEX items_search_p2022w12_collection_id_idx ON pgstac.items_search_p2022w12 USING btree (collection_id);

CREATE INDEX items_search_p2022w12_datetime_id_idx ON pgstac.items_search_p2022w12 USING btree (datetime, id);

CREATE INDEX items_search_p2022w12_geometry_idx ON pgstac.items_search_p2022w12 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2022w12_pkey ON pgstac.items_search_p2022w12 USING btree (id);

CREATE INDEX items_search_p2022w12_properties_idx ON pgstac.items_search_p2022w12 USING gin (properties);

CREATE INDEX items_search_p2022w13_collection_id_idx ON pgstac.items_search_p2022w13 USING btree (collection_id);

CREATE INDEX items_search_p2022w13_datetime_id_idx ON pgstac.items_search_p2022w13 USING btree (datetime, id);

CREATE INDEX items_search_p2022w13_geometry_idx ON pgstac.items_search_p2022w13 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2022w13_pkey ON pgstac.items_search_p2022w13 USING btree (id);

CREATE INDEX items_search_p2022w13_properties_idx ON pgstac.items_search_p2022w13 USING gin (properties);

CREATE INDEX items_search_p2022w14_collection_id_idx ON pgstac.items_search_p2022w14 USING btree (collection_id);

CREATE INDEX items_search_p2022w14_datetime_id_idx ON pgstac.items_search_p2022w14 USING btree (datetime, id);

CREATE INDEX items_search_p2022w14_geometry_idx ON pgstac.items_search_p2022w14 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2022w14_pkey ON pgstac.items_search_p2022w14 USING btree (id);

CREATE INDEX items_search_p2022w14_properties_idx ON pgstac.items_search_p2022w14 USING gin (properties);

CREATE INDEX items_search_p2022w15_collection_id_idx ON pgstac.items_search_p2022w15 USING btree (collection_id);

CREATE INDEX items_search_p2022w15_datetime_id_idx ON pgstac.items_search_p2022w15 USING btree (datetime, id);

CREATE INDEX items_search_p2022w15_geometry_idx ON pgstac.items_search_p2022w15 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2022w15_pkey ON pgstac.items_search_p2022w15 USING btree (id);

CREATE INDEX items_search_p2022w15_properties_idx ON pgstac.items_search_p2022w15 USING gin (properties);

CREATE INDEX items_search_p2022w16_collection_id_idx ON pgstac.items_search_p2022w16 USING btree (collection_id);

CREATE INDEX items_search_p2022w16_datetime_id_idx ON pgstac.items_search_p2022w16 USING btree (datetime, id);

CREATE INDEX items_search_p2022w16_geometry_idx ON pgstac.items_search_p2022w16 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2022w16_pkey ON pgstac.items_search_p2022w16 USING btree (id);

CREATE INDEX items_search_p2022w16_properties_idx ON pgstac.items_search_p2022w16 USING gin (properties);

CREATE INDEX items_search_p2022w17_collection_id_idx ON pgstac.items_search_p2022w17 USING btree (collection_id);

CREATE INDEX items_search_p2022w17_datetime_id_idx ON pgstac.items_search_p2022w17 USING btree (datetime, id);

CREATE INDEX items_search_p2022w17_geometry_idx ON pgstac.items_search_p2022w17 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2022w17_pkey ON pgstac.items_search_p2022w17 USING btree (id);

CREATE INDEX items_search_p2022w17_properties_idx ON pgstac.items_search_p2022w17 USING gin (properties);

CREATE INDEX items_search_p2022w18_collection_id_idx ON pgstac.items_search_p2022w18 USING btree (collection_id);

CREATE INDEX items_search_p2022w18_datetime_id_idx ON pgstac.items_search_p2022w18 USING btree (datetime, id);

CREATE INDEX items_search_p2022w18_geometry_idx ON pgstac.items_search_p2022w18 USING gist (geometry);

CREATE UNIQUE INDEX items_search_p2022w18_pkey ON pgstac.items_search_p2022w18 USING btree (id);

CREATE INDEX items_search_p2022w18_properties_idx ON pgstac.items_search_p2022w18 USING gin (properties);

CREATE UNIQUE INDEX items_search_template_pkey ON pgstac.items_search_template USING btree (id);

CREATE INDEX properties_idx ON ONLY pgstac.items_search USING gin (properties);

alter table "pgstac"."collections" add constraint "collections_pkey" PRIMARY KEY using index "collections_pkey";

alter table "pgstac"."items" add constraint "items_pkey" PRIMARY KEY using index "items_pkey";

alter table "pgstac"."items_search_default" add constraint "items_search_default_pkey" PRIMARY KEY using index "items_search_default_pkey";

alter table "pgstac"."items_search_p1999w52" add constraint "items_search_p1999w52_pkey" PRIMARY KEY using index "items_search_p1999w52_pkey";

alter table "pgstac"."items_search_p2000w01" add constraint "items_search_p2000w01_pkey" PRIMARY KEY using index "items_search_p2000w01_pkey";

alter table "pgstac"."items_search_p2000w02" add constraint "items_search_p2000w02_pkey" PRIMARY KEY using index "items_search_p2000w02_pkey";

alter table "pgstac"."items_search_p2000w03" add constraint "items_search_p2000w03_pkey" PRIMARY KEY using index "items_search_p2000w03_pkey";

alter table "pgstac"."items_search_p2000w04" add constraint "items_search_p2000w04_pkey" PRIMARY KEY using index "items_search_p2000w04_pkey";

alter table "pgstac"."items_search_p2000w05" add constraint "items_search_p2000w05_pkey" PRIMARY KEY using index "items_search_p2000w05_pkey";

alter table "pgstac"."items_search_p2000w06" add constraint "items_search_p2000w06_pkey" PRIMARY KEY using index "items_search_p2000w06_pkey";

alter table "pgstac"."items_search_p2000w07" add constraint "items_search_p2000w07_pkey" PRIMARY KEY using index "items_search_p2000w07_pkey";

alter table "pgstac"."items_search_p2000w08" add constraint "items_search_p2000w08_pkey" PRIMARY KEY using index "items_search_p2000w08_pkey";

alter table "pgstac"."items_search_p2000w09" add constraint "items_search_p2000w09_pkey" PRIMARY KEY using index "items_search_p2000w09_pkey";

alter table "pgstac"."items_search_p2000w10" add constraint "items_search_p2000w10_pkey" PRIMARY KEY using index "items_search_p2000w10_pkey";

alter table "pgstac"."items_search_p2000w11" add constraint "items_search_p2000w11_pkey" PRIMARY KEY using index "items_search_p2000w11_pkey";

alter table "pgstac"."items_search_p2000w12" add constraint "items_search_p2000w12_pkey" PRIMARY KEY using index "items_search_p2000w12_pkey";

alter table "pgstac"."items_search_p2000w13" add constraint "items_search_p2000w13_pkey" PRIMARY KEY using index "items_search_p2000w13_pkey";

alter table "pgstac"."items_search_p2000w14" add constraint "items_search_p2000w14_pkey" PRIMARY KEY using index "items_search_p2000w14_pkey";

alter table "pgstac"."items_search_p2000w15" add constraint "items_search_p2000w15_pkey" PRIMARY KEY using index "items_search_p2000w15_pkey";

alter table "pgstac"."items_search_p2000w16" add constraint "items_search_p2000w16_pkey" PRIMARY KEY using index "items_search_p2000w16_pkey";

alter table "pgstac"."items_search_p2000w17" add constraint "items_search_p2000w17_pkey" PRIMARY KEY using index "items_search_p2000w17_pkey";

alter table "pgstac"."items_search_p2000w18" add constraint "items_search_p2000w18_pkey" PRIMARY KEY using index "items_search_p2000w18_pkey";

alter table "pgstac"."items_search_p2000w19" add constraint "items_search_p2000w19_pkey" PRIMARY KEY using index "items_search_p2000w19_pkey";

alter table "pgstac"."items_search_p2000w20" add constraint "items_search_p2000w20_pkey" PRIMARY KEY using index "items_search_p2000w20_pkey";

alter table "pgstac"."items_search_p2000w21" add constraint "items_search_p2000w21_pkey" PRIMARY KEY using index "items_search_p2000w21_pkey";

alter table "pgstac"."items_search_p2000w22" add constraint "items_search_p2000w22_pkey" PRIMARY KEY using index "items_search_p2000w22_pkey";

alter table "pgstac"."items_search_p2000w23" add constraint "items_search_p2000w23_pkey" PRIMARY KEY using index "items_search_p2000w23_pkey";

alter table "pgstac"."items_search_p2000w24" add constraint "items_search_p2000w24_pkey" PRIMARY KEY using index "items_search_p2000w24_pkey";

alter table "pgstac"."items_search_p2000w25" add constraint "items_search_p2000w25_pkey" PRIMARY KEY using index "items_search_p2000w25_pkey";

alter table "pgstac"."items_search_p2000w26" add constraint "items_search_p2000w26_pkey" PRIMARY KEY using index "items_search_p2000w26_pkey";

alter table "pgstac"."items_search_p2000w27" add constraint "items_search_p2000w27_pkey" PRIMARY KEY using index "items_search_p2000w27_pkey";

alter table "pgstac"."items_search_p2000w28" add constraint "items_search_p2000w28_pkey" PRIMARY KEY using index "items_search_p2000w28_pkey";

alter table "pgstac"."items_search_p2000w29" add constraint "items_search_p2000w29_pkey" PRIMARY KEY using index "items_search_p2000w29_pkey";

alter table "pgstac"."items_search_p2000w30" add constraint "items_search_p2000w30_pkey" PRIMARY KEY using index "items_search_p2000w30_pkey";

alter table "pgstac"."items_search_p2000w31" add constraint "items_search_p2000w31_pkey" PRIMARY KEY using index "items_search_p2000w31_pkey";

alter table "pgstac"."items_search_p2000w32" add constraint "items_search_p2000w32_pkey" PRIMARY KEY using index "items_search_p2000w32_pkey";

alter table "pgstac"."items_search_p2000w33" add constraint "items_search_p2000w33_pkey" PRIMARY KEY using index "items_search_p2000w33_pkey";

alter table "pgstac"."items_search_p2000w34" add constraint "items_search_p2000w34_pkey" PRIMARY KEY using index "items_search_p2000w34_pkey";

alter table "pgstac"."items_search_p2000w35" add constraint "items_search_p2000w35_pkey" PRIMARY KEY using index "items_search_p2000w35_pkey";

alter table "pgstac"."items_search_p2000w36" add constraint "items_search_p2000w36_pkey" PRIMARY KEY using index "items_search_p2000w36_pkey";

alter table "pgstac"."items_search_p2000w37" add constraint "items_search_p2000w37_pkey" PRIMARY KEY using index "items_search_p2000w37_pkey";

alter table "pgstac"."items_search_p2000w38" add constraint "items_search_p2000w38_pkey" PRIMARY KEY using index "items_search_p2000w38_pkey";

alter table "pgstac"."items_search_p2000w39" add constraint "items_search_p2000w39_pkey" PRIMARY KEY using index "items_search_p2000w39_pkey";

alter table "pgstac"."items_search_p2000w40" add constraint "items_search_p2000w40_pkey" PRIMARY KEY using index "items_search_p2000w40_pkey";

alter table "pgstac"."items_search_p2000w41" add constraint "items_search_p2000w41_pkey" PRIMARY KEY using index "items_search_p2000w41_pkey";

alter table "pgstac"."items_search_p2000w42" add constraint "items_search_p2000w42_pkey" PRIMARY KEY using index "items_search_p2000w42_pkey";

alter table "pgstac"."items_search_p2000w43" add constraint "items_search_p2000w43_pkey" PRIMARY KEY using index "items_search_p2000w43_pkey";

alter table "pgstac"."items_search_p2000w44" add constraint "items_search_p2000w44_pkey" PRIMARY KEY using index "items_search_p2000w44_pkey";

alter table "pgstac"."items_search_p2000w45" add constraint "items_search_p2000w45_pkey" PRIMARY KEY using index "items_search_p2000w45_pkey";

alter table "pgstac"."items_search_p2000w46" add constraint "items_search_p2000w46_pkey" PRIMARY KEY using index "items_search_p2000w46_pkey";

alter table "pgstac"."items_search_p2000w47" add constraint "items_search_p2000w47_pkey" PRIMARY KEY using index "items_search_p2000w47_pkey";

alter table "pgstac"."items_search_p2000w48" add constraint "items_search_p2000w48_pkey" PRIMARY KEY using index "items_search_p2000w48_pkey";

alter table "pgstac"."items_search_p2000w49" add constraint "items_search_p2000w49_pkey" PRIMARY KEY using index "items_search_p2000w49_pkey";

alter table "pgstac"."items_search_p2000w50" add constraint "items_search_p2000w50_pkey" PRIMARY KEY using index "items_search_p2000w50_pkey";

alter table "pgstac"."items_search_p2000w51" add constraint "items_search_p2000w51_pkey" PRIMARY KEY using index "items_search_p2000w51_pkey";

alter table "pgstac"."items_search_p2000w52" add constraint "items_search_p2000w52_pkey" PRIMARY KEY using index "items_search_p2000w52_pkey";

alter table "pgstac"."items_search_p2001w01" add constraint "items_search_p2001w01_pkey" PRIMARY KEY using index "items_search_p2001w01_pkey";

alter table "pgstac"."items_search_p2001w02" add constraint "items_search_p2001w02_pkey" PRIMARY KEY using index "items_search_p2001w02_pkey";

alter table "pgstac"."items_search_p2001w03" add constraint "items_search_p2001w03_pkey" PRIMARY KEY using index "items_search_p2001w03_pkey";

alter table "pgstac"."items_search_p2001w04" add constraint "items_search_p2001w04_pkey" PRIMARY KEY using index "items_search_p2001w04_pkey";

alter table "pgstac"."items_search_p2001w05" add constraint "items_search_p2001w05_pkey" PRIMARY KEY using index "items_search_p2001w05_pkey";

alter table "pgstac"."items_search_p2001w06" add constraint "items_search_p2001w06_pkey" PRIMARY KEY using index "items_search_p2001w06_pkey";

alter table "pgstac"."items_search_p2001w07" add constraint "items_search_p2001w07_pkey" PRIMARY KEY using index "items_search_p2001w07_pkey";

alter table "pgstac"."items_search_p2001w08" add constraint "items_search_p2001w08_pkey" PRIMARY KEY using index "items_search_p2001w08_pkey";

alter table "pgstac"."items_search_p2001w09" add constraint "items_search_p2001w09_pkey" PRIMARY KEY using index "items_search_p2001w09_pkey";

alter table "pgstac"."items_search_p2001w10" add constraint "items_search_p2001w10_pkey" PRIMARY KEY using index "items_search_p2001w10_pkey";

alter table "pgstac"."items_search_p2001w11" add constraint "items_search_p2001w11_pkey" PRIMARY KEY using index "items_search_p2001w11_pkey";

alter table "pgstac"."items_search_p2001w12" add constraint "items_search_p2001w12_pkey" PRIMARY KEY using index "items_search_p2001w12_pkey";

alter table "pgstac"."items_search_p2001w13" add constraint "items_search_p2001w13_pkey" PRIMARY KEY using index "items_search_p2001w13_pkey";

alter table "pgstac"."items_search_p2001w14" add constraint "items_search_p2001w14_pkey" PRIMARY KEY using index "items_search_p2001w14_pkey";

alter table "pgstac"."items_search_p2001w15" add constraint "items_search_p2001w15_pkey" PRIMARY KEY using index "items_search_p2001w15_pkey";

alter table "pgstac"."items_search_p2001w16" add constraint "items_search_p2001w16_pkey" PRIMARY KEY using index "items_search_p2001w16_pkey";

alter table "pgstac"."items_search_p2001w17" add constraint "items_search_p2001w17_pkey" PRIMARY KEY using index "items_search_p2001w17_pkey";

alter table "pgstac"."items_search_p2001w18" add constraint "items_search_p2001w18_pkey" PRIMARY KEY using index "items_search_p2001w18_pkey";

alter table "pgstac"."items_search_p2001w19" add constraint "items_search_p2001w19_pkey" PRIMARY KEY using index "items_search_p2001w19_pkey";

alter table "pgstac"."items_search_p2001w20" add constraint "items_search_p2001w20_pkey" PRIMARY KEY using index "items_search_p2001w20_pkey";

alter table "pgstac"."items_search_p2001w21" add constraint "items_search_p2001w21_pkey" PRIMARY KEY using index "items_search_p2001w21_pkey";

alter table "pgstac"."items_search_p2001w22" add constraint "items_search_p2001w22_pkey" PRIMARY KEY using index "items_search_p2001w22_pkey";

alter table "pgstac"."items_search_p2001w23" add constraint "items_search_p2001w23_pkey" PRIMARY KEY using index "items_search_p2001w23_pkey";

alter table "pgstac"."items_search_p2001w24" add constraint "items_search_p2001w24_pkey" PRIMARY KEY using index "items_search_p2001w24_pkey";

alter table "pgstac"."items_search_p2001w25" add constraint "items_search_p2001w25_pkey" PRIMARY KEY using index "items_search_p2001w25_pkey";

alter table "pgstac"."items_search_p2001w26" add constraint "items_search_p2001w26_pkey" PRIMARY KEY using index "items_search_p2001w26_pkey";

alter table "pgstac"."items_search_p2001w27" add constraint "items_search_p2001w27_pkey" PRIMARY KEY using index "items_search_p2001w27_pkey";

alter table "pgstac"."items_search_p2001w28" add constraint "items_search_p2001w28_pkey" PRIMARY KEY using index "items_search_p2001w28_pkey";

alter table "pgstac"."items_search_p2001w29" add constraint "items_search_p2001w29_pkey" PRIMARY KEY using index "items_search_p2001w29_pkey";

alter table "pgstac"."items_search_p2001w30" add constraint "items_search_p2001w30_pkey" PRIMARY KEY using index "items_search_p2001w30_pkey";

alter table "pgstac"."items_search_p2001w31" add constraint "items_search_p2001w31_pkey" PRIMARY KEY using index "items_search_p2001w31_pkey";

alter table "pgstac"."items_search_p2001w32" add constraint "items_search_p2001w32_pkey" PRIMARY KEY using index "items_search_p2001w32_pkey";

alter table "pgstac"."items_search_p2001w33" add constraint "items_search_p2001w33_pkey" PRIMARY KEY using index "items_search_p2001w33_pkey";

alter table "pgstac"."items_search_p2001w34" add constraint "items_search_p2001w34_pkey" PRIMARY KEY using index "items_search_p2001w34_pkey";

alter table "pgstac"."items_search_p2001w35" add constraint "items_search_p2001w35_pkey" PRIMARY KEY using index "items_search_p2001w35_pkey";

alter table "pgstac"."items_search_p2001w36" add constraint "items_search_p2001w36_pkey" PRIMARY KEY using index "items_search_p2001w36_pkey";

alter table "pgstac"."items_search_p2001w37" add constraint "items_search_p2001w37_pkey" PRIMARY KEY using index "items_search_p2001w37_pkey";

alter table "pgstac"."items_search_p2001w38" add constraint "items_search_p2001w38_pkey" PRIMARY KEY using index "items_search_p2001w38_pkey";

alter table "pgstac"."items_search_p2001w39" add constraint "items_search_p2001w39_pkey" PRIMARY KEY using index "items_search_p2001w39_pkey";

alter table "pgstac"."items_search_p2001w40" add constraint "items_search_p2001w40_pkey" PRIMARY KEY using index "items_search_p2001w40_pkey";

alter table "pgstac"."items_search_p2001w41" add constraint "items_search_p2001w41_pkey" PRIMARY KEY using index "items_search_p2001w41_pkey";

alter table "pgstac"."items_search_p2001w42" add constraint "items_search_p2001w42_pkey" PRIMARY KEY using index "items_search_p2001w42_pkey";

alter table "pgstac"."items_search_p2001w43" add constraint "items_search_p2001w43_pkey" PRIMARY KEY using index "items_search_p2001w43_pkey";

alter table "pgstac"."items_search_p2001w44" add constraint "items_search_p2001w44_pkey" PRIMARY KEY using index "items_search_p2001w44_pkey";

alter table "pgstac"."items_search_p2001w45" add constraint "items_search_p2001w45_pkey" PRIMARY KEY using index "items_search_p2001w45_pkey";

alter table "pgstac"."items_search_p2001w46" add constraint "items_search_p2001w46_pkey" PRIMARY KEY using index "items_search_p2001w46_pkey";

alter table "pgstac"."items_search_p2001w47" add constraint "items_search_p2001w47_pkey" PRIMARY KEY using index "items_search_p2001w47_pkey";

alter table "pgstac"."items_search_p2001w48" add constraint "items_search_p2001w48_pkey" PRIMARY KEY using index "items_search_p2001w48_pkey";

alter table "pgstac"."items_search_p2001w49" add constraint "items_search_p2001w49_pkey" PRIMARY KEY using index "items_search_p2001w49_pkey";

alter table "pgstac"."items_search_p2001w50" add constraint "items_search_p2001w50_pkey" PRIMARY KEY using index "items_search_p2001w50_pkey";

alter table "pgstac"."items_search_p2001w51" add constraint "items_search_p2001w51_pkey" PRIMARY KEY using index "items_search_p2001w51_pkey";

alter table "pgstac"."items_search_p2001w52" add constraint "items_search_p2001w52_pkey" PRIMARY KEY using index "items_search_p2001w52_pkey";

alter table "pgstac"."items_search_p2002w01" add constraint "items_search_p2002w01_pkey" PRIMARY KEY using index "items_search_p2002w01_pkey";

alter table "pgstac"."items_search_p2002w02" add constraint "items_search_p2002w02_pkey" PRIMARY KEY using index "items_search_p2002w02_pkey";

alter table "pgstac"."items_search_p2002w03" add constraint "items_search_p2002w03_pkey" PRIMARY KEY using index "items_search_p2002w03_pkey";

alter table "pgstac"."items_search_p2002w04" add constraint "items_search_p2002w04_pkey" PRIMARY KEY using index "items_search_p2002w04_pkey";

alter table "pgstac"."items_search_p2002w05" add constraint "items_search_p2002w05_pkey" PRIMARY KEY using index "items_search_p2002w05_pkey";

alter table "pgstac"."items_search_p2002w06" add constraint "items_search_p2002w06_pkey" PRIMARY KEY using index "items_search_p2002w06_pkey";

alter table "pgstac"."items_search_p2002w07" add constraint "items_search_p2002w07_pkey" PRIMARY KEY using index "items_search_p2002w07_pkey";

alter table "pgstac"."items_search_p2002w08" add constraint "items_search_p2002w08_pkey" PRIMARY KEY using index "items_search_p2002w08_pkey";

alter table "pgstac"."items_search_p2002w09" add constraint "items_search_p2002w09_pkey" PRIMARY KEY using index "items_search_p2002w09_pkey";

alter table "pgstac"."items_search_p2002w10" add constraint "items_search_p2002w10_pkey" PRIMARY KEY using index "items_search_p2002w10_pkey";

alter table "pgstac"."items_search_p2002w11" add constraint "items_search_p2002w11_pkey" PRIMARY KEY using index "items_search_p2002w11_pkey";

alter table "pgstac"."items_search_p2002w12" add constraint "items_search_p2002w12_pkey" PRIMARY KEY using index "items_search_p2002w12_pkey";

alter table "pgstac"."items_search_p2002w13" add constraint "items_search_p2002w13_pkey" PRIMARY KEY using index "items_search_p2002w13_pkey";

alter table "pgstac"."items_search_p2002w14" add constraint "items_search_p2002w14_pkey" PRIMARY KEY using index "items_search_p2002w14_pkey";

alter table "pgstac"."items_search_p2002w15" add constraint "items_search_p2002w15_pkey" PRIMARY KEY using index "items_search_p2002w15_pkey";

alter table "pgstac"."items_search_p2002w16" add constraint "items_search_p2002w16_pkey" PRIMARY KEY using index "items_search_p2002w16_pkey";

alter table "pgstac"."items_search_p2002w17" add constraint "items_search_p2002w17_pkey" PRIMARY KEY using index "items_search_p2002w17_pkey";

alter table "pgstac"."items_search_p2002w18" add constraint "items_search_p2002w18_pkey" PRIMARY KEY using index "items_search_p2002w18_pkey";

alter table "pgstac"."items_search_p2002w19" add constraint "items_search_p2002w19_pkey" PRIMARY KEY using index "items_search_p2002w19_pkey";

alter table "pgstac"."items_search_p2002w20" add constraint "items_search_p2002w20_pkey" PRIMARY KEY using index "items_search_p2002w20_pkey";

alter table "pgstac"."items_search_p2002w21" add constraint "items_search_p2002w21_pkey" PRIMARY KEY using index "items_search_p2002w21_pkey";

alter table "pgstac"."items_search_p2002w22" add constraint "items_search_p2002w22_pkey" PRIMARY KEY using index "items_search_p2002w22_pkey";

alter table "pgstac"."items_search_p2002w23" add constraint "items_search_p2002w23_pkey" PRIMARY KEY using index "items_search_p2002w23_pkey";

alter table "pgstac"."items_search_p2002w24" add constraint "items_search_p2002w24_pkey" PRIMARY KEY using index "items_search_p2002w24_pkey";

alter table "pgstac"."items_search_p2002w25" add constraint "items_search_p2002w25_pkey" PRIMARY KEY using index "items_search_p2002w25_pkey";

alter table "pgstac"."items_search_p2002w26" add constraint "items_search_p2002w26_pkey" PRIMARY KEY using index "items_search_p2002w26_pkey";

alter table "pgstac"."items_search_p2002w27" add constraint "items_search_p2002w27_pkey" PRIMARY KEY using index "items_search_p2002w27_pkey";

alter table "pgstac"."items_search_p2002w28" add constraint "items_search_p2002w28_pkey" PRIMARY KEY using index "items_search_p2002w28_pkey";

alter table "pgstac"."items_search_p2002w29" add constraint "items_search_p2002w29_pkey" PRIMARY KEY using index "items_search_p2002w29_pkey";

alter table "pgstac"."items_search_p2002w30" add constraint "items_search_p2002w30_pkey" PRIMARY KEY using index "items_search_p2002w30_pkey";

alter table "pgstac"."items_search_p2002w31" add constraint "items_search_p2002w31_pkey" PRIMARY KEY using index "items_search_p2002w31_pkey";

alter table "pgstac"."items_search_p2002w32" add constraint "items_search_p2002w32_pkey" PRIMARY KEY using index "items_search_p2002w32_pkey";

alter table "pgstac"."items_search_p2002w33" add constraint "items_search_p2002w33_pkey" PRIMARY KEY using index "items_search_p2002w33_pkey";

alter table "pgstac"."items_search_p2002w34" add constraint "items_search_p2002w34_pkey" PRIMARY KEY using index "items_search_p2002w34_pkey";

alter table "pgstac"."items_search_p2002w35" add constraint "items_search_p2002w35_pkey" PRIMARY KEY using index "items_search_p2002w35_pkey";

alter table "pgstac"."items_search_p2002w36" add constraint "items_search_p2002w36_pkey" PRIMARY KEY using index "items_search_p2002w36_pkey";

alter table "pgstac"."items_search_p2002w37" add constraint "items_search_p2002w37_pkey" PRIMARY KEY using index "items_search_p2002w37_pkey";

alter table "pgstac"."items_search_p2002w38" add constraint "items_search_p2002w38_pkey" PRIMARY KEY using index "items_search_p2002w38_pkey";

alter table "pgstac"."items_search_p2002w39" add constraint "items_search_p2002w39_pkey" PRIMARY KEY using index "items_search_p2002w39_pkey";

alter table "pgstac"."items_search_p2002w40" add constraint "items_search_p2002w40_pkey" PRIMARY KEY using index "items_search_p2002w40_pkey";

alter table "pgstac"."items_search_p2002w41" add constraint "items_search_p2002w41_pkey" PRIMARY KEY using index "items_search_p2002w41_pkey";

alter table "pgstac"."items_search_p2002w42" add constraint "items_search_p2002w42_pkey" PRIMARY KEY using index "items_search_p2002w42_pkey";

alter table "pgstac"."items_search_p2002w43" add constraint "items_search_p2002w43_pkey" PRIMARY KEY using index "items_search_p2002w43_pkey";

alter table "pgstac"."items_search_p2002w44" add constraint "items_search_p2002w44_pkey" PRIMARY KEY using index "items_search_p2002w44_pkey";

alter table "pgstac"."items_search_p2002w45" add constraint "items_search_p2002w45_pkey" PRIMARY KEY using index "items_search_p2002w45_pkey";

alter table "pgstac"."items_search_p2002w46" add constraint "items_search_p2002w46_pkey" PRIMARY KEY using index "items_search_p2002w46_pkey";

alter table "pgstac"."items_search_p2002w47" add constraint "items_search_p2002w47_pkey" PRIMARY KEY using index "items_search_p2002w47_pkey";

alter table "pgstac"."items_search_p2002w48" add constraint "items_search_p2002w48_pkey" PRIMARY KEY using index "items_search_p2002w48_pkey";

alter table "pgstac"."items_search_p2002w49" add constraint "items_search_p2002w49_pkey" PRIMARY KEY using index "items_search_p2002w49_pkey";

alter table "pgstac"."items_search_p2002w50" add constraint "items_search_p2002w50_pkey" PRIMARY KEY using index "items_search_p2002w50_pkey";

alter table "pgstac"."items_search_p2002w51" add constraint "items_search_p2002w51_pkey" PRIMARY KEY using index "items_search_p2002w51_pkey";

alter table "pgstac"."items_search_p2002w52" add constraint "items_search_p2002w52_pkey" PRIMARY KEY using index "items_search_p2002w52_pkey";

alter table "pgstac"."items_search_p2003w01" add constraint "items_search_p2003w01_pkey" PRIMARY KEY using index "items_search_p2003w01_pkey";

alter table "pgstac"."items_search_p2003w02" add constraint "items_search_p2003w02_pkey" PRIMARY KEY using index "items_search_p2003w02_pkey";

alter table "pgstac"."items_search_p2003w03" add constraint "items_search_p2003w03_pkey" PRIMARY KEY using index "items_search_p2003w03_pkey";

alter table "pgstac"."items_search_p2003w04" add constraint "items_search_p2003w04_pkey" PRIMARY KEY using index "items_search_p2003w04_pkey";

alter table "pgstac"."items_search_p2003w05" add constraint "items_search_p2003w05_pkey" PRIMARY KEY using index "items_search_p2003w05_pkey";

alter table "pgstac"."items_search_p2003w06" add constraint "items_search_p2003w06_pkey" PRIMARY KEY using index "items_search_p2003w06_pkey";

alter table "pgstac"."items_search_p2003w07" add constraint "items_search_p2003w07_pkey" PRIMARY KEY using index "items_search_p2003w07_pkey";

alter table "pgstac"."items_search_p2003w08" add constraint "items_search_p2003w08_pkey" PRIMARY KEY using index "items_search_p2003w08_pkey";

alter table "pgstac"."items_search_p2003w09" add constraint "items_search_p2003w09_pkey" PRIMARY KEY using index "items_search_p2003w09_pkey";

alter table "pgstac"."items_search_p2003w10" add constraint "items_search_p2003w10_pkey" PRIMARY KEY using index "items_search_p2003w10_pkey";

alter table "pgstac"."items_search_p2003w11" add constraint "items_search_p2003w11_pkey" PRIMARY KEY using index "items_search_p2003w11_pkey";

alter table "pgstac"."items_search_p2003w12" add constraint "items_search_p2003w12_pkey" PRIMARY KEY using index "items_search_p2003w12_pkey";

alter table "pgstac"."items_search_p2003w13" add constraint "items_search_p2003w13_pkey" PRIMARY KEY using index "items_search_p2003w13_pkey";

alter table "pgstac"."items_search_p2003w14" add constraint "items_search_p2003w14_pkey" PRIMARY KEY using index "items_search_p2003w14_pkey";

alter table "pgstac"."items_search_p2003w15" add constraint "items_search_p2003w15_pkey" PRIMARY KEY using index "items_search_p2003w15_pkey";

alter table "pgstac"."items_search_p2003w16" add constraint "items_search_p2003w16_pkey" PRIMARY KEY using index "items_search_p2003w16_pkey";

alter table "pgstac"."items_search_p2003w17" add constraint "items_search_p2003w17_pkey" PRIMARY KEY using index "items_search_p2003w17_pkey";

alter table "pgstac"."items_search_p2003w18" add constraint "items_search_p2003w18_pkey" PRIMARY KEY using index "items_search_p2003w18_pkey";

alter table "pgstac"."items_search_p2003w19" add constraint "items_search_p2003w19_pkey" PRIMARY KEY using index "items_search_p2003w19_pkey";

alter table "pgstac"."items_search_p2003w20" add constraint "items_search_p2003w20_pkey" PRIMARY KEY using index "items_search_p2003w20_pkey";

alter table "pgstac"."items_search_p2003w21" add constraint "items_search_p2003w21_pkey" PRIMARY KEY using index "items_search_p2003w21_pkey";

alter table "pgstac"."items_search_p2003w22" add constraint "items_search_p2003w22_pkey" PRIMARY KEY using index "items_search_p2003w22_pkey";

alter table "pgstac"."items_search_p2003w23" add constraint "items_search_p2003w23_pkey" PRIMARY KEY using index "items_search_p2003w23_pkey";

alter table "pgstac"."items_search_p2003w24" add constraint "items_search_p2003w24_pkey" PRIMARY KEY using index "items_search_p2003w24_pkey";

alter table "pgstac"."items_search_p2003w25" add constraint "items_search_p2003w25_pkey" PRIMARY KEY using index "items_search_p2003w25_pkey";

alter table "pgstac"."items_search_p2003w26" add constraint "items_search_p2003w26_pkey" PRIMARY KEY using index "items_search_p2003w26_pkey";

alter table "pgstac"."items_search_p2003w27" add constraint "items_search_p2003w27_pkey" PRIMARY KEY using index "items_search_p2003w27_pkey";

alter table "pgstac"."items_search_p2003w28" add constraint "items_search_p2003w28_pkey" PRIMARY KEY using index "items_search_p2003w28_pkey";

alter table "pgstac"."items_search_p2003w29" add constraint "items_search_p2003w29_pkey" PRIMARY KEY using index "items_search_p2003w29_pkey";

alter table "pgstac"."items_search_p2003w30" add constraint "items_search_p2003w30_pkey" PRIMARY KEY using index "items_search_p2003w30_pkey";

alter table "pgstac"."items_search_p2003w31" add constraint "items_search_p2003w31_pkey" PRIMARY KEY using index "items_search_p2003w31_pkey";

alter table "pgstac"."items_search_p2003w32" add constraint "items_search_p2003w32_pkey" PRIMARY KEY using index "items_search_p2003w32_pkey";

alter table "pgstac"."items_search_p2003w33" add constraint "items_search_p2003w33_pkey" PRIMARY KEY using index "items_search_p2003w33_pkey";

alter table "pgstac"."items_search_p2003w34" add constraint "items_search_p2003w34_pkey" PRIMARY KEY using index "items_search_p2003w34_pkey";

alter table "pgstac"."items_search_p2003w35" add constraint "items_search_p2003w35_pkey" PRIMARY KEY using index "items_search_p2003w35_pkey";

alter table "pgstac"."items_search_p2003w36" add constraint "items_search_p2003w36_pkey" PRIMARY KEY using index "items_search_p2003w36_pkey";

alter table "pgstac"."items_search_p2003w37" add constraint "items_search_p2003w37_pkey" PRIMARY KEY using index "items_search_p2003w37_pkey";

alter table "pgstac"."items_search_p2003w38" add constraint "items_search_p2003w38_pkey" PRIMARY KEY using index "items_search_p2003w38_pkey";

alter table "pgstac"."items_search_p2003w39" add constraint "items_search_p2003w39_pkey" PRIMARY KEY using index "items_search_p2003w39_pkey";

alter table "pgstac"."items_search_p2003w40" add constraint "items_search_p2003w40_pkey" PRIMARY KEY using index "items_search_p2003w40_pkey";

alter table "pgstac"."items_search_p2003w41" add constraint "items_search_p2003w41_pkey" PRIMARY KEY using index "items_search_p2003w41_pkey";

alter table "pgstac"."items_search_p2003w42" add constraint "items_search_p2003w42_pkey" PRIMARY KEY using index "items_search_p2003w42_pkey";

alter table "pgstac"."items_search_p2003w43" add constraint "items_search_p2003w43_pkey" PRIMARY KEY using index "items_search_p2003w43_pkey";

alter table "pgstac"."items_search_p2003w44" add constraint "items_search_p2003w44_pkey" PRIMARY KEY using index "items_search_p2003w44_pkey";

alter table "pgstac"."items_search_p2003w45" add constraint "items_search_p2003w45_pkey" PRIMARY KEY using index "items_search_p2003w45_pkey";

alter table "pgstac"."items_search_p2003w46" add constraint "items_search_p2003w46_pkey" PRIMARY KEY using index "items_search_p2003w46_pkey";

alter table "pgstac"."items_search_p2003w47" add constraint "items_search_p2003w47_pkey" PRIMARY KEY using index "items_search_p2003w47_pkey";

alter table "pgstac"."items_search_p2003w48" add constraint "items_search_p2003w48_pkey" PRIMARY KEY using index "items_search_p2003w48_pkey";

alter table "pgstac"."items_search_p2003w49" add constraint "items_search_p2003w49_pkey" PRIMARY KEY using index "items_search_p2003w49_pkey";

alter table "pgstac"."items_search_p2003w50" add constraint "items_search_p2003w50_pkey" PRIMARY KEY using index "items_search_p2003w50_pkey";

alter table "pgstac"."items_search_p2003w51" add constraint "items_search_p2003w51_pkey" PRIMARY KEY using index "items_search_p2003w51_pkey";

alter table "pgstac"."items_search_p2003w52" add constraint "items_search_p2003w52_pkey" PRIMARY KEY using index "items_search_p2003w52_pkey";

alter table "pgstac"."items_search_p2004w01" add constraint "items_search_p2004w01_pkey" PRIMARY KEY using index "items_search_p2004w01_pkey";

alter table "pgstac"."items_search_p2004w02" add constraint "items_search_p2004w02_pkey" PRIMARY KEY using index "items_search_p2004w02_pkey";

alter table "pgstac"."items_search_p2004w03" add constraint "items_search_p2004w03_pkey" PRIMARY KEY using index "items_search_p2004w03_pkey";

alter table "pgstac"."items_search_p2004w04" add constraint "items_search_p2004w04_pkey" PRIMARY KEY using index "items_search_p2004w04_pkey";

alter table "pgstac"."items_search_p2004w05" add constraint "items_search_p2004w05_pkey" PRIMARY KEY using index "items_search_p2004w05_pkey";

alter table "pgstac"."items_search_p2004w06" add constraint "items_search_p2004w06_pkey" PRIMARY KEY using index "items_search_p2004w06_pkey";

alter table "pgstac"."items_search_p2004w07" add constraint "items_search_p2004w07_pkey" PRIMARY KEY using index "items_search_p2004w07_pkey";

alter table "pgstac"."items_search_p2004w08" add constraint "items_search_p2004w08_pkey" PRIMARY KEY using index "items_search_p2004w08_pkey";

alter table "pgstac"."items_search_p2004w09" add constraint "items_search_p2004w09_pkey" PRIMARY KEY using index "items_search_p2004w09_pkey";

alter table "pgstac"."items_search_p2004w10" add constraint "items_search_p2004w10_pkey" PRIMARY KEY using index "items_search_p2004w10_pkey";

alter table "pgstac"."items_search_p2004w11" add constraint "items_search_p2004w11_pkey" PRIMARY KEY using index "items_search_p2004w11_pkey";

alter table "pgstac"."items_search_p2004w12" add constraint "items_search_p2004w12_pkey" PRIMARY KEY using index "items_search_p2004w12_pkey";

alter table "pgstac"."items_search_p2004w13" add constraint "items_search_p2004w13_pkey" PRIMARY KEY using index "items_search_p2004w13_pkey";

alter table "pgstac"."items_search_p2004w14" add constraint "items_search_p2004w14_pkey" PRIMARY KEY using index "items_search_p2004w14_pkey";

alter table "pgstac"."items_search_p2004w15" add constraint "items_search_p2004w15_pkey" PRIMARY KEY using index "items_search_p2004w15_pkey";

alter table "pgstac"."items_search_p2004w16" add constraint "items_search_p2004w16_pkey" PRIMARY KEY using index "items_search_p2004w16_pkey";

alter table "pgstac"."items_search_p2004w17" add constraint "items_search_p2004w17_pkey" PRIMARY KEY using index "items_search_p2004w17_pkey";

alter table "pgstac"."items_search_p2004w18" add constraint "items_search_p2004w18_pkey" PRIMARY KEY using index "items_search_p2004w18_pkey";

alter table "pgstac"."items_search_p2004w19" add constraint "items_search_p2004w19_pkey" PRIMARY KEY using index "items_search_p2004w19_pkey";

alter table "pgstac"."items_search_p2004w20" add constraint "items_search_p2004w20_pkey" PRIMARY KEY using index "items_search_p2004w20_pkey";

alter table "pgstac"."items_search_p2004w21" add constraint "items_search_p2004w21_pkey" PRIMARY KEY using index "items_search_p2004w21_pkey";

alter table "pgstac"."items_search_p2004w22" add constraint "items_search_p2004w22_pkey" PRIMARY KEY using index "items_search_p2004w22_pkey";

alter table "pgstac"."items_search_p2004w23" add constraint "items_search_p2004w23_pkey" PRIMARY KEY using index "items_search_p2004w23_pkey";

alter table "pgstac"."items_search_p2004w24" add constraint "items_search_p2004w24_pkey" PRIMARY KEY using index "items_search_p2004w24_pkey";

alter table "pgstac"."items_search_p2004w25" add constraint "items_search_p2004w25_pkey" PRIMARY KEY using index "items_search_p2004w25_pkey";

alter table "pgstac"."items_search_p2004w26" add constraint "items_search_p2004w26_pkey" PRIMARY KEY using index "items_search_p2004w26_pkey";

alter table "pgstac"."items_search_p2004w27" add constraint "items_search_p2004w27_pkey" PRIMARY KEY using index "items_search_p2004w27_pkey";

alter table "pgstac"."items_search_p2004w28" add constraint "items_search_p2004w28_pkey" PRIMARY KEY using index "items_search_p2004w28_pkey";

alter table "pgstac"."items_search_p2004w29" add constraint "items_search_p2004w29_pkey" PRIMARY KEY using index "items_search_p2004w29_pkey";

alter table "pgstac"."items_search_p2004w30" add constraint "items_search_p2004w30_pkey" PRIMARY KEY using index "items_search_p2004w30_pkey";

alter table "pgstac"."items_search_p2004w31" add constraint "items_search_p2004w31_pkey" PRIMARY KEY using index "items_search_p2004w31_pkey";

alter table "pgstac"."items_search_p2004w32" add constraint "items_search_p2004w32_pkey" PRIMARY KEY using index "items_search_p2004w32_pkey";

alter table "pgstac"."items_search_p2004w33" add constraint "items_search_p2004w33_pkey" PRIMARY KEY using index "items_search_p2004w33_pkey";

alter table "pgstac"."items_search_p2004w34" add constraint "items_search_p2004w34_pkey" PRIMARY KEY using index "items_search_p2004w34_pkey";

alter table "pgstac"."items_search_p2004w35" add constraint "items_search_p2004w35_pkey" PRIMARY KEY using index "items_search_p2004w35_pkey";

alter table "pgstac"."items_search_p2004w36" add constraint "items_search_p2004w36_pkey" PRIMARY KEY using index "items_search_p2004w36_pkey";

alter table "pgstac"."items_search_p2004w37" add constraint "items_search_p2004w37_pkey" PRIMARY KEY using index "items_search_p2004w37_pkey";

alter table "pgstac"."items_search_p2004w38" add constraint "items_search_p2004w38_pkey" PRIMARY KEY using index "items_search_p2004w38_pkey";

alter table "pgstac"."items_search_p2004w39" add constraint "items_search_p2004w39_pkey" PRIMARY KEY using index "items_search_p2004w39_pkey";

alter table "pgstac"."items_search_p2004w40" add constraint "items_search_p2004w40_pkey" PRIMARY KEY using index "items_search_p2004w40_pkey";

alter table "pgstac"."items_search_p2004w41" add constraint "items_search_p2004w41_pkey" PRIMARY KEY using index "items_search_p2004w41_pkey";

alter table "pgstac"."items_search_p2004w42" add constraint "items_search_p2004w42_pkey" PRIMARY KEY using index "items_search_p2004w42_pkey";

alter table "pgstac"."items_search_p2004w43" add constraint "items_search_p2004w43_pkey" PRIMARY KEY using index "items_search_p2004w43_pkey";

alter table "pgstac"."items_search_p2004w44" add constraint "items_search_p2004w44_pkey" PRIMARY KEY using index "items_search_p2004w44_pkey";

alter table "pgstac"."items_search_p2004w45" add constraint "items_search_p2004w45_pkey" PRIMARY KEY using index "items_search_p2004w45_pkey";

alter table "pgstac"."items_search_p2004w46" add constraint "items_search_p2004w46_pkey" PRIMARY KEY using index "items_search_p2004w46_pkey";

alter table "pgstac"."items_search_p2004w47" add constraint "items_search_p2004w47_pkey" PRIMARY KEY using index "items_search_p2004w47_pkey";

alter table "pgstac"."items_search_p2004w48" add constraint "items_search_p2004w48_pkey" PRIMARY KEY using index "items_search_p2004w48_pkey";

alter table "pgstac"."items_search_p2004w49" add constraint "items_search_p2004w49_pkey" PRIMARY KEY using index "items_search_p2004w49_pkey";

alter table "pgstac"."items_search_p2004w50" add constraint "items_search_p2004w50_pkey" PRIMARY KEY using index "items_search_p2004w50_pkey";

alter table "pgstac"."items_search_p2004w51" add constraint "items_search_p2004w51_pkey" PRIMARY KEY using index "items_search_p2004w51_pkey";

alter table "pgstac"."items_search_p2004w52" add constraint "items_search_p2004w52_pkey" PRIMARY KEY using index "items_search_p2004w52_pkey";

alter table "pgstac"."items_search_p2004w53" add constraint "items_search_p2004w53_pkey" PRIMARY KEY using index "items_search_p2004w53_pkey";

alter table "pgstac"."items_search_p2005w01" add constraint "items_search_p2005w01_pkey" PRIMARY KEY using index "items_search_p2005w01_pkey";

alter table "pgstac"."items_search_p2005w02" add constraint "items_search_p2005w02_pkey" PRIMARY KEY using index "items_search_p2005w02_pkey";

alter table "pgstac"."items_search_p2005w03" add constraint "items_search_p2005w03_pkey" PRIMARY KEY using index "items_search_p2005w03_pkey";

alter table "pgstac"."items_search_p2005w04" add constraint "items_search_p2005w04_pkey" PRIMARY KEY using index "items_search_p2005w04_pkey";

alter table "pgstac"."items_search_p2005w05" add constraint "items_search_p2005w05_pkey" PRIMARY KEY using index "items_search_p2005w05_pkey";

alter table "pgstac"."items_search_p2005w06" add constraint "items_search_p2005w06_pkey" PRIMARY KEY using index "items_search_p2005w06_pkey";

alter table "pgstac"."items_search_p2005w07" add constraint "items_search_p2005w07_pkey" PRIMARY KEY using index "items_search_p2005w07_pkey";

alter table "pgstac"."items_search_p2005w08" add constraint "items_search_p2005w08_pkey" PRIMARY KEY using index "items_search_p2005w08_pkey";

alter table "pgstac"."items_search_p2005w09" add constraint "items_search_p2005w09_pkey" PRIMARY KEY using index "items_search_p2005w09_pkey";

alter table "pgstac"."items_search_p2005w10" add constraint "items_search_p2005w10_pkey" PRIMARY KEY using index "items_search_p2005w10_pkey";

alter table "pgstac"."items_search_p2005w11" add constraint "items_search_p2005w11_pkey" PRIMARY KEY using index "items_search_p2005w11_pkey";

alter table "pgstac"."items_search_p2005w12" add constraint "items_search_p2005w12_pkey" PRIMARY KEY using index "items_search_p2005w12_pkey";

alter table "pgstac"."items_search_p2005w13" add constraint "items_search_p2005w13_pkey" PRIMARY KEY using index "items_search_p2005w13_pkey";

alter table "pgstac"."items_search_p2005w14" add constraint "items_search_p2005w14_pkey" PRIMARY KEY using index "items_search_p2005w14_pkey";

alter table "pgstac"."items_search_p2005w15" add constraint "items_search_p2005w15_pkey" PRIMARY KEY using index "items_search_p2005w15_pkey";

alter table "pgstac"."items_search_p2005w16" add constraint "items_search_p2005w16_pkey" PRIMARY KEY using index "items_search_p2005w16_pkey";

alter table "pgstac"."items_search_p2005w17" add constraint "items_search_p2005w17_pkey" PRIMARY KEY using index "items_search_p2005w17_pkey";

alter table "pgstac"."items_search_p2005w18" add constraint "items_search_p2005w18_pkey" PRIMARY KEY using index "items_search_p2005w18_pkey";

alter table "pgstac"."items_search_p2005w19" add constraint "items_search_p2005w19_pkey" PRIMARY KEY using index "items_search_p2005w19_pkey";

alter table "pgstac"."items_search_p2005w20" add constraint "items_search_p2005w20_pkey" PRIMARY KEY using index "items_search_p2005w20_pkey";

alter table "pgstac"."items_search_p2005w21" add constraint "items_search_p2005w21_pkey" PRIMARY KEY using index "items_search_p2005w21_pkey";

alter table "pgstac"."items_search_p2005w22" add constraint "items_search_p2005w22_pkey" PRIMARY KEY using index "items_search_p2005w22_pkey";

alter table "pgstac"."items_search_p2005w23" add constraint "items_search_p2005w23_pkey" PRIMARY KEY using index "items_search_p2005w23_pkey";

alter table "pgstac"."items_search_p2005w24" add constraint "items_search_p2005w24_pkey" PRIMARY KEY using index "items_search_p2005w24_pkey";

alter table "pgstac"."items_search_p2005w25" add constraint "items_search_p2005w25_pkey" PRIMARY KEY using index "items_search_p2005w25_pkey";

alter table "pgstac"."items_search_p2005w26" add constraint "items_search_p2005w26_pkey" PRIMARY KEY using index "items_search_p2005w26_pkey";

alter table "pgstac"."items_search_p2005w27" add constraint "items_search_p2005w27_pkey" PRIMARY KEY using index "items_search_p2005w27_pkey";

alter table "pgstac"."items_search_p2005w28" add constraint "items_search_p2005w28_pkey" PRIMARY KEY using index "items_search_p2005w28_pkey";

alter table "pgstac"."items_search_p2005w29" add constraint "items_search_p2005w29_pkey" PRIMARY KEY using index "items_search_p2005w29_pkey";

alter table "pgstac"."items_search_p2005w30" add constraint "items_search_p2005w30_pkey" PRIMARY KEY using index "items_search_p2005w30_pkey";

alter table "pgstac"."items_search_p2005w31" add constraint "items_search_p2005w31_pkey" PRIMARY KEY using index "items_search_p2005w31_pkey";

alter table "pgstac"."items_search_p2005w32" add constraint "items_search_p2005w32_pkey" PRIMARY KEY using index "items_search_p2005w32_pkey";

alter table "pgstac"."items_search_p2005w33" add constraint "items_search_p2005w33_pkey" PRIMARY KEY using index "items_search_p2005w33_pkey";

alter table "pgstac"."items_search_p2005w34" add constraint "items_search_p2005w34_pkey" PRIMARY KEY using index "items_search_p2005w34_pkey";

alter table "pgstac"."items_search_p2005w35" add constraint "items_search_p2005w35_pkey" PRIMARY KEY using index "items_search_p2005w35_pkey";

alter table "pgstac"."items_search_p2005w36" add constraint "items_search_p2005w36_pkey" PRIMARY KEY using index "items_search_p2005w36_pkey";

alter table "pgstac"."items_search_p2005w37" add constraint "items_search_p2005w37_pkey" PRIMARY KEY using index "items_search_p2005w37_pkey";

alter table "pgstac"."items_search_p2005w38" add constraint "items_search_p2005w38_pkey" PRIMARY KEY using index "items_search_p2005w38_pkey";

alter table "pgstac"."items_search_p2005w39" add constraint "items_search_p2005w39_pkey" PRIMARY KEY using index "items_search_p2005w39_pkey";

alter table "pgstac"."items_search_p2005w40" add constraint "items_search_p2005w40_pkey" PRIMARY KEY using index "items_search_p2005w40_pkey";

alter table "pgstac"."items_search_p2005w41" add constraint "items_search_p2005w41_pkey" PRIMARY KEY using index "items_search_p2005w41_pkey";

alter table "pgstac"."items_search_p2005w42" add constraint "items_search_p2005w42_pkey" PRIMARY KEY using index "items_search_p2005w42_pkey";

alter table "pgstac"."items_search_p2005w43" add constraint "items_search_p2005w43_pkey" PRIMARY KEY using index "items_search_p2005w43_pkey";

alter table "pgstac"."items_search_p2005w44" add constraint "items_search_p2005w44_pkey" PRIMARY KEY using index "items_search_p2005w44_pkey";

alter table "pgstac"."items_search_p2005w45" add constraint "items_search_p2005w45_pkey" PRIMARY KEY using index "items_search_p2005w45_pkey";

alter table "pgstac"."items_search_p2005w46" add constraint "items_search_p2005w46_pkey" PRIMARY KEY using index "items_search_p2005w46_pkey";

alter table "pgstac"."items_search_p2005w47" add constraint "items_search_p2005w47_pkey" PRIMARY KEY using index "items_search_p2005w47_pkey";

alter table "pgstac"."items_search_p2005w48" add constraint "items_search_p2005w48_pkey" PRIMARY KEY using index "items_search_p2005w48_pkey";

alter table "pgstac"."items_search_p2005w49" add constraint "items_search_p2005w49_pkey" PRIMARY KEY using index "items_search_p2005w49_pkey";

alter table "pgstac"."items_search_p2005w50" add constraint "items_search_p2005w50_pkey" PRIMARY KEY using index "items_search_p2005w50_pkey";

alter table "pgstac"."items_search_p2005w51" add constraint "items_search_p2005w51_pkey" PRIMARY KEY using index "items_search_p2005w51_pkey";

alter table "pgstac"."items_search_p2005w52" add constraint "items_search_p2005w52_pkey" PRIMARY KEY using index "items_search_p2005w52_pkey";

alter table "pgstac"."items_search_p2006w01" add constraint "items_search_p2006w01_pkey" PRIMARY KEY using index "items_search_p2006w01_pkey";

alter table "pgstac"."items_search_p2006w02" add constraint "items_search_p2006w02_pkey" PRIMARY KEY using index "items_search_p2006w02_pkey";

alter table "pgstac"."items_search_p2006w03" add constraint "items_search_p2006w03_pkey" PRIMARY KEY using index "items_search_p2006w03_pkey";

alter table "pgstac"."items_search_p2006w04" add constraint "items_search_p2006w04_pkey" PRIMARY KEY using index "items_search_p2006w04_pkey";

alter table "pgstac"."items_search_p2006w05" add constraint "items_search_p2006w05_pkey" PRIMARY KEY using index "items_search_p2006w05_pkey";

alter table "pgstac"."items_search_p2006w06" add constraint "items_search_p2006w06_pkey" PRIMARY KEY using index "items_search_p2006w06_pkey";

alter table "pgstac"."items_search_p2006w07" add constraint "items_search_p2006w07_pkey" PRIMARY KEY using index "items_search_p2006w07_pkey";

alter table "pgstac"."items_search_p2006w08" add constraint "items_search_p2006w08_pkey" PRIMARY KEY using index "items_search_p2006w08_pkey";

alter table "pgstac"."items_search_p2006w09" add constraint "items_search_p2006w09_pkey" PRIMARY KEY using index "items_search_p2006w09_pkey";

alter table "pgstac"."items_search_p2006w10" add constraint "items_search_p2006w10_pkey" PRIMARY KEY using index "items_search_p2006w10_pkey";

alter table "pgstac"."items_search_p2006w11" add constraint "items_search_p2006w11_pkey" PRIMARY KEY using index "items_search_p2006w11_pkey";

alter table "pgstac"."items_search_p2006w12" add constraint "items_search_p2006w12_pkey" PRIMARY KEY using index "items_search_p2006w12_pkey";

alter table "pgstac"."items_search_p2006w13" add constraint "items_search_p2006w13_pkey" PRIMARY KEY using index "items_search_p2006w13_pkey";

alter table "pgstac"."items_search_p2006w14" add constraint "items_search_p2006w14_pkey" PRIMARY KEY using index "items_search_p2006w14_pkey";

alter table "pgstac"."items_search_p2006w15" add constraint "items_search_p2006w15_pkey" PRIMARY KEY using index "items_search_p2006w15_pkey";

alter table "pgstac"."items_search_p2006w16" add constraint "items_search_p2006w16_pkey" PRIMARY KEY using index "items_search_p2006w16_pkey";

alter table "pgstac"."items_search_p2006w17" add constraint "items_search_p2006w17_pkey" PRIMARY KEY using index "items_search_p2006w17_pkey";

alter table "pgstac"."items_search_p2006w18" add constraint "items_search_p2006w18_pkey" PRIMARY KEY using index "items_search_p2006w18_pkey";

alter table "pgstac"."items_search_p2006w19" add constraint "items_search_p2006w19_pkey" PRIMARY KEY using index "items_search_p2006w19_pkey";

alter table "pgstac"."items_search_p2006w20" add constraint "items_search_p2006w20_pkey" PRIMARY KEY using index "items_search_p2006w20_pkey";

alter table "pgstac"."items_search_p2006w21" add constraint "items_search_p2006w21_pkey" PRIMARY KEY using index "items_search_p2006w21_pkey";

alter table "pgstac"."items_search_p2006w22" add constraint "items_search_p2006w22_pkey" PRIMARY KEY using index "items_search_p2006w22_pkey";

alter table "pgstac"."items_search_p2006w23" add constraint "items_search_p2006w23_pkey" PRIMARY KEY using index "items_search_p2006w23_pkey";

alter table "pgstac"."items_search_p2006w24" add constraint "items_search_p2006w24_pkey" PRIMARY KEY using index "items_search_p2006w24_pkey";

alter table "pgstac"."items_search_p2006w25" add constraint "items_search_p2006w25_pkey" PRIMARY KEY using index "items_search_p2006w25_pkey";

alter table "pgstac"."items_search_p2006w26" add constraint "items_search_p2006w26_pkey" PRIMARY KEY using index "items_search_p2006w26_pkey";

alter table "pgstac"."items_search_p2006w27" add constraint "items_search_p2006w27_pkey" PRIMARY KEY using index "items_search_p2006w27_pkey";

alter table "pgstac"."items_search_p2006w28" add constraint "items_search_p2006w28_pkey" PRIMARY KEY using index "items_search_p2006w28_pkey";

alter table "pgstac"."items_search_p2006w29" add constraint "items_search_p2006w29_pkey" PRIMARY KEY using index "items_search_p2006w29_pkey";

alter table "pgstac"."items_search_p2006w30" add constraint "items_search_p2006w30_pkey" PRIMARY KEY using index "items_search_p2006w30_pkey";

alter table "pgstac"."items_search_p2006w31" add constraint "items_search_p2006w31_pkey" PRIMARY KEY using index "items_search_p2006w31_pkey";

alter table "pgstac"."items_search_p2006w32" add constraint "items_search_p2006w32_pkey" PRIMARY KEY using index "items_search_p2006w32_pkey";

alter table "pgstac"."items_search_p2006w33" add constraint "items_search_p2006w33_pkey" PRIMARY KEY using index "items_search_p2006w33_pkey";

alter table "pgstac"."items_search_p2006w34" add constraint "items_search_p2006w34_pkey" PRIMARY KEY using index "items_search_p2006w34_pkey";

alter table "pgstac"."items_search_p2006w35" add constraint "items_search_p2006w35_pkey" PRIMARY KEY using index "items_search_p2006w35_pkey";

alter table "pgstac"."items_search_p2006w36" add constraint "items_search_p2006w36_pkey" PRIMARY KEY using index "items_search_p2006w36_pkey";

alter table "pgstac"."items_search_p2006w37" add constraint "items_search_p2006w37_pkey" PRIMARY KEY using index "items_search_p2006w37_pkey";

alter table "pgstac"."items_search_p2006w38" add constraint "items_search_p2006w38_pkey" PRIMARY KEY using index "items_search_p2006w38_pkey";

alter table "pgstac"."items_search_p2006w39" add constraint "items_search_p2006w39_pkey" PRIMARY KEY using index "items_search_p2006w39_pkey";

alter table "pgstac"."items_search_p2006w40" add constraint "items_search_p2006w40_pkey" PRIMARY KEY using index "items_search_p2006w40_pkey";

alter table "pgstac"."items_search_p2006w41" add constraint "items_search_p2006w41_pkey" PRIMARY KEY using index "items_search_p2006w41_pkey";

alter table "pgstac"."items_search_p2006w42" add constraint "items_search_p2006w42_pkey" PRIMARY KEY using index "items_search_p2006w42_pkey";

alter table "pgstac"."items_search_p2006w43" add constraint "items_search_p2006w43_pkey" PRIMARY KEY using index "items_search_p2006w43_pkey";

alter table "pgstac"."items_search_p2006w44" add constraint "items_search_p2006w44_pkey" PRIMARY KEY using index "items_search_p2006w44_pkey";

alter table "pgstac"."items_search_p2006w45" add constraint "items_search_p2006w45_pkey" PRIMARY KEY using index "items_search_p2006w45_pkey";

alter table "pgstac"."items_search_p2006w46" add constraint "items_search_p2006w46_pkey" PRIMARY KEY using index "items_search_p2006w46_pkey";

alter table "pgstac"."items_search_p2006w47" add constraint "items_search_p2006w47_pkey" PRIMARY KEY using index "items_search_p2006w47_pkey";

alter table "pgstac"."items_search_p2006w48" add constraint "items_search_p2006w48_pkey" PRIMARY KEY using index "items_search_p2006w48_pkey";

alter table "pgstac"."items_search_p2006w49" add constraint "items_search_p2006w49_pkey" PRIMARY KEY using index "items_search_p2006w49_pkey";

alter table "pgstac"."items_search_p2006w50" add constraint "items_search_p2006w50_pkey" PRIMARY KEY using index "items_search_p2006w50_pkey";

alter table "pgstac"."items_search_p2006w51" add constraint "items_search_p2006w51_pkey" PRIMARY KEY using index "items_search_p2006w51_pkey";

alter table "pgstac"."items_search_p2006w52" add constraint "items_search_p2006w52_pkey" PRIMARY KEY using index "items_search_p2006w52_pkey";

alter table "pgstac"."items_search_p2007w01" add constraint "items_search_p2007w01_pkey" PRIMARY KEY using index "items_search_p2007w01_pkey";

alter table "pgstac"."items_search_p2007w02" add constraint "items_search_p2007w02_pkey" PRIMARY KEY using index "items_search_p2007w02_pkey";

alter table "pgstac"."items_search_p2007w03" add constraint "items_search_p2007w03_pkey" PRIMARY KEY using index "items_search_p2007w03_pkey";

alter table "pgstac"."items_search_p2007w04" add constraint "items_search_p2007w04_pkey" PRIMARY KEY using index "items_search_p2007w04_pkey";

alter table "pgstac"."items_search_p2007w05" add constraint "items_search_p2007w05_pkey" PRIMARY KEY using index "items_search_p2007w05_pkey";

alter table "pgstac"."items_search_p2007w06" add constraint "items_search_p2007w06_pkey" PRIMARY KEY using index "items_search_p2007w06_pkey";

alter table "pgstac"."items_search_p2007w07" add constraint "items_search_p2007w07_pkey" PRIMARY KEY using index "items_search_p2007w07_pkey";

alter table "pgstac"."items_search_p2007w08" add constraint "items_search_p2007w08_pkey" PRIMARY KEY using index "items_search_p2007w08_pkey";

alter table "pgstac"."items_search_p2007w09" add constraint "items_search_p2007w09_pkey" PRIMARY KEY using index "items_search_p2007w09_pkey";

alter table "pgstac"."items_search_p2007w10" add constraint "items_search_p2007w10_pkey" PRIMARY KEY using index "items_search_p2007w10_pkey";

alter table "pgstac"."items_search_p2007w11" add constraint "items_search_p2007w11_pkey" PRIMARY KEY using index "items_search_p2007w11_pkey";

alter table "pgstac"."items_search_p2007w12" add constraint "items_search_p2007w12_pkey" PRIMARY KEY using index "items_search_p2007w12_pkey";

alter table "pgstac"."items_search_p2007w13" add constraint "items_search_p2007w13_pkey" PRIMARY KEY using index "items_search_p2007w13_pkey";

alter table "pgstac"."items_search_p2007w14" add constraint "items_search_p2007w14_pkey" PRIMARY KEY using index "items_search_p2007w14_pkey";

alter table "pgstac"."items_search_p2007w15" add constraint "items_search_p2007w15_pkey" PRIMARY KEY using index "items_search_p2007w15_pkey";

alter table "pgstac"."items_search_p2007w16" add constraint "items_search_p2007w16_pkey" PRIMARY KEY using index "items_search_p2007w16_pkey";

alter table "pgstac"."items_search_p2007w17" add constraint "items_search_p2007w17_pkey" PRIMARY KEY using index "items_search_p2007w17_pkey";

alter table "pgstac"."items_search_p2007w18" add constraint "items_search_p2007w18_pkey" PRIMARY KEY using index "items_search_p2007w18_pkey";

alter table "pgstac"."items_search_p2007w19" add constraint "items_search_p2007w19_pkey" PRIMARY KEY using index "items_search_p2007w19_pkey";

alter table "pgstac"."items_search_p2007w20" add constraint "items_search_p2007w20_pkey" PRIMARY KEY using index "items_search_p2007w20_pkey";

alter table "pgstac"."items_search_p2007w21" add constraint "items_search_p2007w21_pkey" PRIMARY KEY using index "items_search_p2007w21_pkey";

alter table "pgstac"."items_search_p2007w22" add constraint "items_search_p2007w22_pkey" PRIMARY KEY using index "items_search_p2007w22_pkey";

alter table "pgstac"."items_search_p2007w23" add constraint "items_search_p2007w23_pkey" PRIMARY KEY using index "items_search_p2007w23_pkey";

alter table "pgstac"."items_search_p2007w24" add constraint "items_search_p2007w24_pkey" PRIMARY KEY using index "items_search_p2007w24_pkey";

alter table "pgstac"."items_search_p2007w25" add constraint "items_search_p2007w25_pkey" PRIMARY KEY using index "items_search_p2007w25_pkey";

alter table "pgstac"."items_search_p2007w26" add constraint "items_search_p2007w26_pkey" PRIMARY KEY using index "items_search_p2007w26_pkey";

alter table "pgstac"."items_search_p2007w27" add constraint "items_search_p2007w27_pkey" PRIMARY KEY using index "items_search_p2007w27_pkey";

alter table "pgstac"."items_search_p2007w28" add constraint "items_search_p2007w28_pkey" PRIMARY KEY using index "items_search_p2007w28_pkey";

alter table "pgstac"."items_search_p2007w29" add constraint "items_search_p2007w29_pkey" PRIMARY KEY using index "items_search_p2007w29_pkey";

alter table "pgstac"."items_search_p2007w30" add constraint "items_search_p2007w30_pkey" PRIMARY KEY using index "items_search_p2007w30_pkey";

alter table "pgstac"."items_search_p2007w31" add constraint "items_search_p2007w31_pkey" PRIMARY KEY using index "items_search_p2007w31_pkey";

alter table "pgstac"."items_search_p2007w32" add constraint "items_search_p2007w32_pkey" PRIMARY KEY using index "items_search_p2007w32_pkey";

alter table "pgstac"."items_search_p2007w33" add constraint "items_search_p2007w33_pkey" PRIMARY KEY using index "items_search_p2007w33_pkey";

alter table "pgstac"."items_search_p2007w34" add constraint "items_search_p2007w34_pkey" PRIMARY KEY using index "items_search_p2007w34_pkey";

alter table "pgstac"."items_search_p2007w35" add constraint "items_search_p2007w35_pkey" PRIMARY KEY using index "items_search_p2007w35_pkey";

alter table "pgstac"."items_search_p2007w36" add constraint "items_search_p2007w36_pkey" PRIMARY KEY using index "items_search_p2007w36_pkey";

alter table "pgstac"."items_search_p2007w37" add constraint "items_search_p2007w37_pkey" PRIMARY KEY using index "items_search_p2007w37_pkey";

alter table "pgstac"."items_search_p2007w38" add constraint "items_search_p2007w38_pkey" PRIMARY KEY using index "items_search_p2007w38_pkey";

alter table "pgstac"."items_search_p2007w39" add constraint "items_search_p2007w39_pkey" PRIMARY KEY using index "items_search_p2007w39_pkey";

alter table "pgstac"."items_search_p2007w40" add constraint "items_search_p2007w40_pkey" PRIMARY KEY using index "items_search_p2007w40_pkey";

alter table "pgstac"."items_search_p2007w41" add constraint "items_search_p2007w41_pkey" PRIMARY KEY using index "items_search_p2007w41_pkey";

alter table "pgstac"."items_search_p2007w42" add constraint "items_search_p2007w42_pkey" PRIMARY KEY using index "items_search_p2007w42_pkey";

alter table "pgstac"."items_search_p2007w43" add constraint "items_search_p2007w43_pkey" PRIMARY KEY using index "items_search_p2007w43_pkey";

alter table "pgstac"."items_search_p2007w44" add constraint "items_search_p2007w44_pkey" PRIMARY KEY using index "items_search_p2007w44_pkey";

alter table "pgstac"."items_search_p2007w45" add constraint "items_search_p2007w45_pkey" PRIMARY KEY using index "items_search_p2007w45_pkey";

alter table "pgstac"."items_search_p2007w46" add constraint "items_search_p2007w46_pkey" PRIMARY KEY using index "items_search_p2007w46_pkey";

alter table "pgstac"."items_search_p2007w47" add constraint "items_search_p2007w47_pkey" PRIMARY KEY using index "items_search_p2007w47_pkey";

alter table "pgstac"."items_search_p2007w48" add constraint "items_search_p2007w48_pkey" PRIMARY KEY using index "items_search_p2007w48_pkey";

alter table "pgstac"."items_search_p2007w49" add constraint "items_search_p2007w49_pkey" PRIMARY KEY using index "items_search_p2007w49_pkey";

alter table "pgstac"."items_search_p2007w50" add constraint "items_search_p2007w50_pkey" PRIMARY KEY using index "items_search_p2007w50_pkey";

alter table "pgstac"."items_search_p2007w51" add constraint "items_search_p2007w51_pkey" PRIMARY KEY using index "items_search_p2007w51_pkey";

alter table "pgstac"."items_search_p2007w52" add constraint "items_search_p2007w52_pkey" PRIMARY KEY using index "items_search_p2007w52_pkey";

alter table "pgstac"."items_search_p2008w01" add constraint "items_search_p2008w01_pkey" PRIMARY KEY using index "items_search_p2008w01_pkey";

alter table "pgstac"."items_search_p2008w02" add constraint "items_search_p2008w02_pkey" PRIMARY KEY using index "items_search_p2008w02_pkey";

alter table "pgstac"."items_search_p2008w03" add constraint "items_search_p2008w03_pkey" PRIMARY KEY using index "items_search_p2008w03_pkey";

alter table "pgstac"."items_search_p2008w04" add constraint "items_search_p2008w04_pkey" PRIMARY KEY using index "items_search_p2008w04_pkey";

alter table "pgstac"."items_search_p2008w05" add constraint "items_search_p2008w05_pkey" PRIMARY KEY using index "items_search_p2008w05_pkey";

alter table "pgstac"."items_search_p2008w06" add constraint "items_search_p2008w06_pkey" PRIMARY KEY using index "items_search_p2008w06_pkey";

alter table "pgstac"."items_search_p2008w07" add constraint "items_search_p2008w07_pkey" PRIMARY KEY using index "items_search_p2008w07_pkey";

alter table "pgstac"."items_search_p2008w08" add constraint "items_search_p2008w08_pkey" PRIMARY KEY using index "items_search_p2008w08_pkey";

alter table "pgstac"."items_search_p2008w09" add constraint "items_search_p2008w09_pkey" PRIMARY KEY using index "items_search_p2008w09_pkey";

alter table "pgstac"."items_search_p2008w10" add constraint "items_search_p2008w10_pkey" PRIMARY KEY using index "items_search_p2008w10_pkey";

alter table "pgstac"."items_search_p2008w11" add constraint "items_search_p2008w11_pkey" PRIMARY KEY using index "items_search_p2008w11_pkey";

alter table "pgstac"."items_search_p2008w12" add constraint "items_search_p2008w12_pkey" PRIMARY KEY using index "items_search_p2008w12_pkey";

alter table "pgstac"."items_search_p2008w13" add constraint "items_search_p2008w13_pkey" PRIMARY KEY using index "items_search_p2008w13_pkey";

alter table "pgstac"."items_search_p2008w14" add constraint "items_search_p2008w14_pkey" PRIMARY KEY using index "items_search_p2008w14_pkey";

alter table "pgstac"."items_search_p2008w15" add constraint "items_search_p2008w15_pkey" PRIMARY KEY using index "items_search_p2008w15_pkey";

alter table "pgstac"."items_search_p2008w16" add constraint "items_search_p2008w16_pkey" PRIMARY KEY using index "items_search_p2008w16_pkey";

alter table "pgstac"."items_search_p2008w17" add constraint "items_search_p2008w17_pkey" PRIMARY KEY using index "items_search_p2008w17_pkey";

alter table "pgstac"."items_search_p2008w18" add constraint "items_search_p2008w18_pkey" PRIMARY KEY using index "items_search_p2008w18_pkey";

alter table "pgstac"."items_search_p2008w19" add constraint "items_search_p2008w19_pkey" PRIMARY KEY using index "items_search_p2008w19_pkey";

alter table "pgstac"."items_search_p2008w20" add constraint "items_search_p2008w20_pkey" PRIMARY KEY using index "items_search_p2008w20_pkey";

alter table "pgstac"."items_search_p2008w21" add constraint "items_search_p2008w21_pkey" PRIMARY KEY using index "items_search_p2008w21_pkey";

alter table "pgstac"."items_search_p2008w22" add constraint "items_search_p2008w22_pkey" PRIMARY KEY using index "items_search_p2008w22_pkey";

alter table "pgstac"."items_search_p2008w23" add constraint "items_search_p2008w23_pkey" PRIMARY KEY using index "items_search_p2008w23_pkey";

alter table "pgstac"."items_search_p2008w24" add constraint "items_search_p2008w24_pkey" PRIMARY KEY using index "items_search_p2008w24_pkey";

alter table "pgstac"."items_search_p2008w25" add constraint "items_search_p2008w25_pkey" PRIMARY KEY using index "items_search_p2008w25_pkey";

alter table "pgstac"."items_search_p2008w26" add constraint "items_search_p2008w26_pkey" PRIMARY KEY using index "items_search_p2008w26_pkey";

alter table "pgstac"."items_search_p2008w27" add constraint "items_search_p2008w27_pkey" PRIMARY KEY using index "items_search_p2008w27_pkey";

alter table "pgstac"."items_search_p2008w28" add constraint "items_search_p2008w28_pkey" PRIMARY KEY using index "items_search_p2008w28_pkey";

alter table "pgstac"."items_search_p2008w29" add constraint "items_search_p2008w29_pkey" PRIMARY KEY using index "items_search_p2008w29_pkey";

alter table "pgstac"."items_search_p2008w30" add constraint "items_search_p2008w30_pkey" PRIMARY KEY using index "items_search_p2008w30_pkey";

alter table "pgstac"."items_search_p2008w31" add constraint "items_search_p2008w31_pkey" PRIMARY KEY using index "items_search_p2008w31_pkey";

alter table "pgstac"."items_search_p2008w32" add constraint "items_search_p2008w32_pkey" PRIMARY KEY using index "items_search_p2008w32_pkey";

alter table "pgstac"."items_search_p2008w33" add constraint "items_search_p2008w33_pkey" PRIMARY KEY using index "items_search_p2008w33_pkey";

alter table "pgstac"."items_search_p2008w34" add constraint "items_search_p2008w34_pkey" PRIMARY KEY using index "items_search_p2008w34_pkey";

alter table "pgstac"."items_search_p2008w35" add constraint "items_search_p2008w35_pkey" PRIMARY KEY using index "items_search_p2008w35_pkey";

alter table "pgstac"."items_search_p2008w36" add constraint "items_search_p2008w36_pkey" PRIMARY KEY using index "items_search_p2008w36_pkey";

alter table "pgstac"."items_search_p2008w37" add constraint "items_search_p2008w37_pkey" PRIMARY KEY using index "items_search_p2008w37_pkey";

alter table "pgstac"."items_search_p2008w38" add constraint "items_search_p2008w38_pkey" PRIMARY KEY using index "items_search_p2008w38_pkey";

alter table "pgstac"."items_search_p2008w39" add constraint "items_search_p2008w39_pkey" PRIMARY KEY using index "items_search_p2008w39_pkey";

alter table "pgstac"."items_search_p2008w40" add constraint "items_search_p2008w40_pkey" PRIMARY KEY using index "items_search_p2008w40_pkey";

alter table "pgstac"."items_search_p2008w41" add constraint "items_search_p2008w41_pkey" PRIMARY KEY using index "items_search_p2008w41_pkey";

alter table "pgstac"."items_search_p2008w42" add constraint "items_search_p2008w42_pkey" PRIMARY KEY using index "items_search_p2008w42_pkey";

alter table "pgstac"."items_search_p2008w43" add constraint "items_search_p2008w43_pkey" PRIMARY KEY using index "items_search_p2008w43_pkey";

alter table "pgstac"."items_search_p2008w44" add constraint "items_search_p2008w44_pkey" PRIMARY KEY using index "items_search_p2008w44_pkey";

alter table "pgstac"."items_search_p2008w45" add constraint "items_search_p2008w45_pkey" PRIMARY KEY using index "items_search_p2008w45_pkey";

alter table "pgstac"."items_search_p2008w46" add constraint "items_search_p2008w46_pkey" PRIMARY KEY using index "items_search_p2008w46_pkey";

alter table "pgstac"."items_search_p2008w47" add constraint "items_search_p2008w47_pkey" PRIMARY KEY using index "items_search_p2008w47_pkey";

alter table "pgstac"."items_search_p2008w48" add constraint "items_search_p2008w48_pkey" PRIMARY KEY using index "items_search_p2008w48_pkey";

alter table "pgstac"."items_search_p2008w49" add constraint "items_search_p2008w49_pkey" PRIMARY KEY using index "items_search_p2008w49_pkey";

alter table "pgstac"."items_search_p2008w50" add constraint "items_search_p2008w50_pkey" PRIMARY KEY using index "items_search_p2008w50_pkey";

alter table "pgstac"."items_search_p2008w51" add constraint "items_search_p2008w51_pkey" PRIMARY KEY using index "items_search_p2008w51_pkey";

alter table "pgstac"."items_search_p2008w52" add constraint "items_search_p2008w52_pkey" PRIMARY KEY using index "items_search_p2008w52_pkey";

alter table "pgstac"."items_search_p2009w01" add constraint "items_search_p2009w01_pkey" PRIMARY KEY using index "items_search_p2009w01_pkey";

alter table "pgstac"."items_search_p2009w02" add constraint "items_search_p2009w02_pkey" PRIMARY KEY using index "items_search_p2009w02_pkey";

alter table "pgstac"."items_search_p2009w03" add constraint "items_search_p2009w03_pkey" PRIMARY KEY using index "items_search_p2009w03_pkey";

alter table "pgstac"."items_search_p2009w04" add constraint "items_search_p2009w04_pkey" PRIMARY KEY using index "items_search_p2009w04_pkey";

alter table "pgstac"."items_search_p2009w05" add constraint "items_search_p2009w05_pkey" PRIMARY KEY using index "items_search_p2009w05_pkey";

alter table "pgstac"."items_search_p2009w06" add constraint "items_search_p2009w06_pkey" PRIMARY KEY using index "items_search_p2009w06_pkey";

alter table "pgstac"."items_search_p2009w07" add constraint "items_search_p2009w07_pkey" PRIMARY KEY using index "items_search_p2009w07_pkey";

alter table "pgstac"."items_search_p2009w08" add constraint "items_search_p2009w08_pkey" PRIMARY KEY using index "items_search_p2009w08_pkey";

alter table "pgstac"."items_search_p2009w09" add constraint "items_search_p2009w09_pkey" PRIMARY KEY using index "items_search_p2009w09_pkey";

alter table "pgstac"."items_search_p2009w10" add constraint "items_search_p2009w10_pkey" PRIMARY KEY using index "items_search_p2009w10_pkey";

alter table "pgstac"."items_search_p2009w11" add constraint "items_search_p2009w11_pkey" PRIMARY KEY using index "items_search_p2009w11_pkey";

alter table "pgstac"."items_search_p2009w12" add constraint "items_search_p2009w12_pkey" PRIMARY KEY using index "items_search_p2009w12_pkey";

alter table "pgstac"."items_search_p2009w13" add constraint "items_search_p2009w13_pkey" PRIMARY KEY using index "items_search_p2009w13_pkey";

alter table "pgstac"."items_search_p2009w14" add constraint "items_search_p2009w14_pkey" PRIMARY KEY using index "items_search_p2009w14_pkey";

alter table "pgstac"."items_search_p2009w15" add constraint "items_search_p2009w15_pkey" PRIMARY KEY using index "items_search_p2009w15_pkey";

alter table "pgstac"."items_search_p2009w16" add constraint "items_search_p2009w16_pkey" PRIMARY KEY using index "items_search_p2009w16_pkey";

alter table "pgstac"."items_search_p2009w17" add constraint "items_search_p2009w17_pkey" PRIMARY KEY using index "items_search_p2009w17_pkey";

alter table "pgstac"."items_search_p2009w18" add constraint "items_search_p2009w18_pkey" PRIMARY KEY using index "items_search_p2009w18_pkey";

alter table "pgstac"."items_search_p2009w19" add constraint "items_search_p2009w19_pkey" PRIMARY KEY using index "items_search_p2009w19_pkey";

alter table "pgstac"."items_search_p2009w20" add constraint "items_search_p2009w20_pkey" PRIMARY KEY using index "items_search_p2009w20_pkey";

alter table "pgstac"."items_search_p2009w21" add constraint "items_search_p2009w21_pkey" PRIMARY KEY using index "items_search_p2009w21_pkey";

alter table "pgstac"."items_search_p2009w22" add constraint "items_search_p2009w22_pkey" PRIMARY KEY using index "items_search_p2009w22_pkey";

alter table "pgstac"."items_search_p2009w23" add constraint "items_search_p2009w23_pkey" PRIMARY KEY using index "items_search_p2009w23_pkey";

alter table "pgstac"."items_search_p2009w24" add constraint "items_search_p2009w24_pkey" PRIMARY KEY using index "items_search_p2009w24_pkey";

alter table "pgstac"."items_search_p2009w25" add constraint "items_search_p2009w25_pkey" PRIMARY KEY using index "items_search_p2009w25_pkey";

alter table "pgstac"."items_search_p2009w26" add constraint "items_search_p2009w26_pkey" PRIMARY KEY using index "items_search_p2009w26_pkey";

alter table "pgstac"."items_search_p2009w27" add constraint "items_search_p2009w27_pkey" PRIMARY KEY using index "items_search_p2009w27_pkey";

alter table "pgstac"."items_search_p2009w28" add constraint "items_search_p2009w28_pkey" PRIMARY KEY using index "items_search_p2009w28_pkey";

alter table "pgstac"."items_search_p2009w29" add constraint "items_search_p2009w29_pkey" PRIMARY KEY using index "items_search_p2009w29_pkey";

alter table "pgstac"."items_search_p2009w30" add constraint "items_search_p2009w30_pkey" PRIMARY KEY using index "items_search_p2009w30_pkey";

alter table "pgstac"."items_search_p2009w31" add constraint "items_search_p2009w31_pkey" PRIMARY KEY using index "items_search_p2009w31_pkey";

alter table "pgstac"."items_search_p2009w32" add constraint "items_search_p2009w32_pkey" PRIMARY KEY using index "items_search_p2009w32_pkey";

alter table "pgstac"."items_search_p2009w33" add constraint "items_search_p2009w33_pkey" PRIMARY KEY using index "items_search_p2009w33_pkey";

alter table "pgstac"."items_search_p2009w34" add constraint "items_search_p2009w34_pkey" PRIMARY KEY using index "items_search_p2009w34_pkey";

alter table "pgstac"."items_search_p2009w35" add constraint "items_search_p2009w35_pkey" PRIMARY KEY using index "items_search_p2009w35_pkey";

alter table "pgstac"."items_search_p2009w36" add constraint "items_search_p2009w36_pkey" PRIMARY KEY using index "items_search_p2009w36_pkey";

alter table "pgstac"."items_search_p2009w37" add constraint "items_search_p2009w37_pkey" PRIMARY KEY using index "items_search_p2009w37_pkey";

alter table "pgstac"."items_search_p2009w38" add constraint "items_search_p2009w38_pkey" PRIMARY KEY using index "items_search_p2009w38_pkey";

alter table "pgstac"."items_search_p2009w39" add constraint "items_search_p2009w39_pkey" PRIMARY KEY using index "items_search_p2009w39_pkey";

alter table "pgstac"."items_search_p2009w40" add constraint "items_search_p2009w40_pkey" PRIMARY KEY using index "items_search_p2009w40_pkey";

alter table "pgstac"."items_search_p2009w41" add constraint "items_search_p2009w41_pkey" PRIMARY KEY using index "items_search_p2009w41_pkey";

alter table "pgstac"."items_search_p2009w42" add constraint "items_search_p2009w42_pkey" PRIMARY KEY using index "items_search_p2009w42_pkey";

alter table "pgstac"."items_search_p2009w43" add constraint "items_search_p2009w43_pkey" PRIMARY KEY using index "items_search_p2009w43_pkey";

alter table "pgstac"."items_search_p2009w44" add constraint "items_search_p2009w44_pkey" PRIMARY KEY using index "items_search_p2009w44_pkey";

alter table "pgstac"."items_search_p2009w45" add constraint "items_search_p2009w45_pkey" PRIMARY KEY using index "items_search_p2009w45_pkey";

alter table "pgstac"."items_search_p2009w46" add constraint "items_search_p2009w46_pkey" PRIMARY KEY using index "items_search_p2009w46_pkey";

alter table "pgstac"."items_search_p2009w47" add constraint "items_search_p2009w47_pkey" PRIMARY KEY using index "items_search_p2009w47_pkey";

alter table "pgstac"."items_search_p2009w48" add constraint "items_search_p2009w48_pkey" PRIMARY KEY using index "items_search_p2009w48_pkey";

alter table "pgstac"."items_search_p2009w49" add constraint "items_search_p2009w49_pkey" PRIMARY KEY using index "items_search_p2009w49_pkey";

alter table "pgstac"."items_search_p2009w50" add constraint "items_search_p2009w50_pkey" PRIMARY KEY using index "items_search_p2009w50_pkey";

alter table "pgstac"."items_search_p2009w51" add constraint "items_search_p2009w51_pkey" PRIMARY KEY using index "items_search_p2009w51_pkey";

alter table "pgstac"."items_search_p2009w52" add constraint "items_search_p2009w52_pkey" PRIMARY KEY using index "items_search_p2009w52_pkey";

alter table "pgstac"."items_search_p2009w53" add constraint "items_search_p2009w53_pkey" PRIMARY KEY using index "items_search_p2009w53_pkey";

alter table "pgstac"."items_search_p2010w01" add constraint "items_search_p2010w01_pkey" PRIMARY KEY using index "items_search_p2010w01_pkey";

alter table "pgstac"."items_search_p2010w02" add constraint "items_search_p2010w02_pkey" PRIMARY KEY using index "items_search_p2010w02_pkey";

alter table "pgstac"."items_search_p2010w03" add constraint "items_search_p2010w03_pkey" PRIMARY KEY using index "items_search_p2010w03_pkey";

alter table "pgstac"."items_search_p2010w04" add constraint "items_search_p2010w04_pkey" PRIMARY KEY using index "items_search_p2010w04_pkey";

alter table "pgstac"."items_search_p2010w05" add constraint "items_search_p2010w05_pkey" PRIMARY KEY using index "items_search_p2010w05_pkey";

alter table "pgstac"."items_search_p2010w06" add constraint "items_search_p2010w06_pkey" PRIMARY KEY using index "items_search_p2010w06_pkey";

alter table "pgstac"."items_search_p2010w07" add constraint "items_search_p2010w07_pkey" PRIMARY KEY using index "items_search_p2010w07_pkey";

alter table "pgstac"."items_search_p2010w08" add constraint "items_search_p2010w08_pkey" PRIMARY KEY using index "items_search_p2010w08_pkey";

alter table "pgstac"."items_search_p2010w09" add constraint "items_search_p2010w09_pkey" PRIMARY KEY using index "items_search_p2010w09_pkey";

alter table "pgstac"."items_search_p2010w10" add constraint "items_search_p2010w10_pkey" PRIMARY KEY using index "items_search_p2010w10_pkey";

alter table "pgstac"."items_search_p2010w11" add constraint "items_search_p2010w11_pkey" PRIMARY KEY using index "items_search_p2010w11_pkey";

alter table "pgstac"."items_search_p2010w12" add constraint "items_search_p2010w12_pkey" PRIMARY KEY using index "items_search_p2010w12_pkey";

alter table "pgstac"."items_search_p2010w13" add constraint "items_search_p2010w13_pkey" PRIMARY KEY using index "items_search_p2010w13_pkey";

alter table "pgstac"."items_search_p2010w14" add constraint "items_search_p2010w14_pkey" PRIMARY KEY using index "items_search_p2010w14_pkey";

alter table "pgstac"."items_search_p2010w15" add constraint "items_search_p2010w15_pkey" PRIMARY KEY using index "items_search_p2010w15_pkey";

alter table "pgstac"."items_search_p2010w16" add constraint "items_search_p2010w16_pkey" PRIMARY KEY using index "items_search_p2010w16_pkey";

alter table "pgstac"."items_search_p2010w17" add constraint "items_search_p2010w17_pkey" PRIMARY KEY using index "items_search_p2010w17_pkey";

alter table "pgstac"."items_search_p2010w18" add constraint "items_search_p2010w18_pkey" PRIMARY KEY using index "items_search_p2010w18_pkey";

alter table "pgstac"."items_search_p2010w19" add constraint "items_search_p2010w19_pkey" PRIMARY KEY using index "items_search_p2010w19_pkey";

alter table "pgstac"."items_search_p2010w20" add constraint "items_search_p2010w20_pkey" PRIMARY KEY using index "items_search_p2010w20_pkey";

alter table "pgstac"."items_search_p2010w21" add constraint "items_search_p2010w21_pkey" PRIMARY KEY using index "items_search_p2010w21_pkey";

alter table "pgstac"."items_search_p2010w22" add constraint "items_search_p2010w22_pkey" PRIMARY KEY using index "items_search_p2010w22_pkey";

alter table "pgstac"."items_search_p2010w23" add constraint "items_search_p2010w23_pkey" PRIMARY KEY using index "items_search_p2010w23_pkey";

alter table "pgstac"."items_search_p2010w24" add constraint "items_search_p2010w24_pkey" PRIMARY KEY using index "items_search_p2010w24_pkey";

alter table "pgstac"."items_search_p2010w25" add constraint "items_search_p2010w25_pkey" PRIMARY KEY using index "items_search_p2010w25_pkey";

alter table "pgstac"."items_search_p2010w26" add constraint "items_search_p2010w26_pkey" PRIMARY KEY using index "items_search_p2010w26_pkey";

alter table "pgstac"."items_search_p2010w27" add constraint "items_search_p2010w27_pkey" PRIMARY KEY using index "items_search_p2010w27_pkey";

alter table "pgstac"."items_search_p2010w28" add constraint "items_search_p2010w28_pkey" PRIMARY KEY using index "items_search_p2010w28_pkey";

alter table "pgstac"."items_search_p2010w29" add constraint "items_search_p2010w29_pkey" PRIMARY KEY using index "items_search_p2010w29_pkey";

alter table "pgstac"."items_search_p2010w30" add constraint "items_search_p2010w30_pkey" PRIMARY KEY using index "items_search_p2010w30_pkey";

alter table "pgstac"."items_search_p2010w31" add constraint "items_search_p2010w31_pkey" PRIMARY KEY using index "items_search_p2010w31_pkey";

alter table "pgstac"."items_search_p2010w32" add constraint "items_search_p2010w32_pkey" PRIMARY KEY using index "items_search_p2010w32_pkey";

alter table "pgstac"."items_search_p2010w33" add constraint "items_search_p2010w33_pkey" PRIMARY KEY using index "items_search_p2010w33_pkey";

alter table "pgstac"."items_search_p2010w34" add constraint "items_search_p2010w34_pkey" PRIMARY KEY using index "items_search_p2010w34_pkey";

alter table "pgstac"."items_search_p2010w35" add constraint "items_search_p2010w35_pkey" PRIMARY KEY using index "items_search_p2010w35_pkey";

alter table "pgstac"."items_search_p2010w36" add constraint "items_search_p2010w36_pkey" PRIMARY KEY using index "items_search_p2010w36_pkey";

alter table "pgstac"."items_search_p2010w37" add constraint "items_search_p2010w37_pkey" PRIMARY KEY using index "items_search_p2010w37_pkey";

alter table "pgstac"."items_search_p2010w38" add constraint "items_search_p2010w38_pkey" PRIMARY KEY using index "items_search_p2010w38_pkey";

alter table "pgstac"."items_search_p2010w39" add constraint "items_search_p2010w39_pkey" PRIMARY KEY using index "items_search_p2010w39_pkey";

alter table "pgstac"."items_search_p2010w40" add constraint "items_search_p2010w40_pkey" PRIMARY KEY using index "items_search_p2010w40_pkey";

alter table "pgstac"."items_search_p2010w41" add constraint "items_search_p2010w41_pkey" PRIMARY KEY using index "items_search_p2010w41_pkey";

alter table "pgstac"."items_search_p2010w42" add constraint "items_search_p2010w42_pkey" PRIMARY KEY using index "items_search_p2010w42_pkey";

alter table "pgstac"."items_search_p2010w43" add constraint "items_search_p2010w43_pkey" PRIMARY KEY using index "items_search_p2010w43_pkey";

alter table "pgstac"."items_search_p2010w44" add constraint "items_search_p2010w44_pkey" PRIMARY KEY using index "items_search_p2010w44_pkey";

alter table "pgstac"."items_search_p2010w45" add constraint "items_search_p2010w45_pkey" PRIMARY KEY using index "items_search_p2010w45_pkey";

alter table "pgstac"."items_search_p2010w46" add constraint "items_search_p2010w46_pkey" PRIMARY KEY using index "items_search_p2010w46_pkey";

alter table "pgstac"."items_search_p2010w47" add constraint "items_search_p2010w47_pkey" PRIMARY KEY using index "items_search_p2010w47_pkey";

alter table "pgstac"."items_search_p2010w48" add constraint "items_search_p2010w48_pkey" PRIMARY KEY using index "items_search_p2010w48_pkey";

alter table "pgstac"."items_search_p2010w49" add constraint "items_search_p2010w49_pkey" PRIMARY KEY using index "items_search_p2010w49_pkey";

alter table "pgstac"."items_search_p2010w50" add constraint "items_search_p2010w50_pkey" PRIMARY KEY using index "items_search_p2010w50_pkey";

alter table "pgstac"."items_search_p2010w51" add constraint "items_search_p2010w51_pkey" PRIMARY KEY using index "items_search_p2010w51_pkey";

alter table "pgstac"."items_search_p2010w52" add constraint "items_search_p2010w52_pkey" PRIMARY KEY using index "items_search_p2010w52_pkey";

alter table "pgstac"."items_search_p2011w01" add constraint "items_search_p2011w01_pkey" PRIMARY KEY using index "items_search_p2011w01_pkey";

alter table "pgstac"."items_search_p2011w02" add constraint "items_search_p2011w02_pkey" PRIMARY KEY using index "items_search_p2011w02_pkey";

alter table "pgstac"."items_search_p2011w03" add constraint "items_search_p2011w03_pkey" PRIMARY KEY using index "items_search_p2011w03_pkey";

alter table "pgstac"."items_search_p2011w04" add constraint "items_search_p2011w04_pkey" PRIMARY KEY using index "items_search_p2011w04_pkey";

alter table "pgstac"."items_search_p2011w05" add constraint "items_search_p2011w05_pkey" PRIMARY KEY using index "items_search_p2011w05_pkey";

alter table "pgstac"."items_search_p2011w06" add constraint "items_search_p2011w06_pkey" PRIMARY KEY using index "items_search_p2011w06_pkey";

alter table "pgstac"."items_search_p2011w07" add constraint "items_search_p2011w07_pkey" PRIMARY KEY using index "items_search_p2011w07_pkey";

alter table "pgstac"."items_search_p2011w08" add constraint "items_search_p2011w08_pkey" PRIMARY KEY using index "items_search_p2011w08_pkey";

alter table "pgstac"."items_search_p2011w09" add constraint "items_search_p2011w09_pkey" PRIMARY KEY using index "items_search_p2011w09_pkey";

alter table "pgstac"."items_search_p2011w10" add constraint "items_search_p2011w10_pkey" PRIMARY KEY using index "items_search_p2011w10_pkey";

alter table "pgstac"."items_search_p2011w11" add constraint "items_search_p2011w11_pkey" PRIMARY KEY using index "items_search_p2011w11_pkey";

alter table "pgstac"."items_search_p2011w12" add constraint "items_search_p2011w12_pkey" PRIMARY KEY using index "items_search_p2011w12_pkey";

alter table "pgstac"."items_search_p2011w13" add constraint "items_search_p2011w13_pkey" PRIMARY KEY using index "items_search_p2011w13_pkey";

alter table "pgstac"."items_search_p2011w14" add constraint "items_search_p2011w14_pkey" PRIMARY KEY using index "items_search_p2011w14_pkey";

alter table "pgstac"."items_search_p2011w15" add constraint "items_search_p2011w15_pkey" PRIMARY KEY using index "items_search_p2011w15_pkey";

alter table "pgstac"."items_search_p2011w16" add constraint "items_search_p2011w16_pkey" PRIMARY KEY using index "items_search_p2011w16_pkey";

alter table "pgstac"."items_search_p2011w17" add constraint "items_search_p2011w17_pkey" PRIMARY KEY using index "items_search_p2011w17_pkey";

alter table "pgstac"."items_search_p2011w18" add constraint "items_search_p2011w18_pkey" PRIMARY KEY using index "items_search_p2011w18_pkey";

alter table "pgstac"."items_search_p2011w19" add constraint "items_search_p2011w19_pkey" PRIMARY KEY using index "items_search_p2011w19_pkey";

alter table "pgstac"."items_search_p2011w20" add constraint "items_search_p2011w20_pkey" PRIMARY KEY using index "items_search_p2011w20_pkey";

alter table "pgstac"."items_search_p2011w21" add constraint "items_search_p2011w21_pkey" PRIMARY KEY using index "items_search_p2011w21_pkey";

alter table "pgstac"."items_search_p2011w22" add constraint "items_search_p2011w22_pkey" PRIMARY KEY using index "items_search_p2011w22_pkey";

alter table "pgstac"."items_search_p2011w23" add constraint "items_search_p2011w23_pkey" PRIMARY KEY using index "items_search_p2011w23_pkey";

alter table "pgstac"."items_search_p2011w24" add constraint "items_search_p2011w24_pkey" PRIMARY KEY using index "items_search_p2011w24_pkey";

alter table "pgstac"."items_search_p2011w25" add constraint "items_search_p2011w25_pkey" PRIMARY KEY using index "items_search_p2011w25_pkey";

alter table "pgstac"."items_search_p2011w26" add constraint "items_search_p2011w26_pkey" PRIMARY KEY using index "items_search_p2011w26_pkey";

alter table "pgstac"."items_search_p2011w27" add constraint "items_search_p2011w27_pkey" PRIMARY KEY using index "items_search_p2011w27_pkey";

alter table "pgstac"."items_search_p2011w28" add constraint "items_search_p2011w28_pkey" PRIMARY KEY using index "items_search_p2011w28_pkey";

alter table "pgstac"."items_search_p2011w29" add constraint "items_search_p2011w29_pkey" PRIMARY KEY using index "items_search_p2011w29_pkey";

alter table "pgstac"."items_search_p2011w30" add constraint "items_search_p2011w30_pkey" PRIMARY KEY using index "items_search_p2011w30_pkey";

alter table "pgstac"."items_search_p2011w31" add constraint "items_search_p2011w31_pkey" PRIMARY KEY using index "items_search_p2011w31_pkey";

alter table "pgstac"."items_search_p2011w32" add constraint "items_search_p2011w32_pkey" PRIMARY KEY using index "items_search_p2011w32_pkey";

alter table "pgstac"."items_search_p2011w33" add constraint "items_search_p2011w33_pkey" PRIMARY KEY using index "items_search_p2011w33_pkey";

alter table "pgstac"."items_search_p2011w34" add constraint "items_search_p2011w34_pkey" PRIMARY KEY using index "items_search_p2011w34_pkey";

alter table "pgstac"."items_search_p2011w35" add constraint "items_search_p2011w35_pkey" PRIMARY KEY using index "items_search_p2011w35_pkey";

alter table "pgstac"."items_search_p2011w36" add constraint "items_search_p2011w36_pkey" PRIMARY KEY using index "items_search_p2011w36_pkey";

alter table "pgstac"."items_search_p2011w37" add constraint "items_search_p2011w37_pkey" PRIMARY KEY using index "items_search_p2011w37_pkey";

alter table "pgstac"."items_search_p2011w38" add constraint "items_search_p2011w38_pkey" PRIMARY KEY using index "items_search_p2011w38_pkey";

alter table "pgstac"."items_search_p2011w39" add constraint "items_search_p2011w39_pkey" PRIMARY KEY using index "items_search_p2011w39_pkey";

alter table "pgstac"."items_search_p2011w40" add constraint "items_search_p2011w40_pkey" PRIMARY KEY using index "items_search_p2011w40_pkey";

alter table "pgstac"."items_search_p2011w41" add constraint "items_search_p2011w41_pkey" PRIMARY KEY using index "items_search_p2011w41_pkey";

alter table "pgstac"."items_search_p2011w42" add constraint "items_search_p2011w42_pkey" PRIMARY KEY using index "items_search_p2011w42_pkey";

alter table "pgstac"."items_search_p2011w43" add constraint "items_search_p2011w43_pkey" PRIMARY KEY using index "items_search_p2011w43_pkey";

alter table "pgstac"."items_search_p2011w44" add constraint "items_search_p2011w44_pkey" PRIMARY KEY using index "items_search_p2011w44_pkey";

alter table "pgstac"."items_search_p2011w45" add constraint "items_search_p2011w45_pkey" PRIMARY KEY using index "items_search_p2011w45_pkey";

alter table "pgstac"."items_search_p2011w46" add constraint "items_search_p2011w46_pkey" PRIMARY KEY using index "items_search_p2011w46_pkey";

alter table "pgstac"."items_search_p2011w47" add constraint "items_search_p2011w47_pkey" PRIMARY KEY using index "items_search_p2011w47_pkey";

alter table "pgstac"."items_search_p2011w48" add constraint "items_search_p2011w48_pkey" PRIMARY KEY using index "items_search_p2011w48_pkey";

alter table "pgstac"."items_search_p2011w49" add constraint "items_search_p2011w49_pkey" PRIMARY KEY using index "items_search_p2011w49_pkey";

alter table "pgstac"."items_search_p2011w50" add constraint "items_search_p2011w50_pkey" PRIMARY KEY using index "items_search_p2011w50_pkey";

alter table "pgstac"."items_search_p2011w51" add constraint "items_search_p2011w51_pkey" PRIMARY KEY using index "items_search_p2011w51_pkey";

alter table "pgstac"."items_search_p2011w52" add constraint "items_search_p2011w52_pkey" PRIMARY KEY using index "items_search_p2011w52_pkey";

alter table "pgstac"."items_search_p2012w01" add constraint "items_search_p2012w01_pkey" PRIMARY KEY using index "items_search_p2012w01_pkey";

alter table "pgstac"."items_search_p2012w02" add constraint "items_search_p2012w02_pkey" PRIMARY KEY using index "items_search_p2012w02_pkey";

alter table "pgstac"."items_search_p2012w03" add constraint "items_search_p2012w03_pkey" PRIMARY KEY using index "items_search_p2012w03_pkey";

alter table "pgstac"."items_search_p2012w04" add constraint "items_search_p2012w04_pkey" PRIMARY KEY using index "items_search_p2012w04_pkey";

alter table "pgstac"."items_search_p2012w05" add constraint "items_search_p2012w05_pkey" PRIMARY KEY using index "items_search_p2012w05_pkey";

alter table "pgstac"."items_search_p2012w06" add constraint "items_search_p2012w06_pkey" PRIMARY KEY using index "items_search_p2012w06_pkey";

alter table "pgstac"."items_search_p2012w07" add constraint "items_search_p2012w07_pkey" PRIMARY KEY using index "items_search_p2012w07_pkey";

alter table "pgstac"."items_search_p2012w08" add constraint "items_search_p2012w08_pkey" PRIMARY KEY using index "items_search_p2012w08_pkey";

alter table "pgstac"."items_search_p2012w09" add constraint "items_search_p2012w09_pkey" PRIMARY KEY using index "items_search_p2012w09_pkey";

alter table "pgstac"."items_search_p2012w10" add constraint "items_search_p2012w10_pkey" PRIMARY KEY using index "items_search_p2012w10_pkey";

alter table "pgstac"."items_search_p2012w11" add constraint "items_search_p2012w11_pkey" PRIMARY KEY using index "items_search_p2012w11_pkey";

alter table "pgstac"."items_search_p2012w12" add constraint "items_search_p2012w12_pkey" PRIMARY KEY using index "items_search_p2012w12_pkey";

alter table "pgstac"."items_search_p2012w13" add constraint "items_search_p2012w13_pkey" PRIMARY KEY using index "items_search_p2012w13_pkey";

alter table "pgstac"."items_search_p2012w14" add constraint "items_search_p2012w14_pkey" PRIMARY KEY using index "items_search_p2012w14_pkey";

alter table "pgstac"."items_search_p2012w15" add constraint "items_search_p2012w15_pkey" PRIMARY KEY using index "items_search_p2012w15_pkey";

alter table "pgstac"."items_search_p2012w16" add constraint "items_search_p2012w16_pkey" PRIMARY KEY using index "items_search_p2012w16_pkey";

alter table "pgstac"."items_search_p2012w17" add constraint "items_search_p2012w17_pkey" PRIMARY KEY using index "items_search_p2012w17_pkey";

alter table "pgstac"."items_search_p2012w18" add constraint "items_search_p2012w18_pkey" PRIMARY KEY using index "items_search_p2012w18_pkey";

alter table "pgstac"."items_search_p2012w19" add constraint "items_search_p2012w19_pkey" PRIMARY KEY using index "items_search_p2012w19_pkey";

alter table "pgstac"."items_search_p2012w20" add constraint "items_search_p2012w20_pkey" PRIMARY KEY using index "items_search_p2012w20_pkey";

alter table "pgstac"."items_search_p2012w21" add constraint "items_search_p2012w21_pkey" PRIMARY KEY using index "items_search_p2012w21_pkey";

alter table "pgstac"."items_search_p2012w22" add constraint "items_search_p2012w22_pkey" PRIMARY KEY using index "items_search_p2012w22_pkey";

alter table "pgstac"."items_search_p2012w23" add constraint "items_search_p2012w23_pkey" PRIMARY KEY using index "items_search_p2012w23_pkey";

alter table "pgstac"."items_search_p2012w24" add constraint "items_search_p2012w24_pkey" PRIMARY KEY using index "items_search_p2012w24_pkey";

alter table "pgstac"."items_search_p2012w25" add constraint "items_search_p2012w25_pkey" PRIMARY KEY using index "items_search_p2012w25_pkey";

alter table "pgstac"."items_search_p2012w26" add constraint "items_search_p2012w26_pkey" PRIMARY KEY using index "items_search_p2012w26_pkey";

alter table "pgstac"."items_search_p2012w27" add constraint "items_search_p2012w27_pkey" PRIMARY KEY using index "items_search_p2012w27_pkey";

alter table "pgstac"."items_search_p2012w28" add constraint "items_search_p2012w28_pkey" PRIMARY KEY using index "items_search_p2012w28_pkey";

alter table "pgstac"."items_search_p2012w29" add constraint "items_search_p2012w29_pkey" PRIMARY KEY using index "items_search_p2012w29_pkey";

alter table "pgstac"."items_search_p2012w30" add constraint "items_search_p2012w30_pkey" PRIMARY KEY using index "items_search_p2012w30_pkey";

alter table "pgstac"."items_search_p2012w31" add constraint "items_search_p2012w31_pkey" PRIMARY KEY using index "items_search_p2012w31_pkey";

alter table "pgstac"."items_search_p2012w32" add constraint "items_search_p2012w32_pkey" PRIMARY KEY using index "items_search_p2012w32_pkey";

alter table "pgstac"."items_search_p2012w33" add constraint "items_search_p2012w33_pkey" PRIMARY KEY using index "items_search_p2012w33_pkey";

alter table "pgstac"."items_search_p2012w34" add constraint "items_search_p2012w34_pkey" PRIMARY KEY using index "items_search_p2012w34_pkey";

alter table "pgstac"."items_search_p2012w35" add constraint "items_search_p2012w35_pkey" PRIMARY KEY using index "items_search_p2012w35_pkey";

alter table "pgstac"."items_search_p2012w36" add constraint "items_search_p2012w36_pkey" PRIMARY KEY using index "items_search_p2012w36_pkey";

alter table "pgstac"."items_search_p2012w37" add constraint "items_search_p2012w37_pkey" PRIMARY KEY using index "items_search_p2012w37_pkey";

alter table "pgstac"."items_search_p2012w38" add constraint "items_search_p2012w38_pkey" PRIMARY KEY using index "items_search_p2012w38_pkey";

alter table "pgstac"."items_search_p2012w39" add constraint "items_search_p2012w39_pkey" PRIMARY KEY using index "items_search_p2012w39_pkey";

alter table "pgstac"."items_search_p2012w40" add constraint "items_search_p2012w40_pkey" PRIMARY KEY using index "items_search_p2012w40_pkey";

alter table "pgstac"."items_search_p2012w41" add constraint "items_search_p2012w41_pkey" PRIMARY KEY using index "items_search_p2012w41_pkey";

alter table "pgstac"."items_search_p2012w42" add constraint "items_search_p2012w42_pkey" PRIMARY KEY using index "items_search_p2012w42_pkey";

alter table "pgstac"."items_search_p2012w43" add constraint "items_search_p2012w43_pkey" PRIMARY KEY using index "items_search_p2012w43_pkey";

alter table "pgstac"."items_search_p2012w44" add constraint "items_search_p2012w44_pkey" PRIMARY KEY using index "items_search_p2012w44_pkey";

alter table "pgstac"."items_search_p2012w45" add constraint "items_search_p2012w45_pkey" PRIMARY KEY using index "items_search_p2012w45_pkey";

alter table "pgstac"."items_search_p2012w46" add constraint "items_search_p2012w46_pkey" PRIMARY KEY using index "items_search_p2012w46_pkey";

alter table "pgstac"."items_search_p2012w47" add constraint "items_search_p2012w47_pkey" PRIMARY KEY using index "items_search_p2012w47_pkey";

alter table "pgstac"."items_search_p2012w48" add constraint "items_search_p2012w48_pkey" PRIMARY KEY using index "items_search_p2012w48_pkey";

alter table "pgstac"."items_search_p2012w49" add constraint "items_search_p2012w49_pkey" PRIMARY KEY using index "items_search_p2012w49_pkey";

alter table "pgstac"."items_search_p2012w50" add constraint "items_search_p2012w50_pkey" PRIMARY KEY using index "items_search_p2012w50_pkey";

alter table "pgstac"."items_search_p2012w51" add constraint "items_search_p2012w51_pkey" PRIMARY KEY using index "items_search_p2012w51_pkey";

alter table "pgstac"."items_search_p2012w52" add constraint "items_search_p2012w52_pkey" PRIMARY KEY using index "items_search_p2012w52_pkey";

alter table "pgstac"."items_search_p2013w01" add constraint "items_search_p2013w01_pkey" PRIMARY KEY using index "items_search_p2013w01_pkey";

alter table "pgstac"."items_search_p2013w02" add constraint "items_search_p2013w02_pkey" PRIMARY KEY using index "items_search_p2013w02_pkey";

alter table "pgstac"."items_search_p2013w03" add constraint "items_search_p2013w03_pkey" PRIMARY KEY using index "items_search_p2013w03_pkey";

alter table "pgstac"."items_search_p2013w04" add constraint "items_search_p2013w04_pkey" PRIMARY KEY using index "items_search_p2013w04_pkey";

alter table "pgstac"."items_search_p2013w05" add constraint "items_search_p2013w05_pkey" PRIMARY KEY using index "items_search_p2013w05_pkey";

alter table "pgstac"."items_search_p2013w06" add constraint "items_search_p2013w06_pkey" PRIMARY KEY using index "items_search_p2013w06_pkey";

alter table "pgstac"."items_search_p2013w07" add constraint "items_search_p2013w07_pkey" PRIMARY KEY using index "items_search_p2013w07_pkey";

alter table "pgstac"."items_search_p2013w08" add constraint "items_search_p2013w08_pkey" PRIMARY KEY using index "items_search_p2013w08_pkey";

alter table "pgstac"."items_search_p2013w09" add constraint "items_search_p2013w09_pkey" PRIMARY KEY using index "items_search_p2013w09_pkey";

alter table "pgstac"."items_search_p2013w10" add constraint "items_search_p2013w10_pkey" PRIMARY KEY using index "items_search_p2013w10_pkey";

alter table "pgstac"."items_search_p2013w11" add constraint "items_search_p2013w11_pkey" PRIMARY KEY using index "items_search_p2013w11_pkey";

alter table "pgstac"."items_search_p2013w12" add constraint "items_search_p2013w12_pkey" PRIMARY KEY using index "items_search_p2013w12_pkey";

alter table "pgstac"."items_search_p2013w13" add constraint "items_search_p2013w13_pkey" PRIMARY KEY using index "items_search_p2013w13_pkey";

alter table "pgstac"."items_search_p2013w14" add constraint "items_search_p2013w14_pkey" PRIMARY KEY using index "items_search_p2013w14_pkey";

alter table "pgstac"."items_search_p2013w15" add constraint "items_search_p2013w15_pkey" PRIMARY KEY using index "items_search_p2013w15_pkey";

alter table "pgstac"."items_search_p2013w16" add constraint "items_search_p2013w16_pkey" PRIMARY KEY using index "items_search_p2013w16_pkey";

alter table "pgstac"."items_search_p2013w17" add constraint "items_search_p2013w17_pkey" PRIMARY KEY using index "items_search_p2013w17_pkey";

alter table "pgstac"."items_search_p2013w18" add constraint "items_search_p2013w18_pkey" PRIMARY KEY using index "items_search_p2013w18_pkey";

alter table "pgstac"."items_search_p2013w19" add constraint "items_search_p2013w19_pkey" PRIMARY KEY using index "items_search_p2013w19_pkey";

alter table "pgstac"."items_search_p2013w20" add constraint "items_search_p2013w20_pkey" PRIMARY KEY using index "items_search_p2013w20_pkey";

alter table "pgstac"."items_search_p2013w21" add constraint "items_search_p2013w21_pkey" PRIMARY KEY using index "items_search_p2013w21_pkey";

alter table "pgstac"."items_search_p2013w22" add constraint "items_search_p2013w22_pkey" PRIMARY KEY using index "items_search_p2013w22_pkey";

alter table "pgstac"."items_search_p2013w23" add constraint "items_search_p2013w23_pkey" PRIMARY KEY using index "items_search_p2013w23_pkey";

alter table "pgstac"."items_search_p2013w24" add constraint "items_search_p2013w24_pkey" PRIMARY KEY using index "items_search_p2013w24_pkey";

alter table "pgstac"."items_search_p2013w25" add constraint "items_search_p2013w25_pkey" PRIMARY KEY using index "items_search_p2013w25_pkey";

alter table "pgstac"."items_search_p2013w26" add constraint "items_search_p2013w26_pkey" PRIMARY KEY using index "items_search_p2013w26_pkey";

alter table "pgstac"."items_search_p2013w27" add constraint "items_search_p2013w27_pkey" PRIMARY KEY using index "items_search_p2013w27_pkey";

alter table "pgstac"."items_search_p2013w28" add constraint "items_search_p2013w28_pkey" PRIMARY KEY using index "items_search_p2013w28_pkey";

alter table "pgstac"."items_search_p2013w29" add constraint "items_search_p2013w29_pkey" PRIMARY KEY using index "items_search_p2013w29_pkey";

alter table "pgstac"."items_search_p2013w30" add constraint "items_search_p2013w30_pkey" PRIMARY KEY using index "items_search_p2013w30_pkey";

alter table "pgstac"."items_search_p2013w31" add constraint "items_search_p2013w31_pkey" PRIMARY KEY using index "items_search_p2013w31_pkey";

alter table "pgstac"."items_search_p2013w32" add constraint "items_search_p2013w32_pkey" PRIMARY KEY using index "items_search_p2013w32_pkey";

alter table "pgstac"."items_search_p2013w33" add constraint "items_search_p2013w33_pkey" PRIMARY KEY using index "items_search_p2013w33_pkey";

alter table "pgstac"."items_search_p2013w34" add constraint "items_search_p2013w34_pkey" PRIMARY KEY using index "items_search_p2013w34_pkey";

alter table "pgstac"."items_search_p2013w35" add constraint "items_search_p2013w35_pkey" PRIMARY KEY using index "items_search_p2013w35_pkey";

alter table "pgstac"."items_search_p2013w36" add constraint "items_search_p2013w36_pkey" PRIMARY KEY using index "items_search_p2013w36_pkey";

alter table "pgstac"."items_search_p2013w37" add constraint "items_search_p2013w37_pkey" PRIMARY KEY using index "items_search_p2013w37_pkey";

alter table "pgstac"."items_search_p2013w38" add constraint "items_search_p2013w38_pkey" PRIMARY KEY using index "items_search_p2013w38_pkey";

alter table "pgstac"."items_search_p2013w39" add constraint "items_search_p2013w39_pkey" PRIMARY KEY using index "items_search_p2013w39_pkey";

alter table "pgstac"."items_search_p2013w40" add constraint "items_search_p2013w40_pkey" PRIMARY KEY using index "items_search_p2013w40_pkey";

alter table "pgstac"."items_search_p2013w41" add constraint "items_search_p2013w41_pkey" PRIMARY KEY using index "items_search_p2013w41_pkey";

alter table "pgstac"."items_search_p2013w42" add constraint "items_search_p2013w42_pkey" PRIMARY KEY using index "items_search_p2013w42_pkey";

alter table "pgstac"."items_search_p2013w43" add constraint "items_search_p2013w43_pkey" PRIMARY KEY using index "items_search_p2013w43_pkey";

alter table "pgstac"."items_search_p2013w44" add constraint "items_search_p2013w44_pkey" PRIMARY KEY using index "items_search_p2013w44_pkey";

alter table "pgstac"."items_search_p2013w45" add constraint "items_search_p2013w45_pkey" PRIMARY KEY using index "items_search_p2013w45_pkey";

alter table "pgstac"."items_search_p2013w46" add constraint "items_search_p2013w46_pkey" PRIMARY KEY using index "items_search_p2013w46_pkey";

alter table "pgstac"."items_search_p2013w47" add constraint "items_search_p2013w47_pkey" PRIMARY KEY using index "items_search_p2013w47_pkey";

alter table "pgstac"."items_search_p2013w48" add constraint "items_search_p2013w48_pkey" PRIMARY KEY using index "items_search_p2013w48_pkey";

alter table "pgstac"."items_search_p2013w49" add constraint "items_search_p2013w49_pkey" PRIMARY KEY using index "items_search_p2013w49_pkey";

alter table "pgstac"."items_search_p2013w50" add constraint "items_search_p2013w50_pkey" PRIMARY KEY using index "items_search_p2013w50_pkey";

alter table "pgstac"."items_search_p2013w51" add constraint "items_search_p2013w51_pkey" PRIMARY KEY using index "items_search_p2013w51_pkey";

alter table "pgstac"."items_search_p2013w52" add constraint "items_search_p2013w52_pkey" PRIMARY KEY using index "items_search_p2013w52_pkey";

alter table "pgstac"."items_search_p2014w01" add constraint "items_search_p2014w01_pkey" PRIMARY KEY using index "items_search_p2014w01_pkey";

alter table "pgstac"."items_search_p2014w02" add constraint "items_search_p2014w02_pkey" PRIMARY KEY using index "items_search_p2014w02_pkey";

alter table "pgstac"."items_search_p2014w03" add constraint "items_search_p2014w03_pkey" PRIMARY KEY using index "items_search_p2014w03_pkey";

alter table "pgstac"."items_search_p2014w04" add constraint "items_search_p2014w04_pkey" PRIMARY KEY using index "items_search_p2014w04_pkey";

alter table "pgstac"."items_search_p2014w05" add constraint "items_search_p2014w05_pkey" PRIMARY KEY using index "items_search_p2014w05_pkey";

alter table "pgstac"."items_search_p2014w06" add constraint "items_search_p2014w06_pkey" PRIMARY KEY using index "items_search_p2014w06_pkey";

alter table "pgstac"."items_search_p2014w07" add constraint "items_search_p2014w07_pkey" PRIMARY KEY using index "items_search_p2014w07_pkey";

alter table "pgstac"."items_search_p2014w08" add constraint "items_search_p2014w08_pkey" PRIMARY KEY using index "items_search_p2014w08_pkey";

alter table "pgstac"."items_search_p2014w09" add constraint "items_search_p2014w09_pkey" PRIMARY KEY using index "items_search_p2014w09_pkey";

alter table "pgstac"."items_search_p2014w10" add constraint "items_search_p2014w10_pkey" PRIMARY KEY using index "items_search_p2014w10_pkey";

alter table "pgstac"."items_search_p2014w11" add constraint "items_search_p2014w11_pkey" PRIMARY KEY using index "items_search_p2014w11_pkey";

alter table "pgstac"."items_search_p2014w12" add constraint "items_search_p2014w12_pkey" PRIMARY KEY using index "items_search_p2014w12_pkey";

alter table "pgstac"."items_search_p2014w13" add constraint "items_search_p2014w13_pkey" PRIMARY KEY using index "items_search_p2014w13_pkey";

alter table "pgstac"."items_search_p2014w14" add constraint "items_search_p2014w14_pkey" PRIMARY KEY using index "items_search_p2014w14_pkey";

alter table "pgstac"."items_search_p2014w15" add constraint "items_search_p2014w15_pkey" PRIMARY KEY using index "items_search_p2014w15_pkey";

alter table "pgstac"."items_search_p2014w16" add constraint "items_search_p2014w16_pkey" PRIMARY KEY using index "items_search_p2014w16_pkey";

alter table "pgstac"."items_search_p2014w17" add constraint "items_search_p2014w17_pkey" PRIMARY KEY using index "items_search_p2014w17_pkey";

alter table "pgstac"."items_search_p2014w18" add constraint "items_search_p2014w18_pkey" PRIMARY KEY using index "items_search_p2014w18_pkey";

alter table "pgstac"."items_search_p2014w19" add constraint "items_search_p2014w19_pkey" PRIMARY KEY using index "items_search_p2014w19_pkey";

alter table "pgstac"."items_search_p2014w20" add constraint "items_search_p2014w20_pkey" PRIMARY KEY using index "items_search_p2014w20_pkey";

alter table "pgstac"."items_search_p2014w21" add constraint "items_search_p2014w21_pkey" PRIMARY KEY using index "items_search_p2014w21_pkey";

alter table "pgstac"."items_search_p2014w22" add constraint "items_search_p2014w22_pkey" PRIMARY KEY using index "items_search_p2014w22_pkey";

alter table "pgstac"."items_search_p2014w23" add constraint "items_search_p2014w23_pkey" PRIMARY KEY using index "items_search_p2014w23_pkey";

alter table "pgstac"."items_search_p2014w24" add constraint "items_search_p2014w24_pkey" PRIMARY KEY using index "items_search_p2014w24_pkey";

alter table "pgstac"."items_search_p2014w25" add constraint "items_search_p2014w25_pkey" PRIMARY KEY using index "items_search_p2014w25_pkey";

alter table "pgstac"."items_search_p2014w26" add constraint "items_search_p2014w26_pkey" PRIMARY KEY using index "items_search_p2014w26_pkey";

alter table "pgstac"."items_search_p2014w27" add constraint "items_search_p2014w27_pkey" PRIMARY KEY using index "items_search_p2014w27_pkey";

alter table "pgstac"."items_search_p2014w28" add constraint "items_search_p2014w28_pkey" PRIMARY KEY using index "items_search_p2014w28_pkey";

alter table "pgstac"."items_search_p2014w29" add constraint "items_search_p2014w29_pkey" PRIMARY KEY using index "items_search_p2014w29_pkey";

alter table "pgstac"."items_search_p2014w30" add constraint "items_search_p2014w30_pkey" PRIMARY KEY using index "items_search_p2014w30_pkey";

alter table "pgstac"."items_search_p2014w31" add constraint "items_search_p2014w31_pkey" PRIMARY KEY using index "items_search_p2014w31_pkey";

alter table "pgstac"."items_search_p2014w32" add constraint "items_search_p2014w32_pkey" PRIMARY KEY using index "items_search_p2014w32_pkey";

alter table "pgstac"."items_search_p2014w33" add constraint "items_search_p2014w33_pkey" PRIMARY KEY using index "items_search_p2014w33_pkey";

alter table "pgstac"."items_search_p2014w34" add constraint "items_search_p2014w34_pkey" PRIMARY KEY using index "items_search_p2014w34_pkey";

alter table "pgstac"."items_search_p2014w35" add constraint "items_search_p2014w35_pkey" PRIMARY KEY using index "items_search_p2014w35_pkey";

alter table "pgstac"."items_search_p2014w36" add constraint "items_search_p2014w36_pkey" PRIMARY KEY using index "items_search_p2014w36_pkey";

alter table "pgstac"."items_search_p2014w37" add constraint "items_search_p2014w37_pkey" PRIMARY KEY using index "items_search_p2014w37_pkey";

alter table "pgstac"."items_search_p2014w38" add constraint "items_search_p2014w38_pkey" PRIMARY KEY using index "items_search_p2014w38_pkey";

alter table "pgstac"."items_search_p2014w39" add constraint "items_search_p2014w39_pkey" PRIMARY KEY using index "items_search_p2014w39_pkey";

alter table "pgstac"."items_search_p2014w40" add constraint "items_search_p2014w40_pkey" PRIMARY KEY using index "items_search_p2014w40_pkey";

alter table "pgstac"."items_search_p2014w41" add constraint "items_search_p2014w41_pkey" PRIMARY KEY using index "items_search_p2014w41_pkey";

alter table "pgstac"."items_search_p2014w42" add constraint "items_search_p2014w42_pkey" PRIMARY KEY using index "items_search_p2014w42_pkey";

alter table "pgstac"."items_search_p2014w43" add constraint "items_search_p2014w43_pkey" PRIMARY KEY using index "items_search_p2014w43_pkey";

alter table "pgstac"."items_search_p2014w44" add constraint "items_search_p2014w44_pkey" PRIMARY KEY using index "items_search_p2014w44_pkey";

alter table "pgstac"."items_search_p2014w45" add constraint "items_search_p2014w45_pkey" PRIMARY KEY using index "items_search_p2014w45_pkey";

alter table "pgstac"."items_search_p2014w46" add constraint "items_search_p2014w46_pkey" PRIMARY KEY using index "items_search_p2014w46_pkey";

alter table "pgstac"."items_search_p2014w47" add constraint "items_search_p2014w47_pkey" PRIMARY KEY using index "items_search_p2014w47_pkey";

alter table "pgstac"."items_search_p2014w48" add constraint "items_search_p2014w48_pkey" PRIMARY KEY using index "items_search_p2014w48_pkey";

alter table "pgstac"."items_search_p2014w49" add constraint "items_search_p2014w49_pkey" PRIMARY KEY using index "items_search_p2014w49_pkey";

alter table "pgstac"."items_search_p2014w50" add constraint "items_search_p2014w50_pkey" PRIMARY KEY using index "items_search_p2014w50_pkey";

alter table "pgstac"."items_search_p2014w51" add constraint "items_search_p2014w51_pkey" PRIMARY KEY using index "items_search_p2014w51_pkey";

alter table "pgstac"."items_search_p2014w52" add constraint "items_search_p2014w52_pkey" PRIMARY KEY using index "items_search_p2014w52_pkey";

alter table "pgstac"."items_search_p2015w01" add constraint "items_search_p2015w01_pkey" PRIMARY KEY using index "items_search_p2015w01_pkey";

alter table "pgstac"."items_search_p2015w02" add constraint "items_search_p2015w02_pkey" PRIMARY KEY using index "items_search_p2015w02_pkey";

alter table "pgstac"."items_search_p2015w03" add constraint "items_search_p2015w03_pkey" PRIMARY KEY using index "items_search_p2015w03_pkey";

alter table "pgstac"."items_search_p2015w04" add constraint "items_search_p2015w04_pkey" PRIMARY KEY using index "items_search_p2015w04_pkey";

alter table "pgstac"."items_search_p2015w05" add constraint "items_search_p2015w05_pkey" PRIMARY KEY using index "items_search_p2015w05_pkey";

alter table "pgstac"."items_search_p2015w06" add constraint "items_search_p2015w06_pkey" PRIMARY KEY using index "items_search_p2015w06_pkey";

alter table "pgstac"."items_search_p2015w07" add constraint "items_search_p2015w07_pkey" PRIMARY KEY using index "items_search_p2015w07_pkey";

alter table "pgstac"."items_search_p2015w08" add constraint "items_search_p2015w08_pkey" PRIMARY KEY using index "items_search_p2015w08_pkey";

alter table "pgstac"."items_search_p2015w09" add constraint "items_search_p2015w09_pkey" PRIMARY KEY using index "items_search_p2015w09_pkey";

alter table "pgstac"."items_search_p2015w10" add constraint "items_search_p2015w10_pkey" PRIMARY KEY using index "items_search_p2015w10_pkey";

alter table "pgstac"."items_search_p2015w11" add constraint "items_search_p2015w11_pkey" PRIMARY KEY using index "items_search_p2015w11_pkey";

alter table "pgstac"."items_search_p2015w12" add constraint "items_search_p2015w12_pkey" PRIMARY KEY using index "items_search_p2015w12_pkey";

alter table "pgstac"."items_search_p2015w13" add constraint "items_search_p2015w13_pkey" PRIMARY KEY using index "items_search_p2015w13_pkey";

alter table "pgstac"."items_search_p2015w14" add constraint "items_search_p2015w14_pkey" PRIMARY KEY using index "items_search_p2015w14_pkey";

alter table "pgstac"."items_search_p2015w15" add constraint "items_search_p2015w15_pkey" PRIMARY KEY using index "items_search_p2015w15_pkey";

alter table "pgstac"."items_search_p2015w16" add constraint "items_search_p2015w16_pkey" PRIMARY KEY using index "items_search_p2015w16_pkey";

alter table "pgstac"."items_search_p2015w17" add constraint "items_search_p2015w17_pkey" PRIMARY KEY using index "items_search_p2015w17_pkey";

alter table "pgstac"."items_search_p2015w18" add constraint "items_search_p2015w18_pkey" PRIMARY KEY using index "items_search_p2015w18_pkey";

alter table "pgstac"."items_search_p2015w19" add constraint "items_search_p2015w19_pkey" PRIMARY KEY using index "items_search_p2015w19_pkey";

alter table "pgstac"."items_search_p2015w20" add constraint "items_search_p2015w20_pkey" PRIMARY KEY using index "items_search_p2015w20_pkey";

alter table "pgstac"."items_search_p2015w21" add constraint "items_search_p2015w21_pkey" PRIMARY KEY using index "items_search_p2015w21_pkey";

alter table "pgstac"."items_search_p2015w22" add constraint "items_search_p2015w22_pkey" PRIMARY KEY using index "items_search_p2015w22_pkey";

alter table "pgstac"."items_search_p2015w23" add constraint "items_search_p2015w23_pkey" PRIMARY KEY using index "items_search_p2015w23_pkey";

alter table "pgstac"."items_search_p2015w24" add constraint "items_search_p2015w24_pkey" PRIMARY KEY using index "items_search_p2015w24_pkey";

alter table "pgstac"."items_search_p2015w25" add constraint "items_search_p2015w25_pkey" PRIMARY KEY using index "items_search_p2015w25_pkey";

alter table "pgstac"."items_search_p2015w26" add constraint "items_search_p2015w26_pkey" PRIMARY KEY using index "items_search_p2015w26_pkey";

alter table "pgstac"."items_search_p2015w27" add constraint "items_search_p2015w27_pkey" PRIMARY KEY using index "items_search_p2015w27_pkey";

alter table "pgstac"."items_search_p2015w28" add constraint "items_search_p2015w28_pkey" PRIMARY KEY using index "items_search_p2015w28_pkey";

alter table "pgstac"."items_search_p2015w29" add constraint "items_search_p2015w29_pkey" PRIMARY KEY using index "items_search_p2015w29_pkey";

alter table "pgstac"."items_search_p2015w30" add constraint "items_search_p2015w30_pkey" PRIMARY KEY using index "items_search_p2015w30_pkey";

alter table "pgstac"."items_search_p2015w31" add constraint "items_search_p2015w31_pkey" PRIMARY KEY using index "items_search_p2015w31_pkey";

alter table "pgstac"."items_search_p2015w32" add constraint "items_search_p2015w32_pkey" PRIMARY KEY using index "items_search_p2015w32_pkey";

alter table "pgstac"."items_search_p2015w33" add constraint "items_search_p2015w33_pkey" PRIMARY KEY using index "items_search_p2015w33_pkey";

alter table "pgstac"."items_search_p2015w34" add constraint "items_search_p2015w34_pkey" PRIMARY KEY using index "items_search_p2015w34_pkey";

alter table "pgstac"."items_search_p2015w35" add constraint "items_search_p2015w35_pkey" PRIMARY KEY using index "items_search_p2015w35_pkey";

alter table "pgstac"."items_search_p2015w36" add constraint "items_search_p2015w36_pkey" PRIMARY KEY using index "items_search_p2015w36_pkey";

alter table "pgstac"."items_search_p2015w37" add constraint "items_search_p2015w37_pkey" PRIMARY KEY using index "items_search_p2015w37_pkey";

alter table "pgstac"."items_search_p2015w38" add constraint "items_search_p2015w38_pkey" PRIMARY KEY using index "items_search_p2015w38_pkey";

alter table "pgstac"."items_search_p2015w39" add constraint "items_search_p2015w39_pkey" PRIMARY KEY using index "items_search_p2015w39_pkey";

alter table "pgstac"."items_search_p2015w40" add constraint "items_search_p2015w40_pkey" PRIMARY KEY using index "items_search_p2015w40_pkey";

alter table "pgstac"."items_search_p2015w41" add constraint "items_search_p2015w41_pkey" PRIMARY KEY using index "items_search_p2015w41_pkey";

alter table "pgstac"."items_search_p2015w42" add constraint "items_search_p2015w42_pkey" PRIMARY KEY using index "items_search_p2015w42_pkey";

alter table "pgstac"."items_search_p2015w43" add constraint "items_search_p2015w43_pkey" PRIMARY KEY using index "items_search_p2015w43_pkey";

alter table "pgstac"."items_search_p2015w44" add constraint "items_search_p2015w44_pkey" PRIMARY KEY using index "items_search_p2015w44_pkey";

alter table "pgstac"."items_search_p2015w45" add constraint "items_search_p2015w45_pkey" PRIMARY KEY using index "items_search_p2015w45_pkey";

alter table "pgstac"."items_search_p2015w46" add constraint "items_search_p2015w46_pkey" PRIMARY KEY using index "items_search_p2015w46_pkey";

alter table "pgstac"."items_search_p2015w47" add constraint "items_search_p2015w47_pkey" PRIMARY KEY using index "items_search_p2015w47_pkey";

alter table "pgstac"."items_search_p2015w48" add constraint "items_search_p2015w48_pkey" PRIMARY KEY using index "items_search_p2015w48_pkey";

alter table "pgstac"."items_search_p2015w49" add constraint "items_search_p2015w49_pkey" PRIMARY KEY using index "items_search_p2015w49_pkey";

alter table "pgstac"."items_search_p2015w50" add constraint "items_search_p2015w50_pkey" PRIMARY KEY using index "items_search_p2015w50_pkey";

alter table "pgstac"."items_search_p2015w51" add constraint "items_search_p2015w51_pkey" PRIMARY KEY using index "items_search_p2015w51_pkey";

alter table "pgstac"."items_search_p2015w52" add constraint "items_search_p2015w52_pkey" PRIMARY KEY using index "items_search_p2015w52_pkey";

alter table "pgstac"."items_search_p2015w53" add constraint "items_search_p2015w53_pkey" PRIMARY KEY using index "items_search_p2015w53_pkey";

alter table "pgstac"."items_search_p2016w01" add constraint "items_search_p2016w01_pkey" PRIMARY KEY using index "items_search_p2016w01_pkey";

alter table "pgstac"."items_search_p2016w02" add constraint "items_search_p2016w02_pkey" PRIMARY KEY using index "items_search_p2016w02_pkey";

alter table "pgstac"."items_search_p2016w03" add constraint "items_search_p2016w03_pkey" PRIMARY KEY using index "items_search_p2016w03_pkey";

alter table "pgstac"."items_search_p2016w04" add constraint "items_search_p2016w04_pkey" PRIMARY KEY using index "items_search_p2016w04_pkey";

alter table "pgstac"."items_search_p2016w05" add constraint "items_search_p2016w05_pkey" PRIMARY KEY using index "items_search_p2016w05_pkey";

alter table "pgstac"."items_search_p2016w06" add constraint "items_search_p2016w06_pkey" PRIMARY KEY using index "items_search_p2016w06_pkey";

alter table "pgstac"."items_search_p2016w07" add constraint "items_search_p2016w07_pkey" PRIMARY KEY using index "items_search_p2016w07_pkey";

alter table "pgstac"."items_search_p2016w08" add constraint "items_search_p2016w08_pkey" PRIMARY KEY using index "items_search_p2016w08_pkey";

alter table "pgstac"."items_search_p2016w09" add constraint "items_search_p2016w09_pkey" PRIMARY KEY using index "items_search_p2016w09_pkey";

alter table "pgstac"."items_search_p2016w10" add constraint "items_search_p2016w10_pkey" PRIMARY KEY using index "items_search_p2016w10_pkey";

alter table "pgstac"."items_search_p2016w11" add constraint "items_search_p2016w11_pkey" PRIMARY KEY using index "items_search_p2016w11_pkey";

alter table "pgstac"."items_search_p2016w12" add constraint "items_search_p2016w12_pkey" PRIMARY KEY using index "items_search_p2016w12_pkey";

alter table "pgstac"."items_search_p2016w13" add constraint "items_search_p2016w13_pkey" PRIMARY KEY using index "items_search_p2016w13_pkey";

alter table "pgstac"."items_search_p2016w14" add constraint "items_search_p2016w14_pkey" PRIMARY KEY using index "items_search_p2016w14_pkey";

alter table "pgstac"."items_search_p2016w15" add constraint "items_search_p2016w15_pkey" PRIMARY KEY using index "items_search_p2016w15_pkey";

alter table "pgstac"."items_search_p2016w16" add constraint "items_search_p2016w16_pkey" PRIMARY KEY using index "items_search_p2016w16_pkey";

alter table "pgstac"."items_search_p2016w17" add constraint "items_search_p2016w17_pkey" PRIMARY KEY using index "items_search_p2016w17_pkey";

alter table "pgstac"."items_search_p2016w18" add constraint "items_search_p2016w18_pkey" PRIMARY KEY using index "items_search_p2016w18_pkey";

alter table "pgstac"."items_search_p2016w19" add constraint "items_search_p2016w19_pkey" PRIMARY KEY using index "items_search_p2016w19_pkey";

alter table "pgstac"."items_search_p2016w20" add constraint "items_search_p2016w20_pkey" PRIMARY KEY using index "items_search_p2016w20_pkey";

alter table "pgstac"."items_search_p2016w21" add constraint "items_search_p2016w21_pkey" PRIMARY KEY using index "items_search_p2016w21_pkey";

alter table "pgstac"."items_search_p2016w22" add constraint "items_search_p2016w22_pkey" PRIMARY KEY using index "items_search_p2016w22_pkey";

alter table "pgstac"."items_search_p2016w23" add constraint "items_search_p2016w23_pkey" PRIMARY KEY using index "items_search_p2016w23_pkey";

alter table "pgstac"."items_search_p2016w24" add constraint "items_search_p2016w24_pkey" PRIMARY KEY using index "items_search_p2016w24_pkey";

alter table "pgstac"."items_search_p2016w25" add constraint "items_search_p2016w25_pkey" PRIMARY KEY using index "items_search_p2016w25_pkey";

alter table "pgstac"."items_search_p2016w26" add constraint "items_search_p2016w26_pkey" PRIMARY KEY using index "items_search_p2016w26_pkey";

alter table "pgstac"."items_search_p2016w27" add constraint "items_search_p2016w27_pkey" PRIMARY KEY using index "items_search_p2016w27_pkey";

alter table "pgstac"."items_search_p2016w28" add constraint "items_search_p2016w28_pkey" PRIMARY KEY using index "items_search_p2016w28_pkey";

alter table "pgstac"."items_search_p2016w29" add constraint "items_search_p2016w29_pkey" PRIMARY KEY using index "items_search_p2016w29_pkey";

alter table "pgstac"."items_search_p2016w30" add constraint "items_search_p2016w30_pkey" PRIMARY KEY using index "items_search_p2016w30_pkey";

alter table "pgstac"."items_search_p2016w31" add constraint "items_search_p2016w31_pkey" PRIMARY KEY using index "items_search_p2016w31_pkey";

alter table "pgstac"."items_search_p2016w32" add constraint "items_search_p2016w32_pkey" PRIMARY KEY using index "items_search_p2016w32_pkey";

alter table "pgstac"."items_search_p2016w33" add constraint "items_search_p2016w33_pkey" PRIMARY KEY using index "items_search_p2016w33_pkey";

alter table "pgstac"."items_search_p2016w34" add constraint "items_search_p2016w34_pkey" PRIMARY KEY using index "items_search_p2016w34_pkey";

alter table "pgstac"."items_search_p2016w35" add constraint "items_search_p2016w35_pkey" PRIMARY KEY using index "items_search_p2016w35_pkey";

alter table "pgstac"."items_search_p2016w36" add constraint "items_search_p2016w36_pkey" PRIMARY KEY using index "items_search_p2016w36_pkey";

alter table "pgstac"."items_search_p2016w37" add constraint "items_search_p2016w37_pkey" PRIMARY KEY using index "items_search_p2016w37_pkey";

alter table "pgstac"."items_search_p2016w38" add constraint "items_search_p2016w38_pkey" PRIMARY KEY using index "items_search_p2016w38_pkey";

alter table "pgstac"."items_search_p2016w39" add constraint "items_search_p2016w39_pkey" PRIMARY KEY using index "items_search_p2016w39_pkey";

alter table "pgstac"."items_search_p2016w40" add constraint "items_search_p2016w40_pkey" PRIMARY KEY using index "items_search_p2016w40_pkey";

alter table "pgstac"."items_search_p2016w41" add constraint "items_search_p2016w41_pkey" PRIMARY KEY using index "items_search_p2016w41_pkey";

alter table "pgstac"."items_search_p2016w42" add constraint "items_search_p2016w42_pkey" PRIMARY KEY using index "items_search_p2016w42_pkey";

alter table "pgstac"."items_search_p2016w43" add constraint "items_search_p2016w43_pkey" PRIMARY KEY using index "items_search_p2016w43_pkey";

alter table "pgstac"."items_search_p2016w44" add constraint "items_search_p2016w44_pkey" PRIMARY KEY using index "items_search_p2016w44_pkey";

alter table "pgstac"."items_search_p2016w45" add constraint "items_search_p2016w45_pkey" PRIMARY KEY using index "items_search_p2016w45_pkey";

alter table "pgstac"."items_search_p2016w46" add constraint "items_search_p2016w46_pkey" PRIMARY KEY using index "items_search_p2016w46_pkey";

alter table "pgstac"."items_search_p2016w47" add constraint "items_search_p2016w47_pkey" PRIMARY KEY using index "items_search_p2016w47_pkey";

alter table "pgstac"."items_search_p2016w48" add constraint "items_search_p2016w48_pkey" PRIMARY KEY using index "items_search_p2016w48_pkey";

alter table "pgstac"."items_search_p2016w49" add constraint "items_search_p2016w49_pkey" PRIMARY KEY using index "items_search_p2016w49_pkey";

alter table "pgstac"."items_search_p2016w50" add constraint "items_search_p2016w50_pkey" PRIMARY KEY using index "items_search_p2016w50_pkey";

alter table "pgstac"."items_search_p2016w51" add constraint "items_search_p2016w51_pkey" PRIMARY KEY using index "items_search_p2016w51_pkey";

alter table "pgstac"."items_search_p2016w52" add constraint "items_search_p2016w52_pkey" PRIMARY KEY using index "items_search_p2016w52_pkey";

alter table "pgstac"."items_search_p2017w01" add constraint "items_search_p2017w01_pkey" PRIMARY KEY using index "items_search_p2017w01_pkey";

alter table "pgstac"."items_search_p2017w02" add constraint "items_search_p2017w02_pkey" PRIMARY KEY using index "items_search_p2017w02_pkey";

alter table "pgstac"."items_search_p2017w03" add constraint "items_search_p2017w03_pkey" PRIMARY KEY using index "items_search_p2017w03_pkey";

alter table "pgstac"."items_search_p2017w04" add constraint "items_search_p2017w04_pkey" PRIMARY KEY using index "items_search_p2017w04_pkey";

alter table "pgstac"."items_search_p2017w05" add constraint "items_search_p2017w05_pkey" PRIMARY KEY using index "items_search_p2017w05_pkey";

alter table "pgstac"."items_search_p2017w06" add constraint "items_search_p2017w06_pkey" PRIMARY KEY using index "items_search_p2017w06_pkey";

alter table "pgstac"."items_search_p2017w07" add constraint "items_search_p2017w07_pkey" PRIMARY KEY using index "items_search_p2017w07_pkey";

alter table "pgstac"."items_search_p2017w08" add constraint "items_search_p2017w08_pkey" PRIMARY KEY using index "items_search_p2017w08_pkey";

alter table "pgstac"."items_search_p2017w09" add constraint "items_search_p2017w09_pkey" PRIMARY KEY using index "items_search_p2017w09_pkey";

alter table "pgstac"."items_search_p2017w10" add constraint "items_search_p2017w10_pkey" PRIMARY KEY using index "items_search_p2017w10_pkey";

alter table "pgstac"."items_search_p2017w11" add constraint "items_search_p2017w11_pkey" PRIMARY KEY using index "items_search_p2017w11_pkey";

alter table "pgstac"."items_search_p2017w12" add constraint "items_search_p2017w12_pkey" PRIMARY KEY using index "items_search_p2017w12_pkey";

alter table "pgstac"."items_search_p2017w13" add constraint "items_search_p2017w13_pkey" PRIMARY KEY using index "items_search_p2017w13_pkey";

alter table "pgstac"."items_search_p2017w14" add constraint "items_search_p2017w14_pkey" PRIMARY KEY using index "items_search_p2017w14_pkey";

alter table "pgstac"."items_search_p2017w15" add constraint "items_search_p2017w15_pkey" PRIMARY KEY using index "items_search_p2017w15_pkey";

alter table "pgstac"."items_search_p2017w16" add constraint "items_search_p2017w16_pkey" PRIMARY KEY using index "items_search_p2017w16_pkey";

alter table "pgstac"."items_search_p2017w17" add constraint "items_search_p2017w17_pkey" PRIMARY KEY using index "items_search_p2017w17_pkey";

alter table "pgstac"."items_search_p2017w18" add constraint "items_search_p2017w18_pkey" PRIMARY KEY using index "items_search_p2017w18_pkey";

alter table "pgstac"."items_search_p2017w19" add constraint "items_search_p2017w19_pkey" PRIMARY KEY using index "items_search_p2017w19_pkey";

alter table "pgstac"."items_search_p2017w20" add constraint "items_search_p2017w20_pkey" PRIMARY KEY using index "items_search_p2017w20_pkey";

alter table "pgstac"."items_search_p2017w21" add constraint "items_search_p2017w21_pkey" PRIMARY KEY using index "items_search_p2017w21_pkey";

alter table "pgstac"."items_search_p2017w22" add constraint "items_search_p2017w22_pkey" PRIMARY KEY using index "items_search_p2017w22_pkey";

alter table "pgstac"."items_search_p2017w23" add constraint "items_search_p2017w23_pkey" PRIMARY KEY using index "items_search_p2017w23_pkey";

alter table "pgstac"."items_search_p2017w24" add constraint "items_search_p2017w24_pkey" PRIMARY KEY using index "items_search_p2017w24_pkey";

alter table "pgstac"."items_search_p2017w25" add constraint "items_search_p2017w25_pkey" PRIMARY KEY using index "items_search_p2017w25_pkey";

alter table "pgstac"."items_search_p2017w26" add constraint "items_search_p2017w26_pkey" PRIMARY KEY using index "items_search_p2017w26_pkey";

alter table "pgstac"."items_search_p2017w27" add constraint "items_search_p2017w27_pkey" PRIMARY KEY using index "items_search_p2017w27_pkey";

alter table "pgstac"."items_search_p2017w28" add constraint "items_search_p2017w28_pkey" PRIMARY KEY using index "items_search_p2017w28_pkey";

alter table "pgstac"."items_search_p2017w29" add constraint "items_search_p2017w29_pkey" PRIMARY KEY using index "items_search_p2017w29_pkey";

alter table "pgstac"."items_search_p2017w30" add constraint "items_search_p2017w30_pkey" PRIMARY KEY using index "items_search_p2017w30_pkey";

alter table "pgstac"."items_search_p2017w31" add constraint "items_search_p2017w31_pkey" PRIMARY KEY using index "items_search_p2017w31_pkey";

alter table "pgstac"."items_search_p2017w32" add constraint "items_search_p2017w32_pkey" PRIMARY KEY using index "items_search_p2017w32_pkey";

alter table "pgstac"."items_search_p2017w33" add constraint "items_search_p2017w33_pkey" PRIMARY KEY using index "items_search_p2017w33_pkey";

alter table "pgstac"."items_search_p2017w34" add constraint "items_search_p2017w34_pkey" PRIMARY KEY using index "items_search_p2017w34_pkey";

alter table "pgstac"."items_search_p2017w35" add constraint "items_search_p2017w35_pkey" PRIMARY KEY using index "items_search_p2017w35_pkey";

alter table "pgstac"."items_search_p2017w36" add constraint "items_search_p2017w36_pkey" PRIMARY KEY using index "items_search_p2017w36_pkey";

alter table "pgstac"."items_search_p2017w37" add constraint "items_search_p2017w37_pkey" PRIMARY KEY using index "items_search_p2017w37_pkey";

alter table "pgstac"."items_search_p2017w38" add constraint "items_search_p2017w38_pkey" PRIMARY KEY using index "items_search_p2017w38_pkey";

alter table "pgstac"."items_search_p2017w39" add constraint "items_search_p2017w39_pkey" PRIMARY KEY using index "items_search_p2017w39_pkey";

alter table "pgstac"."items_search_p2017w40" add constraint "items_search_p2017w40_pkey" PRIMARY KEY using index "items_search_p2017w40_pkey";

alter table "pgstac"."items_search_p2017w41" add constraint "items_search_p2017w41_pkey" PRIMARY KEY using index "items_search_p2017w41_pkey";

alter table "pgstac"."items_search_p2017w42" add constraint "items_search_p2017w42_pkey" PRIMARY KEY using index "items_search_p2017w42_pkey";

alter table "pgstac"."items_search_p2017w43" add constraint "items_search_p2017w43_pkey" PRIMARY KEY using index "items_search_p2017w43_pkey";

alter table "pgstac"."items_search_p2017w44" add constraint "items_search_p2017w44_pkey" PRIMARY KEY using index "items_search_p2017w44_pkey";

alter table "pgstac"."items_search_p2017w45" add constraint "items_search_p2017w45_pkey" PRIMARY KEY using index "items_search_p2017w45_pkey";

alter table "pgstac"."items_search_p2017w46" add constraint "items_search_p2017w46_pkey" PRIMARY KEY using index "items_search_p2017w46_pkey";

alter table "pgstac"."items_search_p2017w47" add constraint "items_search_p2017w47_pkey" PRIMARY KEY using index "items_search_p2017w47_pkey";

alter table "pgstac"."items_search_p2017w48" add constraint "items_search_p2017w48_pkey" PRIMARY KEY using index "items_search_p2017w48_pkey";

alter table "pgstac"."items_search_p2017w49" add constraint "items_search_p2017w49_pkey" PRIMARY KEY using index "items_search_p2017w49_pkey";

alter table "pgstac"."items_search_p2017w50" add constraint "items_search_p2017w50_pkey" PRIMARY KEY using index "items_search_p2017w50_pkey";

alter table "pgstac"."items_search_p2017w51" add constraint "items_search_p2017w51_pkey" PRIMARY KEY using index "items_search_p2017w51_pkey";

alter table "pgstac"."items_search_p2017w52" add constraint "items_search_p2017w52_pkey" PRIMARY KEY using index "items_search_p2017w52_pkey";

alter table "pgstac"."items_search_p2018w01" add constraint "items_search_p2018w01_pkey" PRIMARY KEY using index "items_search_p2018w01_pkey";

alter table "pgstac"."items_search_p2018w02" add constraint "items_search_p2018w02_pkey" PRIMARY KEY using index "items_search_p2018w02_pkey";

alter table "pgstac"."items_search_p2018w03" add constraint "items_search_p2018w03_pkey" PRIMARY KEY using index "items_search_p2018w03_pkey";

alter table "pgstac"."items_search_p2018w04" add constraint "items_search_p2018w04_pkey" PRIMARY KEY using index "items_search_p2018w04_pkey";

alter table "pgstac"."items_search_p2018w05" add constraint "items_search_p2018w05_pkey" PRIMARY KEY using index "items_search_p2018w05_pkey";

alter table "pgstac"."items_search_p2018w06" add constraint "items_search_p2018w06_pkey" PRIMARY KEY using index "items_search_p2018w06_pkey";

alter table "pgstac"."items_search_p2018w07" add constraint "items_search_p2018w07_pkey" PRIMARY KEY using index "items_search_p2018w07_pkey";

alter table "pgstac"."items_search_p2018w08" add constraint "items_search_p2018w08_pkey" PRIMARY KEY using index "items_search_p2018w08_pkey";

alter table "pgstac"."items_search_p2018w09" add constraint "items_search_p2018w09_pkey" PRIMARY KEY using index "items_search_p2018w09_pkey";

alter table "pgstac"."items_search_p2018w10" add constraint "items_search_p2018w10_pkey" PRIMARY KEY using index "items_search_p2018w10_pkey";

alter table "pgstac"."items_search_p2018w11" add constraint "items_search_p2018w11_pkey" PRIMARY KEY using index "items_search_p2018w11_pkey";

alter table "pgstac"."items_search_p2018w12" add constraint "items_search_p2018w12_pkey" PRIMARY KEY using index "items_search_p2018w12_pkey";

alter table "pgstac"."items_search_p2018w13" add constraint "items_search_p2018w13_pkey" PRIMARY KEY using index "items_search_p2018w13_pkey";

alter table "pgstac"."items_search_p2018w14" add constraint "items_search_p2018w14_pkey" PRIMARY KEY using index "items_search_p2018w14_pkey";

alter table "pgstac"."items_search_p2018w15" add constraint "items_search_p2018w15_pkey" PRIMARY KEY using index "items_search_p2018w15_pkey";

alter table "pgstac"."items_search_p2018w16" add constraint "items_search_p2018w16_pkey" PRIMARY KEY using index "items_search_p2018w16_pkey";

alter table "pgstac"."items_search_p2018w17" add constraint "items_search_p2018w17_pkey" PRIMARY KEY using index "items_search_p2018w17_pkey";

alter table "pgstac"."items_search_p2018w18" add constraint "items_search_p2018w18_pkey" PRIMARY KEY using index "items_search_p2018w18_pkey";

alter table "pgstac"."items_search_p2018w19" add constraint "items_search_p2018w19_pkey" PRIMARY KEY using index "items_search_p2018w19_pkey";

alter table "pgstac"."items_search_p2018w20" add constraint "items_search_p2018w20_pkey" PRIMARY KEY using index "items_search_p2018w20_pkey";

alter table "pgstac"."items_search_p2018w21" add constraint "items_search_p2018w21_pkey" PRIMARY KEY using index "items_search_p2018w21_pkey";

alter table "pgstac"."items_search_p2018w22" add constraint "items_search_p2018w22_pkey" PRIMARY KEY using index "items_search_p2018w22_pkey";

alter table "pgstac"."items_search_p2018w23" add constraint "items_search_p2018w23_pkey" PRIMARY KEY using index "items_search_p2018w23_pkey";

alter table "pgstac"."items_search_p2018w24" add constraint "items_search_p2018w24_pkey" PRIMARY KEY using index "items_search_p2018w24_pkey";

alter table "pgstac"."items_search_p2018w25" add constraint "items_search_p2018w25_pkey" PRIMARY KEY using index "items_search_p2018w25_pkey";

alter table "pgstac"."items_search_p2018w26" add constraint "items_search_p2018w26_pkey" PRIMARY KEY using index "items_search_p2018w26_pkey";

alter table "pgstac"."items_search_p2018w27" add constraint "items_search_p2018w27_pkey" PRIMARY KEY using index "items_search_p2018w27_pkey";

alter table "pgstac"."items_search_p2018w28" add constraint "items_search_p2018w28_pkey" PRIMARY KEY using index "items_search_p2018w28_pkey";

alter table "pgstac"."items_search_p2018w29" add constraint "items_search_p2018w29_pkey" PRIMARY KEY using index "items_search_p2018w29_pkey";

alter table "pgstac"."items_search_p2018w30" add constraint "items_search_p2018w30_pkey" PRIMARY KEY using index "items_search_p2018w30_pkey";

alter table "pgstac"."items_search_p2018w31" add constraint "items_search_p2018w31_pkey" PRIMARY KEY using index "items_search_p2018w31_pkey";

alter table "pgstac"."items_search_p2018w32" add constraint "items_search_p2018w32_pkey" PRIMARY KEY using index "items_search_p2018w32_pkey";

alter table "pgstac"."items_search_p2018w33" add constraint "items_search_p2018w33_pkey" PRIMARY KEY using index "items_search_p2018w33_pkey";

alter table "pgstac"."items_search_p2018w34" add constraint "items_search_p2018w34_pkey" PRIMARY KEY using index "items_search_p2018w34_pkey";

alter table "pgstac"."items_search_p2018w35" add constraint "items_search_p2018w35_pkey" PRIMARY KEY using index "items_search_p2018w35_pkey";

alter table "pgstac"."items_search_p2018w36" add constraint "items_search_p2018w36_pkey" PRIMARY KEY using index "items_search_p2018w36_pkey";

alter table "pgstac"."items_search_p2018w37" add constraint "items_search_p2018w37_pkey" PRIMARY KEY using index "items_search_p2018w37_pkey";

alter table "pgstac"."items_search_p2018w38" add constraint "items_search_p2018w38_pkey" PRIMARY KEY using index "items_search_p2018w38_pkey";

alter table "pgstac"."items_search_p2018w39" add constraint "items_search_p2018w39_pkey" PRIMARY KEY using index "items_search_p2018w39_pkey";

alter table "pgstac"."items_search_p2018w40" add constraint "items_search_p2018w40_pkey" PRIMARY KEY using index "items_search_p2018w40_pkey";

alter table "pgstac"."items_search_p2018w41" add constraint "items_search_p2018w41_pkey" PRIMARY KEY using index "items_search_p2018w41_pkey";

alter table "pgstac"."items_search_p2018w42" add constraint "items_search_p2018w42_pkey" PRIMARY KEY using index "items_search_p2018w42_pkey";

alter table "pgstac"."items_search_p2018w43" add constraint "items_search_p2018w43_pkey" PRIMARY KEY using index "items_search_p2018w43_pkey";

alter table "pgstac"."items_search_p2018w44" add constraint "items_search_p2018w44_pkey" PRIMARY KEY using index "items_search_p2018w44_pkey";

alter table "pgstac"."items_search_p2018w45" add constraint "items_search_p2018w45_pkey" PRIMARY KEY using index "items_search_p2018w45_pkey";

alter table "pgstac"."items_search_p2018w46" add constraint "items_search_p2018w46_pkey" PRIMARY KEY using index "items_search_p2018w46_pkey";

alter table "pgstac"."items_search_p2018w47" add constraint "items_search_p2018w47_pkey" PRIMARY KEY using index "items_search_p2018w47_pkey";

alter table "pgstac"."items_search_p2018w48" add constraint "items_search_p2018w48_pkey" PRIMARY KEY using index "items_search_p2018w48_pkey";

alter table "pgstac"."items_search_p2018w49" add constraint "items_search_p2018w49_pkey" PRIMARY KEY using index "items_search_p2018w49_pkey";

alter table "pgstac"."items_search_p2018w50" add constraint "items_search_p2018w50_pkey" PRIMARY KEY using index "items_search_p2018w50_pkey";

alter table "pgstac"."items_search_p2018w51" add constraint "items_search_p2018w51_pkey" PRIMARY KEY using index "items_search_p2018w51_pkey";

alter table "pgstac"."items_search_p2018w52" add constraint "items_search_p2018w52_pkey" PRIMARY KEY using index "items_search_p2018w52_pkey";

alter table "pgstac"."items_search_p2019w01" add constraint "items_search_p2019w01_pkey" PRIMARY KEY using index "items_search_p2019w01_pkey";

alter table "pgstac"."items_search_p2019w02" add constraint "items_search_p2019w02_pkey" PRIMARY KEY using index "items_search_p2019w02_pkey";

alter table "pgstac"."items_search_p2019w03" add constraint "items_search_p2019w03_pkey" PRIMARY KEY using index "items_search_p2019w03_pkey";

alter table "pgstac"."items_search_p2019w04" add constraint "items_search_p2019w04_pkey" PRIMARY KEY using index "items_search_p2019w04_pkey";

alter table "pgstac"."items_search_p2019w05" add constraint "items_search_p2019w05_pkey" PRIMARY KEY using index "items_search_p2019w05_pkey";

alter table "pgstac"."items_search_p2019w06" add constraint "items_search_p2019w06_pkey" PRIMARY KEY using index "items_search_p2019w06_pkey";

alter table "pgstac"."items_search_p2019w07" add constraint "items_search_p2019w07_pkey" PRIMARY KEY using index "items_search_p2019w07_pkey";

alter table "pgstac"."items_search_p2019w08" add constraint "items_search_p2019w08_pkey" PRIMARY KEY using index "items_search_p2019w08_pkey";

alter table "pgstac"."items_search_p2019w09" add constraint "items_search_p2019w09_pkey" PRIMARY KEY using index "items_search_p2019w09_pkey";

alter table "pgstac"."items_search_p2019w10" add constraint "items_search_p2019w10_pkey" PRIMARY KEY using index "items_search_p2019w10_pkey";

alter table "pgstac"."items_search_p2019w11" add constraint "items_search_p2019w11_pkey" PRIMARY KEY using index "items_search_p2019w11_pkey";

alter table "pgstac"."items_search_p2019w12" add constraint "items_search_p2019w12_pkey" PRIMARY KEY using index "items_search_p2019w12_pkey";

alter table "pgstac"."items_search_p2019w13" add constraint "items_search_p2019w13_pkey" PRIMARY KEY using index "items_search_p2019w13_pkey";

alter table "pgstac"."items_search_p2019w14" add constraint "items_search_p2019w14_pkey" PRIMARY KEY using index "items_search_p2019w14_pkey";

alter table "pgstac"."items_search_p2019w15" add constraint "items_search_p2019w15_pkey" PRIMARY KEY using index "items_search_p2019w15_pkey";

alter table "pgstac"."items_search_p2019w16" add constraint "items_search_p2019w16_pkey" PRIMARY KEY using index "items_search_p2019w16_pkey";

alter table "pgstac"."items_search_p2019w17" add constraint "items_search_p2019w17_pkey" PRIMARY KEY using index "items_search_p2019w17_pkey";

alter table "pgstac"."items_search_p2019w18" add constraint "items_search_p2019w18_pkey" PRIMARY KEY using index "items_search_p2019w18_pkey";

alter table "pgstac"."items_search_p2019w19" add constraint "items_search_p2019w19_pkey" PRIMARY KEY using index "items_search_p2019w19_pkey";

alter table "pgstac"."items_search_p2019w20" add constraint "items_search_p2019w20_pkey" PRIMARY KEY using index "items_search_p2019w20_pkey";

alter table "pgstac"."items_search_p2019w21" add constraint "items_search_p2019w21_pkey" PRIMARY KEY using index "items_search_p2019w21_pkey";

alter table "pgstac"."items_search_p2019w22" add constraint "items_search_p2019w22_pkey" PRIMARY KEY using index "items_search_p2019w22_pkey";

alter table "pgstac"."items_search_p2019w23" add constraint "items_search_p2019w23_pkey" PRIMARY KEY using index "items_search_p2019w23_pkey";

alter table "pgstac"."items_search_p2019w24" add constraint "items_search_p2019w24_pkey" PRIMARY KEY using index "items_search_p2019w24_pkey";

alter table "pgstac"."items_search_p2019w25" add constraint "items_search_p2019w25_pkey" PRIMARY KEY using index "items_search_p2019w25_pkey";

alter table "pgstac"."items_search_p2019w26" add constraint "items_search_p2019w26_pkey" PRIMARY KEY using index "items_search_p2019w26_pkey";

alter table "pgstac"."items_search_p2019w27" add constraint "items_search_p2019w27_pkey" PRIMARY KEY using index "items_search_p2019w27_pkey";

alter table "pgstac"."items_search_p2019w28" add constraint "items_search_p2019w28_pkey" PRIMARY KEY using index "items_search_p2019w28_pkey";

alter table "pgstac"."items_search_p2019w29" add constraint "items_search_p2019w29_pkey" PRIMARY KEY using index "items_search_p2019w29_pkey";

alter table "pgstac"."items_search_p2019w30" add constraint "items_search_p2019w30_pkey" PRIMARY KEY using index "items_search_p2019w30_pkey";

alter table "pgstac"."items_search_p2019w31" add constraint "items_search_p2019w31_pkey" PRIMARY KEY using index "items_search_p2019w31_pkey";

alter table "pgstac"."items_search_p2019w32" add constraint "items_search_p2019w32_pkey" PRIMARY KEY using index "items_search_p2019w32_pkey";

alter table "pgstac"."items_search_p2019w33" add constraint "items_search_p2019w33_pkey" PRIMARY KEY using index "items_search_p2019w33_pkey";

alter table "pgstac"."items_search_p2019w34" add constraint "items_search_p2019w34_pkey" PRIMARY KEY using index "items_search_p2019w34_pkey";

alter table "pgstac"."items_search_p2019w35" add constraint "items_search_p2019w35_pkey" PRIMARY KEY using index "items_search_p2019w35_pkey";

alter table "pgstac"."items_search_p2019w36" add constraint "items_search_p2019w36_pkey" PRIMARY KEY using index "items_search_p2019w36_pkey";

alter table "pgstac"."items_search_p2019w37" add constraint "items_search_p2019w37_pkey" PRIMARY KEY using index "items_search_p2019w37_pkey";

alter table "pgstac"."items_search_p2019w38" add constraint "items_search_p2019w38_pkey" PRIMARY KEY using index "items_search_p2019w38_pkey";

alter table "pgstac"."items_search_p2019w39" add constraint "items_search_p2019w39_pkey" PRIMARY KEY using index "items_search_p2019w39_pkey";

alter table "pgstac"."items_search_p2019w40" add constraint "items_search_p2019w40_pkey" PRIMARY KEY using index "items_search_p2019w40_pkey";

alter table "pgstac"."items_search_p2019w41" add constraint "items_search_p2019w41_pkey" PRIMARY KEY using index "items_search_p2019w41_pkey";

alter table "pgstac"."items_search_p2019w42" add constraint "items_search_p2019w42_pkey" PRIMARY KEY using index "items_search_p2019w42_pkey";

alter table "pgstac"."items_search_p2019w43" add constraint "items_search_p2019w43_pkey" PRIMARY KEY using index "items_search_p2019w43_pkey";

alter table "pgstac"."items_search_p2019w44" add constraint "items_search_p2019w44_pkey" PRIMARY KEY using index "items_search_p2019w44_pkey";

alter table "pgstac"."items_search_p2019w45" add constraint "items_search_p2019w45_pkey" PRIMARY KEY using index "items_search_p2019w45_pkey";

alter table "pgstac"."items_search_p2019w46" add constraint "items_search_p2019w46_pkey" PRIMARY KEY using index "items_search_p2019w46_pkey";

alter table "pgstac"."items_search_p2019w47" add constraint "items_search_p2019w47_pkey" PRIMARY KEY using index "items_search_p2019w47_pkey";

alter table "pgstac"."items_search_p2019w48" add constraint "items_search_p2019w48_pkey" PRIMARY KEY using index "items_search_p2019w48_pkey";

alter table "pgstac"."items_search_p2019w49" add constraint "items_search_p2019w49_pkey" PRIMARY KEY using index "items_search_p2019w49_pkey";

alter table "pgstac"."items_search_p2019w50" add constraint "items_search_p2019w50_pkey" PRIMARY KEY using index "items_search_p2019w50_pkey";

alter table "pgstac"."items_search_p2019w51" add constraint "items_search_p2019w51_pkey" PRIMARY KEY using index "items_search_p2019w51_pkey";

alter table "pgstac"."items_search_p2019w52" add constraint "items_search_p2019w52_pkey" PRIMARY KEY using index "items_search_p2019w52_pkey";

alter table "pgstac"."items_search_p2020w01" add constraint "items_search_p2020w01_pkey" PRIMARY KEY using index "items_search_p2020w01_pkey";

alter table "pgstac"."items_search_p2020w02" add constraint "items_search_p2020w02_pkey" PRIMARY KEY using index "items_search_p2020w02_pkey";

alter table "pgstac"."items_search_p2020w03" add constraint "items_search_p2020w03_pkey" PRIMARY KEY using index "items_search_p2020w03_pkey";

alter table "pgstac"."items_search_p2020w04" add constraint "items_search_p2020w04_pkey" PRIMARY KEY using index "items_search_p2020w04_pkey";

alter table "pgstac"."items_search_p2020w05" add constraint "items_search_p2020w05_pkey" PRIMARY KEY using index "items_search_p2020w05_pkey";

alter table "pgstac"."items_search_p2020w06" add constraint "items_search_p2020w06_pkey" PRIMARY KEY using index "items_search_p2020w06_pkey";

alter table "pgstac"."items_search_p2020w07" add constraint "items_search_p2020w07_pkey" PRIMARY KEY using index "items_search_p2020w07_pkey";

alter table "pgstac"."items_search_p2020w08" add constraint "items_search_p2020w08_pkey" PRIMARY KEY using index "items_search_p2020w08_pkey";

alter table "pgstac"."items_search_p2020w09" add constraint "items_search_p2020w09_pkey" PRIMARY KEY using index "items_search_p2020w09_pkey";

alter table "pgstac"."items_search_p2020w10" add constraint "items_search_p2020w10_pkey" PRIMARY KEY using index "items_search_p2020w10_pkey";

alter table "pgstac"."items_search_p2020w11" add constraint "items_search_p2020w11_pkey" PRIMARY KEY using index "items_search_p2020w11_pkey";

alter table "pgstac"."items_search_p2020w12" add constraint "items_search_p2020w12_pkey" PRIMARY KEY using index "items_search_p2020w12_pkey";

alter table "pgstac"."items_search_p2020w13" add constraint "items_search_p2020w13_pkey" PRIMARY KEY using index "items_search_p2020w13_pkey";

alter table "pgstac"."items_search_p2020w14" add constraint "items_search_p2020w14_pkey" PRIMARY KEY using index "items_search_p2020w14_pkey";

alter table "pgstac"."items_search_p2020w15" add constraint "items_search_p2020w15_pkey" PRIMARY KEY using index "items_search_p2020w15_pkey";

alter table "pgstac"."items_search_p2020w16" add constraint "items_search_p2020w16_pkey" PRIMARY KEY using index "items_search_p2020w16_pkey";

alter table "pgstac"."items_search_p2020w17" add constraint "items_search_p2020w17_pkey" PRIMARY KEY using index "items_search_p2020w17_pkey";

alter table "pgstac"."items_search_p2020w18" add constraint "items_search_p2020w18_pkey" PRIMARY KEY using index "items_search_p2020w18_pkey";

alter table "pgstac"."items_search_p2020w19" add constraint "items_search_p2020w19_pkey" PRIMARY KEY using index "items_search_p2020w19_pkey";

alter table "pgstac"."items_search_p2020w20" add constraint "items_search_p2020w20_pkey" PRIMARY KEY using index "items_search_p2020w20_pkey";

alter table "pgstac"."items_search_p2020w21" add constraint "items_search_p2020w21_pkey" PRIMARY KEY using index "items_search_p2020w21_pkey";

alter table "pgstac"."items_search_p2020w22" add constraint "items_search_p2020w22_pkey" PRIMARY KEY using index "items_search_p2020w22_pkey";

alter table "pgstac"."items_search_p2020w23" add constraint "items_search_p2020w23_pkey" PRIMARY KEY using index "items_search_p2020w23_pkey";

alter table "pgstac"."items_search_p2020w24" add constraint "items_search_p2020w24_pkey" PRIMARY KEY using index "items_search_p2020w24_pkey";

alter table "pgstac"."items_search_p2020w25" add constraint "items_search_p2020w25_pkey" PRIMARY KEY using index "items_search_p2020w25_pkey";

alter table "pgstac"."items_search_p2020w26" add constraint "items_search_p2020w26_pkey" PRIMARY KEY using index "items_search_p2020w26_pkey";

alter table "pgstac"."items_search_p2020w27" add constraint "items_search_p2020w27_pkey" PRIMARY KEY using index "items_search_p2020w27_pkey";

alter table "pgstac"."items_search_p2020w28" add constraint "items_search_p2020w28_pkey" PRIMARY KEY using index "items_search_p2020w28_pkey";

alter table "pgstac"."items_search_p2020w29" add constraint "items_search_p2020w29_pkey" PRIMARY KEY using index "items_search_p2020w29_pkey";

alter table "pgstac"."items_search_p2020w30" add constraint "items_search_p2020w30_pkey" PRIMARY KEY using index "items_search_p2020w30_pkey";

alter table "pgstac"."items_search_p2020w31" add constraint "items_search_p2020w31_pkey" PRIMARY KEY using index "items_search_p2020w31_pkey";

alter table "pgstac"."items_search_p2020w32" add constraint "items_search_p2020w32_pkey" PRIMARY KEY using index "items_search_p2020w32_pkey";

alter table "pgstac"."items_search_p2020w33" add constraint "items_search_p2020w33_pkey" PRIMARY KEY using index "items_search_p2020w33_pkey";

alter table "pgstac"."items_search_p2020w34" add constraint "items_search_p2020w34_pkey" PRIMARY KEY using index "items_search_p2020w34_pkey";

alter table "pgstac"."items_search_p2020w35" add constraint "items_search_p2020w35_pkey" PRIMARY KEY using index "items_search_p2020w35_pkey";

alter table "pgstac"."items_search_p2020w36" add constraint "items_search_p2020w36_pkey" PRIMARY KEY using index "items_search_p2020w36_pkey";

alter table "pgstac"."items_search_p2020w37" add constraint "items_search_p2020w37_pkey" PRIMARY KEY using index "items_search_p2020w37_pkey";

alter table "pgstac"."items_search_p2020w38" add constraint "items_search_p2020w38_pkey" PRIMARY KEY using index "items_search_p2020w38_pkey";

alter table "pgstac"."items_search_p2020w39" add constraint "items_search_p2020w39_pkey" PRIMARY KEY using index "items_search_p2020w39_pkey";

alter table "pgstac"."items_search_p2020w40" add constraint "items_search_p2020w40_pkey" PRIMARY KEY using index "items_search_p2020w40_pkey";

alter table "pgstac"."items_search_p2020w41" add constraint "items_search_p2020w41_pkey" PRIMARY KEY using index "items_search_p2020w41_pkey";

alter table "pgstac"."items_search_p2020w42" add constraint "items_search_p2020w42_pkey" PRIMARY KEY using index "items_search_p2020w42_pkey";

alter table "pgstac"."items_search_p2020w43" add constraint "items_search_p2020w43_pkey" PRIMARY KEY using index "items_search_p2020w43_pkey";

alter table "pgstac"."items_search_p2020w44" add constraint "items_search_p2020w44_pkey" PRIMARY KEY using index "items_search_p2020w44_pkey";

alter table "pgstac"."items_search_p2020w45" add constraint "items_search_p2020w45_pkey" PRIMARY KEY using index "items_search_p2020w45_pkey";

alter table "pgstac"."items_search_p2020w46" add constraint "items_search_p2020w46_pkey" PRIMARY KEY using index "items_search_p2020w46_pkey";

alter table "pgstac"."items_search_p2020w47" add constraint "items_search_p2020w47_pkey" PRIMARY KEY using index "items_search_p2020w47_pkey";

alter table "pgstac"."items_search_p2020w48" add constraint "items_search_p2020w48_pkey" PRIMARY KEY using index "items_search_p2020w48_pkey";

alter table "pgstac"."items_search_p2020w49" add constraint "items_search_p2020w49_pkey" PRIMARY KEY using index "items_search_p2020w49_pkey";

alter table "pgstac"."items_search_p2020w50" add constraint "items_search_p2020w50_pkey" PRIMARY KEY using index "items_search_p2020w50_pkey";

alter table "pgstac"."items_search_p2020w51" add constraint "items_search_p2020w51_pkey" PRIMARY KEY using index "items_search_p2020w51_pkey";

alter table "pgstac"."items_search_p2020w52" add constraint "items_search_p2020w52_pkey" PRIMARY KEY using index "items_search_p2020w52_pkey";

alter table "pgstac"."items_search_p2020w53" add constraint "items_search_p2020w53_pkey" PRIMARY KEY using index "items_search_p2020w53_pkey";

alter table "pgstac"."items_search_p2021w01" add constraint "items_search_p2021w01_pkey" PRIMARY KEY using index "items_search_p2021w01_pkey";

alter table "pgstac"."items_search_p2021w02" add constraint "items_search_p2021w02_pkey" PRIMARY KEY using index "items_search_p2021w02_pkey";

alter table "pgstac"."items_search_p2021w03" add constraint "items_search_p2021w03_pkey" PRIMARY KEY using index "items_search_p2021w03_pkey";

alter table "pgstac"."items_search_p2021w04" add constraint "items_search_p2021w04_pkey" PRIMARY KEY using index "items_search_p2021w04_pkey";

alter table "pgstac"."items_search_p2021w05" add constraint "items_search_p2021w05_pkey" PRIMARY KEY using index "items_search_p2021w05_pkey";

alter table "pgstac"."items_search_p2021w06" add constraint "items_search_p2021w06_pkey" PRIMARY KEY using index "items_search_p2021w06_pkey";

alter table "pgstac"."items_search_p2021w07" add constraint "items_search_p2021w07_pkey" PRIMARY KEY using index "items_search_p2021w07_pkey";

alter table "pgstac"."items_search_p2021w08" add constraint "items_search_p2021w08_pkey" PRIMARY KEY using index "items_search_p2021w08_pkey";

alter table "pgstac"."items_search_p2021w09" add constraint "items_search_p2021w09_pkey" PRIMARY KEY using index "items_search_p2021w09_pkey";

alter table "pgstac"."items_search_p2021w10" add constraint "items_search_p2021w10_pkey" PRIMARY KEY using index "items_search_p2021w10_pkey";

alter table "pgstac"."items_search_p2021w11" add constraint "items_search_p2021w11_pkey" PRIMARY KEY using index "items_search_p2021w11_pkey";

alter table "pgstac"."items_search_p2021w12" add constraint "items_search_p2021w12_pkey" PRIMARY KEY using index "items_search_p2021w12_pkey";

alter table "pgstac"."items_search_p2021w13" add constraint "items_search_p2021w13_pkey" PRIMARY KEY using index "items_search_p2021w13_pkey";

alter table "pgstac"."items_search_p2021w14" add constraint "items_search_p2021w14_pkey" PRIMARY KEY using index "items_search_p2021w14_pkey";

alter table "pgstac"."items_search_p2021w15" add constraint "items_search_p2021w15_pkey" PRIMARY KEY using index "items_search_p2021w15_pkey";

alter table "pgstac"."items_search_p2021w16" add constraint "items_search_p2021w16_pkey" PRIMARY KEY using index "items_search_p2021w16_pkey";

alter table "pgstac"."items_search_p2021w17" add constraint "items_search_p2021w17_pkey" PRIMARY KEY using index "items_search_p2021w17_pkey";

alter table "pgstac"."items_search_p2021w18" add constraint "items_search_p2021w18_pkey" PRIMARY KEY using index "items_search_p2021w18_pkey";

alter table "pgstac"."items_search_p2021w19" add constraint "items_search_p2021w19_pkey" PRIMARY KEY using index "items_search_p2021w19_pkey";

alter table "pgstac"."items_search_p2021w20" add constraint "items_search_p2021w20_pkey" PRIMARY KEY using index "items_search_p2021w20_pkey";

alter table "pgstac"."items_search_p2021w21" add constraint "items_search_p2021w21_pkey" PRIMARY KEY using index "items_search_p2021w21_pkey";

alter table "pgstac"."items_search_p2021w22" add constraint "items_search_p2021w22_pkey" PRIMARY KEY using index "items_search_p2021w22_pkey";

alter table "pgstac"."items_search_p2021w23" add constraint "items_search_p2021w23_pkey" PRIMARY KEY using index "items_search_p2021w23_pkey";

alter table "pgstac"."items_search_p2021w24" add constraint "items_search_p2021w24_pkey" PRIMARY KEY using index "items_search_p2021w24_pkey";

alter table "pgstac"."items_search_p2021w25" add constraint "items_search_p2021w25_pkey" PRIMARY KEY using index "items_search_p2021w25_pkey";

alter table "pgstac"."items_search_p2021w26" add constraint "items_search_p2021w26_pkey" PRIMARY KEY using index "items_search_p2021w26_pkey";

alter table "pgstac"."items_search_p2021w27" add constraint "items_search_p2021w27_pkey" PRIMARY KEY using index "items_search_p2021w27_pkey";

alter table "pgstac"."items_search_p2021w28" add constraint "items_search_p2021w28_pkey" PRIMARY KEY using index "items_search_p2021w28_pkey";

alter table "pgstac"."items_search_p2021w29" add constraint "items_search_p2021w29_pkey" PRIMARY KEY using index "items_search_p2021w29_pkey";

alter table "pgstac"."items_search_p2021w30" add constraint "items_search_p2021w30_pkey" PRIMARY KEY using index "items_search_p2021w30_pkey";

alter table "pgstac"."items_search_p2021w31" add constraint "items_search_p2021w31_pkey" PRIMARY KEY using index "items_search_p2021w31_pkey";

alter table "pgstac"."items_search_p2021w32" add constraint "items_search_p2021w32_pkey" PRIMARY KEY using index "items_search_p2021w32_pkey";

alter table "pgstac"."items_search_p2021w33" add constraint "items_search_p2021w33_pkey" PRIMARY KEY using index "items_search_p2021w33_pkey";

alter table "pgstac"."items_search_p2021w34" add constraint "items_search_p2021w34_pkey" PRIMARY KEY using index "items_search_p2021w34_pkey";

alter table "pgstac"."items_search_p2021w35" add constraint "items_search_p2021w35_pkey" PRIMARY KEY using index "items_search_p2021w35_pkey";

alter table "pgstac"."items_search_p2021w36" add constraint "items_search_p2021w36_pkey" PRIMARY KEY using index "items_search_p2021w36_pkey";

alter table "pgstac"."items_search_p2021w37" add constraint "items_search_p2021w37_pkey" PRIMARY KEY using index "items_search_p2021w37_pkey";

alter table "pgstac"."items_search_p2021w38" add constraint "items_search_p2021w38_pkey" PRIMARY KEY using index "items_search_p2021w38_pkey";

alter table "pgstac"."items_search_p2021w39" add constraint "items_search_p2021w39_pkey" PRIMARY KEY using index "items_search_p2021w39_pkey";

alter table "pgstac"."items_search_p2021w40" add constraint "items_search_p2021w40_pkey" PRIMARY KEY using index "items_search_p2021w40_pkey";

alter table "pgstac"."items_search_p2021w41" add constraint "items_search_p2021w41_pkey" PRIMARY KEY using index "items_search_p2021w41_pkey";

alter table "pgstac"."items_search_p2021w42" add constraint "items_search_p2021w42_pkey" PRIMARY KEY using index "items_search_p2021w42_pkey";

alter table "pgstac"."items_search_p2021w43" add constraint "items_search_p2021w43_pkey" PRIMARY KEY using index "items_search_p2021w43_pkey";

alter table "pgstac"."items_search_p2021w44" add constraint "items_search_p2021w44_pkey" PRIMARY KEY using index "items_search_p2021w44_pkey";

alter table "pgstac"."items_search_p2021w45" add constraint "items_search_p2021w45_pkey" PRIMARY KEY using index "items_search_p2021w45_pkey";

alter table "pgstac"."items_search_p2021w46" add constraint "items_search_p2021w46_pkey" PRIMARY KEY using index "items_search_p2021w46_pkey";

alter table "pgstac"."items_search_p2021w47" add constraint "items_search_p2021w47_pkey" PRIMARY KEY using index "items_search_p2021w47_pkey";

alter table "pgstac"."items_search_p2021w48" add constraint "items_search_p2021w48_pkey" PRIMARY KEY using index "items_search_p2021w48_pkey";

alter table "pgstac"."items_search_p2021w49" add constraint "items_search_p2021w49_pkey" PRIMARY KEY using index "items_search_p2021w49_pkey";

alter table "pgstac"."items_search_p2021w50" add constraint "items_search_p2021w50_pkey" PRIMARY KEY using index "items_search_p2021w50_pkey";

alter table "pgstac"."items_search_p2021w51" add constraint "items_search_p2021w51_pkey" PRIMARY KEY using index "items_search_p2021w51_pkey";

alter table "pgstac"."items_search_p2021w52" add constraint "items_search_p2021w52_pkey" PRIMARY KEY using index "items_search_p2021w52_pkey";

alter table "pgstac"."items_search_p2022w01" add constraint "items_search_p2022w01_pkey" PRIMARY KEY using index "items_search_p2022w01_pkey";

alter table "pgstac"."items_search_p2022w02" add constraint "items_search_p2022w02_pkey" PRIMARY KEY using index "items_search_p2022w02_pkey";

alter table "pgstac"."items_search_p2022w03" add constraint "items_search_p2022w03_pkey" PRIMARY KEY using index "items_search_p2022w03_pkey";

alter table "pgstac"."items_search_p2022w04" add constraint "items_search_p2022w04_pkey" PRIMARY KEY using index "items_search_p2022w04_pkey";

alter table "pgstac"."items_search_p2022w05" add constraint "items_search_p2022w05_pkey" PRIMARY KEY using index "items_search_p2022w05_pkey";

alter table "pgstac"."items_search_p2022w06" add constraint "items_search_p2022w06_pkey" PRIMARY KEY using index "items_search_p2022w06_pkey";

alter table "pgstac"."items_search_p2022w07" add constraint "items_search_p2022w07_pkey" PRIMARY KEY using index "items_search_p2022w07_pkey";

alter table "pgstac"."items_search_p2022w08" add constraint "items_search_p2022w08_pkey" PRIMARY KEY using index "items_search_p2022w08_pkey";

alter table "pgstac"."items_search_p2022w09" add constraint "items_search_p2022w09_pkey" PRIMARY KEY using index "items_search_p2022w09_pkey";

alter table "pgstac"."items_search_p2022w10" add constraint "items_search_p2022w10_pkey" PRIMARY KEY using index "items_search_p2022w10_pkey";

alter table "pgstac"."items_search_p2022w11" add constraint "items_search_p2022w11_pkey" PRIMARY KEY using index "items_search_p2022w11_pkey";

alter table "pgstac"."items_search_p2022w12" add constraint "items_search_p2022w12_pkey" PRIMARY KEY using index "items_search_p2022w12_pkey";

alter table "pgstac"."items_search_p2022w13" add constraint "items_search_p2022w13_pkey" PRIMARY KEY using index "items_search_p2022w13_pkey";

alter table "pgstac"."items_search_p2022w14" add constraint "items_search_p2022w14_pkey" PRIMARY KEY using index "items_search_p2022w14_pkey";

alter table "pgstac"."items_search_p2022w15" add constraint "items_search_p2022w15_pkey" PRIMARY KEY using index "items_search_p2022w15_pkey";

alter table "pgstac"."items_search_p2022w16" add constraint "items_search_p2022w16_pkey" PRIMARY KEY using index "items_search_p2022w16_pkey";

alter table "pgstac"."items_search_p2022w17" add constraint "items_search_p2022w17_pkey" PRIMARY KEY using index "items_search_p2022w17_pkey";

alter table "pgstac"."items_search_p2022w18" add constraint "items_search_p2022w18_pkey" PRIMARY KEY using index "items_search_p2022w18_pkey";

alter table "pgstac"."items_search_template" add constraint "items_search_template_pkey" PRIMARY KEY using index "items_search_template_pkey";

set check_function_bodies = off;

CREATE OR REPLACE FUNCTION pgstac.all_collections()
 RETURNS jsonb
 LANGUAGE sql
 SET search_path TO 'pgstac', 'public'
AS $function$
SELECT jsonb_agg(content) FROM collections;
;
$function$
;

CREATE OR REPLACE FUNCTION pgstac.array_idents(_js jsonb)
 RETURNS text
 LANGUAGE sql
 IMMUTABLE PARALLEL SAFE
AS $function$
  SELECT string_agg(quote_ident(v),',') FROM jsonb_array_elements_text(_js) v;
$function$
;

CREATE OR REPLACE FUNCTION pgstac.bbox_geom(_bbox jsonb)
 RETURNS box3d
 LANGUAGE sql
 IMMUTABLE PARALLEL SAFE
AS $function$
SELECT CASE jsonb_array_length(_bbox)
    WHEN 4 THEN
        ST_SetSRID(ST_MakeEnvelope(
            (_bbox->>0)::float,
            (_bbox->>1)::float,
            (_bbox->>2)::float,
            (_bbox->>3)::float
        ),4326)
    WHEN 6 THEN
    ST_SetSRID(ST_3DMakeBox(
        ST_MakePoint(
            (_bbox->>0)::float,
            (_bbox->>1)::float,
            (_bbox->>2)::float
        ),
        ST_MakePoint(
            (_bbox->>3)::float,
            (_bbox->>4)::float,
            (_bbox->>5)::float
        )
    ),4326)
    ELSE null END;
;
$function$
;

CREATE OR REPLACE FUNCTION pgstac.collection_bbox(id text)
 RETURNS jsonb
 LANGUAGE sql
 IMMUTABLE PARALLEL SAFE
 SET search_path TO 'pgstac', 'public'
AS $function$
SELECT (replace(replace(replace(st_extent(geometry)::text,'BOX(','[['),')',']]'),' ',','))::jsonb
FROM items_search WHERE collection_id=$1;
;
$function$
;

CREATE OR REPLACE FUNCTION pgstac.collection_temporal_extent(id text)
 RETURNS jsonb
 LANGUAGE sql
 IMMUTABLE PARALLEL SAFE
 SET search_path TO 'pgstac', 'public'
AS $function$
SELECT to_jsonb(array[array[min(datetime)::text, max(datetime)::text]])
FROM items_search WHERE collection_id=$1;
;
$function$
;

CREATE OR REPLACE FUNCTION pgstac.collections_trigger_func()
 RETURNS trigger
 LANGUAGE plpgsql
 SET search_path TO 'pgstac', 'public'
AS $function$
BEGIN
    IF pg_trigger_depth() = 1 THEN
        PERFORM create_collection(NEW.content);
        RETURN NULL;
    END IF;
    RETURN NEW;
END;
$function$
;

CREATE OR REPLACE FUNCTION pgstac.count_by_delim(text, text)
 RETURNS integer
 LANGUAGE sql
 IMMUTABLE PARALLEL SAFE
AS $function$
SELECT count(*) FROM regexp_split_to_table($1,$2);
$function$
;

CREATE OR REPLACE FUNCTION pgstac.create_collection(data jsonb)
 RETURNS void
 LANGUAGE sql
 SET search_path TO 'pgstac', 'public'
AS $function$
    INSERT INTO collections (content)
    VALUES (data)
    ON CONFLICT (id) DO
    UPDATE
        SET content=EXCLUDED.content
    ;
$function$
;

CREATE OR REPLACE FUNCTION pgstac.create_item(data jsonb)
 RETURNS void
 LANGUAGE sql
 SET search_path TO 'pgstac', 'public'
AS $function$
    DELETE FROM items WHERE id=data->>'id';
    INSERT INTO items (content) VALUES (data);
$function$
;

CREATE OR REPLACE FUNCTION pgstac.delete_item(_id text)
 RETURNS void
 LANGUAGE sql
 SET search_path TO 'pgstac', 'public'
AS $function$
    DELETE FROM items WHERE id = _id;
$function$
;

CREATE OR REPLACE FUNCTION pgstac.feature_to_item(value jsonb)
 RETURNS pgstac.item
 LANGUAGE sql
 IMMUTABLE PARALLEL SAFE
 SET search_path TO 'pgstac', 'public'
AS $function$
    SELECT
        value->>'id' as id,
        CASE
            WHEN value->>'geometry' IS NOT NULL THEN
                ST_GeomFromGeoJSON(value->>'geometry')
            WHEN value->>'bbox' IS NOT NULL THEN
                ST_MakeEnvelope(
                    (value->'bbox'->>0)::float,
                    (value->'bbox'->>1)::float,
                    (value->'bbox'->>2)::float,
                    (value->'bbox'->>3)::float,
                    4326
                )
            ELSE NULL
        END as geometry,
        properties_idx(value ->'properties') as properties,
        value->>'collection' as collection_id,
        (value->'properties'->>'datetime')::timestamptz as datetime
;
$function$
;

CREATE OR REPLACE FUNCTION pgstac.features_to_items(value jsonb)
 RETURNS SETOF pgstac.item
 LANGUAGE sql
 IMMUTABLE PARALLEL SAFE
 SET search_path TO 'pgstac', 'public'
AS $function$
    WITH features AS (
        SELECT
        jsonb_array_elements(
            CASE
                WHEN jsonb_typeof(value) = 'array' THEN value
                WHEN value->>'type' = 'Feature' THEN '[]'::jsonb || value
                WHEN value->>'type' = 'FeatureCollection' THEN value->'features'
                ELSE NULL
            END
        ) as value
    )
    SELECT feature_to_item(value) FROM features
    ;
$function$
;

CREATE OR REPLACE FUNCTION pgstac.filter_by_order(_item pgstac.item, _sort jsonb, _type text)
 RETURNS text
 LANGUAGE plpgsql
 SET search_path TO 'pgstac', 'public'
AS $function$
DECLARE
sorts RECORD;
filts text[];
itemval text;
op text;
idop text;
ret text;
eq_flag text;
_item_j jsonb := to_jsonb(_item);
BEGIN
FOR sorts IN SELECT * FROM sort_base(_sort) LOOP
    IF sorts.col = 'datetime' THEN
        CONTINUE;
    END IF;
    IF sorts.col='id' AND _type IN ('prev','next') THEN
        eq_flag := '';
    ELSE
        eq_flag := '=';
    END IF;

    op := concat(
        CASE
            WHEN _type in ('prev','first') AND sorts.dir = 'ASC' THEN '<'
            WHEN _type in ('last','next') AND sorts.dir = 'ASC' THEN '>'
            WHEN _type in ('prev','first') AND sorts.dir = 'DESC' THEN '>'
            WHEN _type in ('last','next') AND sorts.dir = 'DESC' THEN '<'
        END,
        eq_flag
    );

    IF _item_j ? sorts.col THEN
        filts = array_append(filts, format('%s %s %L', sorts.col, op, _item_j->>sorts.col));
    END IF;
END LOOP;
ret := coalesce(array_to_string(filts,' AND '), 'TRUE');
RAISE NOTICE 'Order Filter %', ret;
RETURN ret;
END;
$function$
;

CREATE OR REPLACE FUNCTION pgstac.filter_by_order(item_id text, _sort jsonb, _type text)
 RETURNS text
 LANGUAGE plpgsql
 SET search_path TO 'pgstac', 'public'
AS $function$
DECLARE
item item;
BEGIN
SELECT * INTO item FROM items_search WHERE id=item_id;
RETURN filter_by_order(item, _sort, _type);
END;
$function$
;

CREATE OR REPLACE FUNCTION pgstac.get_collection(id text)
 RETURNS jsonb
 LANGUAGE sql
 SET search_path TO 'pgstac', 'public'
AS $function$
SELECT content FROM collections
WHERE id=$1
;
$function$
;

CREATE OR REPLACE FUNCTION pgstac.get_item(_id text)
 RETURNS jsonb
 LANGUAGE sql
 SET search_path TO 'pgstac', 'public'
AS $function$
SELECT content FROM items WHERE id=_id;
$function$
;

CREATE OR REPLACE FUNCTION pgstac.in_array_q(col text, arr jsonb)
 RETURNS text
 LANGUAGE sql
 IMMUTABLE PARALLEL SAFE
AS $function$
SELECT CASE jsonb_typeof(arr) WHEN 'array' THEN format('%I = ANY(textarr(%L))', col, arr) ELSE format('%I = %L', col, arr) END;
$function$
;

CREATE OR REPLACE FUNCTION pgstac.items_by_partition(_where text DEFAULT 'TRUE'::text, _dtrange tstzrange DEFAULT tstzrange('-infinity'::timestamp with time zone, 'infinity'::timestamp with time zone), _orderby text DEFAULT 'datetime DESC, id DESC'::text, _limit integer DEFAULT 10)
 RETURNS SETOF text
 LANGUAGE plpgsql
 SET search_path TO 'pgstac', 'public'
AS $function$
DECLARE
partition_query text;
main_query text;
batchcount int;
counter int := 0;
p record;
BEGIN
IF _orderby ILIKE 'datetime d%' THEN
    partition_query := format($q$
        SELECT partition
        FROM items_search_partitions
        WHERE tstzrange && $1
        ORDER BY tstzrange DESC;
    $q$);
ELSIF _orderby ILIKE 'datetime a%' THEN
    partition_query := format($q$
        SELECT partition
        FROM items_search_partitions
        WHERE tstzrange && $1
        ORDER BY tstzrange ASC;
    $q$);
ELSE
    partition_query := format($q$
        SELECT 'items_search' as partition WHERE $1 IS NOT NULL;
    $q$);
END IF;

FOR p IN
    EXECUTE partition_query USING (_dtrange)
LOOP
    IF lower(_dtrange)::timestamptz > '-infinity' THEN
        _where := concat(_where,format(' AND datetime >= %L',lower(_dtrange)::timestamptz::text));
    END IF;
    IF upper(_dtrange)::timestamptz < 'infinity' THEN
        _where := concat(_where,format(' AND datetime <= %L',upper(_dtrange)::timestamptz::text));
    END IF;

    main_query := format($q$
        SELECT id FROM %I
        WHERE %s
        ORDER BY %s
        LIMIT %s - $1
    $q$, p.partition::text, _where, _orderby, _limit
    );
    RAISE NOTICE 'Partition Query %', main_query;
    RAISE NOTICE '%', counter;
    RETURN QUERY EXECUTE main_query USING counter;

    GET DIAGNOSTICS batchcount = ROW_COUNT;
    counter := counter + batchcount;
    RAISE NOTICE 'FOUND %', batchcount;
    IF counter >= _limit THEN
        EXIT;
    END IF;
    RAISE NOTICE 'ADDED % FOR A TOTAL OF %', batchcount, counter;
END LOOP;
RETURN;
END;
$function$
;

create or replace view "pgstac"."items_search_partitions" as  WITH base AS (
         SELECT ((c.oid)::regclass)::text AS partition,
            pg_get_expr(c.relpartbound, c.oid) AS _constraint,
            regexp_matches(pg_get_expr(c.relpartbound, c.oid), '\(''([0-9 :+-]*)''\).*\(''([0-9 :+-]*)''\)'::text) AS t,
            (c.reltuples)::bigint AS est_cnt
           FROM pg_class c,
            pg_inherits i
          WHERE ((c.oid = i.inhrelid) AND (i.inhparent = ('pgstac.items_search'::regclass)::oid))
        )
 SELECT base.partition,
    tstzrange((base.t[1])::timestamp with time zone, (base.t[2])::timestamp with time zone) AS tstzrange,
    base.est_cnt
   FROM base
  WHERE (base.est_cnt > 0)
  ORDER BY (tstzrange((base.t[1])::timestamp with time zone, (base.t[2])::timestamp with time zone)) DESC;


CREATE OR REPLACE FUNCTION pgstac.items_trigger_func()
 RETURNS trigger
 LANGUAGE plpgsql
 SET search_path TO 'pgstac', 'public'
AS $function$
DECLARE
BEGIN
    DELETE FROM items_search WHERE id = NEW.id;
    IF TG_OP IN ('INSERT', 'UPDATE') AND pg_trigger_depth() = 1 THEN
        INSERT INTO items (content) VALUES (NEW.content)
        ON CONFLICT (id) DO UPDATE
            SET content=EXCLUDED.content;
        INSERT INTO items_search SELECT * FROM feature_to_item(NEW.content)
        ON CONFLICT DO NOTHING
        ;
        RETURN NULL;
    END IF;
    RETURN NEW;
END;
$function$
;

CREATE OR REPLACE FUNCTION pgstac.properties_idx(_in jsonb)
 RETURNS jsonb
 LANGUAGE sql
 IMMUTABLE PARALLEL SAFE
AS $function$
WITH kv AS (
    SELECT key, value FROM jsonb_each(_in) WHERE key = 'datetime' OR jsonb_typeof(value) IN ('object','array')
) SELECT lower((_in - array_agg(key))::text)::jsonb FROM kv;
$function$
;

CREATE OR REPLACE FUNCTION pgstac.rsort(_sort jsonb)
 RETURNS text
 LANGUAGE sql
 PARALLEL SAFE
 SET search_path TO 'pgstac', 'public'
AS $function$
SELECT string_agg(rsort,', ') FROM sort_base(_sort);
$function$
;

CREATE OR REPLACE FUNCTION pgstac.search(_search jsonb DEFAULT '{}'::jsonb)
 RETURNS SETOF jsonb
 LANGUAGE plpgsql
 SET search_path TO 'pgstac', 'public'
AS $function$
DECLARE
qstart timestamptz := clock_timestamp();
_sort text := '';
_rsort text := '';
_limit int := 10;
_geom geometry;
qa text[];
pq text[];
query text;
pq_prop record;
pq_op record;
prev_id text := NULL;
next_id text := NULL;
whereq text := 'TRUE';
links jsonb := '[]'::jsonb;
token text;
tok_val text;
tok_q text := 'TRUE';
tok_sort text;
first_id text;
first_dt timestamptz;
last_id text;
sort text;
rsort text;
dt text[];
dqa text[];
dq text;
mq_where text;
startdt timestamptz;
enddt timestamptz;
item items_search%ROWTYPE;
counter int := 0;
batchcount int;
month timestamptz;
m record;
_dtrange tstzrange := tstzrange('-infinity','infinity');
_dtsort text;
_token_dtrange tstzrange := tstzrange('-infinity','infinity');
_token_record items_search%ROWTYPE;
is_prev boolean := false;
BEGIN
-- Create table from sort query of items to sort
CREATE TEMP TABLE pgstac_tmp_sorts ON COMMIT DROP AS SELECT * FROM sort_base(_search->'sortby');

-- Get the datetime sort direction, necessary for efficient cycling through partitions
SELECT INTO _dtsort dir FROM pgstac_tmp_sorts WHERE key='datetime';
RAISE NOTICE '_dtsort: %',_dtsort;

SELECT INTO _sort string_agg(s.sort,', ') FROM pgstac_tmp_sorts s;
SELECT INTO _rsort string_agg(s.rsort,', ') FROM pgstac_tmp_sorts s;
tok_sort := _sort;


-- Get datetime from query as a tstzrange
IF _search ? 'datetime' THEN
    _dtrange := search_dtrange(_search->'datetime');
    _token_dtrange := _dtrange;
END IF;

-- Get the paging token
IF _search ? 'token' THEN
    token := _search->>'token';
    tok_val := substr(token,6);
    IF starts_with(token, 'prev:') THEN
        is_prev := true;
    END IF;
    SELECT INTO _token_record * FROM items_search WHERE id=tok_val;
    IF
        (is_prev AND _dtsort = 'DESC')
        OR
        (not is_prev AND _dtsort = 'ASC')
    THEN
        _token_dtrange := tstzrange(_token_record.datetime, 'infinity');
    ELSIF
        _dtsort IS NOT NULL
    THEN
        _token_dtrange := tstzrange('-infinity',_token_record.datetime);
    END IF;
    IF is_prev THEN
        tok_q := filter_by_order(tok_val,  _search->'sortby', 'first');
        _sort := _rsort;
    ELSIF starts_with(token, 'next:') THEN
       tok_q := filter_by_order(tok_val,  _search->'sortby', 'last');
    END IF;
END IF;
RAISE NOTICE 'timing: %', age(clock_timestamp(), qstart);
RAISE NOTICE 'tok_q: % _token_dtrange: %', tok_q, _token_dtrange;

IF _search ? 'ids' THEN
    RAISE NOTICE 'searching solely based on ids... %',_search;
    qa := array_append(qa, in_array_q('id', _search->'ids'));
ELSE
    IF _search ? 'intersects' THEN
        _geom := ST_SetSRID(ST_GeomFromGeoJSON(_search->>'intersects'), 4326);
    ELSIF _search ? 'bbox' THEN
        _geom := bbox_geom(_search->'bbox');
    END IF;

    IF _geom IS NOT NULL THEN
        qa := array_append(qa, format('st_intersects(geometry, %L::geometry)',_geom));
    END IF;

    IF _search ? 'collections' THEN
        qa := array_append(qa, in_array_q('collection_id', _search->'collections'));
    END IF;

    IF _search ? 'query' THEN
        qa := array_cat(qa,
            stac_query(_search->'query')
        );
    END IF;
END IF;

IF _search ? 'limit' THEN
    _limit := (_search->>'limit')::int;
END IF;


whereq := COALESCE(array_to_string(qa,' AND '),' TRUE ');
dq := COALESCE(array_to_string(dqa,' AND '),' TRUE ');
RAISE NOTICE 'timing before temp table: %', age(clock_timestamp(), qstart);

CREATE TEMP TABLE results_page ON COMMIT DROP AS
SELECT items_by_partition(
    concat(whereq, ' AND ', tok_q),
    _token_dtrange,
    _sort,
    _limit + 1
) as id;
RAISE NOTICE 'timing after temp table: %', age(clock_timestamp(), qstart);

RAISE NOTICE 'timing before min/max: %', age(clock_timestamp(), qstart);

IF is_prev THEN
    SELECT INTO last_id, first_id
        first_value(id) OVER (),
        last_value(id) OVER ()
    FROM results_page;
ELSE
    SELECT INTO first_id, last_id
        first_value(id) OVER (),
        last_value(id) OVER ()
    FROM results_page;
END IF;
RAISE NOTICE 'firstid: %, lastid %', first_id, last_id;
RAISE NOTICE 'timing after min/max: %', age(clock_timestamp(), qstart);





next_id := last_id;
RAISE NOTICE 'next_id: %', next_id;

IF tok_q = 'TRUE' THEN
    RAISE NOTICE 'Not a paging query, no previous item';
ELSE
    RAISE NOTICE 'Getting previous item id';
    RAISE NOTICE 'timing: %', age(clock_timestamp(), qstart);
    SELECT INTO _token_record * FROM items_search WHERE id=first_id;
    IF
        _dtsort = 'DESC'
    THEN
        _token_dtrange := _dtrange * tstzrange(_token_record.datetime, 'infinity');
    ELSE
        _token_dtrange := _dtrange * tstzrange('-infinity',_token_record.datetime);
    END IF;
    RAISE NOTICE '% %', _token_dtrange, _dtrange;
    SELECT INTO prev_id items_by_partition(
        concat(whereq, ' AND ', filter_by_order(first_id, _search->'sortby', 'prev')),
        _token_dtrange,
        _rsort,
        1
    ) as id;
    RAISE NOTICE 'timing: %', age(clock_timestamp(), qstart);

    RAISE NOTICE 'prev_id: %', prev_id;
END IF;


RETURN QUERY
WITH features AS (
    SELECT jsonb_agg(content) features
    FROM items WHERE id IN (SELECT id FROM results_page LIMIT _limit)
)
SELECT jsonb_build_object(
    'type', 'FeatureCollection',
    'features', coalesce(features,'[]'::jsonb),
    'links', links,
    'timeStamp', now(),
    'next', next_id,
    'prev', prev_id
)
FROM features
;


END;
$function$
;

CREATE OR REPLACE FUNCTION pgstac.search_dtrange(_indate jsonb, OUT _tstzrange tstzrange)
 RETURNS tstzrange
 LANGUAGE sql
 IMMUTABLE PARALLEL SAFE
AS $function$
WITH t AS (
    SELECT CASE
        WHEN jsonb_typeof(_indate) = 'array' THEN
            textarr(_indate)
        ELSE
            regexp_split_to_array(
                btrim(_indate::text,'"'),
                '/'
            )
        END AS arr
)
, t1 AS (
    SELECT
        CASE
            WHEN arr[1] = '..' THEN '-infinity'::timestamptz
            ELSE arr[1]::timestamptz
        END AS st,
        CASE
            WHEN array_upper(arr,1) = 1 THEN null
            WHEN arr[2] = '..' THEN 'infinity'::timestamptz
            ELSE arr[2]::timestamptz
        END AS et
    FROM t
)
SELECT
    CASE
        WHEN et IS NULL
            THEN tstzrange(st, st, '()')
        ELSE
            tstzrange(st, et)
    END AS _tstzrange
FROM t1;
$function$
;

CREATE OR REPLACE FUNCTION pgstac.sort(_sort jsonb)
 RETURNS text
 LANGUAGE sql
 PARALLEL SAFE
 SET search_path TO 'pgstac', 'public'
AS $function$
SELECT string_agg(sort,', ') FROM sort_base(_sort);
$function$
;

CREATE OR REPLACE FUNCTION pgstac.sort_base(_sort jsonb DEFAULT '[{"field": "datetime", "direction": "desc"}]'::jsonb, OUT key text, OUT col text, OUT dir text, OUT rdir text, OUT sort text, OUT rsort text)
 RETURNS SETOF record
 LANGUAGE sql
AS $function$
WITH sorts AS (
    SELECT
        value->>'field' as key,
        (split_stac_path(value->>'field')).jspathtext as col,
        coalesce(upper(value->>'direction'),'ASC') as dir
    FROM jsonb_array_elements('[]'::jsonb || coalesce(_sort,'[{"field":"datetime","direction":"desc"}]') )
)
SELECT
    key,
    col,
    dir,
    CASE dir WHEN 'DESC' THEN 'ASC' ELSE 'ASC' END as rdir,
    concat(col, ' ', dir, ' NULLS LAST ') AS sort,
    concat(col,' ', CASE dir WHEN 'DESC' THEN 'ASC' ELSE 'ASC' END, ' NULLS LAST ') AS rsort
FROM sorts
UNION ALL
SELECT 'id', 'id', 'DESC', 'ASC', 'id DESC', 'id ASC'
;
$function$
;

CREATE OR REPLACE FUNCTION pgsta