# -*- coding: utf-8 -*-
#
# zsl documentation build configuration file, created by
# sphinx-quickstart on Tue Dec 20 16:26:44 2016.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
import pkgutil
import sys

src_path = os.path.abspath(os.path.join(os.path.dirname(__file__), '..'))
sys.path.insert(0, src_path)

from recommonmark.parser import CommonMarkParser

# -- General configuration ------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = ['sphinx.ext.autodoc',
              'sphinx.ext.intersphinx',
              'sphinx.ext.ifconfig',
              'sphinx.ext.viewcode']

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
source_suffix = ['.rst', '.md']
# source_suffix = '.rst'
source_parsers = {'.md': CommonMarkParser}

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = u'zsl'
copyright = u'2016, Atteq s.r.o.'
author = u'Atteq s.r.o.'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
version = u'0.9a'
# The full version, including alpha/beta/rc tags.
release = u'0.9a'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store']

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = False

# -- Options for HTML output ----------------------------------------------

import sphinx_rtd_theme

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = "sphinx_rtd_theme"
html_theme_path = [sphinx_rtd_theme.get_html_theme_path()]

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
# html_theme_options = {}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

# -- Options for HTMLHelp output ------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = 'zsldoc'

# -- Options for LaTeX output ---------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',

    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',

    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',

    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (master_doc, 'zsl.tex', u'zsl Documentation',
     u'Atteq s.r.o.', 'manual'),
]

# -- Options for manual page output ---------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (master_doc, 'zsl', u'zsl Documentation',
     [author], 1)
]

# -- Options for Texinfo output -------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (master_doc, 'zsl', u'zsl Documentation',
     author, 'zsl', 'One line description of project.',
     'Miscellaneous'),
]

# Example configuration for intersphinx: refer to the Python standard library.
intersphinx_mapping = {'https://docs.python.org/': None}

UNDOC = []

UNDOC_PYTHON_3 = ["zsl.application.containers.gearman_container",
                  "zsl.application.modules.gearman_module",
                  "zsl.interface.gearman.json_data_encoder",
                  "zsl.interface.gearman.task_filler",
                  "zsl.interface.gearman.worker",
                  "zsl.tasks.zsl.cors_test_task",
                  "zsl.tasks.zsl.schedule_gearman_task",
                  "zsl.tasks.zsl.schedule_kill_worker_task",
                  "zsl.utils.background_task",
                  "zsl.utils.gearman_helper"]
UNDOC_PYTHON_2 = []


def api_doc_generate():
    def create_forbidden_modules():
        forbidden_modules = UNDOC
        forbidden_modules += UNDOC_PYTHON_3 if sys.version_info >= (3, 0) else \
            UNDOC_PYTHON_2
        return set(forbidden_modules)

    forbidden_modules = create_forbidden_modules()

    def write_header(f):
        f.writelines(["API\n",
                      "###\n",
                      "\n",
                      ".. toctree::\n",
                      "   :maxdepth: 2\n",
                      "   :caption: Contents:\n",
                      "\n"])

    def is_module_hidden(modname):
        return modname.split('.')[-1].startswith('_')

    def is_module_from_zsl(modname):
        return modname.startswith('zsl.')

    def is_module_forbidden(modname):
        return modname in forbidden_modules

    def gather_modules():

        ignore_error = lambda x: None
        for _, modname, _ in pkgutil.walk_packages(onerror=ignore_error):
            if not is_module_from_zsl(modname):
                continue

            if is_module_hidden(modname):
                continue

            if is_module_forbidden(modname):
                continue

            yield modname

    def write_module(f, modname):
        f.writelines(["\n",
                      ".. automodule:: {0}\n".format(modname),
                      "   :members:\n",
                      "   :undoc-members:\n"])

    def write_modules(f, modnames):
        for modname in modnames:
            write_module(f, modname)

    with open(os.path.join(os.path.dirname(__file__), 'api.rst'), 'w') as f:
        write_header(f)
        modules = list(gather_modules())
        write_modules(f, modules)


api_doc_generate()
