[![PyPI version](https://badge.fury.io/py/cechmate.svg)](https://badge.fury.io/py/cechmate)
[![Downloads](https://pypip.in/download/cechmate/badge.svg)](https://pypi.python.org/pypi/cechmate/)
[![Build Status](https://travis-ci.org/scikit-tda/cechmate.svg?branch=master)](https://travis-ci.org/scikit-tda/cechmate)
[![codecov](https://codecov.io/gh/scikit-tda/cechmate/branch/master/graph/badge.svg)](https://codecov.io/gh/scikit-tda/cechmate)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)

This library provides easy to use constructors for custom filtrations that are suitable for use with [Phat](https://github.com/xoltar/phat). 
Phat currently provides a clean interface for persistence reduction algorithms for boundary matrices. 
This tool helps bridge the gap between data and boundary matrices.  
Currently, we support construction of Alpha, Rips, and Cech filtrations, and provide an easy interface for Phat.

If you have a particular filtration you would like implemented, please feel free to reach out and we can work on helping with implementation and integration, so others can use it.

# Setup

We use the following dependencies in this library

* Numpy
* Scipy
* Matplotlib
* Phat


The latest version of Cechmate can be found on Pypi and installed with pip:

```
pip install cechmate
```

# Contributions


We welcome contributions of all shapes and sizes. There are lots of opportunities for potential projects, so please get in touch if you would like to help out. Everything from an implementation of your favorite distance, notebooks, examples, and documentation are all equally valuable so please don't feel you can't contribute. 

To contribute please fork the project make your changes and submit a pull request. We will do our best to work through any issues with you and get your code merged into the main branch.


## Documentation

Check out complete documentation at [cechmate.scikit-tda.org](https://cechmate.scikit-tda.org/)