# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Client']


class Client(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addons: Optional[pulumi.Input[pulumi.InputType['ClientAddonsArgs']]] = None,
                 allowed_logout_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 app_type: Optional[pulumi.Input[str]] = None,
                 callbacks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 client_metadata: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 client_secret_rotation_trigger: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 cross_origin_auth: Optional[pulumi.Input[bool]] = None,
                 cross_origin_loc: Optional[pulumi.Input[str]] = None,
                 custom_login_page: Optional[pulumi.Input[str]] = None,
                 custom_login_page_on: Optional[pulumi.Input[bool]] = None,
                 custom_login_page_preview: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encryption_key: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 form_template: Optional[pulumi.Input[str]] = None,
                 grant_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 initiate_login_uri: Optional[pulumi.Input[str]] = None,
                 is_first_party: Optional[pulumi.Input[bool]] = None,
                 is_token_endpoint_ip_header_trusted: Optional[pulumi.Input[bool]] = None,
                 jwt_configuration: Optional[pulumi.Input[pulumi.InputType['ClientJwtConfigurationArgs']]] = None,
                 logo_uri: Optional[pulumi.Input[str]] = None,
                 mobile: Optional[pulumi.Input[pulumi.InputType['ClientMobileArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oidc_conformant: Optional[pulumi.Input[bool]] = None,
                 refresh_token: Optional[pulumi.Input[pulumi.InputType['ClientRefreshTokenArgs']]] = None,
                 sso: Optional[pulumi.Input[bool]] = None,
                 sso_disabled: Optional[pulumi.Input[bool]] = None,
                 token_endpoint_auth_method: Optional[pulumi.Input[str]] = None,
                 web_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        With this resource, you can set up applications that use Auth0 for authentication and configure allowed callback URLs and secrets for these applications. Depending on your plan, you may also configure add-ons to allow your application to call another application's API (such as Firebase and AWS) on behalf of an authenticated user.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        my_client = auth0.Client("myClient",
            addons=auth0.ClientAddonsArgs(
                firebase={
                    "clientEmail": "john.doe@example.com",
                    "lifetimeInSeconds": 1,
                    "privateKey": "wer",
                    "privateKeyId": "qwreerwerwe",
                },
                samlp=auth0.ClientAddonsSamlpArgs(
                    audience="https://example.com/saml",
                    create_upn_claim=False,
                    map_identities=False,
                    map_unknown_claims_as_is=False,
                    mappings={
                        "email": "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress",
                        "name": "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/name",
                    },
                    name_identifier_format="urn:oasis:names:tc:SAML:2.0:nameid-format:persistent",
                    name_identifier_probes=["http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress"],
                    passthrough_claims_with_no_mapping=False,
                ),
            ),
            allowed_logout_urls=["https://example.com"],
            allowed_origins=["https://example.com"],
            app_type="non_interactive",
            callbacks=["https://example.com/callback"],
            client_metadata={
                "foo": "zoo",
            },
            custom_login_page_on=True,
            description="Test Applications Long Description",
            grant_types=[
                "authorization_code",
                "http://auth0.com/oauth/grant-type/password-realm",
                "implicit",
                "password",
                "refresh_token",
            ],
            is_first_party=True,
            is_token_endpoint_ip_header_trusted=True,
            jwt_configuration=auth0.ClientJwtConfigurationArgs(
                alg="RS256",
                lifetime_in_seconds=300,
                scopes={
                    "foo": "bar",
                },
                secret_encoded=True,
            ),
            mobile=auth0.ClientMobileArgs(
                ios=auth0.ClientMobileIosArgs(
                    app_bundle_identifier="com.my.bundle.id",
                    team_id="9JA89QQLNQ",
                ),
            ),
            oidc_conformant=False,
            refresh_token=auth0.ClientRefreshTokenArgs(
                expiration_type="expiring",
                idle_token_lifetime=1296000,
                infinite_idle_token_lifetime=True,
                infinite_token_lifetime=False,
                leeway=15,
                rotation_type="rotating",
                token_lifetime=84600,
            ),
            token_endpoint_auth_method="client_secret_post",
            web_origins=["https://example.com"])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ClientAddonsArgs']] addons: List(Resource). Configuration settings for add-ons for this client. For details, see Add-ons.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_logout_urls: List(String). URLs that Auth0 may redirect to after logout.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_origins: List(String). URLs that represent valid origins for cross-origin resource sharing. By default, all your callback URLs will be allowed.
        :param pulumi.Input[str] app_type: String. Type of application the client represents. Options include `native`, `spa`, `regular_web`, `non_interactive`, `rms`, `box`, `cloudbees`, `concur`, `dropbox`, `mscrm`, `echosign`, `egnyte`, `newrelic`, `office365`, `salesforce`, `sentry`, `sharepoint`, `slack`, `springcm`, `zendesk`, `zoom`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] callbacks: List(String). URLs that Auth0 may call back to after a user authenticates for the client. Make sure to specify the protocol (https://) otherwise the callback may fail in some cases. With the exception of custom URI schemes for native clients, all callbacks should use protocol https://.
        :param pulumi.Input[Mapping[str, Any]] client_metadata: Map(String)
        :param pulumi.Input[Mapping[str, Any]] client_secret_rotation_trigger: Map.
        :param pulumi.Input[bool] cross_origin_auth: Boolean. Indicates whether or not the client can be used to make cross-origin authentication requests.
        :param pulumi.Input[str] cross_origin_loc: String. URL for the location on your site where the cross-origin verification takes place for the cross-origin auth flow. Used when performing auth in your own domain instead of through the Auth0-hosted login page.
        :param pulumi.Input[str] custom_login_page: String. Content of the custom login page.
        :param pulumi.Input[bool] custom_login_page_on: Boolean. Indicates whether or not a custom login page is to be used.
        :param pulumi.Input[str] custom_login_page_preview: String.
        :param pulumi.Input[str] description: String, (Max length = 140 characters). Description of the purpose of the client.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] encryption_key: Map(String).
        :param pulumi.Input[str] form_template: String. Form template for WS-Federation protocol.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] grant_types: List(String). Types of grants that this client is authorized to use.
        :param pulumi.Input[bool] is_first_party: Boolean. Indicates whether or not this client is a first-party client.
        :param pulumi.Input[bool] is_token_endpoint_ip_header_trusted: Boolean. Indicates whether or not the token endpoint IP header is trusted.
        :param pulumi.Input[pulumi.InputType['ClientJwtConfigurationArgs']] jwt_configuration: List(Resource). Configuration settings for the JWTs issued for this client. For details, see JWT Configuration.
        :param pulumi.Input[str] logo_uri: String. URL of the logo for the client. Recommended size is 150px x 150px. If none is set, the default badge for the application type will be shown.
        :param pulumi.Input[pulumi.InputType['ClientMobileArgs']] mobile: List(Resource). Configuration settings for mobile native applications. For details, see Mobile.
        :param pulumi.Input[str] name: String. Name of the client.
        :param pulumi.Input[bool] oidc_conformant: Boolean. Indicates whether or not this client will conform to strict OIDC specifications.
        :param pulumi.Input[pulumi.InputType['ClientRefreshTokenArgs']] refresh_token: List(Resource). Configuration settings for the refresh tokens issued for this client.  For details, see Refresh Token Configuration.
        :param pulumi.Input[bool] sso: Boolean. Indicates whether or not the client should use Auth0 rather than the IdP to perform Single Sign-On (SSO). True = Use Auth0.
        :param pulumi.Input[bool] sso_disabled: Boolean. Indicates whether or not SSO is disabled.
        :param pulumi.Input[str] token_endpoint_auth_method: String. Defines the requested authentication method for the token endpoint. Options include `none` (public client without a client secret), `client_secret_post` (client uses HTTP POST parameters), `client_secret_basic` (client uses HTTP Basic).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] web_origins: List(String). URLs that represent valid web origins for use with web message response mode.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['addons'] = addons
            __props__['allowed_logout_urls'] = allowed_logout_urls
            __props__['allowed_origins'] = allowed_origins
            __props__['app_type'] = app_type
            __props__['callbacks'] = callbacks
            __props__['client_metadata'] = client_metadata
            __props__['client_secret_rotation_trigger'] = client_secret_rotation_trigger
            __props__['cross_origin_auth'] = cross_origin_auth
            __props__['cross_origin_loc'] = cross_origin_loc
            __props__['custom_login_page'] = custom_login_page
            __props__['custom_login_page_on'] = custom_login_page_on
            __props__['custom_login_page_preview'] = custom_login_page_preview
            if description is None:
                description = 'Managed by Pulumi'
            __props__['description'] = description
            __props__['encryption_key'] = encryption_key
            __props__['form_template'] = form_template
            __props__['grant_types'] = grant_types
            __props__['initiate_login_uri'] = initiate_login_uri
            __props__['is_first_party'] = is_first_party
            __props__['is_token_endpoint_ip_header_trusted'] = is_token_endpoint_ip_header_trusted
            __props__['jwt_configuration'] = jwt_configuration
            __props__['logo_uri'] = logo_uri
            __props__['mobile'] = mobile
            __props__['name'] = name
            __props__['oidc_conformant'] = oidc_conformant
            __props__['refresh_token'] = refresh_token
            __props__['sso'] = sso
            __props__['sso_disabled'] = sso_disabled
            __props__['token_endpoint_auth_method'] = token_endpoint_auth_method
            __props__['web_origins'] = web_origins
            __props__['client_id'] = None
            __props__['client_secret'] = None
        super(Client, __self__).__init__(
            'auth0:index/client:Client',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            addons: Optional[pulumi.Input[pulumi.InputType['ClientAddonsArgs']]] = None,
            allowed_logout_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            allowed_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            app_type: Optional[pulumi.Input[str]] = None,
            callbacks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            client_id: Optional[pulumi.Input[str]] = None,
            client_metadata: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            client_secret: Optional[pulumi.Input[str]] = None,
            client_secret_rotation_trigger: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            cross_origin_auth: Optional[pulumi.Input[bool]] = None,
            cross_origin_loc: Optional[pulumi.Input[str]] = None,
            custom_login_page: Optional[pulumi.Input[str]] = None,
            custom_login_page_on: Optional[pulumi.Input[bool]] = None,
            custom_login_page_preview: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            encryption_key: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            form_template: Optional[pulumi.Input[str]] = None,
            grant_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            initiate_login_uri: Optional[pulumi.Input[str]] = None,
            is_first_party: Optional[pulumi.Input[bool]] = None,
            is_token_endpoint_ip_header_trusted: Optional[pulumi.Input[bool]] = None,
            jwt_configuration: Optional[pulumi.Input[pulumi.InputType['ClientJwtConfigurationArgs']]] = None,
            logo_uri: Optional[pulumi.Input[str]] = None,
            mobile: Optional[pulumi.Input[pulumi.InputType['ClientMobileArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            oidc_conformant: Optional[pulumi.Input[bool]] = None,
            refresh_token: Optional[pulumi.Input[pulumi.InputType['ClientRefreshTokenArgs']]] = None,
            sso: Optional[pulumi.Input[bool]] = None,
            sso_disabled: Optional[pulumi.Input[bool]] = None,
            token_endpoint_auth_method: Optional[pulumi.Input[str]] = None,
            web_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'Client':
        """
        Get an existing Client resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ClientAddonsArgs']] addons: List(Resource). Configuration settings for add-ons for this client. For details, see Add-ons.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_logout_urls: List(String). URLs that Auth0 may redirect to after logout.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_origins: List(String). URLs that represent valid origins for cross-origin resource sharing. By default, all your callback URLs will be allowed.
        :param pulumi.Input[str] app_type: String. Type of application the client represents. Options include `native`, `spa`, `regular_web`, `non_interactive`, `rms`, `box`, `cloudbees`, `concur`, `dropbox`, `mscrm`, `echosign`, `egnyte`, `newrelic`, `office365`, `salesforce`, `sentry`, `sharepoint`, `slack`, `springcm`, `zendesk`, `zoom`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] callbacks: List(String). URLs that Auth0 may call back to after a user authenticates for the client. Make sure to specify the protocol (https://) otherwise the callback may fail in some cases. With the exception of custom URI schemes for native clients, all callbacks should use protocol https://.
        :param pulumi.Input[str] client_id: String. ID of the client.
        :param pulumi.Input[Mapping[str, Any]] client_metadata: Map(String)
        :param pulumi.Input[str] client_secret: String. Secret for the client; keep this private.
        :param pulumi.Input[Mapping[str, Any]] client_secret_rotation_trigger: Map.
        :param pulumi.Input[bool] cross_origin_auth: Boolean. Indicates whether or not the client can be used to make cross-origin authentication requests.
        :param pulumi.Input[str] cross_origin_loc: String. URL for the location on your site where the cross-origin verification takes place for the cross-origin auth flow. Used when performing auth in your own domain instead of through the Auth0-hosted login page.
        :param pulumi.Input[str] custom_login_page: String. Content of the custom login page.
        :param pulumi.Input[bool] custom_login_page_on: Boolean. Indicates whether or not a custom login page is to be used.
        :param pulumi.Input[str] custom_login_page_preview: String.
        :param pulumi.Input[str] description: String, (Max length = 140 characters). Description of the purpose of the client.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] encryption_key: Map(String).
        :param pulumi.Input[str] form_template: String. Form template for WS-Federation protocol.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] grant_types: List(String). Types of grants that this client is authorized to use.
        :param pulumi.Input[bool] is_first_party: Boolean. Indicates whether or not this client is a first-party client.
        :param pulumi.Input[bool] is_token_endpoint_ip_header_trusted: Boolean. Indicates whether or not the token endpoint IP header is trusted.
        :param pulumi.Input[pulumi.InputType['ClientJwtConfigurationArgs']] jwt_configuration: List(Resource). Configuration settings for the JWTs issued for this client. For details, see JWT Configuration.
        :param pulumi.Input[str] logo_uri: String. URL of the logo for the client. Recommended size is 150px x 150px. If none is set, the default badge for the application type will be shown.
        :param pulumi.Input[pulumi.InputType['ClientMobileArgs']] mobile: List(Resource). Configuration settings for mobile native applications. For details, see Mobile.
        :param pulumi.Input[str] name: String. Name of the client.
        :param pulumi.Input[bool] oidc_conformant: Boolean. Indicates whether or not this client will conform to strict OIDC specifications.
        :param pulumi.Input[pulumi.InputType['ClientRefreshTokenArgs']] refresh_token: List(Resource). Configuration settings for the refresh tokens issued for this client.  For details, see Refresh Token Configuration.
        :param pulumi.Input[bool] sso: Boolean. Indicates whether or not the client should use Auth0 rather than the IdP to perform Single Sign-On (SSO). True = Use Auth0.
        :param pulumi.Input[bool] sso_disabled: Boolean. Indicates whether or not SSO is disabled.
        :param pulumi.Input[str] token_endpoint_auth_method: String. Defines the requested authentication method for the token endpoint. Options include `none` (public client without a client secret), `client_secret_post` (client uses HTTP POST parameters), `client_secret_basic` (client uses HTTP Basic).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] web_origins: List(String). URLs that represent valid web origins for use with web message response mode.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["addons"] = addons
        __props__["allowed_logout_urls"] = allowed_logout_urls
        __props__["allowed_origins"] = allowed_origins
        __props__["app_type"] = app_type
        __props__["callbacks"] = callbacks
        __props__["client_id"] = client_id
        __props__["client_metadata"] = client_metadata
        __props__["client_secret"] = client_secret
        __props__["client_secret_rotation_trigger"] = client_secret_rotation_trigger
        __props__["cross_origin_auth"] = cross_origin_auth
        __props__["cross_origin_loc"] = cross_origin_loc
        __props__["custom_login_page"] = custom_login_page
        __props__["custom_login_page_on"] = custom_login_page_on
        __props__["custom_login_page_preview"] = custom_login_page_preview
        __props__["description"] = description
        __props__["encryption_key"] = encryption_key
        __props__["form_template"] = form_template
        __props__["grant_types"] = grant_types
        __props__["initiate_login_uri"] = initiate_login_uri
        __props__["is_first_party"] = is_first_party
        __props__["is_token_endpoint_ip_header_trusted"] = is_token_endpoint_ip_header_trusted
        __props__["jwt_configuration"] = jwt_configuration
        __props__["logo_uri"] = logo_uri
        __props__["mobile"] = mobile
        __props__["name"] = name
        __props__["oidc_conformant"] = oidc_conformant
        __props__["refresh_token"] = refresh_token
        __props__["sso"] = sso
        __props__["sso_disabled"] = sso_disabled
        __props__["token_endpoint_auth_method"] = token_endpoint_auth_method
        __props__["web_origins"] = web_origins
        return Client(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def addons(self) -> pulumi.Output[Optional['outputs.ClientAddons']]:
        """
        List(Resource). Configuration settings for add-ons for this client. For details, see Add-ons.
        """
        return pulumi.get(self, "addons")

    @property
    @pulumi.getter(name="allowedLogoutUrls")
    def allowed_logout_urls(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List(String). URLs that Auth0 may redirect to after logout.
        """
        return pulumi.get(self, "allowed_logout_urls")

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List(String). URLs that represent valid origins for cross-origin resource sharing. By default, all your callback URLs will be allowed.
        """
        return pulumi.get(self, "allowed_origins")

    @property
    @pulumi.getter(name="appType")
    def app_type(self) -> pulumi.Output[Optional[str]]:
        """
        String. Type of application the client represents. Options include `native`, `spa`, `regular_web`, `non_interactive`, `rms`, `box`, `cloudbees`, `concur`, `dropbox`, `mscrm`, `echosign`, `egnyte`, `newrelic`, `office365`, `salesforce`, `sentry`, `sharepoint`, `slack`, `springcm`, `zendesk`, `zoom`.
        """
        return pulumi.get(self, "app_type")

    @property
    @pulumi.getter
    def callbacks(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List(String). URLs that Auth0 may call back to after a user authenticates for the client. Make sure to specify the protocol (https://) otherwise the callback may fail in some cases. With the exception of custom URI schemes for native clients, all callbacks should use protocol https://.
        """
        return pulumi.get(self, "callbacks")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[str]:
        """
        String. ID of the client.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientMetadata")
    def client_metadata(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        Map(String)
        """
        return pulumi.get(self, "client_metadata")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[str]:
        """
        String. Secret for the client; keep this private.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="clientSecretRotationTrigger")
    def client_secret_rotation_trigger(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        Map.
        """
        return pulumi.get(self, "client_secret_rotation_trigger")

    @property
    @pulumi.getter(name="crossOriginAuth")
    def cross_origin_auth(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean. Indicates whether or not the client can be used to make cross-origin authentication requests.
        """
        return pulumi.get(self, "cross_origin_auth")

    @property
    @pulumi.getter(name="crossOriginLoc")
    def cross_origin_loc(self) -> pulumi.Output[Optional[str]]:
        """
        String. URL for the location on your site where the cross-origin verification takes place for the cross-origin auth flow. Used when performing auth in your own domain instead of through the Auth0-hosted login page.
        """
        return pulumi.get(self, "cross_origin_loc")

    @property
    @pulumi.getter(name="customLoginPage")
    def custom_login_page(self) -> pulumi.Output[Optional[str]]:
        """
        String. Content of the custom login page.
        """
        return pulumi.get(self, "custom_login_page")

    @property
    @pulumi.getter(name="customLoginPageOn")
    def custom_login_page_on(self) -> pulumi.Output[bool]:
        """
        Boolean. Indicates whether or not a custom login page is to be used.
        """
        return pulumi.get(self, "custom_login_page_on")

    @property
    @pulumi.getter(name="customLoginPagePreview")
    def custom_login_page_preview(self) -> pulumi.Output[Optional[str]]:
        """
        String.
        """
        return pulumi.get(self, "custom_login_page_preview")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        String, (Max length = 140 characters). Description of the purpose of the client.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Map(String).
        """
        return pulumi.get(self, "encryption_key")

    @property
    @pulumi.getter(name="formTemplate")
    def form_template(self) -> pulumi.Output[Optional[str]]:
        """
        String. Form template for WS-Federation protocol.
        """
        return pulumi.get(self, "form_template")

    @property
    @pulumi.getter(name="grantTypes")
    def grant_types(self) -> pulumi.Output[Sequence[str]]:
        """
        List(String). Types of grants that this client is authorized to use.
        """
        return pulumi.get(self, "grant_types")

    @property
    @pulumi.getter(name="initiateLoginUri")
    def initiate_login_uri(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "initiate_login_uri")

    @property
    @pulumi.getter(name="isFirstParty")
    def is_first_party(self) -> pulumi.Output[bool]:
        """
        Boolean. Indicates whether or not this client is a first-party client.
        """
        return pulumi.get(self, "is_first_party")

    @property
    @pulumi.getter(name="isTokenEndpointIpHeaderTrusted")
    def is_token_endpoint_ip_header_trusted(self) -> pulumi.Output[bool]:
        """
        Boolean. Indicates whether or not the token endpoint IP header is trusted.
        """
        return pulumi.get(self, "is_token_endpoint_ip_header_trusted")

    @property
    @pulumi.getter(name="jwtConfiguration")
    def jwt_configuration(self) -> pulumi.Output['outputs.ClientJwtConfiguration']:
        """
        List(Resource). Configuration settings for the JWTs issued for this client. For details, see JWT Configuration.
        """
        return pulumi.get(self, "jwt_configuration")

    @property
    @pulumi.getter(name="logoUri")
    def logo_uri(self) -> pulumi.Output[Optional[str]]:
        """
        String. URL of the logo for the client. Recommended size is 150px x 150px. If none is set, the default badge for the application type will be shown.
        """
        return pulumi.get(self, "logo_uri")

    @property
    @pulumi.getter
    def mobile(self) -> pulumi.Output[Optional['outputs.ClientMobile']]:
        """
        List(Resource). Configuration settings for mobile native applications. For details, see Mobile.
        """
        return pulumi.get(self, "mobile")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        String. Name of the client.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="oidcConformant")
    def oidc_conformant(self) -> pulumi.Output[bool]:
        """
        Boolean. Indicates whether or not this client will conform to strict OIDC specifications.
        """
        return pulumi.get(self, "oidc_conformant")

    @property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> pulumi.Output['outputs.ClientRefreshToken']:
        """
        List(Resource). Configuration settings for the refresh tokens issued for this client.  For details, see Refresh Token Configuration.
        """
        return pulumi.get(self, "refresh_token")

    @property
    @pulumi.getter
    def sso(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean. Indicates whether or not the client should use Auth0 rather than the IdP to perform Single Sign-On (SSO). True = Use Auth0.
        """
        return pulumi.get(self, "sso")

    @property
    @pulumi.getter(name="ssoDisabled")
    def sso_disabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean. Indicates whether or not SSO is disabled.
        """
        return pulumi.get(self, "sso_disabled")

    @property
    @pulumi.getter(name="tokenEndpointAuthMethod")
    def token_endpoint_auth_method(self) -> pulumi.Output[str]:
        """
        String. Defines the requested authentication method for the token endpoint. Options include `none` (public client without a client secret), `client_secret_post` (client uses HTTP POST parameters), `client_secret_basic` (client uses HTTP Basic).
        """
        return pulumi.get(self, "token_endpoint_auth_method")

    @property
    @pulumi.getter(name="webOrigins")
    def web_origins(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List(String). URLs that represent valid web origins for use with web message response mode.
        """
        return pulumi.get(self, "web_origins")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

