# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetRelayProxyConfigurationResult',
    'AwaitableGetRelayProxyConfigurationResult',
    'get_relay_proxy_configuration',
    'get_relay_proxy_configuration_output',
]

@pulumi.output_type
class GetRelayProxyConfigurationResult:
    """
    A collection of values returned by getRelayProxyConfiguration.
    """
    def __init__(__self__, display_key=None, id=None, name=None, policies=None):
        if display_key and not isinstance(display_key, str):
            raise TypeError("Expected argument 'display_key' to be a str")
        pulumi.set(__self__, "display_key", display_key)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if policies and not isinstance(policies, list):
            raise TypeError("Expected argument 'policies' to be a list")
        pulumi.set(__self__, "policies", policies)

    @property
    @pulumi.getter(name="displayKey")
    def display_key(self) -> str:
        """
        The last 4 characters of the Relay Proxy configuration's unique key.
        """
        return pulumi.get(self, "display_key")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The human-readable name for your Relay Proxy configuration.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def policies(self) -> Optional[Sequence['outputs.GetRelayProxyConfigurationPolicyResult']]:
        """
        The Relay Proxy configuration's rule policy block. This determines what content the Relay Proxy receives. To learn more, read [Understanding policies](https://docs.launchdarkly.com/home/members/role-policies#understanding-policies).
        """
        return pulumi.get(self, "policies")


class AwaitableGetRelayProxyConfigurationResult(GetRelayProxyConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRelayProxyConfigurationResult(
            display_key=self.display_key,
            id=self.id,
            name=self.name,
            policies=self.policies)


def get_relay_proxy_configuration(id: Optional[str] = None,
                                  policies: Optional[Sequence[pulumi.InputType['GetRelayProxyConfigurationPolicyArgs']]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRelayProxyConfigurationResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import lbrlabs_pulumi_launchdarkly as launchdarkly

    example = launchdarkly.RelayProxyConfiguration("example", policies=[launchdarkly.RelayProxyConfigurationPolicyArgs(
        actions=["*"],
        effect="allow",
        resources=["proj/*:env/*"],
    )])
    ```


    :param str id: The Relay Proxy configuration's unique 24 character ID. The unique relay proxy ID can be found in the relay proxy edit page URL, which you can locate by clicking the three dot menu on your relay proxy item in the UI and selecting 'Edit configuration':
    :param Sequence[pulumi.InputType['GetRelayProxyConfigurationPolicyArgs']] policies: The Relay Proxy configuration's rule policy block. This determines what content the Relay Proxy receives. To learn more, read [Understanding policies](https://docs.launchdarkly.com/home/members/role-policies#understanding-policies).
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['policies'] = policies
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('launchdarkly:index/getRelayProxyConfiguration:getRelayProxyConfiguration', __args__, opts=opts, typ=GetRelayProxyConfigurationResult).value

    return AwaitableGetRelayProxyConfigurationResult(
        display_key=__ret__.display_key,
        id=__ret__.id,
        name=__ret__.name,
        policies=__ret__.policies)


@_utilities.lift_output_func(get_relay_proxy_configuration)
def get_relay_proxy_configuration_output(id: Optional[pulumi.Input[str]] = None,
                                         policies: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetRelayProxyConfigurationPolicyArgs']]]]] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRelayProxyConfigurationResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import lbrlabs_pulumi_launchdarkly as launchdarkly

    example = launchdarkly.RelayProxyConfiguration("example", policies=[launchdarkly.RelayProxyConfigurationPolicyArgs(
        actions=["*"],
        effect="allow",
        resources=["proj/*:env/*"],
    )])
    ```


    :param str id: The Relay Proxy configuration's unique 24 character ID. The unique relay proxy ID can be found in the relay proxy edit page URL, which you can locate by clicking the three dot menu on your relay proxy item in the UI and selecting 'Edit configuration':
    :param Sequence[pulumi.InputType['GetRelayProxyConfigurationPolicyArgs']] policies: The Relay Proxy configuration's rule policy block. This determines what content the Relay Proxy receives. To learn more, read [Understanding policies](https://docs.launchdarkly.com/home/members/role-policies#understanding-policies).
    """
    ...
