# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetTeamResult',
    'AwaitableGetTeamResult',
    'get_team',
    'get_team_output',
]

@pulumi.output_type
class GetTeamResult:
    """
    A collection of values returned by getTeam.
    """
    def __init__(__self__, custom_role_keys=None, description=None, id=None, key=None, maintainers=None, name=None, project_keys=None):
        if custom_role_keys and not isinstance(custom_role_keys, list):
            raise TypeError("Expected argument 'custom_role_keys' to be a list")
        pulumi.set(__self__, "custom_role_keys", custom_role_keys)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        pulumi.set(__self__, "key", key)
        if maintainers and not isinstance(maintainers, list):
            raise TypeError("Expected argument 'maintainers' to be a list")
        pulumi.set(__self__, "maintainers", maintainers)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project_keys and not isinstance(project_keys, list):
            raise TypeError("Expected argument 'project_keys' to be a list")
        pulumi.set(__self__, "project_keys", project_keys)

    @property
    @pulumi.getter(name="customRoleKeys")
    def custom_role_keys(self) -> Optional[Sequence[str]]:
        """
        The list of the keys of the custom roles that you have assigned to the team.
        """
        return pulumi.get(self, "custom_role_keys")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The team description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def maintainers(self) -> Sequence['outputs.GetTeamMaintainerResult']:
        """
        The list of team maintainers as [team member objects](https://www.terraform.io/docs/providers/launchdarkly/d/team_member.html).
        """
        return pulumi.get(self, "maintainers")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Human readable name for the team.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectKeys")
    def project_keys(self) -> Sequence[str]:
        """
        The list of keys of the projects that the team has any write access to.
        """
        return pulumi.get(self, "project_keys")


class AwaitableGetTeamResult(GetTeamResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTeamResult(
            custom_role_keys=self.custom_role_keys,
            description=self.description,
            id=self.id,
            key=self.key,
            maintainers=self.maintainers,
            name=self.name,
            project_keys=self.project_keys)


def get_team(custom_role_keys: Optional[Sequence[str]] = None,
             description: Optional[str] = None,
             key: Optional[str] = None,
             name: Optional[str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTeamResult:
    """
    Provides a LaunchDarkly team data source.

    This data source allows you to retrieve team information from your LaunchDarkly organization.

    > **Note:** Teams are available to customers on an Enterprise LaunchDarkly plan. To learn more, read about our pricing. To upgrade your plan, [contact LaunchDarkly Sales](https://launchdarkly.com/contact-sales/).
    ## Example Usage

    ```python
    import pulumi
    import pulumi_launchdarkly as launchdarkly

    platform_team = launchdarkly.get_team(key="platform_team")
    ```


    :param Sequence[str] custom_role_keys: The list of the keys of the custom roles that you have assigned to the team.
    :param str description: The team description.
    :param str key: The team key.
    :param str name: Human readable name for the team.
    """
    __args__ = dict()
    __args__['customRoleKeys'] = custom_role_keys
    __args__['description'] = description
    __args__['key'] = key
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('launchdarkly:index/getTeam:getTeam', __args__, opts=opts, typ=GetTeamResult).value

    return AwaitableGetTeamResult(
        custom_role_keys=__ret__.custom_role_keys,
        description=__ret__.description,
        id=__ret__.id,
        key=__ret__.key,
        maintainers=__ret__.maintainers,
        name=__ret__.name,
        project_keys=__ret__.project_keys)


@_utilities.lift_output_func(get_team)
def get_team_output(custom_role_keys: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                    description: Optional[pulumi.Input[Optional[str]]] = None,
                    key: Optional[pulumi.Input[str]] = None,
                    name: Optional[pulumi.Input[Optional[str]]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTeamResult]:
    """
    Provides a LaunchDarkly team data source.

    This data source allows you to retrieve team information from your LaunchDarkly organization.

    > **Note:** Teams are available to customers on an Enterprise LaunchDarkly plan. To learn more, read about our pricing. To upgrade your plan, [contact LaunchDarkly Sales](https://launchdarkly.com/contact-sales/).
    ## Example Usage

    ```python
    import pulumi
    import pulumi_launchdarkly as launchdarkly

    platform_team = launchdarkly.get_team(key="platform_team")
    ```


    :param Sequence[str] custom_role_keys: The list of the keys of the custom roles that you have assigned to the team.
    :param str description: The team description.
    :param str key: The team key.
    :param str name: Human readable name for the team.
    """
    ...
