# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['TeamMemberArgs', 'TeamMember']

@pulumi.input_type
class TeamMemberArgs:
    def __init__(__self__, *,
                 email: pulumi.Input[str],
                 custom_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 first_name: Optional[pulumi.Input[str]] = None,
                 last_name: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a TeamMember resource.
        :param pulumi.Input[str] email: The unique email address associated with the team member. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_roles: The list of custom roles keys associated with the team member. Custom roles are only available to customers on enterprise plans. To learn more about enterprise plans, contact sales@launchdarkly.com.
        :param pulumi.Input[str] first_name: The team member's given name. Please note that, once created, this cannot be updated except by the team member themself.
        :param pulumi.Input[str] last_name: The team member's family name. Please note that, once created, this cannot be updated except by the team member themself.
        :param pulumi.Input[str] role: The role associated with team member. Supported roles are `reader`, `writer`, `no_access`, or `admin`. If you don't specify a role, `reader` is assigned by default.
        """
        pulumi.set(__self__, "email", email)
        if custom_roles is not None:
            pulumi.set(__self__, "custom_roles", custom_roles)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Input[str]:
        """
        The unique email address associated with the team member. A change in this field will force the destruction of the existing resource and the creation of a new one.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[str]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="customRoles")
    def custom_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of custom roles keys associated with the team member. Custom roles are only available to customers on enterprise plans. To learn more about enterprise plans, contact sales@launchdarkly.com.
        """
        return pulumi.get(self, "custom_roles")

    @custom_roles.setter
    def custom_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "custom_roles", value)

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[pulumi.Input[str]]:
        """
        The team member's given name. Please note that, once created, this cannot be updated except by the team member themself.
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "first_name", value)

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[pulumi.Input[str]]:
        """
        The team member's family name. Please note that, once created, this cannot be updated except by the team member themself.
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_name", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        The role associated with team member. Supported roles are `reader`, `writer`, `no_access`, or `admin`. If you don't specify a role, `reader` is assigned by default.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class _TeamMemberState:
    def __init__(__self__, *,
                 custom_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 first_name: Optional[pulumi.Input[str]] = None,
                 last_name: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering TeamMember resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_roles: The list of custom roles keys associated with the team member. Custom roles are only available to customers on enterprise plans. To learn more about enterprise plans, contact sales@launchdarkly.com.
        :param pulumi.Input[str] email: The unique email address associated with the team member. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[str] first_name: The team member's given name. Please note that, once created, this cannot be updated except by the team member themself.
        :param pulumi.Input[str] last_name: The team member's family name. Please note that, once created, this cannot be updated except by the team member themself.
        :param pulumi.Input[str] role: The role associated with team member. Supported roles are `reader`, `writer`, `no_access`, or `admin`. If you don't specify a role, `reader` is assigned by default.
        """
        if custom_roles is not None:
            pulumi.set(__self__, "custom_roles", custom_roles)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter(name="customRoles")
    def custom_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of custom roles keys associated with the team member. Custom roles are only available to customers on enterprise plans. To learn more about enterprise plans, contact sales@launchdarkly.com.
        """
        return pulumi.get(self, "custom_roles")

    @custom_roles.setter
    def custom_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "custom_roles", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        The unique email address associated with the team member. A change in this field will force the destruction of the existing resource and the creation of a new one.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[pulumi.Input[str]]:
        """
        The team member's given name. Please note that, once created, this cannot be updated except by the team member themself.
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "first_name", value)

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[pulumi.Input[str]]:
        """
        The team member's family name. Please note that, once created, this cannot be updated except by the team member themself.
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_name", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        The role associated with team member. Supported roles are `reader`, `writer`, `no_access`, or `admin`. If you don't specify a role, `reader` is assigned by default.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


class TeamMember(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 first_name: Optional[pulumi.Input[str]] = None,
                 last_name: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a LaunchDarkly team member resource.

        This resource allows you to create and manage team members within your LaunchDarkly organization.

        > **Note:** You can only manage team members with "admin" level personal access tokens. To learn more, read [Managing Teams](https://docs.launchdarkly.com/docs/teams).

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_launchdarkly as launchdarkly

        example = launchdarkly.TeamMember("example",
            email="example.user@example.com",
            first_name="John",
            last_name="Smith",
            role="writer")
        ```

        ## Import

        LaunchDarkly team members can be imported using the team member's 24 character ID, e.g.

        ```sh
         $ pulumi import launchdarkly:index/teamMember:TeamMember example 5f05565b48be0b441fb63020
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_roles: The list of custom roles keys associated with the team member. Custom roles are only available to customers on enterprise plans. To learn more about enterprise plans, contact sales@launchdarkly.com.
        :param pulumi.Input[str] email: The unique email address associated with the team member. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[str] first_name: The team member's given name. Please note that, once created, this cannot be updated except by the team member themself.
        :param pulumi.Input[str] last_name: The team member's family name. Please note that, once created, this cannot be updated except by the team member themself.
        :param pulumi.Input[str] role: The role associated with team member. Supported roles are `reader`, `writer`, `no_access`, or `admin`. If you don't specify a role, `reader` is assigned by default.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TeamMemberArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a LaunchDarkly team member resource.

        This resource allows you to create and manage team members within your LaunchDarkly organization.

        > **Note:** You can only manage team members with "admin" level personal access tokens. To learn more, read [Managing Teams](https://docs.launchdarkly.com/docs/teams).

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_launchdarkly as launchdarkly

        example = launchdarkly.TeamMember("example",
            email="example.user@example.com",
            first_name="John",
            last_name="Smith",
            role="writer")
        ```

        ## Import

        LaunchDarkly team members can be imported using the team member's 24 character ID, e.g.

        ```sh
         $ pulumi import launchdarkly:index/teamMember:TeamMember example 5f05565b48be0b441fb63020
        ```

        :param str resource_name: The name of the resource.
        :param TeamMemberArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TeamMemberArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 first_name: Optional[pulumi.Input[str]] = None,
                 last_name: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TeamMemberArgs.__new__(TeamMemberArgs)

            __props__.__dict__["custom_roles"] = custom_roles
            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = email
            __props__.__dict__["first_name"] = first_name
            __props__.__dict__["last_name"] = last_name
            __props__.__dict__["role"] = role
        super(TeamMember, __self__).__init__(
            'launchdarkly:index/teamMember:TeamMember',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            custom_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            email: Optional[pulumi.Input[str]] = None,
            first_name: Optional[pulumi.Input[str]] = None,
            last_name: Optional[pulumi.Input[str]] = None,
            role: Optional[pulumi.Input[str]] = None) -> 'TeamMember':
        """
        Get an existing TeamMember resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_roles: The list of custom roles keys associated with the team member. Custom roles are only available to customers on enterprise plans. To learn more about enterprise plans, contact sales@launchdarkly.com.
        :param pulumi.Input[str] email: The unique email address associated with the team member. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[str] first_name: The team member's given name. Please note that, once created, this cannot be updated except by the team member themself.
        :param pulumi.Input[str] last_name: The team member's family name. Please note that, once created, this cannot be updated except by the team member themself.
        :param pulumi.Input[str] role: The role associated with team member. Supported roles are `reader`, `writer`, `no_access`, or `admin`. If you don't specify a role, `reader` is assigned by default.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TeamMemberState.__new__(_TeamMemberState)

        __props__.__dict__["custom_roles"] = custom_roles
        __props__.__dict__["email"] = email
        __props__.__dict__["first_name"] = first_name
        __props__.__dict__["last_name"] = last_name
        __props__.__dict__["role"] = role
        return TeamMember(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="customRoles")
    def custom_roles(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The list of custom roles keys associated with the team member. Custom roles are only available to customers on enterprise plans. To learn more about enterprise plans, contact sales@launchdarkly.com.
        """
        return pulumi.get(self, "custom_roles")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[str]:
        """
        The unique email address associated with the team member. A change in this field will force the destruction of the existing resource and the creation of a new one.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> pulumi.Output[Optional[str]]:
        """
        The team member's given name. Please note that, once created, this cannot be updated except by the team member themself.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> pulumi.Output[Optional[str]]:
        """
        The team member's family name. Please note that, once created, this cannot be updated except by the team member themself.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[str]:
        """
        The role associated with team member. Supported roles are `reader`, `writer`, `no_access`, or `admin`. If you don't specify a role, `reader` is assigned by default.
        """
        return pulumi.get(self, "role")

