"""File generated by TLObjects' generator. All changes will be ERASED"""
from ...tl.tlobject import TLObject
from ...tl.tlobject import TLRequest
from typing import Optional, List, Union, TYPE_CHECKING
import os
import struct
from datetime import datetime
if TYPE_CHECKING:
    from ...tl.types import TypeInputDocument, TypeInputStickerSet, TypeInputStickerSetItem, TypeInputUser



class AddStickerToSetRequest(TLRequest):
    CONSTRUCTOR_ID = 0x8653febe
    SUBCLASS_OF_ID = 0x9b704a5a

    def __init__(self, stickerset: 'TypeInputStickerSet', sticker: 'TypeInputStickerSetItem'):
        """
        :returns messages.StickerSet: Instance of either StickerSet, StickerSetNotModified.
        """
        self.stickerset = stickerset
        self.sticker = sticker

    def to_dict(self):
        return {
            '_': 'AddStickerToSetRequest',
            'stickerset': self.stickerset.to_dict() if isinstance(self.stickerset, TLObject) else self.stickerset,
            'sticker': self.sticker.to_dict() if isinstance(self.sticker, TLObject) else self.sticker
        }

    def _bytes(self):
        return b''.join((
            b'\xbe\xfeS\x86',
            self.stickerset._bytes(),
            self.sticker._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _stickerset = reader.tgread_object()
        _sticker = reader.tgread_object()
        return cls(stickerset=_stickerset, sticker=_sticker)


class ChangeStickerPositionRequest(TLRequest):
    CONSTRUCTOR_ID = 0xffb6d4ca
    SUBCLASS_OF_ID = 0x9b704a5a

    def __init__(self, sticker: 'TypeInputDocument', position: int):
        """
        :returns messages.StickerSet: Instance of either StickerSet, StickerSetNotModified.
        """
        self.sticker = sticker
        self.position = position

    async def resolve(self, client, utils):
        self.sticker = utils.get_input_document(self.sticker)

    def to_dict(self):
        return {
            '_': 'ChangeStickerPositionRequest',
            'sticker': self.sticker.to_dict() if isinstance(self.sticker, TLObject) else self.sticker,
            'position': self.position
        }

    def _bytes(self):
        return b''.join((
            b'\xca\xd4\xb6\xff',
            self.sticker._bytes(),
            struct.pack('<i', self.position),
        ))

    @classmethod
    def from_reader(cls, reader):
        _sticker = reader.tgread_object()
        _position = reader.read_int()
        return cls(sticker=_sticker, position=_position)


class CheckShortNameRequest(TLRequest):
    CONSTRUCTOR_ID = 0x284b3639
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, short_name: str):
        """
        :returns Bool: This type has no constructors.
        """
        self.short_name = short_name

    def to_dict(self):
        return {
            '_': 'CheckShortNameRequest',
            'short_name': self.short_name
        }

    def _bytes(self):
        return b''.join((
            b'96K(',
            self.serialize_bytes(self.short_name),
        ))

    @classmethod
    def from_reader(cls, reader):
        _short_name = reader.tgread_string()
        return cls(short_name=_short_name)


class CreateStickerSetRequest(TLRequest):
    CONSTRUCTOR_ID = 0x9021ab67
    SUBCLASS_OF_ID = 0x9b704a5a

    def __init__(self, user_id: 'TypeInputUser', title: str, short_name: str, stickers: List['TypeInputStickerSetItem'], masks: Optional[bool]=None, animated: Optional[bool]=None, thumb: Optional['TypeInputDocument']=None, software: Optional[str]=None):
        """
        :returns messages.StickerSet: Instance of either StickerSet, StickerSetNotModified.
        """
        self.user_id = user_id
        self.title = title
        self.short_name = short_name
        self.stickers = stickers
        self.masks = masks
        self.animated = animated
        self.thumb = thumb
        self.software = software

    async def resolve(self, client, utils):
        self.user_id = utils.get_input_user(await client.get_input_entity(self.user_id))
        if self.thumb:
            self.thumb = utils.get_input_document(self.thumb)

    def to_dict(self):
        return {
            '_': 'CreateStickerSetRequest',
            'user_id': self.user_id.to_dict() if isinstance(self.user_id, TLObject) else self.user_id,
            'title': self.title,
            'short_name': self.short_name,
            'stickers': [] if self.stickers is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.stickers],
            'masks': self.masks,
            'animated': self.animated,
            'thumb': self.thumb.to_dict() if isinstance(self.thumb, TLObject) else self.thumb,
            'software': self.software
        }

    def _bytes(self):
        return b''.join((
            b'g\xab!\x90',
            struct.pack('<I', (0 if self.masks is None or self.masks is False else 1) | (0 if self.animated is None or self.animated is False else 2) | (0 if self.thumb is None or self.thumb is False else 4) | (0 if self.software is None or self.software is False else 8)),
            self.user_id._bytes(),
            self.serialize_bytes(self.title),
            self.serialize_bytes(self.short_name),
            b'' if self.thumb is None or self.thumb is False else (self.thumb._bytes()),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.stickers)),b''.join(x._bytes() for x in self.stickers),
            b'' if self.software is None or self.software is False else (self.serialize_bytes(self.software)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _masks = bool(flags & 1)
        _animated = bool(flags & 2)
        _user_id = reader.tgread_object()
        _title = reader.tgread_string()
        _short_name = reader.tgread_string()
        if flags & 4:
            _thumb = reader.tgread_object()
        else:
            _thumb = None
        reader.read_int()
        _stickers = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _stickers.append(_x)

        if flags & 8:
            _software = reader.tgread_string()
        else:
            _software = None
        return cls(user_id=_user_id, title=_title, short_name=_short_name, stickers=_stickers, masks=_masks, animated=_animated, thumb=_thumb, software=_software)


class RemoveStickerFromSetRequest(TLRequest):
    CONSTRUCTOR_ID = 0xf7760f51
    SUBCLASS_OF_ID = 0x9b704a5a

    def __init__(self, sticker: 'TypeInputDocument'):
        """
        :returns messages.StickerSet: Instance of either StickerSet, StickerSetNotModified.
        """
        self.sticker = sticker

    async def resolve(self, client, utils):
        self.sticker = utils.get_input_document(self.sticker)

    def to_dict(self):
        return {
            '_': 'RemoveStickerFromSetRequest',
            'sticker': self.sticker.to_dict() if isinstance(self.sticker, TLObject) else self.sticker
        }

    def _bytes(self):
        return b''.join((
            b'Q\x0fv\xf7',
            self.sticker._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _sticker = reader.tgread_object()
        return cls(sticker=_sticker)


class SetStickerSetThumbRequest(TLRequest):
    CONSTRUCTOR_ID = 0x9a364e30
    SUBCLASS_OF_ID = 0x9b704a5a

    def __init__(self, stickerset: 'TypeInputStickerSet', thumb: 'TypeInputDocument'):
        """
        :returns messages.StickerSet: Instance of either StickerSet, StickerSetNotModified.
        """
        self.stickerset = stickerset
        self.thumb = thumb

    async def resolve(self, client, utils):
        self.thumb = utils.get_input_document(self.thumb)

    def to_dict(self):
        return {
            '_': 'SetStickerSetThumbRequest',
            'stickerset': self.stickerset.to_dict() if isinstance(self.stickerset, TLObject) else self.stickerset,
            'thumb': self.thumb.to_dict() if isinstance(self.thumb, TLObject) else self.thumb
        }

    def _bytes(self):
        return b''.join((
            b'0N6\x9a',
            self.stickerset._bytes(),
            self.thumb._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _stickerset = reader.tgread_object()
        _thumb = reader.tgread_object()
        return cls(stickerset=_stickerset, thumb=_thumb)


class SuggestShortNameRequest(TLRequest):
    CONSTRUCTOR_ID = 0x4dafc503
    SUBCLASS_OF_ID = 0xc44a4b21

    def __init__(self, title: str):
        """
        :returns stickers.SuggestedShortName: Instance of SuggestedShortName.
        """
        self.title = title

    def to_dict(self):
        return {
            '_': 'SuggestShortNameRequest',
            'title': self.title
        }

    def _bytes(self):
        return b''.join((
            b'\x03\xc5\xafM',
            self.serialize_bytes(self.title),
        ))

    @classmethod
    def from_reader(cls, reader):
        _title = reader.tgread_string()
        return cls(title=_title)

