from __future__ import annotations

from typing import TypedDict

from .tracking import ClickTrackingParams


class ExperimentFlags(TypedDict):
    H5_enable_full_pacf_logging: bool
    H5_use_async_logging: bool
    PremiumClientSharedConfig__enable_att_context_processor: bool
    PremiumClientSharedConfig__enable_att_for_get_premium_on_web_client: bool
    ab_det_apb_b: bool
    ab_det_el_h: bool
    ab_det_fet_wr: bool
    ab_det_fet_wr_en: bool
    ab_det_gen_re: bool
    action_companion_center_align_description: bool
    allow_skip_networkless: bool
    att_web_record_metrics: bool
    autoescape_tempdata_url: bool
    browse_next_continuations_migration_playlist: bool
    c3_watch_page_component: bool
    cache_utc_offset_minutes_in_pref_cookie: bool
    cancel_pending_navs: bool
    check_login_info_at_app_init_time: bool
    check_user_lact_at_prompt_shown_time_on_web: bool
    clear_user_partitioned_ls: bool
    client_respect_autoplay_switch_button_renderer: bool
    compress_gel: bool
    copy_login_info_to_st_cookie: bool
    csi_config_handling_infra: bool
    csi_on_gel: bool
    decorate_autoplay_renderer: bool
    defer_menus: bool
    defer_overlays: bool
    defer_rendering_outside_visible_area: bool
    deprecate_csi_has_info: bool
    deprecate_pair_servlet_enabled: bool
    desktop_add_to_playlist_renderer_dialog_popup: bool
    desktop_animate_miniplayer: bool
    desktop_client_release: bool
    desktop_delay_player_resizing: bool
    desktop_enable_dmpanel_click_drag_scroll: bool
    desktop_enable_dmpanel_scroll: bool
    desktop_enable_dmpanel_wheel_scroll: bool
    desktop_keyboard_capture_keydown_killswitch: bool
    desktop_mix_use_sampled_color_for_bottom_bar: bool
    desktop_mix_use_sampled_color_for_bottom_bar_search: bool
    desktop_mix_use_sampled_color_for_bottom_bar_watch_next: bool
    desktop_notification_high_priority_ignore_push: bool
    desktop_notification_set_title_bar: bool
    desktop_search_prominent_thumbs: bool
    desktop_sparkles_light_cta_button: bool
    desktop_swipeable_guide: bool
    desktop_use_new_history_manager: bool
    disable_banner_collapsing_when_hidden: bool
    disable_cached_masthead_data: bool
    disable_child_node_auto_formatted_strings: bool
    disable_dependency_injection: bool
    disable_enf_isd: bool
    disable_features_for_supex: bool
    disable_legacy_desktop_remote_queue: bool
    disable_pacf_logging_for_memory_limited_tv: bool
    disable_pause_on_linked_comment_nav: bool
    disable_safari_ui_status_check: bool
    disable_simple_mixed_direction_formatted_strings: bool
    disable_super_chat_buy_button: bool
    disable_thumbnail_preloading: bool
    embeds_transport_use_scheduler: bool
    embeds_web_nwl_disable_nocookie: bool
    empty_attributed_string_killswitch: bool
    enable_ab_report_on_errorscreen: bool
    enable_ab_rp_int: bool
    enable_active_view_display_ad_renderer_web_home: bool
    enable_ad_context_in_vss_pings: bool
    enable_ads_web_ep_buenos_aires_and_padding_fix: bool
    enable_async_ab_enf: bool
    enable_autotrim_enhanced_video_on_web: bool
    enable_buenos_aires_typography: bool
    enable_button_behavior_reuse: bool
    enable_call_to_action_clarification_renderer_bottom_section_conditions: bool
    enable_channel_page_modern_profile_section: bool
    enable_client_sli_logging: bool
    enable_client_streamz_web: bool
    enable_cloud_save_download_data_succeeded_check: bool
    enable_creator_details_shelf_m2: bool
    enable_custom_survey_impression_logging: bool
    enable_desktop_amsterdam_info_panels: bool
    enable_desktop_companion_impression_on_first_visible: bool
    enable_desktop_fountain_reaction_item_data_consumption: bool
    enable_desktop_search_bigger_thumbs: bool
    enable_desktop_search_bigger_thumbs_square: bool
    enable_dma_post_enforcement: bool
    enable_dma_web_toast: bool
    enable_docked_chat_messages: bool
    enable_dsa_one_click_ata_translators_infeed_elements: bool
    enable_dynamic_at_sign_for_channel_creation_handle: bool
    enable_entity_store_from_dependency_injection: bool
    enable_entity_update_command_resolver_web: bool
    enable_eom_webview_header: bool
    enable_exit_confirmation_dialog: bool
    enable_flow_logging_p4e: bool
    enable_gameplay: bool
    enable_gel_log_commands: bool
    enable_get_account_switcher_endpoint_on_webfe: bool
    enable_ghost_view_rendering_limited_h5_client: bool
    enable_google_payment_billing_command_client_support: bool
    enable_handle_search_on_channel_switcher: bool
    enable_handles_account_menu_switcher: bool
    enable_handles_in_mention_suggest_posts: bool
    enable_hlp_client_icon_pick: bool
    enable_identity_attributes_for_live_chat: bool
    enable_image_poll_post_creation: bool
    enable_inline_shorts_on_wn: bool
    enable_interstitial_entity_check: bool
    enable_is_extended_monitoring: bool
    enable_lcr_emoji_fountain: bool
    enable_livingroom_no_action_change: bool
    enable_loggingcontext_trackingparams: bool
    enable_masthead_quartile_ping_fix: bool
    enable_memberships_and_purchases: bool
    enable_mentions_in_reposts: bool
    enable_microformat_data: bool
    enable_mini_app_microformats: bool
    enable_mixed_direction_formatted_strings: bool
    enable_multi_image_post_creation: bool
    enable_names_handles_account_switcher: bool
    enable_native_bridge_view_saved_playables: bool
    enable_network_request_logging_on_game_events: bool
    enable_new_channel_creation_for_id4all: bool
    enable_offer_suppression: bool
    enable_on_yt_command_executor_command_to_navigate: bool
    enable_pacf_slot_asde_infeed_h5: bool
    enable_pacf_slot_asde_player_byte_h5: bool
    enable_pacf_slot_asde_player_byte_h5_TV: bool
    enable_pass_sdc_get_accounts_list: bool
    enable_pl_r_c: bool
    enable_pl_r_c_s: bool
    enable_pl_r_si_fa: bool
    enable_playable_a11y_label_with_badge_text: bool
    enable_playable_container_save_button: bool
    enable_playable_entity_save_menu_item: bool
    enable_playables_deeplink: bool
    enable_playables_url_resolution: bool
    enable_player_param_truncation_before_navigation_on_web: bool
    enable_poll_choice_border_on_web: bool
    enable_polymer_resin: bool
    enable_polymer_resin_migration: bool
    enable_populate_att_psd_in_abe_feedback: bool
    enable_populate_psd_in_abe_feedback: bool
    enable_post_cct_links: bool
    enable_post_scheduling: bool
    enable_premium_voluntary_pause: bool
    enable_programmed_playlist_color_sample: bool
    enable_programmed_playlist_redesign: bool
    enable_purchase_activity_in_paid_memberships: bool
    enable_quiz_creation: bool
    enable_reel_watch_sequence: bool
    enable_resolve_command_on_lwe_desktop: bool
    enable_respect_lang_dir: bool
    enable_rfa_rate_limits: bool
    enable_rta_manager: bool
    enable_scrolling_fix: bool
    enable_sdf_midroll_postroll_player_bytes_video_h5: bool
    enable_sdf_preroll_player_bytes_video_h5: bool
    enable_sdf_preroll_player_bytes_video_tv: bool
    enable_sdk_performance_network_logging: bool
    enable_sdk_performance_play_logging: bool
    enable_section_list_scroll_to_item_section_web: bool
    enable_seedless_shorts_url: bool
    enable_server_stitched_dai: bool
    enable_service_ajax_csn: bool
    enable_servlet_errors_streamz: bool
    enable_servlet_streamz: bool
    enable_sfv_audio_pivot_url: bool
    enable_sfv_effect_pivot_microformat: bool
    enable_sfv_effect_pivot_url: bool
    enable_shadydom_free_scoped_node_methods: bool
    enable_shadydom_free_scoped_query_methods: bool
    enable_shadydom_free_scoped_readonly_properties_batch_one: bool
    enable_skip_ad_guidance_prompt: bool
    enable_skippable_ads_for_unplugged_ad_pod: bool
    enable_smearing_expansion_dai: bool
    enable_sparkles_web_clickable_description: bool
    enable_squiffle_gif_handles_landing_page: bool
    enable_startup_lifecycle_kids: bool
    enable_startup_lifecycle_parent_tools: bool
    enable_streamline_repost_flow: bool
    enable_structured_description_shorts_web_mweb: bool
    enable_tectonic_ad_ux_for_halftime: bool
    enable_third_party_info: bool
    enable_time_out_messages: bool
    enable_topsoil_wta_for_halftime_live_infra: bool
    enable_true_inline_for_desktop_home_feed_vac: bool
    enable_unavailable_videos_watch_page: bool
    enable_variable_timeout_web: bool
    enable_watch_next_pause_autoplay_lact: bool
    enable_web_gpay_command_spinner: bool
    enable_web_ketchup_hero_animation: bool
    enable_web_player_player_in_bar_feature: bool
    enable_web_poster_hover_animation: bool
    enable_web_shorts_audio_pivot: bool
    enable_web_shorts_mention_pivot: bool
    enable_web_tiered_gel: bool
    enable_window_constrained_buy_flow_dialog: bool
    enable_wiz_next_lp2_msof: bool
    enable_yoodle: bool
    enable_your_playables_feed_entrypoint: bool
    enable_ypc_spinners: bool
    enable_yt_ata_iframe_authuser: bool
    enable_ytc_refunds_submit_form_signal_action: bool
    enable_ytc_self_serve_refunds: bool
    endpoint_handler_logging_cleanup_killswitch: bool
    err_on_pl_r_c: bool
    export_networkless_options: bool
    external_fullscreen: bool
    external_fullscreen_with_edu: bool
    fetch_bid_for_dclk_status: bool
    fill_no_history_user_in_ip: bool
    fill_no_history_user_in_watch_status: bool
    fill_single_video_with_notify_to_lasr: bool
    fill_view_models_on_web_vod: bool
    fix_alignment_search_desktop_text_image_ads_small_screens: bool
    fix_isd_logging: bool
    gcf_config_store_enabled: bool
    gcf_music_innertube: bool
    gda_enable_playlist_download: bool
    global_spacebar_pause: bool
    h5_companion_enable_adcpn_macro_substitution_for_click_pings: bool
    h5_enable_generic_error_logging_event: bool
    h5_inplayer_enable_adcpn_macro_substitution_for_click_pings: bool
    h5_reset_cache_and_filter_before_update_masthead: bool
    handles_in_mention_suggest_posts: bool
    hide_endpoint_overflow_on_ytd_display_ad_renderer: bool
    html5_enable_ads_client_monitoring_log_tv: bool
    html5_enable_single_video_vod_ivar_on_pacf: bool
    html5_log_trigger_events_with_debug_data: bool
    html5_recognize_predict_start_cue_point: bool
    html5_server_stitched_dai_group: bool
    il_attach_cache_limit: bool
    il_use_view_model_logging_context: bool
    imp_cache_player_requests: bool
    include_autoplay_count_in_playlists: bool
    is_browser_support_for_webcam_streaming: bool
    is_part_of_any_user_engagement_experiment: bool
    json_condensed_response: bool
    kev_adb_pg: bool
    kevlar_app_shortcuts: bool
    kevlar_appbehavior_attach_startup_tasks: bool
    kevlar_appshell_service_worker: bool
    kevlar_autofocus_menu_on_keyboard_nav: bool
    kevlar_autonav_popup_filtering: bool
    kevlar_av_eliminate_polling: bool
    kevlar_c3po_to_wiz_1: bool
    kevlar_c3po_to_wiz_2: bool
    kevlar_cache_cold_load_response: bool
    kevlar_cache_on_ttl_player: bool
    kevlar_cache_on_ttl_search: bool
    kevlar_calculate_grid_collapsible: bool
    kevlar_cancel_scheduled_comment_jobs_on_navigate: bool
    kevlar_channel_creation_form_resolver: bool
    kevlar_channel_trailer_multi_attach: bool
    kevlar_chapters_list_view_seek_by_chapter: bool
    kevlar_clear_duplicate_pref_cookie: bool
    kevlar_clear_non_displayable_url_params: bool
    kevlar_client_enable_shorts_player_bootstrap: bool
    kevlar_client_side_screens: bool
    kevlar_command_handler: bool
    kevlar_command_handler_clicks: bool
    kevlar_command_handler_formatted_string: bool
    kevlar_command_url: bool
    kevlar_continue_playback_without_player_response: bool
    kevlar_decorate_endpoint_with_onesie_config: bool
    kevlar_delay_watch_initial_data: bool
    kevlar_disable_background_prefetch: bool
    kevlar_disable_pending_command: bool
    kevlar_dragdrop_fast_scroll: bool
    kevlar_dropdown_fix: bool
    kevlar_droppable_prefetchable_requests: bool
    kevlar_early_popup_close: bool
    kevlar_enable_download_upsell_type_a: bool
    kevlar_enable_editable_playlists: bool
    kevlar_enable_em_offlineable_discovery: bool
    kevlar_enable_keto_batch_17_9: bool
    kevlar_enable_reorderable_playlists: bool
    kevlar_enable_shorts_prefetch_in_sequence: bool
    kevlar_enable_shorts_response_chunking: bool
    kevlar_enable_up_arrow: bool
    kevlar_exit_fullscreen_leaving_watch: bool
    kevlar_fetch_pbj: bool
    kevlar_fill_offline_availability_type_for_gda: bool
    kevlar_fix_playlist_continuation: bool
    kevlar_flexible_menu: bool
    kevlar_fluid_touch_scroll: bool
    kevlar_frontend_queue_recover: bool
    kevlar_gel_error_routing: bool
    kevlar_guide_refresh: bool
    kevlar_help_use_locale: bool
    kevlar_hide_playlist_playback_status: bool
    kevlar_hide_pp_url_param: bool
    kevlar_hide_time_continue_url_param: bool
    kevlar_home_skeleton: bool
    kevlar_js_fixes: bool
    kevlar_keyboard_button_focus: bool
    kevlar_larger_three_dot_tap: bool
    kevlar_lazy_list_resume_for_autofill: bool
    kevlar_local_innertube_response: bool
    kevlar_log_updated_time_for_smart_downloads: bool
    kevlar_macro_markers_keyboard_shortcut: bool
    kevlar_mandatory_icon_data_killswitch: bool
    kevlar_masthead_store: bool
    kevlar_mealbar_above_player: bool
    kevlar_miniplayer: bool
    kevlar_miniplayer_expand_top: bool
    kevlar_miniplayer_play_pause_on_scrim: bool
    kevlar_miniplayer_queue_user_activation: bool
    kevlar_mix_handle_first_endpoint_different: bool
    kevlar_modern_sd: bool
    kevlar_modern_sd_v2: bool
    kevlar_next_cold_on_auth_change_detected: bool
    kevlar_nitrate_driven_tooltips: bool
    kevlar_no_autoscroll_on_playlist_hover: bool
    kevlar_op_infra: bool
    kevlar_op_warm_pages: bool
    kevlar_pandown_polyfill: bool
    kevlar_passive_event_listeners: bool
    kevlar_playback_associated_queue: bool
    kevlar_player_cached_load_config: bool
    kevlar_player_check_ad_state_on_stop: bool
    kevlar_player_load_player_no_op: bool
    kevlar_player_new_bootstrap_adoption: bool
    kevlar_player_playlist_use_local_index: bool
    kevlar_player_watch_endpoint_navigation: bool
    kevlar_playlist_drag_handles: bool
    kevlar_playlist_use_x_close_button: bool
    kevlar_prefetch: bool
    kevlar_prevent_polymer_dynamic_font_load: bool
    kevlar_refresh_gesture: bool
    kevlar_rendererstamper_event_listener: bool
    kevlar_replace_short_to_short_history_state: bool
    kevlar_request_sequencing: bool
    kevlar_resolve_command_for_confirm_dialog: bool
    kevlar_response_command_processor_page: bool
    kevlar_scroll_chips_on_touch: bool
    kevlar_scrollbar_rework: bool
    kevlar_service_command_check: bool
    kevlar_set_internal_player_size: bool
    kevlar_shell_for_downloads_page: bool
    kevlar_shorts_scroll_v2: bool
    kevlar_shorts_seedless_retry_initial_load: bool
    kevlar_should_maintain_stable_list: bool
    kevlar_show_em_dl_btn: bool
    kevlar_show_em_dl_menu_item: bool
    kevlar_show_em_dl_settings_tab: bool
    kevlar_show_playlist_dl_btn: bool
    kevlar_startup_lifecycle: bool
    kevlar_structured_description_content_inline: bool
    kevlar_system_icons: bool
    kevlar_tabs_gesture: bool
    kevlar_text_inline_expander_formatted_snippet: bool
    kevlar_three_dot_ink: bool
    kevlar_thumbnail_fluid: bool
    kevlar_toast_manager: bool
    kevlar_topbar_logo_fallback_home: bool
    kevlar_touch_feedback: bool
    kevlar_touch_gesture_ves: bool
    kevlar_transcript_engagement_panel: bool
    kevlar_tuner_run_default_comments_delay: bool
    kevlar_tuner_should_defer_detach: bool
    kevlar_typography_spacing_update: bool
    kevlar_typography_update: bool
    kevlar_unified_errors_init: bool
    kevlar_use_response_ttl_to_invalidate_cache: bool
    kevlar_use_vimio_behavior: bool
    kevlar_use_wil_icons: bool
    kevlar_use_ytd_player: bool
    kevlar_variable_youtube_sans: bool
    kevlar_vimio_use_shared_monitor: bool
    kevlar_voice_logging_fix: bool
    kevlar_voice_search_use_yt_endpoint: bool
    kevlar_watch_cinematics: bool
    kevlar_watch_color_update: bool
    kevlar_watch_comments_ep_disable_theater: bool
    kevlar_watch_disable_legacy_metadata_updates: bool
    kevlar_watch_drag_handles: bool
    kevlar_watch_flexy_comments_manager: bool
    kevlar_watch_flexy_miniplayer_manager: bool
    kevlar_watch_flexy_playlist_manager: bool
    kevlar_watch_flexy_theater_manager: bool
    kevlar_watch_flexy_use_controller: bool
    kevlar_watch_focus_on_engagement_panels: bool
    kevlar_watch_gesture_pandown: bool
    kevlar_watch_hide_comments_teaser: bool
    kevlar_watch_hide_comments_while_panel_open: bool
    kevlar_watch_js_panel_height: bool
    kevlar_watch_metadata_refresh: bool
    kevlar_watch_metadata_refresh_attached_subscribe: bool
    kevlar_watch_metadata_refresh_clickable_description: bool
    kevlar_watch_metadata_refresh_compact_view_count: bool
    kevlar_watch_metadata_refresh_description_info_dedicated_line: bool
    kevlar_watch_metadata_refresh_description_inline_expander: bool
    kevlar_watch_metadata_refresh_description_primary_color: bool
    kevlar_watch_metadata_refresh_for_live_killswitch: bool
    kevlar_watch_metadata_refresh_full_width_description: bool
    kevlar_watch_metadata_refresh_left_aligned_video_actions: bool
    kevlar_watch_metadata_refresh_lower_case_video_actions: bool
    kevlar_watch_metadata_refresh_narrower_item_wrap: bool
    kevlar_watch_metadata_refresh_no_old_secondary_data: bool
    kevlar_watch_metadata_refresh_relative_date: bool
    kevlar_watch_metadata_refresh_top_aligned_actions: bool
    kevlar_watch_modern_metapanel: bool
    kevlar_watch_modern_panels: bool
    kevlar_watch_panel_height_matches_player: bool
    kevlar_wiz_player_microformat: bool
    kevlar_woffle: bool
    kevlar_woffle_fallback_image: bool
    kevlar_woffle_log_thumbnail_failure_ve: bool
    kevlar_ytb_live_badges: bool
    killswitch_toggle_button_behavior_resolve_command: bool
    live_chat_channel_activity: bool
    live_chat_emoji_picker_toggle_state: bool
    live_chat_enable_command_handler_resolver_map: bool
    live_chat_enable_controller_extraction: bool
    live_chat_enable_qna_banner_overflow_menu_actions: bool
    live_chat_enable_rta_manager: bool
    live_chat_enable_send_button_in_slow_mode: bool
    live_chat_increased_min_height: bool
    live_chat_over_playlist: bool
    live_chat_require_space_for_autocomplete_emoji: bool
    live_chat_unclickable_message: bool
    live_chat_web_input_update: bool
    live_chat_web_use_emoji_manager_singleton: bool
    live_chat_whole_message_clickable: bool
    log_errors_through_nwl_on_retry: bool
    log_gel_compression_latency: bool
    log_heartbeat_with_lifecycles: bool
    log_vis_on_tab_change: bool
    log_web_endpoint_to_layer: bool
    main_app_controller_extraction_batch_17: bool
    main_app_controller_extraction_batch_18: bool
    main_app_controller_extraction_batch_19: bool
    main_app_sink_wrapper_batch_1: bool
    main_app_sink_wrapper_batch_10: bool
    main_app_sink_wrapper_batch_11: bool
    main_app_sink_wrapper_batch_12: bool
    main_app_sink_wrapper_batch_2: bool
    main_app_sink_wrapper_batch_3: bool
    main_app_sink_wrapper_batch_4: bool
    main_app_sink_wrapper_batch_5: bool
    main_app_sink_wrapper_batch_6: bool
    main_app_sink_wrapper_batch_7: bool
    main_app_sink_wrapper_batch_8: bool
    main_app_sink_wrapper_batch_9: bool
    mdx_enable_privacy_disclosure_ui: bool
    mdx_load_cast_api_bootstrap_script: bool
    migrate_events_to_ts: bool
    migrate_remaining_web_ad_badges_to_innertube: bool
    modernize_structured_description_playlist_lockups_v2: bool
    music_on_main_open_playlist_recommended_videos_in_miniplayer: bool
    mweb_actions_command_handler: bool
    mweb_channels_restyle_buttons_extra_padding: bool
    mweb_channels_restyle_landscape_wider_buttons: bool
    mweb_command_handler: bool
    mweb_deprecate_skip_ve_logging: bool
    mweb_disable_set_autonav_state_in_player: bool
    mweb_enable_search_big_thumbs: bool
    mweb_logo_use_home_page_ve: bool
    mweb_render_crawler_description: bool
    mweb_stop_truncating_meta_tags: bool
    network_status_banner_display_none: bool
    networkless_gel: bool
    networkless_logging: bool
    new_csn_storage_design: bool
    no_iframe_for_web_stickiness: bool
    nwl_send_fast_on_unload: bool
    nwl_send_from_memory_when_online: bool
    offline_error_handling: bool
    pageid_as_header_web: bool
    pause_ad_video_on_desktop_engagement_panel_click: bool
    pdg_enable_flow_logging_for_super_chat: bool
    pdg_enable_flow_logging_for_super_stickers: bool
    player_allow_autonav_after_playlist: bool
    player_bootstrap_method: bool
    player_doubletap_to_seek: bool
    player_enable_playback_playlist_change: bool
    polymer_bad_build_labels: bool
    polymer_task_manager_proxied_promise: bool
    polymer_verifiy_app_state: bool
    polymer_ytdi_enable_global_injector: bool
    problem_walkthrough_sd: bool
    qoe_send_and_write: bool
    read_data_from_web_component_wrapper: bool
    record_app_crashed_web: bool
    reels_enable_livingroom_layout: bool
    reels_web_enable_metadata_container: bool
    reels_web_use_contain_for_first_frame: bool
    reels_web_use_pbs_first_shorts: bool
    register_web_smartimations_component: bool
    reload_without_polymer_innertube: bool
    remove_masthead_channel_banner_on_refresh: bool
    remove_yt_simple_endpoint_from_desktop_display_ad_title: bool
    replace_closure_window_with_updated_ytwindow_in_studio: bool
    rich_grid_resize_observer: bool
    rich_grid_resize_observer_only: bool
    rich_grid_watch_hide_rows_above: bool
    scheduler_use_raf_by_default: bool
    search_ui_enable_pve_buy_button: bool
    search_ui_official_cards_enable_paid_virtual_event_buy_button: bool
    searchbox_reporting: bool
    serve_pdp_at_canonical_url: bool
    service_worker_enabled: bool
    service_worker_push_enabled: bool
    service_worker_push_home_page_prompt: bool
    service_worker_push_watch_page_prompt: bool
    service_worker_subscribe_with_vapid_key: bool
    shared_enable_controller_extraction: bool
    shell_load_gcf: bool
    shorts_controller_retrieve_seedless_sequence: bool
    shorts_desktop_watch_while_p2: bool
    shorts_desktop_watch_while_sdp: bool
    shorts_in_playlists_web: bool
    shorts_overlay_reshuffle: bool
    should_clear_video_data_on_player_cued_unstarted: bool
    skip_invalid_ytcsi_ticks: bool
    skip_ls_gel_retry: bool
    skip_setting_info_in_csi_data_object: bool
    smarter_ve_dedupping: bool
    smartimation_background: bool
    sponsorships_free_creator_gifting: bool
    start_client_gcf: bool
    start_client_gcf_for_player: bool
    start_sending_config_hash: bool
    suppress_error_204_logging: bool
    transport_use_scheduler: bool
    trigger_impression_pings_on_view_search_desktop: bool
    update_log_event_config: bool
    update_ytWindow_library_use_closure_window_library: bool
    use_ads_engagement_panel_desktop_footer_cta: bool
    use_better_post_dismissals: bool
    use_border_and_grid_wrapping_on_desktop_panel_tiles: bool
    use_color_palettes_modern_collections_v2: bool
    use_core_sm: bool
    use_csi_stp_handler: bool
    use_event_time_ms_header: bool
    use_fifo_for_networkless: bool
    use_flow_bottom_bar_view_model_in_flow_step_renderer: bool
    use_infogel_early_logging: bool
    use_new_cml: bool
    use_new_in_memory_storage: bool
    use_new_nwl_initialization: bool
    use_new_nwl_stw: bool
    use_new_nwl_wts: bool
    use_not_now_dl_upsell_dismiss_cta: bool
    use_player_abuse_bg_library: bool
    use_request_time_ms_header: bool
    use_rta_manager_for_async: bool
    use_session_based_sampling: bool
    use_ts_visibilitylogger: bool
    use_unified_flag_accessor: bool
    use_watch_fragments2: bool
    use_ytd_player_for_desktop_masthead: bool
    vss_final_ping_send_and_write: bool
    vss_playback_use_send_and_write: bool
    warm_load_nav_start_web: bool
    warm_op_csn_cleanup: bool
    web_always_load_chat_support: bool
    web_amsterdam_playlists: bool
    web_amsterdam_post_mvp_playlists: bool
    web_animated_actions: bool
    web_animated_like: bool
    web_animated_like_lazy_load: bool
    web_api_url: bool
    web_appshell_purge_trigger: bool
    web_appshell_refresh_trigger: bool
    web_autonav_allow_off_by_default: bool
    web_button_rework: bool
    web_button_rework_with_live: bool
    web_chat_prevent_chat_header_overflow: bool
    web_cinematic_light_theme: bool
    web_collect_offline_state: bool
    web_csi_action_sampling_enabled: bool
    web_csi_debug_sample_enabled: bool
    web_darker_dark_theme: bool
    web_darker_dark_theme_deprecate: bool
    web_darker_dark_theme_live_chat: bool
    web_dedupe_ve_grafting: bool
    web_defer_shorts_ui: bool
    web_defer_shorts_ui_phase2: bool
    web_deprecate_service_ajax_map_dependency: bool
    web_disable_channels_chapter_entrypoint: bool
    web_disable_vertical_scroll_chips: bool
    web_early_logging_time_init: bool
    web_enable_ab_em_rsp: bool
    web_enable_ab_rsp_cl: bool
    web_enable_abd_ref: bool
    web_enable_adaptive_appl_signal: bool
    web_enable_dynamic_metadata: bool
    web_enable_dynamic_suggested_action: bool
    web_enable_error_204: bool
    web_enable_history_cache_map: bool
    web_enable_voz_audio_feedback: bool
    web_enable_youtab: bool
    web_engagement_panel_show_description: bool
    web_fill_shorts_detailed_accessibility: bool
    web_fill_watch_endpoint_in_verify_age: bool
    web_filled_subscribed_button: bool
    web_fix_fine_scrubbing_false_play: bool
    web_forward_command_on_pbj: bool
    web_gel_timeout_cap: bool
    web_guide_entry_role_is_link: bool
    web_guide_ui_refresh: bool
    web_header_eu_about_these_results: bool
    web_hide_autonav_keyline: bool
    web_horizontal_list_focus_bugfix: bool
    web_infocards_teaser_show_logging_fix: bool
    web_inline_player_enabled: bool
    web_kevlar_enable_adaptive_signals: bool
    web_localized_cc_icon: bool
    web_log_memory_total_kbytes: bool
    web_log_player_watch_next_ticks: bool
    web_log_reels_ticks: bool
    web_logging_max_batch_hard_limit: bool
    web_memoize_inflight_requests: bool
    web_modern_ads: bool
    web_modern_buttons: bool
    web_modern_buttons_bl_survey: bool
    web_modern_chips: bool
    web_modern_collections: bool
    web_modern_collections_v2: bool
    web_modern_dialogs: bool
    web_modern_player_settings_quality_bottom: bool
    web_modern_playlists: bool
    web_modern_subscribe: bool
    web_modern_tabs: bool
    web_modern_typography: bool
    web_move_autoplay_video_under_chip: bool
    web_one_platform_error_handling: bool
    web_persist_server_autonav_state_on_client: bool
    web_player_add_ve_conversion_logging_to_outbound_links: bool
    web_player_always_enable_auto_translation: bool
    web_player_autonav_empty_suggestions_fix: bool
    web_player_autonav_next_button_renderer: bool
    web_player_autonav_toggle_always_listen: bool
    web_player_autonav_use_server_provided_state: bool
    web_player_disable_inline_scrubbing: bool
    web_player_enable_cultural_moment_overlay: bool
    web_player_enable_early_warning_snackbar: bool
    web_player_enable_featured_product_banner_exclusives_on_desktop: bool
    web_player_enable_featured_product_banner_price_deals_on_desktop: bool
    web_player_enable_info_button_in_banner_on_desktop: bool
    web_player_enable_open_menu_item_from_command: bool
    web_player_enable_overflow_button_in_banner_on_desktop: bool
    web_player_enable_premium_hbr_in_h5_api: bool
    web_player_enable_premium_hbr_playback_cap: bool
    web_player_enable_vod_featured_product_banner_on_desktop: bool
    web_player_entities_middleware: bool
    web_player_log_click_before_generating_ve_conversion_params: bool
    web_player_move_autonav_toggle: bool
    web_player_should_honor_include_asr_setting: bool
    web_player_small_hbp_settings_menu: bool
    web_player_split_event_bus: bool
    web_player_topify_subtitles_for_shorts: bool
    web_player_touch_mode_improvements: bool
    web_player_use_heartbeat_poll_delay_ms: bool
    web_player_use_new_api_for_quality_pullback: bool
    web_player_ve_conversion_fixes_for_channel_info: bool
    web_prefetch_preload_video: bool
    web_progress_bar_window_mouse_events: bool
    web_prs_testing_mode_killswitch: bool
    web_remember_guide_toggle_state: bool
    web_rendererstamper_event_listener: bool
    web_replace_thumbnail_with_image: bool
    web_resizable_advertiser_banner_on_masthead: bool
    web_resizable_advertiser_banner_on_masthead_safari_fix: bool
    web_rich_shelf_show_less_button: bool
    web_rich_shelf_show_less_button_overlapping_divider: bool
    web_rich_shelf_show_more_button: bool
    web_rich_shelf_show_more_button_overlapping_divider: bool
    web_rounded_thumbnails: bool
    web_scheduler_auto_init: bool
    web_segmented_like_dislike_button: bool
    web_sheets_ui_refresh: bool
    web_shorts_badge_migration: bool
    web_shorts_deflate_inactive_slides_aggressive: bool
    web_shorts_shelf_on_search: bool
    web_shorts_skip_loading_same_index: bool
    web_shorts_suggested_action_no_bvm: bool
    web_shorts_surveys: bool
    web_simple_scriptloader: bool
    web_simple_styleloader: bool
    web_snackbar_ui_refresh: bool
    web_speedmaster_spacebar_control: bool
    web_structured_description_show_more: bool
    web_suggested_actions_backwards_compatible: bool
    web_suggestion_box_bolder: bool
    web_suggestion_box_restyle: bool
    web_supports_animations_api: bool
    web_update_flexible_buttons_after_renderidom: bool
    web_use_cache_for_image_fallback: bool
    web_use_client_imp_controls: bool
    web_vision_pro_detection_killswitch: bool
    web_watch_chips_mask_fade: bool
    web_watch_cinematics_preferred_reduced_motion_default_disabled: bool
    web_watch_log_theater_mode: bool
    web_watch_rounded_player_large: bool
    web_watch_theater_chat: bool
    web_watch_theater_fixed_chat: bool
    web_watch_typography_title_headline_xs: bool
    web_watch_updated_metadata_server_initial_delay: bool
    web_yt_config_context: bool
    webfe_disable_ab_em_plb: bool
    wil_icon_render_when_idle: bool
    wiz_use_generic_logging_infra: bool
    woffle_clean_up_after_entity_migration: bool
    woffle_enable_download_status: bool
    woffle_orchestration: bool
    woffle_playlist_only_show_completed: bool
    woffle_playlist_optimization: bool
    woffle_playlist_visitor_fix: bool
    woffle_used_state_report: bool
    your_data_entrypoint: bool
    yt_network_manager_component_to_lib_killswitch: bool
    ytidb_clear_embedded_player: bool
    ytidb_fetch_datasync_ids_for_data_cleanup: bool
    H5_async_logging_delay_ms: float
    autoplay_pause_by_lact_sampling_fraction: float
    browse_ajax_log_warning_fraction: float
    cinematic_watch_effect_opacity: float
    dynamic_metadata_update_interaction_delay_period_sec: float
    formatted_description_log_warning_fraction: float
    kevlar_tuner_clamp_device_pixel_ratio: float
    kevlar_tuner_thumbnail_factor: float
    kevlar_unified_player_logging_threshold: float
    log_window_onerror_fraction: float
    polymer_property_access_logging_percent: float
    polymer_report_client_url_requested_rate: float
    polymer_report_missing_web_navigation_endpoint_rate: float
    prefetch_coordinator_error_logging_sampling_rate: float
    tv_pacf_logging_sample_rate: float
    web_shorts_error_logging_threshold: float
    web_shorts_intersection_observer_threshold_override: float
    web_system_health_fraction: float
    ytidb_transaction_ended_event_rate_limit: float
    ytidb_transaction_ended_event_rate_limit_session: float
    ytidb_transaction_ended_event_rate_limit_transaction: float
    active_time_update_interval_ms: int
    autoplay_pause_by_lact_sec: int
    autoplay_time: int
    autoplay_time_for_fullscreen: int
    autoplay_time_for_music_content: int
    botguard_async_snapshot_timeout_ms: int
    check_navigator_accuracy_timeout_ms: int
    cinematic_watch_css_filter_blur_strength: int
    cinematic_watch_fade_out_duration: int
    cinematic_watch_transition_frame_rate: int
    client_streamz_web_flush_count: int
    client_streamz_web_flush_interval_seconds: int
    close_webview_delay_ms: int
    cloud_save_game_data_rate_limit_ms: int
    compression_disable_point: int
    desktop_fountain_emoji_size_px: int
    desktop_search_suggestion_tap_target: int
    external_fullscreen_button_click_threshold: int
    external_fullscreen_button_shown_threshold: int
    gel_min_batch_size: int
    gel_queue_timeout_max_ms: int
    get_async_timeout_ms: int
    hide_cta_for_home_web_video_ads_animate_in_time: int
    high_priority_flyout_frequency: int
    initial_gel_batch_timeout: int
    innertube_request_limit_ms: int
    kevlar_lockup_hover_delay: int
    kevlar_mini_guide_width_threshold: int
    kevlar_persistent_guide_width_threshold: int
    kevlar_time_caching_end_threshold: int
    kevlar_time_caching_start_threshold: int
    kevlar_tooltip_impression_cap: int
    kevlar_tuner_default_comments_delay: int
    kevlar_tuner_scheduler_soft_state_timer_ms: int
    kevlar_tuner_visibility_time_between_jobs_ms: int
    kevlar_watch_flexy_metadata_height: int
    kevlar_watch_grid_below_player_value: int
    kevlar_watch_grid_sidebar_min_width: int
    kevlar_watch_max_player_width: int
    kevlar_watch_metadata_refresh_description_lines: int
    kevlar_watch_page_columns_top_padding: int
    kevlar_watch_page_horizontal_margin: int
    kevlar_watch_page_margin: int
    kevlar_watch_player_min_height: int
    kevlar_watch_secondary_width: int
    kevlar_watch_two_column_width_threshold: int
    live_chat_chunk_rendering: int
    live_chat_emoji_picker_restyle_bottom_px: int
    live_chat_emoji_picker_restyle_height_percent: int
    live_chat_emoji_picker_restyle_height_px: int
    live_chat_emoji_picker_restyle_width_px: int
    live_chat_max_chunk_size: int
    live_chat_min_chunk_interval_ms: int
    live_reactions_desktop_fab_relocation_mode: int
    max_body_size_to_compress: int
    max_duration_to_consider_mouseover_as_hover: int
    max_prefetch_window_sec_for_livestream_optimization: int
    min_mouse_still_duration: int
    min_prefetch_offset_sec_for_livestream_optimization: int
    minimum_duration_to_consider_mouseover_as_hover: int
    mweb_history_manager_cache_size: int
    mweb_history_manager_w2w_ttl: int
    network_polling_interval: int
    pbj_navigate_limit: int
    play_click_interval_ms: int
    play_ping_interval_ms: int
    post_type_icons_rearrange: int
    prefetch_comments_ms_after_video: int
    prefetch_coordinator_command_timeout_ms: int
    prefetch_coordinator_max_inflight_requests: int
    rich_grid_max_item_width: int
    rich_grid_min_item_width: int
    send_config_hash_timer: int
    service_worker_push_logged_out_prompt_watches: int
    service_worker_push_prompt_cap: int
    service_worker_push_prompt_delay_microseconds: int
    slow_compressions_before_abandon_count: int
    swatcheroo_rich_grid_delay: int
    user_engagement_experiments_rate_limit_ms: int
    user_mention_suggestions_edu_impression_cap: int
    visibility_time_between_jobs_ms: int
    web_cold_open_animation_initial_delay: int
    web_emulated_idle_callback_delay: int
    web_foreground_heartbeat_interval_ms: int
    web_gel_debounce_ms: int
    web_logging_max_batch: int
    web_player_caption_language_preference_stickiness_duration: int
    web_search_inline_player_triggering_delay: int
    web_shorts_deflate_inactive_slides_aggressive_distance: int
    web_shorts_inline_playback_preview_ms: int
    web_smoothness_test_duration_ms: int
    web_smoothness_test_method: int
    wil_icon_max_concurrent_fetches: int
    wn_grid_max_item_width: int
    wn_grid_min_item_width: int
    yoodle_end_time_utc: int
    yoodle_start_time_utc: int
    ytidb_remake_db_retries: int
    ytidb_reopen_db_retries: int
    WebClientReleaseProcessCritical__youtube_web_client_version_override: str
    asset_caching_http_max_age: str
    comment_input_box_triggering_strategy: str
    debug_forced_internalcountrycode: str
    desktop_search_bigger_thumbs_style: str
    desktop_searchbar_style: str
    embeds_web_synth_ch_headers_banned_urls_regex: str
    il_payload_scraping: str
    kevlar_duplicate_pref_cookie_domain_override: str
    kevlar_link_capturing_mode: str
    live_chat_unicode_emoji_json_url: str
    place_pivot_triggering_container_alternate: str
    polymer_task_manager_status: str
    reels_action_justified_content: str
    reels_metadata_justified_content: str
    reels_navigation_justify_content: str
    search_overview_link_style: str
    service_worker_push_force_notification_prompt_tag: str
    service_worker_scope: str
    web_client_version_override: str
    web_home_feed_reload_experience: str
    web_modern_subscribe_style: str
    web_shorts_expanded_overlay_type: str
    web_shorts_overlay_vertical_orientation: str
    yoodle_base_url: str
    yoodle_webp_base_url: str
    conditional_lab_ids: list[int]
    guide_business_info_countries: list[str]
    guide_legal_footer_enabled_countries: list[str]
    html5_profiler_trace_enums: list
    kevlar_command_handler_command_banlist: list
    kevlar_page_service_url_prefix_carveouts: list
    web_op_signal_type_banlist: list


class GoogleFeedbackProductData(TypedDict):
    polymer: str
    polymer2: str
    accept_language: str


class Configinfo(TypedDict):
    appInstallData: str


class Client(TypedDict):
    hl: str
    gl: str
    remoteHost: str
    deviceMake: str
    deviceModel: str
    visitorData: str
    userAgent: str
    clientName: str
    clientVersion: str
    osName: str
    osVersion: str
    originalUrl: str
    platform: str
    clientFormFactor: str
    configInfo: Configinfo
    timeZone: str
    browserName: str
    browserVersion: str
    acceptHeader: str
    deviceExperimentId: str


class User(TypedDict):
    lockedSafetyMode: bool


class ConsistencytokenjarsItem(TypedDict):
    encryptedTokenJarContents: str


class Request(TypedDict):
    useSsl: bool
    consistencyTokenJars: list[ConsistencytokenjarsItem]


class InnertubeContext(TypedDict):
    client: Client
    user: User
    request: Request
    clickTracking: ClickTrackingParams


LatestEcatcherServiceTrackingParams = TypedDict(
    "LatestEcatcherServiceTrackingParams", {"client.name": "str"}
)


class Scheduler(TypedDict):
    useRaf: bool


class LiveChatBaseTangoConfig(TypedDict):
    apiKey: str
    channelUri: str
    clientName: str
    requiresAuthToken: bool
    senderUri: str
    useNewTango: bool


class ytcfg(TypedDict):
    DELEGATED_SESSION_ID: str
    DEVICE: str
    DISABLE_YT_IMG_DELAY_LOADING: bool
    EVENT_ID: str
    EXPERIMENT_FLAGS: ExperimentFlags
    GAPI_HINT_PARAMS: str
    GAPI_HOST: str
    GAPI_LOCALE: str
    GL: str
    GOOGLE_FEEDBACK_PRODUCT_ID: str
    GOOGLE_FEEDBACK_PRODUCT_DATA: GoogleFeedbackProductData
    HL: str
    HTML_DIR: str
    HTML_LANG: str
    ID_TOKEN: str
    INNERTUBE_API_KEY: str
    INNERTUBE_API_VERSION: str
    INNERTUBE_CLIENT_NAME: str
    INNERTUBE_CLIENT_VERSION: str
    INNERTUBE_CONTEXT: InnertubeContext
    INNERTUBE_CONTEXT_CLIENT_NAME: int
    INNERTUBE_CONTEXT_CLIENT_VERSION: str
    INNERTUBE_CONTEXT_GL: str
    INNERTUBE_CONTEXT_HL: str
    LATEST_ECATCHER_SERVICE_TRACKING_PARAMS: LatestEcatcherServiceTrackingParams
    LOGGED_IN: bool
    PAGE_BUILD_LABEL: str
    PAGE_CL: int
    scheduler: Scheduler
    SERVER_NAME: str
    SESSION_INDEX: str
    VISITOR_DATA: str
    XSRF_FIELD_NAME: str
    XSRF_TOKEN: str
    YPC_MB_URL: str
    YTR_FAMILY_CREATION_URL: str
    SERVER_VERSION: str
    DATASYNC_ID: str
    SERIALIZED_CLIENT_CONFIG_DATA: str
    LIVE_CHAT_BASE_TANGO_CONFIG: LiveChatBaseTangoConfig
    LIVE_CHAT_SEND_MESSAGE_ACTION: str
    CLIENT_PROTOCOL: str
    CLIENT_TRANSPORT: str
    TIME_CREATED_MS: int
    LOGIN_INFO: str
    VALID_SESSION_TEMPDATA_DOMAINS: list[str]
    LIVE_CHAT_ALLOW_DARK_MODE: bool
    POST_TO_PARENT_DOMAIN: str
