"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function validateProps(props) {
    validateRange('delivery delay', props.deliveryDelaySec, 0, 900, 'seconds');
    validateRange('maximum message size', props.maxMessageSizeBytes, 1024, 262144, 'bytes');
    validateRange('message retention period', props.retentionPeriodSec, 60, 1209600, 'seconds');
    validateRange('receive wait time', props.receiveMessageWaitTimeSec, 0, 20, 'seconds');
    validateRange('visibility timeout', props.visibilityTimeoutSec, 0, 43200, 'seconds');
    validateRange('dead letter target maximum receive count', props.deadLetterQueue && props.deadLetterQueue.maxReceiveCount, 1, +Infinity);
}
exports.validateProps = validateProps;
function validateRange(label, value, minValue, maxValue, unit) {
    if (value === undefined) {
        return;
    }
    const unitSuffix = unit ? ` ${unit}` : '';
    if (value < minValue) {
        throw new Error(`${label} must be ${minValue}${unitSuffix} or more, but ${value} was provided`);
    }
    if (value > maxValue) {
        throw new Error(`${label} must be ${maxValue}${unitSuffix} of less, but ${value} was provided`);
    }
}
//# sourceMappingURL=data:application/json;base64,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