"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/cdk");
const sqs = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'sqs-bucket-notifications');
const bucket1 = new s3.Bucket(stack, 'Bucket1', {
    removalPolicy: cdk.RemovalPolicy.Destroy
});
const queue = new sqs.Queue(stack, 'MyQueue');
bucket1.onObjectCreated(queue);
const bucket2 = new s3.Bucket(stack, 'Bucket2', {
    removalPolicy: cdk.RemovalPolicy.Destroy
});
bucket2.onObjectCreated(queue, { suffix: '.png' });
const encryptedQueue = new sqs.Queue(stack, 'EncryptedQueue', { encryption: sqs.QueueEncryption.Kms });
bucket1.onObjectRemoved(encryptedQueue);
app.run();
//# sourceMappingURL=data:application/json;base64,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