"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk_1 = require("@aws-cdk/cdk");
const lib_1 = require("../lib");
const app = new cdk_1.App();
const stack = new cdk_1.Stack(app, 'aws-cdk-sqs');
const dlq = new lib_1.Queue(stack, 'DeadLetterQueue');
const queue = new lib_1.Queue(stack, 'Queue', {
    deadLetterQueue: { queue: dlq, maxReceiveCount: 5 }
});
new lib_1.Queue(stack, 'FifoQueue', {
    fifo: true
});
new cdk_1.CfnOutput(stack, 'QueueUrl', { value: queue.queueUrl });
app.run();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuc3FzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcuc3FzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsc0NBQXFEO0FBQ3JELGdDQUErQjtBQUUvQixNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQUcsRUFBRSxDQUFDO0FBRXRCLE1BQU0sS0FBSyxHQUFHLElBQUksV0FBSyxDQUFDLEdBQUcsRUFBRSxhQUFhLENBQUMsQ0FBQztBQUU1QyxNQUFNLEdBQUcsR0FBRyxJQUFJLFdBQUssQ0FBQyxLQUFLLEVBQUUsaUJBQWlCLENBQUMsQ0FBQztBQUNoRCxNQUFNLEtBQUssR0FBRyxJQUFJLFdBQUssQ0FBQyxLQUFLLEVBQUUsT0FBTyxFQUFFO0lBQ3RDLGVBQWUsRUFBRSxFQUFFLEtBQUssRUFBRSxHQUFHLEVBQUUsZUFBZSxFQUFFLENBQUMsRUFBRTtDQUNwRCxDQUFDLENBQUM7QUFFSCxJQUFJLFdBQUssQ0FBQyxLQUFLLEVBQUUsV0FBVyxFQUFFO0lBQzVCLElBQUksRUFBRSxJQUFJO0NBQ1gsQ0FBQyxDQUFDO0FBRUgsSUFBSSxlQUFTLENBQUMsS0FBSyxFQUFFLFVBQVUsRUFBRSxFQUFFLEtBQUssRUFBRSxLQUFLLENBQUMsUUFBUSxFQUFFLENBQUMsQ0FBQztBQUU1RCxHQUFHLENBQUMsR0FBRyxFQUFFLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBBcHAsIENmbk91dHB1dCwgU3RhY2sgfSBmcm9tICdAYXdzLWNkay9jZGsnO1xuaW1wb3J0IHsgUXVldWUgfSBmcm9tICcuLi9saWInO1xuXG5jb25zdCBhcHAgPSBuZXcgQXBwKCk7XG5cbmNvbnN0IHN0YWNrID0gbmV3IFN0YWNrKGFwcCwgJ2F3cy1jZGstc3FzJyk7XG5cbmNvbnN0IGRscSA9IG5ldyBRdWV1ZShzdGFjaywgJ0RlYWRMZXR0ZXJRdWV1ZScpO1xuY29uc3QgcXVldWUgPSBuZXcgUXVldWUoc3RhY2ssICdRdWV1ZScsIHtcbiAgZGVhZExldHRlclF1ZXVlOiB7IHF1ZXVlOiBkbHEsIG1heFJlY2VpdmVDb3VudDogNSB9XG59KTtcblxubmV3IFF1ZXVlKHN0YWNrLCAnRmlmb1F1ZXVlJywge1xuICBmaWZvOiB0cnVlXG59KTtcblxubmV3IENmbk91dHB1dChzdGFjaywgJ1F1ZXVlVXJsJywgeyB2YWx1ZTogcXVldWUucXVldWVVcmwgfSk7XG5cbmFwcC5ydW4oKTtcbiJdfQ==