"""
AlgoliaSearch integration for Django.
http://www.algolia.com
"""

from . import models
from . import registration
from . import settings
from . import version

__version__ = version.VERSION
ALGOLIA_SETTINGS = settings.SETTINGS

AlgoliaIndex = models.AlgoliaIndex
AlgoliaEngine = registration.AlgoliaEngine
algolia_engine = registration.algolia_engine

# Algolia Engine functions

register = algolia_engine.register
unregister = algolia_engine.unregister
get_registered_model = algolia_engine.get_registered_models

get_adapter = algolia_engine.get_adapter
get_adapter_from_instance = algolia_engine.get_adapter_from_instance

save_record = algolia_engine.save_record
delete_record = algolia_engine.delete_record
update_records = algolia_engine.update_records
raw_search = algolia_engine.raw_search
clear_index = algolia_engine.clear_index
reindex_all = algolia_engine.reindex_all
