# Generated by Django 3.0.9 on 2020-09-15 07:08

import django.core.files.storage
from django.db import migrations, models
import django.db.models.deletion
import django.db.models.manager
import django.utils.timezone
import paper_uploads.models.fields.image
import paper_uploads.models.mixins


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='Permissions',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
            options={
                'permissions': (('upload', 'Can upload files'), ('change', 'Can change files'), ('delete', 'Can delete files')),
                'managed': False,
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='CollectionItemBase',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('collection_id', models.IntegerField()),
                ('item_type', models.CharField(db_index=True, editable=False, max_length=32, verbose_name='type')),
                ('order', models.IntegerField(default=0, editable=False, verbose_name='order')),
                ('collection_content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType')),
                ('polymorphic_ctype', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='polymorphic_paper_uploads.collectionitembase_set+', to='contenttypes.ContentType')),
            ],
            options={
                'verbose_name': 'item',
                'verbose_name_plural': 'items',
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='UploadedFile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('owner_app_label', models.CharField(editable=False, max_length=100)),
                ('owner_model_name', models.CharField(editable=False, max_length=100)),
                ('owner_fieldname', models.CharField(editable=False, max_length=255)),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='created at')),
                ('modified_at', models.DateTimeField(auto_now=True, verbose_name='changed at')),
                ('basename', models.CharField(editable=False, help_text='Human-readable resource name', max_length=255, verbose_name='basename')),
                ('extension', models.CharField(editable=False, help_text='Lowercase, without leading dot', max_length=32, verbose_name='extension')),
                ('size', models.PositiveIntegerField(default=0, editable=False, verbose_name='size')),
                ('checksum', models.CharField(editable=False, max_length=64, verbose_name='checksum')),
                ('uploaded_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='uploaded at')),
                ('file', models.FileField(max_length=255, storage=django.core.files.storage.FileSystemStorage(), upload_to='files/%Y-%m-%d', verbose_name='file')),
                ('display_name', models.CharField(blank=True, max_length=255, verbose_name='display name')),
            ],
            options={
                'verbose_name': 'file',
                'verbose_name_plural': 'files',
                'abstract': False,
                'default_permissions': (),
            },
            bases=(paper_uploads.models.mixins.FileFieldProxyMixin, paper_uploads.models.mixins.FileProxyMixin, models.Model),
        ),
        migrations.CreateModel(
            name='UploadedImage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('owner_app_label', models.CharField(editable=False, max_length=100)),
                ('owner_model_name', models.CharField(editable=False, max_length=100)),
                ('owner_fieldname', models.CharField(editable=False, max_length=255)),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='created at')),
                ('modified_at', models.DateTimeField(auto_now=True, verbose_name='changed at')),
                ('basename', models.CharField(editable=False, help_text='Human-readable resource name', max_length=255, verbose_name='basename')),
                ('extension', models.CharField(editable=False, help_text='Lowercase, without leading dot', max_length=32, verbose_name='extension')),
                ('size', models.PositiveIntegerField(default=0, editable=False, verbose_name='size')),
                ('checksum', models.CharField(editable=False, max_length=64, verbose_name='checksum')),
                ('uploaded_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='uploaded at')),
                ('title', models.CharField(blank=True, help_text='The title is being used as a tooltip when the user hovers the mouse over the image', max_length=255, verbose_name='title')),
                ('description', models.TextField(blank=True, help_text='This text will be used by screen readers, search engines, or when the image cannot be loaded', verbose_name='description')),
                ('width', models.PositiveSmallIntegerField(default=0, editable=False, verbose_name='width')),
                ('height', models.PositiveSmallIntegerField(default=0, editable=False, verbose_name='height')),
                ('cropregion', models.CharField(blank=True, editable=False, max_length=24, verbose_name='crop region')),
                ('file', paper_uploads.models.fields.image.VariationalFileField(max_length=255, storage=django.core.files.storage.FileSystemStorage(), upload_to='images/%Y-%m-%d', verbose_name='file')),
            ],
            options={
                'verbose_name': 'image',
                'verbose_name_plural': 'images',
                'abstract': False,
                'default_permissions': (),
            },
            bases=(paper_uploads.models.mixins.FileFieldProxyMixin, paper_uploads.models.mixins.FileProxyMixin, models.Model),
        ),
        migrations.CreateModel(
            name='FileItem',
            fields=[
                ('collectionitembase_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='paper_uploads.CollectionItemBase')),
                ('owner_app_label', models.CharField(editable=False, max_length=100)),
                ('owner_model_name', models.CharField(editable=False, max_length=100)),
                ('owner_fieldname', models.CharField(editable=False, max_length=255)),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='created at')),
                ('modified_at', models.DateTimeField(auto_now=True, verbose_name='changed at')),
                ('basename', models.CharField(editable=False, help_text='Human-readable resource name', max_length=255, verbose_name='basename')),
                ('extension', models.CharField(editable=False, help_text='Lowercase, without leading dot', max_length=32, verbose_name='extension')),
                ('size', models.PositiveIntegerField(default=0, editable=False, verbose_name='size')),
                ('checksum', models.CharField(editable=False, max_length=64, verbose_name='checksum')),
                ('uploaded_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='uploaded at')),
                ('file', models.FileField(max_length=255, storage=django.core.files.storage.FileSystemStorage(), upload_to='collections/files/%Y-%m-%d', verbose_name='file')),
                ('display_name', models.CharField(blank=True, max_length=255, verbose_name='display name')),
            ],
            options={
                'verbose_name': 'File item',
                'verbose_name_plural': 'File items',
                'abstract': False,
                'base_manager_name': 'objects',
            },
            bases=('paper_uploads.collectionitembase', paper_uploads.models.mixins.FileFieldProxyMixin, paper_uploads.models.mixins.FileProxyMixin, models.Model),
        ),
        migrations.CreateModel(
            name='ImageItem',
            fields=[
                ('collectionitembase_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='paper_uploads.CollectionItemBase')),
                ('owner_app_label', models.CharField(editable=False, max_length=100)),
                ('owner_model_name', models.CharField(editable=False, max_length=100)),
                ('owner_fieldname', models.CharField(editable=False, max_length=255)),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='created at')),
                ('modified_at', models.DateTimeField(auto_now=True, verbose_name='changed at')),
                ('basename', models.CharField(editable=False, help_text='Human-readable resource name', max_length=255, verbose_name='basename')),
                ('extension', models.CharField(editable=False, help_text='Lowercase, without leading dot', max_length=32, verbose_name='extension')),
                ('size', models.PositiveIntegerField(default=0, editable=False, verbose_name='size')),
                ('checksum', models.CharField(editable=False, max_length=64, verbose_name='checksum')),
                ('uploaded_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='uploaded at')),
                ('title', models.CharField(blank=True, help_text='The title is being used as a tooltip when the user hovers the mouse over the image', max_length=255, verbose_name='title')),
                ('description', models.TextField(blank=True, help_text='This text will be used by screen readers, search engines, or when the image cannot be loaded', verbose_name='description')),
                ('width', models.PositiveSmallIntegerField(default=0, editable=False, verbose_name='width')),
                ('height', models.PositiveSmallIntegerField(default=0, editable=False, verbose_name='height')),
                ('cropregion', models.CharField(blank=True, editable=False, max_length=24, verbose_name='crop region')),
                ('file', paper_uploads.models.fields.image.VariationalFileField(max_length=255, storage=django.core.files.storage.FileSystemStorage(), upload_to='collections/images/%Y-%m-%d', verbose_name='file')),
            ],
            options={
                'verbose_name': 'Image item',
                'verbose_name_plural': 'Image items',
                'abstract': False,
                'base_manager_name': 'objects',
            },
            bases=('paper_uploads.collectionitembase', paper_uploads.models.mixins.FileFieldProxyMixin, paper_uploads.models.mixins.FileProxyMixin, models.Model),
        ),
        migrations.CreateModel(
            name='SVGItem',
            fields=[
                ('collectionitembase_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='paper_uploads.CollectionItemBase')),
                ('owner_app_label', models.CharField(editable=False, max_length=100)),
                ('owner_model_name', models.CharField(editable=False, max_length=100)),
                ('owner_fieldname', models.CharField(editable=False, max_length=255)),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='created at')),
                ('modified_at', models.DateTimeField(auto_now=True, verbose_name='changed at')),
                ('basename', models.CharField(editable=False, help_text='Human-readable resource name', max_length=255, verbose_name='basename')),
                ('extension', models.CharField(editable=False, help_text='Lowercase, without leading dot', max_length=32, verbose_name='extension')),
                ('size', models.PositiveIntegerField(default=0, editable=False, verbose_name='size')),
                ('checksum', models.CharField(editable=False, max_length=64, verbose_name='checksum')),
                ('uploaded_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='uploaded at')),
                ('file', models.FileField(max_length=255, storage=django.core.files.storage.FileSystemStorage(), upload_to='collections/files/%Y-%m-%d', verbose_name='file')),
                ('display_name', models.CharField(blank=True, max_length=255, verbose_name='display name')),
            ],
            options={
                'verbose_name': 'SVG item',
                'verbose_name_plural': 'SVG items',
                'abstract': False,
                'base_manager_name': 'objects',
            },
            bases=('paper_uploads.collectionitembase', paper_uploads.models.mixins.FileFieldProxyMixin, paper_uploads.models.mixins.FileProxyMixin, models.Model),
        ),
        migrations.CreateModel(
            name='Collection',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('owner_app_label', models.CharField(editable=False, max_length=100)),
                ('owner_model_name', models.CharField(editable=False, max_length=100)),
                ('owner_fieldname', models.CharField(editable=False, max_length=255)),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='created at')),
                ('collection_content_type', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.SET_NULL, to='contenttypes.ContentType')),
            ],
            options={
                'proxy': False,
                'default_manager_name': 'default_mgr',
            },
            managers=[
                ('default_mgr', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='ImageCollection',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
            },
            bases=('paper_uploads.collection',),
            managers=[
                ('default_mgr', django.db.models.manager.Manager()),
            ],
        ),
    ]
