"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Domain = exports.DomainProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cdn_generated_1 = require("./cdn.generated");
Object.defineProperty(exports, "DomainProperty", { enumerable: true, get: function () { return cdn_generated_1.RosDomain; } });
/**
 * A ROS resource type:  `ALIYUN::CDN::Domain`
 */
class Domain extends ros.Resource {
    /**
     * Create a new `ALIYUN::CDN::Domain`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDomain = new cdn_generated_1.RosDomain(this, id, {
            checkUrl: props.checkUrl,
            resourceGroupId: props.resourceGroupId,
            scope: props.scope,
            domainName: props.domainName,
            cdnType: props.cdnType,
            topLevelDomain: props.topLevelDomain,
            sources: props.sources,
            tags: props.tags,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDomain;
        this.attrCname = rosDomain.attrCname;
        this.attrDomainName = rosDomain.attrDomainName;
    }
}
exports.Domain = Domain;
//# sourceMappingURL=data:application/json;base64,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