import { PolicyDocument } from '@aws-cdk/aws-iam';
import { Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { IQueue } from './queue-base';
/**
 * Properties to associate SQS queues with a policy.
 */
export interface QueuePolicyProps {
    /**
     * The set of queues this policy applies to.
     */
    readonly queues: IQueue[];
}
/**
 * Applies a policy to SQS queues.
 */
export declare class QueuePolicy extends Resource {
    /**
     * The IAM policy document for this policy.
     */
    readonly document: PolicyDocument;
    /**
     *
     */
    constructor(scope: Construct, id: string, props: QueuePolicyProps);
}
