"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserIdentity = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const aws_cognito_identitypool_alpha_1 = require("@aws-cdk/aws-cognito-identitypool-alpha");
const aws_cognito_1 = require("aws-cdk-lib/aws-cognito");
const constructs_1 = require("constructs");
/**
 * Creates an Identity Pool with sane defaults configured.
 */
class UserIdentity extends constructs_1.Construct {
    constructor(scope, id, props) {
        var _b, _c, _d;
        super(scope, id);
        // Unless explicitly stated, created a default Cognito User Pool and Web Client.
        if (!(props === null || props === void 0 ? void 0 : props.userPool)) {
            this.userPool = new aws_cognito_1.UserPool(this, "UserPool");
            this.userPoolClient = this.userPool.addClient("WebClient", {
                authFlows: {
                    userPassword: true,
                    userSrp: true,
                },
            });
        }
        this.identityPool = new aws_cognito_identitypool_alpha_1.IdentityPool(this, "IdentityPool", {
            ...props === null || props === void 0 ? void 0 : props.identityPoolOptions,
            authenticationProviders: {
                ...(_b = props === null || props === void 0 ? void 0 : props.identityPoolOptions) === null || _b === void 0 ? void 0 : _b.authenticationProviders,
                userPools: [
                    ...(((_d = (_c = props === null || props === void 0 ? void 0 : props.identityPoolOptions) === null || _c === void 0 ? void 0 : _c.authenticationProviders) === null || _d === void 0 ? void 0 : _d.userPools) ||
                        []),
                    ...(this.userPool
                        ? [new aws_cognito_identitypool_alpha_1.UserPoolAuthenticationProvider({ userPool: this.userPool })]
                        : []),
                ],
            },
        });
    }
}
exports.UserIdentity = UserIdentity;
_a = JSII_RTTI_SYMBOL_1;
UserIdentity[_a] = { fqn: "@aws-prototyping-sdk/identity.UserIdentity", version: "0.0.80" };
//# sourceMappingURL=data:application/json;base64,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