"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk_1 = require("@aws-cdk/cdk");
const logs_generated_1 = require("./logs.generated");
/**
 * Define a Log Stream in a Log Group
 */
class LogStream extends cdk_1.Resource {
    /**
     * Import an existing LogGroup
     */
    static fromLogStreamName(scope, id, logStreamName) {
        class Import extends cdk_1.Resource {
            constructor() {
                super(...arguments);
                this.logStreamName = logStreamName;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id);
        const resource = new logs_generated_1.CfnLogStream(this, 'Resource', {
            logGroupName: props.logGroup.logGroupName,
            logStreamName: props.logStreamName
        });
        resource.applyRemovalPolicy(props.removalPolicy);
        this.logStreamName = resource.refAsString;
    }
}
exports.LogStream = LogStream;
//# sourceMappingURL=data:application/json;base64,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