"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk_1 = require("@aws-cdk/cdk");
const lib_1 = require("../lib");
const stack = new cdk_1.Stack();
function shortLogGroup() {
    /// !show
    // Configure log group for short retention
    const logGroup = new lib_1.LogGroup(stack, 'LogGroup', {
        retentionDays: lib_1.RetentionDays.OneWeek
    });
    /// !hide
    return logGroup;
}
function infiniteLogGroup() {
    /// !show
    // Configure log group for infinite retention
    const logGroup = new lib_1.LogGroup(stack, 'LogGroup', {
        retentionDays: Infinity
    });
    /// !hide
    return logGroup;
}
//
Array.isArray(shortLogGroup);
Array.isArray(infiniteLogGroup);
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXhhbXBsZS5yZXRlbnRpb24ubGl0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiZXhhbXBsZS5yZXRlbnRpb24ubGl0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsc0NBQXFDO0FBQ3JDLGdDQUFpRDtBQUVqRCxNQUFNLEtBQUssR0FBRyxJQUFJLFdBQUssRUFBRSxDQUFDO0FBRTFCLFNBQVMsYUFBYTtJQUNwQixTQUFTO0lBQ1QsMENBQTBDO0lBQzFDLE1BQU0sUUFBUSxHQUFHLElBQUksY0FBUSxDQUFDLEtBQUssRUFBRSxVQUFVLEVBQUU7UUFDL0MsYUFBYSxFQUFFLG1CQUFhLENBQUMsT0FBTztLQUNyQyxDQUFDLENBQUM7SUFDSCxTQUFTO0lBQ1QsT0FBTyxRQUFRLENBQUM7QUFDbEIsQ0FBQztBQUVELFNBQVMsZ0JBQWdCO0lBQ3ZCLFNBQVM7SUFDVCw2Q0FBNkM7SUFDN0MsTUFBTSxRQUFRLEdBQUcsSUFBSSxjQUFRLENBQUMsS0FBSyxFQUFFLFVBQVUsRUFBRTtRQUMvQyxhQUFhLEVBQUUsUUFBUTtLQUN4QixDQUFDLENBQUM7SUFDSCxTQUFTO0lBQ1QsT0FBTyxRQUFRLENBQUM7QUFDbEIsQ0FBQztBQUVELEVBQUU7QUFFRixLQUFLLENBQUMsT0FBTyxDQUFDLGFBQWEsQ0FBQyxDQUFDO0FBQzdCLEtBQUssQ0FBQyxPQUFPLENBQUMsZ0JBQWdCLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFN0YWNrIH0gZnJvbSAnQGF3cy1jZGsvY2RrJztcbmltcG9ydCB7IExvZ0dyb3VwLCBSZXRlbnRpb25EYXlzIH0gZnJvbSAnLi4vbGliJztcblxuY29uc3Qgc3RhY2sgPSBuZXcgU3RhY2soKTtcblxuZnVuY3Rpb24gc2hvcnRMb2dHcm91cCgpIHtcbiAgLy8vICFzaG93XG4gIC8vIENvbmZpZ3VyZSBsb2cgZ3JvdXAgZm9yIHNob3J0IHJldGVudGlvblxuICBjb25zdCBsb2dHcm91cCA9IG5ldyBMb2dHcm91cChzdGFjaywgJ0xvZ0dyb3VwJywge1xuICAgIHJldGVudGlvbkRheXM6IFJldGVudGlvbkRheXMuT25lV2Vla1xuICB9KTtcbiAgLy8vICFoaWRlXG4gIHJldHVybiBsb2dHcm91cDtcbn1cblxuZnVuY3Rpb24gaW5maW5pdGVMb2dHcm91cCgpIHtcbiAgLy8vICFzaG93XG4gIC8vIENvbmZpZ3VyZSBsb2cgZ3JvdXAgZm9yIGluZmluaXRlIHJldGVudGlvblxuICBjb25zdCBsb2dHcm91cCA9IG5ldyBMb2dHcm91cChzdGFjaywgJ0xvZ0dyb3VwJywge1xuICAgIHJldGVudGlvbkRheXM6IEluZmluaXR5XG4gIH0pO1xuICAvLy8gIWhpZGVcbiAgcmV0dXJuIGxvZ0dyb3VwO1xufVxuXG4vL1xuXG5BcnJheS5pc0FycmF5KHNob3J0TG9nR3JvdXApO1xuQXJyYXkuaXNBcnJheShpbmZpbml0ZUxvZ0dyb3VwKTtcbiJdfQ==